// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Tamil (`ta`).
class AppLocalizationsTa extends AppLocalizations {
  AppLocalizationsTa([String locale = 'ta']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'ஆம்';

  @override
  String get add => 'சேர்';

  @override
  String get account_delete_message =>
      'Are you sure you want to delete your account?\nIf there is a specific reason, please share below';

  @override
  String get reason => 'Reason';

  @override
  String get okay => 'சரி';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'உருவாக்கு';

  @override
  String get applyButtonText => 'பயன்படுத்து';

  @override
  String get next_label => 'Next';

  @override
  String get continue_label => 'Continue';

  @override
  String get exit_label => 'வெளியேறு';

  @override
  String get previous_label => 'Previous';

  @override
  String get go_back_to_top => 'மீண்டும் மேலே செல்';

  @override
  String get save => 'சேமி';

  @override
  String get save_confirmation => 'நிச்சயமாக சேமிக்க விரும்புகிறீர்களா?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Cancel';

  @override
  String get ignore => 'விட்டுவிடு';

  @override
  String get close => 'மூடுக‌';

  @override
  String get no => 'இல்லை';

  @override
  String get stop => 'நிறுத்து';

  @override
  String get finish => 'Finish';

  @override
  String get calculate => 'Calculate';

  @override
  String get reset_food_prefs => 'உணவு விருப்பங்களை மீட்டமைக்கவும்';

  @override
  String get error => 'எதிர் பாராத பிழை ஏற்பட்டு விட்டது';

  @override
  String get error_occurred => 'ஒரு பிழை ஏற்பட்டது';

  @override
  String get featureInProgress =>
      'இந்த வடிவத்தில் நாங்கள் இன்னும் பணியாற்றி வருகிறோம், காத்திருங்கள்.\n';

  @override
  String get label_web => 'வலையில் பார்க்கவும்';

  @override
  String get learnMore => 'மேலும்அறிய';

  @override
  String get unknown => 'Unknown';

  @override
  String get match_very_good => 'Very good match';

  @override
  String get match_good => 'Good match';

  @override
  String get match_poor => 'Poor match';

  @override
  String get match_may_not => 'May not match';

  @override
  String get match_does_not => 'Does not match';

  @override
  String get match_unknown => 'Unknown match';

  @override
  String get match_short_very_good => 'Very good match';

  @override
  String get match_short_good => 'Good match';

  @override
  String get match_short_poor => 'Poor match';

  @override
  String get match_short_may_not => 'May not match';

  @override
  String get match_short_does_not => 'Does not match';

  @override
  String get match_short_unknown => 'Unknown match';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => 'Looking for';

  @override
  String get welcomeToOpenFoodFacts => 'Welcome to Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts is a global non-profit powered by local communities.';

  @override
  String get productDataUtility =>
      'See the food data relevant to your preferences.';

  @override
  String get healthCardUtility => 'Choose foods that are good for you.';

  @override
  String get ecoCardUtility => 'Choose foods that are good for the planet.';

  @override
  String get server_error_open_new_issue =>
      'No server response! You may open an issue with the following link.';

  @override
  String get sign_in_text =>
      'Sign in to your Open Food Facts account to save your contributions';

  @override
  String get incorrect_credentials => 'Incorrect username or password.';

  @override
  String get password_lost_incorrect_credentials =>
      'This email or username doesn\'t exist. Please check your credentials.';

  @override
  String get password_lost_server_unavailable =>
      'We are currently experiencing slowdowns on our servers and we apologise for it. Please try again later.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable => 'Network is unreachable';

  @override
  String get login_result_type_server_issue =>
      'Problem on the server. Please try later.';

  @override
  String get login_page_username_or_email => 'Please enter username or e-mail';

  @override
  String get login_page_password_error_empty => 'Please enter a password';

  @override
  String get create_account => 'Create account';

  @override
  String get sign_in => 'உள்நுழை';

  @override
  String get sign_in_mandatory => 'For that feature we need you to sign in.';

  @override
  String get help_improve_country =>
      'உங்கள் நாட்டில் Open Food Facts உண்மைகளை மேம்படுத்த உதவுங்கள்.';

  @override
  String get sign_out => 'Sign out';

  @override
  String get sign_out_confirmation => 'Are you sure you want to sign out?';

  @override
  String get password => 'கடவுச்சொல்';

  @override
  String get forgot_password => 'Forgot password';

  @override
  String get forgot_password_question => 'கடவுச்சொல்லை மறந்துவிட்டீர்களா?';

  @override
  String get view_profile => 'View profile';

  @override
  String get reset_password => 'Reset password';

  @override
  String get reset_password_explanation_text =>
      'In case of a forgotten password, enter your username or e-mail address to receive instructions for a password reset. Also, remember to check the Spam folder.';

  @override
  String get username_or_email => 'Username or e-mail';

  @override
  String get reset_password_done =>
      'An e-mail with a link to reset your password has been sent to the e-mail address associated with your account. Also check your spam';

  @override
  String get send_reset_password_mail => 'Change password';

  @override
  String get enter_some_text => 'Please enter some text';

  @override
  String get sign_up_page_title => 'Sign Up';

  @override
  String get sign_up_page_action_button => 'Sign Up';

  @override
  String get sign_up_page_action_doing_it => 'Signing up…';

  @override
  String get sign_up_page_action_ok =>
      'Congratulations! Your account has just been created.';

  @override
  String get sign_up_page_display_name_hint => 'Name';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Please enter the display name you want to use';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mail is required';

  @override
  String get sign_up_page_email_error_invalid => 'Invalid e-mail';

  @override
  String get sign_up_page_username_hint => 'Username: Publicly visible';

  @override
  String get sign_up_page_username_error_empty => 'Please enter a username';

  @override
  String get sign_up_page_username_error_invalid =>
      'Please enter a valid username';

  @override
  String get sign_up_page_username_description =>
      'Username cannot contains spaces, caps or special characters.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Username cannot exceed $value characters';
  }

  @override
  String get sign_up_page_password_hint => 'கடவுச்சொல்';

  @override
  String get sign_up_page_password_error_empty => 'Please enter a password';

  @override
  String get sign_up_page_password_error_invalid =>
      'Please enter a valid password (at least 6 characters)';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirm Password';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Please confirm the password';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Passwords don\'t match';

  @override
  String get sign_up_page_agree_text => 'I agree to the Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'terms of use and contribution';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'When creating an account, agreeing to the Terms of Use is mandatory, however, anonymous contributions can still be made through the app';

  @override
  String get sign_up_page_producer_checkbox => 'I am a food producer';

  @override
  String get sign_up_page_producer_hint => 'Producer/brand';

  @override
  String get sign_up_page_producer_error_empty =>
      'Please enter a producer or a brand name';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'I\'d like to subscribe to the Open Food Facts newsletter (You can unsubscribe from it at any time)';

  @override
  String get sign_up_page_user_name_already_used =>
      'The user name already exists, please choose another username.';

  @override
  String get sign_up_page_email_already_exists =>
      'already exists, login to the account or try with another email.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Please provide a valid email address.';

  @override
  String get sign_up_page_server_busy =>
      'We are deeply sorry, we have some technical difficulties to create your account. Please try again later.';

  @override
  String get settingsTitle => 'அமைப்புகள்';

  @override
  String get darkmode => 'Theme';

  @override
  String get darkmode_dark => 'Dark';

  @override
  String get darkmode_light => 'Light';

  @override
  String get darkmode_system_default => 'System default';

  @override
  String get thanks_for_contributing => 'Thanks for contributing!';

  @override
  String get contributors_label => 'They are building the app';

  @override
  String get contributors_dialog_title => 'Contributors';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Contributor: $name';
  }

  @override
  String get contributors_description =>
      'A list of all contributors of this app';

  @override
  String get support => 'Support';

  @override
  String get support_join_slack => 'Ask for help in our Slack channel';

  @override
  String get support_via_forum => 'உதவிக்கு எங்கள் மன்றத்தை நாடவும்';

  @override
  String get support_via_email => 'Send us an e-mail';

  @override
  String get support_via_email_include_logs_dialog_title => 'Send app logs?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Do you wish to include application logs in attachment to your email?';

  @override
  String get termsOfUse => 'Terms of use';

  @override
  String get legalNotices => 'சட்ட அறிவிப்புகள்';

  @override
  String get privacy_policy => 'Privacy policy';

  @override
  String get about_this_app => 'About this app';

  @override
  String get contribute => 'Contribute';

  @override
  String get contribute_sw_development => 'Software development';

  @override
  String get contribute_develop_text =>
      'The code for every Open Food Facts product is available on GitHub. You are welcome to reuse the code (it\'s open source) and help us improve it, for everyone, on all the planet.';

  @override
  String get contribute_develop_text_2 =>
      'You can join the Open Food Facts Slack chatroom which is the preferred way to ask questions.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV Mode?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Activate the DEV Mode';

  @override
  String get contribute_donate_title => 'நன்கொடை';

  @override
  String get contribute_donate_header => 'Donate to Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Please acknowledge that with the internal alpha version, complete loss of data is possible, and the app may become unusable at any time !';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Products to be completed';

  @override
  String get contribute_improve_header => 'Improving';

  @override
  String get contribute_improve_text =>
      'The database is the core of the project. It\'s easy and very quick to help. You can download the mobile app for your phone, and start adding or improving products.\n\nOn the other hand, Open Food Facts website offers many ways to contribute: ';

  @override
  String get contribute_translate_header => 'Translate';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Start Translating';

  @override
  String get contribute_translate_text =>
      'Open Food Facts is a global project, containing products from more than 160 countries. Open Food Facts is translated into dozens of languages, with constantly evolving content.';

  @override
  String get contribute_translate_text_2 =>
      'Translations is one of the key tasks of the project';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'Share Open Food Facts with your friends';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribute prices by requesting a GDPR export of your loyalty cards data';

  @override
  String get tap_to_answer => 'Tap here to answer questions';

  @override
  String get tap_to_answer_hint =>
      'இந்தத் தயாரிப்புபற்றிய கேள்விகளுக்குப் பதிலளிக்க இங்கே தட்டவும்';

  @override
  String get robotoff_questions_loading_hint =>
      'இந்தத் தயாரிப்புபற்றிய கேள்விகள் ஏற்றப்படும் வரை காத்திருக்கவும்';

  @override
  String get saving_answer => 'Saving your answer';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Sign in to your Open Food Facts account to get credit for your contributions';

  @override
  String get question_yes_button_accessibility_value => 'Answer with yes';

  @override
  String get question_no_button_accessibility_value => 'Answer with no';

  @override
  String get question_skip_button_accessibility_value => 'Skip this question';

  @override
  String get tap_to_edit_search => 'Tap to edit search';

  @override
  String get myPreferences => 'My preferences';

  @override
  String get account_create_message =>
      'Create your account and join the Open Food Facts community to help build food knowledge all over the world!';

  @override
  String get join_us => 'Join us';

  @override
  String get myPreferences_profile_title => 'Your Profile';

  @override
  String get myPreferences_profile_subtitle =>
      'Manage your Open Food Facts contributor account.';

  @override
  String get myPreferences_settings_title => 'App Settings';

  @override
  String get myPreferences_settings_subtitle => 'இருண்ட பயன்முறை, மொழிகள்…';

  @override
  String get myPreferences_food_title => 'Food Preferences';

  @override
  String get myPreferences_food_subtitle =>
      'Choose what information about food matters most to you.';

  @override
  String get myPreferences_food_comment =>
      'Choose what information about food matters most to you, in order to rank food according to your preferences, see the information you care about first, and get a compatibility summary. Those food preferences stay on your device, and are not associated with your Open Food Facts contributor account if you have one.';

  @override
  String get confirmResetPreferences => 'Reset your food preferences?';

  @override
  String get myPersonalizedRanking => 'My personalized ranking';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'A great match for you';

  @override
  String get ranking_subtitle_match_no => 'Very poor match';

  @override
  String get ranking_subtitle_match_maybe => 'Unknown match';

  @override
  String get refresh_with_new_preferences =>
      'Refresh the list with your new preferences';

  @override
  String get reloaded_with_new_preferences =>
      'Reloaded with your new preferences';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'ஸ்கேன்';

  @override
  String get history_navbar_label => 'வரலாறு';

  @override
  String get list_navbar_label => 'Lists';

  @override
  String get category => 'Filter by category';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(category search)';

  @override
  String get filter => 'Filter';

  @override
  String get scan => 'Products from the Scan screen';

  @override
  String get scan_history => 'வரலாற்றை ஸ்கேன் செய்யவும்';

  @override
  String get search => 'தேடுக';

  @override
  String get search_product_help =>
      'ஒரு தயாரிப்பைத் தேடுங்கள்,\nஒரு பிராண்ட் அல்லது பார்கோடைத் தேடுங்கள்';

  @override
  String get search_filter => 'தேடல் வடிகட்டி';

  @override
  String get search_history => 'தேடல் வரலாறு';

  @override
  String get search_store => 'ஒரு கடையைத் தேடுங்கள்';

  @override
  String get search_store_help =>
      'குறிப்பு: நகரம் அல்லது நாட்டைச் சேர்க்கவும்.';

  @override
  String get tap_for_more => 'Tap to see more info…';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'Unknown brand';

  @override
  String get unknownProductName => 'Unknown product name';

  @override
  String get label_refresh => 'Refresh';

  @override
  String get label_reload => 'மீண்டும் ஏற்றவும்';

  @override
  String get image => 'Image';

  @override
  String get front_photo => 'Front photo';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (this image may be outdated)';
  }

  @override
  String get outdated_image_short_label => 'காலாவதியாக இருக்கலாம்';

  @override
  String get ingredients => 'Ingredients';

  @override
  String get ingredients_editing_instructions =>
      'அசல் ஆர்டரை வைத்திருங்கள். குறிப்பிடப்படும்போது சதவீதத்தைக் குறிக்கவும். காற்புள்ளி அல்லது ஹைபனுடன் பிரித்து, மூலப்பொருளின் பொருட்களுக்கு அடைப்புக்குறிகளைப் பயன்படுத்தவும்.';

  @override
  String get ingredients_editing_error => 'Failed to save the ingredients.';

  @override
  String get ingredients_editing_image_error =>
      'Failed to get a new ingredients image.';

  @override
  String get ingredients_editing_title => 'Edit Ingredients';

  @override
  String get ingredients_photo => 'Ingredients photo';

  @override
  String get packaging_editing_instructions =>
      'List all packaging parts separated by a comma or line feed, with their amount (e.g. 1 or 6) type (e.g. bottle, box, can), material (e.g. plastic, metal, aluminium) and if available their size (e.g. 33cl) and recycling instructions.\nExample: 1 glass bottle to recycle, 1 plastic cork to throw away';

  @override
  String get packaging_editing_error => 'Failed to save the packaging.';

  @override
  String get packaging_editing_image_error =>
      'Failed to get a new packaging image.';

  @override
  String get packaging_editing_title => 'Edit Packaging';

  @override
  String get nutrition => 'ஊட்டச்சத்து';

  @override
  String get nutrition_facts_photo => 'Nutrition facts photo';

  @override
  String get nutrition_facts_editing_title =>
      'ஊட்டச்சத்து உண்மைகளைத் திருத்தவும்';

  @override
  String get packaging_information => 'Packaging information';

  @override
  String get packaging_information_photo => 'Packaging information photo';

  @override
  String get missing_product => 'You found a new product!';

  @override
  String get add_product_take_photos =>
      'Take photos of the packaging to add this product to Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Please take some photos first. You may always complete the product at a later time.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'New Product';

  @override
  String get new_product_found_title => 'புதிய தயாரிப்பு கிடைத்தது!';

  @override
  String get new_product_found_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get new_product_found_button => 'Add this product';

  @override
  String get new_product_leave_title => 'Leave this page?';

  @override
  String get new_product_leave_message =>
      'It looks like you didn\'t input anything. Do you really want to leave this page?';

  @override
  String get new_product_dialog_description =>
      'Please take photos of the packaging to add this product to our common database';

  @override
  String get new_product_dialog_illustration_description =>
      'An illustration with unknown Nutri-Score and Green Score';

  @override
  String get front_packaging_photo_button_label => 'Front packaging photo';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirm upload of Front packaging photo';

  @override
  String get confirm_button_label => 'Confirm';

  @override
  String get send_image_button_label => 'Send image';

  @override
  String get crop_page_action_saving => 'Saving the image…';

  @override
  String get crop_page_action_cropping => 'Cropping the image…';

  @override
  String get crop_page_action_local => 'Saving a local version…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oops… there\'s something with your photo!';

  @override
  String get crop_page_action_local_failed_message =>
      'We are unable to process the image locally, before sending it to our server. Please try again later or contact-us if the issue persists.';

  @override
  String get crop_page_action_retake => 'மீண்டும் ஒரு புகைப்படம் எடுக்கவும்';

  @override
  String get crop_page_too_small_image_title => 'The image is too small!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'The minimum size in pixels for picture upload is ${expectedMinWidth}x$expectedMinHeight. The current picture is ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Preparing a call to the server…';

  @override
  String get front_packaging_photo_title => 'Front Packaging Photo';

  @override
  String get ingredients_photo_title => 'Ingredients Photo';

  @override
  String get nutritional_facts_photo_title => 'Nutrition Facts Photo';

  @override
  String get recycling_photo_title => 'Recycling Photo';

  @override
  String get take_photo_title => 'ஒரு படம் எடு';

  @override
  String get take_more_photo_title => 'Take more photos';

  @override
  String get front_photo_uploaded => 'Front photo uploaded';

  @override
  String get ingredients_photo_button_label => 'Ingredients photo';

  @override
  String get ingredients_photo_uploaded => 'Ingredients photo uploaded';

  @override
  String get nutrition_cache_loading_error =>
      'Unable to load nutrients from cache';

  @override
  String get nutritional_facts_photo_button_label => 'Nutrition facts photo';

  @override
  String get nutritional_facts_input_button_label => 'Fill nutrition facts';

  @override
  String get nutritional_facts_added => 'Nutrition facts added';

  @override
  String get categories_added => 'Categories added';

  @override
  String get new_product_title_nutriscore => 'நியூட்ரி-ஸ்கோரைக் கணக்கிடுங்கள்';

  @override
  String get new_product_subtitle_nutriscore =>
      'உணவு வகை மற்றும் ஊட்டச்சத்து மதிப்புகளை நிரப்புவதன் மூலம் அதைப் பெறுங்கள்';

  @override
  String get new_product_title_environmental_score => 'Compute the Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Get it by filling at least a category';

  @override
  String get new_product_additional_environmental_score =>
      'Make Green Score computation more precise with origins, packaging & more';

  @override
  String get new_product_title_nova =>
      'Compute the food processing level (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Get it by filling the food category and ingredients';

  @override
  String get new_product_desc_nova_unknown => 'Food processing level unknown';

  @override
  String get new_product_title_pictures => 'New product';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'And some basic data…';

  @override
  String new_product_done_msg(String username) {
    return 'Thanks for your contribution “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Thanks for your contribution!';

  @override
  String get new_product_done_button_label => 'Discover the completed product';

  @override
  String get hey_incomplete_product_message =>
      'Tap to answer 3 questions NOW to compute Nutri-Score, Green Score & Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Tap now to answer 2 questions to help analyze this cosmetic!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Tap now to answer 3 questions to help analyze this pet food product!';

  @override
  String get hey_incomplete_product_message_product =>
      'Tap now to help complete this product!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Nutrition facts photo uploaded';

  @override
  String get recycling_photo_button_label => 'Recycling photo';

  @override
  String get recycling_photo_uploaded => 'Recycling photo uploaded';

  @override
  String get take_more_photo_button_label => 'Take more photos';

  @override
  String get other_photo_uploaded => 'Miscellaneous photo uploaded';

  @override
  String get retake_photo_button_label => 'Retake';

  @override
  String get selecting_photo => 'Selecting photo';

  @override
  String get uploading_image => 'Uploading photo to the server';

  @override
  String get uploading_image_type_front =>
      'Uploading front image to Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Uploading ingredients image to Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Uploading nutrition image to Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Uploading packaging image to Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Uploading other image to Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Uploading image to Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Add missing ingredients';

  @override
  String get score_add_missing_packaging_image => 'Add missing packaging image';

  @override
  String get score_add_missing_nutrition_facts => 'Add missing nutrition facts';

  @override
  String get score_add_missing_product_traces => 'Add missing product traces';

  @override
  String get score_add_missing_product_category => 'Select a category';

  @override
  String get score_add_missing_precise_product_category =>
      'மிகவும் துல்லியமான வகையைத் தேர்ந்தெடுக்கவும்.';

  @override
  String get score_add_missing_product_countries =>
      'Add missing product countries';

  @override
  String get score_add_missing_product_emb =>
      'Add missing product traceability codes';

  @override
  String get score_add_missing_product_labels => 'Add missing product labels';

  @override
  String get score_add_missing_product_origins => 'Add missing product origins';

  @override
  String get score_add_missing_product_stores => 'Add missing product stores';

  @override
  String get score_add_missing_product_brands => 'Add missing product brands';

  @override
  String get score_update_nutrition_facts => 'Update nutrition facts';

  @override
  String get nutrition_page_title => 'ஊட்டச்சத்து தகவல்கள்';

  @override
  String get nutrition_page_nutritional_info_title => 'ஊட்டச்சத்துத் தகவல்';

  @override
  String get nutrition_page_nutritional_info_label =>
      'தயாரிப்பில் குறிப்பிடப்பட்ட மதிப்புகள்:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'ஆம்';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'இல்லை';

  @override
  String get nutrition_page_nutritional_info_open_photo =>
      'படத்தைத் திறக்கவும்';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Good practices: Nutritional information';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Sometimes nutrition facts are **not specified on the packaging** or on a document given with the product. In this case, and only in this case, you can set the value to **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'ஊட்டச்சத்து மதிப்புகள்:';

  @override
  String get nutrition_page_per_100g => 'per 100g';

  @override
  String get nutrition_page_per_100g_100ml => '100 கிராம்/மிலிக்கு';

  @override
  String get nutrition_page_per_serving => 'per serving';

  @override
  String get nutrition_page_add_nutrient => 'Add a nutrient';

  @override
  String get nutrition_page_serving_size => 'Serving size';

  @override
  String get nutrition_page_serving_size_hint =>
      'பரிமாறும் அளவை உள்ளிடவும் (எ. கா: 100 கிராம்)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Good practices: Serving size';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'This value helps to **make a proportional calculation of each nutrient per serving size**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Allowed units** are: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** or **60 G** (prefer the first one)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** or **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Invalid unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Invalid units';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **candies** and 2 **biscuits**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Missing unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Invalid number';

  @override
  String get nutrition_page_update_running =>
      'Updating the product on the server…';

  @override
  String get nutrition_page_update_done => 'Product updated!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Use the product quantity as serving size';

  @override
  String get nutrition_page_photo_error => 'புகைப்படத்தை ஏற்ற முடியவில்லை';

  @override
  String get more_photos => 'More interesting photos';

  @override
  String get view_more_photo_button =>
      'View all existing photos for this product';

  @override
  String get no_product_found => 'No product found';

  @override
  String get no_location_found => 'No location found';

  @override
  String get not_found => 'not found:';

  @override
  String get refreshing_product => 'Refreshing product';

  @override
  String get product_refreshed => 'Product refreshed';

  @override
  String product_image_accessibility_label(String date) {
    return 'படம் எடுக்கப்பட்ட$date அன்று';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Image taken on $date. This image may be outdated';
  }

  @override
  String get product_image_outdated => 'This image may be outdated';

  @override
  String get product_image_outdated_explanations_title =>
      'This image may be outdated';

  @override
  String get product_image_outdated_explanations_content =>
      'This image was taken more than a year ago.\n**Please check that\'s it\'s still up-to-date**.\n\nThis is **just a warning**. If the content is still the same, you can ignore this message.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Replace photo ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Add a photo ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'ஒரு படம் எடு';

  @override
  String get product_image_action_from_gallery =>
      'Select from your phone\'s gallery';

  @override
  String get product_image_action_choose_existing_photo =>
      'Select from the product photos';

  @override
  String get product_image_details_label => 'புகைப்படம் பற்றிய தகவல்';

  @override
  String get product_image_details_from_producer => 'தயாரிப்பாளரிடமிருந்து';

  @override
  String get product_image_details_contributor => 'Contributor';

  @override
  String get product_image_details_contributor_producer =>
      'பங்களிப்பாளர் (தயாரிப்பாளர்)';

  @override
  String get product_image_details_date => 'Date';

  @override
  String get product_image_details_date_unknown => 'Unknown';

  @override
  String get homepage_main_card_logo_description =>
      'Welcome to Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scan** a barcode or\n**search** for a product';

  @override
  String get homepage_main_card_search_field_hint => 'Search for a product';

  @override
  String get homepage_main_card_search_field_tooltip => 'Start search';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Latest news: $news_title';
  }

  @override
  String get tagline_app_review => 'Do you like the app?';

  @override
  String get tagline_app_review_button_positive => 'I love it! 😍';

  @override
  String get tagline_app_review_button_negative => 'Not really…';

  @override
  String get tagline_app_review_button_later => 'Ask me later';

  @override
  String get tagline_feed_news_button => 'Know more';

  @override
  String get app_review_negative_modal_title => 'You don\'t like our app?';

  @override
  String get app_review_negative_modal_text =>
      'Could you take a few seconds to tell us why?';

  @override
  String get app_review_negative_modal_positive_button => 'Yes, absolutely!';

  @override
  String get app_review_negative_modal_negative_button => 'இல்லை';

  @override
  String get could_not_refresh => 'Could not refresh product';

  @override
  String get product_internet_error_modal_title => 'An error has occurred!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'We are unable to fetch information about this product due to a network error. Please check your internet connection and try again.\n\nInternal error:\n$error';
  }

  @override
  String get product_tags_title => 'Product properties';

  @override
  String get no_product_tags_found_message =>
      'தயாரிப்புப் பண்புகள் இல்லை. தயாரிப்புகளை மேலும் விவரங்களில், நெகிழ்வான முறையில் விவரிக்கப் பண்புகலைப் பயன்படுத்தப்படலாம்.';

  @override
  String get product_tags_empty => 'சொத்துக்கள் இல்லை';

  @override
  String get product_tags_explanation =>
      'ஒரு பொருளுக்கு பண்புகளை (திறவுகோல்/மதிப்பு) சேர்ப்பதன் மூலம், நீங்கள் அதை வளப்படுத்த உதவுகிறீர்கள்.';

  @override
  String get add_tag => 'ஒரு குணத்தைச் சேர்க்கவும்';

  @override
  String get add_tags => 'பண்புகளைச் சேர்க்கவும்';

  @override
  String get add_edit_tags => 'பண்புகளைச் சேர்க்கவும் அல்லது திருத்தவும்';

  @override
  String get edit_tag => 'Edit property';

  @override
  String get remove_tag => 'Remove property';

  @override
  String get tag_key => 'Property';

  @override
  String get tag_keys => 'பண்புகள்';

  @override
  String get tag_key_uneditable => 'குணம் (திருத்த முடியாதது)';

  @override
  String get tag_key_input_hint => 'ஒரு குணத்தை உள்ளிடவும்';

  @override
  String get tag_value => 'Value';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'ஒரு மதிப்பை உள்ளிடவும்';

  @override
  String get tag_key_item => 'குணம்:';

  @override
  String get tag_value_item => 'மதிப்பு:';

  @override
  String get tag_key_explanations =>
      'ஒரு சாவி சிறிய எழுத்தாகவும் இடைவெளிகள் இல்லாமலும் இருக்க வேண்டும்.';

  @override
  String tag_key_already_exists(String property) {
    return 'குணம் $property உடன் ஒரு குறிச்சொல் ஏற்கனவே உள்ளது!';
  }

  @override
  String get product_internet_error =>
      'Impossible to fetch information about this product due to a network error.';

  @override
  String get cached_results_from => 'Show results from:';

  @override
  String get product_search_same_category => 'மாற்று வழிகளைக் கண்டறியவும்';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'This feature can only be used for products with a category.\n\nPlease edit the product to add a category.';

  @override
  String get product_improvement_add_category =>
      'Add a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Add nutrition facts to calculate the Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Add nutrition facts and a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'The Nutri-Score for this product can\'t be calculated, which may be due to e.g. a non-standard category. If this is considered an error, please contact us.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'The nutrition image is obsolete: please refresh it.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'The Green Score takes into account the origins of the ingredients. Please take a photo of the ingredient list and/or any geographic claim or edit the product, so they can be taken into account.';

  @override
  String get country_chooser_label => 'Please choose a country';

  @override
  String get currency_chooser_label => 'நாணயத்தைத் தேர்வு செய்யவும்';

  @override
  String get country_change_message =>
      'நீங்கள் இப்போதுதான் நாடுகளை மாற்றி இருக்கிறீர்கள்.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'உங்களின் முந்தைய நாணயத்திலிருந்து $previousCurrency சாத்தியமான நாணயத்திற்கு $possibleCurrency மாற்ற விரும்புகிறீர்களா?';
  }

  @override
  String get onboarding_country_chooser_label => 'Please choose a country:';

  @override
  String get country_chooser_label_from_settings => 'Your country';

  @override
  String get country_selection_explanation =>
      'Some environmental features are location-specific';

  @override
  String get product_removed_comparison => 'Product removed from comparison';

  @override
  String get native_app_settings => 'Native App Settings';

  @override
  String get native_app_description =>
      'Open systems settings for Open Food Facts';

  @override
  String get product_removed_history => 'Product removed from history';

  @override
  String get product_removed_list => 'Product removed from list';

  @override
  String get product_could_not_remove => 'Could not remove product';

  @override
  String get no_prodcut_in_list => 'There is no product in this list';

  @override
  String get no_product_in_section => 'There is no product in this section';

  @override
  String get recently_seen_products => 'All viewed products';

  @override
  String get clear => 'Clear';

  @override
  String get clear_long => 'Empty the list';

  @override
  String get really_clear => 'Do you really want to delete this list?';

  @override
  String pct_match(Object percent) {
    return '$percent% match';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count days ago',
      one: 'one day ago',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hours ago',
      one: 'one hour ago',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minutes ago',
      one: 'one minute ago',
      zero: 'less than a minute ago',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count months ago',
      one: 'one month ago',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count weeks ago',
      one: 'one week ago',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Compare $count Products',
      one: 'Compare one Product',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count selected products',
      one: 'One selected product',
      zero: 'No selected product',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Compare selected products';

  @override
  String get delete_products_mode => 'Delete selected products';

  @override
  String get select_all_products_mode => 'Select all products';

  @override
  String get select_none_products_mode => 'Select none';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle =>
      'Please select at least two products';

  @override
  String get retry_button_label => 'மீண்டும் முயல்க';

  @override
  String get connect_with_us => 'Connect with us';

  @override
  String get tiktok => 'Follow us on TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Follow us on Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Follow us on X (formerly Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Follow us on Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Follow us on BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Discover';

  @override
  String get how_to_contribute => 'How to Contribute';

  @override
  String get hint_knowledge_panel_message =>
      'Your can tap on any part of the card to get more details about what you see. Try it now!';

  @override
  String get permissions_page_title => 'Camera access';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'If you change your mind, this option can be enabled and disabled at any time from the settings.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Release: $release)\nModel: $model\nProduct: $product\nDevice: $device\nBrand:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModel: $model\nLocalized model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nApp version:$appVersion\nApp build number:$appBuildNumber\nApp package name:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Refuse';

  @override
  String get ask_me_later_button_label => 'Later';

  @override
  String get are_you_sure => 'Are you sure?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Go further on $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Welcome !';

  @override
  String get onboarding_home_welcome_text2 =>
      'The app that helps you choose food that is good for **you** and the **planet**!';

  @override
  String get onboarding_continue_button => 'Continue';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Loading your first example product';

  @override
  String get onboarding_welcome_warning =>
      'மன்னிக்கவும், இது எங்கள் உதாரண தயாரிப்பு, நீங்கள் அதைத் திருத்த முடியாது :)';

  @override
  String get product_list_your_ranking => 'Your ranking';

  @override
  String get product_list_empty_icon_desc => 'History not available';

  @override
  String get product_list_empty_title => 'Start scanning';

  @override
  String get product_list_empty_message =>
      'Scanned products will appear here and you can check detailed information about them';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'products',
      one: 'product',
      zero: 'product',
    );
    return 'Refreshing $_temp0 in your history';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Products',
      one: 'Product',
      zero: 'Product',
    );
    return '$_temp0 refresh complete';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Downloading data';

  @override
  String get loading_dialog_default_error_message => 'Could not download data';

  @override
  String get account_delete => 'Delete account';

  @override
  String get account_delete_title => 'எனது கணக்கை நீக்கு.';

  @override
  String get user_profile => 'Account';

  @override
  String get user_profile_title_guest => 'நல்வரவு!';

  @override
  String get user_profile_subtitle_guest =>
      'Sign-in or sign-up to join the Open Food Facts community';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts login: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Welcome $id!';
  }

  @override
  String get email_subject_account_deletion => 'Delete account';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hi there, please delete my Open Food Facts account: $userId';
  }

  @override
  String get settings_app_app => 'Application';

  @override
  String get settings_app_data => 'அம்சங்கள் & செயலிழப்பு கண்காணிப்பு';

  @override
  String get settings_app_camera => 'Camera';

  @override
  String get settings_app_products => 'Products';

  @override
  String get settings_app_miscellaneous => 'Miscellaneous';

  @override
  String get camera_play_sound_title => 'Play a sound on scan';

  @override
  String get camera_play_sound_subtitle => 'Will beep on each successful scan';

  @override
  String get camera_window_accessibility_label =>
      'Scan a barcode with your camera';

  @override
  String get app_haptic_feedback_title => 'Vibration & Haptics';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrations after executing some actions (barcode decoded, product removed…).';

  @override
  String get crash_reporting_toggle_title =>
      'பிழைகள் மற்றும் செயலிழப்புகளைப் புகாரளிக்கவும்';

  @override
  String get crash_reporting_toggle_subtitle =>
      'When enabled, crash reports are automatically submitted to Open Food Facts\' error tracking system, so that bugs can be fixed and thus improve the app.';

  @override
  String get send_anonymous_data_toggle_title =>
      'அம்சத்தின் பயன்பாட்டை எங்களுக்குத் தெரிவிக்கவும்';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'இயக்கப்பட்டால், அம்சத்தைப் பயன்படுத்துவது தொடர்பான கண்டிப்பாக அநாமதேயத் தகவல்கள், ஓபன் ஃபுட் ஃபேக்ட்ஸ் சர்வர்களுக்கு அனுப்பப்படும், இதன் மூலம் அம்சங்களை மேம்படுத்தும் வகையில் அம்சங்கள் எவ்வாறு பயன்படுத்தப்படுகின்றன என்பதை நாம் புரிந்து கொள்ள முடியும். இல்லையெனில், 0 ஐடி அனுப்பப்படும்.';

  @override
  String get product_edit_photo_title => 'Edit Photo';

  @override
  String get permission_photo_error => 'Error';

  @override
  String get permission_photo_denied_title =>
      'Allow camera use to scan barcodes';

  @override
  String permission_photo_denied_message(String appName) {
    return 'For an enhanced experience, please allow $appName to access your camera. You will be able to directly scan barcodes.';
  }

  @override
  String get permission_photo_denied_button => 'Allow';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Permission denied';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'As you\'ve previously denied the camera permission, you must allow it manually from the Settings.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Open settings';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Cancel';

  @override
  String get permission_photo_none_found => 'No camera detected';

  @override
  String get permission_photo_denied => 'No camera access granted';

  @override
  String get show_product_pictures => 'தயாரிப்பு படங்களைக் காட்டு';

  @override
  String get edit_product_label => 'Edit product';

  @override
  String get edit_product_pending_operations_banner_title =>
      'உங்கள் திருத்தங்களைப் பதிவேற்றுகிறது…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'உங்கள் திருத்தங்கள் **பின்னணியில் அனுப்பப்படுகின்றன** (அல்லது பின்னர் பிழை ஏற்பட்டால்).\nநீங்கள் பிற தயாரிப்புப் புலங்களைத் தொடர்ந்து திருத்தலாம்.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Your edits are being **sent in the background** (or later in case of error).';

  @override
  String get edit_product_label_short => 'திருத்து';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\"ஐ எப்படி உள்ளிடுவது?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'காலியாக இல்லாத மதிப்பை உள்ளிடவும்!';

  @override
  String get edit_product_form_item_error_existing =>
      'This value is already there!';

  @override
  String get edit_product_form_item_add_action_brand => 'Add a new brand';

  @override
  String get edit_product_form_item_add_action_label => 'Add a new label';

  @override
  String get edit_product_form_item_add_action_store => 'Add a new store';

  @override
  String get edit_product_form_item_add_action_origin => 'Add a new origin';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Add a new traceability code';

  @override
  String get edit_product_form_item_add_action_country => 'Add a new country';

  @override
  String get edit_product_form_item_add_action_category => 'Add a new category';

  @override
  String get edit_product_form_item_add_action_trace => 'Add a new trace';

  @override
  String get edit_product_form_item_add_suggestion => 'Add suggestion';

  @override
  String get edit_product_form_item_deny_suggestion => 'பரிந்துரையை நிராகரி';

  @override
  String get edit_product_form_item_details_title => 'Basic details';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Product name, brand, quantity';

  @override
  String get edit_product_form_item_other_details_title => 'Additional details';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Website…';

  @override
  String get edit_product_form_item_photos_title => 'புகைப்படங்கள்';

  @override
  String get edit_product_form_item_photos_subtitle => 'Add or refresh photos';

  @override
  String get edit_product_form_item_labels_title => 'Labels & Certifications';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Environmental, Quality labels…';

  @override
  String get edit_product_form_item_labels_hint =>
      'ஒரு லேபிளை உள்ளிடவும் (எ. கா: நியூட்ரிஸ்கோர்)';

  @override
  String get edit_product_form_item_labels_type => 'label';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Good practices: Labels';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Any characteristic of the product **which is factual** and different from the other fields.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Made in Belgium, produced in Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rich in fiber, source of iron…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Stores';

  @override
  String get edit_product_form_item_stores_hint => 'ஒரு கடையை உள்ளிடவும்';

  @override
  String get edit_product_form_item_stores_type => 'store';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Good practices: Stores';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Input the store where you bought the product.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Origins';

  @override
  String get edit_product_form_item_origins_hint =>
      'மூலத்தை உள்ளிடவும் (எ. கா: ஜெர்மனி)';

  @override
  String get edit_product_form_item_origins_type => 'country';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Good practices: Origins';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Add **any indications of origins you can find on the packaging**.\nYou need not worry about origins indicated directly in the ingredient list.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Beef from Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'The soy does not come from the European Union';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'ஒரு நாட்டை உள்ளிடவும் (எ. கா: ஜெர்மனி)';

  @override
  String get edit_product_form_item_countries_type => 'country';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Good practices: Countries';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Countries where the product is widely available** (not including stores specialising in foreign products).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Traceability codes';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'குறியீட்டை உள்ளிடவும் (எ. கா: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'traceability code';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Good practices: Traceability codes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In this section, you can input codes related to **packaging marks**, **identification marks** or **health marks**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Examples of traceability codes';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC codes** used in the European Community to identify food producers or packagers:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: country code of **France**\n**72.264.002**: geographic data\n**CE**: European Community';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB codes** used in France:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Traces';

  @override
  String get edit_product_form_item_traces_hint => 'trace';

  @override
  String get edit_product_form_item_traces_type =>
      'Input a trace (eg: Soy beans)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'category';

  @override
  String get edit_product_form_item_categories_type =>
      'ஒரு வகையை உள்ளிடவும் (எ. கா: ஆரஞ்சு சாறு)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Good practices: Categories';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicate **only the most specific category**.\nParent categories will be automatically added.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Missing category?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'In case a category is **not available in autocomplete**, feel free to add it anyway.\nThis will help us improve Open Food Facts in your country.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardines in olive oil';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Orange juice from concentrate';

  @override
  String get edit_product_form_item_exit_title => 'சேமிக்காமல் வெளியேறு?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Do you want to save your changes before leaving this page?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Save changes';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Discard changes';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'திரையைக் கிள்ளுவதன் மூலம் பெரிதாக்கவும்';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'புகைப்படத்தைப் பெரிதாக்கவோ அல்லது பிரிதாகவோ ஆக்கவும்';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**பிஞ்ச்-டு-ஜூம் அம்சத்தைப்** பயன்படுத்தி, நீங்கள் புகைப்படத்தைப் பெரிதாக்கலாம் அல்லது சிறிதாக்கலாம்:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'சேர்';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Please enter a text first';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Remove';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => 'Save your edit';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancel your edit';

  @override
  String get edit_product_form_item_packaging_title =>
      'Recycling instructions photo';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutrition, alcohol content…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Good practices: Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nutritional values';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'First, select if the **values are provided**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Then, input the nutritional values **as indicated on the packaging**. If there is no value, you can click on the \"Eye\" icon.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Missing field?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'If an entry is missing, you can **click on the \"Plus\" icon** to add it (eg: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'திருத்து';

  @override
  String get edit_product_ingredients_photo_title => 'Ingredients photo';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'பேக்கேஜிங் புகைப்படம்';

  @override
  String get edit_product_packaging_list_title => 'பேக்கேஜிங் பட்டியல்';

  @override
  String get no_data_available => 'No data available';

  @override
  String get product_field_website_title => 'Website';

  @override
  String get origins_editing_title => 'மூலங்களைத் திருத்தவும்';

  @override
  String get completed_basic_details_btn_text => 'Complete basic details';

  @override
  String get not_implemented_snackbar_text => 'Not implemented yet';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extract ingredients from the photo';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extract ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extracting ingredients\nfrom the photo';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'To use the \"Extract ingredients\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Refresh photo';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extract packaging\nfrom the photo';

  @override
  String get edit_packaging_extract_btn_text_short =>
      'பேக்கேஜிங்கை பிரித்தெடுத்தல்';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extracting packaging from the photo';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'To use the \"Extract packaging\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Refresh photo';

  @override
  String get edit_ocr_extract_failed => 'Failed to detect text in image.';

  @override
  String get edit_ocr_extract_disabled_title => 'படம் இல்லை!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'உரை பிரித்தெடுத்தல் அம்சத்தைப் பயன்படுத்த, நீங்கள் முதலில் புகைப்படம் எடுக்க வேண்டும்.';

  @override
  String get user_list_dialog_new_title => 'New list of products';

  @override
  String get user_list_dialog_rename_title => 'Rename list';

  @override
  String get user_list_subtitle_product => 'Lists';

  @override
  String get user_list_title => 'உங்களின் பட்டியல்கள்';

  @override
  String get user_list_add_product => 'Add the product to your lists';

  @override
  String get user_list_button_new => 'Create a new list';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Add to list';

  @override
  String get added_to_list_msg => 'Added to list';

  @override
  String get user_list_popup_clear => 'Clear your history';

  @override
  String get user_list_popup_rename => 'Rename';

  @override
  String get user_list_name_hint => 'My list';

  @override
  String get user_list_name_error_empty => 'Name is mandatory';

  @override
  String get user_list_name_error_already => 'That name is already used';

  @override
  String get user_list_name_error_same => 'That is the same name';

  @override
  String get user_list_name_input_hint => 'Name of the list';

  @override
  String get try_again => 'Try Again';

  @override
  String get there_was_an_error => 'There was an error';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'No category found for $items';
  }

  @override
  String get camera_toggle_camera => 'Switch between back and front camera';

  @override
  String get camera_toggle_flash => 'Turn ON or OFF the flash of the camera';

  @override
  String get camera_enable_flash => 'Enable flash';

  @override
  String get camera_disable_flash => 'Disable flash';

  @override
  String get camera_flash_error_dialog_title => 'ஒரு பிழை ஏற்பட்டது!';

  @override
  String get camera_flash_error_dialog_message =>
      'உங்கள் ஃபிளாஷின் நிலையை மாற்றும்போது பிழை ஏற்பட்டது. உங்கள் ஸ்மார்ட்போனில் டார்ச் ஏற்கனவே இயக்கப்படவில்லை என்பதை உறுதிப்படுத்தவும்.';

  @override
  String get category_picker_no_category_found_button => 'பின்செல்';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Click to open in your browser or in the application (if installed)';

  @override
  String get dev_preferences_screen_title => 'DEV Mode';

  @override
  String get dev_preferences_screen_subtitle =>
      'பரிசோதனை அம்சங்கள் மற்றும் மேம்பாட்டு கருவிகளை அணுகவும்';

  @override
  String get dev_preferences_reset_onboarding_title => 'Restart onboarding';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'You then have to restart the App to see it again.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Switch between openfoodfacts.org (PROD) and test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Test environment parameters';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Base URL for current test env: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Test environment host';

  @override
  String get dev_preferences_ml_kit_title => 'Use ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'then you have to restart this app';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Additional button on product page';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Edit ingredients via a knowledge panel button';

  @override
  String get dev_preferences_export_history_title => 'Export History';

  @override
  String get dev_preferences_export_history_progress_error => 'exception';

  @override
  String get dev_preferences_export_history_progress_found => 'product found';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'product NOT found';

  @override
  String get dev_preferences_export_history_dialog_title => 'Export history';

  @override
  String get dev_preferences_button_positive => 'சரி';

  @override
  String get dev_preferences_button_negative => 'Cancel';

  @override
  String get dev_preferences_migration_title => 'Data migration from V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'success or fresh install';

  @override
  String get dev_preferences_migration_status_success => 'success';

  @override
  String get dev_preferences_migration_status_error => 'error';

  @override
  String get dev_preferences_migration_status_in_progress => 'in progress';

  @override
  String get dev_preferences_migration_status_required =>
      'required (click to start)';

  @override
  String get dev_preferences_migration_status_not_started => 'unknown';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Will clear history and put 3 products in there';

  @override
  String get dev_preferences_news_custom_url_title => 'Custom URL for news';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL of the JSON file:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Not set';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Last refresh: $date';
  }

  @override
  String get product_type_label_food => 'Food';

  @override
  String get product_type_label_beauty => 'Personal care';

  @override
  String get product_type_label_pet_food => 'Pet food';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Product type';

  @override
  String get product_type_selection_subtitle =>
      'Select the type of this product';

  @override
  String get product_type_selection_empty =>
      'You need to select a product type first!';

  @override
  String product_type_selection_already(String productType) {
    return 'You cannot change the product type ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Shortcut to Prices app on product page';

  @override
  String get prices_app_button => 'Go to Prices app';

  @override
  String get prices_website_button => 'திறந்த விலைகள் வலைத்தளத்தில் திறக்கவும்';

  @override
  String get prices_bulk_proof_upload_select =>
      'Add price tags directly from gallery';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Once you\'ve selected images, you won\'t be able to edit them!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'AI ஆல் பிரித்தெடுக்கப்பட்ட விலைகளை சமூகம் சரிபார்க்க அனுமதிக்கவும்.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Multiple Price Tags';

  @override
  String get prices_bulk_proof_upload_title => 'Bulk Proof Upload';

  @override
  String get prices_bulk_proof_upload_step_selecting =>
      'கோப்புகளைத் தேர்ந்தெடுக்கிறது';

  @override
  String get prices_bulk_proof_upload_step_starting =>
      'பதிவேற்றத்தைத் தொடங்குகிறது';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return '#$index/$countகோப்பை உள்ளூரில் நகலெடுக்கிறது.';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'பதிவேற்றத்தைத் தயார் செய்கிறது #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'படத்தில் தோல்வி #$index/$count';
  }

  @override
  String get prices_generic_title => 'Prices';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add $count prices',
      one: 'Add a price',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Send $count prices',
      one: 'Send the price',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Add an item';

  @override
  String get prices_add_a_price => 'Add a price';

  @override
  String get prices_add_a_receipt => 'Add a receipt';

  @override
  String get prices_add_price_tags => 'Add price tags';

  @override
  String prices_barcode_already(String barcode) {
    return 'This barcode ($barcode) is already in the list!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'No product yet';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcode ஐத் தேடுகிறது அல்லது தேடுகிறோம்';
  }

  @override
  String get prices_barcode_enter => 'Enter the Barcode';

  @override
  String get prices_category_enter => 'பார்கோடு இல்லாத பொருள்';

  @override
  String get prices_per_kilogram => 'ஒரு கிலோகிராமுக்கு விலை';

  @override
  String get prices_per_unit => 'ஒன்றின் விலை';

  @override
  String get prices_per_kilogram_short => ' / கிலோ';

  @override
  String get prices_per_unit_short => ' / அலகு';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => 'விருப்பத்தேர்வு';

  @override
  String get prices_category_error_mandatory => 'இந்தப் பிரிவு கட்டாயமானது';

  @override
  String get prices_barcode_reader_action => 'Barcode reader';

  @override
  String get prices_view_prices => 'View the prices';

  @override
  String get prices_list_title => 'விலைப்பட்டியல்';

  @override
  String get prices_list_count => '\nவிலைகளின் எண்ணிக்கை';

  @override
  String get prices_list_add_new_price => '\nபுதிய விலையைச் சேர்க்கவும்';

  @override
  String get prices_list_empty_title => 'இன்னும் விலை இல்லை!';

  @override
  String get prices_list_empty_subtitle =>
      '**ரசீது** அல்லது **விலை குறிச்சொல்** ஐ ஸ்கேன் செய்வதன் மூலம்\nஐச் சேர்க்கும் முதல் நபராக இருங்கள்!';

  @override
  String get prices_entry_shop_not_found => 'தெரியாத கடை';

  @override
  String prices_entry_menu_title(String user) {
    return '\"$user\" இலிருந்து விலை உள்ளீடு';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'இந்த தயாரிப்புக்கான அனைத்து விலைகளையும் காண்க';

  @override
  String get prices_entry_menu_open_proof => 'ஆதாரத்தைக் காண்க';

  @override
  String get prices_entry_menu_my_prices => 'எனது பிற விலைகளைப் பார்க்கவும்';

  @override
  String get prices_entry_menu_author_prices =>
      'ஆசிரியரின் பிற விலைகளைக் காண்க.';

  @override
  String get prices_entry_menu_shop_prices =>
      'கடையில் உள்ள பிற விலைகளைப் பார்க்கவும்.';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: '1 price',
    );
    return '$_temp0 for $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count prices',
      one: 'Only one price',
      zero: 'No price yet',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize prices (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Price: $price / Store: \"$location\" / Published on $date by \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Open proofs of \"$user\"';
  }

  @override
  String get prices_open_proof => 'Open price proof';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count proofs',
      one: 'Only one proof',
      zero: 'No proof yet',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize proofs (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'இன்னும் பங்களிப்பாளர் இல்லை!';

  @override
  String get prices_users_empty_explanation =>
      'விலையைச் சேர்க்கும் முதல் நபராக இருங்கள்!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'சிறந்த $pageSize பங்களிப்பாளர்கள் (மொத்தம்: $total)';
  }

  @override
  String get prices_locations_empty_title => 'இன்னும் கடை இல்லை!';

  @override
  String get prices_locations_empty_explanation =>
      'விலையைச் சேர்க்கும் முதல் நபராக இருங்கள்!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize locations (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count proofs',
      one: 'One proof',
      zero: 'No proof',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: 'One product',
      zero: 'No product',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count users',
      one: 'One user',
      zero: 'No user',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: 'One price',
      zero: 'No price',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'முன்பு சேர்க்கப்பட்ட விலை';

  @override
  String get prices_amount_subtitle => 'Amount';

  @override
  String get prices_amount_is_discounted => 'Is discounted?';

  @override
  String get prices_amount_price_normal => 'Price';

  @override
  String get prices_amount_price_discounted => 'Discounted price';

  @override
  String get prices_amount_price_not_discounted => 'Original price';

  @override
  String get prices_amount_no_product => 'One product is missing!';

  @override
  String get prices_amount_price_incorrect => 'Incorrect value';

  @override
  String get prices_amount_price_mandatory => 'Mandatory value';

  @override
  String get prices_currency_subtitle => 'Currency';

  @override
  String get prices_date_subtitle => 'Date';

  @override
  String get prices_location_subtitle => 'Shop';

  @override
  String get prices_location_find => 'Find a shop';

  @override
  String get prices_location_mandatory => 'You need to select a shop!';

  @override
  String get prices_location_search_broader =>
      'Couldn\'t find what you were looking for? Let\'s try a broader search!';

  @override
  String get prices_proof_subtitle => 'Proof';

  @override
  String get prices_proof_empty_title => 'இன்னும் ஆதாரம் இல்லை!';

  @override
  String get prices_proof_empty_explanation =>
      '**ரசீது** அல்லது **விலை குறி**யின் புகைப்படத்தைச் சேர்ப்பதன் மூலம் தொடங்குங்கள்!';

  @override
  String get prices_proof_find => 'Select a proof';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Receipt';

  @override
  String get prices_proof_price_tag => 'Price tag';

  @override
  String get prices_proof_mandatory => 'You need to select a proof!';

  @override
  String get prices_add_validation_error => 'Validation error';

  @override
  String get prices_privacy_warning_title => 'Privacy warning';

  @override
  String get prices_unknown_product => 'Unknown product';

  @override
  String get prices_privacy_warning_main_message =>
      'Prices **will be public**, along with the store they refer to.\n\nThat might allow people who know about your Open Food Facts pseudonym to:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Infer in which area you live';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Know what you are buying';

  @override
  String get prices_privacy_warning_sub_message =>
      'If you are uneasy with that, please change your pseudonym, or create a new Open Food Facts account and log into the app with it.';

  @override
  String get i_refuse => 'I refuse';

  @override
  String get i_accept => 'I accept';

  @override
  String get prices_currency_change_proposal_title => 'நாணயத்தை மாற்றவா?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'உங்கள் தற்போதைய நாணயத்தை **$currency**. இதை **$newCurrency** ஆக மாற்ற விரும்புகிறீர்களா?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'ஆம், $newCurrency ஐப் பயன்படுத்தவும்';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'இல்லை, $currency வைத்திருங்கள்';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Done';

  @override
  String get dev_mode_section_server => 'Server configuration';

  @override
  String get dev_mode_section_news => 'News provider configuration';

  @override
  String get dev_mode_section_product_page => 'Product page';

  @override
  String get dev_mode_section_ui => 'User Interface';

  @override
  String get dev_mode_section_experimental_features => 'Experimental features';

  @override
  String get dev_mode_hide_environmental_score_title => 'Exclude Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Use a spellchecker for OCR screens';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredients and packaging)';

  @override
  String get dev_mode_reset_app_language_title =>
      'பயன்பாட்டு மொழியை மீட்டமைக்கவும்';

  @override
  String get dev_mode_add_demo_cards_language_title => 'கார்டுகளைச் சேர்';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) மற்றும் சோதனை env க்கு இடையில் மாறவும்.';

  @override
  String get search_history_item_edit_tooltip => 'Reuse and edit this search';

  @override
  String get search_history_item_remove_tooltip => 'Remove';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'You\'ve downloaded all the $totalSize products.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Download $count more products\nAlready downloaded $downloaded out of $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Your search of $search is in progress.\n\nPlease wait a few seconds…';
  }

  @override
  String get user_search_contributor_title => 'Products I added';

  @override
  String get user_search_informer_title => 'Products I edited';

  @override
  String get user_search_photographer_title => 'Products I photographed';

  @override
  String get user_search_to_be_completed_title => 'My to-be-completed products';

  @override
  String get user_search_prices_title => 'எனது விலைகள்';

  @override
  String get user_search_proofs_title => 'My proofs';

  @override
  String get user_search_proof_title => 'My proof';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'பங்களிப்பாளர் விலைகள்: $user';
  }

  @override
  String get all_search_prices_latest_title =>
      'சமீபத்திய விலைகள் சேர்க்கப்பட்டன';

  @override
  String get all_search_prices_top_user_title => 'அதிக விலை பங்களிப்பாளர்கள்';

  @override
  String get all_search_prices_top_location_title => 'அதிக விலை கொண்ட கடைகள்';

  @override
  String get prices_contribution_assistant => 'விலை பங்களிப்பு உதவியாளர்';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'சவால்கள்';

  @override
  String get prices_multiple_proof_addition_system => 'Add Multiple Proofs';

  @override
  String get all_search_prices_top_location_single_title => 'Prices in a store';

  @override
  String get all_search_prices_top_product_title =>
      'அதிக விலை கொண்ட தயாரிப்புகள்';

  @override
  String get all_search_to_be_completed_title => 'All to-be-completed products';

  @override
  String get categorize_products_country_title =>
      'Help categorize products in your country';

  @override
  String get edit_product_action_retake_picture => 'Retake photo';

  @override
  String get edit_product_action_take_picture => 'Take photo';

  @override
  String get edit_product_action_confirm => 'Confirm';

  @override
  String get signup_page_terms_of_use_line1 =>
      'I agree to the Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'terms of use and contribution';

  @override
  String get analytics_consent_image_semantic_label => 'Analytics icon';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Fatal Error: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Fatal Error: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Complete basic details';

  @override
  String get edit_photo_button_label => 'திருத்து';

  @override
  String get edit_photo_unselect_button_label => 'Unselect photo';

  @override
  String get edit_photo_select_existing_button_label =>
      'Select an existing image';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Select an image by clicking on it';

  @override
  String get edit_photo_select_existing_download_label =>
      'Retrieving existing images…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'There are no images previously uploaded related to this product.';

  @override
  String get edit_photo_language_not_this_one =>
      'அந்த மொழியில் இன்னும் உருவம் இல்லை';

  @override
  String get edit_photo_language_none => 'இன்னும் எந்த உருவமும் இல்லை';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'Basic Details';

  @override
  String get product_name => 'Product Name';

  @override
  String get product_names => 'தயாரிப்புப் பெயர்கள்';

  @override
  String get add_basic_details_product_name_add_translation =>
      'புதிய மொழிபெயர்ப்பைச் சேர்க்கவும்';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Before validating, please ensure you only add a translation **if the language is present on the packaging**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'முன் புகைப்படத்தைப் பார்க்கவும்';

  @override
  String get add_basic_details_product_name_take_photo =>
      'முன் புகைப்படம் எடுக்கவும்';

  @override
  String get add_basic_details_product_name_hint =>
      'தயாரிப்பின் பெயரை உள்ளிடவும் (எ. கா: நுட்டெல்லா)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'இயல்புநிலை மொழியை மாற்றவா?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'தயாரிப்பின் இயல்புநிலை மொழியை \'$language\' என அமைக்க விரும்புகிறீர்களா?';
  }

  @override
  String get explanation_section_good_examples => 'Good examples';

  @override
  String get explanation_section_bad_examples => 'Bad examples';

  @override
  String get add_basic_details_product_name_help_title =>
      'Good practices: Product name';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'The product name is the **main name printed on the packaging**. It can be a registered trademark.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Note:** Please don\'t add a translation **if the language is not present on the packaging**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomato Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Don\'t include the brand in the name';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomato Ketchup **by Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Don\'t use symbols ®, ™, © or similar';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count மற்ற மொழிபெயர்ப்பு',
      one: '$count மற்ற மொழிபெயர்ப்பு',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Brand name';

  @override
  String get brand_names => 'தயாரிப்புப் பெயர்கள்';

  @override
  String get add_basic_details_brand_name_error =>
      'Please enter the brand name';

  @override
  String get add_basic_details_brand_names_hint =>
      'உள்ளீட்டு பிராண்டுகள் (எ. கா: ஃபெர்ரெரோ)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Good practices: Brands';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Input **all the brands of the product**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Main brand';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'The **main brand**, generally clearly displayed on the front pack, should be **entered first**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Other brands';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'When sold **by a big company**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** is sold by **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'When sold with its brand **translated in multiple languages**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** is sometimes written **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Quantity and weight';

  @override
  String get add_basic_details_quantity_hint =>
      'எடை மற்றும் தேவைப்பட்டால் அளவை உள்ளிடவும் (எ. கா: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Good practices: Quantity';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copy the value indicated on the product and **don\'t forget the units**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** or **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (for 6 eggs)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(for a product with 3 boxes, each of 150g)';

  @override
  String get barcode => 'பார்கோடு';

  @override
  String barcode_barcode(String barcode) {
    return 'Barcode: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Invalid barcode';

  @override
  String get basic_details_add_success => 'Basic details added successfully';

  @override
  String get basic_details_add_error =>
      'Unable to add basic details. Please try again after some time';

  @override
  String get clear_search => 'Clear your search';

  @override
  String get confirm_clear =>
      'You\'re about to clear your entire history: are you sure you want to continue?';

  @override
  String get alert_clear_selected_user_list =>
      'You\'re about to clear selected items in your history';

  @override
  String get confirm_clear_selected_user_list =>
      'Are you sure you want to continue?';

  @override
  String get alert_select_items_to_clear =>
      'Please select one or more items to clear';

  @override
  String confirm_clear_user_list(String name) {
    return 'You\'re about to clear this list ($name): are you sure you want to continue?';
  }

  @override
  String get confirm_delete_user_list_title => 'Delete the list?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'You\'re about to delete the list \"$name\".\nAre you sure you want to continue?';
  }

  @override
  String get confirm_delete_user_list_button => 'Yes, I confirm';

  @override
  String importance_label(String name, String id) {
    return '$name importance: $id';
  }

  @override
  String get user_list_all_title => 'Lists';

  @override
  String get user_list_all_empty => 'Create your first list';

  @override
  String get product_list_select => 'Select a list';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: 'One product',
      zero: 'Empty list',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Add list';

  @override
  String get open_food_preferences_tooltip => 'Edit your food preferences';

  @override
  String get add_photo_button_label => 'Add photo';

  @override
  String get add_packaging_photo_button_label =>
      'Take photos of any packaging/recycling information';

  @override
  String get add_origin_photo_button_label =>
      'எந்தவொரு மூலத் தகவலின் புகைப்படங்களையும் எடுக்கவும்';

  @override
  String get add_emb_photo_button_label =>
      'எந்தவொரு மூலத் தகவலின் புகைப்படங்களையும் எடுக்கவும்';

  @override
  String get add_label_photo_button_label =>
      'ஏதேனும் லேபிள்கள் மற்றும் சான்றிதழ்கள்பற்றிய தகவல்களைப் புகைப்படம் எடுக்கவும்';

  @override
  String get choose_image_source_title => 'Choose image source';

  @override
  String get choose_image_source_body => 'Please choose a image source';

  @override
  String get gallery_source_label => 'Gallery';

  @override
  String get gallery_source_access_denied_dialog_title => 'Access denied';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Unfortunately, the application can\'t access your gallery, as you have previously denied the permission.\n\nPlease go to the app settings in your phone Settings -> Photos';

  @override
  String get gallery_source_access_denied_dialog_button => 'Open the Settings';

  @override
  String get share => 'பகிர்க';

  @override
  String share_product_text(String url) {
    return 'Have a look at this product on Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Have a look at this product on Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Have a look at this product on Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Have a look at this product on Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Have a look at my list of products on Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'ஒரு படம் எடு';

  @override
  String get choose_from_gallery => 'Choose from gallery';

  @override
  String get image_upload_queued =>
      'The image will be uploaded in the background as soon as possible.';

  @override
  String get add_price_queued =>
      'The price will be sent to the server as soon as possible.';

  @override
  String get background_task_title_full_refresh =>
      'உள்நாட்டில் சேமிக்கப்பட்ட அனைத்து தயாரிப்புகளையும் புதுப்பிக்கத் தொடங்குகிறது';

  @override
  String get background_task_title_top_n =>
      'மிகவும் பிரபலமான தயாரிப்புகளின் பதிவிறக்கத்தைத் தொடங்குகிறது';

  @override
  String get expand_nutrition_facts => 'Expand nutrition facts table';

  @override
  String get expand_nutrition_facts_body =>
      'Keep the nutrition facts table expanded';

  @override
  String get expand_ingredients => 'Expand ingredients';

  @override
  String get expand_ingredients_body => 'Keep the ingredients panel expanded';

  @override
  String get no_internet_connection => 'No internet connection';

  @override
  String get world_results_label => 'Entire world';

  @override
  String get world_results_action => 'Extend your search to the world';

  @override
  String get copy_to_clipboard => 'Copy';

  @override
  String get paste_from_clipboard => 'Paste from clipboard';

  @override
  String get no_data_available_in_clipboard =>
      'No data available in your clipboard';

  @override
  String get clipboard_barcode_copy => 'Copy barcode to clipboard';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Barcode $barcode copied to the clipboard!';
  }

  @override
  String get open_product_website => 'இந்தத் தயாரிப்பை இணையதளத்தில் திறக்கவும்';

  @override
  String get language_picker_label => 'Your language';

  @override
  String get country_picker_label => 'Your country';

  @override
  String get currency_picker_label => 'உங்கள் நாணயம்';

  @override
  String get help_with_openfoodfacts => 'Help with OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'The product will be updated in the background as soon as possible.';

  @override
  String get no_email_client_available_dialog_title => 'No email apps!';

  @override
  String get no_email_client_available_dialog_content =>
      'Please send us manually an email to mobile@openfoodfacts.org';

  @override
  String get all_images => 'All Images';

  @override
  String get selected_images => 'Selected Images';

  @override
  String get product_card_remove_product_tooltip => 'Remove product';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'New barcode scanned: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Remove all products from the carousel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Please scan at least two products to compare them';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'நீங்கள் ஸ்கேன் செய்த தயாரிப்புகளை ஒப்பிடக் கிளிக் செய்யவும்.';

  @override
  String get scan_product_loading => 'You have scanned\nthe barcode:';

  @override
  String get scan_product_loading_initial =>
      'We\'re looking for this product!\nPlease wait a few seconds…';

  @override
  String get scan_product_loading_long_request =>
      'We\'re still looking for this product!\nDo you find it takes a long time to load? So are we…';

  @override
  String get scan_product_loading_unresponsive =>
      'We\'re still looking for this product.\nWould you like to restart the search?';

  @override
  String get scan_product_loading_restart_button => 'Restart search';

  @override
  String get portion_calculator_description =>
      'Calculate nutrition facts for a specific quantity';

  @override
  String get portion_calculator_hint => 'Quantity in';

  @override
  String get portion_calculator_accessibility =>
      'Input a quantity to calculate nutrition facts';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Please enter a quantity between $min and $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'காணாமல் போன தரவு. கணக்கீடு செய்ய முடியவில்லை.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Nutrition facts for $grams g (or ml)';
  }

  @override
  String get offline_data => 'Offline Data';

  @override
  String get ocr_image_upload_instruction =>
      'Upload an image to automatically extract the information it contains.';

  @override
  String get upload_image => 'Upload Photo';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Failed to download image';

  @override
  String get image_edit_url_error =>
      'Failed to edit image because the image URL was not set.';

  @override
  String get user_picture_source_remember => 'எனது தேர்வை நினைவில்கொள்';

  @override
  String get user_picture_source_ask => 'Ask each time';

  @override
  String get robotoff_continue => 'Continue';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count questions',
      one: 'question',
    );
    return 'Next $_temp0';
  }

  @override
  String get show_password => 'Show Password';

  @override
  String get owner_field_info_title => 'Producer provided values';

  @override
  String get owner_field_info_message =>
      'With that logo we highlight data provided by the producer, and that may not be editable.';

  @override
  String get owner_field_info_close_button => 'Close this info';

  @override
  String get owner_field_image =>
      'This image is provided by the producer. It may not be editable.';

  @override
  String get edit_packagings_title => 'Packaging components';

  @override
  String get edit_packagings_element_add => 'Add a packaging component';

  @override
  String get edit_packagings_completed => 'The packaging is complete';

  @override
  String edit_packagings_element_title(int index) {
    return 'Packaging component #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Number of units';

  @override
  String get edit_packagings_element_hint_units =>
      'Enter the number of packaging units of the same shape and material contained in the product.';

  @override
  String get edit_packagings_element_field_shape => 'Shape';

  @override
  String get edit_packagings_element_hint_shape =>
      'Enter the shape name listed in the recycling instructions if they are available, or select a shape.';

  @override
  String get edit_packagings_element_example_shape => 'Bottle';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Enter the specific material if it can be determined (a material code inside a triangle can often be found on packaging parts), or a generic material (for instance plastic or metal) if you are unsure.';

  @override
  String get edit_packagings_element_example_material => 'Glass';

  @override
  String get edit_packagings_element_field_recycling => 'Recycling instruction';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Enter recycling instructions only if they are listed on the product.';

  @override
  String get edit_packagings_element_example_recycling => 'Recycle';

  @override
  String get edit_packagings_element_field_quantity =>
      'Net quantity of product per unit';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Enter the net weight or net volume and indicate the unit (for example g or ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Weight of one empty unit (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Remove any remaining food and wash and dry the packaging part before weighing. If possible, use a scale with 0.1g or 0.01g precision.';

  @override
  String get background_task_title => 'Pending contributions';

  @override
  String get background_task_subtitle =>
      'Your contributions are automatically saved to our server, but not always in real-time.';

  @override
  String get background_task_list_empty => 'No Pending Background Tasks';

  @override
  String get background_task_error_server_time_out => 'Server timeout';

  @override
  String get background_task_error_no_internet =>
      'Internet connection error. Try later.';

  @override
  String get background_task_operation_unknown => 'unknown operation type';

  @override
  String get background_task_operation_details => 'detailed changes';

  @override
  String get background_task_operation_image => 'photo upload';

  @override
  String get background_task_operation_refresh =>
      'refresh delayed after photo upload';

  @override
  String get background_task_run_started => 'started';

  @override
  String get background_task_run_not_started => 'not started yet';

  @override
  String get background_task_run_to_be_deleted => 'to be deleted';

  @override
  String get background_task_question_stop =>
      'Do you want to stop that task ASAP?';

  @override
  String get feed_back => 'Feedback';

  @override
  String get undo => 'Undo';

  @override
  String get copy_email_to_clip_board => 'Copy email to clipboard';

  @override
  String get please_send_us_an_email_to =>
      'Please send us manually an email to';

  @override
  String get email_copied_to_clip_board => 'Email copied to clipboard!';

  @override
  String get select_accent_color => 'Select Accent Color';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blue';

  @override
  String get color_cyan => 'Cyan';

  @override
  String get color_green => 'Green';

  @override
  String get color_light_brown => 'Default';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Orange';

  @override
  String get color_pink => 'Pink';

  @override
  String get color_red => 'Red';

  @override
  String get color_rust => 'Rust';

  @override
  String get color_teal => 'Teal';

  @override
  String get text_contrast_mode => 'Text Contrast';

  @override
  String get contrast_high => 'High';

  @override
  String get contrast_medium => 'Medium';

  @override
  String get contrast_low => 'Low';

  @override
  String get product_refresher_internet_not_found => 'Product not found!';

  @override
  String get product_refresher_internet_not_connected =>
      'You are not connected to internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server down ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Server error ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Product not found!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'A product with the following barcode doesn\'t exist in our database: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'No internet connection!';

  @override
  String get product_loader_network_error_message =>
      'Please check that your smartphone is on a WiFi network or has mobile data enabled';

  @override
  String get page_not_found_title => 'Page not found!';

  @override
  String get page_not_found_button => 'Go back to the homepage';

  @override
  String get download_data => 'Download data';

  @override
  String get download_top_products =>
      'Download the top 1000 products in your country for instant scanning';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count பொருட்கள்',
      one: '',
    );
    return 'மேலே பதிவிறக்கவும் $_temp0 உடனடி ஸ்கேன் செய்ய உங்கள் நாட்டில்';
  }

  @override
  String get download_in_progress => 'Downloading data\nThis may take a while';

  @override
  String downloaded_products(int num) {
    return '$num products added';
  }

  @override
  String get update_offline_data => 'Update offline product data';

  @override
  String get update_local_database_sub =>
      'Update the local product database with the latest data from Open Food Facts';

  @override
  String get clear_local_database => 'Clear offline product data';

  @override
  String get clear_local_database_sub =>
      'Clear all local product data from your app to free up space';

  @override
  String deleted_products(int num) {
    return '$num products deleted';
  }

  @override
  String get loading => 'ஏற்றுகிறது…';

  @override
  String get know_more => 'Know More';

  @override
  String get offline_data_desc => 'Click to know more about offline data';

  @override
  String get offline_product_data_title => 'Offline product data';

  @override
  String available_for_download(int num) {
    return '$num products available for immediate scaning';
  }

  @override
  String get country_selector_title => 'Select your country:';

  @override
  String get currency_selector_title => 'உங்கள் நாணயத்தைத் தேர்ந்தெடுக்கவும்:';

  @override
  String get language_selector_title => 'Select your language:';

  @override
  String get language_selector_section_selected =>
      'தேர்ந்தெடுக்கப்பட்ட மொழிகள்';

  @override
  String get language_selector_section_frequently_used =>
      'அடிக்கடி பயன்படுத்தப்படுபவை';

  @override
  String get action_delete_list => 'நீக்கு';

  @override
  String get action_change_list => 'Change the current list';

  @override
  String get product_list_create => 'உருவாக்கு';

  @override
  String get product_list_create_tooltip => 'Create a new list';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (New calculation)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'தெரியாத Nutri-Score (புதிய கணக்கீடு)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score பொருந்தாது (புதிய கணக்கீடு)';

  @override
  String get environmental_score_generic_new => 'பச்சை-ஸ்கோர்';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'தெரியாத Green-Score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score பொருந்தாது.';

  @override
  String get nova_group_generic_new =>
      'மிகவும் பதப்படுத்தப்பட்ட உணவுகள் - NOVA குழுக்கள்';

  @override
  String get nova_group_1 => 'NOVA Group 1';

  @override
  String get nova_group_2 => 'NOVA Group 2';

  @override
  String get nova_group_3 => 'NOVA Group 3';

  @override
  String get nova_group_4 => 'NOVA Group 4';

  @override
  String get nova_group_unknown => 'Unknown NOVA Group';

  @override
  String get nutrition_facts => 'Nutrient Levels';

  @override
  String get faq_title_partners => 'Partners & Patrons of the NGO';

  @override
  String get faq_title_vision =>
      'The Open Food Facts Vision, Mission, Values and Programs';

  @override
  String get faq_title_install_beauty =>
      'Install Open Beauty Facts to create a cosmetic database';

  @override
  String get faq_title_install_pet =>
      'Install Open Pet Food Facts to create a pet food database';

  @override
  String get faq_title_install_product =>
      'Install Open Products Facts to create a products database to extend the life of objects';

  @override
  String get faq_nutriscore_nutriscore =>
      'New calculation of the Nutri-Score: what\'s new?';

  @override
  String get contact_title_pro_page =>
      'Pro? Import your products in Open Food Facts';

  @override
  String get contact_title_pro_email => 'Producer Contact';

  @override
  String get contact_title_press_page => 'Press Page';

  @override
  String get contact_title_press_email => 'Press Contact';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'Subscribe to our community calendar';

  @override
  String get hunger_games_loading_line1 => 'Please give us a few seconds…';

  @override
  String get hunger_games_loading_line2 => 'We\'re downloading the questions!';

  @override
  String get hunger_games_error_label =>
      'Argh! Something went wrong… and we couldn\'t load the questions.';

  @override
  String get hunger_games_error_retry_button => 'Let\'s retry!';

  @override
  String get reorder_attribute_action => 'Reorder the attributes';

  @override
  String get link_cant_be_opened =>
      'This link can\'t be opened on your device. Please check that you have a browser installed.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Details for $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Details for $pageName with $productName';
  }

  @override
  String get guide_title => 'கையேடு';

  @override
  String get guide_share_label => 'பகிர்க';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Where to find the new Nutri-Score calculation?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'The Nutri-Score is applied in 7 countries: France, Germany, Belgium, Spain, Luxembourg, the Netherlands and Switzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Manufacturers have at most **2 years** at the latest after the signature of the decree **to replace** the old calculation with the new one.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'பச்சை-ஸ்கோர்';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'கிரீன் ஸ்கோர் என்றால் என்ன?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score என்பது **உணவின் சுற்றுச்சூழல் தாக்கம்** பற்றி உங்களுக்குத் தெரிவிப்பதை நோக்கமாகக் கொண்ட ஒரு லோகோ ஆகும்.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      '**குறைந்த தாக்கத்தை ஏற்படுத்தும்** தயாரிப்புகளுக்கு வண்ணக் குறியீடு அடர் பச்சை (**A+**) இலிருந்து **மிகவும் தாக்கத்தை ஏற்படுத்தும்** தயாரிப்புகளுக்கு அடர் சிவப்பு (**F**) வரை மாறுபடும்.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score லோகோக்கள்';

  @override
  String get guide_greenscore_lca_title =>
      'அடிப்படை: வாழ்க்கைச் சுழற்சி மதிப்பீடு (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'உணவு வகைகளின் அறிவியல் மதிப்பீடு';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'ஒவ்வொரு தயாரிப்பு வகைக்கும், Agribalyse சுற்றுச்சூழல் தரவுத்தளத்திலிருந்து (ADEME மற்றும் INRAE ஆல் வடிவமைக்கப்பட்டது) தரவைப் பயன்படுத்தி ஒரு **பெஞ்ச்மார்க்** மதிப்பெண் நிறுவப்படுகிறது.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**வாழ்க்கைச் சுழற்சி பகுப்பாய்வு** என்பது பல-நிலை மற்றும் பல-அளவுகோல்களைக் கொண்ட சுற்றுச்சூழல் மதிப்பீட்டை மேற்கொள்வதற்கான ஒரு தரப்படுத்தப்பட்ட மதிப்பீட்டு முறையாகும்.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**இது அளவிடுகிறது:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 உற்பத்தி படிகள்';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Packaging';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 சுற்றுச்சூழல் தாக்க குறிகாட்டிகள்';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'காலநிலை மாற்றம்/கார்பன் தடம்';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'ஓசோன் படலக் குறைவு';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'அயனியாக்கும் கதிர்வீச்சு';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'நாடு';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'நீர் மற்றும் ஆற்றல் பயன்பாடு';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'காற்று மாசுபாடு';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'கடல் மற்றும் நன்னீர் (துகள்கள், அமிலமயமாக்கல், யூட்ரோஃபிகேஷன்)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'வளங்கள் குறைதல்.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'போனஸ் & அபராதங்கள்';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origin of ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Packaging';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'உற்பத்தியாளர்கள் எவ்வாறு உதவ முடியும்';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'உற்பத்தியாளர்கள் எங்கள் இலவச தயாரிப்பாளர் தளத்தின் மூலம் தங்கள் தகவல்களை நேரடியாக எங்களுக்கு அனுப்பலாம்.';

  @override
  String get guide_greenscore_better_product_title =>
      'எந்த தயாரிப்பு கிரகத்திற்கு சிறந்தது?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'சொல்ல கடினமாக இருக்கலாம்.';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      '**நமது உலகளாவிய உணவு முறை அனைத்து பசுமை இல்ல வாயு வெளியேற்றங்களிலும் கால் பங்கிற்கும் மேலாக பொறுப்பேற்பதால்**, நிலையான உணவைத் தேர்ந்தெடுப்பது காலநிலைக்கு நாம் செய்யக்கூடிய மிக சக்திவாய்ந்த விஷயங்களில் ஒன்றாகும்.\n(ஆதாரம்: பூரே & நெமெசெக், அறிவியல், 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title =>
      'உங்களிடம் சக்தி இருக்கிறது!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'நல்ல செய்தி என்னவென்றால், இது மாற்றத்தை உருவாக்க ஒரு சக்திவாய்ந்த வழியை நமக்கு வழங்குகிறது.\n**நாம் ஒவ்வொருவரும் ஒவ்வொரு வருடமும் சுமார் 1,000 உணவுகளை சாப்பிடுகிறோம்**. அது **இந்த கிரகத்திற்கு சிறந்த எதிர்காலத்தைத் தேர்ந்தெடுப்பதற்கான** 1,000 வாய்ப்புகள்!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'பொறுப்பாக இருந்து முடிவெடுக்க உதவுகிறது.';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'நிலையான உணவைத் தேர்ந்தெடுப்பது சிக்கலானதாகத் தோன்றலாம். லேபிள்கள் குழப்பமானவை, மேலும் தகவல்கள் பெரும்பாலும் காணாமல் போகின்றன. Green-Score அதை எளிமையாக்க உருவாக்கப்பட்டது, உங்களுக்குத் தேவையான இடத்தில்: நீங்கள் ஷாப்பிங் செய்யும் போது உணவுப் பொருட்களுக்கு **தெளிவான**, **அறிவியல் அடிப்படையிலான** மற்றும் **வெளிப்படையான** சுற்றுச்சூழல் மதிப்பீட்டை வழங்குகிறது.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'வெளிப்படைத்தன்மை';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'தனியுரிம லேபிள்களைப் போலன்றி, Green-Score கணக்கீடு **முற்றிலும் திறந்திருக்கும்** மற்றும் **எவராலும் சரிபார்க்கப்படலாம்**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'அல்ட்ரா-பிராசசிங் என்றால் என்ன?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'உணவு பதப்படுத்துதலின் அளவைப் பற்றி NOVA குழுக்கள் உங்களுக்குத் தெரிவிக்கின்றன.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      '**தொழில்துறை செயலாக்கத்தின்** (குறைந்தபட்ச பதப்படுத்தப்பட்ட அல்லது பதப்படுத்தப்படாத உணவுகள், சமையல் பொருட்கள், பதப்படுத்தப்பட்ட உணவுகள், தீவிர பதப்படுத்தப்பட்ட உணவுகள்) அடிப்படையில் உணவுகளை **4 குழுக்களாக** வகைப்படுத்த NOVA வகைப்பாடு அனுமதிக்கிறது.';

  @override
  String get guide_nova_logos_caption => 'NOVA லோகோக்கள்';

  @override
  String get guide_nova_groups_title => '4 NOVA குழுக்கள்';

  @override
  String get guide_nova_groups_intro =>
      '4 NOVA குழுக்கள் உள்ளன, அவற்றில் சிக்கலானது குழு 4 - அல்ட்ரா-பதப்படுத்தப்பட்ட உணவுகள்.';

  @override
  String get guide_nova_groups_arg1_title =>
      'குறைந்தபட்சமாக பதப்படுத்தப்பட்ட அல்லது பதப்படுத்தப்படாத உணவுகள்';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Processed culinary ingredients';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'அல்ட்ரா-பிராசசிங்கில் உள்ள சிக்கல்கள்';

  @override
  String get guide_nova_explanations_arg1_title =>
      'உணவுப் பொருட்களின் தீவிர செயலாக்கம்';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'தூய உணவுப் பாதுகாப்பைத் தாண்டிச் செல்லும் சேர்க்கைகள்';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'வீட்டிலேயே செய்ய முடியாத செயலாக்கம்';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'அல்ட்ரா-பிராசசிங்கின் கொள்ளையடிக்கும் மற்றும் நிதி அம்சங்கள்';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-ta.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ta.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ta.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ta.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'பார்கோடு அளவில் தயாரிப்பு விலைகளின் பெரிய தரவுத்தளங்களை வைத்திருக்கும் நிறுவனங்கள் தற்போது மிகக் குறைவு. இந்த விலைகள் இலவசமாகக் கிடைக்காது, ஆனால் தனியார் நிறுவனங்கள், ஆராய்ச்சியாளர்கள் மற்றும் அவற்றை வாங்கக்கூடிய பிற நிறுவனங்களுக்கு அதிக விலைக்கு விற்கப்படுகின்றன.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'நான் ஒரு சில்லறை விற்பனையாளர், விலைகளைப் பங்களிக்க விரும்புகிறேன். அதை நான் எப்படி செய்வது?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about பற்றி';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ta.openproductsfacts.org/discover பற்றிய தகவல்';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Preview';

  @override
  String get prices_feedback_form =>
      'இந்தப் புதிய அம்சத்தைப் பற்றிய உங்கள் கருத்தை எங்களுக்கு அனுப்ப இங்கே கிளிக் செய்யவும்!';

  @override
  String get menu_button_list_actions => 'Select an action';

  @override
  String get error_loading_photo => 'Error loading photo';

  @override
  String get photo_viewer_action_use_picture_as => 'Use as…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Use this picture as…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Use this picture as… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Details';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Details of this photo';

  @override
  String get photo_viewer_details_title => 'Details of the photo';

  @override
  String get photo_viewer_details_contributor_title => 'Contributor';

  @override
  String get photo_viewer_details_size_title => 'Size';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Date';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatible';

  @override
  String get user_lists_action_multi_select => 'Multi-select';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Your compatibility score: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Front picture';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Ingredients picture';

  @override
  String get product_image_nutrition_accessibility_label => 'Nutrition picture';

  @override
  String get product_image_packaging_accessibility_label => 'Packaging picture';

  @override
  String get product_image_other_accessibility_label => 'Other picture';

  @override
  String get product_image_outdated_message => 'This picture may be outdated';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (this image may be outdated)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (this image may be locked by the producer)';
  }

  @override
  String get product_image_error => 'Unable to load the image!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Unable to load the $type (network error?)';
  }

  @override
  String get product_page_image_no_image_available => 'No\nimage!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'No picture available for this product';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reorder or hide actions';

  @override
  String get product_page_action_bar_setting_modal_title => 'Edit actions';

  @override
  String get product_page_action_bar_item_move_up => 'Move up';

  @override
  String get product_page_action_bar_item_move_down => 'Move down';

  @override
  String get product_page_action_bar_item_enable => 'Enable action';

  @override
  String get product_page_action_bar_item_disable => 'Disable action';

  @override
  String get product_page_pending_operations_banner_title =>
      'உங்கள் திருத்தங்களைப் பதிவேற்றுகிறது…';

  @override
  String get product_page_pending_operations_banner_message =>
      'இந்தப் பக்கத்தில் காட்டப்படும் தரவு **உங்கள் மாற்றங்களை இன்னும் பிரதிபலிக்கவில்லை**.\nசில வினாடிகள் காத்திருக்கவும்…';

  @override
  String get product_add_a_language => 'Add a language';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Barcode $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Remove this product from the carousel';

  @override
  String get carousel_unsupported_header => 'Unsupported barcode!';

  @override
  String get carousel_unsupported_title => 'Ooops!';

  @override
  String get carousel_unsupported_text =>
      'The barcode scanned is not supported by Open Food Facts!';

  @override
  String get carousel_error_header => 'Error!';

  @override
  String get carousel_error_title => 'It\'s a bummer!';

  @override
  String get carousel_error_text_1 =>
      'We couldn\'t download information on this barcode:';

  @override
  String get carousel_error_text_2 =>
      'Please check your Internet connection or click this button:';

  @override
  String get carousel_error_button => 'மீண்டும் முயல்க';

  @override
  String get carousel_unknown_product_header => 'Unknown product';

  @override
  String get carousel_unknown_product_title =>
      'Congratulations!\nYou\'ve found __the rare gem!__';

  @override
  String get carousel_unknown_product_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get carousel_unknown_product_button => 'Add this product';

  @override
  String get carousel_loading_header => 'Loading information...';

  @override
  String get carousel_loading_title =>
      'You\'ve just scanned a product with the following barcode:';

  @override
  String get carousel_loading_text =>
      'We are searching for it in our database of more than **3 million products!**';

  @override
  String get product_type_subtitle_food => 'Vegetables, fruits, frozen food…';

  @override
  String get product_type_subtitle_beauty => 'Makeup, soaps, toothpastes…';

  @override
  String get product_type_subtitle_pet_food => 'Food for dogs, cats…';

  @override
  String get product_type_subtitle_product => 'Smartphones, furniture…';

  @override
  String get photo_field_front => 'Product photo';

  @override
  String get photo_field_ingredients => 'Ingredients photo';

  @override
  String get photo_field_nutrition => 'Nutrition photo';

  @override
  String get photo_field_packaging => 'Packaging information photo';

  @override
  String get photo_already_exists => 'This photo already exists';

  @override
  String get photo_missing => 'This photo is missing';

  @override
  String get date => 'Date';

  @override
  String get photo_rotate_left => 'Rotate left';

  @override
  String get photo_rotate_right => 'Rotate right';

  @override
  String get photo_undo_action => 'Undo the previous action';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location இன் உலக வரைபடம்';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap பங்களிப்பாளர்கள்';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Warning';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'இந்த Nutri-Score தொகுப்பில் உள்ள மதிப்பெண்ணிலிருந்து ஏன் வேறுபட்டது?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'இரண்டு சாத்தியமான விளக்கங்கள் உள்ளன:\nபொருட்களின் பட்டியல் மற்றும்/அல்லது ஊட்டச்சத்து உண்மைகள் புதுப்பித்த நிலையில் இல்லை.\n\nநியூட்ரி-ஸ்கோரின் (அல்லது V2) \"புதிய கணக்கீட்டை\" நாங்கள் வழங்குகிறோம். தொகுப்பில் \"புதிய கணக்கீடு\" என்ற பேனர் உள்ளதா எனச் சரிபார்க்கவும்.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'பொருட்களைச் சரிபார்க்கவும்';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'ஊட்டச்சத்து உண்மைகளைச் சரிபார்க்கவும்';

  @override
  String url_not_supported(String url) {
    return 'துரதிருஷ்டவசமாக, எங்களால் URL ஐ திறக்க முடியவில்லை:\n$url';
  }

  @override
  String get product_list_export => 'Export';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'பார்கோடைப் பார்க்கவும்';

  @override
  String get product_footer_action_barcode_short => 'பார்கோடு';

  @override
  String get product_footer_action_open_website => 'இணையதளத்தைத் திறக்கவும்';

  @override
  String get product_footer_action_report => 'அறிக்கை';

  @override
  String get product_footer_action_contributor_guide => 'உதவி';

  @override
  String get product_footer_action_data_quality_tags => 'தரவுகளின் தரம்';

  @override
  String get product_page_tab_for_me => 'எனக்காக';

  @override
  String get product_page_tab_website => 'Website';

  @override
  String get product_page_tab_prices => 'Prices';

  @override
  String get prices_explanation_card_title => 'ஏன் விலைகள்?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** என்பது உலகம் முழுவதும் உள்ள பொருட்களின் விலைகளைச் சேகரித்துப் பகிர்ந்து கொள்ளும் ஒரு திட்டமாகும் 🌍. Open Prices Open Food Facts உண்மைகளால் உருவாக்கப்பட்டு பராமரிக்கப்படுகின்றன.';

  @override
  String get explanation_card_learn_more_button => 'மேலும்அறிய';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'ஃபோக்சோனமியின் பண்புக்கூறுகள் என்ன?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'பண்புக்கூறுகள் **முக்கிய-மதிப்பு** அடிப்படையிலானவை.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'இந்தப் பண்புகள் பங்களிப்பாளர்களால் எந்தவொரு பயன்பாட்டிற்கும் உருவாக்கப்பட்டு தாக்கல் செய்யப்படுகின்றன.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'விலை எதுவும் கிடைக்கவில்லை.';

  @override
  String get prices_products_empty_explanation => 'முதலில் பங்களிக்கவும்!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize products (total: $total)';
  }

  @override
  String get app_review_title => 'Are you enjoying this app?';

  @override
  String get app_review_low => 'Could do better';

  @override
  String get app_review_medium => 'Not bad';

  @override
  String get app_review_high => 'I love it!';

  @override
  String get app_review_feedback_modal_title =>
      'Help us improve our application';

  @override
  String get app_review_feedback_modal_content =>
      'If you have a few minutes, could you answer this form so that **we can improve in future updates**:';

  @override
  String get app_review_feedback_modal_open_form => 'Answer the form';

  @override
  String get app_review_feedback_modal_later => 'Ask me later';

  @override
  String get nutrition_facts_extract_new =>
      'புதியது: படத்திலிருந்து ஊட்டச்சத்துக்களை நீங்கள் தானாகவே பிரித்தெடுக்கலாம்!';

  @override
  String get nutrition_facts_extract_button_text => 'இப்போது பிரித்தெடு';

  @override
  String get nutrition_facts_extract_in_progress =>
      'பிரித்தெடுக்கும் பணி நடந்து கொண்டிருக்கிறது…';

  @override
  String get nutrition_facts_extract_successful =>
      'பிரித்தெடுத்தல் வெற்றியடைந்தது';

  @override
  String get nutrition_facts_extract_failed =>
      'படத்திலிருந்து ஊட்டச்சத்துக்களைப் பிரித்தெடுக்க முடியவில்லை';

  @override
  String get prices_discount => 'தள்ளுபடி';

  @override
  String get prices_stats_statistics => 'Statistics';

  @override
  String get prices_stats_title => 'Prices Statistics';

  @override
  String get prices_stats_prices_section => 'Prices';

  @override
  String get prices_stats_products_section => 'Products';

  @override
  String get prices_stats_locations_section => 'இடங்கள்';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contributors';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Miscellaneous';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'ஒரு விலையுடன்';

  @override
  String get prices_stats_food => 'Food';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Products';

  @override
  String get prices_stats_pet_food => 'Pet food';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'ஆன்லைன்';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'Price tag';

  @override
  String get prices_stats_receipt => 'Receipt';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'சவால்கள்';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title =>
      'மூலத்திற்கான விலைகள் மற்றும் சான்றுகள்';

  @override
  String get prices_stats_website => 'Website';

  @override
  String get prices_stats_mobile_app => 'மொபைல் பயன்பாடு';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => 'Last updated on';

  @override
  String get prices_stats_error =>
      'An error occurred while loading statistics.';

  @override
  String get product_edit_robotoff_question_answered => 'Question answered!';

  @override
  String get product_edit_robotoff_proof => 'Proof';

  @override
  String get preferences_card_general => 'பொது';

  @override
  String get preferences_prices_title => 'Prices';

  @override
  String get preferences_prices_subtitle =>
      'உங்கள் விலை விருப்பங்களை நிர்வகிக்கவும்';

  @override
  String get preferences_card_project => 'திறந்த உணவு உண்மைகள் திட்டம்';

  @override
  String get preferences_contribute_title => 'Contribute';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'எனது புள்ளிவிவரங்கள்';

  @override
  String get preferences_contribute_subtitle =>
      'மொழிபெயர்க்கவும், எங்கள் கருவிகளை மேம்படுத்தவும்…';

  @override
  String get preferences_connect_title => 'இணைக்கவும்';

  @override
  String get preferences_connect_subtitle =>
      'எங்களைத் தொடர்பு கொள்ளுங்கள் அல்லது சமூக ஊடகங்களில் எங்களைப் பின்தொடருங்கள்';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'உலகெங்கிலும் உள்ள மில்லியன் கணக்கான நுகர்வோருக்குத் தெரிவிக்க எங்களுக்கு உதவுங்கள்.';

  @override
  String get preferences_card_help => 'உதவி & ஆதரவு';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle =>
      'உங்கள் கேள்விகளுக்கான பதில்களைப் பெறுங்கள்';

  @override
  String get logged_out => 'வெளியேறிவிட்டார்';

  @override
  String get preferences_app_bar_message =>
      'எங்கள் உறுப்பினர்களில் ஒருவராக இருப்பதற்கு நன்றி!';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'விலைகள் சேர்க்கப்பட்டன';

  @override
  String get preferences_app_bar_see_all_stats =>
      'எல்லா புள்ளிவிவரங்களையும் காண்க';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '\"$keyword\" -ஐ $provider -ல் தேடவும்.';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'ஒரு அமைப்பைத் தேடுங்கள் (எ.கா. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'அணுகல்தன்மை: ஈமோஜியைக் காட்டு';

  @override
  String get preferences_accessibility_remove_colors =>
      'அணுகல்தன்மை: வண்ணங்களை அகற்று';

  @override
  String get preferences_app_settings_products => 'Products';

  @override
  String get preferences_card_about => 'இதைப் பற்றி';

  @override
  String get preferences_legal_information_title => 'சட்ட தகவல்';

  @override
  String get preferences_legal_information_subtitle =>
      'பயன்பாட்டு விதிமுறைகள், தனியுரிமைக் கொள்கை மற்றும் பல';

  @override
  String get preferences_terms_of_use => 'Terms of use';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் என்பது அனைவராலும், அனைவருக்கும்** உருவாக்கப்பட்ட உணவுப் பொருட்களின் தரவுத்தளமாகும்.\nசிறந்த உணவுத் தேர்வுகளைச் செய்ய நீங்கள் இதைப் பயன்படுத்தலாம், மேலும் இது **திறந்த தரவு** என்பதால், யார் வேண்டுமானாலும் எந்த நோக்கத்திற்காகவும் இதை மீண்டும் பயன்படுத்தலாம்**.';

  @override
  String get preferences_privacy_policy => 'Privacy policy';

  @override
  String get preferences_licenses => 'உரிமங்கள்';

  @override
  String get preferences_about_app_title => 'பயன்பாட்டைப் பற்றி';

  @override
  String get preferences_about_app_subtitle =>
      'தொழில்நுட்பத் தகவல், டெவலப்பர் தகவல் மற்றும் பல';

  @override
  String get preferences_card_information => 'தகவல்';

  @override
  String get preferences_version_number_title => 'பதிப்பு எண்';

  @override
  String get preferences_scanner_title => 'ஸ்கேனர்';

  @override
  String get preferences_app_store => 'ஆப் ஸ்டோர்';

  @override
  String get preferences_app_system_settings => 'கணினி அமைப்புகள்';

  @override
  String get preferences_source_code => 'மூலக் குறியீட்டை அணுகவும்';

  @override
  String get preferences_source_code_subtitle =>
      'மில்லியன் கணக்கானவர்களுக்கு ஒரு தாக்கத்தை ஏற்படுத்தத் தொடங்குங்கள்.';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'முழுமையான தயாரிப்புகள்';

  @override
  String get preferences_tips => 'குறிப்புகள்';

  @override
  String get tips_discover_nutriscore => 'புதிய நியூட்ரி-ஸ்கோரைக் கண்டறியவும்';

  @override
  String get preferences_on_off_website_subtitle =>
      'ஓபன் ஃபுட் ஃபேக்ட்ஸ் வலைத்தளத்தில்';

  @override
  String get preferences_manage_account_title => 'எனது கணக்கை நிர்வகிக்கவும்';

  @override
  String get preferences_manage_account_tooltip =>
      'உங்கள் கணக்கை நிர்வகிக்கவும்';

  @override
  String get preferences_change_password_title => 'எனது கடவுச்சொல்லை மாற்று';

  @override
  String get preferences_danger_zone => 'ஆபத்து மண்டலம்';

  @override
  String get preferences_account_deletion_subtitle =>
      'உங்கள் பங்களிப்புகள் அனைத்தும் இழக்கப்படும்.';

  @override
  String get preferences_contributions_title => 'Contributions';

  @override
  String get preferences_dev_mode_app_settings_title => 'பயன்பாட்டு அமைப்புகள்';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'தயாரிப்புகளை ஆஃப்லைனில் ஸ்கேன் செய்வதற்கான மிகவும் சோதனை வழி';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'சேவையகத்திலிருந்து அனைத்து தயாரிப்புகளையும் புதுப்பிக்கவும்.';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'மிகவும் அவசியமானால் தவிர, தயவுசெய்து அதைச் செய்வதைத் தவிர்க்கவும்.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'டெமோ பயன்முறை';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'ஸ்கேனரில் கார்டுகளைச் சேர்க்கவும்';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'ஸ்கேனரில் 3 மாதிரி தயாரிப்புகளைச் சேர்க்கிறது.';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'ஃபோக்சோனமி ஹோஸ்ட்';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'தொகுப்பாளர்: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'அணுகல்தன்மை பரிசோதனைகள்';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'விலைகளுக்கு ஏற்ப பல தயாரிப்புகளின் தேர்வு';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'பயனர் ஆர்டர் செய்த தகவல் பலகைகள்';

  @override
  String get preferences_dev_mode_location_search_title =>
      'இருப்பிடத் தேடலுக்கான தற்காலிக அணுகல்';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 அல்லது 3 தயாரிப்புகளுக்கான பக்கவாட்டு ஒப்பீடு';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'தயாரிப்பு பட்டியல் இறக்குமதி';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'மதிப்பெண்கள் & வழிமுறைகள்';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Nutri-Score எவ்வாறு கணக்கிடப்படுகிறது என்பதைக் கண்டறியவும்.';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'முறைமையில் ஏற்பட்ட முக்கிய மாற்றங்களைக் கண்டறியவும்.';

  @override
  String get preferences_faq_discover_project_title => 'Discover the project';

  @override
  String get preferences_faq_discover_off_title =>
      'Open Food Facts உண்மைகளைக் கண்டறியவும்';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title =>
      'அடிக்கடி கேட்கப்படும் கேள்விகள் - அடிக்கடி கேட்கப்படும் கேள்விகள்';

  @override
  String get preferences_faq_off_ngo_title =>
      'Open Food Facts அரசு சாரா நிறுவனம்';

  @override
  String get preferences_about_information_title => 'தகவல்';

  @override
  String get preferences_connect_community_updates_title =>
      'சமூக புதுப்பிப்புகளைப் பெறுங்கள்';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'பயன்பாடு மற்றும் சமூக செய்திகளுடன் இணைந்திருங்கள்.';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscribe to our community calendar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'எங்கள் மெய்நிகர் நிகழ்வுகளில் ஒன்றில் கலந்துகொள்வதன் மூலம் ஈடுபடுங்கள்.';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts வலைப்பதிவு';

  @override
  String get preferences_connect_blog_subtitle =>
      'சமீபத்திய செய்திகளை அவை நடக்கும்போதே பெறுங்கள்';

  @override
  String get preferences_connect_community_help_title =>
      'சமூகத்திடமிருந்து உதவி பெறுங்கள்';

  @override
  String get preferences_connect_improve_app_title =>
      'பயன்பாட்டை மேம்படுத்த எங்களுக்கு உதவுங்கள்.';

  @override
  String get preferences_connect_debug_info_title =>
      'பிழைத்திருத்த தகவலை எங்களுக்கு அனுப்புங்கள்.';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'விரிவான பிழைத்திருத்த தகவலுடன் எங்களுக்கு ஒரு மின்னஞ்சல் அனுப்புங்கள்.';

  @override
  String get preferences_connect_feedback_title =>
      'பயன்பாட்டைப் பற்றிய உங்கள் கருத்துக்களை எங்களுக்கு அனுப்புங்கள்.';

  @override
  String get preferences_connect_feedback_subtitle =>
      'பயன்பாட்டின் எதிர்காலத்தை வடிவமைக்க உதவுங்கள்.';

  @override
  String get preferences_connect_survey_title =>
      'பயன்பாட்டு கணக்கெடுப்பில் பங்கேற்கவும்';

  @override
  String get preferences_connect_survey_subtitle =>
      'அடுத்து என்ன கட்ட வேண்டும் என்பதைப் புரிந்துகொள்ள உதவுங்கள்.';

  @override
  String get preferences_connect_professionals_title => 'வல்லுநர்கள்';

  @override
  String get preferences_connect_pro_subtitle =>
      'முற்றிலும் இலவசம், 500 பயன்பாடுகள் மற்றும் மில்லியன் கணக்கான நுகர்வோருக்கு துல்லியமான தரவை உறுதி செய்கிறது. சுய சேவை, உங்கள் PIM அல்லது விரிதாள்களுடன் (XLSX) இணக்கமானது.';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'தொடங்குவதற்கு தொடர்பு கொள்ளவும்.';

  @override
  String get preferences_connect_press_title => 'Press';

  @override
  String get preferences_connect_press_page_subtitle =>
      'உங்கள் அறிக்கைக்குத் தேவையான அனைத்துப் பொருட்களையும் பெறுங்கள்.';

  @override
  String get preferences_connect_press_email_subtitle =>
      'பத்திரிகை விசாரணைகளுக்கு அல்லது உங்கள் அறிக்கையைப் பற்றி எங்களுக்குத் தெரிவிக்க தொடர்பு கொள்ளவும்.';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'ஒரு செயலில் தன்னார்வலராகுங்கள்';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'மேம்பாடு, தொடர்பு, வடிவமைப்பு… எந்த வகையான தன்னார்வத் தொண்டு அல்லது நிபுணத்துவமும் வரவேற்கப்படுகிறது!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'நீங்கள் பங்களிக்கக்கூடிய பல வழிகளில் சிலவற்றைக் கண்டறியவும்.';

  @override
  String get preferences_contribute_mobile_dev_title => 'மொபைல் செயலி மேம்பாடு';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'மென்பொருள் மேம்பாட்டிற்கு எவ்வாறு பங்களிப்பது என்பதை அறிக.';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'தினசரி நிலையற்ற உருவாக்கங்கள், புத்தம் புதிய அம்சங்கள்';

  @override
  String get preferences_contribute_local_community_title =>
      'உங்கள் உள்ளூர் சமூகத்தை வளர்க்கவும்.';

  @override
  String get preferences_contribute_translate_subtitle =>
      'மென்பொருள், உள்ளடக்கங்கள், மூலப்பொருள் பகுப்பாய்வு மொழிபெயர்ப்புகளுக்கு உதவி.';

  @override
  String get preferences_contribute_share_subtitle =>
      'உங்களுக்கு உதவ ஒரு சிறிய டெம்ப்ளேட்டை நாங்கள் தயார் செய்துள்ளோம் :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'உங்கள் நாட்டில் உணவு வெளிப்படைத்தன்மையை வளர்ப்பதற்கான எளிய வழிமுறைகள்.';

  @override
  String get preferences_contribute_data_quality_title => 'தரவுகளின் தரம்';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'தரவு தரக் குழுவில் சேருங்கள்';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'தரவுத்தளம் முழுமையாகவும் துல்லியமாகவும் இருப்பதை உறுதிசெய்ய எங்கள் முயற்சியில் சேருங்கள்.';

  @override
  String get preferences_contributions_products_added_title =>
      'சேர்க்கப்பட்ட தயாரிப்புகள்';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Open Food Facts உண்மைகளில் நான் சேர்த்த புதிய தயாரிப்புகள்';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'நான் முடிக்க வேண்டிய தயாரிப்புகள்';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'முழுமையற்ற அனைத்து தயாரிப்புகளும்';

  @override
  String get preferences_my_contributions_prices_title => 'Prices';

  @override
  String get preferences_my_contributions_my_prices_title => 'எனது விலைகள்';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'என்னுடைய விலைகள், என்னுடைய சான்றுகள்…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'நீங்கள் முடிக்க உதவும் தயாரிப்புகள்';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'உங்கள் நாட்டில் Nutri-Score & கிரீன்-ஸ்கோரைக் கணக்கிட உதவுங்கள்.';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'நான் பங்களித்த விலைகள்';

  @override
  String get preferences_prices_proofs_subtitle =>
      'விலைக் குறிச்சொற்கள் மற்றும் ரசீதுகள்';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'உங்கள் ரசீதுகளின் புகைப்படங்களை எடுத்து தொடர்புடைய பார்கோடுகளை ஸ்கேன் செய்யுங்கள்.';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'ஒரு கடையில் விலைகளின் புகைப்படங்களை எடுத்துக் கொள்ளுங்கள்.';

  @override
  String get preferences_prices_newest_title => 'புதிய விலைகள்';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Prices சமூகத்தால் சேர்க்கப்பட்ட சமீபத்திய விலைகள்';

  @override
  String get preferences_prices_top_contributors_title =>
      'அதிக விலைகளைக் கொண்ட பங்களிப்பாளர்கள்';

  @override
  String get preferences_prices_metrics_title => 'திறந்த விலை அளவீடுகள்';

  @override
  String get preferences_prices_metrics_subtitle =>
      'திட்டத்தின் பரிணாம வளர்ச்சியைப் பின்பற்றுங்கள்';

  @override
  String get preferences_prices_ways_contribute_title =>
      'பங்களிப்பதற்கான வழிகள்';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'AI உதவியுடன், நீங்களோ அல்லது மற்றவர்களோ சேர்த்த விலைகளை உறுதிப்படுத்தவும்.';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'உங்கள் கேமரா ரோலில் இருந்து பல ரசீதுகள் அல்லது அலமாரிகளின் புகைப்படங்களை விரைவாகச் சேர்க்கவும்';

  @override
  String get preferences_prices_challenges_title => 'மாதாந்திர சவால்கள்';

  @override
  String get preferences_prices_challenges_subtitle =>
      'விலைகளைச் சேகரிக்க மாதாந்திர கருப்பொருள் தேடல்களில் பங்கேற்கவும்';

  @override
  String get preferences_prices_loyalty_data_title =>
      'உங்கள் விசுவாசத் தரவை மீட்டெடுக்கவும்';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'உங்கள் தரவை எவ்வாறு கோருவது என்பதை அறிக.';

  @override
  String get preferences_page_customize_app_title =>
      'பயன்பாட்டைத் தனிப்பயனாக்குங்கள்';

  @override
  String get preferences_page_contribute_project_title =>
      'திட்டத்திற்கு பங்களிக்கவும்';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Factsக்க உதவும் எளிய வழிகள்';

  @override
  String get preferences_page_faq_subtitle =>
      'திட்டத்தைப் பற்றிய மதிப்பெண் முறைகள், உதவி மற்றும் பல.';

  @override
  String get product_edit_robotoff_positive_button => 'பரிந்துரையை ஏற்கிறேன்';

  @override
  String get product_edit_robotoff_negative_button => 'பரிந்துரையை நிராகரி';

  @override
  String get product_edit_robotoff_show_proof => 'ஆதாரம் காட்டு.';

  @override
  String get product_edit_robotoff_expand_proof => 'ஆதாரத்தை விரிவாக்கு';

  @override
  String get product_page_tab_raw_data => 'மூல தரவு';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'பக்கம் $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'பக்கம் $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count / $total பொருட்கள்';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count / $total பொருட்கள்';
  }

  @override
  String item_count(int count) {
    return '$count பொருட்கள்';
  }

  @override
  String item_count_string(String count) {
    return '$count பொருட்கள்';
  }

  @override
  String get prices_no_result => 'விலை புள்ளிவிவரங்கள் எதுவும் கிடைக்கவில்லை.';

  @override
  String get prices_error_loading_more_items =>
      'கூடுதல் உருப்படிகளை ஏற்றுவதில் பிழை';

  @override
  String get prices_proof_error =>
      'அங்கீகாரம் தோல்வியடைந்தது, சான்றுகளைப் பெற முடியவில்லை.';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count / $total சான்றுகள்';
  }

  @override
  String proof_count(int count) {
    return '$count சான்றுகள்';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$total பங்களிப்பாளர்களில் $count';
  }

  @override
  String contributors_count(int count) {
    return '$count பங்களிப்பாளர்கள்';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$total இடங்களில் $count';
  }

  @override
  String prices_locations_count(int count) {
    return '$count இடங்கள்';
  }

  @override
  String get restart_to_apply_message =>
      'மாற்றங்களைப் பயன்படுத்த பயன்பாட்டை மறுதொடக்கம் செய்யவும்.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'வரைகலை இடைமுகம்';

  @override
  String get preferences_app_settings_media_title => 'ஊடகம்';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts ஆய்வகங்கள்';

  @override
  String get preferences_root_account_title => 'Account';

  @override
  String get preferences_contribute_translate_header =>
      'Open Food Facts உண்மைகளை உங்கள் மொழியில் கொண்டு வாருங்கள்.';

  @override
  String get preferences_contribute_enroll_alpha =>
      'பயன்பாட்டின் ஆல்பா பதிப்பில் பதிவுசெய்யவும்';

  @override
  String get preferences_dev_mode_section_data =>
      'பங்களிப்புகள் & தயாரிப்பு தரவு';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'ஃபோக்சோனமியைக் காட்டாதே';

  @override
  String get preferences_account_title => 'Account';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '$createdஇல் சேர்க்கப்பட்டது';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Name';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
