// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Slovenian (`sl`).
class AppLocalizationsSl extends AppLocalizations {
  AppLocalizationsSl([String locale = 'sl']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Da';

  @override
  String get add => 'Dodaj';

  @override
  String get account_delete_message =>
      'Ali ste prepričani, da želite izbrisati svoj račun?\nČe obstaja poseben razlog, ga prosim delite spodaj.';

  @override
  String get reason => 'Razlog';

  @override
  String get okay => 'V redu';

  @override
  String get validate => 'Validate';

  @override
  String get create => 'Ustvari';

  @override
  String get applyButtonText => 'Uporabi';

  @override
  String get next_label => 'Naprej';

  @override
  String get continue_label => 'Nadaljuj';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => 'Prejšnji';

  @override
  String get go_back_to_top => 'Nazaj na vrh';

  @override
  String get save => 'Shrani';

  @override
  String get save_confirmation => 'Ali ste prepričani, da želite shraniti?';

  @override
  String get skip => 'Skip';

  @override
  String get cancel => 'Prekliči';

  @override
  String get ignore => 'Prezri';

  @override
  String get close => 'Zapri';

  @override
  String get no => 'Ne';

  @override
  String get stop => 'Ustavi';

  @override
  String get finish => 'Končaj';

  @override
  String get calculate => 'Izračunaj';

  @override
  String get reset_food_prefs => 'Ponastavi nastavitve';

  @override
  String get error => 'Nekaj je šlo narobe';

  @override
  String get error_occurred => 'Prišlo je do napake';

  @override
  String get featureInProgress => 'Fukcija v obdelavi';

  @override
  String get label_web => 'Ogled na spletu';

  @override
  String get learnMore => 'Več o tem';

  @override
  String get unknown => 'Neznano';

  @override
  String get match_very_good => 'Zelo dobro ujemanje';

  @override
  String get match_good => 'Dobro ujemanje';

  @override
  String get match_poor => 'Slabo ujemanje';

  @override
  String get match_may_not => 'Morda se ne ujema';

  @override
  String get match_does_not => 'Se ne ujema';

  @override
  String get match_unknown => 'Ujemanje neznano';

  @override
  String get match_short_very_good => 'Zelo dobro ujemanje';

  @override
  String get match_short_good => 'Dobro ujemanje';

  @override
  String get match_short_poor => 'Slabo ujemanje';

  @override
  String get match_short_may_not => 'Morda se ne ujema';

  @override
  String get match_short_does_not => 'Se ne ujema';

  @override
  String get match_short_unknown => 'Ujemanje neznano';

  @override
  String get licenses => 'Licence';

  @override
  String get looking_for => 'Iskanje';

  @override
  String get welcomeToOpenFoodFacts => 'Dobrodošli v Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts je globalna neprofitna organizacija, ki jo poganjajo lokalne skupnosti.';

  @override
  String get productDataUtility =>
      'Oglejte si podatke o živilih, ki ustrezajo vašim željam.';

  @override
  String get healthCardUtility => 'Izberite hrano, ki so dobra za vas.';

  @override
  String get ecoCardUtility => 'Izberite živila, ki so dobra za svet.';

  @override
  String get server_error_open_new_issue =>
      'Strežnik se ne odziva! Naslednjo povezavo lahko odprete z zahtevo.';

  @override
  String get sign_in_text =>
      'Prijavite se v svoj račun Open Food Facts, da shranite svoje prispevke.';

  @override
  String get incorrect_credentials => 'Napačno uporabniško ime ali geslo.';

  @override
  String get password_lost_incorrect_credentials =>
      'Ta e-poštni naslov ali uporabniško ime ne obstaja. Preverite svoje poverilnice.';

  @override
  String get password_lost_server_unavailable =>
      'Trenutno prihaja do upočasnitev delovanja naših strežnikov in se za to opravičujemo. Poskusite znova pozneje.';

  @override
  String get login => 'Uporabniško ime';

  @override
  String get login_result_type_server_unreachable => 'Omrežje ni dosegljivo';

  @override
  String get login_result_type_server_issue =>
      'Težava na strežniku. Poskusite pozneje.';

  @override
  String get login_page_username_or_email =>
      'Prosimo vnesite uporabniško ime ali elektronski naslov';

  @override
  String get login_page_password_error_empty => 'Prosimo vnesite geslo';

  @override
  String get create_account => 'Ustvarite račun';

  @override
  String get sign_in => 'Vpis';

  @override
  String get sign_in_mandatory => 'Za to funkcijo se morate prijaviti.';

  @override
  String get help_improve_country =>
      'Pomagajte izboljšati Open Food Facts v vaši državi';

  @override
  String get sign_out => 'Odjava';

  @override
  String get sign_out_confirmation =>
      'Ali ste prepričani, da se želite odjaviti?';

  @override
  String get password => 'Geslo';

  @override
  String get forgot_password => 'Pozabljeno geslo';

  @override
  String get forgot_password_question => 'Ste pozabili geslo?';

  @override
  String get view_profile => 'Ogled profila';

  @override
  String get reset_password => 'Ponastavi geslo';

  @override
  String get reset_password_explanation_text =>
      'V primeru, da ste pozabili geslo vnesite svoje uporabniško ime ali elektronski naslov in sledite nadaljnjim navodilom. Prav tako ne pozabite preverit vsiljeno pošto.';

  @override
  String get username_or_email => 'Uporabniško ime ali elektronski naslov';

  @override
  String get reset_password_done =>
      'Poslali smo vam elektronsko sporočilo s povezavo za ponastavitev vašega gesla. Preverite tudi ali ste morda sporočilo prejeli med vsiljeno pošto';

  @override
  String get send_reset_password_mail => 'Spremeni geslo';

  @override
  String get enter_some_text => 'Vnesi besedilo';

  @override
  String get sign_up_page_title => 'Registracija';

  @override
  String get sign_up_page_action_button => 'Registracija';

  @override
  String get sign_up_page_action_doing_it => 'Prijava…';

  @override
  String get sign_up_page_action_ok => 'Čestitamo! Vaš račun je bil ustvarjen.';

  @override
  String get sign_up_page_display_name_hint => 'Ime';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Prosimo vnesite ime, ki ga želite prikazati';

  @override
  String get sign_up_page_email_hint => 'Elektronski naslov';

  @override
  String get sign_up_page_email_error_empty => 'Elektronski naslov je obvezen';

  @override
  String get sign_up_page_email_error_invalid =>
      'Neveljaven elektronski naslov';

  @override
  String get sign_up_page_username_hint => 'Uporabniško ime: Javno';

  @override
  String get sign_up_page_username_error_empty => 'Vnesite uporabniško ime';

  @override
  String get sign_up_page_username_error_invalid =>
      'Prosimo vnesite veljavno uporabniško ime';

  @override
  String get sign_up_page_username_description =>
      'Uporabniško ime ne sme vsebovati presledkov, velikih črk ali posebnih znakov.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Uporabniško ime ne sme presegati $value znakov';
  }

  @override
  String get sign_up_page_password_hint => 'Geslo';

  @override
  String get sign_up_page_password_error_empty => 'Prosimo vnesite geslo';

  @override
  String get sign_up_page_password_error_invalid =>
      'Prosimo vnesite veljavno geslo (vsaj 6 znakov)';

  @override
  String get sign_up_page_confirm_password_hint => 'Potrditev gesla';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Prosimo potrdite geslo';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Vneseni gesli se ne ujemata';

  @override
  String get sign_up_page_agree_text =>
      'Strinjam se z odprtimi dejstvi o hrani';

  @override
  String get sign_up_page_terms_text => 'pogoji uporabe in prispevki';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Ob registraciji je potrditev pogojev obvezna, kljub temu je anonimne prispevke mogoče oddati preko aplikacije';

  @override
  String get sign_up_page_producer_checkbox => 'Sem proizvajalec hrane';

  @override
  String get sign_up_page_producer_hint => 'Proizvajalec/blagovna Znamka';

  @override
  String get sign_up_page_producer_error_empty =>
      'Prosimo vnesite proizvajalca ali blagovno znamko';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Želim se naročiti na novice Open Food Facts (Od njih se lahko kadar koli odjavite)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Uporabniško ime že obstaja, izberite drugo uporabniško ime.';

  @override
  String get sign_up_page_email_already_exists =>
      'že obstaja, prijavite se v račun ali poskusite z drugim e-poštnim naslovom.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Prosimo, navedite veljaven e-poštni naslov.';

  @override
  String get sign_up_page_server_busy =>
      'Žal nam je, imamo tehnične težave pri ustvarjanju vašega računa. Poskusite znova pozneje.';

  @override
  String get settingsTitle => 'Nastavitve';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Temno';

  @override
  String get darkmode_light => 'Svetlo';

  @override
  String get darkmode_system_default => 'Sistemsko privzeto';

  @override
  String get thanks_for_contributing => 'Hvala za prispevek!';

  @override
  String get contributors_label => 'Gradijo aplikacijo';

  @override
  String get contributors_dialog_title => 'Sodelavci';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Sodelavec: $name';
  }

  @override
  String get contributors_description => 'Seznam vseh sodelavcev te aplikacije';

  @override
  String get support => 'Podpora';

  @override
  String get support_join_slack => 'Za pomoč vprašajte na našem Slack kanalu';

  @override
  String get support_via_forum => 'Prosite za pomoč na našem forumu';

  @override
  String get support_via_email => 'Pošljite nam elektronsko sporočilo';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Pošlji dnevnike aplikacij?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Ali želite v prilogo k e-poštnemu sporočilu vključiti dnevnike aplikacij?';

  @override
  String get termsOfUse => 'Pogoji uporabe';

  @override
  String get legalNotices => 'Pravna obvestila';

  @override
  String get privacy_policy => 'Pravilnik o zasebnosti';

  @override
  String get about_this_app => 'O tej aplikaciji';

  @override
  String get contribute => 'Prispevaj';

  @override
  String get contribute_sw_development => 'Razvoj programske opreme';

  @override
  String get contribute_develop_text =>
      'Koda za vsak izdelek Open Food Facts je na voljo na GitHubu. Kodo lahko ponovno uporabite (je odprtokodna) in nam pomagate izboljšati jo za vse na planetu.';

  @override
  String get contribute_develop_text_2 =>
      'Lahko se pridružite klepetalnici Open Food Facts Slack, kar je najprimernejši način za postavljanje vprašanj.';

  @override
  String get contribute_develop_dev_mode_title => 'Razvojni način?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktivirajte način DEV';

  @override
  String get contribute_donate_title => 'Prispevaj';

  @override
  String get contribute_donate_header => 'Donirajte Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Prosimo, upoštevajte, da je z interno alfa različico možna popolna izguba podatkov in da aplikacija lahko kadar koli postane neuporabna!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Izdelki, ki jih je potrebno dokončati';

  @override
  String get contribute_improve_header => 'Izboljšanje';

  @override
  String get contribute_improve_text =>
      'Podatkovna baza je jedro projekta. Pomagati je enostavno in zelo hitro. Prenesete lahko mobilno aplikacijo za svoj telefon in začnete dodajati ali izboljševati izdelke.\n\nPo drugi strani pa spletna stran Open Food Facts ponuja veliko načinov za prispevanje: ';

  @override
  String get contribute_translate_header => 'Prevedi';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Začni prevajati';

  @override
  String get contribute_translate_text =>
      'Open Food Facts je globalni projekt, ki združuje izdelke iz več kot 160 držav. Open Food Facts je preveden v številne jezike, njegova vsebina pa se nenehno razvija.';

  @override
  String get contribute_translate_text_2 =>
      'Prevodi so ena ključnih nalog projekta';

  @override
  String get contribute_join_skill_pool =>
      'Prispevajte svoje znanje k Open Food Facts. Pridružite se skupini znanj in spretnosti!';

  @override
  String get contribute_share_header =>
      'Delite odprta dejstva o hrani s prijatelji';

  @override
  String get contribute_share_content =>
      'Želel sem vas obvestiti o aplikaciji, ki jo uporabljam, Open Food Facts. S to aplikacijo lahko na personaliziran način pridobite informacije o vplivu vaše hrane na zdravje in okolje. Deluje tako, da skenira črtne kode na embalaži. Nenazadnje je brezplačna, ne zahteva registracije in lahko celo pomagate povečati število dešifriranih izdelkov. Tukaj je povezava za prenos na vaš telefon: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Prispevajte k cenam tako, da zahtevate izvoz podatkov o vaših karticah zvestobe v skladu z GDPR';

  @override
  String get tap_to_answer => 'Kliknite tukaj, da odgovorite na vprašanja';

  @override
  String get tap_to_answer_hint =>
      'Dotaknite se tukaj, če želite odgovoriti na vprašanja o tem izdelku';

  @override
  String get robotoff_questions_loading_hint =>
      'Prosimo, počakajte, da se naložijo vprašanja o tem izdelku.';

  @override
  String get saving_answer => 'Shranjevanje vašega odgovora';

  @override
  String get contribute_to_get_rewards =>
      'Postanite udeleženec preglednosti hrane';

  @override
  String get question_sign_in_text =>
      'Prijavite se v svoj račun Open Food Facts, da prejmete zasluge za svoje prispevke.';

  @override
  String get question_yes_button_accessibility_value => 'Odgovorite z da';

  @override
  String get question_no_button_accessibility_value => 'Odgovori z ne';

  @override
  String get question_skip_button_accessibility_value =>
      'Preskoči to vprašanje';

  @override
  String get tap_to_edit_search => 'Dotaknite se za urejanje iskanja';

  @override
  String get myPreferences => 'Moje nastavitve';

  @override
  String get account_create_message =>
      'Ustvarite svoj račun in se pridružite skupnosti Open Food Facts, da bi pomagali graditi znanje o hrani po vsem svetu!';

  @override
  String get join_us => 'Pridružite se nam';

  @override
  String get myPreferences_profile_title => 'Vaš profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Upravljajte svoj račun za sodelavce na Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Nastavitve aplikacije';

  @override
  String get myPreferences_settings_subtitle => 'Temni način, Jeziki…';

  @override
  String get myPreferences_food_title => 'Najljubša hrana';

  @override
  String get myPreferences_food_subtitle =>
      'Izberite katere informacije o hrani so vam najbolj pomembne.';

  @override
  String get myPreferences_food_comment =>
      'Izberite, katere informacije o hrani so vam najpomembnejše, da boste hrano razvrstili glede na svoje preference, si ogledali informacije, ki vas najprej zanimajo, in dobili povzetek združljivosti. Te preference glede hrane ostanejo v vaši napravi in niso povezane z vašim računom za sodelavce Open Food Facts, če ga imate.';

  @override
  String get confirmResetPreferences => 'Ponastavitev preferenc o izdelkih?';

  @override
  String get myPersonalizedRanking => 'Moja prilagojena razvrstitev';

  @override
  String get ranking_tab_all => 'All';

  @override
  String get ranking_subtitle_match_yes => 'Odlično ujemanje za vas';

  @override
  String get ranking_subtitle_match_no => 'Slabo ujemanje';

  @override
  String get ranking_subtitle_match_maybe => 'Ujemanje neznano';

  @override
  String get refresh_with_new_preferences =>
      'Osvežite seznam z novimi nastavitvami';

  @override
  String get reloaded_with_new_preferences =>
      'Ponovno naloži z novimi nastavitvami';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Preberi';

  @override
  String get history_navbar_label => 'Zgodovina';

  @override
  String get list_navbar_label => 'Seznam';

  @override
  String get category => 'Filtriraj po kategorijah';

  @override
  String get category_all => 'All';

  @override
  String get category_search => '(iskanje po kategorijah)';

  @override
  String get filter => 'Filter';

  @override
  String get scan => 'Izdelki z zaslona za skeniranje';

  @override
  String get scan_history => 'Zgodovina skeniranja';

  @override
  String get search => 'Iskanje';

  @override
  String get search_product_help =>
      'Išči izdelek,\nblagovno znamko ali črtno kodo';

  @override
  String get search_filter => 'Iskalni filter';

  @override
  String get search_history => 'Zgodovina iskanja';

  @override
  String get search_store => 'Iskanje trgovine';

  @override
  String get search_store_help => 'Namig: dodajte mesto ali državo';

  @override
  String get tap_for_more => 'Dotaknite se za več informacij…';

  @override
  String get product => 'Izdelek';

  @override
  String get unknownBrand => 'Neznana znamka';

  @override
  String get unknownProductName => 'Neznano ime izdelka';

  @override
  String get label_refresh => 'Osveži';

  @override
  String get label_reload => 'Ponovno naloži';

  @override
  String get image => 'Slika';

  @override
  String get front_photo => 'Sprednja fotografija';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (ta slika je morda zastarela)';
  }

  @override
  String get outdated_image_short_label => 'morda zastarelo';

  @override
  String get ingredients => 'Sestavine';

  @override
  String get ingredients_editing_instructions =>
      'Obdržite prvotni vrstni red. Navedite odstotek, kjer je določen. Ločite z vejico ali vezajem in uporabite oklepaje za sestavine sestavine.';

  @override
  String get ingredients_editing_error => 'Sestavin ni mogoče shraniti.';

  @override
  String get ingredients_editing_image_error =>
      'Slike sestavin ni bilo mogoče shraniti.';

  @override
  String get ingredients_editing_title => 'Uredite sestavine';

  @override
  String get ingredients_photo => 'Slike sestavin';

  @override
  String get packaging_editing_instructions =>
      'Navedite vse dele embalaže, ločene z vejico ali premikom v novo vrstico, z njihovo količino (npr. 1 ali 6), vrsto (npr. steklenica, škatla, pločevinka), materialom (npr. plastika, kovina, aluminij) in, če je na voljo, njihovo velikostjo (npr. 33 cl) ter navodili za recikliranje.\nPrimer: 1 steklenica za recikliranje, 1 plastični zamašek za zavrženje';

  @override
  String get packaging_editing_error => 'Shranjevanje embalaže ni uspelo.';

  @override
  String get packaging_editing_image_error =>
      'Ni mogoče pridobiti slike nove embalaže.';

  @override
  String get packaging_editing_title => 'Uredi embalažo';

  @override
  String get nutrition => 'Prehrana';

  @override
  String get nutrition_facts_photo => 'Slika hranilnih vrednosti';

  @override
  String get nutrition_facts_editing_title => 'Uredi hranilne vrednosti';

  @override
  String get packaging_information => 'Informacije o embalaži';

  @override
  String get packaging_information_photo => 'Slika informacij o embalaži';

  @override
  String get missing_product => 'Našli ste nov izdelek!';

  @override
  String get add_product_take_photos =>
      'Fotografirajte embalažo, da dodate ta izdelek na Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Najprej posnemite nekaj fotografij. Izdelek lahko vedno dokončate pozneje.';

  @override
  String get add_product_information_button_label =>
      'Dodajanje informacij o izdelku';

  @override
  String get new_product => 'Nov izdelek';

  @override
  String get new_product_found_title => 'Najden nov izdelek!';

  @override
  String get new_product_found_text =>
      'Naša skupna baza podatkov vsebuje več kot **3 milijone izdelkov**, vendar ta črtna koda ne obstaja: ';

  @override
  String get new_product_found_button => 'Dodaj ta izdelek';

  @override
  String get new_product_leave_title => 'Zapustiti to stran?';

  @override
  String get new_product_leave_message =>
      'Zdi se, da niste vnesli ničesar. Ali res želite zapustiti to stran?';

  @override
  String get new_product_dialog_description =>
      'Prosimo, fotografirajte embalažo, da boste izdelek dodali v našo skupno bazo podatkov.';

  @override
  String get new_product_dialog_illustration_description =>
      'Ilustracija z neznanim Nutri-Score in Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Fotografija sprednjega dela izdelka';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Potrdite naloženo sprednjo fotografijo izdelka';

  @override
  String get confirm_button_label => 'Potrdi';

  @override
  String get send_image_button_label => 'Pošlji sliko';

  @override
  String get crop_page_action_saving => 'Shranjevanje slike…';

  @override
  String get crop_page_action_cropping => 'Obrezovanje slike…';

  @override
  String get crop_page_action_local => 'Shranjevanje lokalne različice…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ups… nekaj je narobe s tvojo fotografijo!';

  @override
  String get crop_page_action_local_failed_message =>
      'Slike ne moremo obdelati lokalno, preden jo pošljemo na naš strežnik. Poskusite znova pozneje ali pa nas kontaktirajte, če težava ne izgine.';

  @override
  String get crop_page_action_retake => 'Ponovno posnemite fotografijo';

  @override
  String get crop_page_too_small_image_title => 'Slika je premajhna!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Najmanjša velikost slike v slikovnih pikah za nalaganje je ${expectedMinWidth}x$expectedMinHeight. Trenutna slika je ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Priprava klica strežniku…';

  @override
  String get front_packaging_photo_title => 'Fotografija sprednje embalaže';

  @override
  String get ingredients_photo_title => 'Slika sestavin';

  @override
  String get nutritional_facts_photo_title => 'Fotografija hranilnih vrednosti';

  @override
  String get recycling_photo_title => 'Fotografija recikliranja';

  @override
  String get take_photo_title => 'Posnemi fotografijo';

  @override
  String get take_more_photo_title => 'Naredite več slik';

  @override
  String get front_photo_uploaded => 'Sprednja fotografija je naložena';

  @override
  String get ingredients_photo_button_label => 'Slike sestavin';

  @override
  String get ingredients_photo_uploaded => 'Fotografija sestavin je naložena';

  @override
  String get nutrition_cache_loading_error =>
      'Ni mogoče naložiti hranil iz predpomnilnika';

  @override
  String get nutritional_facts_photo_button_label =>
      'Slika hranilnih vrednosti';

  @override
  String get nutritional_facts_input_button_label =>
      'Vnesite hranilne vrednosti';

  @override
  String get nutritional_facts_added => 'Hranilne vrednosti so dodane';

  @override
  String get categories_added => 'Dodane kategorije';

  @override
  String get new_product_title_nutriscore => 'Izračunajte Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Pomagajte nam tako, da izpolnite vsaj eno kategorijo in hranilne vrednosti.';

  @override
  String get new_product_title_environmental_score =>
      'Izračunajte zeleni rezultat';

  @override
  String get new_product_subtitle_environmental_score =>
      'Pridobite ga tako, da izpolnite vsaj eno kategorijo';

  @override
  String get new_product_additional_environmental_score =>
      'Natančnejši izračun Green Score z izvorom, embalažo in še več';

  @override
  String get new_product_title_nova =>
      'Izračunajte stopnjo predelave hrane (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Pridobite ga tako, da izpolnite kategorijo živil in sestavine';

  @override
  String get new_product_desc_nova_unknown => 'Neznana stopnja predelave hrane';

  @override
  String get new_product_title_pictures => 'Nov izdelek';

  @override
  String get new_product_title_pictures_details =>
      'Prosim, posnemite naslednje fotografije, iskalnik Open Food Facts pa bo izračunal ostalo!';

  @override
  String get new_product_title_misc => 'In nekaj osnovnih podatkov…';

  @override
  String new_product_done_msg(String username) {
    return 'Hvala za vaš prispevek “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Hvala za vaš prispevek!';

  @override
  String get new_product_done_button_label => 'Odkrijte končni izdelek';

  @override
  String get hey_incomplete_product_message =>
      'Dotaknite se, da ZDAJ odgovorite na 3 vprašanja in izračunate Nutri-Score, Green Score in Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Dotaknite se zdaj, da odgovorite na 2 vprašanji, ki vam bosta pomagali analizirati to kozmetiko!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Dotaknite se zdaj, da odgovorite na 3 vprašanja, ki vam bodo pomagala analizirati ta izdelek s hrano za hišne ljubljenčke!';

  @override
  String get hey_incomplete_product_message_product =>
      'Dotaknite se zdaj, da pomagate dokončati ta izdelek!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Slika hranilnih vrednosti je naložena';

  @override
  String get recycling_photo_button_label =>
      'Slika z informacijami o recikliranju';

  @override
  String get recycling_photo_uploaded =>
      'Fotografija recikliranja je bila naložena';

  @override
  String get take_more_photo_button_label => 'Naredite več slik';

  @override
  String get other_photo_uploaded => 'Razna fotografija je naložena';

  @override
  String get retake_photo_button_label => 'Ponovi';

  @override
  String get selecting_photo => 'Izbiranje fotografije';

  @override
  String get uploading_image => 'Nalaganje fotografij na strežnik';

  @override
  String get uploading_image_type_front =>
      'Nalaganje sprednje slike na Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Nalaganje slike sestavin v Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Nalaganje slike o hranilni vrednosti v Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Nalaganje slike embalaže na Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Nalaganje druge slike na Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Nalaganje slike na Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Dodaj manjkajoče sestavine';

  @override
  String get score_add_missing_packaging_image =>
      'Dodajte manjkajočo sliko embalaže';

  @override
  String get score_add_missing_nutrition_facts =>
      'Dodaj manjkajoče hranilne vrednosti';

  @override
  String get score_add_missing_product_traces =>
      'Dodajte manjkajoče sledi izdelka';

  @override
  String get score_add_missing_product_category =>
      'Dodaj manjkajočo kategorijo izdelka';

  @override
  String get score_add_missing_precise_product_category =>
      'Izberite natančnejšo kategorijo';

  @override
  String get score_add_missing_product_countries =>
      'Dodajte manjkajoče države izdelkov';

  @override
  String get score_add_missing_product_emb =>
      'Dodajte manjkajoče kode za sledljivost izdelkov';

  @override
  String get score_add_missing_product_labels =>
      'Dodajte manjkajoče oznake izdelkov';

  @override
  String get score_add_missing_product_origins =>
      'Dodajte manjkajoče izvore izdelkov';

  @override
  String get score_add_missing_product_stores =>
      'Dodaj manjkajoče trgovine z izdelki';

  @override
  String get score_add_missing_product_brands =>
      'Dodajte manjkajoče blagovne znamke izdelkov';

  @override
  String get score_update_nutrition_facts => 'Posodobi hranilne vrednosti';

  @override
  String get nutrition_page_title => 'Dejstva o hranilni vrednosti';

  @override
  String get nutrition_page_nutritional_info_title => 'Hranilne informacije';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Vrednosti, navedene na izdelku:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Da';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Ne';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Odpri fotografijo';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Dobre prakse: Informacije o hranilni vrednosti';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Včasih hranilne vrednosti **niso navedene na embalaži** ali na dokumentu, ki je priložen izdelku. V tem primeru in samo v tem primeru lahko vrednost nastavite na **NE**.';

  @override
  String get nutrition_page_serving_type_label => 'Hranilne vrednosti:';

  @override
  String get nutrition_page_per_100g => 'na 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'na 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'na porcijo';

  @override
  String get nutrition_page_add_nutrient => 'Dodaj hranilo';

  @override
  String get nutrition_page_serving_size => 'Velikost obroka';

  @override
  String get nutrition_page_serving_size_hint =>
      'Vnesite velikost porcije (npr. 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Dobre prakse: Velikost serviranja';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Ta vrednost pomaga pri **sorazmernem izračunu vsakega hranila na velikost porcije**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Dovoljene enote** so: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, l, дл, кл, ml, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** ali **60 G** (raje izberite prvo)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** ali **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Neveljavna enota';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Neveljavne enote';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **sladkarij** in 2 **piškota**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Manjka enota';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Neveljavna številka';

  @override
  String get nutrition_page_update_running =>
      'Posodabljanje izdelka na strežniku…';

  @override
  String get nutrition_page_update_done => 'Izdelek posodobljen!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Količino izdelka uporabite kot velikost porcije';

  @override
  String get nutrition_page_photo_error => 'Fotografije ni mogoče naložiti';

  @override
  String get more_photos => 'Ostale fotografije';

  @override
  String get view_more_photo_button =>
      'Oglejte si vse obstoječe fotografije tega izdelka';

  @override
  String get no_product_found => 'Ni zadetkov';

  @override
  String get no_location_found => 'Ni najdene lokacije';

  @override
  String get not_found => 'ni zadetkov:';

  @override
  String get refreshing_product => 'Osvežitev izdelkov';

  @override
  String get product_refreshed => 'Izdelki so osveženi';

  @override
  String product_image_accessibility_label(String date) {
    return 'Slika je bila posneta dne $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Slika je bila posneta dne $date. Ta slika je morda zastarela.';
  }

  @override
  String get product_image_outdated => 'Ta slika je morda zastarela';

  @override
  String get product_image_outdated_explanations_title =>
      'Ta slika je morda zastarela';

  @override
  String get product_image_outdated_explanations_content =>
      'Ta slika je bila posneta pred več kot enim letom.\n**Preverite, ali je še vedno posodobljena**.\n\nTo je **le opozorilo**. Če je vsebina še vedno enaka, lahko to sporočilo prezrete.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Zamenjaj fotografijo ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Dodaj fotografijo ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'Posnemi fotografijo';

  @override
  String get product_image_action_from_gallery =>
      'Izberite iz galerije telefona';

  @override
  String get product_image_action_choose_existing_photo =>
      'Izberite med fotografijami izdelkov';

  @override
  String get product_image_details_label => 'Informacije o fotografiji';

  @override
  String get product_image_details_from_producer => 'Od proizvajalca';

  @override
  String get product_image_details_contributor => 'Sodelavec';

  @override
  String get product_image_details_contributor_producer =>
      'Sodelavec (producent)';

  @override
  String get product_image_details_date => 'Datum';

  @override
  String get product_image_details_date_unknown => 'Neznano';

  @override
  String get homepage_main_card_logo_description =>
      'Dobrodošli na Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Skenirajte** črtno kodo ali\n**poiščite** izdelek';

  @override
  String get homepage_main_card_search_field_hint => 'Iskanje izdelka';

  @override
  String get homepage_main_card_search_field_tooltip => 'Začni iskanje';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Najnovejše novice: $news_title';
  }

  @override
  String get tagline_app_review => 'Vam je aplikacija všeč?';

  @override
  String get tagline_app_review_button_positive => 'Obožujem! 😍';

  @override
  String get tagline_app_review_button_negative => 'Ne ravno…';

  @override
  String get tagline_app_review_button_later => 'Vprašaj me pozneje';

  @override
  String get tagline_feed_news_button => 'Več informacij';

  @override
  String get app_review_negative_modal_title => 'Vam ni všeč naša aplikacija?';

  @override
  String get app_review_negative_modal_text =>
      'Bi si lahko vzeli nekaj sekund in nam povedali, zakaj?';

  @override
  String get app_review_negative_modal_positive_button => 'Ja, absolutno!';

  @override
  String get app_review_negative_modal_negative_button => 'Ne';

  @override
  String get could_not_refresh => 'Izdelka ni bilo mogoče osvežiti';

  @override
  String get product_internet_error_modal_title => 'Prišlo je do napake!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Zaradi omrežne napake ni mogoče pridobiti informacij o tem izdelku. Preverite internetno povezavo in poskusite znova.\n\nNotranja napaka:\n$error';
  }

  @override
  String get product_tags_title => 'Lastnosti izdelka';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Ni nepremičnin';

  @override
  String get product_tags_explanation =>
      'Z dodajanjem lastnosti (ključ/vrednost) izdelku ga pomagate obogatiti.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Dodaj lastnosti';

  @override
  String get add_edit_tags => 'Dodajanje ali urejanje lastnosti';

  @override
  String get edit_tag => 'Uredi nepremičnino';

  @override
  String get remove_tag => 'Odstrani nepremičnino';

  @override
  String get tag_key => 'Nepremičnina';

  @override
  String get tag_keys => 'Nepremičnine';

  @override
  String get tag_key_uneditable => 'Lastnost (ni mogoče urejati)';

  @override
  String get tag_key_input_hint => 'Vnesite lastnost';

  @override
  String get tag_value => 'Vrednost';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Vnesite vrednost';

  @override
  String get tag_key_item => 'Nepremičnina:';

  @override
  String get tag_value_item => 'Vrednost:';

  @override
  String get tag_key_explanations =>
      'Ključ mora biti napisan z malimi črkami in brez presledkov.';

  @override
  String tag_key_already_exists(String property) {
    return 'Oznaka z lastnostjo $property že obstaja!';
  }

  @override
  String get product_internet_error =>
      'Zaradi napake v omrežju ni mogoče pridobiti informacij o tem izdelku.';

  @override
  String get cached_results_from => 'Prikaži rezultate iz:';

  @override
  String get product_search_same_category => 'Poiščite alternative';

  @override
  String get product_search_same_category_short => 'Primerjaj';

  @override
  String get product_search_same_category_error =>
      'To funkcijo je mogoče uporabiti samo za izdelke s kategorijo.\n\nUredite izdelek, da dodate kategorijo.';

  @override
  String get product_improvement_add_category =>
      'Dodajte kategorijo za izračun Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Dodajte hranilne vrednosti za izračun Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Dodajte hranilne vrednosti in kategorijo za izračun Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Score za ta izdelek ni mogoče izračunati, kar je lahko posledica npr. nestandardne kategorije. Če to štejete za napako, nas prosim kontaktirajte.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Fotografija hranilnih vrednosti je zastarela: osvežite jo.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Zelena ocena upošteva poreklo sestavin. Prosimo, fotografirajte seznam sestavin in/ali morebitno geografsko trditev ali uredite izdelek, da se lahko upoštevajo.';

  @override
  String get country_chooser_label => 'Prosimo, izberite državo';

  @override
  String get currency_chooser_label => 'Izberite valuto';

  @override
  String get country_change_message => 'Pravkar ste zamenjali državo.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Ali želite spremeniti valuto iz $previousCurrency v $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Prosimo, izberite državo:';

  @override
  String get country_chooser_label_from_settings => 'Vaša država';

  @override
  String get country_selection_explanation =>
      'Nekatere okoljske značilnosti so specifične za lokacijo';

  @override
  String get product_removed_comparison =>
      'Izdelek je odstranjen iz primerjave';

  @override
  String get native_app_settings => 'Nastavitve izvorne aplikacije';

  @override
  String get native_app_description =>
      'Nastavitve odprtih sistemov za Open Food Facts';

  @override
  String get product_removed_history => 'Izdelek je odstranjen iz zgodovine';

  @override
  String get product_removed_list => 'Izdelek odstranjen s seznama';

  @override
  String get product_could_not_remove => 'Izdelka ni bilo mogoče odstraniti';

  @override
  String get no_prodcut_in_list => 'Na tem seznamu ni nobenega izdelka';

  @override
  String get no_product_in_section => 'V tem razdelku ni izdelka';

  @override
  String get recently_seen_products => 'Vsi ogledani izdelki';

  @override
  String get clear => 'Počisti';

  @override
  String get clear_long => 'Izprazni seznam';

  @override
  String get really_clear => 'Ali res želite izbrisati ta seznam?';

  @override
  String pct_match(Object percent) {
    return '$percent% ujemanje';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pred dnevi',
      one: 'pred enim dnem',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pred urami',
      one: 'pred eno uro',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pred minutami',
      one: 'pred eno minuto',
      zero: 'pred manj kot minuto',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pred meseci',
      one: 'pred enim mesecem',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pred tedni',
      one: 'pred enim tednom',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Primerjaj $count Izdelki',
      one: 'Primerjaj en izdelek',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izbrani izdelki',
      one: 'En izbran izdelek',
      zero: 'Ni izbranega izdelka',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Primerjajte izbrane izdelke';

  @override
  String get delete_products_mode => 'Izbriši izbrane izdelke';

  @override
  String get select_all_products_mode => 'Izberite vse izdelke';

  @override
  String get select_none_products_mode => 'Izberi nič';

  @override
  String get compare_products_appbar_title => 'Primerjava izdelkov';

  @override
  String get compare_products_appbar_subtitle => 'Izberite vsaj dva izdelka';

  @override
  String get retry_button_label => 'Poskusi znova';

  @override
  String get connect_with_us => 'Povežite se z nami';

  @override
  String get tiktok => 'Spremljajte nas na TikToku';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Spremljajte nas na Instagramu';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Spremljajte nas na X (prej Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Spremljajte nas na Mastodonu';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Spremljajte nas na BlueSkyju';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Pogosta vprašanja';

  @override
  String get discover => 'Odkritje';

  @override
  String get how_to_contribute => 'Kako prispevati';

  @override
  String get hint_knowledge_panel_message =>
      'Kliknite kjerkoli na kartici za več informacij o tem kar vidite. Poizkusite sedaj!';

  @override
  String get permissions_page_title => 'Dostop do kamere';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'To opcijo lahko onemogočite ali ponovno omogočite kadarkoli v nastavitvah.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Operacijski sistem: Android (SDK Int: $sdkInt / Izdaja: $release)\nModel: $model\nIzdelek: $product\nNaprava: $device\nZnamka:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Operacijski sistem: iOS ($version)\nModel: $model\nLokaliziran model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nRazličica aplikacije:$appVersion\nŠtevilka gradnje aplikacije:$appBuildNumber\nIme paketa aplikacije:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'Zavrni';

  @override
  String get ask_me_later_button_label => 'Kasneje';

  @override
  String get are_you_sure => 'Si prepričan/a?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Pojdi naprej na $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Dobrodošli!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Aplikacija, ki vam pomaga izbrati hrano, ki je dobra za **vas** in **planet**!';

  @override
  String get onboarding_continue_button => 'Nadaljuj';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Nalaganje prvega primera izdelka';

  @override
  String get onboarding_welcome_warning =>
      'Žal je to naš primer izdelka, ne morete ga urejati :)';

  @override
  String get product_list_your_ranking => 'Vaša razvrstitev';

  @override
  String get product_list_empty_icon_desc => 'Zgodovina ni na voljo';

  @override
  String get product_list_empty_title => 'Začni skeniranje';

  @override
  String get product_list_empty_message =>
      'Skenirani izdelki se bodo prikazali tukaj. Na voljo bodo podrobne informacije';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'izdelkov',
      one: 'izdelka',
      zero: 'izdelka',
    );
    return 'Osvežitev $_temp0 v vaši zgodovini';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Izdelki',
      one: 'Izdelek',
      zero: 'Izdelek',
    );
    return '$_temp0 osvežitev končana';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Nalaganje podatkov';

  @override
  String get loading_dialog_default_error_message =>
      'Datoteke ni bilo mogoče prenesti';

  @override
  String get account_delete => 'Izbrišite račun';

  @override
  String get account_delete_title => 'Izbriši moj račun';

  @override
  String get user_profile => 'Račun';

  @override
  String get user_profile_title_guest => 'Dobrodošli!';

  @override
  String get user_profile_subtitle_guest =>
      'Prijavite se ali registrirajte, da se pridružite skupnosti Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Prijava v Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Dobrodošli $id!';
  }

  @override
  String get email_subject_account_deletion => 'Izbrišite račun';

  @override
  String email_body_account_deletion(String userId) {
    return 'Živjo, prosim, izbrišite moj račun Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Uporaba';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Izdelki';

  @override
  String get settings_app_miscellaneous => 'Razno';

  @override
  String get camera_play_sound_title => 'Zvok ob skeniranju';

  @override
  String get camera_play_sound_subtitle =>
      'Po vsakem uspešnem skeniranju bo zapiskalo';

  @override
  String get camera_window_accessibility_label =>
      'Skenirajte črtno kodo s kamero';

  @override
  String get app_haptic_feedback_title => 'Vibracije in haptika';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibracije po izvedbi nekaterih dejanj (črtna koda dekodirana, izdelek odstranjen…).';

  @override
  String get crash_reporting_toggle_title => 'Poročanje o sesutjih';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Ko je omogočeno, se poročila o zrušitvah samodejno pošljejo v sistem za sledenje napak Open Food Facts, tako da je mogoče odpraviti napake in s tem izboljšati aplikacijo.';

  @override
  String get send_anonymous_data_toggle_title => 'Pošlji anonimne podatke';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Uredi fotografijo';

  @override
  String get permission_photo_error => 'Napaka';

  @override
  String get permission_photo_denied_title =>
      'Dovoli uporabo kamere za skeniranje črtnih kod';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Za izboljšanje uporabniške izkušnje dovolite, da $appName dostopa do vaše kamere. Črtne kode boste lahko neposredno skenirali.';
  }

  @override
  String get permission_photo_denied_button => 'Dovoli';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Dovoljenje zavrnjeno';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Ker ste predhodno zavrnili dovoljenje za dostop do kamere, je potrebno dovoljenje ročno omogočiti v nastavitvah.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Odpri nastavitve';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Prekliči';

  @override
  String get permission_photo_none_found => 'Kamera ni zaznana';

  @override
  String get permission_photo_denied => 'Dostop do kamere je omogočen';

  @override
  String get show_product_pictures => 'Prikaži slike izdelkov';

  @override
  String get edit_product_label => 'Uredi izdelek';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Nalaganje vaših sprememb…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Vaše spremembe se **pošiljajo v ozadju** (ali kasneje v primeru napake).\nLahko nadaljujete z urejanjem drugih polj izdelka.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Vaše spremembe se **pošiljajo v ozadju** (ali kasneje v primeru napake).';

  @override
  String get edit_product_label_short => 'Uredi';

  @override
  String edit_product_form_item_help(String value) {
    return 'Kako vnesti \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Vnesite vrednost, ki ni prazna!';

  @override
  String get edit_product_form_item_error_existing => 'Ta vrednost je že tam!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Dodaj novo blagovno znamko';

  @override
  String get edit_product_form_item_add_action_label => 'Dodaj novo oznako';

  @override
  String get edit_product_form_item_add_action_store => 'Dodaj novo trgovino';

  @override
  String get edit_product_form_item_add_action_origin => 'Dodaj nov izvor';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Dodaj novo kodo sledljivosti';

  @override
  String get edit_product_form_item_add_action_country => 'Dodaj novo državo';

  @override
  String get edit_product_form_item_add_action_category =>
      'Dodaj novo kategorijo';

  @override
  String get edit_product_form_item_add_action_trace => 'Dodaj novo sled';

  @override
  String get edit_product_form_item_add_suggestion => 'Dodaj predlog';

  @override
  String get edit_product_form_item_deny_suggestion => 'Zavrni predlog';

  @override
  String get edit_product_form_item_details_title => 'Osnovni podatki';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Ime izdelka, blagovna znamka, količina';

  @override
  String get edit_product_form_item_other_details_title =>
      'Dodatne podrobnosti';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Spletna stran…';

  @override
  String get edit_product_form_item_photos_title => 'Fotografije';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Dodajte ali osvežite fotografije';

  @override
  String get edit_product_form_item_labels_title => 'Oznake in certifikati';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Okoljske, kakovostne oznake…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Vnesite oznako (npr.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'oznaka';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Dobre prakse: Oznake';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Vsaka značilnost izdelka, **ki je dejanska** in se razlikuje od drugih polj.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Izdelano v Belgiji, proizvedeno v Bretanji…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Bogato z vlakninami, vir železa…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Pravična trgovina, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Trgovine';

  @override
  String get edit_product_form_item_stores_hint => 'Vnesite trgovino';

  @override
  String get edit_product_form_item_stores_type => 'trgovina';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Dobre prakse: Trgovine';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Vnesite trgovino, kjer ste kupili izdelek.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Poreklo';

  @override
  String get edit_product_form_item_origins_hint =>
      'Vnesite izvor (npr. Nemčija)';

  @override
  String get edit_product_form_item_origins_type => 'država';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Dobre prakse: Izvor';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Dodajte **vse navedbe porekla, ki jih najdete na embalaži**.\nNi vam treba skrbeti za poreklo, ki je navedeno neposredno na seznamu sestavin.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Govedina iz Argentine';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soja ne prihaja iz Evropske unije';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Vnesite državo (npr. Nemčija)';

  @override
  String get edit_product_form_item_countries_type => 'država';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Dobre prakse: Države';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Države, kjer je izdelek široko dostopen** (brez trgovin, specializiranih za tuje izdelke).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Kode sledljivosti';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Vnesite kodo (npr.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'kode sledljivosti';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Dobre prakse: Kode sledljivosti';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'V tem razdelku lahko vnesete kode, povezane z **oznakami embalaže**, **identifikacijskimi oznakami** ali **oznakami zdravstvene ustreznosti**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Primeri kod sledljivosti';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Kode ES**, ki se uporabljajo v Evropski skupnosti za identifikacijo proizvajalcev ali pakirnic živil:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: koda države **Francija**\n**72.264.002**: geografski podatki\n**CE**: Evropska skupnost';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Kode EMB**, ki se uporabljajo v Franciji:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Sledi';

  @override
  String get edit_product_form_item_traces_hint => 'sledi';

  @override
  String get edit_product_form_item_traces_type => 'Vnesite sled (npr. soja)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorije';

  @override
  String get edit_product_form_item_categories_hint => 'kategorijo';

  @override
  String get edit_product_form_item_categories_type =>
      'Vnesite kategorijo (npr.: pomarančni sok)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Dobre prakse: Kategorije';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Označite **samo najbolj specifično kategorijo**.\nNadrejene kategorije bodo dodane samodejno.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Manjka kategorija?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Če kategorija **ni na voljo v samodejnem dokončevanju**, jo lahko vseeno dodate.\nTo nam bo pomagalo izboljšati Open Food Facts v vaši državi.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardine v olivnem olju';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Pomarančni sok iz koncentrata';

  @override
  String get edit_product_form_item_exit_title => 'Odhod brez shranjevanja?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Želite shraniti spremembe pred odhodom?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Shrani spremembe';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Zavrzi spremembe';

  @override
  String get edit_product_form_item_ingredients_title => 'Sestavine';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Povečajte in pomanjšajte s stiskanjem prstov na zaslonu';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Povečaj in pomanjšaj fotografijo';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Z uporabo **poteze povečave s prsti** lahko povečate ali pomanjšate fotografijo:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Dodaj';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Najprej vnesite besedilo';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Odstrani';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => 'Shrani urejanje';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Prekliči urejanje';

  @override
  String get edit_product_form_item_packaging_title =>
      'Fotografija navodil za recikliranje';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Dejstva o hranilni vrednosti';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Hranilna vrednost, vsebnost alkohola…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Dobre prakse: Hranilna dejstva';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Hranilne vrednosti';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Najprej izberite, ali so **vrednosti podane**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Dejstva o hranilni vrednosti';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Nato vnesite hranilne vrednosti **kot so navedene na embalaži**. Če vrednosti ni, lahko kliknete ikono »Oko«.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Manjkajoče polje?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Če vnos manjka, ga lahko dodate s **kliknitvijo ikone »Plus«** (npr.: vitamin D, magnezij…).';

  @override
  String get edit_product_form_save => 'Uredi';

  @override
  String get edit_product_ingredients_photo_title => 'Slike sestavin';

  @override
  String get edit_product_ingredients_list_title => 'Seznam sestavin';

  @override
  String get edit_product_packaging_photo_title => 'Fotografija embalaže';

  @override
  String get edit_product_packaging_list_title => 'Seznam embalaže';

  @override
  String get no_data_available => 'Ni na voljo podatkov';

  @override
  String get product_field_website_title => 'Spletna stran';

  @override
  String get origins_editing_title => 'Uredi izvore';

  @override
  String get completed_basic_details_btn_text => 'Izpolnite osnovne podatke';

  @override
  String get not_implemented_snackbar_text => 'Še ni implementirano';

  @override
  String get category_picker_page_appbar_text => 'Kategorije';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Izvlecite sestavine iz fotografije';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Preberi sestavine';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Pridobivanje sestavin\niz fotografije';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'Nalaganje fotografije…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Zakaj vidim to sporočilo?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Za uporabo funkcije »Izvleči sestavine« je treba najprej naložiti fotografijo.\n\nPočakajte nekaj sekund ali jih vnesite ročno.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Osveži fotografijo';

  @override
  String get edit_packaging_extract_btn_text =>
      'Izvlecite embalažo\ns fotografije';

  @override
  String get edit_packaging_extract_btn_text_short => 'Izvleček embalaže';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Izvleček embalaže iz fotografije';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Nalaganje fotografije…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Zakaj vidim to sporočilo?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Za uporabo funkcije »Izvleči embalažo« je treba najprej naložiti fotografijo.\n\nPočakajte nekaj sekund ali jih vnesite ročno.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Osveži fotografijo';

  @override
  String get edit_ocr_extract_failed =>
      'Besedila na sliki ni bilo mogoče zaznati.';

  @override
  String get edit_ocr_extract_disabled_title => 'Brez slike!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Če želite uporabiti funkcijo ekstrakcije besedila, morate najprej posneti fotografijo.';

  @override
  String get user_list_dialog_new_title => 'Nov seznam izdelkov';

  @override
  String get user_list_dialog_rename_title => 'Preimenuj seznam';

  @override
  String get user_list_subtitle_product => 'Seznam';

  @override
  String get user_list_title => 'Tvoji seznami';

  @override
  String get user_list_add_product => 'Dodajte izdelek na svoje sezname';

  @override
  String get user_list_button_new => 'Ustvari nov seznam';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Dodaj na seznam';

  @override
  String get added_to_list_msg => 'Dodano na seznam';

  @override
  String get user_list_popup_clear => 'Počisti zgodovino';

  @override
  String get user_list_popup_rename => 'Preimenuj';

  @override
  String get user_list_name_hint => 'Moj seznam';

  @override
  String get user_list_name_error_empty => 'Ime je obvezno';

  @override
  String get user_list_name_error_already => 'Ime je že v uporabi';

  @override
  String get user_list_name_error_same => 'To ime je enako';

  @override
  String get user_list_name_input_hint => 'Ime seznama';

  @override
  String get try_again => 'Poskusite ponovno';

  @override
  String get there_was_an_error => 'Prišlo je do napake';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nobena kategorija ni bila najdena za $items';
  }

  @override
  String get camera_toggle_camera =>
      'Preklapljanje med zadnjo in sprednjo kamero';

  @override
  String get camera_toggle_flash => 'Vklop ali izklop bliskavice fotoaparata';

  @override
  String get camera_enable_flash => 'Omogoči bliskavico';

  @override
  String get camera_disable_flash => 'Onemogoči bliskavico';

  @override
  String get camera_flash_error_dialog_title => 'Prišlo je do napake!';

  @override
  String get camera_flash_error_dialog_message =>
      'Pri spreminjanju stanja bliskavice je prišlo do napake. Prepričajte se, da svetilka ni že omogočena na vašem pametnem telefonu.';

  @override
  String get category_picker_no_category_found_button => 'Nazaj';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Kliknite, da odprete v brskalniku ali v aplikaciji (če je nameščena)';

  @override
  String get dev_preferences_screen_title => 'Način za razvijalce';

  @override
  String get dev_preferences_screen_subtitle =>
      'Dostop do eksperimentalnih funkcij in razvojnih orodij';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Znova zaženite vkrcanje';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Nato morate aplikacijo znova zagnati, da jo ponovno vidite.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Preklapljanje med openfoodfacts.org (PROD) in testnim env';

  @override
  String get dev_preferences_test_environment_title =>
      'Parametri testnega okolja';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Osnovni URL za trenutno testno okolje: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Gostitelj testnega okolja';

  @override
  String get dev_preferences_ml_kit_title => 'Uporabite ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'nato ponovno zaženite to aplikacijo';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Dodatni gumb na strani izdelka';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Urejanje sestavin s pomočjo gumba o znanju';

  @override
  String get dev_preferences_export_history_title => 'Izvozi zgodovino';

  @override
  String get dev_preferences_export_history_progress_error => 'izjema';

  @override
  String get dev_preferences_export_history_progress_found =>
      'izdelek je bil najden';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'izdelka ni bilo mogoče najti';

  @override
  String get dev_preferences_export_history_dialog_title => 'Izvozi zgodovino';

  @override
  String get dev_preferences_button_positive => 'V redu';

  @override
  String get dev_preferences_button_negative => 'Prekliči';

  @override
  String get dev_preferences_migration_title => 'Selitev podatkov iz V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Stanje: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'uspešno ali nova namestitev';

  @override
  String get dev_preferences_migration_status_success => 'uspešno';

  @override
  String get dev_preferences_migration_status_error => 'napaka';

  @override
  String get dev_preferences_migration_status_in_progress => 'v teku';

  @override
  String get dev_preferences_migration_status_required =>
      'zahtevano (kliknite za začetek)';

  @override
  String get dev_preferences_migration_status_not_started => 'neznano';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Počistil bo zgodovino in tam vstavil 3 izdelke';

  @override
  String get dev_preferences_news_custom_url_title => 'URL po meri za novice';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL datoteke JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Ni nastavljeno';

  @override
  String get dev_preferences_news_provider_status_title => 'Stanje';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Zadnja osvežitev: $date';
  }

  @override
  String get product_type_label_food => 'Hrana';

  @override
  String get product_type_label_beauty => 'Osebna nega';

  @override
  String get product_type_label_pet_food => 'Hrana za hišne ljubljenčke';

  @override
  String get product_type_label_product => 'Drugo';

  @override
  String get product_type_selection_title => 'Vrsta izdelka';

  @override
  String get product_type_selection_subtitle => 'Izberite vrsto tega izdelka';

  @override
  String get product_type_selection_empty =>
      'Najprej morate izbrati vrsto izdelka!';

  @override
  String product_type_selection_already(String productType) {
    return 'Vrste izdelka ($productType) ne morete spremeniti!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Bližnjica do aplikacije Cene na strani izdelka';

  @override
  String get prices_app_button => 'Pojdi v aplikacijo Cene';

  @override
  String get prices_website_button => 'Odprto na spletni strani Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Dodajte cenovne oznake neposredno iz galerije';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Ko izberete slike, jih ne boste mogli več urejati!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Omogočite skupnosti, da potrdi cene, pridobljene z umetno inteligenco.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Več cenovnih oznak';

  @override
  String get prices_bulk_proof_upload_title =>
      'Nalaganje dokazil v velikem obsegu';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Izbiranje datotek';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Začetek nalaganja';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokalno kopiranje datoteke #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Priprava nalaganja #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Napaka pri sliki #$index/$count';
  }

  @override
  String get prices_generic_title => 'Cene';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Dodaj $count cene',
      one: 'Dodaj ceno',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Pošlji $count cene',
      one: 'Pošlji ceno',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Dodaj element';

  @override
  String get prices_add_a_price => 'Dodaj ceno';

  @override
  String get prices_add_a_receipt => 'Dodaj račun';

  @override
  String get prices_add_price_tags => 'Dodajte cenovne oznake';

  @override
  String prices_barcode_already(String barcode) {
    return 'Ta črtna koda ($barcode) je že na seznamu!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'Še ni izdelka';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Iščem $barcode';
  }

  @override
  String get prices_barcode_enter => 'Vnesite črtno kodo';

  @override
  String get prices_category_enter => 'Izdelek brez črtne kode';

  @override
  String get prices_per_kilogram => 'Cena na kilogram';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / enota';

  @override
  String get prices_category_mandatory => 'Obvezno';

  @override
  String get prices_category_optional => 'Neobvezno';

  @override
  String get prices_category_error_mandatory => 'Kategorija je obvezna';

  @override
  String get prices_barcode_reader_action => 'Čitalnik črtne kode';

  @override
  String get prices_view_prices => 'Oglejte si cene';

  @override
  String get prices_list_title => 'Cenik';

  @override
  String get prices_list_count => 'Število cen\n';

  @override
  String get prices_list_add_new_price => 'Dodajte novo ceno\n';

  @override
  String get prices_list_empty_title => 'Cene še ni!';

  @override
  String get prices_list_empty_subtitle =>
      'Dodajte prvi:\nS skeniranjem **računa** ali **cenovke**!';

  @override
  String get prices_entry_shop_not_found => 'Neznana trgovina';

  @override
  String prices_entry_menu_title(String user) {
    return 'Vnos cene od \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Oglejte si vse cene za ta izdelek';

  @override
  String get prices_entry_menu_open_proof => 'Ogled dokazila';

  @override
  String get prices_entry_menu_my_prices => 'Oglejte si moje druge cene';

  @override
  String get prices_entry_menu_author_prices => 'Oglejte si druge cene avtorja';

  @override
  String get prices_entry_menu_shop_prices =>
      'Oglejte si druge cene iz trgovine';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count cene',
      one: '1 cena',
    );
    return '$_temp0 za $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Vse $count cene',
      one: 'Samo ena cena',
      zero: 'Cene še ni',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Najnovejše $pageSize cene (skupaj: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Cena: $price / Trgovina: \"$location\" / Objavljeno dne $date avtorja \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Odprti dokazi za \"$user\"';
  }

  @override
  String get prices_open_proof => 'Dokaz o odprti ceni';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Vsi $count dokazi',
      one: 'Samo en dokaz',
      zero: 'Še ni dokaza',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Najnovejši $pageSize dokazov (skupaj: $total)';
  }

  @override
  String get prices_users_empty_title => 'Še ni sodelavca!';

  @override
  String get prices_users_empty_explanation => 'Bodite prvi, ki doda ceno!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Največ $pageSize sodelavcev (skupaj: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Še ni trgovine!';

  @override
  String get prices_locations_empty_explanation => 'Bodite prvi, ki doda ceno!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Najboljših $pageSize lokacij (skupaj: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dokazi',
      one: 'En dokaz',
      zero: 'Brez dokaza',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izdelki',
      one: 'En izdelek',
      zero: 'Ni izdelka',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count uporabniki',
      one: 'En uporabnik',
      zero: 'Brez uporabnika',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count cene',
      one: 'Ena cena',
      zero: 'Brez cene',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Cena je bila že dodana';

  @override
  String get prices_amount_subtitle => 'Znesek';

  @override
  String get prices_amount_is_discounted => 'Je znižano?';

  @override
  String get prices_amount_price_normal => 'Cena';

  @override
  String get prices_amount_price_discounted => 'Znižana cena';

  @override
  String get prices_amount_price_not_discounted => 'Prvotna cena';

  @override
  String get prices_amount_no_product => 'Manjka en izdelek!';

  @override
  String get prices_amount_price_incorrect => 'Napačna vrednost';

  @override
  String get prices_amount_price_mandatory => 'Obvezna vrednost';

  @override
  String get prices_currency_subtitle => 'Valuta';

  @override
  String get prices_date_subtitle => 'Datum';

  @override
  String get prices_location_subtitle => 'Trgovina';

  @override
  String get prices_location_find => 'Poiščite trgovino';

  @override
  String get prices_location_mandatory => 'Izbrati morate trgovino!';

  @override
  String get prices_location_search_broader =>
      'Niste našli, kar ste iskali? Poskusimo s širšim iskanjem!';

  @override
  String get prices_proof_subtitle => 'Dokaz';

  @override
  String get prices_proof_empty_title => 'Še ni dokazov!';

  @override
  String get prices_proof_empty_explanation =>
      'Začnite tako, da dodate fotografijo **računa** ali **cenovke**!';

  @override
  String get prices_proof_find => 'Izberite dokaz';

  @override
  String get prices_proof_change => 'Dokazilo o spremembi';

  @override
  String get prices_proof_receipt => 'Potrdilo';

  @override
  String get prices_proof_price_tag => 'Cena';

  @override
  String get prices_proof_mandatory => 'Izbrati morate dokaz!';

  @override
  String get prices_add_validation_error => 'Napaka pri preverjanju';

  @override
  String get prices_privacy_warning_title => 'Opozorilo o zasebnosti';

  @override
  String get prices_unknown_product => 'Neznan izdelek';

  @override
  String get prices_privacy_warning_main_message =>
      'Cene **bodo javne**, skupaj z imenom trgovine, na katero se nanašajo.\n\nTo bi lahko ljudem, ki poznajo vaš psevdonim Open Food Facts, omogočilo:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Ugotovi, na katerem območju živiš';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Vedite, kaj kupujete';

  @override
  String get prices_privacy_warning_sub_message =>
      'Če vam to ne ustreza, spremenite svoj psevdonim ali ustvarite nov račun Open Food Facts in se z njim prijavite v aplikacijo.';

  @override
  String get i_refuse => 'Zavračam';

  @override
  String get i_accept => 'Sprejemam';

  @override
  String get prices_currency_change_proposal_title => 'Spremeniti valuto?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Vaša trenutna valuta je **$currency**. Ali jo želite spremeniti v **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Da, uporabite $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Ne, obdrži $currency';
  }

  @override
  String get prices_menu_know_more => 'Več o odprtih cenah';

  @override
  String get dev_preferences_import_history_result_success => 'Opravljeno';

  @override
  String get dev_mode_section_server => 'Konfiguracija strežnika';

  @override
  String get dev_mode_section_news => 'Konfiguracija ponudnika novic';

  @override
  String get dev_mode_section_product_page => 'Stran izdelka';

  @override
  String get dev_mode_section_ui => 'Uporabniški vmesnik';

  @override
  String get dev_mode_section_experimental_features =>
      'Eksperimentalne funkcije';

  @override
  String get dev_mode_hide_environmental_score_title => 'Izključi zeleno oceno';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Za zaslone OCR uporabite preverjalnik črkovanja';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Sestavine in embalaža)';

  @override
  String get dev_mode_reset_app_language_title => 'Ponastavi jezik aplikacije';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Dodaj kartice';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Preklapljanje med prices.openfoodfacts.org (PROD) in testnim okoljem';

  @override
  String get search_history_item_edit_tooltip =>
      'Ponovno uporabi in uredi to iskanje';

  @override
  String get search_history_item_remove_tooltip => 'Odstrani';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Prenesli ste vseh $totalSize izdelkov.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Prenesi še $count izdelkov\nŽe prenesenih $downloaded od $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Vaše iskanje $search je v teku.\n\nProsimo, počakajte nekaj sekund…';
  }

  @override
  String get user_search_contributor_title => 'Izdelki, ki sem jih dodal';

  @override
  String get user_search_informer_title => 'Izdelki, ki sem jih uredil/a';

  @override
  String get user_search_photographer_title =>
      'Izdelki, ki sem jih fotografiral';

  @override
  String get user_search_to_be_completed_title =>
      'Moji izdelki, ki jih je treba dokončati';

  @override
  String get user_search_prices_title => 'Moje cene';

  @override
  String get user_search_proofs_title => 'Moji dokazi';

  @override
  String get user_search_proof_title => 'Moj dokaz';

  @override
  String search_proof_title(String user) {
    return 'Dokaz iz \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Cene sodelavcev: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Najnovejše cene so bile dodane';

  @override
  String get all_search_prices_top_user_title => 'Največji prispevki k cenam';

  @override
  String get all_search_prices_top_location_title =>
      'Trgovine z najvišjimi cenami';

  @override
  String get prices_contribution_assistant => 'Pomočnik za prispevek k cenam';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Dodaj več dokazov';

  @override
  String get all_search_prices_top_location_single_title => 'Cene v trgovini';

  @override
  String get all_search_prices_top_product_title =>
      'Izdelki z najvišjimi cenami';

  @override
  String get all_search_to_be_completed_title =>
      'Vsi izdelki, ki jih je treba dokončati';

  @override
  String get categorize_products_country_title =>
      'Pomagajte kategorizirati izdelke v vaši državi';

  @override
  String get edit_product_action_retake_picture =>
      'Ponovno posnemite fotografijo';

  @override
  String get edit_product_action_take_picture => 'Posnemi fotografijo';

  @override
  String get edit_product_action_confirm => 'Potrdi';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Strinjam se z odprtimi dejstvi o hrani ';

  @override
  String get signup_page_terms_of_use_line2 => 'pogoji uporabe in prispevki';

  @override
  String get analytics_consent_image_semantic_label => 'Ikona analitike';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Kritična napaka: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Kritična napaka: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Izpolnite osnovne podatke';

  @override
  String get edit_photo_button_label => 'Uredi';

  @override
  String get edit_photo_unselect_button_label => 'Prekliči izbor fotografije';

  @override
  String get edit_photo_select_existing_button_label =>
      'Izberite obstoječo sliko';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Izberite sliko s klikom nanjo';

  @override
  String get edit_photo_select_existing_download_label =>
      'Pridobivanje obstoječih slik…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Za ta izdelek ni bilo predhodno naloženih slik.';

  @override
  String get edit_photo_language_not_this_one => 'V tem jeziku še ni slike';

  @override
  String get edit_photo_language_none => 'Še ni slike';

  @override
  String get category_picker_screen_title => 'Kategorije';

  @override
  String get basic_details => 'Osnovni podatki';

  @override
  String get product_name => 'Ime izdelka';

  @override
  String get product_names => 'Imena izdelkov';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Dodaj nov prevod';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Pred potrditvijo se prepričajte, da dodate prevod le, **če je jezik prisoten na embalaži**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Ogled sprednje fotografije';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Posnemite sprednjo fotografijo';

  @override
  String get add_basic_details_product_name_hint =>
      'Vnesite ime izdelka (npr. Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Sprememba privzetega jezika?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Ali želite, da je privzeti jezik izdelka nastavljen na »$language«?';
  }

  @override
  String get explanation_section_good_examples => 'Dobri primeri';

  @override
  String get explanation_section_bad_examples => 'Slabi primeri';

  @override
  String get add_basic_details_product_name_help_title =>
      'Dobre prakse: Ime izdelka';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Ime izdelka je **glavno ime, natisnjeno na embalaži**. Lahko je registrirana blagovna znamka.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Opomba:** Prosimo, ne dodajajte prevoda, **če jezik ni naveden na embalaži**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Paradižnikov kečap';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Ne vključujte blagovne znamke v ime';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Paradižnikov kečap **Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Ne uporabljajte simbolov ®, ™, © ali podobnih.';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count drugi prevodi',
      one: '$count drug prevod',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Blagovna znamka';

  @override
  String get brand_names => 'Blagovne znamke';

  @override
  String get add_basic_details_brand_name_error => 'Vnesite blagovno znamko';

  @override
  String get add_basic_details_brand_names_hint =>
      'Vnos blagovnih znamk (npr. Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Dobre prakse: Blagovne znamke';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Vnesite **vse blagovne znamke izdelka**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Glavna blagovna znamka';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Najprej je treba **vnesti** **glavno blagovno znamko**, ki je običajno jasno prikazana na sprednji strani embalaže.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Druge blagovne znamke';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Ko ga prodaja **veliko podjetje**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** prodaja **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Ko se prodaja z blagovno znamko, **prevedeno v več jezikov**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Dolina narave** se včasih piše **Dolina narave**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Količina in teža';

  @override
  String get add_basic_details_quantity_hint =>
      'Vnesite težo in po potrebi količino (npr.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Dobre prakse: Količina';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Prepišite vrednost, navedeno na izdelku, in **ne pozabite na enote**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** ali **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (za 6 jajc)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(za izdelek s 3 škatlami, vsaka po 150 g)';

  @override
  String get barcode => 'Črtna koda';

  @override
  String barcode_barcode(String barcode) {
    return 'Črtna koda: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Neveljavna črtna koda';

  @override
  String get basic_details_add_success =>
      'Osnovni podatki so bili uspešno dodani';

  @override
  String get basic_details_add_error =>
      'Osnovnih podatkov ni bilo mogoče dodati. Prosimo poizkusite kasneje';

  @override
  String get clear_search => 'Počisti iskanje';

  @override
  String get confirm_clear =>
      'Izbrisali boste celotno zgodovino: ali ste prepričani, da želite nadaljevati?';

  @override
  String get alert_clear_selected_user_list =>
      'Iz zgodovine boste izbrisali izbrane elemente.';

  @override
  String get confirm_clear_selected_user_list =>
      'Ste prepričani, da želite nadaljevati?';

  @override
  String get alert_select_items_to_clear =>
      'Izberite enega ali več elementov za brisanje';

  @override
  String confirm_clear_user_list(String name) {
    return 'Ta seznam boste počistili ($name): ali ste prepričani, da želite nadaljevati?';
  }

  @override
  String get confirm_delete_user_list_title => 'Izbrisati seznam?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Izbrisali boste seznam »$name«.\nAli ste prepričani, da želite nadaljevati?';
  }

  @override
  String get confirm_delete_user_list_button => 'Da, potrjujem';

  @override
  String importance_label(String name, String id) {
    return '$name pomembnost: $id';
  }

  @override
  String get user_list_all_title => 'Seznam';

  @override
  String get user_list_all_empty => 'Ustvarite svoj prvi seznam';

  @override
  String get product_list_select => 'Izberite seznam';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izdelek',
      one: 'En izdelek',
      zero: 'Prazen seznam',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Dodaj seznam';

  @override
  String get open_food_preferences_tooltip => 'Uredi preference izdelkov';

  @override
  String get add_photo_button_label => 'Dodaj fotografijo';

  @override
  String get add_packaging_photo_button_label =>
      'Fotografirajte vse informacije o embalaži/recikliranju';

  @override
  String get add_origin_photo_button_label =>
      'Fotografirajte vse informacije o izvoru';

  @override
  String get add_emb_photo_button_label =>
      'Fotografirajte vse podatke o kodi sledljivosti';

  @override
  String get add_label_photo_button_label =>
      'Fotografirajte vse nalepke in informacije o certifikatih';

  @override
  String get choose_image_source_title => 'Izberite vir slike';

  @override
  String get choose_image_source_body => 'Izberite vir slike';

  @override
  String get gallery_source_label => 'Galerija';

  @override
  String get gallery_source_access_denied_dialog_title => 'Dostop zavrnjen';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Žal aplikacija ne more dostopati do vaše galerije, ker ste prej zavrnili dovoljenje.\n\nPojdite v nastavitve aplikacije v telefonu Nastavitve -> Fotografije';

  @override
  String get gallery_source_access_denied_dialog_button => 'Odprite Nastavitve';

  @override
  String get share => 'Deli';

  @override
  String share_product_text(String url) {
    return 'Oglejte si ta izdelek na Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Oglejte si ta izdelek na Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Oglejte si ta izdelek na Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Oglejte si ta izdelek na Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Oglejte si moj seznam izdelkov na Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'Posnemi fotografijo';

  @override
  String get choose_from_gallery => 'Izberite iz galerije';

  @override
  String get image_upload_queued =>
      'Slika bo naložena v ozadju v najkrajšem možnem času.';

  @override
  String get add_price_queued =>
      'Cena bo poslana na strežnik v najkrajšem možnem času.';

  @override
  String get background_task_title_full_refresh =>
      'Začetek osveževanja vseh lokalno shranjenih izdelkov';

  @override
  String get background_task_title_top_n =>
      'Začetek prenosa najbolj priljubljenih izdelkov';

  @override
  String get expand_nutrition_facts => 'Razširi tabelo prehranskih podatkov';

  @override
  String get expand_nutrition_facts_body =>
      'Razširite tabelo s hranilnimi vrednostmi';

  @override
  String get expand_ingredients => 'Razširi sestavine';

  @override
  String get expand_ingredients_body =>
      'Ohranite ploščo s sestavinami razširjeno';

  @override
  String get no_internet_connection => 'Ni internetne povezave';

  @override
  String get world_results_label => 'Ves svet';

  @override
  String get world_results_action => 'Razširite svoje iskanje na svet';

  @override
  String get copy_to_clipboard => 'Kopiraj';

  @override
  String get paste_from_clipboard => 'Prilepi iz odložišča';

  @override
  String get no_data_available_in_clipboard => 'V odložišču ni podatkov';

  @override
  String get clipboard_barcode_copy => 'Kopiraj črtno kodo v odložišče';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Črtna koda $barcode je bila kopirana v odložišče!';
  }

  @override
  String get open_product_website => 'Odprite ta izdelek na spletni strani';

  @override
  String get language_picker_label => 'Vaš jezik';

  @override
  String get country_picker_label => 'Vaša država';

  @override
  String get currency_picker_label => 'Vaša valuta';

  @override
  String get help_with_openfoodfacts => 'Pomoč pri OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Izdelek bo posodobljen v ozadju v najkrajšem možnem času.';

  @override
  String get no_email_client_available_dialog_title =>
      'Brez e-poštnih aplikacij!';

  @override
  String get no_email_client_available_dialog_content =>
      'Prosimo, da nam ročno pošljete e-pošto na mobile@openfoodfacts.org';

  @override
  String get all_images => 'Vse slike';

  @override
  String get selected_images => 'Izbrane slike';

  @override
  String get product_card_remove_product_tooltip => 'Odstrani izdelek';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nova skenirana črtna koda: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Odstrani vse izdelke iz vrtiljaka';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Za primerjavo skenirajte vsaj dva izdelka';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Kliknite za primerjavo izdelkov, ki ste jih skenirali';

  @override
  String get scan_product_loading => 'Skenirali ste\nčrtno kodo:';

  @override
  String get scan_product_loading_initial =>
      'Iščemo ta izdelek!\nProsimo, počakajte nekaj sekund…';

  @override
  String get scan_product_loading_long_request =>
      'Še vedno iščemo ta izdelek!\nSe vam zdi, da traja dolgo, da se naloži? Se tudi nam zdi…';

  @override
  String get scan_product_loading_unresponsive =>
      'Ta izdelek še vedno iščemo.\nAli želite znova začeti iskanje?';

  @override
  String get scan_product_loading_restart_button => 'Ponovni začetek iskanja';

  @override
  String get portion_calculator_description =>
      'Izračunajte hranilne vrednosti za določeno količino';

  @override
  String get portion_calculator_hint => 'Količina v';

  @override
  String get portion_calculator_accessibility =>
      'Vnesite količino za izračun hranilne vrednosti';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Vnesite količino med $min in $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Manjkajoči podatki. Izračuna ni bilo mogoče izvesti.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Hranilna vrednost za $grams g (ali ml)';
  }

  @override
  String get offline_data => 'Podatki brez povezave';

  @override
  String get ocr_image_upload_instruction =>
      'Naložite sliko, da samodejno izvlečete informacije, ki jih vsebuje.';

  @override
  String get upload_image => 'Naloži fotografijo';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Prenos slike ni uspel';

  @override
  String get image_edit_url_error =>
      'Slike ni bilo mogoče urediti, ker URL slike ni bil nastavljen.';

  @override
  String get user_picture_source_remember => 'Zapomni si mojo izbiro';

  @override
  String get user_picture_source_ask => 'Vsakič vprašaj';

  @override
  String get robotoff_continue => 'Nadaljuj';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vprašanja',
      one: 'vprašanje',
    );
    return 'Naslednje $_temp0';
  }

  @override
  String get show_password => 'Prikaži geslo';

  @override
  String get owner_field_info_title =>
      'Vrednosti, ki jih je zagotovil proizvajalec';

  @override
  String get owner_field_info_message =>
      'S tem logotipom označujemo podatke, ki jih je posredoval proizvajalec, in jih morda ni mogoče urejati.';

  @override
  String get owner_field_info_close_button => 'Zapri te informacije';

  @override
  String get owner_field_image =>
      'To sliko je zagotovil proizvajalec. Morda je ni mogoče urejati.';

  @override
  String get edit_packagings_title => 'Komponente embalaže';

  @override
  String get edit_packagings_element_add => 'Dodajte komponento embalaže';

  @override
  String get edit_packagings_completed => 'Embalaža je popolna';

  @override
  String edit_packagings_element_title(int index) {
    return 'Komponenta embalaže #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Število enot';

  @override
  String get edit_packagings_element_hint_units =>
      'Vnesite število embalažnih enot enake oblike in materiala, ki jih izdelek vsebuje.';

  @override
  String get edit_packagings_element_field_shape => 'Oblika';

  @override
  String get edit_packagings_element_hint_shape =>
      'Vnesite ime oblike, navedeno v navodilih za recikliranje, če so na voljo, ali izberite obliko.';

  @override
  String get edit_packagings_element_example_shape => 'Steklenica';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Vnesite specifičen material, če ga je mogoče določiti (koda materiala znotraj trikotnika je pogosto navedena na embalaži), ali generični material (na primer plastika ali kovina), če niste prepričani.';

  @override
  String get edit_packagings_element_example_material => 'Steklo';

  @override
  String get edit_packagings_element_field_recycling =>
      'Navodila za recikliranje';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Navodila za recikliranje vnesite le, če so navedena na izdelku.';

  @override
  String get edit_packagings_element_example_recycling => 'Reciklirajte';

  @override
  String get edit_packagings_element_field_quantity =>
      'Neto količina izdelka na enoto';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Vnesite neto težo ali neto prostornino in navedite enoto (na primer g ali ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Teža ene prazne enote (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Pred tehtanjem odstranite preostalo hrano ter operite in posušite embalažo. Če je mogoče, uporabite tehtnico z natančnostjo 0,1 g ali 0,01 g.';

  @override
  String get background_task_title => 'Čakajoči prispevki';

  @override
  String get background_task_subtitle =>
      'Vaši prispevki se samodejno shranijo na naš strežnik, vendar ne vedno v realnem času.';

  @override
  String get background_task_list_empty => 'Ni čakajočih nalog v ozadju';

  @override
  String get background_task_error_server_time_out =>
      'Časovna omejitev strežnika';

  @override
  String get background_task_error_no_internet =>
      'Napaka internetne povezave. Poskusite pozneje.';

  @override
  String get background_task_operation_unknown => 'neznana vrsta operacije';

  @override
  String get background_task_operation_details => 'podrobne spremembe';

  @override
  String get background_task_operation_image => 'nalaganje fotografij';

  @override
  String get background_task_operation_refresh =>
      'Osvežitev se je zakasnila po nalaganju fotografije';

  @override
  String get background_task_run_started => 'začel';

  @override
  String get background_task_run_not_started => 'še ni začeto';

  @override
  String get background_task_run_to_be_deleted => 'za izbris';

  @override
  String get background_task_question_stop =>
      'Ali želite to nalogo čim prej ustaviti?';

  @override
  String get feed_back => 'Povratne informacije';

  @override
  String get undo => 'Razveljavi';

  @override
  String get copy_email_to_clip_board => 'Kopiraj e-pošto v odložišče';

  @override
  String get please_send_us_an_email_to =>
      'Prosimo, pošljite nam ročno e-pošto na';

  @override
  String get email_copied_to_clip_board =>
      'E-pošta je bila kopirana v odložišče!';

  @override
  String get select_accent_color => 'Izberite barvo poudarka';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Modra';

  @override
  String get color_cyan => 'Cian';

  @override
  String get color_green => 'Zelena';

  @override
  String get color_light_brown => 'Privzeto';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Oranžna';

  @override
  String get color_pink => 'Roza';

  @override
  String get color_red => 'Rdeča';

  @override
  String get color_rust => 'Rja';

  @override
  String get color_teal => 'Modrozelena';

  @override
  String get text_contrast_mode => 'Kontrast besedila';

  @override
  String get contrast_high => 'Visoka';

  @override
  String get contrast_medium => 'Srednje';

  @override
  String get contrast_low => 'Nizko';

  @override
  String get product_refresher_internet_not_found =>
      'Izdelka ni bilo mogoče najti!';

  @override
  String get product_refresher_internet_not_connected =>
      'Niste povezani z internetom!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Strežnik ne deluje ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Napaka strežnika ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Izdelka ni bilo mogoče najti!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Izdelek z naslednjo črtno kodo ne obstaja v naši bazi podatkov: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Ni internetne povezave!';

  @override
  String get product_loader_network_error_message =>
      'Preverite, ali je vaš pametni telefon povezan z omrežjem WiFi ali ima omogočene mobilne podatke.';

  @override
  String get page_not_found_title => 'Strani ni bilo mogoče najti!';

  @override
  String get page_not_found_button => 'Nazaj na domačo stran';

  @override
  String get download_data => 'Prenesi podatke';

  @override
  String get download_top_products =>
      'Prenesite 1000 najboljših izdelkov v vaši državi za takojšnje skeniranje';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
    );
    return 'Download the top $_temp0 in your country for instant scanning';
  }

  @override
  String get download_in_progress =>
      'Prenos podatkov\nTo lahko traja nekaj časa';

  @override
  String downloaded_products(int num) {
    return 'Dodanih $num izdelkov';
  }

  @override
  String get update_offline_data => 'Posodobi podatke o izdelkih brez povezave';

  @override
  String get update_local_database_sub =>
      'Posodobite lokalno podatkovno bazo izdelkov z najnovejšimi podatki iz Open Food Facts';

  @override
  String get clear_local_database => 'Počisti podatke o izdelkih brez povezave';

  @override
  String get clear_local_database_sub =>
      'Iz aplikacije počistite vse lokalne podatke o izdelkih, da sprostite prostor';

  @override
  String deleted_products(int num) {
    return '$num izdelkov izbrisanih';
  }

  @override
  String get loading => 'Nalaganje…';

  @override
  String get know_more => 'Več informacij';

  @override
  String get offline_data_desc =>
      'Kliknite za več informacij o podatkih brez povezave';

  @override
  String get offline_product_data_title => 'Podatki o izdelkih brez povezave';

  @override
  String available_for_download(int num) {
    return '$num izdelkov na voljo za takojšnje skeniranje';
  }

  @override
  String get country_selector_title => 'Izberite svojo državo:';

  @override
  String get currency_selector_title => 'Izberite svojo valuto:';

  @override
  String get language_selector_title => 'Izberite svoj jezik:';

  @override
  String get language_selector_section_selected => 'Izbrani jeziki';

  @override
  String get language_selector_section_frequently_used => 'Pogosto uporabljeno';

  @override
  String get action_delete_list => 'Izbriši';

  @override
  String get action_change_list => 'Spremeni trenutni seznam';

  @override
  String get product_list_create => 'Ustvari';

  @override
  String get product_list_create_tooltip => 'Ustvari nov seznam';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-ocena A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Nov izračun)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (nov izračun)';

  @override
  String get nutriscore_unknown => 'Neznana hranilna vrednost';

  @override
  String get nutriscore_unknown_new_formula =>
      'Neznan nutri-rezultat (nov izračun)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score se ne uporablja.';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score se ne uporablja (nov izračun)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Zelena ocena A';

  @override
  String get environmental_score_b_new => 'Zelena ocena B';

  @override
  String get environmental_score_c_new => 'Zelena ocena C';

  @override
  String get environmental_score_d_new => 'Zelena ocena D';

  @override
  String get environmental_score_e_new => 'Zelena ocena E';

  @override
  String get environmental_score_unknown_new => 'Neznan zeleni rezultat';

  @override
  String get environmental_score_not_applicable_new =>
      'Zelena ocena ni uporabna';

  @override
  String get nova_group_generic_new => 'Ultra predelana živila - skupine NOVA';

  @override
  String get nova_group_1 => 'Skupina NOVA 1';

  @override
  String get nova_group_2 => 'Skupina NOVA 2';

  @override
  String get nova_group_3 => 'Skupina NOVA 3';

  @override
  String get nova_group_4 => 'Skupina NOVA 4';

  @override
  String get nova_group_unknown => 'Neznana skupina NOVA';

  @override
  String get nutrition_facts => 'Ravni hranil';

  @override
  String get faq_title_partners =>
      'Partnerji in pokrovitelji nevladne organizacije';

  @override
  String get faq_title_vision =>
      'Vizija, poslanstvo, vrednote in programi Odprtega programa za živila';

  @override
  String get faq_title_install_beauty =>
      'Namestite Open Beauty Facts za ustvarjanje kozmetične baze podatkov';

  @override
  String get faq_title_install_pet =>
      'Namestite Open Pet Food Facts, da ustvarite bazo podatkov o hrani za hišne ljubljenčke';

  @override
  String get faq_title_install_product =>
      'Namestite Open Products Facts, da ustvarite podatkovno zbirko izdelkov in podaljšate življenjsko dobo predmetov.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nov izračun Nutri-Score: kaj je novega?';

  @override
  String get contact_title_pro_page =>
      'Profesionalec? Uvozite svoje izdelke v Open Food Facts';

  @override
  String get contact_title_pro_email => 'Kontakt producenta';

  @override
  String get contact_title_press_page => 'Stran za medije';

  @override
  String get contact_title_press_email => 'Kontakt za medije';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'Naročite se na naš skupnostni koledar';

  @override
  String get hunger_games_loading_line1 => 'Prosim, dajte nam nekaj sekund…';

  @override
  String get hunger_games_loading_line2 => 'Prenašamo vprašanja!';

  @override
  String get hunger_games_error_label =>
      'Argh! Nekaj je šlo narobe… in vprašanj ni bilo mogoče naložiti.';

  @override
  String get hunger_games_error_retry_button => 'Poskusimo znova!';

  @override
  String get reorder_attribute_action => 'Prerazporedite atribute';

  @override
  String get link_cant_be_opened =>
      'Te povezave ni mogoče odpreti v vaši napravi. Preverite, ali imate nameščen brskalnik.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Podrobnosti za $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Podrobnosti za $pageName z $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Deli';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Kje najdem nov izračun Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score se uporablja v 7 državah: Franciji, Nemčiji, Belgiji, Španiji, Luksemburgu, na Nizozemskem in v Švici.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Proizvajalci imajo po podpisu odloka največ **2 leti** časa, da stari izračun nadomestijo z novim.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Kaj je zeleni rezultat?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Zeleni rezultat je logotip, katerega cilj je obveščati vas o **vplivu hrane na okolje**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Barvna koda se razlikuje od temno zelene (**A+**) za izdelke z **najmanjšim vplivom** do temno rdeče (**F**) za izdelke z **največjim vplivom**.';

  @override
  String get guide_greenscore_logos_caption => 'Logotipi Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Jedro: Ocena življenjskega cikla (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Znanstvena ocena kategorij živil';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Za vsako kategorijo izdelkov se določi **referenčna** ocena z uporabo podatkov iz okoljske baze podatkov Agribalyse (ki sta jo zasnovala ADEME in INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Analiza življenjskega cikla** je standardizirana metoda ocenjevanja za izvajanje večstopenjske in večkriterialne okoljske presoje.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Meri:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 proizvodnih korakov';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Kmetijstvo';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Obdelava';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Pakiranje';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Prevoz';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribucija';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Poraba';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 kazalnikov vpliva na okolje';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Podnebne spremembe/ogljični odtis';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Izčrpavanje ozonske plasti';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ionizirajoče sevanje';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Zemljišče';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Poraba vode in energije';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Onesnaženje zraka';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Morska in sladka voda (delci, zakisljevanje, evtrofikacija)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Izčrpavanje virov.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonusi in kazni';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Za nagrajevanje boljših izdelkov znotraj kategorije nato uporabimo **bonuse in kazni na podlagi več meril**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Izdelkom, ki imajo **uradno etiketo, etiketo ali certifikat, ki zagotavlja okoljske koristi** (ekološki, poštena trgovina, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC), se dodeli **bonus**.';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Poreklo sestavin';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Bonus** se dodeli glede na poreklo sestavin. Ta bonus upošteva **vpliv na prevoz** in tudi **okoljsko politiko** države posameznega proizvajalca.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Izdelki, ki vsebujejo sestavine z znatnimi negativnimi vplivi na biotsko raznovrstnost in ekosisteme, kot je palmovo olje, katerega proizvodnja je odgovorna za obsežno krčenje gozdov, so **kaznjeni**.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Pakiranje';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Kazen** se izračuna ob upoštevanju **krožnosti embalaže** (uporaba recikliranih surovin in možnost recikliranja) in prekomernega pakiranja.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Za natančen izračun zelene ocene (Green-Score) so potrebne **informacije, ki niso nujno navedene na embalaži** (kot sta izvor in natančen odstotek posamezne sestavine) ali ki so redko na voljo v uporabni obliki (kot je seznam vseh sestavnih delov embalaže z natančnimi vrstami uporabljene plastike).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Povprečne vrednosti se uporabljajo, kadar te informacije še niso na voljo**, vendar zdaj pozivamo vse, da nam pomagajo zbrati te informacije, ki bodo zelo koristne za Green-Score, pa tudi za številne druge namene.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Kako lahko pomagajo državljani?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Vsi državljani nam lahko pomagajo zbrati in strukturirati informacije, ki so prisotne na izdelkih ali ki jih je mogoče iz njih razbrati, kot so informacije o **embalaži**: »Misija Emballages«: obsežen skupni popis embalaže za vse živilske izdelke (v francoščini).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Kako lahko pomagajo proizvajalci';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Proizvajalci nam lahko svoje podatke pošljejo neposredno prek naše brezplačne platforme za proizvajalce.';

  @override
  String get guide_greenscore_better_product_title =>
      'Kateri izdelek je boljši za planet?';

  @override
  String get guide_greenscore_better_product_arg1_title => 'Težko je reči';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Izbira trajnostne hrane je ena najmočnejših stvari, ki jih lahko storimo za podnebje, saj **naš globalni prehranski sistem je odgovoren za več kot četrtino vseh emisij toplogrednih plinov**.\n(Vir: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Imaš moč!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Dobra novica je, da nam to ponuja močan način za ustvarjanje sprememb.\n**Vsak od nas poje približno 1000 obrokov na leto**. To je 1000 priložnosti, da **izberemo boljšo prihodnost za planet**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Pomaga pri odgovornosti in odločanju';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Izbira trajnostne hrane se lahko zdi zapletena. Oznake so zmedene in informacije pogosto manjkajo. Green-Score je bil ustvarjen zato, da bi to poenostavil, saj vam daje **jasno**, **znanstveno utemeljeno** in **transparentno** okoljsko oceno za živila, točno tam, kjer jo potrebujete: med nakupovanjem.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Preglednost';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Za razliko od lastniških oznak je izračun Green-Score **popolnoma odprt** in ga lahko **preveri kdorkoli**.';

  @override
  String get guide_nova_title => 'Ultra predelana živila';

  @override
  String get guide_nova_what_is_nova_title => 'Kaj je ultraprocesiranje?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Skupine NOVA vas obveščajo o stopnji predelave hrane.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Klasifikacija NOVA omogoča razvrstitev živil v **4 skupine** glede na njihovo **stopnjo industrijske predelave** (minimalno predelana ali nepredelana živila, kulinarične sestavine, predelana živila, ultra predelana živila).';

  @override
  String get guide_nova_logos_caption => 'Logotipi NOVA';

  @override
  String get guide_nova_groups_title => '4 skupine NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Obstajajo 4 skupine NOVA, problematična pa je skupina 4 - Ultra predelana živila.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimalno predelana ali nepredelana živila';

  @override
  String get guide_nova_groups_arg1_text =>
      'Nepredelana (ali naravna) živila so **užitni deli rastlin** (semena, plodovi, listi, stebla, korenine) **ali živali** (mišice, drobovina, jajca, mleko), pa tudi glive, alge in voda, potem ko so ločeni od narave.';

  @override
  String get guide_nova_groups_arg2_title => 'Predelane kulinarične sestavine';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Predelana živila';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include Various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic Fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. They can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra predelana živila';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-Processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are Directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Težave z ultraprocesiranjem';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Ekstremna predelava živilskih sestavin';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Mnogi so **pridobljeni z nadaljnjo predelavo sestavin hrane**, kot so hidrogenirana ali interesterificirana olja, hidrolizirane beljakovine, izolat sojinih beljakovin, maltodekstrin, invertni sladkor in koruzni sirup z visoko vsebnostjo fruktoze.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aditivi, ki presegajo zgolj varnost živil';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Aditivi v ultra predelani hrani vključujejo nekatere, ki se uporabljajo tudi v predelani hrani, kot so konzervansi, antioksidanti in stabilizatorji. Razredi aditivov, ki jih najdemo samo v ultra predelanih izdelkih, vključujejo tiste, ki se uporabljajo **za posnemanje ali izboljšanje senzoričnih lastnosti živil ali za prikrivanje neokusnih vidikov končnega izdelka**. Ti aditivi vključujejo barvila in druga barvila, stabilizatorje barv; arome, ojačevalce okusa, sladila brez sladkorja; in pomožna sredstva za predelavo, kot so gaziralnik, učvrščevalnik, sredstvo za povečanje in preprečevanje nabiranja snovi, sredstva za odstranjevanje penjenja, sredstva proti sprijemanju in glaziranje, emulgatorji, vezivna sredstva in humektanti.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Obdelava, ki je ne morete opraviti doma';

  @override
  String get guide_nova_explanations_arg3_text =>
      'Za kombiniranje običajno številnih sestavin in ustvarjanje končnega izdelka (zato »ultra predelan«) se uporablja **množica zaporedij postopkov**. Postopki vključujejo več postopkov, **ki nimajo domačih ustreznic**, kot so hidrogeniranje in hidrolizacija, ekstrudiranje in oblikovanje ter predobdelava za cvrtje.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Plenilski in finančni vidiki ultraprocesiranja';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Splošni namen ultra predelave je ustvariti blagovne znamke**, **priročne** (trajne, pripravljene za uživanje), **privlačne** (hiper okusne) in **zelo donosne** (s poceni sestavinami) živilske izdelke, namenjene izpodrivanju vseh drugih skupin živil. Ultra predelana živila so običajno privlačno pakirana in se intenzivno tržijo.';

  @override
  String get guide_nova_explanations_arg5_title => 'Nevarnost za zdravje';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Od leta 2018 so bile z NutriNet-Santé poudarjene prve povezave med **uživanjem ultra predelane hrane in povečanim tveganjem za raka, bolezni srca in ožilja ter sladkorno boleznijo**. Danes te ugotovitve potrjuje več kot 90 študij po vsem svetu.\nNajmočnejše povezave so povezane z **debelostjo, umrljivostjo zaradi bolezni srca in ožilja ter depresivnimi simptomi**. Pri otrocih se učinki opažajo predvsem pri telesni teži in neravnovesju lipidov.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Države priporočajo njihovo omejitev';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Nekatere države uporabljajo skupine NOVA za svoje prehranske smernice ali cilje, na primer:\n\n- **🇧🇷 Brazilske** prehranske smernice **priporočajo omejitev** uživanja predelane hrane in izogibanje ultra predelani hrani.\n\n- **🇫🇷 Francija** ima za cilj **zmanjšati uživanje ultra predelane hrane iz skupine 4 za 20 %**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Dobrodošli na Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Kaj so odprta dejstva o hrani?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts je **sodelovalna**, **brezplačna** in **odprta** baza podatkov o živilih z vsega sveta.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Verjamemo, da bi moral imeti vsakdo dostop do informacij o tem, kaj je. Z zbiranjem podatkov o sestavinah, alergenih, hranilnih vrednostih in drugem **opolnomočamo potrošnike, da se informirano odločajo** in spodbujamo živilsko industrijo k **večji preglednosti**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Značilnosti odprtih dejstev o hrani';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Prejemajte opozorila o neželenih sestavinah';

  @override
  String get guide_open_food_facts_tips_title =>
      'Nasveti za odlične fotografije';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Česa ne smete storiti';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Izogibajte se sencam in bleščanju.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Brez zamegljenega ali neostrega besedila.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Ne izrezujte delov besedila.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Izogibajte se živahnim ozadjem.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Kaj storiti';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Uporabite dobro, enakomerno osvetlitev.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Poskrbite, da bo besedilo ostro in berljivo.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Zabeležite celoten seznam sestavin.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Izdelek hranite na ravni površini.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Pomagajte nam zgraditi \"Wikipedijo hrane\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Ocena hranilne kakovosti';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Rezultat za izogibanje ultra predelani hrani';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Rezultat za planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-sl.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Dobrodošli na Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Kaj je Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts širi naše poslanstvo na naše kosmate prijatelje! Gre za **bazo podatkov o hrani za hišne ljubljenčke za mačke, pse in druge hišne ljubljenčke**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Zbiramo informacije o **sestavinah**, **analizi hranil** in smernicah za hranjenje, da bi lastnikom hišnih ljubljenčkov pomagali izbrati najboljšo hrano za potrebe svojih živali.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Značilnosti odprtih dejstev o hrani za hišne ljubljenčke';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Prejemajte opozorila o neželenih sestavinah';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Je vaš ljubljenček alergičen na katero od sestavin? Seznam kozmetičnih sestavin, ki se jim je treba izogniti, lahko nastavite kar v aplikaciji!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Nasveti za odlične fotografije';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title =>
      'Česa ne smete storiti';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Izogibajte se sencam in bleščanju.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Brez zamegljenega ali neostrega besedila.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Ne izrezujte delov besedila.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Izogibajte se živahnim ozadjem.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Kaj storiti';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Uporabite dobro, enakomerno osvetlitev.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Poskrbite, da bo besedilo ostro in berljivo.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Zabeležite celoten seznam sestavin.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Izdelek hranite na ravni površini.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'Opomba o točkovanju';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Razvoj sistema točkovanja hrane za hišne ljubljenčke **trenutno ni prednostna naloga**. Metodologija bi bila zapletena, saj se prehranske potrebe zelo razlikujejo glede na vrsto, starost in zdravstveno stanje. Zaenkrat še nismo našli nobene neodvisne znanstvene ekipe, ki bi bila sposobna razviti takšno točkovanje.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-sl.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Dobrodošli na Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Kaj so odprta dejstva o lepoti?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts je skupna baza podatkov o **kozmetičnih izdelkih**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Naš cilj je dešifrirati sezname sestavin, da boste lažje **razumeli, kaj je v vaših izdelkih za osebno nego**. Od vlažilnih krem do ličil zbiramo podatke o sestavinah, alergenih in embalaži, da bi spodbudili preglednost v kozmetični industriji.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Značilnosti Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Prejemajte opozorila o neželenih sestavinah';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ste alergični na katero od sestavin? Želite se izogniti komedogenim snovem? Želite se izogniti kontroverznim sestavinam? Seznam kozmetičnih sestavin, ki se jim morate izogniti, lahko nastavite kar v aplikaciji!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Nasveti za odlične fotografije';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Česa ne smete storiti';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Izogibajte se sencam in bleščanju.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Brez zamegljenega ali neostrega besedila.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Ne izrezujte delov besedila.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Izogibajte se živahnim ozadjem.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Kaj storiti';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Uporabite dobro, enakomerno osvetlitev.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Poskrbite, da bo besedilo ostro in berljivo.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Zabeležite celoten seznam sestavin.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Če je steklenica ukrivljena, posnemite toliko slik, kot jih potrebujete.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Morda boste morali odlepiti etiketo, da si ogledate seznam sestavin.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Izdelek hranite na ravni površini.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Opomba o točkovanju';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Za razliko od živilskih izdelkov svet kozmetike **nima splošno priznanega, vladno podprtega sistema ocenjevanja, kot je Nutri-Score**. Učinki sestavin so lahko zelo osebni in odvisni od tipa kože, alergij in individualnih težav.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-sl.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Dobrodošli na Odprtih cenah!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Kaj so odprte cene?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices je projekt za **zbiranje in deljenje cen izdelkov po vsem svetu**. Gre za javno dostopen nabor podatkov, ki ga je mogoče uporabiti za raziskave, analize in drugo. Open Prices razvija in vzdržuje Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'Kako delujejo odprte cene?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Zbiramo odprtokodne podatke o cenah prek množičnega financiranja.** Cene lahko uporabniki dodajo prek te spletne aplikacije ali prek uradne mobilne aplikacije Open Food Facts. Prispevajo lahko tudi trgovci na drobno ali aplikacije tretjih oseb z uporabo našega API-ja.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Zbirajte fotografije cenovnih etiket v hodnikih';

  @override
  String get guide_open_prices_how_arg2_title => 'Zberite fotografije računov';

  @override
  String get guide_open_prices_why_title => 'Zakaj Open Food Facts to počne?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informacije o cenah so izjemnega pomena za razumevanje prehranskih sistemov. So ključni dejavnik za razumevanje stroškov hrane in spodbujanje bolj zdrave prehrane. Podatki o odpiralnih cenah so način, da raziskovalcem, novinarjem in državljanom olajšajo **boljše razumevanje geografskih in časovnih sprememb cen hrane**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Spremljajte razvoj cen skozi čas';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Poglejte si **evolucijo cen**: krčenje inflacije, poceni inflacija, lahko ju spremljamo skupaj!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Primerjajte cene v vaši bližini';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Ko dobimo več cen, lahko opazite **najcenejše trgovine v svoji bližini**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Ste razmišljali o tem, da bi pobrali cene s spletnih strani trgovcev na drobno?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Zaradi pravnih in tehničnih razlogov **strganja cen s spletnih strani trgovcev na drobno ne smatramo za veljaven način prispevanja k Open Prices**. Želimo zagotoviti, da so cene, ki jih zbiramo, točne in posodobljene, prejemanje strganih cen od sodelujočih pa nam tega ne omogoča.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Strganje cen je možnost, ki se upošteva v prihodnji različici Open Prices, vendar bi to storil sam Open Prices, da bi lahko imeli dokazilo o ceni na podlagi strani HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Cene lahko prispevate z uporabo našega API-ja.\nČe želite prispevati cene v večjem obsegu, nas kontaktirajte na prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Dobrodošli na spletni strani Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Kaj so dejstva o odprtih izdelkih?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts je obsežna, odprta baza podatkov za **vse izdelke s črtno kodo, ki niso hrana, kozmetika ali hrana za hišne ljubljenčke**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Od **elektronike** do **igrač** in od **oblačil** do **čistilnih sredstev**, če ima črtno kodo, jo je mogoče dodati. Cilj tega projekta je ustvariti »internet stvari« za vsakdanje predmete, s čimer bi informacije o njih postale splošno dostopne.';

  @override
  String get guide_open_products_facts_features_title =>
      'Značilnosti odprtih izdelkov Dejstva';

  @override
  String get guide_open_products_facts_features_text =>
      'Cilj Open Products Facts je potrošnikom omogočiti **podaljšanje življenjske dobe predmetov** z zagotavljanjem krožnih rešitev za vzdrževanje, **popravilo**, **recikliranje** njihovih predmetov ali pa jim dati novega lastnika.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Ogljični odtis nekaterih izdelkov';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Vpliv CO2**, ki ga je pripravil francoski organ za okolje ADEME, zagotavlja **ogljični vpliv** za številne kategorije, zato poskrbite, da boste izdelke natančno kategorizirali.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Indeks popravljivosti za številne izdelke';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Kadar koli bo na voljo francoski indeks popravljivosti, ga bomo prikazali. Poleg tega lahko **z uporabo orodja Folksonomy Engine** začnete zbirati spremenljivke, da ga bomo lahko v prihodnje sami ponovno izračunali, tudi v državah, kjer ni na voljo.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Poiščite načine za donacijo/preprodajo svojega izdelka';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Ponujamo povezave do **storitev tretjih oseb, ki so prijazne do krožnega gospodarstva**, ki vam pomagajo pridobiti želeni izdelek, kot rabljen izdelek, da bi bili prijaznejši do planetarnih virov.\nUpoštevajte, da za to nismo plačani in da sistem deluje le kot primer za dve spletni strani v Franciji. Ta sistem lahko pomagate razširiti tako, da na wikiju dokumentirate več spletnih mest.';

  @override
  String get guide_open_products_facts_information_title =>
      'Katere informacije so koristne?';

  @override
  String get guide_open_products_facts_information_text =>
      'Za tako širok nabor elementov so **podatki, ki jih zbiramo, prilagodljivi**. Da bi to dosegli, **smo ustvarili Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Folksonomski mehanizem';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine je orodje, ki vam pomaga dopolniti izdelke z ustreznimi lastnostmi. To pomaga izboljšati iskanje in odkritost, hkrati pa tudi izračunati in prikazati zanimive stvari v prihodnosti.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Dodate lahko poljubne ključe in vrednosti, kot na primer: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Prejeli boste samodejni predlog možnih lastnosti in dobrodošli, da dodate in dokumentirate nove za svoje najljubše vrste izdelkov.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-sl.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Odprite nastavitve hrane';

  @override
  String get guide_coming_soon_button_title => 'Kmalu na voljo';

  @override
  String get guide_learn_more_subtitle => 'Dotaknite se za več informacij';

  @override
  String get preview_badge => 'Predogled';

  @override
  String get prices_feedback_form =>
      'Kliknite tukaj, če nam želite poslati svoje mnenje o tej novi funkciji!';

  @override
  String get menu_button_list_actions => 'Izberite dejanje';

  @override
  String get error_loading_photo => 'Napaka pri nalaganju fotografije';

  @override
  String get photo_viewer_action_use_picture_as => 'Uporabi kot…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Uporabi to sliko kot…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Uporabi to sliko kot… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Podrobnosti';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Podrobnosti te fotografije';

  @override
  String get photo_viewer_details_title => 'Podrobnosti fotografije';

  @override
  String get photo_viewer_details_contributor_title => 'Sodelavec';

  @override
  String get photo_viewer_details_size_title => 'Velikost';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height slikovnih pik';
  }

  @override
  String get photo_viewer_details_date_title => 'Datum';

  @override
  String get photo_viewer_details_url_title => 'URL-naslov';

  @override
  String get product_page_compatibility_score => 'Združljivo';

  @override
  String get user_lists_action_multi_select => 'Večkratna izbira';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Vaša ocena združljivosti: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Sprednja slika';

  @override
  String get product_image_ingredients_accessibility_label => 'Slika sestavin';

  @override
  String get product_image_nutrition_accessibility_label => 'Slika prehrane';

  @override
  String get product_image_packaging_accessibility_label => 'Slika embalaže';

  @override
  String get product_image_other_accessibility_label => 'Druga slika';

  @override
  String get product_image_outdated_message => 'Ta slika je morda zastarela';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (ta slika je morda zastarela)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (to sliko je morda zaklenil proizvajalec)';
  }

  @override
  String get product_image_error => 'Slike ni mogoče naložiti!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Ni mogoče naložiti $type (napaka omrežja?)';
  }

  @override
  String get product_page_image_no_image_available => 'Brez slike\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Za ta izdelek ni na voljo slike';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Spreminjanje vrstnega reda ali skrivanje dejanj';

  @override
  String get product_page_action_bar_setting_modal_title => 'Urejanje dejanj';

  @override
  String get product_page_action_bar_item_move_up => 'Premakni se navzgor';

  @override
  String get product_page_action_bar_item_move_down => 'Premakni navzdol';

  @override
  String get product_page_action_bar_item_enable => 'Omogoči dejanje';

  @override
  String get product_page_action_bar_item_disable => 'Onemogoči dejanje';

  @override
  String get product_page_pending_operations_banner_title =>
      'Nalaganje vaših sprememb…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Podatki, prikazani na tej strani, **še ne odražajo vaših sprememb**.\nPočakajte nekaj sekund…';

  @override
  String get product_add_a_language => 'Dodaj jezik';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Črtna koda $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Odstrani ta izdelek iz vrtiljaka';

  @override
  String get carousel_unsupported_header => 'Nepodprta črtna koda!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'Skenirane črtne kode Open Food Facts ne podpira!';

  @override
  String get carousel_error_header => 'Napaka!';

  @override
  String get carousel_error_title => 'To je pa škoda!';

  @override
  String get carousel_error_text_1 =>
      'Podatkov o tej črtni kodi ni bilo mogoče prenesti:';

  @override
  String get carousel_error_text_2 =>
      'Preverite internetno povezavo ali kliknite ta gumb:';

  @override
  String get carousel_error_button => 'Poskusi znova';

  @override
  String get carousel_unknown_product_header => 'Neznan izdelek';

  @override
  String get carousel_unknown_product_title =>
      'Čestitamo!\nNašli ste __redki dragulj!__';

  @override
  String get carousel_unknown_product_text =>
      'Naša skupna baza podatkov vsebuje več kot **3 milijone izdelkov**, vendar ta črtna koda ne obstaja: ';

  @override
  String get carousel_unknown_product_button => 'Dodaj ta izdelek';

  @override
  String get carousel_loading_header => 'Nalaganje informacij ...';

  @override
  String get carousel_loading_title =>
      'Pravkar ste skenirali izdelek z naslednjo črtno kodo:';

  @override
  String get carousel_loading_text =>
      'Iščemo ga v naši bazi podatkov z več kot **3 milijoni izdelkov!**';

  @override
  String get product_type_subtitle_food =>
      'Zelenjava, sadje, zamrznjena hrana…';

  @override
  String get product_type_subtitle_beauty => 'Ličila, mila, zobne paste…';

  @override
  String get product_type_subtitle_pet_food => 'Hrana za pse, mačke…';

  @override
  String get product_type_subtitle_product => 'Pametni telefoni, pohištvo…';

  @override
  String get photo_field_front => 'Fotografija izdelka';

  @override
  String get photo_field_ingredients => 'Slike sestavin';

  @override
  String get photo_field_nutrition => 'Fotografija prehrane';

  @override
  String get photo_field_packaging => 'Slika informacij o embalaži';

  @override
  String get photo_already_exists => 'Ta fotografija že obstaja';

  @override
  String get photo_missing => 'Ta fotografija manjka';

  @override
  String get date => 'Datum';

  @override
  String get photo_rotate_left => 'Zavrti levo';

  @override
  String get photo_rotate_right => 'Zavrti desno';

  @override
  String get photo_undo_action => 'Razveljavi prejšnje dejanje';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Zemljevid sveta $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Sodelavci OpenStreetMapa';

  @override
  String get not_applicable_short => 'Ni na voljo';

  @override
  String get knowledge_panel_warning_text => 'Opozorilo';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Zakaj se ta Nutri-Score razlikuje od tistega na embalaži?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Obstajata dve možni razlagi:\nSeznam sestavin in/ali hranilnih vrednosti ni posodobljen.\n\nZagotavljamo »nov izračun« Nutri-Score (ali V2). Preverite, ali imate na embalaži napis »Nov izračun«.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Preverite sestavine';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Preverite prehranska dejstva';

  @override
  String url_not_supported(String url) {
    return 'Žal URL-ja ne moremo odpreti:\n$url';
  }

  @override
  String get product_list_export => 'Izvoz';

  @override
  String get product_list_import => 'Uvoz';

  @override
  String get product_footer_action_barcode => 'Ogled črtne kode';

  @override
  String get product_footer_action_barcode_short => 'Črtna koda';

  @override
  String get product_footer_action_open_website => 'Odpri spletno mesto';

  @override
  String get product_footer_action_report => 'Poročilo';

  @override
  String get product_footer_action_contributor_guide => 'Pomoč';

  @override
  String get product_footer_action_data_quality_tags => 'Kakovost podatkov';

  @override
  String get product_page_tab_for_me => 'Zame';

  @override
  String get product_page_tab_website => 'Spletna stran';

  @override
  String get product_page_tab_prices => 'Cene';

  @override
  String get prices_explanation_card_title => 'Zakaj cene?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** je projekt za zbiranje in deljenje cen izdelkov po vsem svetu 🌍. Open Prices razvija in vzdržuje Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Več o tem';

  @override
  String get product_page_tab_folksonomy => 'Folksonomija';

  @override
  String get folksonomy_explanation_card_title =>
      'Kaj so atributi folksonomije?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atributi temeljijo na **ključih in vrednostih**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Te lastnosti ustvarijo in shranijo sodelavci za kakršno koli uporabo.';

  @override
  String get folksonomy_action_external_link_title => 'Odpri zunanjo povezavo';

  @override
  String get folksonomy_action_external_link_warning =>
      'Zunanje povezave so morda nevarne. Ali res želite obiskati to stran?';

  @override
  String get prices_products_empty_title => 'Cena ni na voljo';

  @override
  String get prices_products_empty_explanation => 'Bodite prvi, ki prispeva!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Najboljših $pageSize izdelkov (skupaj: $total)';
  }

  @override
  String get app_review_title => 'Ali uživate v tej aplikaciji?';

  @override
  String get app_review_low => 'Lahko bi bilo bolje';

  @override
  String get app_review_medium => 'Ni slabo';

  @override
  String get app_review_high => 'Obožujem to!';

  @override
  String get app_review_feedback_modal_title =>
      'Pomagajte nam izboljšati našo aplikacijo';

  @override
  String get app_review_feedback_modal_content =>
      'Če imate nekaj minut, ali lahko izpolnite ta obrazec, da se bomo lahko **izboljšali v prihodnjih posodobitvah**:';

  @override
  String get app_review_feedback_modal_open_form => 'Izpolnite obrazec';

  @override
  String get app_review_feedback_modal_later => 'Vprašaj me pozneje';

  @override
  String get nutrition_facts_extract_new =>
      'NOVO: Hranilne snovi lahko samodejno izvlečete iz slike!';

  @override
  String get nutrition_facts_extract_button_text => 'Izvleči zdaj';

  @override
  String get nutrition_facts_extract_in_progress => 'Pridobivanje v teku…';

  @override
  String get nutrition_facts_extract_successful => 'Ekstrakcija uspešna';

  @override
  String get nutrition_facts_extract_failed =>
      'Hranilnih snovi iz slike ni bilo mogoče izluščiti';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistika';

  @override
  String get prices_stats_title => 'Statistika cen';

  @override
  String get prices_stats_prices_section => 'Cene';

  @override
  String get prices_stats_products_section => 'Izdelki';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Sodelavci';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Razno';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Poraba';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Hrana';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Izdelki';

  @override
  String get prices_stats_pet_food => 'Hrana za hišne ljubljenčke';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Countries';

  @override
  String get prices_stats_price_tag => 'Cena';

  @override
  String get prices_stats_receipt => 'Potrdilo';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Spletna stran';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Drugo';

  @override
  String get prices_stats_last_updated => 'Nazadnje posodobljeno dne';

  @override
  String get prices_stats_error =>
      'Pri nalaganju statističnih podatkov je prišlo do napake.';

  @override
  String get product_edit_robotoff_question_answered => 'Odgovor na vprašanje!';

  @override
  String get product_edit_robotoff_proof => 'Dokaz';

  @override
  String get preferences_card_general => 'Splošno';

  @override
  String get preferences_prices_title => 'Cene';

  @override
  String get preferences_prices_subtitle =>
      'Upravljajte svoje cenovne nastavitve';

  @override
  String get preferences_card_project => 'Projekt Odprta dejstva o hrani';

  @override
  String get preferences_contribute_title => 'Prispevaj';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => 'Moja statistika';

  @override
  String get preferences_contribute_subtitle =>
      'Prevajajte, izboljšajte naša orodja…';

  @override
  String get preferences_connect_title => 'Poveži se';

  @override
  String get preferences_connect_subtitle =>
      'Stopite v stik z nami ali nas spremljajte na družbenih omrežjih';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      'Pomagajte nam obveščati milijone potrošnikov po vsem svetu';

  @override
  String get preferences_card_help => 'Pomoč in podpora';

  @override
  String get preferences_faq_title => 'Pogosta vprašanja';

  @override
  String get preferences_faq_subtitle =>
      'Pridobite odgovore na svoja vprašanja';

  @override
  String get logged_out => 'Odjavljen/a';

  @override
  String get preferences_app_bar_message => 'Hvala, ker ste eden naših članov!';

  @override
  String get preferences_app_bar_products_modified => 'Izdelek spremenjen';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats =>
      'Oglejte si vse statistične podatke';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Išči v $provider za »$keyword«';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Iskanje nastavitve (npr. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Dostopnost: Prikaži emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Dostopnost: Odstrani barve';

  @override
  String get preferences_app_settings_products => 'Izdelki';

  @override
  String get preferences_card_about => 'O programu';

  @override
  String get preferences_legal_information_title => 'Pravne informacije';

  @override
  String get preferences_legal_information_subtitle =>
      'Pogoji uporabe, politika zasebnosti in drugo';

  @override
  String get preferences_terms_of_use => 'Pogoji uporabe';

  @override
  String get preferences_legal_mentions => 'Pravni podatki';

  @override
  String get preferences_legal_header =>
      'Open Food Facts je podatkovna zbirka živil, **ki so jo ustvarili vsi za vsakogar**.\nUporabite jo lahko za boljše izbire hrane, in ker gre za **odprte podatke**, jo lahko kdorkoli **ponovno uporabi za kateri koli namen**.';

  @override
  String get preferences_privacy_policy => 'Pravilnik o zasebnosti';

  @override
  String get preferences_licenses => 'Licence';

  @override
  String get preferences_about_app_title => 'O aplikaciji';

  @override
  String get preferences_about_app_subtitle =>
      'Tehnične informacije, informacije za razvijalce in drugo';

  @override
  String get preferences_card_information => 'Informacije';

  @override
  String get preferences_version_number_title => 'Številka različice';

  @override
  String get preferences_scanner_title => 'Skener';

  @override
  String get preferences_app_store => 'Trgovina z aplikacijami';

  @override
  String get preferences_app_system_settings => 'Sistemske nastavitve';

  @override
  String get preferences_source_code => 'Dostop do izvorne kode';

  @override
  String get preferences_source_code_subtitle =>
      'In začnite vplivati na milijone';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Povej svetu';

  @override
  String get preferences_tips => 'Nasveti';

  @override
  String get tips_discover_nutriscore => 'Odkrijte novi Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Na spletni strani Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Upravljaj moj račun';

  @override
  String get preferences_manage_account_tooltip => 'Upravljajte svoj račun';

  @override
  String get preferences_change_password_title => 'Spremeni moje geslo';

  @override
  String get preferences_danger_zone => 'Nevarno območje';

  @override
  String get preferences_account_deletion_subtitle =>
      'Vsi vaši prispevki bodo izgubljeni';

  @override
  String get preferences_contributions_title => 'Prispevki';

  @override
  String get preferences_dev_mode_app_settings_title => 'Nastavitve aplikacije';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Zelo eksperimentalen način skeniranja izdelkov brez povezave';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Osveži vse izdelke s strežnika';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Prosim, izogibajte se temu, razen če je to nujno potrebno';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demo način';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Dodajanje kartic v skener';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Doda 3 vzorčne izdelke v skener';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Voditelj folksonomije';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Gostitelj: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Poskusi dostopnosti';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Izbira več izdelkov po cenah';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Uporabniki so naročili informacijske plošče po naročilu';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Začasni dostop do iskanja lokacije';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Vzporedna primerjava za 2 ali 3 izdelke';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Uvoz seznama izdelkov';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Rezultati in metodologije';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Odkrijte, kako se izračuna Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Odkrijte glavne spremembe metodologije';

  @override
  String get preferences_faq_discover_project_title => 'Odkrijte projekt';

  @override
  String get preferences_faq_discover_off_title =>
      'Odkrijte dejstva o odprti hrani';

  @override
  String get preferences_faq_discover_obf_title =>
      'Odkrijte odprta dejstva o lepoti';

  @override
  String get preferences_faq_discover_opff_title =>
      'Odkrijte dejstva o hrani za hišne ljubljenčke na Open';

  @override
  String get preferences_faq_discover_op_title => 'Odkrijte odprte cene';

  @override
  String get preferences_faq_discover_opf_title =>
      'Odkrijte dejstva o odprtih izdelkih';

  @override
  String get preferences_faq_faq_title =>
      'Pogosta vprašanja - Pogosto zastavljena vprašanja';

  @override
  String get preferences_faq_off_ngo_title =>
      'Nevladna organizacija Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informacije';

  @override
  String get preferences_connect_community_updates_title =>
      'Pridobite posodobitve skupnosti';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Ostanite na tekočem z novicami iz aplikacije in skupnosti';

  @override
  String get preferences_connect_community_calendar_title =>
      'Naročite se na naš skupnostni koledar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Sodelujte z udeležbo na enem od naših virtualnih dogodkov';

  @override
  String get preferences_connect_blog_title => 'Blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Pridobite najnovejše novice, takoj ko se zgodijo';

  @override
  String get preferences_connect_community_help_title =>
      'Poiščite pomoč skupnosti';

  @override
  String get preferences_connect_improve_app_title =>
      'Pomagajte nam izboljšati aplikacijo';

  @override
  String get preferences_connect_debug_info_title =>
      'Pošljite nam informacije o odpravljanju napak';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Pošljite nam e-pošto s podrobnimi informacijami o odpravljanju napak';

  @override
  String get preferences_connect_feedback_title =>
      'Pošljite nam povratne informacije o aplikaciji';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Pomagajte oblikovati prihodnost aplikacije';

  @override
  String get preferences_connect_survey_title =>
      'Izpolnite anketo o aplikaciji';

  @override
  String get preferences_connect_survey_subtitle =>
      'Pomagajte nam razumeti, kaj naj zgradimo naprej';

  @override
  String get preferences_connect_professionals_title => 'Strokovnjaki';

  @override
  String get preferences_connect_pro_subtitle =>
      'Popolnoma brezplačno, zagotavlja natančne podatke za 500 aplikacij in milijone potrošnikov. Samopostrežno, združljivo z vašim PIM ali preglednicami (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Za začetek stopite v stik z nami';

  @override
  String get preferences_connect_press_title => 'Mediji';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Pridobite vse gradivo, ki ga potrebujete za svoje poročilo';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Za vprašanja v medijih ali za obveščanje o vašem poročilu nas kontaktirajte';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Postanite aktivni prostovoljec';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Razvoj, komunikacija, oblikovanje… Vsakršno prostovoljstvo ali strokovno znanje je dobrodošlo!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Odkrijte nekaj številnih načinov, kako lahko prispevate';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Razvoj mobilnih aplikacij';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Naučite se, kako prispevati k razvoju programske opreme';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Dnevno nestabilne različice, povsem nove funkcije';

  @override
  String get preferences_contribute_local_community_title =>
      'Razširite svojo lokalno skupnost';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Pomoč pri programski opremi, vsebini in prevodih analiz sestavin';

  @override
  String get preferences_contribute_share_subtitle =>
      'Pripravili smo vam majhno predlogo, ki vam bo v pomoč :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Preprosti koraki za povečanje preglednosti hrane v vaši državi';

  @override
  String get preferences_contribute_data_quality_title => 'Kakovost podatkov';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Pridružite se ekipi za kakovost podatkov';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Pridružite se nam pri prizadevanjih za zagotovitev popolnosti in točnosti baze podatkov';

  @override
  String get preferences_contributions_products_added_title => 'Dodani izdelki';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Novi izdelki, ki sem jih dodal na Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Izdelki, ki jih moram dokončati';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Vsi nepopolni izdelki';

  @override
  String get preferences_my_contributions_prices_title => 'Cene';

  @override
  String get preferences_my_contributions_my_prices_title => 'Moje cene';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Moje cene, moji dokazi…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Izdelki, ki jih lahko pomagate dokončati';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Pomagajte izračunati Nutri-Score in Green-Score v vaši državi';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Cene, ki sem jih prispeval/a';

  @override
  String get preferences_prices_proofs_subtitle => 'Cenovne oznake in računi';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Fotografirajte račune in skenirajte povezane črtne kode';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Fotografirajte cene v trgovini';

  @override
  String get preferences_prices_newest_title => 'Najnovejše cene';

  @override
  String get preferences_prices_newest_subtitle =>
      'Najnovejše cene, ki jih je dodala skupnost Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Sodelavci z najvišjimi cenami';

  @override
  String get preferences_prices_metrics_title => 'Metrike odprte cene';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Spremljajte razvoj projekta';

  @override
  String get preferences_prices_ways_contribute_title => 'Načini prispevanja';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Potrdite cene, ki ste jih dodali sami ali drugi, s pomočjo umetne inteligence';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Hitro dodajte veliko računov ali fotografij polic iz fotoaparata';

  @override
  String get preferences_prices_challenges_title => 'Mesečni izzivi';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Sodelujte v mesečnih tematskih nalogah za zbiranje nagrad';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Ponovno pridobite svoje podatke o zvestobi';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Naučite se, kako zahtevati svoje podatke';

  @override
  String get preferences_page_customize_app_title => 'Prilagodite aplikacijo';

  @override
  String get preferences_page_contribute_project_title =>
      'Prispevajte k projektu';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Preprosti načini za pomoč Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologije ocenjevanja, pomoč in več o projektu';

  @override
  String get product_edit_robotoff_positive_button => 'Sprejmi predlog';

  @override
  String get product_edit_robotoff_negative_button => 'Zavrni predlog';

  @override
  String get product_edit_robotoff_show_proof => 'Pokaži dokaz';

  @override
  String get product_edit_robotoff_expand_proof => 'Razširi dokaz';

  @override
  String get product_page_tab_raw_data => 'Surovi podatki';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Stran $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Stran $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count od $total elementov';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count od $total elementov';
  }

  @override
  String item_count(int count) {
    return '$count artiklov';
  }

  @override
  String item_count_string(String count) {
    return '$count artiklov';
  }

  @override
  String get prices_no_result => 'Ni najdenih statističnih podatkov o cenah.';

  @override
  String get prices_error_loading_more_items =>
      'Napaka pri nalaganju več elementov';

  @override
  String get prices_proof_error =>
      'Preverjanje pristnosti ni uspelo, dokazov ni mogoče pridobiti';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count od $total dokazov';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count od $total sodelavcev';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count od $total lokacij';
  }

  @override
  String prices_locations_count(int count) {
    return '$count lokacij';
  }

  @override
  String get restart_to_apply_message =>
      'Znova zaženite aplikacijo, da se spremembe uporabijo.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafični vmesnik';

  @override
  String get preferences_app_settings_media_title => 'Mediji';

  @override
  String get preferences_about_app_development_title => 'Razvoj';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Odprti laboratoriji za dejstva o hrani';

  @override
  String get preferences_root_account_title => 'Račun';

  @override
  String get preferences_contribute_translate_header =>
      'Prinesite odprta dejstva o hrani v svoj jezik';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Vpišite se v alfa različico aplikacije';

  @override
  String get preferences_dev_mode_section_data =>
      'Prispevki in podatki o izdelkih';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Ne prikazuj folksonomije';

  @override
  String get preferences_account_title => 'Račun';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Dodano dne $created';
  }

  @override
  String get location_map_details_title => 'Podrobnosti o lokaciji';

  @override
  String get location_map_details_name => 'Ime';

  @override
  String get location_map_details_street => 'Ulica';

  @override
  String get location_map_details_city => 'Mesto';

  @override
  String get location_map_details_postcode => 'Poštna številka';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Koordinate';

  @override
  String get location_map_details_osm_id => 'ID OSM-a';
}
