// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class AppLocalizationsPt extends AppLocalizations {
  AppLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Sim';

  @override
  String get add => 'Adicionar';

  @override
  String get account_delete_message =>
      'Tem certeza de que deseja excluir sua conta?\nSe houver um motivo específico, compartilhe abaixo';

  @override
  String get reason => 'Motivo';

  @override
  String get okay => 'Ok';

  @override
  String get validate => 'Validar';

  @override
  String get create => 'Criar';

  @override
  String get applyButtonText => 'Aplicar';

  @override
  String get next_label => 'Seguinte';

  @override
  String get continue_label => 'Continuar';

  @override
  String get exit_label => 'Sair';

  @override
  String get previous_label => 'Anterior';

  @override
  String get go_back_to_top => 'Voltar ao topo';

  @override
  String get save => 'Guardar';

  @override
  String get save_confirmation => 'Você tem certeza de que deseja salvar?';

  @override
  String get skip => 'Ignorar';

  @override
  String get cancel => 'Cancelar';

  @override
  String get ignore => 'Ignorar';

  @override
  String get close => 'Fechar';

  @override
  String get no => 'Não';

  @override
  String get stop => 'Parar';

  @override
  String get finish => 'Terminar';

  @override
  String get calculate => 'Calcular';

  @override
  String get reset_food_prefs => 'Resetar preferências alimentares';

  @override
  String get error => 'Algo correu mal';

  @override
  String get error_occurred => 'Ocorreu um erro';

  @override
  String get featureInProgress =>
      'Ainda estamos trabalhando nesse recurso, fique atento';

  @override
  String get label_web => 'Visualizar no navegador';

  @override
  String get learnMore => 'Mais informações';

  @override
  String get unknown => 'Desconhecido';

  @override
  String get match_very_good => 'Correspondência excelente';

  @override
  String get match_good => 'Boa correspondência';

  @override
  String get match_poor => 'Baixa correspondência';

  @override
  String get match_may_not => 'Pode não corresponder';

  @override
  String get match_does_not => 'Não corresponde';

  @override
  String get match_unknown => 'Combinação desconhecida';

  @override
  String get match_short_very_good => 'Correspondência excelente';

  @override
  String get match_short_good => 'Boa correspondência';

  @override
  String get match_short_poor => 'Baixa correspondência';

  @override
  String get match_short_may_not => 'Pode não corresponder';

  @override
  String get match_short_does_not => 'Não corresponde';

  @override
  String get match_short_unknown => 'Combinação desconhecida';

  @override
  String get licenses => 'Licenças';

  @override
  String get looking_for => 'Procurando';

  @override
  String get welcomeToOpenFoodFacts => 'Bem-vindo ao Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts é uma organização global sem fins lucrativos dinamizada por comunidades locais.';

  @override
  String get productDataUtility =>
      'Veja as informações nutricionais relevantes às suas preferências.';

  @override
  String get healthCardUtility => 'Escolha alimentos que sejam bons para si.';

  @override
  String get ecoCardUtility =>
      'Escolha alimentos que sejam bons para o planeta.';

  @override
  String get server_error_open_new_issue =>
      'Nenhuma resposta do servidor! Você pode reportar o problema com o link a seguir.';

  @override
  String get sign_in_text =>
      'Entre na sua conta Open Food Facts para guardar as suas contribuições';

  @override
  String get incorrect_credentials => 'Nome do usuário ou senha incorretos.';

  @override
  String get password_lost_incorrect_credentials =>
      'Este endereço eletrónico ou este nome de utilizador não existe. Por favor, verifique as suas credenciais.';

  @override
  String get password_lost_server_unavailable =>
      'Estamos atualmente a sofrer lentidão nos nossos servidores e pedimos desculpa por isso. Por favor, tente novamente mais tarde.';

  @override
  String get login => 'Iniciar sessão';

  @override
  String get login_result_type_server_unreachable =>
      'Não foi possível estabelecer ligação à rede';

  @override
  String get login_result_type_server_issue =>
      'Problema no servidor. Por favor, tente mais tarde.';

  @override
  String get login_page_username_or_email =>
      'Por favor, insira o nome de utilizador ou o e-mail';

  @override
  String get login_page_password_error_empty =>
      'Por favor, introduza uma palavra-passe';

  @override
  String get create_account => 'Criar conta';

  @override
  String get sign_in => 'Iniciar sessão';

  @override
  String get sign_in_mandatory =>
      'Para essa funcionalidade, é necessário iniciar sessão.';

  @override
  String get help_improve_country =>
      'Ajude a melhorar o Open Food Facts no seu país';

  @override
  String get sign_out => 'Terminar sessão';

  @override
  String get sign_out_confirmation => 'Você tem certeza que deseja sair?';

  @override
  String get password => 'Palavra-passe';

  @override
  String get forgot_password => 'Esqueci-me da palavra-passe';

  @override
  String get forgot_password_question => 'Esqueceu-se da sua senha?';

  @override
  String get view_profile => 'Ver perfil';

  @override
  String get reset_password => 'Recuperar a palavra-passe';

  @override
  String get reset_password_explanation_text =>
      'Caso se tenha esquecido da palavra-passe, introduza o seu nome de utilizador ou e-mail para receber instruções para a criação de uma nova palavra-passe. Lembre-se também de verificar a pasta \"Spam\".';

  @override
  String get username_or_email => 'Nome de utilizador ou e-mail';

  @override
  String get reset_password_done =>
      'Enviámos um e-mail para o endereço associado à sua conta, com uma hiperligação para redefinir a palavra-passe. Verifique tambem a sua pasta \"Spam\"';

  @override
  String get send_reset_password_mail => 'Mudar a palavra-passe';

  @override
  String get enter_some_text => 'Por favor introduza algum texto';

  @override
  String get sign_up_page_title => 'Criar conta';

  @override
  String get sign_up_page_action_button => 'Criar conta';

  @override
  String get sign_up_page_action_doing_it => 'A criar a conta…';

  @override
  String get sign_up_page_action_ok =>
      'Parabéns! A sua conta foi criada com sucesso.';

  @override
  String get sign_up_page_display_name_hint => 'Nome';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Por favor, escolha o nome que deseja usar';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'O e-mail é obrigatório';

  @override
  String get sign_up_page_email_error_invalid => 'E-mail inválido';

  @override
  String get sign_up_page_username_hint => 'Nome de utilizador: público';

  @override
  String get sign_up_page_username_error_empty =>
      'Por favor introduza um nome de utilizador';

  @override
  String get sign_up_page_username_error_invalid =>
      'Por favor introduza um nome de utilizador válido';

  @override
  String get sign_up_page_username_description =>
      'O nome de utilizador não pode conter espaços, maiúsculas ou caracteres especiais.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'O nome de utilizador não pode exceder $value caracteres';
  }

  @override
  String get sign_up_page_password_hint => 'Palavra-passe';

  @override
  String get sign_up_page_password_error_empty =>
      'Por favor, introduza uma palavra-passe';

  @override
  String get sign_up_page_password_error_invalid =>
      'Por favor introduza uma palavra-passe com pelo menos 6 caracteres';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirme a palavra-passe';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Por favor, confirme a senha';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'As palavras-passe não coincidem';

  @override
  String get sign_up_page_agree_text => 'Concordo com a Open Food Facts';

  @override
  String get sign_up_page_terms_text =>
      'termos de utilização e contribuição do Open Food Facts';

  @override
  String get donate_url =>
      'https://world-pt.openfoodfacts.org/fazer-um-donativo-ao-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Ao criar uma conta, é obrigatório concordar com os Termos de Uso, porém, contribuições anônimas ainda podem ser feitas através do app';

  @override
  String get sign_up_page_producer_checkbox => 'Sou um produtor de alimentos';

  @override
  String get sign_up_page_producer_hint => 'Produtor / marca';

  @override
  String get sign_up_page_producer_error_empty =>
      'Por favor, insira um nome de um produtor ou marca';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Gostaria de subscrever o boletim informativo do Open Food Facts (pode cancelar a sua subscrição em qualquer momento)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Este nome já existe; escolha outro.';

  @override
  String get sign_up_page_email_already_exists =>
      'já existe, inicie sessão nessa conta ou tente com outro e-mail.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Por favor, indique um endereço de email válido.';

  @override
  String get sign_up_page_server_busy =>
      'Pedimos desculpa, estamos com algumas dificuldades técnicas para criar a sua conta. Por favor, tente mais tarde.';

  @override
  String get settingsTitle => 'Definições';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Escuro';

  @override
  String get darkmode_light => 'Claro';

  @override
  String get darkmode_system_default => 'Predefinição do sistema';

  @override
  String get thanks_for_contributing => 'Obrigado pela sua contribuição!';

  @override
  String get contributors_label => 'Eles estão a desenvolver a aplicação';

  @override
  String get contributors_dialog_title => 'Colaboradores';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Colaborador: $name';
  }

  @override
  String get contributors_description =>
      'Lista de todos os colaboradores desta aplicação';

  @override
  String get support => 'Suporte';

  @override
  String get support_join_slack => 'Peça ajuda no nosso canal Slack';

  @override
  String get support_via_forum => 'Peça ajuda no nosso fórum';

  @override
  String get support_via_email => 'Envie-nos um e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Enviar registos da aplicação?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Quer incluir os registos da aplicação anexados ao seu e-mail?';

  @override
  String get termsOfUse => 'Termos de utilização';

  @override
  String get legalNotices => 'Avisos legais';

  @override
  String get privacy_policy => 'Política de privacidade';

  @override
  String get about_this_app => 'Sobre esta aplicação';

  @override
  String get contribute => 'Contribuir';

  @override
  String get contribute_sw_development => 'Desenvolvimento de software';

  @override
  String get contribute_develop_text =>
      'O código de cada produto Open Food Facts está disponível no GitHub. Pode reutilizar o código (é de fonte aberta) e ajudar-nos a melhorá-lo, para todos, em todo o planeta.';

  @override
  String get contribute_develop_text_2 =>
      'Pode juntar-se à sala de conversação no Slack do Open Food Facts, que é a opção preferida para colocar questões.';

  @override
  String get contribute_develop_dev_mode_title => 'Modo DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Ativar o modo DEV';

  @override
  String get contribute_donate_title => 'Doar';

  @override
  String get contribute_donate_header => 'Fazer um donativo ao Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Informamos que a versão alfa interna permite a perda total de dados e a aplicação pode ficar inutilizável em qualquer altura!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'Produtos a completar';

  @override
  String get contribute_improve_header => 'Melhorar';

  @override
  String get contribute_improve_text =>
      'A base de dados é a parte central do projeto. É muito fácil e rápido colaborar. Pode descarregar a aplicação móvel para o seu telemóvel e começar a adicionar ou a melhorar produtos.\n\nPor outro lado, o website Open Food Facts permite contribuir de várias formas: ';

  @override
  String get contribute_translate_header => 'Traduzir';

  @override
  String get contribute_data_quality => 'Qualidade dos dados';

  @override
  String get contribute_translate_link_text => 'Começar a traduzir';

  @override
  String get contribute_translate_text =>
      'O Open Food Facts é um projeto global, que contém produtos de mais de 160 países. O Open Food Facts está traduzido em dezenas de línguas, com conteúdos em constante evolução.';

  @override
  String get contribute_translate_text_2 =>
      'A tradução é uma das principais tarefas do projeto';

  @override
  String get contribute_join_skill_pool =>
      'Contribua com as suas competências para o Open Food Facts. Junte-se ao conjunto de competências!';

  @override
  String get contribute_share_header =>
      'Partilhe o Open Food Facts com os amigos';

  @override
  String get contribute_share_content =>
      'Queria dar-te a conhecer a aplicação que tenho utilizado, o Open Food Facts, que permite conhecer os impactos dos alimentos na saúde e no ambiente, de forma personalizada. Funciona através da leitura dos códigos de barras das embalagens. É gratuita, não requer registo e pode até ajudar a aumentar o número de produtos decifrados. Aqui está o link para a obter: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribua com os preços solicitando uma exportação GDPR dos dados dos seus cartões de fidelidade';

  @override
  String get tap_to_answer => 'Toque aqui para responder a perguntas';

  @override
  String get tap_to_answer_hint =>
      'Toque aqui para responder a perguntas sobre este produto';

  @override
  String get robotoff_questions_loading_hint =>
      'Por favor, aguarde enquanto as perguntas sobre este produto são carregadas';

  @override
  String get saving_answer => 'A guardar a sua resposta';

  @override
  String get contribute_to_get_rewards =>
      'Torne-se um ator da transparência alimentar';

  @override
  String get question_sign_in_text =>
      'Entre na sua conta do Open Food Facts para guardar as suas contribuições';

  @override
  String get question_yes_button_accessibility_value => 'Responder sim';

  @override
  String get question_no_button_accessibility_value => 'Responder não';

  @override
  String get question_skip_button_accessibility_value =>
      'Ignorar esta pergunta';

  @override
  String get tap_to_edit_search => 'Toque para editar a pesquisa';

  @override
  String get myPreferences => 'As minhas preferências';

  @override
  String get account_create_message =>
      'Crie a sua conta e junte-se à comunidade Open Food Facts para ajudar a aumentar o conhecimento sobre os alimentos de todo o mundo!';

  @override
  String get join_us => 'Junte-se a nós';

  @override
  String get myPreferences_profile_title => 'O seu perfil';

  @override
  String get myPreferences_profile_subtitle =>
      'Gerir a sua conta como colaborador do Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Configurações da aplicação';

  @override
  String get myPreferences_settings_subtitle => 'Modo escuro, idiomas…';

  @override
  String get myPreferences_food_title => 'Preferências alimentares';

  @override
  String get myPreferences_food_subtitle =>
      'Escolha as informações sobre os alimentos que mais lhe interessam.';

  @override
  String get myPreferences_food_comment =>
      'Escolha as informações sobre alimentos que mais lhe interessam, para classificar os alimentos de acordo com as suas preferências, ver primeiro as informações que lhe interessam e obter um resumo de compatibilidade. Essas preferências alimentares permanecem no seu dispositivo e não estão associadas à sua conta de colaborador do Open Food Facts, caso tenha uma.';

  @override
  String get confirmResetPreferences =>
      'Redefinir suas preferências alimentares?';

  @override
  String get myPersonalizedRanking => 'A minha classificação personalizada';

  @override
  String get ranking_tab_all => 'Todos';

  @override
  String get ranking_subtitle_match_yes => 'Uma ótima combinação para você';

  @override
  String get ranking_subtitle_match_no => 'Correspondência muito baixa';

  @override
  String get ranking_subtitle_match_maybe => 'Combinação desconhecida';

  @override
  String get refresh_with_new_preferences =>
      'Atualizar a lista com as novas preferências';

  @override
  String get reloaded_with_new_preferences =>
      'Recarregado com suas novas preferências';

  @override
  String get profile_navbar_label => 'Comunidade';

  @override
  String get scan_navbar_label => 'Digitalizar';

  @override
  String get history_navbar_label => 'Histórico';

  @override
  String get list_navbar_label => 'Listas';

  @override
  String get category => 'Filtrar por categoria';

  @override
  String get category_all => 'Todos';

  @override
  String get category_search => '(pesquisa de categoria)';

  @override
  String get filter => 'Filtro';

  @override
  String get scan => 'Produtos do ecrã de digitalização';

  @override
  String get scan_history => 'Histórico de digitalização';

  @override
  String get search => 'Procurar';

  @override
  String get search_product_help => 'Search a product,\na brand or a barcode';

  @override
  String get search_filter => 'Filtro de pesquisa';

  @override
  String get search_history => 'Histórico de pesquisa';

  @override
  String get search_store => 'Procurar uma loja';

  @override
  String get search_store_help => 'Dica: adicione a cidade ou o país';

  @override
  String get tap_for_more => 'Toque para mais informação…';

  @override
  String get product => 'Produto';

  @override
  String get unknownBrand => 'Marca desconhecida';

  @override
  String get unknownProductName => 'Nome de produto desconhecido';

  @override
  String get label_refresh => 'Atualizar';

  @override
  String get label_reload => 'Recarregar';

  @override
  String get image => 'Imagem';

  @override
  String get front_photo => 'Foto frontal';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (esta imagem pode estar desatualizada)';
  }

  @override
  String get outdated_image_short_label => 'pode estar desatualizado';

  @override
  String get ingredients => 'Ingredientes';

  @override
  String get ingredients_editing_instructions =>
      'Mantenha a ordem original. Indique a percentagem quando especificado. Separe com vírgula ou hífen e use parênteses para os ingredientes de um ingrediente.';

  @override
  String get ingredients_editing_error => 'Falha ao guardar os ingredientes.';

  @override
  String get ingredients_editing_image_error =>
      'Falha ao obter uma nova imagem de ingredientes.';

  @override
  String get ingredients_editing_title => 'Editar ingredientes';

  @override
  String get ingredients_photo => 'Foto de ingredientes';

  @override
  String get packaging_editing_instructions =>
      'Indique todas as partes da embalagem separadas por uma vírgula ou paragrafo, com a sua quantidade (ex: 1 ou 6), formato (ex: garrafa, caixa, lata), material (ex: plástico, metal, alumínio) e, se disponível, o tamanho (ex: 33 cl) e instruções de reciclagem.\nExemplo: 1 garrafa de vidro para reciclar, 1 rolha de plástico para deitar fora';

  @override
  String get packaging_editing_error => 'Falha ao guardar a embalagem.';

  @override
  String get packaging_editing_image_error =>
      'Falha ao obter uma nova imagem da embalagem.';

  @override
  String get packaging_editing_title => 'Editar embalagem';

  @override
  String get nutrition => 'Nutrição';

  @override
  String get nutrition_facts_photo => 'Foto de informações nutricionais';

  @override
  String get nutrition_facts_editing_title => 'Editar informações nutricionais';

  @override
  String get packaging_information => 'Informação de embalagem';

  @override
  String get packaging_information_photo => 'Foto de informações da embalagem';

  @override
  String get missing_product => 'Encontrou um novo produto!';

  @override
  String get add_product_take_photos =>
      'Tire fotografias da embalagem para adicionar este produto ao Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Por favor, tire algumas fotografias primeiro. Pode concluir os dados do produto mais tarde.';

  @override
  String get add_product_information_button_label =>
      'Adicione informações sobre o produto';

  @override
  String get new_product => 'Produto Novo';

  @override
  String get new_product_found_title => 'Novo produto encontrado!';

  @override
  String get new_product_found_text =>
      'Este produto ainda não existe na nossa base de dados: ';

  @override
  String get new_product_found_button => 'Adicionar este produto';

  @override
  String get new_product_leave_title => 'Sair desta página?';

  @override
  String get new_product_leave_message =>
      'Parece que não introduziu nada. Quer mesmo sair desta página?';

  @override
  String get new_product_dialog_description =>
      'Por favor fotografe a embalagem do produto para o adicionar à nossa base de dados';

  @override
  String get new_product_dialog_illustration_description =>
      'Uma ilustração com Nutri-Score e Green-Score desconhecidos';

  @override
  String get front_packaging_photo_button_label =>
      'Fotografia frontal da embalagem';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirmar envio da fotografia frontal da embalagem';

  @override
  String get confirm_button_label => 'Confirmar';

  @override
  String get send_image_button_label => 'Enviar imagem';

  @override
  String get crop_page_action_saving => 'A guardar a imagem…';

  @override
  String get crop_page_action_cropping => 'A recortar a imagem…';

  @override
  String get crop_page_action_local => 'A guardar uma versão local…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oops... há um problema com a fotografia!';

  @override
  String get crop_page_action_local_failed_message =>
      'Não estamos a conseguir processar a sua imagem antes de a enviar para o nosso servidor. Tente novamente mais tarde ou contacte-nos se o problema persistir.';

  @override
  String get crop_page_action_retake => 'Tornar a fotografar';

  @override
  String get crop_page_too_small_image_title => 'A imagem é muito pequena!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Para carregar imagens o tamanho mínimo em píxeis é ${expectedMinWidth}x$expectedMinHeight. A imagem selecionada tem ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server =>
      'A preparar um telefonema para o servidor…';

  @override
  String get front_packaging_photo_title => 'Fotografia frontal da embalagem';

  @override
  String get ingredients_photo_title => 'Fotografia dos ingredientes';

  @override
  String get nutritional_facts_photo_title =>
      'Fotografia das informações nutricionais';

  @override
  String get recycling_photo_title => 'Fotografia de reciclagem';

  @override
  String get take_photo_title => 'Tirar uma foto';

  @override
  String get take_more_photo_title => 'Tirar mais fotografias';

  @override
  String get front_photo_uploaded => 'Fotografia inicial enviada';

  @override
  String get ingredients_photo_button_label => 'Foto de ingredientes';

  @override
  String get ingredients_photo_uploaded => 'Foto dos ingredientes enviada';

  @override
  String get nutrition_cache_loading_error =>
      'Não é possível carregar nutrientes do cache';

  @override
  String get nutritional_facts_photo_button_label =>
      'Foto de informações nutricionais';

  @override
  String get nutritional_facts_input_button_label =>
      'Preencher informações nutricionais';

  @override
  String get nutritional_facts_added => 'Informações nutricionais adicionadas';

  @override
  String get categories_added => 'Categorias adicionadas';

  @override
  String get new_product_title_nutriscore => 'Calcular o Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Ajude-nos preenchendo pelo menos uma categoria e valores nutricionais';

  @override
  String get new_product_title_environmental_score => 'Calcular o Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Obtenha-o preenchendo pelo menos uma categoria';

  @override
  String get new_product_additional_environmental_score =>
      'Torne o cálculo do Green-Score mais exato com a indicação da origem, embalagem e outras informações';

  @override
  String get new_product_title_nova =>
      'Calcular o nível de processamento de alimentos (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Obtenha-o preenchendo a categoria do alimento e os ingredientes';

  @override
  String get new_product_desc_nova_unknown =>
      'Nível desconhecido de processamento do alimento';

  @override
  String get new_product_title_pictures => 'Novo produto';

  @override
  String get new_product_title_pictures_details =>
      'Tire as seguintes fotografias e o motor Open Food Facts resolverá o resto!';

  @override
  String get new_product_title_misc => 'E alguns dados básicos…';

  @override
  String new_product_done_msg(String username) {
    return 'Obrigado pela sua contribuição “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Obrigado pela sua contribuição!';

  @override
  String get new_product_done_button_label => 'Descubra o produto completo';

  @override
  String get hey_incomplete_product_message =>
      'Toque para responder a 3 perguntas AGORA para calcular o Nutri-Score, o Green-Score e o ultra-processamento (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Toque agora para responder a 2 perguntas para ajudar a analisar este cosmético!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Toque agora para responder a 3 perguntas para ajudar a analisar este produto de alimentação para animais de estimação!';

  @override
  String get hey_incomplete_product_message_product =>
      'Toque agora para ajudar a completar este produto!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto das informações nutricionais enviada';

  @override
  String get recycling_photo_button_label =>
      'Fotografia de informações sobre a reciclagem';

  @override
  String get recycling_photo_uploaded =>
      'Fotografia sobre a reciclagem enviada';

  @override
  String get take_more_photo_button_label => 'Tirar mais fotografias';

  @override
  String get other_photo_uploaded => 'Fotografia diversa enviada';

  @override
  String get retake_photo_button_label => 'Tirar novamente';

  @override
  String get selecting_photo => 'Selecionar fotografia';

  @override
  String get uploading_image => 'A enviar a fotografia para o servidor';

  @override
  String get uploading_image_type_front =>
      'A enviar a imagem frontal para o Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'A enviar a imagem dos ingredientes para o Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'A enviar a imagem das informações nutricionais para o Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'A enviar a imagem da embalagem para o Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'A enviar outra imagem para o Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'A enviar imagem para o Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Adicionar ingredientes que faltam';

  @override
  String get score_add_missing_packaging_image =>
      'Adicionar imagem de embalagem que falta';

  @override
  String get score_add_missing_nutrition_facts =>
      'Adicionar informações nutricionais que faltam';

  @override
  String get score_add_missing_product_traces =>
      'Adicionar vestígios de produtos em falta';

  @override
  String get score_add_missing_product_category => 'Selecionar uma categoria';

  @override
  String get score_add_missing_precise_product_category =>
      'Selecione uma categoria mais precisa';

  @override
  String get score_add_missing_product_countries =>
      'Adicionar países que faltam de produtos';

  @override
  String get score_add_missing_product_emb =>
      'Adicionar códigos de rastreabilidade que faltam de produtos';

  @override
  String get score_add_missing_product_labels =>
      'Adicionar rótulos que faltam de produtos';

  @override
  String get score_add_missing_product_origins =>
      'Adicionar origens que faltam de produtos';

  @override
  String get score_add_missing_product_stores =>
      'Adicionar lojas que faltam de produtos';

  @override
  String get score_add_missing_product_brands =>
      'Adicionar marcas que faltam de produtos';

  @override
  String get score_update_nutrition_facts => 'Atualizar dados nutricionais';

  @override
  String get nutrition_page_title => 'Informações nutricionais';

  @override
  String get nutrition_page_nutritional_info_title => 'Informação nutricional';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Valores especificados no produto:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Sim';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Não';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Abrir fotografia';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Boas práticas: Informação nutricional';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Às vezes, informações nutricionais **não são especificadas na embalagem** ou em um documento de determinado produto. Nesse caso, e apenas nele, você pode definir o valor para **NÃO**.';

  @override
  String get nutrition_page_serving_type_label => 'Valores nutricionais:';

  @override
  String get nutrition_page_per_100g => 'por 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'por 100g/ml';

  @override
  String get nutrition_page_per_serving => 'por porção';

  @override
  String get nutrition_page_add_nutrient => 'Adicionar um nutriente';

  @override
  String get nutrition_page_serving_size => 'Tamanho da porção';

  @override
  String get nutrition_page_serving_size_hint =>
      'Insira o tamanho da porção (por exemplo: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Boas práticas: Tamanho da porção';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Este valor ajuda a **fazer um cálculo proporcional de cada nutriente por porção**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Unidade permitidas** são: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** ou **60 G** (preferencialmente o primeiro)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** ou **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unidade inválida';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unidades inválidas';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **doces** e 2 **biscoitos**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unidade em falta';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Número inválido';

  @override
  String get nutrition_page_update_running =>
      'A atualizar o produto no servidor…';

  @override
  String get nutrition_page_update_done => 'Produto atualizado!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Utilizar a quantidade do produto como tamanho da dose';

  @override
  String get nutrition_page_photo_error =>
      'Não foi possível carregar a fotografia';

  @override
  String get more_photos => 'Mais fotografias interessantes';

  @override
  String get view_more_photo_button =>
      'Ver todas as fotografias existentes para este produto';

  @override
  String get no_product_found => 'Não foi encontrado nenhum produto';

  @override
  String get no_location_found => 'Nenhuma localização encontrada';

  @override
  String get not_found => 'não encontrado:';

  @override
  String get refreshing_product => 'A atualizar o produto';

  @override
  String get product_refreshed => 'Produto atualizado';

  @override
  String product_image_accessibility_label(String date) {
    return 'Imagem tirada em $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Imagem tirada em $date. Esta imagem pode estar desatualizada';
  }

  @override
  String get product_image_outdated => 'Esta imagem pode estar desatualizada';

  @override
  String get product_image_outdated_explanations_title =>
      'Esta imagem pode estar desatualizada';

  @override
  String get product_image_outdated_explanations_content =>
      'Esta imagem foi tirada há mais de um ano.\n**Verifique se ainda está atualizada**.\n\nIsto é **apenas um aviso**. Se o conteúdo continuar a ser o mesmo, pode ignorar esta mensagem.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Substituir foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Adicionar uma fotografia ($type)';
  }

  @override
  String get product_image_action_take_new_picture =>
      'Tirar uma nova fotografia';

  @override
  String get product_image_action_take_picture => 'Tirar uma foto';

  @override
  String get product_image_action_from_gallery =>
      'Selecionar a partir da biblioteca do seu telemóvel';

  @override
  String get product_image_action_choose_existing_photo =>
      'Selecionar entre as fotografias do produto';

  @override
  String get product_image_details_label => 'Informação sobre a fotografia';

  @override
  String get product_image_details_from_producer => 'Do produtor';

  @override
  String get product_image_details_contributor => 'Colaborador';

  @override
  String get product_image_details_contributor_producer =>
      'Colaborador (produtor)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Desconhecido';

  @override
  String get homepage_main_card_logo_description =>
      'Bem-vindo ao Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Digitalize** um código de barras ou\n**pesquise** por um produto';

  @override
  String get homepage_main_card_search_field_hint => 'Procurar por um produto';

  @override
  String get homepage_main_card_search_field_tooltip => 'Iniciar pesquisa';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Últimas notícias: $news_title';
  }

  @override
  String get tagline_app_review => 'Gosta da aplicação?';

  @override
  String get tagline_app_review_button_positive => 'Adoro! 😍';

  @override
  String get tagline_app_review_button_negative => 'Nem por isso…';

  @override
  String get tagline_app_review_button_later => 'Perguntar depois';

  @override
  String get tagline_feed_news_button => 'Saber mais';

  @override
  String get app_review_negative_modal_title => 'Não gosta da nossa aplicação?';

  @override
  String get app_review_negative_modal_text =>
      'Pode tirar uns segundos e dizer-nos o porquê por favor?';

  @override
  String get app_review_negative_modal_positive_button => 'Sim, absolutamente!';

  @override
  String get app_review_negative_modal_negative_button => 'Não';

  @override
  String get could_not_refresh => 'Não foi possível atualizar o produto';

  @override
  String get product_internet_error_modal_title => 'Ocorreu um erro!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Não foi possível obter informações sobre este produto devido a um erro de rede. Verifique a sua ligação à Internet e tente novamente.\n\nErro interno:\n$error';
  }

  @override
  String get product_tags_title => 'Propriedades do produto';

  @override
  String get no_product_tags_found_message =>
      'Não foram encontradas propriedades de produtos. As propriedades podem ser utilizadas para descrever os produtos com mais pormenores, de uma forma flexível.';

  @override
  String get product_tags_empty => 'Nenhuma propriedade';

  @override
  String get product_tags_explanation =>
      'Ao adicionar propriedades (chave/valor) a um produto, ajuda a enriquecê-lo.';

  @override
  String get add_tag => 'Adicionar uma propriedade';

  @override
  String get add_tags => 'Adicionar propriedades';

  @override
  String get add_edit_tags => 'Adicionar ou editar propriedades';

  @override
  String get edit_tag => 'Editar propriedade';

  @override
  String get remove_tag => 'Remover propriedade';

  @override
  String get tag_key => 'Propriedade';

  @override
  String get tag_keys => 'Propriedades';

  @override
  String get tag_key_uneditable => 'Propriedade (não editável)';

  @override
  String get tag_key_input_hint => 'Introduza uma propriedade';

  @override
  String get tag_value => 'Valor';

  @override
  String get tag_values => 'Valores';

  @override
  String get tag_value_input_hint => 'Introduza um valor';

  @override
  String get tag_key_item => 'Propriedade:';

  @override
  String get tag_value_item => 'Valor:';

  @override
  String get tag_key_explanations =>
      'Uma chave tem de estar minúsculas e sem espaços.';

  @override
  String tag_key_already_exists(String property) {
    return 'Já existe uma etiqueta com a propriedade $property!';
  }

  @override
  String get product_internet_error =>
      'Não foi possível obter informações sobre este produto devido a um erro de rede.';

  @override
  String get cached_results_from => 'Mostrar resultados de:';

  @override
  String get product_search_same_category => 'Encontre alternativas';

  @override
  String get product_search_same_category_short => 'Comparar';

  @override
  String get product_search_same_category_error =>
      'Esta funcionalidade só pode ser utilizada para produtos com uma categoria.\n\nPor favor, edite o produto para adicionar uma categoria.';

  @override
  String get product_improvement_add_category =>
      'Adicione uma categoria para calcular o Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Adicione as informações nutricionais para calcular o Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Adicione as informações nutricionais e uma categoria para calcular o Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'O Nutri-Score para este produto não pode ser calculado, o que pode ser devido, por exemplo, a uma categoria fora do normal. Se isso for considerado um erro, contacte-nos.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'A imagem nutricional está obsoleta: atualize-a.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'O Green-Score leva em consideração a origem dos ingredientes. Tire uma fotografia da lista de ingredientes e/ou qualquer reivindicação geográfica ou edite o produto, para que possam ser levados em consideração.';

  @override
  String get country_chooser_label => 'Escolha um país';

  @override
  String get currency_chooser_label => 'Por favor selecione uma moeda';

  @override
  String get country_change_message => 'Acabou de mudar de país.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Quer alterar a moeda de $previousCurrency para $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Escolha um país:';

  @override
  String get country_chooser_label_from_settings => 'O seu país';

  @override
  String get country_selection_explanation =>
      'Algumas características ambientais dependem do local';

  @override
  String get product_removed_comparison => 'Produto removido da comparação';

  @override
  String get native_app_settings => 'Configurações nativas da aplicação';

  @override
  String get native_app_description =>
      'Abrir configurações do sistema do Open Food Facts';

  @override
  String get product_removed_history => 'Produto removido do histórico';

  @override
  String get product_removed_list => 'Produto removido da lista';

  @override
  String get product_could_not_remove => 'Não foi possível remover o produto';

  @override
  String get no_prodcut_in_list => 'Não há nenhum produto nesta lista';

  @override
  String get no_product_in_section => 'Não há nenhum produto nesta lista';

  @override
  String get recently_seen_products => 'Todos os produtos visualizados';

  @override
  String get clear => 'Limpar';

  @override
  String get clear_long => 'Esvaziar a lista';

  @override
  String get really_clear => 'Quer mesmo eliminar esta lista?';

  @override
  String pct_match(Object percent) {
    return '$percent% de correspondência';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count dias',
      one: 'há um dia',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count horas',
      one: 'há uma hora',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count minutos',
      one: 'há um minuto',
      zero: 'há menos de um minuto',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count meses',
      one: 'há um mês',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count semanas',
      one: 'há uma semana',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Comparar $count produtos',
      one: 'Comparar um produto',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos selecionados',
      one: 'Um produto selecionado',
      zero: 'Nenhum produto selecionado',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Comparar produtos selecionados';

  @override
  String get delete_products_mode => 'Apagar produtos selecionados';

  @override
  String get select_all_products_mode => 'Selecionar todos os produtos';

  @override
  String get select_none_products_mode => 'Desselecionar';

  @override
  String get compare_products_appbar_title => 'Compare produtos';

  @override
  String get compare_products_appbar_subtitle =>
      'Selecione pelo menos dois produtos';

  @override
  String get retry_button_label => 'Repetir';

  @override
  String get connect_with_us => 'Ligue-se a nós';

  @override
  String get tiktok => 'Siga-nos no TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Siga-nos no Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Siga-nos no X (antigo Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Siga-nos no Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Siga-nos no BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogue';

  @override
  String get faq => 'Perguntas frequentes';

  @override
  String get discover => 'Descobrir';

  @override
  String get how_to_contribute => 'Como contribuir';

  @override
  String get hint_knowledge_panel_message =>
      'Pode tocar em qualquer parte do cartão para obter mais detalhes sobre o que vê. Tente agora!';

  @override
  String get permissions_page_title => 'Acesso à câmara';

  @override
  String get permissions_page_body1 =>
      'Para digitalizar códigos de barras com a câmara do telemóvel, por favor conceda o acesso.';

  @override
  String get permissions_page_body2 =>
      'Se mudar de ideias, esta opção pode ser ativada e desativada a qualquer momento nas configurações.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'SO: Android (SDK Int: $sdkInt / lançamento: $release)\nModelo: $model\nProduto: $product\nDispositivo: $device\nMarca: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'SO: iOS ($version)\nModelo: $model\nModelo localizado: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersão da aplicação: $appVersion\nNúmero de compilação da aplicação: $appBuildNumber\nNome do pacote da aplicação: $appPackageName';
  }

  @override
  String get authorize_button_label => 'Autorizar';

  @override
  String get refuse_button_label => 'Recusar';

  @override
  String get ask_me_later_button_label => 'Lembrar-me depois';

  @override
  String get are_you_sure => 'Tem a certeza?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Mais informação em $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Bem-vindo!';

  @override
  String get onboarding_home_welcome_text2 =>
      'A aplicação que ajuda a escolher alimentos que são bons para **si** e para o **planeta**!';

  @override
  String get onboarding_continue_button => 'Continuar';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'A carregar o seu primeiro exemplo de produto';

  @override
  String get onboarding_welcome_warning =>
      'Desculpe, este é um produto de exemplo, não pode editá-lo :)';

  @override
  String get product_list_your_ranking => 'A sua classificação';

  @override
  String get product_list_empty_icon_desc => 'Histórico indisponível';

  @override
  String get product_list_empty_title => 'Iniciar a digitalização';

  @override
  String get product_list_empty_message =>
      'Os produtos digitalizados aparecerão aqui e poderá ver informações detalhadas sobre eles';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produtos',
      one: 'produto',
      zero: 'produto',
    );
    return 'A atualizar $_temp0 no seu histórico';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produtos',
      one: 'produto',
      zero: 'produto',
    );
    return 'Atualização de $_temp0 terminada';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'A descarregar os dados';

  @override
  String get loading_dialog_default_error_message =>
      'Não foi possível descarregar os dados';

  @override
  String get account_delete => 'Eliminar a conta';

  @override
  String get account_delete_title => 'Apagar a minha conta';

  @override
  String get user_profile => 'Conta';

  @override
  String get user_profile_title_guest => 'Bem-vindo(a)!';

  @override
  String get user_profile_subtitle_guest =>
      'Inicie a sessão ou registe-se para se juntar à comunidade do Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Iniciar sessão no Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Bem-vindo(a) $id!';
  }

  @override
  String get email_subject_account_deletion => 'Eliminar a conta';

  @override
  String email_body_account_deletion(String userId) {
    return 'Olá, por favor elimine a minha conta no Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplicação';

  @override
  String get settings_app_data => 'Funcionalidades e monitorização de falhas';

  @override
  String get settings_app_camera => 'Câmara';

  @override
  String get settings_app_products => 'Produtos';

  @override
  String get settings_app_miscellaneous => 'Diversos';

  @override
  String get camera_play_sound_title =>
      'Reproduzir um som durante a digitalização';

  @override
  String get camera_play_sound_subtitle =>
      'Irá emitir um sinal sonoro em cada digitalização bem sucedida';

  @override
  String get camera_window_accessibility_label =>
      'Digitalize um código de barras com a sua câmara';

  @override
  String get app_haptic_feedback_title => 'Vibração e resposta tátil';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrações após a execução de algumas ações (código de barras descodificado, produto removido…).';

  @override
  String get crash_reporting_toggle_title => 'Reporte-nos erros e falhas';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Quando ativado, os relatórios de falhas são automaticamente enviados para o sistema de rastreio de erros do Open Food Facts, para que os erros possam ser corrigidos e assim melhorar a aplicação.';

  @override
  String get send_anonymous_data_toggle_title =>
      'Reporte-nos a utilização das funcionalidades';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Quando ativado, serão enviadas informações estritamente anónimas relativas à utilização das funcionalidades para os servidores do Open Food Facts, para que possamos compreender como são utilizadas as funcionalidades, por forma a melhorá-las. Caso contrário, será enviado um ID 0.';

  @override
  String get product_edit_photo_title => 'Editar foto';

  @override
  String get permission_photo_error => 'Erro';

  @override
  String get permission_photo_denied_title =>
      'Permitir o uso da câmara para digitalizar códigos de barras';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Para uma melhor experiência, conceda a permissão ao $appName de acesso à sua câmara. Poderá digitalizar códigos de barras diretamente.';
  }

  @override
  String get permission_photo_denied_button => 'Permitir';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Permissão negada';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Como anteriormente negou a permissão da câmara, tem de conseder a permissão manualmente nas Configurações.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Abrir configurações';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Cancelar';

  @override
  String get permission_photo_none_found => 'Nenhuma câmara detetada';

  @override
  String get permission_photo_denied => 'Não foi concedido acesso à câmara';

  @override
  String get show_product_pictures => 'Mostrar fotos do produto';

  @override
  String get edit_product_label => 'Editar produto';

  @override
  String get edit_product_pending_operations_banner_title =>
      'A enviar as suas edições…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'As suas edições estão a ser **enviadas em segundo plano** (ou mais tarde em caso de erro).\nPode continuar a editar outros campos do produto.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Suas edições estão **sendo feitas em segundo plano** (ou mais tarde, em caso de erro).';

  @override
  String get edit_product_label_short => 'Editar';

  @override
  String edit_product_form_item_help(String value) {
    return 'Como inserir \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Por favor, insira um valor não vazio!';

  @override
  String get edit_product_form_item_error_existing => 'Esse valor já está aí!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Adicionar uma nova marca';

  @override
  String get edit_product_form_item_add_action_label =>
      'Adicionar uma nova etiqueta';

  @override
  String get edit_product_form_item_add_action_store =>
      'Adicionar uma nova loja';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Adicionar uma nova origem';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Adicionar um novo código de rastreabilidade';

  @override
  String get edit_product_form_item_add_action_country =>
      'Adicionar um novo país';

  @override
  String get edit_product_form_item_add_action_category =>
      'Adicionar uma nova categoria';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Adicionar um novo vestígio';

  @override
  String get edit_product_form_item_add_suggestion => 'Dê uma sugestão';

  @override
  String get edit_product_form_item_deny_suggestion => 'Negar sugestão';

  @override
  String get edit_product_form_item_details_title => 'Detalhes básicos';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nome do produto, marca, quantidade';

  @override
  String get edit_product_form_item_other_details_title =>
      'Detalhes adicionais';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Site…';

  @override
  String get edit_product_form_item_photos_title => 'Fotografias';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Adicionar ou atualizar fotografias';

  @override
  String get edit_product_form_item_labels_title => 'Etiquetas e certificações';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Selos ambientais, de qualidade…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Introduza uma etiqueta (por exemplo: Nutri-Score)';

  @override
  String get edit_product_form_item_labels_type => 'rótulo';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Boas práticas: Rótulos';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Qualquer característica do produto **que seja verdadeira** e diferente dos outros campos.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Feito na Bélgica, Produzido na Bretanha…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rico em fibras, fonte de ferro…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Troca justa, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Lojas';

  @override
  String get edit_product_form_item_stores_hint => 'Introduza uma loja';

  @override
  String get edit_product_form_item_stores_type => 'loja';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Boas práticas: Lojas';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Insira loja em que você comprou o produto.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Continente';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Mercadona';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Origens';

  @override
  String get edit_product_form_item_origins_hint =>
      'Insira uma origem (por exemplo: Carne bovina da Argentina)';

  @override
  String get edit_product_form_item_origins_type => 'país';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Boas práticas: Origem';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Adicione **qualquer indicação de origem que conseguir encontrar na embalagem**.\nDesconsidere as origens indicadas diretamente na lista de ingredientes.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Carne da Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'A soja não vem da União Europeia';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Introduza um país (por exemplo: Portugal)';

  @override
  String get edit_product_form_item_countries_type => 'país';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Boas práticas: Países';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Países em que os produtos são abundantes** (exceto lojas especializada em produtos importados).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Códigos de rastreabilidade';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Introduza um código (por exemplo: PT DLT 1 CE, EMB 53062, FR 62.448.034 CE…)';

  @override
  String get edit_product_form_item_emb_codes_type =>
      'código de rastreabilidade';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Boas práticas: Códigos de rastreio';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Nesta seção, você consegue inserir códigos relacionados a **marcas de embalagem**, **marcas de identificação** ou **marcas de saúde**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Exemplos de códigos de rastreio';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Códigos EC** usados na Comunidade Europeia para identificar produtores ou embaladores de alimentos:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'PT\nDLT-1\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: código de país da **França**\n**72.264.002**: dados geográficos\n**CE**: Comunidade Europeia';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Códigos EMB** usados na França:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Vestígios';

  @override
  String get edit_product_form_item_traces_hint => 'vestígio';

  @override
  String get edit_product_form_item_traces_type =>
      'Insira um vestígio (p. ex.: soja)';

  @override
  String get edit_product_form_item_categories_title => 'Categorias';

  @override
  String get edit_product_form_item_categories_hint => 'categoria';

  @override
  String get edit_product_form_item_categories_type =>
      'Introduza uma categoria (por exemplo: Refrigerante de laranja)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Boas práticas: Categorias';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicar apenas a categoria mais específica.\nAs categorias principais serão adicionadas automaticamente.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Ausência de categoria?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'No caso de ausência de preenchimento automático de alguma categoria, pode adicioná-la mesmo assim.\nEstará nos ajudando a melhorar o OpenFoodFacts no seu país.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardinhas ao óleo';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Suco de laranja concentrado';

  @override
  String get edit_product_form_item_exit_title => 'Sair sem guardar?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Quer guardar as alterações antes de deixar esta página?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Guardar alterações';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Descartar alterações';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredientes';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Amplie ou reduza apertando ou afastando 2 dedos no ecrã';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Amplie e reduza a fotografia';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Utilizando o gesto **Pinch-to-zoom**, pode ampliar ou reduzir a fotografia:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Adicionar';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Introduzir primeiro um texto';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Eliminar';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Guarde a sua edição';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancele a sua edição';

  @override
  String get edit_product_form_item_packaging_title =>
      'Fotografia das instruções de reciclagem';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Dados nutricionais';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Informações nutricionais, conteúdo alcoólico…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Boas práticas: Informação nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Valores nutricionais';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Primeiro, selecione se os valores são fornecidos:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Dados nutricionais';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Depois, insira os valores nutricionais conforme indicado na embalagem. Se não houver valor, clique no ícone do olho.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Campos em falta?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Se algum campo estiver em falta, você pode clicar no ícone de \"mais\" para adicioná-lo (ex: vitamina D, magnésio...).';

  @override
  String get edit_product_form_save => 'Editar';

  @override
  String get edit_product_ingredients_photo_title => 'Foto de ingredientes';

  @override
  String get edit_product_ingredients_list_title => 'Lista de ingredientes';

  @override
  String get edit_product_packaging_photo_title => 'Foto da embalagem';

  @override
  String get edit_product_packaging_list_title => 'Lista de embalagens';

  @override
  String get no_data_available => 'Sem dados disponíveis';

  @override
  String get product_field_website_title => 'Site';

  @override
  String get origins_editing_title => 'Editar origens';

  @override
  String get completed_basic_details_btn_text => 'Detalhes básicos completos';

  @override
  String get not_implemented_snackbar_text => 'Ainda não implementado';

  @override
  String get category_picker_page_appbar_text => 'Categorias';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extrair os ingredientes da fotografia';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extrair ingredientes';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extrair os ingredientes\nda fotografia';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'A carregar a fotografia…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Porque é que vejo esta mensagem?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Para utilizar a funcionalidade \"Extrair ingredientes\", a fotografia tem de ser enviada primeiro.\n\nAguarde alguns segundos ou introduza-os manualmente.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Atualizar fotografia';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extrair os ingredientes\nda fotografia';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extrair embalagem';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extrair os ingredientes da fotografia';

  @override
  String get edit_packaging_loading_photo_btn_text =>
      'A carregar a fotografia…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Porque é que vejo esta mensagem?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Para utilizar a funcionalidade \"Extrair embalagem\", a fotografia tem de ser enviada primeiro.\n\nAguarde alguns segundos ou introduza-os manualmente.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Atualizar fotografia';

  @override
  String get edit_ocr_extract_failed => 'Falha ao detetar texto na imagem.';

  @override
  String get edit_ocr_extract_disabled_title => 'Nenhuma imagem!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Para usar o recurso de extração de texto, primeiro tem de tirar uma foto.';

  @override
  String get user_list_dialog_new_title => 'Nova lista de produtos';

  @override
  String get user_list_dialog_rename_title => 'Alterar nome da lista';

  @override
  String get user_list_subtitle_product => 'Listas';

  @override
  String get user_list_title => 'Minhas listas';

  @override
  String get user_list_add_product => 'Adicione o produto às suas listas';

  @override
  String get user_list_button_new => 'Criar uma nova lista';

  @override
  String get user_list_empty_label =>
      'Ainda não existe nenhuma lista disponível!\nPor favor, comece por criar uma.';

  @override
  String get user_list_button_add_product => 'Adicionar à lista';

  @override
  String get added_to_list_msg => 'Adicionado à lista';

  @override
  String get user_list_popup_clear => 'Limpar histórico';

  @override
  String get user_list_popup_rename => 'Alterar nome';

  @override
  String get user_list_name_hint => 'A minha lista';

  @override
  String get user_list_name_error_empty => 'O nome é obrigatório';

  @override
  String get user_list_name_error_already => 'Esse nome já está a ser usado';

  @override
  String get user_list_name_error_same => 'É o mesmo nome';

  @override
  String get user_list_name_input_hint => 'Nome da lista';

  @override
  String get try_again => 'Tentar novamente';

  @override
  String get there_was_an_error => 'Ocorreu um erro';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nenhuma categoria encontrada para $items';
  }

  @override
  String get camera_toggle_camera =>
      'Alternar entre as câmaras traseira e frontal';

  @override
  String get camera_toggle_flash => 'Ligar ou desligar o flash da câmara';

  @override
  String get camera_enable_flash => 'Ligar flash';

  @override
  String get camera_disable_flash => 'Desligar flash';

  @override
  String get camera_flash_error_dialog_title => 'Ocorreu um erro!';

  @override
  String get camera_flash_error_dialog_message =>
      'Ocorreu um erro ao alterar o estado do seu flash. Certifique-se de que o seu telemóvel não tem a lanterna ligada.';

  @override
  String get category_picker_no_category_found_button => 'Voltar';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Clique para abrir no seu navegador ou na aplicação (se instalada)';

  @override
  String get dev_preferences_screen_title => 'Modo programador';

  @override
  String get dev_preferences_screen_subtitle =>
      'Aceda a recursos experimentais e ferramentas de desenvolvimento';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Relançar experiência de boas-vindas';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Depois, tem de reiniciar a aplicação para a ver novamente.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Alternar entre openfoodfacts.org (PROD) e ambiente de teste';

  @override
  String get dev_preferences_test_environment_title =>
      'Parâmetros do ambiente de teste';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL base para o ambiente de teste atual: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Hospedeiro do ambiente de teste';

  @override
  String get dev_preferences_ml_kit_title => 'Usar kit de ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'então terá que reiniciar esta aplicação';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Botão adicional na página do produto';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Editar ingredientes através de um botão do painel de conhecimento';

  @override
  String get dev_preferences_export_history_title => 'Exportar histórico';

  @override
  String get dev_preferences_export_history_progress_error => 'exceção';

  @override
  String get dev_preferences_export_history_progress_found =>
      'produto encontrado';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produto NÃO encontrado';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Exportar histórico';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Cancelar';

  @override
  String get dev_preferences_migration_title => 'Migração de dados da V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Estado: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'sucesso ou nova instalação';

  @override
  String get dev_preferences_migration_status_success => 'sucesso';

  @override
  String get dev_preferences_migration_status_error => 'erro';

  @override
  String get dev_preferences_migration_status_in_progress => 'a decorrer';

  @override
  String get dev_preferences_migration_status_required =>
      'necessário (clique para começar)';

  @override
  String get dev_preferences_migration_status_not_started => 'desconhecido';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Irá limpar o histórico e colocar 3 produtos nele';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL personalizado para notícias';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL do ficheiro JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Não definido';

  @override
  String get dev_preferences_news_provider_status_title => 'Estado';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Última atualização: $date';
  }

  @override
  String get product_type_label_food => 'Alimentação';

  @override
  String get product_type_label_beauty => 'Cuidados pessoais';

  @override
  String get product_type_label_pet_food => 'Alimentos de pets';

  @override
  String get product_type_label_product => 'Outro';

  @override
  String get product_type_selection_title => 'Tipo do produto';

  @override
  String get product_type_selection_subtitle =>
      'Selecione o tipo deste produto';

  @override
  String get product_type_selection_empty =>
      'Deve primeiro selecionar um tipo de produto!';

  @override
  String product_type_selection_already(String productType) {
    return 'Não pode mudar o tipo de produto ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Atalho para a aplicação Preços na página do produto';

  @override
  String get prices_app_button => 'Ir para a aplicação Preços';

  @override
  String get prices_website_button => 'Aberto no site Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Adicione etiquetas de preço diretamente da galeria';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Depois de selecionar as imagens, não será possível editá-las!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'A IA irá analisar as suas provas para extrair os preços.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Permitir que a comunidade valide os preços extraídos pela IA.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Várias etiquetas de preço';

  @override
  String get prices_bulk_proof_upload_title => 'Envio em lote de comprovativos';

  @override
  String get prices_bulk_proof_upload_step_selecting =>
      'Selecionando ficheiros';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Iniciando o upload';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copiar localmente o ficheiro #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'A preparar o upload #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Falha na imagem #$index/$count';
  }

  @override
  String get prices_generic_title => 'Preços';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar $count preços',
      one: 'Adicionar um preço',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Enviar $count preços',
      one: 'Enviar o preço',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Adicionar um item';

  @override
  String get prices_add_a_price => 'Adicionar um preço';

  @override
  String get prices_add_a_receipt => 'Adicionar um recibo';

  @override
  String get prices_add_price_tags => 'Adicionar etiquetas de preço';

  @override
  String prices_barcode_already(String barcode) {
    return 'Este código de barras ($barcode) já está na lista!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produto não encontrado';

  @override
  String get prices_barcode_search_none_yet => 'Ainda sem produtos';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'A procurar $barcode';
  }

  @override
  String get prices_barcode_enter => 'Digite o código de barras';

  @override
  String get prices_category_enter => 'Artigo sem código de barras';

  @override
  String get prices_per_kilogram => 'Preço por quilograma';

  @override
  String get prices_per_unit => 'Preço por unidade';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unidade';

  @override
  String get prices_category_mandatory => 'Obrigatório';

  @override
  String get prices_category_optional => 'Opcional';

  @override
  String get prices_category_error_mandatory => 'A categoria é obrigatória';

  @override
  String get prices_barcode_reader_action => 'Leitor de código de barras';

  @override
  String get prices_view_prices => 'Ver os preços';

  @override
  String get prices_list_title => 'Lista de preços';

  @override
  String get prices_list_count => 'Número de preços\n';

  @override
  String get prices_list_add_new_price => 'Adicionar um novo preço\n';

  @override
  String get prices_list_empty_title => 'Ainda não há preço!';

  @override
  String get prices_list_empty_subtitle =>
      'Seja o primeiro a adicionar um:\nDigitalizando um **recibo** ou uma **etiqueta de preço**!';

  @override
  String get prices_entry_shop_not_found => 'Loja desconhecida';

  @override
  String prices_entry_menu_title(String user) {
    return 'Entrada de preço a partir de \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Ver todos os preços deste produto';

  @override
  String get prices_entry_menu_open_proof => 'Ver prova';

  @override
  String get prices_entry_menu_my_prices => 'Veja os meus outros preços';

  @override
  String get prices_entry_menu_author_prices => 'Ver outros preços do autor';

  @override
  String get prices_entry_menu_shop_prices => 'Veja outros preços da loja';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count preços',
      one: '1 preço',
    );
    return '$_temp0 de $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Todos os $count preços',
      one: 'Apenas um preço',
      zero: 'Ainda sem preço',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Últimos $pageSize preços (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Preço: $price / Loja: \"$location\" / Publicado em $date por \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Abrir comprovativos de \"$user\"';
  }

  @override
  String get prices_open_proof => 'Abrir comprovativos dos preços';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Todos os $count comprovativos',
      one: 'Apenas um comprovativo',
      zero: 'Ainda sem comprovativos',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Últimos $pageSize comprovativos (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'Nenhum colaborador ainda!';

  @override
  String get prices_users_empty_explanation =>
      'Seja o primeiro a adicionar um preço!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Principais $pageSize contribuidores (total: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Nenhuma loja ainda!';

  @override
  String get prices_locations_empty_explanation =>
      'Seja o primeiro a adicionar um preço!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Principais $pageSize localizações (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count comprovativos',
      one: 'Um comprovativo',
      zero: 'Nenhum comprovativo',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos',
      one: 'Um produto',
      zero: 'Nenhum produto',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count utilizadores',
      one: 'Um utilizador',
      zero: 'Nenhum utilizador',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count preços',
      one: 'Um preço',
      zero: 'Sem preço',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle =>
      'Preço adicionado anteriormente';

  @override
  String get prices_amount_subtitle => 'Montante';

  @override
  String get prices_amount_is_discounted => 'Está com desconto?';

  @override
  String get prices_amount_price_normal => 'Preço';

  @override
  String get prices_amount_price_discounted => 'Preço descontado';

  @override
  String get prices_amount_price_not_discounted => 'Preço original';

  @override
  String get prices_amount_no_product => 'Falta um produto!';

  @override
  String get prices_amount_price_incorrect => 'Valor incorreto';

  @override
  String get prices_amount_price_mandatory => 'Valor obrigatório';

  @override
  String get prices_currency_subtitle => 'Moeda';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Loja';

  @override
  String get prices_location_find => 'Encontrar uma loja';

  @override
  String get prices_location_mandatory => 'Tem de selecionar uma loja!';

  @override
  String get prices_location_search_broader =>
      'Não encontrou o que estava à procura? Vamos tentar uma pesquisa mais avançada!';

  @override
  String get prices_proof_subtitle => 'Demonstração';

  @override
  String get prices_proof_empty_title => 'Nenhuma prova ainda!';

  @override
  String get prices_proof_empty_explanation =>
      'Comece por adicionar uma fotografia de um **recibo** ou de uma **etiqueta de preço**!';

  @override
  String get prices_proof_find => 'Selecionar um comprovativo';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Talão';

  @override
  String get prices_proof_price_tag => 'Etiqueta de preço';

  @override
  String get prices_proof_mandatory => 'Tem de selecionar um comprovativo!';

  @override
  String get prices_add_validation_error => 'Erro de validação';

  @override
  String get prices_privacy_warning_title => 'Aviso de privacidade';

  @override
  String get prices_unknown_product => 'Produto desconhecido';

  @override
  String get prices_privacy_warning_main_message =>
      'Os preços **serão públicos**, juntamente com a loja a que se referem.\n\nIsto pode permitir que as pessoas que conhecem o nome da sua conta no Open Food Facts possam:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Deduzir em que área vive';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Saber o que compra';

  @override
  String get prices_privacy_warning_sub_message =>
      'Se não se sentir à vontade com isso, altere o nome da sua conta ou crie uma nova conta no Open Food Facts e inicie sessão na aplicação com essa nova conta.';

  @override
  String get i_refuse => 'Não aceito';

  @override
  String get i_accept => 'Aceito';

  @override
  String get prices_currency_change_proposal_title => 'Alterar a moeda?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'A moeda atual é **$currency**. Quer alterá-la para **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Sim, usar $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Não, manter $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Concluído';

  @override
  String get dev_mode_section_server => 'Configuração do servidor';

  @override
  String get dev_mode_section_news => 'Configuração do fornecedor de notícias';

  @override
  String get dev_mode_section_product_page => 'Página do produto';

  @override
  String get dev_mode_section_ui => 'Interface do utilizador';

  @override
  String get dev_mode_section_experimental_features =>
      'Funcionalidades experimentais';

  @override
  String get dev_mode_hide_environmental_score_title => 'Excluir Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Utilizar um corretor ortográfico para ecrãs de OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredientes e embalagem)';

  @override
  String get dev_mode_reset_app_language_title => 'Repor idioma do aplicativo';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Adicionar cartões';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Alternar entre prices.openfoodfacts.org (PROD) e ambiente de teste';

  @override
  String get search_history_item_edit_tooltip =>
      'Reproduzir e editar esta pesquisa';

  @override
  String get search_history_item_remove_tooltip => 'Eliminar';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Descarregou todos os $totalSize produtos.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Descarregar mais $count produtos\nJá descarregou $downloaded de $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'A sua pesquisa de $search está a decorrer.\n\nAguarde alguns segundos…';
  }

  @override
  String get user_search_contributor_title => 'Produtos que adicionei';

  @override
  String get user_search_informer_title => 'Produtos que editei';

  @override
  String get user_search_photographer_title => 'Produtos que fotografei';

  @override
  String get user_search_to_be_completed_title =>
      'Meus produtos a serem concluídos';

  @override
  String get user_search_prices_title => 'Meus valores';

  @override
  String get user_search_proofs_title => 'Minhas demonstrações';

  @override
  String get user_search_proof_title => 'Meu comprovativo';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Preços para colaboradores: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Últimos preços adicionados';

  @override
  String get all_search_prices_top_user_title =>
      'Maiores colaboradores de preços';

  @override
  String get all_search_prices_top_location_title => 'Lojas com mais preços';

  @override
  String get prices_contribution_assistant =>
      'Assistente de contribuição de preços';

  @override
  String get prices_validation_assistant => 'Assistente de validação de preços';

  @override
  String get prices_challenges_page => 'Desafios';

  @override
  String get prices_multiple_proof_addition_system => 'Adicionar várias provas';

  @override
  String get all_search_prices_top_location_single_title => 'Preços numa loja';

  @override
  String get all_search_prices_top_product_title => 'Produtos com mais preços';

  @override
  String get all_search_to_be_completed_title =>
      'Todos os produtos a serem concluídos';

  @override
  String get categorize_products_country_title =>
      'Ajude a categorizar produtos no seu país';

  @override
  String get edit_product_action_retake_picture => 'Tornar a fotografar';

  @override
  String get edit_product_action_take_picture => 'Fotografar';

  @override
  String get edit_product_action_confirm => 'Confirmar';

  @override
  String get signup_page_terms_of_use_line1 => 'Concordo com ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'termos de utilização e contribuição do Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'Ícone do Analytics';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Erro fatal: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Erro fatal: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Detalhes básicos completos';

  @override
  String get edit_photo_button_label => 'Editar';

  @override
  String get edit_photo_unselect_button_label => 'Desmarcar fotografia';

  @override
  String get edit_photo_select_existing_button_label =>
      'Selecionar uma imagem existente';

  @override
  String get edit_photo_select_existing_all_label =>
      'Imagens existentes para este produto';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Selecione uma imagem clicando nela';

  @override
  String get edit_photo_select_existing_download_label =>
      'A recuperar imagens existentes…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Não há imagens previamente enviadas relacionadas com este produto.';

  @override
  String get edit_photo_language_not_this_one =>
      'Ainda não existem imagens nesse idioma';

  @override
  String get edit_photo_language_none => 'Ainda sem imagem';

  @override
  String get category_picker_screen_title => 'Categorias';

  @override
  String get basic_details => 'Detalhes básicos';

  @override
  String get product_name => 'Nome do produto';

  @override
  String get product_names => 'Nomes do Produto';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Adicionar uma nova tradução';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Antes de validar, certifique-se de adicionar uma tradução apenas **se o idioma estiver presente na embalagem**';

  @override
  String get add_basic_details_product_name_open_photo => 'Ver foto frontal';

  @override
  String get add_basic_details_product_name_take_photo => 'Tirar foto frontal';

  @override
  String get add_basic_details_product_name_hint =>
      'Introduza o nome do produto (por exemplo: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Alterar o idioma predefinido?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Pretende que o idioma padrão do produto seja definido como \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Bons exemplos';

  @override
  String get explanation_section_bad_examples => 'Maus exemplos';

  @override
  String get add_basic_details_product_name_help_title =>
      'Boas práticas: Nome do produto';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'O nome do produto é o **nome principal impresso na embalagem**. Pode ser uma marca registrada.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Observação:** não adicione uma tradução **se o idioma não estiver presente na embalagem**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Ketchup de tomate';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Não inclua a marca no nome';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketchup de tomate **por Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Não use os símbolos ®, ™, © ou similares';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count outras traduções',
      one: '$count outra tradução',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nome da marca';

  @override
  String get brand_names => 'Marcas';

  @override
  String get add_basic_details_brand_name_error => 'Introduza o nome da marca';

  @override
  String get add_basic_details_brand_names_hint =>
      'Marcas (por exemplo: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Boas práticas: Marcas';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Insira **todas as marcas do produto**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Marca principal';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'A **marca principal**, geralmente mostrada claramente na embalagem frontal, deve ser **inserida primeiro**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Outras marcas';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Quando vendido **por uma grande empresa**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** é vendido pela **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Quando vendido com sua marca **traduzida em vários idiomas**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** às vezes é escrito **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Quantidade e peso';

  @override
  String get add_basic_details_quantity_hint =>
      'Introduza o peso e se necessário a quantidade (ex.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Boas práticas: quantidade';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copie o valor indicado no produto e **não se esqueça das unidades**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** ou **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (para 6 ovos)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(para um produto com 3 caixas, cada uma com 150g)';

  @override
  String get barcode => 'Código de barras';

  @override
  String barcode_barcode(String barcode) {
    return 'Código de barras: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Código de barras inválido';

  @override
  String get basic_details_add_success =>
      'Detalhes básicos adicionados com sucesso';

  @override
  String get basic_details_add_error =>
      'Não foi possível adicionar detalhes básicos. Por favor, tente novamente após algum tempo';

  @override
  String get clear_search => 'Limpar a pesquisa';

  @override
  String get confirm_clear =>
      'Está prestes a limpar todo o seu histórico: tem a certeza que quer continuar?';

  @override
  String get alert_clear_selected_user_list =>
      'Está prestes a limpar os itens selecionados do seu histórico';

  @override
  String get confirm_clear_selected_user_list =>
      'Tem a certeza que quer continuar?';

  @override
  String get alert_select_items_to_clear =>
      'Selecione um ou mais itens para eliminar';

  @override
  String confirm_clear_user_list(String name) {
    return 'Está prestes a limpar a lista ($name): tem a certeza que quer continuar?';
  }

  @override
  String get confirm_delete_user_list_title => 'Eliminar a lista?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Está prestes a eliminar a lista \"$name\".\nTem a certeza de que quer continuar?';
  }

  @override
  String get confirm_delete_user_list_button => 'Sim, confirmo';

  @override
  String importance_label(String name, String id) {
    return 'Importância de $name: $id';
  }

  @override
  String get user_list_all_title => 'Listas';

  @override
  String get user_list_all_empty => 'Crie a sua primeira lista';

  @override
  String get product_list_select => 'Selecione uma lista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos',
      one: 'Um produto',
      zero: 'Lista vazia',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Adicionar lista';

  @override
  String get open_food_preferences_tooltip =>
      'Edite as suas preferências alimentares';

  @override
  String get add_photo_button_label => 'Adicionar fotografia';

  @override
  String get add_packaging_photo_button_label =>
      'Tirar fotografias de qualquer informação sobre embalagem/reciclagem';

  @override
  String get add_origin_photo_button_label =>
      'Tirar fotografias de qualquer informação relativa à origem';

  @override
  String get add_emb_photo_button_label =>
      'Tirar fotografias de qualquer informação relativa ao código de rastreabilidade';

  @override
  String get add_label_photo_button_label =>
      'Tirar fotografias de todos os selos e informações de certificação';

  @override
  String get choose_image_source_title => 'Escolha a fonte da imagem';

  @override
  String get choose_image_source_body =>
      'Por favor, escolha uma fonte de imagem';

  @override
  String get gallery_source_label => 'Galeria';

  @override
  String get gallery_source_access_denied_dialog_title =>
      'Acesso não autorizado';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Infelizmente, a aplicação não pode aceder à sua galeria, uma vez que negou anteriormente a permissão.\n\nAceda às configurações da aplicação no seu telemóvel em Definições -> Fotografias';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Abrir as configurações';

  @override
  String get share => 'Partilhar';

  @override
  String share_product_text(String url) {
    return 'Dê uma vista de olhos a este produto no Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Veja este produto no Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Veja este produto no Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Veja este produto em Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Dê uma vista de olhos na minha lista de produtos no Open Food Facts: $url';
  }

  @override
  String get capture => 'Tirar uma nova fotografia';

  @override
  String get capture_new_picture => 'Tirar uma foto';

  @override
  String get choose_from_gallery => 'Escolher da galeria';

  @override
  String get image_upload_queued =>
      'A imagem será enviada em segundo plano assim que possível.';

  @override
  String get add_price_queued =>
      'O preço será enviado para o servidor o mais rapidamente possível.';

  @override
  String get background_task_title_full_refresh =>
      'A iniciar a atualização de todos os produtos armazenados localmente';

  @override
  String get background_task_title_top_n =>
      'Iniciar o descarregamento dos produtos mais populares';

  @override
  String get expand_nutrition_facts =>
      'Expandir tabela de informações nutricionais';

  @override
  String get expand_nutrition_facts_body =>
      'Manter a tabela de informações nutricionais expandida';

  @override
  String get expand_ingredients => 'Expandir os ingredientes';

  @override
  String get expand_ingredients_body =>
      'Manter o painel de ingredientes expandido';

  @override
  String get no_internet_connection => 'Sem ligação à Internet';

  @override
  String get world_results_label => 'Todo o mundo';

  @override
  String get world_results_action => 'Alargar a pesquisa a todo o mundo';

  @override
  String get copy_to_clipboard => 'Copiar';

  @override
  String get paste_from_clipboard => 'Colar da área de transferência';

  @override
  String get no_data_available_in_clipboard =>
      'Não existem dados disponíveis na sua área de transferência';

  @override
  String get clipboard_barcode_copy =>
      'Copiar código de barras para a área de transferência';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Código de barras $barcode copiado para a área de transferência!';
  }

  @override
  String get open_product_website => 'Abrir este produto no website';

  @override
  String get language_picker_label => 'O seu idioma';

  @override
  String get country_picker_label => 'O seu país';

  @override
  String get currency_picker_label => 'A sua moeda';

  @override
  String get help_with_openfoodfacts => 'Ajuda com o OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'O produto será atualizado em segundo plano assim que possível.';

  @override
  String get no_email_client_available_dialog_title =>
      'Nenhuma aplicação de e-mail!';

  @override
  String get no_email_client_available_dialog_content =>
      'Por favor, envie-nos manualmente um e-mail para mobile@openfoodfacts.org';

  @override
  String get all_images => 'Todas as imagens';

  @override
  String get selected_images => 'Imagens selecionadas';

  @override
  String get product_card_remove_product_tooltip => 'Remover produto';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Novo código de barras digitalizado: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Remover todos os produtos do carrossel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Por favor, digitalize pelo menos dois produtos para compará-los';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Compare os produtos que digitalizou';

  @override
  String get scan_product_loading => 'Digitalizou o\ncódigo de barras:';

  @override
  String get scan_product_loading_initial =>
      'Estamos à procura deste produto!\nPor favor, aguarde alguns segundos…';

  @override
  String get scan_product_loading_long_request =>
      'Ainda estamos à procura deste produto!\nAcha que demora muito tempo a carregar? Nós também…';

  @override
  String get scan_product_loading_unresponsive =>
      'Ainda estamos à procura deste produto.\nGostaria de reiniciar a pesquisa?';

  @override
  String get scan_product_loading_restart_button => 'Reiniciar pesquisa';

  @override
  String get portion_calculator_description =>
      'Calcular informações nutricionais para uma quantidade específica';

  @override
  String get portion_calculator_hint => 'Quantidade';

  @override
  String get portion_calculator_accessibility =>
      'Introduza uma quantidade para calcular as informações nutricionais';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Por favor introduza uma quantidade entre $min e $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Dados em falta. Não foi possível efetuar o cálculo.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Informações nutricionais para $grams g (ou ml)';
  }

  @override
  String get offline_data => 'Dados off-line';

  @override
  String get ocr_image_upload_instruction =>
      'Envie uma imagem para extrair automaticamente as informações que ela contém.';

  @override
  String get upload_image => 'Enviar fotografia';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Falha ao descarregar a imagem';

  @override
  String get image_edit_url_error =>
      'Falha ao editar a imagem porque o URL da imagem não foi indicado.';

  @override
  String get user_picture_source_remember => 'Memorizar a minha escolha';

  @override
  String get user_picture_source_ask => 'Perguntar sempre';

  @override
  String get robotoff_continue => 'Continuar';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Próximas $count perguntas',
      one: 'Próxima pergunta',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'Mostrar palavra-passe';

  @override
  String get owner_field_info_title => 'Valores fornecidos pelo produtor';

  @override
  String get owner_field_info_message =>
      'Com esse logótipo destacamos os dados fornecidos pelo produtor, que podem não ser editáveis.';

  @override
  String get owner_field_info_close_button => 'Fechar esta informação';

  @override
  String get owner_field_image =>
      'Esta imagem é fornecida pelo produtor. Pode não ser editável.';

  @override
  String get edit_packagings_title => 'Componentes da embalagem';

  @override
  String get edit_packagings_element_add =>
      'Adicionar um componente de embalagem';

  @override
  String get edit_packagings_completed => 'A embalagem está completa';

  @override
  String edit_packagings_element_title(int index) {
    return 'Componente de embalagem #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Número de unidades';

  @override
  String get edit_packagings_element_hint_units =>
      'Introduza o número de unidades de embalagens com o mesmo formato e material.';

  @override
  String get edit_packagings_element_field_shape => 'Formato';

  @override
  String get edit_packagings_element_hint_shape =>
      'Introduza o nome do formato indicado nas instruções de reciclagem, se estiverem disponíveis ou selecione um formato.';

  @override
  String get edit_packagings_element_example_shape => 'Garrafa';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Escreva o material específico se souber (pode-se ver muitas vezes um código de material dentro de um triângulo na embalagem) ou um material genérico (por exemplo plástico ou metal) se não tiver a certeza.';

  @override
  String get edit_packagings_element_example_material => 'Vidro';

  @override
  String get edit_packagings_element_field_recycling =>
      'Instruções de reciclagem';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Introduza as instruções de reciclagem apenas se estiverem indicadas no produto.';

  @override
  String get edit_packagings_element_example_recycling => 'Reciclar';

  @override
  String get edit_packagings_element_field_quantity =>
      'Quantidade líquida de produto por unidade';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Introduza o peso líquido ou o volume líquido e indique a unidade (por exemplo g ou ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Peso de uma unidade vazia (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Remova qualquer resto de comida, lave e seque a parte da embalagem antes de a pesar. Se possível, use uma balança com precisão de 0,1g ou 0,01g.';

  @override
  String get background_task_title => 'Contribuições pendentes';

  @override
  String get background_task_subtitle =>
      'As suas contribuições são guardadas automaticamente no nosso servidor, mas nem sempre em tempo real.';

  @override
  String get background_task_list_empty =>
      'Nenhuma Tarefa em Segundo Plano Pendente';

  @override
  String get background_task_error_server_time_out =>
      'Tempo limite do servidor';

  @override
  String get background_task_error_no_internet =>
      'Erro de ligação à Internet. Tente mais tarde.';

  @override
  String get background_task_operation_unknown =>
      'tipo de operação desconhecida';

  @override
  String get background_task_operation_details => 'alterações detalhadas';

  @override
  String get background_task_operation_image => 'envio de fotografia';

  @override
  String get background_task_operation_refresh =>
      'atualização atrasada após o envio da fotografia';

  @override
  String get background_task_run_started => 'iniciado';

  @override
  String get background_task_run_not_started => 'ainda não iniciado';

  @override
  String get background_task_run_to_be_deleted => 'a ser eliminado';

  @override
  String get background_task_question_stop =>
      'Quer interromper esta tarefa o mais rápido possível?';

  @override
  String get feed_back => 'Opinião';

  @override
  String get undo => 'Desfazer';

  @override
  String get copy_email_to_clip_board =>
      'Copiar e-mail para a área de transferência';

  @override
  String get please_send_us_an_email_to => 'Por favor envie-nos um email para';

  @override
  String get email_copied_to_clip_board => 'Email copiado!';

  @override
  String get select_accent_color => 'Selecionar cor de destaque';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Azul';

  @override
  String get color_cyan => 'Ciano';

  @override
  String get color_green => 'Verde';

  @override
  String get color_light_brown => 'Predefinido';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Laranja';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Vermelho';

  @override
  String get color_rust => 'Ferrugem';

  @override
  String get color_teal => 'Verde-azulado';

  @override
  String get text_contrast_mode => 'Contraste do texto';

  @override
  String get contrast_high => 'Alto';

  @override
  String get contrast_medium => 'Médio';

  @override
  String get contrast_low => 'Baixo';

  @override
  String get product_refresher_internet_not_found => 'Produto não encontrado!';

  @override
  String get product_refresher_internet_not_connected =>
      'Não está ligado à Internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Servidor em baixo ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Erro do servidor ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produto não encontrado!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Não existe nenhum produto com o seguinte código de barras na nossa base de dados: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Sem ligação à Internet!';

  @override
  String get product_loader_network_error_message =>
      'Verifique se o telemóvel está ligado a uma rede Wi-Fi ou se os dados móveis estão ativados';

  @override
  String get page_not_found_title => 'Página não encontrada!';

  @override
  String get page_not_found_button => 'Voltar à página inicial';

  @override
  String get download_data => 'Descarregar dados';

  @override
  String get download_top_products =>
      'Descarregar os 1000 produtos mais digitalizados do seu país para fazer digitalizações instantâneas';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos',
    );
    return 'Descarregar os $_temp0 produtos mais digitalizados do seu país para fazer digitalizações instantâneas';
  }

  @override
  String get download_in_progress =>
      'A descarregar os dados\nIsto pode demorar algum tempo';

  @override
  String downloaded_products(int num) {
    return '$num produtos adicionados';
  }

  @override
  String get update_offline_data => 'Atualizar dados de produtos offline';

  @override
  String get update_local_database_sub =>
      'Atualizar a base de dados local de produtos com os dados mais recentes do Open Food Facts';

  @override
  String get clear_local_database => 'Remover dados de produtos offline';

  @override
  String get clear_local_database_sub =>
      'Limpe todos os dados de produtos locais da sua aplicação para libertar espaço';

  @override
  String deleted_products(int num) {
    return '$num produtos eliminados';
  }

  @override
  String get loading => 'A carregar…';

  @override
  String get know_more => 'Mais informação';

  @override
  String get offline_data_desc =>
      'Clique para saber mais sobre os dados offline';

  @override
  String get offline_product_data_title => 'Dados de produtos offline';

  @override
  String available_for_download(int num) {
    return '$num produtos disponíveis para digitalização instantânea';
  }

  @override
  String get country_selector_title => 'Selecione o seu país:';

  @override
  String get currency_selector_title => 'Selecione a sua moeda:';

  @override
  String get language_selector_title => 'Selecione o seu idioma:';

  @override
  String get language_selector_section_selected => 'Idiomas selecionados';

  @override
  String get language_selector_section_frequently_used =>
      'Usados frequentemente';

  @override
  String get action_delete_list => 'Eliminar';

  @override
  String get action_change_list => 'Alterar a lista atual';

  @override
  String get product_list_create => 'Criar';

  @override
  String get product_list_create_tooltip => 'Criar uma nova lista';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (novo cálculo)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (novo cálculo)';

  @override
  String get nutriscore_unknown => 'Nutri-Score desconhecido';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score desconhecido (novo cálculo)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score não aplicável';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'O Nutri-Score não é aplicável (novo cálculo)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Pontuação Verde A';

  @override
  String get environmental_score_b_new => 'Pontuação Verde B';

  @override
  String get environmental_score_c_new => 'Pontuação Verde C';

  @override
  String get environmental_score_d_new => 'Pontuação Verde D';

  @override
  String get environmental_score_e_new => 'Pontuação Verde E';

  @override
  String get environmental_score_unknown_new => 'Pontuação Verde Desconhecida';

  @override
  String get environmental_score_not_applicable_new =>
      'O Green-Score não é aplicável';

  @override
  String get nova_group_generic_new =>
      'Alimentos ultraprocessados - Grupos NOVA';

  @override
  String get nova_group_1 => 'NOVA Grupo 1';

  @override
  String get nova_group_2 => 'NOVA Grupo 2';

  @override
  String get nova_group_3 => 'NOVA Grupo 3';

  @override
  String get nova_group_4 => 'NOVA Grupo 4';

  @override
  String get nova_group_unknown => 'NOVA Grupo desconhecido';

  @override
  String get nutrition_facts => 'Valores nutricionais';

  @override
  String get faq_title_partners => 'Parceiros e patrocinadores da ONG';

  @override
  String get faq_title_vision =>
      'A visão, missão, valores e programas do Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Instale o Open Beauty Facts para criar uma base de dados de cosméticos';

  @override
  String get faq_title_install_pet =>
      'Instale o Open Pet Food Facts para criar uma base de dados de comida para animais de estimação';

  @override
  String get faq_title_install_product =>
      'Instale o Open Products Facts para criar uma base de dados de produtos para prolongar a vida útil dos objetos';

  @override
  String get faq_nutriscore_nutriscore =>
      'Novo cálculo do Nutri-Score: o que há de novo?';

  @override
  String get contact_title_pro_page =>
      'Profissional? Importe os seus produtos no Open Food Facts';

  @override
  String get contact_title_pro_email => 'Contacto do produtor';

  @override
  String get contact_title_press_page => 'Página de imprensa';

  @override
  String get contact_title_press_email => 'Contactos de imprensa';

  @override
  String get contact_title_newsletter => 'Assine o nosso boletim informativo';

  @override
  String get contact_title_calendar =>
      'Inscreva-se no nosso calendário comunitário';

  @override
  String get hunger_games_loading_line1 => 'Por favor, dê-nos alguns segundos…';

  @override
  String get hunger_games_loading_line2 =>
      'Estamos a descarregar as perguntas!';

  @override
  String get hunger_games_error_label =>
      'Ups! Algo correu mal... e não conseguimos carregar as perguntas.';

  @override
  String get hunger_games_error_retry_button => 'Vamos tentar novamente!';

  @override
  String get reorder_attribute_action => 'Reordenar os atributos';

  @override
  String get link_cant_be_opened =>
      'Este link não pode ser aberto no seu dispositivo. Por favor, verifique se você tem um navegador instalado.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detalhes de $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detalhes de $pageName com $productName';
  }

  @override
  String get guide_title => 'Guia';

  @override
  String get guide_share_label => 'Partilhar';

  @override
  String get guide_nutriscore_v2_title =>
      'O Nutri-Score está a evoluir: explicações!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'O que é o Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'O Nutri-Score é um logotipo que tem como objetivo informar sobre a **qualidade nutricional dos alimentos**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'O código de cores varia entre o verde escuro (**A**) para os produtos **mais saudáveis** e o vermelho escuro (**E**) para os **menos saudáveis**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'O logótipo Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Porque é que o Nutri-Score está a evoluir?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'A fórmula do Nutri-Score **está a evoluir** para fornecer melhores recomendações:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Avaliar melhor todas as bebidas';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'As notas comparativas de **leite**, **bebidas lácteas** com adição de açúcar e **bebidas vegetais** foram melhor diferenciadas no novo algoritmo.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Melhor classificação das bebidas';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'O **conteúdo de açúcar** é tido em melhor conta e favorece as bebidas **pouco adoçadas**.\\n**Os adoçantes também serão penalizados**: os refrigerantes dietéticos passarão de uma classificação B para uma classificação entre C e E. A água continua a ser a bebida recomendada.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Penalização do sal e do açúcar';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Os produtos **demasiado doces** ou ** demasiado salgados** verão a sua **classificação ainda mais penalizada**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarquia nos óleos e peixes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'A classificação de certos **peixes gordos** e **óleos ricos em gorduras boas** melhorará.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title =>
      'Limitar a carne vermelha';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'O consumo de **carne vermelha deve ser limitado**. É por isso que **as aves domésticas serão comparativamente melhor classificadas**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Como distinguir o antigo Nutri-Score do novo cálculo?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'A partir de agora, o logótipo pode apresentar uma menção \"**Novo cálculo**\" para esclarecer que se trata efetivamente do novo cálculo.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'O logótipo do novo Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Onde encontrar o novo cálculo do Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'O Nutri-Score é aplicado em 7 países: França, Alemanha, Bélgica, Espanha, Luxemburgo, Países Baixos e Suíça.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Os fabricantes têm, no máximo, **2 anos** após a assinatura do decreto **para substituir** o cálculo antigo pelo novo.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Sem ter de esperar, já encontrará na aplicação OpenFoodFacts** o novo cálculo, mesmo que os fabricantes não tenham atualizado a classificação.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'O que não muda';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'O Nutri-Score é uma pontuação concebida para **medir a qualidade nutricional**. É **complementar ao grupo NOVA** sobre **alimentos ultra-processados** (também presente na aplicação).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Para os fabricantes, a indicação do Nutri-Score **continua a ser facultativa**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'O que é o Green Score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'O Green-Score é um logótipo que visa informá-lo sobre o **impacto ambiental dos alimentos**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'O código de cores varia entre o verde escuro (**A+**) para os produtos **de menor impacto** e o vermelho escuro (**F**) para os produtos **de maior impacto**.';

  @override
  String get guide_greenscore_logos_caption => 'Os logótipos do Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'O núcleo: Avaliação do ciclo de vida (ACV)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Uma avaliação científica das categorias de alimentos';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Para cada categoria de produto, é estabelecida uma pontuação de referência utilizando os dados da base de dados ambiental Agribalyse (desenvolvida pela ADEME e INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Análise do ciclo de vida** é um método de avaliação padronizado para realizar uma avaliação ambiental multiestágio e multicritério.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Mede:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 fases de produção';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agricultura';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processamento';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Embalagem';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transporte';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribuição';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumo';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicadores de impacto ambiental';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Alterações climáticas/pegada de carbono';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Depleção da camada de ozono';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiação ionizante';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Terra';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Utilização de água e energia';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Poluição do ar';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Água marinha e doce (partículas, acidificação, eutrofização)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Esgotamento de recursos.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bónus e penalidades';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Modo de produção';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origem dos ingredientes';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Espécies ameaçadas';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Embalagem';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Uma maior necessidade de transparência para melhor medir e reduzir os impactos ambientais';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Como podem os fabricantes ajudar';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Os fabricantes podem enviar-nos as suas informações diretamente através da nossa plataforma gratuita para produtores.';

  @override
  String get guide_greenscore_better_product_title =>
      'Qual o produto melhor para o planeta?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Pode ser difícil dizer';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Escolher alimentos sustentáveis é uma das coisas mais poderosas que podemos fazer pelo clima, uma vez que **o nosso sistema alimentar global é responsável por mais de um quarto de todas as emissões de gases com efeito de estufa**.\n(Fonte: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Você tem o poder!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'A boa notícia é que nos dá uma forma poderosa de gerar mudança.\n**Cada um de nós faz cerca de 1.000 refeições por ano**. São 1.000 oportunidades para **escolher um futuro melhor para o planeta**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Ajuda a ser responsável e a decidir';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Escolher alimentos sustentáveis pode parecer complexo. Os rótulos são confusos e muitas vezes falta informação. O Green-Score foi criado para simplificar, oferecendo uma classificação ambiental **clara**, **baseada em dados científicos** e **transparente** para produtos alimentares, exatamente onde precisa: enquanto faz compras.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparência';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Ao contrário dos rótulos proprietários, o cálculo do Green-Score é **completamente aberto** e pode ser **verificado por qualquer pessoa**.';

  @override
  String get guide_nova_title => 'Alimentos ultra-processados';

  @override
  String get guide_nova_what_is_nova_title => 'O que é o ultraprocessamento?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Os grupos NOVA informam sobre o nível de processamento dos alimentos.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'A classificação NOVA permite a categorização dos alimentos em **4 grupos** com base no seu **grau de processamento industrial** (alimentos minimamente processados ou não processados, ingredientes culinários, alimentos processados, alimentos ultraprocessados).';

  @override
  String get guide_nova_logos_caption => 'Os logótipos da NOVA';

  @override
  String get guide_nova_groups_title => 'Os 4 grupos NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Existem 4 grupos NOVA, sendo o problemático o Grupo 4 - Alimentos ultraprocessados.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Alimentos minimamente processados ou não processados';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Ingredientes culinários processados';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 Foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Alimentos processados';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** Foods. Processes include various preservation Or cooking Methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and ARE recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, In combination With other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Alimentos ultra-processados';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. Ingredients in These formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed Products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted From foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Os problemas com o ultraprocessamento';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Processamento extremo de ingredientes alimentares';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aditivos que vão além da pura segurança alimentar';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Processamento que não pode fazer em casa';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Os aspetos predatórios e financeiros do ultraprocessamento';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-pt.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-pt.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-pt.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-pt.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Atualmente, são poucas as empresas que possuem grandes bases de dados de preços de produtos ao nível do código de barras. Estes preços não estão disponíveis gratuitamente, mas são vendidos a um preço elevado a agentes privados, investigadores e outras organizações que os podem pagar.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'Sou um retalhista e quero contribuir com preços. Como é que posso fazer isso?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-pt.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Pré-visualizar';

  @override
  String get prices_feedback_form =>
      'Clique aqui para nos enviar os seus comentários sobre esta nova funcionalidade!';

  @override
  String get menu_button_list_actions => 'Selecione uma ação';

  @override
  String get error_loading_photo => 'Erro ao carregar a foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Usar como…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Usar esta imagem como…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Usar esta imagem como… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detalhes';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detalhes desta foto';

  @override
  String get photo_viewer_details_title => 'Detalhes da foto';

  @override
  String get photo_viewer_details_contributor_title => 'Colaborador';

  @override
  String get photo_viewer_details_size_title => 'Tamanho';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatível';

  @override
  String get user_lists_action_multi_select => 'Selecionar vários';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'A sua pontuação de compatibilidade: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Imagem frontal';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Imagem dos ingredientes';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Imagem das informações nutricionais';

  @override
  String get product_image_packaging_accessibility_label =>
      'Imagem da embalagem';

  @override
  String get product_image_other_accessibility_label => 'Outras imagens';

  @override
  String get product_image_outdated_message =>
      'Esta imagem pode estar desatualizada';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (esta imagem pode estar desatualizada)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (esta imagem pode estar bloqueada pelo produtor)';
  }

  @override
  String get product_image_error => 'Não foi possível carregar a imagem!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Não foi possível carregar a $type (erro de rede?)';
  }

  @override
  String get product_page_image_no_image_available => 'Nenhuma \nimagem!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Nenhuma imagem disponível para este produto';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reordenar ou ocultar ações';

  @override
  String get product_page_action_bar_setting_modal_title => 'Editar ações';

  @override
  String get product_page_action_bar_item_move_up => 'Mover para cima';

  @override
  String get product_page_action_bar_item_move_down => 'Mover para baixo';

  @override
  String get product_page_action_bar_item_enable => 'Ativar a ação';

  @override
  String get product_page_action_bar_item_disable => 'Desativar a ação';

  @override
  String get product_page_pending_operations_banner_title =>
      'A enviar as suas edições…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Os dados mostrados nesta página **ainda não refletem as suas alterações**.\nAguarde alguns segundos…';

  @override
  String get product_add_a_language => 'Adicionar um idioma';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Código de barras $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Remover todos os produtos do carrossel';

  @override
  String get carousel_unsupported_header => 'Código de barras não suportado!';

  @override
  String get carousel_unsupported_title => 'Uuups!';

  @override
  String get carousel_unsupported_text =>
      'O código de barras digitalizado não é suportado pelo Open Food Facts!';

  @override
  String get carousel_error_header => 'Erro!';

  @override
  String get carousel_error_title => 'Que chatice!';

  @override
  String get carousel_error_text_1 =>
      'Não conseguimos descarregar informações sobre este código de barras:';

  @override
  String get carousel_error_text_2 =>
      'Verifique a sua ligação à Internet ou clique neste botão:';

  @override
  String get carousel_error_button => 'Repetir';

  @override
  String get carousel_unknown_product_header => 'Produto desconhecido';

  @override
  String get carousel_unknown_product_title => 'Encontraste uma __raridade!__';

  @override
  String get carousel_unknown_product_text =>
      'Este produto ainda não existe na nossa base de dados: ';

  @override
  String get carousel_unknown_product_button => 'Adicionar este produto';

  @override
  String get carousel_loading_header => 'A carregar informação...';

  @override
  String get carousel_loading_title =>
      'Acabou de digitalizar um produto com o seguinte código de barras:';

  @override
  String get carousel_loading_text =>
      'Estamos a procurar na nossa base de dados com mais de **3 milhões de produtos!**';

  @override
  String get product_type_subtitle_food =>
      'Legumes, frutas, alimentos congelados…';

  @override
  String get product_type_subtitle_beauty =>
      'Maquilhagem, sabonetes, pastas de dentes…';

  @override
  String get product_type_subtitle_pet_food => 'Comida para cães, gatos…';

  @override
  String get product_type_subtitle_product => 'Telemóveis, mobiliário…';

  @override
  String get photo_field_front => 'Fotografia do produto';

  @override
  String get photo_field_ingredients => 'Foto de ingredientes';

  @override
  String get photo_field_nutrition => 'Fotografia das informações nutricionais';

  @override
  String get photo_field_packaging => 'Foto de informações da embalagem';

  @override
  String get photo_already_exists => 'Esta fotografia já existe';

  @override
  String get photo_missing => 'Esta fotografia está em falta';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Rodar para a esquerda';

  @override
  String get photo_rotate_right => 'Rodar para a direita';

  @override
  String get photo_undo_action => 'Desfazer a ação anterior';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Um mapa mundial de $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Contribuidores do OpenStreetMap';

  @override
  String get not_applicable_short => 'N/D';

  @override
  String get knowledge_panel_warning_text => 'Aviso';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Porque é que este Nutri-Score é diferente do que está na embalagem?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Existem duas explicações possíveis:\nA lista de ingredientes e/ou informações nutricionais não estão atualizadas.\n\nFornecemos o “Novo cálculo” do Nutri-Score (ou V2). Por favor, verifique se tem a indicação “Novo cálculo” na embalagem.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Verifique os ingredientes';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Verifique as informações nutricionais';

  @override
  String url_not_supported(String url) {
    return 'Infelizmente, não é possível abrir o URL:\n$url';
  }

  @override
  String get product_list_export => 'Exportar';

  @override
  String get product_list_import => 'Importar';

  @override
  String get product_footer_action_barcode => 'Ver código de barras';

  @override
  String get product_footer_action_barcode_short => 'Código de barras';

  @override
  String get product_footer_action_open_website => 'Abrir site';

  @override
  String get product_footer_action_report => 'Denunciar';

  @override
  String get product_footer_action_contributor_guide => 'Ajuda';

  @override
  String get product_footer_action_data_quality_tags => 'Qualidade dos dados';

  @override
  String get product_page_tab_for_me => 'Para mim';

  @override
  String get product_page_tab_website => 'Site';

  @override
  String get product_page_tab_prices => 'Preços';

  @override
  String get prices_explanation_card_title => 'Porquê os preços?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** é um projeto para recolher e partilhar preços de produtos em todo o mundo 🌍. O Open Prices é desenvolvido e mantido pela Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Mais informações';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title =>
      'O que são atributos da Folksonomia?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Os atributos são baseados em **chave-valor**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Estas propriedades são criadas e arquivadas pelos colaboradores para qualquer tipo de utilização.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Sem preço disponível';

  @override
  String get prices_products_empty_explanation =>
      'Seja o primeiro a contribuir!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Principais $pageSize produtos (total: $total)';
  }

  @override
  String get app_review_title => 'Está a gostar desta aplicação?';

  @override
  String get app_review_low => 'Podia ser melhor';

  @override
  String get app_review_medium => 'Não é má';

  @override
  String get app_review_high => 'Adoro-a!';

  @override
  String get app_review_feedback_modal_title =>
      'Ajude-nos a melhorar a nossa aplicação';

  @override
  String get app_review_feedback_modal_content =>
      'Se tiver alguns minutos, responda a este formulário para que **possamos melhorar em futuras atualizações**:';

  @override
  String get app_review_feedback_modal_open_form => 'Responder ao formulário';

  @override
  String get app_review_feedback_modal_later => 'Perguntar depois';

  @override
  String get nutrition_facts_extract_new =>
      'NOVO: pode extrair automaticamente os nutrientes da imagem!';

  @override
  String get nutrition_facts_extract_button_text => 'Extrair agora';

  @override
  String get nutrition_facts_extract_in_progress => 'Extração em curso…';

  @override
  String get nutrition_facts_extract_successful => 'Extração bem-sucedida';

  @override
  String get nutrition_facts_extract_failed =>
      'Falha ao extrair os nutrientes da imagem';

  @override
  String get prices_discount => 'Desconto';

  @override
  String get prices_stats_statistics => 'Estatísticas';

  @override
  String get prices_stats_title => 'Estatísticas de preços';

  @override
  String get prices_stats_prices_section => 'Preços';

  @override
  String get prices_stats_products_section => 'Produtos';

  @override
  String get prices_stats_locations_section => 'Localizações';

  @override
  String get prices_stats_proofs_section => 'Comprovativos';

  @override
  String get prices_stats_contributors_section => 'Colaboradores';

  @override
  String get prices_stats_experiments_section => 'Experiências';

  @override
  String get prices_stats_misc_section => 'Diversos';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'Com um código de barras';

  @override
  String get prices_stats_with_category => 'Com uma categoria';

  @override
  String get prices_stats_with_discount => 'Com desconto';

  @override
  String get prices_stats_community => 'Comunidade';

  @override
  String get prices_stats_consumption => 'Consumo';

  @override
  String get prices_stats_with_price => 'Com um preço';

  @override
  String get prices_stats_food => 'Alimentação';

  @override
  String get prices_stats_beauty => 'Beleza';

  @override
  String get prices_stats_products => 'Produtos';

  @override
  String get prices_stats_pet_food => 'Alimentos de pets';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Países';

  @override
  String get prices_stats_price_tag => 'Etiqueta de preço';

  @override
  String get prices_stats_receipt => 'Talão';

  @override
  String get prices_stats_gdpr_request => 'Pedido RGPD';

  @override
  String get prices_stats_shop_import => 'Importado pela loja';

  @override
  String get prices_stats_challenges => 'Desafios';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Preços ligados a uma etiqueta de preço';

  @override
  String get prices_stats_currencies => 'Moedas';

  @override
  String get prices_stats_years => 'Anos';

  @override
  String get prices_stats_by_source_title =>
      'Preços e comprovativos por origem';

  @override
  String get prices_stats_website => 'Site';

  @override
  String get prices_stats_mobile_app => 'Aplicação móvel';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Outro';

  @override
  String get prices_stats_last_updated => 'Última atualização em';

  @override
  String get prices_stats_error =>
      'Ocorreu um erro ao carregar as estatísticas.';

  @override
  String get product_edit_robotoff_question_answered => 'Pergunta respondida!';

  @override
  String get product_edit_robotoff_proof => 'Demonstração';

  @override
  String get preferences_card_general => 'Geral';

  @override
  String get preferences_prices_title => 'Preços';

  @override
  String get preferences_prices_subtitle =>
      'Gerir as suas preferências de preços';

  @override
  String get preferences_card_project => 'O projeto Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuir';

  @override
  String get preferences_my_contributions_title => 'As minhas contribuições';

  @override
  String get preferences_my_stats_title => 'As minhas estatísticas';

  @override
  String get preferences_contribute_subtitle =>
      'Traduza, melhore as nossas ferramentas…';

  @override
  String get preferences_connect_title => 'Ligar';

  @override
  String get preferences_connect_subtitle =>
      'Entre em contacto ou siga-nos nas redes sociais';

  @override
  String get preferences_support_title => 'Fazer um donativo';

  @override
  String get preferences_support_subtitle =>
      'Ajude-nos a informar milhões de consumidores em todo o mundo';

  @override
  String get preferences_card_help => 'Ajuda e Suporte';

  @override
  String get preferences_faq_title => 'Perguntas frequentes';

  @override
  String get preferences_faq_subtitle => 'Obtenha respostas às suas perguntas';

  @override
  String get logged_out => 'Desconectado';

  @override
  String get preferences_app_bar_message =>
      'Obrigado por ser um dos nossos membros!';

  @override
  String get preferences_app_bar_products_modified => 'Produtos alterados';

  @override
  String get preferences_app_bar_prices_added => 'Preços adicionado';

  @override
  String get preferences_app_bar_see_all_stats => 'Ver todas as estatísticas';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Procurar $provider por \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Pesquisar uma definição (por exemplo, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Acessibilidade: Mostrar emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Acessibilidade: Remover cores';

  @override
  String get preferences_app_settings_products => 'Produtos';

  @override
  String get preferences_card_about => 'Sobre';

  @override
  String get preferences_legal_information_title => 'Informações legais';

  @override
  String get preferences_legal_information_subtitle =>
      'Termos de utilização, política de privacidade e muito mais';

  @override
  String get preferences_terms_of_use => 'Termos de utilização';

  @override
  String get preferences_legal_mentions => 'Menções legais';

  @override
  String get preferences_legal_header =>
      'Open Food Facts é uma base de dados de produtos alimentares **feita por todos, para todos**.\nPode usá-lo para fazer melhores escolhas alimentares e, como são **dados abertos**, qualquer pessoa pode **reutilizá-los para qualquer fim**.';

  @override
  String get preferences_privacy_policy => 'Política de privacidade';

  @override
  String get preferences_licenses => 'Licenças';

  @override
  String get preferences_about_app_title => 'Sobre a aplicação';

  @override
  String get preferences_about_app_subtitle =>
      'Informações técnicas, informações para programadores e muito mais';

  @override
  String get preferences_card_information => 'Informação';

  @override
  String get preferences_version_number_title => 'Número da versão';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'Loja de aplicações';

  @override
  String get preferences_app_system_settings => 'Configurações do sistema';

  @override
  String get preferences_source_code => 'Aceder ao código fonte';

  @override
  String get preferences_source_code_subtitle =>
      'E comece a causar impacto em milhões';

  @override
  String get preferences_add_prices => 'Adicionar preços';

  @override
  String get preferences_complete_products => 'Complete os produtos';

  @override
  String get preferences_tips => 'Dicas';

  @override
  String get tips_discover_nutriscore => 'Conheça o novo Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => 'No site Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Gerir a minha conta';

  @override
  String get preferences_manage_account_tooltip => 'Gerir a sua conta';

  @override
  String get preferences_change_password_title => 'Alterar a minha senha';

  @override
  String get preferences_danger_zone => 'Zona de perigo';

  @override
  String get preferences_account_deletion_subtitle =>
      'Todas as suas contribuições serão perdidas';

  @override
  String get preferences_contributions_title => 'Contribuições';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Configurações do aplicativo';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Uma forma muito experimental de digitalizar produtos offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Atualizar todos os produtos do servidor';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Por favor, evite fazê-lo, a menos que seja absolutamente necessário.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Modo de demonstração';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Adicionar cartões ao scanner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Adiciona 3 produtos de amostra ao scanner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Apresentador do Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Anfitrião: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experimentos de acessibilidade';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Seleção de vários produtos para preços';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Painéis de conhecimento solicitados pelo utilizador';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Acesso temporário à pesquisa de localização';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Comparação lado a lado de 2 ou 3 produtos';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importação de lista de produtos';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Pontuações e metodologias';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Descubra como é calculado o Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Conheça as principais alterações na metodologia';

  @override
  String get preferences_faq_discover_project_title => 'Descubra o projeto';

  @override
  String get preferences_faq_discover_off_title =>
      'Descubra factos sobre os alimentos abertos';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Perguntas Frequentes';

  @override
  String get preferences_faq_off_ngo_title => 'A ONG Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informação';

  @override
  String get preferences_connect_community_updates_title =>
      'Receba atualizações da comunidade';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Fique a par das novidades da aplicação e da comunidade';

  @override
  String get preferences_connect_community_calendar_title =>
      'Inscreva-se no nosso calendário comunitário';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Participe participando num dos nossos eventos virtuais';

  @override
  String get preferences_connect_blog_title => 'O blogue Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Receba as últimas notícias assim que elas acontecem';

  @override
  String get preferences_connect_community_help_title =>
      'Obtenha ajuda da comunidade';

  @override
  String get preferences_connect_improve_app_title =>
      'Ajude-nos a melhorar a aplicação';

  @override
  String get preferences_connect_debug_info_title =>
      'Envie-nos informações de depuração';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Envie-nos um e-mail com informações detalhadas de depuração';

  @override
  String get preferences_connect_feedback_title =>
      'Envie-nos feedback sobre a aplicação';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Ajude a moldar o futuro da aplicação';

  @override
  String get preferences_connect_survey_title =>
      'Responda à pesquisa da aplicação';

  @override
  String get preferences_connect_survey_subtitle =>
      'Ajude-nos a compreender o que devemos construir a seguir';

  @override
  String get preferences_connect_professionals_title => 'Profissionais';

  @override
  String get preferences_connect_pro_subtitle =>
      'Totalmente gratuito, garante dados precisos para 500 aplicações e milhões de consumidores. Self-service, compatível com o seu PIM ou folhas de cálculo (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Entre em contacto para começar';

  @override
  String get preferences_connect_press_title => 'Imprensa';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Obtenha todo o material necessário para o seu relatório';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Entre em contacto para questões da imprensa ou para nos informar sobre o seu relatório';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Torne-se um voluntário ativo';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Desenvolvimento, Comunicação, Design… qualquer tipo de voluntariado ou especialização é bem-vindo!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Descubra algumas das muitas formas pelas quais pode contribuir';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Desenvolvimento de aplicações móveis';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Saiba como contribuir para o desenvolvimento de software';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Compilações instáveis diárias, novos recursos';

  @override
  String get preferences_contribute_local_community_title =>
      'Faça crescer a sua comunidade local';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Ajuda com software, conteúdo, traduções de análise de ingredientes';

  @override
  String get preferences_contribute_share_subtitle =>
      'Preparámos um pequeno modelo para o ajudar :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Passos simples para aumentar a transparência alimentar no seu país';

  @override
  String get preferences_contribute_data_quality_title => 'Qualidade dos dados';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Junte-se à equipa de qualidade de dados';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Junte-se ao nosso esforço para garantir que a base de dados está completa e precisa';

  @override
  String get preferences_contributions_products_added_title =>
      'Produtos adicionados';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Novos produtos que adicionei ao Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produtos que preciso de completar';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Todos os produtos incompletos';

  @override
  String get preferences_my_contributions_prices_title => 'Preços';

  @override
  String get preferences_my_contributions_my_prices_title => 'Meus valores';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Os meus preços, as minhas provas…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produtos que pode ajudar a completar';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ajude a calcular o Nutri-Score e o Green-Score no seu país';

  @override
  String get preferences_prices_user_prices_subtitle => 'Preços que contribuí';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Etiquetas de preço e recibos';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Tire fotografias dos seus recibos e digitalize os códigos de barras associados';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Tire fotografias dos preços numa loja';

  @override
  String get preferences_prices_newest_title => 'Preços mais recentes';

  @override
  String get preferences_prices_newest_subtitle =>
      'Últimos preços adicionados pela comunidade Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Colaboradores com mais preços';

  @override
  String get preferences_prices_metrics_title => 'Métricas de preço aberto';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Acompanhe a evolução do projeto';

  @override
  String get preferences_prices_ways_contribute_title => 'Formas de contribuir';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Confirme os preços adicionados por si ou por outros, com a ajuda da IA';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Adicione rapidamente muitos recibos ou fotografias de prateleiras do seu rolo de câmara';

  @override
  String get preferences_prices_challenges_title => 'Desafios mensais';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Participe em missões temáticas mensais para recolher preços';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Recupere os seus dados de fidelização';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Saiba como solicitar os seus dados';

  @override
  String get preferences_page_customize_app_title => 'Personalize a aplicação';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribua para o projeto';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Formas simples de ajudar o Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologias de pontuação, ajuda e mais sobre o projeto';

  @override
  String get product_edit_robotoff_positive_button => 'Aceitar sugestão';

  @override
  String get product_edit_robotoff_negative_button => 'Rejeitar sugestão';

  @override
  String get product_edit_robotoff_show_proof => 'Mostrar prova';

  @override
  String get product_edit_robotoff_expand_proof => 'Expandir a prova';

  @override
  String get product_page_tab_raw_data => 'Dados brutos';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Página $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Página $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count de $total itens';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count de $total itens';
  }

  @override
  String item_count(int count) {
    return '$count itens';
  }

  @override
  String item_count_string(String count) {
    return '$count itens';
  }

  @override
  String get prices_no_result => 'Nenhuma estatística de preço encontrada.';

  @override
  String get prices_error_loading_more_items => 'Erro ao carregar mais itens';

  @override
  String get prices_proof_error =>
      'Falha na autenticação, não foi possível obter provas';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count de $total provas';
  }

  @override
  String proof_count(int count) {
    return '$count comprovativos';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count de $total colaboradores';
  }

  @override
  String contributors_count(int count) {
    return '$count colaboradores';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count de $total locais';
  }

  @override
  String prices_locations_count(int count) {
    return '$count locais';
  }

  @override
  String get restart_to_apply_message =>
      'Reinicie a aplicação para aplicar as alterações.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interface gráfica';

  @override
  String get preferences_app_settings_media_title => 'Mídia';

  @override
  String get preferences_about_app_development_title => 'Desenvolvimento';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Laboratórios Abertos de Informação Alimentar';

  @override
  String get preferences_root_account_title => 'Conta';

  @override
  String get preferences_contribute_translate_header =>
      'Traga o Open Food Facts para o seu idioma';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Inscreva-se na versão alfa da aplicação';

  @override
  String get preferences_dev_mode_section_data =>
      'Contribuições e dados do produto';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Não mostrar Folksonomia';

  @override
  String get preferences_account_title => 'Conta';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Adicionado em $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Nome';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}

/// The translations for Portuguese, as used in Brazil (`pt_BR`).
class AppLocalizationsPtBr extends AppLocalizationsPt {
  AppLocalizationsPtBr() : super('pt_BR');

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Sim';

  @override
  String get add => 'Adicione';

  @override
  String get account_delete_message =>
      'Tem certeza de que deseja excluir sua conta?\nSe houver um motivo específico, compartilhe abaixo';

  @override
  String get reason => 'Motivo';

  @override
  String get okay => 'Ok';

  @override
  String get validate => 'Validar';

  @override
  String get create => 'Criar';

  @override
  String get applyButtonText => 'Aplicar';

  @override
  String get next_label => 'Seguinte';

  @override
  String get continue_label => 'Continuar';

  @override
  String get exit_label => 'Sair';

  @override
  String get previous_label => 'Anterior';

  @override
  String get go_back_to_top => 'Voltar ao topo';

  @override
  String get save => 'Guardar';

  @override
  String get save_confirmation => 'Você tem certeza de que deseja salvar?';

  @override
  String get skip => 'Pular';

  @override
  String get cancel => 'Cancelar';

  @override
  String get ignore => 'Ignorar';

  @override
  String get close => 'Fechar';

  @override
  String get no => 'Não';

  @override
  String get stop => 'Parar';

  @override
  String get finish => 'Terminar';

  @override
  String get calculate => 'Calcular';

  @override
  String get reset_food_prefs => 'Resetar preferências alimentares';

  @override
  String get error => 'Algo correu mal';

  @override
  String get error_occurred => 'Ocorreu um erro';

  @override
  String get featureInProgress =>
      'Ainda estamos trabalhando nesse recurso, fique atento';

  @override
  String get label_web => 'Visualizar no navegador';

  @override
  String get learnMore => 'Saiba mais';

  @override
  String get unknown => 'Desconhecido';

  @override
  String get match_very_good => 'Correspondência excelente';

  @override
  String get match_good => 'Boa correspondência';

  @override
  String get match_poor => 'Baixa correspondência';

  @override
  String get match_may_not => 'Pode não corresponder';

  @override
  String get match_does_not => 'Não corresponde';

  @override
  String get match_unknown => 'Combinação desconhecida';

  @override
  String get match_short_very_good => 'Correspondência excelente';

  @override
  String get match_short_good => 'Boa correspondência';

  @override
  String get match_short_poor => 'Baixa correspondência';

  @override
  String get match_short_may_not => 'Pode não corresponder';

  @override
  String get match_short_does_not => 'Não corresponde';

  @override
  String get match_short_unknown => 'Combinação desconhecida';

  @override
  String get licenses => 'Licenças';

  @override
  String get looking_for => 'Procurando';

  @override
  String get welcomeToOpenFoodFacts => 'Bem-vindo ao Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts é uma organização global sem fins lucrativos dinamizada por comunidades locais.';

  @override
  String get productDataUtility =>
      'Veja as informações nutricionais relevantes às suas preferências.';

  @override
  String get healthCardUtility =>
      '▶ Escolha os alimentos que são bons para você.';

  @override
  String get ecoCardUtility =>
      'Escolha alimentos que sejam bons para o planeta.';

  @override
  String get server_error_open_new_issue =>
      'Nenhuma resposta do servidor! Você pode reportar o problema com o link a seguir.';

  @override
  String get sign_in_text =>
      'Entre na sua conta Open Food Facts para guardar as suas contribuições';

  @override
  String get incorrect_credentials => 'Nome do usuário ou senha incorretos.';

  @override
  String get password_lost_incorrect_credentials =>
      'Este endereço eletrónico ou este nome de utilizador não existe. Por favor, verifique as suas credenciais.';

  @override
  String get password_lost_server_unavailable =>
      'Estamos atualmente a sofrer lentidão nos nossos servidores e pedimos desculpa por isso. Por favor, tente novamente mais tarde.';

  @override
  String get login => 'Login';

  @override
  String get login_result_type_server_unreachable =>
      'Não foi possível estabelecer ligação à rede';

  @override
  String get login_result_type_server_issue =>
      'Problema no servidor. Por favor, tente mais tarde.';

  @override
  String get login_page_username_or_email =>
      'Por favor, digite o nome de usuário ou e-mail';

  @override
  String get login_page_password_error_empty =>
      'Por favor, introduza uma palavra-passe';

  @override
  String get create_account => 'Criar uma conta';

  @override
  String get sign_in => 'Iniciar sessão';

  @override
  String get sign_in_mandatory =>
      'Para essa funcionalidade, é necessário iniciar sessão.';

  @override
  String get help_improve_country =>
      'Ajude a melhorar o Open Food Facts no seu país';

  @override
  String get sign_out => 'Sair';

  @override
  String get sign_out_confirmation => 'Você tem certeza que deseja sair?';

  @override
  String get password => 'Palavra-passe';

  @override
  String get forgot_password => 'Esqueci-me da palavra-passe';

  @override
  String get forgot_password_question => 'Esqueceu sua senha?';

  @override
  String get view_profile => 'Ver perfil';

  @override
  String get reset_password => 'Recuperar a palavra-passe';

  @override
  String get reset_password_explanation_text =>
      'Caso se tenha esquecido da palavra-passe, introduza o seu nome de utilizador ou e-mail para receber instruções para a criação de uma nova palavra-passe. Lembre-se também de verificar a pasta \"Spam\".';

  @override
  String get username_or_email => 'Nome de utilizador ou e-mail';

  @override
  String get reset_password_done =>
      'Enviámos um e-mail para o endereço associado à sua conta, com uma hiperligação para redefinir a palavra-passe. Verifique tambem a sua pasta \"Spam\"';

  @override
  String get send_reset_password_mail => 'Mudar a palavra-passe';

  @override
  String get enter_some_text => 'Por favor introduza algum texto';

  @override
  String get sign_up_page_title => 'Criar conta';

  @override
  String get sign_up_page_action_button => 'Criar conta';

  @override
  String get sign_up_page_action_doing_it => 'A criar a conta…';

  @override
  String get sign_up_page_action_ok =>
      'Parabéns! A sua conta foi criada com sucesso.';

  @override
  String get sign_up_page_display_name_hint => 'Nome';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Por favor, escolha o nome que deseja usar';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'O e-mail é obrigatório';

  @override
  String get sign_up_page_email_error_invalid => 'E-mail inválido';

  @override
  String get sign_up_page_username_hint => 'Nome de utilizador: público';

  @override
  String get sign_up_page_username_error_empty =>
      'Por favor introduza um nome de utilizador';

  @override
  String get sign_up_page_username_error_invalid =>
      'Por favor introduza um nome de utilizador válido';

  @override
  String get sign_up_page_username_description =>
      'O nome de utilizador não pode conter espaços, maiúsculas ou caracteres especiais.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'O nome de utilizador não pode exceder $value caracteres';
  }

  @override
  String get sign_up_page_password_hint => 'Palavra-passe';

  @override
  String get sign_up_page_password_error_empty =>
      'Por favor, introduza uma palavra-passe';

  @override
  String get sign_up_page_password_error_invalid =>
      'Por favor introduza uma palavra-passe com pelo menos 6 caracteres';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirme a palavra-passe';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Por favor, confirme a senha';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'As senhas não conferem';

  @override
  String get sign_up_page_agree_text => 'Concordo com a Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'termos de uso e contribuição';

  @override
  String get donate_url =>
      'https://world-pt.openfoodfacts.org/fazer-um-donativo-ao-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Ao criar uma conta, é obrigatório concordar com os Termos de Uso, porém, contribuições anônimas ainda podem ser feitas através do app';

  @override
  String get sign_up_page_producer_checkbox => 'Sou um produtor de alimentos';

  @override
  String get sign_up_page_producer_hint => 'Produtor/marca';

  @override
  String get sign_up_page_producer_error_empty =>
      'Por favor, insira um nome de um produtor ou marca';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Gostaria de subscrever o boletim informativo do Open Food Facts (pode cancelar a sua subscrição em qualquer momento)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Este nome já existe; escolha outro.';

  @override
  String get sign_up_page_email_already_exists =>
      'já existe, inicie sessão nessa conta ou tente com outro e-mail.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Por favor, indique um endereço de email válido.';

  @override
  String get sign_up_page_server_busy =>
      'Pedimos desculpa, estamos com algumas dificuldades técnicas para criar a sua conta. Por favor, tente mais tarde.';

  @override
  String get settingsTitle => 'Definições';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Escuro';

  @override
  String get darkmode_light => 'Claro';

  @override
  String get darkmode_system_default => 'Padrão do sistema';

  @override
  String get thanks_for_contributing => 'Obrigado pela sua contribuição!';

  @override
  String get contributors_label => 'Eles estão a desenvolver a aplicação';

  @override
  String get contributors_dialog_title => 'Colaboradores';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Colaborador: $name';
  }

  @override
  String get contributors_description =>
      'Lista de todos os colaboradores desta aplicação';

  @override
  String get support => 'Suporte';

  @override
  String get support_join_slack => 'Peça ajuda no nosso canal Slack';

  @override
  String get support_via_forum => 'Peça ajuda no nosso fórum';

  @override
  String get support_via_email => 'Envie-nos um e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Enviar registos da aplicação?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Quer incluir os registos da aplicação anexados ao seu e-mail?';

  @override
  String get termsOfUse => 'Termos de utilização';

  @override
  String get legalNotices => 'Avisos legais';

  @override
  String get privacy_policy => 'Política de privacidade';

  @override
  String get about_this_app => 'Sobre esta aplicação';

  @override
  String get contribute => 'Contribuir';

  @override
  String get contribute_sw_development => 'Desenvolvimento de software';

  @override
  String get contribute_develop_text =>
      'O código de cada produto Open Food Facts está disponível no GitHub. Pode reutilizar o código (é de fonte aberta) e ajudar-nos a melhorá-lo, para todos, em todo o planeta.';

  @override
  String get contribute_develop_text_2 =>
      'Pode juntar-se à sala de conversação no Slack do Open Food Facts, que é a opção preferida para colocar questões.';

  @override
  String get contribute_develop_dev_mode_title => 'Modo DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Ativar o modo DEV';

  @override
  String get contribute_donate_title => 'Doar';

  @override
  String get contribute_donate_header => 'Fazer um donativo ao Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Informamos que a versão alfa interna permite a perda total de dados e a aplicação pode ficar inutilizável em qualquer altura!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'Produtos a completar';

  @override
  String get contribute_improve_header => 'Melhorar';

  @override
  String get contribute_improve_text =>
      'A base de dados é a parte central do projeto. É muito fácil e rápido colaborar. Pode descarregar a aplicação móvel para o seu telemóvel e começar a adicionar ou a melhorar produtos.\n\nPor outro lado, o website Open Food Facts permite contribuir de várias formas: ';

  @override
  String get contribute_translate_header => 'Traduzir';

  @override
  String get contribute_data_quality => 'Qualidade dos dados';

  @override
  String get contribute_translate_link_text => 'Começar a traduzir';

  @override
  String get contribute_translate_text =>
      'O Open Food Facts é um projeto global, que contém produtos de mais de 160 países. O Open Food Facts está traduzido em dezenas de línguas, com conteúdos em constante evolução.';

  @override
  String get contribute_translate_text_2 =>
      'A tradução é uma das principais tarefas do projeto';

  @override
  String get contribute_join_skill_pool =>
      'Contribua com as suas competências para o Open Food Facts. Junte-se ao conjunto de competências!';

  @override
  String get contribute_share_header =>
      'Partilhe o Open Food Facts com os amigos';

  @override
  String get contribute_share_content =>
      'Queria dar-te a conhecer a aplicação que tenho utilizado, o Open Food Facts, que permite conhecer os impactos dos alimentos na saúde e no ambiente, de forma personalizada. Funciona através da leitura dos códigos de barras das embalagens. É gratuita, não requer registo e pode até ajudar a aumentar o número de produtos decifrados. Aqui está o link para a obter: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribua com preços solicitando uma exportação GDPR dos dados dos seus cartões de fidelidade';

  @override
  String get tap_to_answer => 'Toque aqui para responder a perguntas';

  @override
  String get tap_to_answer_hint =>
      'Toque aqui para responder a perguntas sobre este produto';

  @override
  String get robotoff_questions_loading_hint =>
      'Por favor, aguarde enquanto as perguntas sobre este produto são carregadas';

  @override
  String get saving_answer => 'A guardar a sua resposta';

  @override
  String get contribute_to_get_rewards =>
      'Transforme-se em um ator de transparência alimentar';

  @override
  String get question_sign_in_text =>
      'Entre na sua conta do Open Food Facts para guardar as suas contribuições';

  @override
  String get question_yes_button_accessibility_value => 'Responder sim';

  @override
  String get question_no_button_accessibility_value => 'Responder não';

  @override
  String get question_skip_button_accessibility_value =>
      'Ignorar esta pergunta';

  @override
  String get tap_to_edit_search => 'Toque para editar a pesquisa';

  @override
  String get myPreferences => 'As minhas preferências';

  @override
  String get account_create_message =>
      'Crie a sua conta e junte-se à comunidade Open Food Facts para ajudar a aumentar o conhecimento sobre os alimentos de todo o mundo!';

  @override
  String get join_us => 'Junte-se a nós';

  @override
  String get myPreferences_profile_title => 'O seu perfil';

  @override
  String get myPreferences_profile_subtitle =>
      'Gerir a sua conta como colaborador do Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Configurações da aplicação';

  @override
  String get myPreferences_settings_subtitle => 'Modo escuro, idiomas…';

  @override
  String get myPreferences_food_title => 'Preferências alimentares';

  @override
  String get myPreferences_food_subtitle =>
      'Escolha as informações sobre os alimentos que mais lhe interessam.';

  @override
  String get myPreferences_food_comment =>
      'Escolha as informações sobre alimentos que mais lhe interessam, para classificar os alimentos de acordo com as suas preferências, ver primeiro as informações que lhe interessam e obter um resumo de compatibilidade. Essas preferências alimentares permanecem no seu dispositivo e não estão associadas à sua conta de colaborador do Open Food Facts, caso tenha uma.';

  @override
  String get confirmResetPreferences =>
      'Redefinir suas preferências alimentares?';

  @override
  String get myPersonalizedRanking => 'A minha classificação personalizada';

  @override
  String get ranking_tab_all => 'Todos';

  @override
  String get ranking_subtitle_match_yes => 'Uma ótima combinação para você';

  @override
  String get ranking_subtitle_match_no => 'Correspondência muito baixa';

  @override
  String get ranking_subtitle_match_maybe => 'Combinação desconhecida';

  @override
  String get refresh_with_new_preferences =>
      'Atualizar a lista com as novas preferências';

  @override
  String get reloaded_with_new_preferences =>
      'Recarregado com suas novas preferências';

  @override
  String get profile_navbar_label => 'Comunidade';

  @override
  String get scan_navbar_label => 'Digitalizar';

  @override
  String get history_navbar_label => 'Histórico';

  @override
  String get list_navbar_label => 'Listas';

  @override
  String get category => 'Filtrar por categoria';

  @override
  String get category_all => 'Todos';

  @override
  String get category_search => '(pesquisa de categoria)';

  @override
  String get filter => 'Filtro';

  @override
  String get scan => 'Produtos do ecrã de digitalização';

  @override
  String get scan_history => 'Histórico de digitalização';

  @override
  String get search => 'Procurar';

  @override
  String get search_product_help => 'Search a product,\na brand or a barcode';

  @override
  String get search_filter => 'Filtro de pesquisa';

  @override
  String get search_history => 'Histórico de pesquisa';

  @override
  String get search_store => 'Procurar uma loja';

  @override
  String get search_store_help => 'Dica: adicione a cidade ou o país';

  @override
  String get tap_for_more => 'Toque para mais informação…';

  @override
  String get product => 'Produto';

  @override
  String get unknownBrand => 'Marca desconhecida';

  @override
  String get unknownProductName => 'Nome de produto desconhecido';

  @override
  String get label_refresh => 'Atualizar';

  @override
  String get label_reload => 'Recarregar';

  @override
  String get image => 'Imagem';

  @override
  String get front_photo => 'Foto frontal';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (esta imagem pode estar desatualizada)';
  }

  @override
  String get outdated_image_short_label => 'pode estar desatualizado';

  @override
  String get ingredients => 'Ingredientes';

  @override
  String get ingredients_editing_instructions =>
      'Mantenha a ordem original. Indique a percentagem quando especificado. Separe com vírgula ou hífen e use parênteses para os ingredientes de um ingrediente.';

  @override
  String get ingredients_editing_error => 'Falha ao salvar os ingredientes.';

  @override
  String get ingredients_editing_image_error =>
      'Falha ao obter uma nova imagem de ingredientes.';

  @override
  String get ingredients_editing_title => 'Editar ingredientes';

  @override
  String get ingredients_photo => 'Foto de ingredientes';

  @override
  String get packaging_editing_instructions =>
      'Indique todas as partes da embalagem separadas por uma vírgula ou paragrafo, com a sua quantidade (ex: 1 ou 6), formato (ex: garrafa, caixa, lata), material (ex: plástico, metal, alumínio) e, se disponível, o tamanho (ex: 33 cl) e instruções de reciclagem.\nExemplo: 1 garrafa de vidro para reciclar, 1 rolha de plástico para deitar fora';

  @override
  String get packaging_editing_error => 'Falha ao guardar a embalagem.';

  @override
  String get packaging_editing_image_error =>
      'Falha ao obter uma nova imagem da embalagem.';

  @override
  String get packaging_editing_title => 'Editar embalagem';

  @override
  String get nutrition => 'Nutrição';

  @override
  String get nutrition_facts_photo => 'Foto de informações nutricionais';

  @override
  String get nutrition_facts_editing_title => 'Editar informações nutricionais';

  @override
  String get packaging_information => 'Informação de embalagem';

  @override
  String get packaging_information_photo => 'Foto de informações da embalagem';

  @override
  String get missing_product => 'Você encontrou um novo produto!';

  @override
  String get add_product_take_photos =>
      'Tire fotografias da embalagem para adicionar este produto ao Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Por favor, tire algumas fotografias primeiro. Pode concluir os dados do produto mais tarde.';

  @override
  String get add_product_information_button_label =>
      'Adicione informações sobre o produto';

  @override
  String get new_product => 'Produto Novo';

  @override
  String get new_product_found_title => 'Novo produto encontrado!';

  @override
  String get new_product_found_text =>
      'Este produto ainda não existe na nossa base de dados: ';

  @override
  String get new_product_found_button => 'Adicione este produto';

  @override
  String get new_product_leave_title => 'Sair desta página?';

  @override
  String get new_product_leave_message =>
      'Parece que não introduziu nada. Quer mesmo sair desta página?';

  @override
  String get new_product_dialog_description =>
      'Por favor fotografe a embalagem do produto para o adicionar à nossa base de dados';

  @override
  String get new_product_dialog_illustration_description =>
      'Uma ilustração com Nutri-Score e Green-Score desconhecidos';

  @override
  String get front_packaging_photo_button_label =>
      'Fotografia frontal da embalagem';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirmar envio da fotografia frontal da embalagem';

  @override
  String get confirm_button_label => 'Confirmar';

  @override
  String get send_image_button_label => 'Enviar imagem';

  @override
  String get crop_page_action_saving => 'A guardar a imagem…';

  @override
  String get crop_page_action_cropping => 'A recortar a imagem…';

  @override
  String get crop_page_action_local => 'A guardar uma versão local…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oops... há um problema com a fotografia!';

  @override
  String get crop_page_action_local_failed_message =>
      'Não estamos a conseguir processar a sua imagem antes de a enviar para o nosso servidor. Tente novamente mais tarde ou contacte-nos se o problema persistir.';

  @override
  String get crop_page_action_retake => 'Tornar a fotografar';

  @override
  String get crop_page_too_small_image_title => 'A imagem é muito pequena!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Para carregar imagens o tamanho mínimo em píxeis é ${expectedMinWidth}x$expectedMinHeight. A imagem selecionada tem ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server =>
      'A preparar um telefonema para o servidor…';

  @override
  String get front_packaging_photo_title => 'Foto frontal da embalagem';

  @override
  String get ingredients_photo_title => 'Fotografia dos ingredientes';

  @override
  String get nutritional_facts_photo_title =>
      'Fotografia das informações nutricionais';

  @override
  String get recycling_photo_title => 'Fotografia de reciclagem';

  @override
  String get take_photo_title => 'Tirar uma foto';

  @override
  String get take_more_photo_title => 'Tirar mais fotografias';

  @override
  String get front_photo_uploaded => 'Fotografia inicial enviada';

  @override
  String get ingredients_photo_button_label => 'Foto de ingredientes';

  @override
  String get ingredients_photo_uploaded => 'Foto dos ingredientes enviada';

  @override
  String get nutrition_cache_loading_error =>
      'Não é possível carregar nutrientes do cache';

  @override
  String get nutritional_facts_photo_button_label =>
      'Foto de informações nutricionais';

  @override
  String get nutritional_facts_input_button_label =>
      'Preencher informações nutricionais';

  @override
  String get nutritional_facts_added => 'Informações nutricionais adicionadas';

  @override
  String get categories_added => 'Categorias adicionadas';

  @override
  String get new_product_title_nutriscore => 'Calcular o Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Ajude-nos preenchendo pelo menos uma categoria e valores nutricionais';

  @override
  String get new_product_title_environmental_score => 'Calcular o Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Obtenha-o preenchendo pelo menos uma categoria';

  @override
  String get new_product_additional_environmental_score =>
      'Torne o cálculo do Green-Score mais exato com a indicação da origem, embalagem e outras informações';

  @override
  String get new_product_title_nova =>
      'Calcular o nível de processamento de alimentos (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Obtenha-o preenchendo a categoria do alimento e os ingredientes';

  @override
  String get new_product_desc_nova_unknown =>
      'Nível desconhecido de processamento do alimento';

  @override
  String get new_product_title_pictures => 'Novo produto';

  @override
  String get new_product_title_pictures_details =>
      'Tire as seguintes fotografias e o motor Open Food Facts resolverá o resto!';

  @override
  String get new_product_title_misc => 'E alguns dados básicos…';

  @override
  String new_product_done_msg(String username) {
    return 'Obrigado pela sua contribuição “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Obrigado pela sua contribuição!';

  @override
  String get new_product_done_button_label => 'Descubra o produto completo';

  @override
  String get hey_incomplete_product_message =>
      'Toque para responder a 3 perguntas AGORA para calcular o Nutri-Score, o Green-Score e o ultra-processamento (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Clique agora para responder a 2 perguntas para ajudar a analisar este cosmético!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Toque agora para responder a 3 perguntas para ajudar a analisar este produto de alimentação para animais de estimação!';

  @override
  String get hey_incomplete_product_message_product =>
      'Clique agora para ajudar a completar este produto!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto das informações nutricionais enviada';

  @override
  String get recycling_photo_button_label =>
      'Fotografia de informações sobre a reciclagem';

  @override
  String get recycling_photo_uploaded =>
      'Fotografia sobre a reciclagem enviada';

  @override
  String get take_more_photo_button_label => 'Tirar mais fotografias';

  @override
  String get other_photo_uploaded => 'Fotografia diversa enviada';

  @override
  String get retake_photo_button_label => 'Tirar novamente';

  @override
  String get selecting_photo => 'Selecionar fotografia';

  @override
  String get uploading_image => 'A enviar a fotografia para o servidor';

  @override
  String get uploading_image_type_front =>
      'A enviar a imagem frontal para o Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'A enviar a imagem dos ingredientes para o Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'A enviar a imagem das informações nutricionais para o Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'A enviar a imagem da embalagem para o Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'A enviar outra imagem para o Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'A enviar imagem para o Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Adicionar ingredientes que faltam';

  @override
  String get score_add_missing_packaging_image =>
      'Adicionar imagem de embalagem que falta';

  @override
  String get score_add_missing_nutrition_facts =>
      'Adicionar informações nutricionais que faltam';

  @override
  String get score_add_missing_product_traces =>
      'Adicionar traços ausentes de produtos';

  @override
  String get score_add_missing_product_category => 'Selecionar uma categoria';

  @override
  String get score_add_missing_precise_product_category =>
      'Selecione uma categoria mais precisa';

  @override
  String get score_add_missing_product_countries =>
      'Adicionar países que faltam de produtos';

  @override
  String get score_add_missing_product_emb =>
      'Adicionar códigos de rastreabilidade que faltam de produtos';

  @override
  String get score_add_missing_product_labels =>
      'Adicionar rótulos que faltam de produtos';

  @override
  String get score_add_missing_product_origins =>
      'Adicionar origens que faltam de produtos';

  @override
  String get score_add_missing_product_stores =>
      'Adicionar lojas que faltam de produtos';

  @override
  String get score_add_missing_product_brands =>
      'Adicionar marcas que faltam de produtos';

  @override
  String get score_update_nutrition_facts => 'Atualizar dados nutricionais';

  @override
  String get nutrition_page_title => 'Informações nutricionais';

  @override
  String get nutrition_page_nutritional_info_title => 'Informação nutricional';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Valores especificados no produto:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Sim';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Não';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Abrir fotografia';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Boas práticas: Informação nutricional';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Às vezes, informações nutricionais **não são especificadas na embalagem** ou em um documento de determinado produto. Nesse caso, e apenas nele, você pode definir o valor para **NÃO**.';

  @override
  String get nutrition_page_serving_type_label => 'Valores nutricionais:';

  @override
  String get nutrition_page_per_100g => 'por 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'por 100g/ml';

  @override
  String get nutrition_page_per_serving => 'por porção';

  @override
  String get nutrition_page_add_nutrient => 'Adicionar um nutriente';

  @override
  String get nutrition_page_serving_size => 'Tamanho da porção';

  @override
  String get nutrition_page_serving_size_hint =>
      'Insira o tamanho da porção (por exemplo: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Boas práticas: Tamanho da porção';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Este valor ajuda a **fazer um cálculo proporcional de cada nutriente por porção**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Unidade permitidas** são: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** ou **60 G** (preferencialmente o primeiro)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** ou **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unidade inválida';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unidades inválidas';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **doces** e 2 **biscoitos**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unidade em falta';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Número inválido';

  @override
  String get nutrition_page_update_running =>
      'A atualizar o produto no servidor…';

  @override
  String get nutrition_page_update_done => 'Produto atualizado!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Utilizar a quantidade do produto como tamanho da dose';

  @override
  String get nutrition_page_photo_error =>
      'Não foi possível carregar a fotografia';

  @override
  String get more_photos => 'Mais fotografias interessantes';

  @override
  String get view_more_photo_button =>
      'Veja todas as fotos existentes para este produto';

  @override
  String get no_product_found => 'Não foi encontrado nenhum produto';

  @override
  String get no_location_found => 'Nenhuma localização encontrada';

  @override
  String get not_found => 'não encontrado:';

  @override
  String get refreshing_product => 'A atualizar o produto';

  @override
  String get product_refreshed => 'Produto atualizado';

  @override
  String product_image_accessibility_label(String date) {
    return 'Imagem tirada em $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Imagem tirada em $date. Esta imagem pode estar desatualizada';
  }

  @override
  String get product_image_outdated => 'Esta imagem pode estar desatualizada';

  @override
  String get product_image_outdated_explanations_title =>
      'Esta imagem pode estar desatualizada';

  @override
  String get product_image_outdated_explanations_content =>
      'Esta imagem foi tirada há mais de um ano.\n**Verifique se ainda está atualizada**.\n\nIsto é **apenas um aviso**. Se o conteúdo continuar a ser o mesmo, pode ignorar esta mensagem.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Substituir foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Adicionar uma fotografia ($type)';
  }

  @override
  String get product_image_action_take_new_picture =>
      'Tirar uma nova fotografia';

  @override
  String get product_image_action_take_picture => 'Tirar uma foto';

  @override
  String get product_image_action_from_gallery =>
      'Selecionar a partir da biblioteca do seu telemóvel';

  @override
  String get product_image_action_choose_existing_photo =>
      'Selecionar entre as fotografias do produto';

  @override
  String get product_image_details_label => 'Informação sobre a fotografia';

  @override
  String get product_image_details_from_producer => 'Do produtor';

  @override
  String get product_image_details_contributor => 'Colaborador';

  @override
  String get product_image_details_contributor_producer =>
      'Colaborador (produtor)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Desconhecido';

  @override
  String get homepage_main_card_logo_description =>
      'Bem-vindo ao Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Digitalize** um código de barras ou\n**pesquise** por um produto';

  @override
  String get homepage_main_card_search_field_hint => 'Procurar por um produto';

  @override
  String get homepage_main_card_search_field_tooltip => 'Iniciar pesquisa';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Últimas notícias: $news_title';
  }

  @override
  String get tagline_app_review => 'Gosta da aplicação?';

  @override
  String get tagline_app_review_button_positive => 'Adoro! 😍';

  @override
  String get tagline_app_review_button_negative => 'Nem por isso…';

  @override
  String get tagline_app_review_button_later => 'Perguntar depois';

  @override
  String get tagline_feed_news_button => 'Saber mais';

  @override
  String get app_review_negative_modal_title => 'Não gosta da nossa aplicação?';

  @override
  String get app_review_negative_modal_text =>
      'Pode tirar uns segundos e dizer-nos o porquê por favor?';

  @override
  String get app_review_negative_modal_positive_button => 'Sim, absolutamente!';

  @override
  String get app_review_negative_modal_negative_button => 'Não';

  @override
  String get could_not_refresh => 'Não foi possível atualizar o produto';

  @override
  String get product_internet_error_modal_title => 'Ocorreu um erro!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Não foi possível obter informações sobre este produto devido a um erro de rede. Verifique a sua ligação à Internet e tente novamente.\n\nErro interno:\n$error';
  }

  @override
  String get product_tags_title => 'Propriedades do produto';

  @override
  String get no_product_tags_found_message =>
      'Não foram encontradas propriedades de produtos. As propriedades podem ser utilizadas para descrever os produtos com mais pormenores, de uma forma flexível.';

  @override
  String get product_tags_empty => 'Nenhuma propriedade';

  @override
  String get product_tags_explanation =>
      'Ao adicionar propriedades (chave/valor) a um produto, você ajuda a enriquecê-lo.';

  @override
  String get add_tag => 'Adicionar uma propriedade';

  @override
  String get add_tags => 'Adicionar propriedades';

  @override
  String get add_edit_tags => 'Adicionar ou editar propriedades';

  @override
  String get edit_tag => 'Editar propriedade';

  @override
  String get remove_tag => 'Remover propriedade';

  @override
  String get tag_key => 'Propriedade';

  @override
  String get tag_keys => 'Propriedades';

  @override
  String get tag_key_uneditable => 'Propriedade (não editável)';

  @override
  String get tag_key_input_hint => 'Introduza uma propriedade';

  @override
  String get tag_value => 'Valor';

  @override
  String get tag_values => 'Valores';

  @override
  String get tag_value_input_hint => 'Introduza um valor';

  @override
  String get tag_key_item => 'Propriedade:';

  @override
  String get tag_value_item => 'Valor:';

  @override
  String get tag_key_explanations =>
      'Uma chave tem de estar minúsculas e sem espaços.';

  @override
  String tag_key_already_exists(String property) {
    return 'Já existe uma etiqueta com a propriedade $property!';
  }

  @override
  String get product_internet_error =>
      'Não foi possível obter informações sobre este produto devido a um erro de rede.';

  @override
  String get cached_results_from => 'Mostrar resultados de:';

  @override
  String get product_search_same_category => 'Encontre alternativas';

  @override
  String get product_search_same_category_short => 'Comparar';

  @override
  String get product_search_same_category_error =>
      'Esta funcionalidade só pode ser utilizada para produtos com uma categoria.\n\nPor favor, edite o produto para adicionar uma categoria.';

  @override
  String get product_improvement_add_category =>
      'Adicione uma categoria para calcular o Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Adicione as informações nutricionais para calcular o Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Adicione as informações nutricionais e uma categoria para calcular o Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'O Nutri-Score para este produto não pode ser calculado, o que pode ser devido, por exemplo, a uma categoria fora do normal. Se isso for considerado um erro, contacte-nos.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'A imagem nutricional está obsoleta: atualize-a.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'O Green-Score leva em consideração a origem dos ingredientes. Tire uma fotografia da lista de ingredientes e/ou qualquer reivindicação geográfica ou edite o produto, para que possam ser levados em consideração.';

  @override
  String get country_chooser_label => 'Escolha um país';

  @override
  String get currency_chooser_label => 'Por favor selecione uma moeda';

  @override
  String get country_change_message => 'Acabou de mudar de país.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Quer alterar a moeda de $previousCurrency para $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Escolha um país:';

  @override
  String get country_chooser_label_from_settings => 'O seu país';

  @override
  String get country_selection_explanation =>
      'Algumas características ambientais dependem do local';

  @override
  String get product_removed_comparison => 'Produto removido da comparação';

  @override
  String get native_app_settings => 'Configurações nativas da aplicação';

  @override
  String get native_app_description =>
      'Abrir configurações do sistema do Open Food Facts';

  @override
  String get product_removed_history => 'Produto removido do histórico';

  @override
  String get product_removed_list => 'Produto removido da lista';

  @override
  String get product_could_not_remove => 'Não foi possível remover o produto';

  @override
  String get no_prodcut_in_list => 'Não há nenhum produto nesta lista';

  @override
  String get no_product_in_section => 'Não há nenhum produto nesta lista';

  @override
  String get recently_seen_products => 'Todos os produtos visualizados';

  @override
  String get clear => 'Limpar';

  @override
  String get clear_long => 'Esvaziar a lista';

  @override
  String get really_clear => 'Quer mesmo eliminar esta lista?';

  @override
  String pct_match(Object percent) {
    return '$percent% de correspondência';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count dias',
      one: 'há um dia',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count horas',
      one: 'há uma hora',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count minutos',
      one: 'há um minuto',
      zero: 'há menos de um minuto',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count meses',
      one: 'há um mês',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'há $count semanas',
      one: 'há uma semana',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Comparar $count produtos',
      one: 'Comparar um produto',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos selecionados',
      one: 'Um produto selecionado',
      zero: 'Nenhum produto selecionado',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Comparar produtos selecionados';

  @override
  String get delete_products_mode => 'Apagar produtos selecionados';

  @override
  String get select_all_products_mode => 'Selecionar todos os produtos';

  @override
  String get select_none_products_mode => 'Desselecionar';

  @override
  String get compare_products_appbar_title => 'Comparar produtos';

  @override
  String get compare_products_appbar_subtitle =>
      'Selecione pelo menos dois produtos';

  @override
  String get retry_button_label => 'Repetir';

  @override
  String get connect_with_us => 'Ligue-se a nós';

  @override
  String get tiktok => 'Siga-nos no TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Siga-nos no Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Siga-nos no X (antigo Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Siga-nos no Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Siga-nos no BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogue';

  @override
  String get faq => 'Perguntas frequentes';

  @override
  String get discover => 'Descobrir';

  @override
  String get how_to_contribute => 'Como contribuir';

  @override
  String get hint_knowledge_panel_message =>
      'Pode tocar em qualquer parte do cartão para obter mais detalhes sobre o que vê. Tente agora!';

  @override
  String get permissions_page_title => 'Acesso à câmara';

  @override
  String get permissions_page_body1 =>
      'Para digitalizar códigos de barras com a câmara do telemóvel, por favor conceda o acesso.';

  @override
  String get permissions_page_body2 =>
      'Se mudar de ideias, esta opção pode ser ativada e desativada a qualquer momento nas configurações.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'SO: Android (SDK Int: $sdkInt / lançamento: $release)\nModelo: $model\nProduto: $product\nDispositivo: $device\nMarca: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'SO: iOS ($version)\nModelo: $model\nModelo localizado: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersão da aplicação: $appVersion\nNúmero de compilação da aplicação: $appBuildNumber\nNome do pacote da aplicação: $appPackageName';
  }

  @override
  String get authorize_button_label => 'Autorizar';

  @override
  String get refuse_button_label => 'Recusar';

  @override
  String get ask_me_later_button_label => 'Lembrar-me depois';

  @override
  String get are_you_sure => 'Tem a certeza?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Mais informação em $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Bem-vindo!';

  @override
  String get onboarding_home_welcome_text2 =>
      'A aplicação que ajuda a escolher alimentos que são bons para **si** e para o **planeta**!';

  @override
  String get onboarding_continue_button => 'Continuar';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'A carregar o seu primeiro exemplo de produto';

  @override
  String get onboarding_welcome_warning =>
      'Desculpe, este é um produto de exemplo, você não pode editá-lo :)';

  @override
  String get product_list_your_ranking => 'A sua classificação';

  @override
  String get product_list_empty_icon_desc => 'Histórico indisponível';

  @override
  String get product_list_empty_title => 'Iniciar a digitalização';

  @override
  String get product_list_empty_message =>
      'Os produtos digitalizados aparecerão aqui e poderá ver informações detalhadas sobre eles';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produtos',
      one: 'produto',
      zero: 'produto',
    );
    return 'A atualizar $_temp0 no seu histórico';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produtos',
      one: 'produto',
      zero: 'produto',
    );
    return 'Atualização de $_temp0 terminada';
  }

  @override
  String get loading_dialog_default_title => 'A descarregar os dados';

  @override
  String get loading_dialog_default_error_message =>
      'Não foi possível descarregar os dados';

  @override
  String get account_delete => 'Eliminar a conta';

  @override
  String get account_delete_title => 'Excluir minha conta';

  @override
  String get user_profile => 'Conta';

  @override
  String get user_profile_title_guest => 'Bem-vindo!';

  @override
  String get user_profile_subtitle_guest =>
      'Inicie a sessão ou registe-se para se juntar à comunidade do Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Iniciar sessão no Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Bem-vindo(a) $id!';
  }

  @override
  String get email_subject_account_deletion => 'Eliminar a conta';

  @override
  String email_body_account_deletion(String userId) {
    return 'Olá, por favor elimine a minha conta no Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplicação';

  @override
  String get settings_app_data => 'Funcionalidades e monitorização de falhas';

  @override
  String get settings_app_camera => 'Câmara';

  @override
  String get settings_app_products => 'Produtos';

  @override
  String get settings_app_miscellaneous => 'Diversos';

  @override
  String get camera_play_sound_title =>
      'Reproduzir um som durante a digitalização';

  @override
  String get camera_play_sound_subtitle =>
      'Irá emitir um sinal sonoro em cada digitalização bem sucedida';

  @override
  String get camera_window_accessibility_label =>
      'Digitalize um código de barras com a sua câmara';

  @override
  String get app_haptic_feedback_title => 'Vibração e resposta tátil';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrações após a execução de algumas ações (código de barras descodificado, produto removido…).';

  @override
  String get crash_reporting_toggle_title => 'Reporte-nos erros e falhas';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Quando ativado, os relatórios de falhas são automaticamente enviados para o sistema de rastreio de erros do Open Food Facts, para que os erros possam ser corrigidos e assim melhorar a aplicação.';

  @override
  String get send_anonymous_data_toggle_title =>
      'Reporte-nos a utilização das funcionalidades';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Quando ativado, serão enviadas informações estritamente anónimas relativas à utilização das funcionalidades para os servidores do Open Food Facts, para que possamos compreender como são utilizadas as funcionalidades, por forma a melhorá-las. Caso contrário, será enviado um ID 0.';

  @override
  String get product_edit_photo_title => 'Editar foto';

  @override
  String get permission_photo_error => 'Erro';

  @override
  String get permission_photo_denied_title =>
      'Permitir o uso da câmara para digitalizar códigos de barras';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Para uma melhor experiência, conceda a permissão ao $appName de acesso à sua câmara. Poderá digitalizar códigos de barras diretamente.';
  }

  @override
  String get permission_photo_denied_button => 'Permitir';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Permissão negada';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Como anteriormente negou a permissão da câmara, tem de conseder a permissão manualmente nas Configurações.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Abrir configurações';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Cancelar';

  @override
  String get permission_photo_none_found => 'Nenhuma câmara detetada';

  @override
  String get permission_photo_denied => 'Não foi concedido acesso à câmara';

  @override
  String get show_product_pictures => 'Mostrar fotos do produto';

  @override
  String get edit_product_label => 'Editar produto';

  @override
  String get edit_product_pending_operations_banner_title =>
      'A enviar as suas edições…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'As suas edições estão a ser **enviadas em segundo plano** (ou mais tarde em caso de erro).\nPode continuar a editar outros campos do produto.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Suas edições estão **sendo feitas em segundo plano** (ou mais tarde, em caso de erro).';

  @override
  String get edit_product_label_short => 'Editar';

  @override
  String edit_product_form_item_help(String value) {
    return 'Como inserir \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Por favor, insira um valor não vazio!';

  @override
  String get edit_product_form_item_error_existing => 'Esse valor já está aí!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Adicionar uma nova marca';

  @override
  String get edit_product_form_item_add_action_label =>
      'Adicionar uma nova etiqueta';

  @override
  String get edit_product_form_item_add_action_store =>
      'Adicionar uma nova loja';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Adicionar uma nova origem';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Adicionar um novo código de rastreabilidade';

  @override
  String get edit_product_form_item_add_action_country =>
      'Adicionar um novo país';

  @override
  String get edit_product_form_item_add_action_category =>
      'Adicionar uma nova categoria';

  @override
  String get edit_product_form_item_add_action_trace => 'Adicionar novo traço';

  @override
  String get edit_product_form_item_add_suggestion => 'Dê uma sugestão';

  @override
  String get edit_product_form_item_deny_suggestion => 'Negar sugestão';

  @override
  String get edit_product_form_item_details_title => 'Detalhes básicos';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nome do produto, marca, quantidade';

  @override
  String get edit_product_form_item_other_details_title =>
      'Detalhes adicionais';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Site…';

  @override
  String get edit_product_form_item_photos_title => 'Fotografias';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Adicionar ou atualizar fotografias';

  @override
  String get edit_product_form_item_labels_title => 'Etiquetas e certificações';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Selos ambientais, de qualidade…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Introduza uma etiqueta (por exemplo: Nutri-Score)';

  @override
  String get edit_product_form_item_labels_type => 'rótulo';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Boas práticas: Rótulos';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Qualquer característica do produto **que seja verdadeira** e diferente dos outros campos.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Feito na Bélgica, Produzido na Bretanha…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rico em fibras, fonte de ferro…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Troca justa, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Lojas';

  @override
  String get edit_product_form_item_stores_hint => 'Introduza uma loja';

  @override
  String get edit_product_form_item_stores_type => 'loja';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Boas práticas: Lojas';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Insira loja em que você comprou o produto.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Origens';

  @override
  String get edit_product_form_item_origins_hint =>
      'Insira uma origem (por exemplo: Carne bovina da Argentina)';

  @override
  String get edit_product_form_item_origins_type => 'país';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Boas práticas: Origem';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Adicione **qualquer indicação de origem que conseguir encontrar na embalagem**.\nDesconsidere as origens indicadas diretamente na lista de ingredientes.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Carne da Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'A soja não vem da União Europeia';

  @override
  String get edit_product_form_item_countries_title => 'País';

  @override
  String get edit_product_form_item_countries_hint =>
      'Introduza um país (por exemplo: Portugal)';

  @override
  String get edit_product_form_item_countries_type => 'país';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Boas práticas: Países';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Países em que os produtos são abundantes** (exceto lojas especializada em produtos importados).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Códigos de rastreabilidade';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Introduza um código (por exemplo: PT DLT 1 CE, EMB 53062, FR 62.448.034 CE…)';

  @override
  String get edit_product_form_item_emb_codes_type =>
      'código de rastreabilidade';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Boas práticas: Códigos de rastreio';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Nesta seção, você consegue inserir códigos relacionados a **marcas de embalagem**, **marcas de identificação** ou **marcas de saúde**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Exemplos de códigos de rastreio';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Códigos EC** usados na Comunidade Europeia para identificar produtores ou embaladores de alimentos:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: código de país da **França**\n**72.264.002**: dados geográficos\n**CE**: Comunidade Europeia';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Códigos EMB** usados na França:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Vestígios';

  @override
  String get edit_product_form_item_traces_hint => 'vestígio';

  @override
  String get edit_product_form_item_traces_type =>
      'Insira um traço (ex.: Soja)';

  @override
  String get edit_product_form_item_categories_title => 'Categorias';

  @override
  String get edit_product_form_item_categories_hint => 'categoria';

  @override
  String get edit_product_form_item_categories_type =>
      'Introduza uma categoria (por exemplo: Refrigerante de laranja)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Boas práticas: Categorias';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicar apenas a categoria mais específica.\nAs categorias principais serão adicionadas automaticamente.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Ausência de categoria?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'No caso de ausência de preenchimento automático de alguma categoria, pode adicioná-la mesmo assim.\nEstará nos ajudando a melhorar o OpenFoodFacts no seu país.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardinhas ao óleo';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Suco de laranja concentrado';

  @override
  String get edit_product_form_item_exit_title => 'Sair sem guardar?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Quer guardar as alterações antes de deixar esta página?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Guardar alterações';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Descartar alterações';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredientes';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Amplie ou reduza apertando ou afastando 2 dedos no ecrã';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Amplie e reduza a fotografia';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Utilizando o gesto **Pinch-to-zoom**, pode ampliar ou reduzir a fotografia:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Adicione';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Introduzir primeiro um texto';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Eliminar';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Guarde a sua edição';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancele a sua edição';

  @override
  String get edit_product_form_item_packaging_title =>
      'Fotografia das instruções de reciclagem';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Dados nutricionais';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Informações nutricionais, conteúdo alcoólico…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Boas práticas: Informação nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Valores nutricionais';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Primeiro, selecione se os valores são fornecidos:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Dados nutricionais';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Depois, insira os valores nutricionais conforme indicado na embalagem. Se não houver valor, clique no ícone do olho.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Campos em falta?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Se algum campo estiver em falta, você pode clicar no ícone de \"mais\" para adicioná-lo (ex: vitamina D, magnésio...).';

  @override
  String get edit_product_form_save => 'Editar';

  @override
  String get edit_product_ingredients_photo_title => 'Foto de ingredientes';

  @override
  String get edit_product_ingredients_list_title => 'Lista de ingredientes';

  @override
  String get edit_product_packaging_photo_title => 'Foto da embalagem';

  @override
  String get edit_product_packaging_list_title => 'Lista de embalagens';

  @override
  String get no_data_available => 'Sem dados disponíveis';

  @override
  String get product_field_website_title => 'Site';

  @override
  String get origins_editing_title => 'Editar origens';

  @override
  String get completed_basic_details_btn_text => 'Detalhes básicos completos';

  @override
  String get not_implemented_snackbar_text => 'Ainda não implementado';

  @override
  String get category_picker_page_appbar_text => 'Categorias';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extrair os ingredientes da fotografia';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extrair ingredientes';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extrair os ingredientes\nda fotografia';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'A carregar a fotografia…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Porque é que vejo esta mensagem?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Para utilizar a funcionalidade \"Extrair ingredientes\", a fotografia tem de ser enviada primeiro.\n\nAguarde alguns segundos ou introduza-os manualmente.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Atualizar fotografia';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extrair os ingredientes\nda fotografia';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extrair embalagem';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extrair os ingredientes da fotografia';

  @override
  String get edit_packaging_loading_photo_btn_text =>
      'A carregar a fotografia…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Porque é que vejo esta mensagem?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Para utilizar a funcionalidade \"Extrair embalagem\", a fotografia tem de ser enviada primeiro.\n\nAguarde alguns segundos ou introduza-os manualmente.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Atualizar fotografia';

  @override
  String get edit_ocr_extract_failed => 'Falha ao detetar texto na imagem.';

  @override
  String get edit_ocr_extract_disabled_title => 'Nenhuma imagem!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Para usar o recurso de extração de texto, primeiro tem de tirar uma foto.';

  @override
  String get user_list_dialog_new_title => 'Nova lista de produtos';

  @override
  String get user_list_dialog_rename_title => 'Alterar nome da lista';

  @override
  String get user_list_subtitle_product => 'Listas';

  @override
  String get user_list_title => 'Suas listas';

  @override
  String get user_list_add_product => 'Adicione o produto às suas listas';

  @override
  String get user_list_button_new => 'Criar uma nova lista';

  @override
  String get user_list_empty_label =>
      'Ainda não existe nenhuma lista disponível!\nPor favor, comece por criar uma.';

  @override
  String get user_list_button_add_product => 'Adicionar à lista';

  @override
  String get added_to_list_msg => 'Adicionado à lista';

  @override
  String get user_list_popup_clear => 'Limpar histórico';

  @override
  String get user_list_popup_rename => 'Alterar nome';

  @override
  String get user_list_name_hint => 'A minha lista';

  @override
  String get user_list_name_error_empty => 'O nome é obrigatório';

  @override
  String get user_list_name_error_already => 'Esse nome já está a ser usado';

  @override
  String get user_list_name_error_same => 'É o mesmo nome';

  @override
  String get user_list_name_input_hint => 'Nome da lista';

  @override
  String get try_again => 'Tentar novamente';

  @override
  String get there_was_an_error => 'Ocorreu um erro';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nenhuma categoria encontrada para $items';
  }

  @override
  String get camera_toggle_camera =>
      'Alternar entre as câmaras traseira e frontal';

  @override
  String get camera_toggle_flash => 'Ligar ou desligar o flash da câmara';

  @override
  String get camera_enable_flash => 'Ligar flash';

  @override
  String get camera_disable_flash => 'Desligar flash';

  @override
  String get camera_flash_error_dialog_title => 'Ocorreu um erro!';

  @override
  String get camera_flash_error_dialog_message =>
      'Ocorreu um erro ao alterar o estado do seu flash. Certifique-se de que o seu telemóvel não tem a lanterna ligada.';

  @override
  String get category_picker_no_category_found_button => 'Voltar';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Clique para abrir no seu navegador ou na aplicação (se instalada)';

  @override
  String get dev_preferences_screen_title => 'Modo programador';

  @override
  String get dev_preferences_screen_subtitle =>
      'Acesse recursos experimentais e ferramentas de desenvolvimento';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Relançar experiência de boas-vindas';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Depois, tem de reiniciar a aplicação para a ver novamente.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Alternar entre openfoodfacts.org (PROD) e ambiente de teste';

  @override
  String get dev_preferences_test_environment_title =>
      'Parâmetros do ambiente de teste';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL base para o ambiente de teste atual: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Hospedeiro do ambiente de teste';

  @override
  String get dev_preferences_ml_kit_title => 'Usar kit de ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'então terá que reiniciar esta aplicação';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Botão adicional na página do produto';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Editar ingredientes através de um botão do painel de conhecimento';

  @override
  String get dev_preferences_export_history_title => 'Exportar histórico';

  @override
  String get dev_preferences_export_history_progress_error => 'exceção';

  @override
  String get dev_preferences_export_history_progress_found =>
      'produto encontrado';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produto NÃO encontrado';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Exportar histórico';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Cancelar';

  @override
  String get dev_preferences_migration_title => 'Migração de dados da V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Estado: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'sucesso ou nova instalação';

  @override
  String get dev_preferences_migration_status_success => 'sucesso';

  @override
  String get dev_preferences_migration_status_error => 'erro';

  @override
  String get dev_preferences_migration_status_in_progress => 'a decorrer';

  @override
  String get dev_preferences_migration_status_required =>
      'necessário (clique para começar)';

  @override
  String get dev_preferences_migration_status_not_started => 'desconhecido';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Irá limpar o histórico e colocar 3 produtos nele';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL personalizado para notícias';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL do ficheiro JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Não definido';

  @override
  String get dev_preferences_news_provider_status_title => 'Estado';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Última atualização: $date';
  }

  @override
  String get product_type_label_food => 'Alimentação';

  @override
  String get product_type_label_beauty => 'Cuidados pessoais';

  @override
  String get product_type_label_pet_food => 'Alimentos de pets';

  @override
  String get product_type_label_product => 'Outros';

  @override
  String get product_type_selection_title => 'Tipo do produto';

  @override
  String get product_type_selection_subtitle =>
      'Selecione o tipo deste produto';

  @override
  String get product_type_selection_empty =>
      'Deve primeiro selecionar um tipo de produto!';

  @override
  String product_type_selection_already(String productType) {
    return 'Não pode mudar o tipo de produto ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Atalho para a aplicação Preços na página do produto';

  @override
  String get prices_app_button => 'Ir para a aplicação Preços';

  @override
  String get prices_website_button => 'Aberto no site Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Adicionar etiquetas de preço diretamente da galeria';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Depois de selecionar as imagens, você não poderá editá-las!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'Usaremos IA em suas provas para extrair preços.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Permitir que a comunidade valide os preços extraídos pela IA.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Várias etiquetas de preço';

  @override
  String get prices_bulk_proof_upload_title => 'Envio de provas em massa';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Selecionando arquivos';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Iniciando o upload';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copiando localmente o arquivo #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Preparando upload #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Falha na imagem #$index/$count';
  }

  @override
  String get prices_generic_title => 'Preços';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adicionar $count preços',
      one: 'Adicionar um preço',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Enviar $count preços',
      one: 'Enviar o preço',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Adicionar um item';

  @override
  String get prices_add_a_price => 'Adicionar um preço';

  @override
  String get prices_add_a_receipt => 'Adicionar um recibo';

  @override
  String get prices_add_price_tags => 'Adicionar etiquetas de preço';

  @override
  String prices_barcode_already(String barcode) {
    return 'Este código de barras ($barcode) já está na lista!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produto não encontrado';

  @override
  String get prices_barcode_search_none_yet => 'Ainda sem produtos';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'A procurar $barcode';
  }

  @override
  String get prices_barcode_enter => 'Digite o código de barras';

  @override
  String get prices_category_enter => 'Item sem código de barras';

  @override
  String get prices_per_kilogram => 'Preço por quilograma';

  @override
  String get prices_per_unit => 'Valor por unidade';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unidade';

  @override
  String get prices_category_mandatory => 'Obrigatório';

  @override
  String get prices_category_optional => 'Opcional';

  @override
  String get prices_category_error_mandatory => 'A categoria é obrigatória';

  @override
  String get prices_barcode_reader_action => 'Leitor de código de barras';

  @override
  String get prices_view_prices => 'Ver os preços';

  @override
  String get prices_list_title => 'Lista de preços';

  @override
  String get prices_list_count => 'Número de preços\n';

  @override
  String get prices_list_add_new_price => 'Adicione um novo preço\n';

  @override
  String get prices_list_empty_title => 'Ainda não há preço!';

  @override
  String get prices_list_empty_subtitle =>
      'Seja o primeiro a adicionar um:\nEscaneando um **recibo** ou uma **etiqueta de preço**!';

  @override
  String get prices_entry_shop_not_found => 'Loja desconhecida';

  @override
  String prices_entry_menu_title(String user) {
    return 'Entrada de preço a partir de \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Ver todos os preços deste produto';

  @override
  String get prices_entry_menu_open_proof => 'Ver prova';

  @override
  String get prices_entry_menu_my_prices => 'Veja meus outros preços';

  @override
  String get prices_entry_menu_author_prices => 'Ver outros preços do autor';

  @override
  String get prices_entry_menu_shop_prices => 'Veja outros preços da loja';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count preços',
      one: '1 preço',
    );
    return '$_temp0 de $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Todos os $count preços',
      one: 'Apenas um preço',
      zero: 'Ainda sem preço',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Últimos $pageSize preços (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Preço: $price / Loja: \"$location\" / Publicado em $date por \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Abrir comprovativos de \"$user\"';
  }

  @override
  String get prices_open_proof => 'Abrir comprovativos dos preços';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Todos os $count comprovativos',
      one: 'Apenas um comprovativo',
      zero: 'Ainda sem comprovativos',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Últimos $pageSize comprovativos (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'Nenhum colaborador ainda!';

  @override
  String get prices_users_empty_explanation =>
      'Seja o primeiro a adicionar um preço!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Principais $pageSize contribuidores (total: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Nenhuma loja ainda!';

  @override
  String get prices_locations_empty_explanation =>
      'Seja o primeiro a adicionar um preço!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Principais $pageSize localizações (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count comprovativos',
      one: 'Um comprovativo',
      zero: 'Nenhum comprovativo',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos',
      one: 'Um produto',
      zero: 'Nenhum produto',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count utilizadores',
      one: 'Um utilizador',
      zero: 'Nenhum utilizador',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count preços',
      one: 'Um preço',
      zero: 'Sem preço',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle =>
      'Preço adicionado anteriormente';

  @override
  String get prices_amount_subtitle => 'Montante';

  @override
  String get prices_amount_is_discounted => 'Está com desconto?';

  @override
  String get prices_amount_price_normal => 'Preço';

  @override
  String get prices_amount_price_discounted => 'Preço descontado';

  @override
  String get prices_amount_price_not_discounted => 'Preço original';

  @override
  String get prices_amount_no_product => 'Falta um produto!';

  @override
  String get prices_amount_price_incorrect => 'Valor incorreto';

  @override
  String get prices_amount_price_mandatory => 'Valor obrigatório';

  @override
  String get prices_currency_subtitle => 'Moeda';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Loja';

  @override
  String get prices_location_find => 'Encontrar uma loja';

  @override
  String get prices_location_mandatory => 'Tem de selecionar uma loja!';

  @override
  String get prices_location_search_broader =>
      'Não encontrou o que estava à procura? Vamos tentar uma pesquisa mais avançada!';

  @override
  String get prices_proof_subtitle => 'Demonstração';

  @override
  String get prices_proof_empty_title => 'Nenhuma prova ainda!';

  @override
  String get prices_proof_empty_explanation =>
      'Comece adicionando uma foto de um **recibo** ou uma **etiqueta de preço**!';

  @override
  String get prices_proof_find => 'Selecionar um comprovativo';

  @override
  String get prices_proof_change => 'Prova de alteração';

  @override
  String get prices_proof_receipt => 'Recibo';

  @override
  String get prices_proof_price_tag => 'Etiqueta de preço';

  @override
  String get prices_proof_mandatory => 'Tem de selecionar um comprovativo!';

  @override
  String get prices_add_validation_error => 'Erro de validação';

  @override
  String get prices_privacy_warning_title => 'Aviso de privacidade';

  @override
  String get prices_unknown_product => 'Produto desconhecido';

  @override
  String get prices_privacy_warning_main_message =>
      'Os preços **serão públicos**, juntamente com a loja a que se referem.\n\nIsto pode permitir que as pessoas que conhecem o nome da sua conta no Open Food Facts possam:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Deduzir em que área vive';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Saber o que compra';

  @override
  String get prices_privacy_warning_sub_message =>
      'Se não se sentir à vontade com isso, altere o nome da sua conta ou crie uma nova conta no Open Food Facts e inicie sessão na aplicação com essa nova conta.';

  @override
  String get i_refuse => 'Não aceito';

  @override
  String get i_accept => 'Aceito';

  @override
  String get prices_currency_change_proposal_title => 'Alterar a moeda?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'A moeda atual é **$currency**. Quer alterá-la para **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Sim, usar $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Não, manter $currency';
  }

  @override
  String get prices_menu_know_more => 'Saiba mais sobre preços abertos';

  @override
  String get dev_preferences_import_history_result_success => 'Concluído';

  @override
  String get dev_mode_section_server => 'Configuração do servidor';

  @override
  String get dev_mode_section_news => 'Configuração do fornecedor de notícias';

  @override
  String get dev_mode_section_product_page => 'Página do produto';

  @override
  String get dev_mode_section_ui => 'Interface do utilizador';

  @override
  String get dev_mode_section_experimental_features =>
      'Funcionalidades experimentais';

  @override
  String get dev_mode_hide_environmental_score_title => 'Excluir Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Utilizar um corretor ortográfico para ecrãs de OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredientes e embalagem)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Redefinir idioma do aplicativo';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Adicionar cartões';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Alternar entre prices.openfoodfacts.org (PROD) e ambiente de teste';

  @override
  String get search_history_item_edit_tooltip =>
      'Reproduzir e editar esta pesquisa';

  @override
  String get search_history_item_remove_tooltip => 'Eliminar';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Descarregou todos os $totalSize produtos.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Descarregar mais $count produtos\nJá descarregou $downloaded de $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'A sua pesquisa de $search está a decorrer.\n\nAguarde alguns segundos…';
  }

  @override
  String get user_search_contributor_title => 'Produtos que adicionei';

  @override
  String get user_search_informer_title => 'Produtos que editei';

  @override
  String get user_search_photographer_title => 'Produtos que fotografei';

  @override
  String get user_search_to_be_completed_title =>
      'Meus produtos a serem concluídos';

  @override
  String get user_search_prices_title => 'Meus valores';

  @override
  String get user_search_proofs_title => 'Minhas demonstrações';

  @override
  String get user_search_proof_title => 'Meu comprovativo';

  @override
  String search_proof_title(String user) {
    return 'Prova enviada por \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Preços para colaboradores: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Últimos preços adicionados';

  @override
  String get all_search_prices_top_user_title =>
      'Maiores colaboradores de preços';

  @override
  String get all_search_prices_top_location_title => 'Lojas com mais preços';

  @override
  String get prices_contribution_assistant =>
      'Assistente de contribuição de preços';

  @override
  String get prices_validation_assistant => 'Assistente de validação de preço';

  @override
  String get prices_challenges_page => 'Desafios';

  @override
  String get prices_multiple_proof_addition_system => 'Adicionar várias provas';

  @override
  String get all_search_prices_top_location_single_title => 'Preços numa loja';

  @override
  String get all_search_prices_top_product_title => 'Produtos com mais preços';

  @override
  String get all_search_to_be_completed_title =>
      'Todos os produtos a serem concluídos';

  @override
  String get categorize_products_country_title =>
      'Ajude a categorizar produtos no seu país';

  @override
  String get edit_product_action_retake_picture => 'Tornar a fotografar';

  @override
  String get edit_product_action_take_picture => 'Fotografar';

  @override
  String get edit_product_action_confirm => 'Confirmar';

  @override
  String get signup_page_terms_of_use_line1 => 'Concordo com ';

  @override
  String get signup_page_terms_of_use_line2 => 'termos de uso e contribuição';

  @override
  String get analytics_consent_image_semantic_label => 'Ícone do Analytics';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Erro fatal: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Erro fatal: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Detalhes básicos completos';

  @override
  String get edit_photo_button_label => 'Editar';

  @override
  String get edit_photo_unselect_button_label => 'Desmarcar fotografia';

  @override
  String get edit_photo_select_existing_button_label =>
      'Selecionar uma imagem existente';

  @override
  String get edit_photo_select_existing_all_label =>
      'Imagens existentes para este produto';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Selecione uma imagem clicando nela';

  @override
  String get edit_photo_select_existing_download_label =>
      'A recuperar imagens existentes…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Não há imagens previamente enviadas relacionadas com este produto.';

  @override
  String get edit_photo_language_not_this_one =>
      'Ainda não existem imagens nesse idioma';

  @override
  String get edit_photo_language_none => 'Ainda sem imagem';

  @override
  String get category_picker_screen_title => 'Categorias';

  @override
  String get basic_details => 'Detalhes básicos';

  @override
  String get product_name => 'Nome do produto';

  @override
  String get product_names => 'Nomes do Produto';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Adicionar uma nova tradução';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Antes de validar, certifique-se de adicionar uma tradução apenas **se o idioma estiver presente na embalagem**';

  @override
  String get add_basic_details_product_name_open_photo => 'Ver foto frontal';

  @override
  String get add_basic_details_product_name_take_photo => 'Tirar foto frontal';

  @override
  String get add_basic_details_product_name_hint =>
      'Introduza o nome do produto (por exemplo: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Alterar o idioma padrão?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Você deseja que o idioma padrão do produto seja definido como \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Bons exemplos';

  @override
  String get explanation_section_bad_examples => 'Maus exemplos';

  @override
  String get add_basic_details_product_name_help_title =>
      'Boas práticas: Nome do produto';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'O nome do produto é o **nome principal impresso na embalagem**. Pode ser uma marca registrada.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Observação:** não adicione uma tradução **se o idioma não estiver presente na embalagem**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Ketchup de tomate';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Não inclua a marca no nome';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketchup de tomate **por Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Não use os símbolos ®, ™, © ou similares';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count outras traduções',
      one: '$count outra tradução',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nome da marca';

  @override
  String get brand_names => 'Marcas';

  @override
  String get add_basic_details_brand_name_error => 'Introduza o nome da marca';

  @override
  String get add_basic_details_brand_names_hint =>
      'Marcas (por exemplo: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Boas práticas: Marcas';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Insira **todas as marcas do produto**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Marca principal';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'A **marca principal**, geralmente exibida claramente na embalagem frontal, deve ser **inserida primeiro**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Outras marcas';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Quando vendido **por uma grande empresa**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** é vendido pela **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Quando vendido com a marca **traduzida em vários idiomas**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** às vezes aparece como **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Quantidade e peso';

  @override
  String get add_basic_details_quantity_hint =>
      'Introduza o peso e se necessário a quantidade (ex.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Boas práticas: quantidade';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copie o valor indicado no produto e **não se esqueça das unidades**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** ou **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (para 6 ovos)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(para um produto com 3 caixas, cada uma de 150g)';

  @override
  String get barcode => 'Código de barras';

  @override
  String barcode_barcode(String barcode) {
    return 'Código de barras: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Código de barras inválido';

  @override
  String get basic_details_add_success =>
      'Detalhes básicos adicionados com sucesso';

  @override
  String get basic_details_add_error =>
      'Não foi possível adicionar detalhes básicos. Por favor, tente novamente após algum tempo';

  @override
  String get clear_search => 'Limpar a pesquisa';

  @override
  String get confirm_clear =>
      'Está prestes a limpar todo o seu histórico: tem a certeza que quer continuar?';

  @override
  String get alert_clear_selected_user_list =>
      'Está prestes a limpar os itens selecionados do seu histórico';

  @override
  String get confirm_clear_selected_user_list =>
      'Tem a certeza que quer continuar?';

  @override
  String get alert_select_items_to_clear =>
      'Selecione um ou mais itens para eliminar';

  @override
  String confirm_clear_user_list(String name) {
    return 'Está prestes a limpar a lista ($name): tem a certeza que quer continuar?';
  }

  @override
  String get confirm_delete_user_list_title => 'Eliminar a lista?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Está prestes a eliminar a lista \"$name\".\nTem a certeza de que quer continuar?';
  }

  @override
  String get confirm_delete_user_list_button => 'Sim, confirmo';

  @override
  String importance_label(String name, String id) {
    return 'Importância de $name: $id';
  }

  @override
  String get user_list_all_title => 'Listas';

  @override
  String get user_list_all_empty => 'Crie a sua primeira lista';

  @override
  String get product_list_select => 'Selecione uma lista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos',
      one: 'Um produto',
      zero: 'Lista vazia',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Adicionar lista';

  @override
  String get open_food_preferences_tooltip =>
      'Edite as suas preferências alimentares';

  @override
  String get add_photo_button_label => 'Adicionar fotografia';

  @override
  String get add_packaging_photo_button_label =>
      'Tirar fotografias de qualquer informação sobre embalagem/reciclagem';

  @override
  String get add_origin_photo_button_label =>
      'Tirar fotografias de qualquer informação relativa à origem';

  @override
  String get add_emb_photo_button_label =>
      'Tirar fotografias de qualquer informação relativa ao código de rastreabilidade';

  @override
  String get add_label_photo_button_label =>
      'Tirar fotografias de todos os selos e informações de certificação';

  @override
  String get choose_image_source_title => 'Escolha a fonte da imagem';

  @override
  String get choose_image_source_body =>
      'Por favor, escolha uma fonte de imagem';

  @override
  String get gallery_source_label => 'Galeria';

  @override
  String get gallery_source_access_denied_dialog_title =>
      'Acesso não autorizado';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Infelizmente, a aplicação não pode aceder à sua galeria, uma vez que negou anteriormente a permissão.\n\nAceda às configurações da aplicação no seu telemóvel em Definições -> Fotografias';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Abrir as configurações';

  @override
  String get share => 'Partilhar';

  @override
  String share_product_text(String url) {
    return 'Dê uma vista de olhos a este produto no Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Veja este produto no Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Veja este produto no Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Veja este produto em Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Dê uma vista de olhos na minha lista de produtos no Open Food Facts: $url';
  }

  @override
  String get capture => 'Tirar uma nova fotografia';

  @override
  String get capture_new_picture => 'Tirar uma foto';

  @override
  String get choose_from_gallery => 'Escolher da galeria';

  @override
  String get image_upload_queued =>
      'A imagem será enviada em segundo plano assim que possível.';

  @override
  String get add_price_queued =>
      'O preço será enviado para o servidor o mais rapidamente possível.';

  @override
  String get background_task_title_full_refresh =>
      'A iniciar a atualização de todos os produtos armazenados localmente';

  @override
  String get background_task_title_top_n =>
      'Iniciar o descarregamento dos produtos mais populares';

  @override
  String get expand_nutrition_facts =>
      'Expandir tabela de informações nutricionais';

  @override
  String get expand_nutrition_facts_body =>
      'Manter a tabela de informações nutricionais expandida';

  @override
  String get expand_ingredients => 'Expandir os ingredientes';

  @override
  String get expand_ingredients_body =>
      'Manter o painel de ingredientes expandido';

  @override
  String get no_internet_connection => 'Sem ligação à Internet';

  @override
  String get world_results_label => 'Todo o mundo';

  @override
  String get world_results_action => 'Alargar a pesquisa a todo o mundo';

  @override
  String get copy_to_clipboard => 'Copiar';

  @override
  String get paste_from_clipboard => 'Colar da área de transferência';

  @override
  String get no_data_available_in_clipboard =>
      'Não existem dados disponíveis na sua área de transferência';

  @override
  String get clipboard_barcode_copy =>
      'Copiar código de barras para a área de transferência';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Código de barras $barcode copiado para a área de transferência!';
  }

  @override
  String get open_product_website => 'Abrir este produto no website';

  @override
  String get language_picker_label => 'O seu idioma';

  @override
  String get country_picker_label => 'O seu país';

  @override
  String get currency_picker_label => 'A sua moeda';

  @override
  String get help_with_openfoodfacts => 'Ajuda com o OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'O produto será atualizado em segundo plano assim que possível.';

  @override
  String get no_email_client_available_dialog_title =>
      'Nenhuma aplicação de e-mail!';

  @override
  String get no_email_client_available_dialog_content =>
      'Por favor, envie-nos manualmente um e-mail para mobile@openfoodfacts.org';

  @override
  String get all_images => 'Todas as imagens';

  @override
  String get selected_images => 'Imagens selecionadas';

  @override
  String get product_card_remove_product_tooltip => 'Remover produto';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Novo código de barras escaneado: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Remover todos os produtos do carrossel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Por favor, digitalize pelo menos dois produtos para compará-los';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Compare os produtos que digitalizou';

  @override
  String get scan_product_loading => 'Digitalizou o\ncódigo de barras:';

  @override
  String get scan_product_loading_initial =>
      'Estamos à procura deste produto!\nPor favor, aguarde alguns segundos…';

  @override
  String get scan_product_loading_long_request =>
      'Ainda estamos à procura deste produto!\nAcha que demora muito tempo a carregar? Nós também…';

  @override
  String get scan_product_loading_unresponsive =>
      'Ainda estamos à procura deste produto.\nGostaria de reiniciar a pesquisa?';

  @override
  String get scan_product_loading_restart_button => 'Reiniciar pesquisa';

  @override
  String get portion_calculator_description =>
      'Calcular informações nutricionais para uma quantidade específica';

  @override
  String get portion_calculator_hint => 'Quantidade';

  @override
  String get portion_calculator_accessibility =>
      'Introduza uma quantidade para calcular as informações nutricionais';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Por favor introduza uma quantidade entre $min e $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Dados em falta. Não foi possível efetuar o cálculo.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Informações nutricionais para $grams g (ou ml)';
  }

  @override
  String get offline_data => 'Dados off-line';

  @override
  String get ocr_image_upload_instruction =>
      'Envie uma imagem para extrair automaticamente as informações que ela contém.';

  @override
  String get upload_image => 'Enviar fotografia';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Falha ao descarregar a imagem';

  @override
  String get image_edit_url_error =>
      'Falha ao editar a imagem porque o URL da imagem não foi indicado.';

  @override
  String get user_picture_source_remember => 'Memorizar a minha escolha';

  @override
  String get user_picture_source_ask => 'Perguntar sempre';

  @override
  String get robotoff_continue => 'Continuar';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Próximas $count perguntas',
      one: 'Próxima pergunta',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'Mostrar palavra-passe';

  @override
  String get owner_field_info_title => 'Valores fornecidos pelo produtor';

  @override
  String get owner_field_info_message =>
      'Com esse logótipo destacamos os dados fornecidos pelo produtor, que podem não ser editáveis.';

  @override
  String get owner_field_info_close_button => 'Fechar esta informação';

  @override
  String get owner_field_image =>
      'Esta imagem é fornecida pelo produtor. Pode não ser editável.';

  @override
  String get edit_packagings_title => 'Componentes da embalagem';

  @override
  String get edit_packagings_element_add =>
      'Adicionar um componente de embalagem';

  @override
  String get edit_packagings_completed => 'A embalagem está completa';

  @override
  String edit_packagings_element_title(int index) {
    return 'Componente de embalagem #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Número de unidades';

  @override
  String get edit_packagings_element_hint_units =>
      'Introduza o número de unidades de embalagens com o mesmo formato e material.';

  @override
  String get edit_packagings_element_field_shape => 'Formato';

  @override
  String get edit_packagings_element_hint_shape =>
      'Introduza o nome do formato indicado nas instruções de reciclagem, se estiverem disponíveis ou selecione um formato.';

  @override
  String get edit_packagings_element_example_shape => 'Garrafa';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Escreva o material específico se souber (pode-se ver muitas vezes um código de material dentro de um triângulo na embalagem) ou um material genérico (por exemplo plástico ou metal) se não tiver a certeza.';

  @override
  String get edit_packagings_element_example_material => 'Vidro';

  @override
  String get edit_packagings_element_field_recycling =>
      'Instruções de reciclagem';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Introduza as instruções de reciclagem apenas se estiverem indicadas no produto.';

  @override
  String get edit_packagings_element_example_recycling => 'Reciclar';

  @override
  String get edit_packagings_element_field_quantity =>
      'Quantidade líquida de produto por unidade';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Introduza o peso líquido ou o volume líquido e indique a unidade (por exemplo g ou ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Peso de uma unidade vazia (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Remova qualquer resto de comida, lave e seque a parte da embalagem antes de a pesar. Se possível, use uma balança com precisão de 0,1g ou 0,01g.';

  @override
  String get background_task_title => 'Contribuições pendentes';

  @override
  String get background_task_subtitle =>
      'As suas contribuições são guardadas automaticamente no nosso servidor, mas nem sempre em tempo real.';

  @override
  String get background_task_list_empty =>
      'Nenhuma Tarefa em Segundo Plano Pendente';

  @override
  String get background_task_error_server_time_out =>
      'Tempo limite do servidor';

  @override
  String get background_task_error_no_internet =>
      'Erro de ligação à Internet. Tente mais tarde.';

  @override
  String get background_task_operation_unknown =>
      'tipo de operação desconhecida';

  @override
  String get background_task_operation_details => 'alterações detalhadas';

  @override
  String get background_task_operation_image => 'envio de fotografia';

  @override
  String get background_task_operation_refresh =>
      'atualização atrasada após o envio da fotografia';

  @override
  String get background_task_run_started => 'iniciado';

  @override
  String get background_task_run_not_started => 'ainda não iniciado';

  @override
  String get background_task_run_to_be_deleted => 'a ser eliminado';

  @override
  String get background_task_question_stop =>
      'Quer interromper esta tarefa o mais rápido possível?';

  @override
  String get feed_back => 'Opinião';

  @override
  String get undo => 'Desfazer';

  @override
  String get copy_email_to_clip_board =>
      'Copiar e-mail para a área de transferência';

  @override
  String get please_send_us_an_email_to => 'Por favor envie-nos um email para';

  @override
  String get email_copied_to_clip_board => 'Email copiado!';

  @override
  String get select_accent_color => 'Selecionar cor de destaque';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Azul';

  @override
  String get color_cyan => 'Ciano';

  @override
  String get color_green => 'Verde';

  @override
  String get color_light_brown => 'Predefinido';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Laranja';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Vermelho';

  @override
  String get color_rust => 'Ferrugem';

  @override
  String get color_teal => 'Verde-azulado';

  @override
  String get text_contrast_mode => 'Contraste do texto';

  @override
  String get contrast_high => 'Alto';

  @override
  String get contrast_medium => 'Médio';

  @override
  String get contrast_low => 'Baixo';

  @override
  String get product_refresher_internet_not_found => 'Produto não encontrado!';

  @override
  String get product_refresher_internet_not_connected =>
      'Não está ligado à Internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Servidor em baixo ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Erro do servidor ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produto não encontrado!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Não existe nenhum produto com o seguinte código de barras na nossa base de dados: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Sem ligação à Internet!';

  @override
  String get product_loader_network_error_message =>
      'Verifique se o telemóvel está ligado a uma rede Wi-Fi ou se os dados móveis estão ativados';

  @override
  String get page_not_found_title => 'Página não encontrada!';

  @override
  String get page_not_found_button => 'Voltar à página inicial';

  @override
  String get download_data => 'Descarregar dados';

  @override
  String get download_top_products =>
      'Descarregar os 1000 produtos mais digitalizados do seu país para fazer digitalizações instantâneas';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produtos',
    );
    return 'Descarregar os $_temp0 produtos mais digitalizados do seu país para fazer digitalizações instantâneas';
  }

  @override
  String get download_in_progress =>
      'A descarregar os dados\nIsto pode demorar algum tempo';

  @override
  String downloaded_products(int num) {
    return '$num produtos adicionados';
  }

  @override
  String get update_offline_data => 'Atualizar dados de produtos offline';

  @override
  String get update_local_database_sub =>
      'Atualizar a base de dados local de produtos com os dados mais recentes do Open Food Facts';

  @override
  String get clear_local_database => 'Remover dados de produtos offline';

  @override
  String get clear_local_database_sub =>
      'Limpe todos os dados de produtos locais da sua aplicação para libertar espaço';

  @override
  String deleted_products(int num) {
    return '$num produtos eliminados';
  }

  @override
  String get loading => 'Carregando…';

  @override
  String get know_more => 'Mais informação';

  @override
  String get offline_data_desc =>
      'Clique para saber mais sobre os dados offline';

  @override
  String get offline_product_data_title => 'Dados de produtos offline';

  @override
  String available_for_download(int num) {
    return '$num produtos disponíveis para digitalização instantânea';
  }

  @override
  String get country_selector_title => 'Selecione o seu país:';

  @override
  String get currency_selector_title => 'Selecione a sua moeda:';

  @override
  String get language_selector_title => 'Selecione o seu idioma:';

  @override
  String get language_selector_section_selected => 'Idiomas selecionados';

  @override
  String get language_selector_section_frequently_used =>
      'Frequentemente usados';

  @override
  String get action_delete_list => 'Eliminar';

  @override
  String get action_change_list => 'Alterar a lista atual';

  @override
  String get product_list_create => 'Criar';

  @override
  String get product_list_create_tooltip => 'Criar uma nova lista';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (novo cálculo)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (novo cálculo)';

  @override
  String get nutriscore_unknown => 'Nutri-Score desconhecido';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score desconhecido (novo cálculo)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score não aplicável';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'O Nutri-Score não é aplicável (novo cálculo)';

  @override
  String get environmental_score_generic_new => 'Eco-Pontuação';

  @override
  String get environmental_score_a_new => 'Pontuação Verde A';

  @override
  String get environmental_score_b_new => 'Pontuação Verde B';

  @override
  String get environmental_score_c_new => 'Pontuação Verde C';

  @override
  String get environmental_score_d_new => 'Pontuação Verde D';

  @override
  String get environmental_score_e_new => 'Pontuação Verde E';

  @override
  String get environmental_score_unknown_new => 'Pontuação Verde Desconhecida';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score não é aplicável';

  @override
  String get nova_group_generic_new =>
      'Alimentos ultraprocessados - Grupos NOVA';

  @override
  String get nova_group_1 => 'NOVA Grupo 1';

  @override
  String get nova_group_2 => 'NOVA Grupo 2';

  @override
  String get nova_group_3 => 'NOVA Grupo 3';

  @override
  String get nova_group_4 => 'NOVA Grupo 4';

  @override
  String get nova_group_unknown => 'NOVA Grupo desconhecido';

  @override
  String get nutrition_facts => 'Valores nutricionais';

  @override
  String get faq_title_partners => 'Parceiros e patrocinadores da ONG';

  @override
  String get faq_title_vision =>
      'A visão, missão, valores e programas do Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Instale o Open Beauty Facts para criar uma base de dados de cosméticos';

  @override
  String get faq_title_install_pet =>
      'Instale o Open Pet Food Facts para criar uma base de dados de comida para animais de estimação';

  @override
  String get faq_title_install_product =>
      'Instale o Open Products Facts para criar uma base de dados de produtos para prolongar a vida útil dos objetos';

  @override
  String get faq_nutriscore_nutriscore =>
      'Novo cálculo do Nutri-Score: o que há de novo?';

  @override
  String get contact_title_pro_page =>
      'Profissional? Importe os seus produtos no Open Food Facts';

  @override
  String get contact_title_pro_email => 'Contacto do produtor';

  @override
  String get contact_title_press_page => 'Página de imprensa';

  @override
  String get contact_title_press_email => 'Contactos de imprensa';

  @override
  String get contact_title_newsletter => 'Inscreva-se na nossa newsletter';

  @override
  String get contact_title_calendar =>
      'Assine o calendário da nossa comunidade';

  @override
  String get hunger_games_loading_line1 => 'Por favor, dê-nos alguns segundos…';

  @override
  String get hunger_games_loading_line2 =>
      'Estamos a descarregar as perguntas!';

  @override
  String get hunger_games_error_label =>
      'Ups! Algo correu mal... e não conseguimos carregar as perguntas.';

  @override
  String get hunger_games_error_retry_button => 'Vamos tentar novamente!';

  @override
  String get reorder_attribute_action => 'Reordenar os atributos';

  @override
  String get link_cant_be_opened =>
      'Este link não pode ser aberto no seu dispositivo. Por favor, verifique se você tem um navegador instalado.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detalhes de $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detalhes de $pageName com $productName';
  }

  @override
  String get guide_title => 'Guia';

  @override
  String get guide_share_label => 'Partilhar';

  @override
  String get guide_nutriscore_v2_title =>
      'O Nutri-Score está evoluindo: explicações!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'O que é o Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'O Nutri-Score é um logotipo que visa informá-lo sobre a **qualidade nutricional dos alimentos**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'O código de cores varia de verde-escuro (**A**) para os produtos **mais saudáveis** a vermelho-escuro (**E**) para os **menos saudáveis**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'O logotipo Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Por que o Nutri-Score está evoluindo?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'A fórmula Nutri-Score **está evoluindo** para fornecer melhores recomendações:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Avalie melhor todas as bebidas';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'As notas comparativas de **leite**, **bebidas lácteas** com adição de açúcar e bebidas **vegetais** foram melhor diferenciadas no novo algoritmo.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Melhor classificação de bebidas';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'O **teor de açúcar** é melhor considerado e favorece bebidas **pouco adoçadas**.\\n**Adoçantes também serão penalizados**: refrigerantes dietéticos serão rebaixados de uma classificação B para entre C e E. Água continua sendo a bebida recomendada.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Sal e açúcar penalizados';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Produtos **muito doces** ou **muito salgados** terão sua **classificação ainda mais rebaixada**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarquia entre óleos e peixes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'A classificação de certos **peixes gordurosos** e **óleos ricos em gorduras boas** melhorará.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limite a carne vermelha';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'O consumo de **carne vermelha deve ser limitado**. É por isso que **aves serão comparativamente melhor classificadas**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Como diferenciar o antigo Nutri-Score do novo cálculo?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'A partir de agora, o logotipo pode exibir a menção \"**Novo cálculo**\" para esclarecer que este é realmente o novo cálculo.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'O logotipo do novo Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Onde encontrar o novo cálculo do Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'O Nutri-Score é aplicado em 7 países: França, Alemanha, Bélgica, Espanha, Luxemburgo, Holanda e Suíça.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Os fabricantes têm no máximo **2 anos** após a assinatura do decreto **para substituir** o cálculo antigo pelo novo.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Sem esperar, você **já encontrará no aplicativo OpenFoodFacts** o novo cálculo, inclusive caso os fabricantes não tenham atualizado a pontuação.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'O que não muda';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'O Nutri-Score é uma pontuação projetada para **medir a qualidade nutricional**. É **complementar ao grupo NOVA** sobre **alimentos ultraprocessados** (também presente no aplicativo).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Para os fabricantes, a exibição do Nutri-Score **continua opcional**.';

  @override
  String get guide_greenscore_title => 'Eco-Pontuação';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'O que é o Green Score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'O Green-Score é um logotipo que visa informá-lo sobre o **impacto ambiental dos alimentos**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'O código de cores varia de verde escuro (**A+**) para os produtos **de menor impacto** a vermelho escuro (**F**) para os produtos **de maior impacto**.';

  @override
  String get guide_greenscore_logos_caption => 'Os logotipos do Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'O núcleo: Avaliação do ciclo de vida (ACV)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Uma avaliação científica das categorias de alimentos';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Para cada categoria de produto, uma pontuação de referência é estabelecida usando dados do banco de dados ambiental Agribalyse (desenvolvido pela ADEME e INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Análise do ciclo de vida** é um método de avaliação padronizado para realizar uma avaliação ambiental multiestágio e multicritério.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Ele mede:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 etapas de produção';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agricultura';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processamento';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Embalagem';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transporte';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribuição';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumo';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicadores de impacto ambiental';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Mudanças climáticas/pegada de carbono';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Depleção da camada de ozônio';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiação ionizante';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Terra';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Uso de água e energia';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Poluição do ar';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Água marinha e doce (partículas, acidificação, eutrofização)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Esgotamento de recursos.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bônus e penalidades';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Para recompensar os melhores produtos dentro de uma categoria, aplicamos bônus e penalidades com base em vários critérios:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Modo de produção';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Um bônus é concedido a produtos que possuem um rótulo oficial ou certificação que garante benefícios ambientais (orgânico, comércio justo, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origem dos ingredientes';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Um bônus é concedido com base na origem dos ingredientes, observando que o impacto do transporte e também a política ambiental do país de produção.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Espécies ameaçadas';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Uma penalidade é aplicada a produtos que contenham ingredientes com impactos negativos significativos na biodiversidade e nos ecossistemas, como o óleo de palma, os quais são responsáveis por desflorestamento massivo';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Embalagem';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Uma penalidade é calculada observando a circularidade das embalagens (uso de material reciclado, reciclabilidade e excesso de embalagem).';

  @override
  String get guide_greenscore_transparency_title =>
      'Uma maior necessidade de transparência para melhor medir e reduzir os impactos ambientais';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Para calcular com exatidão a Pontuação Verde, é necessário ter **informações que não são necessariamente especificados na embalagem** (tal como a origem ou exata porcentagem de cada ingrediente) ou os quais são raramente disponíveis em formas utilizáveis (como a lista com todos os componentes da embalagem com os tipos precisos de plásticos usados).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      'Valores médios são usados quando essas informações ainda não estão disponíveis, mas agora estamos convocando todos para nos ajudar a coletar esses dados, que serão muito úteis para a Pontuação Verde e outros usos.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Como os cidadãos podem ajudar?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Todos podem ajudar a reunir e estruturar as informações presentes nos produtos ou que possam ser deduzidas deles, como informações sobre embalagem: “Missão Embalagens” — um grande inventário colaborativo de embalagens de alimentos (em francês).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Como os fabricantes podem ajudar';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Os fabricantes podem nos enviar suas informações diretamente por meio de nossa plataforma gratuita para produtores.';

  @override
  String get guide_greenscore_better_product_title =>
      'Qual produto é melhor para o planeta?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Pode ser difícil dizer';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Escolher alimentos sustentáveis é uma das coisas mais poderosas que podemos fazer pelo clima, já que **nosso sistema alimentar global é responsável por mais de um quarto de todas as emissões de gases de efeito estufa**.\n(Fonte: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Você tem o poder!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'A boa notícia é que isso nos dá uma maneira poderosa de gerar mudanças.\n**Cada um de nós faz cerca de 1.000 refeições por ano**. São 1.000 oportunidades para **escolher um futuro melhor para o planeta**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Ajuda a ser responsável e a decidir';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Escolher alimentos sustentáveis pode parecer complexo. Os rótulos são confusos e muitas vezes faltam informações. O Green-Score foi criado para simplificar, oferecendo uma classificação ambiental **clara**, **baseada em dados científicos** e **transparente** para produtos alimentícios, exatamente onde você precisa: enquanto faz compras.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparência';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Ao contrário dos rótulos proprietários, o cálculo do Green-Score é **completamente aberto** e pode ser **verificado por qualquer pessoa**.';

  @override
  String get guide_nova_title => 'Alimentos ultraprocessados';

  @override
  String get guide_nova_what_is_nova_title => 'O que é ultraprocessamento?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Os grupos NOVA informam sobre o nível de processamento dos alimentos.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'A classificação NOVA permite a categorização de alimentos em **4 grupos** com base em seu **grau de processamento industrial** (alimentos minimamente processados ou não processados, ingredientes culinários, alimentos processados, alimentos ultraprocessados).';

  @override
  String get guide_nova_logos_caption => 'Os logotipos da NOVA';

  @override
  String get guide_nova_groups_title => 'Os 4 grupos NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Existem 4 grupos NOVA, sendo o problemático o Grupo 4 - Alimentos ultraprocessados.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Alimentos minimamente processados ou não processados';

  @override
  String get guide_nova_groups_arg1_text =>
      'Alimentos não processados (ou naturais) são as partes comestíveis de plantas (sementes, frutas, folhas, caules, raízes) ou de animais (músculos, vísceras, ovos, leite), além de fungos, algas e água, após serem separados da natureza.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Ingredientes culinários processados';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Comidas Processadas';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances From Group 2 to group 1** foods. Processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most PROCESSED foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can Be eaten On their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Alimentos ultraprocessados';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to No intact Group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, Oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in Culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Os problemas com o ultraprocessamento';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Processamento extremo de ingredientes alimentares';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Muitos são derivados do processamento de alimentos constituintes, tais são óleos hidrogenados ou interesterificados, proteínas hidrolisadas, proteína isolada de soja, açúcar invertido e xarope de milho de alta frutose.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aditivos que vão além da pura segurança alimentar';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Aditivos em alimentos ultraprocessados incluem alguns que também são usados em alimentos processados, como conservantes, antioxidantes e estabilizantes. As classes de aditivos encontradas apenas em produtos ultraprocessados incluem aquelas usadas **para imitar ou intensificar as qualidades sensoriais dos alimentos ou para disfarçar aspectos desagradáveis do produto final**. Esses aditivos incluem corantes e estabilizadores de cor; aromas, realçadores de sabor, adoçantes não açucarados; e auxiliares de processamento, como agentes gaseificantes, firmadores, de volume e antiespumantes, agentes antiaglomerantes e de brilho, emulsificantes, sequestrantes e umectantes.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Processamento que você não pode fazer em casa';

  @override
  String get guide_nova_explanations_arg3_text =>
      'Uma infinidade de sequências de processos é utilizada** para combinar os geralmente muitos ingredientes e criar o produto final (daí o termo \"ultraprocessado\"). Esses processos incluem vários **sem equivalente doméstico**, como hidrogenação e hidrólise, extrusão e moldagem, e pré-processamento para fritura.\n';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Os aspectos predatórios e financeiros do ultraprocessamento';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**O objetivo geral do ultraprocessamento é criar produtos alimentícios de marca**, **convenientes** (duráveis, prontos para consumo), **atraentes** (hiperpalatáveis) e **altamente lucrativos** (com ingredientes de baixo custo), projetados para substituir todos os outros grupos alimentares. Produtos ultraprocessados geralmente são embalados de forma atraente e amplamente promovidos.';

  @override
  String get guide_nova_explanations_arg5_title => 'Um risco à saúde';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Desde 2018, com o estudo NutriNet-Santé, foram destacados os primeiros vínculos entre **o consumo de alimentos ultraprocessados e o aumento dos riscos de câncer, doenças cardiovasculares e diabetes**. Hoje, mais de 90 estudos em todo o mundo confirmam essas descobertas.  \nAs associações mais fortes estão relacionadas à **obesidade, mortalidade cardiovascular e sintomas depressivos**. Em crianças, os efeitos são observados principalmente no peso e em desequilíbrios lipídicos.\n';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Países recomendam limitá-los';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Alguns países utilizam os grupos NOVA em suas diretrizes ou metas alimentares, por exemplo:\nAs diretrizes alimentares do **🇧🇷 Brasil** **recomendam limitar o consumo** de alimentos processados e evitar os ultraprocessados\n**As metas da política nutricional de saúde pública da **🇫🇷 França** para 2018-2022 visam **reduzir o consumo de alimentos ultraprocessados do grupo 4 em 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-pt.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Bem-vindo ao Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      ' O que é o Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'O Open Food Facts é um banco de dados **colaborativo**, **gratuito** e **aberto** de produtos alimentícios de todo o mundo.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Acreditamos que todos devem ter acesso às informações sobre o que consomem. Ao coletar dados sobre ingredientes, alérgenos, informações nutricionais e muito mais, **capacitamos os consumidores a fazer escolhas conscientes** e impulsionamos a indústria alimentícia **rumo a uma maior transparência**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Recursos do Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Receba alerta sobre ingredientes que você deseja evitar';

  @override
  String get guide_open_food_facts_tips_title =>
      'Dicas para tirar boas fotos\n';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'O que não fazer';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Evite sombras e reflexos.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Não envie texto borrado ou fora de foco.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Não corte partes do texto.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Evite fundos poluídos ou com muitos detalhes.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'O que fazer';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use iluminação boa e uniforme.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Certifique-se de que o texto esteja nítido e legível.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Fotografe toda a lista de ingredientes.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Mantenha o produto sobre uma superfície plana.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Ajude-nos a construir a “Wikipédia dos Alimentos”';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Uma pontuação sobre a qualidade nutricional';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Uma pontuação para evitar alimentos ultraprocessados';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      ' Uma pontuação para o planeta';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-en.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Bem-vindo ao Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'O que é o Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'O Open Pet Food Facts estende nossa missão aos nossos amigos peludos! É um **banco de dados de produtos alimentícios para gatos, cães e outros animais de estimação**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Reunimos informações sobre **ingredientes**, **análises nutricionais** e **orientações de alimentação** para ajudar os tutores a escolher o melhor alimento para as necessidades de seus animais.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Recursos do Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Receba alerta sobre ingredientes que você deseja evitar';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      ' Seu animal é alérgico a algum ingrediente? Você pode definir uma lista de ingredientes a evitar diretamente no aplicativo!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Dicas para tirar boas fotos\n';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'O que não fazer';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Evite sombras e reflexos.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Não envie texto borrado ou fora de foco.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Não corte partes do texto.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Evite fundos poluídos ou com muitos detalhes.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'O que fazer';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use iluminação boa e uniforme.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Certifique-se de que o texto esteja nítido e legível.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Fotografe toda a lista de ingredientes.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Mantenha o produto sobre uma superfície plana.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Uma observação sobre a pontuação';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Desenvolver um sistema de pontuação para alimentos de animais **não é uma prioridade no momento**. A metodologia seria complexa, pois as necessidades nutricionais variam bastante conforme a espécie, idade e condição de saúde. Ainda não encontramos nenhuma equipe científica independente capaz de desenvolver tal pontuação.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-en.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Bem-vindo ao Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'O que é o Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'O Open Beauty Facts é um banco de dados colaborativo de **produtos cosméticos**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Nosso objetivo é decifrar listas de ingredientes para ajudar você a **entender o que há em seus produtos de cuidados pessoais**. De hidratantes a maquiagens, coletamos dados sobre ingredientes, alérgenos e embalagens para promover a transparência na indústria cosmética.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Recursos do Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Receba alerta sobre ingredientes que você deseja evitar';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'É alérgico a algum ingrediente? Quer evitar substâncias comedogênicas? Quer afastar-se de componentes controversos? Você pode definir uma lista de ingredientes cosméticos a evitar diretamente no aplicativo!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Dicas para tirar boas fotos\n';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'O que não fazer';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Evite sombras e reflexos.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Não envie texto borrado ou fora de foco.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Não corte partes do texto.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Evite fundos poluídos ou com muitos detalhes.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'O que fazer';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use iluminação boa e uniforme.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Certifique-se de que o texto esteja nítido e legível.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Fotografe toda a lista de ingredientes.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Tire quantas fotos forem necessárias se o frasco for curvado.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Pode ser necessário remover o rótulo para ver a lista de ingredientes.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Mantenha o produto sobre uma superfície plana.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Uma observação sobre a pontuação';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Diferente dos produtos alimentícios, o mundo dos cosméticos **não possui um sistema de pontuação reconhecido e respaldado por governos, como a Pontuação de Nutrição. Os efeitos dos ingredientes podem ser altamente pessoais e depender do tom de pele, alergias e preocupações individuais.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-en.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Bem-vindo ao Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'O que é o Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'O Open Prices é um projeto para **coletar e compartilhar preços de produtos em todo o mundo**. É um conjunto de dados de acesso público que pode ser usado para pesquisa, análise e muito mais. O Open Prices é desenvolvido e mantido pelo Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Atualmente há poucas empresas que possuem grandes bancos de dados de preços de produtos no nível de código de barras. Esses preços não estão disponíveis gratuitamente, mas são vendidos a um preço alto para atores privados, pesquisadores e outras organizações que podem pagar por eles.';

  @override
  String get guide_open_prices_how_title => 'Como funciona o Open Prices?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Estamos coletando dados de um conjunto de dados de preços de código aberto**. Os preços podem ser adicionados pelos usuários através deste aplicativo da Web ou pelo aplicativo móvel Open Food Facts. Varejistas ou aplicativos de terceiros também podem contribuir utilizando nossa API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Colete fotos das etiquetas de preço nos corredores';

  @override
  String get guide_open_prices_how_arg2_title => 'Colete fotos de receitas';

  @override
  String get guide_open_prices_why_title =>
      'Por que o Open Food Facts está fazendo isso?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informações sobre preços são de suma importância para compreender os sistemas alimentares. É um fator-chave na compreensão do custo dos alimentos e para promover dietas mais saudáveis. Abrir dados de preços é uma maneira de tornar mais fácil para pesquisadores, jornalistas e cidadãos **terem uma melhor compreensão de como os preços dos alimentos variam geograficamente e ao longo do tempo**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Acompanhe a evolução dos preços ao longo do tempo';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Veja a **evolução dos preços**: reduflação, cheapflação, podemos acompanhá-las juntos!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Compare os preços perto de você';

  @override
  String get guide_open_prices_why_arg2_text =>
      'À medida que obtivermos mais preços, você poderá identificar **as lojas mais baratas perto de você**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Você considerou coletar preços dos sites dos varejistas?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Por razões legais e técnicas, **não consideramos a coleta de preços de sites de varejistas como uma forma válida de contribuir com o Open Prices**. Queremos ter certeza de que os preços que coletamos são precisos e atualizados, e receber preços coletados de contribuidores não nos permite fazer isso.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'A coleta de preços é uma opção considerada em uma versão futura do Open Prices, mas ela seria feita pelo próprio Open Prices para podermos ter uma prova do preço com base na página HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'Sou um varejista e quero contribuir com preços. Como posso fazer isso?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Você pode contribuir com os preços utilizando nossa API.\nSe você quiser contribuir com preços em escala, entre em contato conosco em prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Bem-vindo ao Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'O que é o Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'O Open Products Facts é um enorme banco de dados aberto para **qualquer produto com código de barras, exceto alimentos, cosméticos e ração para animais de estimação**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'De **eletrônicos** a **brinquedos**, e de **roupas** a **produtos de limpeza**, se tiver um código de barras, pode ser adicionado. Este projeto visa criar uma \"Internet das Coisas\" para objetos do cotidiano, tornando as informações sobre eles universalmente acessíveis.';

  @override
  String get guide_open_products_facts_features_title =>
      'Recursos do Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'O Open Products Facts tem como objetivo proporcionar aos consumidores a possibilidade de **prolongar a vida útil dos objetos**, oferecendo soluções circulares para a manutenção, **reparo**, **reciclagem** dos seus objetos ou para que eles sejam entregues a um novo proprietário.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Pegadas de carbono para alguns produtos';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**O Impacto de CO2**, da ADEME (Autoridade Francesa do Meio Ambiente), fornece o **impacto de carbono** de diversas categorias. Certifique-se de categorizar os produtos corretamente.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Índice de reparabilidade para muitos produtos';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Sempre que um índice de reparabilidade francês estiver disponível, nós o exibiremos. Além disso, **você pode começar a coletar as variáveis usando o Mecanismo de Folksonomia**, para que possamos recalculá-lo no futuro, mesmo em países onde ele não estiver disponível.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Encontre maneiras de doar/revender seu produto';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Nós fornecemos links para **serviços de terceiros que respeitam a economia circular**, que ajudam você a obter o tipo de produto que procura, como um produto de segunda mão, para ser mais gentil com os recursos do planeta.\nObserve que não somos pagos para fazer isso e que o sistema funciona apenas como um exemplo para dois sites na França. Você pode ajudar a expandir este sistema documentando mais sites na wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Quais informações são úteis?';

  @override
  String get guide_open_products_facts_information_text =>
      'Para uma ampla variedade de itens, **os dados que coletamos são flexíveis**. Para isso, **criamos o Mecanismo de Folksonomia**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'O Mecanismo de Folksonomia';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'O Mecanismo de Folksonomia é uma ferramenta que ajuda a complementar produtos com propriedades relevantes. Isso contribui para melhorar a busca e a visibilidade, além de gerar e exibir informações interessantes no futuro.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Você pode adicionar quaisquer chaves e valores, como: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Você receberá sugestões automáticas de possíveis propriedades e poderá adicionar e documentar novas propriedades relacionadas aos seus tipos de produtos favoritos.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-en.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Abrir preferências alimentares';

  @override
  String get guide_coming_soon_button_title => 'Em breve';

  @override
  String get guide_learn_more_subtitle => 'Toque para saber mais';

  @override
  String get preview_badge => 'Pré-visualizar';

  @override
  String get prices_feedback_form =>
      'Clique aqui para nos enviar os seus comentários sobre esta nova funcionalidade!';

  @override
  String get menu_button_list_actions => 'Selecione uma ação';

  @override
  String get error_loading_photo => 'Erro ao carregar a foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Usar como…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Usar esta imagem como…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Usar esta imagem como… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detalhes';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detalhes desta foto';

  @override
  String get photo_viewer_details_title => 'Detalhes da foto';

  @override
  String get photo_viewer_details_contributor_title => 'Colaborador';

  @override
  String get photo_viewer_details_size_title => 'Tamanho';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatível';

  @override
  String get user_lists_action_multi_select => 'Selecionar vários';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'A sua pontuação de compatibilidade: $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'Imagem frontal do produto';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Imagem com os ingredientes do produto';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Imagem das informações nutricionais';

  @override
  String get product_image_packaging_accessibility_label =>
      'Imagem da embalagem';

  @override
  String get product_image_other_accessibility_label => 'Outras imagens';

  @override
  String get product_image_outdated_message =>
      'Esta imagem pode estar desatualizada';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (esta imagem pode estar desatualizada)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (esta imagem pode estar bloqueada pelo produtor)';
  }

  @override
  String get product_image_error => 'Não foi possível carregar a imagem!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Não foi possível carregar a $type (erro de rede?)';
  }

  @override
  String get product_page_image_no_image_available => 'Nenhuma \nimagem!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Nenhuma imagem disponível para este produto';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reordenar ou ocultar ações';

  @override
  String get product_page_action_bar_setting_modal_title => 'Editar ações';

  @override
  String get product_page_action_bar_item_move_up => 'Mover para cima';

  @override
  String get product_page_action_bar_item_move_down => 'Mover para baixo';

  @override
  String get product_page_action_bar_item_enable => 'Ativar a ação';

  @override
  String get product_page_action_bar_item_disable => 'Desativar a ação';

  @override
  String get product_page_pending_operations_banner_title =>
      'A enviar as suas edições…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Os dados mostrados nesta página **ainda não refletem as suas alterações**.\nAguarde alguns segundos…';

  @override
  String get product_add_a_language => 'Adiciona um idioma';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Código de barras. $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Remover todos os produtos do carrossel';

  @override
  String get carousel_unsupported_header => 'Código de barras não suportado!';

  @override
  String get carousel_unsupported_title => 'Uuups!';

  @override
  String get carousel_unsupported_text =>
      'O código de barras digitalizado não é suportado pelo Open Food Facts!';

  @override
  String get carousel_error_header => 'Erro!';

  @override
  String get carousel_error_title => 'Que chatice!';

  @override
  String get carousel_error_text_1 =>
      'Não conseguimos descarregar informações sobre este código de barras:';

  @override
  String get carousel_error_text_2 =>
      'Verifique a sua ligação à Internet ou clique neste botão:';

  @override
  String get carousel_error_button => 'Repetir';

  @override
  String get carousel_unknown_product_header => 'Produto desconhecido';

  @override
  String get carousel_unknown_product_title => 'Encontraste uma __raridade!__';

  @override
  String get carousel_unknown_product_text =>
      'Este produto ainda não existe na nossa base de dados: ';

  @override
  String get carousel_unknown_product_button => 'Adicione este produto';

  @override
  String get carousel_loading_header => 'A carregar informação...';

  @override
  String get carousel_loading_title =>
      'Acabou de digitalizar um produto com o seguinte código de barras:';

  @override
  String get carousel_loading_text =>
      'Estamos a procurar na nossa base de dados com mais de **3 milhões de produtos!**';

  @override
  String get product_type_subtitle_food =>
      'Legumes, frutas, alimentos congelados…';

  @override
  String get product_type_subtitle_beauty =>
      'Maquilhagem, sabonetes, pastas de dentes…';

  @override
  String get product_type_subtitle_pet_food => 'Comida para cães, gatos…';

  @override
  String get product_type_subtitle_product => 'Telemóveis, mobiliário…';

  @override
  String get photo_field_front => 'Fotografia do produto';

  @override
  String get photo_field_ingredients => 'Foto de ingredientes';

  @override
  String get photo_field_nutrition => 'Fotografia das informações nutricionais';

  @override
  String get photo_field_packaging => 'Foto de informações da embalagem';

  @override
  String get photo_already_exists => 'Esta fotografia já existe';

  @override
  String get photo_missing => 'Esta fotografia está em falta';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Rodar para a esquerda';

  @override
  String get photo_rotate_right => 'Rodar para a direita';

  @override
  String get photo_undo_action => 'Desfazer a ação anterior';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Um mapa mundial de $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Contribuidores do OpenStreetMap';

  @override
  String get not_applicable_short => 'N/D';

  @override
  String get knowledge_panel_warning_text => 'Aviso';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Porque é que este Nutri-Score é diferente do que está na embalagem?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Existem duas explicações possíveis:\nA lista de ingredientes e/ou informações nutricionais não estão atualizadas.\n\nFornecemos o “Novo cálculo” do Nutri-Score (ou V2). Por favor, verifique se tem a indicação “Novo cálculo” na embalagem.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Verifique os ingredientes';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Verifique as informações nutricionais';

  @override
  String url_not_supported(String url) {
    return 'Infelizmente, não é possível abrir o URL:\n$url';
  }

  @override
  String get product_list_export => 'Exportar';

  @override
  String get product_list_import => 'Importar';

  @override
  String get product_footer_action_barcode => 'Ver código de barras';

  @override
  String get product_footer_action_barcode_short => 'Código de barras';

  @override
  String get product_footer_action_open_website => 'Visitar site';

  @override
  String get product_footer_action_report => 'Denunciar';

  @override
  String get product_footer_action_contributor_guide => 'Ajuda';

  @override
  String get product_footer_action_data_quality_tags => 'Qualidade dos dados';

  @override
  String get product_page_tab_for_me => 'Para mim';

  @override
  String get product_page_tab_website => 'Site';

  @override
  String get product_page_tab_prices => 'Preços';

  @override
  String get prices_explanation_card_title => 'Por que os preços?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** é um projeto para coletar e compartilhar preços de produtos ao redor do mundo 🌍. O Open Prices é desenvolvido e mantido pelo Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Saiba mais';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title =>
      'O que são atributos da Folksonomia?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Os atributos são baseados em **chave-valor**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Essas propriedades são criadas e arquivadas por colaboradores para qualquer tipo de uso.';

  @override
  String get folksonomy_action_external_link_title => 'Abrir link externo';

  @override
  String get folksonomy_action_external_link_warning =>
      'Links externos podem não ser seguros. Você realmente quer acessá-lo?';

  @override
  String get prices_products_empty_title => 'Nenhum preço disponível';

  @override
  String get prices_products_empty_explanation =>
      'Seja o primeiro a contribuir!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Principais $pageSize produtos (total: $total)';
  }

  @override
  String get app_review_title => 'Está gostando do aplicativo?';

  @override
  String get app_review_low => 'Poderia ser melhor';

  @override
  String get app_review_medium => 'Nada mal';

  @override
  String get app_review_high => 'Adoro!';

  @override
  String get app_review_feedback_modal_title =>
      'Ajude-nos a melhorar nosso aplicativo';

  @override
  String get app_review_feedback_modal_content =>
      'Se você tiver alguns minutos, responda a este formulário para que **possamos melhorar em atualizações futuras**:';

  @override
  String get app_review_feedback_modal_open_form => 'Responder ao formulário';

  @override
  String get app_review_feedback_modal_later => 'Perguntar depois';

  @override
  String get nutrition_facts_extract_new =>
      'NOVO: você pode extrair os nutrientes da imagem automaticamente!';

  @override
  String get nutrition_facts_extract_button_text => 'Extrair agora';

  @override
  String get nutrition_facts_extract_in_progress => 'Extração em andamento…';

  @override
  String get nutrition_facts_extract_successful => 'Extração bem-sucedida';

  @override
  String get nutrition_facts_extract_failed =>
      'Falha ao extrair nutrientes da imagem';

  @override
  String get prices_discount => 'Desconto';

  @override
  String get prices_stats_statistics => 'Estatísticas';

  @override
  String get prices_stats_title => 'Estatísticas de preços';

  @override
  String get prices_stats_prices_section => 'Preços';

  @override
  String get prices_stats_products_section => 'Produtos';

  @override
  String get prices_stats_locations_section => 'Localizações';

  @override
  String get prices_stats_proofs_section => 'Provas';

  @override
  String get prices_stats_contributors_section => 'Colaboradores';

  @override
  String get prices_stats_experiments_section => 'Experimentos';

  @override
  String get prices_stats_misc_section => 'Diversos';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'Com um código de barras';

  @override
  String get prices_stats_with_category => 'Com uma categoria';

  @override
  String get prices_stats_with_discount => 'Com desconto';

  @override
  String get prices_stats_community => 'Comunidade';

  @override
  String get prices_stats_consumption => 'Consumo';

  @override
  String get prices_stats_with_price => 'Com um preço';

  @override
  String get prices_stats_food => 'Alimentação';

  @override
  String get prices_stats_beauty => 'Beleza';

  @override
  String get prices_stats_products => 'Produtos';

  @override
  String get prices_stats_pet_food => 'Alimentos de pets';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Países';

  @override
  String get prices_stats_price_tag => 'Etiqueta de preço';

  @override
  String get prices_stats_receipt => 'Recibo';

  @override
  String get prices_stats_gdpr_request => 'Solicitação do GDPR';

  @override
  String get prices_stats_shop_import => 'Importação de loja';

  @override
  String get prices_stats_challenges => 'Desafios';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Preços vinculados a uma etiqueta de preço';

  @override
  String get prices_stats_currencies => 'Moedas';

  @override
  String get prices_stats_years => 'Anos';

  @override
  String get prices_stats_by_source_title => 'Preços e provas por fonte';

  @override
  String get prices_stats_website => 'Site';

  @override
  String get prices_stats_mobile_app => 'Aplicativo móvel';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Outros';

  @override
  String get prices_stats_last_updated => 'Última atualização em';

  @override
  String get prices_stats_error =>
      'Ocorreu um erro ao carregar as estatísticas.';

  @override
  String get product_edit_robotoff_question_answered => 'Pergunta respondida!';

  @override
  String get product_edit_robotoff_proof => 'Demonstração';

  @override
  String get preferences_card_general => 'Gerais';

  @override
  String get preferences_prices_title => 'Preços';

  @override
  String get preferences_prices_subtitle =>
      'Gerencie suas preferências de preços';

  @override
  String get preferences_card_project => 'O projeto Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuir';

  @override
  String get preferences_my_contributions_title => 'Minhas contribuições';

  @override
  String get preferences_my_stats_title => 'Minhas estatísticas';

  @override
  String get preferences_contribute_subtitle =>
      'Traduza, melhore nossas ferramentas…';

  @override
  String get preferences_connect_title => 'Conectar';

  @override
  String get preferences_connect_subtitle =>
      'Entre em contato ou siga-nos nas redes sociais';

  @override
  String get preferences_support_title => 'Fazer um donativo';

  @override
  String get preferences_support_subtitle =>
      'Ajude-nos a informar milhões de consumidores em todo o mundo';

  @override
  String get preferences_card_help => 'Ajuda e Suporte';

  @override
  String get preferences_faq_title => 'Perguntas frequentes';

  @override
  String get preferences_faq_subtitle =>
      'Obtenha respostas para suas perguntas';

  @override
  String get logged_out => 'Desconectado';

  @override
  String get preferences_app_bar_message =>
      'Obrigado por ser um dos nossos membros!';

  @override
  String get preferences_app_bar_products_modified => 'Produtos alterados';

  @override
  String get preferences_app_bar_prices_added => 'Preços adicionados';

  @override
  String get preferences_app_bar_see_all_stats => 'Ver todas as estatísticas';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Pesquise $provider por \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Pesquisar uma configuração (por exemplo, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Acessibilidade: Mostrar emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Acessibilidade: Remover cores';

  @override
  String get preferences_app_settings_products => 'Produtos';

  @override
  String get preferences_card_about => 'Sobre';

  @override
  String get preferences_legal_information_title => 'Informações legais';

  @override
  String get preferences_legal_information_subtitle =>
      'Termos de uso, política de privacidade e muito mais';

  @override
  String get preferences_terms_of_use => 'Termos de utilização';

  @override
  String get preferences_legal_mentions => 'Menções legais';

  @override
  String get preferences_legal_header =>
      'Open Food Facts é um banco de dados de produtos alimentícios **feito por todos, para todos**.\nVocê pode usá-lo para fazer melhores escolhas alimentares e, como são **dados abertos**, qualquer pessoa pode **reutilizá-los para qualquer propósito**.';

  @override
  String get preferences_privacy_policy => 'Política de privacidade';

  @override
  String get preferences_licenses => 'Licenças';

  @override
  String get preferences_about_app_title => 'Sobre o aplicativo';

  @override
  String get preferences_about_app_subtitle =>
      'Informações técnicas, informações para desenvolvedores e muito mais';

  @override
  String get preferences_card_information => 'Informação';

  @override
  String get preferences_version_number_title => 'Número da versão';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'Loja de aplicativos';

  @override
  String get preferences_app_system_settings => 'Configurações do sistema';

  @override
  String get preferences_source_code => 'Acesse o código fonte';

  @override
  String get preferences_source_code_subtitle =>
      'E comece a causar impacto em milhões';

  @override
  String get preferences_add_prices => 'Adicionar preços';

  @override
  String get preferences_complete_products => 'Produtos completos';

  @override
  String get preferences_tips => 'Pontas';

  @override
  String get tips_discover_nutriscore => 'Descubra o novo Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => 'No site Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Gerenciar minha conta';

  @override
  String get preferences_manage_account_tooltip => 'Gerencie sua conta';

  @override
  String get preferences_change_password_title => 'Alterar minha senha';

  @override
  String get preferences_danger_zone => 'Zona de perigo';

  @override
  String get preferences_account_deletion_subtitle =>
      'Todas as suas contribuições serão perdidas';

  @override
  String get preferences_contributions_title => 'Contribuições';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Configurações do aplicativo';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Uma maneira muito experimental de escanear produtos offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Atualizar todos os produtos do servidor';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Por favor, evite fazer isso, a menos que seja absolutamente necessário.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Modo de demonstração';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Adicionar cartões ao scanner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Adiciona 3 produtos de amostra ao scanner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Apresentador do Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Anfitrião: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experimentos de acessibilidade';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Seleção de vários produtos para preços';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Painéis de conhecimento solicitados pelo usuário';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Acesso temporário à pesquisa de localização';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Comparação lado a lado de 2 ou 3 produtos';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importação de lista de produtos';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Pontuações e metodologias';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Descubra como o Nutri-Score é calculado';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Conheça as principais mudanças na metodologia';

  @override
  String get preferences_faq_discover_project_title => 'Descubra o projeto';

  @override
  String get preferences_faq_discover_off_title =>
      'Descubra fatos sobre alimentos abertos';

  @override
  String get preferences_faq_discover_obf_title =>
      'Descubra o Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Descubra Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Descubra o Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Descubra o Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Perguntas Frequentes';

  @override
  String get preferences_faq_off_ngo_title => 'A ONG Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informação';

  @override
  String get preferences_connect_community_updates_title =>
      'Receba atualizações da comunidade';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Fique por dentro das novidades do aplicativo e da comunidade';

  @override
  String get preferences_connect_community_calendar_title =>
      'Assine o calendário da nossa comunidade';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Participe participando de um dos nossos eventos virtuais';

  @override
  String get preferences_connect_blog_title => 'O blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Receba as últimas notícias assim que elas acontecem';

  @override
  String get preferences_connect_community_help_title =>
      'Obtenha ajuda da comunidade';

  @override
  String get preferences_connect_improve_app_title =>
      'Ajude-nos a melhorar o aplicativo';

  @override
  String get preferences_connect_debug_info_title =>
      'Envie-nos informações de depuração';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Envie-nos um e-mail com informações detalhadas de depuração';

  @override
  String get preferences_connect_feedback_title =>
      'Envie-nos feedback sobre o aplicativo';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Ajude a moldar o futuro do aplicativo';

  @override
  String get preferences_connect_survey_title =>
      'Responda à pesquisa do aplicativo';

  @override
  String get preferences_connect_survey_subtitle =>
      'Ajude-nos a entender o que devemos construir a seguir';

  @override
  String get preferences_connect_professionals_title => 'Profissionais';

  @override
  String get preferences_connect_pro_subtitle =>
      'Totalmente gratuito, garante dados precisos para 500 aplicativos e milhões de consumidores. Autoatendimento, compatível com seu PIM ou planilhas (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Entre em contato para começar';

  @override
  String get preferences_connect_press_title => 'Imprensa';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Obtenha todo o material necessário para o seu relatório';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Entre em contato para perguntas da imprensa ou para nos informar sobre seu relatório';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Torne-se um voluntário ativo';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Desenvolvimento, Comunicação, Design… qualquer tipo de voluntariado ou especialização é bem-vinda!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Descubra algumas das muitas maneiras pelas quais você pode contribuir';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Desenvolvimento de aplicativos móveis';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Aprenda como contribuir para o desenvolvimento de software';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Compilações instáveis diárias, novos recursos';

  @override
  String get preferences_contribute_local_community_title =>
      'Faça sua comunidade local crescer';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Ajuda com software, conteúdo, traduções de análise de ingredientes';

  @override
  String get preferences_contribute_share_subtitle =>
      'Preparamos um pequeno modelo para ajudar você :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Passos simples para aumentar a transparência alimentar no seu país';

  @override
  String get preferences_contribute_data_quality_title => 'Qualidade dos dados';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Junte-se à equipe de qualidade de dados';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Junte-se ao nosso esforço para garantir que o banco de dados esteja completo e preciso';

  @override
  String get preferences_contributions_products_added_title =>
      'Produtos adicionados';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Novos produtos que adicionei ao Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produtos que preciso completar';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Todos os produtos incompletos';

  @override
  String get preferences_my_contributions_prices_title => 'Preços';

  @override
  String get preferences_my_contributions_my_prices_title => 'Meus valores';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Meus preços, minhas provas…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produtos que você pode ajudar a completar';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ajude a calcular o Nutri-Score e o Green-Score em seu país';

  @override
  String get preferences_prices_user_prices_subtitle => 'Preços que contribuí';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Etiquetas de preço e recibos';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Tire fotos dos seus recibos e escaneie os códigos de barras associados';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Tire fotos dos preços em uma loja';

  @override
  String get preferences_prices_newest_title => 'Preços mais recentes';

  @override
  String get preferences_prices_newest_subtitle =>
      'Últimos preços adicionados pela comunidade Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Colaboradores com mais preços';

  @override
  String get preferences_prices_metrics_title => 'Métricas de preço aberto';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Acompanhe a evolução do projeto';

  @override
  String get preferences_prices_ways_contribute_title => 'Formas de contribuir';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Confirme os preços adicionados por você ou por outros, com a ajuda da IA';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Adicione rapidamente muitos recibos ou fotos de prateleiras do seu rolo de câmera';

  @override
  String get preferences_prices_challenges_title => 'Desafios mensais';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Participe de missões temáticas mensais para coletar preços';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Recupere seus dados de fidelidade';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Aprenda como solicitar seus dados';

  @override
  String get preferences_page_customize_app_title => 'Personalize o aplicativo';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribua para o projeto';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Maneiras simples de ajudar o Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologias de pontuação, ajuda e mais sobre o projeto';

  @override
  String get product_edit_robotoff_positive_button => 'Aceitar sugestão';

  @override
  String get product_edit_robotoff_negative_button => 'Rejeitar sugestão';

  @override
  String get product_edit_robotoff_show_proof => 'Mostrar prova';

  @override
  String get product_edit_robotoff_expand_proof => 'Expandir a prova';

  @override
  String get product_page_tab_raw_data => 'Dados brutos';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Página $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Página $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count de $total itens';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count de $total itens';
  }

  @override
  String item_count(int count) {
    return '$count itens';
  }

  @override
  String item_count_string(String count) {
    return '$count itens';
  }

  @override
  String get prices_no_result => 'Nenhuma estatística de preço encontrada.';

  @override
  String get prices_error_loading_more_items => 'Erro ao carregar mais itens';

  @override
  String get prices_proof_error =>
      'Falha na autenticação, não foi possível obter provas';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count de $total provas';
  }

  @override
  String proof_count(int count) {
    return '$count demonstrações';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count de $total colaboradores';
  }

  @override
  String contributors_count(int count) {
    return '$count colaboradores';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count de $total locais';
  }

  @override
  String prices_locations_count(int count) {
    return '$count locais';
  }

  @override
  String get restart_to_apply_message =>
      'Reinicie o aplicativo para aplicar as alterações.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interface gráfica';

  @override
  String get preferences_app_settings_media_title => 'Mídia';

  @override
  String get preferences_about_app_development_title => 'Desenvolvimento';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Laboratórios Abertos de Informações Alimentares';

  @override
  String get preferences_root_account_title => 'Conta';

  @override
  String get preferences_contribute_translate_header =>
      'Traga o Open Food Facts para o seu idioma';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Inscreva-se na versão alfa do aplicativo';

  @override
  String get preferences_dev_mode_section_data =>
      'Contribuições e dados do produto';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Não mostrar Folksonomia';

  @override
  String get preferences_account_title => 'Conta';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Adicionado em $created';
  }

  @override
  String get location_map_details_title => 'Detalhes da localização';

  @override
  String get location_map_details_name => 'Nome';

  @override
  String get location_map_details_street => 'Rua';

  @override
  String get location_map_details_city => 'Cidade';

  @override
  String get location_map_details_postcode => 'Código postal';

  @override
  String get location_map_details_country => 'País';

  @override
  String get location_map_details_coordinates => 'Coordenadas';

  @override
  String get location_map_details_osm_id => 'ID OSM';
}
