// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Korean (`ko`).
class AppLocalizationsKo extends AppLocalizations {
  AppLocalizationsKo([String locale = 'ko']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => '예';

  @override
  String get add => '추가하기';

  @override
  String get account_delete_message => '계정을 삭제하시겠습니까?\n특별한 이유가 있다면 아래에 공유해주세요.';

  @override
  String get reason => '사유';

  @override
  String get okay => '확인';

  @override
  String get validate => '검사';

  @override
  String get create => '만들기';

  @override
  String get applyButtonText => '적용';

  @override
  String get next_label => '다음';

  @override
  String get continue_label => '계속하기';

  @override
  String get exit_label => '종료';

  @override
  String get previous_label => '이전';

  @override
  String get go_back_to_top => '맨 위로 돌아가기';

  @override
  String get save => '저장';

  @override
  String get save_confirmation => '정말로 저장하시겠습니까?';

  @override
  String get skip => '건너뛰기';

  @override
  String get cancel => '취소';

  @override
  String get ignore => '무시';

  @override
  String get close => '닫기';

  @override
  String get no => '아니요';

  @override
  String get stop => '중지';

  @override
  String get finish => '마치다';

  @override
  String get calculate => '계산하기';

  @override
  String get reset_food_prefs => '식품 설정 초기화';

  @override
  String get error => '문제가 발생했습니다';

  @override
  String get error_occurred => '오류가 발생했습니다';

  @override
  String get featureInProgress => '지금도 작업 중인 기능입니다. 지켜봐주세요.';

  @override
  String get label_web => '웹에서 보기';

  @override
  String get learnMore => '더보기';

  @override
  String get unknown => '알 수 없음';

  @override
  String get match_very_good => '아주 좋은 일치';

  @override
  String get match_good => '적합';

  @override
  String get match_poor => '호환성 낮음';

  @override
  String get match_may_not => '부적합함';

  @override
  String get match_does_not => '일치하지 않음';

  @override
  String get match_unknown => '호환성 알 수 없음';

  @override
  String get match_short_very_good => '아주 좋은 일치';

  @override
  String get match_short_good => '적합';

  @override
  String get match_short_poor => '호환성 낮음';

  @override
  String get match_short_may_not => '부적합함';

  @override
  String get match_short_does_not => '일치하지 않음';

  @override
  String get match_short_unknown => '호환성 알 수 없음';

  @override
  String get licenses => '라이센스';

  @override
  String get looking_for => '찾는 항목';

  @override
  String get welcomeToOpenFoodFacts => 'Open Food Facts 사용을 환영합니다';

  @override
  String get whatIsOff => '오픈 푸드 팩츠는 지역 사회의 지원을 받는 글로벌 비영리 단체입니다.';

  @override
  String get productDataUtility => '당신의 선호도와 관련된 식품 데이터를 확인하세요.';

  @override
  String get healthCardUtility => '당신에게 좋은 음식을 선택하십시오.';

  @override
  String get ecoCardUtility => '지구에 좋은 음식을 선택하십시오.';

  @override
  String get server_error_open_new_issue =>
      '서버 응답이 없습니다! 다음 링크를 통해 문제를 제기하실 수 있습니다.';

  @override
  String get sign_in_text => '귀하의 기여를 저장하려면 Open Food Facts 계정에 로그인하세요.';

  @override
  String get incorrect_credentials => '잘못된 사용자 이름 또는 암호입니다.';

  @override
  String get password_lost_incorrect_credentials =>
      '이 이메일 또는 사용자 이름은 존재하지 않습니다. 자격 증명을 확인하세요.';

  @override
  String get password_lost_server_unavailable =>
      '현재 서버 속도가 느려지고 있습니다. 양해 부탁드립니다. 나중에 다시 시도해 주세요.';

  @override
  String get login => 'Username';

  @override
  String get login_result_type_server_unreachable => '네트워크에 접속할 수 없습니다';

  @override
  String get login_result_type_server_issue => '서버에 문제가 있습니다. 나중에 다시 시도해 주세요.';

  @override
  String get login_page_username_or_email => '사용자 이름 또는 이메일을 입력하십시오';

  @override
  String get login_page_password_error_empty => '비밀번호를 입력하십시오';

  @override
  String get create_account => '계정 생성';

  @override
  String get sign_in => '가입하기';

  @override
  String get sign_in_mandatory => '해당 기능을 사용하려면 로그인해야 합니다.';

  @override
  String get help_improve_country =>
      '귀하의 국가에서 Open Food Facts를 개선하는 데 도움을 주세요.';

  @override
  String get sign_out => '로그아웃';

  @override
  String get sign_out_confirmation => '정말 로그아웃하시겠습니까?';

  @override
  String get password => '암호';

  @override
  String get forgot_password => '비밀번호 찾기';

  @override
  String get forgot_password_question => '비밀번호를 잊으셨나요?';

  @override
  String get view_profile => '프로필 보기';

  @override
  String get reset_password => '비밀번호 재설정';

  @override
  String get reset_password_explanation_text =>
      '비밀번호를 잊어버린 경우 사용자 이름 또는 이메일 주소를 입력하면 비밀번호 재설정 안내를 받을 수 있습니다. 또한 스팸 폴더를 확인하는 것을 잊지 마십시오.';

  @override
  String get username_or_email => '사용자 이름 또는 이메일';

  @override
  String get reset_password_done =>
      '계정과 연결된 이메일로 비밀번호를 초기화하는 링크가 전송되었습니다. 스팸함도 확인하시기 바랍니다';

  @override
  String get send_reset_password_mail => '비밀번호 변경';

  @override
  String get enter_some_text => '내용을 입력해주세요';

  @override
  String get sign_up_page_title => '회원가입';

  @override
  String get sign_up_page_action_button => '회원가입';

  @override
  String get sign_up_page_action_doing_it => '가입하기…';

  @override
  String get sign_up_page_action_ok => '축하합니다! 귀하의 계정이 방금 생성되었습니다.';

  @override
  String get sign_up_page_display_name_hint => '이름';

  @override
  String get sign_up_page_display_name_error_empty => '사용하고자 하는 이름을 입력하십시오';

  @override
  String get sign_up_page_email_hint => '이메일';

  @override
  String get sign_up_page_email_error_empty => '이메일이 필요합니다';

  @override
  String get sign_up_page_email_error_invalid => '이메일이 올바르지 않습니다';

  @override
  String get sign_up_page_username_hint => '사용자 이름: 모두가 볼 수 있어요';

  @override
  String get sign_up_page_username_error_empty => '사용자 이름을 입력하십시오';

  @override
  String get sign_up_page_username_error_invalid => '유효한 사용자 이름을 입력하십시오';

  @override
  String get sign_up_page_username_description =>
      '사용자 이름에는 공백, 대문자 또는 특수문자가 포함될 수 없습니다.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return '사용자 이름은 $value자를 초과할 수 없습니다';
  }

  @override
  String get sign_up_page_password_hint => '암호';

  @override
  String get sign_up_page_password_error_empty => '비밀번호를 입력하십시오';

  @override
  String get sign_up_page_password_error_invalid =>
      '유효한 비밀번호를 입력하십시오 (최소 6자 이상)';

  @override
  String get sign_up_page_confirm_password_hint => '비밀번호 확인';

  @override
  String get sign_up_page_confirm_password_error_empty => '비밀번호를 확인하십시오';

  @override
  String get sign_up_page_confirm_password_error_invalid => '비밀번호가 일치하지 않습니다';

  @override
  String get sign_up_page_agree_text => '저는 Open Food Facts에 동의합니다.';

  @override
  String get sign_up_page_terms_text => '이용 및 기여 약관';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      '계정을 만들 때 사용 약관에 동의하는 것은 필수이지만 앱을 통해 익명으로 기여할 수 있습니다.';

  @override
  String get sign_up_page_producer_checkbox => '저는 식품 생산자입니다';

  @override
  String get sign_up_page_producer_hint => '생산자/브랜드';

  @override
  String get sign_up_page_producer_error_empty => '생산자 또는 브랜드 이름을 입력해주십시오';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Open Food Facts 뉴스레터를 구독하고 싶습니다. (언제든지 구독을 취소할 수 있습니다.)';

  @override
  String get sign_up_page_user_name_already_used =>
      '사용자 이름이 이미 존재합니다. 다른 사용자 이름을 선택하세요.';

  @override
  String get sign_up_page_email_already_exists =>
      '이미 존재합니다. 계정에 로그인하거나 다른 이메일로 시도해 보세요.';

  @override
  String get sign_up_page_provide_valid_email => '유효한 이메일 주소를 입력해 주세요.';

  @override
  String get sign_up_page_server_busy =>
      '대단히 죄송합니다. 귀하의 계정을 만드는 데 기술적인 문제가 있습니다. 나중에 다시 시도 해주십시오.';

  @override
  String get settingsTitle => '설정';

  @override
  String get darkmode => '주제';

  @override
  String get darkmode_dark => '어둡게';

  @override
  String get darkmode_light => '밝게';

  @override
  String get darkmode_system_default => '시스템 기본값';

  @override
  String get thanks_for_contributing => '기여해주셔서 감사합니다!';

  @override
  String get contributors_label => '그들은 앱을 만들고 있습니다';

  @override
  String get contributors_dialog_title => '기여자';

  @override
  String contributors_dialog_entry_description(Object name) {
    return '기여자: $name';
  }

  @override
  String get contributors_description => '이 앱의 모든 기여자 목록';

  @override
  String get support => '지원하다';

  @override
  String get support_join_slack => 'Slack 채널에서 도움 요청';

  @override
  String get support_via_forum => '포럼에서 도움을 요청하세요';

  @override
  String get support_via_email => '이메일 전송';

  @override
  String get support_via_email_include_logs_dialog_title => '앱 로그를 전송할까요?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      '이메일에 앱 로그 파일을 첨부하시겠습니까?';

  @override
  String get termsOfUse => '이용 약관';

  @override
  String get legalNotices => '법적 고지 사항';

  @override
  String get privacy_policy => '개인정보 보호정책';

  @override
  String get about_this_app => '앱 정보';

  @override
  String get contribute => '기여하기';

  @override
  String get contribute_sw_development => '소프트웨어 개발';

  @override
  String get contribute_develop_text =>
      '모든 Open Food Facts 제품의 코드는 GitHub에서 확인할 수 있습니다. 코드를 재사용하여(오픈 소스이므로) 지구상의 모든 사람을 위해 코드를 개선하는 데 도움을 주세요.';

  @override
  String get contribute_develop_text_2 =>
      '질문을 하는 가장 좋은 방법은 Open Food Facts Slack 채팅방에 참여하는 것입니다.';

  @override
  String get contribute_develop_dev_mode_title => '개발자 모드를 활성화할까요?';

  @override
  String get contribute_develop_dev_mode_subtitle => '개발자 모드 활성화';

  @override
  String get contribute_donate_title => '기부';

  @override
  String get contribute_donate_header => 'Open Food Facts에 기부하세요';

  @override
  String get contribute_enroll_alpha_warning =>
      '내부 알파 버전에서는 데이터가 완전히 손실될 가능성이 있으며, 언제든지 앱을 사용할 수 없게 될 수도 있다는 점을 양해해 주시기 바랍니다!';

  @override
  String get contribute_improve_ProductsToBeCompleted => '완제품';

  @override
  String get contribute_improve_header => '개선 중';

  @override
  String get contribute_improve_text =>
      '데이터베이스는 이 프로젝트의 핵심입니다. 쉽고 빠르게 도움을 드릴 수 있습니다. 휴대폰용 모바일 앱을 다운로드하여 제품을 추가하거나 개선할 수 있습니다.\n\n한편, Open Food Facts 웹사이트는 다양한 참여 방법을 제공합니다. ';

  @override
  String get contribute_translate_header => '번역하기';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => '번역 시작';

  @override
  String get contribute_translate_text =>
      '오픈 푸드 팩츠(Open Food Facts)는 160개국 이상의 제품을 소개하는 글로벌 프로젝트입니다. 오픈 푸드 팩츠는 수십 개 언어로 번역되며, 끊임없이 업데이트되는 콘텐츠를 제공합니다.';

  @override
  String get contribute_translate_text_2 => '번역은 프로젝트의 핵심 작업 중 하나입니다';

  @override
  String get contribute_join_skill_pool =>
      'Open Food Facts에 여러분의 기술을 공유하고, 기술 풀에 참여하세요!';

  @override
  String get contribute_share_header => '친구들과 Open Food Facts를 공유하세요';

  @override
  String get contribute_share_content =>
      '제가 사용하고 있는 앱, 오픈 푸드 팩츠(Open Food Facts)를 소개해 드리고자 합니다. 이 앱을 사용하면 개인 맞춤형으로 식품의 건강 및 환경 영향을 확인할 수 있습니다. 포장의 바코드를 스캔하면 작동하며, 무료이고 등록도 필요 없습니다. 심지어 해독되는 식품의 수를 늘리는 데 도움을 줄 수도 있습니다. 휴대폰으로 앱을 다운로드하려면 다음 링크를 클릭하세요: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'GDPR에 따라 로열티 카드 데이터 내보내기를 요청하여 가격을 제공하세요.';

  @override
  String get tap_to_answer => '여기를 눌러 질문에 답하세요';

  @override
  String get tap_to_answer_hint => '이 제품에 대한 질문에 답하려면 여기를 탭하세요.';

  @override
  String get robotoff_questions_loading_hint =>
      '이 제품에 대한 질문이 로드되는 동안 잠시 기다려 주세요.';

  @override
  String get saving_answer => '답변 저장 중';

  @override
  String get contribute_to_get_rewards => '식품 투명성의 배우가 되십시오 음식 위키백과';

  @override
  String get question_sign_in_text =>
      '귀하의 기여에 대한 크레딧을 받으려면 Open Food Facts 계정에 로그인하세요.';

  @override
  String get question_yes_button_accessibility_value => '예라고 대답하세요';

  @override
  String get question_no_button_accessibility_value => '아니오로 대답하세요';

  @override
  String get question_skip_button_accessibility_value => '이 질문을 건너뛰세요';

  @override
  String get tap_to_edit_search => '탭하여 검색하세요';

  @override
  String get myPreferences => '내 설정';

  @override
  String get account_create_message =>
      '계정을 만들고 Open Food Facts 커뮤니티에 가입하여 전 세계의 음식 지식을 쌓는 데 도움을 주세요!';

  @override
  String get join_us => '우리와 함께하세요';

  @override
  String get myPreferences_profile_title => '내 프로필';

  @override
  String get myPreferences_profile_subtitle => 'Open Food Facts 기고자 계정을 관리하세요.';

  @override
  String get myPreferences_settings_title => '앱 설정';

  @override
  String get myPreferences_settings_subtitle => '다크 모드, 언어…';

  @override
  String get myPreferences_food_title => '식품 설정';

  @override
  String get myPreferences_food_subtitle => '당신에게 가장 중요한 음식 정보를 선택하십시오.';

  @override
  String get myPreferences_food_comment =>
      '음식에 대한 가장 중요한 정보를 선택하여 선호도에 따라 음식을 순위를 매기고, 관심 있는 정보를 먼저 확인하고, 호환성 요약을 받아보세요. 선택한 음식 선호도는 기기에 저장되며, Open Food Facts 기여자 계정이 있는 경우 해당 계정과 연결되지 않습니다.';

  @override
  String get confirmResetPreferences => '식품 설정을 초기화하시겠습니까?';

  @override
  String get myPersonalizedRanking => '나만의 순위';

  @override
  String get ranking_tab_all => '모두';

  @override
  String get ranking_subtitle_match_yes => '당신을 위한 좋은 매치';

  @override
  String get ranking_subtitle_match_no => '호환성 매우 낮음';

  @override
  String get ranking_subtitle_match_maybe => '호환성 알 수 없음';

  @override
  String get refresh_with_new_preferences => '새로운 기본 설정으로 목록을 새로 고칩니다.';

  @override
  String get reloaded_with_new_preferences => '새로운 기본 설정으로 다시 로드됨';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => '스캔';

  @override
  String get history_navbar_label => '최근 기록';

  @override
  String get list_navbar_label => '목록';

  @override
  String get category => '카테고리로 필터';

  @override
  String get category_all => '모두';

  @override
  String get category_search => '(카테고리 검색)';

  @override
  String get filter => '필터';

  @override
  String get scan => '스캔 화면의 제품';

  @override
  String get scan_history => '스캔 내역';

  @override
  String get search => '검색';

  @override
  String get search_product_help => 'Search a product,\na brand or a barcode';

  @override
  String get search_filter => '검색 필터';

  @override
  String get search_history => '검색 기록';

  @override
  String get search_store => '매장 검색';

  @override
  String get search_store_help => '힌트: 도시나 국가를 추가하세요';

  @override
  String get tap_for_more => '자세한 내용을 보려면 탭하세요…';

  @override
  String get product => '생성물';

  @override
  String get unknownBrand => '알 수 없는 상표';

  @override
  String get unknownProductName => '알 수 없는 상품명';

  @override
  String get label_refresh => '새로고침';

  @override
  String get label_reload => '재장전';

  @override
  String get image => '이미지';

  @override
  String get front_photo => '전면 사진';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (이 이미지는 오래되었을 수 있습니다)';
  }

  @override
  String get outdated_image_short_label => '오래되었을 수도 있습니다';

  @override
  String get ingredients => '성분';

  @override
  String get ingredients_editing_instructions =>
      '원래 순서를 유지하세요. 특정 성분의 함량을 명시할 때는 백분율을 표시하세요. 쉼표나 하이픈으로 구분하고, 성분의 성분을 나타내는 괄호를 사용하세요.';

  @override
  String get ingredients_editing_error => '재료를 저장하지 못했습니다.';

  @override
  String get ingredients_editing_image_error => '새로운 재료 이미지를 가져오지 못했습니다.';

  @override
  String get ingredients_editing_title => '재료 수정';

  @override
  String get ingredients_photo => '재료 사진';

  @override
  String get packaging_editing_instructions =>
      '모든 포장 부품을 콤마 또는 라인 피드로 구분하여 수량(예: 1 또는 6), 재료(예: 플라스틱, 금속, 알루미늄), 크기(예: 33cl) 및 재활용 지침과 함께 나열합니다.\n예: 재활용할 유리병 1개, 버릴 플라스틱 코르크 1개';

  @override
  String get packaging_editing_error => '포장 사항을 저장하지 못했습니다.';

  @override
  String get packaging_editing_image_error => '새 포장 사진을 가져오지 못했습니다.';

  @override
  String get packaging_editing_title => '포장 편집';

  @override
  String get nutrition => '영양';

  @override
  String get nutrition_facts_photo => '영양 성분 사진';

  @override
  String get nutrition_facts_editing_title => '영양 정보 편집';

  @override
  String get packaging_information => '포장 정보';

  @override
  String get packaging_information_photo => '포장 정보 사진';

  @override
  String get missing_product => '새 상품을 찾았습니다!';

  @override
  String get add_product_take_photos =>
      '이 제품을 Open Food Facts에 추가하려면 포장 사진을 찍으세요.';

  @override
  String get add_product_take_photos_descriptive =>
      '사진을 먼저 찍어주세요. 나중에 언제든지 제품을 완성할 수 있습니다.';

  @override
  String get add_product_information_button_label => '제품 정보 추가하기';

  @override
  String get new_product => '새 상품';

  @override
  String get new_product_found_title => '새로운 제품을 발견했습니다!';

  @override
  String get new_product_found_text =>
      '저희의 협업 데이터베이스에는 **300만 개 이상의 제품**이 포함되어 있지만, 이 바코드는 존재하지 않습니다. ';

  @override
  String get new_product_found_button => '제품 추가';

  @override
  String get new_product_leave_title => '이 페이지를 떠나시겠습니까?';

  @override
  String get new_product_leave_message =>
      '아무것도 입력하지 않으신 것 같습니다. 정말로 이 페이지를 닫으시겠습니까?';

  @override
  String get new_product_dialog_description =>
      '이 제품을 공통 데이터베이스에 추가하려면 포장 사진을 찍어주세요.';

  @override
  String get new_product_dialog_illustration_description =>
      'Nutri-Score와 Green Score가 알려지지 않은 그림';

  @override
  String get front_packaging_photo_button_label => '상품 전면 사진';

  @override
  String get confirm_front_packaging_photo_button_label => '상품 전면 사진 업로드 확인';

  @override
  String get confirm_button_label => '확인';

  @override
  String get send_image_button_label => '이미지 보내기';

  @override
  String get crop_page_action_saving => '이미지 저장…';

  @override
  String get crop_page_action_cropping => '이미지 자르기…';

  @override
  String get crop_page_action_local => '로컬 버전 저장…';

  @override
  String get crop_page_action_local_failed_title => '앗… 사진에 뭔가 이상한 게 있네요!';

  @override
  String get crop_page_action_local_failed_message =>
      '이미지를 서버로 전송하기 전에 로컬에서 처리할 수 없습니다. 나중에 다시 시도하거나 문제가 지속되면 문의해 주세요.';

  @override
  String get crop_page_action_retake => '사진을 다시 찍다';

  @override
  String get crop_page_too_small_image_title => '이미지가 너무 작습니다!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return '사진 업로드에 필요한 최소 픽셀 크기는 ${expectedMinWidth}x$expectedMinHeight입니다. 현재 사진은 ${actualWidth}x$actualHeight입니다.';
  }

  @override
  String get crop_page_action_server => '서버…에 대한 호출 준비';

  @override
  String get front_packaging_photo_title => '전면 포장 사진';

  @override
  String get ingredients_photo_title => '재료 사진';

  @override
  String get nutritional_facts_photo_title => '영양 성분 사진';

  @override
  String get recycling_photo_title => '재활용 사진';

  @override
  String get take_photo_title => '사진을 촬영';

  @override
  String get take_more_photo_title => '더 많은 사진을 찍어보세요';

  @override
  String get front_photo_uploaded => '전면 사진 갱신됨';

  @override
  String get ingredients_photo_button_label => '재료 사진';

  @override
  String get ingredients_photo_uploaded => '재료 사진을 올렸습니다';

  @override
  String get nutrition_cache_loading_error => '캐시에서 영양 성분을 불러올 수 없습니다';

  @override
  String get nutritional_facts_photo_button_label => '영양 성분 사진';

  @override
  String get nutritional_facts_input_button_label => '영양 성분 입력';

  @override
  String get nutritional_facts_added => '영양 성분 추가됨';

  @override
  String get categories_added => '카테고리가 추가되었습니다';

  @override
  String get new_product_title_nutriscore => 'Nutri-Score 계산';

  @override
  String get new_product_subtitle_nutriscore =>
      '최소한 하나의 카테고리와 영양가를 입력하여 도움을 주세요.';

  @override
  String get new_product_title_environmental_score => '그린 점수 계산';

  @override
  String get new_product_subtitle_environmental_score =>
      '최소한 하나의 카테고리를 채워서 받으세요';

  @override
  String get new_product_additional_environmental_score =>
      '원산지, 포장 등을 통해 Green Score 계산을 더욱 정확하게 만드세요.';

  @override
  String get new_product_title_nova => '식품 가공 수준(NOVA) 계산';

  @override
  String get new_product_subtitle_nova => '식품 카테고리와 재료를 입력하여 받으세요';

  @override
  String get new_product_desc_nova_unknown => '식품 가공 수준을 알 수 없음';

  @override
  String get new_product_title_pictures => '신제품';

  @override
  String get new_product_title_pictures_details =>
      '다음 사진을 찍어주세요. 그러면 Open Food Facts 엔진이 나머지 정보를 알아낼 수 있습니다!';

  @override
  String get new_product_title_misc => '그리고 몇 가지 기본 데이터…';

  @override
  String new_product_done_msg(String username) {
    return '귀하의 기여에 감사드립니다 “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => '귀하의 기여에 감사드립니다!';

  @override
  String get new_product_done_button_label => '완성된 제품을 만나보세요';

  @override
  String get hey_incomplete_product_message =>
      '지금 당장 3개의 질문에 답하고 Nutri-Score, Green Score 및 Ultra-processing(NOVA)을 계산해보세요!';

  @override
  String get hey_incomplete_product_message_beauty =>
      '지금 탭하여 2개의 질문에 답하고 이 화장품을 분석해보세요!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      '지금 탭하여 이 반려동물 사료 제품을 분석하는 데 도움이 되는 3가지 질문에 답하세요!';

  @override
  String get hey_incomplete_product_message_product =>
      '지금 탭하여 이 제품을 완성하는 데 도움을 주세요!';

  @override
  String get nutritional_facts_photo_uploaded => '영양 성분 사진을 올렸습니다';

  @override
  String get recycling_photo_button_label => '재활용 정보 사진';

  @override
  String get recycling_photo_uploaded => '재활용 사진을 올렸습니다';

  @override
  String get take_more_photo_button_label => '더 많은 사진을 찍어보세요';

  @override
  String get other_photo_uploaded => '기타 사진을 올렸습니다';

  @override
  String get retake_photo_button_label => '재촬영';

  @override
  String get selecting_photo => '사진 선택';

  @override
  String get uploading_image => '사진을 서버에 올리는 중';

  @override
  String get uploading_image_type_front => 'Open Food Facts에 전면 이미지 업로드';

  @override
  String get uploading_image_type_ingredients => 'Open Food Facts에 재료 이미지 업로드';

  @override
  String get uploading_image_type_nutrition => 'Open Food Facts에 영양 정보 이미지 업로드';

  @override
  String get uploading_image_type_packaging => 'Open Food Facts에 포장 이미지 업로드';

  @override
  String get uploading_image_type_other => 'Open Food Facts에 다른 이미지 업로드';

  @override
  String get uploading_image_type_generic => 'Open Food Facts에 이미지 업로드';

  @override
  String get score_add_missing_ingredients => '누락된 재료 추가';

  @override
  String get score_add_missing_packaging_image => '누락된 패키징 이미지 추가';

  @override
  String get score_add_missing_nutrition_facts => '누락된 영양성분 추가';

  @override
  String get score_add_missing_product_traces => '누락된 제품 추적 추가';

  @override
  String get score_add_missing_product_category => '누락된 상품 카테고리 추가';

  @override
  String get score_add_missing_precise_product_category => '더 정확한 카테고리를 선택하세요';

  @override
  String get score_add_missing_product_countries => '누락된 제품 국가 추가';

  @override
  String get score_add_missing_product_emb => '누락된 제품 추적 코드 추가';

  @override
  String get score_add_missing_product_labels => '누락된 제품 라벨 추가';

  @override
  String get score_add_missing_product_origins => '누락된 제품 원산지 추가';

  @override
  String get score_add_missing_product_stores => '누락된 제품 매장 추가';

  @override
  String get score_add_missing_product_brands => '누락된 제품 브랜드 추가';

  @override
  String get score_update_nutrition_facts => '영양 성분 갱신';

  @override
  String get nutrition_page_title => '영양 성분 정보';

  @override
  String get nutrition_page_nutritional_info_title => '영양 정보';

  @override
  String get nutrition_page_nutritional_info_label => '제품에 명시된 값:';

  @override
  String get nutrition_page_nutritional_info_value_positive => '예';

  @override
  String get nutrition_page_nutritional_info_value_negative => '아니요';

  @override
  String get nutrition_page_nutritional_info_open_photo => '사진 열기';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      '모범 사례: 영양 정보';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      '영양 정보가 **포장이나** 제품과 함께 제공되는 문서에 명시되어 있지 않은 경우가 있습니다. 이 경우에만 값을 **아니요**로 설정할 수 있습니다.';

  @override
  String get nutrition_page_serving_type_label => '영양가:';

  @override
  String get nutrition_page_per_100g => '100g 당';

  @override
  String get nutrition_page_per_100g_100ml => '100g/ml당';

  @override
  String get nutrition_page_per_serving => '인분';

  @override
  String get nutrition_page_add_nutrient => '영양소 추가하기';

  @override
  String get nutrition_page_serving_size => '서빙 사이즈';

  @override
  String get nutrition_page_serving_size_hint => '1회 제공량(예: 100g)을 입력하세요.';

  @override
  String get nutrition_page_serving_size_explanation_title => '모범 사례: 제공량';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      '이 값은 **1회 제공량당 각 영양소의 비례적 계산**을 하는 데 도움이 됩니다.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**허용되는 단위**는 kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨입니다.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60g**, **60g** 또는 **60G** (첫 번째를 선호합니다)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000ml** 또는 **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      '잘못된 단위';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **그램**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      '잘못된 단위';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '**사탕** 9개와 **비스킷** 2개';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      '누락된 단위';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => '잘못된 번호';

  @override
  String get nutrition_page_update_running => '서버에서 제품 업데이트…';

  @override
  String get nutrition_page_update_done => '제품 업데이트됨';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      '제품 수량을 제공량으로 사용하세요';

  @override
  String get nutrition_page_photo_error => '사진을 로드할 수 없습니다';

  @override
  String get more_photos => '기타 흥미로운 사진';

  @override
  String get view_more_photo_button => '이 제품에 대한 모든 기존 사진 보기';

  @override
  String get no_product_found => '상품 없음';

  @override
  String get no_location_found => '위치를 찾을 수 없습니다';

  @override
  String get not_found => '찾을 수 없음:';

  @override
  String get refreshing_product => '상품 새로고치는 중...';

  @override
  String get product_refreshed => '상품 새로고침 완료';

  @override
  String product_image_accessibility_label(String date) {
    return '$date에 촬영된 이미지';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return '$date에 촬영된 이미지입니다. 이 이미지는 오래되었을 수 있습니다.';
  }

  @override
  String get product_image_outdated => '이 이미지는 오래되었을 수 있습니다.';

  @override
  String get product_image_outdated_explanations_title =>
      '이 이미지는 오래되었을 수 있습니다.';

  @override
  String get product_image_outdated_explanations_content =>
      '이 이미지는 1년 이상 전에 촬영되었습니다.\n**아직 최신 상태인지 확인해 주세요.**\n\n**경고**입니다. 내용이 동일하다면 이 메시지를 무시해도 됩니다.';

  @override
  String product_image_action_replace_photo(String type) {
    return '사진 교체 ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return '사진 추가 ($type)';
  }

  @override
  String get product_image_action_take_new_picture => '새 캡처';

  @override
  String get product_image_action_take_picture => '사진을 촬영';

  @override
  String get product_image_action_from_gallery => '휴대폰 갤러리에서 선택하세요';

  @override
  String get product_image_action_choose_existing_photo => '제품 사진에서 선택하세요';

  @override
  String get product_image_details_label => '사진에 대한 정보';

  @override
  String get product_image_details_from_producer => '프로듀서로부터';

  @override
  String get product_image_details_contributor => '기여자';

  @override
  String get product_image_details_contributor_producer => '기여자(프로듀서)';

  @override
  String get product_image_details_date => '날짜';

  @override
  String get product_image_details_date_unknown => '알 수 없음';

  @override
  String get homepage_main_card_logo_description =>
      'Open Food Facts에 오신 것을 환영합니다';

  @override
  String get homepage_main_card_subheading => '**바코드를 스캔**하거나\n제품을 **검색**하세요.';

  @override
  String get homepage_main_card_search_field_hint => '제품 검색';

  @override
  String get homepage_main_card_search_field_tooltip => '검색 시작';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return '최신 뉴스: $news_title';
  }

  @override
  String get tagline_app_review => '이 앱이 마음에 드시나요?';

  @override
  String get tagline_app_review_button_positive => '최고에요! 😍';

  @override
  String get tagline_app_review_button_negative => '별로...';

  @override
  String get tagline_app_review_button_later => '나중에 물어봐 주세요';

  @override
  String get tagline_feed_news_button => '더 알아보세요';

  @override
  String get app_review_negative_modal_title => '저희 앱이 맘에 안드세요?';

  @override
  String get app_review_negative_modal_text => '잠시 시간을 내어 이유를 말씀해 주실래요?';

  @override
  String get app_review_negative_modal_positive_button => '예, 물론입니다!';

  @override
  String get app_review_negative_modal_negative_button => '아니요';

  @override
  String get could_not_refresh => '상품을 새로고침할 수 없음';

  @override
  String get product_internet_error_modal_title => '오류가 발생했습니다!';

  @override
  String product_internet_error_modal_message(String error) {
    return '네트워크 오류로 인해 이 제품에 대한 정보를 가져올 수 없습니다. 인터넷 연결을 확인하고 다시 시도해 주세요.\n\n내부 오류:\n$error';
  }

  @override
  String get product_tags_title => '제품 특성';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => '속성 없음';

  @override
  String get product_tags_explanation =>
      '제품에 속성(키/값)을 추가하면 제품을 더욱 풍부하게 만드는 데 도움이 됩니다.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => '속성 추가';

  @override
  String get add_edit_tags => '속성 추가 또는 편집';

  @override
  String get edit_tag => '속성 편집';

  @override
  String get remove_tag => '속성 제거';

  @override
  String get tag_key => '재산';

  @override
  String get tag_keys => '속성';

  @override
  String get tag_key_uneditable => '속성(편집 불가)';

  @override
  String get tag_key_input_hint => '속성을 입력하세요';

  @override
  String get tag_value => '값';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => '값을 입력하세요';

  @override
  String get tag_key_item => '재산:';

  @override
  String get tag_value_item => '값:';

  @override
  String get tag_key_explanations => '키는 소문자여야 하며 공백이 없어야 합니다.';

  @override
  String tag_key_already_exists(String property) {
    return '$property 속성을 가진 태그가 이미 존재합니다!';
  }

  @override
  String get product_internet_error => '네트워크 오류로 인해 이 제품에 대한 정보를 가져올 수 없습니다.';

  @override
  String get cached_results_from => '결과 보기:';

  @override
  String get product_search_same_category => '대안을 찾으세요';

  @override
  String get product_search_same_category_short => '비교';

  @override
  String get product_search_same_category_error =>
      '이 기능은 카테고리가 있는 제품에만 사용할 수 있습니다.\n\n카테고리를 추가하려면 제품을 편집하세요.';

  @override
  String get product_improvement_add_category =>
      'Nutri-Score를 계산할 카테고리를 추가하세요.';

  @override
  String get product_improvement_add_nutrition_facts => '영양 성분을 추가하여 영양 점수 계산';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      '영양 성분을 추가하여 영양 점수 계산';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      '이 제품의 Nutri-Score를 계산할 수 없습니다. 예를 들어 비표준 카테고리 때문일 수 있습니다. 이것이 오류로 간주되면 당사에 문의하십시오.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      '영양 이미지가 더 이상 사용되지 않습니다. 새로고침하세요.';

  @override
  String get product_improvement_origins_to_be_completed =>
      '그린 스코어는 재료의 원산지를 고려합니다. 재료 목록 및/또는 지리적 표시를 사진으로 촬영하시거나 제품 정보를 수정하여 반영해 주시기 바랍니다.';

  @override
  String get country_chooser_label => '국가를 선택하십시오';

  @override
  String get currency_chooser_label => '통화를 선택해주세요';

  @override
  String get country_change_message => '방금 국가를 변경했습니다.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return '통화를 $previousCurrency 에서 $possibleCurrency로 변경하시겠습니까?';
  }

  @override
  String get onboarding_country_chooser_label => '국가를 선택해 주세요:';

  @override
  String get country_chooser_label_from_settings => '당신의 나라';

  @override
  String get country_selection_explanation => '일부 환경 기능은 위치에 따라 다릅니다.';

  @override
  String get product_removed_comparison => '비교에서 제거된 제품';

  @override
  String get native_app_settings => '네이티브 앱 설정';

  @override
  String get native_app_description => 'Open Food Facts에 대한 개방형 시스템 설정';

  @override
  String get product_removed_history => '기록에서 제거된 제품';

  @override
  String get product_removed_list => '제품이 목록에서 제거되었습니다.';

  @override
  String get product_could_not_remove => '상품을 제거할 수 없음';

  @override
  String get no_prodcut_in_list => '목록에 상품이 없습니다';

  @override
  String get no_product_in_section => '이 섹션에는 상품이 없습니다';

  @override
  String get recently_seen_products => '본 모든 상품';

  @override
  String get clear => '지우기';

  @override
  String get clear_long => '목록을 비우세요';

  @override
  String get really_clear => '정말로 목록을 삭제하시겠습니까?';

  @override
  String pct_match(Object percent) {
    return '$percent% 일치';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 일 전',
      one: '하루 전',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 시간 전',
      one: '한 시간 전',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 분 전',
      one: '1분 전',
      zero: '1분 이내',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 몇 달 전',
      one: '한 달 전',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 몇 주 전',
      one: '일주일 전',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '비교 $count 제품',
      one: '하나의 제품 비교',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 선택된 제품이 하나 있습니다',
      one: '선택된 제품이 하나 있습니다',
      zero: '선택된 제품이 없습니다',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => '선택한 제품을 비교하세요';

  @override
  String get delete_products_mode => '선택한 제품 삭제';

  @override
  String get select_all_products_mode => '모든 제품을 선택하세요';

  @override
  String get select_none_products_mode => '선택하지 마세요';

  @override
  String get compare_products_appbar_title => '제품 비교';

  @override
  String get compare_products_appbar_subtitle => '하나 이상의 옵션을 선택하십시오.';

  @override
  String get retry_button_label => '다시 시도';

  @override
  String get connect_with_us => '소통하기';

  @override
  String get tiktok => 'TikTok에서 우리를 팔로우하세요';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => '인스타그램에서 팔로우하세요';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'X(이전 Twitter)에서 우리를 팔로우하세요';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Mastodon에서 우리를 팔로우하세요';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'BlueSky에서 우리를 팔로우하세요';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => '블로그';

  @override
  String get faq => '자주 묻는 질문';

  @override
  String get discover => '둘러보기';

  @override
  String get how_to_contribute => '기여하는 방법';

  @override
  String get hint_knowledge_panel_message =>
      '카드의 아무 부분이나 눌러서 상세 정보를 볼 수 있습니다. 지금 해보세요!';

  @override
  String get permissions_page_title => '카메라 액세스';

  @override
  String get permissions_page_body1 => '휴대전화의 카메라로 바코드를 스캔하려면 접근을 승인하세요.';

  @override
  String get permissions_page_body2 =>
      '마음이 바뀌면 언제든지 설정에서 이 옵션을 활성화하거나 비활성화할 수 있습니다.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return '운영체제: Android (SDK Int: $sdkInt / Release: $release)\n모델: $model\n제품: $product\n기기: $device\n브랜드:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return '운영체제: iOS ($version)\n모델: $model\n현지화 모델: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\n앱 버전:$appVersion\n앱 빌드 번호:$appBuildNumber\n앱 패키지 이름:$appPackageName';
  }

  @override
  String get authorize_button_label => '허가';

  @override
  String get refuse_button_label => '거절';

  @override
  String get ask_me_later_button_label => '다음에';

  @override
  String get are_you_sure => '정말이에요?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return '$sourceName에서 더 나아가세요';
  }

  @override
  String get onboarding_home_welcome_text1 => '환영 !';

  @override
  String get onboarding_home_welcome_text2 =>
      '**당신**과 **지구**에 좋은 음식을 선택하는 데 도움이 되는 앱입니다!';

  @override
  String get onboarding_continue_button => '계속하기';

  @override
  String get onboarding_welcome_loading_dialog_title => '첫 예시 상품 불러오는 중';

  @override
  String get onboarding_welcome_warning =>
      '죄송합니다. 이는 예시 제품이기 때문에 편집할 수 없습니다 :)';

  @override
  String get product_list_your_ranking => '내 순위';

  @override
  String get product_list_empty_icon_desc => '내역 없음';

  @override
  String get product_list_empty_title => '스캐닝을 시작하세요';

  @override
  String get product_list_empty_message =>
      '스캔한 상품이 여기에 표시되며 해당 상품에 대한 자세한 정보를 확인할 수 있습니다';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '제품',
      one: '제품',
      zero: '제품',
    );
    return '기록에 있는 $_temp0 을 새로 고침합니다.';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '제품',
      one: '제품',
      zero: '제품',
    );
    return '$_temp0 새로 고침 완료';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => '데이터 다운로드 중';

  @override
  String get loading_dialog_default_error_message => '데이터를 다운로드할 수 없음';

  @override
  String get account_delete => '계정 삭제';

  @override
  String get account_delete_title => '내 계정 삭제';

  @override
  String get user_profile => '계정';

  @override
  String get user_profile_title_guest => '환영합니다!';

  @override
  String get user_profile_subtitle_guest =>
      'Open Food Facts 커뮤니티에 가입하려면 로그인하거나 가입하세요.';

  @override
  String user_profile_title_id_email(String email) {
    return '오픈 푸드 팩트 로그인: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return '$id님, 환영합니다!';
  }

  @override
  String get email_subject_account_deletion => '계정 삭제';

  @override
  String email_body_account_deletion(String userId) {
    return '안녕하세요, 제 Open Food Facts 계정을 삭제해 주세요: $userId';
  }

  @override
  String get settings_app_app => '애플리케이션';

  @override
  String get settings_app_data => '개인정보 및 추적';

  @override
  String get settings_app_camera => '카메라';

  @override
  String get settings_app_products => '제품';

  @override
  String get settings_app_miscellaneous => '기타';

  @override
  String get camera_play_sound_title => '스캔 시 소리 재생';

  @override
  String get camera_play_sound_subtitle => '스캔을 성공할 때마다 신호음이 울립니다';

  @override
  String get camera_window_accessibility_label => '카메라로 바코드를 스캔하세요';

  @override
  String get app_haptic_feedback_title => '진동 및 햅틱';

  @override
  String get app_haptic_feedback_subtitle =>
      '일부 작업 실행 후 진동(바코드 디코딩됨, 제품 제거됨…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      '이 기능을 활성화하면 충돌 보고서가 Open Food Facts의 오류 추적 시스템에 자동으로 제출되어 버그를 수정하고 앱을 개선할 수 있습니다.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => '사진 편집';

  @override
  String get permission_photo_error => '오류';

  @override
  String get permission_photo_denied_title => '카메라를 사용하여 바코드를 스캔하도록 허용';

  @override
  String permission_photo_denied_message(String appName) {
    return '향상된 경험을 위해 $appName 카메라에 액세스하도록 허용하십시오. 바코드를 직접 스캔할 수 있습니다.';
  }

  @override
  String get permission_photo_denied_button => '허용';

  @override
  String get permission_photo_denied_dialog_settings_title => '권한 거부됨';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      '이전에 카메라 권한을 거부했으므로 설정에서 수동으로 허용해야 합니다.';

  @override
  String get permission_photo_denied_dialog_settings_button_open => '설정 열기';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => '취소';

  @override
  String get permission_photo_none_found => '카메라가 감지되지 않았습니다';

  @override
  String get permission_photo_denied => '카메라 접근 권한 없음';

  @override
  String get show_product_pictures => '제품 사진 보기';

  @override
  String get edit_product_label => '제품 정보 편집';

  @override
  String get edit_product_pending_operations_banner_title => '편집 내용 업로드…';

  @override
  String get edit_product_pending_operations_banner_message =>
      '편집 내용은 **백그라운드에서 전송**됩니다(오류가 발생한 경우에는 나중에 전송).\n다른 제품 필드 편집을 계속할 수 있습니다.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      '귀하의 편집 내용은 **백그라운드에서 전송**되고 있습니다(오류가 발생한 경우에는 나중에 전송).';

  @override
  String get edit_product_label_short => '수정';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\"을 입력하는 방법은?';
  }

  @override
  String get edit_product_form_item_error_empty => '비어 있지 않은 값을 입력하세요!';

  @override
  String get edit_product_form_item_error_existing => '이 값은 이미 존재합니다!';

  @override
  String get edit_product_form_item_add_action_brand => '새로운 브랜드 추가';

  @override
  String get edit_product_form_item_add_action_label => '새로운 라벨 추가';

  @override
  String get edit_product_form_item_add_action_store => '새로운 매장 추가';

  @override
  String get edit_product_form_item_add_action_origin => '새로운 원점 추가';

  @override
  String get edit_product_form_item_add_action_emb_code => '새로운 추적 코드 추가';

  @override
  String get edit_product_form_item_add_action_country => '새로운 국가 추가';

  @override
  String get edit_product_form_item_add_action_category => '새로운 카테고리를 추가하세요';

  @override
  String get edit_product_form_item_add_action_trace => '새로운 추적 추가';

  @override
  String get edit_product_form_item_add_suggestion => '제안 추가';

  @override
  String get edit_product_form_item_deny_suggestion => '제안 거부';

  @override
  String get edit_product_form_item_details_title => '기본 정보';

  @override
  String get edit_product_form_item_details_subtitle => '상품 이름, 브랜드, 양';

  @override
  String get edit_product_form_item_other_details_title => '추가 정보';

  @override
  String get edit_product_form_item_other_details_subtitle => '웹사이트…';

  @override
  String get edit_product_form_item_photos_title => '사진';

  @override
  String get edit_product_form_item_photos_subtitle => '사진을 추가하거나 변경';

  @override
  String get edit_product_form_item_labels_title => '라벨 및 인증';

  @override
  String get edit_product_form_item_labels_subtitle => '환경, 품질 라벨…';

  @override
  String get edit_product_form_item_labels_hint => '라벨을 입력하세요(예: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => '상표';

  @override
  String get edit_product_form_item_labels_explanation_title => '모범 사례: 라벨';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      '**사실에 기반한** 제품의 모든 특성이며 다른 분야와 다릅니다.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      '뉴트리스코어, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      '벨기에에서 제작, 브르타뉴에서 생산…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      '섬유질이 풍부하고 철분이 풍부합니다…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      '공정무역, 막스 하벨라르…';

  @override
  String get edit_product_form_item_stores_title => '상점';

  @override
  String get edit_product_form_item_stores_hint => '매장을 입력하세요';

  @override
  String get edit_product_form_item_stores_type => '상점';

  @override
  String get edit_product_form_item_stores_explanation_title => '모범 사례: 매장';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      '해당 제품을 구매한 매장을 입력하세요.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 => '월마트';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 => '까르푸';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 => '리들';

  @override
  String get edit_product_form_item_origins_title => '근원';

  @override
  String get edit_product_form_item_origins_hint => '원산지를 입력하세요(예: 독일)';

  @override
  String get edit_product_form_item_origins_type => '국가';

  @override
  String get edit_product_form_item_origins_explanation_title => '모범 사례: 출처';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '**포장에 표시된 원산지 표시**를 추가하세요.\n성분 목록에 직접 표시된 원산지에 대해서는 걱정할 필요가 없습니다.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      '아르헨티나산 소고기';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      '콩은 유럽연합에서 생산되지 않습니다.';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint => '국가를 입력하세요(예: 독일)';

  @override
  String get edit_product_form_item_countries_type => '국가';

  @override
  String get edit_product_form_item_countries_explanations_title => '모범 사례: 국가';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**해당 제품이 널리 판매되는 국가** (외국 제품을 전문으로 취급하는 매장은 제외).';

  @override
  String get edit_product_form_item_emb_codes_title => '생산경로 코드';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      '코드를 입력하세요(예: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => '생산경로 코드';

  @override
  String get edit_product_form_item_emb_help_title => '모범 사례: 추적 코드';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      '이 섹션에서는 **포장 표시**, **식별 표시** 또는 **건강 표시**와 관련된 코드를 입력할 수 있습니다.';

  @override
  String get edit_product_form_item_emb_help_info2_title => '추적 코드의 예';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC 코드**는 유럽 공동체에서 식품 생산자 또는 포장업체를 식별하는 데 사용됩니다.';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **프랑스** 국가 코드\n**72.264.002**: 지리 데이터\n**CE**: 유럽 공동체';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '프랑스에서 사용되는 **EMB 코드**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => '흔적';

  @override
  String get edit_product_form_item_traces_hint => '흔적';

  @override
  String get edit_product_form_item_traces_type => '추적 내용을 입력하세요(예: 콩)';

  @override
  String get edit_product_form_item_categories_title => '카테고리';

  @override
  String get edit_product_form_item_categories_hint => '카테고리';

  @override
  String get edit_product_form_item_categories_type => '카테고리를 입력하세요(예: 오렌지 주스)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      '모범 사례: 카테고리';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**가장 구체적인 카테고리만** 표시하세요.\n상위 카테고리는 자동으로 추가됩니다.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      '카테고리가 누락되었나요?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      '**자동완성에서 카테고리를 사용할 수 없는 경우**, 어쨌든 추가해 주세요.\n이렇게 하면 해당 국가의 Open Food Facts를 개선하는 데 도움이 됩니다.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      '올리브 오일에 담긴 정어리';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      '농축 오렌지 주스';

  @override
  String get edit_product_form_item_exit_title => '저장하지 않고 종료하시겠습니까?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      '페이지를 나가기 전에 변경 사항을 저장하시겠습니까?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      '변경 사항 저장';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      '변경 사항 취소';

  @override
  String get edit_product_form_item_ingredients_title => '성분';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      '화면을 핀치하여 확대/축소';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      '사진을 확대 및 축소합니다';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**핀치 투 줌 제스처**를 사용하면 사진을 확대하거나 축소할 수 있습니다.';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => '추가하기';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip => '먼저 내용을 입력해주세요';

  @override
  String get edit_product_form_item_remove_item_tooltip => '제거';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => '편집 내용을 저장하세요';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip => '편집 취소';

  @override
  String get edit_product_form_item_packaging_title => '재활용 지침 사진';

  @override
  String get edit_product_form_item_nutrition_facts_title => '영양 성분 표시';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      '영양 성분, 알코올 포함...';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      '좋은 관행: 영양 정보';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      '영양가';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      '먼저, **값이 제공되는지** 여부를 선택합니다.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      '영양 성분 표시';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      '그런 다음 **포장에 표시된** 영양 정보를 입력하세요. 영양 정보가 없으면 \"눈\" 아이콘을 클릭하세요.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      '필드가 누락되었나요?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      '항목이 누락된 경우 **더하기\" 아이콘을 클릭**하여 추가할 수 있습니다(예: 비타민 D, 마그네슘…).';

  @override
  String get edit_product_form_save => '수정';

  @override
  String get edit_product_ingredients_photo_title => '재료 사진';

  @override
  String get edit_product_ingredients_list_title => '성분 목록';

  @override
  String get edit_product_packaging_photo_title => '포장 사진';

  @override
  String get edit_product_packaging_list_title => '포장 목록';

  @override
  String get no_data_available => '사용 가능한 데이터가 없습니다';

  @override
  String get product_field_website_title => '웹사이트';

  @override
  String get origins_editing_title => '출처 편집';

  @override
  String get completed_basic_details_btn_text => '기본 세부 정보 완성';

  @override
  String get not_implemented_snackbar_text => '아직 구현되지 않았어요';

  @override
  String get category_picker_page_appbar_text => '카테고리';

  @override
  String get edit_ingredients_extract_ingredients_btn_text => '사진에서 재료 추출하기';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short => '성분 추출';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text => '사진에서\n재료 추출';

  @override
  String get edit_ingredients_loading_photo_btn_text => '사진 로딩 중…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      '왜 이 메시지가 표시되나요?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '\"재료 추출\" 기능을 사용하려면 먼저 사진을 업로드해야 합니다.\n\n몇 초간 기다리시거나 직접 입력해 주세요.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => '사진 새로고침';

  @override
  String get edit_packaging_extract_btn_text => '사진에서 패키지\n추출';

  @override
  String get edit_packaging_extract_btn_text_short => '포장 추출';

  @override
  String get edit_packaging_extracting_btn_text => '사진에서 포장 추출';

  @override
  String get edit_packaging_loading_photo_btn_text => '사진 로딩 중…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      '왜 이 메시지가 표시되나요?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '\"패키징 추출\" 기능을 사용하려면 먼저 사진을 업로드해야 합니다.\n\n몇 초간 기다리거나 직접 입력하세요.';

  @override
  String get edit_packaging_refresh_photo_btn_text => '사진 새로고침';

  @override
  String get edit_ocr_extract_failed => '이미지에서 텍스트를 감지하지 못했습니다.';

  @override
  String get edit_ocr_extract_disabled_title => '사진이 없습니다!';

  @override
  String get edit_ocr_extract_disabled_message =>
      '텍스트 추출 기능을 사용하려면 먼저 사진을 찍어야 합니다.';

  @override
  String get user_list_dialog_new_title => '새 상품 목록';

  @override
  String get user_list_dialog_rename_title => '목록 이름 변경';

  @override
  String get user_list_subtitle_product => '목록';

  @override
  String get user_list_title => '내 목록';

  @override
  String get user_list_add_product => '목록에 제품 추가';

  @override
  String get user_list_button_new => '새로운 목록을 만듭니다';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => '목록에 추가';

  @override
  String get added_to_list_msg => '목록에 추가됨';

  @override
  String get user_list_popup_clear => '기록 지우기';

  @override
  String get user_list_popup_rename => '이름 변경';

  @override
  String get user_list_name_hint => '내 목록';

  @override
  String get user_list_name_error_empty => '이름은 필수 항목입니다';

  @override
  String get user_list_name_error_already => '이미 사용 중인 이름입니다';

  @override
  String get user_list_name_error_same => '같은 이름입니다';

  @override
  String get user_list_name_input_hint => '목록의 이름';

  @override
  String get try_again => '다시 시도';

  @override
  String get there_was_an_error => '오류가 발생했습니다';

  @override
  String category_picker_no_category_found_message(String items) {
    return '$items에 대한 카테고리를 찾을 수 없습니다';
  }

  @override
  String get camera_toggle_camera => '후면 및 전면 카메라 전환';

  @override
  String get camera_toggle_flash => '카메라 플래시를 켜거나 끕니다.';

  @override
  String get camera_enable_flash => '플래시 켜기';

  @override
  String get camera_disable_flash => '플래시 끄기';

  @override
  String get camera_flash_error_dialog_title => '오류가 발생했습니다!';

  @override
  String get camera_flash_error_dialog_message =>
      '플래시 상태를 변경하는 중 오류가 발생했습니다. 스마트폰에서 플래시가 활성화되어 있지 않은지 확인하세요.';

  @override
  String get category_picker_no_category_found_button => '돌아가기';

  @override
  String get user_preferences_item_accessibility_hint =>
      '브라우저나 애플리케이션(설치된 경우)에서 열려면 클릭하세요.';

  @override
  String get dev_preferences_screen_title => '개발자 모드';

  @override
  String get dev_preferences_screen_subtitle => '실험적 기능 및 개발 도구에 액세스하세요';

  @override
  String get dev_preferences_reset_onboarding_title => '온보딩 다시 시작';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      '그런 다음 앱을 다시 시작해야 다시 볼 수 있습니다.';

  @override
  String get dev_preferences_environment_switch_title =>
      'openfoodfacts.org(PROD)와 테스트 환경 간 전환';

  @override
  String get dev_preferences_test_environment_title => '테스트 환경 매개변수';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return '현재 테스트 환경의 기본 URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title => '테스트 환경 호스트';

  @override
  String get dev_preferences_ml_kit_title => 'ML 키트 사용';

  @override
  String get dev_preferences_ml_kit_subtitle => '앱을 재시작해야 합니다';

  @override
  String get dev_preferences_product_additional_features_title =>
      '상품 페이지에 버튼 더 표시';

  @override
  String get dev_preferences_edit_ingredients_title => '지식 패널 버튼으로 재료 편집';

  @override
  String get dev_preferences_export_history_title => '내보내기 기록';

  @override
  String get dev_preferences_export_history_progress_error => '예외';

  @override
  String get dev_preferences_export_history_progress_found => '상품 찾음';

  @override
  String get dev_preferences_export_history_progress_not_found => '상품 없음';

  @override
  String get dev_preferences_export_history_dialog_title => '내보내기 기록';

  @override
  String get dev_preferences_button_positive => '확인';

  @override
  String get dev_preferences_button_negative => '취소';

  @override
  String get dev_preferences_migration_title => 'V1에서 데이터 이전';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return '상태: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done => '성공 / 신규 설치임';

  @override
  String get dev_preferences_migration_status_success => '성공';

  @override
  String get dev_preferences_migration_status_error => '오류';

  @override
  String get dev_preferences_migration_status_in_progress => '진행 중';

  @override
  String get dev_preferences_migration_status_required => '필요 (시작하려면 클릭)';

  @override
  String get dev_preferences_migration_status_not_started => '알 수 없음';

  @override
  String get dev_preferences_import_history_subtitle =>
      '기록을 지우고 거기에 3개의 제품을 넣습니다.';

  @override
  String get dev_preferences_news_custom_url_title => '뉴스에 대한 사용자 정의 URL';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON 파일의 URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => '설정되지 않음';

  @override
  String get dev_preferences_news_provider_status_title => '상태';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return '마지막 새로고침: $date';
  }

  @override
  String get product_type_label_food => '음식';

  @override
  String get product_type_label_beauty => '개인 관리';

  @override
  String get product_type_label_pet_food => '반려동물 사료';

  @override
  String get product_type_label_product => '기타';

  @override
  String get product_type_selection_title => '제품 유형';

  @override
  String get product_type_selection_subtitle => '이 제품의 유형을 선택하세요';

  @override
  String get product_type_selection_empty => '먼저 제품 유형을 선택해야 합니다!';

  @override
  String product_type_selection_already(String productType) {
    return '제품 유형($productType)을 변경할 수 없습니다!';
  }

  @override
  String get prices_app_dev_mode_flag => '제품 페이지의 가격 앱 바로가기';

  @override
  String get prices_app_button => '가격 앱으로 이동';

  @override
  String get prices_website_button => 'Open Prices 웹사이트에서 열기';

  @override
  String get prices_bulk_proof_upload_select => '갤러리에서 직접 가격표 추가';

  @override
  String get prices_bulk_proof_upload_warning => '이미지를 선택하고 나면 편집할 수 없습니다!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      '커뮤니티가 AI가 추출한 가격을 검증할 수 있도록 허용합니다.';

  @override
  String get prices_bulk_proof_upload_subtitle => '여러 가격표';

  @override
  String get prices_bulk_proof_upload_title => '대량 교정 업로드';

  @override
  String get prices_bulk_proof_upload_step_selecting => '파일 선택';

  @override
  String get prices_bulk_proof_upload_step_starting => '업로드 시작';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return '로컬로 파일 #$index/$count복사 중';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return '업로드 준비 중 #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return '이미지 #$index/$count에서 실패했습니다.';
  }

  @override
  String get prices_generic_title => '물가';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 가격 추가',
      one: '가격 추가',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 가격 보내기',
      one: '가격 보내기',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => '아이템 추가';

  @override
  String get prices_add_a_price => '가격 추가';

  @override
  String get prices_add_a_receipt => '영수증 추가';

  @override
  String get prices_add_price_tags => '가격표 추가';

  @override
  String prices_barcode_already(String barcode) {
    return '이 바코드($barcode)는 이미 목록에 있습니다!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => '아직 상품이 없습니다';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcode을(를) 찾고 있습니다';
  }

  @override
  String get prices_barcode_enter => '바코드를 입력하세요';

  @override
  String get prices_category_enter => '바코드가 없는 품목';

  @override
  String get prices_per_kilogram => '킬로그램당 가격';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / 단위';

  @override
  String get prices_category_mandatory => '필수';

  @override
  String get prices_category_optional => '선택 과목';

  @override
  String get prices_category_error_mandatory => '카테고리는 필수입니다';

  @override
  String get prices_barcode_reader_action => '바코드 리더기';

  @override
  String get prices_view_prices => '가격 보기';

  @override
  String get prices_list_title => '가격표';

  @override
  String get prices_list_count => '\n가격의 개수';

  @override
  String get prices_list_add_new_price => '\n새로운 가격을 추가합니다';

  @override
  String get prices_list_empty_title => '아직 가격이 없습니다!';

  @override
  String get prices_list_empty_subtitle =>
      '가장 먼저 하나를 추가하세요:\n**영수증**이나 **가격표**를 스캔하세요!';

  @override
  String get prices_entry_shop_not_found => '알 수 없는 매장';

  @override
  String prices_entry_menu_title(String user) {
    return '\"$user\"에서 가격 입력';
  }

  @override
  String get prices_entry_menu_open_product_prices => '이 제품의 모든 가격 보기';

  @override
  String get prices_entry_menu_open_proof => '증거 보기';

  @override
  String get prices_entry_menu_my_prices => '다른 가격 보기';

  @override
  String get prices_entry_menu_author_prices => '저자의 다른 가격 보기';

  @override
  String get prices_entry_menu_shop_prices => '상점의 다른 가격 보기';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 가격',
      one: '1 가격',
    );
    return '$_temp0 $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '모든 $count 가격',
      one: '가격은 하나뿐입니다',
      zero: '아직 가격이 없습니다',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return '최신 $pageSize 가격 (총: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return '가격: $price / 매장: \"$location\" / \"$user\"에서 $date 에 게시됨';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '\"$user\"의 공개 증명';
  }

  @override
  String get prices_open_proof => '오픈 가격 증명';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '모든 $count 증명',
      one: '증명은 하나뿐입니다',
      zero: '아직 증명이 없습니다',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return '최신 $pageSize 교정본 (총: $total)';
  }

  @override
  String get prices_users_empty_title => '아직 기여자가 없습니다!';

  @override
  String get prices_users_empty_explanation => '가격을 최초로 추가하세요!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return '상위 $pageSize 기여자 (총: $total)';
  }

  @override
  String get prices_locations_empty_title => '아직 가게가 없습니다!';

  @override
  String get prices_locations_empty_explanation => '가격을 최초로 추가하세요!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return '상위 $pageSize 개 위치(총: $total개)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 증명 여러 개',
      one: '증명 하나',
      zero: '증명 없음',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 제품',
      one: '제품 1개',
      zero: '제품 없음',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 사용자',
      one: '사용자 1명',
      zero: '사용자 없음',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 가격',
      one: '가격 하나',
      zero: '가격 없음',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => '이전에 추가된 가격';

  @override
  String get prices_amount_subtitle => '양';

  @override
  String get prices_amount_is_discounted => '할인되나요?';

  @override
  String get prices_amount_price_normal => '가격';

  @override
  String get prices_amount_price_discounted => '할인된 가격';

  @override
  String get prices_amount_price_not_discounted => '원래 가격';

  @override
  String get prices_amount_no_product => '제품 하나가 빠졌습니다!';

  @override
  String get prices_amount_price_incorrect => '잘못된 값';

  @override
  String get prices_amount_price_mandatory => '필수 값';

  @override
  String get prices_currency_subtitle => '통화';

  @override
  String get prices_date_subtitle => '날짜';

  @override
  String get prices_location_subtitle => '가게';

  @override
  String get prices_location_find => '가게 찾기';

  @override
  String get prices_location_mandatory => '가게를 선택해야 합니다!';

  @override
  String get prices_location_search_broader =>
      '원하시는 내용을 찾지 못하셨나요? 더 광범위하게 검색해 보세요!';

  @override
  String get prices_proof_subtitle => '증거';

  @override
  String get prices_proof_empty_title => '아직 증거가 없습니다!';

  @override
  String get prices_proof_empty_explanation =>
      '**영수증**이나 **가격표** 사진을 첨부하여 시작하세요!';

  @override
  String get prices_proof_find => '증거를 선택하세요';

  @override
  String get prices_proof_change => '변경 증명';

  @override
  String get prices_proof_receipt => '영수증';

  @override
  String get prices_proof_price_tag => '가격표';

  @override
  String get prices_proof_mandatory => '증거를 선택해야 합니다!';

  @override
  String get prices_add_validation_error => '검증 오류';

  @override
  String get prices_privacy_warning_title => '개인정보 보호 경고';

  @override
  String get prices_unknown_product => '알 수 없는 제품';

  @override
  String get prices_privacy_warning_main_message =>
      '가격은 **공개됩니다**. 해당 가격이 언급하는 매장도 함께 공개됩니다.\n\n이를 통해 Open Food Facts 가명을 아는 사람들이 다음을 수행할 수 있습니다.\n';

  @override
  String get prices_privacy_warning_message_bullet_1 => '당신이 사는 지역을 추론해보세요';

  @override
  String get prices_privacy_warning_message_bullet_2 => '무엇을 사는지 알아보세요';

  @override
  String get prices_privacy_warning_sub_message =>
      '해당 사항이 불편하시다면 가명을 변경하시거나 새로운 Open Food Facts 계정을 만들어 앱에 로그인해 주세요.';

  @override
  String get i_refuse => '나는 거부한다';

  @override
  String get i_accept => '나는 받아들인다';

  @override
  String get prices_currency_change_proposal_title => '통화를 변경하시겠습니까?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return '현재 통화는 **$currency**입니다. **$newCurrency**로 변경하시겠습니까?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return '네, $newCurrency를 사용하세요';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return '아니요, $currency를 유지하세요';
  }

  @override
  String get prices_menu_know_more => '오픈 가격에 대해 자세히 알아보세요';

  @override
  String get dev_preferences_import_history_result_success => '완료';

  @override
  String get dev_mode_section_server => '서버 구성';

  @override
  String get dev_mode_section_news => '뉴스 제공자 구성';

  @override
  String get dev_mode_section_product_page => '제품 페이지';

  @override
  String get dev_mode_section_ui => '사용자 인터페이스';

  @override
  String get dev_mode_section_experimental_features => '실험적 특징';

  @override
  String get dev_mode_hide_environmental_score_title => '그린 스코어 제외';

  @override
  String get dev_mode_spellchecker_for_ocr_title => 'OCR 화면에 맞춤법 검사기 사용';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(재료 및 포장)';

  @override
  String get dev_mode_reset_app_language_title => '앱 언어 재설정';

  @override
  String get dev_mode_add_demo_cards_language_title => '카드 추가';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org(PROD)와 테스트 환경 간 전환';

  @override
  String get search_history_item_edit_tooltip => '이 검색을 재사용하고 편집하세요';

  @override
  String get search_history_item_remove_tooltip => '제거';

  @override
  String product_search_no_more_results(int totalSize) {
    return '$totalSize 개 제품을 모두 다운로드했습니다.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '더 많은 제품 $count 개 다운로드\n이미 $totalSize중 $downloaded 다운로드했습니다.';
  }

  @override
  String product_search_loading_message(Object search) {
    return '$search 검색이 진행 중입니다.\n\n몇 초간 기다려 주세요.…';
  }

  @override
  String get user_search_contributor_title => '내가 추가한 상품';

  @override
  String get user_search_informer_title => '내가 편집한 상품';

  @override
  String get user_search_photographer_title => '내가 사진을 추가한 상품';

  @override
  String get user_search_to_be_completed_title => '내 미완성 상품';

  @override
  String get user_search_prices_title => '내 가격';

  @override
  String get user_search_proofs_title => '내 증거';

  @override
  String get user_search_proof_title => '내 증거';

  @override
  String search_proof_title(String user) {
    return '\"$user\"의 증명';
  }

  @override
  String user_any_search_prices_title(String user) {
    return '기여자 가격: $user';
  }

  @override
  String get all_search_prices_latest_title => '최신 가격 추가됨';

  @override
  String get all_search_prices_top_user_title => '최고 가격 기여자';

  @override
  String get all_search_prices_top_location_title => '가장 가격이 비싼 매장';

  @override
  String get prices_contribution_assistant => '가격 기여 지원자';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => '여러 개의 증명 추가';

  @override
  String get all_search_prices_top_location_single_title => '매장의 가격';

  @override
  String get all_search_prices_top_product_title => '가장 가격이 비싼 상품';

  @override
  String get all_search_to_be_completed_title => '모든 미완성 상품';

  @override
  String get categorize_products_country_title =>
      '귀하의 국가에서 제품을 분류하는 데 도움이 됩니다.';

  @override
  String get edit_product_action_retake_picture => '사진 재촬영';

  @override
  String get edit_product_action_take_picture => '사진 촬영';

  @override
  String get edit_product_action_confirm => '확인';

  @override
  String get signup_page_terms_of_use_line1 => '저는 Open Food Facts에 동의합니다. ';

  @override
  String get signup_page_terms_of_use_line2 => '이용 및 기여 약관';

  @override
  String get analytics_consent_image_semantic_label => '분석 아이콘';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return '심각한 오류 발생: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return '심각한 오류 발생: $error';
  }

  @override
  String get summary_card_button_add_basic_details => '기본 세부 정보 완성';

  @override
  String get edit_photo_button_label => '수정';

  @override
  String get edit_photo_unselect_button_label => '사진 선택 해제';

  @override
  String get edit_photo_select_existing_button_label => '기존 이미지를 선택하세요';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle => '이미지를 클릭하여 선택하세요';

  @override
  String get edit_photo_select_existing_download_label => '기존 이미지 검색…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      '이 제품과 관련하여 이전에 업로드된 이미지가 없습니다.';

  @override
  String get edit_photo_language_not_this_one => '아직 해당 언어로 된 이미지가 없습니다.';

  @override
  String get edit_photo_language_none => '아직 이미지가 없습니다';

  @override
  String get category_picker_screen_title => '카테고리';

  @override
  String get basic_details => '기본 정보';

  @override
  String get product_name => '상품 이름';

  @override
  String get product_names => '제품 이름';

  @override
  String get add_basic_details_product_name_add_translation => '새로운 번역 추가';

  @override
  String get add_basic_details_product_name_warning_translations =>
      '검증하기 전에 **패키지에 해당 언어가 있는 경우에만** 번역을 추가해야 합니다.';

  @override
  String get add_basic_details_product_name_open_photo => '정면 사진 보기';

  @override
  String get add_basic_details_product_name_take_photo => '정면 사진 찍기';

  @override
  String get add_basic_details_product_name_hint => '제품명을 입력하세요 (예: 누텔라)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      '기본 언어를 변경하시겠습니까?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return '제품의 기본 언어를 \'$language\'로 설정하시겠습니까?';
  }

  @override
  String get explanation_section_good_examples => '좋은 예';

  @override
  String get explanation_section_bad_examples => '나쁜 예';

  @override
  String get add_basic_details_product_name_help_title => '우수 사례: 제품 이름';

  @override
  String get add_basic_details_product_name_help_info1 =>
      '제품명은 **포장에 인쇄된 주요 명칭**입니다. 등록상표가 될 수 있습니다.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**참고:** **패키지에 해당 언어가 없는 경우** 번역을 추가하지 마십시오.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => '네스퀵';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => '토마토 케첩';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      '이름에 브랜드를 포함하지 마세요';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      '토마토 케첩 **Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '®, ™, © 또는 이와 유사한 기호를 사용하지 마십시오.';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      '네스퀵**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 다른 번역',
      one: '$count 다른 번역',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => '브랜드 이름';

  @override
  String get brand_names => '브랜드 이름';

  @override
  String get add_basic_details_brand_name_error => '브랜드 이름을 입력하세요';

  @override
  String get add_basic_details_brand_names_hint => '입력 브랜드(예: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title => '우수 사례: 브랜드';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      '**제품의 모든 브랜드**를 입력하세요.';

  @override
  String get add_basic_details_product_brand_help_info2_title => '주요 브랜드';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**주요 브랜드**는 일반적으로 앞면에 명확하게 표시되며, **먼저 입력**해야 합니다.';

  @override
  String get add_basic_details_product_brand_help_info3_title => '다른 브랜드';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      '**대기업**에서 판매 시:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel**은 **Danone**에서 판매합니다.';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      '**여러 언어로 번역된 브랜드와 함께 판매되는 경우**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley**는 때때로 **Val Nature**로 표기됩니다.';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => '누텔라';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      '오레오, 몬델레즈';

  @override
  String get quantity => '수량 및 무게';

  @override
  String get add_basic_details_quantity_hint =>
      '무게를 입력하고 필요한 경우 수량을 입력하세요(예: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title => '모범 사례: 수량';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      '제품에 표시된 값을 복사하고 **단위를 잊지 마세요**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** 또는 **230g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (계란 6개)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(각 150g씩 3개 상자로 구성된 제품의 경우)';

  @override
  String get barcode => '바코드';

  @override
  String barcode_barcode(String barcode) {
    return '바코드: $barcode';
  }

  @override
  String get barcode_invalid_error => '잘못된 바코드';

  @override
  String get basic_details_add_success => '기본 정보를 성공적으로 추가했습니다';

  @override
  String get basic_details_add_error => '기본 정보를 추가할 수 없습니다. 나중에 다시 시도해주세요';

  @override
  String get clear_search => '검색을 지우세요';

  @override
  String get confirm_clear => '전체 내역을 삭제하려고 합니다. 계속하시겠습니까?';

  @override
  String get alert_clear_selected_user_list => '기록에서 선택한 항목을 지우려고 합니다.';

  @override
  String get confirm_clear_selected_user_list => '계속하시겠습니까?';

  @override
  String get alert_select_items_to_clear => '지우려면 하나 이상의 항목을 선택하세요';

  @override
  String confirm_clear_user_list(String name) {
    return '목록($name)을 비우려고 합니다. 정말로 계속하시겠습니까?';
  }

  @override
  String get confirm_delete_user_list_title => '목록을 삭제하시겠습니까?';

  @override
  String confirm_delete_user_list_message(String name) {
    return '\"$name\" 목록을 삭제하려고 합니다.\n계속하시겠습니까?';
  }

  @override
  String get confirm_delete_user_list_button => '네, 확인합니다';

  @override
  String importance_label(String name, String id) {
    return '$name 중요도: $id';
  }

  @override
  String get user_list_all_title => '목록';

  @override
  String get user_list_all_empty => '첫 목록 만들기';

  @override
  String get product_list_select => '목록을 선택하세요';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '상품 $count개',
      one: '상품 1개',
      zero: '목록이 비었어요',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => '목록 추가';

  @override
  String get open_food_preferences_tooltip => '선호하는 음식 편집';

  @override
  String get add_photo_button_label => '사진 추가';

  @override
  String get add_packaging_photo_button_label => '모든 포장/재활용 정보의 사진을 찍으세요';

  @override
  String get add_origin_photo_button_label => '원산지 정보의 사진을 찍으세요';

  @override
  String get add_emb_photo_button_label => '추적 코드 정보의 사진을 찍으세요';

  @override
  String get add_label_photo_button_label => '모든 라벨 및 인증 정보의 사진을 찍으세요';

  @override
  String get choose_image_source_title => '사진 소스 선택';

  @override
  String get choose_image_source_body => '사진 소스를 선택해주세요';

  @override
  String get gallery_source_label => '갤러리';

  @override
  String get gallery_source_access_denied_dialog_title => '접근 불가';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      '안타깝게도 이전에 권한을 거부했기 때문에 앱에서 갤러리에 액세스할 수 없습니다.\n\n휴대폰의 앱 설정 -> 사진으로 이동하세요.';

  @override
  String get gallery_source_access_denied_dialog_button => '설정을 엽니다';

  @override
  String get share => '공유하기';

  @override
  String share_product_text(String url) {
    return 'Open Food Facts에서 이 제품을 살펴보세요: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Open Beauty Facts에서 이 제품을 살펴보세요: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Open PetFood Facts에서 이 제품을 살펴보세요: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Open Products Facts에서 이 제품을 살펴보세요: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Open Food Facts에서 내 제품 목록을 확인하세요: $url';
  }

  @override
  String get capture => '새 캡처';

  @override
  String get capture_new_picture => '사진을 촬영';

  @override
  String get choose_from_gallery => '갤러리에서 선택';

  @override
  String get image_upload_queued => '이미지는 가능한 한 빨리 백그라운드에 업로드됩니다.';

  @override
  String get add_price_queued => '가격은 최대한 빨리 서버로 전송됩니다.';

  @override
  String get background_task_title_full_refresh =>
      '로컬에 저장된 모든 제품의 새로 고침을 시작합니다.';

  @override
  String get background_task_title_top_n => '가장 인기 있는 상품 다운로드 시작';

  @override
  String get expand_nutrition_facts => '영양 성분표 확장';

  @override
  String get expand_nutrition_facts_body => '영양 성분표를 확장한 채로 유지';

  @override
  String get expand_ingredients => '재료 목록 확장';

  @override
  String get expand_ingredients_body => '재료 패널을 확장한 채로 유지';

  @override
  String get no_internet_connection => '인터넷 연결 없음';

  @override
  String get world_results_label => '전 세계';

  @override
  String get world_results_action => '검색을 세계로 확장';

  @override
  String get copy_to_clipboard => '복사';

  @override
  String get paste_from_clipboard => '클립보드에서 붙여넣기';

  @override
  String get no_data_available_in_clipboard => '클립보드에 사용 가능한 데이터가 없습니다.';

  @override
  String get clipboard_barcode_copy => '바코드를 클립보드에 복사';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return '$barcode 바코드를 클립보드에 복사했습니다!';
  }

  @override
  String get open_product_website => '이 제품을 웹사이트에서 열어보세요';

  @override
  String get language_picker_label => '당신의 언어';

  @override
  String get country_picker_label => '당신의 나라';

  @override
  String get currency_picker_label => '귀하의 통화';

  @override
  String get help_with_openfoodfacts => 'OpenFoodFacts 도움말';

  @override
  String get product_task_background_schedule => '이미지는 가능한 한 빨리 백그라운드에 업로드됩니다.';

  @override
  String get no_email_client_available_dialog_title => '이메일 앱은 필요 없습니다!';

  @override
  String get no_email_client_available_dialog_content =>
      'mobile@openfoodfacts.org로 수동으로 이메일을 보내주세요.';

  @override
  String get all_images => '모든 이미지';

  @override
  String get selected_images => '이미지 선택하기';

  @override
  String get product_card_remove_product_tooltip => '제품 제거';

  @override
  String scan_announce_new_barcode(String barcode) {
    return '스캔된 새 바코드: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip => '캐러셀에서 모든 제품을 제거합니다.';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      '최소 두 개의 제품을 스캔하여 비교하세요.';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      '스캔한 제품을 비교하려면 클릭하세요';

  @override
  String get scan_product_loading => '\n바코드를 스캔했습니다.';

  @override
  String get scan_product_loading_initial => '이 상품을 찾고 있습니다!\n잠시만 기다려 주세요…';

  @override
  String get scan_product_loading_long_request =>
      '아직 이 제품을 찾고 있습니다!\n로딩 시간이 오래 걸리시나요? 저희도 그렇죠.…';

  @override
  String get scan_product_loading_unresponsive =>
      '아직 해당 상품을 찾고 있습니다.\n검색을 다시 시작하시겠습니까?';

  @override
  String get scan_product_loading_restart_button => '검색을 다시 시작하세요';

  @override
  String get portion_calculator_description => '특정 수량에 대한 영양 정보 계산';

  @override
  String get portion_calculator_hint => '수량';

  @override
  String get portion_calculator_accessibility => '영양성분을 계산하려면 수량을 입력하세요';

  @override
  String portion_calculator_error(int min, int max) {
    return '$min ~ $max g 사이의 수량을 입력하세요.';
  }

  @override
  String get portion_calculator_computation_error =>
      '데이터가 누락되어 계산을 수행할 수 없습니다.';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams (또는 ml)의 영양 성분';
  }

  @override
  String get offline_data => '오프라인 데이터';

  @override
  String get ocr_image_upload_instruction => '포함된 정보를 자동으로 추출하려면 이미지를 업로드하세요.';

  @override
  String get upload_image => '사진 업로드';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => '이미지 다운로드를 실패했습니다.';

  @override
  String get image_edit_url_error => '이미지 URL이 설정되지 않아 이미지를 수정하지 못했습니다.';

  @override
  String get user_picture_source_remember => '선택 사항 기억하기';

  @override
  String get user_picture_source_ask => '매번 물어보세요';

  @override
  String get robotoff_continue => '계속하기';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 질문',
      one: '질문',
    );
    return '다음 $_temp0';
  }

  @override
  String get show_password => '비밀번호 표시';

  @override
  String get owner_field_info_title => '생산자가 제공한 값';

  @override
  String get owner_field_info_message =>
      '해당 로고에서는 제작자가 제공한 데이터를 강조 표시하며, 편집이 불가능할 수 있습니다.';

  @override
  String get owner_field_info_close_button => '이 정보를 닫습니다';

  @override
  String get owner_field_image => '이 이미지는 제작자가 제공한 것입니다. 편집이 불가능할 수 있습니다.';

  @override
  String get edit_packagings_title => '포장 구성 요소';

  @override
  String get edit_packagings_element_add => '포장 구성요소 추가';

  @override
  String get edit_packagings_completed => '포장이 완료되었습니다';

  @override
  String edit_packagings_element_title(int index) {
    return '패키징 구성 요소 #$index';
  }

  @override
  String get edit_packagings_element_field_units => '단위 수';

  @override
  String get edit_packagings_element_hint_units =>
      '제품에 포함된 동일한 모양과 재질의 포장 단위의 수량을 입력하세요.';

  @override
  String get edit_packagings_element_field_shape => '모양';

  @override
  String get edit_packagings_element_hint_shape =>
      '재활용 지침에 나와 있는 모양 이름이 있으면 입력하거나 모양을 선택하세요.';

  @override
  String get edit_packagings_element_example_shape => '병';

  @override
  String get edit_packagings_element_field_material => '재료';

  @override
  String get edit_packagings_element_hint_material =>
      '구체적인 재료가 확인 가능한 경우(삼각형 안의 재료 코드는 종종 포장 부품에서 발견됨) 해당 재료를 입력하거나, 확실하지 않은 경우 일반적인 재료(예: 플라스틱이나 금속)를 입력하세요.';

  @override
  String get edit_packagings_element_example_material => '유리';

  @override
  String get edit_packagings_element_field_recycling => '재활용 지침';

  @override
  String get edit_packagings_element_hint_recycling =>
      '제품에 재활용 지침이 적혀 있는 경우에만 해당 지침을 입력하세요.';

  @override
  String get edit_packagings_element_example_recycling => '재활용';

  @override
  String get edit_packagings_element_field_quantity => '단위당 제품의 순 수량';

  @override
  String get edit_packagings_element_hint_quantity =>
      '순중량이나 순부피를 입력하고 단위(예: g 또는 ml)를 표시하세요.';

  @override
  String get edit_packagings_element_field_weight => '빈 단위 하나의 무게(g)';

  @override
  String get edit_packagings_element_hint_weight =>
      '무게를 측정하기 전에 남은 음식물을 모두 제거하고 포장 부분을 씻어서 말리세요. 가능하면 0.1g 또는 0.01g 단위의 저울을 사용하세요.';

  @override
  String get background_task_title => '보류 중인 기부';

  @override
  String get background_task_subtitle => '귀하의 기여는 자동으로 서버에 저장되지만 항상 실시간은 아닙니다.';

  @override
  String get background_task_list_empty => '보류 중인 백그라운드 작업 없음';

  @override
  String get background_task_error_server_time_out => '서버 시간 초과';

  @override
  String get background_task_error_no_internet =>
      '인터넷 연결 오류가 발생했습니다. 나중에 다시 시도하세요.';

  @override
  String get background_task_operation_unknown => '알 수 없는 작업 유형';

  @override
  String get background_task_operation_details => '자세한 변경 사항';

  @override
  String get background_task_operation_image => '사진 업로드';

  @override
  String get background_task_operation_refresh => '사진 업로드 후 새로고침이 지연됨';

  @override
  String get background_task_run_started => '시작했다';

  @override
  String get background_task_run_not_started => '아직 시작하지 않음';

  @override
  String get background_task_run_to_be_deleted => '삭제될 예정';

  @override
  String get background_task_question_stop => '가능한 한 빨리 그 작업을 중단하고 싶으신가요?';

  @override
  String get feed_back => '피드백';

  @override
  String get undo => '끄르다';

  @override
  String get copy_email_to_clip_board => '이메일을 클립보드에 복사';

  @override
  String get please_send_us_an_email_to => '수동으로 이메일을 보내주세요.';

  @override
  String get email_copied_to_clip_board => '이메일이 클립보드에 복사되었습니다!';

  @override
  String get select_accent_color => '강조색 선택';

  @override
  String get theme_amoled => '아몰레드';

  @override
  String get color_blue => '파란색';

  @override
  String get color_cyan => '시안';

  @override
  String get color_green => '녹색';

  @override
  String get color_light_brown => '기본';

  @override
  String get color_magenta => '마젠타';

  @override
  String get color_orange => '주황색';

  @override
  String get color_pink => '분홍색';

  @override
  String get color_red => '빨간색';

  @override
  String get color_rust => '녹';

  @override
  String get color_teal => '물오리';

  @override
  String get text_contrast_mode => '텍스트 대비';

  @override
  String get contrast_high => '높은';

  @override
  String get contrast_medium => '중간';

  @override
  String get contrast_low => '낮은';

  @override
  String get product_refresher_internet_not_found => '제품을 찾을 수 없습니다!';

  @override
  String get product_refresher_internet_not_connected => '인터넷에 접속되지 않았습니다!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return '서버 다운($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return '서버 오류 ($exception)';
  }

  @override
  String get product_loader_not_found_title => '제품을 찾을 수 없습니다!';

  @override
  String product_loader_not_found_message(String barcode) {
    return '다음 바코드가 있는 제품은 데이터베이스에 없습니다: $barcode';
  }

  @override
  String get product_loader_network_error_title => '인터넷에 연결되지 않았습니다!';

  @override
  String get product_loader_network_error_message =>
      '스마트폰이 WiFi 네트워크에 연결되어 있거나 모바일 데이터가 활성화되어 있는지 확인하세요.';

  @override
  String get page_not_found_title => '페이지를 찾을 수 없습니다!';

  @override
  String get page_not_found_button => '홈페이지로 돌아가기';

  @override
  String get download_data => '데이터 다운로드';

  @override
  String get download_top_products =>
      '귀하의 국가에서 가장 인기 있는 1000개 제품을 다운로드하여 즉시 스캔하세요.';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 제품',
    );
    return '귀하의 국가에서 최고의 $_temp0 을 다운로드하여 즉시 스캔하세요.';
  }

  @override
  String get download_in_progress => '데이터 다운로드 중\n시간이 좀 걸릴 수 있습니다.';

  @override
  String downloaded_products(int num) {
    return '$num 개의 제품이 추가되었습니다.';
  }

  @override
  String get update_offline_data => '오프라인 제품 데이터 업데이트';

  @override
  String get update_local_database_sub =>
      'Open Food Facts의 최신 데이터로 로컬 제품 데이터베이스를 업데이트하세요.';

  @override
  String get clear_local_database => '오프라인 제품 데이터 지우기';

  @override
  String get clear_local_database_sub => '앱에서 모든 로컬 제품 데이터를 지워 공간을 확보하세요.';

  @override
  String deleted_products(int num) {
    return '$num 개의 제품이 삭제되었습니다.';
  }

  @override
  String get loading => '로딩중…';

  @override
  String get know_more => '더 알아보기';

  @override
  String get offline_data_desc => '오프라인 데이터에 대해 자세히 알아보려면 클릭하세요';

  @override
  String get offline_product_data_title => '오프라인 제품 데이터';

  @override
  String available_for_download(int num) {
    return '$num 개 제품을 즉시 스캔할 수 있습니다.';
  }

  @override
  String get country_selector_title => '국가를 선택하세요:';

  @override
  String get currency_selector_title => '통화를 선택하세요:';

  @override
  String get language_selector_title => '언어를 선택하세요:';

  @override
  String get language_selector_section_selected => '선택된 언어';

  @override
  String get language_selector_section_frequently_used => '자주 사용되는';

  @override
  String get action_delete_list => '삭제';

  @override
  String get action_change_list => '현재 목록 변경';

  @override
  String get product_list_create => '만들기';

  @override
  String get product_list_create_tooltip => '새로운 목록을 만듭니다';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => '뉴트리스코어 A';

  @override
  String get nutriscore_b => '뉴트리스코어 B';

  @override
  String get nutriscore_c => '뉴트리스코어 C';

  @override
  String get nutriscore_d => '뉴트리스코어 D';

  @override
  String get nutriscore_e => '뉴트리스코어 E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (새로운 계산)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score(새로운 계산)';

  @override
  String get nutriscore_unknown => '알 수 없는 영양 점수';

  @override
  String get nutriscore_unknown_new_formula => '알 수 없는 Nutri-Score(새로운 계산)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score가 적용되지 않습니다';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score가 적용되지 않습니다. (새로운 계산)';

  @override
  String get environmental_score_generic_new => '친환경 점수';

  @override
  String get environmental_score_a_new => '그린 스코어 A';

  @override
  String get environmental_score_b_new => '그린 스코어 B';

  @override
  String get environmental_score_c_new => '그린 스코어 C';

  @override
  String get environmental_score_d_new => '그린 스코어 D';

  @override
  String get environmental_score_e_new => '그린 스코어 E';

  @override
  String get environmental_score_unknown_new => '알 수 없는 그린 스코어';

  @override
  String get environmental_score_not_applicable_new => 'Green-Score는 적용되지 않습니다';

  @override
  String get nova_group_generic_new => '초가공식품 - NOVA 그룹';

  @override
  String get nova_group_1 => '노바 그룹 1';

  @override
  String get nova_group_2 => '노바 그룹 2';

  @override
  String get nova_group_3 => '노바 그룹 3';

  @override
  String get nova_group_4 => '노바 그룹 4';

  @override
  String get nova_group_unknown => '알 수 없는 NOVA 그룹';

  @override
  String get nutrition_facts => '영양소 수준';

  @override
  String get faq_title_partners => 'NGO의 파트너 및 후원자';

  @override
  String get faq_title_vision => 'Open Food Facts 비전, 사명, 가치 및 프로그램';

  @override
  String get faq_title_install_beauty =>
      '화장품 데이터베이스를 생성하려면 Open Beauty Facts를 설치하세요.';

  @override
  String get faq_title_install_pet =>
      '반려동물 사료 데이터베이스를 생성하려면 Open Pet Food Facts를 설치하세요.';

  @override
  String get faq_title_install_product =>
      '제품 데이터베이스를 생성하여 개체 수명을 연장하려면 Open Products Facts를 설치하세요.';

  @override
  String get faq_nutriscore_nutriscore => 'Nutri-Score의 새로운 계산법: 새로운 점은 무엇인가요?';

  @override
  String get contact_title_pro_page => '찬성? Open Food Facts에서 제품을 가져오세요';

  @override
  String get contact_title_pro_email => '프로듀서 연락처';

  @override
  String get contact_title_press_page => '보도 페이지';

  @override
  String get contact_title_press_email => '언론 연락처';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => '커뮤니티 캘린더 구독하기';

  @override
  String get hunger_games_loading_line1 => '몇 초만 기다려주세요…';

  @override
  String get hunger_games_loading_line2 => '질문을 다운로드 중입니다!';

  @override
  String get hunger_games_error_label => '아아! 오류가 발생해서… 질문을 불러올 수 없습니다.';

  @override
  String get hunger_games_error_retry_button => '다시 시도해 보자!';

  @override
  String get reorder_attribute_action => '속성을 재정렬합니다';

  @override
  String get link_cant_be_opened =>
      '이 링크는 사용 중인 기기에서 열 수 없습니다. 브라우저가 설치되어 있는지 확인하세요.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productName에 대한 세부 정보';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName 과 $productName에 대한 세부 정보';
  }

  @override
  String get guide_title => '가이드';

  @override
  String get guide_share_label => '공유하기';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score는 **식품의 영양적 품질**에 대한 정보를 제공하는 하는 로고입니다.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      '색상 코드는 가장 건강한 제품을 나타내는 짙은 녹색(**A**)부터 덜 건강한 제품을 나타내는 짙은 빨간색(**E**)까지 다양합니다.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      '**너무 달거나** **너무 짠** 제품은 **평가가 더 낮아집니다**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption => '새로운 Nutri-Score 로고';

  @override
  String get guide_nutriscore_v2_where_title =>
      '새로운 Nutri-Score 계산은 어디에서 찾을 수 있나요?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score는 프랑스, 독일, 벨기에, 스페인, 룩셈부르크, 네덜란드, 스위스 등 7개국에서 적용됩니다.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      '제조업체는 법령에 서명한 후 늦어도 **2년** 이내에 기존 계산을 새로운 계산으로 **대체**해야 합니다.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => '변하지 않는 것';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      '제조업체의 경우 Nutri-Score 표시 여부는 **선택 사항**입니다.';

  @override
  String get guide_greenscore_title => '친환경 점수';

  @override
  String get guide_greenscore_what_is_greenscore_title => '그린 스코어란 무엇인가요?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      '그린스코어는 **식품의 환경적 영향**에 대한 정보를 제공하기 위해 만들어진 로고입니다.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      '색상 코드는 **가장 영향이 적은** 제품을 나타내는 진한 녹색(**A+**)부터 **가장 영향이 큰** 제품을 나타내는 진한 빨간색(**F**)까지 다양합니다.';

  @override
  String get guide_greenscore_logos_caption => '그린스코어 로고';

  @override
  String get guide_greenscore_lca_title => '핵심: 수명주기평가(LCA)';

  @override
  String get guide_greenscore_lca_arg1_title => '식품 카테고리에 대한 과학적 평가';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      '각 제품 카테고리에 대해 **벤치마크** 점수는 Agribalyse 환경 데이터베이스(ADEME 및 INRAE에서 설계)의 데이터를 사용하여 설정됩니다.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**생명주기 분석**은 다단계, 다기준 환경 평가를 실시하기 위한 표준화된 평가 방법입니다.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**측정 항목:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6단계 생산';

  @override
  String get guide_greenscore_lca_arg2_agriculture => '농업';

  @override
  String get guide_greenscore_lca_arg2_processing => '처리';

  @override
  String get guide_greenscore_lca_arg2_packaging => '포장';

  @override
  String get guide_greenscore_lca_arg2_transportation => '수송';

  @override
  String get guide_greenscore_lca_arg2_distribution => '분포';

  @override
  String get guide_greenscore_lca_arg2_consumption => '소비';

  @override
  String get guide_greenscore_lca_arg3_title => '14가지 환경영향지표';

  @override
  String get guide_greenscore_lca_arg3_text1 => '기후 변화/탄소 발자국';

  @override
  String get guide_greenscore_lca_arg3_text2 => '오존층 파괴';

  @override
  String get guide_greenscore_lca_arg3_text3 => '이온화 방사선';

  @override
  String get guide_greenscore_lca_arg3_text4 => '땅';

  @override
  String get guide_greenscore_lca_arg3_text5 => '물과 에너지 사용';

  @override
  String get guide_greenscore_lca_arg3_text6 => '대기 오염';

  @override
  String get guide_greenscore_lca_arg3_text7 => '해양 및 담수(입자, 산성화, 부영양화)';

  @override
  String get guide_greenscore_lca_arg3_text8 => '자원 고갈.';

  @override
  String get guide_greenscore_bonuses_penalties_title => '보너스 및 페널티';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      '카테고리 내에서 더 나은 제품을 보상하기 위해 우리는 다음과 같은 여러 기준에 따라 **보너스 및 페널티**를 적용합니다.';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**공식 라벨, 환경적 이점을 보장하는 라벨 또는 인증**(유기농, 공정 무역, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC)이 있는 제품에는 **보너스**가 수여됩니다.';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => '성분의 유래';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**보너스**는 재료의 원산지에 따라 지급됩니다. 이 보너스는 **운송에 미치는 영향**과 각 생산국 국가의 **환경 정책**을 고려하여 책정됩니다.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '생물다양성과 생태계에 심각한 **부정적 영향**을 미치는 성분을 함유한 제품에는 **벌금**이 부과됩니다. 예를 들어 팜유 생산으로 인해 대규모 삼림 벌채가 발생합니다.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => '포장';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**포장의 순환성**(재활용 원료 사용 및 재활용 가능성)과 과도한 포장을 고려하여 **벌금**이 계산됩니다.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      '그린 스코어를 정확하게 계산하려면 **포장에 반드시 명시되어 있지 않은 정보**(예: 원산지 및 각 성분의 정확한 비율) 또는 사용 가능한 형태로 거의 제공되지 않는 정보(예: 사용된 플라스틱의 정확한 유형이 포함된 모든 포장 구성 요소 목록)가 필요합니다.';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**이 정보가 아직 제공되지 않을 경우 평균값을 사용합니다.** 하지만 이제 우리는 모든 분들의 도움을 받아 이 정보를 수집하고 있습니다. 이 정보는 Green-Score뿐만 아니라 다른 여러 용도에도 매우 유용할 것입니다.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      '시민들은 어떻게 도움을 줄 수 있나요?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      '모든 시민은 제품에 표시되어 있거나 제품에서 추론할 수 있는 정보(예: **포장**에 대한 정보)를 수집하고 구성하는 데 도움을 줄 수 있습니다. \"Mission Emballages\"는 모든 식품에 대한 대규모 협업 포장 목록입니다(프랑스어).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      '제조업체가 어떻게 도움을 줄 수 있나요?';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      '제조업체는 우리의 생산자를 위한 무료 플랫폼을 통해 직접 정보를 보낼 수 있습니다.';

  @override
  String get guide_greenscore_better_product_title => '어떤 제품이 지구에 더 좋을까요?';

  @override
  String get guide_greenscore_better_product_arg1_title => '말하기 어려울 수 있습니다';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      '지속 가능한 음식을 선택하는 것은 우리가 기후를 위해 할 수 있는 가장 강력한 일 중 하나입니다. **우리의 글로벌 식량 시스템은 모든 온실 가스 배출량의 4분의 1 이상을 차지합니다**.\n(출처: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => '당신에게 힘이 있어요!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      '좋은 소식은 이것이 우리에게 변화를 만들어낼 강력한 방법을 제공한다는 것입니다.\n**우리는 각자 매년 약 1,000끼의 식사를 합니다.** 이는 **지구의 더 나은 미래를 선택할 수 있는** 1,000번의 기회입니다!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      '책임감을 갖고 결정하는 데 도움이 됩니다.';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      '지속 가능한 식품을 선택하는 것은 복잡하게 느껴질 수 있습니다. 라벨은 헷갈리고 정보는 종종 누락됩니다. 그린스코어는 이러한 과정을 간소화하기 위해 만들어졌으며, 식품에 대한 **명확하고**, **과학에 기반하며**, **투명한** 환경 등급을 쇼핑하는 순간에 바로 확인할 수 있도록 설계되었습니다.';

  @override
  String get guide_greenscore_better_product_arg4_title => '투명도';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      '독점 라벨과 달리 Green-Score 계산은 **완전히 공개**되어 **누구나 검증**할 수 있습니다.';

  @override
  String get guide_nova_title => '가공 식품';

  @override
  String get guide_nova_what_is_nova_title => '초고처리란 무엇인가?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA 그룹에서는 식품 가공 수준에 대해 알려드립니다.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA 분류는 **산업적 가공 정도**(최소한 가공 또는 비가공 식품, 요리 재료, 가공 식품, 고도 가공 식품)에 따라 식품을 **4가지 그룹**으로 분류할 수 있도록 합니다.';

  @override
  String get guide_nova_logos_caption => 'NOVA 로고';

  @override
  String get guide_nova_groups_title => '4개의 NOVA 그룹';

  @override
  String get guide_nova_groups_intro =>
      'NOVA 그룹은 4개로 구성되어 있는데, 문제가 되는 그룹은 4그룹 - 초가공식품입니다.';

  @override
  String get guide_nova_groups_arg1_title => '최소한으로 가공되거나 가공되지 않은 식품';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => '가공 식품 재료';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => '가공 식품';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => '가공 식품';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => '초고속 처리의 문제점';

  @override
  String get guide_nova_explanations_arg1_title => '식품 재료의 극한 가공';

  @override
  String get guide_nova_explanations_arg1_text =>
      '많은 식품 성분을 추가 가공하여 얻은 것으로, 수소화 또는 인터에스테르화 오일, 가수분해 단백질, 대두 단백질 분리물, 말토덱스트린, 전화당, 고과당 옥수수 시럽 등이 있습니다.';

  @override
  String get guide_nova_explanations_arg2_title => '단순한 식품안전을 넘어선 첨가물';

  @override
  String get guide_nova_explanations_arg2_text =>
      '초가공 식품에 첨가되는 첨가제에는 방부제, 항산화제, 안정제 등 가공식품에도 사용되는 첨가제가 포함됩니다. 초가공 제품에만 사용되는 첨가제에는 **식품의 관능적 품질을 모방하거나 향상시키거나 최종 제품의 불쾌한 부분을 가리는 데 사용되는** 첨가제가 포함됩니다. 이러한 첨가제에는 염료 및 기타 색소, 색상 안정제, 향료, 풍미 증강제, 무설탕 감미료, 그리고 탄산화제, 경화제, 팽창제 및 팽창 방지제, 소포제, 고결 방지제 및 광택제, 유화제, 금속이온봉쇄제, 보습제와 같은 가공 보조제가 포함됩니다.';

  @override
  String get guide_nova_explanations_arg3_title => '집에서 할 수 없는 처리';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**여러 단계의 공정을 거쳐** 보통 많은 재료들을 결합하고 최종 제품(즉, \'초가공\')을 만듭니다. 이러한 공정에는 수소화 및 가수분해, 압출 및 성형, 튀김 전처리 등 **국내에는 없는** 여러 공정이 포함됩니다.';

  @override
  String get guide_nova_explanations_arg4_title => '초가공의 약탈적 측면과 재정적 측면';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**초가공 식품의 전반적인 목적은 브랜드화되고, **편리하고** (내구성이 뛰어나고, 바로 섭취할 수 있으며), **매력적이고** (매우 맛있으며), **고수익성** (저가 원료 사용) 식품을 생산하여 다른 모든 식품군을 대체하는 것입니다. 초가공 식품은 일반적으로 매력적인 포장과 집중적인 마케팅을 통해 판매됩니다.';

  @override
  String get guide_nova_explanations_arg5_title => '건강에 해롭다';

  @override
  String get guide_nova_explanations_arg5_text =>
      '2018년 NutriNet-Santé를 통해 **초가공식품 섭취와 암, 심혈관 질환, 당뇨병 위험 증가 사이의 연관성**이 처음으로 밝혀졌습니다. 현재 전 세계적으로 90건 이상의 연구에서 이러한 결과가 확인되었습니다.\n가장 강력한 연관성은 **비만, 심혈관 질환 사망률, 우울증 증상**과 관련이 있습니다. 어린이의 경우, 이러한 영향은 주로 체중과 지질 불균형에서 관찰됩니다.';

  @override
  String get guide_nova_explanations_arg6_title => '국가들은 이를 제한할 것을 권고합니다.';

  @override
  String get guide_nova_explanations_arg6_text =>
      '일부 국가에서는 다음과 같이 NOVA 그룹을 식단 지침이나 목표로 사용합니다.\n\n- **🇧🇷 브라질**의 식단 지침은 가공 식품의 **소비를 제한**하고 고도 가공 식품을 피할 것을 권장합니다.\n\n- **🇫🇷 프랑스**의 2018-2022년 공중 보건 영양 정책 목표는 **그룹 4 고도 가공 식품의 소비를 20% 줄이는 것**입니다.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => '오픈 푸드 팩트에 오신 것을 환영합니다!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      '오픈푸드팩트란 무엇인가요?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      '오픈 푸드 팩츠는 전 세계 식품 제품에 대한 **협업적**, **무료**, **개방형** 데이터베이스입니다.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      '저희는 모든 사람이 자신이 먹는 음식에 대한 정보에 접근할 수 있어야 한다고 믿습니다. 재료, 알레르기 유발 물질, 영양 정보 등에 대한 데이터를 수집함으로써 **소비자가 정보에 기반한 선택을 할 수 있도록 지원**하고 식품 산업의 **투명성을 더욱 강화**합니다.';

  @override
  String get guide_open_food_facts_features_title => '오픈푸드팩트의 특징';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      '원치 않는 재료에 대한 알림을 받으세요';

  @override
  String get guide_open_food_facts_tips_title => '멋진 사진을 찍기 위한 팁';

  @override
  String get guide_open_food_facts_tips_arg1_title => '하지 말아야 할 것';

  @override
  String get guide_open_food_facts_tips_arg1_text1 => '그림자와 눈부심을 피하세요.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      '흐릿하거나 초점이 맞지 않는 텍스트는 없어야 합니다.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 => '텍스트의 일부를 잘라내지 마세요.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => '복잡한 배경은 피하세요.';

  @override
  String get guide_open_food_facts_tips_arg2_title => '해야 할 일';

  @override
  String get guide_open_food_facts_tips_arg2_text1 => '조명을 밝고 고르게 사용하세요.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 => '텍스트가 선명하고 읽기 쉬운지 확인하세요.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 => '전체 재료 목록을 기록해 두세요.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 => '제품을 평평한 곳에 보관하세요.';

  @override
  String get guide_open_food_facts_scores_title =>
      '\"음식의 위키피디아\"를 만드는 데 도움을 주세요';

  @override
  String get guide_open_food_facts_scores_arg1_title => '영양 품질에 대한 점수';

  @override
  String get guide_open_food_facts_scores_arg2_title => '초가공식품을 피하기 위한 점수';

  @override
  String get guide_open_food_facts_scores_arg3_title => '지구를 위한 점수';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ko.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title => '오픈 펫 푸드 팩트에 오신 것을 환영합니다!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      '오픈 펫 푸드 팩트란 무엇인가요?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts는 우리의 소중한 반려동물에게까지 그 사명을 확장합니다! **고양이, 강아지, 그리고 다른 반려동물들을 위한 반려동물 사료 데이터베이스**입니다.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      '우리는 애완동물 주인이 자신의 애완동물에게 가장 적합한 사료를 선택할 수 있도록 돕기 위해 **성분**, **영양 분석** 및 급여 지침에 대한 정보를 수집합니다.';

  @override
  String get guide_open_pet_food_facts_features_title => '오픈 펫푸드 팩트의 특징';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      '원치 않는 재료에 대한 알림을 받으세요';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      '반려동물이 특정 성분에 알레르기가 있나요? 앱에서 바로 피해야 할 화장품 성분 목록을 설정할 수 있습니다!';

  @override
  String get guide_open_pet_food_facts_tips_title => '멋진 사진을 찍기 위한 팁';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => '하지 말아야 할 것';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 => '그림자와 눈부심을 피하세요.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      '흐릿하거나 초점이 맞지 않는 텍스트는 없어야 합니다.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 => '텍스트의 일부를 잘라내지 마세요.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 => '복잡한 배경은 피하세요.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => '해야 할 일';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 => '조명을 밝고 고르게 사용하세요.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      '텍스트가 선명하고 읽기 쉬운지 확인하세요.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 => '전체 재료 목록을 기록해 두세요.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 => '제품을 평평한 곳에 보관하세요.';

  @override
  String get guide_open_pet_food_facts_scores_title => '점수에 대한 참고 사항';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      '반려동물 사료 점수 체계 개발은 **현재로서는 우선순위가 아닙니다**. 종, 연령, 건강 상태에 따라 필요한 영양분이 크게 다르기 때문에 방법론이 복잡할 것입니다. 아직 그러한 점수를 개발할 수 있는 독립적인 과학팀을 찾지 못했습니다.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ko.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => '오픈 뷰티 팩트에 오신 것을 환영합니다!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      '오픈 뷰티 팩트란 무엇인가요?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      '오픈 뷰티 팩츠는 **화장품**에 대한 협업 데이터베이스입니다.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      '저희의 목표는 **개인 관리 용품에 무엇이 들어 있는지** 이해하기 쉽도록 성분 목록을 분석하는 것입니다. 보습제부터 화장품까지, 저희는 화장품 업계의 투명성을 높이기 위해 성분, 알레르기 유발 물질, 포장에 대한 데이터를 수집합니다.';

  @override
  String get guide_open_beauty_facts_features_title => '오픈 뷰티 팩트의 특징';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      '원치 않는 재료에 대한 알림을 받으세요';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      '특정 성분에 알레르기가 있으신가요? 코메도 유발 성분을 피하고 싶으신가요? 논란의 여지가 있는 성분을 피하고 싶으신가요? 앱에서 바로 피해야 할 화장품 성분 목록을 설정할 수 있습니다!';

  @override
  String get guide_open_beauty_facts_tips_title => '멋진 사진을 찍기 위한 팁';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => '하지 말아야 할 것';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 => '그림자와 눈부심을 피하세요.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      '흐릿하거나 초점이 맞지 않는 텍스트는 없어야 합니다.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 => '텍스트의 일부를 잘라내지 마세요.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 => '복잡한 배경은 피하세요.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => '해야 할 일';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 => '조명을 밝고 고르게 사용하세요.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      '텍스트가 선명하고 읽기 쉬운지 확인하세요.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 => '전체 재료 목록을 기록해 두세요.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      '병이 휘어져 있다면 필요한 만큼 사진을 찍으세요.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      '성분 목록을 보려면 라벨을 벗겨야 할 수도 있습니다.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 => '제품을 평평한 곳에 보관하세요.';

  @override
  String get guide_open_beauty_facts_scores_title => '점수에 대한 참고 사항';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      '식품과 달리 화장품에는 **뉴트리스코어(Nutri-Score)**처럼 보편적으로 인정받고 정부에서 지원하는 점수 체계가 없습니다.** 성분의 효과는 매우 개인적이며 피부 타입, 알레르기, 그리고 개인의 고민에 따라 달라질 수 있습니다.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ko.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => '오픈 프라이스에 오신 것을 환영합니다!';

  @override
  String get guide_open_prices_what_is_open_prices_title => '오픈 프라이스란 무엇인가요?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices는 **전 세계 제품 가격을 수집하고 공유하는** 프로젝트입니다. 연구, 분석 등에 활용할 수 있는 공개 데이터 세트입니다. Open Prices는 Open Food Facts에서 개발 및 관리합니다.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => '오픈 프라이스는 어떻게 작동하나요?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**저희는 오픈소스 가격 데이터 세트를 크라우드소싱하고 있습니다**. 사용자는 이 웹앱이나 공식 Open Food Facts 모바일 앱을 통해 가격을 추가할 수 있습니다. 소매업체나 타사 앱도 저희 API를 사용하여 가격을 추가할 수 있습니다.';

  @override
  String get guide_open_prices_how_arg1_title => '통로에 있는 가격표 사진을 수집하세요';

  @override
  String get guide_open_prices_how_arg2_title => '영수증 사진 수집';

  @override
  String get guide_open_prices_why_title =>
      'Open Food Facts에서 이런 일을 하는 이유는 무엇입니까?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      '가격 정보는 식량 시스템을 이해하는 데 매우 중요합니다. 식량 가격을 이해하고 더 건강한 식단을 장려하는 데 중요한 요소입니다. 가격 데이터 공개는 연구자, 언론인, 그리고 시민들이 **지역별, 시간별 식량 가격 변동을 더 잘 이해할 수 있도록** 하는 방법입니다.';

  @override
  String get guide_open_prices_why_arg1_title => '시간 경과에 따른 가격 변화를 추적하세요';

  @override
  String get guide_open_prices_why_arg1_text =>
      '**가격의 변화**를 보세요: 수축 인플레이션, 저렴한 인플레이션, 우리는 함께 추적할 수 있습니다!';

  @override
  String get guide_open_prices_why_arg2_title => '가까운 곳의 가격을 비교하세요';

  @override
  String get guide_open_prices_why_arg2_text =>
      '가격이 더 많이 올라감에 따라, **주변에서 가장 저렴한 매장**을 찾으실 수 있습니다.';

  @override
  String get guide_open_prices_scrapping_title =>
      '소매업체 웹사이트에서 가격을 스크래핑하는 것을 고려해 보셨나요?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      '법적 및 기술적 이유로, **소매업체 웹사이트에서 가격을 스크래핑하는 것은 오픈 프라이스에 기여하는 유효한 방법으로 간주하지 않습니다**. 수집하는 가격이 정확하고 최신인지 확인해야 하며, 기여자들로부터 스크래핑된 가격을 받는 것만으로는 이를 보장할 수 없습니다.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Open Prices의 향후 버전에서는 가격 스크래핑을 고려한 옵션이지만, HTML 페이지를 기반으로 가격 증명을 얻을 수 있도록 Open Prices에서 직접 수행할 것입니다.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'API를 사용하여 가격을 제공할 수 있습니다.\n대규모로 가격을 제공하고 싶으시다면 prices@openfoodfacts.org로 연락해 주세요.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title => '오픈 프로덕츠 팩트에 오신 것을 환영합니다!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      '오픈 프로덕츠 팩트란 무엇인가요?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      '오픈 프로덕츠 팩츠는 **식품, 화장품, 애완동물 사료가 아닌 바코드가 있는 모든 제품**을 위한 대규모 오픈 데이터베이스입니다.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      '**전자제품**부터 **장난감**, **옷**부터 **청소용품**까지, 바코드가 있으면 추가할 수 있습니다. 이 프로젝트는 일상 사물에 대한 \"사물 인터넷\"을 구축하여 누구나 해당 사물에 대한 정보를 접근할 수 있도록 하는 것을 목표로 합니다.';

  @override
  String get guide_open_products_facts_features_title => '오픈 제품 정보의 특징';

  @override
  String get guide_open_products_facts_features_text =>
      '오픈 프로덕츠 팩츠는 소비자에게 물건을 유지 관리, **수리**, **재활용**하거나 새로운 소유자에게 돌려주는 순환 솔루션을 제공함으로써 **사물의 수명을 연장**하는 것을 목표로 합니다.';

  @override
  String get guide_open_products_facts_features_arg1_title => '일부 제품의 탄소 발자국';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '프랑스 환경청 ADEME의 **CO2 영향**은 다양한 범주의 **탄소 영향**을 제공하므로, 제품을 정확하게 분류해야 합니다.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      '다양한 제품의 수리가능성 지수';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      '프랑스의 수리 가능성 지수가 제공되는 경우, 언제든지 표시해 드립니다. 또한, **Folksonomy Engine을 사용하여 변수 수집을 시작하실 수 있습니다.** 이를 통해 해당 지수를 사용할 수 없는 국가에서도 향후 직접 다시 계산할 수 있습니다.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      '귀하의 제품을 기부하거나 재판매할 방법을 찾으세요';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      '저희는 지구 자원을 더욱 아끼기 위해, 여러분이 원하는 제품을 중고 제품으로 구매하실 수 있도록 **제3자 순환 친화 서비스** 링크를 제공합니다.\n저희는 이러한 서비스를 위해 돈을 받고 제공하는 것이 아니며, 이 시스템은 프랑스의 두 웹사이트에 대한 예시로만 작동합니다. 위키에 더 많은 사이트를 문서화하여 이 시스템 확장에 도움을 주실 수 있습니다.';

  @override
  String get guide_open_products_facts_information_title => '어떤 정보가 유용한가요?';

  @override
  String get guide_open_products_facts_information_text =>
      '이처럼 광범위한 품목에 대해 **수집하는 데이터는 유연합니다**. 이를 위해 **Folksonomy 엔진**을 개발했습니다.';

  @override
  String get guide_open_products_facts_folksonomy_title => '폴크소노미 엔진';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      '폴크소노미 엔진은 관련성 높은 상품 정보를 제공하여 상품을 완성하는 데 도움을 주는 도구입니다. 이 엔진은 검색 및 발견 가능성을 개선하는 데 도움이 될 뿐만 아니라, 향후 흥미로운 상품을 계산하고 표시하는 데에도 도움이 됩니다.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      '**compatibility_with_5G_mobile_network: yes**와 같은 키와 값을 추가할 수 있습니다.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      '가능한 속성에 대한 자동 제안이 제공되며, 선호하는 제품 유형에 대한 새로운 속성을 추가하고 문서화하는 것도 매우 좋습니다.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ko.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => '음식 선호도 공개';

  @override
  String get guide_coming_soon_button_title => '곧 출시 예정';

  @override
  String get guide_learn_more_subtitle => '자세히 알아보려면 탭하세요';

  @override
  String get preview_badge => '시사';

  @override
  String get prices_feedback_form => '이 새로운 기능에 대한 피드백을 보내려면 여기를 클릭하세요!';

  @override
  String get menu_button_list_actions => '작업을 선택하세요';

  @override
  String get error_loading_photo => '사진 로딩 중 오류 발생';

  @override
  String get photo_viewer_action_use_picture_as => '…로 사용하세요';

  @override
  String get photo_viewer_use_picture_as_tooltip => '이 사진을…로 사용하세요';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return '이 사진을… ($language)로 사용하세요.';
  }

  @override
  String get photo_viewer_details_button => '세부';

  @override
  String get photo_viewer_details_button_accessibility_label => '이 사진의 세부 정보';

  @override
  String get photo_viewer_details_title => '사진의 세부 사항';

  @override
  String get photo_viewer_details_contributor_title => '기여자';

  @override
  String get photo_viewer_details_size_title => '크기';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height 픽셀';
  }

  @override
  String get photo_viewer_details_date_title => '날짜';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => '호환 가능';

  @override
  String get user_lists_action_multi_select => '다중 선택';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return '귀하의 호환성 점수: $score%';
  }

  @override
  String get product_image_front_accessibility_label => '전면 사진';

  @override
  String get product_image_ingredients_accessibility_label => '성분 목록의 그림';

  @override
  String get product_image_nutrition_accessibility_label => '영양 정보 사진';

  @override
  String get product_image_packaging_accessibility_label => '포장 사진';

  @override
  String get product_image_other_accessibility_label => '다른 사진';

  @override
  String get product_image_outdated_message => '이 사진은 오래되었을 수 있습니다';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (이 이미지는 오래되었을 수 있습니다)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (이 이미지는 제작자에 의해 잠겼을 수 있습니다)';
  }

  @override
  String get product_image_error => '이미지를 로드할 수 없습니다!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type 을 로드할 수 없습니다. (네트워크 오류?)';
  }

  @override
  String get product_page_image_no_image_available => '\n이미지가 없습니다!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      '이 제품에 대한 사진이 없습니다.';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      '작업 재정렬 또는 숨기기';

  @override
  String get product_page_action_bar_setting_modal_title => '편집 작업';

  @override
  String get product_page_action_bar_item_move_up => '위로 이동';

  @override
  String get product_page_action_bar_item_move_down => '아래로 이동';

  @override
  String get product_page_action_bar_item_enable => '작업 활성화';

  @override
  String get product_page_action_bar_item_disable => '동작 비활성화';

  @override
  String get product_page_pending_operations_banner_title => '편집 내용 업로드…';

  @override
  String get product_page_pending_operations_banner_message =>
      '이 페이지에 표시된 데이터는 **아직 귀하의 수정 사항을 반영하지 않았습니다**.\n몇 초간 기다려 주세요…';

  @override
  String get product_add_a_language => '언어 추가';

  @override
  String barcode_accessibility_label(String barcode) {
    return '바코드 $barcode';
  }

  @override
  String get carousel_close_tooltip => '이 제품을 캐러셀에서 제거하세요';

  @override
  String get carousel_unsupported_header => '지원되지 않는 바코드입니다!';

  @override
  String get carousel_unsupported_title => '앗!';

  @override
  String get carousel_unsupported_text =>
      '스캔된 바코드는 Open Food Facts에서 지원하지 않습니다!';

  @override
  String get carousel_error_header => '오류!';

  @override
  String get carousel_error_title => '실망스럽네요!';

  @override
  String get carousel_error_text_1 => '이 바코드에 대한 정보를 다운로드할 수 없습니다:';

  @override
  String get carousel_error_text_2 => '인터넷 연결을 확인하거나 이 버튼을 클릭하세요:';

  @override
  String get carousel_error_button => '다시 시도';

  @override
  String get carousel_unknown_product_header => '알 수 없는 제품';

  @override
  String get carousel_unknown_product_title => '축하합니다!\n__희귀한 보석을 찾으셨습니다!__';

  @override
  String get carousel_unknown_product_text =>
      '저희의 협업 데이터베이스에는 **300만 개 이상의 제품**이 포함되어 있지만, 이 바코드는 존재하지 않습니다. ';

  @override
  String get carousel_unknown_product_button => '제품 추가';

  @override
  String get carousel_loading_header => '정보를 로딩 중입니다...';

  @override
  String get carousel_loading_title => '방금 다음 바코드가 있는 제품을 스캔했습니다.';

  @override
  String get carousel_loading_text =>
      '저희는 **300만 개 이상의 제품**을 보유한 데이터베이스에서 해당 제품을 검색하고 있습니다!';

  @override
  String get product_type_subtitle_food => '야채, 과일, 냉동식품…';

  @override
  String get product_type_subtitle_beauty => '화장품, 비누, 치약…';

  @override
  String get product_type_subtitle_pet_food => '개, 고양이용 사료…';

  @override
  String get product_type_subtitle_product => '스마트폰, 가구…';

  @override
  String get photo_field_front => '제품 사진';

  @override
  String get photo_field_ingredients => '재료 사진';

  @override
  String get photo_field_nutrition => '영양 사진';

  @override
  String get photo_field_packaging => '포장 정보 사진';

  @override
  String get photo_already_exists => '이 사진은 이미 존재합니다';

  @override
  String get photo_missing => '이 사진이 없습니다';

  @override
  String get date => '날짜';

  @override
  String get photo_rotate_left => '왼쪽으로 돌리기';

  @override
  String get photo_rotate_right => '오른쪽으로 돌리기';

  @override
  String get photo_undo_action => '이전 작업을 실행 취소합니다';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location의 세계 지도';
  }

  @override
  String get open_street_map_contributor_attribution => 'OpenStreetMap 기여자';

  @override
  String get not_applicable_short => '해당 없음';

  @override
  String get knowledge_panel_warning_text => '경고';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      '이 Nutri-Score가 패키지에 적힌 것과 다른 이유는 무엇입니까?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      '두 가지 가능한 이유가 있습니다.\n원재료 및/또는 영양 정보가 최신 상태가 아닙니다.\n\nNutri-Score(또는 V2)의 \"새로운 계산\"을 제공합니다. 제품 포장에 \"새로운 계산\" 배너가 있는지 확인해 주세요.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      '성분 확인';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      '영양성분을 확인하세요';

  @override
  String url_not_supported(String url) {
    return '안타깝게도 URL을 열 수 없습니다:\n$url';
  }

  @override
  String get product_list_export => '내보내다';

  @override
  String get product_list_import => '수입';

  @override
  String get product_footer_action_barcode => '바코드 보기';

  @override
  String get product_footer_action_barcode_short => '바코드';

  @override
  String get product_footer_action_open_website => '웹사이트 열기';

  @override
  String get product_footer_action_report => '보고서';

  @override
  String get product_footer_action_contributor_guide => '돕다';

  @override
  String get product_footer_action_data_quality_tags => '데이터 품질';

  @override
  String get product_page_tab_for_me => '나를 위한';

  @override
  String get product_page_tab_website => '웹사이트';

  @override
  String get product_page_tab_prices => '물가';

  @override
  String get prices_explanation_card_title => '왜 가격인가?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices**는 전 세계 제품 가격을 수집하고 공유하는 프로젝트입니다. 🌍 Open Prices는 오픈 푸드 팩츠에서 개발 및 관리합니다.';

  @override
  String get explanation_card_learn_more_button => '더보기';

  @override
  String get product_page_tab_folksonomy => '포크소노미';

  @override
  String get folksonomy_explanation_card_title => 'Folksonomy 속성은 무엇인가요?';

  @override
  String get folksonomy_explanation_card_line1 => '속성은 **키-값** 기반입니다.';

  @override
  String get folksonomy_explanation_card_line2 =>
      '이러한 속성은 기여자에 의해 어떤 용도로든 생성되고 보관됩니다.';

  @override
  String get folksonomy_action_external_link_title => '외부 링크 열기';

  @override
  String get folksonomy_action_external_link_warning =>
      '외부 링크는 안전하지 않을 수 있습니다. 정말 방문하시겠습니까?';

  @override
  String get prices_products_empty_title => '가격이 없습니다';

  @override
  String get prices_products_empty_explanation => '첫 번째로 기여해 보세요!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return '상위 $pageSize 개 제품 (총: $total개)';
  }

  @override
  String get app_review_title => '이 앱이 마음에 드시나요?';

  @override
  String get app_review_low => '더 잘할 수 있었을 텐데';

  @override
  String get app_review_medium => '나쁘지 않다';

  @override
  String get app_review_high => '정말 좋아요!';

  @override
  String get app_review_feedback_modal_title => '우리의 애플리케이션을 개선하는 데 도움을 주세요';

  @override
  String get app_review_feedback_modal_content =>
      '시간이 좀 있으시다면 **향후 업데이트에서 개선할 수 있도록** 이 양식에 답변해 주시겠습니까?';

  @override
  String get app_review_feedback_modal_open_form => '양식에 답하세요';

  @override
  String get app_review_feedback_modal_later => '나중에 물어봐 주세요';

  @override
  String get nutrition_facts_extract_new =>
      '새로운 기능: 사진에서 영양소를 자동으로 추출할 수 있습니다!';

  @override
  String get nutrition_facts_extract_button_text => '지금 추출하세요';

  @override
  String get nutrition_facts_extract_in_progress => '추출 진행 중…';

  @override
  String get nutrition_facts_extract_successful => '추출 성공';

  @override
  String get nutrition_facts_extract_failed => '사진에서 영양소 추출에 실패했습니다.';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => '통계';

  @override
  String get prices_stats_title => '가격 통계';

  @override
  String get prices_stats_prices_section => '물가';

  @override
  String get prices_stats_products_section => '제품';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => '기여자';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => '기타';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => '소비';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => '음식';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => '제품';

  @override
  String get prices_stats_pet_food => '반려동물 사료';

  @override
  String get prices_stats_osm => '오픈스트리트맵';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => '국가';

  @override
  String get prices_stats_price_tag => '가격표';

  @override
  String get prices_stats_receipt => '영수증';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => '웹사이트';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => '기타';

  @override
  String get prices_stats_last_updated => '마지막 업데이트 날짜';

  @override
  String get prices_stats_error => '통계를 로드하는 동안 오류가 발생했습니다.';

  @override
  String get product_edit_robotoff_question_answered => '질문에 답변되었습니다!';

  @override
  String get product_edit_robotoff_proof => '증거';

  @override
  String get preferences_card_general => '일반';

  @override
  String get preferences_prices_title => '물가';

  @override
  String get preferences_prices_subtitle => '가격 선호도를 관리하세요';

  @override
  String get preferences_card_project => '오픈 푸드 팩츠 프로젝트';

  @override
  String get preferences_contribute_title => '기여하기';

  @override
  String get preferences_my_contributions_title => '내 기여';

  @override
  String get preferences_my_stats_title => '내 통계';

  @override
  String get preferences_contribute_subtitle => '번역하고 도구를 개선하세요…';

  @override
  String get preferences_connect_title => '연결하다';

  @override
  String get preferences_connect_subtitle => '문의하시거나 소셜 미디어에서 팔로우하세요';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle =>
      '전 세계 수백만 명의 소비자에게 정보를 제공하는 데 도움을 주세요.';

  @override
  String get preferences_card_help => '도움말 및 지원';

  @override
  String get preferences_faq_title => '자주 묻는 질문';

  @override
  String get preferences_faq_subtitle => '질문에 대한 답변을 받으세요';

  @override
  String get logged_out => '로그아웃됨';

  @override
  String get preferences_app_bar_message => '우리 회원이 되어주셔서 감사합니다!';

  @override
  String get preferences_app_bar_products_modified => '수정된 제품';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => '모든 통계 보기';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '$provider 에서 \"$keyword\"을 검색하세요';
  }

  @override
  String get preferences_app_bar_search_hint => '설정 검색(예: Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji => '접근성: 이모티콘 표시';

  @override
  String get preferences_accessibility_remove_colors => '접근성: 색상 제거';

  @override
  String get preferences_app_settings_products => '제품';

  @override
  String get preferences_card_about => '정보';

  @override
  String get preferences_legal_information_title => '법률 정보';

  @override
  String get preferences_legal_information_subtitle => '이용 약관, 개인정보 보호정책 등';

  @override
  String get preferences_terms_of_use => '이용 약관';

  @override
  String get preferences_legal_mentions => '법률상의 언급';

  @override
  String get preferences_legal_header =>
      '오픈 푸드 팩츠는 **모든 사람이 만들고, 모든 사람을 위해** 만든 식품 데이터베이스입니다.\n더 나은 식품 선택을 하는 데 활용할 수 있으며, **오픈 데이터**이므로 누구나 **어떤 목적으로든 재사용**할 수 있습니다.';

  @override
  String get preferences_privacy_policy => '개인정보 보호정책';

  @override
  String get preferences_licenses => '라이센스';

  @override
  String get preferences_about_app_title => '앱에 대하여';

  @override
  String get preferences_about_app_subtitle => '기술 정보, 개발자 정보 등';

  @override
  String get preferences_card_information => '정보';

  @override
  String get preferences_version_number_title => '버전 번호';

  @override
  String get preferences_scanner_title => '스캐너';

  @override
  String get preferences_app_store => '앱스토어';

  @override
  String get preferences_app_system_settings => '시스템 설정';

  @override
  String get preferences_source_code => '소스 코드에 접근하세요';

  @override
  String get preferences_source_code_subtitle => '그리고 수백만 명에게 영향을 미치기 시작하세요';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => '제품 보완';

  @override
  String get preferences_tips => '팁';

  @override
  String get tips_discover_nutriscore => '새로운 Nutri-Score를 만나보세요';

  @override
  String get preferences_on_off_website_subtitle => 'Open Food Facts 웹사이트에서';

  @override
  String get preferences_manage_account_title => '내 계정 관리';

  @override
  String get preferences_manage_account_tooltip => '계정 관리';

  @override
  String get preferences_change_password_title => '내 비밀번호를 변경하세요';

  @override
  String get preferences_danger_zone => '위험 구역';

  @override
  String get preferences_account_deletion_subtitle => '귀하의 모든 기여가 손실됩니다.';

  @override
  String get preferences_contributions_title => '기여';

  @override
  String get preferences_dev_mode_app_settings_title => '앱 설정';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      '오프라인에서 제품을 스캔하는 매우 실험적인 방법';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      '서버에서 모든 제품을 새로 고침합니다';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      '절대적으로 필요하지 않는 한 그렇게 하지 마십시오.';

  @override
  String get preferences_dev_mode_demo_mode_title => '데모 모드';

  @override
  String get preferences_dev_mode_add_cards_title => '스캐너에 카드 추가';

  @override
  String get preferences_dev_mode_add_cards_subtitle => '스캐너에 샘플 제품 3개를 추가합니다.';

  @override
  String get preferences_dev_mode_folksonomy_host_title => '폴크소노미 호스트';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return '호스트: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title => '접근성 실험';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      '다양한 제품 선택 가격';

  @override
  String get preferences_dev_mode_user_ordered_kp_title => '사용자가 주문한 지식 패널';

  @override
  String get preferences_dev_mode_location_search_title => '위치 검색에 대한 임시 액세스';

  @override
  String get preferences_dev_mode_comparison_title => '2~3개 제품을 나란히 비교해보세요';

  @override
  String get preferences_dev_mode_product_list_import_title => '제품 목록 가져오기';

  @override
  String get preferences_faq_scores_methodologies_title => '점수 및 방법론';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Nutri-Score가 어떻게 계산되는지 알아보세요';

  @override
  String get preferences_faq_nutriscore_v2_subtitle => '방법론의 주요 변경 사항을 알아보세요';

  @override
  String get preferences_faq_discover_project_title => '프로젝트보세요';

  @override
  String get preferences_faq_discover_off_title => '공개 식품 정보를 알아보세요';

  @override
  String get preferences_faq_discover_obf_title => '공개된 뷰티 정보를 확인하세요';

  @override
  String get preferences_faq_discover_opff_title => '공개된 반려동물 사료 정보를 확인하세요';

  @override
  String get preferences_faq_discover_op_title => '공개 가격 알아보기';

  @override
  String get preferences_faq_discover_opf_title => '오픈 제품 정보를 확인하세요';

  @override
  String get preferences_faq_faq_title => 'FAQ - 자주 묻는 질문';

  @override
  String get preferences_faq_off_ngo_title => '오픈 푸드 팩츠 NGO';

  @override
  String get preferences_about_information_title => '정보';

  @override
  String get preferences_connect_community_updates_title => '커뮤니티 업데이트 받기';

  @override
  String get preferences_connect_newsletter_subtitle =>
      '앱과 커뮤니티 뉴스를 최신 상태로 유지하세요';

  @override
  String get preferences_connect_community_calendar_title => '커뮤니티 캘린더 구독하기';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      '당사의 가상 이벤트 중 하나에 참석하여 참여하세요.';

  @override
  String get preferences_connect_blog_title => '오픈 푸드 팩츠 블로그';

  @override
  String get preferences_connect_blog_subtitle => '최신 뉴스를 실시간으로 받아보세요';

  @override
  String get preferences_connect_community_help_title => '커뮤니티로부터 도움을 받으세요';

  @override
  String get preferences_connect_improve_app_title => '앱 개선에 도움을 주세요';

  @override
  String get preferences_connect_debug_info_title => '디버그 정보를 보내주세요';

  @override
  String get preferences_connect_debug_info_subtitle =>
      '자세한 디버깅 정보가 포함된 이메일을 보내주세요.';

  @override
  String get preferences_connect_feedback_title => '앱에 대한 피드백을 보내주세요';

  @override
  String get preferences_connect_feedback_subtitle => '앱의 미래를 형성하는 데 도움을 주세요';

  @override
  String get preferences_connect_survey_title => '앱 설문조사에 참여하세요';

  @override
  String get preferences_connect_survey_subtitle =>
      '우리가 다음에 무엇을 만들어야 할지 이해하도록 도와주세요';

  @override
  String get preferences_connect_professionals_title => '전문가';

  @override
  String get preferences_connect_pro_subtitle =>
      '완전 무료이며, 500개 앱과 수백만 명의 소비자에게 정확한 데이터를 제공합니다. PIM 또는 스프레드시트(XLSX)와 호환되는 셀프 서비스입니다.';

  @override
  String get preferences_connect_pro_email_subtitle => '시작하려면 연락하세요';

  @override
  String get preferences_connect_press_title => '프레스';

  @override
  String get preferences_connect_press_page_subtitle => '보고서에 필요한 모든 자료를 얻으세요';

  @override
  String get preferences_connect_press_email_subtitle =>
      '언론 문의나 보고서에 대한 정보를 알려주시려면 연락해 주세요.';

  @override
  String get preferences_contribute_active_volunteer_title => '활동적인 자원봉사자가 되세요';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      '개발, 커뮤니케이션, 디자인… 모든 종류의 자원봉사나 전문지식을 환영합니다!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      '여러분이 기여할 수 있는 다양한 방법을 알아보세요';

  @override
  String get preferences_contribute_mobile_dev_title => '모바일 앱 개발';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      '소프트웨어 개발에 기여하는 방법을 알아보세요';

  @override
  String get preferences_contribute_alpha_subtitle => '매일 불안정한 빌드, 새로운 기능';

  @override
  String get preferences_contribute_local_community_title => '지역 사회를 성장시키세요';

  @override
  String get preferences_contribute_translate_subtitle =>
      '소프트웨어, 콘텐츠, 성분 분석 번역 지원';

  @override
  String get preferences_contribute_share_subtitle =>
      '여러분을 돕기 위해 작은 템플릿을 준비했습니다 :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      '귀하의 국가에서 식량 투명성을 높이기 위한 간단한 단계';

  @override
  String get preferences_contribute_data_quality_title => '데이터 품질';

  @override
  String get preferences_contribute_data_quality_team_title =>
      '데이터 품질 팀에 합류하세요';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      '데이터베이스가 완전하고 정확한지 확인하기 위한 노력에 동참해 주세요.';

  @override
  String get preferences_contributions_products_added_title => '추가된 상품';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Open Food Facts에 추가한 새로운 제품';

  @override
  String get preferences_contributions_to_be_completed_title => '내가 완성해야 할 제품';

  @override
  String get preferences_contributions_all_incomplete_title => '모든 미완성 제품';

  @override
  String get preferences_my_contributions_prices_title => '물가';

  @override
  String get preferences_my_contributions_my_prices_title => '내 가격';

  @override
  String get preferences_my_contributions_my_prices_subtitle => '내 가격, 내 증명…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      '당신이 완성하는 데 도움을 줄 수 있는 제품';

  @override
  String get preferences_contributions_categorize_subtitle =>
      '귀하의 국가에서 Nutri-Score 및 Green-Score를 계산하는 데 도움이 됩니다.';

  @override
  String get preferences_prices_user_prices_subtitle => '내가 기여한 가격';

  @override
  String get preferences_prices_proofs_subtitle => '가격표와 영수증';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      '영수증 사진을 찍고 관련 바코드를 스캔하세요';

  @override
  String get preferences_prices_add_price_tags_subtitle => '가게의 가격 사진을 찍어보세요';

  @override
  String get preferences_prices_newest_title => '최신 가격';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Price 커뮤니티에서 추가한 최신 가격';

  @override
  String get preferences_prices_top_contributors_title => '가장 많은 가격을 제시한 기여자';

  @override
  String get preferences_prices_metrics_title => '오픈 가격 지표';

  @override
  String get preferences_prices_metrics_subtitle => '프로젝트의 진행 상황을 살펴보세요';

  @override
  String get preferences_prices_ways_contribute_title => '기여 방법';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'AI의 도움으로 자신이나 다른 사람이 추가한 가격을 확인하세요.';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      '카메라 롤에서 많은 영수증이나 선반 사진을 빠르게 추가하세요';

  @override
  String get preferences_prices_challenges_title => '월간 챌린지';

  @override
  String get preferences_prices_challenges_subtitle =>
      '월별 주제별 퀘스트에 참여하여 가격을 수집하세요';

  @override
  String get preferences_prices_loyalty_data_title => '충성도 데이터를 회수하세요';

  @override
  String get preferences_prices_gdpr_subtitle => '데이터를 요청하는 방법을 알아보세요';

  @override
  String get preferences_page_customize_app_title => '앱 사용자 지정';

  @override
  String get preferences_page_contribute_project_title => '프로젝트에 기여하다';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Facts를 돕는 간단한 방법';

  @override
  String get preferences_page_faq_subtitle => '점수 방법론, 도움말 및 프로젝트에 대한 추가 정보';

  @override
  String get product_edit_robotoff_positive_button => '제안 수락';

  @override
  String get product_edit_robotoff_negative_button => '제안 거부';

  @override
  String get product_edit_robotoff_show_proof => '증거를 보여주세요';

  @override
  String get product_edit_robotoff_expand_proof => '증명을 확장하다';

  @override
  String get product_page_tab_raw_data => '원시 데이터';

  @override
  String page_indicator_with_total(int current, int total) {
    return '페이지 $current / $total';
  }

  @override
  String page_indicator(int current) {
    return '페이지 $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count / $total 항목';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count / $total 항목';
  }

  @override
  String item_count(int count) {
    return '$count 항목';
  }

  @override
  String item_count_string(String count) {
    return '$count 항목';
  }

  @override
  String get prices_no_result => '가격 통계를 찾을 수 없습니다.';

  @override
  String get prices_error_loading_more_items => '더 많은 항목을 로드하는 중 오류가 발생했습니다.';

  @override
  String get prices_proof_error => '인증에 실패하여 증명을 가져올 수 없습니다.';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count / $total 증명';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count / $total 기여자';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count / $total 위치';
  }

  @override
  String prices_locations_count(int count) {
    return '$count 위치';
  }

  @override
  String get restart_to_apply_message => '변경 사항을 적용하려면 앱을 다시 시작하세요.';

  @override
  String get preferences_app_settings_graphical_interface_title => '그래픽 인터페이스';

  @override
  String get preferences_app_settings_media_title => '메디아';

  @override
  String get preferences_about_app_development_title => '개발';

  @override
  String get preferences_page_open_food_facts_labs_title => '오픈 푸드 팩츠 랩스';

  @override
  String get preferences_root_account_title => '계정';

  @override
  String get preferences_contribute_translate_header =>
      '공개 식품 정보를 귀하의 언어로 제공하세요';

  @override
  String get preferences_contribute_enroll_alpha => '앱의 알파 버전에 등록하세요';

  @override
  String get preferences_dev_mode_section_data => '기여 및 제품 데이터';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Folksonomy를 표시하지 마십시오';

  @override
  String get preferences_account_title => '계정';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '$created에 추가됨';
  }

  @override
  String get location_map_details_title => '위치 세부 정보';

  @override
  String get location_map_details_name => '이름';

  @override
  String get location_map_details_street => '거리';

  @override
  String get location_map_details_city => '도시';

  @override
  String get location_map_details_postcode => '우편번호';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => '좌표';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
