// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Japanese (`ja`).
class AppLocalizationsJa extends AppLocalizations {
  AppLocalizationsJa([String locale = 'ja']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'はい';

  @override
  String get add => '追加';

  @override
  String get account_delete_message =>
      '本当にアカウントを削除しますか？\n具体的な理由がある場合は、以下にご記入ください。';

  @override
  String get reason => '原因';

  @override
  String get okay => 'OK';

  @override
  String get validate => '検証';

  @override
  String get create => '作成する';

  @override
  String get applyButtonText => '適用';

  @override
  String get next_label => '次';

  @override
  String get continue_label => '続ける';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => '前';

  @override
  String get go_back_to_top => 'トップに戻る';

  @override
  String get save => '保存';

  @override
  String get save_confirmation => '保存してもよろしいですか？';

  @override
  String get skip => 'スキップ';

  @override
  String get cancel => '取消';

  @override
  String get ignore => '無視';

  @override
  String get close => '閉じる';

  @override
  String get no => 'いいえ';

  @override
  String get stop => '停止';

  @override
  String get finish => '仕上げる';

  @override
  String get calculate => '計算';

  @override
  String get reset_food_prefs => '食品の好みをリセット';

  @override
  String get error => '問題が発生しました';

  @override
  String get error_occurred => 'エラーが発生しました';

  @override
  String get featureInProgress => 'この機能はまだ開発中です。ご期待ください。';

  @override
  String get label_web => 'Web 上で見る';

  @override
  String get learnMore => '詳細';

  @override
  String get unknown => '不明';

  @override
  String get match_very_good => '非常に良い一致';

  @override
  String get match_good => '良好な一致';

  @override
  String get match_poor => 'マッチが悪い';

  @override
  String get match_may_not => '一致していないかもしれません。';

  @override
  String get match_does_not => '一致しない';

  @override
  String get match_unknown => '一致度は不明';

  @override
  String get match_short_very_good => '非常に良い一致';

  @override
  String get match_short_good => '良好な一致';

  @override
  String get match_short_poor => 'マッチが悪い';

  @override
  String get match_short_may_not => '一致していないかもしれません。';

  @override
  String get match_short_does_not => '一致しない';

  @override
  String get match_short_unknown => '一致度は不明';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => '検索中';

  @override
  String get welcomeToOpenFoodFacts => 'Open Food Factsへようこそ';

  @override
  String get whatIsOff => 'Open Food Facts は、地域社会によって運営される世界的な非営利団体です。';

  @override
  String get productDataUtility => 'あなたの好みに関連する食品データを確認する。';

  @override
  String get healthCardUtility => 'あなたにとって良い食品を選んでください。';

  @override
  String get ecoCardUtility => '地球にとって良い食品を選んでください。';

  @override
  String get server_error_open_new_issue =>
      'サーバーからの応答がありません。次のリンクから問題を報告してください。';

  @override
  String get sign_in_text => 'Open Food Factsアカウントにログインして投稿を保存しましょう';

  @override
  String get incorrect_credentials => 'ユーザー名またはパスワードが間違っています。';

  @override
  String get password_lost_incorrect_credentials =>
      'このメールアドレスまたはユーザー名は存在しません。認証情報を確認してください。';

  @override
  String get password_lost_server_unavailable =>
      '現在、サーバーの速度低下が発生しており、お詫び申し上げます。後でもう一度試してください。';

  @override
  String get login => 'ログイン';

  @override
  String get login_result_type_server_unreachable => 'ネットワークにアクセスできません';

  @override
  String get login_result_type_server_issue =>
      'サーバーに問題が発生しました。しばらくしてからもう一度お試しください。';

  @override
  String get login_page_username_or_email => 'ユーザー名またはメールアドレスを入力してください';

  @override
  String get login_page_password_error_empty => 'パスワードを入力してください';

  @override
  String get create_account => 'アカウントを作成';

  @override
  String get sign_in => 'サインイン';

  @override
  String get sign_in_mandatory => 'その機能を使用するには、サインインが必要です。';

  @override
  String get help_improve_country => 'あなたの国のOpen Food Factsの改善にご協力ください';

  @override
  String get sign_out => 'サインアウト';

  @override
  String get sign_out_confirmation => 'サインアウトしますか？';

  @override
  String get password => 'パスワード';

  @override
  String get forgot_password => 'パスワードを忘れた場合';

  @override
  String get forgot_password_question => 'パスワードをお忘れですか？';

  @override
  String get view_profile => 'プロフィールを表示';

  @override
  String get reset_password => 'パスワードをリセットする';

  @override
  String get reset_password_explanation_text =>
      'パスワードを忘れた場合は、ユーザー名または電子メールアドレスを入力して、パスワードリセットの手順を受け取ってください。また、迷惑メールフォルダも忘れずにご確認ください。';

  @override
  String get username_or_email => 'ユーザー名またはメールアドレス';

  @override
  String get reset_password_done =>
      'パスワードをリセットするためのリンクが記載されたメールが、アカウントに関連付けられたメールアドレスに送信されました。迷惑メールフォルダもご確認ください。';

  @override
  String get send_reset_password_mail => 'パスワードを変更';

  @override
  String get enter_some_text => 'テキストを入力してください';

  @override
  String get sign_up_page_title => 'サインアップ';

  @override
  String get sign_up_page_action_button => 'サインアップ';

  @override
  String get sign_up_page_action_doing_it => 'サインアップ…';

  @override
  String get sign_up_page_action_ok => 'おめでとうございます！あなたのアカウントが作成されました。';

  @override
  String get sign_up_page_display_name_hint => '名前';

  @override
  String get sign_up_page_display_name_error_empty => '使用したい表示名を入力してください';

  @override
  String get sign_up_page_email_hint => 'メールアドレス';

  @override
  String get sign_up_page_email_error_empty => 'メールアドレスは必須です';

  @override
  String get sign_up_page_email_error_invalid => '無効なメールアドレスです';

  @override
  String get sign_up_page_username_hint => 'ユーザー名：他者に公開されます';

  @override
  String get sign_up_page_username_error_empty => 'ユーザー名を入力してください';

  @override
  String get sign_up_page_username_error_invalid => '有効なユーザー名を入力してください';

  @override
  String get sign_up_page_username_description =>
      'ユーザー名にスペース、大文字、特殊文字は使用できません。';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'ユーザー名は $value 文字以内で入力してください';
  }

  @override
  String get sign_up_page_password_hint => 'パスワード';

  @override
  String get sign_up_page_password_error_empty => 'パスワードを入力してください';

  @override
  String get sign_up_page_password_error_invalid => 'パスワードは6文字以上で入力してください';

  @override
  String get sign_up_page_confirm_password_hint => 'パスワード再確認';

  @override
  String get sign_up_page_confirm_password_error_empty => 'パスワードの確認をしてください';

  @override
  String get sign_up_page_confirm_password_error_invalid => 'パスワードが一致しません';

  @override
  String get sign_up_page_agree_text => '私はオープンフードファクトに同意します';

  @override
  String get sign_up_page_terms_text => '利用と貢献規約';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'アカウントを作成する場合、利用規約への同意が必須ですが、アプリからの投稿は匿名で可能です。';

  @override
  String get sign_up_page_producer_checkbox => '私は食品生産者です';

  @override
  String get sign_up_page_producer_hint => '生産者/ブランド';

  @override
  String get sign_up_page_producer_error_empty => '生産者またはブランド名を入力してください';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Open Food Factsニュースレターを購読します（いつでも購読を解除できます）';

  @override
  String get sign_up_page_user_name_already_used =>
      'このユーザー名は既に存在します。別のユーザー名を入力してください。';

  @override
  String get sign_up_page_email_already_exists =>
      '既に存在します。アカウントにログインするか、別のメールアドレスをお試しください。';

  @override
  String get sign_up_page_provide_valid_email => '有効なメールアドレスを入力してください。';

  @override
  String get sign_up_page_server_busy =>
      '申し訳ございませんが、お客様のアカウントを作成する際に技術的な問題が発生しました。後でもう一度お試しください。';

  @override
  String get settingsTitle => '設定';

  @override
  String get darkmode => 'テーマ';

  @override
  String get darkmode_dark => 'ダーク';

  @override
  String get darkmode_light => 'ライト';

  @override
  String get darkmode_system_default => 'システムの既定値';

  @override
  String get thanks_for_contributing => 'ご協力ありがとうございます！';

  @override
  String get contributors_label => '彼らはアプリを構築中です';

  @override
  String get contributors_dialog_title => '貢献者';

  @override
  String contributors_dialog_entry_description(Object name) {
    return '貢献者: $name';
  }

  @override
  String get contributors_description => 'このアプリのすべての貢献者のリスト';

  @override
  String get support => 'サポート';

  @override
  String get support_join_slack => 'Slackチャンネルで質問する';

  @override
  String get support_via_forum => 'フォーラムで助けを求める';

  @override
  String get support_via_email => '私たちにメールを送信';

  @override
  String get support_via_email_include_logs_dialog_title => 'アプリのログを送信しますか？';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'メールの添付ファイルにアプリのログを含めますか？';

  @override
  String get termsOfUse => '利用規約';

  @override
  String get legalNotices => '法的通知';

  @override
  String get privacy_policy => 'プライバシーポリシー';

  @override
  String get about_this_app => 'このアプリについて';

  @override
  String get contribute => '貢献する';

  @override
  String get contribute_sw_development => 'ソフトウェア開発';

  @override
  String get contribute_develop_text =>
      'Open Food Facts のすべての製品のコードは GitHub で公開されています。コードはオープンソースなので、ぜひ再利用して、地球上のすべての人々のために改善にご協力ください。';

  @override
  String get contribute_develop_text_2 =>
      '質問をする場合は、Open Food Facts Slack チャットルームに参加することをお勧めします。';

  @override
  String get contribute_develop_dev_mode_title => '開発者モード？';

  @override
  String get contribute_develop_dev_mode_subtitle => '開発者モードを有効にする';

  @override
  String get contribute_donate_title => '寄付';

  @override
  String get contribute_donate_header => 'Open Food Factsに寄付する';

  @override
  String get contribute_enroll_alpha_warning =>
      '内部アルファ版では、データが完全に失われる可能性があり、アプリはいつでも使用できなくなる可能性があることをご了承ください!';

  @override
  String get contribute_improve_ProductsToBeCompleted => '完了が必要な製品';

  @override
  String get contribute_improve_header => '改善';

  @override
  String get contribute_improve_text =>
      'データベースはプロジェクトの中核です。簡単に、そして迅速に貢献できます。スマートフォン用のモバイルアプリをダウンロードして、商品の追加や改善を始めましょう。\n\n一方、Open Food Factsのウェブサイトでは、様々な方法で貢献できます。 ';

  @override
  String get contribute_translate_header => '翻訳';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => '翻訳を始める';

  @override
  String get contribute_translate_text =>
      'Open Food Factsは、160カ国以上の製品を網羅するグローバルプロジェクトです。Open Food Factsは数十の言語に翻訳されており、コンテンツは常に進化しています。';

  @override
  String get contribute_translate_text_2 => '翻訳はプロジェクトの重要なタスクの1つです';

  @override
  String get contribute_join_skill_pool =>
      'スキルをOpen Food Factsに貢献しましょう。スキルプールに参加しましょう！';

  @override
  String get contribute_share_header => 'Open Food Factsを友達と共有しましょう';

  @override
  String get contribute_share_content =>
      '私が使っているアプリ「Open Food Facts」についてお知らせします。このアプリは、食品の健康や環境への影響を、個人に合わせて調べることができます。パッケージのバーコードをスキャンするだけで使えます。無料、登録も不要で、解読対象製品の数を増やすことにも貢献できます。スマートフォン用のダウンロードリンクはこちらです：https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'GDPRに準拠したポイントカードデータのエクスポートをリクエストして価格設定に貢献しましょう';

  @override
  String get tap_to_answer => '質問に答えるにはここをタップ';

  @override
  String get tap_to_answer_hint => 'この製品に関する質問に回答するにはここをタップしてください';

  @override
  String get robotoff_questions_loading_hint => 'この製品に関する質問が読み込まれるまでお待ちください';

  @override
  String get saving_answer => '回答を保存しています';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Open Food Factsアカウントにログインして、貢献度を評価されましょう';

  @override
  String get question_yes_button_accessibility_value => '「はい」で回答';

  @override
  String get question_no_button_accessibility_value => 'No で回答';

  @override
  String get question_skip_button_accessibility_value => 'この質問をスキップ';

  @override
  String get tap_to_edit_search => 'タップして検索を編集';

  @override
  String get myPreferences => '好みの設定';

  @override
  String get account_create_message =>
      'アカウントを作成して Open Food Facts コミュニティに参加し、世界中で食品に関する知識の構築に貢献しましょう。';

  @override
  String get join_us => '参加する';

  @override
  String get myPreferences_profile_title => 'あなたのプロフィール';

  @override
  String get myPreferences_profile_subtitle =>
      'Open Food Facts 貢献者アカウントを管理します。';

  @override
  String get myPreferences_settings_title => 'アプリ設定';

  @override
  String get myPreferences_settings_subtitle => 'ダークモード、言語…';

  @override
  String get myPreferences_food_title => '食品の好み';

  @override
  String get myPreferences_food_subtitle => 'あなたにとって最も重要な食品に関する情報を選択してください。';

  @override
  String get myPreferences_food_comment =>
      '食品に関する最も重要な情報を選択すると、あなたの好みに応じて食品がランク付けされ、関心のある情報が最初に表示され、相性の概要が表示されます。これらの食品の好みはデバイスに保存され、Open Food Facts寄稿者アカウント（お持ちの場合）には関連付けられません。';

  @override
  String get confirmResetPreferences => '食品の好みをリセットしますか？';

  @override
  String get myPersonalizedRanking => 'おすすめランキング';

  @override
  String get ranking_tab_all => '全て';

  @override
  String get ranking_subtitle_match_yes => 'あなたにぴったり';

  @override
  String get ranking_subtitle_match_no => '非常に相性が悪い';

  @override
  String get ranking_subtitle_match_maybe => '一致度は不明';

  @override
  String get refresh_with_new_preferences => '新しい好みの設定でリストを更新';

  @override
  String get reloaded_with_new_preferences => '新しい好みの設定で再読み込みしました';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'スキャン';

  @override
  String get history_navbar_label => '履歴';

  @override
  String get list_navbar_label => 'リスト';

  @override
  String get category => 'カテゴリでフィルタ';

  @override
  String get category_all => '全て';

  @override
  String get category_search => '(カテゴリ検索)';

  @override
  String get filter => 'フィルタ';

  @override
  String get scan => 'スキャン画面の製品';

  @override
  String get scan_history => 'スキャン履歴';

  @override
  String get search => '検索';

  @override
  String get search_product_help => '製品、ブランド、またはバーコードを検索します。\n';

  @override
  String get search_filter => '検索フィルター';

  @override
  String get search_history => '検索履歴';

  @override
  String get search_store => '店舗を検索';

  @override
  String get search_store_help => 'ヒント: 都市または国を追加してください';

  @override
  String get tap_for_more => '詳細情報を表示するにはタップしてください…';

  @override
  String get product => '製品';

  @override
  String get unknownBrand => '不明なブランド';

  @override
  String get unknownProductName => '不明な製品名';

  @override
  String get label_refresh => '再読み込み';

  @override
  String get label_reload => 'リロード';

  @override
  String get image => '画像';

  @override
  String get front_photo => '正面画像';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (この画像は古い可能性があります)';
  }

  @override
  String get outdated_image_short_label => '時代遅れかもしれない';

  @override
  String get ingredients => '原材料';

  @override
  String get ingredients_editing_instructions =>
      '元の順序を維持してください。パーセンテージが指定されている場合は示してください。カンマまたはハイフンで区切り、成分を表す場合は括弧を使用してください。';

  @override
  String get ingredients_editing_error => '原材料を保存できませんでした。';

  @override
  String get ingredients_editing_image_error => '新しい原材料画像を取得できませんでした。';

  @override
  String get ingredients_editing_title => '原材料を編集';

  @override
  String get ingredients_photo => '原材料の画像';

  @override
  String get packaging_editing_instructions =>
      'カンマもしくは改行で区切られたすべてのパッケージの要素を、数量（例：1 または 6）、種類（例：ボトル、箱、缶）、素材（例：プラスチック、金属、アルミ）、サイズ（例：33cl）、リサイクルに関する指示とともに列記してください。\n例：リサイクルするガラス瓶1本、廃棄するプラスチックの栓1つ';

  @override
  String get packaging_editing_error => 'パッケージの保存に失敗しました。';

  @override
  String get packaging_editing_image_error => '新しいパッケージ画像を取得できませんでした。';

  @override
  String get packaging_editing_title => 'パッケージを編集';

  @override
  String get nutrition => '栄養';

  @override
  String get nutrition_facts_photo => '栄養成分表の画像';

  @override
  String get nutrition_facts_editing_title => '栄養成分表示を編集する';

  @override
  String get packaging_information => 'パッケージ情報';

  @override
  String get packaging_information_photo => 'パッケージ情報の画像';

  @override
  String get missing_product => '新しい製品を見つけました！';

  @override
  String get add_product_take_photos =>
      'パッケージの写真を撮って、この商品をOpen Food Factsに追加しましょう';

  @override
  String get add_product_take_photos_descriptive =>
      '最初に何枚か画像を撮ってください。後でいつでも製品を完成させることができます。';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => '新しい製品';

  @override
  String get new_product_found_title => '新商品発見！';

  @override
  String get new_product_found_text =>
      '当社の共同データベースには**300 万以上の製品**が含まれていますが、このバーコードは存在しません: ';

  @override
  String get new_product_found_button => 'この製品を追加';

  @override
  String get new_product_leave_title => 'このページから移動しますか？';

  @override
  String get new_product_leave_message => '何も入力されていないようです。本当にこのページを離れますか？';

  @override
  String get new_product_dialog_description =>
      'この製品を当社の共通データベースに追加するには、パッケージの写真を撮ってください。';

  @override
  String get new_product_dialog_illustration_description =>
      'Nutri-ScoreとGreen Scoreが不明なイラスト';

  @override
  String get front_packaging_photo_button_label => 'パッケージ正面の写真';

  @override
  String get confirm_front_packaging_photo_button_label =>
      '製品の正面画像のアップロードを確認する';

  @override
  String get confirm_button_label => '確定';

  @override
  String get send_image_button_label => '画像を送信';

  @override
  String get crop_page_action_saving => '画像を保存中…';

  @override
  String get crop_page_action_cropping => '画像を加工中...';

  @override
  String get crop_page_action_local => 'ローカルバージョンを保存しています…';

  @override
  String get crop_page_action_local_failed_title => '… あなたの写真に何かが含まれています!';

  @override
  String get crop_page_action_local_failed_message =>
      'サーバーに送信する前に画像をローカルで処理することができません。後でもう一度試すか、問題が解決しない場合はcontact-usをお試しください。';

  @override
  String get crop_page_action_retake => '写真を再撮影する';

  @override
  String get crop_page_too_small_image_title => '画像が小さすぎます!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return '画像のアップロードの最小サイズ（ピクセル単位）は ${expectedMinWidth}x$expectedMinHeightです。現在の画像は ${actualWidth}x$actualHeightです。';
  }

  @override
  String get crop_page_action_server => 'サーバーへの呼び出しを準備しています…';

  @override
  String get front_packaging_photo_title => 'パッケージの正面の画像';

  @override
  String get ingredients_photo_title => '原材料の画像';

  @override
  String get nutritional_facts_photo_title => '栄養成分表の画像';

  @override
  String get recycling_photo_title => 'リサイクル情報の画像';

  @override
  String get take_photo_title => '画像を撮る';

  @override
  String get take_more_photo_title => 'もっと写真を撮ります';

  @override
  String get front_photo_uploaded => '正面の画像をアップロードしました';

  @override
  String get ingredients_photo_button_label => '原材料の画像';

  @override
  String get ingredients_photo_uploaded => '原材料の画像がアップロードされました';

  @override
  String get nutrition_cache_loading_error => 'キャッシュから栄養成分を読み込むことができませんでした';

  @override
  String get nutritional_facts_photo_button_label => '栄養成分表の画像';

  @override
  String get nutritional_facts_input_button_label => '栄養成分表を入力する';

  @override
  String get nutritional_facts_added => '栄養成分表が追加されました';

  @override
  String get categories_added => 'カテゴリーが追加されました。';

  @override
  String get new_product_title_nutriscore => 'ニュートリスコアを計算する';

  @override
  String get new_product_subtitle_nutriscore => '食品カテゴリと栄養価を満たして入手する';

  @override
  String get new_product_title_environmental_score => 'グリーンスコアを計算する';

  @override
  String get new_product_subtitle_environmental_score =>
      '少なくとも1つのカテゴリを入力して取得してください';

  @override
  String get new_product_additional_environmental_score =>
      '原産地、パッケージなどを考慮してグリーンスコアの計算をより正確にします';

  @override
  String get new_product_title_nova => '食品加工レベルを計算する（NOVA）';

  @override
  String get new_product_subtitle_nova => '食品カテゴリーと材料を入力して入手';

  @override
  String get new_product_desc_nova_unknown => '食品加工レベル不明';

  @override
  String get new_product_title_pictures => '写真を撮りましょう！';

  @override
  String get new_product_title_pictures_details =>
      '以下の写真を撮ってください。あとは Open Food Facts エンジンが計算します。';

  @override
  String get new_product_title_misc => 'そしていくつかの基本データ…';

  @override
  String new_product_done_msg(String username) {
    return 'ご協力ありがとうございます。「$username」！';
  }

  @override
  String get new_product_done_msg_no_user => 'ご協力ありがとうございました！';

  @override
  String get new_product_done_button_label => '完成した製品を探す';

  @override
  String get hey_incomplete_product_message =>
      '今すぐタップして 3 つの質問に答え、Nutri-Score、Green Score、Ultra-processing (NOVA) を計算しましょう。';

  @override
  String get hey_incomplete_product_message_beauty =>
      '今すぐタップして 2 つの質問に答え、この化粧品の分析に役立ててください。';

  @override
  String get hey_incomplete_product_message_pet_food =>
      '今すぐタップして 3 つの質問に答え、このペットフード製品を分析してください。';

  @override
  String get hey_incomplete_product_message_product => '今すぐタップしてこの製品を完成させましょう!';

  @override
  String get nutritional_facts_photo_uploaded => '栄養成分表の画像がアップロードされました';

  @override
  String get recycling_photo_button_label => 'リサイクル情報の画像';

  @override
  String get recycling_photo_uploaded => 'リサイクル情報の画像がアップロードされました';

  @override
  String get take_more_photo_button_label => 'もっと写真を撮ります';

  @override
  String get other_photo_uploaded => 'その他の画像がアップロードされました';

  @override
  String get retake_photo_button_label => 'リテイク';

  @override
  String get selecting_photo => '画像を選択中です';

  @override
  String get uploading_image => 'サーバーに画像をアップロードしています';

  @override
  String get uploading_image_type_front => 'Open Food Factsにフロント画像をアップロードしています';

  @override
  String get uploading_image_type_ingredients =>
      'Open Food Factsに原材料画像をアップロードしています';

  @override
  String get uploading_image_type_nutrition =>
      'Open Food Factsに栄養画像をアップロードしています';

  @override
  String get uploading_image_type_packaging =>
      'Open Food Factsにパッケージ画像をアップロードしています';

  @override
  String get uploading_image_type_other => 'Open Food Factsに他の画像をアップロードしています';

  @override
  String get uploading_image_type_generic => 'Open Food Factsに画像をアップロードしています';

  @override
  String get score_add_missing_ingredients => '不足している原材料を追加';

  @override
  String get score_add_missing_packaging_image => '不足しているパッケージ画像を追加';

  @override
  String get score_add_missing_nutrition_facts => '不足している栄養成分表を追加';

  @override
  String get score_add_missing_product_traces => '不足している製品トレースを追加する';

  @override
  String get score_add_missing_product_category => '不足している製品カテゴリを追加';

  @override
  String get score_add_missing_precise_product_category => 'より正確なカテゴリを選択してください';

  @override
  String get score_add_missing_product_countries => '不足している製品の国を追加';

  @override
  String get score_add_missing_product_emb => '不足している製品のトレーサビリティコードを追加';

  @override
  String get score_add_missing_product_labels => '不足している製品ラベルを追加';

  @override
  String get score_add_missing_product_origins => '不足している製品の産地を追加';

  @override
  String get score_add_missing_product_stores => '不足している製品の販売店を追加';

  @override
  String get score_add_missing_product_brands => '不足している製品ブランドを追加する';

  @override
  String get score_update_nutrition_facts => '栄養成分表を更新';

  @override
  String get nutrition_page_title => '栄養成分表';

  @override
  String get nutrition_page_nutritional_info_title => '栄養情報';

  @override
  String get nutrition_page_nutritional_info_label => '製品に指定されている値:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'はい';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'いいえ';

  @override
  String get nutrition_page_nutritional_info_open_photo => '写真を開く';

  @override
  String get nutrition_page_nutritional_info_explanation_title => '良い実践：栄養情報';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      '栄養成分表示は、**パッケージ**や製品に同梱されている書類に記載されていない場合があります。そのような場合のみ、値を**いいえ**に設定できます。';

  @override
  String get nutrition_page_serving_type_label => '栄養価:';

  @override
  String get nutrition_page_per_100g => '100gあたり';

  @override
  String get nutrition_page_per_100g_100ml => '100g/mlあたり';

  @override
  String get nutrition_page_per_serving => '一食当たり';

  @override
  String get nutrition_page_add_nutrient => '栄養成分を追加';

  @override
  String get nutrition_page_serving_size => '一人前の分量';

  @override
  String get nutrition_page_serving_size_hint => '1食分の量を入力してください（例：100g）';

  @override
  String get nutrition_page_serving_size_explanation_title => '良い実践：サービングサイズ';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'この値は、**1 食分あたりの各栄養素の比率計算を行う** のに役立ちます。';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**使用できる単位**は、kg、g、mg、µg、oz、l、dl、cl、ml、fl.oz、fl oz、г、мг、кг、л、дл、кл、мл、毫克、公斤、毫升、公升、吨です。';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**、**60g**、または**60 G**（最初のものを優先）';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** または **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      '無効な単位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **グラム**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      '無効な単位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9個の**キャンディー**と2個の**ビスケット**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'ユニットが見つかりません';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => '無効な数字です';

  @override
  String get nutrition_page_update_running => 'サーバー…で製品を更新しています';

  @override
  String get nutrition_page_update_done => '製品が更新されました！';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      '製品の量を1食分量として使用します';

  @override
  String get nutrition_page_photo_error => '写真を読み込めません';

  @override
  String get more_photos => 'より興味深い画像';

  @override
  String get view_more_photo_button => 'この製品の既存の写真をすべて表示';

  @override
  String get no_product_found => '製品が見つかりません';

  @override
  String get no_location_found => '場所が見つかりません';

  @override
  String get not_found => '見つかりません:';

  @override
  String get refreshing_product => '製品を更新中';

  @override
  String get product_refreshed => '製品が更新されました';

  @override
  String product_image_accessibility_label(String date) {
    return '$dateに撮影された画像';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return '画像は $dateに撮影されました。この画像は古い可能性があります';
  }

  @override
  String get product_image_outdated => 'この画像は古い可能性があります';

  @override
  String get product_image_outdated_explanations_title => 'この画像は古い可能性があります';

  @override
  String get product_image_outdated_explanations_content =>
      'この画像は1年以上前に撮影されたものです。\n**最新の状態であることを確認してください**。\n\nこれは**単なる警告**です。内容が変わっていない場合は、このメッセージを無視してください。';

  @override
  String product_image_action_replace_photo(String type) {
    return '写真を置き換える ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return '写真を追加する ($type)';
  }

  @override
  String get product_image_action_take_new_picture => '新しく撮影する';

  @override
  String get product_image_action_take_picture => '画像を撮る';

  @override
  String get product_image_action_from_gallery => '携帯電話のギャラリーから選択してください';

  @override
  String get product_image_action_choose_existing_photo => '商品写真から選択';

  @override
  String get product_image_details_label => '写真に関する情報';

  @override
  String get product_image_details_from_producer => 'プロデューサーより';

  @override
  String get product_image_details_contributor => '貢献者';

  @override
  String get product_image_details_contributor_producer => '貢献者（プロデューサー）';

  @override
  String get product_image_details_date => '日付';

  @override
  String get product_image_details_date_unknown => '不明';

  @override
  String get homepage_main_card_logo_description => 'オープンフードファクトへようこそ';

  @override
  String get homepage_main_card_subheading =>
      'バーコードを**スキャン**するか、製品を\n**検索**してください';

  @override
  String get homepage_main_card_search_field_hint => '商品を検索';

  @override
  String get homepage_main_card_search_field_tooltip => '検索を開始';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return '最新ニュース: $news_title';
  }

  @override
  String get tagline_app_review => 'アプリを気に入っていただけましたか？';

  @override
  String get tagline_app_review_button_positive => '大好きです！ 😍';

  @override
  String get tagline_app_review_button_negative => 'そうでもないんですが...';

  @override
  String get tagline_app_review_button_later => 'あとで';

  @override
  String get tagline_feed_news_button => 'さらに詳しく';

  @override
  String get app_review_negative_modal_title => 'このアプリを気に入っていますか？';

  @override
  String get app_review_negative_modal_text => 'その理由を少し教えていただけますか?';

  @override
  String get app_review_negative_modal_positive_button => 'そのとおり！';

  @override
  String get app_review_negative_modal_negative_button => 'いいえ';

  @override
  String get could_not_refresh => '製品を更新できませんでした';

  @override
  String get product_internet_error_modal_title => 'エラーが発生しました!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'ネットワークエラーのため、この製品に関する情報を取得できません。インターネット接続をご確認の上、もう一度お試しください。\n\n内部エラー:\n$error';
  }

  @override
  String get product_tags_title => '製品特性';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'プロパティなし';

  @override
  String get product_tags_explanation =>
      '製品にプロパティ (キー/値) を追加することで、製品の充実に貢献できます。';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'プロパティを追加する';

  @override
  String get add_edit_tags => 'プロパティを追加または編集する';

  @override
  String get edit_tag => 'プロパティを編集';

  @override
  String get remove_tag => 'プロパティを削除';

  @override
  String get tag_key => '財産';

  @override
  String get tag_keys => 'プロパティ';

  @override
  String get tag_key_uneditable => 'プロパティ（編集不可）';

  @override
  String get tag_key_input_hint => 'プロパティを入力する';

  @override
  String get tag_value => '値：';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => '値を入力してください';

  @override
  String get tag_key_item => '財産：';

  @override
  String get tag_value_item => '価値：';

  @override
  String get tag_key_explanations => 'キーは小文字でスペースが含まれないようにする必要があります。';

  @override
  String tag_key_already_exists(String property) {
    return 'プロパティ $property を持つタグがすでに存在します。';
  }

  @override
  String get product_internet_error => 'ネットワークエラーのため、この製品に関する情報を取得できません。';

  @override
  String get cached_results_from => '結果の最終更新：';

  @override
  String get product_search_same_category => '代替案を探す';

  @override
  String get product_search_same_category_short => 'Compare';

  @override
  String get product_search_same_category_error =>
      'この機能は、カテゴリのある製品にのみ使用できます。\n\nカテゴリを追加するには、製品を編集してください。';

  @override
  String get product_improvement_add_category =>
      'Nutri-Scoreを計算するために、カテゴリを追加してください。';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Nutri-Scoreを計算するために、栄養成分表を追加してください。';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Nutri-Scoreを計算するために、栄養成分表とカテゴリを追加してください。';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'この製品のNutri-Scoreは計算できません。例えば、標準的ではないカテゴリが原因である可能性があります。もしこれがエラーだと考えられる場合、お問い合わせください。';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      '栄養成分の画像が古くなっています。更新してください。';

  @override
  String get product_improvement_origins_to_be_completed =>
      'グリーンスコアは原材料の原産地を考慮します。原材料リストや地理的表示の記載を写真に撮るか、商品情報を編集して、グリーンスコアに反映させてください。';

  @override
  String get country_chooser_label => '国を選んでください';

  @override
  String get currency_chooser_label => '通貨を選んでください';

  @override
  String get country_change_message => '国を変更しました。';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return '通貨を $previousCurrency から $possibleCurrency に変更しますか?';
  }

  @override
  String get onboarding_country_chooser_label => '国を選択してください';

  @override
  String get country_chooser_label_from_settings => 'あなたの国';

  @override
  String get country_selection_explanation => '一部の環境特性は場所固有です';

  @override
  String get product_removed_comparison => '比較から削除された製品';

  @override
  String get native_app_settings => 'ネイティブアプリ設定';

  @override
  String get native_app_description => 'Open Food Factsのオープンシステム設定';

  @override
  String get product_removed_history => '履歴から削除された製品';

  @override
  String get product_removed_list => 'リストから削除された商品';

  @override
  String get product_could_not_remove => '製品を削除できませんでした';

  @override
  String get no_prodcut_in_list => 'このリストには製品がありません';

  @override
  String get no_product_in_section => 'このリストには製品がありません';

  @override
  String get recently_seen_products => '閲覧されたすべての製品';

  @override
  String get clear => 'クリア';

  @override
  String get clear_long => 'リストを空にする';

  @override
  String get really_clear => '本当にこのリストを削除しますか？';

  @override
  String pct_match(Object percent) {
    return '$percent% マッチ';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 日前',
      one: '1 日前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 時間前',
      one: '1 時間前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 分前',
      one: '1 分前',
      zero: '1分以内',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ヶ月前',
      one: '1 ヶ月前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 週間前',
      one: '1 週間前',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 個の製品を比較',
      one: '1 個の製品を比較',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 選択された製品',
      one: '選択された製品 1 つ',
      zero: '選択された製品はありません',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => '選択した製品を比較する';

  @override
  String get delete_products_mode => '選択した商品を削除';

  @override
  String get select_all_products_mode => 'すべての製品を選択';

  @override
  String get select_none_products_mode => '何も選択しない';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle => '製品を2つ以上選択してください';

  @override
  String get retry_button_label => '再試行';

  @override
  String get connect_with_us => '私たちとつながる';

  @override
  String get tiktok => 'TikTokでフォローしてください';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Instagram でフォロー';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'X (旧 Twitter) でフォローしてください';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'マストドンでフォローしてください';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'BlueSkyをフォローしてください';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'ブログ';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => '見つける';

  @override
  String get how_to_contribute => '貢献方法';

  @override
  String get hint_knowledge_panel_message =>
      'カードの任意の部分をタップすると、さらに詳細な情報を確認できます。試してみてください！';

  @override
  String get permissions_page_title => 'カメラへのアクセス権限';

  @override
  String get permissions_page_body1 => '携帯電話のカメラでバーコードをスキャンするには、アクセスを許可してください。';

  @override
  String get permissions_page_body2 => '気が変わった場合、設定からいつでも切り替えることができます。';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Release: $release)\nモデル: $model\n製品: $product\nデバイス: $device\nブランド:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nモデル: $model\nローカライズされたモデル: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nアプリのバージョン：$appVersion\nアプリのビルド番号：$appBuildNumber\nアプリのパッケージ名：$appPackageName';
  }

  @override
  String get authorize_button_label => '許可する';

  @override
  String get refuse_button_label => '拒否する';

  @override
  String get ask_me_later_button_label => '後で';

  @override
  String get are_you_sure => 'よろしいですか？';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return '$sourceName に進む';
  }

  @override
  String get onboarding_home_welcome_text1 => 'いらっしゃいませ ！';

  @override
  String get onboarding_home_welcome_text2 =>
      '**あなた**と**地球**に良い食べ物を選ぶのに役立つアプリです!';

  @override
  String get onboarding_continue_button => '続ける';

  @override
  String get onboarding_welcome_loading_dialog_title => '最初の見本となる製品を読み込んでいます';

  @override
  String get onboarding_welcome_warning => '申し訳ありませんが、これはサンプル製品なので編集できません :)';

  @override
  String get product_list_your_ranking => 'あなたのランキング';

  @override
  String get product_list_empty_icon_desc => '履歴がありません';

  @override
  String get product_list_empty_title => 'スキャン開始';

  @override
  String get product_list_empty_message => 'スキャンした製品がここに表示され、それらの詳細情報を確認できます';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '商品',
      one: '商品',
      zero: '商品',
    );
    return '更新中 $_temp0';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '製品',
      one: '製品',
      zero: '製品',
    );
    return '$_temp0 更新完了';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'データをダウンロード中';

  @override
  String get loading_dialog_default_error_message => 'データをダウンロードできませんでした';

  @override
  String get account_delete => 'アカウントを削除';

  @override
  String get account_delete_title => 'アカウントを削除する';

  @override
  String get user_profile => 'アカウント';

  @override
  String get user_profile_title_guest => 'ようこそ！';

  @override
  String get user_profile_subtitle_guest =>
      'Open Food Factsコミュニティに参加するには、サインインまたはサインアップしてください。';

  @override
  String user_profile_title_id_email(String email) {
    return 'Food Factsログインを開く: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return '$id さん、ようこそ！';
  }

  @override
  String get email_subject_account_deletion => 'アカウントを削除';

  @override
  String email_body_account_deletion(String userId) {
    return 'こんにちは。Open Food Factsのアカウントを削除してください: $userId';
  }

  @override
  String get settings_app_app => 'アプリケーション';

  @override
  String get settings_app_data => 'プライバシーと監視';

  @override
  String get settings_app_camera => 'カメラ';

  @override
  String get settings_app_products => '製品';

  @override
  String get settings_app_miscellaneous => 'その他';

  @override
  String get camera_play_sound_title => 'スキャン時にサウンドを再生する';

  @override
  String get camera_play_sound_subtitle => 'スキャンが成功するたびにビープ音が鳴ります';

  @override
  String get camera_window_accessibility_label => 'カメラでバーコードをスキャンする';

  @override
  String get app_haptic_feedback_title => '振動と触覚フィードバック';

  @override
  String get app_haptic_feedback_subtitle =>
      '一部アクション（バーコードの解読、製品の削除…）を行った後に振動させる。';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      '有効にすると、クラッシュ レポートが Open Food Facts のエラー追跡システムに自動的に送信され、バグが修正されてアプリが改善されます。';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => '写真を編集';

  @override
  String get permission_photo_error => 'エラー';

  @override
  String get permission_photo_denied_title => 'カメラによるバーコードのスキャンを許可する';

  @override
  String permission_photo_denied_message(String appName) {
    return 'エクスペリエンスを向上させるために、カメラへのアクセスを $appName に許可してください。バーコードを直接スキャンできるようになります。';
  }

  @override
  String get permission_photo_denied_button => '許可する';

  @override
  String get permission_photo_denied_dialog_settings_title => '権限が拒否されました';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      '以前カメラの権限を拒否したため、設定から許可する必要があります。';

  @override
  String get permission_photo_denied_dialog_settings_button_open => '設定を開く';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => '取消';

  @override
  String get permission_photo_none_found => 'カメラを検出できませんでした';

  @override
  String get permission_photo_denied => 'カメラへのアクセス権限がありません';

  @override
  String get show_product_pictures => '製品写真を表示';

  @override
  String get edit_product_label => '製品を編集';

  @override
  String get edit_product_pending_operations_banner_title =>
      '編集内容をアップロードしています…';

  @override
  String get edit_product_pending_operations_banner_message =>
      '編集内容は**バックグラウンドで送信**されています（エラーの場合は後で送信されます）。\n他の製品フィールドの編集を続行できます。';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      '編集内容は**バックグラウンドで**送信されています（エラーの場合は後で送信されます）。';

  @override
  String get edit_product_label_short => '編集';

  @override
  String edit_product_form_item_help(String value) {
    return '「$value」を入力するにはどうすればいいですか？';
  }

  @override
  String get edit_product_form_item_error_empty => '空でない値を入力してください。';

  @override
  String get edit_product_form_item_error_existing => 'この価値はすでに存在します!';

  @override
  String get edit_product_form_item_add_action_brand => '新しいブランドを追加する';

  @override
  String get edit_product_form_item_add_action_label => '新しいラベルを追加する';

  @override
  String get edit_product_form_item_add_action_store => '新しいストアを追加する';

  @override
  String get edit_product_form_item_add_action_origin => '新しいオリジンを追加する';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      '新しいトレーサビリティコードを追加する';

  @override
  String get edit_product_form_item_add_action_country => '新しい国を追加する';

  @override
  String get edit_product_form_item_add_action_category => '新しいカテゴリを追加する';

  @override
  String get edit_product_form_item_add_action_trace => '新しいトレースを追加する';

  @override
  String get edit_product_form_item_add_suggestion => '提案を追加';

  @override
  String get edit_product_form_item_deny_suggestion => '提案を拒否';

  @override
  String get edit_product_form_item_details_title => '基本情報';

  @override
  String get edit_product_form_item_details_subtitle => '製品名、ブランド、数量';

  @override
  String get edit_product_form_item_other_details_title => '追加情報';

  @override
  String get edit_product_form_item_other_details_subtitle => 'ウェブサイト…';

  @override
  String get edit_product_form_item_photos_title => '写真';

  @override
  String get edit_product_form_item_photos_subtitle => '画像の追加または更新';

  @override
  String get edit_product_form_item_labels_title => 'ラベルと認証';

  @override
  String get edit_product_form_item_labels_subtitle => '環境、品質ラベル…';

  @override
  String get edit_product_form_item_labels_hint => 'ラベルを入力してください（例：NutriScore）';

  @override
  String get edit_product_form_item_labels_type => 'ラベル';

  @override
  String get edit_product_form_item_labels_explanation_title => '優れた実践：ラベル';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      '**事実に基づく**、他の分野とは異なる製品の特性。';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'ニュートリスコア、NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'ベルギー製、ブルターニュ産…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001、ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      '食物繊維が豊富で鉄分も豊富です…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'フェアトレード、マックス・ハブラー…';

  @override
  String get edit_product_form_item_stores_title => '店舗';

  @override
  String get edit_product_form_item_stores_hint => '店舗を入力してください';

  @override
  String get edit_product_form_item_stores_type => '店舗';

  @override
  String get edit_product_form_item_stores_explanation_title => 'グッドプラクティス：店舗';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      '商品を購入した店舗を入力してください。';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'ウォルマート';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'カルフール';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 => 'リドル';

  @override
  String get edit_product_form_item_origins_title => '原産国';

  @override
  String get edit_product_form_item_origins_hint => '原産地を入力してください（例：ドイツ）';

  @override
  String get edit_product_form_item_origins_type => '国';

  @override
  String get edit_product_form_item_origins_explanation_title => 'グッドプラクティス：起源';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '**パッケージに記載されている原産地の表示をすべて追加してください**。\n原材料リストに直接記載されている原産地については心配する必要はありません。';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'アルゼンチン産牛肉';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      '大豆は欧州連合産ではない';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint => '国を入力してください（例：ドイツ）';

  @override
  String get edit_product_form_item_countries_type => '国';

  @override
  String get edit_product_form_item_countries_explanations_title => '優れた実践例：国';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**製品が広く入手可能な国**（海外製品専門店は除く）。';

  @override
  String get edit_product_form_item_emb_codes_title => 'トレーサビリティコード';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'コードを入力してください (例: EMB 53062、FR 62.448.034 CE、84 R 20、33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'トレーサビリティコード';

  @override
  String get edit_product_form_item_emb_help_title => '優れた実践：トレーサビリティコード';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'このセクションでは、**梱包マーク**、**識別マーク**、**衛生マーク**に関連するコードを入力できます。';

  @override
  String get edit_product_form_item_emb_help_info2_title => 'トレーサビリティコードの例';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC コード** は、欧州共同体で食品生産者または包装業者を識別するために使用されます。';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'フランス\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **フランス** の国コード\n**72.264.002**: 地理データ\n**CE**: 欧州共同体';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      'フランスで使用される**EMBコード**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => '形跡';

  @override
  String get edit_product_form_item_traces_hint => '形跡';

  @override
  String get edit_product_form_item_traces_type => 'トレースを入力します（例：大豆）';

  @override
  String get edit_product_form_item_categories_title => 'カテゴリー';

  @override
  String get edit_product_form_item_categories_hint => 'カテゴリー';

  @override
  String get edit_product_form_item_categories_type =>
      'カテゴリを入力してください（例：オレンジジュース）';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'グッドプラクティス: カテゴリ';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**最も具体的なカテゴリのみ**を指定します。\n親カテゴリは自動的に追加されます。';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'カテゴリがありませんか?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'カテゴリが**オートコンプリートで利用できない**場合でも、自由に追加してください。\nこれは、あなたの国での Open Food Facts の改善に役立ちます。';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'オリーブオイル漬けイワシ';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      '濃縮オレンジジュース';

  @override
  String get edit_product_form_item_exit_title => '保存せずに終了しますか?';

  @override
  String get edit_product_form_item_exit_confirmation => 'ページを離れる前に変更を保存しますか？';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      '変更を保存';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      '変更を破棄';

  @override
  String get edit_product_form_item_ingredients_title => '原材料';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      '画面をピンチしてズームイン・ズームアウト';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      '写真を拡大・縮小する';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**ピンチしてズームするジェスチャ** を使用すると、写真を拡大または縮小できます。';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => '追加';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'まずは文字を入力してください';

  @override
  String get edit_product_form_item_remove_item_tooltip => '削除する';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => '編集内容を保存する';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip => '編集をキャンセル';

  @override
  String get edit_product_form_item_packaging_title => 'リサイクル手順の画像';

  @override
  String get edit_product_form_item_nutrition_facts_title => '栄養成分表';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      '栄養成分、アルコール含有量…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      '良い実践：栄養成分表示';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      '栄養価';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'まず、**値が提供される**かどうかを選択します。';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      '栄養成分表';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      '次に、**パッケージに記載されている栄養成分**を入力してください。栄養成分値が表示されていない場合は、「目」アイコンをクリックしてください。';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'フィールドがありませんか?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'エントリが不足している場合は、**「プラス」アイコンをクリックして**追加できます (例: ビタミン D、マグネシウム…)。';

  @override
  String get edit_product_form_save => '編集';

  @override
  String get edit_product_ingredients_photo_title => '原材料の画像';

  @override
  String get edit_product_ingredients_list_title => '原材料の一覧';

  @override
  String get edit_product_packaging_photo_title => 'パッケージ写真';

  @override
  String get edit_product_packaging_list_title => 'パッケージリスト';

  @override
  String get no_data_available => '利用可能なデータがありません。';

  @override
  String get product_field_website_title => 'ウェブサイト';

  @override
  String get origins_editing_title => '起源を編集';

  @override
  String get completed_basic_details_btn_text => '基本情報を完成させる';

  @override
  String get not_implemented_snackbar_text => 'まだ実装されていません';

  @override
  String get category_picker_page_appbar_text => 'カテゴリー';

  @override
  String get edit_ingredients_extract_ingredients_btn_text => '写真から材料を抽出する';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short => '原材料を抽出';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text => '写真から材料を抽出\n';

  @override
  String get edit_ingredients_loading_photo_btn_text => '写真を読み込んでいます…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'なぜこのメッセージが表示されるのでしょうか?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '「材料抽出」機能を使用するには、まず写真をアップロードする必要があります。\n\n数秒待つか、手動で入力してください。';

  @override
  String get edit_ingredients_refresh_photo_btn_text => '画像を更新';

  @override
  String get edit_packaging_extract_btn_text => '写真からパッケージ\nを抽出します';

  @override
  String get edit_packaging_extract_btn_text_short => '抽出パッケージ';

  @override
  String get edit_packaging_extracting_btn_text => '写真からパッケージを抽出する';

  @override
  String get edit_packaging_loading_photo_btn_text => '写真を読み込んでいます…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'なぜこのメッセージが表示されるのでしょうか?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '「パッケージ抽出」機能を使用するには、まず写真をアップロードする必要があります。\n\n数秒待つか、手動で入力してください。';

  @override
  String get edit_packaging_refresh_photo_btn_text => '画像を更新';

  @override
  String get edit_ocr_extract_failed => '画像内のテキストを検出できませんでした。';

  @override
  String get edit_ocr_extract_disabled_title => '写真がありません！';

  @override
  String get edit_ocr_extract_disabled_message =>
      'テキスト抽出機能を使用するには、まず写真を撮る必要があります。';

  @override
  String get user_list_dialog_new_title => '新規製品リスト';

  @override
  String get user_list_dialog_rename_title => 'リスト名を変更';

  @override
  String get user_list_subtitle_product => 'リスト';

  @override
  String get user_list_title => 'あなたのリスト';

  @override
  String get user_list_add_product => '製品をリストに追加';

  @override
  String get user_list_button_new => '新しいリストを作成する';

  @override
  String get user_list_empty_label => 'まだリストがありません。リストを作成してください。';

  @override
  String get user_list_button_add_product => 'リストに追加';

  @override
  String get added_to_list_msg => 'リストに追加されました';

  @override
  String get user_list_popup_clear => '履歴を消去する';

  @override
  String get user_list_popup_rename => '名前を変更';

  @override
  String get user_list_name_hint => 'マイリスト';

  @override
  String get user_list_name_error_empty => '名前は必須です';

  @override
  String get user_list_name_error_already => 'この名前は既に使用されています';

  @override
  String get user_list_name_error_same => '同じ名前です';

  @override
  String get user_list_name_input_hint => 'リストの名前';

  @override
  String get try_again => '再試行';

  @override
  String get there_was_an_error => 'エラーが発生しました';

  @override
  String category_picker_no_category_found_message(String items) {
    return '$items のカテゴリが見つかりませんでした';
  }

  @override
  String get camera_toggle_camera => '前面カメラと背面カメラを切り替える';

  @override
  String get camera_toggle_flash => 'カメラのフラッシュをONまたはOFFにする';

  @override
  String get camera_enable_flash => 'フラッシュを有効にする';

  @override
  String get camera_disable_flash => 'フラッシュを無効にする';

  @override
  String get camera_flash_error_dialog_title => 'エラーが発生しました!';

  @override
  String get camera_flash_error_dialog_message =>
      'フラッシュの状態を変更中にエラーが発生しました。スマートフォンでフラッシュが既に有効になっていないことを確認してください。';

  @override
  String get category_picker_no_category_found_button => '戻る';

  @override
  String get user_preferences_item_accessibility_hint =>
      'クリックしてブラウザまたはアプリケーションで開く（インストールされている場合）';

  @override
  String get dev_preferences_screen_title => '開発者モード';

  @override
  String get dev_preferences_screen_subtitle => '実験的な機能と開発ツールにアクセスする';

  @override
  String get dev_preferences_reset_onboarding_title => 'オンボーディングをやり直す';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      '再び表示するにはアプリを再起動する必要があります。';

  @override
  String get dev_preferences_environment_switch_title =>
      'openfoodfacts.org (PROD)とtest環境の切り替え';

  @override
  String get dev_preferences_test_environment_title => 'テスト環境のパラメータ';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return '現在のテスト環境のベースURL： $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title => 'テスト環境のホスト';

  @override
  String get dev_preferences_ml_kit_title => 'MLキットを使う';

  @override
  String get dev_preferences_ml_kit_subtitle => 'その後、アプリを再起動する必要があります';

  @override
  String get dev_preferences_product_additional_features_title =>
      '製品ページに追加ボタンを配置';

  @override
  String get dev_preferences_edit_ingredients_title => 'ナレッジパネルのボタンから原材料を編集する';

  @override
  String get dev_preferences_export_history_title => '履歴をエクスポート';

  @override
  String get dev_preferences_export_history_progress_error => 'エラー';

  @override
  String get dev_preferences_export_history_progress_found => '製品が見つかりました';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      '製品が見つかりませんでした';

  @override
  String get dev_preferences_export_history_dialog_title => '履歴をエクスポート';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => '取消';

  @override
  String get dev_preferences_migration_title => 'V1からのデータ移行';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'ステータス：$status';
  }

  @override
  String get dev_preferences_migration_status_already_done => '成功または新規インストール';

  @override
  String get dev_preferences_migration_status_success => '成功';

  @override
  String get dev_preferences_migration_status_error => 'エラー';

  @override
  String get dev_preferences_migration_status_in_progress => '進行中';

  @override
  String get dev_preferences_migration_status_required => '必要（クリックしてスタート）';

  @override
  String get dev_preferences_migration_status_not_started => '不明';

  @override
  String get dev_preferences_import_history_subtitle => '履歴をクリアし、3つの製品を追加します';

  @override
  String get dev_preferences_news_custom_url_title => 'ニュースのカスタムURL';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON ファイルの URL:';

  @override
  String get dev_preferences_news_custom_url_empty_value => '未設定';

  @override
  String get dev_preferences_news_provider_status_title => '状態';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return '最終更新: $date';
  }

  @override
  String get product_type_label_food => '食べ物';

  @override
  String get product_type_label_beauty => 'パーソナルケア';

  @override
  String get product_type_label_pet_food => 'ペットフード';

  @override
  String get product_type_label_product => 'その他';

  @override
  String get product_type_selection_title => '製品タイプ';

  @override
  String get product_type_selection_subtitle => 'この製品の種類を選択してください';

  @override
  String get product_type_selection_empty => 'まず製品タイプを選択する必要があります。';

  @override
  String product_type_selection_already(String productType) {
    return '製品タイプ ($productType) を変更することはできません。';
  }

  @override
  String get prices_app_dev_mode_flag => '製品ページの価格アプリへのショートカット';

  @override
  String get prices_app_button => '価格アプリに移動';

  @override
  String get prices_website_button => 'Open Pricesウェブサイトで開く';

  @override
  String get prices_bulk_proof_upload_select => 'ギャラリーから直接値札を追加';

  @override
  String get prices_bulk_proof_upload_warning => '画像を選択すると、編集できなくなります。';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'AI によって抽出された価格をコミュニティが検証できるようにします。';

  @override
  String get prices_bulk_proof_upload_subtitle => '複数の値札';

  @override
  String get prices_bulk_proof_upload_title => '一括校正アップロード';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'ファイルの選択';

  @override
  String get prices_bulk_proof_upload_step_starting => 'アップロードを開始';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'ファイル #$index/$countをローカルにコピーしています';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'アップロードを準備中 #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return '画像 #$index/$countで失敗しました';
  }

  @override
  String get prices_generic_title => '価格';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 価格を追加します',
      one: '価格を追加します',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '価格を送信 $count',
      one: '価格を送信',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'アイテムを追加する';

  @override
  String get prices_add_a_price => '価格を追加する';

  @override
  String get prices_add_a_receipt => '領収書を追加する';

  @override
  String get prices_add_price_tags => '値札を追加する';

  @override
  String prices_barcode_already(String barcode) {
    return 'このバーコード ($barcode) はすでにリストに存在します。';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'まだ製品はありません';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcodeを探しています';
  }

  @override
  String get prices_barcode_enter => 'バーコードを入力してください';

  @override
  String get prices_category_enter => 'バーコードのない商品';

  @override
  String get prices_per_kilogram => 'キログラムあたりの価格';

  @override
  String get prices_per_unit => '単位あたりの価格';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / ユニット';

  @override
  String get prices_category_mandatory => '必須';

  @override
  String get prices_category_optional => 'オプション';

  @override
  String get prices_category_error_mandatory => 'カテゴリーは必須です';

  @override
  String get prices_barcode_reader_action => 'バーコードリーダー';

  @override
  String get prices_view_prices => '価格を見る';

  @override
  String get prices_list_title => '価格表';

  @override
  String get prices_list_count => '\n価格の数';

  @override
  String get prices_list_add_new_price => '新しい価格を\n追加する';

  @override
  String get prices_list_empty_title => '価格はまだありません!';

  @override
  String get prices_list_empty_subtitle =>
      '最初に追加するには:\n**レシート**または**値札**をスキャンしてください!';

  @override
  String get prices_entry_shop_not_found => '不明な店舗';

  @override
  String prices_entry_menu_title(String user) {
    return '価格入力は「$user」から';
  }

  @override
  String get prices_entry_menu_open_product_prices => 'この商品のすべての価格を見る';

  @override
  String get prices_entry_menu_open_proof => '証拠を見る';

  @override
  String get prices_entry_menu_my_prices => '他の価格を見る';

  @override
  String get prices_entry_menu_author_prices => '著者による他の価格を見る';

  @override
  String get prices_entry_menu_shop_prices => 'ショップの他の価格を見る';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count の価格',
      one: '1 つの価格',
    );
    return '$_temp0 は $productです';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'すべての $count の価格',
      one: '価格は 1 つだけです',
      zero: '価格はまだ設定されていません',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return '最新の $pageSize 価格（合計: $total）';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return '価格: $price / ストア: \"$location\" / 公開日: $date 、投稿者: \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '「$user」の公開証明';
  }

  @override
  String get prices_open_proof => 'オープン価格証明';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'すべての $count 証明があります',
      one: '証明は 1 つだけです',
      zero: 'まだ証明されていません',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return '最新の $pageSize 個の証明 (合計: $total)';
  }

  @override
  String get prices_users_empty_title => 'まだ貢献者がいません!';

  @override
  String get prices_users_empty_explanation => '最初に価格を追加してください!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return '上位 $pageSize 人の貢献者 (合計: $total)';
  }

  @override
  String get prices_locations_empty_title => 'まだショップはありません！';

  @override
  String get prices_locations_empty_explanation => '最初に価格を追加してください!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return '上位 $pageSize か所 (合計: $totalか所)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 証明あり',
      one: '証明1つ',
      zero: '証明なし',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 商品',
      one: '商品1個',
      zero: '商品なし',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ユーザー',
      one: 'ユーザー 1 人',
      zero: 'ユーザーなし',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 価格',
      one: '単一価格',
      zero: '価格なし',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => '以前に追加された価格';

  @override
  String get prices_amount_subtitle => '額';

  @override
  String get prices_amount_is_discounted => '割引されますか？';

  @override
  String get prices_amount_price_normal => '価格';

  @override
  String get prices_amount_price_discounted => '割引価格';

  @override
  String get prices_amount_price_not_discounted => '元の価格';

  @override
  String get prices_amount_no_product => '商品が1つ不足しています。';

  @override
  String get prices_amount_price_incorrect => '値が正しくありません';

  @override
  String get prices_amount_price_mandatory => '必須値';

  @override
  String get prices_currency_subtitle => '通貨';

  @override
  String get prices_date_subtitle => '日付';

  @override
  String get prices_location_subtitle => '店';

  @override
  String get prices_location_find => 'お店を探す';

  @override
  String get prices_location_mandatory => 'ショップを選択する必要があります！';

  @override
  String get prices_location_search_broader =>
      '探しているものが見つかりませんでしたか？もっと広い範囲で検索してみましょう！';

  @override
  String get prices_proof_subtitle => '証拠';

  @override
  String get prices_proof_empty_title => 'まだ証拠はありません!';

  @override
  String get prices_proof_empty_explanation =>
      'まずは**領収書**または**値札**の写真を追加しましょう！';

  @override
  String get prices_proof_find => '証明を選択';

  @override
  String get prices_proof_change => '変更証明';

  @override
  String get prices_proof_receipt => '領収書';

  @override
  String get prices_proof_price_tag => '値札';

  @override
  String get prices_proof_mandatory => '証明を選択する必要があります。';

  @override
  String get prices_add_validation_error => '検証エラー';

  @override
  String get prices_privacy_warning_title => 'プライバシーに関する警告';

  @override
  String get prices_unknown_product => '不明な製品';

  @override
  String get prices_privacy_warning_main_message =>
      '価格は**公開されます**。**価格が参照する店舗も公開されます。\n\nこれにより、Open Food Factsの仮名を知っている人が次のことを実行できるようになります。\n';

  @override
  String get prices_privacy_warning_message_bullet_1 => 'あなたが住んでいる地域を推測する';

  @override
  String get prices_privacy_warning_message_bullet_2 => '何を買うのかを知る';

  @override
  String get prices_privacy_warning_sub_message =>
      'ご不安な場合は、仮名を変更するか、新しい Open Food Facts アカウントを作成して、アプリにログインしてください。';

  @override
  String get i_refuse => '拒否します';

  @override
  String get i_accept => '承諾します';

  @override
  String get prices_currency_change_proposal_title => '通貨を変更しますか?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return '現在の通貨は**$currency** です。**$newCurrency**に変更しますか？';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'はい、 $newCurrencyを使用してください';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'いいえ、 $currencyを維持します';
  }

  @override
  String get prices_menu_know_more => 'オープン価格について詳しく知る';

  @override
  String get dev_preferences_import_history_result_success => '完了';

  @override
  String get dev_mode_section_server => 'サーバー設定';

  @override
  String get dev_mode_section_news => 'ニュースプロバイダーの設定';

  @override
  String get dev_mode_section_product_page => '製品ページ';

  @override
  String get dev_mode_section_ui => 'ユーザインタフェース';

  @override
  String get dev_mode_section_experimental_features => '試験的な機能';

  @override
  String get dev_mode_hide_environmental_score_title => 'グリーンスコアを除外';

  @override
  String get dev_mode_spellchecker_for_ocr_title => 'OCR画面でスペルチェッカーを使用する';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '（原材料と包装）';

  @override
  String get dev_mode_reset_app_language_title => 'アプリの言語をリセット';

  @override
  String get dev_mode_add_demo_cards_language_title => 'カードを追加';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) とテスト環境を切り替える';

  @override
  String get search_history_item_edit_tooltip => 'この検索を再利用して編集する';

  @override
  String get search_history_item_remove_tooltip => '削除する';

  @override
  String product_search_no_more_results(int totalSize) {
    return '$totalSize 製品をすべてダウンロードしました。';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'あと $count 製品をダウンロード\n$totalSize 製品中 $downloaded 製品はダウンロード済みです。';
  }

  @override
  String product_search_loading_message(Object search) {
    return '$search の検索が進行中です。\n\n数秒お待ちください…';
  }

  @override
  String get user_search_contributor_title => '自分が追加した製品';

  @override
  String get user_search_informer_title => '自分が編集した製品';

  @override
  String get user_search_photographer_title => '自分が撮影した製品';

  @override
  String get user_search_to_be_completed_title => '自分の未完成の製品';

  @override
  String get user_search_prices_title => '私の価格';

  @override
  String get user_search_proofs_title => '自分の証拠';

  @override
  String get user_search_proof_title => '私の証明';

  @override
  String search_proof_title(String user) {
    return '「$user」からの証明';
  }

  @override
  String user_any_search_prices_title(String user) {
    return '貢献者価格: $user';
  }

  @override
  String get all_search_prices_latest_title => '最新の価格を追加しました';

  @override
  String get all_search_prices_top_user_title => '価格に最も大きく貢献した企業';

  @override
  String get all_search_prices_top_location_title => '価格が最も高い店舗';

  @override
  String get prices_contribution_assistant => '価格貢献アシスタント';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => '複数の証明を追加する';

  @override
  String get all_search_prices_top_location_single_title => '店内の価格';

  @override
  String get all_search_prices_top_product_title => '価格が最も高い商品';

  @override
  String get all_search_to_be_completed_title => 'すべての未完成の製品';

  @override
  String get categorize_products_country_title => '商品の分類にご協力ください';

  @override
  String get edit_product_action_retake_picture => '画像を再撮影';

  @override
  String get edit_product_action_take_picture => '画像を撮影';

  @override
  String get edit_product_action_confirm => '確定';

  @override
  String get signup_page_terms_of_use_line1 => '私はオープンフードファクトに同意します ';

  @override
  String get signup_page_terms_of_use_line2 => '利用と貢献規約';

  @override
  String get analytics_consent_image_semantic_label => '分析アイコン';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return '致命的なエラー：$error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return '致命的なエラー：$error';
  }

  @override
  String get summary_card_button_add_basic_details => '基本情報を完成させる';

  @override
  String get edit_photo_button_label => '編集';

  @override
  String get edit_photo_unselect_button_label => '画像の選択を解除';

  @override
  String get edit_photo_select_existing_button_label => '既存の画像を選択';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle => '画像をクリックして選択してください';

  @override
  String get edit_photo_select_existing_download_label => '既存の画像を取得中…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'この製品に関連する、過去にアップロードされた画像はありません。';

  @override
  String get edit_photo_language_not_this_one => 'その言語にはまだ画像がありません';

  @override
  String get edit_photo_language_none => '画像はまだありません';

  @override
  String get category_picker_screen_title => 'カテゴリー';

  @override
  String get basic_details => '基本情報';

  @override
  String get product_name => '製品名';

  @override
  String get product_names => '製品名';

  @override
  String get add_basic_details_product_name_add_translation => '新しい翻訳を追加する';

  @override
  String get add_basic_details_product_name_warning_translations =>
      '検証する前に、**パッケージに言語が記載されている場合**のみ翻訳を追加してください。';

  @override
  String get add_basic_details_product_name_open_photo => '前面写真を見る';

  @override
  String get add_basic_details_product_name_take_photo => '正面写真を撮る';

  @override
  String get add_basic_details_product_name_hint => '製品名を入力してください（例：ヌテラ）';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'デフォルトの言語を変更しますか?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return '製品のデフォルト言語を「$language」に設定しますか?';
  }

  @override
  String get explanation_section_good_examples => '良い例';

  @override
  String get explanation_section_bad_examples => '悪い例';

  @override
  String get add_basic_details_product_name_help_title => 'グッドプラクティス：製品名';

  @override
  String get add_basic_details_product_name_help_info1 =>
      '製品名は**パッケージに印刷される主な名称**です。登録商標にすることもできます。';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**注意:** **パッケージに言語が記載されていない場合**は、翻訳を追加しないでください。';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'ネスクイック';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => 'トマトケチャップ';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      '名前にブランド名を含めないでください';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'トマトケチャップ **ハインツ**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '®、™、©などの記号は使用しないでください';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'ネスクイック**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count その他の翻訳',
      one: '$count その他の翻訳',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'ブランド名';

  @override
  String get brand_names => 'ブランド名';

  @override
  String get add_basic_details_brand_name_error => 'ブランド名を入力してください';

  @override
  String get add_basic_details_brand_names_hint => '入力ブランド（例：フェレロ）';

  @override
  String get add_basic_details_product_brand_help_title => 'グッドプラクティス：ブランド';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      '**製品のすべてのブランド**を入力します。';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'メインブランド';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '通常、フロントパックに明確に表示されている**メインブランド**を**最初に入力**する必要があります。';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'その他のブランド';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      '**大企業が販売する場合**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**アクティメル**は**ダノン**によって販売されています';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'ブランド名を**複数の言語に翻訳**して販売する場合:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**ネイチャーバレー**は**ヴァルネイチャー**と表記されることもあります';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'ヌテラ';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'オレオ、モンデリーズ';

  @override
  String get quantity => '数量と重量';

  @override
  String get add_basic_details_quantity_hint =>
      '重量と、必要に応じて数量を入力してください（例：4x100g）';

  @override
  String get add_basic_details_product_quantity_help_title => 'グッドプラクティス：量';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      '製品に表示されている値をコピーし、**単位を忘れないでください**。';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** または **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (卵6個分)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n（1箱150g入りの商品3個入り）';

  @override
  String get barcode => 'バーコード';

  @override
  String barcode_barcode(String barcode) {
    return 'バーコード： $barcode';
  }

  @override
  String get barcode_invalid_error => '無効なバーコード';

  @override
  String get basic_details_add_success => '基本情報が正常に追加されました';

  @override
  String get basic_details_add_error => '基本情報の追加に失敗しました。しばらくしてからもう一度お試しください。';

  @override
  String get clear_search => '検索を消去';

  @override
  String get confirm_clear => 'すべての履歴をクリアしようとしています。続けますか？';

  @override
  String get alert_clear_selected_user_list => '選択したアイテムを履歴から消去しようとしています';

  @override
  String get confirm_clear_selected_user_list => '本当に続行しますか？';

  @override
  String get alert_select_items_to_clear => '削除する項目を 1 つ以上選択してください';

  @override
  String confirm_clear_user_list(String name) {
    return 'リスト($name) をクリアしようとしています。続けますか？';
  }

  @override
  String get confirm_delete_user_list_title => 'リストを削除しますか?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'リスト「$name」を削除しようとしています。\n続行してもよろしいですか?';
  }

  @override
  String get confirm_delete_user_list_button => 'はい、確認します';

  @override
  String importance_label(String name, String id) {
    return '$name の重要度: $id';
  }

  @override
  String get user_list_all_title => 'リスト';

  @override
  String get user_list_all_empty => '最初のリストを作成';

  @override
  String get product_list_select => 'リストを選択';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 製品',
      one: '1 製品',
      zero: '空のリスト',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'リストを追加';

  @override
  String get open_food_preferences_tooltip => '食べ物の好みの編集';

  @override
  String get add_photo_button_label => '画像を追加';

  @override
  String get add_packaging_photo_button_label => 'パッケージ/リサイクル情報の画像を撮る';

  @override
  String get add_origin_photo_button_label => 'パッケージ/リサイクル情報の画像を撮る';

  @override
  String get add_emb_photo_button_label => 'トレーサビリティコード情報の写真を撮る';

  @override
  String get add_label_photo_button_label => 'ラベルと認証情報の写真を撮る';

  @override
  String get choose_image_source_title => '画像ソースを選択';

  @override
  String get choose_image_source_body => '画像ソースを選択してください';

  @override
  String get gallery_source_label => 'ギャラリー';

  @override
  String get gallery_source_access_denied_dialog_title => 'アクセス拒否';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      '残念ながら、以前に許可を拒否されたため、アプリケーションはギャラリーにアクセスできません。\n\n携帯電話の [設定] -> [写真] のアプリ設定に移動してください。';

  @override
  String get gallery_source_access_denied_dialog_button => '設定を開く';

  @override
  String get share => '共有';

  @override
  String share_product_text(String url) {
    return 'Open Food Factsでこの製品をご覧ください: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Open Beauty Factsでこの製品をご覧ください: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Open PetFood Factsでこの製品をご覧ください: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Open Products Facts でこの製品をご覧ください: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Open Food Facts の私の製品リストをご覧ください: $url';
  }

  @override
  String get capture => '新しく撮影する';

  @override
  String get capture_new_picture => '画像を撮る';

  @override
  String get choose_from_gallery => 'ギャラリーから選択する';

  @override
  String get image_upload_queued => '画像はできるだけ早くpc上の背景にてアップロードされます。';

  @override
  String get add_price_queued => '価格はできるだけ早くサーバーに送信されます。';

  @override
  String get background_task_title_full_refresh =>
      'ローカルに保存されているすべての製品の更新を開始します';

  @override
  String get background_task_title_top_n => '最も人気のある製品のダウンロードを開始します';

  @override
  String get expand_nutrition_facts => '栄養成分表を広げる';

  @override
  String get expand_nutrition_facts_body => '栄養成分表を広げたままにする';

  @override
  String get expand_ingredients => '原材料を広げる';

  @override
  String get expand_ingredients_body => '原材料パネルを広げたままにする';

  @override
  String get no_internet_connection => 'インターネットに接続されていません';

  @override
  String get world_results_label => '世界全体';

  @override
  String get world_results_action => '検索範囲を世界に広げる';

  @override
  String get copy_to_clipboard => 'コピー';

  @override
  String get paste_from_clipboard => 'クリップボードから貼り付け';

  @override
  String get no_data_available_in_clipboard => 'クリップボードに利用可能なデータがありません';

  @override
  String get clipboard_barcode_copy => 'バーコードをクリップボードにコピー';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'バーコード $barcode がクリップボードにコピーされました！';
  }

  @override
  String get open_product_website => 'この商品をウェブサイトで開く';

  @override
  String get language_picker_label => 'あなたの言語';

  @override
  String get country_picker_label => 'あなたの国';

  @override
  String get currency_picker_label => 'あなたの通貨';

  @override
  String get help_with_openfoodfacts => 'OpenFoodFactsのヘルプ';

  @override
  String get product_task_background_schedule => '製品は可能な限り早くバックグラウンドで更新されます。';

  @override
  String get no_email_client_available_dialog_title => 'メールアプリがありません！';

  @override
  String get no_email_client_available_dialog_content =>
      'mobile@openfoodfacts.org まで手動でメールをお送りください。';

  @override
  String get all_images => 'すべての画像';

  @override
  String get selected_images => '選択した画像';

  @override
  String get product_card_remove_product_tooltip => '製品の削除';

  @override
  String scan_announce_new_barcode(String barcode) {
    return '新しいバーコードがスキャンされました: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip => 'カルーセルからすべての商品を削除します';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      '比較するには少なくとも2つの製品をスキャンしてください';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'クリックしてスキャンした製品を比較してください';

  @override
  String get scan_product_loading => 'バーコード\nスキャンしました:';

  @override
  String get scan_product_loading_initial => 'この商品を探しています！\n数秒お待ちください…';

  @override
  String get scan_product_loading_long_request =>
      'この商品はまだまだ募集中です！\n読み込みに時間がかかると思いますか? 私たちもそうです…';

  @override
  String get scan_product_loading_unresponsive => 'この製品はまだ検索中です。\n検索を再開しますか?';

  @override
  String get scan_product_loading_restart_button => '検索を再開';

  @override
  String get portion_calculator_description => '特定の量の栄養成分表示を計算する';

  @override
  String get portion_calculator_hint => '数量';

  @override
  String get portion_calculator_accessibility => '栄養成分を計算するには「数量」を入力してください';

  @override
  String portion_calculator_error(int min, int max) {
    return '$min ～ $max の間で数量を入力してください';
  }

  @override
  String get portion_calculator_computation_error =>
      'データが見つかりません。計算を実行できませんでした。';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams g (または ml) の栄養成分表';
  }

  @override
  String get offline_data => 'オフラインデータ';

  @override
  String get ocr_image_upload_instruction =>
      '画像をアップロードすると、画像に含まれる情報を自動的に抽出します。';

  @override
  String get upload_image => '画像をアップロード';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => '画像のダウンロードに失敗しました';

  @override
  String get image_edit_url_error => '画像のURLが設定されていないため、画像の編集に失敗しました。';

  @override
  String get user_picture_source_remember => '選択を保存';

  @override
  String get user_picture_source_ask => '毎回尋ねる';

  @override
  String get robotoff_continue => '続ける';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 質問',
      one: '質問',
    );
    return '次 $_temp0';
  }

  @override
  String get show_password => 'パスワードを表示';

  @override
  String get owner_field_info_title => 'プロデューサー提供の値';

  @override
  String get owner_field_info_message =>
      'このロゴでは、プロデューサーが提供したデータが強調表示されますが、編集できない可能性があります。';

  @override
  String get owner_field_info_close_button => 'この情報を閉じる';

  @override
  String get owner_field_image => 'この画像は制作者から提供されたものであり、編集できない可能性があります。';

  @override
  String get edit_packagings_title => 'パッケージの要素';

  @override
  String get edit_packagings_element_add => 'パッケージの要素を追加する';

  @override
  String get edit_packagings_completed => 'パッケージ情報が完成しました';

  @override
  String edit_packagings_element_title(int index) {
    return 'パッケージの要素 #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'ユニット数';

  @override
  String get edit_packagings_element_hint_units =>
      '製品に含まれる、同一形状、同材質の包装単位の数を入力してください。';

  @override
  String get edit_packagings_element_field_shape => '形状';

  @override
  String get edit_packagings_element_hint_shape =>
      'リサイクル手順に形状が記載されている場合それを入力するか、形状を選択してください。';

  @override
  String get edit_packagings_element_example_shape => 'ボトル';

  @override
  String get edit_packagings_element_field_material => '材質';

  @override
  String get edit_packagings_element_hint_material =>
      '判別できる場合は特定の素材（三角で囲まれた素材コードはパッケージ部分によくあります）を入力し、不明な場合は包括的な素材（プラスチックや金属など）を入力してください。';

  @override
  String get edit_packagings_element_example_material => 'ガラス';

  @override
  String get edit_packagings_element_field_recycling => 'リサイクル手順';

  @override
  String get edit_packagings_element_hint_recycling =>
      '製品に記載されている場合にのみ、リサイクル手順を入力してください。';

  @override
  String get edit_packagings_element_example_recycling => 'リサイクル';

  @override
  String get edit_packagings_element_field_quantity => '単位あたりの製品の正味数量';

  @override
  String get edit_packagings_element_hint_quantity =>
      '正味重量または正味体積を入力し、単位を明記します（g または ml など）。';

  @override
  String get edit_packagings_element_field_weight => '空の状態での単位あたりの重さ (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      '計量の前に残っている食品を取り除き、パッケージを洗浄、乾燥させてください。可能であれば、0.1gまたは0.01gの精度のはかりを使用してください。';

  @override
  String get background_task_title => '保留中の投稿';

  @override
  String get background_task_subtitle =>
      'あなたの投稿は自動的にサーバーに保存されますが、リアルタイムで保存されるとは限りません。';

  @override
  String get background_task_list_empty => '保留中のバックグラウンドタスクはありません';

  @override
  String get background_task_error_server_time_out => 'サーバータイムアウト';

  @override
  String get background_task_error_no_internet =>
      'インターネット接続エラーが発生しました。後でお試しください。';

  @override
  String get background_task_operation_unknown => '不明な操作タイプ';

  @override
  String get background_task_operation_details => '詳細な変更';

  @override
  String get background_task_operation_image => '画像のアップロード';

  @override
  String get background_task_operation_refresh => '画像のアップロード後の更新の遅れ';

  @override
  String get background_task_run_started => '開始されました';

  @override
  String get background_task_run_not_started => 'まだ開始していません';

  @override
  String get background_task_run_to_be_deleted => '削除予定';

  @override
  String get background_task_question_stop => '直ちにタスクを停止しますか？';

  @override
  String get feed_back => 'フィードバック';

  @override
  String get undo => '元に戻す';

  @override
  String get copy_email_to_clip_board => 'メールアドレスをクリップボードにコピー';

  @override
  String get please_send_us_an_email_to => 'こちらのアドレスにメールを送信してください';

  @override
  String get email_copied_to_clip_board => 'メールをクリップボードにコピーしました！';

  @override
  String get select_accent_color => 'アクセントカラーを選択';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => '青';

  @override
  String get color_cyan => 'シアン';

  @override
  String get color_green => '緑';

  @override
  String get color_light_brown => 'デフォルト';

  @override
  String get color_magenta => 'マゼンタ';

  @override
  String get color_orange => 'オレンジ';

  @override
  String get color_pink => 'ピンク';

  @override
  String get color_red => '赤';

  @override
  String get color_rust => '赤茶色';

  @override
  String get color_teal => 'ティール';

  @override
  String get text_contrast_mode => '文字のコントラスト';

  @override
  String get contrast_high => '高';

  @override
  String get contrast_medium => '中';

  @override
  String get contrast_low => '低';

  @override
  String get product_refresher_internet_not_found => '商品が見つかりませんでした';

  @override
  String get product_refresher_internet_not_connected => 'インターネットに接続されていません。';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'サーバーダウン ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'サーバーエラー ($exception)';
  }

  @override
  String get product_loader_not_found_title => '商品が見つかりませんでした';

  @override
  String product_loader_not_found_message(String barcode) {
    return '次のバーコードを持つ商品はデータベースに存在しません: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'インターネットに接続されていません';

  @override
  String get product_loader_network_error_message =>
      'スマートフォンが WiFi ネットワークに接続されているか、モバイル データが有効になっていることを確認してください';

  @override
  String get page_not_found_title => 'ページが見つかりません。';

  @override
  String get page_not_found_button => 'ホームページへ戻る';

  @override
  String get download_data => 'データをダウンロード';

  @override
  String get download_top_products => 'あなたの国の上位 1,000 製品をダウンロードして即時スキャンできます';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 製品',
    );
    return 'あなたの国のトップの $_temp0 をダウンロードしてすぐにスキャンしてください';
  }

  @override
  String get download_in_progress => 'データをダウンロード中\nしばらく時間がかかる場合があります';

  @override
  String downloaded_products(int num) {
    return '$num 商品が追加されました';
  }

  @override
  String get update_offline_data => 'オフラインデータを更新';

  @override
  String get update_local_database_sub =>
      'Open Food Factsの最新データでローカル製品データベースを更新します';

  @override
  String get clear_local_database => 'オフライン商品データを消去';

  @override
  String get clear_local_database_sub => 'アプリからすべてのローカル製品データを消去して空き容量を増やします';

  @override
  String deleted_products(int num) {
    return '$num 商品が削除されました';
  }

  @override
  String get loading => '読み込んでいます…';

  @override
  String get know_more => '詳しくはこちら';

  @override
  String get offline_data_desc => 'オフラインデータの詳細についてはクリックしてください';

  @override
  String get offline_product_data_title => 'オフラインの製品データ';

  @override
  String available_for_download(int num) {
    return '即時スキャン可能な製品は$num 件あります';
  }

  @override
  String get country_selector_title => '国を選択してください';

  @override
  String get currency_selector_title => '通貨を選択してください。';

  @override
  String get language_selector_title => '言語を選択してください:';

  @override
  String get language_selector_section_selected => '選択した言語';

  @override
  String get language_selector_section_frequently_used => 'よく使われる';

  @override
  String get action_delete_list => '削除';

  @override
  String get action_change_list => '現在のリストを変更する';

  @override
  String get product_list_create => '作成する';

  @override
  String get product_list_create_tooltip => '新しいリストを作成する';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'ニュートリスコアA';

  @override
  String get nutriscore_b => 'ニュートリスコアB';

  @override
  String get nutriscore_c => 'ニュートリスコアC';

  @override
  String get nutriscore_d => 'ニュートリスコアD';

  @override
  String get nutriscore_e => 'ニュートリスコアE';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (新しい計算)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (新しい計算)';

  @override
  String get nutriscore_unknown => '不明な栄養スコア';

  @override
  String get nutriscore_unknown_new_formula => '未知の栄養スコア（新しい計算）';

  @override
  String get nutriscore_not_applicable => 'Nutri-Scoreは適用されません';

  @override
  String get nutriscore_not_applicable_new_formula => 'ニュートリスコアは適用されません（新しい計算）';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'グリーンスコアA';

  @override
  String get environmental_score_b_new => 'グリーンスコアB';

  @override
  String get environmental_score_c_new => 'グリーンスコアC';

  @override
  String get environmental_score_d_new => 'グリーンスコアD';

  @override
  String get environmental_score_e_new => 'グリーンスコアE';

  @override
  String get environmental_score_unknown_new => '不明なグリーンスコア';

  @override
  String get environmental_score_not_applicable_new => 'グリーンスコアは適用されません';

  @override
  String get nova_group_generic_new => '超加工食品 - NOVAグループ';

  @override
  String get nova_group_1 => 'NOVAグループ1';

  @override
  String get nova_group_2 => 'NOVAグループ2';

  @override
  String get nova_group_3 => 'NOVAグループ3';

  @override
  String get nova_group_4 => 'NOVAグループ4';

  @override
  String get nova_group_unknown => '不明なNOVAグループ';

  @override
  String get nutrition_facts => '栄養レベル';

  @override
  String get faq_title_partners => 'NGO のパートナーと後援者';

  @override
  String get faq_title_vision => 'Open Food Facts ビジョン、使命、価値観、プログラム';

  @override
  String get faq_title_install_beauty =>
      'Open Beauty Facts をインストールして化粧品データベースを作成する';

  @override
  String get faq_title_install_pet =>
      'Open Pet Food Facts をインストールしてペットフード データベースを作成する';

  @override
  String get faq_title_install_product =>
      'Open Products Facts をインストールして製品データベースを作成し、オブジェクトの寿命を延ばす';

  @override
  String get faq_nutriscore_nutriscore => 'Nutri-Score の新しい計算: 何が新しいのでしょうか?';

  @override
  String get contact_title_pro_page => 'プロ？ Open Food Facts に製品をインポートします';

  @override
  String get contact_title_pro_email => 'プロデューサー連絡先';

  @override
  String get contact_title_press_page => 'プレスページ';

  @override
  String get contact_title_press_email => '報道関係者向けのお問い合わせ先';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'コミュニティカレンダーを購読する';

  @override
  String get hunger_games_loading_line1 => '数秒お待ちください…';

  @override
  String get hunger_games_loading_line2 => '質問をダウンロード中です！';

  @override
  String get hunger_games_error_label => 'ああ！問題が発生した… 、質問を読み込むことができませんでした。';

  @override
  String get hunger_games_error_retry_button => '再試行しましょう！';

  @override
  String get reorder_attribute_action => '属性の順序変更';

  @override
  String get link_cant_be_opened =>
      'このリンクは、お使いのデバイスでは開けません。ブラウザがインストールされていることを確認してください。';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productNameの詳細';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName の詳細と $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => '共有';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title => '新しい Nutri-Score 計算はどこにありますか?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score は、フランス、ドイツ、ベルギー、スペイン、ルクセンブルク、オランダ、スイスの 7 か国で適用されています。';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      '製造業者は、法令の署名後、遅くとも **2 年** 以内に古い計算を新しい計算に置き換える必要があります**。';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'グリーンスコアとは何ですか?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'グリーンスコアは、**食品の環境への影響**について知らせることを目的としたロゴです。';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      '色コードは、**影響が最も少ない** 製品を表す濃い緑 (**A+**) から、**影響が最も大きい** 製品を表す濃い赤 (**F**) まで異なります。';

  @override
  String get guide_greenscore_logos_caption => 'グリーンスコアのロゴ';

  @override
  String get guide_greenscore_lca_title => '核となるのは、ライフサイクルアセスメント（LCA）です。';

  @override
  String get guide_greenscore_lca_arg1_title => '食品カテゴリーの科学的評価';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      '各製品カテゴリーごとに、Agribalyse 環境データベース (ADEME と INRAE が設計) のデータを使用して **ベンチマーク** スコアが確立されます。';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**ライフサイクル分析** は、多段階かつ多基準の環境評価を実行するための標準化された評価方法です。';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**サイズ:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6つの製造ステップ';

  @override
  String get guide_greenscore_lca_arg2_agriculture => '農業';

  @override
  String get guide_greenscore_lca_arg2_processing => '加工';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'パッケージング';

  @override
  String get guide_greenscore_lca_arg2_transportation => '輸送';

  @override
  String get guide_greenscore_lca_arg2_distribution => '流通';

  @override
  String get guide_greenscore_lca_arg2_consumption => '消費';

  @override
  String get guide_greenscore_lca_arg3_title => '14の環境影響指標';

  @override
  String get guide_greenscore_lca_arg3_text1 => '気候変動/カーボンフットプリント';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'オゾン層の破壊';

  @override
  String get guide_greenscore_lca_arg3_text3 => '電離放射線';

  @override
  String get guide_greenscore_lca_arg3_text4 => '土地';

  @override
  String get guide_greenscore_lca_arg3_text5 => '水とエネルギーの使用';

  @override
  String get guide_greenscore_lca_arg3_text6 => '大気汚染';

  @override
  String get guide_greenscore_lca_arg3_text7 => '海水と淡水（粒子、酸性化、富栄養化）';

  @override
  String get guide_greenscore_lca_arg3_text8 => '資源の枯渇。';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'ボーナスとペナルティ';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'カテゴリー内でより優れた製品に報酬を与えるために、**いくつかの基準に基づいてボーナスとペナルティを適用します**。';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**公式ラベル、環境上の利点を保証するラベルまたは認証** (オーガニック、フェアトレード、HVE、Label Rouge、Bleu Blanc Cœur、MSC/ASC) が付いた製品には、**ボーナス** が付与されます。';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => '成分の起源';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '原材料の原産地に基づいて**ボーナス**が付与されます。このボーナスは、**輸送への影響**と、各生産国の**環境政策**を考慮に入れています。';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'パーム油などの、大規模な森林破壊の原因となっている生産など、**生物多様性と生態系に重大な悪影響を与える**成分を含む製品には、**罰則**が科せられます。';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'パッケージング';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**ペナルティ**は、**包装の循環性**（リサイクル原材料の使用とリサイクル性）と過剰梱包を考慮して計算されます。';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'グリーンスコアを正確に計算するには、**パッケージに必ずしも明記されていない情報** (原産地や各成分の正確な割合など)、または使用可能な形式で入手できることがほとんどない情報 (パッケージのすべてのコンポーネントのリストと、使用されているプラスチックの正確な種類など) が必要です。';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**この情報がまだ入手できない場合は平均値が使用されます**が、現在、私たちはこの情報を収集するために皆様の協力を呼びかけています。この情報は、グリーンスコアだけでなく、他の多くの用途にも非常に役立ちます。';

  @override
  String get guide_greenscore_transparency_arg1_title => '国民はどのように支援できるでしょうか?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'すべての市民は、**パッケージ**に関する情報など、製品に存在する情報や製品から推測できる情報を収集し、構造化することに協力できます。「Mission Emballages」は、すべての食品のパッケージの大規模な共同インベントリです（フランス語）。';

  @override
  String get guide_greenscore_transparency_arg2_title => 'メーカーがどのように支援できるか';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'メーカーは、当社の生産者向け無料プラットフォームを通じて、直接情報をお送りいただけます。';

  @override
  String get guide_greenscore_better_product_title => 'どちらの製品が地球にとって良いのでしょうか?';

  @override
  String get guide_greenscore_better_product_arg1_title => '判断するのは難しいかもしれない';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      '持続可能な食品を選択することは、気候のために私たちができる最も強力なことの1つです。**世界の食料システムは、温室効果ガス排出量の4分の1以上を占めています**。\n(出典: Poore & Nemecek、Science、2018)。';

  @override
  String get guide_greenscore_better_product_arg2_title => 'あなたには力がある！';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      '良いニュースは、これが変化を生み出す強力な手段となるということです。\n**私たちは一人当たり年間約1,000食を食べます**。それは**地球にとってより良い未来を選ぶ**機会が1,000回あるということです！';

  @override
  String get guide_greenscore_better_product_arg3_title => '責任感と決断力を高める';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      '持続可能な食品を選ぶのは、複雑に感じることがあります。ラベルは分かりにくく、情報が不足していることも少なくありません。グリーンスコアは、この状況をシンプルにするために開発されました。食品の**明確**で**科学に基づいた**、**透明性のある**環境評価を、必要な時に、つまり買い物中に提供します。';

  @override
  String get guide_greenscore_better_product_arg4_title => '透明性';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      '独自のラベルとは異なり、グリーン スコアの計算は **完全にオープン** であり、**誰でも検証できます**。';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => '超処理とは何ですか?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA グループは食品加工のレベルについてお知らせします。';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA 分類では、**工業的加工の程度** (最小限に加工された食品または未加工の食品、料理の材料、加工食品、超加工食品) に基づいて食品を **4 つのグループ** に分類できます。';

  @override
  String get guide_nova_logos_caption => 'NOVAのロゴ';

  @override
  String get guide_nova_groups_title => '4つのNOVAグループ';

  @override
  String get guide_nova_groups_intro =>
      'NOVA グループは 4 つありますが、問題となるのはグループ 4 の超加工食品です。';

  @override
  String get guide_nova_groups_arg1_title => '加工が最小限か未加工の食品';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => '加工された料理の材料';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => '加工食品';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => '超処理の問題点';

  @override
  String get guide_nova_explanations_arg1_title => '食品原料の極端な加工';

  @override
  String get guide_nova_explanations_arg1_text =>
      '多くは、水素化油やエステル交換油、加水分解タンパク質、大豆タンパク質分離物、マルトデキストリン、転化糖、高果糖コーンシロップなど、**食品成分のさらなる加工から得られます**。';

  @override
  String get guide_nova_explanations_arg2_title => '純粋な食品安全性を超えた添加物';

  @override
  String get guide_nova_explanations_arg2_text =>
      '超加工食品に含まれる添加物には、保存料、酸化防止剤、安定剤など、加工食品にも使用されるものが含まれます。超加工食品にのみ含まれる添加物には、**食品の官能特性を模倣または強化するため、あるいは最終製品の不快な側面を隠すため**に使用されるものが含まれます。これらの添加物には、染料などの着色料、色安定剤、香料、風味増強剤、非糖類甘味料、そして炭酸化剤、硬化剤、増量剤、膨張防止剤、消泡剤、固結防止剤、艶出し剤、乳化剤、金属イオン封鎖剤、保湿剤などの加工助剤が含まれます。';

  @override
  String get guide_nova_explanations_arg3_title => '自宅ではできない処理';

  @override
  String get guide_nova_explanations_arg3_text =>
      '通常は多くの材料を組み合わせ、最終製品を作るために、**多数の工程が連続して用いられます**（そのため「超加工」と呼ばれます）。これらの工程には、水素化、加水分解、押し出し、成形、揚げるための前処理など、**国内には同等の工程がない**ものもいくつか含まれています。';

  @override
  String get guide_nova_explanations_arg4_title => '超加工の略奪的かつ経済的側面';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**超加工の全体的な目的は、ブランド化され、**便利**（耐久性があり、すぐに食べられる）、**魅力的**（非常に美味しい）、そして**高収益**（低コストの原材料）な食品を製造し、他のすべての食品群に取って代わることです。超加工食品は通常、魅力的なパッケージで包装され、集中的に販売されます。';

  @override
  String get guide_nova_explanations_arg5_title => '健康被害';

  @override
  String get guide_nova_explanations_arg5_text =>
      '2018年以来、NutriNet-Santéの取り組みにより、**超加工食品の摂取とがん、心血管疾患、糖尿病のリスク増加との関連性が初めて明らかにされました**。現在、世界中で90件以上の研究でこれらの知見が確認されています。\n最も強い関連性は、**肥満、心血管疾患による死亡率、うつ症状**に関連しています。小児においては、主に体重と脂質の不均衡に影響が見られます。';

  @override
  String get guide_nova_explanations_arg6_title => '各国は制限を推奨';

  @override
  String get guide_nova_explanations_arg6_text =>
      '一部の国では、食事のガイドラインや目標に NOVA グループを使用しています。例:\n\n- **🇧🇷ブラジル**の食事ガイドラインでは、**加工食品の消費を制限**し、超加工食品を避けることを推奨しています。\n\n- **🇫🇷フランス**の 2018～2022 年の公衆衛生栄養政策目標は、**グループ 4 の超加工食品の消費を 20% 削減**することを目指しています。';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Open Food Facts へようこそ!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Open Food Factsとは何ですか?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts は、世界中の食品に関する**共同**的、**無料**、**オープン**なデータベースです。';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      '私たちは、誰もが自分が食べるものに関する情報にアクセスできるべきだと考えています。原材料、アレルゲン、栄養成分表示などのデータを収集することで、**消費者が情報に基づいた選択を行えるように支援**し、食品業界の**透明性の向上**を推進します。';

  @override
  String get guide_open_food_facts_features_title => 'オープンフードファクトの特徴';

  @override
  String get guide_open_food_facts_features_arg1_title => '不要な食材に関するアラートを受け取る';

  @override
  String get guide_open_food_facts_tips_title => '素晴らしい写真を撮るためのヒント';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'してはいけないこと';

  @override
  String get guide_open_food_facts_tips_arg1_text1 => '影やまぶしさを避けてください。';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'ぼやけたテキストや焦点が合っていないテキストはありません。';

  @override
  String get guide_open_food_facts_tips_arg1_text3 => 'テキストの一部を切り取らないでください。';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => '雑然とした背景は避けてください。';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'すべきこと';

  @override
  String get guide_open_food_facts_tips_arg2_text1 => '良好で均一な照明を使用してください。';

  @override
  String get guide_open_food_facts_tips_arg2_text2 => 'テキストが鮮明で読みやすいことを確認します。';

  @override
  String get guide_open_food_facts_tips_arg2_text3 => '材料リスト全体をキャプチャします。';

  @override
  String get guide_open_food_facts_tips_arg2_text4 => '製品を平らな面に置いてください。';

  @override
  String get guide_open_food_facts_scores_title => '「食のウィキペディア」の構築にご協力ください';

  @override
  String get guide_open_food_facts_scores_arg1_title => '栄養価のスコア';

  @override
  String get guide_open_food_facts_scores_arg2_title => '超加工食品を避けるためのスコア';

  @override
  String get guide_open_food_facts_scores_arg3_title => '地球のためのスコア';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ja.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title => 'Open Pet Food Facts へようこそ!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Open Pet Food Factsとは何ですか?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts は、私たちの使命を愛するペットたちにまで広げます！**猫、犬、その他のペットのためのペットフード製品のデータベース**です。';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      '私たちは、ペットの飼い主が動物のニーズに最適な食べ物を選択できるように、**原材料**、**栄養分析**、給餌ガイドラインに関する情報を収集しています。';

  @override
  String get guide_open_pet_food_facts_features_title => 'オープンペットフードファクトの特徴';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      '不要な食材に関するアラートを受け取る';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'ペットにアレルギーのある成分はありますか？避けるべき化粧品成分のリストをアプリ内で設定できます。';

  @override
  String get guide_open_pet_food_facts_tips_title => '素晴らしい写真を撮るためのヒント';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'してはいけないこと';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 => '影やまぶしさを避けてください。';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'ぼやけたテキストや焦点が合っていないテキストはありません。';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'テキストの一部を切り取らないでください。';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 => '雑然とした背景は避けてください。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'すべきこと';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 => '良好で均一な照明を使用してください。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'テキストが鮮明で読みやすいことを確認します。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 => '材料リスト全体をキャプチャします。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 => '製品を平らな面に置いてください。';

  @override
  String get guide_open_pet_food_facts_scores_title => 'スコアリングに関する注意';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'ペットフードのスコアリングシステムの開発は**現時点では優先事項ではありません**。栄養ニーズは種、年齢、健康状態によって大きく異なるため、その方法論は複雑になります。そのようなスコアを開発できる独立した科学チームはまだ見つかっていません。';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ja.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Open Beauty Facts へようこそ!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Open Beauty Factsとは何ですか?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts は、**化粧品** の共同データベースです。';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      '私たちの目標は、**パーソナルケア製品に何が含まれているのか**を理解していただくために、成分リストを解読することです。保湿剤から化粧品まで、化粧品業界の透明性を高めるために、成分、アレルゲン、パッケージに関するデータを収集しています。';

  @override
  String get guide_open_beauty_facts_features_title => 'オープンビューティーファクトの特徴';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      '不要な食材に関するアラートを受け取る';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      '成分にアレルギーがありますか？コメドゲン物質を避けたいですか？物議を醸す成分を避けたいですか？アプリ内で、避けたい化粧品成分のリストを設定できます！';

  @override
  String get guide_open_beauty_facts_tips_title => '素晴らしい写真を撮るためのヒント';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'してはいけないこと';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 => '影やまぶしさを避けてください。';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'ぼやけたテキストや焦点が合っていないテキストはありません。';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 => 'テキストの一部を切り取らないでください。';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 => '雑然とした背景は避けてください。';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'すべきこと';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 => '良好で均一な照明を使用してください。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'テキストが鮮明で読みやすいことを確認します。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 => '材料リスト全体をキャプチャします。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'ボトルが湾曲している場合は、必要なだけ写真を撮ってください。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      '原材料のリストを確認するには、ラベルを剥がす必要があるかもしれません。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 => '製品を平らな面に置いてください。';

  @override
  String get guide_open_beauty_facts_scores_title => 'スコアリングに関する注意';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      '食品とは異なり、化粧品の世界には**Nutri-Score**のような、世界的に認知され、政府が支援する評価システムはありません。成分の効果は個人差が大きく、肌質、アレルギー、個人の悩みによって異なります。';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ja.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'オープン価格へようこそ！';

  @override
  String get guide_open_prices_what_is_open_prices_title => 'オープン価格とは何ですか?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices は、**世界中の商品の価格を収集・共有する**プロジェクトです。これは、研究や分析などに利用できる公開データセットです。Open Prices は、Open Food Facts によって開発・管理されています。';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'オープン価格はどのように機能しますか?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**オープンソースの価格データセットをクラウドソーシングしています**。ユーザーは、このウェブアプリまたは公式のOpen Food Factsモバイルアプリから価格を追加できます。小売業者やサードパーティ製アプリも、APIを使用して価格データに貢献できます。';

  @override
  String get guide_open_prices_how_arg1_title => '通路にある値札の写真を集める';

  @override
  String get guide_open_prices_how_arg2_title => '領収書の写真を集める';

  @override
  String get guide_open_prices_why_title =>
      'Open Food Facts はなぜこれを行っているのでしょうか?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      '価格情報は、食料システムを理解する上で極めて重要です。食料コストを理解し、より健康的な食生活を促進する上で重要な要素です。価格データを公開することで、研究者、ジャーナリスト、そして一般市民は、**食料価格が地域や時間によってどのように変動するかをより深く理解**しやすくなります。';

  @override
  String get guide_open_prices_why_arg1_title => '時間の経過に伴う価格の推移を追跡する';

  @override
  String get guide_open_prices_why_arg1_text =>
      '**価格の推移**をご覧ください: シュリンクフレーション、チープフレーション、これらを一緒に追跡できます!';

  @override
  String get guide_open_prices_why_arg2_title => 'お近くの価格を比較';

  @override
  String get guide_open_prices_why_arg2_text =>
      'より多くの価格を入手すれば、**あなたの周囲で最も安い店舗**を見つけることができます。';

  @override
  String get guide_open_prices_scrapping_title =>
      '小売業者のウェブサイトから価格をスクレイピングすることを検討しましたか?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      '法的および技術的な理由により、**小売業者のウェブサイトから価格をスクレイピングすることは、Open Pricesへの貢献方法としては有効とは考えていません**。収集する価格が正確かつ最新のものであることを保証したいと考えており、貢献者からスクレイピングされた価格を受け取ることで、それが可能になるわけではありません。';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      '価格スクレイピングは、Open Prices の将来のバージョンでは検討中のオプションですが、HTML ページに基づいて価格を証明できるように、Open Prices 自体によって実行される予定です。';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      '当社の API を使用して価格を提供できます。\n大規模な価格を提供したい場合は、prices@openfoodfacts.org までご連絡ください。';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title => 'Open Products Facts へようこそ!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Open Products Facts とは何ですか?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts は、**食品、化粧品、ペットフード以外のバーコード付き製品** に関する大規模なオープン データベースです。';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      '**電化製品**から**おもちゃ**、**衣類**から**掃除用品**まで、バーコードがあれば追加できます。このプロジェクトは、日常のあらゆるモノに「モノのインターネット」を構築し、それらに関する情報を誰もがアクセスできるようにすることを目的としています。';

  @override
  String get guide_open_products_facts_features_title => 'オープンプロダクトの特徴';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts は、物品を維持、**修理**、**リサイクル**したり、新しい所有者に譲渡したりするための循環型ソリューションを提供することで、消費者に**物品の寿命を延ばす**ことを目指しています。';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      '一部の製品のカーボンフットプリント';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'フランス環境庁 ADEME による **Impact CO2** では、多くのカテゴリーの **炭素影響** が示されています。製品を正確に分類するようにしてください。';

  @override
  String get guide_open_products_facts_features_arg2_title => '多くの製品の修理可能性指数';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'フランスの修復可能性指数が利用可能になり次第、表示します。さらに、**Folksonomy Engineを使って変数の収集を開始できます**。これにより、将来、修復可能性指数が利用できない国でも、私たち自身で再計算できるようになります。';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      '製品を寄付/再販する方法を見つける';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      '地球資源に優しい中古品として、お探しの商品を手に入れるのに役立つ**サードパーティの循環型サービス**へのリンクを提供しています。\nなお、私たちはこれらのサービスに対して報酬を受け取っておらず、このシステムはフランスの2つのウェブサイトの例としてのみ機能しています。Wikiでより多くのサイトをドキュメント化することで、このシステムの拡張にご協力いただけます。';

  @override
  String get guide_open_products_facts_information_title => 'どのような情報が役立ちますか?';

  @override
  String get guide_open_products_facts_information_text =>
      '幅広い商品を扱うため、**収集するデータは柔軟です**。そのために、**フォークソノミーエンジン**を開発しました。';

  @override
  String get guide_open_products_facts_folksonomy_title => 'フォークソノミーエンジン';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engineは、関連性の高いプロパティを持つ商品を完成させるためのツールです。検索性と発見性を向上させるだけでなく、将来的に興味深い情報を計算して表示するのに役立ちます。';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      '次のような任意のキーと値を追加できます: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      '可能なプロパティが自動的に提案されるので、お気に入りの種類の製品に新しいプロパティを追加して文書化することもできます。';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ja.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => '食べ物の好みをオープンにする';

  @override
  String get guide_coming_soon_button_title => '近日公開';

  @override
  String get guide_learn_more_subtitle => 'タップして詳細をご覧ください';

  @override
  String get preview_badge => 'プレビュー';

  @override
  String get prices_feedback_form =>
      'この新機能についてのフィードバックをお送りいただくには、ここをクリックしてください。';

  @override
  String get menu_button_list_actions => 'アクションを選択';

  @override
  String get error_loading_photo => '写真の読み込みエラー';

  @override
  String get photo_viewer_action_use_picture_as => '…として使用';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'この写真を…として使用します';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'この画像を… ($language) として使用します';
  }

  @override
  String get photo_viewer_details_button => '詳細';

  @override
  String get photo_viewer_details_button_accessibility_label => 'この写真の詳細';

  @override
  String get photo_viewer_details_title => '写真の詳細';

  @override
  String get photo_viewer_details_contributor_title => '貢献者';

  @override
  String get photo_viewer_details_size_title => 'サイズ';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height ピクセル';
  }

  @override
  String get photo_viewer_details_date_title => '日付';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => '互換性がある';

  @override
  String get user_lists_action_multi_select => '複数選択';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'あなたの互換性スコア: $score%';
  }

  @override
  String get product_image_front_accessibility_label => '前面の画像';

  @override
  String get product_image_ingredients_accessibility_label => '成分のリストの写真';

  @override
  String get product_image_nutrition_accessibility_label => '栄養画像';

  @override
  String get product_image_packaging_accessibility_label => 'パッケージ写真';

  @override
  String get product_image_other_accessibility_label => 'その他の写真';

  @override
  String get product_image_outdated_message => 'この写真は古い可能性があります';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (この画像は古い可能性があります)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (この画像はプロデューサーによってロックされている可能性があります)';
  }

  @override
  String get product_image_error => '画像を読み込めません!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type を読み込めません (ネットワーク エラーでしょうか?)';
  }

  @override
  String get product_page_image_no_image_available => '画像なし！';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'この商品の画像はありません';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'アクションの順序を変更または非表示にする';

  @override
  String get product_page_action_bar_setting_modal_title => '編集アクション';

  @override
  String get product_page_action_bar_item_move_up => '上に移動';

  @override
  String get product_page_action_bar_item_move_down => '下に移動';

  @override
  String get product_page_action_bar_item_enable => 'アクションを有効にする';

  @override
  String get product_page_action_bar_item_disable => 'アクションを無効にする';

  @override
  String get product_page_pending_operations_banner_title =>
      '編集内容をアップロードしています…';

  @override
  String get product_page_pending_operations_banner_message =>
      'このページに表示されているデータは**まだ変更を反映していません**。\n数秒お待ちください…';

  @override
  String get product_add_a_language => '言語を追加する';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'バーコード $barcode';
  }

  @override
  String get carousel_close_tooltip => 'この商品をカルーセルから削除する';

  @override
  String get carousel_unsupported_header => 'サポートされていないバーコードです。';

  @override
  String get carousel_unsupported_title => 'おっと！';

  @override
  String get carousel_unsupported_text =>
      'スキャンされたバーコードは Open Food Facts ではサポートされていません。';

  @override
  String get carousel_error_header => 'エラー！';

  @override
  String get carousel_error_title => 'それは残念だ！';

  @override
  String get carousel_error_text_1 => 'このバーコードに関する情報をダウンロードできませんでした:';

  @override
  String get carousel_error_text_2 => 'インターネット接続を確認するか、このボタンをクリックしてください:';

  @override
  String get carousel_error_button => '再試行';

  @override
  String get carousel_unknown_product_header => '不明な製品';

  @override
  String get carousel_unknown_product_title => 'おめでとうございます！\n__珍しい宝石を見つけました！__';

  @override
  String get carousel_unknown_product_text =>
      '当社の共同データベースには**300 万以上の製品**が含まれていますが、このバーコードは存在しません: ';

  @override
  String get carousel_unknown_product_button => 'この製品を追加';

  @override
  String get carousel_loading_header => '情報を読み込んでいます...';

  @override
  String get carousel_loading_title => '次のバーコードが付いた製品をスキャンしました:';

  @override
  String get carousel_loading_text => '**300 万点以上の製品**を収録したデータベースで検索中です。';

  @override
  String get product_type_subtitle_food => '野菜、果物、冷凍食品…';

  @override
  String get product_type_subtitle_beauty => '化粧品、石鹸、歯磨き粉…';

  @override
  String get product_type_subtitle_pet_food => '犬、猫の食べ物…';

  @override
  String get product_type_subtitle_product => 'スマートフォン、家具…';

  @override
  String get photo_field_front => '製品写真';

  @override
  String get photo_field_ingredients => '原材料の画像';

  @override
  String get photo_field_nutrition => '栄養写真';

  @override
  String get photo_field_packaging => 'パッケージ情報の画像';

  @override
  String get photo_already_exists => 'この写真は既に存在します';

  @override
  String get photo_missing => 'この写真がありません';

  @override
  String get date => '日付';

  @override
  String get photo_rotate_left => '左に回転';

  @override
  String get photo_rotate_right => '右に回転';

  @override
  String get photo_undo_action => '前の操作を元に戻す';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$locationの世界地図';
  }

  @override
  String get open_street_map_contributor_attribution => 'OpenStreetMap貢献者';

  @override
  String get not_applicable_short => '該当なし';

  @override
  String get knowledge_panel_warning_text => '警告';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'この Nutri-Score はパッケージに記載されているものとなぜ違うのですか?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      '考えられる理由は2つあります。\n原材料名または栄養成分表示が最新ではありません。\n\nNutri-Score（またはV2）は「新しい計算方法」で提供されています。パッケージに「新しい計算方法」のバナーが付いていることをご確認ください。';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      '材料を確認する';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      '栄養成分表示を確認する';

  @override
  String url_not_supported(String url) {
    return '残念ながら、URLを開くことができません:\n$url';
  }

  @override
  String get product_list_export => '輸出';

  @override
  String get product_list_import => '輸入';

  @override
  String get product_footer_action_barcode => 'バーコードを表示';

  @override
  String get product_footer_action_barcode_short => 'バーコード';

  @override
  String get product_footer_action_open_website => 'ウェブサイトを開く';

  @override
  String get product_footer_action_report => '報告';

  @override
  String get product_footer_action_contributor_guide => 'ヘルプ';

  @override
  String get product_footer_action_data_quality_tags => 'データ品質';

  @override
  String get product_page_tab_for_me => '私にとって';

  @override
  String get product_page_tab_website => 'ウェブサイト';

  @override
  String get product_page_tab_prices => '価格';

  @override
  String get prices_explanation_card_title => 'なぜ価格なのですか?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** は、世界中の商品の価格を収集し共有するプロジェクトです🌍。Open Prices は、Open Food Facts によって開発および管理されています。';

  @override
  String get explanation_card_learn_more_button => '詳細';

  @override
  String get product_page_tab_folksonomy => 'フォークソノミー';

  @override
  String get folksonomy_explanation_card_title => 'Folksonomy の属性とは何ですか?';

  @override
  String get folksonomy_explanation_card_line1 => '属性は**キーと値**に基づいています。';

  @override
  String get folksonomy_explanation_card_line2 =>
      'これらのプロパティは、あらゆる用途のために貢献者によって作成され、ファイルされます。';

  @override
  String get folksonomy_action_external_link_title => '外部リンクを開く';

  @override
  String get folksonomy_action_external_link_warning =>
      '外部リンクは安全ではない可能性があります。本当にアクセスしてもよろしいですか？';

  @override
  String get prices_products_empty_title => '価格はありません';

  @override
  String get prices_products_empty_explanation => '最初に貢献しましょう！';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return '上位 $pageSize 製品 (合計: $total)';
  }

  @override
  String get app_review_title => 'このアプリを楽しんでいますか?';

  @override
  String get app_review_low => 'もっと良くできる';

  @override
  String get app_review_medium => '悪くない';

  @override
  String get app_review_high => '大好きです！';

  @override
  String get app_review_feedback_modal_title => 'アプリケーションの改善にご協力ください';

  @override
  String get app_review_feedback_modal_content =>
      '数分お時間がありましたら、**今後のアップデートで改善できるよう**、このフォームにご回答いただけますでしょうか。';

  @override
  String get app_review_feedback_modal_open_form => 'フォームに回答する';

  @override
  String get app_review_feedback_modal_later => 'あとで';

  @override
  String get nutrition_facts_extract_new => '新機能：写真から栄養素を自動的に抽出できます！';

  @override
  String get nutrition_facts_extract_button_text => '今すぐ抽出';

  @override
  String get nutrition_facts_extract_in_progress => '抽出中…';

  @override
  String get nutrition_facts_extract_successful => '抽出成功';

  @override
  String get nutrition_facts_extract_failed => '画像から栄養素を抽出できませんでした';

  @override
  String get prices_discount => 'ディスカウント';

  @override
  String get prices_stats_statistics => '統計';

  @override
  String get prices_stats_title => '価格統計';

  @override
  String get prices_stats_prices_section => '価格';

  @override
  String get prices_stats_products_section => '製品';

  @override
  String get prices_stats_locations_section => '場所：';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => '貢献者';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'その他';

  @override
  String get prices_stats_total => '合計';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => '消費';

  @override
  String get prices_stats_with_price => '価格付き';

  @override
  String get prices_stats_food => '食べ物';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => '製品';

  @override
  String get prices_stats_pet_food => 'ペットフード';

  @override
  String get prices_stats_osm => 'オープンストリートマップ';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => '国';

  @override
  String get prices_stats_price_tag => '値札';

  @override
  String get prices_stats_receipt => '領収書';

  @override
  String get prices_stats_gdpr_request => 'GDPR リクエスト';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'ウェブサイト';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'その他';

  @override
  String get prices_stats_last_updated => '最終更新日';

  @override
  String get prices_stats_error => '統計の読み込み中にエラーが発生しました。';

  @override
  String get product_edit_robotoff_question_answered => '質問にお答えします！';

  @override
  String get product_edit_robotoff_proof => '証拠';

  @override
  String get preferences_card_general => '全般';

  @override
  String get preferences_prices_title => '価格';

  @override
  String get preferences_prices_subtitle => '価格設定を管理する';

  @override
  String get preferences_card_project => 'オープンフードファクトプロジェクト';

  @override
  String get preferences_contribute_title => '貢献する';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => '私の統計';

  @override
  String get preferences_contribute_subtitle => '翻訳してツールを改善しましょう…';

  @override
  String get preferences_connect_title => '接続する';

  @override
  String get preferences_connect_subtitle => 'ご連絡いただくか、ソーシャルメディアでフォローしてください';

  @override
  String get preferences_support_title => 'Make a donation';

  @override
  String get preferences_support_subtitle => '世界中の何百万人もの消費者に情報を提供するのにご協力ください';

  @override
  String get preferences_card_help => 'ヘルプとサポート';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => '質問への回答を得る';

  @override
  String get logged_out => 'ログアウトしました';

  @override
  String get preferences_app_bar_message => '私たちのメンバーになっていただきありがとうございます！';

  @override
  String get preferences_app_bar_products_modified => '製品が変更されました';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'すべての統計を見る';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '$provider で「$keyword」を検索';
  }

  @override
  String get preferences_app_bar_search_hint => '設定を検索する（例：Nutri-Score）';

  @override
  String get preferences_accessibility_show_emoji => 'アクセシビリティ: 絵文字を表示';

  @override
  String get preferences_accessibility_remove_colors => 'アクセシビリティ: 色を削除する';

  @override
  String get preferences_app_settings_products => '製品';

  @override
  String get preferences_card_about => 'アプリについて';

  @override
  String get preferences_legal_information_title => '法的情報';

  @override
  String get preferences_legal_information_subtitle => '利用規約、プライバシーポリシーなど';

  @override
  String get preferences_terms_of_use => '利用規約';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts は、**みんなが作った、みんなのための**食品データベースです。\nこれを使えば、より良い食品の選択ができるだけでなく、**オープン データ** なので、誰でも **どんな目的でも再利用** できます。';

  @override
  String get preferences_privacy_policy => 'プライバシーポリシー';

  @override
  String get preferences_licenses => 'ライセンス';

  @override
  String get preferences_about_app_title => 'アプリについて';

  @override
  String get preferences_about_app_subtitle => '技術情報、開発者情報など';

  @override
  String get preferences_card_information => '情報';

  @override
  String get preferences_version_number_title => 'バージョン番号';

  @override
  String get preferences_scanner_title => 'スキャナー';

  @override
  String get preferences_app_store => 'アプリストア';

  @override
  String get preferences_app_system_settings => 'システム設定';

  @override
  String get preferences_source_code => 'ソースコードにアクセスする';

  @override
  String get preferences_source_code_subtitle => 'そして何百万人もの人々に影響を与え始める';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => '製品情報を完成させる';

  @override
  String get preferences_tips => 'ヒント';

  @override
  String get tips_discover_nutriscore => '新しいNutri-Scoreをご覧ください';

  @override
  String get preferences_on_off_website_subtitle => 'オープンフードファクトのウェブサイト';

  @override
  String get preferences_manage_account_title => 'アカウントを管理する';

  @override
  String get preferences_manage_account_tooltip => 'アカウントを管理する';

  @override
  String get preferences_change_password_title => 'パスワードを変更する';

  @override
  String get preferences_danger_zone => '危険地帯';

  @override
  String get preferences_account_deletion_subtitle => 'あなたの貢献はすべて失われます';

  @override
  String get preferences_contributions_title => '貢献';

  @override
  String get preferences_dev_mode_app_settings_title => 'アプリの設定';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'オフラインで製品をスキャンする非常に実験的な方法';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'サーバーからすべての製品を更新します';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      '絶対に必要な場合を除き、そうしないでください';

  @override
  String get preferences_dev_mode_demo_mode_title => 'デモモード';

  @override
  String get preferences_dev_mode_add_cards_title => 'スキャナーにカードを追加する';

  @override
  String get preferences_dev_mode_add_cards_subtitle => 'スキャナーに3つのサンプル製品を追加します';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'フォークソノミーホスト';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'ホスト: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'アクセシビリティ実験';

  @override
  String get preferences_dev_mode_multi_products_selection_title => '価格の複数製品選択';

  @override
  String get preferences_dev_mode_user_ordered_kp_title => 'ユーザーが注文したナレッジパネル';

  @override
  String get preferences_dev_mode_location_search_title => '場所検索への一時アクセス';

  @override
  String get preferences_dev_mode_comparison_title => '2つまたは3つの製品を並べて比較する';

  @override
  String get preferences_dev_mode_product_list_import_title => '製品リストのインポート';

  @override
  String get preferences_faq_scores_methodologies_title => 'スコアと方法論';

  @override
  String get preferences_faq_nutriscore_subtitle => 'Nutri-Scoreの計算方法をご覧ください';

  @override
  String get preferences_faq_nutriscore_v2_subtitle => '方法論の主な変更点を確認する';

  @override
  String get preferences_faq_discover_project_title => 'プロジェクトを見つける';

  @override
  String get preferences_faq_discover_off_title => 'オープンフードファクトを発見';

  @override
  String get preferences_faq_discover_obf_title => 'オープンビューティーファクトを発見';

  @override
  String get preferences_faq_discover_opff_title => 'オープンペットフードの事実を知る';

  @override
  String get preferences_faq_discover_op_title => 'オープン価格を見る';

  @override
  String get preferences_faq_discover_opf_title => 'オープンプロダクトの詳細を見る';

  @override
  String get preferences_faq_faq_title => 'FAQ - よくある質問';

  @override
  String get preferences_faq_off_ngo_title => 'オープンフードファクトNGO';

  @override
  String get preferences_about_information_title => '情報';

  @override
  String get preferences_connect_community_updates_title => 'コミュニティの最新情報を入手する';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'アプリとコミュニティのニュースを常にチェック';

  @override
  String get preferences_connect_community_calendar_title => 'コミュニティカレンダーを購読する';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'バーチャルイベントに参加して、ぜひご参加ください';

  @override
  String get preferences_connect_blog_title => 'オープンフードファクトブログ';

  @override
  String get preferences_connect_blog_subtitle => '最新ニュースをすぐに入手';

  @override
  String get preferences_connect_community_help_title => 'コミュニティから助けを得る';

  @override
  String get preferences_connect_improve_app_title => 'アプリの改善にご協力ください';

  @override
  String get preferences_connect_debug_info_title => 'デバッグ情報を送信してください';

  @override
  String get preferences_connect_debug_info_subtitle =>
      '詳細なデバッグ情報を記載したメールをお送りください';

  @override
  String get preferences_connect_feedback_title => 'アプリに関するフィードバックをお送りください';

  @override
  String get preferences_connect_feedback_subtitle => 'アプリの未来を形作るのを手伝ってください';

  @override
  String get preferences_connect_survey_title => 'アプリのアンケートにご協力ください';

  @override
  String get preferences_connect_survey_subtitle => '次に何を構築すべきかを理解するのにご協力ください';

  @override
  String get preferences_connect_professionals_title => 'プロフェッショナル';

  @override
  String get preferences_connect_pro_subtitle =>
      '完全に無料で、500のアプリと数百万人の消費者の正確なデータを提供します。セルフサービスで、PIMまたはスプレッドシート（XLSX）と互換性があります。';

  @override
  String get preferences_connect_pro_email_subtitle => 'まずはお問い合わせください';

  @override
  String get preferences_connect_press_title => 'プレス';

  @override
  String get preferences_connect_press_page_subtitle => 'レポートに必要な資料をすべて入手';

  @override
  String get preferences_connect_press_email_subtitle =>
      '報道関係のお問い合わせやレポートのお知らせは、こちらまでご連絡ください。';

  @override
  String get preferences_contribute_active_volunteer_title => '積極的にボランティアになる';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      '開発、コミュニケーション、デザイン… あらゆる種類のボランティアや専門知識を歓迎します!';

  @override
  String get preferences_contribute_how_to_subtitle => '貢献できる様々な方法をご紹介します';

  @override
  String get preferences_contribute_mobile_dev_title => 'モバイルアプリ開発';

  @override
  String get preferences_contribute_sw_dev_subtitle => 'ソフトウェア開発に貢献する方法を学ぶ';

  @override
  String get preferences_contribute_alpha_subtitle => '毎日の不安定なビルド、新機能';

  @override
  String get preferences_contribute_local_community_title => '地域社会を成長させましょう';

  @override
  String get preferences_contribute_translate_subtitle =>
      'ソフトウェア、コンテンツ、成分分析の翻訳支援';

  @override
  String get preferences_contribute_share_subtitle =>
      '役に立つ小さなテンプレートを用意しました :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'あなたの国で食品の透明性を高めるための簡単なステップ';

  @override
  String get preferences_contribute_data_quality_title => 'データ品質';

  @override
  String get preferences_contribute_data_quality_team_title => 'データ品質チームに参加する';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'データベースの完全性と正確性を確保するための私たちの取り組みにご参加ください';

  @override
  String get preferences_contributions_products_added_title => '追加された製品';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Open Food Factsに追加した新製品';

  @override
  String get preferences_contributions_to_be_completed_title => '完了する必要がある製品';

  @override
  String get preferences_contributions_all_incomplete_title => 'すべての不完全な製品';

  @override
  String get preferences_my_contributions_prices_title => '価格';

  @override
  String get preferences_my_contributions_my_prices_title => '私の価格';

  @override
  String get preferences_my_contributions_my_prices_subtitle => '私の価格、私の証明…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      '完成にご協力いただける製品';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'あなたの国のNutri-ScoreとGreen-Scoreの計算にご協力ください';

  @override
  String get preferences_prices_user_prices_subtitle => '私が寄付した価格';

  @override
  String get preferences_prices_proofs_subtitle => '値札と領収書';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'レシートの写真を撮り、関連するバーコードをスキャンします';

  @override
  String get preferences_prices_add_price_tags_subtitle => '店内の価格を写真に撮る';

  @override
  String get preferences_prices_newest_title => '最新価格';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Pricesコミュニティによって追加された最新の価格';

  @override
  String get preferences_prices_top_contributors_title => '最も多くの価格を提示した貢献者';

  @override
  String get preferences_prices_metrics_title => '始値指標';

  @override
  String get preferences_prices_metrics_subtitle => 'プロジェクトの進捗を追跡する';

  @override
  String get preferences_prices_ways_contribute_title => '貢献する方法';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'AIの助けを借りて、自分や他の人によって追加された価格を確認します';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'カメラロールからたくさんの領収書や棚の写真を素早く追加できます';

  @override
  String get preferences_prices_challenges_title => '毎月のチャレンジ';

  @override
  String get preferences_prices_challenges_subtitle => '毎月のテーマ別クエストに参加して賞品を集める';

  @override
  String get preferences_prices_loyalty_data_title => 'ロイヤルティデータを取り戻す';

  @override
  String get preferences_prices_gdpr_subtitle => 'データのリクエスト方法を学ぶ';

  @override
  String get preferences_page_customize_app_title => 'アプリをカスタマイズする';

  @override
  String get preferences_page_contribute_project_title => 'プロジェクトに貢献する';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Factsを支援する簡単な方法';

  @override
  String get preferences_page_faq_subtitle => 'スコアリングの方法論、ヘルプ、プロジェクトの詳細';

  @override
  String get product_edit_robotoff_positive_button => '提案を受け入れる';

  @override
  String get product_edit_robotoff_negative_button => '提案を拒否';

  @override
  String get product_edit_robotoff_show_proof => '証拠を示す';

  @override
  String get product_edit_robotoff_expand_proof => '証拠を拡大する';

  @override
  String get product_page_tab_raw_data => '生データ';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'ページ $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'ページ $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$total 件中 $count 件目';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$total 件中 $count 件目';
  }

  @override
  String item_count(int count) {
    return '$count 個のアイテム';
  }

  @override
  String item_count_string(String count) {
    return '$count 個のアイテム';
  }

  @override
  String get prices_no_result => '価格統計が見つかりません。';

  @override
  String get prices_error_loading_more_items => 'さらにアイテムを読み込む際にエラーが発生しました';

  @override
  String get prices_proof_error => '認証に失敗しました。証明を取得できません';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$total 件中 $count 件の証明';
  }

  @override
  String proof_count(int count) {
    return '$count 件の証明';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$total 人中 $count 人の貢献者';
  }

  @override
  String contributors_count(int count) {
    return '$count 人の貢献者';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$total か所のうち $count か所';
  }

  @override
  String prices_locations_count(int count) {
    return '$count の場所';
  }

  @override
  String get restart_to_apply_message => '変更を適用するにはアプリを再起動してください。';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'グラフィカルインターフェース';

  @override
  String get preferences_app_settings_media_title => 'メディア';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title => 'オープンフードファクトラボ';

  @override
  String get preferences_root_account_title => 'アカウント';

  @override
  String get preferences_contribute_translate_header =>
      'Open Food Factsをあなたの言語で';

  @override
  String get preferences_contribute_enroll_alpha => 'アプリのアルファ版に登録する';

  @override
  String get preferences_dev_mode_section_data => '貢献と製品データ';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Folksonomyを表示しない';

  @override
  String get preferences_account_title => 'アカウント';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '$createdに追加されました';
  }

  @override
  String get location_map_details_title => '場所の詳細';

  @override
  String get location_map_details_name => '名前';

  @override
  String get location_map_details_street => '通り';

  @override
  String get location_map_details_city => '市';

  @override
  String get location_map_details_postcode => '郵便番号';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => '座標';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
