// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Finnish (`fi`).
class AppLocalizationsFi extends AppLocalizations {
  AppLocalizationsFi([String locale = 'fi']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Kyllä';

  @override
  String get add => 'Lisää';

  @override
  String get account_delete_message =>
      'Oletko varma, että haluat poistaa tilisi?\nKerro meille, jos tilinpoistolle on erityinen syy';

  @override
  String get reason => 'Syy';

  @override
  String get okay => 'OK';

  @override
  String get validate => 'Vahvista';

  @override
  String get create => 'Luo';

  @override
  String get applyButtonText => 'Hyväksy';

  @override
  String get next_label => 'Seuraava';

  @override
  String get continue_label => 'Jatka';

  @override
  String get exit_label => 'Poistu';

  @override
  String get previous_label => 'Edellinen';

  @override
  String get go_back_to_top => 'Takaisin ylös';

  @override
  String get save => 'Tallenna';

  @override
  String get save_confirmation => 'Haluatko varmasti tallentaa?';

  @override
  String get skip => 'Ohita';

  @override
  String get cancel => 'Peruuta';

  @override
  String get ignore => 'Ohita';

  @override
  String get close => 'Sulje';

  @override
  String get no => 'Ei';

  @override
  String get stop => 'Lopeta';

  @override
  String get finish => 'Valmis';

  @override
  String get calculate => 'Laske';

  @override
  String get reset_food_prefs => 'Nollaa ruokamieltymykset';

  @override
  String get error => 'Jokin meni vikaan';

  @override
  String get error_occurred => 'Tapahtui virhe';

  @override
  String get featureInProgress =>
      'Työstämme edelleen tätä ominaisuutta, pysy kuulolla';

  @override
  String get label_web => 'Tarkastele verkossa';

  @override
  String get learnMore => 'Opi lisää';

  @override
  String get unknown => 'Tuntematon';

  @override
  String get match_very_good => 'Erittäin hyvä vastaavuus';

  @override
  String get match_good => 'Hyvä vastaavuus';

  @override
  String get match_poor => 'Heikko vastaavuus';

  @override
  String get match_may_not => 'Ei ehkä vastaa';

  @override
  String get match_does_not => 'Ei vastaa';

  @override
  String get match_unknown => 'Tuntematon vastaavuus';

  @override
  String get match_short_very_good => 'Erittäin hyvä vastaavuus';

  @override
  String get match_short_good => 'Hyvä vastaavuus';

  @override
  String get match_short_poor => 'Heikko vastaavuus';

  @override
  String get match_short_may_not => 'Ei ehkä vastaa';

  @override
  String get match_short_does_not => 'Ei vastaa';

  @override
  String get match_short_unknown => 'Tuntematon vastaavuus';

  @override
  String get licenses => 'Lisenssit';

  @override
  String get looking_for => 'Etsitään';

  @override
  String get welcomeToOpenFoodFacts => 'Tervetuloa Open Food Factsiin';

  @override
  String get whatIsOff =>
      'Open Food Facts on globaali voittoa tavoittelematon järjestö, jota tukevat paikalliset yhteisöt.';

  @override
  String get productDataUtility => 'Katso valintoihisi liittyvät ruokatietosi.';

  @override
  String get healthCardUtility =>
      'Valitse ruoat, jotka tekevät itsellesi hyvää.';

  @override
  String get ecoCardUtility =>
      'Valitse ruoat, jotka tekevät planeetalle hyvää.';

  @override
  String get server_error_open_new_issue =>
      'Ei vastausta palvelimelta! Voit luoda ongelmailmoituksen seuraavan linkin avulla.';

  @override
  String get sign_in_text =>
      'Kirjaudu sisään Open Food Facts -tilillesi tallentaaksesi avustuksesi';

  @override
  String get incorrect_credentials =>
      'Virheellinen käyttäjätunnus tai salasana.';

  @override
  String get password_lost_incorrect_credentials =>
      'Tätä sähköpostiosoitetta tai käyttäjätunnusta ei ole olemassa. Tarkista kirjautumistietosi.';

  @override
  String get password_lost_server_unavailable =>
      'Palvelimellamme on tällä hetkellä hidastuksia, pahoittelut. Yritä uudelleen myöhemmin.';

  @override
  String get login => 'Kirjaudu';

  @override
  String get login_result_type_server_unreachable =>
      'Verkkoon ei saada yhteyttä';

  @override
  String get login_result_type_server_issue =>
      'Ongelma palvelimella. Ole hyvä ja yritä myöhemmin.';

  @override
  String get login_page_username_or_email =>
      'Syötä käyttäjänimi tai sähköposti';

  @override
  String get login_page_password_error_empty => 'Syötä salasana';

  @override
  String get create_account => 'Luo tili';

  @override
  String get sign_in => 'Kirjaudu sisään';

  @override
  String get sign_in_mandatory =>
      'Kirjaudu käyttääksesi kyseistä ominaisuutta.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Kirjaudu ulos';

  @override
  String get sign_out_confirmation => 'Haluatko varmasti kirjautua ulos?';

  @override
  String get password => 'Salasana';

  @override
  String get forgot_password => 'Unohtunut salasana';

  @override
  String get forgot_password_question => 'Unohditko salasanasi?';

  @override
  String get view_profile => 'Näytä profiili';

  @override
  String get reset_password => 'Palauta salasana';

  @override
  String get reset_password_explanation_text =>
      'Mikäli unohdit salasanasi, syötä käyttäjätunnuksesi tai sähköpostiosoitteesi saadaksesi ohjeet salasanan vaihtoon. Muista tarkistaa myös roskapostikansio.';

  @override
  String get username_or_email => 'Käyttäjätunnus tai sähköpostiosoite';

  @override
  String get reset_password_done =>
      'Lähetimme tiliin kirjattuun sähköpostiosoitteeseen linkin salasananvaihdokseen. Tarkista myös roskapostikansio';

  @override
  String get send_reset_password_mail => 'Vaihda salasana';

  @override
  String get enter_some_text => 'Syötä tekstiä';

  @override
  String get sign_up_page_title => 'Rekisteröidy';

  @override
  String get sign_up_page_action_button => 'Rekisteröidy';

  @override
  String get sign_up_page_action_doing_it => 'Rekisteröidytään…';

  @override
  String get sign_up_page_action_ok => 'Onnittelut! Tilisi on nyt luotu.';

  @override
  String get sign_up_page_display_name_hint => 'Nimi';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Lisää haluamasi julkinen nimi';

  @override
  String get sign_up_page_email_hint => 'Sähköpostiosoite';

  @override
  String get sign_up_page_email_error_empty => 'Sähköpostiosoite on pakollinen';

  @override
  String get sign_up_page_email_error_invalid =>
      'Virheellinen sähköpostiosoite';

  @override
  String get sign_up_page_username_hint => 'Käyttäjänimi: julkinen';

  @override
  String get sign_up_page_username_error_empty => 'Syötä käyttäjänimi';

  @override
  String get sign_up_page_username_error_invalid =>
      'Syötä kelvollinen käyttäjänimi';

  @override
  String get sign_up_page_username_description =>
      'Käyttäjänimi ei voi sisältää välilyöntejä, suuraakkosia tai erikoismerkkejä.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Käyttäjänimi ei voi olla yli $value merkkiä pitkä';
  }

  @override
  String get sign_up_page_password_hint => 'Salasana';

  @override
  String get sign_up_page_password_error_empty => 'Syötä salasana';

  @override
  String get sign_up_page_password_error_invalid =>
      'Syötä kelvollinen salasana (vähintään 6 merkkiä)';

  @override
  String get sign_up_page_confirm_password_hint => 'Vahvista salasana';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Vahvistathan salasanasi';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Salasanat eivät täsmää';

  @override
  String get sign_up_page_agree_text => 'Hyväksyn Open Food Factsin';

  @override
  String get sign_up_page_terms_text => 'käyttö- ja osallistumisehdot';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Luodessasi tilin käyttöehtojen hyväksyminen on pakollista, mutta voit silti osallistua anonyymisti sovelluksessa';

  @override
  String get sign_up_page_producer_checkbox => 'Olen elintarvikkeiden tuottaja';

  @override
  String get sign_up_page_producer_hint => 'Tuottaja/tuotemerkki';

  @override
  String get sign_up_page_producer_error_empty =>
      'Syötä tuottaja tai tuotemerkki';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Haluan tilata Open Food Facts -uutiskirjeen (Voit peruuttaa sen tilauksen milloin tahansa)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Käyttäjänimi on varattu, valitse toinen käyttäjänimi.';

  @override
  String get sign_up_page_email_already_exists =>
      'on jo käytössä, kirjaudu tai kokeile toisella sähköpostiosoitteella.';

  @override
  String get sign_up_page_provide_valid_email => 'Anna käypä sähköpostiosoite.';

  @override
  String get sign_up_page_server_busy =>
      'Olemme syvästi pahoillamme, mutta meillä on teknisiä vaikeuksia tilisi luomisessa. Yritä uudelleen myöhemmin.';

  @override
  String get settingsTitle => 'Asetukset';

  @override
  String get darkmode => 'Teema';

  @override
  String get darkmode_dark => 'Tumma';

  @override
  String get darkmode_light => 'Vaalea';

  @override
  String get darkmode_system_default => 'Järjestelmän oletus';

  @override
  String get thanks_for_contributing => 'Kiitos osallistumisestasi!';

  @override
  String get contributors_label => 'He rakentavat sovellusta';

  @override
  String get contributors_dialog_title => 'Osallistujat';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Tekijä: $name';
  }

  @override
  String get contributors_description =>
      'Luettelo kaikista tämän sovelluksen tekijöistä';

  @override
  String get support => 'Tuki';

  @override
  String get support_join_slack => 'Pyydä apua Slack-kanavallamme';

  @override
  String get support_via_forum => 'Kysy apua foorumillamme';

  @override
  String get support_via_email => 'Lähetä meille sähköpostia';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Lähetetäänkö sovellusloki?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Haluatko liittää sovelluslokit sähköpostiisi?';

  @override
  String get termsOfUse => 'Käyttöehdot';

  @override
  String get legalNotices => 'Lailliset huomautukset';

  @override
  String get privacy_policy => 'Tietosuojakäytäntö';

  @override
  String get about_this_app => 'Tietoa sovelluksesta';

  @override
  String get contribute => 'Osallistu';

  @override
  String get contribute_sw_development => 'Ohjelmistokehitys';

  @override
  String get contribute_develop_text =>
      'Jokaisen Open Food Facts -tuotteen koodi on saatavilla GitHubissa. Koodia saa käyttää vapaasti (lähdekoodi on avoin) ja parannella. Parannuksista hyötyy jokainen, koko planeetta.';

  @override
  String get contribute_develop_text_2 =>
      'Voit liittyä Open Food Factsin Slack-keskusteluryhmään, jossa voi esittää kysymyksiä.';

  @override
  String get contribute_develop_dev_mode_title => 'Kehittäjätila?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktivoi kehittäjätila';

  @override
  String get contribute_donate_title => 'Lahjoita';

  @override
  String get contribute_donate_header => 'Lahjoita Open Food Factsille';

  @override
  String get contribute_enroll_alpha_warning =>
      'Huomaa, että sisäisellä alfaversiolla tietojen täydellinen menetys on mahdollista ja sovellus voi muuttua käyttökelvottomaksi milloin tahansa!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Täydennettävät tuotteet';

  @override
  String get contribute_improve_header => 'Kehitys';

  @override
  String get contribute_improve_text =>
      'Tietokanta on hankkeen ydin. Se on helppoa ja erittäin nopeaa auttaa. Voit ladata mobiilisovelluksen puhelimeesi ja aloittaa tuotteiden lisäämisen tai parantamisen.\n\nToisaalta Open Food Facts -sivusto tarjoaa monia tapoja osallistua: ';

  @override
  String get contribute_translate_header => 'Käännä';

  @override
  String get contribute_data_quality => 'Tietojen laatu';

  @override
  String get contribute_translate_link_text => 'Aloita kääntäminen';

  @override
  String get contribute_translate_text =>
      'Open Food Facts on maailmanlaajuinen projekti, joka sisältää tuotteita yli 160 maasta. Open Food Facts on käännetty kymmenille kielille, ja sen sisältö kehittyy jatkuvasti.';

  @override
  String get contribute_translate_text_2 =>
      'Käännökset on yksi hankkeen keskeisistä tehtävistä';

  @override
  String get contribute_join_skill_pool =>
      'Edistä taitojasi Open Food Factsissa. Liity osaamispooliin!';

  @override
  String get contribute_share_header => 'Jaa Open Food Facts ystäviesi kanssa';

  @override
  String get contribute_share_content =>
      'Halusin kertoa sinulle käyttämästäni Open Food Facts -sovelluksesta, jonka avulla saat henkilökohtaisesti selville ruokasi terveys- ja ympäristövaikutukset. Se toimii skannaamalla pakkauksessa olevat viivakoodit. Lopuksi se on ilmainen, ei vaadi rekisteröintiä, ja voit jopa auttaa lisäämään purettujen tuotteiden määrää. Tässä linkki, josta saat sen puhelimeesi: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribute prices by requesting a GDPR export of your loyalty cards data';

  @override
  String get tap_to_answer => 'Vastaa tästä kysymyksiin';

  @override
  String get tap_to_answer_hint =>
      'Napauta tätä vastataksesi tätä tuotetta koskeviin kysymyksiin';

  @override
  String get robotoff_questions_loading_hint =>
      'Odota. Tätä tuotetta koskevia kysymyksiä ladataan';

  @override
  String get saving_answer => 'Tallennetaan vastauksiasi';

  @override
  String get contribute_to_get_rewards =>
      'Ryhdy ruoan läpinäkyvyyden toimijaksi';

  @override
  String get question_sign_in_text =>
      'Kirjaudu sisään Open Food Facts -tilillesi saadaksesi hyvitystä avustuksestasi';

  @override
  String get question_yes_button_accessibility_value => 'Vastaa kyllä';

  @override
  String get question_no_button_accessibility_value => 'Vastaa ei';

  @override
  String get question_skip_button_accessibility_value => 'Ohita tämä kysymys';

  @override
  String get tap_to_edit_search => 'Muokkaa hakua';

  @override
  String get myPreferences => 'Mieltymykseni';

  @override
  String get account_create_message =>
      'Luo tili ja liity Open Food Facts -yhteisöön auttaaksesi rakentamaan ruokatietoa kaikkialla maailmassa!';

  @override
  String get join_us => 'Liity';

  @override
  String get myPreferences_profile_title => 'Profiilisi';

  @override
  String get myPreferences_profile_subtitle =>
      'Hallinnoi Open Food Facts -avustajatiliäsi.';

  @override
  String get myPreferences_settings_title => 'Sovellusasetukset';

  @override
  String get myPreferences_settings_subtitle => 'Dark mode, Languages…';

  @override
  String get myPreferences_food_title => 'Ruokamieltymykset';

  @override
  String get myPreferences_food_subtitle =>
      'Valitse, mikä ruoan tieto kiinnostaa eniten.';

  @override
  String get myPreferences_food_comment =>
      'Valitse, mitkä tiedot ruoasta ovat sinulle tärkeimpiä, jotta voit luokitella ruoat mieltymystesi mukaan, nähdä sinulle tärkeät tiedot ensin ja saada yhteensopivuusyhteenveto. Nämä ruokamieltymykset pysyvät laitteessasi, eikä niitä yhdistetä Open Food Facts -avustajatiliisi, jos sinulla on sellainen.';

  @override
  String get confirmResetPreferences => 'Nollaa ruokamieltymyksesi?';

  @override
  String get myPersonalizedRanking => 'Henkilökohtainen sijoitukseni';

  @override
  String get ranking_tab_all => 'Kaikki';

  @override
  String get ranking_subtitle_match_yes => 'Hyvä osuma sinulle';

  @override
  String get ranking_subtitle_match_no => 'Heikko osuma';

  @override
  String get ranking_subtitle_match_maybe => 'Tuntematon vastaavuus';

  @override
  String get refresh_with_new_preferences =>
      'Päivitä lista uusilla ruokamieltymyksilläsi';

  @override
  String get reloaded_with_new_preferences => 'Ladattu uusin asetuksin';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Lue';

  @override
  String get history_navbar_label => 'Historia';

  @override
  String get list_navbar_label => 'Listat';

  @override
  String get category => 'Suodata luokan mukaan';

  @override
  String get category_all => 'Kaikki';

  @override
  String get category_search => '(luokkahaku)';

  @override
  String get filter => 'Suodata';

  @override
  String get scan => 'Tuotteet skannausnäytöstä';

  @override
  String get scan_history => 'Skannaushistoria';

  @override
  String get search => 'Etsi';

  @override
  String get search_product_help =>
      'Hae tuotetta,\ntuotemerkkiä tai viivakoodia';

  @override
  String get search_filter => 'Hakusuodatin';

  @override
  String get search_history => 'Hakuhistoria';

  @override
  String get search_store => 'Hae myymälää';

  @override
  String get search_store_help => 'Vihje: lisää kaupunki tai maa';

  @override
  String get tap_for_more => 'Napauta nähdäksesi lisätietoja…';

  @override
  String get product => 'Tuote';

  @override
  String get unknownBrand => 'Tuntematon tuotemerkki';

  @override
  String get unknownProductName => 'Tuntematon tuotenimi';

  @override
  String get label_refresh => 'Päivitä';

  @override
  String get label_reload => 'Reload';

  @override
  String get image => 'Kuva';

  @override
  String get front_photo => 'Tuotteen etupuoli';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (tämä kuva saattaa olla vanhentunut)';
  }

  @override
  String get outdated_image_short_label => 'may be outdated';

  @override
  String get ingredients => 'Ainesosat';

  @override
  String get ingredients_editing_instructions =>
      'Keep the original order. Indicate the percentage when specified. Separate with a comma or hyphen and use parentheses for ingredients of an ingredient.';

  @override
  String get ingredients_editing_error =>
      'Ainesosalistan tallennus epäonnistui.';

  @override
  String get ingredients_editing_image_error =>
      'Ainesosakuvan lataus epäonnistui.';

  @override
  String get ingredients_editing_title => 'Muokkaa ainesosia';

  @override
  String get ingredients_photo => 'Ainesosakuva';

  @override
  String get packaging_editing_instructions =>
      'Luettele pakkauksen osat pilkuin taikka rivinvaihdoin eroteltuna, ilmoita myös lukumäärä (kuten 1 tai 6), tyyppi (kuten pullo, laatikko tai tölkki), materiaali (kuten muovi, metalli tai alumiini) sekä mikäli mahdollista, koko (kuten 33 cl) ja kierrätysohjeet.\nEsimerkki: 1 lasipullo kierrätettäväksi, 1 muovikorkki heitettäväksi pois';

  @override
  String get packaging_editing_error => 'Pakkauksen tallentaminen epäonnistui.';

  @override
  String get packaging_editing_image_error =>
      'Pakkauskuvan hakeminen epäonnistui.';

  @override
  String get packaging_editing_title => 'Muokkaa pakkausta';

  @override
  String get nutrition => 'Ravinto';

  @override
  String get nutrition_facts_photo => 'Ravintosisältökuva';

  @override
  String get nutrition_facts_editing_title => 'Edit Nutrition Facts';

  @override
  String get packaging_information => 'Pakkaustiedot';

  @override
  String get packaging_information_photo => 'Pakkaustietokuva';

  @override
  String get missing_product => 'Löysit uuden tuotteen!';

  @override
  String get add_product_take_photos =>
      'Ota valokuvia pakkauksesta lisätäksesi tämän tuotteen Open Food Factsiin';

  @override
  String get add_product_take_photos_descriptive =>
      'Ota kuvia ensin. Voit viimeistellä myöhemmin.';

  @override
  String get add_product_information_button_label => 'Lisää tuotetiedot';

  @override
  String get new_product => 'Uusi tuote';

  @override
  String get new_product_found_title => 'Löysit uuden tuotteen!';

  @override
  String get new_product_found_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get new_product_found_button => 'Lisää tämä tuote';

  @override
  String get new_product_leave_title => 'Poistu tältä sivulta?';

  @override
  String get new_product_leave_message =>
      'Näyttää siltä, ettet syöttänyt mitään. Haluatko todella poistua tältä sivulta?';

  @override
  String get new_product_dialog_description =>
      'Lisää tämä tuote yhteiseen tietokantaamme ottamalla sen pakkauksesta kuvia';

  @override
  String get new_product_dialog_illustration_description =>
      'Kuva tuntemattomasta Nutri-Scoresta ja Green-Scoresta';

  @override
  String get front_packaging_photo_button_label => 'Kuva edestä';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Vahvista edestäpäin otetun kuvan lataaminen';

  @override
  String get confirm_button_label => 'Vahvista';

  @override
  String get send_image_button_label => 'Lähetä kuva';

  @override
  String get crop_page_action_saving => 'Tallennetaan kuvaa…';

  @override
  String get crop_page_action_cropping => 'Rajataan kuvaa…';

  @override
  String get crop_page_action_local => 'Tallennetaan paikallinen versio…';

  @override
  String get crop_page_action_local_failed_title =>
      'Hups… valokuvassasi on jotain!';

  @override
  String get crop_page_action_local_failed_message =>
      'Emme pysty käsittelemään kuvaa paikallisesti ennen sen lähettämistä palvelimellemme. Yritä myöhemmin uudelleen tai ota meihin yhteyttä, jos ongelma jatkuu.';

  @override
  String get crop_page_action_retake => 'Retake a photo';

  @override
  String get crop_page_too_small_image_title => 'Kuva on liian pieni!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Vähimmäiskoko pikseleinä kuvan lähettämiseen on ${expectedMinWidth}x$expectedMinHeight. Nykyinen kuva on ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Valmistellaan palvelinkutsua…';

  @override
  String get front_packaging_photo_title => 'Pakkauksen kuva';

  @override
  String get ingredients_photo_title => 'Sisältöluettelon kuva';

  @override
  String get nutritional_facts_photo_title => 'Ravintosisältökuva';

  @override
  String get recycling_photo_title => 'Kierrätyksen kuva';

  @override
  String get take_photo_title => 'Ota kuva';

  @override
  String get take_more_photo_title => 'Ota lisää kuvia';

  @override
  String get front_photo_uploaded => 'Etukuva ladattu';

  @override
  String get ingredients_photo_button_label => 'Ainesosakuva';

  @override
  String get ingredients_photo_uploaded => 'Sisältöluettelokuva ladattu';

  @override
  String get nutrition_cache_loading_error =>
      'Ravintoaineita ei voida ladata välimuistista';

  @override
  String get nutritional_facts_photo_button_label => 'Ravintosisältökuva';

  @override
  String get nutritional_facts_input_button_label => 'Lisää ravintosisältö';

  @override
  String get nutritional_facts_added => 'Ravintosisältö lisätty';

  @override
  String get categories_added => 'Tuoteluokat lisätty';

  @override
  String get new_product_title_nutriscore => 'Laske Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Hanki se täyttämällä ruokaluokka ja ravintoarvot';

  @override
  String get new_product_title_environmental_score => 'Laske Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Sinun on lisättävä tuotteelle luokka, jotta laskelma voidaan suorittaa';

  @override
  String get new_product_additional_environmental_score =>
      'Lisää tuotteen alkuperä- ja pakkaustiedot sekä muita tietoja, jotta Green-Score-laskelma olisi tarkempi';

  @override
  String get new_product_title_nova => 'Laske ruoan jalostustaso (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Hanki se täyttämällä ruokaluokka ja ainesosat';

  @override
  String get new_product_desc_nova_unknown => 'Ruoan jalostusaste tuntematon';

  @override
  String get new_product_title_pictures => 'Otetaan muutamia kuvia!';

  @override
  String get new_product_title_pictures_details =>
      'Ota seuraavat kuvat, niin Open Food Facts -moottori ratkaisee loput!';

  @override
  String get new_product_title_misc => 'Ja joitakin perustietoja…';

  @override
  String new_product_done_msg(String username) {
    return 'Kiitos panoksestasi \"$username\"!';
  }

  @override
  String get new_product_done_msg_no_user => 'Kiitos panostuksestasi!';

  @override
  String get new_product_done_button_label => 'Tutustu valmiiseen tuotteeseen';

  @override
  String get hey_incomplete_product_message =>
      'Napauta tästä ja vastaa Nutri-Scoren, Green-Scoren ja jalostusasteen (NOVA) laskemiseen tarvittaviin \nkolmeen kysymykseen!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Napauta tästä ja vastaa kahteen kosmetiikkatuotteen analysoimiseen tarvittavaan kysymykseen!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Napauta tästä ja vastaa kahteen lemmikkieläinten ruokatuotteen analysoimiseen tarvittavaan kysymykseen!';

  @override
  String get hey_incomplete_product_message_product =>
      'Napauta tästä ja auta täydentämään tämän tuotteen tiedot!';

  @override
  String get nutritional_facts_photo_uploaded => 'Ravintosisältökuva ladattu';

  @override
  String get recycling_photo_button_label => 'Kierrätyskuva';

  @override
  String get recycling_photo_uploaded => 'Kierrätyskuva ladattu';

  @override
  String get take_more_photo_button_label => 'Ota lisää kuvia';

  @override
  String get other_photo_uploaded => 'Sekalainen kuva ladattu';

  @override
  String get retake_photo_button_label => 'Ota uudelleen';

  @override
  String get selecting_photo => 'Valitaan kuva';

  @override
  String get uploading_image => 'Ladataan kuva palvelimelle';

  @override
  String get uploading_image_type_front =>
      'Ladataan etukuva Open Food Factsiin';

  @override
  String get uploading_image_type_ingredients =>
      'Ladataan ainesosien kuvaa Open Food Factsiin';

  @override
  String get uploading_image_type_nutrition =>
      'Ladataan ravintosisältökuvaa Open Food Factsiin';

  @override
  String get uploading_image_type_packaging =>
      'Ladataan pakkauskuvaa Open Food Factsiin';

  @override
  String get uploading_image_type_other =>
      'Ladataan muuta kuvaa Open Food Factsiin';

  @override
  String get uploading_image_type_generic =>
      'Ladataan kuvaa Open Foods Factsiin';

  @override
  String get score_add_missing_ingredients => 'Lisää puuttuva ravintoaine';

  @override
  String get score_add_missing_packaging_image => 'Lisää kuva pakkauksesta';

  @override
  String get score_add_missing_nutrition_facts =>
      'Lisää puuttuva ravintosisältö';

  @override
  String get score_add_missing_product_traces => 'Add missing product traces';

  @override
  String get score_add_missing_product_category => 'Lisää puuttuva tuoteluokka';

  @override
  String get score_add_missing_precise_product_category =>
      'Valitse tarkempi kategoria';

  @override
  String get score_add_missing_product_countries => 'Lisää valmistusmaa';

  @override
  String get score_add_missing_product_emb => 'Lisää jäljitettävyyskoodi';

  @override
  String get score_add_missing_product_labels => 'Lisää puuttuvat merkit';

  @override
  String get score_add_missing_product_origins => 'Lisää alkuperä';

  @override
  String get score_add_missing_product_stores => 'Lisää kaupat';

  @override
  String get score_add_missing_product_brands => 'Add missing product brands';

  @override
  String get score_update_nutrition_facts => 'Päivitä ravintosisältö';

  @override
  String get nutrition_page_title => 'Ravintosisältö';

  @override
  String get nutrition_page_nutritional_info_title => 'Nutritional information';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Values specified on the product:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Kyllä';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Ei';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Open photo';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Good practices: Nutritional information';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Sometimes nutrition facts are **not specified on the packaging** or on a document given with the product. In this case, and only in this case, you can set the value to **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'Nutritional values:';

  @override
  String get nutrition_page_per_100g => '100 grammaa kohti';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100g/ml';

  @override
  String get nutrition_page_per_serving => 'annosta kohti';

  @override
  String get nutrition_page_add_nutrient => 'Lisää ravintoaine';

  @override
  String get nutrition_page_serving_size => 'Annoskoko';

  @override
  String get nutrition_page_serving_size_hint =>
      'Input a serving size (eg: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Good practices: Serving size';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'This value helps to **make a proportional calculation of each nutrient per serving size**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Allowed units** are: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** or **60 G** (prefer the first one)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** or **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Invalid unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Invalid units';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **candies** and 2 **biscuits**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Missing unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Virheellinen numero';

  @override
  String get nutrition_page_update_running =>
      'Päivitetään tuotteita palvelimella…';

  @override
  String get nutrition_page_update_done => 'Tuote päivitetty!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Käytä tuotteen määrää annoskokona';

  @override
  String get nutrition_page_photo_error => 'Unable to load the photo';

  @override
  String get more_photos => 'Lisää kuvia';

  @override
  String get view_more_photo_button =>
      'Näytä kaikki tämän tuotteen olemassa olevat kuvat';

  @override
  String get no_product_found => 'Tuotetta ei löytynyt';

  @override
  String get no_location_found => 'Sijaintia ei löytynyt';

  @override
  String get not_found => 'ei löytynyt:';

  @override
  String get refreshing_product => 'Päivitetään tuotetta';

  @override
  String get product_refreshed => 'Tuote päivitetty';

  @override
  String product_image_accessibility_label(String date) {
    return 'Kuva otettu $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Kuva otettu $date. Tämä kuva saattaa olla vanhentunut';
  }

  @override
  String get product_image_outdated => 'Tämä kuva saattaa olla vanhentunut';

  @override
  String get product_image_outdated_explanations_title =>
      'Tämä kuva saattaa olla vanhentunut';

  @override
  String get product_image_outdated_explanations_content =>
      'This image was taken more than a year ago.\n**Please check that\'s it\'s still up-to-date**.\n\nThis is **just a warning**. If the content is still the same, you can ignore this message.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Korvaa kuva ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Lisää kuva ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Ota uusi';

  @override
  String get product_image_action_take_picture => 'Ota kuva';

  @override
  String get product_image_action_from_gallery =>
      'Valitse puhelimen galleriasta';

  @override
  String get product_image_action_choose_existing_photo =>
      'Valitse tuotekuvista';

  @override
  String get product_image_details_label => 'Information about the photo';

  @override
  String get product_image_details_from_producer => 'From the producer';

  @override
  String get product_image_details_contributor => 'Osallistuja';

  @override
  String get product_image_details_contributor_producer =>
      'Contributor (producer)';

  @override
  String get product_image_details_date => 'Päivämäärä';

  @override
  String get product_image_details_date_unknown => 'Tuntematon';

  @override
  String get homepage_main_card_logo_description =>
      'Tervetuloa Open Food Factsiin';

  @override
  String get homepage_main_card_subheading =>
      '**Skannaa** viivakoodi tai\n**hae** tuotetta';

  @override
  String get homepage_main_card_search_field_hint => 'Etsi tuote';

  @override
  String get homepage_main_card_search_field_tooltip => 'Aloita haku';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Viimeisimmät uutiset: $news_title';
  }

  @override
  String get tagline_app_review => 'Pidätkö sovelluksesta?';

  @override
  String get tagline_app_review_button_positive => 'Rakastan sitä! 😍';

  @override
  String get tagline_app_review_button_negative => 'En juurikaan…';

  @override
  String get tagline_app_review_button_later => 'Kysy myöhemmin';

  @override
  String get tagline_feed_news_button => 'Lisätietoja';

  @override
  String get app_review_negative_modal_title => 'Etkö pidä sovelluksestamme?';

  @override
  String get app_review_negative_modal_text =>
      'Voisitko käyttää muutaman sekunnin kertoaksesi meille miksi?';

  @override
  String get app_review_negative_modal_positive_button =>
      'Kyllä, ehdottomasti!';

  @override
  String get app_review_negative_modal_negative_button => 'Ei';

  @override
  String get could_not_refresh => 'Tuotteen päivitys epäonnistui';

  @override
  String get product_internet_error_modal_title => 'Tapahtui virhe!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Emme voi noutaa tietoja tästä tuotteesta verkkovirheen vuoksi. Tarkista internet-yhteytesi ja yritä uudelleen.\n\nSisäinen virhe:\n$error';
  }

  @override
  String get product_tags_title => 'Tuotteen ominaisuudet';

  @override
  String get no_product_tags_found_message =>
      'Tuotteen ominaisuuksia ei löytynyt. Ominaisuuksien avulla voidaan kuvata tuotteita tarkemmin, joustavasti. Lisää napauttamalla.';

  @override
  String get product_tags_empty => 'Ei ominaisuuksia';

  @override
  String get product_tags_explanation =>
      'Lisäämällä tuotteeseen ominaisuuksia (avain/arvo) autat rikastamaan sitä.';

  @override
  String get add_tag => 'Lisää omaisuus';

  @override
  String get add_tags => 'Add properties';

  @override
  String get add_edit_tags => 'Add or edit properties';

  @override
  String get edit_tag => 'Muokkaa ominaisuutta';

  @override
  String get remove_tag => 'Poista ominaisuus';

  @override
  String get tag_key => 'Ominaisuus';

  @override
  String get tag_keys => 'Ominaisuudet';

  @override
  String get tag_key_uneditable => 'Property (uneditable)';

  @override
  String get tag_key_input_hint => 'Input a property';

  @override
  String get tag_value => 'Arvo';

  @override
  String get tag_values => 'Arvot';

  @override
  String get tag_value_input_hint => 'Input a value';

  @override
  String get tag_key_item => 'Property:';

  @override
  String get tag_value_item => 'Value:';

  @override
  String get tag_key_explanations =>
      'A key must be lowercase and without any spaces.';

  @override
  String tag_key_already_exists(String property) {
    return 'A tag with a property $property already exists!';
  }

  @override
  String get product_internet_error =>
      'Tietojen lataus epäonnistui verkkovirheen vuoksi.';

  @override
  String get cached_results_from => 'Näytä tulokset ajalta:';

  @override
  String get product_search_same_category => 'Etsi vaihtoehtoja';

  @override
  String get product_search_same_category_short => 'Vertaile';

  @override
  String get product_search_same_category_error =>
      'Tätä ominaisuutta voi käyttää vain tuotteissa, joilla on luokka.\n\nLisää luokka muokkaamalla tuotetta.';

  @override
  String get product_improvement_add_category =>
      'Lisää kategoria laskeaksesi Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Lisää ravitsemustietoja Nutri-Scoren laskemiseksi.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Lisää ravintosisältö ja kategoria Nutri-Scoren laskemiseksi.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-pisteytystä ei voi laskea. Syynä voi olla esimerkiksi epätavallinen luokka. Ota yhteyttä, mikäli oletat tämän olevan virhe.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Ravintokuva on vanhentunut, päivitä.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Green-Scoren laskelmassa otetaan huomioon ainesosien alkuperät. Ota kuva ainesosaluettelosta tai mistä vain maantieteellisestä alkuperästä kertovasta väittämästä, tai muokkaa tuotetta, jotta ainesosien alkuperä voidaan ottaa huomioon laskelmassa.';

  @override
  String get country_chooser_label => 'Valitse maa';

  @override
  String get currency_chooser_label => 'Valitse valuutta';

  @override
  String get country_change_message => 'Olet juuri vaihtanut maata.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Haluatko vaihtaa valuutan $previousCurrency arvoon $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Valitse maa:';

  @override
  String get country_chooser_label_from_settings => 'Maasi';

  @override
  String get country_selection_explanation =>
      'Jotkin ympäristövaikutukset ovat paikkakohtaisia';

  @override
  String get product_removed_comparison => 'Tuote poistettu vertailusta';

  @override
  String get native_app_settings => 'Sovellusasetukset';

  @override
  String get native_app_description => 'Avaa Open Food Factsin asetukset';

  @override
  String get product_removed_history => 'Tuote poistettu historiasta';

  @override
  String get product_removed_list => 'Tuote poistettu listalta';

  @override
  String get product_could_not_remove => 'Tuotetta ei voi poistaa';

  @override
  String get no_prodcut_in_list => 'Listassa ei ole tuotteita';

  @override
  String get no_product_in_section => 'Tässä osiossa ei ole tuotteita';

  @override
  String get recently_seen_products => 'Kaikki katsotut tuotteet';

  @override
  String get clear => 'Tyhjennä';

  @override
  String get clear_long => 'Tyhjennä lista';

  @override
  String get really_clear => 'Haluatko poistaa tämän listan?';

  @override
  String pct_match(Object percent) {
    return '$percent % vastaavuus';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count päivää sitten',
      one: 'päivä sitten',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuntia sitten',
      one: 'tunti sitten',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minuuttia sitten',
      one: 'minuutti sitten',
      zero: 'alle minuutti sitten',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kuukautta sitten',
      one: 'kuukausi sitten',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count viikkoa sitten',
      one: 'viikko sitten',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Vertaile $count tuotetta',
      one: 'Vertaile yhtä tuotetta',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuotetta valittu',
      one: 'Yksi tuote valittu',
      zero: 'Ei valittuja tuotteita',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Vertaile valittuja tuotteita';

  @override
  String get delete_products_mode => 'Poista valitut tuotteet';

  @override
  String get select_all_products_mode => 'Valitse kaikki tuotteet';

  @override
  String get select_none_products_mode => 'Tyhjennä valinta';

  @override
  String get compare_products_appbar_title => 'Vertaile tuotteita';

  @override
  String get compare_products_appbar_subtitle =>
      'Valitse vähintään kaksi tuotetta';

  @override
  String get retry_button_label => 'Yritä uudelleen';

  @override
  String get connect_with_us => 'Ota yhteyttä';

  @override
  String get tiktok => 'Follow us on TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Seuraa meitä Instagramissa';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Seuraa meitä X:ssä (entinen Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Follow us on Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Follow us on BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blogi';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Tutustu';

  @override
  String get how_to_contribute => 'Miten voit auttaa';

  @override
  String get hint_knowledge_panel_message =>
      'Voit painaa mistä kohti kortta tahansa saadaksesi lisätietoja kohteesta. Kokeile!';

  @override
  String get permissions_page_title => 'Kameran käyttöoikeus';

  @override
  String get permissions_page_body1 =>
      'Myönnä sovellukselle kameran käyttöoikeus, jotta se voi lukea viivakoodeja.';

  @override
  String get permissions_page_body2 =>
      'Voit muuttaa tätä koska tahansa asetuksissa.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Käyttöjärjestelmä: Android (SDK Int: $sdkInt / Julkaisu: $release)\nMalli: $model\nTuote: $product\nLaite: $device\nTuotemerkki:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Käyttöjärjestelmä: iOS ($version)\nMalli: $model\nLokalisoitu malli: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nSovelluksen versio:$appVersion\nSovelluksen koontiversion numero:$appBuildNumber\nSovelluspaketin nimi:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Valtuuta';

  @override
  String get refuse_button_label => 'Hylkää';

  @override
  String get ask_me_later_button_label => 'Myöhemmin';

  @override
  String get are_you_sure => 'Oletko varma?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Eteenpäin $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Tervetuloa !';

  @override
  String get onboarding_home_welcome_text2 =>
      'Sovellus, joka auttaa sinua valitsemaan ruokaa, joka sopii **sinulle** ja **planeetalle**!';

  @override
  String get onboarding_continue_button => 'Jatka';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Ladataan ensimmäistä esimerkkituotettasi';

  @override
  String get onboarding_welcome_warning =>
      'Anteeksi, tämä on esimerkkituotteemme, etkä voi muokata sitä :)';

  @override
  String get product_list_your_ranking => 'Sijoituksesi';

  @override
  String get product_list_empty_icon_desc => 'Ei historiaa saatavilla';

  @override
  String get product_list_empty_title => 'Aloita skannaaminen';

  @override
  String get product_list_empty_message =>
      'Skannatut tuotteet ilmestyvät tänne ja voit katsoa niistä lisätietoja täällä';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'tuotteita',
      one: 'tuotetta',
      zero: 'tuotetta',
    );
    return 'Päivitetään $_temp0 historiassasi';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tuotteiden',
      one: 'Tuotteen',
      zero: 'Tuotteen',
    );
    return '$_temp0 päivitys onnistui';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Ladataan tietoja';

  @override
  String get loading_dialog_default_error_message => 'Ei voitu ladata tietoja';

  @override
  String get account_delete => 'Poista tunnus';

  @override
  String get account_delete_title => 'Poista tilini';

  @override
  String get user_profile => 'Tili';

  @override
  String get user_profile_title_guest => 'Tervetuloa!';

  @override
  String get user_profile_subtitle_guest =>
      'Kirjaudu sisään tai rekisteröidy liittyäksesi Open Food Facts -yhteisöön';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts -kirjautuminen: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Tervetuloa $id!';
  }

  @override
  String get email_subject_account_deletion => 'Poista tunnus';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hei, poista Open Food Facts -tilini: $userId';
  }

  @override
  String get settings_app_app => 'Sovellus';

  @override
  String get settings_app_data => 'Yksityisyys ja valvonta';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Tuotteet';

  @override
  String get settings_app_miscellaneous => 'Sekalaiset';

  @override
  String get camera_play_sound_title => 'Toista äänimerkki luettaessa';

  @override
  String get camera_play_sound_subtitle =>
      'Päästää äänimerkin joka skannauksen yhteydessä';

  @override
  String get camera_window_accessibility_label =>
      'Skannaa viivakoodi kamerallasi';

  @override
  String get app_haptic_feedback_title => 'Värinä ja haptiikka';

  @override
  String get app_haptic_feedback_subtitle =>
      'Värinä tapahtuu, kun joitakin toimintoja suoritetaan (kuten viivakoodinluku, tuotteenpoisto, jne.).';

  @override
  String get crash_reporting_toggle_title => 'Kaatumisraportointi';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Kun tämä on käytössä, virheraportit lähetetään automaattisesti Open Food Factsin virheenseurantajärjestelmään, jotta vikoja voidaan korjata ja siten parantaa sovellusta.';

  @override
  String get send_anonymous_data_toggle_title => 'Lähetä nimettömiä tietoja';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Kun tämä on käytössä, Open Food Facts -palvelimille lähetetään anonyymejä tietoja sovellusten käytöstä, jotta voimme ymmärtää, kuinka ja kuinka paljon ominaisuuksia käytetään niiden parantamiseksi.';

  @override
  String get product_edit_photo_title => 'Muokkaa kuvaa';

  @override
  String get permission_photo_error => 'Virhe';

  @override
  String get permission_photo_denied_title =>
      'Salli kameran käyttö, jotta viivakoodeja voidaan lukea';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Salli $appName:n käyttää kameraa paremman kokemuksen saamiseksi. Pystyt sen avulla lukemaan viivakoodeja.';
  }

  @override
  String get permission_photo_denied_button => 'Salli';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Lupa evätty';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Koska hylkäsit anomuksen kameran käyttöön, anna lupa manuaalisesti asetuksista.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Avaa asetukset';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Peruuta';

  @override
  String get permission_photo_none_found => 'Ei kameraa löydetty';

  @override
  String get permission_photo_denied => 'Ei lupaa käyttää kameraa';

  @override
  String get show_product_pictures => 'Show product pictures';

  @override
  String get edit_product_label => 'Muokkaa tuotetta';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Uploading your edits…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Your edits are being **sent in the background** (or later in case of error).\nYou can continue editing other product fields.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Your edits are being **sent in the background** (or later in case of error).';

  @override
  String get edit_product_label_short => 'Muokkaa';

  @override
  String edit_product_form_item_help(String value) {
    return 'How to enter \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Please enter a non-empty value!';

  @override
  String get edit_product_form_item_error_existing =>
      'This value is already there!';

  @override
  String get edit_product_form_item_add_action_brand => 'Add a new brand';

  @override
  String get edit_product_form_item_add_action_label => 'Add a new label';

  @override
  String get edit_product_form_item_add_action_store => 'Add a new store';

  @override
  String get edit_product_form_item_add_action_origin => 'Add a new origin';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Add a new traceability code';

  @override
  String get edit_product_form_item_add_action_country => 'Add a new country';

  @override
  String get edit_product_form_item_add_action_category => 'Add a new category';

  @override
  String get edit_product_form_item_add_action_trace => 'Add a new trace';

  @override
  String get edit_product_form_item_add_suggestion => 'Add suggestion';

  @override
  String get edit_product_form_item_deny_suggestion => 'Hylkää ehdotus';

  @override
  String get edit_product_form_item_details_title => 'Perustiedot';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Tuotteen nimi, merkki ja määrä';

  @override
  String get edit_product_form_item_other_details_title => 'Lisätietoja';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Nettisivusto…';

  @override
  String get edit_product_form_item_photos_title => 'Kuvat';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Lisää tai päivitä kuvia';

  @override
  String get edit_product_form_item_labels_title => 'Merkit ja sertifikaatit';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Ympäristöystävällisyys, laatumerkit…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Input a label (eg: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'merkki';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Good practices: Labels';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Any characteristic of the product **which is factual** and different from the other fields.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Made in Belgium, produced in Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rich in fiber, source of iron…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Myymälät';

  @override
  String get edit_product_form_item_stores_hint => 'Input a store';

  @override
  String get edit_product_form_item_stores_type => 'myymälä';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Good practices: Stores';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Input the store where you bought the product.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Alkuperät';

  @override
  String get edit_product_form_item_origins_hint =>
      'Input an origin (eg: Germany)';

  @override
  String get edit_product_form_item_origins_type => 'maa';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Good practices: Origins';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Add **any indications of origins you can find on the packaging**.\nYou need not worry about origins indicated directly in the ingredient list.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Beef from Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'The soy does not come from the European Union';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Input a country (eg: Germany)';

  @override
  String get edit_product_form_item_countries_type => 'maa';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Good practices: Countries';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Countries where the product is widely available** (not including stores specialising in foreign products).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Jäljitettävyyskoodit';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Input a code (eg: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'jäljitettävyyskoodi';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Good practices: Traceability codes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In this section, you can input codes related to **packaging marks**, **identification marks** or **health marks**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Examples of traceability codes';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC codes** used in the European Community to identify food producers or packagers:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: country code of **France**\n**72.264.002**: geographic data\n**CE**: European Community';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB codes** used in France:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Jäämät';

  @override
  String get edit_product_form_item_traces_hint => 'jäämä';

  @override
  String get edit_product_form_item_traces_type =>
      'Input a trace (eg: Soy beans)';

  @override
  String get edit_product_form_item_categories_title => 'Tuoteluokat';

  @override
  String get edit_product_form_item_categories_hint => 'tuoteluokka';

  @override
  String get edit_product_form_item_categories_type =>
      'Input a category (eg: Orange juice)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Good practices: Categories';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicate **only the most specific category**.\nParent categories will be automatically added.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Missing category?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'In case a category is **not available in autocomplete**, feel free to add it anyway.\nThis will help us improve Open Food Facts in your country.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardines in olive oil';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Orange juice from concentrate';

  @override
  String get edit_product_form_item_exit_title => 'Quit without saving?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Haluatko tallenta muutokset ennen poistumista?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Tallenna muutokset';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Hylkää muutokset';

  @override
  String get edit_product_form_item_ingredients_title => 'Ainesosat';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zoom in and out by pinching the screen';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zoom in and out the photo';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Using the **Pinch-to-zoom gesture**, you can zoom in or out the photo:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Lisää';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Syötä ensin teksti';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Poista';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => 'Save your edit';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancel your edit';

  @override
  String get edit_product_form_item_packaging_title => 'Kierrätysohjekuva';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Ravintosisältö';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Ravintosisältö, alkoholipitoisuus, jne.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Good practices: Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nutritional values';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'First, select if the **values are provided**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Ravintosisältö';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Then, input the nutritional values **as indicated on the packaging**. If there is no value, you can click on the \"Eye\" icon.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Missing field?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'If an entry is missing, you can **click on the \"Plus\" icon** to add it (eg: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'Muokkaa';

  @override
  String get edit_product_ingredients_photo_title => 'Ainesosakuva';

  @override
  String get edit_product_ingredients_list_title => 'Ainesosaluettelo';

  @override
  String get edit_product_packaging_photo_title => 'Packaging photo';

  @override
  String get edit_product_packaging_list_title => 'Packaging list';

  @override
  String get no_data_available => 'Tietoja ei ole saatavilla';

  @override
  String get product_field_website_title => 'Nettisivusto';

  @override
  String get origins_editing_title => 'Edit Origins';

  @override
  String get completed_basic_details_btn_text => 'Täytä perustiedot';

  @override
  String get not_implemented_snackbar_text => 'Ei vielä käytössä';

  @override
  String get category_picker_page_appbar_text => 'Tuoteluokat';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Poimi ainesosat valokuvasta';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Poimi ainesosat';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Poimitaan ainesosia\nkuvasta';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Ladataan kuvaa…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Miksi näen tämän viestin?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Käyttääksesi toimintoa \"Poimi valmistusaineet kuvasta\", valokuva täytyy ensin ladata palveluun.\n\nOdota muutama sekunti tai syötä ne käsin.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Päivitä kuva';

  @override
  String get edit_packaging_extract_btn_text => 'Poimi pakkaus\nvalokuvasta';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extract packaging';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Poimitaan pakkausta kuvasta';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Ladataan kuvaa…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Miksi näen tämän viestin?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Jotta voit käyttää \"Ota pakkaus\" -ominaisuutta, valokuva on ensin ladattava.\n\nOdota muutama sekunti tai kirjoita ne manuaalisesti.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Päivitä kuva';

  @override
  String get edit_ocr_extract_failed => 'Tekstintunnistus epäonnistui.';

  @override
  String get edit_ocr_extract_disabled_title => 'No picture!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'In order to use the text extraction feature, you must first take a photo.';

  @override
  String get user_list_dialog_new_title => 'Uusi tuotelista';

  @override
  String get user_list_dialog_rename_title => 'Uudelleennimeä lista';

  @override
  String get user_list_subtitle_product => 'Listat';

  @override
  String get user_list_title => 'Luettelosi';

  @override
  String get user_list_add_product => 'Lisää tuote listoihisi';

  @override
  String get user_list_button_new => 'Luo uusi luettelo';

  @override
  String get user_list_empty_label =>
      'Luetteloa ei ole vielä saatavilla. Aloita luomalla sellainen';

  @override
  String get user_list_button_add_product => 'Lisää luetteloon';

  @override
  String get added_to_list_msg => 'Lisätty listaan';

  @override
  String get user_list_popup_clear => 'Tyhjennä historiasi';

  @override
  String get user_list_popup_rename => 'Uudelleennimeä';

  @override
  String get user_list_name_hint => 'Listani';

  @override
  String get user_list_name_error_empty => 'Nimi on pakollinen';

  @override
  String get user_list_name_error_already => 'Nimi on jo käytössä';

  @override
  String get user_list_name_error_same => 'Nimeä ei ole muutettu';

  @override
  String get user_list_name_input_hint => 'Luettelon nimi';

  @override
  String get try_again => 'Yritä uudelleen';

  @override
  String get there_was_an_error => 'Tapahtui virhe';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Ei luokkaa $items:lle';
  }

  @override
  String get camera_toggle_camera => 'Vaihda taka- ja etukameran välillä';

  @override
  String get camera_toggle_flash =>
      'Kytke kameran salama päälle tai pois päältä';

  @override
  String get camera_enable_flash => 'Käytä salamaa';

  @override
  String get camera_disable_flash => 'Poista salama käytöstä';

  @override
  String get camera_flash_error_dialog_title => 'Virhe!';

  @override
  String get camera_flash_error_dialog_message =>
      'Virhe vaihtaessa salaman tilaasi. Tarkista, ettei puhelimesi taskulamppu ole päällä.';

  @override
  String get category_picker_no_category_found_button => 'Takaisin';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Napsauta avataksesi selaimessasi tai sovelluksessa (jos asennettu)';

  @override
  String get dev_preferences_screen_title => 'Kehittäjätila';

  @override
  String get dev_preferences_screen_subtitle =>
      'Käytä kokeellisia ominaisuuksia ja kehitystyökaluja';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Käynnistä perehdytys uudelleen';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Uudelleenkäynnistä sovellus nähdäksesi se uudelleen.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Vaihda openfoodfacts.org (PROD):n ja kokeiluympäristön välillä';

  @override
  String get dev_preferences_test_environment_title =>
      'Kokeiluympäristön parametrit';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Kokeiluympäristön nettiosoite: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Kokeiluympäristön isäntä';

  @override
  String get dev_preferences_ml_kit_title => 'Käytä ML-pakettia';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'sitten on sovellus uudelleenkäynnistettävä';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Lisänappula tuotesivulla';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Muokkaa ainesosia tietopaneelin kautta';

  @override
  String get dev_preferences_export_history_title => 'Vientihistoria';

  @override
  String get dev_preferences_export_history_progress_error => 'poikkeama';

  @override
  String get dev_preferences_export_history_progress_found => 'tuote löytyi';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'tuotetta EI löydy';

  @override
  String get dev_preferences_export_history_dialog_title => 'Vientihistoria';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Peruuta';

  @override
  String get dev_preferences_migration_title => 'Tiedon siirto V1:stä';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Tila: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'onnistui tai uusi lataus';

  @override
  String get dev_preferences_migration_status_success => 'onnistui';

  @override
  String get dev_preferences_migration_status_error => 'virhe';

  @override
  String get dev_preferences_migration_status_in_progress => 'käynnissä';

  @override
  String get dev_preferences_migration_status_required =>
      'vaaditaan (aloita napauttamalla)';

  @override
  String get dev_preferences_migration_status_not_started => 'tuntematon';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Poistaa historian ja lisää kolme tuotetta sinne';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Muokattu URL-osoite uutisille';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'JSON-tiedoston URL-osoite:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Ei määritetty';

  @override
  String get dev_preferences_news_provider_status_title => 'Tila';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Viimeisin päivitys: $date';
  }

  @override
  String get product_type_label_food => 'Ruoka';

  @override
  String get product_type_label_beauty => 'Henkilökohtainen hoito';

  @override
  String get product_type_label_pet_food => 'Lemmikin ruoka';

  @override
  String get product_type_label_product => 'Muu';

  @override
  String get product_type_selection_title => 'Tuotetyyppi';

  @override
  String get product_type_selection_subtitle => 'Valitse tuotteen tyyppi';

  @override
  String get product_type_selection_empty =>
      'Tuotteen tyyppi on valittava ensin!';

  @override
  String product_type_selection_already(String productType) {
    return 'Et voi muuttaa tuotetyyppiä ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Pikakuvake Hinnat-sovellukseen tuotesivulla';

  @override
  String get prices_app_button => 'Siirry Hinnat-sovellukseen';

  @override
  String get prices_website_button => 'Avaa Open Prices -verkkosivustolla';

  @override
  String get prices_bulk_proof_upload_select =>
      'Add price tags directly from gallery';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Once you\'ve selected images, you won\'t be able to edit them!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Salli yhteisön vahvistaa tekoälyn laskemat hinnat.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Multiple Price Tags';

  @override
  String get prices_bulk_proof_upload_title => 'Bulk Proof Upload';

  @override
  String get prices_bulk_proof_upload_step_selecting =>
      'Tiedostojen valitseminen';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Latauksen aloittaminen';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Paikallisesti kopioitu tiedosto #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Valmistellaan latausta #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Epäonnistui kuvassa #$index/$count';
  }

  @override
  String get prices_generic_title => 'Hinnat';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Lisää $count hintaa',
      one: 'Lisää hinta',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Lähetä $count hintaa',
      one: 'Lähetä hinta',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Lisää tuote';

  @override
  String get prices_add_a_price => 'Lisää hinta';

  @override
  String get prices_add_a_receipt => 'Lisää kuitti';

  @override
  String get prices_add_price_tags => 'Lisää hintalaput';

  @override
  String prices_barcode_already(String barcode) {
    return 'Viivakoodi ($barcode) on jo luettelossa!';
  }

  @override
  String get prices_barcode_search_not_found => 'Tuotetta ei löytynyt';

  @override
  String get prices_barcode_search_none_yet => 'Ei tuotetta vielä';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Etsitään $barcode';
  }

  @override
  String get prices_barcode_enter => 'Syötä viivakoodi';

  @override
  String get prices_category_enter => 'Tuote ilman viivakoodia';

  @override
  String get prices_per_kilogram => 'Kilohinta';

  @override
  String get prices_per_unit => 'Hinta per yksikkö';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / yksikkö';

  @override
  String get prices_category_mandatory => 'Pakollinen';

  @override
  String get prices_category_optional => 'Valinnainen';

  @override
  String get prices_category_error_mandatory => 'Luokka on pakollinen';

  @override
  String get prices_barcode_reader_action => 'Viivakoodinlukija';

  @override
  String get prices_view_prices => 'Katso hinnat';

  @override
  String get prices_list_title => 'Hinnasto';

  @override
  String get prices_list_count => 'Hintahaarukka\n';

  @override
  String get prices_list_add_new_price => 'Lisää\nuusi hinta';

  @override
  String get prices_list_empty_title => 'Ei vielä hintaa!';

  @override
  String get prices_list_empty_subtitle =>
      'Lisää ensimmäinen:\nSkannaamalla **kuitin** tai **hintalapun**!';

  @override
  String get prices_entry_shop_not_found => 'Tuntematon kauppa';

  @override
  String prices_entry_menu_title(String user) {
    return 'Hintasyöttö alkaen \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Näytä kaikki tämän tuotteen hinnat';

  @override
  String get prices_entry_menu_open_proof => 'Näytä todiste';

  @override
  String get prices_entry_menu_my_prices => 'Katso muut hintani';

  @override
  String get prices_entry_menu_author_prices => 'Katso tekijän muut hinnat';

  @override
  String get prices_entry_menu_shop_prices => 'Katso muut hinnat kaupasta';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hintaa',
      one: '1 hinta',
    );
    return '$_temp0 tuotteelle $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Kaikki $count hintaa',
      one: 'Vain yksi hinta',
      zero: 'Ei hintaa vielä',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Viimeisimmät $pageSize hinnat (yhteensä: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Hinta: $price / Kauppa: \"$location\" / tekijän \"$user\" päivämääränä $date julkaisema';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Avaa käyttäjän \"$user\" todisteet';
  }

  @override
  String get prices_open_proof => 'Avaa hintatodiste';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Kaikki $count todistetta',
      one: 'Vain yksi todiste',
      zero: 'Ei vielä todisteita',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Viimeisimmät $pageSize todisteet (yhteensä: $total)';
  }

  @override
  String get prices_users_empty_title => 'Ei vielä osallistujaa!';

  @override
  String get prices_users_empty_explanation =>
      'Ole ensimmäinen, joka lisää hinnan!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Parhaat $pageSize avustajat (yhteensä: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Ei vielä kauppaa!';

  @override
  String get prices_locations_empty_explanation =>
      'Ole ensimmäinen, joka lisää hinnan!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Näytetään $pageSize kohdetta (yhteensä: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count todistetta',
      one: 'Yksi todiste',
      zero: 'Ei todisteita',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuotetta',
      one: 'Yksi tuote',
      zero: 'Ei tuotteita',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count käyttäjää',
      one: 'Yksi käyttäjä',
      zero: 'Ei käyttäjiä',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hintaa',
      one: 'Yksi hinta',
      zero: 'Ei hintoja',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Hinta lisätty aiemmin';

  @override
  String get prices_amount_subtitle => 'Määrä';

  @override
  String get prices_amount_is_discounted => 'Onko alennettu?';

  @override
  String get prices_amount_price_normal => 'Hinta';

  @override
  String get prices_amount_price_discounted => 'Alennettu hinta';

  @override
  String get prices_amount_price_not_discounted => 'Alkuperäinen hinta';

  @override
  String get prices_amount_no_product => 'Yksi tuote puuttuu!';

  @override
  String get prices_amount_price_incorrect => 'Virheellinen arvo';

  @override
  String get prices_amount_price_mandatory => 'Pakollinen arvo';

  @override
  String get prices_currency_subtitle => 'Valuutta';

  @override
  String get prices_date_subtitle => 'Päivämäärä';

  @override
  String get prices_location_subtitle => 'Myymälä';

  @override
  String get prices_location_find => 'Etsi kauppa';

  @override
  String get prices_location_mandatory => 'Sinun on valittava kauppa!';

  @override
  String get prices_location_search_broader =>
      'Etkö löytänyt etsimääsi? Kokeillaan laajempaa hakua!';

  @override
  String get prices_proof_subtitle => 'Todiste';

  @override
  String get prices_proof_empty_title => 'Ei vielä todisteita!';

  @override
  String get prices_proof_empty_explanation =>
      'Aloita lisäämällä kuva **kuitista** tai **hintalapusta**!';

  @override
  String get prices_proof_find => 'Valitse todiste';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Kuitti';

  @override
  String get prices_proof_price_tag => 'Hintalappu';

  @override
  String get prices_proof_mandatory => 'Sinun on valittava todiste!';

  @override
  String get prices_add_validation_error => 'Tarkistusvirhe';

  @override
  String get prices_privacy_warning_title => 'Tietosuojavaroitus';

  @override
  String get prices_unknown_product => 'Tuntematon tuote';

  @override
  String get prices_privacy_warning_main_message =>
      'Prices **will be public**, along with the store they refer to.\n\nThat might allow people who know about your Open Food Facts pseudonym to:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Infer in which area you live';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Know what you are buying';

  @override
  String get prices_privacy_warning_sub_message =>
      'If you are uneasy with that, please change your pseudonym, or create a new Open Food Facts account and log into the app with it.';

  @override
  String get i_refuse => 'I refuse';

  @override
  String get i_accept => 'I accept';

  @override
  String get prices_currency_change_proposal_title => 'Change the currency?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Your current currency is **$currency**. Would you like to change it to **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Yes, use $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'No, keep $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Valmis';

  @override
  String get dev_mode_section_server => 'Palvelimen asetukset';

  @override
  String get dev_mode_section_news => 'Uutispalveluntarjoajan määritykset';

  @override
  String get dev_mode_section_product_page => 'Tuotesivu';

  @override
  String get dev_mode_section_ui => 'Käyttöliittymä';

  @override
  String get dev_mode_section_experimental_features =>
      'Kokeelliset ominaisuudet';

  @override
  String get dev_mode_hide_environmental_score_title => 'Piilota Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Käytä OCR-näytöissä oikeinkirjoituksen tarkistusta';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(Ainesosat ja pakkaus)';

  @override
  String get dev_mode_reset_app_language_title => 'Palauta sovelluksen kieli';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Lisää kortteja';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Vaihda prices.openfoodfacts.org (PROD) -sivuston ja testiympäristön välillä';

  @override
  String get search_history_item_edit_tooltip =>
      'Käytä ja muokkaa tätä hakua uudelleen';

  @override
  String get search_history_item_remove_tooltip => 'Poista';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Olet ladannut kaikki $totalSize tuotetta.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Lataa $count tuotetta lisää\nLadattu $downloaded tuotetta $totalSize tuotteesta.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Hakusi $search on käynnissä.\n\nOdota muutama sekunti…';
  }

  @override
  String get user_search_contributor_title => 'Tuotteita lisätty';

  @override
  String get user_search_informer_title => 'Tuotteita muokattu';

  @override
  String get user_search_photographer_title => 'Tuotteita kuvattu';

  @override
  String get user_search_to_be_completed_title => 'Tehtävälistan tuotteet';

  @override
  String get user_search_prices_title => 'Minun hinnat';

  @override
  String get user_search_proofs_title => 'Minun todisteeni';

  @override
  String get user_search_proof_title => 'Minun todisteeni';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Avustajien hinnat: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Viimeisimmät hinnat lisätty';

  @override
  String get all_search_prices_top_user_title => 'Hintojen huippuavustajat';

  @override
  String get all_search_prices_top_location_title =>
      'Kaupat, joilla on eniten hintoja';

  @override
  String get prices_contribution_assistant => 'Price Contribution Assistant';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Add Multiple Proofs';

  @override
  String get all_search_prices_top_location_single_title => 'Myymälähinnat';

  @override
  String get all_search_prices_top_product_title =>
      'Tuotteet, joilla on eniten hintoja';

  @override
  String get all_search_to_be_completed_title =>
      'Kaikki tehtävälistan tuotteet';

  @override
  String get categorize_products_country_title =>
      'Auta luokittelemaan tuotteet maassasi';

  @override
  String get edit_product_action_retake_picture => 'Ota kuva uudelleen';

  @override
  String get edit_product_action_take_picture => 'Ota kuva';

  @override
  String get edit_product_action_confirm => 'Vahvista';

  @override
  String get signup_page_terms_of_use_line1 => 'Hyväksyn Open Food Factsin';

  @override
  String get signup_page_terms_of_use_line2 => 'käyttö- ja osallistumisehdot';

  @override
  String get analytics_consent_image_semantic_label => 'Tilastokuva';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Paha vika: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Paha vika: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Täytä perustiedot';

  @override
  String get edit_photo_button_label => 'Muokkaa';

  @override
  String get edit_photo_unselect_button_label => 'Jätä kuva valitsematta';

  @override
  String get edit_photo_select_existing_button_label => 'Valitse kuva';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Valitse kuva napauttamalla sitä';

  @override
  String get edit_photo_select_existing_download_label =>
      'Etsitään olemassaolevia kuvia…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Tähän tuotteeseen liittyviä kuvia ei löydy.';

  @override
  String get edit_photo_language_not_this_one => 'Ei kuvaa kyseisellä kielellä';

  @override
  String get edit_photo_language_none => 'Ei kuvaa';

  @override
  String get category_picker_screen_title => 'Tuoteluokat';

  @override
  String get basic_details => 'Perustiedot';

  @override
  String get product_name => 'Tuotteen nimi';

  @override
  String get product_names => 'Product Names';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Add a new translation';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Before validating, please ensure you only add a translation **if the language is present on the packaging**';

  @override
  String get add_basic_details_product_name_open_photo => 'View front photo';

  @override
  String get add_basic_details_product_name_take_photo => 'Take front photo';

  @override
  String get add_basic_details_product_name_hint =>
      'Input the name of the product (eg: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Vaihdetaanko oletuskieli?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Haluatko tuotteen oletuskieleksi asetettavan \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Good examples';

  @override
  String get explanation_section_bad_examples => 'Bad examples';

  @override
  String get add_basic_details_product_name_help_title =>
      'Good practices: Product name';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'The product name is the **main name printed on the packaging**. It can be a registered trademark.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Note:** Please don\'t add a translation **if the language is not present on the packaging**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomato Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Don\'t include the brand in the name';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomato Ketchup **by Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Don\'t use symbols ®, ™, © or similar';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count other translations',
      one: '$count other translation',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Merkki';

  @override
  String get brand_names => 'Brand names';

  @override
  String get add_basic_details_brand_name_error => 'Syötä merkki';

  @override
  String get add_basic_details_brand_names_hint => 'Input brands (eg: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Good practices: Brands';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Input **all the brands of the product**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Main brand';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'The **main brand**, generally clearly displayed on the front pack, should be **entered first**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Other brands';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'When sold **by a big company**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** is sold by **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'When sold with its brand **translated in multiple languages**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** is sometimes written **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Määrä ja paino';

  @override
  String get add_basic_details_quantity_hint =>
      'Input the weight and if needed the quantity (eg : 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Good practices: Quantity';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copy the value indicated on the product and **don\'t forget the units**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** or **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (for 6 eggs)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(for a product with 3 boxes, each of 150g)';

  @override
  String get barcode => 'Viivakoodi';

  @override
  String barcode_barcode(String barcode) {
    return 'Viivakoodi: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Virheellinen viivakoodi';

  @override
  String get basic_details_add_success => 'Perustiedot lisätty onnistuneesti';

  @override
  String get basic_details_add_error =>
      'Perustietojen tallennus epäonnistui, yritä uudelleen myöhemmin';

  @override
  String get clear_search => 'Tyhjennä haku';

  @override
  String get confirm_clear => 'Haluatko varmasti poistaa koko historiasi?';

  @override
  String get alert_clear_selected_user_list =>
      'Olet poistamassa valitut kohteet historiastasi';

  @override
  String get confirm_clear_selected_user_list => 'Haluatko varmasti jatkaa?';

  @override
  String get alert_select_items_to_clear =>
      'Valitse yksi tai useampi poistettava kohde';

  @override
  String confirm_clear_user_list(String name) {
    return 'Haluatko varmasti tyhjentää listan $name?';
  }

  @override
  String get confirm_delete_user_list_title => 'Poistetaanko luettelo?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Olet poistamassa luetteloa \"$name\".\nHaluatko varmasti jatkaa?';
  }

  @override
  String get confirm_delete_user_list_button => 'Kyllä, vahvistan';

  @override
  String importance_label(String name, String id) {
    return '$name:n tärkeys: $id';
  }

  @override
  String get user_list_all_title => 'Listat';

  @override
  String get user_list_all_empty => 'Luo ensimmäinen listasi';

  @override
  String get product_list_select => 'Valitse luettelo';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuotetta',
      one: 'Yksi tuote',
      zero: 'Tyhjä lista',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Lisää lista';

  @override
  String get open_food_preferences_tooltip => 'Muokkaa ruokamieltymyksiäsi';

  @override
  String get add_photo_button_label => 'Lisää kuva';

  @override
  String get add_packaging_photo_button_label =>
      'Ota kuvia kierrätys- tai pakkausselosteesta';

  @override
  String get add_origin_photo_button_label => 'Ota kuvia alkuperätiedoista';

  @override
  String get add_emb_photo_button_label =>
      'Ota kuvia jäljitettävyyskooditiedoista';

  @override
  String get add_label_photo_button_label =>
      'Ota kuvia merkeistä ja sertifiointitiedoista';

  @override
  String get choose_image_source_title => 'Valitse kuvan lähde';

  @override
  String get choose_image_source_body => 'Valitse kuvan lähde';

  @override
  String get gallery_source_label => 'Kuvagalleria';

  @override
  String get gallery_source_access_denied_dialog_title => 'Pääsy evätty';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Valitettavasti sovellus ei pääse galleriaasi, koska olet aiemmin evännyt luvan.\n\nSiirry puhelimen sovelluksen asetuksiin kohdassa Asetukset -> Kuvat';

  @override
  String get gallery_source_access_denied_dialog_button => 'Avaa Asetukset';

  @override
  String get share => 'Jaa';

  @override
  String share_product_text(String url) {
    return 'Katso tämä tuote Open Food Facts -sivustolla: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Katso tämä tuote Open Beauty Factsissa: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Katso tämä tuote Open PetFood Factsissa: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Katso tämä tuote Open Products Factsissa: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Katso Open Food Facts -sivustolla oleva tuoteluetteloni: $url';
  }

  @override
  String get capture => 'Ota uusi';

  @override
  String get capture_new_picture => 'Ota kuva';

  @override
  String get choose_from_gallery => 'Valitse kuvagalleriasta';

  @override
  String get image_upload_queued =>
      'Kuva lähetetään taustalla mahdollisimman pian.';

  @override
  String get add_price_queued =>
      'Hinta lähetetään palvelimelle mahdollisimman pian.';

  @override
  String get background_task_title_full_refresh =>
      'Aloitetaan kaikkien paikallisesti tallennettujen tuotteiden päivitys';

  @override
  String get background_task_title_top_n =>
      'Aloitetaan suosituimpien tuotteiden lataus';

  @override
  String get expand_nutrition_facts => 'Laajenna ravintosisältötaulukkoa';

  @override
  String get expand_nutrition_facts_body =>
      'Pidä ravintosisältötaulukko laajennettuna';

  @override
  String get expand_ingredients => 'Laajenna ainesosat';

  @override
  String get expand_ingredients_body => 'Pidä ainesosat laajennettuna';

  @override
  String get no_internet_connection => 'Ei Internet-yhteyttä';

  @override
  String get world_results_label => 'Koko maailma';

  @override
  String get world_results_action => 'Laajenna hakuasi maailmalle';

  @override
  String get copy_to_clipboard => 'Kopioi';

  @override
  String get paste_from_clipboard => 'Liitä leikepöydältä';

  @override
  String get no_data_available_in_clipboard => 'Leikepöydälläsi ei ole tietoja';

  @override
  String get clipboard_barcode_copy => 'Kopioi viivakoodi leikepöydälle';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Viivakoodi $barcode kopioitu leikepöydälle!';
  }

  @override
  String get open_product_website => 'Open this product on the website';

  @override
  String get language_picker_label => 'Sinun kielesi';

  @override
  String get country_picker_label => 'Maasi';

  @override
  String get currency_picker_label => 'Your currency';

  @override
  String get help_with_openfoodfacts => 'Neuvoja OpenFoodFactsiin';

  @override
  String get product_task_background_schedule =>
      'Tuote päivitetään taustalla mahdollisimman pian.';

  @override
  String get no_email_client_available_dialog_title =>
      'Ei sähköpostisovelluksia asennettuna!';

  @override
  String get no_email_client_available_dialog_content =>
      'Lähetä meille sähköpostiviesti manuaalisesti osoitteeseen mobile@openfoodfacts.org';

  @override
  String get all_images => 'Kaikki kuvat';

  @override
  String get selected_images => 'Valitut kuvat';

  @override
  String get product_card_remove_product_tooltip => 'Poista tuote';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Uusi viivakoodi skannattu: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Poista kaikki tuotteet karusellista';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Skannaa vähintään kaksi tuotetta vertaillaksesi niitä';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Napsauta vertaillaksesi skannaamiasi tuotteita';

  @override
  String get scan_product_loading => 'Olet skannannut\nviivakoodin:';

  @override
  String get scan_product_loading_initial =>
      'Etsimme tätä tuotetta!\nOdota muutama sekunti…';

  @override
  String get scan_product_loading_long_request =>
      'Etsimme edelleen tätä tuotetta!\nKestääkö lataaminen mielestäsi kauan? Niin mekin…';

  @override
  String get scan_product_loading_unresponsive =>
      'Etsimme edelleen tätä tuotetta.\nHaluatko aloittaa haun uudelleen?';

  @override
  String get scan_product_loading_restart_button => 'Käynnistä haku uudelleen';

  @override
  String get portion_calculator_description =>
      'Laske ravitsemustiedot tietylle määrälle';

  @override
  String get portion_calculator_hint => 'Määrä';

  @override
  String get portion_calculator_accessibility =>
      'Syötä määrä laskeaksesi ravitsemustiedot';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Anna määrä väliltä $min ja $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Missing data. Calculation could not be performed.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Ravintosisältö ($grams g/ml)';
  }

  @override
  String get offline_data => 'Tiedot ilman Internet-yhteyttä';

  @override
  String get ocr_image_upload_instruction =>
      'Lataa kuva, jotta voit poimia sen sisältämät tiedot.';

  @override
  String get upload_image => 'Lataa kuva';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Kuvaa ei voitu ladata';

  @override
  String get image_edit_url_error =>
      'Kuvan muokkaus epäonnistui, koska kuvalla ei ole internetosoitetta.';

  @override
  String get user_picture_source_remember => 'Muista valintani';

  @override
  String get user_picture_source_ask => 'Kysy aina';

  @override
  String get robotoff_continue => 'Jatka';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Seuraavat $count kysymystä',
      one: 'Seuraava kysymys',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'Näytä salasana';

  @override
  String get owner_field_info_title => 'Tuottajan toimittamat arvot';

  @override
  String get owner_field_info_message =>
      'Logolla korostamme tuottajan toimittamia tietoja, joita ei välttämättä voi muokata.';

  @override
  String get owner_field_info_close_button => 'Sulje tiedot';

  @override
  String get owner_field_image =>
      'Tämä on tuottajan toimittama kuva. Sitä ei ehkä voi muokata.';

  @override
  String get edit_packagings_title => 'Pakkauskomponentit';

  @override
  String get edit_packagings_element_add => 'Lisää pakkauskomponentti';

  @override
  String get edit_packagings_completed => 'Pakattu';

  @override
  String edit_packagings_element_title(int index) {
    return 'Pakkauskomponentti #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Yksiköiden määrä';

  @override
  String get edit_packagings_element_hint_units =>
      'Syötä samanmuotoisten ja samaa materiaalia olevien pakkausten määrä tuotteessa.';

  @override
  String get edit_packagings_element_field_shape => 'Muoto';

  @override
  String get edit_packagings_element_hint_shape =>
      'Syötä kierrätysohjeiden mukainen muodon nimi tai valitse muoto.';

  @override
  String get edit_packagings_element_example_shape => 'Pullo';

  @override
  String get edit_packagings_element_field_material => 'Materiaali';

  @override
  String get edit_packagings_element_hint_material =>
      'Lisää materiaali, jos se voidaan määrittää (pakkauksessa materiaalikoodi kolmiossa) tai yleismateriaali (kuten muovi tai lasi), jos olet epävarma.';

  @override
  String get edit_packagings_element_example_material => 'Lasi';

  @override
  String get edit_packagings_element_field_recycling => 'Kierrätysohje';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Lisää kierrätysohje, jos se lukee paketissa.';

  @override
  String get edit_packagings_element_example_recycling => 'Kierrätä';

  @override
  String get edit_packagings_element_field_quantity => 'Nettomäärä per tuote';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Syötä nettopaino tai -tilavuus, muista suure (kuten g tai ml).';

  @override
  String get edit_packagings_element_field_weight => 'Tyhjän yksikön paino (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Poista kaikki ruoka ja pese ja kuivaa pakkaus ennen punnitsemista. Mahdollisuuksien mukaan käytä vaakaa, jonka tarkkuus on 0,1 g tai 0,01 g.';

  @override
  String get background_task_title => 'Odottavat panostukset';

  @override
  String get background_task_subtitle =>
      'Lisäyksesi lisätään palvelimelle, mutta ei aina heti.';

  @override
  String get background_task_list_empty => 'Ei tehtäviä';

  @override
  String get background_task_error_server_time_out => 'Palvelimen aikakatkaisu';

  @override
  String get background_task_error_no_internet =>
      'Verkkovirhe. Yritä myöhemmin uudelleen.';

  @override
  String get background_task_operation_unknown =>
      'tuntematon operaattorityyppi';

  @override
  String get background_task_operation_details => 'yksityiskohtaiset muutokset';

  @override
  String get background_task_operation_image => 'kuvan lataus';

  @override
  String get background_task_operation_refresh =>
      'päivitystä myöhennetty kuvan latauksen vuoksi';

  @override
  String get background_task_run_started => 'aloitettu';

  @override
  String get background_task_run_not_started => 'ei aloitettu';

  @override
  String get background_task_run_to_be_deleted => 'poistettava';

  @override
  String get background_task_question_stop => 'Haluatko päättää tehtävän heti?';

  @override
  String get feed_back => 'Palaute';

  @override
  String get undo => 'Kumoa';

  @override
  String get copy_email_to_clip_board =>
      'Kopioi sähköpostiosoite leikepöydälle';

  @override
  String get please_send_us_an_email_to =>
      'Lähetä manuaalisesti sähköpostia osoitteeseen';

  @override
  String get email_copied_to_clip_board =>
      'Sähköpostiosoite kopioitu leikepöydälle';

  @override
  String get select_accent_color => 'Valitse korostusväri';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Sininen';

  @override
  String get color_cyan => 'Vaaleampi sinivihreä';

  @override
  String get color_green => 'Vihreä';

  @override
  String get color_light_brown => 'Oletus';

  @override
  String get color_magenta => 'Aniliininpunainen';

  @override
  String get color_orange => 'Oranssi';

  @override
  String get color_pink => 'Vaaleanpunainen';

  @override
  String get color_red => 'Punainen';

  @override
  String get color_rust => 'Ruosteenvärinen';

  @override
  String get color_teal => 'Tummempi sinivihreä';

  @override
  String get text_contrast_mode => 'Tekstin kontrasti';

  @override
  String get contrast_high => 'Korkea';

  @override
  String get contrast_medium => 'Keskitaso';

  @override
  String get contrast_low => 'Matala';

  @override
  String get product_refresher_internet_not_found => 'Tuotetta ei löydy!';

  @override
  String get product_refresher_internet_not_connected =>
      'Et ole yhteydessä Internetiin!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Palvelin alas ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Palvelinvirhe ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Tuotetta ei löydy!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Tietokannassamme ei ole tuotetta, jolla on seuraava viivakoodi: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Ei internet-yhteyttä!';

  @override
  String get product_loader_network_error_message =>
      'Tarkista, että älypuhelimesi on Wi-Fi-verkossa tai että mobiilidata on käytössä';

  @override
  String get page_not_found_title => 'Sivua ei löydy!';

  @override
  String get page_not_found_button => 'Palaa etusivulle';

  @override
  String get download_data => 'Tietojen lataaminen';

  @override
  String get download_top_products =>
      'Lataa maasi 1000 suosituinta tuotetta välitöntä skannausta varten';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuotetta',
    );
    return 'Lataa suosituimmat $_temp0 maassasi välittömään skannaukseen';
  }

  @override
  String get download_in_progress =>
      'Ladataan tietoja\nTämä voi kestää jonkin aikaa';

  @override
  String downloaded_products(int num) {
    return '$num tuotetta lisätty';
  }

  @override
  String get update_offline_data => 'Offline-tuotetietojen päivitys';

  @override
  String get update_local_database_sub =>
      'Päivitä paikallinen tuotetietokanta Open Food Factsin uusimmilla tiedoilla';

  @override
  String get clear_local_database => 'Offline-tuotetietojen tyhjennys';

  @override
  String get clear_local_database_sub =>
      'Vapauta tilaa tyhjentämällä kaikki sovelluksen paikalliset tuotetiedot';

  @override
  String deleted_products(int num) {
    return '$num tuotetta poistettu';
  }

  @override
  String get loading => 'Ladataan…';

  @override
  String get know_more => 'Lisätietoja';

  @override
  String get offline_data_desc =>
      'Napsauta saadaksesi lisätietoja offline-tiedoista';

  @override
  String get offline_product_data_title => 'Offline-tuotetiedot';

  @override
  String available_for_download(int num) {
    return '$num tuotetta saatavilla välittömään skannaukseen';
  }

  @override
  String get country_selector_title => 'Valitse maa:';

  @override
  String get currency_selector_title => 'Valitse valuutta:';

  @override
  String get language_selector_title => 'Valitse kieli:';

  @override
  String get language_selector_section_selected => 'Selected languages';

  @override
  String get language_selector_section_frequently_used => 'Frequently used';

  @override
  String get action_delete_list => 'Poista';

  @override
  String get action_change_list => 'Muuta nykyistä luetteloa';

  @override
  String get product_list_create => 'Luo';

  @override
  String get product_list_create_tooltip => 'Luo uusi luettelo';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Uusi laskukaava)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Uusi laskukaava)';

  @override
  String get nutriscore_unknown => 'Tuntematon Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Tuntematon Nutri-Score (Uusi laskukaava)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score ei sovellu';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score ei ole sovellettavissa (Uusi laskukaava)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Vihreä pistemäärä A';

  @override
  String get environmental_score_b_new => 'Vihreä pistemäärä B';

  @override
  String get environmental_score_c_new => 'Vihreän pistemäärän C';

  @override
  String get environmental_score_d_new => 'Vihreä pistemäärä D';

  @override
  String get environmental_score_e_new => 'Vihreä pistemäärä E';

  @override
  String get environmental_score_unknown_new => 'Tuntematon vihreä pisteytys';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score ei ole sovellettavissa';

  @override
  String get nova_group_generic_new =>
      'Erittäin prosessoidut elintarvikkeet - NOVA-ryhmät';

  @override
  String get nova_group_1 => 'NOVA Ryhmä 1';

  @override
  String get nova_group_2 => 'NOVA Ryhmä 2';

  @override
  String get nova_group_3 => 'NOVA Ryhmä 3';

  @override
  String get nova_group_4 => 'NOVA Ryhmä 4';

  @override
  String get nova_group_unknown => 'Tuntematon NOVA Ryhmä';

  @override
  String get nutrition_facts => 'Ravintoaineiden Tasot';

  @override
  String get faq_title_partners =>
      'Kansalaisjärjestön yhteistyökumppanit ja suojelijat';

  @override
  String get faq_title_vision =>
      'Open Food Facts Visio, Missio, Arvot ja Ohjelmat';

  @override
  String get faq_title_install_beauty =>
      'Luo kosmeettinen tietokanta asentamalla Open Beauty Facts';

  @override
  String get faq_title_install_pet =>
      'Luo lemmikkieläinten ruokatietokanta asentamalla Open Pet Food Facts';

  @override
  String get faq_title_install_product =>
      'Asenna Open Products Facts luodaksesi tuotetietokannan objektien käyttöiän pidentämiseksi';

  @override
  String get faq_nutriscore_nutriscore =>
      'Uusi Nutri-Score-laskukaava: mitä uutta?';

  @override
  String get contact_title_pro_page => 'Pro? Tuo tuotteesi Open Food Factsiin';

  @override
  String get contact_title_pro_email => 'Tuottajan yhteystiedot';

  @override
  String get contact_title_press_page => 'Lehdistösivu';

  @override
  String get contact_title_press_email => 'Lehdistöyhteystiedot';

  @override
  String get contact_title_newsletter => 'Tilaa uutiskirjeemme';

  @override
  String get contact_title_calendar => 'Subscribe to our community calendar';

  @override
  String get hunger_games_loading_line1 =>
      'Ole hyvä ja anna meille muutama sekunti…';

  @override
  String get hunger_games_loading_line2 => 'Ladataan kysymyksiä!';

  @override
  String get hunger_games_error_label =>
      'Argh! Jotain meni pieleen… emmekä voineet ladata kysymyksiä.';

  @override
  String get hunger_games_error_retry_button => 'Yritetään uudelleen!';

  @override
  String get reorder_attribute_action => 'Uudelleenjärjestä attribuutit';

  @override
  String get link_cant_be_opened =>
      'Tätä linkkiä ei voi avata laitteellasi. Tarkista, että sinulla on selain asennettuna.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Yksityiskohdat tuotteelle $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Tiedot $pageName ja $productName';
  }

  @override
  String get guide_title => 'Opas';

  @override
  String get guide_share_label => 'Jaa';

  @override
  String get guide_nutriscore_v2_title => 'Nutri-Score kehittyy: selityksiä!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Mikä on Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score on logo, jonka tarkoituksena on kertoa sinulle **ruokien ravintoarvosta**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Värikoodi vaihtelee tummanvihreästä (**A**) **terveellisimmille** tuotteille tummanpunaiseen (**E**) **vähemmän terveellisille** tuotteille.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption => 'Nutri-Score A -logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Miksi Nutri-Score kehittyy?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Nutri-Score-kaava **kehitetään** tarjotakseen parempia suosituksia:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Paranna kaikkien juomien arviointia';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Uuden algoritmin mukaan **maito**, **sokerilla maustetut maitojuomat** ja **kasvijuomat** eroteltiin paremmin vertailevissa muistiinpanoissa.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Parempi juomien sijoitus';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**Sokeripitoisuus** otetaan paremmin huomioon ja suosii **vähän makeutettuja** juomia.\\n**Makeutusaineista myös rangaistaan**: dieettivirvoitusjuomat alennetaan B-luokituksen tasosta C:n ja E:n välille. Vesi on edelleen suositeltu juoma.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Suolasta ja sokerista rangaistaan';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Tuotteiden, jotka ovat **liian makeita** tai **liian suolaisia**, **luokitusta alennetaan edelleen**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarkia öljyjen ja kalojen välillä';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Tiettyjen **rasvaisten kalojen** ja **hyviä rasvoja sisältävien öljyjen** luokitus paranee.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Rajoita punaista lihaa';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      '**Punaisen lihan kulutusta tulisi rajoittaa**. Tämä on syy siihen, miksi **siipikarja sijoittuu suhteellisesti paremmin**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Kuinka erottaa vanha Nutri-Score ja uusi laskelma?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Tästä eteenpäin logossa voi näkyä maininta \"**Uusi laskelma**\" selventääkseen, että kyseessä on todellakin uusi laskelma.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Uuden Nutri-Scoren logo';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Mistä löydät uuden Nutri-Score-laskelman?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'The Nutri-Score is applied in 7 countries: France, Germany, Belgium, Spain, Luxembourg, the Netherlands and Switzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Manufacturers have at most **2 years** at the latest after the signature of the decree **to replace** the old calculation with the new one.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Odotamatta **löydät jo OpenFoodFacts-sovelluksesta** uuden laskelman, myös jos valmistajat eivät ole päivittäneet arvosanaa.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Mikä ei muutu';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score on pistemäärä, joka on suunniteltu **mittaamaan ravintoarvoa**. Se **täydentää NOVA-ryhmää** **ultrajalostetuissa elintarvikkeissa** (sisältyy myös hakemukseen).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Valmistajille Nutri-Score-näyttö **pysyy valinnaisena**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Mikä on vihreä pisteytys?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score on logo, jonka tarkoituksena on tiedottaa sinulle **ruoan ympäristövaikutuksista**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Värikoodi vaihtelee tummanvihreästä (**A+**) **vähiten vaikuttaville** tuotteille tummanpunaiseen (**F**) **vaikuttavimmille** tuotteille.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score-logot';

  @override
  String get guide_greenscore_lca_title => 'Ydin: Elinkaariarviointi (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Elintarvikekategorioiden tieteellinen arviointi';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Kullekin tuotekategorialle määritetään **vertailuarvo** Agribalyse-ympäristötietokannan (ADEME:n ja INRAE:n suunnittelema) tietojen perusteella.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Elinkaarianalyysi** on standardoitu arviointimenetelmä monivaiheisen ja monikriteerisen ympäristöarvioinnin suorittamiseksi.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Se mittaa:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 tuotantovaihetta';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Maatalous';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Jalostus';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Pakkaus';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Kuljetus';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Jakelu';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Kulutus';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 ympäristövaikutusindikaattoria';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Ilmastonmuutos/hiilijalanjälki';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Otsonikerroksen oheneminen';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ionisoiva säteily';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Maa';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Veden ja energian kulutus';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Ilman saastuminen';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Meri- ja makea vesi (hiukkaset, happamoituminen, rehevöityminen)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Resurssien ehtyminen.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonukset ja rangaistukset';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Tuotantotapa';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Ainesosien alkuperä';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Uhanalaiset lajit';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Pakkaus';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Lisääntynyt avoimuuden tarve parantamaan ympäristövaikutusten mittaamista ja vähentämistä';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Miten valmistajat voivat auttaa';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Valmistajat voivat lähettää meille tietonsa suoraan ilmaisen tuottaja-alustamme kautta.';

  @override
  String get guide_greenscore_better_product_title =>
      'Kumpi tuote on parempi planeetalle?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Voi olla vaikea sanoa';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Kestävän ruoan valitseminen on yksi tehokkaimmista asioista, joita voimme tehdä ilmaston hyväksi, sillä **maailmanlaajuinen ruokajärjestelmämme on vastuussa yli neljänneksestä kaikista kasvihuonekaasupäästöistä**.\n(Lähde: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Sinulla on valta!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Hyvä uutinen on, että tämä antaa meille tehokkaan tavan luoda muutosta.\n**Jokainen meistä syö noin 1 000 ateriaa vuodessa**. Se on 1 000 mahdollisuutta **valita parempi tulevaisuus planeetalle**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Auttaa olemaan vastuullinen ja tekemään päätöksiä';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Kestävän ruoan valitseminen voi tuntua monimutkaiselta. Etiketit ovat hämmentäviä ja tiedot usein puuttuvat. Green-Score luotiin yksinkertaistamaan valintaa, antaen sinulle **selkeän**, **tieteeseen perustuvan** ja **läpinäkyvän** ympäristöluokituksen elintarvikkeille juuri siellä missä sitä tarvitset: ostoksilla ollessasi.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Läpinäkyvyys';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Toisin kuin omat merkinnät, Green-Score-laskenta on **täysin avoin** ja **kuka tahansa voi tarkistaa sen**.';

  @override
  String get guide_nova_title => 'Ultrajalostetut ruoat';

  @override
  String get guide_nova_what_is_nova_title => 'Mitä on ultraprosessointi?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA-ryhmät kertovat sinulle elintarvikkeiden jalostuksen tasosta.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA-luokituksen avulla elintarvikkeet voidaan luokitella **neljään ryhmään** niiden **teollisen prosessoinnin asteen** perusteella (minimaalisesti prosessoidut tai prosessoimattomat elintarvikkeet, ruoanlaittoainesosat, prosessoidut elintarvikkeet, erittäin prosessoidut elintarvikkeet).';

  @override
  String get guide_nova_logos_caption => 'NOVA-logot';

  @override
  String get guide_nova_groups_title => '4 NOVA-ryhmää';

  @override
  String get guide_nova_groups_intro =>
      'NOVA-ryhmiä on neljä, joista ongelmallisin on ryhmä 4 – erittäin prosessoidut elintarvikkeet.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimaalisesti prosessoidut tai prosessoimattomat elintarvikkeet';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Jalostetut ruoanvalmistusaineet';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from Group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Jalostetut ruoat';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to group 1** foods. processes include various preservation or cooking methods, And in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or Three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultrajalostetut ruoat';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, Or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically Used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Ultraprosessoinnin ongelmat';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Elintarvikkeiden ainesosien äärimmäinen käsittely';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Lisäaineet, jotka ylittävät pelkän elintarviketurvallisuuden rajat';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Käsittelyä, jota ei voi tehdä kotona';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Ultraprosessoinnin saalistushinnoittelu ja taloudelliset näkökohdat';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-fi.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-fi.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-fi.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-fi.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-fi.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Esikatselu';

  @override
  String get prices_feedback_form =>
      'Napsauta tätä lähettääksesi meille palautetta tästä uudesta ominaisuudesta!';

  @override
  String get menu_button_list_actions => 'Valitse toiminto';

  @override
  String get error_loading_photo => 'Virhe kuvaa ladattaessa';

  @override
  String get photo_viewer_action_use_picture_as => 'Tee tästä kuvasta…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Use this picture as…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Tee tästä kuvasta… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Yksityiskohdat';

  @override
  String get photo_viewer_details_button_accessibility_label => 'Kuvan tiedot';

  @override
  String get photo_viewer_details_title => 'Kuvan tiedot';

  @override
  String get photo_viewer_details_contributor_title => 'Osallistuja';

  @override
  String get photo_viewer_details_size_title => 'Koko';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height kuvapistettä';
  }

  @override
  String get photo_viewer_details_date_title => 'Päivämäärä';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Yhteensopiva';

  @override
  String get user_lists_action_multi_select => 'Monivalinta';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Yhteensopivuuspisteesi: $score %';
  }

  @override
  String get product_image_front_accessibility_label => 'Etukuva';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Kuva ainesosaluettelosta';

  @override
  String get product_image_nutrition_accessibility_label => 'Ravintoarvokuva';

  @override
  String get product_image_packaging_accessibility_label => 'Pakkauksen kuva';

  @override
  String get product_image_other_accessibility_label => 'Muu kuva';

  @override
  String get product_image_outdated_message =>
      'Tämä kuva saattaa olla vanhentunut';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (tämä kuva saattaa olla vanhentunut)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (tuottaja on saattanut lukita tämän kuvan)';
  }

  @override
  String get product_image_error => 'Kuvaa ei voi ladata!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '${type}a ei voitu ladata. (verkkovirhe?)';
  }

  @override
  String get product_page_image_no_image_available => 'Ei\nkuvaa!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Tästä tuotteesta ei ole saatavilla kuvaa';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Järjestä tai piilota toimintoja';

  @override
  String get product_page_action_bar_setting_modal_title => 'Edit actions';

  @override
  String get product_page_action_bar_item_move_up => 'Move up';

  @override
  String get product_page_action_bar_item_move_down => 'Move down';

  @override
  String get product_page_action_bar_item_enable => 'Enable action';

  @override
  String get product_page_action_bar_item_disable => 'Disable action';

  @override
  String get product_page_pending_operations_banner_title =>
      'Uploading your edits…';

  @override
  String get product_page_pending_operations_banner_message =>
      'The data displayed on this page **does not yet reflect your modifications**.\nPlease wait a few seconds…';

  @override
  String get product_add_a_language => 'Add a language';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Barcode $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Remove this product from the carousel';

  @override
  String get carousel_unsupported_header => 'Unsupported barcode!';

  @override
  String get carousel_unsupported_title => 'Ooops!';

  @override
  String get carousel_unsupported_text =>
      'The barcode scanned is not supported by Open Food Facts!';

  @override
  String get carousel_error_header => 'Error!';

  @override
  String get carousel_error_title => 'It\'s a bummer!';

  @override
  String get carousel_error_text_1 =>
      'We couldn\'t download information on this barcode:';

  @override
  String get carousel_error_text_2 =>
      'Please check your Internet connection or click this button:';

  @override
  String get carousel_error_button => 'Yritä uudelleen';

  @override
  String get carousel_unknown_product_header => 'Tuntematon tuote';

  @override
  String get carousel_unknown_product_title =>
      'Congratulations!\nYou\'ve found __the rare gem!__';

  @override
  String get carousel_unknown_product_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get carousel_unknown_product_button => 'Lisää tämä tuote';

  @override
  String get carousel_loading_header => 'Loading information...';

  @override
  String get carousel_loading_title =>
      'You\'ve just scanned a product with the following barcode:';

  @override
  String get carousel_loading_text =>
      'We are searching for it in our database of more than **3 million products!**';

  @override
  String get product_type_subtitle_food => 'Vegetables, fruits, frozen food…';

  @override
  String get product_type_subtitle_beauty => 'Makeup, soaps, toothpastes…';

  @override
  String get product_type_subtitle_pet_food => 'Food for dogs, cats…';

  @override
  String get product_type_subtitle_product => 'Smartphones, furniture…';

  @override
  String get photo_field_front => 'Product photo';

  @override
  String get photo_field_ingredients => 'Ainesosakuva';

  @override
  String get photo_field_nutrition => 'Nutrition photo';

  @override
  String get photo_field_packaging => 'Pakkaustietokuva';

  @override
  String get photo_already_exists => 'This photo already exists';

  @override
  String get photo_missing => 'This photo is missing';

  @override
  String get date => 'Päivämäärä';

  @override
  String get photo_rotate_left => 'Kierrä vasemmalle';

  @override
  String get photo_rotate_right => 'Kierrä oikealle';

  @override
  String get photo_undo_action => 'Undo the previous action';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'A world map of $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap contributors';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Varoitus';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Why is this Nutri-Score different from the one on the package?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'There are two possible explanations:\nThe list of ingredients and/or nutrition facts are not up-to-date.\n\nWe provide the \"New calculation\" of the Nutri-Score (or V2). Please check that you have the banner \"New calculation\" on the package.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Check ingredients';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Check nutrition facts';

  @override
  String url_not_supported(String url) {
    return 'Unfortunately, we can\'t open the URL:\n$url';
  }

  @override
  String get product_list_export => 'Export';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'View barcode';

  @override
  String get product_footer_action_barcode_short => 'Viivakoodi';

  @override
  String get product_footer_action_open_website => 'Open website';

  @override
  String get product_footer_action_report => 'Report';

  @override
  String get product_footer_action_contributor_guide => 'Ohje';

  @override
  String get product_footer_action_data_quality_tags => 'Data quality';

  @override
  String get product_page_tab_for_me => 'Minulle';

  @override
  String get product_page_tab_website => 'Nettisivusto';

  @override
  String get product_page_tab_prices => 'Hinnat';

  @override
  String get prices_explanation_card_title => 'Miksi hinnat?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** on projekti, jonka tarkoituksena on kerätä ja jakaa tuotteiden hintoja ympäri maailmaa 🌍. Open Pricesin on kehittänyt ja ylläpitää Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Opi lisää';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Mitä ovat folksonomiaominaisuudet?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Attribuutit ovat **avain-arvo**-pohjaisia.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Nämä ominaisuudet luovat ja arkistoivat avustajat kaikenlaiseen käyttöön.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Ei hintaa saatavilla';

  @override
  String get prices_products_empty_explanation =>
      'Ole ensimmäinen osallistuja!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize products (total: $total)';
  }

  @override
  String get app_review_title => 'Are you enjoying this app?';

  @override
  String get app_review_low => 'Could do better';

  @override
  String get app_review_medium => 'Ei huono';

  @override
  String get app_review_high => 'I love it!';

  @override
  String get app_review_feedback_modal_title =>
      'Help us improve our application';

  @override
  String get app_review_feedback_modal_content =>
      'If you have a few minutes, could you answer this form so that **we can improve in future updates**:';

  @override
  String get app_review_feedback_modal_open_form => 'Answer the form';

  @override
  String get app_review_feedback_modal_later => 'Kysy myöhemmin';

  @override
  String get nutrition_facts_extract_new =>
      'NEW: You can automatically extract the nutrients from the picture!';

  @override
  String get nutrition_facts_extract_button_text => 'Extract now';

  @override
  String get nutrition_facts_extract_in_progress => 'Uutto käynnissä…';

  @override
  String get nutrition_facts_extract_successful => 'Uutto onnistui';

  @override
  String get nutrition_facts_extract_failed =>
      'Failed to extract nutrients from picture';

  @override
  String get prices_discount => 'Alennus';

  @override
  String get prices_stats_statistics => 'Statistics';

  @override
  String get prices_stats_title => 'Prices Statistics';

  @override
  String get prices_stats_prices_section => 'Hinnat';

  @override
  String get prices_stats_products_section => 'Tuotteet';

  @override
  String get prices_stats_locations_section => 'Sijainnit';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Osallistujat';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Sekalaiset';

  @override
  String get prices_stats_total => 'Yhteensä';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Kulutus';

  @override
  String get prices_stats_with_price => 'Hinnalla';

  @override
  String get prices_stats_food => 'Ruoka';

  @override
  String get prices_stats_beauty => 'Kauneus';

  @override
  String get prices_stats_products => 'Tuotteet';

  @override
  String get prices_stats_pet_food => 'Lemmikin ruoka';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Maat';

  @override
  String get prices_stats_price_tag => 'Hintalappu';

  @override
  String get prices_stats_receipt => 'Kuitti';

  @override
  String get prices_stats_gdpr_request => 'GDPR-pyyntö';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Nettisivusto';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Muu';

  @override
  String get prices_stats_last_updated => 'Last updated on';

  @override
  String get prices_stats_error =>
      'An error occurred while loading statistics.';

  @override
  String get product_edit_robotoff_question_answered => 'Question answered!';

  @override
  String get product_edit_robotoff_proof => 'Todiste';

  @override
  String get preferences_card_general => 'Yleiset';

  @override
  String get preferences_prices_title => 'Hinnat';

  @override
  String get preferences_prices_subtitle => 'Hallinnoi hinta-asetuksiasi';

  @override
  String get preferences_card_project => 'Avoimet ruokatiedot -projekti';

  @override
  String get preferences_contribute_title => 'Osallistu';

  @override
  String get preferences_my_contributions_title => 'Osallistumiseni';

  @override
  String get preferences_my_stats_title => 'Tilastoni';

  @override
  String get preferences_contribute_subtitle => 'Käännä, paranna työkalujamme…';

  @override
  String get preferences_connect_title => 'Yhdistä';

  @override
  String get preferences_connect_subtitle =>
      'Ota yhteyttä tai seuraa meitä sosiaalisessa mediassa';

  @override
  String get preferences_support_title => 'Tee lahjoitus';

  @override
  String get preferences_support_subtitle =>
      'Auta meitä tiedottamaan miljoonille kuluttajille ympäri maailmaa';

  @override
  String get preferences_card_help => 'Ohje ja tuki';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Hanki vastauksia kysymyksiisi';

  @override
  String get logged_out => 'Kirjauduttu ulos';

  @override
  String get preferences_app_bar_message =>
      'Kiitos, että olet yksi jäsenistämme!';

  @override
  String get preferences_app_bar_products_modified => 'Tuotteita muokattu';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Katso kaikki tilastot';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Hae $provider hakusanalla \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Hae asetusta (esim. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Esteettömyys: Näytä emojit';

  @override
  String get preferences_accessibility_remove_colors =>
      'Esteettömyys: Poista värit';

  @override
  String get preferences_app_settings_products => 'Tuotteet';

  @override
  String get preferences_card_about => 'Tietoja';

  @override
  String get preferences_legal_information_title => 'Lakitiedot';

  @override
  String get preferences_legal_information_subtitle =>
      'Käyttöehdot, tietosuojakäytäntö ja muuta';

  @override
  String get preferences_terms_of_use => 'Käyttöehdot';

  @override
  String get preferences_legal_mentions => 'Oikeudelliset huomautukset';

  @override
  String get preferences_legal_header =>
      'Open Food Facts on elintarviketuotetietokanta, **jonka kaikki ovat tehneet kaikille**.\nVoit käyttää sitä parempien ruokavalintojen tekemiseen, ja koska se on **avointa dataa**, kuka tahansa voi **käyttää sitä uudelleen mihin tahansa tarkoitukseen**.';

  @override
  String get preferences_privacy_policy => 'Tietosuojakäytäntö';

  @override
  String get preferences_licenses => 'Lisenssit';

  @override
  String get preferences_about_app_title => 'Tietoja sovelluksesta';

  @override
  String get preferences_about_app_subtitle =>
      'Teknisiä tietoja, kehittäjätietoja ja muuta';

  @override
  String get preferences_card_information => 'Tietoja';

  @override
  String get preferences_version_number_title => 'Versionumero';

  @override
  String get preferences_scanner_title => 'Skanneri';

  @override
  String get preferences_app_store => 'Sovelluskauppa';

  @override
  String get preferences_app_system_settings => 'Järjestelmäasetukset';

  @override
  String get preferences_source_code => 'Käytä lähdekoodia';

  @override
  String get preferences_source_code_subtitle =>
      'Ja ala vaikuttaa miljoonien ihmisten elämään';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Kerro koko maailmalle';

  @override
  String get preferences_tips => 'Vinkkejä';

  @override
  String get tips_discover_nutriscore => 'Tutustu uuteen Nutri-Scoreen';

  @override
  String get preferences_on_off_website_subtitle =>
      'Open Food Facts -verkkosivustolla';

  @override
  String get preferences_manage_account_title => 'Hallinnoi tiliäni';

  @override
  String get preferences_manage_account_tooltip => 'Hallinnoi tiliäsi';

  @override
  String get preferences_change_password_title => 'Vaihda salasanani';

  @override
  String get preferences_danger_zone => 'Vaara-alue';

  @override
  String get preferences_account_deletion_subtitle =>
      'Kaikki panoksesi menetetään';

  @override
  String get preferences_contributions_title => 'Osallistumiset';

  @override
  String get preferences_dev_mode_app_settings_title => 'Sovellusasetukset';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Hyvin kokeellinen tapa skannata tuotteita offline-tilassa';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Päivitä kaikki tuotteet palvelimelta';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Vältä tekemästä sitä, ellei se ole ehdottoman välttämätöntä';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demotila';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Lisää kortteja skanneriin';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Lisää skanneriin 3 näytetuotetta';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Folksonomy-isäntä';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Isäntä: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Esteettömyyskokeilut';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Useiden tuotteiden valikoima hintojen mukaan';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Käyttäjän järjestämät tietopaneelit';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Tilapäinen pääsy sijaintihakuun';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Kahden tai kolmen tuotteen rinnakkaisvertailu';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Tuotelistan tuonti';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Pisteet ja menetelmät';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Tutustu Nutri-Scoren laskemiseen';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Tutustu metodologian tärkeimpiin muutoksiin';

  @override
  String get preferences_faq_discover_project_title => 'Tutustu hankkeeseen';

  @override
  String get preferences_faq_discover_off_title =>
      'Tutustu avoimiin ruokatietoihin';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'Usein kysytyt kysymykset';

  @override
  String get preferences_faq_off_ngo_title =>
      'Open Food Facts -kansalaisjärjestö';

  @override
  String get preferences_about_information_title => 'Tietoja';

  @override
  String get preferences_connect_community_updates_title =>
      'Hanki yhteisön päivityksiä';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Pysy ajan tasalla sovelluksen ja yhteisön uutisten avulla';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscribe to our community calendar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Osallistu johonkin virtuaalitapahtumiimme';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts -blogi';

  @override
  String get preferences_connect_blog_subtitle =>
      'Saat uusimmat uutiset heti niiden tapahtuessa';

  @override
  String get preferences_connect_community_help_title =>
      'Hanki apua yhteisöltä';

  @override
  String get preferences_connect_improve_app_title =>
      'Auta meitä parantamaan sovellusta';

  @override
  String get preferences_connect_debug_info_title =>
      'Lähetä meille virheenkorjaustiedot';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Lähetä meille sähköpostia, jossa on yksityiskohtaiset virheenkorjaustiedot';

  @override
  String get preferences_connect_feedback_title =>
      'Lähetä meille palautetta sovelluksesta';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Auta muokkaamaan sovelluksen tulevaisuutta';

  @override
  String get preferences_connect_survey_title => 'Osallistu sovelluskyselyyn';

  @override
  String get preferences_connect_survey_subtitle =>
      'Auta meitä ymmärtämään, mitä meidän pitäisi rakentaa seuraavaksi';

  @override
  String get preferences_connect_professionals_title => 'ammattilaiset';

  @override
  String get preferences_connect_pro_subtitle =>
      'Täysin ilmainen, varmistaa tarkat tiedot 500 sovelluksesta ja miljoonilta kuluttajilta. Itsepalvelu, yhteensopiva PIM- tai laskentataulukoiden (XLSX) kanssa.';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Ota yhteyttä aloittaaksesi';

  @override
  String get preferences_connect_press_title => 'Lehdistö';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Hanki kaikki tarvitsemasi materiaali raporttiasi varten';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Ota yhteyttä lehdistötiedusteluja varten tai kertoaksesi meille raportistasi';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Ryhdy aktiiviseksi vapaaehtoiseksi';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Kehitys, viestintä, suunnittelu… Kaikenlainen vapaaehtoistyö tai asiantuntemus on tervetullutta!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Tutustu moniin tapoihin, joilla voit osallistua';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobiilisovellusten kehitys';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Opi osallistumaan ohjelmistokehitykseen';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Päivittäiset epävakaat koontiversiot, upouudet ominaisuudet';

  @override
  String get preferences_contribute_local_community_title =>
      'Kasvata paikallisyhteisöäsi';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Apua ohjelmistojen, sisällön ja ainesosa-analyysien käännösten kanssa';

  @override
  String get preferences_contribute_share_subtitle =>
      'Olemme laatineet pienen mallin avuksesi :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Yksinkertaisia toimenpiteitä ruoan läpinäkyvyyden lisäämiseksi maassasi';

  @override
  String get preferences_contribute_data_quality_title => 'Data quality';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Liity datan laatutiimiin';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Liity mukaan varmistamaan tietokannan täydellisyys ja tarkkuus';

  @override
  String get preferences_contributions_products_added_title =>
      'Lisätyt tuotteet';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Uusia tuotteita, jotka lisäsin Open Food Factsiin';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Tuotteet, jotka minun on saatava valmiiksi';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Kaikki keskeneräiset tuotteet';

  @override
  String get preferences_my_contributions_prices_title => 'Hinnat';

  @override
  String get preferences_my_contributions_my_prices_title => 'Minun hinnat';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Hintani, todisteeni…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Tuotteet, joiden valmistumisessa voit auttaa';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Auta laskemaan Nutri-Score- ja Green-Score-pisteet maassasi';

  @override
  String get preferences_prices_user_prices_subtitle => 'Hinnat, jotka annan';

  @override
  String get preferences_prices_proofs_subtitle => 'Hintalaput ja kuitit';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Ota kuvia kuiteistasi ja skannaa niihin liittyvät viivakoodit';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Ota kuvia hinnoista kaupassa';

  @override
  String get preferences_prices_newest_title => 'Uusimmat hinnat';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Prices -yhteisön lisäämät uusimmat hinnat';

  @override
  String get preferences_prices_top_contributors_title =>
      'Eniten hintoja saaneet avustajat';

  @override
  String get preferences_prices_metrics_title => 'Avaa hintamittarit';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Seuraa projektin etenemistä';

  @override
  String get preferences_prices_ways_contribute_title => 'Tapoja osallistua';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Vahvista itse tai muiden lisäämät hinnat tekoälyn avulla';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Lisää nopeasti useita kuitteja tai hyllykuvia kamerarullasta';

  @override
  String get preferences_prices_challenges_title => 'Kuukausittaiset haasteet';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Osallistu kuukausittaisiin teematehtäviin kerätäksesi hintoja';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Palauta kanta-asiakastietosi';

  @override
  String get preferences_prices_gdpr_subtitle => 'Opi pyytämään tietojasi';

  @override
  String get preferences_page_customize_app_title => 'Mukauta sovellusta';

  @override
  String get preferences_page_contribute_project_title =>
      'Osallistu projektiin';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Yksinkertaisia tapoja auttaa Open Food Factsissa';

  @override
  String get preferences_page_faq_subtitle =>
      'Pisteytysmenetelmät, ohjeet ja muuta projektista';

  @override
  String get product_edit_robotoff_positive_button => 'Hyväksy ehdotus';

  @override
  String get product_edit_robotoff_negative_button => 'Hylkää ehdotus';

  @override
  String get product_edit_robotoff_show_proof => 'Näytä todiste';

  @override
  String get product_edit_robotoff_expand_proof => 'Laajenna todiste';

  @override
  String get product_page_tab_raw_data => 'Raakadata';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Sivu $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Sivu $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count / $total tuotetta';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count / $total tuotetta';
  }

  @override
  String item_count(int count) {
    return '$count tuotetta';
  }

  @override
  String item_count_string(String count) {
    return '$count tuotetta';
  }

  @override
  String get prices_no_result => 'Hintatilastoja ei löytynyt.';

  @override
  String get prices_error_loading_more_items =>
      'Virhe ladattaessa lisää kohteita';

  @override
  String get prices_proof_error =>
      'Todennus epäonnistui, todisteiden nouto epäonnistui';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count / $total todistusta';
  }

  @override
  String proof_count(int count) {
    return '$count todisteita';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count / $total osallistujaa';
  }

  @override
  String contributors_count(int count) {
    return '$count avustajia';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count / $total sijainnista';
  }

  @override
  String prices_locations_count(int count) {
    return '$count sijaintia';
  }

  @override
  String get restart_to_apply_message =>
      'Käynnistä sovellus uudelleen, jotta muutokset tulevat voimaan.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Graafinen käyttöliittymä';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Kehitys';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Avoimet ruokatietolaboratoriot';

  @override
  String get preferences_root_account_title => 'Tili';

  @override
  String get preferences_contribute_translate_header =>
      'Tuo avoimet ruokatiedot omalle kielellesi';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Rekisteröidy sovelluksen alfa-versioon';

  @override
  String get preferences_dev_mode_section_data => 'Lisäykset ja tuotetiedot';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Älä näytä Folksonomiaa';

  @override
  String get preferences_account_title => 'Tili';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Lisätty $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Nimi';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
