// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Sí';

  @override
  String get add => 'Añadir';

  @override
  String get account_delete_message =>
      '¿Seguro que quieres eliminar tu cuenta?\nSi hay alguna una razón específica, cuéntanoslo abajo.';

  @override
  String get reason => 'Razón';

  @override
  String get okay => 'Vale';

  @override
  String get validate => 'Validar';

  @override
  String get create => 'Crear';

  @override
  String get applyButtonText => 'Aplicar';

  @override
  String get next_label => 'Siguiente';

  @override
  String get continue_label => 'Continuar';

  @override
  String get exit_label => 'Salir';

  @override
  String get previous_label => 'Anterior';

  @override
  String get go_back_to_top => 'Volver al principio';

  @override
  String get save => 'Guardar';

  @override
  String get save_confirmation => '¿Seguro que quieres guardar?';

  @override
  String get skip => 'Omitir';

  @override
  String get cancel => 'Cancelar';

  @override
  String get ignore => 'Ignorar';

  @override
  String get close => 'Cerrar';

  @override
  String get no => 'No';

  @override
  String get stop => 'Parar';

  @override
  String get finish => 'Finalizar';

  @override
  String get calculate => 'Calcular';

  @override
  String get reset_food_prefs => 'Restablecer preferencias alimentarias';

  @override
  String get error => 'Algo ha salido mal';

  @override
  String get error_occurred => 'Se ha producido un error';

  @override
  String get featureInProgress =>
      'Todavía estamos trabajando en esta función, estad atentos';

  @override
  String get label_web => 'Ver en la web';

  @override
  String get learnMore => 'Saber más';

  @override
  String get unknown => 'Desconocido';

  @override
  String get match_very_good => 'Muy recomendable';

  @override
  String get match_good => 'Recomendable';

  @override
  String get match_poor => 'Poco recomendable';

  @override
  String get match_may_not => 'Poca información';

  @override
  String get match_does_not => 'No recomendable';

  @override
  String get match_unknown => 'Sin información suficiente';

  @override
  String get match_short_very_good => 'Muy recomendable';

  @override
  String get match_short_good => 'Recomendable';

  @override
  String get match_short_poor => 'Poco recomendable';

  @override
  String get match_short_may_not => 'Poca información';

  @override
  String get match_short_does_not => 'No recomendable';

  @override
  String get match_short_unknown => 'Sin información suficiente';

  @override
  String get licenses => 'Licencias';

  @override
  String get looking_for => 'Buscando';

  @override
  String get welcomeToOpenFoodFacts =>
      'Te damos la bienvenida a Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts es una organización global sin ánimo de lucro impulsada por comunidades locales.';

  @override
  String get productDataUtility =>
      'Consulta los datos de los alimentos relacionados con tus preferencias.';

  @override
  String get healthCardUtility =>
      'Elige los alimentos que sean buenos para ti.';

  @override
  String get ecoCardUtility =>
      'Elige alimentos que sean buenos para el planeta.';

  @override
  String get server_error_open_new_issue =>
      '¡No hay respuesta del servidor! Puedes alertar de esta instancia con el siguiente enlace.';

  @override
  String get sign_in_text =>
      'Inicia sesión en tu cuenta de Open Food Facts para guardar tus contribuciones';

  @override
  String get incorrect_credentials =>
      'Nombre de usuario o contraseña incorrecto.';

  @override
  String get password_lost_incorrect_credentials =>
      'Este correo electrónico o nombre de usuario no existe. Por favor, comprueba tus credenciales.';

  @override
  String get password_lost_server_unavailable =>
      'Estamos sufriendo retrasos en nuestros servidores y nos disculpamos por ello. Por favor, inténtalo de nuevo más tarde.';

  @override
  String get login => 'Iniciar sesión';

  @override
  String get login_result_type_server_unreachable =>
      'No es posible conectarse a la red';

  @override
  String get login_result_type_server_issue =>
      'Problema en el servidor. Por favor, inténtalo más tarde.';

  @override
  String get login_page_username_or_email =>
      'Por favor, introduce tu nombre de usuario o correo electrónico';

  @override
  String get login_page_password_error_empty =>
      'Por favor, introduce una contraseña';

  @override
  String get create_account => 'Crear cuenta';

  @override
  String get sign_in => 'Iniciar sesión';

  @override
  String get sign_in_mandatory =>
      'Para usar esa función necesitas iniciar sesión.';

  @override
  String get help_improve_country =>
      'Ayuda a mejorar Open Food Facts en tu país';

  @override
  String get sign_out => 'Cerrar sesión';

  @override
  String get sign_out_confirmation => '¿Seguro que quieres cerrar la sesión?';

  @override
  String get password => 'Contraseña';

  @override
  String get forgot_password => 'Contraseña olvidada';

  @override
  String get forgot_password_question => '¿Has olvidado tu contraseña?';

  @override
  String get view_profile => 'Ver perfil';

  @override
  String get reset_password => 'Restablecer la contraseña';

  @override
  String get reset_password_explanation_text =>
      'En caso de que hayas olvidado la contraseña, introduce tu nombre de usuario o dirección de correo electrónico para recibir instrucciones de cómo restablecerla. No olvides revisar la carpeta de correo basura.';

  @override
  String get username_or_email => 'Nombre de usuario o correo electrónico';

  @override
  String get reset_password_done =>
      'Hemos enviado un correo electrónico con un enlace a la dirección de correo electrónico vinculada a tu cuenta de usuario para que puedas restablecer tu contraseña. No olvides revisar la carpeta de correo basura.';

  @override
  String get send_reset_password_mail => 'Cambiar contraseña';

  @override
  String get enter_some_text => 'Por favor, escribe algo';

  @override
  String get sign_up_page_title => 'Regístrate';

  @override
  String get sign_up_page_action_button => 'Regístrate';

  @override
  String get sign_up_page_action_doing_it => 'Registrando…';

  @override
  String get sign_up_page_action_ok =>
      '¡Felicidades! Tu cuenta acaba de ser creada.';

  @override
  String get sign_up_page_display_name_hint => 'Nombre';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Por favor, introduce el nombre que deseas mostrar';

  @override
  String get sign_up_page_email_hint => 'Correo electrónico';

  @override
  String get sign_up_page_email_error_empty =>
      'Se requiere un correo electrónico';

  @override
  String get sign_up_page_email_error_invalid => 'Correo electrónico inválido';

  @override
  String get sign_up_page_username_hint =>
      'Nombre de usuario: visible públicamente';

  @override
  String get sign_up_page_username_error_empty =>
      'Por favor, introduce un nombre de usuario';

  @override
  String get sign_up_page_username_error_invalid =>
      'Por favor, introduce un nombre de usuario válido';

  @override
  String get sign_up_page_username_description =>
      'El nombre de usuario no puede contener espacios, mayúsculas o caracteres especiales.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'El nombre de usuario no puede exceder los $value caracteres';
  }

  @override
  String get sign_up_page_password_hint => 'Contraseña';

  @override
  String get sign_up_page_password_error_empty =>
      'Por favor, introduce una contraseña';

  @override
  String get sign_up_page_password_error_invalid =>
      'Por favor, introduce una contraseña válida (al menos 6 caracteres)';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirmar contraseña';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Por favor, confirma la contraseña';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Las contraseñas no coinciden';

  @override
  String get sign_up_page_agree_text =>
      'Estoy de acuerdo con las condiciones de Open Food Facts';

  @override
  String get sign_up_page_terms_text =>
      'las condiciones de uso y contribución de Open Food Facts';

  @override
  String get donate_url =>
      'https://world-es.openfoodfacts.org/dar-a-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Al crear una cuenta, es obligatorio aceptar las condiciones de uso. Sin embargo, aún se pueden hacer contribuciones anónimas a través de la aplicación.';

  @override
  String get sign_up_page_producer_checkbox => 'Soy productor/a de alimentos';

  @override
  String get sign_up_page_producer_hint => 'Productor/marca';

  @override
  String get sign_up_page_producer_error_empty =>
      'Por favor, introduce un productor o una marca';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Me gustaría suscribirme al boletín de noticias de Open Food Facts (podrás darte de baja en cualquier momento).';

  @override
  String get sign_up_page_user_name_already_used =>
      'Este nombre de usuario ya existe, por favor, elige uno nuevo.';

  @override
  String get sign_up_page_email_already_exists =>
      'ya existe, inicia sesión en la cuenta o prueba con otro correo electrónico.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Por favor, proporciona una dirección de correo electrónico válida.';

  @override
  String get sign_up_page_server_busy =>
      'Lo sentimos, estamos teniendo algunas dificultades técnicas para crear tu cuenta. Por favor, inténtalo de nuevo más tarde.';

  @override
  String get settingsTitle => 'Configuración';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Oscuro';

  @override
  String get darkmode_light => 'Claro';

  @override
  String get darkmode_system_default => 'Automático';

  @override
  String get thanks_for_contributing => '¡Gracias por tu colaboración!';

  @override
  String get contributors_label =>
      'Estas son las personas que están construyendo la aplicación';

  @override
  String get contributors_dialog_title => 'Colaboradores';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Colaborador/a: $name';
  }

  @override
  String get contributors_description =>
      'Lista de todos los colaboradores de esta aplicación';

  @override
  String get support => 'Soporte';

  @override
  String get support_join_slack => 'Pide ayuda en nuestro canal de Slack';

  @override
  String get support_via_forum => 'Pide ayuda en nuestro foro';

  @override
  String get support_via_email => 'Envíanos un correo electrónico';

  @override
  String get support_via_email_include_logs_dialog_title =>
      '¿Enviar registros de la aplicación?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      '¿Quieres enviar los registros internos de la aplicación como adjunto en tu correo?';

  @override
  String get termsOfUse => 'Condiciones de uso';

  @override
  String get legalNotices => 'Información legal';

  @override
  String get privacy_policy => 'Política de privacidad';

  @override
  String get about_this_app => 'Sobre la aplicación';

  @override
  String get contribute => 'Contribuir';

  @override
  String get contribute_sw_development => 'Desarrollo de software';

  @override
  String get contribute_develop_text =>
      'El código de todos los productos de Open Food Facts está disponible en GitHub. Si quieres, puedes reutilizarlo (es código abierto) o ayudarnos a mejorarlo. Para todos, en todo el planeta.';

  @override
  String get contribute_develop_text_2 =>
      'Puedes unirte al canal de Slack de Open Food Facts, el mejor lugar para resolver tus dudas.';

  @override
  String get contribute_develop_dev_mode_title => '¿Modo desarrollador?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Activa el modo de desarrollador';

  @override
  String get contribute_donate_title => 'Donar';

  @override
  String get contribute_donate_header => 'Dona a Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Ten en cuenta que con la versión alfa interna, es posible la pérdida total de datos, y que la aplicación puede resultar inutilizable en cualquier momento.';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Productos por completar';

  @override
  String get contribute_improve_header => 'Aportar datos';

  @override
  String get contribute_improve_text =>
      'La base de datos es el núcleo del proyecto. Puedes ayudar de manera fácil y muy rápido. Descarga la aplicación en tu teléfono móvil y empieza a añadir productos o a mejorar los que ya están.\n\nPor otro lado, el sitio web de Open Food Facts ofrece muchas maneras de colaborar: ';

  @override
  String get contribute_translate_header => 'Traduce';

  @override
  String get contribute_data_quality => 'Calidad de datos';

  @override
  String get contribute_translate_link_text => 'Empieza a traducir';

  @override
  String get contribute_translate_text =>
      'Open Food Facts es un proyecto global que contiene productos de más de 160 países. Open Food Facts está traducido a docenas de idiomas, y su contenido está en constante evolución.';

  @override
  String get contribute_translate_text_2 =>
      'La traducción es una de las tareas clave del proyecto.';

  @override
  String get contribute_join_skill_pool =>
      'Colabora con tus habilidades en Open Food Facts. ¡Únete al Grupo de Habilidades!';

  @override
  String get contribute_share_header =>
      'Comparte Open Food Facts con tus amigos';

  @override
  String get contribute_share_content =>
      'Me gustaría enseñaros una aplicación que he estado utilizando, Open Food Facts, la cual permite conocer el impacto sobre la salud y el medioambiente de los alimentos que consumimos de una manera personalizada. Funciona escaneado los códigos de barra de los envases de los productos. Además de ser gratuita y de no necesitar registro, podréis colaborar y añadir productos a la base de datos. Aquí os dejo el enlace por si queréis descargarla en vuestro móvil: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribuya con los precios solicitando una exportación del GDPR de los datos de sus tarjetas de fidelización';

  @override
  String get tap_to_answer => 'Toca aquí para responder preguntas';

  @override
  String get tap_to_answer_hint =>
      'Toca aquí para responder preguntas sobre el producto';

  @override
  String get robotoff_questions_loading_hint =>
      'Por favor, espera mientras se cargan las preguntas sobre este producto.';

  @override
  String get saving_answer => 'Guardando tu respuesta';

  @override
  String get contribute_to_get_rewards =>
      'Conviértete en un actor de la transparencia alimentaria';

  @override
  String get question_sign_in_text =>
      'Inicia sesión en tu cuenta de Open Food Facts para obtener reconocimiento por tu colaboración.';

  @override
  String get question_yes_button_accessibility_value => 'Responde con sí';

  @override
  String get question_no_button_accessibility_value => 'Responde con no';

  @override
  String get question_skip_button_accessibility_value => 'Saltar esta pregunta';

  @override
  String get tap_to_edit_search => 'Toca para editar la búsqueda';

  @override
  String get myPreferences => 'Mis preferencias';

  @override
  String get account_create_message =>
      '¡Crea una cuenta y únete a la comunidad de Open Food Facts para ayudar a crear conocimiento sobre los alimentos en todo el mundo!';

  @override
  String get join_us => 'Únete al equipo';

  @override
  String get myPreferences_profile_title => 'Tu perfil';

  @override
  String get myPreferences_profile_subtitle =>
      'Administra tu cuenta de colaborador de Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Ajustes de la aplicación';

  @override
  String get myPreferences_settings_subtitle => 'Modo oscuro, Idiomas…';

  @override
  String get myPreferences_food_title => 'Preferencias alimentarias';

  @override
  String get myPreferences_food_subtitle =>
      'Elige qué tipo de información alimentaria es más importante para ti.';

  @override
  String get myPreferences_food_comment =>
      'Elige qué información alimentaria es la que más te importan para que la aplicación pueda clasificar los alimentos según tus preferencias. Verás la información más relevante primero y obtendrás un resumen de compatibilidad. Esas preferencias alimentarias permanecen en tu dispositivo y no están asociadas a tu cuenta de colaborador de Open Food Facts, si es que la tienes.';

  @override
  String get confirmResetPreferences =>
      '¿Quieres restablecer tus preferencias alimentarias?';

  @override
  String get myPersonalizedRanking => 'Mi clasificación personalizada';

  @override
  String get ranking_tab_all => 'Todo';

  @override
  String get ranking_subtitle_match_yes => 'Una buena opción para ti';

  @override
  String get ranking_subtitle_match_no => 'Muy poco recomendable';

  @override
  String get ranking_subtitle_match_maybe => 'Sin información suficiente';

  @override
  String get refresh_with_new_preferences =>
      'Actualiza la lista con tus nuevas preferencias';

  @override
  String get reloaded_with_new_preferences =>
      'Actualizado con tus nuevas preferencias';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Escanear';

  @override
  String get history_navbar_label => 'Historial';

  @override
  String get list_navbar_label => 'Listas';

  @override
  String get category => 'Filtrar por categoría';

  @override
  String get category_all => 'Todo';

  @override
  String get category_search => '(búsqueda de categorías)';

  @override
  String get filter => 'Filtro';

  @override
  String get scan => 'Productos de la pantalla de escaneo';

  @override
  String get scan_history => 'Historial de escaneo';

  @override
  String get search => 'Buscar';

  @override
  String get search_product_help =>
      'Buscar un producto,\nuna marca o un código de barras';

  @override
  String get search_filter => 'Filtro de búsqueda';

  @override
  String get search_history => 'Historial de búsqueda';

  @override
  String get search_store => 'Buscar una tienda';

  @override
  String get search_store_help => 'Sugerencia: añade la ciudad o el país.';

  @override
  String get tap_for_more => 'Pulsa para ver más información…';

  @override
  String get product => 'Producto';

  @override
  String get unknownBrand => 'Marca desconocida';

  @override
  String get unknownProductName => 'Nombre de producto desconocido';

  @override
  String get label_refresh => 'Actualizar';

  @override
  String get label_reload => 'Recargar';

  @override
  String get image => 'Imagen';

  @override
  String get front_photo => 'Foto frontal';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (esta imagen puede estar desactualizada)';
  }

  @override
  String get outdated_image_short_label => 'puede estar desactualizado';

  @override
  String get ingredients => 'Ingredientes';

  @override
  String get ingredients_editing_instructions =>
      'Mantenga el orden original. Indique el porcentaje cuando se especifique. Separe con una coma o un guion y use paréntesis para los ingredientes.';

  @override
  String get ingredients_editing_error => 'Error al guardar los ingredientes.';

  @override
  String get ingredients_editing_image_error =>
      'No se ha podido obtener una nueva imagen de los ingredientes.';

  @override
  String get ingredients_editing_title => 'Editar ingredientes';

  @override
  String get ingredients_photo => 'Foto de los ingredientes';

  @override
  String get packaging_editing_instructions =>
      'Enumera todas las partes del envase separándolas con una coma o un salto de línea, incluyendo la cantidad (1,3,6…), el formato (botella, caja, lata…), el material (plástico, metal, aluminio…), y si están disponibles, el tamaño (por ejemplo, 33 cl) y las instrucciones de reciclaje.\nEjemplo: 1 botella de vidrio para reciclar, 1 corcho de plástico para tirar';

  @override
  String get packaging_editing_error => 'No se ha podido guardar el envase.';

  @override
  String get packaging_editing_image_error =>
      'No se ha podido obtener una nueva imagen del envase.';

  @override
  String get packaging_editing_title => 'Editar envase';

  @override
  String get nutrition => 'Nutrición';

  @override
  String get nutrition_facts_photo => 'Foto de la información nutricional';

  @override
  String get nutrition_facts_editing_title => 'Editar Información nutricional';

  @override
  String get packaging_information => 'Información sobre el envase';

  @override
  String get packaging_information_photo => 'Foto de la información del envase';

  @override
  String get missing_product => '¡Has encontrado un nuevo producto!';

  @override
  String get add_product_take_photos =>
      'Haz fotos del envase para añadir este producto a Open Food Facts.';

  @override
  String get add_product_take_photos_descriptive =>
      'Por favor, primero haz alguna foto del producto. Más adelante podrás completar la información del producto.';

  @override
  String get add_product_information_button_label =>
      'Agregar información del producto';

  @override
  String get new_product => 'Nuevo producto';

  @override
  String get new_product_found_title => '¡Nuevo producto encontrado!';

  @override
  String get new_product_found_text =>
      'Nuestra base de datos colaborativa contiene más de **3 millones de productos**, pero este código de barras no existe: ';

  @override
  String get new_product_found_button => 'Añadir este producto';

  @override
  String get new_product_leave_title => '¿Desea dejar esta página?';

  @override
  String get new_product_leave_message =>
      'Parece que no has introducido nada. ¿De verdad quieres abandonar esta página?';

  @override
  String get new_product_dialog_description =>
      'Haz fotos del envase para añadir este producto a nuestra base de datos';

  @override
  String get new_product_dialog_illustration_description =>
      'Una ilustración con Nutri-Score y Green-Score desconocidos';

  @override
  String get front_packaging_photo_button_label => 'Foto frontal del producto';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirmar el envío de la foto frontal del producto';

  @override
  String get confirm_button_label => 'Confirmar';

  @override
  String get send_image_button_label => 'Enviar imagen';

  @override
  String get crop_page_action_saving => 'Guardando la imagen…';

  @override
  String get crop_page_action_cropping => 'Recortando imagen…';

  @override
  String get crop_page_action_local => 'Guardando una versión local…';

  @override
  String get crop_page_action_local_failed_title =>
      'Vaya… hay un problema con tu foto.';

  @override
  String get crop_page_action_local_failed_message =>
      'No podemos procesar la imagen localmente, antes de enviarla a nuestro servidor. Por favor, inténtalo de nuevo más tarde o ponte en contacto con nosotros si el problema persiste.';

  @override
  String get crop_page_action_retake => 'Volver a tomar una foto';

  @override
  String get crop_page_too_small_image_title =>
      '¡La imagen es demasiado pequeña!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'El tamaño mínimo para la subida de imágenes es de $expectedMinWidth x $expectedMinHeight. Esta imagen tiene $actualWidth x $actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Preparando la llamada al servidor…';

  @override
  String get front_packaging_photo_title => 'Foto frontal del envase';

  @override
  String get ingredients_photo_title => 'Foto de los ingredientes';

  @override
  String get nutritional_facts_photo_title =>
      'Foto de la información nutricional';

  @override
  String get recycling_photo_title => 'Foto sobre el reciclaje';

  @override
  String get take_photo_title => 'Saca una foto';

  @override
  String get take_more_photo_title => 'Haz más fotos';

  @override
  String get front_photo_uploaded => 'Foto frontal subida';

  @override
  String get ingredients_photo_button_label => 'Foto de los ingredientes';

  @override
  String get ingredients_photo_uploaded => 'Foto de los ingredientes subida';

  @override
  String get nutrition_cache_loading_error =>
      'Imposible cargar los nutrientes desde el caché';

  @override
  String get nutritional_facts_photo_button_label =>
      'Foto de la información nutricional';

  @override
  String get nutritional_facts_input_button_label =>
      'Introducir información nutricional';

  @override
  String get nutritional_facts_added => 'Información nutricional añadida';

  @override
  String get categories_added => 'Categorías añadidas';

  @override
  String get new_product_title_nutriscore => 'Calcular Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Ayúdanos completando la categoría de alimentos y los valores nutricionales.';

  @override
  String get new_product_title_environmental_score => 'Calcular el Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Consíguelo rellenando al menos una categoría';

  @override
  String get new_product_additional_environmental_score =>
      'Haz que el cálculo de Green-Score sea más preciso añadiendo orígenes, envase y más';

  @override
  String get new_product_title_nova =>
      'Calcula el nivel de procesado de los alimentos (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Hazlo rellenando las categorías de alimentos e ingredientes.';

  @override
  String get new_product_desc_nova_unknown =>
      'Nivel de procesado de alimentos desconocido';

  @override
  String get new_product_title_pictures => 'Nuevo producto';

  @override
  String get new_product_title_pictures_details =>
      'Haz las siguientes fotos y el motor de Open Food Facts se ocupará del resto.';

  @override
  String get new_product_title_misc => 'Y algunos datos básicos…';

  @override
  String new_product_done_msg(String username) {
    return '¡Gracias por tu colaboración, $username!';
  }

  @override
  String get new_product_done_msg_no_user => '¡Gracias por tu colaboración!';

  @override
  String get new_product_done_button_label => 'Descubre el producto completo';

  @override
  String get hey_incomplete_product_message =>
      '¡Toque para responder 3 preguntas AHORA para calcular Nutri-Score, Green-Score y Ultraprocesado (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      '¡Toca aquí para responder 2 preguntas para ayudarnos a analizar este cosmético!';

  @override
  String get hey_incomplete_product_message_pet_food => '';

  @override
  String get hey_incomplete_product_message_product =>
      '¡Toca ahora para ayudarnos a completar este producto!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Imagen sobre información nutricional subida';

  @override
  String get recycling_photo_button_label =>
      'Foto de información sobre reciclaje';

  @override
  String get recycling_photo_uploaded => 'Imagen sobre reciclaje subida';

  @override
  String get take_more_photo_button_label => 'Haz más fotos';

  @override
  String get other_photo_uploaded => 'Imagen miscelánea subida';

  @override
  String get retake_photo_button_label => 'Repetir foto';

  @override
  String get selecting_photo => 'Seleccionando foto';

  @override
  String get uploading_image => 'Subiendo imagen al servidor';

  @override
  String get uploading_image_type_front =>
      'Subiendo imagen frontal a Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Subiendo imagen de ingredientes a Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Subiendo imagen sobre nutrientes a Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Subiendo imagen del envase a Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Subiendo otro tipo de imágenes a Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Subiendo imagen a Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Añadir los ingredientes que faltan';

  @override
  String get score_add_missing_packaging_image =>
      'Añadir la imagen del envase que falta';

  @override
  String get score_add_missing_nutrition_facts =>
      'Añadir la información nutricional que falta';

  @override
  String get score_add_missing_product_traces =>
      'Agregar rastros de productos faltantes';

  @override
  String get score_add_missing_product_category => 'Seleccionar una categoría';

  @override
  String get score_add_missing_precise_product_category =>
      'Seleccione una categoría más precisa';

  @override
  String get score_add_missing_product_countries =>
      'Añadir los países de producto que faltan';

  @override
  String get score_add_missing_product_emb =>
      'Añadir los códigos de trazabilidad que faltan';

  @override
  String get score_add_missing_product_labels =>
      'Añadir las etiquetas que faltan';

  @override
  String get score_add_missing_product_origins =>
      'Añadir los orígenes del producto que faltan';

  @override
  String get score_add_missing_product_stores =>
      'Añadir las tiendas que faltan';

  @override
  String get score_add_missing_product_brands =>
      'Agregar marcas de productos faltantes';

  @override
  String get score_update_nutrition_facts =>
      'Actualizar información nutricional';

  @override
  String get nutrition_page_title => 'Información nutricional';

  @override
  String get nutrition_page_nutritional_info_title => 'Información nutricional';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Valores especificados en el producto:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Sí';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Abrir foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Buenas prácticas: Información nutricional';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'A veces, la información nutricional **no se especifica en el envase** ni en el documento que acompaña al producto. En este caso, y solo en este caso, puede establecer el valor en **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'Valores nutricionales:';

  @override
  String get nutrition_page_per_100g => 'por 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'por 100g/ml';

  @override
  String get nutrition_page_per_serving => 'por porción';

  @override
  String get nutrition_page_add_nutrient => 'Añadir un nutriente';

  @override
  String get nutrition_page_serving_size => 'Tamaño de la porción';

  @override
  String get nutrition_page_serving_size_hint =>
      'Introduce el tamaño de la ración (ej: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Buenas prácticas: Tamaño de la porción';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Este valor ayuda a **realizar un cálculo proporcional de cada nutriente por porción**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Las unidades permitidas** son: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** o **60 G** (preferiblemente la primera)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** o **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unidad no válida';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unidades no válidas';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **caramelos** y 2 **galletas**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unidad faltante';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Número inválido';

  @override
  String get nutrition_page_update_running =>
      'Actualizando el producto en el servidor…';

  @override
  String get nutrition_page_update_done => '¡Producto actualizado!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Utilice la cantidad del producto como tamaño de la porción.';

  @override
  String get nutrition_page_photo_error => 'No se pudo cargar la foto';

  @override
  String get more_photos => 'Más fotos interesantes';

  @override
  String get view_more_photo_button => 'Ver todas las fotos de este producto';

  @override
  String get no_product_found => 'No se ha encontrado ningún producto';

  @override
  String get no_location_found => 'No se ha encontrado ninguna ubicación';

  @override
  String get not_found => 'no se ha encontrado:';

  @override
  String get refreshing_product => 'Actualizando producto';

  @override
  String get product_refreshed => 'Producto actualizado';

  @override
  String product_image_accessibility_label(String date) {
    return 'Imagen tomada el $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Imagen tomada el $date. Esta imagen puede estar desactualizada';
  }

  @override
  String get product_image_outdated => 'Esta imagen puede estar desactualizada';

  @override
  String get product_image_outdated_explanations_title =>
      'Esta imagen puede estar desactualizada';

  @override
  String get product_image_outdated_explanations_content =>
      'Esta imagen se tomó hace más de un año.\n**Por favor, compruebe que sigue estando actualizada**.\n\nEsto es **solo una advertencia**. Si el contenido sigue siendo el mismo, puede ignorar este mensaje.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Reemplazar foto ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Añadir una foto ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Nueva captura';

  @override
  String get product_image_action_take_picture => 'Saca una foto';

  @override
  String get product_image_action_from_gallery =>
      'Selecciona de la galería de tu teléfono';

  @override
  String get product_image_action_choose_existing_photo =>
      'Seleccione entre las fotos del producto';

  @override
  String get product_image_details_label => 'Información sobre la foto';

  @override
  String get product_image_details_from_producer => 'Del productor';

  @override
  String get product_image_details_contributor => 'Colaborador/a';

  @override
  String get product_image_details_contributor_producer =>
      'Colaborador (productor)';

  @override
  String get product_image_details_date => 'Fecha';

  @override
  String get product_image_details_date_unknown => 'Desconocido';

  @override
  String get homepage_main_card_logo_description =>
      'Bienvenida a Open Food Facts∫';

  @override
  String get homepage_main_card_subheading =>
      '**Escanee** un código de barras o\n**busque** un producto';

  @override
  String get homepage_main_card_search_field_hint => 'Buscar un producto';

  @override
  String get homepage_main_card_search_field_tooltip => 'Iniciar búsqueda';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Últimas noticias: $news_title';
  }

  @override
  String get tagline_app_review => '¿Te gusta la aplicación?';

  @override
  String get tagline_app_review_button_positive => '¡Me encanta! 😍';

  @override
  String get tagline_app_review_button_negative => 'No mucho…';

  @override
  String get tagline_app_review_button_later => 'Pregúntame más tarde';

  @override
  String get tagline_feed_news_button => 'Más información';

  @override
  String get app_review_negative_modal_title =>
      '¿No te gusta nuestra aplicación?';

  @override
  String get app_review_negative_modal_text => '¿Nos podrías explicar por qué?';

  @override
  String get app_review_negative_modal_positive_button => '¡Sí, por supuesto!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'No se ha podido actualizar el producto';

  @override
  String get product_internet_error_modal_title => '¡Se ha producido un error!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'No podemos obtener información sobre este producto debido a un error de red. Compruebe su conexión a internet e inténtelo de nuevo.\n\nError interno:\n$error';
  }

  @override
  String get product_tags_title => 'Propiedades del producto';

  @override
  String get no_product_tags_found_message =>
      'No se han encontrado propiedades del producto. Las mismas se pueden utilizar para describir los productos con más detalle, de una manera más flexible.';

  @override
  String get product_tags_empty => 'Sin propiedades';

  @override
  String get product_tags_explanation =>
      'Al agregar propiedades (clave/valor) a un producto, ayudas a enriquecerlo.';

  @override
  String get add_tag => 'Añadir una propiedad';

  @override
  String get add_tags => 'Añadir propiedades';

  @override
  String get add_edit_tags => 'Añadir o modificar propiedades';

  @override
  String get edit_tag => 'Editar propiedad';

  @override
  String get remove_tag => 'Eliminar propiedad';

  @override
  String get tag_key => 'Propiedad';

  @override
  String get tag_keys => 'Propiedades';

  @override
  String get tag_key_uneditable => 'Propiedad (no editable)';

  @override
  String get tag_key_input_hint => 'Ingrese una propiedad';

  @override
  String get tag_value => 'Valor';

  @override
  String get tag_values => 'Valores';

  @override
  String get tag_value_input_hint => 'Ingrese un valor';

  @override
  String get tag_key_item => 'Propiedad:';

  @override
  String get tag_value_item => 'Valor:';

  @override
  String get tag_key_explanations =>
      'La clave debe estar en minúsculas y sin espacios.';

  @override
  String tag_key_already_exists(String property) {
    return '¡Ya existe una etiqueta con una propiedad $property!';
  }

  @override
  String get product_internet_error =>
      'Imposible obtener información sobre este producto debido a un error de red.';

  @override
  String get cached_results_from => 'Mostrar resultados de:';

  @override
  String get product_search_same_category => 'Encuentra alternativas';

  @override
  String get product_search_same_category_short => 'Comparar';

  @override
  String get product_search_same_category_error =>
      'Esta función solo está disponible para productos con categoría.\n\nEdita el producto para añadir una categoría.';

  @override
  String get product_improvement_add_category =>
      'Añade una categoría para calcular la puntuación Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Añade la información nutricional para calcular la puntuación Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Añade una categoría y la información nutricional para calcular la puntuación de Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'No se ha podido calcular la puntuación Nutri-Score para este producto. Esto puede deberse a que, por ejemplo, una categoría no es estándar. Si crees que es un error, por favor, ponte en contacto con nosotros.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'La imagen nutricional está obsoleta: por favor, actualízala.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'El Green-Score tiene en cuenta el origen de los ingredientes. Haz una foto de los ingredientes o a cualquier indicio geográfico y edita el producto para que se tengan en cuenta estos datos.';

  @override
  String get country_chooser_label => 'Elige un país';

  @override
  String get currency_chooser_label => 'Por favor, elija una moneda';

  @override
  String get country_change_message => 'Acabas de cambiar de país.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return '¿Quieres cambiar la moneda de $previousCurrency a $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Por favor, elige un país:';

  @override
  String get country_chooser_label_from_settings => 'Tu país';

  @override
  String get country_selection_explanation =>
      'Algunas características ambientales son específicas de tu ubicación geográfica';

  @override
  String get product_removed_comparison =>
      'Producto eliminado de la comparación';

  @override
  String get native_app_settings => 'Configuración de la aplicación nativa';

  @override
  String get native_app_description =>
      'Abrir configuración del sistema de Open Food Facts';

  @override
  String get product_removed_history => 'Producto eliminado del historial';

  @override
  String get product_removed_list => 'Producto eliminado de la lista';

  @override
  String get product_could_not_remove => 'No se ha podido eliminar el producto';

  @override
  String get no_prodcut_in_list => 'No hay ningún producto en esta lista';

  @override
  String get no_product_in_section => 'No hay ningún producto en esta sección';

  @override
  String get recently_seen_products => 'Todos los productos visualizados';

  @override
  String get clear => 'Limpiar';

  @override
  String get clear_long => 'Vaciar la lista';

  @override
  String get really_clear => '¿Realmente quieres eliminar esta lista?';

  @override
  String pct_match(Object percent) {
    return 'coincide un $percent %';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'hace $count días',
      one: 'hace un día',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'hace $count horas',
      one: 'hace una hora',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'hace $count minutos',
      one: 'hace un minuto',
      zero: 'hace menos de un minuto',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'hace $count meses',
      one: 'hace un mes',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'hace $count semanas',
      one: 'hace una semana',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Comparar $count productos',
      one: 'Comparar un producto',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count productos seleccionados',
      one: 'Un producto seleccionado',
      zero: 'Ningún producto seleccionado',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Comparar productos seleccionados';

  @override
  String get delete_products_mode => 'Eliminar productos seleccionados';

  @override
  String get select_all_products_mode => 'Seleccionar todos los productos';

  @override
  String get select_none_products_mode => 'Quitar selección';

  @override
  String get compare_products_appbar_title => 'Comparar productos';

  @override
  String get compare_products_appbar_subtitle =>
      'Por favor, selecciona al menos dos productos';

  @override
  String get retry_button_label => 'Reintentar';

  @override
  String get connect_with_us => 'Contáctanos';

  @override
  String get tiktok => 'Síguenos en TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Síguenos en Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Síguenos en X (anteriormente Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Síguenos en Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Síguenos en BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Preguntas frecuentes';

  @override
  String get discover => 'Descubrir';

  @override
  String get how_to_contribute => 'Cómo colaborar';

  @override
  String get hint_knowledge_panel_message =>
      'Puedes tocar en cualquier parte de la tarjeta para obtener más detalles sobre lo que ves. ¡Pruébalo!';

  @override
  String get permissions_page_title => 'Acceso a la cámara';

  @override
  String get permissions_page_body1 =>
      'Para poder escanear los códigos de barras con la cámara de tu móvil, primero tienes que autorizar el acceso.';

  @override
  String get permissions_page_body2 =>
      'En cualquier caso, recuerda que si cambias de opinión, puedes activar y desactivar esta opción desde la configuración cuando quieras.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'SO: Android (SDK Int: $sdkInt / Lanzamiento: $release)\nModelo: $model\nProducto: $product\nDispositivo: $device\nMarca: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'SO: iOS ($version)\nModelo: $model\nModelo localizado: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersión de la aplicación: $appVersion\nNúmero de compilación de la aplicación: $appBuildNumber\nNombre del paquete de la aplicación: $appPackageName';
  }

  @override
  String get authorize_button_label => 'Autorizar';

  @override
  String get refuse_button_label => 'Rechazar';

  @override
  String get ask_me_later_button_label => 'Más adelante';

  @override
  String get are_you_sure => '¿De verdad?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Obtener más información en $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => '¡Bienvenido!';

  @override
  String get onboarding_home_welcome_text2 =>
      '¡La app que te ayuda a elegir alimentos buenos para **ti** y para el **planeta**!';

  @override
  String get onboarding_continue_button => 'Continuar';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Cargando tu primer producto de ejemplo';

  @override
  String get onboarding_welcome_warning =>
      'Lo sentimos, es nuestro producto de ejemplo, no puede editarlo :)';

  @override
  String get product_list_your_ranking => 'Tu clasificación';

  @override
  String get product_list_empty_icon_desc => 'Historial no disponible';

  @override
  String get product_list_empty_title => 'Empieza a escanear';

  @override
  String get product_list_empty_message =>
      'Los productos escaneados aparecerán aquí y podrás consultar la información detallada sobre ellos';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'varios productos',
      one: 'un producto',
      zero: '0 productos',
    );
    return 'Actualizando $_temp0 de tu historial';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'varios productos',
      one: 'un producto',
      zero: '0 productos',
    );
    return 'Actualización completa de $_temp0.';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Descargando datos';

  @override
  String get loading_dialog_default_error_message =>
      'No se han podido descargar los datos';

  @override
  String get account_delete => 'Eliminar cuenta';

  @override
  String get account_delete_title => 'Eliminar mi cuenta';

  @override
  String get user_profile => 'Cuenta';

  @override
  String get user_profile_title_guest => '¡Te damos la bienvenida!';

  @override
  String get user_profile_subtitle_guest =>
      'Inicia sesión o regístrate para unirte a la comunidad de Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Inicio de sesión en Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return '¡Te damos la bienvenida, $id!';
  }

  @override
  String get email_subject_account_deletion => 'Eliminar cuenta';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hola, me gustaría eliminar mi cuenta de Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplicación';

  @override
  String get settings_app_data => 'Privacidad y monitorización';

  @override
  String get settings_app_camera => 'Cámara';

  @override
  String get settings_app_products => 'Productos';

  @override
  String get settings_app_miscellaneous => 'Miscelánea';

  @override
  String get camera_play_sound_title => 'Reproducir un sonido al escanear';

  @override
  String get camera_play_sound_subtitle =>
      'Pitará cada vez que se escanee correctamente';

  @override
  String get camera_window_accessibility_label =>
      'Escanea un código de barras con la cámara';

  @override
  String get app_haptic_feedback_title => 'Vibración y respuesta táctil';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrar después de realizar algunas acciones (código de barras decodificado, producto eliminado…).';

  @override
  String get crash_reporting_toggle_title => 'Informe de fallos';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Al activarlo, los informes de errores se enviarán automáticamente al sistema de seguimiento de Open Food Facts para que podamos corregirlos y mejorar la aplicación.';

  @override
  String get send_anonymous_data_toggle_title => 'Enviar datos anónimos';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Al activarlo, se enviarán algunos datos sobre el uso de la aplicación a los servidores de Open Food Facts para que podamos entender cómo y cuánto se utiliza cada función y así poder mejorarlas.';

  @override
  String get product_edit_photo_title => 'Editar foto';

  @override
  String get permission_photo_error => 'Error';

  @override
  String get permission_photo_denied_title =>
      'Permitir el uso de la cámara para escanear códigos de barras';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Para disfrutar de una mejor experiencia, permite que $appName acceda a tu cámara. Así podrás escanear los códigos de barras directamente.';
  }

  @override
  String get permission_photo_denied_button => 'Permitir';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Permiso dengado';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Como ya habías denegado el acceso a la cámara, tendrás que permitirlo manualmente desde la Configuración.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Abrir configuración';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Cancelar';

  @override
  String get permission_photo_none_found => 'Cámara no detectada';

  @override
  String get permission_photo_denied => 'Acceso a la cámara denegado';

  @override
  String get show_product_pictures => 'Mostrar imágenes del producto';

  @override
  String get edit_product_label => 'Editar producto';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Subiendo tus ediciones…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Tus ediciones están siendo **enviadas a un segundo plano** (o más tarde en caso de error). Puedes continuar editando otros campos del producto.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Tus ediciones están siendo **enviadas en segundo plano** (o más tarde en caso de error).';

  @override
  String get edit_product_label_short => 'Editar';

  @override
  String edit_product_form_item_help(String value) {
    return '¿Cómo introducir \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      '¡Por favor ingrese un valor!';

  @override
  String get edit_product_form_item_error_existing => '¡Este valor ya existe!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Añadir una nueva marca';

  @override
  String get edit_product_form_item_add_action_label =>
      'Agregar una nueva etiqueta';

  @override
  String get edit_product_form_item_add_action_store =>
      'Añadir una nueva tienda';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Agregar un nuevo origen';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Agregar un nuevo código de trazabilidad';

  @override
  String get edit_product_form_item_add_action_country =>
      'Añadir un nuevo país';

  @override
  String get edit_product_form_item_add_action_category =>
      'Agregar una nueva categoría';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Agregar un nuevo rastro';

  @override
  String get edit_product_form_item_add_suggestion => 'Añadir una sugerencia';

  @override
  String get edit_product_form_item_deny_suggestion => 'Rechazar sugerencia';

  @override
  String get edit_product_form_item_details_title => 'Detalles básicos';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nombre del producto, marca, cantidad';

  @override
  String get edit_product_form_item_other_details_title =>
      'Detalles adicionales';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Sitio web…';

  @override
  String get edit_product_form_item_photos_title => 'Fotos';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Añadir o actualizar fotos';

  @override
  String get edit_product_form_item_labels_title => 'Etiquetas y certificados';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Sellos ambientales, de calidad…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Ingrese una etiqueta (por ejemplo: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'sello';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Buenas prácticas: Etiquetas';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Cualquier característica del producto **que sea objetiva** y diferente de los demás campos.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Hecho en Bélgica, producido en Bretaña…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rico en fibra, fuente de hierro…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Comercio justo, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Tiendas';

  @override
  String get edit_product_form_item_stores_hint => 'Ingrese una tienda';

  @override
  String get edit_product_form_item_stores_type => 'tienda';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Buenas prácticas: Tiendas';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Indique la tienda donde compró el producto.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Orígenes';

  @override
  String get edit_product_form_item_origins_hint =>
      'Ingrese un origen (por ejemplo: Alemania)';

  @override
  String get edit_product_form_item_origins_type => 'país';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Buenas prácticas: Orígenes';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Añade **cualquier indicación de origen que encuentres en el envase**.\nNo te preocupes por los orígenes indicados directamente en la lista de ingredientes.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Carne de vaca de Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'La soja no procede de la Unión Europea';

  @override
  String get edit_product_form_item_countries_title => 'País';

  @override
  String get edit_product_form_item_countries_hint =>
      'Ingrese un país (por ejemplo: Alemania)';

  @override
  String get edit_product_form_item_countries_type => 'país';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Buenas prácticas: Países';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Países donde el producto está ampliamente disponible** (sin incluir tiendas especializadas en productos extranjeros).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Códigos de trazabilidad';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Ingrese un código (por ejemplo EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANTE 522...)';

  @override
  String get edit_product_form_item_emb_codes_type => 'código de trazabilidad';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Buenas prácticas: Códigos de trazabilidad';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'En esta sección, puede introducir códigos relacionados con **marcas de embalaje**, **marcas de identificación** o **marcas sanitarias**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Ejemplos de códigos de trazabilidad';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Códigos CE** utilizados en la Comunidad Europea para identificar a los productores o envasadores de alimentos:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: código de país de **Francia**\n**72.264.002**: datos geográficos\n**CE**: Comunidad Europea';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Códigos EMB** usados en Francia:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Trazas';

  @override
  String get edit_product_form_item_traces_hint => 'traza';

  @override
  String get edit_product_form_item_traces_type =>
      'Introduzca un tipo de traza (ej.: Soja)';

  @override
  String get edit_product_form_item_categories_title => 'Categorías';

  @override
  String get edit_product_form_item_categories_hint => 'categoría';

  @override
  String get edit_product_form_item_categories_type =>
      'Ingrese una categoría (por ejemplo: jugo de naranja)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Buenas prácticas: Categorías';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indique **solo la categoría más específica**.\nLas categorías superiores se añadirán automáticamente.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      '¿Falta alguna categoría?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Si una categoría **no está disponible en el autocompletado**, puedes agregarla igualmente.\nEsto nos ayudará a mejorar Open Food Facts en tu país.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardinas en aceite de oliva';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Zumo de naranja a partir de concentrado';

  @override
  String get edit_product_form_item_exit_title => '¿Salir sin guardar?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      '¿Deseas guardar los cambios antes de salir de esta página?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Guardar cambios';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Descartar cambios';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredientes';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Acercar y alejar pellizcando la pantalla';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Acercar y alejar la foto';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Utilizando el gesto de **pellizcar para hacer zoom**, puedes acercar o alejar la foto:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Añadir';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Primero escribe algo';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Eliminar';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Guarda tu edición';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancela tu edición';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto sobre instrucciones de reciclaje';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Información nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutrición, contenido en alcohol…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Buenas prácticas: Información nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Valores nutricionales';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Primero, seleccione si **se proporcionan los valores**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Información nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'A continuación, introduce los valores nutricionales **tal y como se indican en el envase**. Si no aparece ningún valor, puedes hacer clic en el icono del ojo.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Campo vacío?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Si falta una entrada, puede **hacer clic en el icono \"Más\"** para agregarla (ej.: vitamina D, magnesio…).';

  @override
  String get edit_product_form_save => 'Editar';

  @override
  String get edit_product_ingredients_photo_title => 'Foto de los ingredientes';

  @override
  String get edit_product_ingredients_list_title =>
      'de la lista de ingredientes;';

  @override
  String get edit_product_packaging_photo_title => 'Foto del embalaje';

  @override
  String get edit_product_packaging_list_title => 'Lista del embalaje';

  @override
  String get no_data_available => 'Sin datos disponibles';

  @override
  String get product_field_website_title => 'Sitio web';

  @override
  String get origins_editing_title => 'Editar Orígenes';

  @override
  String get completed_basic_details_btn_text =>
      'Completa los detalles básicos';

  @override
  String get not_implemented_snackbar_text => 'Aún sin implementar';

  @override
  String get category_picker_page_appbar_text => 'Categorías';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extrae los ingredientes de la foto';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extraer ingredientes';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extrayendo ingredientes\nde la foto';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Cargando foto…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      '¿Por qué veo este mensaje?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Para usar la función \"Extraer ingredientes\", primero debe subir la foto.\n\nEspere unos segundos o introdúzcalos manualmente.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Actualizar foto';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extraiga el embalaje\nde la foto';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extracto del embalaje';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extrayendo el embalaje de la foto';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Cargando foto…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      '¿Por qué veo este mensaje?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Para usar la función \"Extraer embalaje\", primero debe subir la foto.\n\nEspere unos segundos o introdúzcalos manualmente.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Actualizar foto';

  @override
  String get edit_ocr_extract_failed => 'Error al detectar texto en la imagen.';

  @override
  String get edit_ocr_extract_disabled_title => 'Sin imagen!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Para poder utilizar la función de extracción de texto, primero debe tomar una foto.';

  @override
  String get user_list_dialog_new_title => 'Nueva lista de productos';

  @override
  String get user_list_dialog_rename_title => 'Renombrar la lista';

  @override
  String get user_list_subtitle_product => 'Listas';

  @override
  String get user_list_title => 'Tus listas';

  @override
  String get user_list_add_product => 'Añade el producto a tus listas';

  @override
  String get user_list_button_new => 'Crear una nueva lista';

  @override
  String get user_list_empty_label =>
      'No hay ninguna lista disponible, puedes crear una.';

  @override
  String get user_list_button_add_product => 'Añadir a la lista';

  @override
  String get added_to_list_msg => 'Añadido a la lista';

  @override
  String get user_list_popup_clear => 'Limpiar tu historial';

  @override
  String get user_list_popup_rename => 'Renombrar';

  @override
  String get user_list_name_hint => 'Mi lista';

  @override
  String get user_list_name_error_empty => 'El nombre es obligatorio';

  @override
  String get user_list_name_error_already => 'Este nombre ya está en uso';

  @override
  String get user_list_name_error_same => 'Es el mismo nombre';

  @override
  String get user_list_name_input_hint => 'Nombre de la lista';

  @override
  String get try_again => 'Inténtalo de nuevo';

  @override
  String get there_was_an_error => 'Ha ocurrido un error';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'No se ha encontrado ninguna categoría para $items';
  }

  @override
  String get camera_toggle_camera =>
      'Cambia entre la cámara frontal y la trasera';

  @override
  String get camera_toggle_flash => 'Activa o desactiva el flash de la cámara';

  @override
  String get camera_enable_flash => 'Activar flash';

  @override
  String get camera_disable_flash => 'Desactivar flash';

  @override
  String get camera_flash_error_dialog_title => '¡Ha ocurrido un error!';

  @override
  String get camera_flash_error_dialog_message =>
      'Ha ocurrido un error al cambiar el estado del flash. Asegúrate que tu móvil no tenga la linterna encendida.';

  @override
  String get category_picker_no_category_found_button => 'Regresar';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Haz clic para abrir en el navegador o en la aplicación (si está instalada)';

  @override
  String get dev_preferences_screen_title => 'Modo de desarrollador';

  @override
  String get dev_preferences_screen_subtitle =>
      'Acceda a funciones experimentales y herramientas de desarrollo';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Reiniciar incorporación';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Después, tendrás que reiniciar la aplicación para verlo de nuevo.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Cambiar entre openfoodfacts.org (PROD) y el entorno de pruebas';

  @override
  String get dev_preferences_test_environment_title =>
      'Parámetros del entorno de pruebas';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL base para el entorno de pruebas actual: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Alojamiento del entorno de pruebas';

  @override
  String get dev_preferences_ml_kit_title => 'Usar ML kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'tendrás que reiniciar esta aplicación';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Botón adicional en la página del producto';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Editar ingredientes a través de un botón del panel de conocimiento';

  @override
  String get dev_preferences_export_history_title => 'Exportar historial';

  @override
  String get dev_preferences_export_history_progress_error => 'excepción';

  @override
  String get dev_preferences_export_history_progress_found =>
      'producto encontrado';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'producto no encontrado';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Exportar historial';

  @override
  String get dev_preferences_button_positive => 'Aceptar';

  @override
  String get dev_preferences_button_negative => 'Cancelar';

  @override
  String get dev_preferences_migration_title => 'Migración de datos desde V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Estado: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'éxito o nueva instalación';

  @override
  String get dev_preferences_migration_status_success => 'éxito';

  @override
  String get dev_preferences_migration_status_error => 'error';

  @override
  String get dev_preferences_migration_status_in_progress => 'en curso';

  @override
  String get dev_preferences_migration_status_required =>
      'necesario (clic para comenzar)';

  @override
  String get dev_preferences_migration_status_not_started => 'desconocido';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Se limpiará el historial y se pondrán 3 productos ahí';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL personalizada para noticias';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL del archivo JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'No establecido';

  @override
  String get dev_preferences_news_provider_status_title => 'Estado';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Última actualización: $date';
  }

  @override
  String get product_type_label_food => 'Alimento';

  @override
  String get product_type_label_beauty => 'Cuidado personal';

  @override
  String get product_type_label_pet_food => 'Alimento para mascotas';

  @override
  String get product_type_label_product => 'Otro';

  @override
  String get product_type_selection_title => 'Tipo de producto';

  @override
  String get product_type_selection_subtitle =>
      'Seleccione el tipo de este producto';

  @override
  String get product_type_selection_empty =>
      '¡Primero debes seleccionar un tipo de producto!';

  @override
  String product_type_selection_already(String productType) {
    return '¡No puedes cambiar el tipo de producto ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Acceso directo a la aplicación Prices en la página del producto';

  @override
  String get prices_app_button => 'Ir a la aplicación Prices';

  @override
  String get prices_website_button => 'Abierto en el sitio web de Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Añade etiquetas de precio directamente desde la galería';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Una vez que hayas seleccionado las imágenes, ¡no podrás editarlas!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Permitir que la comunidad valide los precios extraídos por IA.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Varias etiquetas de precio';

  @override
  String get prices_bulk_proof_upload_title => 'Carga masiva de pruebas';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Seleccionar archivos';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Iniciando la carga';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copiando localmente el archivo #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Preparando carga #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Error en la imagen #$index/$count';
  }

  @override
  String get prices_generic_title => 'Precios';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Añadir $count precios',
      one: 'Añadir un precio',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Enviar $count precios',
      one: 'Enviar el precio',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Añadir artículo';

  @override
  String get prices_add_a_price => 'Añadir un precio';

  @override
  String get prices_add_a_receipt => 'Añadir un recibo';

  @override
  String get prices_add_price_tags => 'Añadir etiqueta de precio';

  @override
  String prices_barcode_already(String barcode) {
    return '¡El código de barras ($barcode) ya está en la lista!';
  }

  @override
  String get prices_barcode_search_not_found => 'Producto no encontrado';

  @override
  String get prices_barcode_search_none_yet => 'Aún no hay producto';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Buscando $barcode';
  }

  @override
  String get prices_barcode_enter => 'Introducir el código de barras';

  @override
  String get prices_category_enter => 'Artículo sin código de barras';

  @override
  String get prices_per_kilogram => 'Precio por kilogramo';

  @override
  String get prices_per_unit => 'Precio por unidad';

  @override
  String get prices_per_kilogram_short => ' / kilogramo';

  @override
  String get prices_per_unit_short => ' / unidad';

  @override
  String get prices_category_mandatory => 'Necesario';

  @override
  String get prices_category_optional => 'Opcional';

  @override
  String get prices_category_error_mandatory => 'La categoría es obligatoria';

  @override
  String get prices_barcode_reader_action => 'Lector de código de barras';

  @override
  String get prices_view_prices => 'Ver precios';

  @override
  String get prices_list_title => 'Lista de precios';

  @override
  String get prices_list_count => 'Número de\nprecios';

  @override
  String get prices_list_add_new_price => 'Añade un nuevo precio de\n';

  @override
  String get prices_list_empty_title => '¡Aún no hay precio!';

  @override
  String get prices_list_empty_subtitle =>
      '¡Sé el primero en agregar uno:\nEscaneando un **recibo** o una **etiqueta de precio**!';

  @override
  String get prices_entry_shop_not_found => 'Tienda desconocida';

  @override
  String prices_entry_menu_title(String user) {
    return 'Precio de entrada desde \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Ver todos los precios de este producto';

  @override
  String get prices_entry_menu_open_proof => 'Ver prueba';

  @override
  String get prices_entry_menu_my_prices => 'Ver mis otros precios';

  @override
  String get prices_entry_menu_author_prices => 'Ver otros precios del autor';

  @override
  String get prices_entry_menu_shop_prices => 'Ver otros precios en la tienda';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count precios',
      one: '1 precio',
    );
    return '$_temp0 para $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Todos los $count precios',
      one: 'Solo un precio',
      zero: 'Sin precio aún',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Últimos precios $pageSize (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Precio: $price / Tienda: \"$location\" / Publicado el $date por \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Abrir comprobantes de \"$user\"';
  }

  @override
  String get prices_open_proof => 'Abrir comprobante de precio';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Todas las $count pruebas',
      one: 'Solo una prueba',
      zero: 'Aún no hay prueba',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Últimas $pageSize pruebas (total: $total)';
  }

  @override
  String get prices_users_empty_title => '¡Aún no hay colaboradores!';

  @override
  String get prices_users_empty_explanation =>
      '¡Sé el primero en añadir un precio!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Principales $pageSize colaboradores (total: $total)';
  }

  @override
  String get prices_locations_empty_title => '¡Aún no hay tienda!';

  @override
  String get prices_locations_empty_explanation =>
      '¡Sé el primero en añadir un precio!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Las mejores $pageSize ubicaciones (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Pruebas',
      one: 'Una prueba',
      zero: 'Sin prueba',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count productos',
      one: 'Un producto',
      zero: 'Ningún producto',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count usuarios',
      one: 'Un usuario',
      zero: 'Ningún usuario',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count precios',
      one: 'Un precio',
      zero: 'Sin precio',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Precio previamente añadido';

  @override
  String get prices_amount_subtitle => 'Cantidad';

  @override
  String get prices_amount_is_discounted => '¿Está rebajado?';

  @override
  String get prices_amount_price_normal => 'Precio';

  @override
  String get prices_amount_price_discounted => 'Precio con descuento';

  @override
  String get prices_amount_price_not_discounted => 'Precio original';

  @override
  String get prices_amount_no_product => '¡Falta un producto!';

  @override
  String get prices_amount_price_incorrect => 'Valor incorrecto';

  @override
  String get prices_amount_price_mandatory => 'Valor obligatorio';

  @override
  String get prices_currency_subtitle => 'Moneda';

  @override
  String get prices_date_subtitle => 'Fecha';

  @override
  String get prices_location_subtitle => 'Comercio';

  @override
  String get prices_location_find => 'Encuentra una tienda';

  @override
  String get prices_location_mandatory => '¡Debes seleccionar una tienda!';

  @override
  String get prices_location_search_broader =>
      '¿No encontraste lo que buscabas? ¡Intentemos una búsqueda más amplia!';

  @override
  String get prices_proof_subtitle => 'Comprobante';

  @override
  String get prices_proof_empty_title => '¡Aún no hay pruebas!';

  @override
  String get prices_proof_empty_explanation =>
      '¡Comienza agregando una foto de un **recibo** o una **etiqueta de precio**!';

  @override
  String get prices_proof_find => 'Seleccione una prueba';

  @override
  String get prices_proof_change => 'Prueba de cambio';

  @override
  String get prices_proof_receipt => 'Ticket';

  @override
  String get prices_proof_price_tag => 'Etiqueta de precio';

  @override
  String get prices_proof_mandatory => '¡Debes seleccionar una prueba!';

  @override
  String get prices_add_validation_error => 'Error de validación';

  @override
  String get prices_privacy_warning_title => 'Aviso de privacidad';

  @override
  String get prices_unknown_product => 'Producto desconocido';

  @override
  String get prices_privacy_warning_main_message =>
      'Los precios **serán públicos**, junto con la tienda a la que se refieren.\n\nEsto podría permitir que las personas que conocen tu seudónimo en Open Food Facts puedan:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Deducir en qué zona vives';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Saber lo que compras';

  @override
  String get prices_privacy_warning_sub_message =>
      'Si no te sientes cómodo con eso, por favor cambia tu seudónimo o crea una nueva cuenta de Open Food Facts e inicia sesión con ella.';

  @override
  String get i_refuse => 'Rechazar';

  @override
  String get i_accept => 'Aceptar';

  @override
  String get prices_currency_change_proposal_title => '¿Cambiar la moneda?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Tu moneda actual es **$currency**. ¿Quieres cambiarla a **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Sí, usar $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'No, mantén $currency';
  }

  @override
  String get prices_menu_know_more => 'Saber más sobre Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Hecho';

  @override
  String get dev_mode_section_server => 'Configuración del servidor';

  @override
  String get dev_mode_section_news => 'Configuración del proveedor de noticias';

  @override
  String get dev_mode_section_product_page => 'Página del producto';

  @override
  String get dev_mode_section_ui => 'Interfaz de usuario';

  @override
  String get dev_mode_section_experimental_features =>
      'Funciones experimentales';

  @override
  String get dev_mode_hide_environmental_score_title => 'Excluir Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Utilice un corrector ortográfico para las pantallas OCR.';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredientes y envase)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Restablecer el idioma de la aplicación';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Añadir tarjetas';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Cambiar entre prices.openfoodfacts.org (PROD) y el entorno de prueba';

  @override
  String get search_history_item_edit_tooltip =>
      'Reutilizar y editar esta búsqueda';

  @override
  String get search_history_item_remove_tooltip => 'Eliminar';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Has descargado todos los $totalSize productos.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Descargar $count productos más.\nSe han descargado $downloaded de $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Tu búsqueda de $search está en progreso.\n\nEspera unos segundos…';
  }

  @override
  String get user_search_contributor_title => 'Productos que he añadido';

  @override
  String get user_search_informer_title => 'Productos que he editado';

  @override
  String get user_search_photographer_title => 'Productos que he fotografiado';

  @override
  String get user_search_to_be_completed_title => 'Mis productos por completar';

  @override
  String get user_search_prices_title => 'Mis precios';

  @override
  String get user_search_proofs_title => 'Mis pruebas';

  @override
  String get user_search_proof_title => 'Mi comprobante';

  @override
  String search_proof_title(String user) {
    return 'Prueba de \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Precios de los colaboradores: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Últimos precios añadidos';

  @override
  String get all_search_prices_top_user_title =>
      'Principales contribuyentes de precio';

  @override
  String get all_search_prices_top_location_title =>
      'Tiendas con los precios más altos';

  @override
  String get prices_contribution_assistant =>
      'Asistente de contribución de precios';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Desafíos';

  @override
  String get prices_multiple_proof_addition_system =>
      'Agregar múltiples pruebas';

  @override
  String get all_search_prices_top_location_single_title =>
      'Precios en una tienda';

  @override
  String get all_search_prices_top_product_title =>
      'Productos con los precios más altos';

  @override
  String get all_search_to_be_completed_title =>
      'Todos los productos por completar';

  @override
  String get categorize_products_country_title =>
      'Ayuda a categorizar productos en tu país';

  @override
  String get edit_product_action_retake_picture => 'Volver a sacar la foto';

  @override
  String get edit_product_action_take_picture => 'Sacar foto';

  @override
  String get edit_product_action_confirm => 'Confirmar';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Estoy de acuerdo con las condiciones de Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'las condiciones de uso y contribución de Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'Icono de análisis';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Error fatal: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Error fatal: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Completa los detalles básicos';

  @override
  String get edit_photo_button_label => 'Editar';

  @override
  String get edit_photo_unselect_button_label => 'Deseleccionar la foto';

  @override
  String get edit_photo_select_existing_button_label =>
      'Seleccionar una imagen existente';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Seleccione una imagen haciendo clic en ella.';

  @override
  String get edit_photo_select_existing_download_label =>
      'Recuperando imágenes existentes…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'No existen imágenes anteriores relacionadas con este producto.';

  @override
  String get edit_photo_language_not_this_one =>
      'No hay imágenes en ese idioma';

  @override
  String get edit_photo_language_none => 'Todavía no hay imágenes';

  @override
  String get category_picker_screen_title => 'Categorías';

  @override
  String get basic_details => 'Detalles básicos';

  @override
  String get product_name => 'Nombre del producto';

  @override
  String get product_names => 'Nombres de productos';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Añadir una nueva traducción';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Antes de validar, asegúrese de añadir una traducción solo **si el idioma está presente en el envase**.';

  @override
  String get add_basic_details_product_name_open_photo => 'Ver foto frontal';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Toma una foto frontal';

  @override
  String get add_basic_details_product_name_hint =>
      'Ingrese el nombre del producto (por ejemplo: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      '¿Cambiar el idioma predeterminado?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return '¿Quieres que el idioma predeterminado del producto se establezca en \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Buenos ejemplos';

  @override
  String get explanation_section_bad_examples => 'Malos ejemplos';

  @override
  String get add_basic_details_product_name_help_title =>
      'Buenas prácticas: Nombre del producto';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'El nombre del producto es el **nombre principal impreso en el envase**. Puede ser una marca registrada.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Nota:** Por favor, no añada una traducción **si el idioma no está presente en el embalaje**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Kétchup de tomate';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'No incluyas la marca en el nombre';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Kétchup de tomate **de Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'No utilice los símbolos ®, ™, © o similares.';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik®';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count otras traducciones',
      one: '$count otra traducción',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nombre de la marca';

  @override
  String get brand_names => 'Nombres de la marca';

  @override
  String get add_basic_details_brand_name_error =>
      'Por favor, introduce el nombre de la marca';

  @override
  String get add_basic_details_brand_names_hint =>
      'Ingrese las marcas (por ejemplo Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Buenas prácticas: Marcas';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Ingrese **todas las marcas del producto**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Marca principal';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'La **marca principal**, que generalmente se muestra claramente en el envase frontal, debe **introducirse primero**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Otras marcas';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Cuando se vende **por una gran empresa**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** es vendido por **Danone**.';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Cuando se vende con su marca **traducida a varios idiomas**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** a veces se escribe **Val Nature**.';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Cantidad y peso';

  @override
  String get add_basic_details_quantity_hint =>
      'Ingrese el peso y si es necesario la cantidad (por ejemplo: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Buenas prácticas: Cantidad';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copie el valor indicado en el producto y **no olvide las unidades**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** o **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (por 6 huevos)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(para un producto con 3 cajas, cada una de 150 g)';

  @override
  String get barcode => 'Código de barras';

  @override
  String barcode_barcode(String barcode) {
    return 'Código de barras: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Código de barras no válido';

  @override
  String get basic_details_add_success => 'Detalles básicos añadidos con éxito';

  @override
  String get basic_details_add_error =>
      'No se han podido añadir los aspectos básicos. Vuelve a intentarlo en un rato.';

  @override
  String get clear_search => 'Limpiar tu búsqueda';

  @override
  String get confirm_clear =>
      'Estás a punto de eliminar todo tu historial, ¿seguro que deseas continuar?';

  @override
  String get alert_clear_selected_user_list =>
      'Estás a punto de eliminar los ítems seleccionados de tu historial.';

  @override
  String get confirm_clear_selected_user_list =>
      '¿Seguro que deseas continuar?';

  @override
  String get alert_select_items_to_clear =>
      'Selecciona uno o más ítems para eliminar.';

  @override
  String confirm_clear_user_list(String name) {
    return 'Estás a punto de eliminar esta lista ($name), ¿seguro que deseas continuar?';
  }

  @override
  String get confirm_delete_user_list_title => '¿Eliminar la lista?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Estás a punto de eliminar la lista «$name», ¿seguro que deseas continuar?';
  }

  @override
  String get confirm_delete_user_list_button => 'Sí, seguro';

  @override
  String importance_label(String name, String id) {
    return 'Importancia de $name: $id';
  }

  @override
  String get user_list_all_title => 'Listas';

  @override
  String get user_list_all_empty => 'Crea tu primera lista';

  @override
  String get product_list_select => 'Selecciona una lista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count productos',
      one: 'Un producto',
      zero: 'Lista vacía',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Añadir lista';

  @override
  String get open_food_preferences_tooltip =>
      'Edita tus preferencias alimentarias';

  @override
  String get add_photo_button_label => 'Añadir foto';

  @override
  String get add_packaging_photo_button_label =>
      'Saca fotos de cualquier información del envase/reciclaje';

  @override
  String get add_origin_photo_button_label =>
      'Toma fotos de cualquier información del envase';

  @override
  String get add_emb_photo_button_label =>
      'Toma fotos de cualquier información del código de trazabilidad';

  @override
  String get add_label_photo_button_label =>
      'Tomar fotos de cualquier etiqueta e información de certificaciones';

  @override
  String get choose_image_source_title => 'Elegir fuente de la imagen';

  @override
  String get choose_image_source_body =>
      'Por favor, elige la fuente de la imagen';

  @override
  String get gallery_source_label => 'Galería';

  @override
  String get gallery_source_access_denied_dialog_title => 'Acceso denegado';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Lamentablemente, la aplicación no puede acceder a tu galería porque previamente le has denegado el permiso.\n\nVe a la configuración de la aplicación en tu teléfono móvil en Ajustes → Fotos';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Abrir la configuración';

  @override
  String get share => 'Compartir';

  @override
  String share_product_text(String url) {
    return 'Echa un vistazo a este producto en Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Echa un vistazo a este producto en Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Echa un vistazo a este producto en Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Echa un vistazo a este producto en Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Echa un vistazo a mi lista de productos en Open Food Facts: $url';
  }

  @override
  String get capture => 'Nueva captura';

  @override
  String get capture_new_picture => 'Saca una foto';

  @override
  String get choose_from_gallery => 'Seleccionar de la galería';

  @override
  String get image_upload_queued =>
      'La imagen se cargará en segundo plano tan pronto como sea posible.';

  @override
  String get add_price_queued =>
      'El precio se enviará al servidor lo antes posible.';

  @override
  String get background_task_title_full_refresh =>
      'Iniciando la actualización de todos los productos almacenados localmente';

  @override
  String get background_task_title_top_n =>
      'Iniciando la descarga de los productos más populares';

  @override
  String get expand_nutrition_facts =>
      'Expandir la tabla de información nutricional';

  @override
  String get expand_nutrition_facts_body =>
      'Mantener expandida la tabla de información nutricional';

  @override
  String get expand_ingredients => 'Expandir ingredientes';

  @override
  String get expand_ingredients_body =>
      'Mantener expandido el panel de ingredientes';

  @override
  String get no_internet_connection => 'No hay conexión a internet';

  @override
  String get world_results_label => 'Todo el mundo';

  @override
  String get world_results_action => 'Amplía tu búsqueda al mundo entero';

  @override
  String get copy_to_clipboard => 'Copiar';

  @override
  String get paste_from_clipboard => 'Pegar desde el portapapeles';

  @override
  String get no_data_available_in_clipboard =>
      'No hay datos disponibles en el portapapeles.';

  @override
  String get clipboard_barcode_copy =>
      'Copiar código de barras al portapapeles';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return '¡Código de barras $barcode copiado al portapapeles!';
  }

  @override
  String get open_product_website => 'Abre este producto en el sitio web';

  @override
  String get language_picker_label => 'Tu idioma';

  @override
  String get country_picker_label => 'Tu país';

  @override
  String get currency_picker_label => 'Tu moneda';

  @override
  String get help_with_openfoodfacts => 'Ayuda con OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'El producto se actualizará en segundo plano lo antes posible.';

  @override
  String get no_email_client_available_dialog_title =>
      '¡No hay aplicaciones de correo elecrtrónico!';

  @override
  String get no_email_client_available_dialog_content =>
      'Por favor envíanos un correo electrónico a mobile@openfoodfacts.org';

  @override
  String get all_images => 'Todas las imágenes';

  @override
  String get selected_images => 'Imágenes seleccionadas';

  @override
  String get product_card_remove_product_tooltip => 'Eliminar producto';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nuevo código de barras escaneado: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Borrar todos los productos del carrusel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Escanea por lo menos dos productos para poder compararlos.';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Haz clic para comparar los productos que has escaneado.';

  @override
  String get scan_product_loading => 'Has escaneado\nel código de barras:';

  @override
  String get scan_product_loading_initial =>
      '¡Estamos buscando este producto!\nPor favor, espera unos segundos…';

  @override
  String get scan_product_loading_long_request =>
      'Seguimos buscando el producto.\n¿Te parece que tarda mucho? A nosotros también…';

  @override
  String get scan_product_loading_unresponsive =>
      'Todavía estamos buscando el producto.\n¿Te gustaría realizar de nuevo la búsqueda?';

  @override
  String get scan_product_loading_restart_button => 'Reiniciar la búsqueda';

  @override
  String get portion_calculator_description =>
      'Calcula información nutricional para una cantidad específica';

  @override
  String get portion_calculator_hint => 'Cantidad';

  @override
  String get portion_calculator_accessibility =>
      'Introduce una cantidad para calcular la información nutricional';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Por favor, introduce una cantidad entre $min y $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Datos faltantes. No se pudo realizar el cálculo.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Información nutricional por $grams g (o ml)';
  }

  @override
  String get offline_data => 'Datos sin conexión';

  @override
  String get ocr_image_upload_instruction =>
      'Sube una imagen para extraer automáticamente la información que contiene.';

  @override
  String get upload_image => 'Subir foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Error al descargar la imagen';

  @override
  String get image_edit_url_error =>
      'No se ha podido editar la imagen porque la URL de la imagen no está configurada.';

  @override
  String get user_picture_source_remember => 'Recordar mi elección';

  @override
  String get user_picture_source_ask => 'Pregunta cada vez';

  @override
  String get robotoff_continue => 'Continuar';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 's $count preguntas',
      one: ' pregunta',
    );
    return 'Próxima$_temp0';
  }

  @override
  String get show_password => 'Mostrar contraseña';

  @override
  String get owner_field_info_title =>
      'Valores proporcionados por el productor';

  @override
  String get owner_field_info_message =>
      'Con ese logotipo resaltamos los datos proporcionados por el productor, y que estos podrían no ser editables.';

  @override
  String get owner_field_info_close_button => 'Cerrar esta información';

  @override
  String get owner_field_image =>
      'Esta imagen la proporciona el productor. No se puede editar.';

  @override
  String get edit_packagings_title => 'Componentes del envase';

  @override
  String get edit_packagings_element_add => 'Añadir un componente del envase';

  @override
  String get edit_packagings_completed => 'El envase está completo';

  @override
  String edit_packagings_element_title(int index) {
    return 'Componente del envase #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Número de unidades';

  @override
  String get edit_packagings_element_hint_units =>
      'Introduce el número de unidades de envases con el mismo formato y material.';

  @override
  String get edit_packagings_element_field_shape => 'Formato';

  @override
  String get edit_packagings_element_hint_shape =>
      'Introduce los formatos indicados en las instrucciones de reciclaje, si están disponibles, o selecciona un formato.';

  @override
  String get edit_packagings_element_example_shape => 'Botella';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Si es posible, introduce el material específico, muchas veces, el código del material viene indicado dentro de un triángulo en el envase. Si tienes dudas, puedes introducir un material genérico (por ejemplo, plástico o metal).';

  @override
  String get edit_packagings_element_example_material => 'Vidrio';

  @override
  String get edit_packagings_element_field_recycling =>
      'Instrucciones de reciclaje';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Introduce las instrucciones de reciclaje solo si aparecen en el producto.';

  @override
  String get edit_packagings_element_example_recycling => 'Reciclar';

  @override
  String get edit_packagings_element_field_quantity =>
      'Cantidad neta de producto por unidad';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Introduce el peso neto o el volumen neto y el tipo de unidad (por ejemplo, g o ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Peso de una unidad vacía (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Elimina cualquier resto de alimento y lava y seca el envase antes de pesarlo. Si es posible, usa una báscula con 0,1 g o 0,01 g de precisión.';

  @override
  String get background_task_title => 'Contribuciones pendientes';

  @override
  String get background_task_subtitle =>
      'Tus contribuciones se guardan automáticamente en nuestro servidor, pero no siempre se hace en tiempo real.';

  @override
  String get background_task_list_empty =>
      'No hay tareas pendientes en segundo plano';

  @override
  String get background_task_error_server_time_out =>
      'Tiempo de espera del servidor';

  @override
  String get background_task_error_no_internet =>
      'Error de conexión a Internet. Inténtalo más tarde.';

  @override
  String get background_task_operation_unknown =>
      'tipo de operación desconocida';

  @override
  String get background_task_operation_details => 'cambios detallados';

  @override
  String get background_task_operation_image => 'subir foto';

  @override
  String get background_task_operation_refresh =>
      'actualización retrasada después de cargar la foto';

  @override
  String get background_task_run_started => 'iniciado';

  @override
  String get background_task_run_not_started => 'todavía no se ha iniciado';

  @override
  String get background_task_run_to_be_deleted => 'para ser eliminado';

  @override
  String get background_task_question_stop =>
      '¿Quieres detener esa tarea lo antes posible?';

  @override
  String get feed_back => 'Sugerencias';

  @override
  String get undo => 'Deshacer';

  @override
  String get copy_email_to_clip_board =>
      'Copiar el correo electrónico al portapapeles';

  @override
  String get please_send_us_an_email_to =>
      'Por favor, envíanos un correo electrónico a';

  @override
  String get email_copied_to_clip_board =>
      '¡Correo electrónico copiado al portapapeles!';

  @override
  String get select_accent_color => 'Selecciona el color de énfasis';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Azul';

  @override
  String get color_cyan => 'Cian';

  @override
  String get color_green => 'Verde';

  @override
  String get color_light_brown => 'Predeterminado';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Naranja';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Rojo';

  @override
  String get color_rust => 'Naranja rojizo';

  @override
  String get color_teal => 'Verde azulado';

  @override
  String get text_contrast_mode => 'Contraste de texto';

  @override
  String get contrast_high => 'Alto';

  @override
  String get contrast_medium => 'Medio';

  @override
  String get contrast_low => 'Bajo';

  @override
  String get product_refresher_internet_not_found =>
      '¡No se ha encontrado el producto!';

  @override
  String get product_refresher_internet_not_connected =>
      '¡No estás conectado a internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Servidor inactivo ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Error del servidor ($exception)';
  }

  @override
  String get product_loader_not_found_title =>
      '¡No se ha encontrado el producto!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'No existe un producto con este código de barras en nuestra base de datos: $barcode';
  }

  @override
  String get product_loader_network_error_title => '¡Sin conexión a internet!';

  @override
  String get product_loader_network_error_message =>
      'Comprueba que tu teléfono móvil está conectado a una red wifi o tiene los datos móviles habilitados.';

  @override
  String get page_not_found_title => '¡No se ha encontrado la página!';

  @override
  String get page_not_found_button => 'Volver a la página de inicio';

  @override
  String get download_data => 'Descargar datos';

  @override
  String get download_top_products =>
      'Descarga los 1000 productos mejor valorados de tu país para escanearlos al instante.';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'los $count productos mejor valorados',
      one: 'el producto mejor valorado',
    );
    return 'Descarga $_temp0 de tu país para escanear al instante.';
  }

  @override
  String get download_in_progress =>
      'Descargando datos.\nPuede tardar un poco.';

  @override
  String downloaded_products(int num) {
    return '$num productos añadidos';
  }

  @override
  String get update_offline_data =>
      'Actualizar datos del producto sin conexión';

  @override
  String get update_local_database_sub =>
      'Actualiza la base de datos local de productos con los últimos datos de Open Food Facts.';

  @override
  String get clear_local_database => 'Eliminar datos del producto sin conexión';

  @override
  String get clear_local_database_sub =>
      'Elimina todos los datos de productos locales de tu aplicación para liberar espacio.';

  @override
  String deleted_products(int num) {
    return '$num productos eliminados';
  }

  @override
  String get loading => 'Cargando…';

  @override
  String get know_more => 'Más información';

  @override
  String get offline_data_desc =>
      'Haz clic para obtener más información sobre los datos sin conexión.';

  @override
  String get offline_product_data_title => 'Datos sin conexión del producto';

  @override
  String available_for_download(int num) {
    return '$num productos disponibles para escanear inmediatamente';
  }

  @override
  String get country_selector_title => 'Selecciona tu país:';

  @override
  String get currency_selector_title => 'Seleccione su moneda:';

  @override
  String get language_selector_title => 'Selecciona tu idioma:';

  @override
  String get language_selector_section_selected => 'Idiomas seleccionados';

  @override
  String get language_selector_section_frequently_used => 'Uso frecuente';

  @override
  String get action_delete_list => 'Eliminar';

  @override
  String get action_change_list => 'Cambiar la lista acual';

  @override
  String get product_list_create => 'Crear';

  @override
  String get product_list_create_tooltip => 'Crear una nueva lista';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Puntuación Nutri-Score $letter (Nuevo cálculo)';
  }

  @override
  String get nutriscore_new_formula_title =>
      'Puntuación Nutri-Score (Nuevo cálculo)';

  @override
  String get nutriscore_unknown => 'Nutri-Score desconocido';

  @override
  String get nutriscore_unknown_new_formula =>
      'Puntuación Nutri-Score desconocida (Nuevo cálculo)';

  @override
  String get nutriscore_not_applicable =>
      'No es posible aplicar el Nutri-Score';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'El Nutri-Score no es aplicable (Nuevo cálculo)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Puntuación verde A';

  @override
  String get environmental_score_b_new => 'Puntuación verde B';

  @override
  String get environmental_score_c_new => 'Puntuación verde C';

  @override
  String get environmental_score_d_new => 'Puntuación verde D';

  @override
  String get environmental_score_e_new => 'Puntuación verde E';

  @override
  String get environmental_score_unknown_new => 'Puntuación verde desconocida';

  @override
  String get environmental_score_not_applicable_new =>
      'El Green-Score no es aplicable';

  @override
  String get nova_group_generic_new =>
      'Alimentos ultraprocesados - Grupos NOVA';

  @override
  String get nova_group_1 => 'Grupo NOVA 1';

  @override
  String get nova_group_2 => 'Grupo NOVA 2';

  @override
  String get nova_group_3 => 'Grupo NOVA 3';

  @override
  String get nova_group_4 => 'Grupo NOVA 4';

  @override
  String get nova_group_unknown => 'Grupo NOVA desconocido';

  @override
  String get nutrition_facts => 'Niveles de nutrientes';

  @override
  String get faq_title_partners => 'Socios y patrocinadores de la ONG';

  @override
  String get faq_title_vision =>
      'Visión, misión, valores y programas de Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Instala Open Beauty Facts para crear una base de datos sobre cosmética';

  @override
  String get faq_title_install_pet =>
      'Instala Open Pet Food Facts para crear una base de datos sobre alimentación para mascotas';

  @override
  String get faq_title_install_product =>
      'Instala Open Products Facts para crear una base de datos sobre productos del día a día';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nuevo cálculo del Nutri-Score: ¿cuáles son las novedades?';

  @override
  String get contact_title_pro_page =>
      '¿Eres profesional? Importa tus productos a Open Food Facts';

  @override
  String get contact_title_pro_email => 'Contacto para productores';

  @override
  String get contact_title_press_page => 'Página de prensa';

  @override
  String get contact_title_press_email => 'Contacto para prensa';

  @override
  String get contact_title_newsletter => 'Suscríbete a nuestro boletín';

  @override
  String get contact_title_calendar =>
      'Suscríbete a nuestro calendario comunitario';

  @override
  String get hunger_games_loading_line1 => 'Por favor, dennos unos segundos…';

  @override
  String get hunger_games_loading_line2 =>
      '¡Estamos descargando las preguntas!';

  @override
  String get hunger_games_error_label =>
      '¡Vaya! Algo ha salido mal… No hemos podido cargar las preguntas.';

  @override
  String get hunger_games_error_retry_button => '¡Vamos a intentarlo de nuevo!';

  @override
  String get reorder_attribute_action => 'Reorganizar los atributos';

  @override
  String get link_cant_be_opened =>
      'Este enlace no se puede abrir en tu dispositivo. Comprueba que tienes un navegador instalado.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detalles para $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detalles para $pageName con $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Compartir';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      '¿Qué es el Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      '¿Dónde encontrar el nuevo cálculo Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'El Nutri-Score se aplica en 7 países: Francia, Alemania, Bélgica, España, Luxemburgo, Países Bajos y Suiza.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Los fabricantes tienen como máximo **2 años** después de la firma del decreto **para reemplazar** el cálculo antiguo por el nuevo.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      '¿Qué es el Green Score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'El Green-Score es un logotipo que tiene como objetivo informarle sobre el **impacto ambiental de los alimentos**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'El código de color varía desde el verde oscuro (**A+**) para los productos **menos impactantes** hasta el rojo oscuro (**F**) para los productos **más impactantes**.';

  @override
  String get guide_greenscore_logos_caption => 'Los logotipos de Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'El núcleo: Análisis del ciclo de vida (ACV)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Una evaluación científica de las categorías de alimentos';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Para cada categoría de producto, se establece una puntuación de referencia utilizando datos de la base de datos ambiental Agribalyse (diseñada por ADEME e INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      'El **análisis del ciclo de vida** es un método de evaluación estandarizado para llevar a cabo una evaluación ambiental de múltiples etapas y criterios múltiples.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Mide:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 pasos de producción';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agricultura';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Procesado';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Envase';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transporte';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribución';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumo';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicadores de impacto ambiental';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Cambio climático/huella de carbono';

  @override
  String get guide_greenscore_lca_arg3_text2 =>
      'Agotamiento de la capa de ozono';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiación ionizante';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Tierra';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Uso del agua y la energía';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Contaminación del aire';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Agua marina y dulce (partículas, acidificación, eutrofización)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Agotamiento de recursos.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonificaciones y penalizaciones';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Para premiar los mejores productos dentro de una categoría, aplicamos **bonificaciones y penalizaciones basadas en varios criterios**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Modo de producción';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Se otorga una **bonificación** a los productos que tengan una **etiqueta oficial, una etiqueta o una certificación que garantice beneficios ambientales** (orgánico, comercio justo, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origen de los ingredientes';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Se otorga una **bonificación** en función del origen de los ingredientes. Esta bonificación tiene en cuenta el **impacto del transporte** y la **política medioambiental** de cada país productor.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Especies en peligro';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Se impone una **penalización** a los productos que contienen ingredientes que tienen impactos negativos significativos en la biodiversidad y los ecosistemas, como el aceite de palma, cuya producción es responsable de una deforestación masiva.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Envase';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Se calcula una **penalización** para tener en cuenta la **circularidad del embalaje** (uso de materia prima reciclada y reciclabilidad) y el sobreembalaje.';

  @override
  String get guide_greenscore_transparency_title =>
      'Una mayor necesidad de transparencia para medir mejor y reducir los impactos ambientales';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Para calcular con precisión el Green-Score, es necesario disponer de **información que no necesariamente figura en el envase** (como el origen y el porcentaje exacto de cada ingrediente) o que rara vez está disponible en un formato utilizable (como una lista de todos los componentes del envase con los tipos precisos de plásticos utilizados).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Se utilizan valores promedio cuando esta información aún no está disponible**, pero ahora hacemos un llamado a todos para que nos ayuden a recopilar esta información, que será muy útil para el Green-Score, pero también para muchos otros usos.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      '¿Cómo pueden ayudar los ciudadanos?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Todos los ciudadanos pueden ayudarnos a recopilar y estructurar la información que figura en los productos o que puede deducirse de ellos, como la información sobre el **envase**: \"Mission Emballages\": un inventario colaborativo a gran escala de los envases de todos los productos alimenticios (en francés).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Cómo pueden ayudar los fabricantes';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Los fabricantes pueden enviarnos su información directamente a través de nuestra plataforma gratuita para productores.';

  @override
  String get guide_greenscore_better_product_title =>
      '¿Qué producto es mejor para el planeta?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Puede ser difícil decirlo';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Elegir alimentos sustentables es una de las cosas más poderosas que podemos hacer por el clima, ya que **nuestro sistema alimentario global es responsable de más de una cuarta parte de todas las emisiones de gases de efecto invernadero**.\n(Fuente: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => '¡Tienes el poder!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'La buena noticia es que esto nos da una manera poderosa de crear cambios.\n**Cada uno de nosotros come alrededor de 1.000 comidas al año**. ¡Son 1.000 oportunidades para **elegir un futuro mejor para el planeta**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Ayuda a ser responsable y decidir.';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Elegir alimentos sostenibles puede parecer complejo. Las etiquetas son confusas y a menudo falta información. El Green-Score se creó para simplificarlo, ofreciéndote una calificación ambiental **clara**, **con base científica** y **transparente** para productos alimenticios, justo donde la necesitas: mientras compras.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparencia';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'A diferencia de las etiquetas propietarias, el cálculo de Green-Score es **completamente abierto** y puede ser **verificado por cualquier persona**.';

  @override
  String get guide_nova_title => 'Alimentos ultraprocesados';

  @override
  String get guide_nova_what_is_nova_title => '¿Qué es el ultraprocesamiento?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Los grupos NOVA te informan sobre el nivel de procesamiento de los alimentos.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'La clasificación NOVA permite categorizar los alimentos en **4 grupos** en función de su **grado de procesamiento industrial** (alimentos mínimamente procesados o no procesados, ingredientes culinarios, alimentos procesados, alimentos ultraprocesados).';

  @override
  String get guide_nova_logos_caption => 'Los logotipos de NOVA';

  @override
  String get guide_nova_groups_title => 'Los 4 grupos NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Hay cuatro grupos NOVA, siendo el problemático el Grupo 4: Alimentos ultraprocesados.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Alimentos mínimamente procesados o sin procesar';

  @override
  String get guide_nova_groups_arg1_text =>
      'Los alimentos no procesados (o naturales) son las **partes comestibles de las plantas** (semillas, frutos, hojas, tallos, raíces) **o de los animales** (músculo, vísceras, huevos, leche), así como los hongos, las algas y el agua, después de ser separados de la naturaleza.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Ingredientes culinarios procesados';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through Processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Alimentos procesados';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. Processes include various Preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three Ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination With other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Alimentos ultraprocesados';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations Usually include Those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of Energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, Whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Los problemas con el ultraprocesamiento';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Procesamiento extremo de ingredientes alimentarios';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Muchos de ellos **se derivan del procesamiento posterior de componentes alimentarios**, como aceites hidrogenados o interesterificados, proteínas hidrolizadas, aislado de proteína de soja, maltodextrina, azúcar invertido y jarabe de maíz de alta fructosa.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aditivos que van más allá de la mera seguridad alimentaria';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Los aditivos en los alimentos ultraprocesados incluyen algunos que también se utilizan en alimentos procesados, como conservantes, antioxidantes y estabilizantes. Entre las clases de aditivos que se encuentran únicamente en productos ultraprocesados se incluyen aquellos que se utilizan para imitar o mejorar las cualidades sensoriales de los alimentos o para enmascarar aspectos desagradables del producto final. Estos aditivos incluyen colorantes y otros estabilizadores del color; saborizantes, potenciadores del sabor, edulcorantes no azucarados; y coadyuvantes tecnológicos como agentes carbonatantes, reafirmantes, de carga y antiespumantes, antiaglomerantes, antiaglomerantes y agentes de glaseado, emulsionantes, secuestrantes y humectantes.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Procesamiento que no puedes hacer en casa';

  @override
  String get guide_nova_explanations_arg3_text =>
      'Se emplea una multitud de secuencias de procesos para combinar los numerosos ingredientes y crear el producto final (de ahí el término «ultraprocesado»). Estos procesos incluyen varios que no tienen equivalentes nacionales, como la hidrogenación e hidrólisis, la extrusión y el moldeo, y el preprocesamiento para freír.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Los aspectos depredadores y financieros del ultraprocesamiento';

  @override
  String get guide_nova_explanations_arg4_text =>
      'El objetivo principal del ultraprocesamiento es crear alimentos de marca, prácticos (duraderos y listos para consumir), atractivos (hiperpalatables) y altamente rentables (con ingredientes de bajo costo), diseñados para desplazar a todos los demás grupos de alimentos. Los alimentos ultraprocesados suelen tener envases atractivos y se comercializan de forma intensiva.';

  @override
  String get guide_nova_explanations_arg5_title => 'Un riesgo para la salud';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Los países recomiendan limitarlos.';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Algunos países utilizan los grupos NOVA para sus guías o metas dietéticas; por ejemplo:\n\n- Las guías dietéticas de **🇧🇷 Brasil** recomiendan limitar el consumo de alimentos procesados y evitar los ultraprocesados.\n\n- Los objetivos de la política nutricional de salud pública de **🇫🇷 Francia** para el período 2018-2022 buscan reducir el consumo de alimentos ultraprocesados del grupo 4 en un 20 %.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => '¡Bienvenidos a Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      '¿Qué es Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts es una base de datos **colaborativa**, **gratuita** y **abierta** de productos alimenticios de todo el mundo.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Creemos que todos deberían tener acceso a información sobre lo que comen. Al recopilar datos sobre ingredientes, alérgenos, información nutricional y más, **empoderamos a los consumidores para que tomen decisiones informadas** e impulsamos a la industria alimentaria **hacia una mayor transparencia**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Características de Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Reciba alertas sobre ingredientes no deseados.';

  @override
  String get guide_open_food_facts_tips_title =>
      'Consejos para tomar fotos estupendas';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'No hacer';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Evite las sombras y los reflejos.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Sin texto borroso o desenfocado.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'No recortes partes del texto.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Evita fondos recargados.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Qué hacer';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Utilice una iluminación buena y uniforme.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Asegúrese de que el texto sea nítido y legible.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Anota la lista completa de ingredientes.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Mantenga el producto sobre una superficie plana.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Ayúdanos a construir la \"Wikipedia de la comida\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Una puntuación sobre la calidad nutricional';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Una puntuación para evitar los alimentos ultraprocesados';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Una puntuación para el planeta';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-es.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      '¡Bienvenidos a Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      '¿Qué es Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      '¡Open Pet Food Facts extiende nuestra misión a nuestros amigos peludos! Es una **base de datos de productos alimenticios para mascotas para gatos, perros y otros animales de compañía**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Recopilamos información sobre **ingredientes**, **análisis nutricional** y pautas de alimentación para ayudar a los dueños de mascotas a elegir el mejor alimento para las necesidades de sus animales.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Características de Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Reciba alertas sobre ingredientes no deseados.';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      '¿Tu mascota es alérgica a algún ingrediente? ¡Puedes crear una lista de ingredientes cosméticos que debes evitar, directamente en la app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Consejos para tomar fotos estupendas';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'No hacer';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Evite las sombras y los reflejos.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Sin texto borroso o desenfocado.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'No recortes partes del texto.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Evita fondos recargados.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Qué hacer';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Utilice una iluminación buena y uniforme.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Asegúrese de que el texto sea nítido y legible.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Anota la lista completa de ingredientes.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Mantenga el producto sobre una superficie plana.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Nota sobre la puntuación';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Desarrollar un sistema de puntuación para alimentos para mascotas **no es una prioridad en este momento**. La metodología sería compleja, ya que las necesidades nutricionales varían mucho según la especie, la edad y el estado de salud. Todavía no hemos encontrado ningún equipo científico independiente capaz de desarrollar dicha puntuación.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-es.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      '¡Bienvenidos a Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      '¿Qué es Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts es una base de datos colaborativa de **productos cosméticos**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Nuestro objetivo es descifrar las listas de ingredientes para ayudarte a **entender qué contienen tus productos de cuidado personal**. Desde cremas hidratantes hasta maquillaje, recopilamos datos sobre ingredientes, alérgenos y envases para promover la transparencia en la industria cosmética.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Características de Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Reciba alertas sobre ingredientes no deseados.';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      '¿Eres alérgico a algún ingrediente? ¿Quieres evitar sustancias comedogénicas? ¿Quieres alejarte de componentes controvertidos? ¡Puedes crear una lista de ingredientes cosméticos que deseas evitar, directamente en la app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Consejos para tomar fotos estupendas';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'No hacer';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Evite las sombras y los reflejos.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Sin texto borroso o desenfocado.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'No recortes partes del texto.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Evita fondos recargados.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Qué hacer';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Utilice una iluminación buena y uniforme.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Asegúrese de que el texto sea nítido y legible.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Anota la lista completa de ingredientes.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Si la botella es curva, tome todas las fotos que necesite.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Es posible que tengas que despegar la etiqueta para ver la lista de ingredientes.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Mantenga el producto sobre una superficie plana.';

  @override
  String get guide_open_beauty_facts_scores_title => 'Nota sobre la puntuación';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'A diferencia de los productos alimenticios, el mundo de la cosmética **no cuenta con un sistema de puntuación universalmente reconocido y avalado por el gobierno como el Nutri-Score**. Los efectos de los ingredientes pueden ser muy personales y dependen del tipo de piel, las alergias y las necesidades individuales.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-es.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => '¡Bienvenidos a Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      '¿Qué es Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices es un proyecto para recopilar y compartir precios de productos de todo el mundo. Se trata de un conjunto de datos de acceso público que puede utilizarse para investigación, análisis y mucho más. Open Prices es desarrollado y mantenido por Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Actualmente son pocas las empresas que poseen grandes bases de datos de precios de productos a nivel de código de barras. Estos precios no están disponibles libremente, pero se venden a un alto precio a actores privados, investigadores y otras organizaciones que pueden pagarlos.';

  @override
  String get guide_open_prices_how_title => '¿Cómo funciona Open Prices?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      'Estamos creando un conjunto de datos de precios de código abierto mediante colaboración colectiva. Los usuarios pueden añadir precios a través de esta aplicación web o de la aplicación móvil oficial de Open Food Facts. Los minoristas y las aplicaciones de terceros también pueden contribuir utilizando nuestra API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Recopilar fotos de las etiquetas de precio en los pasillos';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Recopila fotos de los recibos.';

  @override
  String get guide_open_prices_why_title =>
      '¿Por qué Open Food Facts hace esto?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'La información sobre precios es fundamental para comprender los sistemas alimentarios. Es un factor clave para entender el costo de los alimentos y promover dietas más saludables. El acceso abierto a los datos de precios facilita que investigadores, periodistas y ciudadanos comprendan mejor cómo varían los precios de los alimentos geográficamente y a lo largo del tiempo.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Realice un seguimiento de la evolución de los precios a lo largo del tiempo.';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Observa la **evolución de los precios**: inflación por reducción, inflación por abaratamiento, ¡podemos seguirlas juntas!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compara precios cerca de ti';

  @override
  String get guide_open_prices_why_arg2_text =>
      'A medida que obtengamos más precios, podrás identificar **las tiendas más baratas de tu zona**.';

  @override
  String get guide_open_prices_scrapping_title =>
      '¿Consideraste extraer los precios de los sitios web de los minoristas?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Por motivos legales y técnicos, **no consideramos que extraer precios de los sitios web de los minoristas sea una forma válida de contribuir a Open Prices**. Queremos asegurarnos de que los precios que recopilamos sean precisos y estén actualizados, y recibir precios extraídos de los colaboradores no nos permite hacerlo.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'La extracción de precios es una opción que se está considerando en una versión futura de Open Prices, pero la realizaría la propia Open Prices para que podamos tener una prueba del precio basada en la página HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'Soy un distribuidor y quiero contribuir con los precios. ¿Cómo puedo hacerlo?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Puedes aportar precios utilizando nuestra API.\nSi deseas aportar precios a gran escala, ponte en contacto con nosotros en prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      '¡Bienvenidos a Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      '¿Qué son los datos de productos abiertos?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts es una base de datos masiva y abierta para **cualquier producto con código de barras, que no sea alimento, cosmético o comida para mascotas**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Desde **dispositivos electrónicos** hasta **juguetes**, y desde **ropa** hasta **productos de limpieza**, si tiene un código de barras, se puede añadir. Este proyecto busca crear un \"Internet de las Cosas\" para los objetos cotidianos, haciendo que la información sobre ellos sea universalmente accesible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Características de los productos abiertos';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts tiene como objetivo proporcionar a los consumidores soluciones circulares para **extender la vida útil de los objetos**, permitiéndoles mantener, **reparar**, **reciclar** sus objetos o darles un nuevo propietario.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Huella de carbono de algunos productos';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impacto CO2**, de la Autoridad de Medio Ambiente francesa ADEME, proporciona el **impacto de carbono** de muchas categorías; asegúrese de clasificar los productos con precisión.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Índice de reparabilidad para muchos productos';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Siempre que esté disponible un índice de reparabilidad francés, lo mostraremos. Además, **puedes empezar a recopilar las variables usando el motor de Folksonomía**, para que podamos recalcularlo nosotros mismos en el futuro, incluso en países donde no esté disponible.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Busca maneras de donar/revender tu producto.';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Ofrecemos enlaces a **servicios de terceros sostenibles** que te ayudan a encontrar el producto que buscas, de segunda mano, para ser más respetuoso con los recursos del planeta.\nTen en cuenta que no recibimos ninguna compensación por esto y que el sistema solo funciona como ejemplo para dos sitios web en Francia. Puedes ayudarnos a ampliar este sistema documentando más sitios en la wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      '¿Qué información es útil?';

  @override
  String get guide_open_products_facts_information_text =>
      'Para una gama tan amplia de artículos, **los datos que recopilamos son flexibles**. Para ello, **creamos el Motor de Folksonomía**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'El motor de folksonomía';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'El motor de folksonomía es una herramienta que te ayuda a completar productos con propiedades relevantes. Esto mejora la búsqueda y la visibilidad, además de permitirte calcular y mostrar información interesante en el futuro.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Puedes añadir cualquier clave y valor, como por ejemplo: **compatibilidad_con_red_móvil_5G: sí**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Recibirás sugerencias automáticas de posibles propiedades, y te invitamos a agregar y documentar otras nuevas sobre tus tipos de productos favoritos.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-es.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'preferencias alimentarias abiertas';

  @override
  String get guide_coming_soon_button_title => 'Muy pronto';

  @override
  String get guide_learn_more_subtitle => 'Toca para obtener más información';

  @override
  String get preview_badge => 'Avance';

  @override
  String get prices_feedback_form =>
      '¡Haz clic aquí para enviarnos tus comentarios sobre esta nueva función!';

  @override
  String get menu_button_list_actions => 'Seleccione una acción';

  @override
  String get error_loading_photo => 'Error al cargar la foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Usar como…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Utilice esta imagen como…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Utilice esta imagen como… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detalles';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detalles de esta foto';

  @override
  String get photo_viewer_details_title => 'Detalles de la foto';

  @override
  String get photo_viewer_details_contributor_title => 'Colaborador/a';

  @override
  String get photo_viewer_details_size_title => 'Tamaño';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height píxeles';
  }

  @override
  String get photo_viewer_details_date_title => 'Fecha';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatible';

  @override
  String get user_lists_action_multi_select => 'Selección múltiple';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Su puntuación de compatibilidad: $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'Imagen frontal del producto';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Imagen de los ingredientes del producto';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Imagen nutricional';

  @override
  String get product_image_packaging_accessibility_label =>
      'Imagen del embalaje';

  @override
  String get product_image_other_accessibility_label => 'Otra imagen';

  @override
  String get product_image_outdated_message =>
      'Esta imagen puede estar desactualizada.';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (esta imagen puede estar desactualizada)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (esta imagen puede estar bloqueada por el productor)';
  }

  @override
  String get product_image_error => '¡No se puede cargar la imagen!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'No se pudo cargar $type (¿error de red?)';
  }

  @override
  String get product_page_image_no_image_available => '¡Sin imagen\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'No hay ninguna imagen disponible para este producto.';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reordenar u ocultar acciones';

  @override
  String get product_page_action_bar_setting_modal_title => 'Editar acciones';

  @override
  String get product_page_action_bar_item_move_up => 'Subir';

  @override
  String get product_page_action_bar_item_move_down => 'Muévete hacia abajo';

  @override
  String get product_page_action_bar_item_enable => 'Habilitar acción';

  @override
  String get product_page_action_bar_item_disable => 'Deshabilitar acción';

  @override
  String get product_page_pending_operations_banner_title =>
      'Subiendo tus ediciones…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Los datos que se muestran en esta página **aún no reflejan sus modificaciones**.\nEspere unos segundos…';

  @override
  String get product_add_a_language => 'Añadir un idioma';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Código de barras $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Eliminar este producto del carrusel';

  @override
  String get carousel_unsupported_header => '¡Código de barras no compatible!';

  @override
  String get carousel_unsupported_title => '¡Ups!';

  @override
  String get carousel_unsupported_text =>
      '¡El código de barras escaneado no es compatible con Open Food Facts!';

  @override
  String get carousel_error_header => '¡Error!';

  @override
  String get carousel_error_title => '¡Qué lástima!';

  @override
  String get carousel_error_text_1 =>
      'No pudimos descargar la información de este código de barras:';

  @override
  String get carousel_error_text_2 =>
      'Por favor, compruebe su conexión a Internet o haga clic en este botón:';

  @override
  String get carousel_error_button => 'Reintentar';

  @override
  String get carousel_unknown_product_header => 'Producto desconocido';

  @override
  String get carousel_unknown_product_title =>
      '¡Felicidades!\n¡Has encontrado la joya rara!';

  @override
  String get carousel_unknown_product_text =>
      'Nuestra base de datos colaborativa contiene más de **3 millones de productos**, pero este código de barras no existe: ';

  @override
  String get carousel_unknown_product_button => 'Añadir este producto';

  @override
  String get carousel_loading_header => 'Cargando información...';

  @override
  String get carousel_loading_title =>
      'Acabas de escanear un producto con el siguiente código de barras:';

  @override
  String get carousel_loading_text =>
      '¡Lo estamos buscando en nuestra base de datos de más de **3 millones de productos!**';

  @override
  String get product_type_subtitle_food =>
      'Verduras, frutas, alimentos congelados…';

  @override
  String get product_type_subtitle_beauty =>
      'Maquillaje, jabones, pastas dentales…';

  @override
  String get product_type_subtitle_pet_food => 'Comida para perros y gatos…';

  @override
  String get product_type_subtitle_product =>
      'Teléfonos inteligentes, muebles…';

  @override
  String get photo_field_front => 'Foto del producto';

  @override
  String get photo_field_ingredients => 'Foto de los ingredientes';

  @override
  String get photo_field_nutrition => 'Foto de nutrición';

  @override
  String get photo_field_packaging => 'Foto de la información del envase';

  @override
  String get photo_already_exists => 'Esta foto ya existe';

  @override
  String get photo_missing => 'Falta esta foto.';

  @override
  String get date => 'Fecha';

  @override
  String get photo_rotate_left => 'Girar a la izquierda';

  @override
  String get photo_rotate_right => 'Girar a la derecha';

  @override
  String get photo_undo_action => 'Deshacer la acción anterior';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Un mapa mundial de $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Colaboradores de OpenStreetMap';

  @override
  String get not_applicable_short => 'N/D';

  @override
  String get knowledge_panel_warning_text => 'Aviso';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      '¿Por qué este Nutri-Score es diferente del que aparece en el envase?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Existen dos posibles explicaciones:\nLa lista de ingredientes o la información nutricional no están actualizadas.\n\nOfrecemos el \"Nuevo cálculo\" del Nutri-Score (o V2). Compruebe que aparece la leyenda \"Nuevo cálculo\" en el envase.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Revisa los ingredientes';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Consulta la información nutricional.';

  @override
  String url_not_supported(String url) {
    return 'Lamentablemente, no podemos abrir la dirección URL:\n$url';
  }

  @override
  String get product_list_export => 'Exportar';

  @override
  String get product_list_import => 'Importar';

  @override
  String get product_footer_action_barcode => 'Ver código de barras';

  @override
  String get product_footer_action_barcode_short => 'Código de barras';

  @override
  String get product_footer_action_open_website => 'Abrir sitio web';

  @override
  String get product_footer_action_report => 'Informe';

  @override
  String get product_footer_action_contributor_guide => 'Ayuda';

  @override
  String get product_footer_action_data_quality_tags => 'Calidad de los datos';

  @override
  String get product_page_tab_for_me => 'Para mí';

  @override
  String get product_page_tab_website => 'Sitio web';

  @override
  String get product_page_tab_prices => 'Precios';

  @override
  String get prices_explanation_card_title => '¿Por qué los precios?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** es un proyecto para recopilar y compartir precios de productos de todo el mundo 🌍. Open Prices es desarrollado y mantenido por Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Saber más';

  @override
  String get product_page_tab_folksonomy => 'Folksonomía';

  @override
  String get folksonomy_explanation_card_title =>
      '¿Qué son los atributos de la folksonomía?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Los atributos se basan en **clave-valor**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Estas propiedades son creadas y archivadas por los colaboradores para cualquier tipo de uso.';

  @override
  String get folksonomy_action_external_link_title => 'Abrir enlace externo';

  @override
  String get folksonomy_action_external_link_warning =>
      'Los enlaces externos pueden ser peligrosos. ¿De verdad quieres visitarlos?';

  @override
  String get prices_products_empty_title => 'No hay precio disponible';

  @override
  String get prices_products_empty_explanation =>
      '¡Sé el primero en contribuir!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Productos más vendidos $pageSize (total: $total)';
  }

  @override
  String get app_review_title => '¿Te gusta esta aplicación?';

  @override
  String get app_review_low => 'Podría hacerlo mejor';

  @override
  String get app_review_medium => 'Nada mal';

  @override
  String get app_review_high => '¡Me encanta!';

  @override
  String get app_review_feedback_modal_title =>
      'Ayúdanos a mejorar nuestra aplicación';

  @override
  String get app_review_feedback_modal_content =>
      'Si tiene unos minutos, ¿podría responder a este formulario para que **podamos mejorar en futuras actualizaciones**?';

  @override
  String get app_review_feedback_modal_open_form => 'Responda el formulario';

  @override
  String get app_review_feedback_modal_later => 'Pregúntame más tarde';

  @override
  String get nutrition_facts_extract_new =>
      'NUEVO: ¡Puedes extraer automáticamente los nutrientes de la imagen!';

  @override
  String get nutrition_facts_extract_button_text => 'Extraer ahora';

  @override
  String get nutrition_facts_extract_in_progress => 'Extracción en progreso…';

  @override
  String get nutrition_facts_extract_successful => 'Extracción exitosa';

  @override
  String get nutrition_facts_extract_failed =>
      'No se pudieron extraer los nutrientes de la imagen.';

  @override
  String get prices_discount => 'Descuento';

  @override
  String get prices_stats_statistics => 'Estadísticas';

  @override
  String get prices_stats_title => 'Estadísticas de precios';

  @override
  String get prices_stats_prices_section => 'Precios';

  @override
  String get prices_stats_products_section => 'Productos';

  @override
  String get prices_stats_locations_section => 'Ubicaciones';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Colaboradores';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Miscelánea';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'Con descuento';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumo';

  @override
  String get prices_stats_with_price => 'con precio';

  @override
  String get prices_stats_food => 'Alimento';

  @override
  String get prices_stats_beauty => 'Belleza';

  @override
  String get prices_stats_products => 'Productos';

  @override
  String get prices_stats_pet_food => 'Alimento para mascotas';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Países';

  @override
  String get prices_stats_price_tag => 'Etiqueta de precio';

  @override
  String get prices_stats_receipt => 'Ticket';

  @override
  String get prices_stats_gdpr_request => 'Solicitud GDPR';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Desafíos';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Sitio web';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Otro';

  @override
  String get prices_stats_last_updated => 'Última actualización el';

  @override
  String get prices_stats_error =>
      'Se produjo un error al cargar las estadísticas.';

  @override
  String get product_edit_robotoff_question_answered => '¡Pregunta respondida!';

  @override
  String get product_edit_robotoff_proof => 'Comprobante';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Precios';

  @override
  String get preferences_prices_subtitle =>
      'Gestiona tus preferencias de precios';

  @override
  String get preferences_card_project => 'El proyecto Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuir';

  @override
  String get preferences_my_contributions_title => 'Mis contribuciones';

  @override
  String get preferences_my_stats_title => 'Mis estadísticas';

  @override
  String get preferences_contribute_subtitle =>
      'Traducir, mejorar nuestras herramientas…';

  @override
  String get preferences_connect_title => 'Conectar';

  @override
  String get preferences_connect_subtitle =>
      'Contáctanos o síguenos en las redes sociales.';

  @override
  String get preferences_support_title => 'Haz una donación';

  @override
  String get preferences_support_subtitle =>
      'Ayúdanos a informar a millones de consumidores en todo el mundo.';

  @override
  String get preferences_card_help => 'Ayuda y soporte';

  @override
  String get preferences_faq_title => 'Preguntas frecuentes';

  @override
  String get preferences_faq_subtitle => 'Obtenga respuestas a sus preguntas';

  @override
  String get logged_out => 'Cerrado sesión';

  @override
  String get preferences_app_bar_message =>
      '¡Gracias por ser uno de nuestros miembros!';

  @override
  String get preferences_app_bar_products_modified => 'Productos modificados';

  @override
  String get preferences_app_bar_prices_added => 'Precios añadidos';

  @override
  String get preferences_app_bar_see_all_stats => 'Ver todas las estadísticas';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Buscar $provider por \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Buscar una configuración (por ejemplo, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Accesibilidad: Mostrar emojis';

  @override
  String get preferences_accessibility_remove_colors =>
      'Accesibilidad: Eliminar colores';

  @override
  String get preferences_app_settings_products => 'Productos';

  @override
  String get preferences_card_about => 'Acerca de';

  @override
  String get preferences_legal_information_title => 'Información legal';

  @override
  String get preferences_legal_information_subtitle =>
      'Condiciones de uso, política de privacidad y más';

  @override
  String get preferences_terms_of_use => 'Condiciones de uso';

  @override
  String get preferences_legal_mentions => 'Aviso legal';

  @override
  String get preferences_legal_header =>
      'Open Food Facts es una base de datos de productos alimenticios **hecha por todos, para todos**.\nPuedes usarla para tomar mejores decisiones alimentarias y, como son **datos abiertos**, cualquiera puede **reutilizarlos para cualquier propósito**.';

  @override
  String get preferences_privacy_policy => 'Política de privacidad';

  @override
  String get preferences_licenses => 'Licencias';

  @override
  String get preferences_about_app_title => 'Acerca de la aplicación';

  @override
  String get preferences_about_app_subtitle =>
      'Información técnica, información para desarrolladores y más';

  @override
  String get preferences_card_information => 'Información';

  @override
  String get preferences_version_number_title => 'Número de versión';

  @override
  String get preferences_scanner_title => 'Escáner';

  @override
  String get preferences_app_store => 'Tienda de aplicaciones';

  @override
  String get preferences_app_system_settings => 'Configuración del sistema';

  @override
  String get preferences_source_code => 'Acceder al código fuente';

  @override
  String get preferences_source_code_subtitle =>
      'Y empieza a tener un impacto para millones';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Completa productos';

  @override
  String get preferences_tips => 'Consejos';

  @override
  String get tips_discover_nutriscore => 'Descubra el nuevo Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'En el sitio web de Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Administrar mi cuenta';

  @override
  String get preferences_manage_account_tooltip => 'Administra tu cuenta';

  @override
  String get preferences_change_password_title => 'Cambiar mi contraseña';

  @override
  String get preferences_danger_zone => 'Zona de peligro';

  @override
  String get preferences_account_deletion_subtitle =>
      'Todas tus contribuciones se perderán';

  @override
  String get preferences_contributions_title => 'Contribuciones';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Configuración de la aplicación';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Una forma muy experimental de escanear productos sin conexión';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Actualizar todos los productos del servidor';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Por favor, evite hacer eso a menos que sea absolutamente necesario.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Modo de demostración';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Agregar tarjetas al escáner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Añade 3 productos de muestra al escáner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Anfitrión de folksonomía';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Anfitrión: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experimentos de accesibilidad';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Selección de múltiples productos por precios';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Paneles de conocimiento ordenados por el usuario';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Acceso temporal a la búsqueda de ubicación';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Comparación lado a lado de 2 o 3 productos';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importación de lista de productos';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Puntuaciones y metodologías';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Descubra cómo se calcula el Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Descubra los principales cambios en la metodología';

  @override
  String get preferences_faq_discover_project_title => 'Descubre el proyecto';

  @override
  String get preferences_faq_discover_off_title =>
      'Descubra datos alimentarios abiertos';

  @override
  String get preferences_faq_discover_obf_title =>
      'Descubre datos sobre belleza abierta';

  @override
  String get preferences_faq_discover_opff_title =>
      'Descubre datos sobre alimentos para mascotas abiertos';

  @override
  String get preferences_faq_discover_op_title => 'Descubra Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Descubra datos sobre productos abiertos';

  @override
  String get preferences_faq_faq_title => 'FAQ - Preguntas frecuentes';

  @override
  String get preferences_faq_off_ngo_title => 'La ONG Open Food Facts';

  @override
  String get preferences_about_information_title => 'Información';

  @override
  String get preferences_connect_community_updates_title =>
      'Reciba actualizaciones de la comunidad';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Manténgase informado con las novedades de la aplicación y la comunidad.';

  @override
  String get preferences_connect_community_calendar_title =>
      'Suscríbete a nuestro calendario comunitario';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Participe asistiendo a uno de nuestros eventos virtuales';

  @override
  String get preferences_connect_blog_title =>
      'El blog de datos alimentarios abiertos';

  @override
  String get preferences_connect_blog_subtitle =>
      'Obtenga las últimas noticias a medida que ocurren';

  @override
  String get preferences_connect_community_help_title =>
      'Obtenga ayuda de la comunidad';

  @override
  String get preferences_connect_improve_app_title =>
      'Ayúdanos a mejorar la aplicación';

  @override
  String get preferences_connect_debug_info_title =>
      'Envíenos información de depuración';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Envíenos un correo electrónico con información detallada de depuración.';

  @override
  String get preferences_connect_feedback_title =>
      'Envíanos tus comentarios sobre la aplicación';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Ayude a dar forma al futuro de la aplicación';

  @override
  String get preferences_connect_survey_title =>
      'Realice la encuesta de la aplicación';

  @override
  String get preferences_connect_survey_subtitle =>
      'Ayúdanos a entender qué debemos construir a continuación.';

  @override
  String get preferences_connect_professionals_title => 'Profesionales';

  @override
  String get preferences_connect_pro_subtitle =>
      'Totalmente gratuito, garantiza datos precisos para 500 aplicaciones y millones de consumidores. Autoservicio, compatible con su PIM u hojas de cálculo (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Ponte en contacto con nosotros para empezar';

  @override
  String get preferences_connect_press_title => 'Prensa';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Consigue todo el material que necesitas para tu informe';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Póngase en contacto con nosotros para consultas de prensa o para informarnos sobre su informe.';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Conviértete en un voluntario activo';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Desarrollo, Comunicación, Diseño… ¡Cualquier tipo de voluntariado o experiencia es bienvenido!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Descubra algunas de las muchas formas en las que puede contribuir';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Desarrollo de aplicaciones móviles';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Aprenda a contribuir al desarrollo de software';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Versiones inestables diarias, características completamente nuevas';

  @override
  String get preferences_contribute_local_community_title =>
      'Haz crecer tu comunidad local';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Ayuda con software, contenidos, traducciones de análisis de ingredientes';

  @override
  String get preferences_contribute_share_subtitle =>
      'Hemos preparado una pequeña plantilla para ayudarte :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Pasos sencillos para aumentar la transparencia alimentaria en su país';

  @override
  String get preferences_contribute_data_quality_title =>
      'Calidad de los datos';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Únase al equipo de calidad de datos';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Únase a nuestro esfuerzo para garantizar que la base de datos esté completa y sea precisa.';

  @override
  String get preferences_contributions_products_added_title =>
      'Productos añadidos';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nuevos productos que agregué a Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Productos que necesito completar';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Todos los productos incompletos';

  @override
  String get preferences_my_contributions_prices_title => 'Precios';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mis precios';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Mis precios, mis pruebas…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Productos que puedes ayudar a completar';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ayúdanos a calcular el Nutri-Score y el Green-Score en tu país';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Precios que he aportado';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Etiquetas de precios y recibos';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Tome fotografías de sus recibos y escanee los códigos de barras asociados';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Toma fotografías de precios en una tienda.';

  @override
  String get preferences_prices_newest_title => 'Precios más nuevos';

  @override
  String get preferences_prices_newest_subtitle =>
      'Últimos precios añadidos por la comunidad Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Colaboradores con más precios';

  @override
  String get preferences_prices_metrics_title => 'Métricas de precio abierto';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Sigue la evolución del proyecto';

  @override
  String get preferences_prices_ways_contribute_title => 'Formas de contribuir';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Confirme los precios agregados por usted mismo o por otros, con la ayuda de IA';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Agregue rápidamente muchos recibos o fotos de estantes desde el carrete de su cámara';

  @override
  String get preferences_prices_challenges_title => 'Desafíos mensuales';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Participa en misiones temáticas mensuales para recolectar premios.';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Recupere sus datos de fidelización';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Aprende cómo solicitar tus datos';

  @override
  String get preferences_page_customize_app_title =>
      'Personaliza la aplicación';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribuir al proyecto';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Formas sencillas de ayudar a Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologías de puntuación, ayuda y más sobre el proyecto';

  @override
  String get product_edit_robotoff_positive_button => 'Aceptar sugerencia';

  @override
  String get product_edit_robotoff_negative_button => 'Rechazar sugerencia';

  @override
  String get product_edit_robotoff_show_proof => 'Mostrar prueba';

  @override
  String get product_edit_robotoff_expand_proof => 'Ampliar prueba';

  @override
  String get product_page_tab_raw_data => 'Datos sin procesar';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Página $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Página $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count de $total artículos';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count de $total artículos';
  }

  @override
  String item_count(int count) {
    return '$count artículos';
  }

  @override
  String item_count_string(String count) {
    return '$count artículos';
  }

  @override
  String get prices_no_result => 'No se encontraron estadísticas de precios.';

  @override
  String get prices_error_loading_more_items => 'Error al cargar más elementos';

  @override
  String get prices_proof_error =>
      'Falló la autenticación, no se pueden obtener pruebas';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count de $total pruebas';
  }

  @override
  String proof_count(int count) {
    return '$count Precios';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count de $total colaboradores';
  }

  @override
  String contributors_count(int count) {
    return '$count colaboradores';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count de $total ubicaciones';
  }

  @override
  String prices_locations_count(int count) {
    return '$count ubicaciones';
  }

  @override
  String get restart_to_apply_message =>
      'Reinicie la aplicación para aplicar los cambios.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interfaz gráfica';

  @override
  String get preferences_app_settings_media_title => 'Medios de comunicación';

  @override
  String get preferences_about_app_development_title => 'Desarrollo';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Laboratorios abiertos de datos alimentarios';

  @override
  String get preferences_root_account_title => 'Cuenta';

  @override
  String get preferences_contribute_translate_header =>
      'Lleva Open Food Facts a tu idioma';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Inscríbete en la versión alfa de la aplicación';

  @override
  String get preferences_dev_mode_section_data =>
      'Contribuciones y datos de productos';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'No mostrar folksonomía';

  @override
  String get preferences_account_title => 'Cuenta';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Añadido el $created';
  }

  @override
  String get location_map_details_title => 'Detalles de la ubicación';

  @override
  String get location_map_details_name => 'Nombre';

  @override
  String get location_map_details_street => 'Calle';

  @override
  String get location_map_details_city => 'Ciudad';

  @override
  String get location_map_details_postcode => 'Código postal';

  @override
  String get location_map_details_country => 'País';

  @override
  String get location_map_details_coordinates => 'Coordenadas';

  @override
  String get location_map_details_osm_id => 'ID de OSM';
}
