// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Danish (`da`).
class AppLocalizationsDa extends AppLocalizations {
  AppLocalizationsDa([String locale = 'da']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ja';

  @override
  String get add => 'Tilføj';

  @override
  String get account_delete_message =>
      'Sikker på, at du vil slette din konto?\nEr der en specifik grund, så del venligst nedenfor';

  @override
  String get reason => 'Årsag';

  @override
  String get okay => 'OK';

  @override
  String get validate => 'Bekræftelse';

  @override
  String get create => 'Opret';

  @override
  String get applyButtonText => 'Anvend';

  @override
  String get next_label => 'Næste';

  @override
  String get continue_label => 'Fortsæt';

  @override
  String get exit_label => 'Afslut';

  @override
  String get previous_label => 'Foregående';

  @override
  String get go_back_to_top => 'Retur til toppen';

  @override
  String get save => 'Gem';

  @override
  String get save_confirmation => 'Sikker på, at du vil gemme?';

  @override
  String get skip => 'Spring over';

  @override
  String get cancel => 'Annullér';

  @override
  String get ignore => 'Ignorér';

  @override
  String get close => 'Luk';

  @override
  String get no => 'Nej';

  @override
  String get stop => 'Stop';

  @override
  String get finish => 'Afslut';

  @override
  String get calculate => 'Beregn';

  @override
  String get reset_food_prefs => 'Nulstil fødevarepræferencer';

  @override
  String get error => 'Noget gik galt';

  @override
  String get error_occurred => 'En fejl opstod';

  @override
  String get featureInProgress =>
      'Der arbejdes stadig på denne funktion, hold dig opdateret';

  @override
  String get label_web => 'Se på nettet';

  @override
  String get learnMore => 'Få mere at vide';

  @override
  String get unknown => 'Ukendt';

  @override
  String get match_very_good => 'Meget godt match';

  @override
  String get match_good => 'Godt match';

  @override
  String get match_poor => 'Dårligt match';

  @override
  String get match_may_not => 'Matcher muligvis ikke';

  @override
  String get match_does_not => 'Matcher ikke';

  @override
  String get match_unknown => 'Ukendt match';

  @override
  String get match_short_very_good => 'Meget godt match';

  @override
  String get match_short_good => 'Godt match';

  @override
  String get match_short_poor => 'Dårligt match';

  @override
  String get match_short_may_not => 'Matcher muligvis ikke';

  @override
  String get match_short_does_not => 'Matcher ikke';

  @override
  String get match_short_unknown => 'Ukendt match';

  @override
  String get licenses => 'Licenser';

  @override
  String get looking_for => 'Leder efter';

  @override
  String get welcomeToOpenFoodFacts => 'Velkommen til Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts er en global non-profit drevet af lokale fællesskaber.';

  @override
  String get productDataUtility =>
      'Se fødevaredata relevante for dine præferencer.';

  @override
  String get healthCardUtility => 'Vælge fødevarer, som er gode for dig.';

  @override
  String get ecoCardUtility => 'Vælge fødevarer, som er gode for planeten.';

  @override
  String get server_error_open_new_issue =>
      'Intet serversvar! Du kan åbne en sag med følgende link.';

  @override
  String get sign_in_text =>
      'Log ind på din Open Food Facts-konto for at gemme dine bidrag';

  @override
  String get incorrect_credentials => 'Forkert brugernavn eller adgangskode.';

  @override
  String get password_lost_incorrect_credentials =>
      'E-mail eller brugernavn eksisterer ikke. Tjek venligst dine legitimationsoplysninger.';

  @override
  String get password_lost_server_unavailable =>
      'Vi oplever i øjeblikket opbremsninger på vores servere, og vi beklager det. Prøv venligst igen senere.';

  @override
  String get login => 'Brugernavn';

  @override
  String get login_result_type_server_unreachable => 'Netværk utilgængeligt';

  @override
  String get login_result_type_server_issue =>
      'Problem på serveren. Prøv venligst senere.';

  @override
  String get login_page_username_or_email => 'Angiv brugernavn eller e-mail';

  @override
  String get login_page_password_error_empty => 'Angiv adgangskode';

  @override
  String get create_account => 'Opret konto';

  @override
  String get sign_in => 'Log ind';

  @override
  String get sign_in_mandatory => 'Denne funktion kræver indlogning.';

  @override
  String get help_improve_country =>
      'Hjælp med at forbedre Open Food Facts i dit land';

  @override
  String get sign_out => 'Log ud';

  @override
  String get sign_out_confirmation => 'Sikker på, at du vil logge ud?';

  @override
  String get password => 'Adgangskode';

  @override
  String get forgot_password => 'Glemt adgangskode';

  @override
  String get forgot_password_question => 'Glemt adgangskode?';

  @override
  String get view_profile => 'Se profil';

  @override
  String get reset_password => 'Nulstil adgangskode';

  @override
  String get reset_password_explanation_text =>
      'Er adgangskoden glemt, så angiv dit brugernavn eller din e-mailadresse for at modtage en vejledning til adgangskodenulstilling. Tjek evt. også Spam-mappen.';

  @override
  String get username_or_email => 'Brugernavn eller e-mail';

  @override
  String get reset_password_done =>
      'En e-mail indeholdende et link til adgangskodenulstilling er sendt til e-mailadressen tilknyttet din konto. Tjek også Spam-mappen';

  @override
  String get send_reset_password_mail => 'Skift adgangskode';

  @override
  String get enter_some_text => 'Angiv noget tekst';

  @override
  String get sign_up_page_title => 'Tilmeld';

  @override
  String get sign_up_page_action_button => 'Tilmeld';

  @override
  String get sign_up_page_action_doing_it => 'Tilmelder…';

  @override
  String get sign_up_page_action_ok => 'Din konto er nu oprettet.';

  @override
  String get sign_up_page_display_name_hint => 'Navn';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Angiv det navn, der ønskes vist';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mail er obligatorisk';

  @override
  String get sign_up_page_email_error_invalid => 'Ugyldig e-mail';

  @override
  String get sign_up_page_username_hint => 'Brugernavn: Offentligt synligt';

  @override
  String get sign_up_page_username_error_empty => 'Indtast et brugernavn';

  @override
  String get sign_up_page_username_error_invalid =>
      'Angiv et gyldigt brugernavn';

  @override
  String get sign_up_page_username_description =>
      'Brugernavn må ikke indeholde mellemrum, majuskler eller specialtegn.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Brugernavn må ikke overstige $value tegn';
  }

  @override
  String get sign_up_page_password_hint => 'Adgangskode';

  @override
  String get sign_up_page_password_error_empty => 'Angiv adgangskode';

  @override
  String get sign_up_page_password_error_invalid =>
      'Angiv en gyldig adgangskode (mindst 6 tegn)';

  @override
  String get sign_up_page_confirm_password_hint => 'Bekræft adgangskode';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Bekræft adgangskoden';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Adgangskoder matcher ikke';

  @override
  String get sign_up_page_agree_text => 'Jeg accepterer Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'vilkår for brug og bidrag';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Ved oprettelse af en konto er det obligatorisk at acceptere Vilkår for Brug, dog kan anonyme bidrag stadig foretages via appen';

  @override
  String get sign_up_page_producer_checkbox => 'Jeg er fødevareproducent';

  @override
  String get sign_up_page_producer_hint => 'Producent/mærke';

  @override
  String get sign_up_page_producer_error_empty =>
      'Angiv en producent eller et mærkenavn';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Jeg ønsker at abonnere på Open Food Facts-nyhedsbrevet (kan altid afmeldes)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Brugernavn findes allerede, vælg et andet.';

  @override
  String get sign_up_page_email_already_exists =>
      'findes allerede. Log ind på kontoen eller prøv med en anden e-mail.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Angiv en gyldig e-mailadresse.';

  @override
  String get sign_up_page_server_busy =>
      'Vi beklager dybt, vi har nogle tekniske problemer med at oprette din konto. Prøv venligst igen senere.';

  @override
  String get settingsTitle => 'Indstillinger';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Mørkt';

  @override
  String get darkmode_light => 'Lyst';

  @override
  String get darkmode_system_default => 'Systemstandard';

  @override
  String get thanks_for_contributing => 'Tak for dit bidrag!';

  @override
  String get contributors_label => 'De bygger appen';

  @override
  String get contributors_dialog_title => 'Bidragsydere';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Bidragyder: $name';
  }

  @override
  String get contributors_description =>
      'En liste over alle bidragydere til denne app';

  @override
  String get support => 'Support';

  @override
  String get support_join_slack => 'Bed om hjælp i vores Slack-kanal';

  @override
  String get support_via_forum => 'Spørg om hjælp forummet';

  @override
  String get support_via_email => 'Send os en e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Indsend app-logfiler?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Medtag app-logfiler i vedhæftning til e-mailen?';

  @override
  String get termsOfUse => 'Brugsvilkår';

  @override
  String get legalNotices => 'Juridiske oplysninger';

  @override
  String get privacy_policy => 'Fortrolighedspolitik';

  @override
  String get about_this_app => 'Om denne app';

  @override
  String get contribute => 'Bidrag';

  @override
  String get contribute_sw_development => 'Softwareudvikling';

  @override
  String get contribute_develop_text =>
      'Koden til hvert Open Food Facts-produkt er tilgængelig på GitHub. Man er velkommen til at genbruge koden (den er open-source) og hjælpe med at forbedre den for alle på hele planeten.';

  @override
  String get contribute_develop_text_2 =>
      'Man kan deltage i Open Food Facts Slack-chatrum, der er den foretrukne måde at stille spørgsmål på.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV-tilstand?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktivér DEV-tilstand';

  @override
  String get contribute_donate_title => 'Donér';

  @override
  String get contribute_donate_header => 'Donér til Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Anerkend venligst, at med den interne alpha-version er det muligt at miste alle data, og appen kan blive ubrugelig når som helst!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produkter, som skal færdiggøres';

  @override
  String get contribute_improve_header => 'Forbedring';

  @override
  String get contribute_improve_text =>
      'Databasen er kernen i projektet. Det er let og meget hurtigt at hjælpe. Man kan downloade appen til sin mobil og begynde at tilføje/forbedre produkter.\n\nDerudover tilbyder Open Food Facts-webstedet mange bidragsmuligheder: ';

  @override
  String get contribute_translate_header => 'Oversæt';

  @override
  String get contribute_data_quality => 'Datakvalitet';

  @override
  String get contribute_translate_link_text => 'Begynd at oversætte';

  @override
  String get contribute_translate_text =>
      'Open Food Facts er et globalt projekt indeholdende produkter fra flere end 160 lande. Open Food Facts er oversat til snesevis af sprog med indhold i konstant udvikling.';

  @override
  String get contribute_translate_text_2 =>
      'Oversættelser er en af projektets nøgleopgaver';

  @override
  String get contribute_join_skill_pool =>
      'Bidrage dine færdigheder til Open Food Facts. Deltag i dygtighedspuljen!';

  @override
  String get contribute_share_header => 'Del Open Food Facts med dine venner';

  @override
  String get contribute_share_content =>
      'Jeg vil gerne lige fortælle om den app, jeg har brugt, Open Food Facts, der giver mulighed for at få viden om madens sundheds- og miljøpåvirkninger på en herlig nem måde. Den fungerer ved at skanne emballagestregkoder. Den er desuden gratis, kræver ingen registrering, og man kan endda hjælpe med at øge antallet af dechifrerede produkter. Her er linket til at få den på mobilen: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Bidrage med priser ved at anmode om en GDPR-eksport af dine loyalitetskortdata';

  @override
  String get tap_to_answer => 'Tryk her for at besvare spørgsmål';

  @override
  String get tap_to_answer_hint =>
      'Tryk her for at besvare spørgsmål om dette produkt';

  @override
  String get robotoff_questions_loading_hint =>
      'Afvent indlæsning af spørgsmål om dette produkt';

  @override
  String get saving_answer => 'Gemmer svaret';

  @override
  String get contribute_to_get_rewards =>
      'Bliv medspilleri fødevarergennemsigtighed';

  @override
  String get question_sign_in_text =>
      'Log ind på Open Food Facts-kontoen for at blive anerkendt for dine bidrag';

  @override
  String get question_yes_button_accessibility_value => 'Svar med ja';

  @override
  String get question_no_button_accessibility_value => 'Svar med nej';

  @override
  String get question_skip_button_accessibility_value =>
      'Overspring spørgsmålet';

  @override
  String get tap_to_edit_search => 'Tryk for at redigere søgning';

  @override
  String get myPreferences => 'Mine præferencer';

  @override
  String get account_create_message =>
      'Opret en konto og tilmeld dig Open Food Facts-fællesskabet for at hjælpe med at opbygge fødevareviden verden over!';

  @override
  String get join_us => 'Tilmeld';

  @override
  String get myPreferences_profile_title => 'Din profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Administrer din Open Food Facts bidragyderkonto.';

  @override
  String get myPreferences_settings_title => 'App-indstillinger';

  @override
  String get myPreferences_settings_subtitle => 'Mørk tilstand, Sprog…';

  @override
  String get myPreferences_food_title => 'Fødevarepræferencer';

  @override
  String get myPreferences_food_subtitle =>
      'Vælg, hvilke oplysninger om fødevarer, som betyder mest.';

  @override
  String get myPreferences_food_comment =>
      'Vælg de fødevareoplysninger med størst betydning for dig, for at kunne rangere dem efter dine præferencer, se de oplysninger, du finder interessante først, samt få en kompatibilitetsoversigt. Disse fødevarepræferencer forbliver lokale og tilknyttes ikke OpenFoodFacts-bidragsyderkontoen, såfremt du har én.';

  @override
  String get confirmResetPreferences => 'Nulstil dine fødevarepræferencer?';

  @override
  String get myPersonalizedRanking => 'Min personlige rangering';

  @override
  String get ranking_tab_all => 'Alle';

  @override
  String get ranking_subtitle_match_yes => 'Et godt match til dig';

  @override
  String get ranking_subtitle_match_no => 'Meget dårligt match';

  @override
  String get ranking_subtitle_match_maybe => 'Ukendt match';

  @override
  String get refresh_with_new_preferences =>
      'Opfrisk listen med de nye præferencer';

  @override
  String get reloaded_with_new_preferences =>
      'Genindlæst med de nye præferencer';

  @override
  String get profile_navbar_label => 'Fællesskab';

  @override
  String get scan_navbar_label => 'Skan';

  @override
  String get history_navbar_label => 'Historik';

  @override
  String get list_navbar_label => 'Lister';

  @override
  String get category => 'Filtrér efter kategori';

  @override
  String get category_all => 'Alle';

  @override
  String get category_search => '(kategorisøgning)';

  @override
  String get filter => 'Filtrere';

  @override
  String get scan => 'Produkter fra Scan-skærmen';

  @override
  String get scan_history => 'Skanningshistorik';

  @override
  String get search => 'Søg';

  @override
  String get search_product_help =>
      'Søg efter et produkt,\net mærke eller en stregkode';

  @override
  String get search_filter => 'Søgefilter';

  @override
  String get search_history => 'Søgehistorik';

  @override
  String get search_store => 'Søg efter en butik';

  @override
  String get search_store_help => 'Tip: tilføj byen eller landet';

  @override
  String get tap_for_more => 'Tryk for flere oplysninger…';

  @override
  String get product => 'Produkt';

  @override
  String get unknownBrand => 'Ukendt brand';

  @override
  String get unknownProductName => 'Ukendt produktnavn';

  @override
  String get label_refresh => 'Opfrisk';

  @override
  String get label_reload => 'Genindlæs';

  @override
  String get image => 'Billed';

  @override
  String get front_photo => 'Forsidefoto';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (dette billede kan være forældet)';
  }

  @override
  String get outdated_image_short_label => 'kan være forældet';

  @override
  String get ingredients => 'Ingredienser';

  @override
  String get ingredients_editing_instructions =>
      'Behold den oprindelige ordre. Angiv procentdelen, når den er angivet. Adskil med komma eller bindestreg, og brug parenteser til ingredienser i en ingrediens.';

  @override
  String get ingredients_editing_error => 'Mislykkedes at gemme ingredienser.';

  @override
  String get ingredients_editing_image_error =>
      'Mislykkedes at hente nyt ingrediensfoto.';

  @override
  String get ingredients_editing_title => 'Redigér ingredienser';

  @override
  String get ingredients_photo => 'Ingrediensfoto';

  @override
  String get packaging_editing_instructions =>
      'Liste alle emballagebestanddele (adskilt med komma eller ny linje) med deres mængde (f.eks. 1 eller 6), type (f.eks. flaske, æske, dåse), materiale (f.eks. plast, metal, aluminium), og hvis tilgængelig, størrelse (f.eks. 33 cl) samt genbrugsinstruktioner.\nEks.: 1 glasflaske til genbrug, 1 plastikprop til kassation';

  @override
  String get packaging_editing_error => 'Kunne ikke gemme emballagen.';

  @override
  String get packaging_editing_image_error =>
      'Kunne ikke hente nyt emballagefoto.';

  @override
  String get packaging_editing_title => 'Redigér emballage';

  @override
  String get nutrition => 'Ernæring';

  @override
  String get nutrition_facts_photo => 'Næringsindholdsfoto';

  @override
  String get nutrition_facts_editing_title => 'Rediger ernæringsfakta';

  @override
  String get packaging_information => 'Emballageoplysning';

  @override
  String get packaging_information_photo => 'Emballageoplysningsfoto';

  @override
  String get missing_product => 'Nyt produkt blev fundet!';

  @override
  String get add_product_take_photos =>
      'Tag billeder af emballagen for at tilføje dette produkt til Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Tag først nogle fotos. Produktet kan altid færdiggøre senere.';

  @override
  String get add_product_information_button_label =>
      'Tilføj produkt eller oplysning';

  @override
  String get new_product => 'Nyt produkt';

  @override
  String get new_product_found_title => 'Nyt produkt fundet!';

  @override
  String get new_product_found_text =>
      'Vores samarbejdsdatabase indeholder mere end **3 millioner produkter**, men denne stregkode findes ikke: ';

  @override
  String get new_product_found_button => 'Tilføj dette produkt';

  @override
  String get new_product_leave_title => 'Forlad denne side?';

  @override
  String get new_product_leave_message =>
      'Ser ud til, at der ikke blev indtastet noget. Forlad siden alligevel, sikker?';

  @override
  String get new_product_dialog_description =>
      'Tag venligst billeder af emballagen for at tilføje dette produkt til vores fælles database';

  @override
  String get new_product_dialog_illustration_description =>
      'En illustration med ukendt Nutri-Score og Green Score';

  @override
  String get front_packaging_photo_button_label => 'Produktforsidefoto';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Bekræft upload af produktforsidefoto';

  @override
  String get confirm_button_label => 'Bekræft';

  @override
  String get send_image_button_label => 'Indsend foto';

  @override
  String get crop_page_action_saving => 'Gemmer fotoet…';

  @override
  String get crop_page_action_cropping => 'Beskærer fotoet…';

  @override
  String get crop_page_action_local => 'Gemmer en lokal version…';

  @override
  String get crop_page_action_local_failed_title =>
      'Hovsa… der er et problem med fotoet!';

  @override
  String get crop_page_action_local_failed_message =>
      'Ude af stand til stand at behandle fotoet lokalt, før det indsendes til vores server. Forsøg igen senere, eller kontakt os, hvis problemet fortsætter.';

  @override
  String get crop_page_action_retake => 'Tag foto igen';

  @override
  String get crop_page_too_small_image_title => 'Foto for lille!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Minimumsstørrelsen i pixels for foto-upload udgør ${expectedMinWidth}x$expectedMinHeight. Det aktuelle foto er ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Forbereder kald til serveren…';

  @override
  String get front_packaging_photo_title => 'Emballageforsidefoto';

  @override
  String get ingredients_photo_title => 'Ingrediensfoto';

  @override
  String get nutritional_facts_photo_title => 'Næringsfaktafoto';

  @override
  String get recycling_photo_title => 'Genbrugsfoto';

  @override
  String get take_photo_title => 'Tag et billede';

  @override
  String get take_more_photo_title => 'Tag flere billeder';

  @override
  String get front_photo_uploaded => 'Forsidefoto uploadet';

  @override
  String get ingredients_photo_button_label => 'Ingrediensfoto';

  @override
  String get ingredients_photo_uploaded => 'Ingrediensfoto uploadet';

  @override
  String get nutrition_cache_loading_error =>
      'Kan ikke indlæse næringsstoffer fra cache';

  @override
  String get nutritional_facts_photo_button_label => 'Næringsindholdsfoto';

  @override
  String get nutritional_facts_input_button_label => 'Angiv ernæringsfakta';

  @override
  String get nutritional_facts_added => 'Næringsfakta tilføjet';

  @override
  String get categories_added => 'Kategorier tilføjet';

  @override
  String get new_product_title_nutriscore => 'Beregn Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Få den ved at udfylde fødevarekategorien og næringsværdier';

  @override
  String get new_product_title_environmental_score => 'Beregn den Grønne Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Få det ved at udfylde mindst en kategori';

  @override
  String get new_product_additional_environmental_score =>
      'Gør Green Score-beregningen mere præcis med oprindelse, emballage med mere';

  @override
  String get new_product_title_nova =>
      'Beregn fødevareforarbejdningsniveau (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Få det ved at udfylde fødevarekategori og ingredienser';

  @override
  String get new_product_desc_nova_unknown =>
      'Fødevareforarbejdningsniveau ukendt';

  @override
  String get new_product_title_pictures => 'Lad os tage nogle fotos!';

  @override
  String get new_product_title_pictures_details =>
      'Tag venligst følgende billeder, og Open Food Facts kan klare resten!';

  @override
  String get new_product_title_misc => 'Og nogle basisdata…';

  @override
  String new_product_done_msg(String username) {
    return 'Tak for dit bidrag \"$username\"!';
  }

  @override
  String get new_product_done_msg_no_user => 'Tak for dit bidrag!';

  @override
  String get new_product_done_button_label => 'Opdag det færdige produkt';

  @override
  String get hey_incomplete_product_message =>
      'Tryk for at besvare 3 spørgsmål NU! for at beregne Nutri-Score, Green Score & Ultra-processing (NOVA).';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Tryk nu for at besvare 2 spørgsmål for at hjælpe med at analysere denne kosmetik!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Tryk nu for at besvare 3 spørgsmål for at hjælpe med at analysere dette dyrefoderprodukt!';

  @override
  String get hey_incomplete_product_message_product =>
      'Tryk nu for at hjælpe med at færdiggøre dette produkt!';

  @override
  String get nutritional_facts_photo_uploaded => 'Næringsfaktafoto uploadet';

  @override
  String get recycling_photo_button_label => 'Genbrugsoplysningsfoto';

  @override
  String get recycling_photo_uploaded => 'Genbrugsoplysningsfoto uploadet';

  @override
  String get take_more_photo_button_label => 'Tag flere billeder';

  @override
  String get other_photo_uploaded => 'Div. foto uploadet';

  @override
  String get retake_photo_button_label => 'Tag igen';

  @override
  String get selecting_photo => 'Valg af foto';

  @override
  String get uploading_image => 'Uploader foto til server';

  @override
  String get uploading_image_type_front =>
      'Uploader forsidebillede til Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Uploader ingrediensbillede til Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Uploader ernæringsbillede til Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Uploader emballagebillede til Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Uploader andet billede til Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Uploader billede til Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Tilføj manglende ingredienser';

  @override
  String get score_add_missing_packaging_image =>
      'Tilføj manglende emballagefoto';

  @override
  String get score_add_missing_nutrition_facts =>
      'Tilføj manglende ernæringsfakta';

  @override
  String get score_add_missing_product_traces => 'Tilføj manglende produktspor';

  @override
  String get score_add_missing_product_category =>
      'Tilføj manglende produktkategori';

  @override
  String get score_add_missing_precise_product_category =>
      'Vælg en mere præcis kategori';

  @override
  String get score_add_missing_product_countries =>
      'Tilføj manglende produktlande';

  @override
  String get score_add_missing_product_emb =>
      'Tilføj manglende produktsporbarhedskoder';

  @override
  String get score_add_missing_product_labels =>
      'Tilføj manglende produktketiketter';

  @override
  String get score_add_missing_product_origins =>
      'Tilføj manglende produktoprindelser';

  @override
  String get score_add_missing_product_stores =>
      'Tilføj manglende produktbutikker';

  @override
  String get score_add_missing_product_brands => 'Tilføj manglende varemærker';

  @override
  String get score_update_nutrition_facts => 'Opdatér ernæringsfakta';

  @override
  String get nutrition_page_title => 'Ernæringsfakta';

  @override
  String get nutrition_page_nutritional_info_title => 'Ernæringsoplysninger';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Værdier angivet på produktet:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ja';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nej';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Åbn foto';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'God praksis: Ernæringsoplysninger';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Nogle gange er næringsindhold **ikke angivet på emballagen** eller i et medfølgende dokument. I dette tilfælde, og kun i dette tilfælde, kan du indstille værdien til **NEJ**.';

  @override
  String get nutrition_page_serving_type_label => 'Ernæringsværdier:';

  @override
  String get nutrition_page_per_100g => 'pr. 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'pr. 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'per portion';

  @override
  String get nutrition_page_add_nutrient => 'Tilføj et næringsstof';

  @override
  String get nutrition_page_serving_size => 'Portionsstørrelse';

  @override
  String get nutrition_page_serving_size_hint =>
      'Angiv en portionsstørrelse (f.eks. 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'God praksis: Portionsstørrelse';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Denne værdi hjælper med at **lave en proportional beregning af hvert næringsstof pr. portion**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Tilladte enheder** er: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** eller **60 G** (foretræk den første)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** eller **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Ugyldig enhed';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Ugyldige enheder';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **slik** og 2 **kiks**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Manglende enhed';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Ugyldigt nummer';

  @override
  String get nutrition_page_update_running =>
      'Opdaterer produktet på serveren…';

  @override
  String get nutrition_page_update_done => 'Produkt opdateret!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Brug produktmængden som portionsstørrelse';

  @override
  String get nutrition_page_photo_error => 'Kan ikke indlæse billedet';

  @override
  String get more_photos => 'Flere interessante fotos';

  @override
  String get view_more_photo_button =>
      'Se alle eksisterende billeder for dette produkt';

  @override
  String get no_product_found => 'Intet produkt fundet';

  @override
  String get no_location_found => 'Ingen placering fundet';

  @override
  String get not_found => 'ikke fundet:';

  @override
  String get refreshing_product => 'Opfrisker produkt';

  @override
  String get product_refreshed => 'Produkt opfrisket';

  @override
  String product_image_accessibility_label(String date) {
    return 'Billede taget d. $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Billede taget d. $date. Dette billede kan være forældet';
  }

  @override
  String get product_image_outdated => 'Dette billede kan være forældet';

  @override
  String get product_image_outdated_explanations_title =>
      'Dette billede kan være forældet';

  @override
  String get product_image_outdated_explanations_content =>
      'Dette billede er taget for mere end et år siden.\n**Tjek venligst, at den stadig er opdateret**.\n\nDette er **bare en advarsel**. Hvis indholdet stadig er det samme, kan du ignorere denne besked.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Erstat billede ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Tilføj et billede ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Tag et nyt';

  @override
  String get product_image_action_take_picture => 'Tag et billede';

  @override
  String get product_image_action_from_gallery =>
      'Vælg fra din telefons kamerarulle';

  @override
  String get product_image_action_choose_existing_photo =>
      'Vælg fra produktbillederne';

  @override
  String get product_image_details_label => 'Oplysninger om billedet';

  @override
  String get product_image_details_from_producer => 'Fra producenten';

  @override
  String get product_image_details_contributor => 'Bidragsyder';

  @override
  String get product_image_details_contributor_producer =>
      'Bidragyder (producent)';

  @override
  String get product_image_details_date => 'Dato';

  @override
  String get product_image_details_date_unknown => 'Ukendt';

  @override
  String get homepage_main_card_logo_description =>
      'Velkommen til Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scan** en stregkode eller\n**søg** efter et produkt';

  @override
  String get homepage_main_card_search_field_hint => 'Søg efter et produkt';

  @override
  String get homepage_main_card_search_field_tooltip => 'Start søgning';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Seneste nyt: $news_title';
  }

  @override
  String get tagline_app_review => 'Kan du lide appen?';

  @override
  String get tagline_app_review_button_positive => 'Jeg elsker det! 😍';

  @override
  String get tagline_app_review_button_negative => 'Ikke rigtigt…';

  @override
  String get tagline_app_review_button_later => 'Spørg mig senere';

  @override
  String get tagline_feed_news_button => 'Lær mere';

  @override
  String get app_review_negative_modal_title => 'Kan du ikke lide vores app?';

  @override
  String get app_review_negative_modal_text =>
      'Vil du bruge et par sekunder på at fortælle os hvorfor?';

  @override
  String get app_review_negative_modal_positive_button => 'Ja, selvfølgelig!';

  @override
  String get app_review_negative_modal_negative_button => 'Nej';

  @override
  String get could_not_refresh => 'Kunne ikke opfriske produkt';

  @override
  String get product_internet_error_modal_title => 'Der opstod en fejl!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Vi kan ikke hente oplysninger om dette produkt grundet en netværksfejl. Tjek venligst din internetforbindelse og prøv igen.';
  }

  @override
  String get product_tags_title => 'Produktegenskaber';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Ingen ejendomme';

  @override
  String get product_tags_explanation =>
      'Ved at tilføje egenskaber (nøgle/værdi) til et produkt, hjælper du med at berige det.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Tilføj egenskaber';

  @override
  String get add_edit_tags => 'Tilføj eller rediger egenskaber';

  @override
  String get edit_tag => 'Rediger egenskab';

  @override
  String get remove_tag => 'Fjern egenskab';

  @override
  String get tag_key => 'Egenskab';

  @override
  String get tag_keys => 'Ejendomme';

  @override
  String get tag_key_uneditable => 'Egenskab (ikke-redigerbar)';

  @override
  String get tag_key_input_hint => 'Indtast en egenskab';

  @override
  String get tag_value => 'Værdi';

  @override
  String get tag_values => 'Værdier';

  @override
  String get tag_value_input_hint => 'Indtast en værdi';

  @override
  String get tag_key_item => 'Egenskab:';

  @override
  String get tag_value_item => 'Værdi:';

  @override
  String get tag_key_explanations =>
      'En nøgle skal være små bogstaver og uden mellemrum.';

  @override
  String tag_key_already_exists(String property) {
    return 'Et tag med en egenskab $property findes allerede!';
  }

  @override
  String get product_internet_error =>
      'Ikke muligt at hente disse produktoplysninger grundet netværksfejl.';

  @override
  String get cached_results_from => 'Vis resultater fra:';

  @override
  String get product_search_same_category => 'Find alternativer';

  @override
  String get product_search_same_category_short => 'Sammenlign';

  @override
  String get product_search_same_category_error =>
      'Denne funktion kan kun bruges til produkter med en kategori.\n\nRediger venligst produktet for at tilføje en kategori.';

  @override
  String get product_improvement_add_category =>
      'Tilføj en kategori for at beregne Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Tilføj ernæringsfakta for at beregne Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Tilføj ernæringsfakta og en kategori for at beregne Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Score for dette produkt kan ikke beregnes, hvilket kan skyldes f.eks. en ikke-standard kategori. Betragtes dette som en fejl, kontakte os venligst.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Ernæringsfaktafoto forældet. Opdatér det venligst.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Green Score tager højde for ingrediensernes oprindelse. Tag venligst et billede af ingredienslisten og/eller enhver geografisk påstand eller rediger produktet, så disse oplysninger kan tages i betragtning.';

  @override
  String get country_chooser_label => 'Vælg land';

  @override
  String get currency_chooser_label => 'Vælg venligst en valuta';

  @override
  String get country_change_message => 'Du har lige skiftet lande.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Vil du ændre valutaen fra $previousCurrency til $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Vælg venligst et land:';

  @override
  String get country_chooser_label_from_settings => 'Dit land';

  @override
  String get country_selection_explanation =>
      'Visse miljømæssige egenskaber er stedbestemte';

  @override
  String get product_removed_comparison => 'Produkt fjernet fra sammenligning';

  @override
  String get native_app_settings => 'Indstillinger for indbyggede apper';

  @override
  String get native_app_description =>
      'Åbn systemindstillinger for Open Food Facts';

  @override
  String get product_removed_history => 'Produkt fjernet fra historik';

  @override
  String get product_removed_list => 'Produkt fjernet fra liste';

  @override
  String get product_could_not_remove => 'Produkt kunne ikke fjernes';

  @override
  String get no_prodcut_in_list => 'Der er intet produkt på denne liste';

  @override
  String get no_product_in_section => 'Der er intet produkt i dette afsnit';

  @override
  String get recently_seen_products => 'Alle sete produkter';

  @override
  String get clear => 'Ryd';

  @override
  String get clear_long => 'Tøm listen';

  @override
  String get really_clear => 'Slet denne liste, sikker?';

  @override
  String pct_match(Object percent) {
    return '$percent% match';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dage siden',
      one: 'en dag siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count timer siden',
      one: 'en time siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minutter siden',
      one: 'et minut siden',
      zero: 'mindre end et minut siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count måneder siden',
      one: 'en måned siden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count uger siden',
      one: 'en uge siden',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Sammenlign $count produkter',
      one: 'Sammenlign et produkt',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count valgte produkter',
      one: 'Ét valgt produkt',
      zero: 'Intet valgt produkt',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Sammenlign valgte produkter';

  @override
  String get delete_products_mode => 'Slet valgte produkter';

  @override
  String get select_all_products_mode => 'Vælg alle produkter';

  @override
  String get select_none_products_mode => 'Vælg ingen';

  @override
  String get compare_products_appbar_title => 'Sammenlign produkter';

  @override
  String get compare_products_appbar_subtitle => 'Vælg mindst to produkter';

  @override
  String get retry_button_label => 'Forsøg igen';

  @override
  String get connect_with_us => 'Kom i forbindelse med os';

  @override
  String get tiktok => 'Følg os på TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Følg os på Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Følg os på X (tidligere Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Følg os på Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Følg os på BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Opdag';

  @override
  String get how_to_contribute => 'Sådan bidrager man';

  @override
  String get hint_knowledge_panel_message =>
      'Tryk på enhver del af kortet for yderligere detaljer om, hvad der ses. Prøv det nu!';

  @override
  String get permissions_page_title => 'Kameraadgang';

  @override
  String get permissions_page_body1 =>
      'For at scanne stregkoder med din telefons kamera skal du godkende adgangen.';

  @override
  String get permissions_page_body2 =>
      'Ombestemmer man sig, kan denne indstilling altid aktiveres/deaktiveres via Indstillingerne.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt/Udgivelse: $release)\nModel: $model\nProdukt: $product\nEnhed: $device\nMærke:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModel: $model\nLokaliseret model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nApp-version:$appVersion\nApp-buildnummer:$appBuildNumber\nApp-pakkenavn:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Godkend';

  @override
  String get refuse_button_label => 'Afvis';

  @override
  String get ask_me_later_button_label => 'Senere';

  @override
  String get are_you_sure => 'Sikker?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Fortsæt på $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Velkommen!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Appen, der hjælper dig med at vælge mad, der er godt for **dig** og **planeten**!';

  @override
  String get onboarding_continue_button => 'Fortsæt';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Indlæser første eksempelprodukt';

  @override
  String get onboarding_welcome_warning =>
      'Beklager, det er vores eksempelprodukt, du kan ikke redigere det :)';

  @override
  String get product_list_your_ranking => 'Din rangering';

  @override
  String get product_list_empty_icon_desc => 'Historik utilgængelig';

  @override
  String get product_list_empty_title => 'Start skanningen';

  @override
  String get product_list_empty_message =>
      'Indskannede produkter vises her, hvor deres detaljerede oplysninger kan tjekkes';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produkter',
      one: 'produkt',
      zero: 'produkt',
    );
    return 'Opfrisker $_temp0 i historikken';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produktopfriskninger',
      one: 'produktopfriskning',
      zero: 'Produkt',
    );
    return '$_temp0 udført';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Downloader data';

  @override
  String get loading_dialog_default_error_message =>
      'Data kunne ikke downloades';

  @override
  String get account_delete => 'Slet konto';

  @override
  String get account_delete_title => 'Slet min konto';

  @override
  String get user_profile => 'Konto';

  @override
  String get user_profile_title_guest => 'Velkommen!';

  @override
  String get user_profile_subtitle_guest =>
      'Log ind eller tilmeld dig for at blive medlem af Open Food Facts-fællesskabet';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts-login: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Velkommen $id!';
  }

  @override
  String get email_subject_account_deletion => 'Slet konto';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hej, slet venligst min Open Food Facts-konto: $userId';
  }

  @override
  String get settings_app_app => 'App';

  @override
  String get settings_app_data => 'Fortrolighed og overvågning';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Produkter';

  @override
  String get settings_app_miscellaneous => 'Diverse';

  @override
  String get camera_play_sound_title => 'Afspil en lyd ved skanning';

  @override
  String get camera_play_sound_subtitle =>
      'Bipper efter hver vellykket skanning';

  @override
  String get camera_window_accessibility_label =>
      'Scan en stregkode med dit kamera';

  @override
  String get app_haptic_feedback_title => 'Vibration og haptik';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibration efter udførelse af visse handlinger (stregkode afkodet, produkt fjernet…).';

  @override
  String get crash_reporting_toggle_title => 'Nedbrudsanmeldelse';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Når det er aktiveret, sendes nedbrudsrapporter automatisk til Open Food Facts\' fejlsporingssystem, så fejl kan rettes og dermed forbedre appen.';

  @override
  String get send_anonymous_data_toggle_title => 'Indsend anonyme data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Redigér foto';

  @override
  String get permission_photo_error => 'Fejlmelding';

  @override
  String get permission_photo_denied_title =>
      'Tillad kameraadgang for stregkodeskanning';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Giv $appName adgang til kameraet. Det vil forbedre brugeroplevelsen, da dette muliggør direkte stregkodeskanning.';
  }

  @override
  String get permission_photo_denied_button => 'Tillad';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Tilladelse nægtet';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Da kameraadgang tidligere blev nægtet, skal tilladelsen gives manuelt via Indstillinger.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Åbn indstillinger';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Annullér';

  @override
  String get permission_photo_none_found => 'Intet kamera fundet';

  @override
  String get permission_photo_denied => 'Ingen kameraadgang tildelt';

  @override
  String get show_product_pictures => 'Vis produktbilleder';

  @override
  String get edit_product_label => 'Rediger produkt';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Uploader dine redigeringer…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Dine redigeringer **sendt i baggrunden** (eller senere i tilfælde af fejl).\nDu kan fortsætte med at redigere andre produktfelter.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Dine redigeringer **sendes i baggrunden** (eller senere i tilfælde af fejl).';

  @override
  String get edit_product_label_short => 'Redigér';

  @override
  String edit_product_form_item_help(String value) {
    return 'Hvordan indtaster jeg \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Indtast venligst en ikke-tom værdi!';

  @override
  String get edit_product_form_item_error_existing =>
      'Denne værdi er der allerede!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Tilføj et nyt varemærke';

  @override
  String get edit_product_form_item_add_action_label => 'Tilføj en ny etiket';

  @override
  String get edit_product_form_item_add_action_store => 'Tilføj en ny butik';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Tilføj en ny oprindelse';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Tilføj en ny sporbarhedskode';

  @override
  String get edit_product_form_item_add_action_country => 'Tilføj et nyt land';

  @override
  String get edit_product_form_item_add_action_category =>
      'Tilføj en ny kategori';

  @override
  String get edit_product_form_item_add_action_trace => 'Tilføj et nyt spor';

  @override
  String get edit_product_form_item_add_suggestion => 'Tilføj forslag';

  @override
  String get edit_product_form_item_deny_suggestion => 'Afvis forslag';

  @override
  String get edit_product_form_item_details_title => 'Basisoplysninger';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Produktnavn, mærke, mængde';

  @override
  String get edit_product_form_item_other_details_title =>
      'Yderligere detaljer';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Hjemmeside…';

  @override
  String get edit_product_form_item_photos_title => 'Fotos';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Tilføj eller opfrisk fotos';

  @override
  String get edit_product_form_item_labels_title =>
      'Etiketter og Certificeringer';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Miljø-, kvalitetsmærker…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Indtast en etiket (f.eks.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etiket';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'God praksis: Etiketter';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Enhver egenskab ved produktet **som er faktuel** og forskellig fra de andre felter.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Fremstillet i Danmark, produceret i Skagen…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rig på fibre, kilde til jern…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Butikker';

  @override
  String get edit_product_form_item_stores_hint => 'Indtast en butik';

  @override
  String get edit_product_form_item_stores_type => 'butik';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'God praksis: Butikker';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Indtast den butik, hvor du købte produktet.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Oprindelser';

  @override
  String get edit_product_form_item_origins_hint =>
      'Indtast et oprindelsesland (f.eks.: Tyskland)';

  @override
  String get edit_product_form_item_origins_type => 'land';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'God praksis: Oprindelse';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Tilføj **oprindelsesindikationer, som du kan finde på emballagen**.\nDu behøver ikke bekymre dig om oprindelse angivet direkte i ingredienslisten.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Oksekød fra Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Sojaen kommer ikke fra EU';

  @override
  String get edit_product_form_item_countries_title => 'Land';

  @override
  String get edit_product_form_item_countries_hint =>
      'Indtast et land (f.eks.: Tyskland)';

  @override
  String get edit_product_form_item_countries_type => 'land';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'God praksis: Lande';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Lande, hvor produktet er udbredt** (omfatter ikke butikker, der specialiserer i udenlandske produkter).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Sporbarhedskoder';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Indtast en kode (f.eks.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'sporbarhedskode';

  @override
  String get edit_product_form_item_emb_help_title =>
      'God praksis: Sporbarhedskoder';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'I denne sektion kan du indtaste koder for **emballagemærker**, **identifikationsmærker** eller **sundhedsmærker**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Eksempler på sporbarhedskoder';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EF-koder**, der bruges i Det Europæiske Fællesskab til at identificere fødevareproducenter eller pakkevirksomheder:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: Landekode for **Frankrig**\n**72.264.002**: Geografiske data\n**CE**: Det Europæiske Fællesskab';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB-koder** brugt i Frankrig:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Spor';

  @override
  String get edit_product_form_item_traces_hint => 'spor';

  @override
  String get edit_product_form_item_traces_type =>
      'Indtast et spor (f.eks. sojabønner)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorier';

  @override
  String get edit_product_form_item_categories_hint => 'kategori';

  @override
  String get edit_product_form_item_categories_type =>
      'Indtast en kategori (f.eks. appelsinjuice)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'God praksis: Kategorier';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Angiv **kun den mest specifikke kategori**.\nOverordnede kategorier tilføjes automatisk.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Manglende kategori?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Hvis en kategori **ikke er tilgængelig i autofuldførelse**, må du gerne tilføje den alligevel.\nDet hjælper os med at forbedre Open Food Facts i dit land.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardiner i olivenolie';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Appelsinjuice fra koncentrat';

  @override
  String get edit_product_form_item_exit_title => 'Afslut uden at gemme?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Gem ændringerne, inden siden forlades?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Gem ændringer';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Kassér ændringer';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredienser';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zoom ind og ud ved at knibe på skærmen';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zoom ind og ud på billedet';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Ved hjælp af bevægelsen **Knib for at zoome** kan du zoome ind eller ud på billedet:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Tilføj';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Angiv først en tekst';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Fjern';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Gem din redigering';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Annuller din redigering';

  @override
  String get edit_product_form_item_packaging_title =>
      'Genbrugsvejledningsfoto';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Ernæringsfakta';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Ernæring, alkoholindhold…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'God praksis: Næringsindhold';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Næringsværdier';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Vælg først, om **værdierne er angivet**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Ernæringsfakta';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Indtast derefter næringsværdierne **som angivet på emballagen**. Hvis der ikke er nogen værdi, kan du klikke på \"Øje\"-ikonet.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Manglende felt?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Hvis et felt mangler, kan du **klikke på \"Plus\"-ikonet** for at tilføje det (f.eks. D-vitamin, magnesium...).';

  @override
  String get edit_product_form_save => 'Redigér';

  @override
  String get edit_product_ingredients_photo_title => 'Ingrediensfoto';

  @override
  String get edit_product_ingredients_list_title => 'Ingrediensoversigt';

  @override
  String get edit_product_packaging_photo_title => 'Emballagefoto';

  @override
  String get edit_product_packaging_list_title => 'Emballageliste';

  @override
  String get no_data_available => 'Ingen data tilgængelig';

  @override
  String get product_field_website_title => 'Websted';

  @override
  String get origins_editing_title => 'Rediger oprindelse';

  @override
  String get completed_basic_details_btn_text => 'Udfyld basisoplysninger';

  @override
  String get not_implemented_snackbar_text => 'Endnu ikke implementeret';

  @override
  String get category_picker_page_appbar_text => 'Kategorier';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Udtræk ingredienser fra billedet';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Udtræk ingredienser';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Udtrækker ingredienser\nfra billedet';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Indlæser billede…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Hvorfor ser jeg denne besked?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'For at bruge funktionen \"Udtræk ingredienser\" skal billedet først uploades.\n\nVent et par sekunder, eller indtast dem manuelt.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Opfrisk foto';

  @override
  String get edit_packaging_extract_btn_text =>
      'Udtræk emballage\nfra billedet';

  @override
  String get edit_packaging_extract_btn_text_short => 'Udtræk emballage';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Udtrækker emballage fra billedet';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Indlæser billede…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Hvorfor ser jeg denne besked?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'For at bruge funktionen \"Udtræk emballage\" skal billedet først uploades.\n\nVent et par sekunder, eller indtast dem manuelt.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Opfrisk foto';

  @override
  String get edit_ocr_extract_failed => 'Tekst i fotoet kunne ikke detekteres.';

  @override
  String get edit_ocr_extract_disabled_title => 'Intet billede!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'For at bruge tekstudtrækningsfunktionen skal du først tage et billede.';

  @override
  String get user_list_dialog_new_title => 'Ny produktliste';

  @override
  String get user_list_dialog_rename_title => 'Omdøb liste';

  @override
  String get user_list_subtitle_product => 'Lister';

  @override
  String get user_list_title => 'Dine lister';

  @override
  String get user_list_add_product => 'Føj produktet til dine lister';

  @override
  String get user_list_button_new => 'Opret ny liste';

  @override
  String get user_list_empty_label =>
      'Ingen liste tilgængelig endnu. Start med at oprette én';

  @override
  String get user_list_button_add_product => 'Føj til liste';

  @override
  String get added_to_list_msg => 'Føjet til liste';

  @override
  String get user_list_popup_clear => 'Ryd historikken';

  @override
  String get user_list_popup_rename => 'Omdøb';

  @override
  String get user_list_name_hint => 'Min liste';

  @override
  String get user_list_name_error_empty => 'Navn er obligatorisk';

  @override
  String get user_list_name_error_already => 'Navn bruges allerede';

  @override
  String get user_list_name_error_same => 'Det er samme navn';

  @override
  String get user_list_name_input_hint => 'Listens navn';

  @override
  String get try_again => 'Forsøg igen';

  @override
  String get there_was_an_error => 'En fejl opstod';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Ingen kategori fundet for $items';
  }

  @override
  String get camera_toggle_camera => 'Skift mellem bag- og frontkamera';

  @override
  String get camera_toggle_flash => 'Slå kamerablitz TIL eller FRA';

  @override
  String get camera_enable_flash => 'Aktivere blitz';

  @override
  String get camera_disable_flash => 'Deaktivere blitz';

  @override
  String get camera_flash_error_dialog_title => 'En fejl opstod!';

  @override
  String get camera_flash_error_dialog_message =>
      'En fejl opstod under tilstandsændring for blitzen. Sørg for, at enheden ikke allerede har LED-modulet tændt.';

  @override
  String get category_picker_no_category_found_button => 'Tilbage';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Klik for at åbne i din browser eller i applikationen (hvis installeret)';

  @override
  String get dev_preferences_screen_title => 'DEV-tilstand';

  @override
  String get dev_preferences_screen_subtitle =>
      'Adgang til eksperimentelle funktioner og udviklingsværktøjer';

  @override
  String get dev_preferences_reset_onboarding_title => 'Genstart onboarding';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Appen skal genstartes for at se det igen.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Skift mellem openfoodfacts.org (PROD) og testmiljø';

  @override
  String get dev_preferences_test_environment_title => 'Testmiljøparametre';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Basis-URL til aktuel test-env: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title => 'Testmiljøvært';

  @override
  String get dev_preferences_ml_kit_title => 'Brug ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle => 'dernæst skal appen genstartes';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Yderligere knap på produktsiden';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Redigér ingredienser via en videnspanelknap';

  @override
  String get dev_preferences_export_history_title => 'Eksportér historik';

  @override
  String get dev_preferences_export_history_progress_error => 'undtagelse';

  @override
  String get dev_preferences_export_history_progress_found => 'produkt fundet';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkt IKKE fundet';

  @override
  String get dev_preferences_export_history_dialog_title => 'Eksporte historik';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Annullér';

  @override
  String get dev_preferences_migration_title => 'Datamigrering fra V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'udført eller nyinstallation';

  @override
  String get dev_preferences_migration_status_success => 'udført';

  @override
  String get dev_preferences_migration_status_error => 'fejl';

  @override
  String get dev_preferences_migration_status_in_progress => 'igangværende';

  @override
  String get dev_preferences_migration_status_required =>
      'krævet (klik for at starte)';

  @override
  String get dev_preferences_migration_status_not_started => 'ukendt';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Rydder historikken og lægge 3 produkter i den';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Brugerdefineret URL til nyheder';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL til JSON-filen:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Ikke indstillet';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Sidste opdatering: $date';
  }

  @override
  String get product_type_label_food => 'Fødevare';

  @override
  String get product_type_label_beauty => 'Personlig pleje';

  @override
  String get product_type_label_pet_food => 'Foder til kæledyr';

  @override
  String get product_type_label_product => 'Andet';

  @override
  String get product_type_selection_title => 'Produkttype';

  @override
  String get product_type_selection_subtitle => 'Vælg typen af dette produkt';

  @override
  String get product_type_selection_empty =>
      'Du skal først vælge en produkttype!';

  @override
  String product_type_selection_already(String productType) {
    return 'Du kan ikke ændre produkttypen ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Genvej til Priser-appen på produktsiden';

  @override
  String get prices_app_button => 'Gå til appen Priser';

  @override
  String get prices_website_button => 'Åben på Open Prices-webstedet';

  @override
  String get prices_bulk_proof_upload_select =>
      'Tilføj prismærker direkte fra galleriet';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Når du har valgt billeder, vil du ikke kunne redigere dem!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI vil undersøge dine beviser for at udtrække priser.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Tillad fællesskabet at validere priser udtrukket af AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Flere prismærker';

  @override
  String get prices_bulk_proof_upload_title => 'Bulk bevis upload';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Valg af filer';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Start af uploaden';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokal kopiering af fil #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Forbereder upload #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Mislykkedes ved billede #$index/$count';
  }

  @override
  String get prices_generic_title => 'Priser';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tilføj $count priser',
      one: 'Tilføj en pris',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Send $count priser',
      one: 'Send prisen',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Tilføj et element';

  @override
  String get prices_add_a_price => 'Tilføj en pris';

  @override
  String get prices_add_a_receipt => 'Tilføj en kvittering';

  @override
  String get prices_add_price_tags => 'Tilføj prismærker';

  @override
  String prices_barcode_already(String barcode) {
    return 'Denne stregkode ($barcode) er allerede på listen!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produktet blev ikke fundet';

  @override
  String get prices_barcode_search_none_yet => 'Intet produkt endnu';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Leder efter $barcode';
  }

  @override
  String get prices_barcode_enter => 'Indtast stregkoden';

  @override
  String get prices_category_enter => 'Vare uden stregkode';

  @override
  String get prices_per_kilogram => 'Pris pr. kilogram';

  @override
  String get prices_per_unit => 'Pris pr. enhed';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / enhed';

  @override
  String get prices_category_mandatory => 'Obligatorisk';

  @override
  String get prices_category_optional => 'Valgfri';

  @override
  String get prices_category_error_mandatory => 'Kategorien er obligatorisk';

  @override
  String get prices_barcode_reader_action => 'Stregkodelæser';

  @override
  String get prices_view_prices => 'Se priserne';

  @override
  String get prices_list_title => 'Prisliste';

  @override
  String get prices_list_count => 'Antal\npriser';

  @override
  String get prices_list_add_new_price => 'Tilføj en\nny pris';

  @override
  String get prices_list_empty_title => 'Ingen pris endnu!';

  @override
  String get prices_list_empty_subtitle =>
      'Vær den første til at tilføje en:\nVed at scanne en **kvittering** eller en **prisseddel**!';

  @override
  String get prices_entry_shop_not_found => 'Ukendt butik';

  @override
  String prices_entry_menu_title(String user) {
    return 'Prisindtastning fra \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Se alle priser for dette produkt';

  @override
  String get prices_entry_menu_open_proof => 'Se bevis';

  @override
  String get prices_entry_menu_my_prices => 'Se mine andre priser';

  @override
  String get prices_entry_menu_author_prices =>
      'Se andre priser fra forfatteren';

  @override
  String get prices_entry_menu_shop_prices => 'Se andre priser fra butikken';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count priser',
      one: '1 pris',
    );
    return '$_temp0 for $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count priser',
      one: 'Kun én pris',
      zero: 'Ingen pris endnu',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Seneste $pageSize priser (i alt: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Pris: $price / Butik: \"$location\" / Udgivet på $date af \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Åbne beviser for \"$user\"';
  }

  @override
  String get prices_open_proof => 'Åben prisbevis';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count beviser',
      one: 'Kun ét bevis',
      zero: 'Intet bevis endnu',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Seneste $pageSize beviser (i alt: $total)';
  }

  @override
  String get prices_users_empty_title => 'Ingen bidragyder endnu!';

  @override
  String get prices_users_empty_explanation =>
      'Vær den første til at tilføje en pris!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize bidragydere (i alt: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Ingen butik endnu!';

  @override
  String get prices_locations_empty_explanation =>
      'Vær den første til at tilføje en pris!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize placeringer (i alt: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count beviser',
      one: 'Et bevis',
      zero: 'Intet bevis',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkter',
      one: 'Et produkt',
      zero: 'Intet produkt',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count brugere',
      one: 'Én bruger',
      zero: 'Ingen bruger',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count priser',
      one: 'En pris',
      zero: 'Ingen pris',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Prisen er tidligere tilføjet';

  @override
  String get prices_amount_subtitle => 'Beløb';

  @override
  String get prices_amount_is_discounted => 'Er med rabat?';

  @override
  String get prices_amount_price_normal => 'Pris';

  @override
  String get prices_amount_price_discounted => 'Nedsat pris';

  @override
  String get prices_amount_price_not_discounted => 'Vejledende pris';

  @override
  String get prices_amount_no_product => 'Et produkt mangler!';

  @override
  String get prices_amount_price_incorrect => 'Forkert værdi';

  @override
  String get prices_amount_price_mandatory => 'Obligatorisk værdi';

  @override
  String get prices_currency_subtitle => 'Valuta';

  @override
  String get prices_date_subtitle => 'Dato';

  @override
  String get prices_location_subtitle => 'Butik';

  @override
  String get prices_location_find => 'Find en butik';

  @override
  String get prices_location_mandatory => 'Du skal vælge en butik!';

  @override
  String get prices_location_search_broader =>
      'Kunne du ikke finde det, du ledte efter? Lad os prøve en bredere søgning!';

  @override
  String get prices_proof_subtitle => 'Bevis';

  @override
  String get prices_proof_empty_title => 'Intet bevis endnu!';

  @override
  String get prices_proof_empty_explanation =>
      'Start med at tilføje et billede af en **kvittering** eller et **prisskilt**!';

  @override
  String get prices_proof_find => 'Vælg et bevis';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Kvittering';

  @override
  String get prices_proof_price_tag => 'Prisskilt';

  @override
  String get prices_proof_mandatory => 'Du skal vælge et bevis!';

  @override
  String get prices_add_validation_error => 'Valideringsfejl';

  @override
  String get prices_privacy_warning_title =>
      'Advarsel om personlige oplysninger';

  @override
  String get prices_unknown_product => 'Ukendt produkt';

  @override
  String get prices_privacy_warning_main_message =>
      'Priserne **vil være offentlige**, sammen med den butik, de henviser til.\n\nDet kan give folk, der kender til dit Open Food Facts-pseudonym, mulighed for at:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Udlede, hvilket område du bor i';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Vide, hvad du køber';

  @override
  String get prices_privacy_warning_sub_message =>
      'Hvis du er utryg ved det, bedes du ændre dit pseudonym eller oprette en ny Open Food Facts-konto og logge ind på appen med den.';

  @override
  String get i_refuse => 'Jeg nægter';

  @override
  String get i_accept => 'Jeg accepterer';

  @override
  String get prices_currency_change_proposal_title => 'Ændr valutaen?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Din nuværende valuta er **$currency**. Vil du ændre det til **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ja, brug $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nej, behold $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Færdiggjort';

  @override
  String get dev_mode_section_server => 'Serverkonfiguration';

  @override
  String get dev_mode_section_news => 'Konfiguration af nyhedsudbyder';

  @override
  String get dev_mode_section_product_page => 'Produktside';

  @override
  String get dev_mode_section_ui => 'Brugergrænseflade';

  @override
  String get dev_mode_section_experimental_features =>
      'Eksperimentelle funktioner';

  @override
  String get dev_mode_hide_environmental_score_title => 'Ekskluder GreenScore';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Brug en stavekontrol til OCR-skærme';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredienser og emballage)';

  @override
  String get dev_mode_reset_app_language_title => 'Nulstil appens sprog';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Tilføj kort';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Skift mellem prices.openfoodfacts.org (PROD) og testmiljø';

  @override
  String get search_history_item_edit_tooltip =>
      'Genbrug og redigér denne søgning';

  @override
  String get search_history_item_remove_tooltip => 'Fjern';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Alle $totalSize produkter er downloadet.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Download yderligere $count produkter\nAllerede downloadet $downloaded ud af $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Din søgning på $search er i gang.\n\nVent et par sekunder…';
  }

  @override
  String get user_search_contributor_title => 'Produkter, jeg tilføjede';

  @override
  String get user_search_informer_title => 'Produkter, jeg redigerede';

  @override
  String get user_search_photographer_title => 'Produkter, jeg fotograferede';

  @override
  String get user_search_to_be_completed_title =>
      'Egne produkter til færdiggørelse';

  @override
  String get user_search_prices_title => 'Mine priser';

  @override
  String get user_search_proofs_title => 'Mine beviser';

  @override
  String get user_search_proof_title => 'Mit bevis';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Bidragyderpriser: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Seneste priser tilføjet';

  @override
  String get all_search_prices_top_user_title => 'Toppris bidragydere';

  @override
  String get all_search_prices_top_location_title =>
      'Butikker med flest priser';

  @override
  String get prices_contribution_assistant => 'Prisbidrag Assistent';

  @override
  String get prices_validation_assistant => 'Prisvalideringsassistent';

  @override
  String get prices_challenges_page => 'Udfordringer';

  @override
  String get prices_multiple_proof_addition_system => 'Tilføj flere beviser';

  @override
  String get all_search_prices_top_location_single_title => 'Priser i en butik';

  @override
  String get all_search_prices_top_product_title =>
      'Produkter med flest priser';

  @override
  String get all_search_to_be_completed_title =>
      'Alle produkter til færdiggørelse';

  @override
  String get categorize_products_country_title =>
      'Hjælp med at kategorisere produkter i dit land';

  @override
  String get edit_product_action_retake_picture => 'Tag foto igen';

  @override
  String get edit_product_action_take_picture => 'Tag foto';

  @override
  String get edit_product_action_confirm => 'Bekræft';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Jeg accepterer Open Food Facts\' ';

  @override
  String get signup_page_terms_of_use_line2 => 'vilkår for brug og bidrag';

  @override
  String get analytics_consent_image_semantic_label => 'Analyseikon';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Fatal fejl: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Fatal fejl: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Udfyld basisoplysninger';

  @override
  String get edit_photo_button_label => 'Redigér';

  @override
  String get edit_photo_unselect_button_label => 'Fravælg foto';

  @override
  String get edit_photo_select_existing_button_label =>
      'Vælg et eksisterende foto';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Vælg et billede ved at klikke på det';

  @override
  String get edit_photo_select_existing_download_label =>
      'Henter eksisterende fotos…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Der er ingen tidligere uploadet fotos relateret til dette produkt.';

  @override
  String get edit_photo_language_not_this_one =>
      'Intet foto på det sprog endnu';

  @override
  String get edit_photo_language_none => 'Intet foto endnu';

  @override
  String get category_picker_screen_title => 'Kategorier';

  @override
  String get basic_details => 'Basisoplysninger';

  @override
  String get product_name => 'Produktnavn';

  @override
  String get product_names => 'Produktnavne';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Tilføj en ny oversættelse';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Før du validerer, skal du sørge for kun at tilføje en oversættelse, **hvis sproget er til stede på emballagen**';

  @override
  String get add_basic_details_product_name_open_photo => 'Se frontbillede';

  @override
  String get add_basic_details_product_name_take_photo => 'Tag frontbillede';

  @override
  String get add_basic_details_product_name_hint =>
      'Indtast produktets navn (f.eks.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Ændre standardsproget?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Vil du have produktets standardsprog indstillet til \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Gode eksempler';

  @override
  String get explanation_section_bad_examples => 'Dårlige eksempler';

  @override
  String get add_basic_details_product_name_help_title =>
      'God praksis: Produktnavn';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Produktnavnet er **hovednavnet trykt på emballagen**. Det kan være et registreret varemærke.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Bemærk:** Tilføj venligst ikke en oversættelse **hvis sproget ikke er til stede på emballagen**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomat ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Udelad varemærket i navnet';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomatketchup **af Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Brug ikke symboler ®, ™, © eller lignende';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count andre oversættelser',
      one: '$count anden oversættelse',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Mærkenavn';

  @override
  String get brand_names => 'Varemærker';

  @override
  String get add_basic_details_brand_name_error => 'Angiv mærkenavnet';

  @override
  String get add_basic_details_brand_names_hint =>
      'Input varemærker (f.eks: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'God praksis: Varemærker';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Indtast **alle produktets mærker**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Hovedmærke';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**hovedmærket**, generelt tydeligt vist på frontpakken, skal **indtastes først**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Andre mærker';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Ved salg **af et stort firma**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** sælges af **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Når det sælges med dets mærke **oversat til flere sprog**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** er nogle gange skrevet **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Mængde og vægt';

  @override
  String get add_basic_details_quantity_hint =>
      'Indtast vægten og om nødvendigt mængden (f.eks.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'God praksis: Kvantitet';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Kopier værdien angivet på produktet og **glem ikke enhederne**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** eller **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (til 6 æg)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(for et produkt med 3 æsker, hver på 150g)';

  @override
  String get barcode => 'Stregkode';

  @override
  String barcode_barcode(String barcode) {
    return 'Stregkode: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Ugyldig stregkode';

  @override
  String get basic_details_add_success => 'Basisoplysninger tilføjet';

  @override
  String get basic_details_add_error =>
      'Kan ikke tilføje basisoplydninger. Forsøg igen om lidt';

  @override
  String get clear_search => 'Ryd søgning';

  @override
  String get confirm_clear =>
      'Hele historikken er ved at blive ryddet. Sikker på, at du vil fortsætte?';

  @override
  String get alert_clear_selected_user_list =>
      'Du er ved at rydde valgte emner i historikken';

  @override
  String get confirm_clear_selected_user_list =>
      'Sikker på, at du vil fortsætte?';

  @override
  String get alert_select_items_to_clear =>
      'Vælg et eller flere emner at rydde';

  @override
  String confirm_clear_user_list(String name) {
    return 'Listen ($name) er ved at blive ryddet. Sikker på, at du vil fortsætte?';
  }

  @override
  String get confirm_delete_user_list_title => 'Slet listen?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Listen \"$name\" er ved at blive slettet.\nSikker på, at du vil fortsætte?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ja, jeg er sikker';

  @override
  String importance_label(String name, String id) {
    return '$name-vigtighed: $id';
  }

  @override
  String get user_list_all_title => 'Lister';

  @override
  String get user_list_all_empty => 'Opret din første liste';

  @override
  String get product_list_select => 'Vælg en liste';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkter',
      one: 'Et produkt',
      zero: 'Tom liste',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Tilføj liste';

  @override
  String get open_food_preferences_tooltip =>
      'Redigér dine fødevarepræferencer';

  @override
  String get add_photo_button_label => 'Tilføj foto';

  @override
  String get add_packaging_photo_button_label =>
      'Tag fotos af enhver emballage-/genbrugsinformation';

  @override
  String get add_origin_photo_button_label =>
      'Tag billeder af oprindelsesinformation';

  @override
  String get add_emb_photo_button_label =>
      'Tag billeder af eventuelle sporbarhedskodeoplysninger';

  @override
  String get add_label_photo_button_label =>
      'Tag billeder af eventuelle etiketter og certificeringsoplysninger';

  @override
  String get choose_image_source_title => 'Vælg billedkilde';

  @override
  String get choose_image_source_body => 'Vælg en billedkilde';

  @override
  String get gallery_source_label => 'Galleri';

  @override
  String get gallery_source_access_denied_dialog_title => 'Adgang nægtet';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Desværre kan applikationen ikke få adgang til dit galleri, da du tidligere har nægtet tilladelsen.\n\nGå til appindstillingerne i din telefon Indstillinger -> Billeder';

  @override
  String get gallery_source_access_denied_dialog_button => 'Åbn indstillinger';

  @override
  String get share => 'Del';

  @override
  String share_product_text(String url) {
    return 'Se dette produkt på Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Tag et kig på dette produkt på Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Tag et kig på dette produkt på Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Tag et kig på dette produkt på Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Tag et kig på min liste over produkter på Open Food Facts: $url';
  }

  @override
  String get capture => 'Tag et nyt';

  @override
  String get capture_new_picture => 'Tag et billede';

  @override
  String get choose_from_gallery => 'Vælg fra galleri';

  @override
  String get image_upload_queued =>
      'Fotoet uploades i baggrunden hurtigst muligt.';

  @override
  String get add_price_queued =>
      'Prisen vil blive sendt til serveren hurtigst muligt.';

  @override
  String get background_task_title_full_refresh =>
      'Starter opdateringen af alle de lokalt lagrede produkter';

  @override
  String get background_task_title_top_n =>
      'Starter download af de mest populære produkter';

  @override
  String get expand_nutrition_facts => 'Udvid ernæringsfaktatabellen';

  @override
  String get expand_nutrition_facts_body =>
      'Hold ernæringsfaktatabellen udvidet';

  @override
  String get expand_ingredients => 'Udvid ingredienser';

  @override
  String get expand_ingredients_body => 'Hold ingredienspanelet udvidet';

  @override
  String get no_internet_connection => 'Ingen internetforbindelse';

  @override
  String get world_results_label => 'Hele verden';

  @override
  String get world_results_action => 'Udvid søgningen til verden';

  @override
  String get copy_to_clipboard => 'Kopiér';

  @override
  String get paste_from_clipboard => 'Indsæt fra udklipsholder';

  @override
  String get no_data_available_in_clipboard =>
      'Ingen tilgængelige data i din udklipsholder';

  @override
  String get clipboard_barcode_copy => 'Kopiér stregkoden til udklipsholderen';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Stregkoden $barcode kopieret til udklipsholderen!';
  }

  @override
  String get open_product_website => 'Åbn dette produkt på hjemmesiden';

  @override
  String get language_picker_label => 'Dit sprog';

  @override
  String get country_picker_label => 'Dit land';

  @override
  String get currency_picker_label => 'Din valuta';

  @override
  String get help_with_openfoodfacts => 'Hjælp med OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produktet uploades i baggrunden hurtigst muligt.';

  @override
  String get no_email_client_available_dialog_title => 'Ingen e-mail apps!';

  @override
  String get no_email_client_available_dialog_content =>
      'Send os venligst en e-mail manuelt til mobile@openfoodfacts.org';

  @override
  String get all_images => 'Alle fotos';

  @override
  String get selected_images => 'Valgte fotos';

  @override
  String get product_card_remove_product_tooltip => 'Fjern produkt';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Ny stregkode skannet: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Fjern alle produkter fra karrusellen';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Skan mindst to produkter for at sammenligne dem';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klik for at sammenligne de skannede produkter';

  @override
  String get scan_product_loading => 'Flg. stregkode er\nblevet skannet:';

  @override
  String get scan_product_loading_initial =>
      'Productet fremsøges!\nVent venligst et øjeblik…';

  @override
  String get scan_product_loading_long_request =>
      'Der søges stadig efter dette produkt!\nSynes det tager for langt tid at finde? Det gør vi også…';

  @override
  String get scan_product_loading_unresponsive =>
      'Der søges stadig efter dette produkt.\nØnsker at genstarte søgningen?';

  @override
  String get scan_product_loading_restart_button => 'Genstart søgning';

  @override
  String get portion_calculator_description =>
      'Beregn ernæringfakta for en bestemt mængde';

  @override
  String get portion_calculator_hint => 'Mængde i';

  @override
  String get portion_calculator_accessibility =>
      'Angiv mængde for at beregne ernæringsfakta';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Angiv en mængde mellem $min og $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Manglende data. Beregningen kunne ikke udføres.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Næringsfakta for $grams g (eller ml)';
  }

  @override
  String get offline_data => 'Offline-data';

  @override
  String get ocr_image_upload_instruction =>
      'Upload et foto for auto-udtræk af oplysningerne herfra.';

  @override
  String get upload_image => 'Upload foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Mislykkedes at downloade foto';

  @override
  String get image_edit_url_error =>
      'Mislykkedes at redigere foto grundet manglende foto-URL.';

  @override
  String get user_picture_source_remember => 'Husk valg';

  @override
  String get user_picture_source_ask => 'Spørg hver gang';

  @override
  String get robotoff_continue => 'Fortsæt';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count spørgsmål',
      one: 'spørgsmål',
    );
    return 'Næste $_temp0';
  }

  @override
  String get show_password => 'Vis adgangskode';

  @override
  String get owner_field_info_title => 'Producentens angivne værdier';

  @override
  String get owner_field_info_message =>
      'Med dette logo fremhæver vi data leveret af producenten, og som muligvis ikke kan redigeres.';

  @override
  String get owner_field_info_close_button => 'Luk denne info';

  @override
  String get owner_field_image =>
      'Dette billede leveres af producenten og kan muligvis ikke redigeres.';

  @override
  String get edit_packagings_title => 'Emballagekomponenter';

  @override
  String get edit_packagings_element_add => 'Tilføj en emballagekomponent';

  @override
  String get edit_packagings_completed => 'Emballagen er komplet';

  @override
  String edit_packagings_element_title(int index) {
    return 'Emballagekomponent #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Antal enheder';

  @override
  String get edit_packagings_element_hint_units =>
      'Angiv antallet af emballageenheder af samme form og materiale indeholdt i produktet.';

  @override
  String get edit_packagings_element_field_shape => 'Form';

  @override
  String get edit_packagings_element_hint_shape =>
      'Angiv formnavnet oplyst i genbrugsvejledningen (hvis tilgængelig), eller vælg en form.';

  @override
  String get edit_packagings_element_example_shape => 'Flaske';

  @override
  String get edit_packagings_element_field_material => 'Materiale';

  @override
  String get edit_packagings_element_hint_material =>
      'Angiv det specifikke materiale, hvis det kan bestemmes (en materialekode i en trekant findes ofte på emballagedele), eller et generisk materiale (f.eks. plastik eller metal), hvis der er tvivl.';

  @override
  String get edit_packagings_element_example_material => 'Glas';

  @override
  String get edit_packagings_element_field_recycling => 'Genbrugsvejledning';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Angiv kun genbrugsvejledningen anført på selve produktet.';

  @override
  String get edit_packagings_element_example_recycling => 'Genbrug';

  @override
  String get edit_packagings_element_field_quantity =>
      'Produktnettomængde pr. enhed';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Angiv nettovægten eller nettovolumen samt enheden (f.eks. g eller ml).';

  @override
  String get edit_packagings_element_field_weight => 'Vægt af én tom enhed (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Fjern evt. madrester, og afvask og aftør emballagedelen før vejning. Benyt om muligt en vægt med 0,1 g eller 0,01 g skalainddeling.';

  @override
  String get background_task_title => 'Afventende bidrag';

  @override
  String get background_task_subtitle =>
      'Bidragene auto-gemmes på vores server (dog ikke altid i realtid).';

  @override
  String get background_task_list_empty => 'Ingen afventende baggrundsopgaver';

  @override
  String get background_task_error_server_time_out => 'Server-timeout';

  @override
  String get background_task_error_no_internet =>
      'Internetforbindelsesfejl. Forsøg senere.';

  @override
  String get background_task_operation_unknown => 'ukendt operationstype';

  @override
  String get background_task_operation_details => 'detaljerede ændringer';

  @override
  String get background_task_operation_image => 'foto-upload';

  @override
  String get background_task_operation_refresh =>
      'opdatering forsinket efter foto-upload';

  @override
  String get background_task_run_started => 'startet';

  @override
  String get background_task_run_not_started => 'ikke startet endnu';

  @override
  String get background_task_run_to_be_deleted => 'skal slettes';

  @override
  String get background_task_question_stop => 'Stop opgaven straks?';

  @override
  String get feed_back => 'Feedback';

  @override
  String get undo => 'Fortryd';

  @override
  String get copy_email_to_clip_board => 'Kopiér e-mail til upklipsholder';

  @override
  String get please_send_us_an_email_to => 'Send os manuelt en e-mail til';

  @override
  String get email_copied_to_clip_board => 'E-mail kopieret til udklipsholder!';

  @override
  String get select_accent_color => 'Vælg fremhævningsfarve';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blå';

  @override
  String get color_cyan => 'Cyan';

  @override
  String get color_green => 'Grøn';

  @override
  String get color_light_brown => 'Standard';

  @override
  String get color_magenta => 'Rødlilla';

  @override
  String get color_orange => 'Orange';

  @override
  String get color_pink => 'Lyserød';

  @override
  String get color_red => 'Rød';

  @override
  String get color_rust => 'Rustfarvet';

  @override
  String get color_teal => 'Blågrøn';

  @override
  String get text_contrast_mode => 'Tekstkontrast';

  @override
  String get contrast_high => 'Høj';

  @override
  String get contrast_medium => 'Mellem';

  @override
  String get contrast_low => 'Lav';

  @override
  String get product_refresher_internet_not_found => 'Produkt ikke fundet!';

  @override
  String get product_refresher_internet_not_connected =>
      'Du er ikke forbundet til internettet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server nede ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Serverfejl ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produkt ikke fundet!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Et produkt med flg. stregkode findes ikke i databasen: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Ingen internetforbindelse!';

  @override
  String get product_loader_network_error_message =>
      'Tjek, at mobilen er på et Wi-Fi netværk eller har mobildata aktiveret';

  @override
  String get page_not_found_title => 'Side ikke fundet!';

  @override
  String get page_not_found_button => 'Gå til startside';

  @override
  String get download_data => 'Download data';

  @override
  String get download_top_products =>
      'Download de 1.000 bedste produkter i dit land til omgående skanning';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count topprodukterne',
    );
    return 'Download $_temp0 i dit land til øjeblikkelig skanning';
  }

  @override
  String get download_in_progress => 'Downloader data\nDette kan tage lidt tid';

  @override
  String downloaded_products(int num) {
    return '$num produkter tilføjet';
  }

  @override
  String get update_offline_data => 'Opdatér offlineproduktdata';

  @override
  String get update_local_database_sub =>
      'Opdater den lokale produktdatabase med de nyeste data fra Open Food Facts';

  @override
  String get clear_local_database => 'Ryd offlineproduktdata';

  @override
  String get clear_local_database_sub =>
      'Ryd alle lokale produktdata fra appen for at frigøre plads';

  @override
  String deleted_products(int num) {
    return '$num produkter slettet';
  }

  @override
  String get loading => 'Indlæser…';

  @override
  String get know_more => 'Få mere at vide';

  @override
  String get offline_data_desc => 'Klik for at mere information om offlinedata';

  @override
  String get offline_product_data_title => 'Offlineproduktdata';

  @override
  String available_for_download(int num) {
    return '$num produkter tilgængelige til omgående skanning';
  }

  @override
  String get country_selector_title => 'Vælg dit land:';

  @override
  String get currency_selector_title => 'Vælg din valuta:';

  @override
  String get language_selector_title => 'Vælg dit sprog:';

  @override
  String get language_selector_section_selected => 'Valgte sprog';

  @override
  String get language_selector_section_frequently_used => 'Ofte brugt';

  @override
  String get action_delete_list => 'Slet';

  @override
  String get action_change_list => 'Ændrer den aktuelle liste';

  @override
  String get product_list_create => 'Opret';

  @override
  String get product_list_create_tooltip => 'Opret ny liste';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Ny beregning)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Ny beregning)';

  @override
  String get nutriscore_unknown => 'Ukendt Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Ukendt Nutri-Score (Ny beregning)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score er ikke tilgængeligt';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score er ikke tilgængeligt (Ny beregning)';

  @override
  String get environmental_score_generic_new => 'Øko-Score';

  @override
  String get environmental_score_a_new => 'Grøn-Score A';

  @override
  String get environmental_score_b_new => 'Grøn-Score B';

  @override
  String get environmental_score_c_new => 'Grøn-Score C';

  @override
  String get environmental_score_d_new => 'Grøn-Score D';

  @override
  String get environmental_score_e_new => 'Grøn-Score E';

  @override
  String get environmental_score_unknown_new => 'Ukendt grøn score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score er ikke relevant';

  @override
  String get nova_group_generic_new =>
      'Ultraforarbejdede fødevarer - NOVA-grupper';

  @override
  String get nova_group_1 => 'NOVA-gruppe 1';

  @override
  String get nova_group_2 => 'NOVA-gruppe 2';

  @override
  String get nova_group_3 => 'NOVA-gruppe 3';

  @override
  String get nova_group_4 => 'NOVA-gruppe 4';

  @override
  String get nova_group_unknown => 'Ukendt NOVA-gruppe';

  @override
  String get nutrition_facts => 'Næringsstofniveauer';

  @override
  String get faq_title_partners => 'NGO\'ens partnere og protektorer';

  @override
  String get faq_title_vision =>
      'Open Food Facts\' vision, mission, værdier og programmer';

  @override
  String get faq_title_install_beauty =>
      'Installer Open Beauty Facts for at oprette en kosmetisk database';

  @override
  String get faq_title_install_pet =>
      'Installer Open Pet Food Facts for at oprette en dyrefoderdatabase';

  @override
  String get faq_title_install_product =>
      'Installer Open Products Facts for at oprette en produktdatabase for at forlænge objekternes levetid';

  @override
  String get faq_nutriscore_nutriscore =>
      'Ny beregning af Nutri-Score: hvad er nyt?';

  @override
  String get contact_title_pro_page =>
      'Prof? Importér dine produkter i Open Food Facts';

  @override
  String get contact_title_pro_email => 'Producent kontakt';

  @override
  String get contact_title_press_page => 'Presseside';

  @override
  String get contact_title_press_email => 'Pressekontakt';

  @override
  String get contact_title_newsletter => 'Abonnér på nyhedsbrevet';

  @override
  String get contact_title_calendar => 'Abonner på vores fællesskabskalender';

  @override
  String get hunger_games_loading_line1 => 'Giv os venligst et par sekunder…';

  @override
  String get hunger_games_loading_line2 => 'Vi henter spørgsmålene!';

  @override
  String get hunger_games_error_label =>
      'Åh nej! Noget gik galt, og vi kunne ikke indlæse spørgsmålene.';

  @override
  String get hunger_games_error_retry_button => 'Lad os prøve igen!';

  @override
  String get reorder_attribute_action => 'Omarranger attributterne';

  @override
  String get link_cant_be_opened =>
      'Dette link kan ikke åbnes på din enhed. Tjek venligst, at du har en browser installeret.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detaljer for $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detaljer for $pageName med $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Del';

  @override
  String get guide_nutriscore_v2_title =>
      'Nutri-Score udvikler sig: forklaringer!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Hvad er Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score er et logo, der har til formål at informere dig om den **ernæringsmæssige kvalitet af fødevarer**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Farvekoden varierer fra mørkegrøn (**A**) for de **sundeste** produkter til mørkerøde (**E**) for de **mindre sunde**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption => 'Nutri-Score A-logoet';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Hvorfor udvikler Nutri-Score sig?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Nutri-Score-formlen **er under udvikling** for at give bedre anbefalinger:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Bedre vurdere alle drikkevarer';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'De sammenlignende noter af **mælk**, **mælkedrikke** tilsat sukker og **vegetabilske drikkevarer var bedre differentieret i den nye algoritme.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Bedre rangering af drikkevarer';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'Der tages bedre hensyn til **sukkerindholdet** og favoriserer **lavt sødede** drikke.\\n**Sødestoffer vil også blive straffet**: Diætsodavand nedgraderes fra en B-vurdering til mellem C og E. Vand er fortsat den anbefalede drik.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title => 'Salt og sukker straffes';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Produkter **for søde** eller **for salte** vil se deres **vurdering yderligere nedgraderet**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarki inden for olier og fisk';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Bedømmelsen af visse **fede fisk** og **olier rige på gode fedtstoffer** vil forbedres.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Begræns rødt kød';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Forbruget af **rødt kød bør begrænses**. Dette er grunden til, at **fjerkræ vil være forholdsvis bedre rangeret**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Hvordan skelner man mellem gammel Nutri-Score og ny beregning?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Fra nu af kan logoet vise en omtale \"**Ny beregning**\" for at tydeliggøre, at dette faktisk er den nye beregning.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Logoet for den nye Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Hvor finder man den nye Nutri-Score-beregning?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score anvendes i 7 lande: Frankrig, Tyskland, Belgien, Spanien, Luxembourg, Holland og Schweiz.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Producenter har højst **2 år** senest efter underskrivelsen af dekretet **til at erstatte** den gamle beregning med den nye.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Uden at vente **finder du allerede den nye beregning i OpenFoodFacts-applikationen**, herunder hvis producenterne ikke har opdateret scoren.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Hvad ændrer sig ikke';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score er en score designet til at **måle ernæringskvalitet**. Den er **supplerende til NOVA-gruppen** om **ultraforarbejdede fødevarer** (også til stede i ansøgningen).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For producenter er visningen af Nutri-Score ** fortsat valgfri**.';

  @override
  String get guide_greenscore_title => 'Øko-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Hvad er den grønne score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score er et logo, der har til formål at informere dig om **fødevarers miljøpåvirkning**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Farvekoden varierer fra mørkegrøn (**A+**) for de **mindst effektfulde** produkter til mørkerød (**F**) for de **mest effektfulde** produkter.';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score-logoerne';

  @override
  String get guide_greenscore_lca_title => 'Kernen: Livscyklusvurdering (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'En videnskabelig evaluering af fødevarekategorier';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'For hver produktkategori fastsættes en **benchmark**-score ved hjælp af data fra Agribalyse-miljødatabasen (udviklet af ADEME og INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Livscyklusanalyse** er en standardiseret vurderingsmetode til udførelse af en flertrins- og flerkriterie-miljøvurdering.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Den måler:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 produktionstrin';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Landbrug';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Bearbejdning';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Emballage';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Forbrug';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indikatorer for miljøpåvirkning';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Klimaforandringer/kulstofaftryk';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Udtømning af ozonlaget';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ioniserende stråling';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Jord';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Vand- og energiforbrug';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Luftforurening';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Hav- og ferskvand (partikler, forsuring, eutrofiering)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Udtømning af ressourcer.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonusser og sanktioner';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Produktionsmåde';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Oprindelse af ingredienser';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title => 'Truede arter';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Emballage';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Et øget behov for gennemsigtighed for bedre at kunne måle og reducere miljøpåvirkninger';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Hvordan kan vi hver især hjælpe?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Alle mennesker kan hjælpe med at indsamle og strukturere information, der til stede på produkter eller som kan trækkes ud af dem. Det kunne være information om **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Hvordan producenter kan hjælpe';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Producenter kan sende os deres oplysninger direkte via vores gratis platform for producenter.';

  @override
  String get guide_greenscore_better_product_title =>
      'Hvilket produkt er bedst for planeten?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Det kan være svært at sige';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'At vælge bæredygtige fødevarer er en af de mest effektive ting, vi kan gøre for klimaet, da **vores globale fødevaresystem er ansvarlig for over en fjerdedel af alle drivhusgasemissioner**.\n(Kilde: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Du har magten!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Den gode nyhed er, at dette giver os en effektiv måde at skabe forandring på.\n**Hver af os spiser omkring 1.000 måltider hvert år**. Det er 1.000 muligheder for at **vælge en bedre fremtid for planeten**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Hjælper med at være ansvarlig og træffe beslutninger';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Det kan føles komplekst at vælge bæredygtige fødevarer. Etiketter er forvirrende, og der mangler ofte information. Green-Score blev skabt for at gøre det enkelt, og giver dig en **klar**, **videnskabeligt baseret** og **transparent** miljøvurdering af fødevarer, lige der hvor du har brug for den: mens du handler.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Gennemsigtighed';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'I modsætning til proprietære etiketter er Green-Score-beregningen **fuldstændig åben** og kan **verificeres af alle**.';

  @override
  String get guide_nova_title => 'Ultraforarbejdede fødevarer';

  @override
  String get guide_nova_what_is_nova_title => 'Hvad er ultraprocessering?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'NOVA-grupperne informerer dig om niveauet af fødevareforarbejdning.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA-klassificeringen muliggør kategorisering af fødevarer i **4 grupper** baseret på deres **grad af industriel forarbejdning** (minimalt forarbejdede eller uforarbejdede fødevarer, kulinariske ingredienser, forarbejdede fødevarer, ultraforarbejdede fødevarer).';

  @override
  String get guide_nova_logos_caption => 'NOVA-logoerne';

  @override
  String get guide_nova_groups_title => 'De 4 NOVA-grupper';

  @override
  String get guide_nova_groups_intro =>
      'Der er 4 NOVA-grupper, hvor den problematiske er Gruppe 4 - Ultraforarbejdede fødevarer.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimalt forarbejdede eller uforarbejdede fødevarer';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Forarbejdede kulinariske ingredienser';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Forarbejdede fødevarer';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. Processes include various preservation or cooking methods, and in the case of breads and cheese, Non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultraforarbejdede fødevarer';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to No intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, Or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically Used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Problemerne med ultraprocessering';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Ekstrem forarbejdning af fødevareingredienser';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Tilsætningsstoffer, der går ud over ren fødevaresikkerhed';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Bearbejdning, du ikke kan gøre derhjemme';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'De aggressive og økonomiske aspekter af ultraforarbejdning';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-da.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Velkommen til OpenFoodFacts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Hvad er Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-da.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-da.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-da.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Der er i øjeblikket få virksomheder, der ejer store databaser over produktpriser på stregkodeniveau. Disse priser er ikke frit tilgængelige, men sælges til en høj pris til private aktører, forskere og andre organisationer, der har råd til dem.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'Jeg er forhandler, og jeg vil gerne bidrage med priser. Hvordan kan jeg gøre det?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-da.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Forhåndsvisning';

  @override
  String get prices_feedback_form =>
      'Klik her for at sende os din feedback om denne nye funktion!';

  @override
  String get menu_button_list_actions => 'Vælg en handling';

  @override
  String get error_loading_photo => 'Fejl ved indlæsning af billede';

  @override
  String get photo_viewer_action_use_picture_as => 'Brug som…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Brug dette billede som…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Brug dette billede som… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detaljer';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detaljer om dette foto';

  @override
  String get photo_viewer_details_title => 'Detaljer om billedet';

  @override
  String get photo_viewer_details_contributor_title => 'Bidragsyder';

  @override
  String get photo_viewer_details_size_title => 'Størrelse';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Dato';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Kompatibel';

  @override
  String get user_lists_action_multi_select => 'Vælg flere';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Din kompatibilitetsscore: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Forsidebillede';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Billede af ingredienser';

  @override
  String get product_image_nutrition_accessibility_label => 'Ernæringsbillede';

  @override
  String get product_image_packaging_accessibility_label => 'Emballage billede';

  @override
  String get product_image_other_accessibility_label => 'Andet billede';

  @override
  String get product_image_outdated_message =>
      'Dette billede kan være forældet';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (dette billede kan være forældet)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (dette billede kan være låst af producenten)';
  }

  @override
  String get product_image_error => 'Kan ikke indlæse billedet!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Kan ikke indlæse $type (netværksfejl?)';
  }

  @override
  String get product_page_image_no_image_available => 'Intet\nbillede!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Intet billede tilgængeligt for dette produkt';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Omarranger eller skjul handlinger';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Rediger handlinger';

  @override
  String get product_page_action_bar_item_move_up => 'Flyt op';

  @override
  String get product_page_action_bar_item_move_down => 'Flyt ned';

  @override
  String get product_page_action_bar_item_enable => 'Aktiver handling';

  @override
  String get product_page_action_bar_item_disable => 'Deaktiver handling';

  @override
  String get product_page_pending_operations_banner_title =>
      'Uploader dine redigeringer…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Dataene vist på denne side **afspejler endnu ikke dine ændringer**.\nVent et par sekunder…';

  @override
  String get product_add_a_language => 'Tilføj et sprog';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Stregkode $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Fjern dette produkt fra karrusellen';

  @override
  String get carousel_unsupported_header => 'Ikke-understøttet stregkode!';

  @override
  String get carousel_unsupported_title => 'Hovsa!';

  @override
  String get carousel_unsupported_text =>
      'Den scannede stregkode understøttes ikke af Open Food Facts!';

  @override
  String get carousel_error_header => 'Fejl!';

  @override
  String get carousel_error_title => 'Det er ærgerligt!';

  @override
  String get carousel_error_text_1 =>
      'Vi kunne ikke hente oplysninger om denne stregkode:';

  @override
  String get carousel_error_text_2 =>
      'Tjek din internetforbindelse, eller klik på denne knap:';

  @override
  String get carousel_error_button => 'Forsøg igen';

  @override
  String get carousel_unknown_product_header => 'Ukendt produkt';

  @override
  String get carousel_unknown_product_title =>
      'Tillykke!\nDu har fundet __den sjældne perle!__';

  @override
  String get carousel_unknown_product_text =>
      'Vores samarbejdsdatabase indeholder mere end **3 millioner produkter**, men denne stregkode findes ikke: ';

  @override
  String get carousel_unknown_product_button => 'Tilføj dette produkt';

  @override
  String get carousel_loading_header => 'Indlæser oplysninger…';

  @override
  String get carousel_loading_title =>
      'Du har lige scannet et produkt med følgende stregkode:';

  @override
  String get carousel_loading_text =>
      'Vi søger efter det i vores database med mere end **3 millioner produkter!**';

  @override
  String get product_type_subtitle_food =>
      'Grøntsager, frugter, frosne fødevarer…';

  @override
  String get product_type_subtitle_beauty => 'Makeup, sæber, tandpastaer…';

  @override
  String get product_type_subtitle_pet_food => 'Foder til hunde, katte…';

  @override
  String get product_type_subtitle_product => 'Smartphones, møbler…';

  @override
  String get photo_field_front => 'Produktfoto';

  @override
  String get photo_field_ingredients => 'Ingrediensfoto';

  @override
  String get photo_field_nutrition => 'Ernæringsfoto';

  @override
  String get photo_field_packaging => 'Emballageoplysningsfoto';

  @override
  String get photo_already_exists => 'Dette billede findes allerede';

  @override
  String get photo_missing => 'Dette billede mangler';

  @override
  String get date => 'Dato';

  @override
  String get photo_rotate_left => 'Rotér venstre om';

  @override
  String get photo_rotate_right => 'Rotér højre om';

  @override
  String get photo_undo_action => 'Fortryd den sidste handling';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Et verdenskort over $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap-bidragydere';

  @override
  String get not_applicable_short => 'Ikke tilgængelig';

  @override
  String get knowledge_panel_warning_text => 'Advarsel';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Hvorfor er denne Nutri-Score anderledes end den på pakken?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Der er to mulige forklaringer:\nIngredienslisten og/eller næringsindhold er ikke opdateret.\n\nVi leverer \"Ny beregning\" af Nutri-Score (eller V2). Tjek venligst, at du har banneret \"Ny beregning\" på pakken.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Tjek ingredienser';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Tjek næringsindhold';

  @override
  String url_not_supported(String url) {
    return 'Vi kan desværre ikke åbne URL\'en:\n$url';
  }

  @override
  String get product_list_export => 'Eksportér';

  @override
  String get product_list_import => 'Importér';

  @override
  String get product_footer_action_barcode => 'Se stregkode';

  @override
  String get product_footer_action_barcode_short => 'Stregkode';

  @override
  String get product_footer_action_open_website => 'Åbn hjemmeside';

  @override
  String get product_footer_action_report => 'Rapportér';

  @override
  String get product_footer_action_contributor_guide => 'Hjælp';

  @override
  String get product_footer_action_data_quality_tags => 'Datakvalitet';

  @override
  String get product_page_tab_for_me => 'For mig';

  @override
  String get product_page_tab_website => 'Websted';

  @override
  String get product_page_tab_prices => 'Priser';

  @override
  String get prices_explanation_card_title => 'Hvorfor priser?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** er et projekt til at indsamle og dele priser på produkter fra hele verden 🌍. Open Prices er udviklet og vedligeholdt af Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Få mere at vide';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Hvad er Folksonomys attributter?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Attributter er **nøgleværdibaserede**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Disse egenskaber oprettes og arkiveres af bidragydere til enhver form for anvendelse.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Ingen pris tilgængelig';

  @override
  String get prices_products_empty_explanation =>
      'Vær den første til at bidrage!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize produkter (i alt: $total)';
  }

  @override
  String get app_review_title => 'Nyder du appen?';

  @override
  String get app_review_low => 'Kunne gøre det bedre';

  @override
  String get app_review_medium => 'Ikke dårligt';

  @override
  String get app_review_high => 'Jeg elsker den!';

  @override
  String get app_review_feedback_modal_title =>
      'Hjælp os med at forbedre vores applikation';

  @override
  String get app_review_feedback_modal_content =>
      'Hvis du har et par minutter, kan du besvare denne formular, så **vi kan forbedre os i fremtidige opdateringer**:';

  @override
  String get app_review_feedback_modal_open_form => 'Besvar formularen';

  @override
  String get app_review_feedback_modal_later => 'Spørg mig senere';

  @override
  String get nutrition_facts_extract_new =>
      'NYHED: Du kan automatisk udtrække næringsstofferne fra billedet!';

  @override
  String get nutrition_facts_extract_button_text => 'Udtræk nu';

  @override
  String get nutrition_facts_extract_in_progress => 'Udtrækning i gang…';

  @override
  String get nutrition_facts_extract_successful => 'Udtrækningen er gennemført';

  @override
  String get nutrition_facts_extract_failed =>
      'Kunne ikke udtrække næringsstoffer fra billedet';

  @override
  String get prices_discount => 'Rabat';

  @override
  String get prices_stats_statistics => 'Statistik';

  @override
  String get prices_stats_title => 'Prisstatistik';

  @override
  String get prices_stats_prices_section => 'Priser';

  @override
  String get prices_stats_products_section => 'Produkter';

  @override
  String get prices_stats_locations_section => 'Placeringer';

  @override
  String get prices_stats_proofs_section => 'Beviser';

  @override
  String get prices_stats_contributors_section => 'Bidragsydere';

  @override
  String get prices_stats_experiments_section => 'Eksperimenter';

  @override
  String get prices_stats_misc_section => 'Diverse';

  @override
  String get prices_stats_total => 'I alt';

  @override
  String get prices_stats_with_barcode => 'Med en stregkode';

  @override
  String get prices_stats_with_category => 'Med en kategori';

  @override
  String get prices_stats_with_discount => 'Med rabat';

  @override
  String get prices_stats_community => 'Fællesskab';

  @override
  String get prices_stats_consumption => 'Forbrug';

  @override
  String get prices_stats_with_price => 'Med en pris';

  @override
  String get prices_stats_food => 'Fødevare';

  @override
  String get prices_stats_beauty => 'Skønhed';

  @override
  String get prices_stats_products => 'Produkter';

  @override
  String get prices_stats_pet_food => 'Foder til kæledyr';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Lande';

  @override
  String get prices_stats_price_tag => 'Prisskilt';

  @override
  String get prices_stats_receipt => 'Kvittering';

  @override
  String get prices_stats_gdpr_request => 'GDPR anmodning';

  @override
  String get prices_stats_shop_import => 'Butik import';

  @override
  String get prices_stats_challenges => 'Udfordringer';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Priser knyttet til en prisskiltning';

  @override
  String get prices_stats_currencies => 'Valutaer';

  @override
  String get prices_stats_years => 'År';

  @override
  String get prices_stats_by_source_title => 'Priser og beviser pr. kilde';

  @override
  String get prices_stats_website => 'Websted';

  @override
  String get prices_stats_mobile_app => 'Mobil app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Andet';

  @override
  String get prices_stats_last_updated => 'Sidst opdateret den';

  @override
  String get prices_stats_error =>
      'Der opstod en fejl under indlæsning af statistik.';

  @override
  String get product_edit_robotoff_question_answered => 'Spørgsmål besvaret!';

  @override
  String get product_edit_robotoff_proof => 'Bevis';

  @override
  String get preferences_card_general => 'Generelt';

  @override
  String get preferences_prices_title => 'Priser';

  @override
  String get preferences_prices_subtitle => 'Administrer dine prispræferencer';

  @override
  String get preferences_card_project => 'Open Food Facts-projektet';

  @override
  String get preferences_contribute_title => 'Bidrag';

  @override
  String get preferences_my_contributions_title => 'Mine bidrag';

  @override
  String get preferences_my_stats_title => 'Min statistik';

  @override
  String get preferences_contribute_subtitle =>
      'Oversæt, forbedr vores værktøjer…';

  @override
  String get preferences_connect_title => 'Forbinde';

  @override
  String get preferences_connect_subtitle =>
      'Kontakt os, eller følg os på de sociale medier';

  @override
  String get preferences_support_title => 'Donér';

  @override
  String get preferences_support_subtitle =>
      'Hjælp os med at informere millioner af forbrugere verden over';

  @override
  String get preferences_card_help => 'Hjælp og support';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Få svar på dine spørgsmål';

  @override
  String get logged_out => 'Logget ud';

  @override
  String get preferences_app_bar_message =>
      'Tak fordi du er et af vores medlemmer!';

  @override
  String get preferences_app_bar_products_modified => 'Ændrede produkter';

  @override
  String get preferences_app_bar_prices_added => 'Priser tilføjet';

  @override
  String get preferences_app_bar_see_all_stats => 'Se alle statistikker';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Søg $provider efter \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Søg efter en indstilling (f.eks. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Tilgængelighed: Vis emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Tilgængelighed: Fjern farver';

  @override
  String get preferences_app_settings_products => 'Produkter';

  @override
  String get preferences_card_about => 'Om';

  @override
  String get preferences_legal_information_title => 'Juridiske oplysninger';

  @override
  String get preferences_legal_information_subtitle =>
      'Brugsbetingelser, privatlivspolitik og mere';

  @override
  String get preferences_terms_of_use => 'Brugsvilkår';

  @override
  String get preferences_legal_mentions => 'Juridiske forhold';

  @override
  String get preferences_legal_header =>
      'Open Food Facts er en fødevaredatabase **lavet af alle, for alle**.\nDu kan bruge den til at træffe bedre madvalg, og da den er **åbne data**, kan alle **genbruge den til ethvert formål**.';

  @override
  String get preferences_privacy_policy => 'Fortrolighedspolitik';

  @override
  String get preferences_licenses => 'Licenser';

  @override
  String get preferences_about_app_title => 'Om appen';

  @override
  String get preferences_about_app_subtitle =>
      'Tekniske oplysninger, udvikleroplysninger og mere';

  @override
  String get preferences_card_information => 'Oplysninger';

  @override
  String get preferences_version_number_title => 'Versionsnummer';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'App-butik';

  @override
  String get preferences_app_system_settings => 'Systemindstillinger';

  @override
  String get preferences_source_code => 'Få adgang til kildekoden';

  @override
  String get preferences_source_code_subtitle =>
      'Og begynd at gøre en forskel for millioner';

  @override
  String get preferences_add_prices => 'Tilføj priser';

  @override
  String get preferences_complete_products => 'Fortæl verden';

  @override
  String get preferences_tips => 'Tips';

  @override
  String get tips_discover_nutriscore => 'Opdag den nye Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'På Open Food Facts-webstedet';

  @override
  String get preferences_manage_account_title => 'Administrer min konto';

  @override
  String get preferences_manage_account_tooltip => 'Administrer din konto';

  @override
  String get preferences_change_password_title => 'Skift min adgangskode';

  @override
  String get preferences_danger_zone => 'Farezone';

  @override
  String get preferences_account_deletion_subtitle =>
      'Alle dine bidrag vil gå tabt';

  @override
  String get preferences_contributions_title => 'Bidrag';

  @override
  String get preferences_dev_mode_app_settings_title => 'App-indstillinger';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Meget eksperimentel måde at scanne produkter offline på';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Opdater alle produkter fra serveren';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Undgå venligst at gøre det, medmindre det er absolut nødvendigt';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demotilstand';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Tilføj kort til scanneren';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Tilføjer 3 prøveprodukter til scanneren';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Folksonomy-vært';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Vært: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Tilgængelighedseksperimenter';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Udvalg af flere produkter til priser';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Brugerbestilte videnspaneler';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Midlertidig adgang til lokationssøgning';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Side om side-sammenligning af 2 eller 3 produkter';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Import af produktliste';

  @override
  String get preferences_faq_scores_methodologies_title => 'Scorer og metoder';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Opdag hvordan Nutri-Score beregnes';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Opdag de vigtigste ændringer i metodologien';

  @override
  String get preferences_faq_discover_project_title =>
      'Gå på opdagelse i projektet';

  @override
  String get preferences_faq_discover_off_title => 'Opdag åbne fødevarefakta';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Ofte stillede spørgsmål';

  @override
  String get preferences_faq_off_ngo_title => 'NGO\'en Open Food Facts';

  @override
  String get preferences_about_information_title => 'Oplysninger';

  @override
  String get preferences_connect_community_updates_title =>
      'Få opdateringer fra lokalsamfundet';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Hold dig opdateret med app- og lokalsamfundsnyheder';

  @override
  String get preferences_connect_community_calendar_title =>
      'Abonner på vores fællesskabskalender';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Bliv involveret ved at deltage i et af vores virtuelle arrangementer';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts-bloggen';

  @override
  String get preferences_connect_blog_subtitle =>
      'Få de seneste nyheder, når de sker';

  @override
  String get preferences_connect_community_help_title =>
      'Få hjælp fra lokalsamfundet';

  @override
  String get preferences_connect_improve_app_title =>
      'Hjælp os med at forbedre appen';

  @override
  String get preferences_connect_debug_info_title =>
      'Send os fejlfindingsoplysninger';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Send os en e-mail med detaljerede oplysninger om fejlfinding';

  @override
  String get preferences_connect_feedback_title => 'Send os feedback om appen';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Vær med til at forme appens fremtid';

  @override
  String get preferences_connect_survey_title => 'Tag app-undersøgelsen';

  @override
  String get preferences_connect_survey_subtitle =>
      'Hjælp os med at forstå, hvad vi skal bygge næste gang';

  @override
  String get preferences_connect_professionals_title => 'Fagfolk';

  @override
  String get preferences_connect_pro_subtitle =>
      'Helt gratis, sikrer nøjagtige data for 500 apps og millioner af forbrugere. Selvbetjening, kompatibel med dit PIM eller regneark (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Kontakt os for at komme i gang';

  @override
  String get preferences_connect_press_title => 'Presse';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Få alt det materiale, du har brug for til din rapport';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Kontakt os for pressehenvendelser eller for at fortælle os om din rapport';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Bliv aktiv frivillig';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Udvikling, kommunikation, design… Enhver form for frivilligt arbejde eller ekspertise er velkommen!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Opdag nogle af de mange måder, du kan bidrage på';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Udvikling af mobilapps';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Lær hvordan du kan bidrage til softwareudvikling';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Daglige ustabile builds, helt nye funktioner';

  @override
  String get preferences_contribute_local_community_title =>
      'Udbyg dit lokalsamfund';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Hjælp med oversættelser af software, indhold og ingrediensanalyser';

  @override
  String get preferences_contribute_share_subtitle =>
      'Vi har lavet en lille skabelon, der kan hjælpe dig :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Enkle trin til at øge gennemsigtigheden af fødevarer i dit land';

  @override
  String get preferences_contribute_data_quality_title => 'Datakvalitet';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Bliv en del af datakvalitetsteamet';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Vær med i vores indsats for at sikre, at databasen er komplet og nøjagtig';

  @override
  String get preferences_contributions_products_added_title =>
      'Tilføjede produkter';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nye produkter jeg har tilføjet til Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkter jeg skal færdiggøre';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Alle ufuldstændige produkter';

  @override
  String get preferences_my_contributions_prices_title => 'Priser';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mine priser';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Mine priser, mine beviser…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkter du kan hjælpe med at færdiggøre';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Hjælp med at beregne Nutri-Score og Green-Score i dit land';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Priser jeg har bidraget med';

  @override
  String get preferences_prices_proofs_subtitle => 'Prismærker og kvitteringer';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Tag billeder af dine kvitteringer og scan tilhørende stregkoder';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Tag billeder af priser i en butik';

  @override
  String get preferences_prices_newest_title => 'Nyeste priser';

  @override
  String get preferences_prices_newest_subtitle =>
      'Seneste priser tilføjet af Open Prices-fællesskabet';

  @override
  String get preferences_prices_top_contributors_title =>
      'Bidragydere med de højeste priser';

  @override
  String get preferences_prices_metrics_title => 'Åbningsprismålinger';

  @override
  String get preferences_prices_metrics_subtitle => 'Følg projektets udvikling';

  @override
  String get preferences_prices_ways_contribute_title => 'Måder at bidrage på';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Bekræft priser tilføjet af dig selv eller andre, ved hjælp af AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Tilføj hurtigt mange kvitteringer eller billeder af hylder fra din kamerarulle';

  @override
  String get preferences_prices_challenges_title => 'Månedlige udfordringer';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Deltag i månedlige tematiske opgaver for at indsamle præmier';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Få dine loyalitetsdata tilbage';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Lær, hvordan du anmoder om dine data';

  @override
  String get preferences_page_customize_app_title => 'Tilpas appen';

  @override
  String get preferences_page_contribute_project_title =>
      'Bidrag til projektet';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Enkle måder at hjælpe på Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Scoremetoder, hjælp og mere om projektet';

  @override
  String get product_edit_robotoff_positive_button => 'Accepter forslaget';

  @override
  String get product_edit_robotoff_negative_button => 'Afvis forslag';

  @override
  String get product_edit_robotoff_show_proof => 'Vis bevis';

  @override
  String get product_edit_robotoff_expand_proof => 'Udvid bevis';

  @override
  String get product_page_tab_raw_data => 'Rådata';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Side $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Side $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count af $total elementer';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count af $total elementer';
  }

  @override
  String item_count(int count) {
    return '$count varer';
  }

  @override
  String item_count_string(String count) {
    return '$count varer';
  }

  @override
  String get prices_no_result => 'Ingen prisstatistik fundet.';

  @override
  String get prices_error_loading_more_items =>
      'Fejl ved indlæsning af flere elementer';

  @override
  String get prices_proof_error =>
      'Godkendelse mislykkedes, kunne ikke hente beviser';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count af $total beviser';
  }

  @override
  String proof_count(int count) {
    return '$count beviser';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count af $total bidragydere';
  }

  @override
  String contributors_count(int count) {
    return '$count bidragydere';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count af $total placeringer';
  }

  @override
  String prices_locations_count(int count) {
    return '$count placeringer';
  }

  @override
  String get restart_to_apply_message =>
      'Genstart venligst appen for at anvende ændringerne.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafisk brugerflade';

  @override
  String get preferences_app_settings_media_title => 'Medier';

  @override
  String get preferences_about_app_development_title => 'Udvikling';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Åbne fødevarefakta-laboratorier';

  @override
  String get preferences_root_account_title => 'Konto';

  @override
  String get preferences_contribute_translate_header =>
      'Få åbne fødevarefakta på dit sprog';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Tilmeld dig alfaversionen af appen';

  @override
  String get preferences_dev_mode_section_data => 'Bidrag og produktdata';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Vis ikke folkesonomi';

  @override
  String get preferences_account_title => 'Konto';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Tilføjet den $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Navn';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Land';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
