// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class AppLocalizationsAr extends AppLocalizations {
  AppLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'نعم';

  @override
  String get add => 'إضافة';

  @override
  String get account_delete_message =>
      'هل انت متأكد انك تريد حذف حسابك؟\nإذا كان هناك سبب محدد ، يرجى المشاركة بالأسفل';

  @override
  String get reason => 'السبب';

  @override
  String get okay => 'حسناً';

  @override
  String get validate => 'التحقق';

  @override
  String get create => 'إنشاء';

  @override
  String get applyButtonText => 'طبق';

  @override
  String get next_label => 'التالى';

  @override
  String get continue_label => 'يكمل';

  @override
  String get exit_label => 'خروج';

  @override
  String get previous_label => 'السابق';

  @override
  String get go_back_to_top => 'العودة لأعلى';

  @override
  String get save => 'حفظ';

  @override
  String get save_confirmation => 'هل أنت متأكد أنك تريد المغادرة؟';

  @override
  String get skip => 'تخطي';

  @override
  String get cancel => 'إلغاء';

  @override
  String get ignore => 'تجاهل';

  @override
  String get close => 'إغلق';

  @override
  String get no => 'لا';

  @override
  String get stop => 'توقّف';

  @override
  String get finish => 'ينهي';

  @override
  String get calculate => 'قم بالحساب';

  @override
  String get reset_food_prefs => 'إعادة تعيين تفضيلات الطعام';

  @override
  String get error => 'حدث خطأ ما';

  @override
  String get error_occurred => 'حدث خطأ';

  @override
  String get featureInProgress => 'لا زلنا نعمل على هذه الميزة. ترقبوا';

  @override
  String get label_web => 'عرض على الويب';

  @override
  String get learnMore => 'لمعرفة المزيد';

  @override
  String get unknown => 'غير معروف';

  @override
  String get match_very_good => 'مباراة جيدة جدًا';

  @override
  String get match_good => 'مباراة جيدة';

  @override
  String get match_poor => 'مباراة سيئة';

  @override
  String get match_may_not => 'قد لا يتطابق';

  @override
  String get match_does_not => 'لا يتطابق';

  @override
  String get match_unknown => 'تطابق غير معروف';

  @override
  String get match_short_very_good => 'مباراة جيدة جدًا';

  @override
  String get match_short_good => 'مباراة جيدة';

  @override
  String get match_short_poor => 'مباراة سيئة';

  @override
  String get match_short_may_not => 'قد لا يتطابق';

  @override
  String get match_short_does_not => 'لا يتطابق';

  @override
  String get match_short_unknown => 'تطابق غير معروف';

  @override
  String get licenses => 'التراخيص';

  @override
  String get looking_for => 'البحث عن';

  @override
  String get welcomeToOpenFoodFacts => 'مرحبًا بكم في موقع Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts هي منظمة عالمية غير ربحية مدعومة من المجتمعات المحلية.';

  @override
  String get productDataUtility =>
      'اطلع على بيانات الطعام ذات الصلة بتفضيلاتك.';

  @override
  String get healthCardUtility => 'اختر الأطعمة المفيدة لك.';

  @override
  String get ecoCardUtility => 'اختر الأطعمة المفيدة للكوكب.';

  @override
  String get server_error_open_new_issue =>
      'لا يوجد استجابة من الخادم! يمكنك فتح مشكلة باستخدام الرابط التالي.';

  @override
  String get sign_in_text =>
      'قم بتسجيل الدخول إلى حساب Open Food Facts الخاص بك لحفظ مساهماتك';

  @override
  String get incorrect_credentials => 'اسم المستخدم أو كلمة المرور غير صحيحة.';

  @override
  String get password_lost_incorrect_credentials =>
      'هذا البريد الإلكتروني أو اسم المستخدم غير موجود. يُرجى التحقق من بيانات اعتمادك.';

  @override
  String get password_lost_server_unavailable =>
      'نواجه حاليًا تباطؤًا في خوادمنا، ونعتذر عن ذلك. يُرجى المحاولة لاحقًا.';

  @override
  String get login => 'اسم المستخدم';

  @override
  String get login_result_type_server_unreachable => 'الشبكة غير قابلة للوصول';

  @override
  String get login_result_type_server_issue =>
      'مشكلة في الخادم. يُرجى المحاولة لاحقًا.';

  @override
  String get login_page_username_or_email =>
      'الرجاء إدخال اسم المستخدم أو البريد الإلكتروني';

  @override
  String get login_page_password_error_empty => 'برجاء إخال كلمة مرور';

  @override
  String get create_account => 'إنشاء حساب';

  @override
  String get sign_in => 'تسجيل الدخول';

  @override
  String get sign_in_mandatory =>
      'للحصول على هذه الميزة، نحتاج منك تسجيل الدخول.';

  @override
  String get help_improve_country =>
      'ساعد في تحسين حقائق الأغذية المفتوحة في بلدك';

  @override
  String get sign_out => 'تسجيل الخروج';

  @override
  String get sign_out_confirmation => 'هل أنت متأكد من أنك تريد تسجيل الخروج؟';

  @override
  String get password => 'كلمة المرور';

  @override
  String get forgot_password => 'نسيت كلمة المرور';

  @override
  String get forgot_password_question => 'هل نسيت كلمة السر؟';

  @override
  String get view_profile => 'عرض الصفحة الشخصية';

  @override
  String get reset_password => 'إعادة تعيين كلمة المرور';

  @override
  String get reset_password_explanation_text =>
      'في حالة نسيت كلمة المرور، أدخل اسم المستخدم أو عنوان البريد الإلكتروني الخاص بك لتلقي تعليمات لإعادة تعيين كلمة المرور. تذكر أيضا التحقق من مجلد البريد المزعج.';

  @override
  String get username_or_email => 'اسم المستخدم أو البريد الإلكتروني';

  @override
  String get reset_password_done =>
      'تم إرسال بريد إلكتروني مع رابط لإعادة تعيين كلمة المرور الخاصة بك إلى عنوان البريد الإلكتروني المرتبط بحسابك. تحقق أيضا من البريد المزعج الخاص بك';

  @override
  String get send_reset_password_mail => 'تغيير كلمة المرور';

  @override
  String get enter_some_text => 'برجاء إدخال نص';

  @override
  String get sign_up_page_title => 'تسجيل';

  @override
  String get sign_up_page_action_button => 'تسجيل';

  @override
  String get sign_up_page_action_doing_it => 'تسجيل الدخول…';

  @override
  String get sign_up_page_action_ok => 'تهانينا! تم إنشاء حسابك للتو.';

  @override
  String get sign_up_page_display_name_hint => 'اﻹسم';

  @override
  String get sign_up_page_display_name_error_empty =>
      'يرجاء إدخال الإسم العرض الذي تود استخدامه';

  @override
  String get sign_up_page_email_hint => 'البريد الإلكتروني';

  @override
  String get sign_up_page_email_error_empty => 'البريد الإلكتروني مطلوب';

  @override
  String get sign_up_page_email_error_invalid => 'بريد إلكتروني غير صالح';

  @override
  String get sign_up_page_username_hint => 'اسم المستخدم: مرئي للعامة';

  @override
  String get sign_up_page_username_error_empty => 'برجاء إدخال اسم المستخدم';

  @override
  String get sign_up_page_username_error_invalid =>
      'برجاء إدخال اسم مستخدم صحيح';

  @override
  String get sign_up_page_username_description =>
      'لا يمكن أن يحتوي اسم المستخدم على مسافات أو أحرف كبيرة أو أحرف خاصة.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'لا يمكن أن يتجاوز اسم المستخدم $value حرفًا';
  }

  @override
  String get sign_up_page_password_hint => 'كلمة المرور';

  @override
  String get sign_up_page_password_error_empty => 'برجاء إخال كلمة مرور';

  @override
  String get sign_up_page_password_error_invalid =>
      'برجاء إدخال كلمة مرور (6 أحرف على الأقل)';

  @override
  String get sign_up_page_confirm_password_hint => 'تأكيد كلمة المرور';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'برجاء تأكيد كلمة المرور';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'كلمة السر غير مطابقة';

  @override
  String get sign_up_page_agree_text => 'أوافق على حقائق الغذاء المفتوحة';

  @override
  String get sign_up_page_terms_text => 'شروط الاستخدام والمساهمة';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'عند إنشاء حساب، الموافقة على شروط الاستخدام إلزامية، ولكن من الممكن تقديم مساهمات مجهولة من خلال التطبيق';

  @override
  String get sign_up_page_producer_checkbox => 'أنا منتج للغذاء';

  @override
  String get sign_up_page_producer_hint => 'المنتِج / العلامة التجارية';

  @override
  String get sign_up_page_producer_error_empty =>
      'برجاء إدخال اسم منتِج أو اسم علامة تجارية';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'أرغب في الاشتراك في النشرة الإخبارية Open Food Facts (يمكنك إلغاء الاشتراك فيها في أي وقت)';

  @override
  String get sign_up_page_user_name_already_used =>
      'اسم المستخدم موجود بالفعل، يرجى اختيار اسم مستخدم آخر.';

  @override
  String get sign_up_page_email_already_exists =>
      'موجود بالفعل، قم بتسجيل الدخول إلى الحساب أو حاول باستخدام بريد إلكتروني آخر.';

  @override
  String get sign_up_page_provide_valid_email =>
      'يرجى تقديم عنوان بريد إلكتروني صالح.';

  @override
  String get sign_up_page_server_busy =>
      'نأسف بشدة، نواجه بعض الصعوبات التقنية في إنشاء حسابك. يُرجى المحاولة لاحقًا.';

  @override
  String get settingsTitle => 'الإعدادات';

  @override
  String get darkmode => 'مظهر';

  @override
  String get darkmode_dark => 'بنتاا';

  @override
  String get darkmode_light => 'وضع نهاري';

  @override
  String get darkmode_system_default => 'الإعداد الافتراضي للنظام';

  @override
  String get thanks_for_contributing => 'شكرا لمساهمتك!';

  @override
  String get contributors_label => 'إنهم يقومون ببناء التطبيق';

  @override
  String get contributors_dialog_title => 'المساهمون';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'المساهم: $name';
  }

  @override
  String get contributors_description => 'قائمة بجميع المساهمين في هذا التطبيق';

  @override
  String get support => 'يدعم';

  @override
  String get support_join_slack => 'طلب المساعدة في قناتنا على Slack';

  @override
  String get support_via_forum => 'اطلب المساعدة في منتدانا';

  @override
  String get support_via_email => 'ارسل لنا بريد إلكتروني';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'إرسال سجلات التطبيق؟';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'هل ترغب في تضمين سجلات التطبيق في المرفقات ببريدك الإلكتروني؟';

  @override
  String get termsOfUse => 'شروط الاستخدام';

  @override
  String get legalNotices => 'الإشعارات القانونية';

  @override
  String get privacy_policy => 'سياسة الخصوصية';

  @override
  String get about_this_app => 'حول هذا التطبيق';

  @override
  String get contribute => 'المساهمة';

  @override
  String get contribute_sw_development => 'تطوير البرمجيات';

  @override
  String get contribute_develop_text =>
      'كود جميع منتجات Open Food Facts متاح على GitHub. نرحب بك لإعادة استخدام الكود (إنه مفتوح المصدر) ومساعدتنا في تحسينه، للجميع في جميع أنحاء العالم.';

  @override
  String get contribute_develop_text_2 =>
      'يمكنك الانضمام إلى غرفة الدردشة الخاصة بـ Open Food Facts على Slack وهي الطريقة المفضلة لطرح الأسئلة.';

  @override
  String get contribute_develop_dev_mode_title => 'وضع DEV؟';

  @override
  String get contribute_develop_dev_mode_subtitle => 'تفعيل وضع DEV';

  @override
  String get contribute_donate_title => 'تبرع';

  @override
  String get contribute_donate_header => 'التبرع لـ Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'يرجى العلم أنه مع الإصدار ألفا الداخلي، من الممكن فقدان البيانات بالكامل، وقد يصبح التطبيق غير قابل للاستخدام في أي وقت!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'مُنتجات مراد إكمالها';

  @override
  String get contribute_improve_header => 'قيد التحسن';

  @override
  String get contribute_improve_text =>
      'قاعدة البيانات هي جوهر المشروع. المساعدة سهلة وسريعة جدًا. يمكنك تنزيل تطبيق الهاتف المحمول على هاتفك، والبدء بإضافة المنتجات أو تحسينها.\n\nمن ناحية أخرى، يوفر موقع Open Food Facts العديد من طرق المساهمة: ';

  @override
  String get contribute_translate_header => 'ترجم';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'إبدأ بالترجمة';

  @override
  String get contribute_translate_text =>
      'حقائق الغذاء المفتوحة مشروع عالمي، يضم منتجات من أكثر من 160 دولة. تُرجمت حقائق الغذاء المفتوحة إلى عشرات اللغات، ويتطور محتواها باستمرار.';

  @override
  String get contribute_translate_text_2 =>
      'الترجمات هي إحدى المهام الرئيسية للمشروع';

  @override
  String get contribute_join_skill_pool =>
      'ساهم بمهاراتك في \"حقائق الطعام المفتوحة\". انضم إلى فريقنا!';

  @override
  String get contribute_share_header => 'شارك حقائق الطعام المفتوحة مع أصدقائك';

  @override
  String get contribute_share_content =>
      'أردتُ أن أخبركم عن تطبيق Open Food Facts الذي أستخدمه، والذي يُمكّنكم من معرفة الآثار الصحية والبيئية لغذائكم، بطريقة شخصية. يعمل التطبيق عن طريق مسح الباركود الموجود على العبوة. وأخيرًا، التطبيق مجاني ولا يتطلب تسجيلًا، ويُمكنكم حتى من زيادة عدد المنتجات التي تُفك رموزها. إليكم رابط تحميله على هاتفكم: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'ساهم في الأسعار من خلال طلب تصدير بيانات بطاقات الولاء الخاصة بك وفقًا لمعايير حماية البيانات العامة (GDPR)';

  @override
  String get tap_to_answer => 'اضغط هنا للإجابة على الأسئلة';

  @override
  String get tap_to_answer_hint =>
      'انقر هنا للإجابة على الأسئلة المتعلقة بهذا المنتج';

  @override
  String get robotoff_questions_loading_hint =>
      'يرجى الانتظار أثناء تحميل الأسئلة المتعلقة بهذا المنتج';

  @override
  String get saving_answer => 'حفظ إجابتك';

  @override
  String get contribute_to_get_rewards => 'أصبح عنصر فعال فى الشفافية الغذائية';

  @override
  String get question_sign_in_text =>
      'قم بتسجيل الدخول إلى حساب Open Food Facts الخاص بك للحصول على رصيد لمساهماتك';

  @override
  String get question_yes_button_accessibility_value => 'أجب بنعم';

  @override
  String get question_no_button_accessibility_value => 'الإجابة بـ لا';

  @override
  String get question_skip_button_accessibility_value => 'تخطي هذا السؤال';

  @override
  String get tap_to_edit_search => 'ماهذا وكيف يستخدم';

  @override
  String get myPreferences => 'خياراتي';

  @override
  String get account_create_message =>
      'قم بإنشاء حسابك وانضم إلى مجتمع Open Food Facts للمساعدة في بناء المعرفة الغذائية في جميع أنحاء العالم!';

  @override
  String get join_us => 'انضم إلينا';

  @override
  String get myPreferences_profile_title => 'صفحتك الشخصية';

  @override
  String get myPreferences_profile_subtitle =>
      'قم بإدارة حساب المساهم الخاص بك في Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'إعدادات التطبيق';

  @override
  String get myPreferences_settings_subtitle => 'الوضع الداكن، اللغات…';

  @override
  String get myPreferences_food_title => 'أضف تفضيلات غذائية';

  @override
  String get myPreferences_food_subtitle =>
      'اختر المعلومات التي تهمك أكثر عن الطعام.';

  @override
  String get myPreferences_food_comment =>
      'اختر المعلومات الغذائية الأكثر أهمية بالنسبة لك، لتصنيف الطعام حسب تفضيلاتك، واطلع على المعلومات التي تهمك أولًا، واحصل على ملخص التوافق. تبقى هذه التفضيلات الغذائية على جهازك، وليست مرتبطة بحساب مساهمك في Open Food Facts، إن كان لديك حساب.';

  @override
  String get confirmResetPreferences => 'إعادة تعيين تفضيلات التطبيق؟';

  @override
  String get myPersonalizedRanking => 'تصنيفي الشخصي';

  @override
  String get ranking_tab_all => 'الكل';

  @override
  String get ranking_subtitle_match_yes => 'مباراة رائعة لك';

  @override
  String get ranking_subtitle_match_no => 'تطابُق ضعيف جداً';

  @override
  String get ranking_subtitle_match_maybe => 'تطابق غير معروف';

  @override
  String get refresh_with_new_preferences =>
      'قم بتحديث القائمة بتفضيلاتك الجديدة';

  @override
  String get reloaded_with_new_preferences =>
      'تم إعادة تحميلها بتفضيلاتك الجديدة';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'مسح';

  @override
  String get history_navbar_label => 'السجل';

  @override
  String get list_navbar_label => 'القوائم';

  @override
  String get category => 'فرز حسب الفئة';

  @override
  String get category_all => 'الكل';

  @override
  String get category_search => '(بحث عن فئة)';

  @override
  String get filter => 'تصفية';

  @override
  String get scan => 'المنتجات من شاشة المسح الضوئي';

  @override
  String get scan_history => 'سجل المسح الضوئي';

  @override
  String get search => 'بحث';

  @override
  String get search_product_help =>
      'ابحث عن منتج أو\nعلامة تجارية أو رمز شريطي';

  @override
  String get search_filter => 'مرشح البحث';

  @override
  String get search_history => 'سجل البحث';

  @override
  String get search_store => 'ابحث عن متجر';

  @override
  String get search_store_help => 'تلميح: أضف المدينة أو البلد';

  @override
  String get tap_for_more => 'انقر لرؤية المزيد من المعلومات…';

  @override
  String get product => 'نتاج';

  @override
  String get unknownBrand => 'علامة تجارية مجهولة';

  @override
  String get unknownProductName => 'إسم منتج غير معروف';

  @override
  String get label_refresh => 'تحديث';

  @override
  String get label_reload => 'إعادة التحميل';

  @override
  String get image => 'الصورة';

  @override
  String get front_photo => 'الصورة الأمامية';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (قد تكون هذه الصورة قديمة)';
  }

  @override
  String get outdated_image_short_label => 'قد تكون قديمة';

  @override
  String get ingredients => 'المكونات';

  @override
  String get ingredients_editing_instructions =>
      'احتفظ بالترتيب الأصلي. بيّن النسبة المئوية عند تحديدها. افصل بين المكونات بفاصلة أو شرطة، واستخدم الأقواس.';

  @override
  String get ingredients_editing_error => 'فشل في حفظ المكونات.';

  @override
  String get ingredients_editing_image_error =>
      'فشل الحصول على صورة جديدة للمكونات.';

  @override
  String get ingredients_editing_title => 'تعديل المكونات';

  @override
  String get ingredients_photo => 'صورة المكونات';

  @override
  String get packaging_editing_instructions =>
      'قم بإدراج جميع أجزاء التغليف مفصولة بفاصلة أو سطر، مع ذكر كميتها (مثل 1 أو 6) ونوعها (مثل زجاجة أو صندوق أو علبة) ومادة الصنع (مثل بلاستيك أو معدن أو ألومنيوم) وإذا كان متاحًا حجمها (مثل 33 سل) وتعليمات إعادة التدوير.\nمثال: زجاجة زجاجية واحدة لإعادة التدوير، وسدادة بلاستيكية واحدة للتخلص منها';

  @override
  String get packaging_editing_error => 'فشل في حفظ العبوة.';

  @override
  String get packaging_editing_image_error =>
      'فشل الحصول على صورة التغليف الجديدة.';

  @override
  String get packaging_editing_title => 'تحرير التغليف';

  @override
  String get nutrition => 'التغذية';

  @override
  String get nutrition_facts_photo => 'صورة حقائق التغذية';

  @override
  String get nutrition_facts_editing_title => 'تعديل حقائق التغذية';

  @override
  String get packaging_information => 'معلومات التعبِئة';

  @override
  String get packaging_information_photo => 'صورة معلومات التعبِئة';

  @override
  String get missing_product => 'لقد وجدت منتجا جديدا!';

  @override
  String get add_product_take_photos =>
      'التقط صورًا للتغليف لإضافة هذا المنتج إلى حقائق الطعام المفتوحة';

  @override
  String get add_product_take_photos_descriptive =>
      'يرجى التقاط بعض الصور أولاً. يمكنك إكمال المنتج لاحقًا.';

  @override
  String get add_product_information_button_label => 'إضافة معلومات عن المنتج';

  @override
  String get new_product => 'منتج جديد';

  @override
  String get new_product_found_title => 'تم العثور على منتج جديد!';

  @override
  String get new_product_found_text =>
      'تحتوي قاعدة بياناتنا التعاونية على أكثر من **3 ملايين منتج**، ولكن هذا الرمز الشريطي غير موجود: ';

  @override
  String get new_product_found_button => 'إضافة منتج';

  @override
  String get new_product_leave_title => 'مغادرة هذه الصفحة؟';

  @override
  String get new_product_leave_message =>
      'يبدو أنك لم تُدخل أي شيء. هل ترغب حقًا بمغادرة هذه الصفحة؟';

  @override
  String get new_product_dialog_description =>
      'يرجى التقاط صور للتغليف لإضافة هذا المنتج إلى قاعدة بياناتنا المشتركة';

  @override
  String get new_product_dialog_illustration_description =>
      'رسم توضيحي باستخدام Nutri-Score وGreen Score غير المعروفين';

  @override
  String get front_packaging_photo_button_label => 'صورة العبوة الأمامية';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'تأكيد تحميل صورة العبوة الأمامية';

  @override
  String get confirm_button_label => 'يتأكد';

  @override
  String get send_image_button_label => 'إرسال الصورة';

  @override
  String get crop_page_action_saving => 'حفظ الصورة…';

  @override
  String get crop_page_action_cropping => 'قص الصورة…';

  @override
  String get crop_page_action_local => 'حفظ النسخة المحلية…';

  @override
  String get crop_page_action_local_failed_title =>
      'عفواً… هناك شيء ما في صورتك!';

  @override
  String get crop_page_action_local_failed_message =>
      'لا يمكننا معالجة الصورة محليًا قبل إرسالها إلى خادمنا. يُرجى المحاولة لاحقًا أو التواصل معنا إذا استمرت المشكلة.';

  @override
  String get crop_page_action_retake => 'إعادة التقاط الصورة';

  @override
  String get crop_page_too_small_image_title => 'الصورة صغيرة جدًا!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'الحد الأدنى لحجم الصورة بالبكسل هو ${expectedMinWidth}x$expectedMinHeight. الصورة الحالية هي ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'تحضير مكالمة إلى الخادم…';

  @override
  String get front_packaging_photo_title => 'صورة التغليف الأمامية';

  @override
  String get ingredients_photo_title => 'صورة المكونات';

  @override
  String get nutritional_facts_photo_title => 'صورة الحقائق الغذائية';

  @override
  String get recycling_photo_title => 'إعادة تدوير الصور';

  @override
  String get take_photo_title => 'التقاط صورة';

  @override
  String get take_more_photo_title => 'التقط المزيد من الصور';

  @override
  String get front_photo_uploaded => 'تم تحميل الصورة الأمامية';

  @override
  String get ingredients_photo_button_label => 'صورة المكونات';

  @override
  String get ingredients_photo_uploaded => 'تم تحميل صورة المكونات';

  @override
  String get nutrition_cache_loading_error =>
      'غير قادر على تحميل العناصر الغذائية من ذاكرة التخزين المؤقت';

  @override
  String get nutritional_facts_photo_button_label => 'صورة حقائق التغذية';

  @override
  String get nutritional_facts_input_button_label => 'املأ حقائق التغذية';

  @override
  String get nutritional_facts_added => 'تمت إضافة حقائق التغذية';

  @override
  String get categories_added => 'تمت إضافة الفئات';

  @override
  String get new_product_title_nutriscore => 'حساب النتيجة الغذائية';

  @override
  String get new_product_subtitle_nutriscore =>
      'ساعدنا عن طريق ملء فئة واحدة على الأقل والقيم الغذائية';

  @override
  String get new_product_title_environmental_score => 'حساب النتيجة الخضراء';

  @override
  String get new_product_subtitle_environmental_score =>
      'احصل عليه عن طريق ملء فئة واحدة على الأقل';

  @override
  String get new_product_additional_environmental_score =>
      'جعل حساب النتيجة الخضراء أكثر دقة مع الأصول والتغليف والمزيد';

  @override
  String get new_product_title_nova => 'حساب مستوى معالجة الأغذية (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'احصل عليه عن طريق ملء فئة الطعام والمكونات';

  @override
  String get new_product_desc_nova_unknown => 'مستوى معالجة الطعام غير معروف';

  @override
  String get new_product_title_pictures => 'منتج جديد';

  @override
  String get new_product_title_pictures_details =>
      'يرجى التقاط الصور التالية وسيتمكن محرك حقائق الغذاء المفتوحة من معرفة الباقي!';

  @override
  String get new_product_title_misc => 'وبعض البيانات الأساسية…';

  @override
  String new_product_done_msg(String username) {
    return 'شكرًا على مساهمتك “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'شكرا لمساهمتك!';

  @override
  String get new_product_done_button_label => 'اكتشف المنتج المكتمل';

  @override
  String get hey_incomplete_product_message =>
      'اضغط للإجابة على 3 أسئلة الآن لحساب Nutri-Score وGreen Score وUltra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'انقر الآن للإجابة على سؤالين للمساعدة في تحليل هذا المستحضر التجميلي!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'انقر الآن للإجابة على 3 أسئلة للمساعدة في تحليل منتج طعام الحيوانات الأليفة هذا!';

  @override
  String get hey_incomplete_product_message_product =>
      'انقر الآن للمساعدة في إكمال هذا المنتج!';

  @override
  String get nutritional_facts_photo_uploaded => 'تم تحميل صورة حقائق التغذية';

  @override
  String get recycling_photo_button_label => 'صورة معلومات إعادة التدوير';

  @override
  String get recycling_photo_uploaded => 'تم تحميل صورة إعادة التدوير';

  @override
  String get take_more_photo_button_label => 'التقط المزيد من الصور';

  @override
  String get other_photo_uploaded => 'تم تحميل صور متنوعة';

  @override
  String get retake_photo_button_label => 'الإعادة';

  @override
  String get selecting_photo => 'تحديد الصورة';

  @override
  String get uploading_image => 'تحميل الصورة على الخادم';

  @override
  String get uploading_image_type_front =>
      'تحميل الصورة الأمامية إلى Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'تحميل صورة المكونات إلى Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'تحميل صورة التغذية إلى Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'تحميل صورة التغليف إلى Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'تحميل صورة أخرى إلى Open Food Facts';

  @override
  String get uploading_image_type_generic => 'تحميل الصورة إلى Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'أضف المكونات المفقودة';

  @override
  String get score_add_missing_packaging_image => 'إضافة صورة التغليف المفقودة';

  @override
  String get score_add_missing_nutrition_facts =>
      'إضافة معلومات التغذية المفقودة';

  @override
  String get score_add_missing_product_traces => 'إضافة آثار المنتج المفقودة';

  @override
  String get score_add_missing_product_category => 'إضافة فئة المنتج مفقودة';

  @override
  String get score_add_missing_precise_product_category => 'حدد فئة أكثر دقة';

  @override
  String get score_add_missing_product_countries =>
      'إضافة البلدان المفقودة للمنتج';

  @override
  String get score_add_missing_product_emb => 'إضافة رموز تتبع المنتج المفقودة';

  @override
  String get score_add_missing_product_labels =>
      'إضافة ملصقات المنتجات المفقودة';

  @override
  String get score_add_missing_product_origins => 'إضافة أصول المنتج المفقودة';

  @override
  String get score_add_missing_product_stores =>
      'إضافة متاجر المنتجات المفقودة';

  @override
  String get score_add_missing_product_brands =>
      'إضافة العلامات التجارية للمنتجات المفقودة';

  @override
  String get score_update_nutrition_facts => 'تحديث المعلومات الغذائية';

  @override
  String get nutrition_page_title => 'حقائق غذائية';

  @override
  String get nutrition_page_nutritional_info_title => 'المعلومات الغذائية';

  @override
  String get nutrition_page_nutritional_info_label =>
      'القيم المحددة على المنتج:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'نعم';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'لا';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'افتح الصورة';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'الممارسات الجيدة: المعلومات الغذائية';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'أحيانًا لا تُذكر المعلومات الغذائية على العبوة أو في المستند المرفق بالمنتج. في هذه الحالة، وفي هذه الحالة فقط، يُمكنك ضبط القيمة على \"لا\".';

  @override
  String get nutrition_page_serving_type_label => 'القيم الغذائية:';

  @override
  String get nutrition_page_per_100g => 'لكل 100 غرام';

  @override
  String get nutrition_page_per_100g_100ml => 'لكل 100 جرام/مل';

  @override
  String get nutrition_page_per_serving => 'لكل وجبة';

  @override
  String get nutrition_page_add_nutrient => 'إضافة مادة غذائية';

  @override
  String get nutrition_page_serving_size => 'حجم الحصة';

  @override
  String get nutrition_page_serving_size_hint =>
      'أدخل حجم الحصة (على سبيل المثال: 100 جرام)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'الممارسات الجيدة: حجم الحصة';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'تساعد هذه القيمة على **إجراء حساب متناسب لكل عنصر غذائي لكل حجم حصة**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**الوحدات المسموح بها** هي: كجم، جرام، ملجم، ميكروجرام، أونصة، لتر، ديسيلتر، cl، مل، فلوريدا أوقية، г، мг، kg، л، дл، кл، мл، 毫克، 公斤، 毫升، 公升، 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 جرامًا**، **60 جرامًا** أو **60 جرامًا** (يفضل الأول)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 مل** أو **1 لتر**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'وحدة غير صالحة';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **جرام**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'وحدات غير صالحة';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **حلوى** و 2 **بسكويت**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'وحدة مفقودة';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'الرقم غير صحيح';

  @override
  String get nutrition_page_update_running => 'تحديث المنتج على الخادم…';

  @override
  String get nutrition_page_update_done => 'تم تحديث المنتج!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'استخدم كمية المنتج كحجم للوجبة';

  @override
  String get nutrition_page_photo_error => 'غير قادر على تحميل الصورة';

  @override
  String get more_photos => 'صور أكثر إثارة للاهتمام';

  @override
  String get view_more_photo_button => 'عرض جميع الصور الموجودة لهذا المنتج';

  @override
  String get no_product_found => 'لم يتم العثور على أي منتج';

  @override
  String get no_location_found => 'لم يتم العثور على الموقع';

  @override
  String get not_found => 'لم يتم العثور على نتائج:';

  @override
  String get refreshing_product => 'تحديث المنتج';

  @override
  String get product_refreshed => 'تم تحديث المنتج';

  @override
  String product_image_accessibility_label(String date) {
    return 'الصورة مأخوذة في $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'الصورة التُقطت في $date. قد تكون هذه الصورة قديمة.';
  }

  @override
  String get product_image_outdated => 'قد تكون هذه الصورة قديمة';

  @override
  String get product_image_outdated_explanations_title =>
      'قد تكون هذه الصورة قديمة';

  @override
  String get product_image_outdated_explanations_content =>
      'التُقطت هذه الصورة منذ أكثر من عام.\n**يرجى التأكد من أنها لا تزال مُحدَّثة**.\n\nهذا **مجرد تحذير**. إذا ظل المحتوى كما هو، يُمكنك تجاهل هذه الرسالة.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'استبدال الصورة ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'أضف صورة ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Capture New';

  @override
  String get product_image_action_take_picture => 'التقاط صورة';

  @override
  String get product_image_action_from_gallery => 'اختر من معرض هاتفك';

  @override
  String get product_image_action_choose_existing_photo => 'اختر من صور المنتج';

  @override
  String get product_image_details_label => 'معلومات عن الصورة';

  @override
  String get product_image_details_from_producer => 'من المنتج';

  @override
  String get product_image_details_contributor => 'مساهم';

  @override
  String get product_image_details_contributor_producer => 'المساهم (المنتج)';

  @override
  String get product_image_details_date => 'تاريخ';

  @override
  String get product_image_details_date_unknown => 'غير معروف';

  @override
  String get homepage_main_card_logo_description =>
      'مرحباً بكم في حقائق الطعام المفتوحة';

  @override
  String get homepage_main_card_subheading =>
      '**امسح** الرمز الشريطي أو\n**ابحث** عن منتج';

  @override
  String get homepage_main_card_search_field_hint => 'ابحث عن منتج';

  @override
  String get homepage_main_card_search_field_tooltip => 'ابدأ البحث';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'آخر الأخبار: $news_title';
  }

  @override
  String get tagline_app_review => 'هل يعجبك التطبيق؟';

  @override
  String get tagline_app_review_button_positive => 'انا احبه! 😍';

  @override
  String get tagline_app_review_button_negative => 'ليس حقا…';

  @override
  String get tagline_app_review_button_later => 'اسألني لاحقا';

  @override
  String get tagline_feed_news_button => 'اعرف المزيد';

  @override
  String get app_review_negative_modal_title => 'هل لا يعجبك تطبيقنا؟';

  @override
  String get app_review_negative_modal_text =>
      'هل يمكنك أن تأخذ بضع ثوان لتخبرنا لماذا؟';

  @override
  String get app_review_negative_modal_positive_button => 'نعم بالتأكيد!';

  @override
  String get app_review_negative_modal_negative_button => 'لا';

  @override
  String get could_not_refresh => 'تعذر تحديث المنتج';

  @override
  String get product_internet_error_modal_title => 'لقد حدث خطأ!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'لا يمكننا الحصول على معلومات حول هذا المنتج بسبب عطل في الشبكة. يُرجى التحقق من اتصالك بالإنترنت والمحاولة مرة أخرى.\n\nخطأ داخلي:\n$error';
  }

  @override
  String get product_tags_title => 'خصائص المنتج';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'لا يوجد خصائص';

  @override
  String get product_tags_explanation =>
      'من خلال إضافة خصائص (مفتاح/قيمة) إلى المنتج، فإنك تساعد في إثرائه.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'إضافة خصائص';

  @override
  String get add_edit_tags => 'إضافة أو تعديل الخصائص';

  @override
  String get edit_tag => 'تعديل الخاصية';

  @override
  String get remove_tag => 'إزالة الممتلكات';

  @override
  String get tag_key => 'ملكية';

  @override
  String get tag_keys => 'ملكيات';

  @override
  String get tag_key_uneditable => 'الملكية (غير قابلة للتعديل)';

  @override
  String get tag_key_input_hint => 'إدخال خاصية';

  @override
  String get tag_value => 'القيمة';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'أدخل قيمة';

  @override
  String get tag_key_item => 'ملكية:';

  @override
  String get tag_value_item => 'قيمة:';

  @override
  String get tag_key_explanations =>
      'يجب أن يكون المفتاح بأحرف صغيرة وبدون أي مسافات.';

  @override
  String tag_key_already_exists(String property) {
    return 'يوجد بالفعل علامة تحتوي على الخاصية $property !';
  }

  @override
  String get product_internet_error =>
      'يتعذر جلب معلمومات حول هذا المنتج بسبب خطأ في الشبكة.';

  @override
  String get cached_results_from => 'إظهار النتائج من:';

  @override
  String get product_search_same_category => 'البحث عن البدائل';

  @override
  String get product_search_same_category_short => 'قارن';

  @override
  String get product_search_same_category_error =>
      'لا يمكن استخدام هذه الميزة إلا للمنتجات التي تحتوي على فئة.\n\nيرجى تعديل المنتج لإضافة فئة.';

  @override
  String get product_improvement_add_category => 'إضافة فئة لحساب Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'إضافة المعلومات الغذائية لحساب Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'أضف المعلومات الغذائية والفئة لحساب Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'لا يمكن حساب Nutri-Score هذا المنتج، والذي قد يكون بسبب مثل. فئة غير قياسية. إذا كان هذا خطأ، يرجى الاتصال بنا.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'صورة التغذية قديمة: يرجى تحديثها.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'يأخذ التقييم الأخضر في الاعتبار أصول المكونات. يُرجى التقاط صورة لقائمة المكونات و/أو أي ادعاء جغرافي، أو تعديل المنتج، لتتم مراعاة ذلك.';

  @override
  String get country_chooser_label => 'الرجاء اختيار بلد';

  @override
  String get currency_chooser_label => 'الرجاء اختيار العملة';

  @override
  String get country_change_message => 'لقد قمت بتغيير البلدان للتو.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'هل تريد تغيير العملة من $previousCurrency إلى $possibleCurrency؟';
  }

  @override
  String get onboarding_country_chooser_label => 'الرجاء اختيار البلد:';

  @override
  String get country_chooser_label_from_settings => 'بلدك';

  @override
  String get country_selection_explanation => 'بعض السمات البيئية خاصة بالموقع';

  @override
  String get product_removed_comparison => 'تم إزالة المنتج من المقارنة';

  @override
  String get native_app_settings => 'إعدادات التطبيق الأصلي';

  @override
  String get native_app_description =>
      'إعدادات النظام المفتوحة لـ Open Food Facts';

  @override
  String get product_removed_history => 'تم إزالة المنتج من السجل';

  @override
  String get product_removed_list => 'تمت إزالة المنتج من القائمة';

  @override
  String get product_could_not_remove => 'لا يمكن إزالة المنتج';

  @override
  String get no_prodcut_in_list => 'لا يوجد منتج في هذه القائمة';

  @override
  String get no_product_in_section => 'لا يوجد منتج في هذا القسم';

  @override
  String get recently_seen_products => 'جميع المنتجات التي تم عرضها';

  @override
  String get clear => 'محو';

  @override
  String get clear_long => 'إفراغ القائمة';

  @override
  String get really_clear => 'هل تريد حقًا حذف هذه القائمة؟';

  @override
  String pct_match(Object percent) {
    return '$percent٪ تطابق';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count قبل أيام',
      one: 'قبل يوم',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count قبل ساعات',
      one: 'قبل ساعة',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count منذ دقائق',
      one: 'قبل دقيقة',
      zero: 'قبل أقل من دقيقة',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count قبل أشهر',
      one: 'قبل شهر',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count قبل أسابيع',
      one: 'قبل أسبوع',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'قارن $count المنتجات',
      one: 'قارن منتجًا واحدًا',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count منتجات محددة',
      one: 'منتج واحد محدد',
      zero: 'لم يتم تحديد أي منتج',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'مقارنة المنتجات المختارة';

  @override
  String get delete_products_mode => 'حذف المنتجات المحددة';

  @override
  String get select_all_products_mode => 'حدد جميع المنتجات';

  @override
  String get select_none_products_mode => 'لا تختار أي شيء';

  @override
  String get compare_products_appbar_title => 'مقارنة المنتجات';

  @override
  String get compare_products_appbar_subtitle =>
      'الرجاء تحديد منتجين على الأقل';

  @override
  String get retry_button_label => 'إعادة المحاولة';

  @override
  String get connect_with_us => 'اتصل بنا';

  @override
  String get tiktok => 'تابعونا على تيك توك';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'تابعونا على الانستغرام';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'تابعونا على X (تويتر سابقًا)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'تابعونا على ماستودون';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'تابعونا على بلو سكاي';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'مدونة';

  @override
  String get faq => 'الأسئلة المتكررة';

  @override
  String get discover => 'إكتشف';

  @override
  String get how_to_contribute => 'كيفية المساهمة';

  @override
  String get hint_knowledge_panel_message =>
      'يمكنك النقر على أي جزء من البطاقة للحصول على مزيد من التفاصيل حول ما تراه. جرّبها الآن!';

  @override
  String get permissions_page_title => 'الوصول إلى الكاميرا';

  @override
  String get permissions_page_body1 =>
      'To scan barcodes with your phone\'s camera, please Authorise the access.';

  @override
  String get permissions_page_body2 =>
      'إذا غيرت رأيك، يمكنك تمكين هذا الخيار أو تعطيله في أي وقت من الإعدادات.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'نظام التشغيل: أندرويد (SDK Int: $sdkInt / الإصدار: $release)\nالطراز: $model\nالمنتج: $product\nالجهاز: $device\nالعلامة التجارية:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'نظام التشغيل: iOS ($version)\nالطراز: $model\nالطراز الموضعي: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nإصدار التطبيق:$appVersion\nرقم بناء التطبيق:$appBuildNumber\nاسم حزمة التطبيق:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Authorise';

  @override
  String get refuse_button_label => 'رفض';

  @override
  String get ask_me_later_button_label => 'لاحقاً';

  @override
  String get are_you_sure => 'هل أنت متأكد؟';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'تعرف أكثر من خلال $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'مرحباً !';

  @override
  String get onboarding_home_welcome_text2 =>
      'التطبيق الذي يساعدك على اختيار الطعام الجيد لك وللكوكب!';

  @override
  String get onboarding_continue_button => 'يكمل';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'تحميل منتج المثال الأول الخاص بك';

  @override
  String get onboarding_welcome_warning =>
      'عذراً، هذا هو منتجنا المثال، لا يمكنك تعديله :)';

  @override
  String get product_list_your_ranking => 'ترتيبك هو';

  @override
  String get product_list_empty_icon_desc => 'السجل غير متوفر';

  @override
  String get product_list_empty_title => 'ابدأ المسح';

  @override
  String get product_list_empty_message =>
      'ستظهر المنتجات الممسوحة ضوئيًا هنا ويمكنك التحقق من المعلومات التفصيلية عنها';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'المنتجات',
      one: 'المنتج',
      zero: 'المنتج',
    );
    return 'تحديث $_temp0 في تاريخك';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'المنتجات',
      one: 'المنتج',
      zero: 'المنتج',
    );
    return '$_temp0 تم التحديث';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'تحميل البيانات';

  @override
  String get loading_dialog_default_error_message => 'تعذر تحميل البيانات';

  @override
  String get account_delete => 'حذف الحساب';

  @override
  String get account_delete_title => 'حذف حسابي';

  @override
  String get user_profile => 'الحساب';

  @override
  String get user_profile_title_guest => 'مرحباً!';

  @override
  String get user_profile_subtitle_guest =>
      'قم بتسجيل الدخول أو الاشتراك للانضمام إلى مجتمع Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'تسجيل الدخول إلى Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'مرحباً $id!';
  }

  @override
  String get email_subject_account_deletion => 'حذف الحساب';

  @override
  String email_body_account_deletion(String userId) {
    return 'مرحبًا، يُرجى حذف حسابي في Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'طلب';

  @override
  String get settings_app_data => 'Privacy & monitoring';

  @override
  String get settings_app_camera => 'آلة تصوير';

  @override
  String get settings_app_products => 'المنتجات';

  @override
  String get settings_app_miscellaneous => 'متنوع';

  @override
  String get camera_play_sound_title => 'تشغيل صوت عند المسح';

  @override
  String get camera_play_sound_subtitle => 'سوف يصدر صوت تنبيه عند كل مسح ناجح';

  @override
  String get camera_window_accessibility_label =>
      'امسح الرمز الشريطي باستخدام الكاميرا الخاصة بك';

  @override
  String get app_haptic_feedback_title => 'الاهتزاز واللمس';

  @override
  String get app_haptic_feedback_subtitle =>
      'اهتزازات بعد تنفيذ بعض الإجراءات (فك تشفير الباركود، إزالة المنتج…).';

  @override
  String get crash_reporting_toggle_title => 'Crash reporting';

  @override
  String get crash_reporting_toggle_subtitle =>
      'عند تمكين هذه الميزة، يتم إرسال تقارير الأعطال تلقائيًا إلى نظام تتبع الأخطاء الخاص بـ Open Food Facts، بحيث يمكن إصلاح الأخطاء وبالتالي تحسين التطبيق.';

  @override
  String get send_anonymous_data_toggle_title => 'Send anonymous data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'حرر الصورة';

  @override
  String get permission_photo_error => 'خطأ';

  @override
  String get permission_photo_denied_title =>
      'السماح باستخدام الكاميرا لمسح الباركود';

  @override
  String permission_photo_denied_message(String appName) {
    return 'للحصول على تجربة محسّنة ، يُرجى السماح لـ $appName بالوصول إلى الكاميرا. سوف تكون قادرا على مسح الباركود مباشرة.';
  }

  @override
  String get permission_photo_denied_button => 'سماح';

  @override
  String get permission_photo_denied_dialog_settings_title => 'تم رفض الإذن';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'نظرًا لأنك رفضت مسبقًا إذن الكاميرا ،يجب أن تسمح بذلك يدويًا من الإعدادات.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Open settings';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'إلغاء';

  @override
  String get permission_photo_none_found => 'لم يتم اكتشاف أي كاميرا';

  @override
  String get permission_photo_denied => 'لم يتم منح الوصول إلى الكاميرا';

  @override
  String get show_product_pictures => 'عرض صور المنتج';

  @override
  String get edit_product_label => 'تحرير المنتج';

  @override
  String get edit_product_pending_operations_banner_title => 'تحميل تعديلاتك…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'سيتم إرسال تعديلاتك **في الخلفية** (أو لاحقًا في حالة حدوث خطأ).\nيمكنك الاستمرار في تحرير حقول المنتج الأخرى.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'سيتم إرسال تعديلاتك **في الخلفية** (أو لاحقًا في حالة حدوث خطأ).';

  @override
  String get edit_product_label_short => 'تحرير';

  @override
  String edit_product_form_item_help(String value) {
    return 'كيفية إدخال \"$value\"؟';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'الرجاء إدخال قيمة غير فارغة!';

  @override
  String get edit_product_form_item_error_existing =>
      'هذه القيمة موجودة بالفعل!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'أضف علامة تجارية جديدة';

  @override
  String get edit_product_form_item_add_action_label => 'إضافة تسمية جديدة';

  @override
  String get edit_product_form_item_add_action_store => 'إضافة متجر جديد';

  @override
  String get edit_product_form_item_add_action_origin => 'إضافة أصل جديد';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'إضافة رمز تتبع جديد';

  @override
  String get edit_product_form_item_add_action_country => 'أضف بلدًا جديدًا';

  @override
  String get edit_product_form_item_add_action_category => 'إضافة فئة جديدة';

  @override
  String get edit_product_form_item_add_action_trace => 'إضافة أثر جديد';

  @override
  String get edit_product_form_item_add_suggestion => 'إضافة اقتراح';

  @override
  String get edit_product_form_item_deny_suggestion => 'رفض الاقتراح';

  @override
  String get edit_product_form_item_details_title => 'المعلومات الأساسية';

  @override
  String get edit_product_form_item_details_subtitle =>
      'اسم المنتج، العلامة التجارية، الكمية';

  @override
  String get edit_product_form_item_other_details_title => 'تفاصيل إضافية';

  @override
  String get edit_product_form_item_other_details_subtitle =>
      'الموقع الإلكتروني…';

  @override
  String get edit_product_form_item_photos_title => 'صور';

  @override
  String get edit_product_form_item_photos_subtitle => 'إضافة أو تحديث الصور';

  @override
  String get edit_product_form_item_labels_title => 'التسميات وشهادات الاعتماد';

  @override
  String get edit_product_form_item_labels_subtitle => 'ملصقات الجودة البيئية…';

  @override
  String get edit_product_form_item_labels_hint =>
      'أدخل تسمية (على سبيل المثال: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'al3alama';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'الممارسات الجيدة: الملصقات';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'أي خاصية للمنتج **والتي هي واقعية** وتختلف عن المجالات الأخرى.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'نيوتري سكور، نوفا…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'صُنع في بلجيكا، أُنتج في بريتاني…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'آيزو 9001، آيزو 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'غني بالألياف ومصدر للحديد…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'التجارة العادلة، ماكس هافيلار…';

  @override
  String get edit_product_form_item_stores_title => 'المتاجر';

  @override
  String get edit_product_form_item_stores_hint => 'إدخال متجر';

  @override
  String get edit_product_form_item_stores_type => 'متجر';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'الممارسات الجيدة: المتاجر';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'أدخل المتجر الذي اشتريت منه المنتج.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'وول مارت';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'كارفور';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'ليدل';

  @override
  String get edit_product_form_item_origins_title => 'أصلي';

  @override
  String get edit_product_form_item_origins_hint =>
      'أدخل الأصل (على سبيل المثال: ألمانيا)';

  @override
  String get edit_product_form_item_origins_type => 'الدولة';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'الممارسات الجيدة: الأصول';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'أضف **أي دلالات على المنشأ يمكنك العثور عليها على العبوة**.\nلا داعي للقلق بشأن المنشأ المشار إليه مباشرة في قائمة المكونات.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'لحم البقر من الأرجنتين';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'الصويا لا يأتي من الاتحاد الأوروبي';

  @override
  String get edit_product_form_item_countries_title => 'بلد';

  @override
  String get edit_product_form_item_countries_hint =>
      'أدخل بلدًا (على سبيل المثال: ألمانيا)';

  @override
  String get edit_product_form_item_countries_type => 'الدولة';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'الممارسات الجيدة: البلدان';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**الدول التي يتوفر فيها المنتج على نطاق واسع** (لا يشمل المتاجر المتخصصة في المنتجات الأجنبية).';

  @override
  String get edit_product_form_item_emb_codes_title => 'رموز التتبع';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'أدخل الرمز (على سبيل المثال: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'رمز التتبع';

  @override
  String get edit_product_form_item_emb_help_title =>
      'أفضل الممارسات: رموز التتبع';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'في هذا القسم، يمكنك إدخال الرموز المتعلقة بـ **علامات التغليف** أو **علامات التعريف** أو **العلامات الصحية**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'أمثلة على رموز التتبع';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**رموز EC** المستخدمة في المجتمع الأوروبي لتحديد منتجي أو معبئي الأغذية:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'الفرنسية\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: رمز دولة **فرنسا**\n**72.264.002**: البيانات الجغرافية\n**CE**: الجماعة الأوروبية';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**رموز EMB** المستخدمة في فرنسا:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'المجلس الإداري للإدارة 72264';

  @override
  String get edit_product_form_item_traces_title => 'آثار';

  @override
  String get edit_product_form_item_traces_hint => 'يتتبع';

  @override
  String get edit_product_form_item_traces_type =>
      'أدخل أثرًا (على سبيل المثال: فول الصويا)';

  @override
  String get edit_product_form_item_categories_title => 'الفئات';

  @override
  String get edit_product_form_item_categories_hint => 'atassnifate';

  @override
  String get edit_product_form_item_categories_type =>
      'أدخل فئة (على سبيل المثال: عصير البرتقال)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'أفضل الممارسات: الفئات';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'أشر **فقط إلى الفئة الأكثر تحديدًا**.\nسيتم إضافة الفئات الرئيسية تلقائيًا.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'الفئة المفقودة؟';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'في حالة عدم توفر فئة **في الإكمال التلقائي**، فلا تتردد في إضافتها على أي حال.\nسيساعدنا هذا في تحسين حقائق الطعام المفتوحة في بلدك.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'السردين في زيت الزيتون';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'عصير البرتقال من المركز';

  @override
  String get edit_product_form_item_exit_title => 'الخروج بدون حفظ؟';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'هل تريد حفظ التغييرات قبل مغادرة هذه الصفحة؟';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'حفظ التغييرات';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'تجاهل التغييرات';

  @override
  String get edit_product_form_item_ingredients_title => 'المكونات';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'تكبير وتصغير الشاشة عن طريق الضغط عليها';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'تكبير وتصغير الصورة';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'باستخدام **إشارة التكبير والتصغير**، يمكنك تكبير الصورة أو تصغيرها:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'إضافة';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'الرجاء إدخال النص أولا';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'إزالة';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => 'احفظ تعديلك';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'إلغاء التعديل الخاص بك';

  @override
  String get edit_product_form_item_packaging_title =>
      'صورة تعليمات إعادة التدوير';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'حقائق غذائية';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'التفاضيل الغذائية، ومحتوى الكحول…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'الممارسات الجيدة: حقائق التغذية';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'القيم الغذائية';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'أولاً، حدد ما إذا كانت **القيم مقدمة**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'حقائق غذائية';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'ثم أدخل القيم الغذائية **كما هو موضح على العبوة**. إذا لم تجد أي قيمة، يمكنك النقر على أيقونة \"العين\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'حقل مفقود؟';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'إذا كان هناك إدخال مفقود، يمكنك **النقر على أيقونة \"زائد\"** لإضافته (على سبيل المثال: فيتامين د، المغنيسيوم…).';

  @override
  String get edit_product_form_save => 'تحرير';

  @override
  String get edit_product_ingredients_photo_title => 'صورة المكونات';

  @override
  String get edit_product_ingredients_list_title => 'قائمة المكونات';

  @override
  String get edit_product_packaging_photo_title => 'صورة التغليف';

  @override
  String get edit_product_packaging_list_title => 'قائمة التعبئة والتغليف';

  @override
  String get no_data_available => 'لا توجد بيانات متاحة';

  @override
  String get product_field_website_title => 'موقع إلكتروني';

  @override
  String get origins_editing_title => 'تحرير الأصول';

  @override
  String get completed_basic_details_btn_text => 'التفاصيل الأساسية الكاملة';

  @override
  String get not_implemented_snackbar_text => 'لم يتم تنفيذه بعد';

  @override
  String get category_picker_page_appbar_text => 'الفئات';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'استخرج المكونات من الصورة';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'استخراج المكونات';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'استخراج المكونات\nمن الصورة';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'جاري تحميل الصورة…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'لماذا أرى هذه الرسالة؟';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'لاستخدام ميزة \"استخراج المكونات\"، يجب تحميل الصورة أولاً.\n\nيرجى الانتظار بضع ثوانٍ أو إدخالها يدويًا.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'تحديث الصورة';

  @override
  String get edit_packaging_extract_btn_text => 'استخرج العبوة\nمن الصورة';

  @override
  String get edit_packaging_extract_btn_text_short =>
      'استخراج التعبئة والتغليف';

  @override
  String get edit_packaging_extracting_btn_text => 'استخراج العبوة من الصورة';

  @override
  String get edit_packaging_loading_photo_btn_text => 'جاري تحميل الصورة…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'لماذا أرى هذه الرسالة؟';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'لاستخدام ميزة \"استخراج العبوة\"، يجب تحميل الصورة أولاً.\n\nيرجى الانتظار بضع ثوانٍ أو إدخالها يدويًا.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'تحديث الصورة';

  @override
  String get edit_ocr_extract_failed => 'فشل في اكتشاف النص في الصورة.';

  @override
  String get edit_ocr_extract_disabled_title => 'لا يوجد صورة!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'لكي تتمكن من استخدام ميزة استخراج النص، يجب عليك أولاً التقاط صورة.';

  @override
  String get user_list_dialog_new_title => 'قائمة جديدة من المنتجات';

  @override
  String get user_list_dialog_rename_title => 'إعادة تسمية القائمة';

  @override
  String get user_list_subtitle_product => 'القوائم';

  @override
  String get user_list_title => 'قوائمك';

  @override
  String get user_list_add_product => 'أضف المنتج إلى قوائمك';

  @override
  String get user_list_button_new => 'إنشاء قائمة جديدة';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'أضف إلى القائمة';

  @override
  String get added_to_list_msg => 'تمت الإضافة إلى القائمة';

  @override
  String get user_list_popup_clear => 'مسح تاريخك';

  @override
  String get user_list_popup_rename => 'إعادة التسمية';

  @override
  String get user_list_name_hint => 'قائمتي';

  @override
  String get user_list_name_error_empty => 'الاسم إلزامي';

  @override
  String get user_list_name_error_already => 'هذا الاسم مستخدم بالفعل';

  @override
  String get user_list_name_error_same => 'هذا هو نفس الاسم';

  @override
  String get user_list_name_input_hint => 'اسم القائمة';

  @override
  String get try_again => 'حاول ثانية';

  @override
  String get there_was_an_error => 'لقد حدث خطأ';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'لم يتم العثور على فئة لـ $items';
  }

  @override
  String get camera_toggle_camera => 'التبديل بين الكاميرا الخلفية والأمامية';

  @override
  String get camera_toggle_flash => 'تشغيل أو إيقاف فلاش الكاميرا';

  @override
  String get camera_enable_flash => 'تمكين الفلاش';

  @override
  String get camera_disable_flash => 'تعطيل الفلاش';

  @override
  String get camera_flash_error_dialog_title => 'حدث خطأ!';

  @override
  String get camera_flash_error_dialog_message =>
      'حدث خطأ أثناء تغيير حالة الفلاش. يُرجى التأكد من عدم تفعيل المصباح اليدوي على هاتفك الذكي.';

  @override
  String get category_picker_no_category_found_button => 'عودة';

  @override
  String get user_preferences_item_accessibility_hint =>
      'انقر لفتحه في متصفحك أو في التطبيق (إذا كان مثبتًا)';

  @override
  String get dev_preferences_screen_title => 'وضع التطوير';

  @override
  String get dev_preferences_screen_subtitle =>
      'الوصول إلى الميزات التجريبية وأدوات التطوير';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'إعادة تشغيل عملية التوجيه';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'يجب عليك بعد ذلك إعادة تشغيل التطبيق لتتمكن من رؤيته مرة أخرى.';

  @override
  String get dev_preferences_environment_switch_title =>
      'التبديل بين openfoodfacts.org (PROD) وبيئة الاختبار';

  @override
  String get dev_preferences_test_environment_title => 'معلمات بيئة الاختبار';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'عنوان URL الأساسي لبيئة الاختبار الحالية: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'مضيف بيئة الاختبار';

  @override
  String get dev_preferences_ml_kit_title => 'استخدم مجموعة ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'ثم عليك إعادة تشغيل هذا التطبيق';

  @override
  String get dev_preferences_product_additional_features_title =>
      'زر إضافي على صفحة المنتج';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'تعديل المكونات عبر زر لوحة المعرفة';

  @override
  String get dev_preferences_export_history_title => 'تاريخ التصدير';

  @override
  String get dev_preferences_export_history_progress_error => 'استثناء';

  @override
  String get dev_preferences_export_history_progress_found =>
      'تم العثور على المنتج';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'لم يتم العثور على المنتج';

  @override
  String get dev_preferences_export_history_dialog_title => 'تاريخ التصدير';

  @override
  String get dev_preferences_button_positive => 'موافق';

  @override
  String get dev_preferences_button_negative => 'إلغاء';

  @override
  String get dev_preferences_migration_title => 'نقل البيانات من الإصدار 1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'الحالة: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'النجاح أو التثبيت الجديد';

  @override
  String get dev_preferences_migration_status_success => 'نجاح';

  @override
  String get dev_preferences_migration_status_error => 'خطأ';

  @override
  String get dev_preferences_migration_status_in_progress => 'في تَقَدم';

  @override
  String get dev_preferences_migration_status_required => 'مطلوب (انقر للبدء)';

  @override
  String get dev_preferences_migration_status_not_started => 'مجهول';

  @override
  String get dev_preferences_import_history_subtitle =>
      'سيتم مسح التاريخ ووضع 3 منتجات هناك';

  @override
  String get dev_preferences_news_custom_url_title => 'عنوان URL مخصص للأخبار';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'عنوان URL لملف JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'غير محدد';

  @override
  String get dev_preferences_news_provider_status_title => 'الحالة';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'آخر تحديث: $date';
  }

  @override
  String get product_type_label_food => 'طعام';

  @override
  String get product_type_label_beauty => 'العناية الشخصية';

  @override
  String get product_type_label_pet_food => 'طعام الحيوانات الأليفة';

  @override
  String get product_type_label_product => 'أخرى';

  @override
  String get product_type_selection_title => 'نوع المنتج';

  @override
  String get product_type_selection_subtitle => 'حدد نوع هذا المنتج';

  @override
  String get product_type_selection_empty => 'يجب عليك تحديد نوع المنتج أولاً!';

  @override
  String product_type_selection_already(String productType) {
    return 'لا يمكنك تغيير نوع المنتج ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'اختصار لتطبيق الأسعار على صفحة المنتج';

  @override
  String get prices_app_button => 'انتقل إلى تطبيق الأسعار';

  @override
  String get prices_website_button => 'افتح على موقع الأسعار المفتوحة';

  @override
  String get prices_bulk_proof_upload_select =>
      'أضف علامات الأسعار مباشرة من المعرض';

  @override
  String get prices_bulk_proof_upload_warning =>
      'بمجرد تحديد الصور، لن تتمكن من تحريرها!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'السماح للمجتمع بالتحقق من الأسعار المستخرجة بواسطة الذكاء الاصطناعي.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'علامات أسعار متعددة';

  @override
  String get prices_bulk_proof_upload_title => 'تحميل الدليل الشامل';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'اختيار الملفات';

  @override
  String get prices_bulk_proof_upload_step_starting => 'بدء التحميل';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'نسخ الملف محليًا #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'جاري التحضير للتحميل #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'فشل في الصورة #$index/$count';
  }

  @override
  String get prices_generic_title => 'الأسعار';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'أضف $count أسعارًا',
      one: 'أضف سعرًا',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'أرسل $count الأسعار',
      one: 'أرسل السعر',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'إضافة عنصر';

  @override
  String get prices_add_a_price => 'أضف سعرا';

  @override
  String get prices_add_a_receipt => 'أضف إيصالاً';

  @override
  String get prices_add_price_tags => 'إضافة علامات الأسعار';

  @override
  String prices_barcode_already(String barcode) {
    return 'هذا الرمز الشريطي ($barcode) موجود بالفعل في القائمة!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'لا يوجد منتج حتى الآن';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'أبحث عن $barcode';
  }

  @override
  String get prices_barcode_enter => 'أدخل الرمز الشريطي';

  @override
  String get prices_category_enter => 'العنصر بدون رمز شريطي';

  @override
  String get prices_per_kilogram => 'السعر للكيلوغرام';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / كجم';

  @override
  String get prices_per_unit_short => ' / وحدة';

  @override
  String get prices_category_mandatory => 'ضروري';

  @override
  String get prices_category_optional => 'خياري';

  @override
  String get prices_category_error_mandatory => 'الفئة إلزامية';

  @override
  String get prices_barcode_reader_action => 'قارئ الباركود';

  @override
  String get prices_view_prices => 'عرض الأسعار';

  @override
  String get prices_list_title => 'قائمة الأسعار';

  @override
  String get prices_list_count => 'عدد\nالأسعار';

  @override
  String get prices_list_add_new_price => 'أضف سعرًا جديدًا\n';

  @override
  String get prices_list_empty_title => 'لا يوجد سعر حتى الآن!';

  @override
  String get prices_list_empty_subtitle =>
      'كن أول من يضيف واحدًا:\nعن طريق مسح **الإيصال** أو **بطاقة السعر**!';

  @override
  String get prices_entry_shop_not_found => 'متجر غير معروف';

  @override
  String prices_entry_menu_title(String user) {
    return 'سعر الدخول من \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'عرض جميع الأسعار لهذا المنتج';

  @override
  String get prices_entry_menu_open_proof => 'عرض الدليل';

  @override
  String get prices_entry_menu_my_prices => 'عرض أسعاري الأخرى';

  @override
  String get prices_entry_menu_author_prices => 'عرض الأسعار الأخرى للمؤلف';

  @override
  String get prices_entry_menu_shop_prices => 'عرض الأسعار الأخرى من المتجر';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count أسعار',
      one: '1 سعر',
    );
    return '$_temp0 لـ $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'جميع الأسعار $count',
      one: 'سعر واحد فقط',
      zero: 'لا يوجد سعر حتى الآن',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'أحدث الأسعار $pageSize (الإجمالي: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'السعر: $price / المتجر: \"$location\" / نُشر في $date بواسطة \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'الأدلة المفتوحة لـ \"$user\"';
  }

  @override
  String get prices_open_proof => 'دليل السعر المفتوح';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'جميع $count الأدلة',
      one: 'دليل واحد فقط',
      zero: 'لا يوجد دليل حتى الآن',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'أحدث $pageSize من الأدلة (المجموع: $total)';
  }

  @override
  String get prices_users_empty_title => 'لا يوجد مساهم حتى الآن!';

  @override
  String get prices_users_empty_explanation => 'كن أول من يضيف سعراً!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'أعلى $pageSize مساهمين (المجموع: $total)';
  }

  @override
  String get prices_locations_empty_title => 'لا يوجد متجر حتى الآن!';

  @override
  String get prices_locations_empty_explanation => 'كن أول من يضيف سعراً!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'أعلى $pageSize مواقع (المجموع: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count أدلة',
      one: 'دليل واحد',
      zero: 'لا يوجد دليل',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count منتجات',
      one: 'منتج واحد',
      zero: 'لا يوجد منتج',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count مستخدمين',
      one: 'مستخدم واحد',
      zero: 'لا يوجد مستخدم',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count الأسعار',
      one: 'سعر واحد',
      zero: 'لا يوجد سعر',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'السعر المضاف سابقا';

  @override
  String get prices_amount_subtitle => 'كمية';

  @override
  String get prices_amount_is_discounted => 'هل هو مخفض؟';

  @override
  String get prices_amount_price_normal => 'سعر';

  @override
  String get prices_amount_price_discounted => 'سعر مخفض';

  @override
  String get prices_amount_price_not_discounted => 'السعر الأصلي';

  @override
  String get prices_amount_no_product => 'منتج واحد مفقود!';

  @override
  String get prices_amount_price_incorrect => 'قيمة غير صحيحة';

  @override
  String get prices_amount_price_mandatory => 'القيمة الإلزامية';

  @override
  String get prices_currency_subtitle => 'عملة';

  @override
  String get prices_date_subtitle => 'تاريخ';

  @override
  String get prices_location_subtitle => 'محل';

  @override
  String get prices_location_find => 'ابحث عن متجر';

  @override
  String get prices_location_mandatory => 'يجب عليك اختيار متجر!';

  @override
  String get prices_location_search_broader =>
      'لم تجد ما تبحث عنه؟ لنجرب بحثًا أوسع!';

  @override
  String get prices_proof_subtitle => 'دليل';

  @override
  String get prices_proof_empty_title => 'لا يوجد دليل حتى الآن!';

  @override
  String get prices_proof_empty_explanation =>
      'ابدأ بإضافة صورة **الإيصال** أو **بطاقة السعر**!';

  @override
  String get prices_proof_find => 'اختر دليلا';

  @override
  String get prices_proof_change => 'دليل التغيير';

  @override
  String get prices_proof_receipt => 'إيصال';

  @override
  String get prices_proof_price_tag => 'سعر البطاقة';

  @override
  String get prices_proof_mandatory => 'يجب عليك اختيار الدليل!';

  @override
  String get prices_add_validation_error => 'خطأ التحقق';

  @override
  String get prices_privacy_warning_title => 'تحذير بشأن الخصوصية';

  @override
  String get prices_unknown_product => 'منتج غير معروف';

  @override
  String get prices_privacy_warning_main_message =>
      'الأسعار **ستكون علنية**، إلى جانب المتجر الذي تشير إليه.\n\nقد يسمح هذا للأشخاص الذين يعرفون اسمك المستعار في Open Food Facts بما يلي:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'استنتج في أي منطقة تعيش';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'اعرف ما تشتريه';

  @override
  String get prices_privacy_warning_sub_message =>
      'إذا كنت تشعر بعدم الارتياح تجاه ذلك، فيرجى تغيير اسمك المستعار، أو إنشاء حساب جديد على Open Food Facts وتسجيل الدخول إلى التطبيق باستخدام هذا الحساب.';

  @override
  String get i_refuse => 'انا ارفض';

  @override
  String get i_accept => 'انا اقبل';

  @override
  String get prices_currency_change_proposal_title => 'تغيير العملة؟';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'عملتك الحالية هي **$currency**. هل ترغب بتغييرها إلى **$newCurrency**؟';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'نعم، استخدم $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'لا، ابق $currency';
  }

  @override
  String get prices_menu_know_more => 'تعرف على المزيد حول الأسعار المفتوحة';

  @override
  String get dev_preferences_import_history_result_success => 'تم';

  @override
  String get dev_mode_section_server => 'تكوين الخادم';

  @override
  String get dev_mode_section_news => 'تكوين مزود الأخبار';

  @override
  String get dev_mode_section_product_page => 'صفحة المنتج';

  @override
  String get dev_mode_section_ui => 'واجهة المستخدم';

  @override
  String get dev_mode_section_experimental_features => 'الميزات التجريبية';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'استبعاد النتيجة الخضراء';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'استخدم مدقق الإملاء لشاشات التعرف الضوئي على الحروف (OCR)';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(المكونات والتغليف)';

  @override
  String get dev_mode_reset_app_language_title => 'إعادة تعيين لغة التطبيق';

  @override
  String get dev_mode_add_demo_cards_language_title => 'إضافة بطاقات';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'التبديل بين prices.openfoodfacts.org (PROD) وبيئة الاختبار';

  @override
  String get search_history_item_edit_tooltip =>
      'إعادة استخدام هذا البحث وتحريره';

  @override
  String get search_history_item_remove_tooltip => 'إزالة';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'لقد قمت بتنزيل جميع المنتجات $totalSize .';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'تنزيل $count المزيد من المنتجات\nتم تنزيل $downloaded بالفعل من أصل $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'بحثك عن $search جاري.\n\nيرجى الانتظار بضع ثوانٍ…';
  }

  @override
  String get user_search_contributor_title => 'المنتجات التي أضفتها';

  @override
  String get user_search_informer_title => 'المنتجات المعدلة';

  @override
  String get user_search_photographer_title => 'المنتجات التي قمت بتصويرها';

  @override
  String get user_search_to_be_completed_title => 'منتجاتي التي سيتم إكمالها';

  @override
  String get user_search_prices_title => 'أسعاري';

  @override
  String get user_search_proofs_title => 'أدلتي';

  @override
  String get user_search_proof_title => 'دليلي';

  @override
  String search_proof_title(String user) {
    return 'دليل من \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'أسعار المساهمين: $user';
  }

  @override
  String get all_search_prices_latest_title => 'أحدث الأسعار المضافة';

  @override
  String get all_search_prices_top_user_title => 'مساهمي الأسعار الأعلى';

  @override
  String get all_search_prices_top_location_title =>
      'المتاجر ذات الأسعار الأعلى';

  @override
  String get prices_contribution_assistant => 'مساعد مساهمة الأسعار';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'إضافة أدلة متعددة';

  @override
  String get all_search_prices_top_location_single_title => 'الأسعار في المتجر';

  @override
  String get all_search_prices_top_product_title =>
      'المنتجات ذات الأسعار الأعلى';

  @override
  String get all_search_to_be_completed_title =>
      'جميع المنتجات التي سيتم إكمالها';

  @override
  String get categorize_products_country_title =>
      'ساعد في تصنيف المنتجات في بلدك';

  @override
  String get edit_product_action_retake_picture => 'إعادة التقاط الصورة';

  @override
  String get edit_product_action_take_picture => 'التقط الصورة';

  @override
  String get edit_product_action_confirm => 'يتأكد';

  @override
  String get signup_page_terms_of_use_line1 =>
      'أوافق على حقائق الغذاء المفتوحة ';

  @override
  String get signup_page_terms_of_use_line2 => 'شروط الاستخدام والمساهمة';

  @override
  String get analytics_consent_image_semantic_label => 'عربية';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'خطأ فادح: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'خطأ فادح: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'التفاصيل الأساسية الكاملة';

  @override
  String get edit_photo_button_label => 'تحرير';

  @override
  String get edit_photo_unselect_button_label => 'إلغاء تحديد الصورة';

  @override
  String get edit_photo_select_existing_button_label =>
      'إختيار صورة موجودة من قبل';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'حدد الصورة بالضغط عليها';

  @override
  String get edit_photo_select_existing_download_label =>
      'استرجاع الصور الموجودة…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'لا توجد صور تم تحميلها سابقا فيما يتعلق بهذا المنتج.';

  @override
  String get edit_photo_language_not_this_one =>
      'لا توجد صورة بهذه اللغة حتى الآن';

  @override
  String get edit_photo_language_none => 'لا توجد صورة حتى الآن';

  @override
  String get category_picker_screen_title => 'الفئات';

  @override
  String get basic_details => 'التفاصيل الأساسية';

  @override
  String get product_name => 'اسم المنتج';

  @override
  String get product_names => 'أسماء المنتجات';

  @override
  String get add_basic_details_product_name_add_translation =>
      'أضف ترجمة جديدة';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'قبل التحقق، يرجى التأكد من إضافة الترجمة فقط **إذا كانت اللغة موجودة على العبوة**';

  @override
  String get add_basic_details_product_name_open_photo => 'عرض الصورة الأمامية';

  @override
  String get add_basic_details_product_name_take_photo => 'التقط صورة أمامية';

  @override
  String get add_basic_details_product_name_hint =>
      'أدخل اسم المنتج (على سبيل المثال: نوتيلا)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'تغيير اللغة الإفتراضية؟';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'هل تريد تعيين لغة المنتج الافتراضية إلى \'$language\'؟';
  }

  @override
  String get explanation_section_good_examples => 'أمثلة جيدة';

  @override
  String get explanation_section_bad_examples => 'أمثلة سيئة';

  @override
  String get add_basic_details_product_name_help_title =>
      'أفضل الممارسات: اسم المنتج';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'اسم المنتج هو **الاسم الرئيسي المطبوع على العبوة**. ويمكن أن يكون علامة تجارية مسجلة.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**ملاحظة:** يرجى عدم إضافة ترجمة **إذا لم تكن اللغة موجودة على العبوة**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'نسكويك';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'كاتشب الطماطم';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'لا تقم بتضمين العلامة التجارية في الاسم';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'كاتشب الطماطم **من هاينز**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'لا تستخدم الرموز ® أو ™ أو © أو ما شابه ذلك';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'نسكويك**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ترجمات أخرى',
      one: '$count ترجمة أخرى',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'اسم العلامة التجارية';

  @override
  String get brand_names => 'الأسماء التجارية';

  @override
  String get add_basic_details_brand_name_error =>
      'الرجاء إدخال اسم العلامة التجارية';

  @override
  String get add_basic_details_brand_names_hint =>
      'العلامات التجارية المدخلة (على سبيل المثال: فيريرو)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'الممارسات الجيدة: العلامات التجارية';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'أدخل **جميع العلامات التجارية للمنتج**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'العلامة التجارية الرئيسية';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'يجب **إدخال العلامة التجارية الرئيسية**، والتي تظهر بشكل واضح على العبوة الأمامية، أولاً.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'ماركات أخرى';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'عند بيعها **بواسطة شركة كبيرة**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** يُباع بواسطة **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'عند بيعها مع علامتها التجارية **مترجمة إلى لغات متعددة**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**وادي الطبيعة** يُكتب أحيانًا **فال الطبيعة**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'نوتيلا';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'أوريو، موندليز';

  @override
  String get quantity => 'الكمية و الوزن';

  @override
  String get add_basic_details_quantity_hint =>
      'أدخل الوزن وإذا لزم الأمر الكمية (على سبيل المثال: 4 × 100 جرام)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'الممارسات الجيدة: الكمية';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'انسخ القيمة الموضحة على المنتج و**لا تنس الوحدات**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 جرام** أو **230 جرام**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (لـ 6 بيضات)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 × 150 جرام**\n(لمنتج يحتوي على 3 صناديق، كل منها يزن 150 جرامًا)';

  @override
  String get barcode => 'الرمز الشريطي';

  @override
  String barcode_barcode(String barcode) {
    return 'الرمز الشريطي: $barcode';
  }

  @override
  String get barcode_invalid_error => 'باركود غير صالح';

  @override
  String get basic_details_add_success => 'تمت إضافة التفاصيل الأساسية بنجاح';

  @override
  String get basic_details_add_error =>
      'تعذر إضافة التفاصيل الأساسية. يُرجى المحاولة مرة أخرى بعد قليل.';

  @override
  String get clear_search => 'مسح بحثك';

  @override
  String get confirm_clear =>
      'أنت على وشك مسح السجل بأكمله: هل أنت متأكد من أنك تريد المتابعة؟';

  @override
  String get alert_clear_selected_user_list =>
      'أنت على وشك مسح العناصر المحددة في سجلك';

  @override
  String get confirm_clear_selected_user_list =>
      'هل أنت متأكد أنك تريد الاستمرار؟';

  @override
  String get alert_select_items_to_clear =>
      'الرجاء تحديد عنصر واحد أو أكثر لمسحه';

  @override
  String confirm_clear_user_list(String name) {
    return 'أنت على وشك مسح هذه القائمة ($name): هل أنت متأكد أنك تريد المتابعة؟';
  }

  @override
  String get confirm_delete_user_list_title => 'حذف القائمة؟';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'أنت على وشك حذف القائمة \"$name\".\nهل أنت متأكد أنك تريد المتابعة؟';
  }

  @override
  String get confirm_delete_user_list_button => 'نعم أؤكد';

  @override
  String importance_label(String name, String id) {
    return '$name الأهمية: $id';
  }

  @override
  String get user_list_all_title => 'القوائم';

  @override
  String get user_list_all_empty => 'إنشاء قائمتك الأولى';

  @override
  String get product_list_select => 'حدد القائمة';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count منتجات',
      one: 'منتج واحد',
      zero: 'قائمة فارغة',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'إضافة القائمة';

  @override
  String get open_food_preferences_tooltip => 'تعديل تفضيلاتك الغذائية';

  @override
  String get add_photo_button_label => 'أضف صورة';

  @override
  String get add_packaging_photo_button_label =>
      'التقط صورًا لأي معلومات تتعلق بالتغليف/إعادة التدوير';

  @override
  String get add_origin_photo_button_label => 'التقط صورًا لأي معلومات أصلية';

  @override
  String get add_emb_photo_button_label => 'التقط صورًا لأي معلومات رمز التتبع';

  @override
  String get add_label_photo_button_label =>
      'التقط صورًا لأي معلومات عن الملصقات والشهادات';

  @override
  String get choose_image_source_title => 'اختر مصدر الصورة';

  @override
  String get choose_image_source_body => 'الرجاء اختيار مصدر الصورة';

  @override
  String get gallery_source_label => 'معرض الصور';

  @override
  String get gallery_source_access_denied_dialog_title => 'تم الرفض';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'لسوء الحظ، لا يمكن للتطبيق الوصول إلى معرض الصور الخاص بك، لأنك رفضت الإذن مسبقًا.\n\nيرجى الانتقال إلى إعدادات التطبيق في هاتفك الإعدادات -> الصور';

  @override
  String get gallery_source_access_denied_dialog_button => 'افتح الإعدادات';

  @override
  String get share => 'مشاركة';

  @override
  String share_product_text(String url) {
    return 'ألق نظرة على هذا المنتج على Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'ألقي نظرة على هذا المنتج على Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'ألق نظرة على هذا المنتج على Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'ألق نظرة على هذا المنتج على حقائق المنتجات المفتوحة: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'ألق نظرة على قائمة المنتجات الخاصة بي على Open Food Facts: $url';
  }

  @override
  String get capture => 'Capture New';

  @override
  String get capture_new_picture => 'التقاط صورة';

  @override
  String get choose_from_gallery => 'اختر من المعرض';

  @override
  String get image_upload_queued =>
      'سيتم تحميل الصورة في الخلفية في أقرب وقت ممكن.';

  @override
  String get add_price_queued =>
      'سيتم إرسال السعر إلى الخادم في أقرب وقت ممكن.';

  @override
  String get background_task_title_full_refresh =>
      'بدء تحديث جميع المنتجات المخزنة محليًا';

  @override
  String get background_task_title_top_n => 'بدء تنزيل المنتجات الأكثر شعبية';

  @override
  String get expand_nutrition_facts => 'توسيع جدول حقائق التغذية';

  @override
  String get expand_nutrition_facts_body =>
      'حافظ على جدول حقائق التغذية موسعًا';

  @override
  String get expand_ingredients => 'توسيع المكونات';

  @override
  String get expand_ingredients_body => 'حافظ على توسيع لوحة المكونات';

  @override
  String get no_internet_connection => 'لا يوجد اتصال بالإنترنت';

  @override
  String get world_results_label => 'العالم كله';

  @override
  String get world_results_action => 'توسيع نطاق بحثك ليشمل العالم';

  @override
  String get copy_to_clipboard => 'ينسخ';

  @override
  String get paste_from_clipboard => 'لصق من الحافظة';

  @override
  String get no_data_available_in_clipboard =>
      'لا توجد بيانات متاحة في الحافظة الخاصة بك';

  @override
  String get clipboard_barcode_copy => 'نسخ الباركود إلى الحافظة';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'تم نسخ الرمز الشريطي $barcode إلى الحافظة!';
  }

  @override
  String get open_product_website => 'افتح هذا المنتج على الموقع';

  @override
  String get language_picker_label => 'لغتك';

  @override
  String get country_picker_label => 'بلدك';

  @override
  String get currency_picker_label => 'عملتك';

  @override
  String get help_with_openfoodfacts => 'Help with Open Food Facts';

  @override
  String get product_task_background_schedule =>
      'سيتم تحديث المنتج في الخلفية بأسرع ما يمكن.';

  @override
  String get no_email_client_available_dialog_title =>
      'لا تطبيقات البريد الإلكتروني!';

  @override
  String get no_email_client_available_dialog_content =>
      'يرجى إرسال بريد إلكتروني إلينا يدويًا إلى mobile@openfoodfacts.org';

  @override
  String get all_images => 'جميع الصور';

  @override
  String get selected_images => 'صور مختارة';

  @override
  String get product_card_remove_product_tooltip => 'إزالة المنتج';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'تم مسح الرمز الشريطي الجديد: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'إزالة جميع المنتجات من الدوارة';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'يرجى مسح منتجين على الأقل لمقارنتهما';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'انقر لمقارنة المنتجات التي قمت بمسحها ضوئيًا';

  @override
  String get scan_product_loading => 'لقد قمت بمسح الرمز الشريطي\n:';

  @override
  String get scan_product_loading_initial =>
      'نحن نبحث عن هذا المنتج!\nيرجى الانتظار بضع ثوان…';

  @override
  String get scan_product_loading_long_request =>
      'ما زلنا نبحث عن هذا المنتج!\nهل يستغرق تحميله وقتًا طويلاً؟ كذلك…';

  @override
  String get scan_product_loading_unresponsive =>
      'مازلنا نبحث عن هذا المنتج.\nهل ترغب في إعادة بدء البحث؟';

  @override
  String get scan_product_loading_restart_button => 'إعادة تشغيل البحث';

  @override
  String get portion_calculator_description =>
      'احسب المعلومات الغذائية لكمية محددة';

  @override
  String get portion_calculator_hint => 'الكمية في';

  @override
  String get portion_calculator_accessibility =>
      'أدخل كمية لحساب الحقائق الغذائية';

  @override
  String portion_calculator_error(int min, int max) {
    return 'الرجاء إدخال كمية بين $min و $max جرام';
  }

  @override
  String get portion_calculator_computation_error =>
      'البيانات مفقودة. تعذر إجراء الحساب.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'حقائق غذائية لـ $grams جرام (أو مل)';
  }

  @override
  String get offline_data => 'البيانات غير المتصلة بالإنترنت';

  @override
  String get ocr_image_upload_instruction =>
      'قم بتحميل صورة لاستخراج المعلومات التي تحتوي عليها تلقائيًا.';

  @override
  String get upload_image => 'تحميل الصورة';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => '، ';

  @override
  String get image_download_error => 'فشل تنزيل الصورة';

  @override
  String get image_edit_url_error =>
      'فشل تحرير الصورة لأن عنوان URL للصورة لم يتم تعيينه.';

  @override
  String get user_picture_source_remember => 'تذكر اختياري';

  @override
  String get user_picture_source_ask => 'اسأل في كل مرة';

  @override
  String get robotoff_continue => 'يكمل';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count الأسئلة',
      one: '',
    );
    return 'السؤال التالي $_temp0';
  }

  @override
  String get show_password => 'إظهار كلمة المرور';

  @override
  String get owner_field_info_title => 'القيم المقدمة من المنتج';

  @override
  String get owner_field_info_message =>
      'من خلال هذا الشعار، نسلط الضوء على البيانات التي يقدمها المنتج، والتي قد لا تكون قابلة للتعديل.';

  @override
  String get owner_field_info_close_button => 'اغلاق هذه المعلومات';

  @override
  String get owner_field_image =>
      'هذه الصورة مقدمة من المنتج. قد لا تكون قابلة للتعديل.';

  @override
  String get edit_packagings_title => 'مكونات التعبئة والتغليف';

  @override
  String get edit_packagings_element_add => 'إضافة مكون التغليف';

  @override
  String get edit_packagings_completed => 'التغليف كامل';

  @override
  String edit_packagings_element_title(int index) {
    return 'مكون التغليف #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'عدد الوحدات';

  @override
  String get edit_packagings_element_hint_units =>
      'أدخل عدد وحدات التغليف من نفس الشكل والمادة الموجودة في المنتج.';

  @override
  String get edit_packagings_element_field_shape => 'شكل';

  @override
  String get edit_packagings_element_hint_shape =>
      'أدخل اسم الشكل المدرج في تعليمات إعادة التدوير إذا كانت متوفرة، أو حدد شكلاً.';

  @override
  String get edit_packagings_element_example_shape => 'زجاجة';

  @override
  String get edit_packagings_element_field_material => 'مادة';

  @override
  String get edit_packagings_element_hint_material =>
      'أدخل المادة المحددة إذا كان من الممكن تحديدها (غالبًا ما يمكن العثور على رمز المادة داخل مثلث على أجزاء التغليف)، أو مادة عامة (على سبيل المثال البلاستيك أو المعدن) إذا كنت غير متأكد.';

  @override
  String get edit_packagings_element_example_material => 'زجاج';

  @override
  String get edit_packagings_element_field_recycling => 'تعليمات إعادة التدوير';

  @override
  String get edit_packagings_element_hint_recycling =>
      'أدخل تعليمات إعادة التدوير فقط إذا كانت مدرجة على المنتج.';

  @override
  String get edit_packagings_element_example_recycling => 'إعادة التدوير';

  @override
  String get edit_packagings_element_field_quantity =>
      'الكمية الصافية للمنتج لكل وحدة';

  @override
  String get edit_packagings_element_hint_quantity =>
      'أدخل الوزن الصافي أو الحجم الصافي وأشر إلى الوحدة (على سبيل المثال جرام أو مل).';

  @override
  String get edit_packagings_element_field_weight => 'وزن الوحدة الفارغة (جم)';

  @override
  String get edit_packagings_element_hint_weight =>
      'أزل أي بقايا طعام، واغسل وجفف غلاف العبوة قبل الوزن. استخدم ميزانًا بدقة ٠٫١ غرام أو ٠٫٠١ غرام، إن أمكن.';

  @override
  String get background_task_title => 'المساهمات المعلقة';

  @override
  String get background_task_subtitle =>
      'سيتم حفظ مساهماتك تلقائيًا على خادمنا، ولكن ليس دائمًا في الوقت الفعلي.';

  @override
  String get background_task_list_empty => 'لا توجد مهام خلفية معلقة';

  @override
  String get background_task_error_server_time_out => 'انتهاء مهلة الخادم';

  @override
  String get background_task_error_no_internet =>
      'خطأ في اتصال الإنترنت. حاول لاحقًا.';

  @override
  String get background_task_operation_unknown => 'نوع العملية غير معروف';

  @override
  String get background_task_operation_details => 'تغييرات مفصلة';

  @override
  String get background_task_operation_image => 'تحميل الصور';

  @override
  String get background_task_operation_refresh =>
      'تأخر التحديث بعد تحميل الصورة';

  @override
  String get background_task_run_started => 'بدأت';

  @override
  String get background_task_run_not_started => 'لم تبدأ بعد';

  @override
  String get background_task_run_to_be_deleted => 'سيتم حذفه';

  @override
  String get background_task_question_stop =>
      'هل تريد إيقاف هذه المهمة في أقرب وقت ممكن؟';

  @override
  String get feed_back => 'ملاحظات';

  @override
  String get undo => 'تراجع';

  @override
  String get copy_email_to_clip_board => 'نسخ البريد الإلكتروني إلى الحافظة';

  @override
  String get please_send_us_an_email_to =>
      'يرجى إرسال بريد إلكتروني إلينا يدويًا إلى';

  @override
  String get email_copied_to_clip_board =>
      'تم نسخ البريد الإلكتروني إلى الحافظة!';

  @override
  String get select_accent_color => 'حدد لون التمييز';

  @override
  String get theme_amoled => 'أموليد';

  @override
  String get color_blue => 'أزرق';

  @override
  String get color_cyan => 'سماوي';

  @override
  String get color_green => 'أخضر';

  @override
  String get color_light_brown => 'تقصير';

  @override
  String get color_magenta => 'أرجواني';

  @override
  String get color_orange => 'البرتقالي';

  @override
  String get color_pink => 'لون القرنفل';

  @override
  String get color_red => 'أحمر';

  @override
  String get color_rust => 'الصدأ';

  @override
  String get color_teal => 'أزرق مخضر';

  @override
  String get text_contrast_mode => 'تباين النص';

  @override
  String get contrast_high => 'عالي';

  @override
  String get contrast_medium => 'واسطة';

  @override
  String get contrast_low => 'قليل';

  @override
  String get product_refresher_internet_not_found =>
      'لم يتم العثور على المنتج!';

  @override
  String get product_refresher_internet_not_connected =>
      'أنت غير متصل بالإنترنت!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'الخادم معطل ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'خطأ في الخادم ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'لم يتم العثور على المنتج!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'لا يوجد منتج يحمل الرمز الشريطي التالي في قاعدة بياناتنا: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'لا يوجد اتصال بالإنترنت!';

  @override
  String get product_loader_network_error_message =>
      'يرجى التأكد من أن هاتفك الذكي متصل بشبكة WiFi أو تم تمكين بيانات الهاتف المحمول به';

  @override
  String get page_not_found_title => 'لم يتم العثور على الصفحة!';

  @override
  String get page_not_found_button => 'العودة إلى الصفحة الرئيسية';

  @override
  String get download_data => 'تنزيل البيانات';

  @override
  String get download_top_products =>
      'قم بتنزيل أفضل 1000 منتج في بلدك للمسح الفوري';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count المنتجات',
    );
    return 'قم بتنزيل أفضل $_temp0 في بلدك للمسح الفوري';
  }

  @override
  String get download_in_progress =>
      'جاري تنزيل البيانات\nقد يستغرق هذا بعض الوقت';

  @override
  String downloaded_products(int num) {
    return 'تمت إضافة $num منتجات';
  }

  @override
  String get update_offline_data => 'تحديث بيانات المنتج غير المتصلة بالإنترنت';

  @override
  String get update_local_database_sub =>
      'تحديث قاعدة بيانات المنتجات المحلية بأحدث البيانات من Open Food Facts';

  @override
  String get clear_local_database => 'مسح بيانات المنتج غير المتصلة بالإنترنت';

  @override
  String get clear_local_database_sub =>
      'امسح جميع بيانات المنتج المحلية من تطبيقك لتحرير المساحة';

  @override
  String deleted_products(int num) {
    return 'تم حذف $num من المنتجات';
  }

  @override
  String get loading => 'جاري التحميل…';

  @override
  String get know_more => 'اعرف المزيد';

  @override
  String get offline_data_desc =>
      'انقر لمعرفة المزيد عن البيانات غير المتصلة بالإنترنت';

  @override
  String get offline_product_data_title =>
      'بيانات المنتج غير المتصلة بالإنترنت';

  @override
  String available_for_download(int num) {
    return '$num منتجات متاحة للمسح الفوري';
  }

  @override
  String get country_selector_title => 'اختر بلدك:';

  @override
  String get currency_selector_title => 'اختر عملتك:';

  @override
  String get language_selector_title => 'اختر لغتك:';

  @override
  String get language_selector_section_selected => 'اللغات المختارة';

  @override
  String get language_selector_section_frequently_used => 'يستخدم بشكل متكرر';

  @override
  String get action_delete_list => 'حذف';

  @override
  String get action_change_list => 'تغيير القائمة الحالية';

  @override
  String get product_list_create => 'إنشاء';

  @override
  String get product_list_create_tooltip => 'إنشاء قائمة جديدة';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'نوتري-سكور أ';

  @override
  String get nutriscore_b => 'نوتري سكور ب';

  @override
  String get nutriscore_c => 'نيوتري-سكور سي';

  @override
  String get nutriscore_d => 'نوتري-سكور د';

  @override
  String get nutriscore_e => 'نوتري-سكور إي';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (حساب جديد)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (حساب جديد)';

  @override
  String get nutriscore_unknown => 'درجة التغذية غير المعروفة';

  @override
  String get nutriscore_unknown_new_formula =>
      'درجة التغذية غير المعروفة (حساب جديد)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score غير قابل للتطبيق';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score غير قابل للتطبيق (حساب جديد)';

  @override
  String get environmental_score_generic_new => 'النتيجة البيئية';

  @override
  String get environmental_score_a_new => 'النتيجة الخضراء أ';

  @override
  String get environmental_score_b_new => 'النتيجة الخضراء ب';

  @override
  String get environmental_score_c_new => 'جرين-سكور سي';

  @override
  String get environmental_score_d_new => 'النتيجة الخضراء د';

  @override
  String get environmental_score_e_new => 'النتيجة الخضراء E';

  @override
  String get environmental_score_unknown_new => 'نتيجة خضراء غير معروفة';

  @override
  String get environmental_score_not_applicable_new => 'لا ينطبق Green-Score';

  @override
  String get nova_group_generic_new => 'الأطعمة فائقة المعالجة - مجموعة نوفا';

  @override
  String get nova_group_1 => 'مجموعة نوفا 1';

  @override
  String get nova_group_2 => 'مجموعة نوفا 2';

  @override
  String get nova_group_3 => 'مجموعة نوفا 3';

  @override
  String get nova_group_4 => 'مجموعة نوفا 4';

  @override
  String get nova_group_unknown => 'مجموعة نوفا غير المعروفة';

  @override
  String get nutrition_facts => '23423456bk';

  @override
  String get faq_title_partners => 'شركاء ورعاة المنظمة غير الحكومية';

  @override
  String get faq_title_vision =>
      'رؤية ورسالة وقيم وبرامج مؤسسة Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'قم بتثبيت Open Beauty Facts لإنشاء قاعدة بيانات مستحضرات التجميل';

  @override
  String get faq_title_install_pet =>
      'قم بتثبيت Open Pet Food Facts لإنشاء قاعدة بيانات لأطعمة الحيوانات الأليفة';

  @override
  String get faq_title_install_product =>
      'قم بتثبيت Open Products Facts لإنشاء قاعدة بيانات للمنتجات لتمديد عمر الكائنات';

  @override
  String get faq_nutriscore_nutriscore =>
      'حساب جديد لـ Nutri-Score: ما الجديد؟';

  @override
  String get contact_title_pro_page =>
      'محترف؟ استورد منتجاتك من خلال Open Food Facts';

  @override
  String get contact_title_pro_email => 'جهة اتصال المنتج';

  @override
  String get contact_title_press_page => 'صفحة الصحافة';

  @override
  String get contact_title_press_email => 'جهة الاتصال الصحفية';

  @override
  String get contact_title_newsletter => 'اشترك إلى نشرتنا الإخبارية';

  @override
  String get contact_title_calendar => 'اشترك في تقويم مجتمعنا';

  @override
  String get hunger_games_loading_line1 => 'من فضلك أعطنا بضع ثوان…';

  @override
  String get hunger_games_loading_line2 => 'نحن نقوم بتنزيل الأسئلة!';

  @override
  String get hunger_games_error_label =>
      'آه! حدث خطأ ما… ولم نتمكن من تحميل الأسئلة.';

  @override
  String get hunger_games_error_retry_button => 'دعونا نحاول مرة أخرى!';

  @override
  String get reorder_attribute_action => 'إعادة ترتيب السمات';

  @override
  String get link_cant_be_opened =>
      'لا يمكن فتح هذا الرابط على جهازك. يُرجى التأكد من تثبيت متصفح.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'تفاصيل عن $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'تفاصيل عن $pageName مع $productName';
  }

  @override
  String get guide_title => 'دليل الاستخدام';

  @override
  String get guide_share_label => 'مشاركة';

  @override
  String get guide_nutriscore_v2_title => 'الدرجة الغذائية في تطور: تفسيرات!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'الدرجة الغذائية هو شعار يهدف إلى إعلامك **بالجودة الغذائية للأطعمة**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'يختلف رمز اللون من اللون الأخضر الداكن (**A**) للمنتجات **الأكثر صحة** إلى اللون الأحمر الداكن (**E**) للمنتجات **الأقل صحة**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'أين يمكنني العثور على حساب Nutri-Score الجديد؟';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'يتم تطبيق نظام Nutri-Score في 7 دول: فرنسا، ألمانيا، بلجيكا، إسبانيا، لوكسمبورج، هولندا وسويسرا.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'لدى المصنعين مهلة لا تتجاوز **سنتين** بعد توقيع المرسوم **لاستبدال** الحساب القديم بالحساب الجديد.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'النتيجة البيئية';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'ما هي النتيجة الخضراء؟';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score هو شعار يهدف إلى إعلامك بالتأثير البيئي للغذاء.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'يختلف رمز اللون من الأخضر الداكن (**A+**) للمنتجات **الأقل تأثيرًا** إلى الأحمر الداكن (**F**) للمنتجات **الأكثر تأثيرًا**.';

  @override
  String get guide_greenscore_logos_caption => 'شعارات Green-Score';

  @override
  String get guide_greenscore_lca_title => 'الجوهر: تقييم دورة الحياة (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title => 'تقييم علمي لفئات الأغذية';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'بالنسبة لكل فئة من فئات المنتجات، يتم إنشاء درجة **معيارية** باستخدام البيانات من قاعدة بيانات Agribalyse البيئية (التي صممها ADEME وINRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**تحليل دورة الحياة** هو أسلوب تقييم موحد لإجراء تقييم بيئي متعدد المراحل ومتعدد المعايير.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**يقيس:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 خطوات الإنتاج';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'زراعة';

  @override
  String get guide_greenscore_lca_arg2_processing => 'معالجة';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'التغليف';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'مواصلات';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'توزيع';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'استهلاك';

  @override
  String get guide_greenscore_lca_arg3_title => '14 مؤشرًا للأثر البيئي';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'تغير المناخ/البصمة الكربونية';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'استنفاد طبقة الأوزون';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'الإشعاع المؤين';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'أرض';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'استخدام المياه والطاقة';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'تلوث الهواء';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'المياه البحرية والعذبة (الجسيمات، الحموضة، التغذية الزائدة)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'استنزاف الموارد.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'المكافآت والعقوبات';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'لمكافأة المنتجات الأفضل ضمن فئة معينة، نقوم بعد ذلك بتطبيق **المكافآت والعقوبات بناءً على عدة معايير**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'طريقة الإنتاج';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'يتم منح **مكافأة** للمنتجات التي تحمل **ملصقًا رسميًا أو ملصقًا أو شهادة تضمن الفوائد البيئية** (عضوي، تجارة عادلة، HVE، Label Rouge، Bleu Blanc Cœur، MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => 'أصل المكونات';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'تُمنح **مكافأة** بناءً على منشأ المكونات. وتراعي هذه المكافأة **التأثير على النقل** و**السياسة البيئية** لكل بلد مُنتِج.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'الأنواع المهددة بالإنقراض';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'يتم فرض عقوبة على المنتجات التي تحتوي على مكونات لها تأثيرات سلبية كبيرة على التنوع البيولوجي والنظم البيئية، مثل زيت النخيل، الذي يتسبب إنتاجه في إزالة الغابات على نطاق واسع.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'التغليف';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'يتم حساب **العقوبة** مع الأخذ في الاعتبار **دائرية التغليف** (استخدام المواد الخام المعاد تدويرها وإمكانية إعادة التدوير) والإفراط في التغليف.';

  @override
  String get guide_greenscore_transparency_title =>
      'الحاجة المتزايدة إلى الشفافية لقياس التأثيرات البيئية والحد منها بشكل أفضل';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'لحساب الدرجة الخضراء بشكل دقيق، من الضروري الحصول على **معلومات غير محددة بالضرورة على العبوة** (مثل المنشأ والنسبة المئوية الدقيقة لكل مكون) أو التي نادراً ما تكون متاحة في شكل قابل للاستخدام (مثل قائمة بجميع مكونات العبوة مع الأنواع الدقيقة من البلاستيك المستخدمة).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**يتم استخدام القيم المتوسطة عندما لا تكون هذه المعلومات متاحة بعد**، ولكننا ندعو الجميع الآن لمساعدتنا في جمع هذه المعلومات التي ستكون مفيدة للغاية بالنسبة لـ Green-Score ولكن أيضًا للعديد من الاستخدامات الأخرى.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'كيف يمكن للمواطنين المساعدة؟';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'يمكن لجميع المواطنين مساعدتنا في جمع وتنظيم المعلومات الموجودة على المنتجات أو التي يمكن استنتاجها منها، مثل المعلومات المتعلقة بالتغليف: \"Mission Emballages\": جرد تعاوني واسع النطاق للتغليف لجميع المنتجات الغذائية (باللغة الفرنسية).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'كيف يمكن للمصنعين المساعدة';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'يمكن للمصنعين إرسال معلوماتهم إلينا مباشرة من خلال منصتنا المجانية للمنتجين.';

  @override
  String get guide_greenscore_better_product_title =>
      'ما هو المنتج الأفضل للكوكب؟';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'قد يكون من الصعب معرفة ذلك';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'يعد اختيار الغذاء المستدام أحد أقوى الأشياء التي يمكننا القيام بها من أجل المناخ، حيث إن **نظامنا الغذائي العالمي مسؤول عن أكثر من ربع جميع انبعاثات الغازات المسببة للاحتباس الحراري**.\n(المصدر: Poore & Nemecek، Science، 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'لديك القوة!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'الخبر السار هو أن هذا يمنحنا وسيلة فعّالة لإحداث التغيير.\n**يتناول كلٌّ منا حوالي ١٠٠٠ وجبة سنويًا**. وهذا يعني ١٠٠٠ فرصة **لاختيار مستقبل أفضل لكوكبنا**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'يساعد على تحمل المسؤولية واتخاذ القرار';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'قد يبدو اختيار الطعام المستدام معقدًا. فالملصقات مُربكة، والمعلومات غالبًا ما تكون ناقصة. صُممت \"الدرجة الخضراء\" لتبسيط الأمر، حيث تمنحك تقييمًا بيئيًا واضحًا، وواضحًا، وشفافًا، للمنتجات الغذائية، أينما كنت: أثناء التسوق.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'الشفافية';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'على عكس العلامات التجارية المسجلة الملكية، فإن حساب Green-Score هو **مفتوح تمامًا** ويمكن **التحقق منه من قبل أي شخص**.';

  @override
  String get guide_nova_title => 'Ultra-processed foods';

  @override
  String get guide_nova_what_is_nova_title => 'ما هي المعالجة الفائقة؟';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'تزودك مجموعات NOVA بمعلومات حول مستوى معالجة الأغذية.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'يسمح تصنيف NOVA بتقسيم الأطعمة إلى **4 مجموعات** بناءً على **درجة المعالجة الصناعية** (الأطعمة المعالجة بشكل بسيط أو غير المعالجة، والمكونات الطهوية، والأطعمة المعالجة، والأطعمة المعالجة للغاية).';

  @override
  String get guide_nova_logos_caption => 'شعارات نوفا';

  @override
  String get guide_nova_groups_title => 'مجموعات نوفا الأربعة';

  @override
  String get guide_nova_groups_intro =>
      'هناك 4 مجموعات NOVA، المجموعة التي تشكل المشكلة هي المجموعة 4 - الأطعمة فائقة المعالجة.';

  @override
  String get guide_nova_groups_arg1_title =>
      'الأطعمة المعالجة بشكل طفيف أو غير المعالجة';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'المكونات الطهوية المعالجة';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title =>
      'المجموعة ٣ المجموعة ٣ Processed foods';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-processed foods';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'مشاكل المعالجة الفائقة';

  @override
  String get guide_nova_explanations_arg1_title =>
      'المعالجة المتطرفة لمكونات الطعام';

  @override
  String get guide_nova_explanations_arg1_text =>
      'يتم الحصول على العديد منها **من خلال المعالجة الإضافية لمكونات الغذاء**، مثل الزيوت المهدرجة أو المهدرجة، والبروتينات المحللة، ومعزول بروتين الصويا، والمالتوديكسترين، والسكر المحول، وشراب الذرة عالي الفركتوز.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'إضافات تتجاوز سلامة الغذاء الصرفة';

  @override
  String get guide_nova_explanations_arg2_text =>
      'تشمل الإضافات في الأطعمة فائقة المعالجة بعض المواد المستخدمة أيضًا في الأطعمة المصنعة، مثل المواد الحافظة ومضادات الأكسدة والمثبتات. وتشمل فئات الإضافات الموجودة فقط في المنتجات فائقة المعالجة تلك المستخدمة **لمحاكاة أو تحسين الخصائص الحسية للأطعمة أو لإخفاء الجوانب غير المستساغة للمنتج النهائي**. تشمل هذه الإضافات الأصباغ والألوان الأخرى، ومثبتات الألوان؛ والنكهات، ومحسنات النكهة، والمحليات غير السكرية؛ ومساعدات المعالجة مثل عوامل الكربنة، والتماسك، والتكتل، وعوامل منع التكتل، وعوامل إزالة الرغوة، وعوامل منع التكتل، والتزجيج، والمستحلبات، ومواد العزل، والمرطبات.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'معالجة لا يمكنك القيام بها في المنزل';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**تُستخدم سلسلة من العمليات** لدمج المكونات العديدة عادةً، ولإنتاج المنتج النهائي (ومن هنا جاء مصطلح \"المعالجة الفائقة\"). تشمل هذه العمليات عدة عمليات **لا مثيل لها محليًا**، مثل الهدرجة والتحلل المائي، والبثق والقولبة، والمعالجة المسبقة للقلي.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'الجوانب المفترسة والمالية للمعالجة الفائقة';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**الغرض العام من المعالجة الفائقة هو إنتاج منتجات غذائية تحمل علامة تجارية**، و**مريحة** (متينة، وجاهزة للاستهلاك)، و**جذابة** (شهية للغاية) و**مربحة للغاية** (بمكونات منخفضة التكلفة)، مصممة لتحل محل جميع المجموعات الغذائية الأخرى. عادةً ما تُعبأ المنتجات الغذائية فائقة المعالجة بشكل جذاب وتُسوّق بشكل مكثف.';

  @override
  String get guide_nova_explanations_arg5_title => 'خطر على الصحة';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title => 'توصي الدول بالحد منها';

  @override
  String get guide_nova_explanations_arg6_text =>
      'تستخدم بعض البلدان مجموعات NOVA لإرشاداتها أو أهدافها الغذائية، على سبيل المثال:\n\n- **🇧🇷 توصي الإرشادات الغذائية للبرازيل بالحد من استهلاك** الأطعمة المصنعة وتجنب الأطعمة فائقة المعالجة.\n\n- **🇫🇷 تهدف أهداف السياسة الغذائية الصحية العامة في فرنسا للفترة 2018-2022 إلى **تقليل استهلاك الأطعمة فائقة المعالجة من المجموعة 4 بنسبة 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-ar.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'مرحباً بكم في حقائق الغذاء المفتوحة!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'ما هي حقائق الغذاء المفتوحة؟';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts عبارة عن قاعدة بيانات **تعاونية** و**مجانية** و**مفتوحة** للمنتجات الغذائية من جميع أنحاء العالم.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'نؤمن بحق كل فرد في الحصول على معلومات حول ما يأكله. من خلال جمع البيانات حول المكونات، ومسببات الحساسية، والمعلومات الغذائية، وغيرها، **نمكّن المستهلكين من اتخاذ خيارات مدروسة** وندفع قطاع الأغذية **نحو مزيد من الشفافية**.';

  @override
  String get guide_open_food_facts_features_title =>
      'مميزات حقائق الطعام المفتوحة';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'احصل على تنبيهات بشأن المكونات غير المرغوب فيها';

  @override
  String get guide_open_food_facts_tips_title => 'نصائح لالتقاط صور رائعة';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'لا تفعل';

  @override
  String get guide_open_food_facts_tips_arg1_text1 => 'تجنب الظلال والوهج.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'لا يوجد نص ضبابي أو خارج التركيز.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'لا تقم بقص أجزاء من النص.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'تجنب الخلفيات المزدحمة.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'افعل';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'استخدم إضاءة جيدة ومتساوية.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'تأكد من أن النص حاد وقابل للقراءة.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'التقاط قائمة المكونات بأكملها.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'احتفظ بالمنتج على سطح مستو.';

  @override
  String get guide_open_food_facts_scores_title =>
      'ساعدنا في بناء \"ويكيبيديا الطعام\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'درجة على الجودة الغذائية';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'نتيجة لتجنب الأطعمة شديدة المعالجة';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'نتيجة للكوكب';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ar.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'مرحباً بكم في حقائق طعام الحيوانات الأليفة المفتوحة!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'ما هي حقائق طعام الحيوانات الأليفة المفتوحة؟';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'حقائق طعام الحيوانات الأليفة المفتوحة تُوسّع نطاق مهمتها لتشمل حيواناتنا الأليفة! إنها **قاعدة بيانات لمنتجات طعام الحيوانات الأليفة للقطط والكلاب وغيرها من الحيوانات الأليفة**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'نقوم بجمع المعلومات حول **المكونات** و**التحليل الغذائي** وإرشادات التغذية لمساعدة أصحاب الحيوانات الأليفة في اختيار أفضل طعام يناسب احتياجات حيواناتهم.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'مميزات حقائق طعام الحيوانات الأليفة المفتوحة';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'احصل على تنبيهات بشأن المكونات غير المرغوب فيها';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'هل يعاني حيوانك الأليف من حساسية تجاه أي من مكونات مستحضرات التجميل؟ يمكنك تحديد قائمة بالمكونات التي يجب تجنبها مباشرةً من التطبيق!';

  @override
  String get guide_open_pet_food_facts_tips_title => 'نصائح لالتقاط صور رائعة';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'لا تفعل';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 => 'تجنب الظلال والوهج.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'لا يوجد نص ضبابي أو خارج التركيز.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'لا تقم بقص أجزاء من النص.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'تجنب الخلفيات المزدحمة.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'افعل';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'استخدم إضاءة جيدة ومتساوية.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'تأكد من أن النص حاد وقابل للقراءة.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'التقاط قائمة المكونات بأكملها.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'احتفظ بالمنتج على سطح مستو.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'ملاحظة حول التسجيل';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'تطوير نظام تقييم لأغذية الحيوانات الأليفة **ليس أولويةً حاليًا**. ستكون منهجيته معقدة، إذ تختلف الاحتياجات الغذائية اختلافًا كبيرًا باختلاف الأنواع والأعمار والحالات الصحية. لم نجد حتى الآن فريقًا علميًا مستقلًا قادرًا على تطوير مثل هذا التقييم.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ar.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'مرحباً بكم في حقائق الجمال المفتوحة!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'ما هي حقائق الجمال المفتوحة؟';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts عبارة عن قاعدة بيانات تعاونية لمنتجات التجميل.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'هدفنا هو تحليل قوائم المكونات لمساعدتكِ **على فهم مكونات منتجات العناية الشخصية**. من المرطبات إلى مستحضرات التجميل، نجمع بيانات عن المكونات ومسببات الحساسية والتغليف لتعزيز الشفافية في صناعة مستحضرات التجميل.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'مميزات تطبيق Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'احصل على تنبيهات بشأن المكونات غير المرغوب فيها';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'هل تعاني من حساسية تجاه أي من المكونات؟ هل ترغب في تجنب المواد المسببة للرؤوس السوداء؟ هل ترغب في تجنب المكونات المثيرة للجدل؟ يمكنك تحديد قائمة بالمكونات التجميلية التي يجب تجنبها مباشرةً من التطبيق!';

  @override
  String get guide_open_beauty_facts_tips_title => 'نصائح لالتقاط صور رائعة';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'لا تفعل';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 => 'تجنب الظلال والوهج.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'لا يوجد نص ضبابي أو خارج التركيز.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'لا تقم بقص أجزاء من النص.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'تجنب الخلفيات المزدحمة.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'افعل';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'استخدم إضاءة جيدة ومتساوية.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'تأكد من أن النص حاد وقابل للقراءة.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'التقاط قائمة المكونات بأكملها.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'التقط أكبر عدد ممكن من الصور حسب الحاجة إذا كانت الزجاجة منحنية.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'قد تحتاج إلى تقشير الملصق لرؤية قائمة المكونات.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'احتفظ بالمنتج على سطح مستو.';

  @override
  String get guide_open_beauty_facts_scores_title => 'ملاحظة حول التسجيل';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'على عكس المنتجات الغذائية، لا يعتمد عالم مستحضرات التجميل نظام تقييم معتمد عالميًا ومدعوم حكوميًا مثل نظام Nutri-Score. قد تختلف تأثيرات المكونات باختلاف نوع البشرة والحساسية والمخاوف الشخصية.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ar.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'مرحباً بكم في الأسعار المفتوحة!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'ما هي الأسعار المفتوحة؟';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      '\"الأسعار المفتوحة\" مشروع لجمع ومشاركة أسعار المنتجات حول العالم. وهي قاعدة بيانات متاحة للعامة، ويمكن استخدامها للبحث والتحليل وغيرها. طُوّرت \"الأسعار المفتوحة\" وصيانتها بواسطة \"حقائق الغذاء المفتوحة\".';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'كيف تعمل الأسعار المفتوحة؟';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**نعمل على جمع بيانات أسعار مفتوحة المصدر من الجمهور**. يمكن للمستخدمين إضافة الأسعار عبر تطبيق الويب هذا، أو عبر تطبيق Open Food Facts الرسمي للهواتف المحمولة. كما يمكن لتجار التجزئة أو تطبيقات الجهات الخارجية المساهمة باستخدام واجهة برمجة التطبيقات الخاصة بنا.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'جمع صور لعلامات الأسعار في الممرات';

  @override
  String get guide_open_prices_how_arg2_title => 'جمع صور الإيصالات';

  @override
  String get guide_open_prices_why_title => 'لماذا تقوم Open Food Facts بهذا؟';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'تُعد معلومات الأسعار بالغة الأهمية لفهم النظم الغذائية. فهي عامل أساسي في فهم تكلفة الغذاء وتعزيز اتباع أنظمة غذائية صحية. تُسهّل بيانات الأسعار الافتتاحية على الباحثين والصحفيين والمواطنين فهم كيفية اختلاف أسعار الغذاء جغرافيًا وزمنيًا بشكل أفضل.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'تتبع تطور الأسعار بمرور الوقت';

  @override
  String get guide_open_prices_why_arg1_text =>
      'انظر إلى **تطور الأسعار**: التضخم الانكماشي، والتضخم الرخيص، يمكننا تتبعهما معًا!';

  @override
  String get guide_open_prices_why_arg2_title => 'قارن الأسعار بالقرب منك';

  @override
  String get guide_open_prices_why_arg2_text =>
      'مع حصولنا على المزيد من الأسعار، يمكنك تحديد **المتاجر الأرخص حولك**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'هل فكرت في استخراج الأسعار من مواقع الويب الخاصة بالمتاجر؟';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'لأسباب قانونية وفنية، **لا نعتبر جمع الأسعار من مواقع تجار التجزئة طريقةً صالحةً للمساهمة في \"الأسعار المفتوحة\". نحرص على دقة الأسعار التي نجمعها وتحديثها، وتلقينا أسعارًا من المساهمين لا يسمح لنا بذلك.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'يعد استخراج الأسعار خيارًا مدروسًا في الإصدار المستقبلي من Open Prices، ولكن سيتم ذلك بواسطة Open Prices نفسها حتى نتمكن من الحصول على دليل على السعر استنادًا إلى صفحة HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'يمكنك المساهمة في الأسعار باستخدام واجهة برمجة التطبيقات الخاصة بنا.\nإذا كنت ترغب في المساهمة في الأسعار على نطاق واسع، فيرجى التواصل معنا على prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'مرحباً بكم في حقائق المنتجات المفتوحة!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'ما هي حقائق المنتجات المفتوحة؟';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'حقائق المنتجات المفتوحة عبارة عن قاعدة بيانات ضخمة مفتوحة لأي منتج يحمل رمزًا شريطيًا، وهو ليس طعامًا أو مستحضر تجميل أو طعامًا للحيوانات الأليفة.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'من **الإلكترونيات** إلى **الألعاب**، ومن **الملابس** إلى **مستلزمات التنظيف**، إذا كانت تحتوي على رمز شريطي، يُمكن إضافتها. يهدف هذا المشروع إلى إنشاء \"إنترنت الأشياء\" للأشياء اليومية، مما يجعل المعلومات المتعلقة بها في متناول الجميع.';

  @override
  String get guide_open_products_facts_features_title =>
      'مميزات حقائق المنتجات المفتوحة';

  @override
  String get guide_open_products_facts_features_text =>
      'تهدف Open Products Facts إلى تمكين المستهلكين من **إطالة عمر الأشياء** من خلال توفير الحلول الدائرية للحفاظ على أشيائهم وإصلاحها وإعادة تدويرها أو منحها مالكًا جديدًا.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'البصمة الكربونية لبعض المنتجات';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      'يوفر تقرير **تأثير ثاني أكسيد الكربون** الصادر عن هيئة البيئة الفرنسية ADEME **تأثير الكربون** للعديد من الفئات، تأكد من تصنيف المنتجات بدقة.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'مؤشر قابلية الإصلاح للعديد من المنتجات';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'كلما توفر مؤشر قابلية الإصلاح الفرنسي، سنعرضه. علاوة على ذلك، **يمكنك البدء بجمع المتغيرات باستخدام محرك Folksonomy**؛ حتى نتمكن من إعادة حسابه بأنفسنا مستقبلًا، حتى في الدول التي لا يتوفر فيها.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'ابحث عن طرق للتبرع بمنتجك أو إعادة بيعه';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'نوفر روابط لخدمات خارجية صديقة للبيئة تساعدك في الحصول على المنتج الذي تبحث عنه، كمنتج مستعمل، ليكون أكثر مراعاةً للموارد الطبيعية.\nيُرجى العلم أننا لا نتقاضى أجرًا مقابل ذلك، وأن النظام يعمل فقط كمثال لموقعين إلكترونيين في فرنسا. يمكنك المساهمة في توسيع هذا النظام بتوثيق المزيد من المواقع على الويكي.';

  @override
  String get guide_open_products_facts_information_title =>
      'ما هي المعلومات المفيدة؟';

  @override
  String get guide_open_products_facts_information_text =>
      'لهذه المجموعة الواسعة من العناصر، **البيانات التي نجمعها مرنة**. ولتحقيق ذلك، **أنشأنا محرك Folksonomy**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'محرك الفولكسونومي';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'محرك Folksonomy هو أداة تساعدك على إكمال المنتجات بالخصائص المناسبة. يُحسّن هذا البحث وإمكانية الاكتشاف، بالإضافة إلى حساب وعرض العناصر المهمة مستقبلًا.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'يمكنك إضافة أي مفاتيح وقيم مثل: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'سوف تحصل على اقتراح تلقائي للخصائص المحتملة، ويسعدنا أن نضيف وتوثّق خصائص جديدة لأنواع المنتجات المفضلة لديك.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ar.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'تفضيلات الطعام المفتوحة';

  @override
  String get guide_coming_soon_button_title => 'قريباً';

  @override
  String get guide_learn_more_subtitle => 'انقر لمعرفة المزيد';

  @override
  String get preview_badge => 'معاينة';

  @override
  String get prices_feedback_form =>
      'انقر هنا لإرسال تعليقاتك حول هذه الميزة الجديدة!';

  @override
  String get menu_button_list_actions => 'حدد إجراءً';

  @override
  String get error_loading_photo => 'خطأ في تحميل الصورة';

  @override
  String get photo_viewer_action_use_picture_as => 'استخدم كـ…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'استخدم هذه الصورة كـ…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'استخدم هذه الصورة كـ… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'تفاصيل';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'تفاصيل هذه الصورة';

  @override
  String get photo_viewer_details_title => 'تفاصيل الصورة';

  @override
  String get photo_viewer_details_contributor_title => 'مساهم';

  @override
  String get photo_viewer_details_size_title => 'مقاس';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height بكسل';
  }

  @override
  String get photo_viewer_details_date_title => 'تاريخ';

  @override
  String get photo_viewer_details_url_title => 'عنوان URL';

  @override
  String get product_page_compatibility_score => 'متناسق';

  @override
  String get user_lists_action_multi_select => 'اختيار متعدد';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'درجة توافقك: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'الصورة الأمامية';

  @override
  String get product_image_ingredients_accessibility_label =>
      'صورة للقائمة المكونات';

  @override
  String get product_image_nutrition_accessibility_label => 'صورة التغذية';

  @override
  String get product_image_packaging_accessibility_label => 'صورة التغليف';

  @override
  String get product_image_other_accessibility_label => 'صورة اخرى';

  @override
  String get product_image_outdated_message => 'قد تكون هذه الصورة قديمة';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (قد تكون هذه الصورة قديمة)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (قد يتم قفل هذه الصورة بواسطة المنتج)';
  }

  @override
  String get product_image_error => 'غير قادر على تحميل الصورة!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'غير قادر على تحميل $type (خطأ في الشبكة؟)';
  }

  @override
  String get product_page_image_no_image_available => 'لا يوجد صورة\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'لا توجد صورة متاحة لهذا المنتج';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'إعادة ترتيب الإجراءات أو إخفاؤها';

  @override
  String get product_page_action_bar_setting_modal_title => 'تحرير الإجراءات';

  @override
  String get product_page_action_bar_item_move_up => 'تحرك للأعلى';

  @override
  String get product_page_action_bar_item_move_down => 'تحرك للأسفل';

  @override
  String get product_page_action_bar_item_enable => 'تمكين الإجراء';

  @override
  String get product_page_action_bar_item_disable => 'تعطيل الإجراء';

  @override
  String get product_page_pending_operations_banner_title => 'تحميل تعديلاتك…';

  @override
  String get product_page_pending_operations_banner_message =>
      'البيانات المعروضة على هذه الصفحة **لا تعكس تعديلاتك بعد**.\nيرجى الانتظار بضع ثوان…';

  @override
  String get product_add_a_language => 'إضافة لغة';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'الباركود $barcode';
  }

  @override
  String get carousel_close_tooltip => 'إزالة هذا المنتج من الدوارة';

  @override
  String get carousel_unsupported_header => 'الباركود غير مدعوم!';

  @override
  String get carousel_unsupported_title => 'اوبس!';

  @override
  String get carousel_unsupported_text =>
      'لا يدعم Open Food Facts الرمز الشريطي الممسوح ضوئيًا!';

  @override
  String get carousel_error_header => 'خطأ!';

  @override
  String get carousel_error_title => 'إنه أمر محبط!';

  @override
  String get carousel_error_text_1 =>
      'لم نتمكن من تنزيل المعلومات حول هذا الرمز الشريطي:';

  @override
  String get carousel_error_text_2 =>
      'يرجى التحقق من اتصالك بالإنترنت أو انقر فوق هذا الزر:';

  @override
  String get carousel_error_button => 'إعادة المحاولة';

  @override
  String get carousel_unknown_product_header => 'منتج غير معروف';

  @override
  String get carousel_unknown_product_title =>
      'مبروك!\nلقد وجدت __الجوهرة النادرة!__';

  @override
  String get carousel_unknown_product_text =>
      'تحتوي قاعدة بياناتنا التعاونية على أكثر من **3 ملايين منتج**، ولكن هذا الرمز الشريطي غير موجود: ';

  @override
  String get carousel_unknown_product_button => 'إضافة منتج';

  @override
  String get carousel_loading_header => 'جاري تحميل المعلومات...';

  @override
  String get carousel_loading_title =>
      'لقد قمت للتو بمسح المنتج بالرمز الشريطي التالي:';

  @override
  String get carousel_loading_text =>
      'نحن نبحث عنه في قاعدة بياناتنا التي تحتوي على أكثر من **3 ملايين منتج!**';

  @override
  String get product_type_subtitle_food =>
      'الخضروات والفواكه والأطعمة المجمدة…';

  @override
  String get product_type_subtitle_beauty => 'المكياج والصابون ومعجون الأسنان…';

  @override
  String get product_type_subtitle_pet_food => 'طعام للكلاب والقطط…';

  @override
  String get product_type_subtitle_product => 'الهواتف الذكية والأثاث…';

  @override
  String get photo_field_front => 'صورة المنتج';

  @override
  String get photo_field_ingredients => 'صورة المكونات';

  @override
  String get photo_field_nutrition => 'صورة التغذية';

  @override
  String get photo_field_packaging => 'صورة معلومات التعبِئة';

  @override
  String get photo_already_exists => 'هذه الصورة موجودة بالفعل';

  @override
  String get photo_missing => 'هذه الصورة مفقودة';

  @override
  String get date => 'تاريخ';

  @override
  String get photo_rotate_left => 'دوران لليسار';

  @override
  String get photo_rotate_right => 'تدوير الحق';

  @override
  String get photo_undo_action => 'التراجع عن الإجراء السابق';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'خريطة العالم $location';
  }

  @override
  String get open_street_map_contributor_attribution => 'مساهمو OpenStreetMap';

  @override
  String get not_applicable_short => 'غير متوفر';

  @override
  String get knowledge_panel_warning_text => 'تحذير';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'لماذا يختلف هذا Nutri-Score عن ذلك الموجود على العبوة؟';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'هناك تفسيران محتملان:\nقائمة المكونات و/أو المعلومات الغذائية غير محدثة.\n\nنوفر \"حسابًا جديدًا\" لـ Nutri-Score (أو الإصدار الثاني). يُرجى التأكد من وجود شعار \"حساب جديد\" على العبوة.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'التحقق من المكونات';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'التحقق من الحقائق الغذائية';

  @override
  String url_not_supported(String url) {
    return 'لسوء الحظ، لا يمكننا فتح عنوان URL:\n$url';
  }

  @override
  String get product_list_export => 'يصدّر';

  @override
  String get product_list_import => 'يستورد';

  @override
  String get product_footer_action_barcode => 'عرض الباركود';

  @override
  String get product_footer_action_barcode_short => 'الرمز الشريطي';

  @override
  String get product_footer_action_open_website => 'افتح الموقع';

  @override
  String get product_footer_action_report => 'تقرير';

  @override
  String get product_footer_action_contributor_guide => 'يساعد';

  @override
  String get product_footer_action_data_quality_tags => 'جودة البيانات';

  @override
  String get product_page_tab_for_me => 'لي';

  @override
  String get product_page_tab_website => 'موقع إلكتروني';

  @override
  String get product_page_tab_prices => 'الأسعار';

  @override
  String get prices_explanation_card_title => 'لماذا الاسعار؟';

  @override
  String get prices_explanation_card_line1 =>
      '**الأسعار المفتوحة** مشروع لجمع ومشاركة أسعار المنتجات حول العالم 🌍. تم تطوير \"الأسعار المفتوحة\" وصيانتها بواسطة Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'لمعرفة المزيد';

  @override
  String get product_page_tab_folksonomy => 'علم اللغة الشعبية';

  @override
  String get folksonomy_explanation_card_title => 'ما هي سمات Folksonomy؟';

  @override
  String get folksonomy_explanation_card_line1 =>
      'السمات تعتمد على **المفتاح والقيمة**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'يتم إنشاء هذه الخصائص وتسجيلها بواسطة المساهمين لأي نوع من الاستخدامات.';

  @override
  String get folksonomy_action_external_link_title => 'افتح الرابط الخارجي';

  @override
  String get folksonomy_action_external_link_warning =>
      'قد تكون الروابط الخارجية غير آمنة. هل ترغب حقًا بزيارتها؟';

  @override
  String get prices_products_empty_title => 'لا يوجد سعر متاح';

  @override
  String get prices_products_empty_explanation => 'كن أول من يساهم!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'أفضل $pageSize المنتجات (المجموع: $total)';
  }

  @override
  String get app_review_title => 'هل تستمتع بهذا التطبيق؟';

  @override
  String get app_review_low => 'يمكن أن أفعل أفضل';

  @override
  String get app_review_medium => 'ليس سيئًا';

  @override
  String get app_review_high => 'أنا أحبه!';

  @override
  String get app_review_feedback_modal_title => 'ساعدنا على تحسين تطبيقنا';

  @override
  String get app_review_feedback_modal_content =>
      'إذا كان لديك بضع دقائق، هل يمكنك الإجابة على هذا النموذج حتى نتمكن من التحسين في التحديثات المستقبلية:';

  @override
  String get app_review_feedback_modal_open_form => 'أجب على النموذج';

  @override
  String get app_review_feedback_modal_later => 'اسألني لاحقا';

  @override
  String get nutrition_facts_extract_new =>
      'جديد: يمكنك استخراج العناصر الغذائية من الصورة تلقائيًا!';

  @override
  String get nutrition_facts_extract_button_text => 'استخرج الآن';

  @override
  String get nutrition_facts_extract_in_progress => 'جاري الاستخراج…';

  @override
  String get nutrition_facts_extract_successful => 'تم الاستخراج بنجاح';

  @override
  String get nutrition_facts_extract_failed =>
      'فشل في استخراج العناصر الغذائية من الصورة';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'إحصائيات';

  @override
  String get prices_stats_title => 'إحصائيات الأسعار';

  @override
  String get prices_stats_prices_section => 'الأسعار';

  @override
  String get prices_stats_products_section => 'المنتجات';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'المساهمون';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'متنوع';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'استهلاك';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'طعام';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'المنتجات';

  @override
  String get prices_stats_pet_food => 'طعام الحيوانات الأليفة';

  @override
  String get prices_stats_osm => 'خريطة الشارع المفتوحة';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'بلدان';

  @override
  String get prices_stats_price_tag => 'سعر البطاقة';

  @override
  String get prices_stats_receipt => 'إيصال';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'موقع إلكتروني';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'واجهة برمجة التطبيقات (API)';

  @override
  String get prices_stats_other => 'أخرى';

  @override
  String get prices_stats_last_updated => 'تم التحديث آخر مرة في';

  @override
  String get prices_stats_error => 'حدث خطأ أثناء تحميل الإحصائيات.';

  @override
  String get product_edit_robotoff_question_answered =>
      'تمت الإجابة على السؤال!';

  @override
  String get product_edit_robotoff_proof => 'دليل';

  @override
  String get preferences_card_general => 'عام';

  @override
  String get preferences_prices_title => 'الأسعار';

  @override
  String get preferences_prices_subtitle => 'إدارة تفضيلات الأسعار الخاصة بك';

  @override
  String get preferences_card_project => 'مشروع حقائق الغذاء المفتوحة';

  @override
  String get preferences_contribute_title => 'المساهمة';

  @override
  String get preferences_my_contributions_title => 'مساهماتي';

  @override
  String get preferences_my_stats_title => 'إحصائياتي';

  @override
  String get preferences_contribute_subtitle => 'ترجمة، تحسين أدواتنا…';

  @override
  String get preferences_connect_title => 'يتصل';

  @override
  String get preferences_connect_subtitle =>
      'تواصل معنا أو تابعنا على وسائل التواصل الاجتماعي';

  @override
  String get preferences_support_title => 'قم بالتبرع';

  @override
  String get preferences_support_subtitle =>
      'ساعدنا في إعلام ملايين المستهلكين حول العالم';

  @override
  String get preferences_card_help => 'المساعدة والدعم';

  @override
  String get preferences_faq_title => 'الأسئلة المتكررة';

  @override
  String get preferences_faq_subtitle => 'احصل على إجابات لأسئلتك';

  @override
  String get logged_out => 'تم تسجيل الخروج';

  @override
  String get preferences_app_bar_message => 'شكرا لك لكونك أحد أعضائنا!';

  @override
  String get preferences_app_bar_products_modified => 'المنتجات المعدلة';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'شاهد جميع الإحصائيات';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'ابحث عن $provider عن \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'ابحث عن الإعداد (على سبيل المثال Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'إمكانية الوصول: إظهار الرموز التعبيرية';

  @override
  String get preferences_accessibility_remove_colors =>
      'إمكانية الوصول: إزالة الألوان';

  @override
  String get preferences_app_settings_products => 'المنتجات';

  @override
  String get preferences_card_about => 'حول';

  @override
  String get preferences_legal_information_title => 'المعلومات القانونية';

  @override
  String get preferences_legal_information_subtitle =>
      'شروط الاستخدام وسياسة الخصوصية والمزيد';

  @override
  String get preferences_terms_of_use => 'شروط الاستخدام';

  @override
  String get preferences_legal_mentions => 'لمحات قانونية';

  @override
  String get preferences_legal_header =>
      'Open Food Facts عبارة عن قاعدة بيانات لمنتجات الأغذية **أنشأها الجميع، من أجل الجميع**.\nيمكنك استخدامها لاتخاذ خيارات غذائية أفضل، وبما أنها **بيانات مفتوحة**، يمكن لأي شخص **إعادة استخدامها لأي غرض**.';

  @override
  String get preferences_privacy_policy => 'سياسة الخصوصية';

  @override
  String get preferences_licenses => 'التراخيص';

  @override
  String get preferences_about_app_title => 'حول التطبيق';

  @override
  String get preferences_about_app_subtitle =>
      'المعلومات الفنية ومعلومات المطور والمزيد';

  @override
  String get preferences_card_information => 'معلومات';

  @override
  String get preferences_version_number_title => 'رقم الإصدار';

  @override
  String get preferences_scanner_title => 'الماسح الضوئي';

  @override
  String get preferences_app_store => 'متجر التطبيقات';

  @override
  String get preferences_app_system_settings => 'إعدادات النظام';

  @override
  String get preferences_source_code => 'الوصول إلى الكود المصدر';

  @override
  String get preferences_source_code_subtitle =>
      'وابدأ في إحداث تأثير إيجابي على الملايين';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'أخبر العالم';

  @override
  String get preferences_tips => 'نصائح';

  @override
  String get tips_discover_nutriscore => 'اكتشف Nutri-Score الجديد';

  @override
  String get preferences_on_off_website_subtitle => 'على موقع Open Food Facts';

  @override
  String get preferences_manage_account_title => 'إدارة حسابي';

  @override
  String get preferences_manage_account_tooltip => 'إدارة حسابك';

  @override
  String get preferences_change_password_title => 'تغيير كلمة المرور الخاصة بي';

  @override
  String get preferences_danger_zone => 'منطقة الخطر';

  @override
  String get preferences_account_deletion_subtitle =>
      'سيتم فقدان جميع مساهماتك';

  @override
  String get preferences_contributions_title => 'مساهمات';

  @override
  String get preferences_dev_mode_app_settings_title => 'إعدادات التطبيق';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'طريقة تجريبية للغاية لمسح المنتجات دون اتصال بالإنترنت';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'تحديث جميع المنتجات من الخادم';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'يرجى تجنب القيام بذلك إلا إذا كان ذلك ضروريا للغاية';

  @override
  String get preferences_dev_mode_demo_mode_title => 'الوضع التجريبي';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'إضافة البطاقات إلى الماسح الضوئي';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'إضافة 3 منتجات عينة إلى الماسح الضوئي';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'مضيف الفولكسونومي';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'المضيف: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'تجارب إمكانية الوصول';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'اختيار منتجات متعددة للأسعار';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'لوحات المعرفة التي طلبها المستخدم';

  @override
  String get preferences_dev_mode_location_search_title =>
      'الوصول المؤقت إلى البحث عن الموقع';

  @override
  String get preferences_dev_mode_comparison_title =>
      'مقارنة جنبًا إلى جنب لمنتجين أو ثلاثة';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'استيراد قائمة المنتجات';

  @override
  String get preferences_faq_scores_methodologies_title => 'النتائج والمنهجيات';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'اكتشف كيف يتم حساب Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'اكتشف التغييرات الرئيسية في المنهجية';

  @override
  String get preferences_faq_discover_project_title => 'اكتشاف المشروع';

  @override
  String get preferences_faq_discover_off_title =>
      'اكتشف حقائق الطعام المفتوحة';

  @override
  String get preferences_faq_discover_obf_title =>
      'اكتشف حقائق الجمال المفتوحة';

  @override
  String get preferences_faq_discover_opff_title =>
      'اكتشف حقائق طعام الحيوانات الأليفة المفتوحة';

  @override
  String get preferences_faq_discover_op_title => 'اكتشف الأسعار المفتوحة';

  @override
  String get preferences_faq_discover_opf_title =>
      'اكتشف حقائق المنتجات المفتوحة';

  @override
  String get preferences_faq_faq_title => 'الأسئلة الشائعة';

  @override
  String get preferences_faq_off_ngo_title =>
      'منظمة حقائق الغذاء المفتوحة غير الحكومية';

  @override
  String get preferences_about_information_title => 'معلومات';

  @override
  String get preferences_connect_community_updates_title =>
      'احصل على تحديثات المجتمع';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'ابق على اطلاع بأحدث أخبار التطبيق والمجتمع';

  @override
  String get preferences_connect_community_calendar_title =>
      'اشترك في تقويم مجتمعنا';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'شارك من خلال حضور أحد فعالياتنا الافتراضية';

  @override
  String get preferences_connect_blog_title => 'مدونة حقائق الغذاء المفتوحة';

  @override
  String get preferences_connect_blog_subtitle =>
      'احصل على آخر الأخبار فور حدوثها';

  @override
  String get preferences_connect_community_help_title =>
      'احصل على المساعدة من المجتمع';

  @override
  String get preferences_connect_improve_app_title =>
      'ساعدنا على تحسين التطبيق';

  @override
  String get preferences_connect_debug_info_title => 'أرسل لنا معلومات التصحيح';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'أرسل لنا بريدًا إلكترونيًا يحتوي على معلومات تفصيلية حول تصحيح الأخطاء';

  @override
  String get preferences_connect_feedback_title =>
      'أرسل لنا تعليقاتك حول التطبيق';

  @override
  String get preferences_connect_feedback_subtitle =>
      'ساعد في تشكيل مستقبل التطبيق';

  @override
  String get preferences_connect_survey_title =>
      'قم بإجراء استطلاع رأي التطبيق';

  @override
  String get preferences_connect_survey_subtitle =>
      'ساعدنا على فهم ما يجب أن نبني بعد ذلك';

  @override
  String get preferences_connect_professionals_title => 'المحترفون';

  @override
  String get preferences_connect_pro_subtitle =>
      'مجاني تمامًا، يضمن دقة البيانات لـ 500 تطبيق وملايين المستخدمين. خدمة ذاتية، متوافقة مع نظام إدارة معلومات المستخدم (PIM) أو جداول البيانات (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle => 'تواصل معنا للبدء';

  @override
  String get preferences_connect_press_title => 'صحافة';

  @override
  String get preferences_connect_press_page_subtitle =>
      'احصل على جميع المواد التي تحتاجها لتقريرك';

  @override
  String get preferences_connect_press_email_subtitle =>
      'تواصل معنا للاستفسارات الصحفية أو لإعلامنا بتقريرك';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'كن متطوعًا نشطًا';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'التطوير، التواصل، التصميم… أي نوع من التطوع أو الخبرة مرحب به!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'اكتشف بعض الطرق العديدة التي يمكنك المساهمة بها';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'تطوير تطبيقات الهاتف المحمول';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'تعرف على كيفية المساهمة في تطوير البرمجيات';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'إصدارات غير مستقرة يوميًا، وميزات جديدة تمامًا';

  @override
  String get preferences_contribute_local_community_title =>
      'تنمية مجتمعك المحلي';

  @override
  String get preferences_contribute_translate_subtitle =>
      'المساعدة في ترجمة البرامج والمحتويات وتحليل المكونات';

  @override
  String get preferences_contribute_share_subtitle =>
      'لقد أعددنا قالبًا صغيرًا لمساعدتك :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'خطوات بسيطة لتعزيز الشفافية الغذائية في بلدك';

  @override
  String get preferences_contribute_data_quality_title => 'جودة البيانات';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'انضم إلى فريق جودة البيانات';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'انضم إلى جهودنا لضمان اكتمال قاعدة البيانات ودقتها';

  @override
  String get preferences_contributions_products_added_title =>
      'المنتجات المضافة';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'المنتجات الجديدة التي أضفتها إلى Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'المنتجات التي أحتاج إلى إكمالها';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'جميع المنتجات غير المكتملة';

  @override
  String get preferences_my_contributions_prices_title => 'الأسعار';

  @override
  String get preferences_my_contributions_my_prices_title => 'أسعاري';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'أسعاري، أدلتي…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'المنتجات التي يمكنك المساعدة في إكمالها';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'ساعد في حساب Nutri-Score وGreen-Score في بلدك';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'الأسعار التي ساهمت بها';

  @override
  String get preferences_prices_proofs_subtitle => 'بطاقات الأسعار والإيصالات';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'التقط صورًا لإيصالاتك ثم امسح الباركود المرتبطة بها';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'التقاط صور للأسعار في المتجر';

  @override
  String get preferences_prices_newest_title => 'أحدث الأسعار';

  @override
  String get preferences_prices_newest_subtitle =>
      'أحدث الأسعار المضافة من قبل مجتمع Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'المساهمون بأعلى الأسعار';

  @override
  String get preferences_prices_metrics_title => 'مقاييس سعر الافتتاح';

  @override
  String get preferences_prices_metrics_subtitle => 'تابع تطور المشروع';

  @override
  String get preferences_prices_ways_contribute_title => 'طرق المساهمة';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'تأكيد الأسعار التي أضفتها بنفسك أو بواسطة الآخرين، بمساعدة الذكاء الاصطناعي';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'أضف بسرعة العديد من الإيصالات أو صور الأرفف من ألبوم الكاميرا الخاص بك';

  @override
  String get preferences_prices_challenges_title => 'التحديات الشهرية';

  @override
  String get preferences_prices_challenges_subtitle =>
      'المشاركة في المهام المواضيعية الشهرية لجمع الأسعار';

  @override
  String get preferences_prices_loyalty_data_title =>
      'استعادة بيانات الولاء الخاصة بك';

  @override
  String get preferences_prices_gdpr_subtitle => 'تعرف على كيفية طلب بياناتك';

  @override
  String get preferences_page_customize_app_title => 'تخصيص التطبيق';

  @override
  String get preferences_page_contribute_project_title => 'المساهمة في المشروع';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'طرق بسيطة للمساعدة في Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'منهجيات التقييم والمساعدة والمزيد حول المشروع';

  @override
  String get product_edit_robotoff_positive_button => 'قبول الاقتراح';

  @override
  String get product_edit_robotoff_negative_button => 'رفض الاقتراح';

  @override
  String get product_edit_robotoff_show_proof => 'إظهار الدليل';

  @override
  String get product_edit_robotoff_expand_proof => 'توسيع الدليل';

  @override
  String get product_page_tab_raw_data => 'البيانات الخام';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'الصفحة $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'الصفحة $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count من $total عناصر';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count من $total عناصر';
  }

  @override
  String item_count(int count) {
    return '$count عناصر';
  }

  @override
  String item_count_string(String count) {
    return '$count عناصر';
  }

  @override
  String get prices_no_result => 'لم يتم العثور على إحصائيات الأسعار.';

  @override
  String get prices_error_loading_more_items =>
      'خطأ في تحميل المزيد من العناصر';

  @override
  String get prices_proof_error => 'فشل المصادقة، غير قادر على جلب الأدلة';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count من $total دليل';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count من $total مساهم';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count من $total موقعًا';
  }

  @override
  String prices_locations_count(int count) {
    return '$count مواقع';
  }

  @override
  String get restart_to_apply_message =>
      'يرجى إعادة تشغيل التطبيق لتطبيق التغييرات.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'واجهة رسومية';

  @override
  String get preferences_app_settings_media_title => 'وسائط';

  @override
  String get preferences_about_app_development_title => 'مطور البرامج';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'مختبرات حقائق الغذاء المفتوحة';

  @override
  String get preferences_root_account_title => 'الحساب';

  @override
  String get preferences_contribute_translate_header =>
      'جلب حقائق الطعام المفتوحة إلى لغتك';

  @override
  String get preferences_contribute_enroll_alpha =>
      'التسجيل في النسخة التجريبية للتطبيق';

  @override
  String get preferences_dev_mode_section_data => 'المساهمات وبيانات المنتج';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'لا تظهر التصنيف الشعبي';

  @override
  String get preferences_account_title => 'الحساب';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'تمت الإضافة في $created';
  }

  @override
  String get location_map_details_title => 'تفاصيل الموقع';

  @override
  String get location_map_details_name => 'اﻹسم';

  @override
  String get location_map_details_street => 'شارع';

  @override
  String get location_map_details_city => 'مدينة';

  @override
  String get location_map_details_postcode => 'شفرة البريد';

  @override
  String get location_map_details_country => 'بلد';

  @override
  String get location_map_details_coordinates => 'الإحداثيات';

  @override
  String get location_map_details_osm_id => 'معرف OSM';
}
