# Changelog

## [6.1.0]

* Issue #186 - Correctly report the device's local time by @krozett in https://github.com/Floating-Dartists/matomo-tracker/pull/187
* docs(contributor): contributors readme action update by @github-actions[bot] in https://github.com/Floating-Dartists/matomo-tracker/pull/188
* Issue #189: bugfix: reset/initialize visitor when setCookieless is called by @stefangaller in https://github.com/Floating-Dartists/matomo-tracker/pull/190
* docs(contributor): contributors readme action update by @github-actions[bot] in https://github.com/Floating-Dartists/matomo-tracker/pull/191
* Add support for custom user language by @streinhard in https://github.com/Floating-Dartists/matomo-tracker/pull/192
* docs(contributor): contributors readme action update by @github-actions[bot] in https://github.com/Floating-Dartists/matomo-tracker/pull/193
* build(deps): bump device_info_plus from 11.5.0 to 12.1.0 by @dependabot[bot] in https://github.com/Floating-Dartists/matomo-tracker/pull/198
* build(deps): bump package_info_plus from 8.3.1 to 9.0.0 by @dependabot[bot] in https://github.com/Floating-Dartists/matomo-tracker/pull/199

## New Contributors
* @krozett made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/187
* @stefangaller made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/190
* @streinhard made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/192

**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/6.0.0...6.1.0

## [6.0.0]

* Change dispatchActions during initialization to unawaited by @skiluk in https://github.com/Floating-Dartists/matomo-tracker/pull/179
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/180
* build(deps): bump custom_lint from 0.6.10 to 0.7.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/182
* chore: supersed #183 and bump dependencies by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/185

## New Contributors
* @skiluk made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/179

## [6.0.0-dev.1]

* 173 feat improve matomoobserver to dispense with traceableclientmixin by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/174
* chore: bump dependencies by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/177

**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/5.1.0...6.0.0-dev.1

## [5.1.0]

* build(deps): bump device_info_plus from 9.1.2 to 10.1.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/166
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/167
* build(deps): bump device_info_plus from 9.1.2 to 10.1.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/168
* Adding `http.Client` argument to the MatomoDispatcher class by @tfreebern2 in https://github.com/Floating-Dartists/matomo-tracker/pull/171
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/172

## New Contributors
* @tfreebern2 made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/171

**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/5.0.0...5.0.1

## [5.0.0+1]

* Updated `README.md` with supported Matomo versions.

## [5.0.0]

**Check the [Migration Guide](https://github.com/Floating-Dartists/matomo-tracker#v500) to learn about breaking changes in this version**

* Fix country code case by @kuhnroyal in https://github.com/Floating-Dartists/matomo-tracker/pull/157
* Add iOS machine name to user agent by @kuhnroyal in https://github.com/Floating-Dartists/matomo-tracker/pull/158
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/159
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/160
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/162
* Remove unused query parameters by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/164

## New Contributors
* @kuhnroyal made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/157

**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/5.0.0-dev.3...5.0.0

## [5.0.0-dev.3]

* build(deps): bump package_info_plus from 7.0.0 to 8.0.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/151
* build(deps): bump custom_lint from 0.5.11 to 0.6.4 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/152
* Bumping up versions and min SDK to 3.4.1 by @Hyla96 in https://github.com/Floating-Dartists/matomo-tracker/pull/153
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/154

## New Contributors
* @Hyla96 made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/153

**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/5.0.0-dev.2...5.0.0-dev.3

## [5.0.0-dev.2]

* build(deps): bump device_info_plus from 9.1.2 to 10.0.1 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/146
* build(deps): bump package_info_plus from 6.0.0 to 7.0.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/148
* Prepare v5.0.0-dev.2 by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/150


**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/5.0.0-dev.1...5.0.0-dev.2

## [5.0.0-dev.1]

* build(deps): bump uuid from 3.0.7 to 4.1.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/125
* Chore/bump dependencies by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/126
* build(deps): bump package_info_plus from 4.2.0 to 5.0.1 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/128
* [FEAT] [#129] by @jainhitesh9998 in https://github.com/Floating-Dartists/matomo-tracker/pull/130
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/131
* 132 contentbaseurl not working with hash sign by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/133
* Allow uuid 5.x by @hpoul in https://github.com/Floating-Dartists/matomo-tracker/pull/136
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/137
* Add grandTotal/revenue to trackCartUpdate by @CleverUnderDog in https://github.com/Floating-Dartists/matomo-tracker/pull/138
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/139
* build(deps): bump package_info_plus from 5.0.1 to 6.0.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/142
* feat: added option to toggle off cookieless by @zvikarp in https://github.com/Floating-Dartists/matomo-tracker/pull/143
* docs(contributor): contributors readme action update by @github-actions in https://github.com/Floating-Dartists/matomo-tracker/pull/145

### New Contributors
* @jainhitesh9998 made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/130
* @hpoul made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/136
* @CleverUnderDog made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/138
* @zvikarp made their first contribution in https://github.com/Floating-Dartists/matomo-tracker/pull/143

**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/4.1.1...5.0.0-dev.1

## [4.1.1]

* Bump device_info_plus from 9.0.3 to 10.0.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/123
* Bump package_info_plus from 4.1.0 to 5.0.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/122
* chore: bump dependencies, fix formatting by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/124


**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/4.1.0...4.1.1

## [4.1.0]

* Bump custom_lint from 0.4.0 to 0.5.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/114
* Bump mocktail from 0.3.0 to 1.0.0 by @dependabot in https://github.com/Floating-Dartists/matomo-tracker/pull/116
* feat: fixed README and bumped dependencies by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/118
* Feat: Change url on the fly by @TesteurManiak in https://github.com/Floating-Dartists/matomo-tracker/pull/120


**Full Changelog**: https://github.com/Floating-Dartists/matomo-tracker/compare/4.0.0...4.1.0

## [4.0.0]

**Check the [Migration Guide](https://github.com/Floating-Dartists/matomo-tracker#v400) to learn about breaking changes in this version**

* Contributions from [Eric Prokop](https://github.com/EPNW-Eric)
  * feat: Added a persistent dispatch queue [#97](https://github.com/Floating-Dartists/matomo-tracker/pull/97)
  * feat: Extended the newVisit capabilities [#105](https://github.com/Floating-Dartists/matomo-tracker/pull/105)
  * feat: More campaigns, path, pvId [#109](https://github.com/Floating-Dartists/matomo-tracker/pull/109)
* Contributions from [TesteurManiak](https://github.com/TesteurManiak)
  * chore: Updated `LICENSE` with major contributors [#100](https://github.com/Floating-Dartists/matomo-tracker/pull/100)
  * chore: Added a contribution guide [#101](https://github.com/Floating-Dartists/matomo-tracker/pull/101)
  * refacto: Added default values to `TrackingOrderItem` [#102](https://github.com/Floating-Dartists/matomo-tracker/pull/102)
  * refacto: Uniformized the "track" methods parameters [#106](https://github.com/Floating-Dartists/matomo-tracker/pull/106)

_Special thanks to [Eric Prokop](https://github.com/EPNW-Eric) who greatly contributed to this release._

## [4.0.0-dev.2]

**Check the [Migration Guide](https://github.com/Floating-Dartists/matomo-tracker#v400) to learn about breaking changes in this version**

* Contributions from [Eric Prokop](https://github.com/EPNW-Eric)
  * feat: Added content tracking [#86](https://github.com/Floating-Dartists/matomo-tracker/pull/86)
  * feat: Added performance tracking [#87](https://github.com/Floating-Dartists/matomo-tracker/pull/87)
  * feat: Ability to drop the dispatch queue [#89](https://github.com/Floating-Dartists/matomo-tracker/pull/89)
  * feat: Serialize `MatomoAction` immediately [#94](https://github.com/Floating-Dartists/matomo-tracker/pull/94)
  * feat: Attach the last `pvId` automatically [#96](https://github.com/Floating-Dartists/matomo-tracker/pull/96)
* Contributions from [TesteurManiak](https://github.com/TesteurManiak)
  * chore: Upgraded dependencies (Dart 3 support) [#99](https://github.com/Floating-Dartists/matomo-tracker/pull/99)

## [4.0.0-dev.1]

**Check the [Migration Guide](https://github.com/Floating-Dartists/matomo-tracker#v400) to learn about breaking changes in this version**

* Contributions from [Eric Prokop](https://github.com/EPNW-Eric)
  * feat: Improved documentation and added verification on dimension keys [#63](https://github.com/Floating-Dartists/matomo-tracker/pull/63)
  * feat: Ping logic to measure accurately the time spent on the last page [#79](https://github.com/Floating-Dartists/matomo-tracker/pull/79)
  * feat: New app launches start a new visit [#77](https://github.com/Floating-Dartists/matomo-tracker/pull/77)
  * feat: Reentry logic to detect a pop navigation on a previous page [#74](https://github.com/Floating-Dartists/matomo-tracker/pull/74)
  * feat: Added a `Campaign` object to manage campaign tracking [#72](https://github.com/Floating-Dartists/matomo-tracker/pull/72) 
* Contributions from [TesteurManiak](https://github.com/TesteurManiak)
  * fix: Added test cases for dimension key validation [#67](https://github.com/Floating-Dartists/matomo-tracker/pull/67)
  * fix: URLs have double slashs in the dashboard [#81](https://github.com/Floating-Dartists/matomo-tracker/pull/81)
  * feat: Added an `EventInfo` class to manage accurately additional data send with an event, added support for custom dimensions to `TraceableMixin` and `TraceableWidget` [#68](https://github.com/Floating-Dartists/matomo-tracker/pull/68)

## [3.1.0]

* Contributions from [Eric Prokop](https://github.com/EPNW-Eric)
  * feat: Allow to set custom http headers [#59](https://github.com/Floating-Dartists/matomo-tracker/pull/59)
* Contributions from [TesteurManiak](https://github.com/TesteurManiak)
  * fix: Added custom headers to `sendBatch` and added test cases [#60](https://github.com/Floating-Dartists/matomo-tracker/pull/60)

## [3.0.0]

**Check the [Migration Guide](https://github.com/Floating-Dartists/matomo-tracker#v300) section to learn about breaking changes in this version.**

* Contributions from [TesteurManiak](https://github.com/TesteurManiak)
  * Added [cookieless tracking](https://github.com/Floating-Dartists/matomo-tracker#cookieless-tracking)
  * Keep failed event request in queue (offline tracking) [#51](https://github.com/Floating-Dartists/matomo-tracker/issues/51) 
  * You can now make your own `LocalStorage` implementation
  * Added a `verbosityLevel` flag to manage the logged messages

## [2.0.0]

* **Breaking Change**: Removed `name` and `widgetName` arguments from `trackEvent` method
* Contributions from [Chris Tomlinson](https://github.com/luckyrat)
  * fix: Problem with visitor id [#26](https://github.com/Floating-Dartists/matomo-tracker/issues/26)
  * fix: PII in the user agent string can cause tracking failure [#39](https://github.com/Floating-Dartists/matomo-tracker/issues/39)
* Contribution from [Johann Schramm](https://github.com/JohannSchramm)
  * fix: queue in matomo.dart breaks tracking [#33](https://github.com/Floating-Dartists/matomo-tracker/issues/33)
* Contribution from [Scolnet](https://github.com/scolnet)
  * Add pause and resume capabilities
* Contribution from [Pierre Monier](https://github.com/Pierre-Monier)
  * Added tests and code coverage
* Bumped `device_info_plus` to `8.0.0`
* Bumped `package_info_plus` to `3.0.2`
* Bumped `uuid` to `3.0.7`

## [1.7.0]

* Bumped `device_info_plus` to `7.0.1`
* Bumped `package_info_plus` to `3.0.1`

## [1.6.0]

* Bumped Dart SDK version to `2.17.0`
* Removed [logging](https://pub.dev/packages/logging) dependency
* Removed [universal_platform](https://pub.dev/packages/universal_platform) dependency

## [1.5.0]

* Contribution from [Paula Petcu](https://github.com/Floating-Dartists/matomo-tracker/pull/21)
* Addition of a `TraceableWidget` to track `StatelessWidget`.

## [1.4.1]

* Fix [#18](https://github.com/Floating-Dartists/matomo-tracker/issues/18)

## [1.4.0]

* Fix [#16](https://github.com/Floating-Dartists/matomo-tracker/issues/16) (Contribution from [Paula Petcu](https://github.com/petcupaula))
* Updated dependency [device_info_plus](https://pub.dev/packages/device_info_plus) to version [4.1.2](https://pub.dev/packages/device_info_plus/versions/4.1.2)
* Updated dependency [http](https://pub.dev/packages/http) to version [0.13.5](https://pub.dev/packages/http/versions/0.13.5)

## [1.3.0]

* Contribution from [lsaudon](https://github.com/lsaudon)
  * Updated dependency [device_info_plus](https://pub.dev/packages/device_info_plus) to [4.0.1](https://pub.dev/packages/device_info_plus/versions/4.0.1)
  * Updated dependency `package_info_plus` to `1.4.3`
  * Fixed analysis warnings

## [1.2.1]

* Added support for Visitor's userId
  * Solves [#13](https://github.com/Floating-Dartists/matomo-tracker/issues/13) by allowing a userId coming from a third-party source (eg. Firebase) to be linked to the visitor.
  * Is accessible through the setVisitorUserId() method of the MatomoTracker instance.
  * No breaking changes.

## [1.2.0]

* Fix [#9](https://github.com/Floating-Dartists/matomo-tracker/issues/9) (Contribution from [Marvin Möltgen](https://github.com/M123-dev))
  * Deprecated `MatomoTracker.trackEvent.name` use `MatomoTracker.trackEvent.eventName` instead
  * Deprecated `MatomoTracker.trackEvent.widgetName` use `MatomoTracker.trackEvent.eventCategory` instead

## [1.1.2]

* Contributions from [Marvin Möltgen](https://github.com/M123-dev)
  * fix [#8](https://github.com/Floating-Dartists/matomo-tracker/issues/8): Send country code only in combination with auth_token

## [1.1.1]

* Contributions from [Marvin Möltgen](https://github.com/M123-dev)
  * fix: Now exporting the `Visitor` class [#6](https://github.com/Floating-Dartists/matomo-tracker/pull/6)

## [1.1.0]

* Contributions from [Marvin Möltgen](https://github.com/M123-dev)
    * feat: Allow to see the opt out status [#5](https://github.com/Floating-Dartists/matomo-tracker/pull/5)
    * feat: Allow tracking of outlinks [#4](https://github.com/Floating-Dartists/matomo-tracker/pull/4)
    * feat: Send country code [#2](https://github.com/Floating-Dartists/matomo-tracker/pull/2)
    * feat: Allow search tracking [#3](https://github.com/Floating-Dartists/matomo-tracker/pull/3)

## [1.0.3+1]

* Updated README with new logo and link to Matomo Integrations page

## [1.0.3]

* Added `path` property to `TraceableClientMixin`
* Improved documentation

## [1.0.2]

* Fixed default `TraceableClientMixin.widgetId`, now `null` and you will have to set it manually with a length of 6 characters
* Migrated example app to null-safety

## [1.0.1+2]

* Fixed README.md typo
* Improved documentation

## [1.0.1+1]

* Updated README with pub version & Matomo Tracking documentation link

## [1.0.1]

* Fixed `visitorId` not being set for future visits

## [1.0.0]

* Initial release of matomo-tracker
