import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the Russian language
/// locale.
class RuCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `ru` locale.
  RuCountriesL10N() {
    map.addAll({
      "ABW": "Аруба",
      "ABW+": "Аруба",
      "AFG": "Афганистан",
      "AFG+": "Исламская Республика Афганистан",
      "AGO": "Ангола",
      "AGO+": "Республика Ангола",
      "AIA": "Ангилья",
      "AIA+": "Ангилья",
      "ALA": "Аландские острова",
      "ALA+": "Аландские острова",
      "ALB": "Албания",
      "ALB+": "Республика Албания",
      "AND": "Андорра",
      "AND+": "Княжество Андорра",
      "ARE": "Объединённые Арабские Эмираты",
      "ARE+": "Объединенные Арабские Эмираты",
      "ARG": "Аргентина",
      "ARG+": "Аргентинская Республика",
      "ARM": "Армения",
      "ARM+": "Республика Армения",
      "ASM": "Американское Самоа",
      "ASM+": "американское Самоа",
      "ATA": "Антарктида",
      "ATA+": "Антарктида",
      "ATF": "Французские Южные и Антарктические территории",
      "ATF+": "Территория Французские Южные и Антарктические земли",
      "ATG": "Антигуа и Барбуда",
      "ATG+": "Антигуа и Барбуда",
      "AUS": "Австралия",
      "AUS+": "Содружество Австралии",
      "AUT": "Австрия",
      "AUT+": "Австрийская Республика",
      "AZE": "Азербайджан",
      "AZE+": "Азербайджанская Республика",
      "BDI": "Бурунди",
      "BDI+": "Республика Бурунди",
      "BEL": "Бельгия",
      "BEL+": "Королевство Бельгия",
      "BEN": "Бенин",
      "BEN+": "Республика Бенин",
      "BES": "Карибские Нидерланды",
      "BES+": "Бонэйр, Синт-Эстатиус и Саба",
      "BFA": "Буркина-Фасо",
      "BFA+": "Буркина -Фасо",
      "BGD": "Бангладеш",
      "BGD+": "Народная Республика Бангладеш",
      "BGR": "Болгария",
      "BGR+": "Республика Болгария",
      "BHR": "Бахрейн",
      "BHR+": "Королевство Бахрейн",
      "BHS": "Багамские Острова",
      "BHS+": "Содружество Багамских Островов",
      "BIH": "Босния и Герцеговина",
      "BIH+": "Босния и Герцеговина",
      "BLM": "Сен-Бартелеми",
      "BLM+": "Коллективность Санкт -Бартельми",
      "BLR": "Беларусь",
      "BLR+": "Республика Беларусь",
      "BLZ": "Белиз",
      "BLZ+": "Белиз",
      "BMU": "Бермудские Острова",
      "BMU+": "Бермудские острова",
      "BOL": "Боливия",
      "BOL+": "Многонациональное Государство Боливия",
      "BRA": "Бразилия",
      "BRA+": "Федеративная Республика Бразилия",
      "BRB": "Барбадос",
      "BRB+": "Барбадос",
      "BRN": "Бруней",
      "BRN+": "Нация Бруней, обитель мира",
      "BTN": "Бутан",
      "BTN+": "Королевство Бутан",
      "BVT": "Остров Буве",
      "BVT+": "Остров Буве",
      "BWA": "Ботсвана",
      "BWA+": "Республика Ботсвана",
      "CAF": "Центральноафриканская Республика",
      "CAF+": "Центрально-Африканская Республика",
      "CAN": "Канада",
      "CAN+": "Канада",
      "CCK": "Кокосовые острова",
      "CCK+": "Территория Кокосовые (Килинг) острова",
      "CHE": "Швейцария",
      "CHE+": "Швейцарская Конфедерация",
      "CHL": "Чили",
      "CHL+": "Республика Чили",
      "CHN": "Китай",
      "CHN+": "Народная Республика Китай",
      "CIV": "Кот-д’Ивуар",
      "CIV+": "Республика Кот-д'Ивуаре",
      "CMR": "Камерун",
      "CMR+": "Республика Камерун",
      "COD": "Демократическая Республика Конго",
      "COD+": "Демократическая Республика Конго",
      "COG": "Республика Конго",
      "COG+": "Республика Конго",
      "COK": "Острова Кука",
      "COK+": "острова Кука",
      "COL": "Колумбия",
      "COL+": "Республика Колумбия",
      "COM": "Коморы",
      "COM+": "Союз Коморских Островов",
      "CPV": "Кабо-Верде",
      "CPV+": "Республика Кабо -Верде",
      "CRI": "Коста-Рика",
      "CRI+": "Республика Коста-Рика",
      "CUB": "Куба",
      "CUB+": "Республика Куба",
      "CUW": "Кюрасао",
      "CUW+": "Страна Кюрасао",
      "CXR": "Остров Рождества",
      "CXR+": "Территория острова Рождества",
      "CYM": "Каймановы острова",
      "CYM+": "Каймановы острова",
      "CYP": "Кипр",
      "CYP+": "Республика Кипр",
      "CZE": "Чехия",
      "CZE+": "Чешская Республика",
      "DEU": "Германия",
      "DEU+": "Федеративная Республика Германия",
      "DJI": "Джибути",
      "DJI+": "Республика Джибути",
      "DMA": "Доминика",
      "DMA+": "Содружество Доминики",
      "DNK": "Дания",
      "DNK+": "Королевство Дания",
      "DOM": "Доминиканская Республика",
      "DOM+": "Доминиканская Республика",
      "DZA": "Алжир",
      "DZA+": "Народно-Демократическая Республика Алжир",
      "ECU": "Эквадор",
      "ECU+": "Республика Эквадор",
      "EGY": "Египет",
      "EGY+": "Арабская Республика Египет",
      "ERI": "Эритрея",
      "ERI+": "Государство Эритрея",
      "ESH": "Западная Сахара",
      "ESH+": "Сахарская Арабская Демократическая Республика",
      "ESP": "Испания",
      "ESP+": "Королевство Испания",
      "EST": "Эстония",
      "EST+": "Эстонская Республика",
      "ETH": "Эфиопия",
      "ETH+": "Федеративная Демократическая Республика Эфиопия",
      "FIN": "Финляндия",
      "FIN+": "Финляндская Республика",
      "FJI": "Фиджи",
      "FJI+": "Республика Фиджи",
      "FLK": "Фолклендские острова",
      "FLK+": "Фолклендские острова",
      "FRA": "Франция",
      "FRA+": "Французская Республика",
      "FRO": "Фарерские острова",
      "FRO+": "Фарерские острова",
      "FSM": "Федеративные Штаты Микронезии",
      "FSM+": "Федеративные Штаты Микронезии",
      "GAB": "Габон",
      "GAB+": "Габона Республика",
      "GBR": "Великобритания",
      "GBR+": "Соединенное Королевство Великобритании и Северной Ирландии",
      "GEO": "Грузия",
      "GEO+": "Грузия",
      "GGY": "Гернси",
      "GGY+": "Коронное владение Гернси",
      "GHA": "Гана",
      "GHA+": "Республика Гана",
      "GIB": "Гибралтар",
      "GIB+": "Гибралтар",
      "GIN": "Гвинея",
      "GIN+": "Республика Гвинея",
      "GLP": "Гваделупа",
      "GLP+": "Гваделупа",
      "GMB": "Гамбия",
      "GMB+": "Республика Гамбия",
      "GNB": "Гвинея-Бисау",
      "GNB+": "Республика Гвинея -Бисау",
      "GNQ": "Экваториальная Гвинея",
      "GNQ+": "Республика Экваториальная Гвинея",
      "GRC": "Греция",
      "GRC+": "Греческая Республика",
      "GRD": "Гренада",
      "GRD+": "Гренада",
      "GRL": "Гренландия",
      "GRL+": "Гренландия",
      "GTM": "Гватемала",
      "GTM+": "Республика Гватемала",
      "GUF": "Французская Гвиана",
      "GUF+": "Гвиана",
      "GUM": "Гуам",
      "GUM+": "Гуам",
      "GUY": "Гайана",
      "GUY+": "Кооперативная Республика Гайана",
      "HKG": "Гонконг",
      "HKG+":
          """Hong Kong Специальный административный район Китайской Народной Республики Китая""",
      "HMD": "Остров Херд и острова Макдональд",
      "HMD+": "Остров Херд и острова Макдональд",
      "HND": "Гондурас",
      "HND+": "Республика Гондурас",
      "HRV": "Хорватия",
      "HRV+": "Республика Хорватия",
      "HTI": "Гаити",
      "HTI+": "Республика Гаити",
      "HUN": "Венгрия",
      "HUN+": "Венгрия",
      "IDN": "Индонезия",
      "IDN+": "Республика Индонезия",
      "IMN": "Остров Мэн",
      "IMN+": "Остров Мэн",
      "IND": "Индия",
      "IND+": "Республика Индия",
      "IOT": "Британская территория в Индийском океане",
      "IOT+": "Британская территория Индийского океана",
      "IRL": "Ирландия",
      "IRL+": "Ирландия",
      "IRN": "Иран",
      "IRN+": "Исламская Республика Иран",
      "IRQ": "Ирак",
      "IRQ+": "Республика Ирак",
      "ISL": "Исландия",
      "ISL+": "Исландия",
      "ISR": "Израиль",
      "ISR+": "Государство Израиль",
      "ITA": "Италия",
      "ITA+": "итальянская Республика",
      "JAM": "Ямайка",
      "JAM+": "Ямайка",
      "JEY": "Джерси",
      "JEY+": "Коронное владение Джерси",
      "JOR": "Иордания",
      "JOR+": "Иорданского Хашимитского Королевства",
      "JPN": "Япония",
      "JPN+": "Япония",
      "KAZ": "Казахстан",
      "KAZ+": "Республика Казахстан",
      "KEN": "Кения",
      "KEN+": "Республика Кения",
      "KGZ": "Киргизия",
      "KGZ+": "Кыргызская Республика",
      "KHM": "Камбоджа",
      "KHM+": "Королевство Камбоджа",
      "KIR": "Кирибати",
      "KIR+": "Независимой и суверенной Республики Кирибати",
      "KNA": "Сент-Китс и Невис",
      "KNA+": "Федерация Сент-Кристофер и Н е в и с",
      "KOR": "Южная Корея",
      "KOR+": "Республика Корея",
      "KWT": "Кувейт",
      "KWT+": "Государство Кувейт",
      "LAO": "Лаос",
      "LAO+": "Лаосская Народно-Демократическая Республика",
      "LBN": "Ливан",
      "LBN+": "Ливанская Республика",
      "LBR": "Либерия",
      "LBR+": "Республика Либерия",
      "LBY": "Ливия",
      "LBY+": "Государство Ливии",
      "LCA": "Сент-Люсия",
      "LCA+": "Сент-Люсия",
      "LIE": "Лихтенштейн",
      "LIE+": "Княжество Лихтенштейн",
      "LKA": "Шри-Ланка",
      "LKA+": "Демократическая Социалистическая Республика Шри-Ланка",
      "LSO": "Лесото",
      "LSO+": "Королевство Лесото",
      "LTU": "Литва",
      "LTU+": "Литовская Республика",
      "LUX": "Люксембург",
      "LUX+": "Великое Герцогство Люксембург",
      "LVA": "Латвия",
      "LVA+": "Латвийская Республика",
      "MAC": "Макао",
      "MAC+":
          """Специальный административный район Макао Китайской Народной Республики Китай""",
      "MAF": "Сен-Мартен",
      "MAF+": "Сен-Мартен",
      "MAR": "Марокко",
      "MAR+": "Королевство Марокко",
      "MCO": "Монако",
      "MCO+": "Княжество Монако",
      "MDA": "Молдавия",
      "MDA+": "Молдова",
      "MDG": "Мадагаскар",
      "MDG+": "Республика Мадагаскар",
      "MDV": "Мальдивы",
      "MDV+": "Республика Мальдивы",
      "MEX": "Мексика",
      "MEX+": "Мексиканские Соединённые Штаты",
      "MHL": "Маршалловы Острова",
      "MHL+": "Республика Маршалловы острова",
      "MKD": "Северная Македония",
      "MKD+": "Республика Северная Македония",
      "MLI": "Мали",
      "MLI+": "Республика Мали",
      "MLT": "Мальта",
      "MLT+": "Республика Мальта",
      "MMR": "Мьянма",
      "MMR+": "Республика Союза Мьянма",
      "MNE": "Черногория",
      "MNE+": "Черногория",
      "MNG": "Монголия",
      "MNG+": "Монголия",
      "MNP": "Северные Марианские острова",
      "MNP+": "Содружество Северных Марианских островов",
      "MOZ": "Мозамбик",
      "MOZ+": "Республика Мозамбик",
      "MRT": "Мавритания",
      "MRT+": "Исламская Республика Мавритания",
      "MSR": "Монтсеррат",
      "MSR+": "Монтсеррат",
      "MTQ": "Мартиника",
      "MTQ+": "Мартиника",
      "MUS": "Маврикий",
      "MUS+": "Республика Маврикий",
      "MWI": "Малави",
      "MWI+": "Республика Малави",
      "MYS": "Малайзия",
      "MYS+": "Малайзия",
      "MYT": "Майотта",
      "MYT+": "Департамент Майотта",
      "NAM": "Намибия",
      "NAM+": "Республика Намибия",
      "NCL": "Новая Каледония",
      "NCL+": "Новая Каледония",
      "NER": "Нигер",
      "NER+": "Республика Нигер",
      "NFK": "Норфолк",
      "NFK+": "Территория острова Норфолк",
      "NGA": "Нигерия",
      "NGA+": "Федеративная Республика Нигерия",
      "NIC": "Никарагуа",
      "NIC+": "Республика Никарагуа",
      "NIU": "Ниуэ",
      "NIU+": "Ниуэ",
      "NLD": "Нидерланды",
      "NLD+": "Нидерланды",
      "NOR": "Норвегия",
      "NOR+": "Королевство Норвегия",
      "NPL": "Непал",
      "NPL+": "Федеративная Демократическая Республика Непал",
      "NRU": "Науру",
      "NRU+": "Республика Науру",
      "NZL": "Новая Зеландия",
      "NZL+": "Новая Зеландия",
      "OMN": "Оман",
      "OMN+": "Султанат Оман",
      "PAK": "Пакистан",
      "PAK+": "Исламская Республика Пакистан",
      "PAN": "Панама",
      "PAN+": "Республика Панама",
      "PCN": "Острова Питкэрн",
      "PCN+": "Питкэрн группа островов",
      "PER": "Перу",
      "PER+": "Республика Перу",
      "PHL": "Филиппины",
      "PHL+": "Республика Филиппины",
      "PLW": "Палау",
      "PLW+": "Республика Палау",
      "PNG": "Папуа — Новая Гвинея",
      "PNG+": "Независимое Государство Папуа-Новой Гвинеи",
      "POL": "Польша",
      "POL+": "Республика Польша",
      "PRI": "Пуэрто-Рико",
      "PRI+": "Содружество Пуэрто-Рико",
      "PRK": "Северная Корея",
      "PRK+": "Корейская Народно-Демократическая Республика Корея",
      "PRT": "Португалия",
      "PRT+": "Португальская Республика",
      "PRY": "Парагвай",
      "PRY+": "Республика Парагвай",
      "PSE": "Палестина",
      "PSE+": "Государство Палестина",
      "PYF": "Французская Полинезия",
      "PYF+": "Французская Полинезия",
      "QAT": "Катар",
      "QAT+": "Государство Катар",
      "REU": "Реюньон",
      "REU+": "Реюньон",
      "ROU": "Румыния",
      "ROU+": "Румыния",
      "RUS": "Россия",
      "RUS+": "Российская Федерация",
      "RWA": "Руанда",
      "RWA+": "Республика Руанда",
      "SAU": "Саудовская Аравия",
      "SAU+": "Королевство Саудовская Аравия",
      "SDN": "Судан",
      "SDN+": "Республика Судан",
      "SEN": "Сенегал",
      "SEN+": "Республика Сенегал",
      "SGP": "Сингапур",
      "SGP+": "Республика Сингапур",
      "SGS": "Южная Георгия и Южные Сандвичевы острова",
      "SGS+": "Южная Георгия и Южные Сандвичевы острова",
      "SHN": "Острова Святой Елены, Вознесения и Тристан-да-Кунья",
      "SHN+": "Острова Святой Елены, Вознесения и Тристан-да-Кунья",
      "SJM": "Шпицберген и Ян-Майен",
      "SJM+": "Свальбарда ог Ян-Майен",
      "SLB": "Соломоновы Острова",
      "SLB+": "Соломоновы острова",
      "SLE": "Сьерра-Леоне",
      "SLE+": "Республика Сьерра-Леоне",
      "SLV": "Сальвадор",
      "SLV+": "Республика Эль-Сальвадор",
      "SMR": "Сан-Марино",
      "SMR+": "Большинство Serene Республика Сан-Марино",
      "SOM": "Сомали",
      "SOM+": "Федеративная Республика Сомали",
      "SPM": "Сен-Пьер и Микелон",
      "SPM+": "Сен-Пьер и Микелон",
      "SRB": "Сербия",
      "SRB+": "Республика Сербия",
      "SSD": "Южный Судан",
      "SSD+": "Республика Южный Судан",
      "STP": "Сан-Томе и Принсипи",
      "STP+": "Демократическая Республика Сан-Томе и Принсипи",
      "SUR": "Суринам",
      "SUR+": "Республика Суринам",
      "SVK": "Словакия",
      "SVK+": "Словацкая Республика",
      "SVN": "Словения",
      "SVN+": "Республика Словения",
      "SWE": "Швеция",
      "SWE+": "Королевство Швеция",
      "SWZ": "Свазиленд",
      "SWZ+": "Королевство Свазиленд",
      "SXM": "Синт-Мартен",
      "SXM+": "Синт-Маартен",
      "SYC": "Сейшельские Острова",
      "SYC+": "Республика Сейшельские Острова",
      "SYR": "Сирия",
      "SYR+": "Сирийская Арабская Республика",
      "TCA": "Теркс и Кайкос",
      "TCA+": "Теркс и Кайкос острова",
      "TCD": "Чад",
      "TCD+": "Республика Чад",
      "TGO": "Того",
      "TGO+": "Того Республика",
      "THA": "Таиланд",
      "THA+": "Королевство Таиланд",
      "TJK": "Таджикистан",
      "TJK+": "Республика Таджикистан",
      "TKL": "Токелау",
      "TKL+": "Токелау",
      "TKM": "Туркмения",
      "TKM+": "Туркменистан",
      "TLS": "Восточный Тимор",
      "TLS+": "Демократическая Республика Тимор -Лешти",
      "TON": "Тонга",
      "TON+": "Королевство Тонга",
      "TTO": "Тринидад и Тобаго",
      "TTO+": "Республика Тринидад и Тобаго",
      "TUN": "Тунис",
      "TUN+": "Тунисской Республики",
      "TUR": "Турция",
      "TUR+": "Республика Турции",
      "TUV": "Тувалу",
      "TUV+": "Тувалу",
      "TWN": "Тайвань",
      "TWN+": "Китайская Республика",
      "TZA": "Танзания",
      "TZA+": "Объединенная Республика Танзания",
      "UGA": "Уганда",
      "UGA+": "Республика Уганда",
      "UKR": "Украина",
      "UKR+": "Украина",
      "UMI": "Внешние малые острова США",
      "UMI+": "Внешние малые острова США",
      "UNK": "Республика Косово",
      "UNK+": "Республика Косово",
      "URY": "Уругвай",
      "URY+": "Восточной Республики Уругвай",
      "USA": "Соединённые Штаты Америки",
      "USA+": "Соединенные Штаты Америки",
      "UZB": "Узбекистан",
      "UZB+": "Республика Узбекистан",
      "VAT": "Ватикан",
      "VAT+": "Город-государство Ватикан",
      "VCT": "Сент-Винсент и Гренадины",
      "VCT+": "Сент-Винсент и Гренадины",
      "VEN": "Венесуэла",
      "VEN+": "Боливарианская Республика Венесуэла",
      "VGB": "Британские Виргинские острова",
      "VGB+": "Виргинские острова",
      "VIR": "Виргинские Острова",
      "VIR+": "Виргинские острова Соединенных Штатов",
      "VNM": "Вьетнам",
      "VNM+": "Социалистическая Республика Вьетнам",
      "VUT": "Вануату",
      "VUT+": "Республика Вануату",
      "WLF": "Уоллис и Футуна",
      "WLF+": "Территория Уоллис и Футуна острова",
      "WSM": "Самоа",
      "WSM+": "Независимое Государство Самоа",
      "YEM": "Йемен",
      "YEM+": "Йеменская Республика",
      "ZAF": "Южная Африка",
      "ZAF+": "Южно-Африканская Республика",
      "ZMB": "Замбия",
      "ZMB+": "Республика Замбия",
      "ZWE": "Зимбабве",
      "ZWE+": "Республика Зимбабве",
    });
  }
}
