import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the Dutch language
/// locale.
class NlCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `nl` locale.
  NlCountriesL10N() {
    map.addAll({
      "ABW": "Aruba",
      "ABW+": "Aruba",
      "AFG": "Afghanistan",
      "AFG+": "Islamitische Republiek Afghanistan",
      "AGO": "Angola",
      "AGO+": "Republiek Angola",
      "AIA": "Anguilla",
      "AIA+": "Anguilla",
      "ALA": "Ålandeilanden",
      "ALA+": "Åland eilanden",
      "ALB": "Albanië",
      "ALB+": "Republiek Albanië",
      "AND": "Andorra",
      "AND+": "Prinsdom Andorra",
      "ARE": "Verenigde Arabische Emiraten",
      "ARE+": "Verenigde Arabische Emiraten",
      "ARG": "Argentinië",
      "ARG+": "Argentijnse Republiek",
      "ARM": "Armenië",
      "ARM+": "Republiek Armenië",
      "ASM": "Amerikaans Samoa",
      "ASM+": "Amerikaans Samoa",
      "ATA": "Antarctica",
      "ATA+": "Antarctica",
      "ATF": "Franse Gebieden in de zuidelijke Indische Oceaan",
      "ATF+": "Grondgebied van de Franse Zuidelijke en Antarctische gebieden",
      "ATG": "Antigua en Barbuda",
      "ATG+": "Antigua en Barbuda",
      "AUS": "Australië",
      "AUS+": "Gemenebest van Australië",
      "AUT": "Oostenrijk",
      "AUT+": "Republiek Oostenrijk",
      "AZE": "Azerbeidzjan",
      "AZE+": "Republiek Azerbeidzjan",
      "BDI": "Burundi",
      "BDI+": "Republiek Burundi",
      "BEL": "België",
      "BEL+": "Koninkrijk België",
      "BEN": "Benin",
      "BEN+": "Republiek Benin",
      "BES": "Caribisch Nederland",
      "BES+": "Bonaire, Sint Eustatius en Saba",
      "BFA": "Burkina Faso",
      "BFA+": "Burkina Faso",
      "BGD": "Bangladesh",
      "BGD+": "Volksrepubliek Bangladesh",
      "BGR": "Bulgarije",
      "BGR+": "Republiek Bulgarije",
      "BHR": "Bahrein",
      "BHR+": "Koninkrijk Bahrein",
      "BHS": "Bahama’s",
      "BHS+": "Gemenebest van de Bahama's",
      "BIH": "Bosnië en Herzegovina",
      "BIH+": "Bosnië-Herzegovina",
      "BLM": "Saint Barthélemy",
      "BLM+": "Gemeenschap Saint Barthélemy",
      "BLR": "Wit-Rusland",
      "BLR+": "Republiek Belarus",
      "BLZ": "Belize",
      "BLZ+": "Belize",
      "BMU": "Bermuda",
      "BMU+": "Bermuda",
      "BOL": "Bolivia",
      "BOL+": "Plurinationale Staat van Bolivia",
      "BRA": "Brazilië",
      "BRA+": "Federale Republiek Brazilië",
      "BRB": "Barbados",
      "BRB+": "Barbados",
      "BRN": "Brunei",
      "BRN+": "Natie van Brunei, de verblijfplaats van de Vrede",
      "BTN": "Bhutan",
      "BTN+": "Koninkrijk Bhutan",
      "BVT": "Bouveteiland",
      "BVT+": "Bouvet Island",
      "BWA": "Botswana",
      "BWA+": "Republiek Botswana",
      "CAF": "Centraal-Afrikaanse Republiek",
      "CAF+": "Centraal-Afrikaanse Republiek",
      "CAN": "Canada",
      "CAN+": "Canada",
      "CCK": "Cocoseilanden",
      "CCK+": "Grondgebied van de Eilanden Cocos (Keeling )",
      "CHE": "Zwitserland",
      "CHE+": "Zwitserse Confederatie",
      "CHL": "Chili",
      "CHL+": "Republiek Chili",
      "CHN": "China",
      "CHN+": "Volksrepubliek China",
      "CIV": "Ivoorkust",
      "CIV+": "Republiek Ivoorkust",
      "CMR": "Kameroen",
      "CMR+": "Republiek Kameroen",
      "COD": "Congo (DRC)",
      "COD+": "Democratische Republiek Congo",
      "COG": "Congo",
      "COG+": "Republiek Congo",
      "COK": "Cookeilanden",
      "COK+": "Cook eilanden",
      "COL": "Colombia",
      "COL+": "Republiek Colombia",
      "COM": "Comoren",
      "COM+": "Unie van de Comoren",
      "CPV": "Kaapverdië",
      "CPV+": "Republiek van Cabo Verde",
      "CRI": "Costa Rica",
      "CRI+": "Republiek Costa Rica",
      "CUB": "Cuba",
      "CUB+": "Republiek Cuba",
      "CUW": "Curaçao",
      "CUW+": "Land Curaçao",
      "CXR": "Christmaseiland",
      "CXR+": "Grondgebied van Christmas Island",
      "CYM": "Caymaneilanden",
      "CYM+": "Caymaneilanden",
      "CYP": "Cyprus",
      "CYP+": "Republiek Cyprus",
      "CZE": "Tsjechië",
      "CZE+": "Tsjechische Republiek",
      "DEU": "Duitsland",
      "DEU+": "Bondsrepubliek Duitsland",
      "DJI": "Djibouti",
      "DJI+": "Republiek Djibouti",
      "DMA": "Dominica",
      "DMA+": "Gemenebest Dominica",
      "DNK": "Denemarken",
      "DNK+": "Koninkrijk Denemarken",
      "DOM": "Dominicaanse Republiek",
      "DOM+": "Dominicaanse Republiek",
      "DZA": "Algerije",
      "DZA+": "Democratische Volksrepubliek Algerije",
      "ECU": "Ecuador",
      "ECU+": "Republiek Ecuador",
      "EGY": "Egypte",
      "EGY+": "Arabische Republiek Egypte",
      "ERI": "Eritrea",
      "ERI+": "Staat Eritrea",
      "ESH": "Westelijke Sahara",
      "ESH+": "Sahrawi Arabische Democratische Republiek",
      "ESP": "Spanje",
      "ESP+": "Koninkrijk Spanje",
      "EST": "Estland",
      "EST+": "Republiek Estland",
      "ETH": "Ethiopië",
      "ETH+": "Federale Democratische Republiek Ethiopië",
      "FIN": "Finland",
      "FIN+": "Republiek Finland",
      "FJI": "Fiji",
      "FJI+": "Republiek Fiji",
      "FLK": "Falklandeilanden",
      "FLK+": "Falkland eilanden",
      "FRA": "Frankrijk",
      "FRA+": "Franse Republiek",
      "FRO": "Faeröer",
      "FRO+": "Faeröer",
      "FSM": "Micronesië",
      "FSM+": "Federale Staten van Micronesia",
      "GAB": "Gabon",
      "GAB+": "Republiek Gabon",
      "GBR": "Verenigd Koninkrijk",
      "GBR+": "Verenigd Koninkrijk van Groot-Brittannië en Noord-Ierland",
      "GEO": "Georgië",
      "GEO+": "Georgia",
      "GGY": "Guernsey",
      "GGY+": "Baljuwschap Guernsey",
      "GHA": "Ghana",
      "GHA+": "Republiek Ghana",
      "GIB": "Gibraltar",
      "GIB+": "Gibraltar",
      "GIN": "Guinee",
      "GIN+": "Republiek Guinee",
      "GLP": "Guadeloupe",
      "GLP+": "Guadeloupe",
      "GMB": "Gambia",
      "GMB+": "Republiek Gambia",
      "GNB": "Guinee-Bissau",
      "GNB+": "Republiek Guinee-Bissau",
      "GNQ": "Equatoriaal-Guinea",
      "GNQ+": "Republiek Equatoriaal-Guinea",
      "GRC": "Griekenland",
      "GRC+": "Helleense Republiek",
      "GRD": "Grenada",
      "GRD+": "Grenada",
      "GRL": "Groenland",
      "GRL+": "Groenland",
      "GTM": "Guatemala",
      "GTM+": "Republiek Guatemala",
      "GUF": "Frans-Guyana",
      "GUF+": "Guyana",
      "GUM": "Guam",
      "GUM+": "Guam",
      "GUY": "Guyana",
      "GUY+": "Coöperatieve Republiek Guyana",
      "HKG": "Hongkong",
      "HKG+":
          """Hong Kong Speciale Administratieve Regio van de Volksrepubliek China""",
      "HMD": "Heard-en McDonaldeilanden",
      "HMD+": "Heard en McDonaldeilanden",
      "HND": "Honduras",
      "HND+": "Republiek Honduras",
      "HRV": "Kroatië",
      "HRV+": "Republiek Kroatië",
      "HTI": "Haïti",
      "HTI+": "Republiek Haïti",
      "HUN": "Hongarije",
      "HUN+": "Hongarije",
      "IDN": "Indonesië",
      "IDN+": "Republiek Indonesië",
      "IMN": "Isle of Man",
      "IMN+": "Isle of Man",
      "IND": "India",
      "IND+": "Republiek India",
      "IOT": "Britse Gebieden in de Indische Oceaan",
      "IOT+": "Brits Indische Oceaan Territorium",
      "IRL": "Ierland",
      "IRL+": "Republic of Ireland",
      "IRN": "Iran",
      "IRN+": "Islamitische Republiek Iran",
      "IRQ": "Irak",
      "IRQ+": "Republiek Irak",
      "ISL": "IJsland",
      "ISL+": "IJsland",
      "ISR": "Israël",
      "ISR+": "Staat Israël",
      "ITA": "Italië",
      "ITA+": "Italiaanse Republiek",
      "JAM": "Jamaica",
      "JAM+": "Jamaica",
      "JEY": "Jersey",
      "JEY+": "Baljuwschap Jersey",
      "JOR": "Jordanië",
      "JOR+": "Hasjemitisch Koninkrijk Jordanië",
      "JPN": "Japan",
      "JPN+": "Japan",
      "KAZ": "Kazachstan",
      "KAZ+": "Republiek Kazachstan",
      "KEN": "Kenia",
      "KEN+": "Republiek Kenia",
      "KGZ": "Kirgizië",
      "KGZ+": "Kirgizische Republiek",
      "KHM": "Cambodja",
      "KHM+": "Koninkrijk Cambodja",
      "KIR": "Kiribati",
      "KIR+": "Onafhankelijke en soevereine republiek Kiribati",
      "KNA": "Saint Kitts en Nevis",
      "KNA+": "Federatie van Saint Kitts en Nevis",
      "KOR": "Zuid-Korea",
      "KOR+": "Republiek Korea",
      "KWT": "Koeweit",
      "KWT+": "Staat Koeweit",
      "LAO": "Laos",
      "LAO+": "Lao Democratische Volksrepubliek",
      "LBN": "Libanon",
      "LBN+": "Libanese Republiek",
      "LBR": "Liberia",
      "LBR+": "Republiek Liberia",
      "LBY": "Libië",
      "LBY+": "Staat van Libië",
      "LCA": "Saint Lucia",
      "LCA+": "Saint Lucia",
      "LIE": "Liechtenstein",
      "LIE+": "Vorstendom Liechtenstein",
      "LKA": "Sri Lanka",
      "LKA+": "Democratische Socialistische Republiek Sri Lanka",
      "LSO": "Lesotho",
      "LSO+": "Koninkrijk Lesotho",
      "LTU": "Litouwen",
      "LTU+": "Republiek Litouwen",
      "LUX": "Luxemburg",
      "LUX+": "Groothertogdom Luxemburg",
      "LVA": "Letland",
      "LVA+": "Republiek Letland",
      "MAC": "Macao",
      "MAC+":
          "Speciale Administratieve Regio Macau van de Volksrepubliek China",
      "MAF": "Saint-Martin",
      "MAF+": "Saint Martin",
      "MAR": "Marokko",
      "MAR+": "Koninkrijk Marokko",
      "MCO": "Monaco",
      "MCO+": "Vorstendom Monaco",
      "MDA": "Moldavië",
      "MDA+": "Republiek Moldavië",
      "MDG": "Madagaskar",
      "MDG+": "Republiek Madagaskar",
      "MDV": "Maldiven",
      "MDV+": "Republiek van de Malediven",
      "MEX": "Mexico",
      "MEX+": "Verenigde Mexicaanse Staten",
      "MHL": "Marshalleilanden",
      "MHL+": "Republiek van de Marshall-eilanden",
      "MKD": "Noord-Macedonië",
      "MKD+": "Republiek Noord-Macedonië",
      "MLI": "Mali",
      "MLI+": "Republiek Mali",
      "MLT": "Malta",
      "MLT+": "Republiek Malta",
      "MMR": "Myanmar",
      "MMR+": "Republiek van de Unie van Myanmar",
      "MNE": "Montenegro",
      "MNE+": "Montenegro",
      "MNG": "Mongolië",
      "MNG+": "Mongolië",
      "MNP": "Noordelijke Marianeneilanden",
      "MNP+": "Commonwealth van de Noordelijke Marianen",
      "MOZ": "Mozambique",
      "MOZ+": "Republiek Mozambique",
      "MRT": "Mauritanië",
      "MRT+": "Islamitische Republiek Mauritanië",
      "MSR": "Montserrat",
      "MSR+": "Montserrat",
      "MTQ": "Martinique",
      "MTQ+": "Martinique",
      "MUS": "Mauritius",
      "MUS+": "Republiek Mauritius",
      "MWI": "Malawi",
      "MWI+": "Republiek Malawi",
      "MYS": "Maleisië",
      "MYS+": "Maleisië",
      "MYT": "Mayotte",
      "MYT+": "Afdeling Mayotte",
      "NAM": "Namibië",
      "NAM+": "Republiek Namibië",
      "NCL": "Nieuw-Caledonië",
      "NCL+": "nieuw -Caledonië",
      "NER": "Niger",
      "NER+": "Republiek Niger",
      "NFK": "Norfolkeiland",
      "NFK+": "Grondgebied van Norfolk Island",
      "NGA": "Nigeria",
      "NGA+": "Federale Republiek Nigeria",
      "NIC": "Nicaragua",
      "NIC+": "Republiek Nicaragua",
      "NIU": "Niue",
      "NIU+": "Niue",
      "NLD": "Nederland",
      "NLD+": "Nederland",
      "NOR": "Noorwegen",
      "NOR+": "Koninkrijk Noorwegen",
      "NPL": "Nepal",
      "NPL+": "Federale Democratische Republiek Nepal",
      "NRU": "Nauru",
      "NRU+": "Republiek Nauru",
      "NZL": "Nieuw-Zeeland",
      "NZL+": "Nieuw Zeeland",
      "OMN": "Oman",
      "OMN+": "Sultanaat van Oman",
      "PAK": "Pakistan",
      "PAK+": "Islamitische Republiek Pakistan",
      "PAN": "Panama",
      "PAN+": "Republiek Panama",
      "PCN": "Pitcairneilanden",
      "PCN+": "Pitcairn groep eilanden",
      "PER": "Peru",
      "PER+": "Republiek Peru",
      "PHL": "Filipijnen",
      "PHL+": "Republiek der Filipijnen",
      "PLW": "Palau",
      "PLW+": "Republiek van Palau",
      "PNG": "Papoea-Nieuw-Guinea",
      "PNG+": "Onafhankelijke Staat Papoea -Nieuw-Guinea",
      "POL": "Polen",
      "POL+": "Republiek Polen",
      "PRI": "Puerto Rico",
      "PRI+": "Gemenebest van Puerto Rico",
      "PRK": "Noord-Korea",
      "PRK+": "Democratische Volksrepubliek Korea",
      "PRT": "Portugal",
      "PRT+": "Portugese Republiek",
      "PRY": "Paraguay",
      "PRY+": "Republiek Paraguay",
      "PSE": "Palestijnse gebieden",
      "PSE+": "Staat Palestina",
      "PYF": "Frans-Polynesië",
      "PYF+": "Frans-Polynesië",
      "QAT": "Qatar",
      "QAT+": "Staat Qatar",
      "REU": "Réunion",
      "REU+": "Réunion",
      "ROU": "Roemenië",
      "ROU+": "Roemenië",
      "RUS": "Rusland",
      "RUS+": "Russische Federatie",
      "RWA": "Rwanda",
      "RWA+": "Republiek Rwanda",
      "SAU": "Saoedi-Arabië",
      "SAU+": "Koninkrijk van Saoedi-Arabië",
      "SDN": "Soedan",
      "SDN+": "Republiek Soedan",
      "SEN": "Senegal",
      "SEN+": "Republiek Senegal",
      "SGP": "Singapore",
      "SGP+": "Republiek Singapore",
      "SGS": "Zuid-Georgia en Zuidelijke Sandwicheilanden",
      "SGS+": "Zuid-Georgië en de Zuidelijke Sandwich-eilanden",
      "SHN": "Sint-Helena, Ascension en Tristan da Cunha",
      "SHN+": "Sint-Helena, Ascension en Tristan da Cunha",
      "SJM": "Svalbard en Jan Mayen",
      "SJM+": "Svalbard og Jan Mayen",
      "SLB": "Salomonseilanden",
      "SLB+": "Solomon eilanden",
      "SLE": "Sierra Leone",
      "SLE+": "Republiek Sierra Leone",
      "SLV": "El Salvador",
      "SLV+": "Republiek El Salvador",
      "SMR": "San Marino",
      "SMR+": "Meest Serene Republiek San Marino",
      "SOM": "Somalië",
      "SOM+": "Federale Republiek Somalië",
      "SPM": "Saint Pierre en Miquelon",
      "SPM+": "Saint-Pierre en Miquelon",
      "SRB": "Servië",
      "SRB+": "Republiek Servië",
      "SSD": "Zuid-Soedan",
      "SSD+": "Republiek Zuid-Soedan",
      "STP": "Sao Tomé en Principe",
      "STP+": "Democratische Republiek Sao Tomé en Principe",
      "SUR": "Suriname",
      "SUR+": "Republiek Suriname",
      "SVK": "Slowakije",
      "SVK+": "Slowaakse Republiek",
      "SVN": "Slovenië",
      "SVN+": "Republiek Slovenië",
      "SWE": "Zweden",
      "SWE+": "Koninkrijk Zweden",
      "SWZ": "Swaziland",
      "SWZ+": "Koninkrijk eSwatini",
      "SXM": "Sint Maarten",
      "SXM+": "Sint Maarten",
      "SYC": "Seychellen",
      "SYC+": "Republiek der Seychellen",
      "SYR": "Syrië",
      "SYR+": "Syrische Arabische Republiek",
      "TCA": "Turks-en Caicoseilanden",
      "TCA+": "Turks-en Caicoseilanden",
      "TCD": "Tsjaad",
      "TCD+": "Republiek Tsjaad",
      "TGO": "Togo",
      "TGO+": "Republiek Togo",
      "THA": "Thailand",
      "THA+": "Koninkrijk Thailand",
      "TJK": "Tadzjikistan",
      "TJK+": "Tadzjikistan",
      "TKL": "Tokelau",
      "TKL+": "Tokelau",
      "TKM": "Turkmenistan",
      "TKM+": "Turkmenistan",
      "TLS": "Oost-Timor",
      "TLS+": "Democratische Republiek Oost-Timor",
      "TON": "Tonga",
      "TON+": "Koninkrijk Tonga",
      "TTO": "Trinidad en Tobago",
      "TTO+": "Republiek Trinidad en Tobago",
      "TUN": "Tunesië",
      "TUN+": "Republiek Tunesië",
      "TUR": "Turkije",
      "TUR+": "Republiek Turkije",
      "TUV": "Tuvalu",
      "TUV+": "Tuvalu",
      "TWN": "Taiwan",
      "TWN+": "Republiek China (Taiwan)",
      "TZA": "Tanzania",
      "TZA+": "Verenigde Republiek Tanzania",
      "UGA": "Oeganda",
      "UGA+": "Republiek Uganda",
      "UKR": "Oekraïne",
      "UKR+": "Oekraïne",
      "UMI": "Kleine afgelegen eilanden van de Verenigde Staten",
      "UMI+": "Kleine afgelegen eilanden van de Verenigde Staten",
      "UNK": "Kosovo",
      "UNK+": "Republiek Kosovo",
      "URY": "Uruguay",
      "URY+": "Oosterse Republiek Uruguay",
      "USA": "Verenigde Staten",
      "USA+": "Verenigde Staten van Amerika",
      "UZB": "Oezbekistan",
      "UZB+": "Republiek Oezbekistan",
      "VAT": "Vaticaanstad",
      "VAT+": "Vaticaanstad",
      "VCT": "Saint Vincent en de Grenadines",
      "VCT+": "Saint Vincent en de Grenadines",
      "VEN": "Venezuela",
      "VEN+": "Bolivariaanse Republiek Venezuela",
      "VGB": "Britse Maagdeneilanden",
      "VGB+": "Maagdeneilanden",
      "VIR": "Amerikaanse Maagdeneilanden",
      "VIR+": "Maagdeneilanden van de Verenigde Staten",
      "VNM": "Vietnam",
      "VNM+": "Socialistische Republiek Vietnam",
      "VUT": "Vanuatu",
      "VUT+": "Republiek Vanuatu",
      "WLF": "Wallis en Futuna",
      "WLF+": "Grondgebied van de Wallis en Futuna",
      "WSM": "Samoa",
      "WSM+": "Onafhankelijke Staat Samoa",
      "YEM": "Jemen",
      "YEM+": "Republiek Jemen",
      "ZAF": "Zuid-Afrika",
      "ZAF+": "Republiek Zuid-Afrika",
      "ZMB": "Zambia",
      "ZMB+": "Republiek Zambia",
      "ZWE": "Zimbabwe",
      "ZWE+": "Republiek Zimbabwe",
    });
  }
}
