import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the Marathi (Marāṭhī) language
/// locale.
class MrCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `mr` locale.
  MrCountriesL10N() {
    map.addAll({
      "ABW": "अरुबा",
      "AFG": "अफगाणिस्तान",
      "AGO": "अंगोला",
      "AIA": "अँग्विला",
      "ALA": "अ‍ॅलँड बेटे",
      "ALB": "अल्बानिया",
      "AND": "अँडोरा",
      "ARE": "संयुक्त अरब अमीरात",
      "ARG": "अर्जेंटिना",
      "ARM": "अर्मेनिया",
      "ASM": "अमेरिकन सामोआ",
      "ATA": "अंटार्क्टिका",
      "ATF": "फ्रेंच दाक्षिणात्य प्रदेश",
      "ATG": "अँटिग्वा आणि बर्बुडा",
      "AUS": "ऑस्ट्रेलिया",
      "AUT": "ऑस्ट्रिया",
      "AZE": "अझरबैजान",
      "BDI": "बुरुंडी",
      "BEL": "बेल्जियम",
      "BEN": "बेनिन",
      "BES": "कॅरिबियन नेदरलँड्स",
      "BFA": "बुर्किना फासो",
      "BGD": "बांगलादेश",
      "BGR": "बल्गेरिया",
      "BHR": "बहारीन",
      "BHS": "बहामाज",
      "BIH": "बोस्निया अणि हर्जेगोविना",
      "BLM": "सेंट बार्थेलेमी",
      "BLR": "बेलारूस",
      "BLZ": "बेलिझे",
      "BMU": "बर्मुडा",
      "BOL": "बोलिव्हिया",
      "BRA": "ब्राझिल",
      "BRB": "बार्बाडोस",
      "BRN": "ब्रुनेई",
      "BTN": "भूतान",
      "BVT": "बोउवेट बेट",
      "BWA": "बोट्सवाना",
      "CAF": "केंद्रीय अफ्रिकी प्रजासत्ताक",
      "CAN": "कॅनडा",
      "CCK": "कोकोस (कीलिंग) बेटे",
      "CHE": "स्वित्झर्लंड",
      "CHL": "चिली",
      "CHN": "चीन",
      "CIV": "आयव्हरी कोस्ट",
      "CMR": "कॅमेरून",
      "COD": "काँगो - किंशासा",
      "COG": "काँगो - ब्राझाविले",
      "COK": "कुक बेटे",
      "COL": "कोलम्बिया",
      "COM": "कोमोरोज",
      "CPV": "केप व्हर्डे",
      "CRI": "कोस्टा रिका",
      "CUB": "क्यूबा",
      "CUW": "क्युरासाओ",
      "CXR": "ख्रिसमस बेट",
      "CYM": "केमन बेटे",
      "CYP": "सायप्रस",
      "CZE": "झेकिया",
      "DEU": "जर्मनी",
      "DJI": "जिबौटी",
      "DMA": "डोमिनिका",
      "DNK": "डेन्मार्क",
      "DOM": "डोमिनिकन प्रजासत्ताक",
      "DZA": "अल्जीरिया",
      "ECU": "इक्वाडोर",
      "EGY": "इजिप्त",
      "ERI": "एरिट्रिया",
      "ESH": "पश्चिम सहारा",
      "ESP": "स्पेन",
      "EST": "एस्टोनिया",
      "ETH": "इथिओपिया",
      "FIN": "फिनलंड",
      "FJI": "फिजी",
      "FLK": "फॉकलंड बेटे",
      "FRA": "फ्रान्स",
      "FRO": "फेरो बेटे",
      "FSM": "मायक्रोनेशिया",
      "GAB": "गॅबॉन",
      "GBR": "युनायटेड किंगडम",
      "GEO": "जॉर्जिया",
      "GGY": "ग्वेर्नसे",
      "GHA": "घाना",
      "GIB": "जिब्राल्टर",
      "GIN": "गिनी",
      "GLP": "ग्वाडेलोउपे",
      "GMB": "गाम्बिया",
      "GNB": "गिनी-बिसाउ",
      "GNQ": "इक्वेटोरियल गिनी",
      "GRC": "ग्रीस",
      "GRD": "ग्रेनेडा",
      "GRL": "ग्रीनलंड",
      "GTM": "ग्वाटेमाला",
      "GUF": "फ्रेंच गयाना",
      "GUM": "गुआम",
      "GUY": "गयाना",
      "HKG": "हाँगकाँग एसएआर चीन",
      "HMD": "हर्ड आणि मॅक्डोनाल्ड बेटे",
      "HND": "होंडुरास",
      "HRV": "क्रोएशिया",
      "HTI": "हैती",
      "HUN": "हंगेरी",
      "IDN": "इंडोनेशिया",
      "IMN": "आयल ऑफ मॅन",
      "IND": "भारत",
      "IOT": "ब्रिटिश हिंदी महासागर क्षेत्र",
      "IRL": "आयर्लंड",
      "IRN": "इराण",
      "IRQ": "इराक",
      "ISL": "आइसलँड",
      "ISR": "इस्त्राइल",
      "ITA": "इटली",
      "JAM": "जमैका",
      "JEY": "जर्सी",
      "JOR": "जॉर्डन",
      "JPN": "जपान",
      "KAZ": "कझाकस्तान",
      "KEN": "केनिया",
      "KGZ": "किरगिझस्तान",
      "KHM": "कंबोडिया",
      "KIR": "किरीबाटी",
      "KNA": "सेंट किट्स आणि नेव्हिस",
      "KOR": "दक्षिण कोरिया",
      "KWT": "कुवेत",
      "LAO": "लाओस",
      "LBN": "लेबनॉन",
      "LBR": "लायबेरिया",
      "LBY": "लिबिया",
      "LCA": "सेंट ल्यूसिया",
      "LIE": "लिक्टेनस्टाइन",
      "LKA": "श्रीलंका",
      "LSO": "लेसोथो",
      "LTU": "लिथुआनिया",
      "LUX": "लक्झेंबर्ग",
      "LVA": "लात्विया",
      "MAC": "मकाओ एसएआर चीन",
      "MAF": "सेंट मार्टिन",
      "MAR": "मोरोक्को",
      "MCO": "मोनॅको",
      "MDA": "मोल्डोव्हा",
      "MDG": "मादागास्कर",
      "MDV": "मालदीव",
      "MEX": "मेक्सिको",
      "MHL": "मार्शल बेटे",
      "MKD": "उत्तर मॅसेडोनिया",
      "MLI": "माली",
      "MLT": "माल्टा",
      "MMR": "म्यानमार (बर्मा)",
      "MNE": "मोंटेनेग्रो",
      "MNG": "मंगोलिया",
      "MNP": "उत्तरी मारियाना बेटे",
      "MOZ": "मोझाम्बिक",
      "MRT": "मॉरिटानिया",
      "MSR": "मॉन्ट्सेराट",
      "MTQ": "मार्टिनिक",
      "MUS": "मॉरिशस",
      "MWI": "मलावी",
      "MYS": "मलेशिया",
      "MYT": "मायोट्टे",
      "NAM": "नामिबिया",
      "NCL": "न्यू कॅलेडोनिया",
      "NER": "नाइजर",
      "NFK": "नॉरफॉक बेट",
      "NGA": "नायजेरिया",
      "NIC": "निकाराग्वा",
      "NIU": "नीयू",
      "NLD": "नेदरलँड",
      "NOR": "नॉर्वे",
      "NPL": "नेपाळ",
      "NRU": "नाउरू",
      "NZL": "न्यूझीलंड",
      "OMN": "ओमान",
      "PAK": "पाकिस्तान",
      "PAN": "पनामा",
      "PCN": "पिटकैर्न बेटे",
      "PER": "पेरू",
      "PHL": "फिलिपिन्स",
      "PLW": "पलाऊ",
      "PNG": "पापुआ न्यू गिनी",
      "POL": "पोलंड",
      "PRI": "प्युएर्तो रिको",
      "PRK": "उत्तर कोरिया",
      "PRT": "पोर्तुगाल",
      "PRY": "पराग्वे",
      "PSE": "पॅलेस्टिनियन प्रदेश",
      "PYF": "फ्रेंच पॉलिनेशिया",
      "QAT": "कतार",
      "REU": "रियुनियन",
      "ROU": "रोमानिया",
      "RUS": "रशिया",
      "RWA": "रवांडा",
      "SAU": "सौदी अरब",
      "SDN": "सुदान",
      "SEN": "सेनेगल",
      "SGP": "सिंगापूर",
      "SGS": "दक्षिण जॉर्जिया आणि दक्षिण सँडविच बेटे",
      "SHN": "सेंट हेलेना",
      "SJM": "स्वालबर्ड आणि जान मायेन",
      "SLB": "सोलोमन बेटे",
      "SLE": "सिएरा लिओन",
      "SLV": "अल साल्वाडोर",
      "SMR": "सॅन मरीनो",
      "SOM": "सोमालिया",
      "SPM": "सेंट पियरे आणि मिक्वेलोन",
      "SRB": "सर्बिया",
      "SSD": "दक्षिण सुदान",
      "STP": "साओ टोम आणि प्रिंसिपे",
      "SUR": "सुरिनाम",
      "SVK": "स्लोव्हाकिया",
      "SVN": "स्लोव्हेनिया",
      "SWE": "स्वीडन",
      "SWZ": "इस्वातिनी",
      "SXM": "सिंट मार्टेन",
      "SYC": "सेशेल्स",
      "SYR": "सीरिया",
      "TCA": "टर्क्स आणि कैकोस बेटे",
      "TCD": "चाड",
      "TGO": "टोगो",
      "THA": "थायलंड",
      "TJK": "ताजिकिस्तान",
      "TKL": "तोकेलाउ",
      "TKM": "तुर्कमेनिस्तान",
      "TLS": "तिमोर-लेस्ते",
      "TON": "टोंगा",
      "TTO": "त्रिनिदाद आणि टोबॅगो",
      "TUN": "ट्यूनिशिया",
      "TUR": "तुर्की",
      "TUV": "टुवालु",
      "TWN": "तैवान",
      "TZA": "टांझानिया",
      "UGA": "युगांडा",
      "UKR": "युक्रेन",
      "UMI": "यू.एस. आउटलाइंग बेटे",
      "UNK": "कोसोव्हो",
      "URY": "उरुग्वे",
      "USA": "युनायटेड स्टेट्स",
      "UZB": "उझबेकिस्तान",
      "VAT": "व्हॅटिकन सिटी",
      "VCT": "सेंट व्हिन्सेंट आणि ग्रेनडाइन्स",
      "VEN": "व्हेनेझुएला",
      "VGB": "ब्रिटिश व्हर्जिन बेटे",
      "VIR": "यू.एस. व्हर्जिन बेटे",
      "VNM": "व्हिएतनाम",
      "VUT": "वानुआतु",
      "WLF": "वालिस आणि फ्यूचूना",
      "WSM": "सामोआ",
      "YEM": "येमेन",
      "ZAF": "दक्षिण आफ्रिका",
      "ZMB": "झाम्बिया",
      "ZWE": "झिम्बाब्वे",
    });
  }
}
