import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the French language
/// locale.
class FrCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `fr` locale.
  FrCountriesL10N() {
    map.addAll({
      "ABW": "Aruba",
      "ABW+": "Aruba",
      "AFG": "Afghanistan",
      "AFG+": "République islamique d'Afghanistan",
      "AGO": "Angola",
      "AGO+": "République d'Angola",
      "AIA": "Anguilla",
      "AIA+": "Anguilla",
      "ALA": "Ahvenanmaa",
      "ALA+": "Ahvenanmaa",
      "ALB": "Albanie",
      "ALB+": "République d'Albanie",
      "AND": "Andorre",
      "AND+": "Principauté d'Andorre",
      "ARE": "Émirats arabes unis",
      "ARE+": "Émirats arabes unis",
      "ARG": "Argentine",
      "ARG+": "République argentine",
      "ARM": "Arménie",
      "ARM+": "République d'Arménie",
      "ASM": "Samoa américaines",
      "ASM+": "Samoa américaines",
      "ATA": "Antarctique",
      "ATA+": "Antarctique",
      "ATF": "Terres australes et antarctiques françaises",
      "ATF+": "Territoire des Terres australes et antarctiques françaises",
      "ATG": "Antigua-et-Barbuda",
      "ATG+": "Antigua-et-Barbuda",
      "AUS": "Australie",
      "AUS+": "Australie",
      "AUT": "Autriche",
      "AUT+": "République d'Autriche",
      "AZE": "Azerbaïdjan",
      "AZE+": "République d'Azerbaïdjan",
      "BDI": "Burundi",
      "BDI+": "République du Burundi",
      "BEL": "Belgique",
      "BEL+": "Royaume de Belgique",
      "BEN": "Bénin",
      "BEN+": "République du Bénin",
      "BES": "Pays-Bas caribéens",
      "BES+": "Bonaire, Saint-Eustache et Saba",
      "BFA": "Burkina Faso",
      "BFA+": "République du Burkina",
      "BGD": "Bangladesh",
      "BGD+": "La République populaire du Bangladesh",
      "BGR": "Bulgarie",
      "BGR+": "République de Bulgarie",
      "BHR": "Bahreïn",
      "BHR+": "Royaume de Bahreïn",
      "BHS": "Bahamas",
      "BHS+": "Commonwealth des Bahamas",
      "BIH": "Bosnie-Herzégovine",
      "BIH+": "Bosnie-et-Herzégovine",
      "BLM": "Saint-Barthélemy",
      "BLM+": "Collectivité de Saint-Barthélemy",
      "BLR": "Biélorussie",
      "BLR+": "République de Biélorussie",
      "BLZ": "Belize",
      "BLZ+": "Belize",
      "BMU": "Bermudes",
      "BMU+": "Bermudes",
      "BOL": "Bolivie",
      "BOL+": "État plurinational de Bolivie",
      "BRA": "Brésil",
      "BRA+": "République fédérative du Brésil",
      "BRB": "Barbade",
      "BRB+": "Barbade",
      "BRN": "Brunei",
      "BRN+": "État de Brunei Darussalam",
      "BTN": "Bhoutan",
      "BTN+": "Royaume du Bhoutan",
      "BVT": "Île Bouvet",
      "BVT+": "Île Bouvet",
      "BWA": "Botswana",
      "BWA+": "République du Botswana",
      "CAF": "République centrafricaine",
      "CAF+": "République centrafricaine",
      "CAN": "Canada",
      "CAN+": "Canada",
      "CCK": "Îles Cocos",
      "CCK+": "Territoire des îles Cocos (Keeling)",
      "CHE": "Suisse",
      "CHE+": "Confédération suisse",
      "CHL": "Chili",
      "CHL+": "République du Chili",
      "CHN": "Chine",
      "CHN+": "République populaire de Chine",
      "CIV": "Côte d'Ivoire",
      "CIV+": "République de Côte d' Ivoire",
      "CMR": "Cameroun",
      "CMR+": "République du Cameroun",
      "COD": "Congo (Rép. dém.)",
      "COD+": "République démocratique du Congo",
      "COG": "Congo",
      "COG+": "République du Congo",
      "COK": "Îles Cook",
      "COK+": "Îles Cook",
      "COL": "Colombie",
      "COL+": "République de Colombie",
      "COM": "Comores",
      "COM+": "Union des Comores",
      "CPV": "Îles du Cap-Vert",
      "CPV+": "République du Cap-Vert",
      "CRI": "Costa Rica",
      "CRI+": "République du Costa Rica",
      "CUB": "Cuba",
      "CUB+": "République de Cuba",
      "CUW": "Curaçao",
      "CUW+": "Pays de Curaçao",
      "CXR": "Île Christmas",
      "CXR+": "Territoire de l'île Christmas",
      "CYM": "Îles Caïmans",
      "CYM+": "Îles Caïmans",
      "CYP": "Chypre",
      "CYP+": "République de Chypre",
      "CZE": "Tchéquie",
      "CZE+": "République tchèque",
      "DEU": "Allemagne",
      "DEU+": "République fédérale d'Allemagne",
      "DJI": "Djibouti",
      "DJI+": "République de Djibouti",
      "DMA": "Dominique",
      "DMA+": "Commonwealth de la Dominique",
      "DNK": "Danemark",
      "DNK+": "Royaume du Danemark",
      "DOM": "République dominicaine",
      "DOM+": "République Dominicaine",
      "DZA": "Algérie",
      "DZA+": "République démocratique et populaire d'Algérie",
      "ECU": "Équateur",
      "ECU+": "République de l'Équateur",
      "EGY": "Égypte",
      "EGY+": "République arabe d'Égypte",
      "ERI": "Érythrée",
      "ERI+": "État d'Érythrée",
      "ESH": "Sahara Occidental",
      "ESH+": "République arabe sahraouie démocratique",
      "ESP": "Espagne",
      "ESP+": "Royaume d'Espagne",
      "EST": "Estonie",
      "EST+": "République d'Estonie",
      "ETH": "Éthiopie",
      "ETH+": "République fédérale démocratique d'Éthiopie",
      "FIN": "Finlande",
      "FIN+": "République de Finlande",
      "FJI": "Fidji",
      "FJI+": "République des Fidji",
      "FLK": "Îles Malouines",
      "FLK+": "Îles Malouines",
      "FRA": "France",
      "FRA+": "République française",
      "FRO": "Îles Féroé",
      "FRO+": "Îles Féroé",
      "FSM": "Micronésie",
      "FSM+": "États fédérés de Micronésie",
      "GAB": "Gabon",
      "GAB+": "République gabonaise",
      "GBR": "Royaume-Uni",
      "GBR+": "Royaume-Uni de Grande-Bretagne et d'Irlande du Nord",
      "GEO": "Géorgie",
      "GEO+": "République de Géorgie",
      "GGY": "Guernesey",
      "GGY+": "Bailliage de Guernesey",
      "GHA": "Ghana",
      "GHA+": "République du Ghana",
      "GIB": "Gibraltar",
      "GIB+": "Gibraltar",
      "GIN": "Guinée",
      "GIN+": "République de Guinée",
      "GLP": "Guadeloupe",
      "GLP+": "Guadeloupe",
      "GMB": "Gambie",
      "GMB+": "République de Gambie",
      "GNB": "Guinée-Bissau",
      "GNB+": "République de Guinée-Bissau",
      "GNQ": "Guinée équatoriale",
      "GNQ+": "République de Guinée équatoriale",
      "GRC": "Grèce",
      "GRC+": "République hellénique",
      "GRD": "Grenade",
      "GRD+": "Grenade",
      "GRL": "Groenland",
      "GRL+": "Groenland",
      "GTM": "Guatemala",
      "GTM+": "République du Guatemala",
      "GUF": "Guyane",
      "GUF+": "Guyane",
      "GUM": "Guam",
      "GUM+": "Guam",
      "GUY": "Guyana",
      "GUY+": "République coopérative de Guyana",
      "HKG": "Hong Kong",
      "HKG+":
          """Région administrative spéciale de Hong Kong de la République populaire de Chine""",
      "HMD": "Îles Heard-et-MacDonald",
      "HMD+": "Des îles Heard et McDonald",
      "HND": "Honduras",
      "HND+": "République du Honduras",
      "HRV": "Croatie",
      "HRV+": "République de Croatie",
      "HTI": "Haïti",
      "HTI+": "République d'Haïti",
      "HUN": "Hongrie",
      "HUN+": "Hongrie",
      "IDN": "Indonésie",
      "IDN+": "République d'Indonésie",
      "IMN": "Île de Man",
      "IMN+": "Isle of Man",
      "IND": "Inde",
      "IND+": "République de l'Inde",
      "IOT": "Territoire britannique de l'océan Indien",
      "IOT+": "Territoire britannique de l' océan Indien",
      "IRL": "Irlande",
      "IRL+": "République d'Irlande",
      "IRN": "Iran",
      "IRN+": "République islamique d'Iran",
      "IRQ": "Irak",
      "IRQ+": "République d'Irak",
      "ISL": "Islande",
      "ISL+": "République d'Islande",
      "ISR": "Israël",
      "ISR+": "État d'Israël",
      "ITA": "Italie",
      "ITA+": "République italienne",
      "JAM": "Jamaïque",
      "JAM+": "Jamaïque",
      "JEY": "Jersey",
      "JEY+": "Bailliage de Jersey",
      "JOR": "Jordanie",
      "JOR+": "Royaume hachémite de Jordanie",
      "JPN": "Japon",
      "JPN+": "Japon",
      "KAZ": "Kazakhstan",
      "KAZ+": "République du Kazakhstan",
      "KEN": "Kenya",
      "KEN+": "République du Kenya",
      "KGZ": "Kirghizistan",
      "KGZ+": "République kirghize",
      "KHM": "Cambodge",
      "KHM+": "Royaume du Cambodge",
      "KIR": "Kiribati",
      "KIR+": "République de Kiribati",
      "KNA": "Saint-Christophe-et-Niévès",
      "KNA+": "Fédération de Saint-Christophe-et-Niévès",
      "KOR": "Corée du Sud",
      "KOR+": "République de Corée",
      "KWT": "Koweït",
      "KWT+": "État du Koweït",
      "LAO": "Laos",
      "LAO+": "République démocratique populaire lao",
      "LBN": "Liban",
      "LBN+": "République libanaise",
      "LBR": "Liberia",
      "LBR+": "République du Libéria",
      "LBY": "Libye",
      "LBY+": "Grande République arabe libyenne populaire et socialiste",
      "LCA": "Sainte-Lucie",
      "LCA+": "Sainte-Lucie",
      "LIE": "Liechtenstein",
      "LIE+": "Principauté du Liechtenstein",
      "LKA": "Sri Lanka",
      "LKA+": "République démocratique socialiste du Sri Lanka",
      "LSO": "Lesotho",
      "LSO+": "Royaume du Lesotho",
      "LTU": "Lituanie",
      "LTU+": "République de Lituanie",
      "LUX": "Luxembourg",
      "LUX+": "Grand-Duché de Luxembourg",
      "LVA": "Lettonie",
      "LVA+": "République de Lettonie",
      "MAC": "Macao",
      "MAC+":
          """Région administrative spéciale de Macao de la République populaire de Chine""",
      "MAF": "Saint-Martin",
      "MAF+": "Saint-Martin",
      "MAR": "Maroc",
      "MAR+": "Royaume du Maroc",
      "MCO": "Monaco",
      "MCO+": "Principauté de Monaco",
      "MDA": "Moldavie",
      "MDA+": "République de Moldavie",
      "MDG": "Madagascar",
      "MDG+": "République de Madagascar",
      "MDV": "Maldives",
      "MDV+": "République des Maldives",
      "MEX": "Mexique",
      "MEX+": "États-Unis du Mexique",
      "MHL": "Îles Marshall",
      "MHL+": "République des Îles Marshall",
      "MKD": "Macédoine du Nord",
      "MKD+": "République de Macédoine du Nord",
      "MLI": "Mali",
      "MLI+": "République du Mali",
      "MLT": "Malte",
      "MLT+": "République de Malte",
      "MMR": "Birmanie",
      "MMR+": "République de l'Union du Myanmar",
      "MNE": "Monténégro",
      "MNE+": "Monténégro",
      "MNG": "Mongolie",
      "MNG+": "Mongolie",
      "MNP": "Îles Mariannes du Nord",
      "MNP+": "Commonwealth des îles Mariannes du Nord",
      "MOZ": "Mozambique",
      "MOZ+": "République du Mozambique",
      "MRT": "Mauritanie",
      "MRT+": "République islamique de Mauritanie",
      "MSR": "Montserrat",
      "MSR+": "Montserrat",
      "MTQ": "Martinique",
      "MTQ+": "Martinique",
      "MUS": "Île Maurice",
      "MUS+": "République de Maurice",
      "MWI": "Malawi",
      "MWI+": "République du Malawi",
      "MYS": "Malaisie",
      "MYS+": "Fédération de Malaisie",
      "MYT": "Mayotte",
      "MYT+": "Département de Mayotte",
      "NAM": "Namibie",
      "NAM+": "République de Namibie",
      "NCL": "Nouvelle-Calédonie",
      "NCL+": "Nouvelle-Calédonie",
      "NER": "Niger",
      "NER+": "République du Niger",
      "NFK": "Île Norfolk",
      "NFK+": "Territoire de l'île Norfolk",
      "NGA": "Nigéria",
      "NGA+": "République fédérale du Nigeria",
      "NIC": "Nicaragua",
      "NIC+": "République du Nicaragua",
      "NIU": "Niue",
      "NIU+": "Niue",
      "NLD": "Pays-Bas",
      "NLD+": "Pays-Bas",
      "NOR": "Norvège",
      "NOR+": "Royaume de Norvège",
      "NPL": "Népal",
      "NPL+": "République du Népal",
      "NRU": "Nauru",
      "NRU+": "République de Nauru",
      "NZL": "Nouvelle-Zélande",
      "NZL+": "Nouvelle-Zélande",
      "OMN": "Oman",
      "OMN+": "Sultanat d'Oman",
      "PAK": "Pakistan",
      "PAK+": "République islamique du Pakistan",
      "PAN": "Panama",
      "PAN+": "République du Panama",
      "PCN": "Îles Pitcairn",
      "PCN+": "Groupe d'îles Pitcairn",
      "PER": "Pérou",
      "PER+": "République du Pérou",
      "PHL": "Philippines",
      "PHL+": "République des Philippines",
      "PLW": "Palaos (Palau)",
      "PLW+": "République des Palaos (Palau)",
      "PNG": "Papouasie-Nouvelle-Guinée",
      "PNG+": "État indépendant de Papouasie-Nouvelle-Guinée",
      "POL": "Pologne",
      "POL+": "République de Pologne",
      "PRI": "Porto Rico",
      "PRI+": "Porto Rico",
      "PRK": "Corée du Nord",
      "PRK+": "République populaire démocratique de Corée",
      "PRT": "Portugal",
      "PRT+": "République portugaise",
      "PRY": "Paraguay",
      "PRY+": "République du Paraguay",
      "PSE": "Palestine",
      "PSE+": "État de Palestine",
      "PYF": "Polynésie française",
      "PYF+": "Polynésie française",
      "QAT": "Qatar",
      "QAT+": "État du Qatar",
      "REU": "Réunion",
      "REU+": "Ile de la Réunion",
      "ROU": "Roumanie",
      "ROU+": "Roumanie",
      "RUS": "Russie",
      "RUS+": "Fédération de Russie",
      "RWA": "Rwanda",
      "RWA+": "République rwandaise",
      "SAU": "Arabie Saoudite",
      "SAU+": "Royaume d'Arabie Saoudite",
      "SDN": "Soudan",
      "SDN+": "République du Soudan",
      "SEN": "Sénégal",
      "SEN+": "République du Sénégal",
      "SGP": "Singapour",
      "SGP+": "République de Singapour",
      "SGS": "Géorgie du Sud-et-les Îles Sandwich du Sud",
      "SGS+": "Géorgie du Sud et les îles Sandwich du Sud",
      "SHN": "Sainte-Hélène, Ascension et Tristan da Cunha",
      "SHN+": "Sainte-Hélène, Ascension et Tristan da Cunha",
      "SJM": "Svalbard et Jan Mayen",
      "SJM+": "Jan Mayen Svalbard",
      "SLB": "Îles Salomon",
      "SLB+": "Îles Salomon",
      "SLE": "Sierra Leone",
      "SLE+": "République de Sierra Leone",
      "SLV": "Salvador",
      "SLV+": "République du Salvador",
      "SMR": "Saint-Marin",
      "SMR+": "République de Saint-Marin",
      "SOM": "Somalie",
      "SOM+": "République fédérale de Somalie",
      "SPM": "Saint-Pierre-et-Miquelon",
      "SPM+": "Saint-Pierre-et-Miquelon",
      "SRB": "Serbie",
      "SRB+": "République de Serbie",
      "SSD": "Soudan du Sud",
      "SSD+": "République du Soudan du Sud",
      "STP": "São Tomé et Príncipe",
      "STP+": "République démocratique de São Tomé et Príncipe",
      "SUR": "Surinam",
      "SUR+": "République du Suriname",
      "SVK": "Slovaquie",
      "SVK+": "République slovaque",
      "SVN": "Slovénie",
      "SVN+": "République de Slovénie",
      "SWE": "Suède",
      "SWE+": "Royaume de Suède",
      "SWZ": "Swaziland",
      "SWZ+": "Royaume d’Eswatini",
      "SXM": "Saint-Martin",
      "SXM+": "Sint Maarten",
      "SYC": "Seychelles",
      "SYC+": "République des Seychelles",
      "SYR": "Syrie",
      "SYR+": "République arabe syrienne",
      "TCA": "Îles Turques-et-Caïques",
      "TCA+": "Îles Turques et Caïques",
      "TCD": "Tchad",
      "TCD+": "République du Tchad",
      "TGO": "Togo",
      "TGO+": "République togolaise",
      "THA": "Thaïlande",
      "THA+": "Royaume de Thaïlande",
      "TJK": "Tadjikistan",
      "TJK+": "République du Tadjikistan",
      "TKL": "Tokelau",
      "TKL+": "Îles Tokelau",
      "TKM": "Turkménistan",
      "TKM+": "Turkménistan",
      "TLS": "Timor oriental",
      "TLS+": "République démocratique du Timor oriental",
      "TON": "Tonga",
      "TON+": "Royaume des Tonga",
      "TTO": "Trinité-et-Tobago",
      "TTO+": "République de Trinité-et-Tobago",
      "TUN": "Tunisie",
      "TUN+": "République tunisienne",
      "TUR": "Turquie",
      "TUR+": "République de Turquie",
      "TUV": "Tuvalu",
      "TUV+": "Tuvalu",
      "TWN": "Taïwan",
      "TWN+": "République de Chine (Taïwan)",
      "TZA": "Tanzanie",
      "TZA+": "République -Unie de Tanzanie",
      "UGA": "Ouganda",
      "UGA+": "République de l'Ouganda",
      "UKR": "Ukraine",
      "UKR+": "Ukraine",
      "UMI": "Îles mineures éloignées des États-Unis",
      "UMI+": "Îles mineures éloignées des États-Unis",
      "UNK": "Kosovo",
      "UNK+": "République du Kosovo",
      "URY": "Uruguay",
      "URY+": "République orientale de l'Uruguay",
      "USA": "États-Unis",
      "USA+": "Les états-unis d'Amérique",
      "UZB": "Ouzbékistan",
      "UZB+": "République d'Ouzbékistan",
      "VAT": "Cité du Vatican",
      "VAT+": "Cité du Vatican",
      "VCT": "Saint-Vincent-et-les-Grenadines",
      "VCT+": "Saint-Vincent-et-les Grenadines",
      "VEN": "Venezuela",
      "VEN+": "République bolivarienne du Venezuela",
      "VGB": "Îles Vierges britanniques",
      "VGB+": "îles Vierges",
      "VIR": "Îles Vierges des États-Unis",
      "VIR+": "Îles Vierges des États-Unis",
      "VNM": "Viêt Nam",
      "VNM+": "République socialiste du Viêt Nam",
      "VUT": "Vanuatu",
      "VUT+": "République de Vanuatu",
      "WLF": "Wallis-et-Futuna",
      "WLF+": "Territoire des îles Wallis et Futuna",
      "WSM": "Samoa",
      "WSM+": "Samoa",
      "YEM": "Yémen",
      "YEM+": "République du Yémen",
      "ZAF": "Afrique du Sud",
      "ZAF+": "République d'Afrique du Sud",
      "ZMB": "Zambie",
      "ZMB+": "République de Zambie",
      "ZWE": "Zimbabwe",
      "ZWE+": "République du Zimbabwe",
    });
  }
}
