import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the Spanish language
/// locale.
class EsCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `es` locale.
  EsCountriesL10N() {
    map.addAll({
      "ABW": "Aruba",
      "ABW+": "Aruba",
      "AFG": "Afganistán",
      "AFG+": "República Islámica de Afganistán",
      "AGO": "Angola",
      "AGO+": "República de Angola",
      "AIA": "Anguilla",
      "AIA+": "Anguila",
      "ALA": "Alandia",
      "ALA+": "Islas Åland",
      "ALB": "Albania",
      "ALB+": "República de Albania",
      "AND": "Andorra",
      "AND+": "Principado de Andorra",
      "ARE": "Emiratos Árabes Unidos",
      "ARE+": "Emiratos Árabes Unidos",
      "ARG": "Argentina",
      "ARG+": "República Argentina",
      "ARM": "Armenia",
      "ARM+": "República de Armenia",
      "ASM": "Samoa Americana",
      "ASM+": "Samoa Americana",
      "ATA": "Antártida",
      "ATA+": "Antártida",
      "ATF": "Tierras Australes y Antárticas Francesas",
      "ATF+": "Territorio del Francés Tierras australes y antárticas",
      "ATG": "Antigua y Barbuda",
      "ATG+": "Antigua y Barbuda",
      "AUS": "Australia",
      "AUS+": "Mancomunidad de Australia",
      "AUT": "Austria",
      "AUT+": "República de Austria",
      "AZE": "Azerbaiyán",
      "AZE+": "República de Azerbaiyán",
      "BDI": "Burundi",
      "BDI+": "República de Burundi",
      "BEL": "Bélgica",
      "BEL+": "Reino de Bélgica",
      "BEN": "Benín",
      "BEN+": "República de Benin",
      "BES": "Caribe Neerlandés",
      "BES+": "Bonaire, San Eustaquio y Saba",
      "BFA": "Burkina Faso",
      "BFA+": "Burkina Faso",
      "BGD": "Bangladesh",
      "BGD+": "República Popular de Bangladesh",
      "BGR": "Bulgaria",
      "BGR+": "República de Bulgaria",
      "BHR": "Bahrein",
      "BHR+": "Reino de Bahrein",
      "BHS": "Bahamas",
      "BHS+": "Commonwealth de las Bahamas",
      "BIH": "Bosnia y Herzegovina",
      "BIH+": "Bosnia y Herzegovina",
      "BLM": "San Bartolomé",
      "BLM+": "Colectividad de San Barthélemy",
      "BLR": "Bielorrusia",
      "BLR+": "República de Belarús",
      "BLZ": "Belice",
      "BLZ+": "Belice",
      "BMU": "Bermudas",
      "BMU+": "Bermuda",
      "BOL": "Bolivia",
      "BOL+": "Estado Plurinacional de Bolivia",
      "BRA": "Brasil",
      "BRA+": "República Federativa del Brasil",
      "BRB": "Barbados",
      "BRB+": "Barbados",
      "BRN": "Brunei",
      "BRN+": "Nación de Brunei, Morada de la Paz",
      "BTN": "Bután",
      "BTN+": "Reino de Bután",
      "BVT": "Isla Bouvet",
      "BVT+": "Isla Bouvet",
      "BWA": "Botswana",
      "BWA+": "República de Botswana",
      "CAF": "República Centroafricana",
      "CAF+": "República Centroafricana",
      "CAN": "Canadá",
      "CAN+": "Canadá",
      "CCK": "Islas Cocos o Islas Keeling",
      "CCK+": "Territorio de los (Keeling) Islas Cocos",
      "CHE": "Suiza",
      "CHE+": "Confederación Suiza",
      "CHL": "Chile",
      "CHL+": "República de Chile",
      "CHN": "China",
      "CHN+": "República Popular de China",
      "CIV": "Costa de Marfil",
      "CIV+": "República de Côte d'Ivoire",
      "CMR": "Camerún",
      "CMR+": "República de Camerún",
      "COD": "Congo (Rep. Dem.)",
      "COD+": "República Democrática del Congo",
      "COG": "Congo",
      "COG+": "República del Congo",
      "COK": "Islas Cook",
      "COK+": "Islas Cook",
      "COL": "Colombia",
      "COL+": "República de Colombia",
      "COM": "Comoras",
      "COM+": "Unión de las Comoras",
      "CPV": "Cabo Verde",
      "CPV+": "República de Cabo Verde",
      "CRI": "Costa Rica",
      "CRI+": "República de Costa Rica",
      "CUB": "Cuba",
      "CUB+": "República de Cuba",
      "CUW": "Curazao",
      "CUW+": "País de Curazao",
      "CXR": "Isla de Navidad",
      "CXR+": "Territorio de la Isla de Navidad",
      "CYM": "Islas Caimán",
      "CYM+": "Islas Caimán",
      "CYP": "Chipre",
      "CYP+": "República de Chipre",
      "CZE": "Chequia",
      "CZE+": "República Checa",
      "DEU": "Alemania",
      "DEU+": "República Federal de Alemania",
      "DJI": "Djibouti",
      "DJI+": "República de Djibouti",
      "DMA": "Dominica",
      "DMA+": "Mancomunidad de Dominica",
      "DNK": "Dinamarca",
      "DNK+": "Reino de Dinamarca",
      "DOM": "República Dominicana",
      "DOM+": "República Dominicana",
      "DZA": "Argelia",
      "DZA+": "República Argelina Democrática y Popular",
      "ECU": "Ecuador",
      "ECU+": "República del Ecuador",
      "EGY": "Egipto",
      "EGY+": "República Árabe de Egipto",
      "ERI": "Eritrea",
      "ERI+": "Estado de Eritrea",
      "ESH": "Sahara Occidental",
      "ESH+": "República Árabe Saharaui Democrática",
      "ESP": "España",
      "ESP+": "Reino de España",
      "EST": "Estonia",
      "EST+": "República de Estonia",
      "ETH": "Etiopía",
      "ETH+": "República Democrática Federal de Etiopía",
      "FIN": "Finlandia",
      "FIN+": "República de Finlandia",
      "FJI": "Fiyi",
      "FJI+": "República de Fiji",
      "FLK": "Islas Malvinas",
      "FLK+": "islas Malvinas",
      "FRA": "Francia",
      "FRA+": "República francés",
      "FRO": "Islas Faroe",
      "FRO+": "Islas Feroe",
      "FSM": "Micronesia",
      "FSM+": "Estados Federados de Micronesia",
      "GAB": "Gabón",
      "GAB+": "República de Gabón",
      "GBR": "Reino Unido",
      "GBR+": "Reino Unido de Gran Bretaña e Irlanda del Norte",
      "GEO": "Georgia",
      "GEO+": "Georgia",
      "GGY": "Guernsey",
      "GGY+": "Bailía de Guernsey",
      "GHA": "Ghana",
      "GHA+": "República de Ghana",
      "GIB": "Gibraltar",
      "GIB+": "Gibraltar",
      "GIN": "Guinea",
      "GIN+": "República de Guinea",
      "GLP": "Guadalupe",
      "GLP+": "Guadalupe",
      "GMB": "Gambia",
      "GMB+": "República de Gambia",
      "GNB": "Guinea-Bisáu",
      "GNB+": "República de Guinea-Bissau",
      "GNQ": "Guinea Ecuatorial",
      "GNQ+": "República de Guinea Ecuatorial",
      "GRC": "Grecia",
      "GRC+": "República Helénica",
      "GRD": "Grenada",
      "GRD+": "Granada",
      "GRL": "Groenlandia",
      "GRL+": "Groenlandia",
      "GTM": "Guatemala",
      "GTM+": "República de Guatemala",
      "GUF": "Guayana Francesa",
      "GUF+": "Guayana",
      "GUM": "Guam",
      "GUM+": "Guam",
      "GUY": "Guyana",
      "GUY+": "República Cooperativa de Guyana",
      "HKG": "Hong Kong",
      "HKG+":
          """Hong Kong Región Administrativa Especial de la República Popular China""",
      "HMD": "Islas Heard y McDonald",
      "HMD+": "Islas Heard y McDonald",
      "HND": "Honduras",
      "HND+": "República de Honduras",
      "HRV": "Croacia",
      "HRV+": "República de Croacia",
      "HTI": "Haití",
      "HTI+": "República de Haití",
      "HUN": "Hungría",
      "HUN+": "Hungría",
      "IDN": "Indonesia",
      "IDN+": "República de Indonesia",
      "IMN": "Isla de Man",
      "IMN+": "Isla de Man",
      "IND": "India",
      "IND+": "República de la India",
      "IOT": "Territorio Británico del Océano Índico",
      "IOT+": "Territorio Británico del Océano Índico",
      "IRL": "Irlanda",
      "IRL+": "República de Irlanda",
      "IRN": "Iran",
      "IRN+": "República Islámica de Irán",
      "IRQ": "Irak",
      "IRQ+": "República de Irak",
      "ISL": "Islandia",
      "ISL+": "Islandia",
      "ISR": "Israel",
      "ISR+": "Estado de Israel",
      "ITA": "Italia",
      "ITA+": "República Italiana",
      "JAM": "Jamaica",
      "JAM+": "Jamaica",
      "JEY": "Jersey",
      "JEY+": "Bailía de Jersey",
      "JOR": "Jordania",
      "JOR+": "Reino Hachemita de Jordania",
      "JPN": "Japón",
      "JPN+": "Japón",
      "KAZ": "Kazajistán",
      "KAZ+": "República de Kazajstán",
      "KEN": "Kenia",
      "KEN+": "República de Kenya",
      "KGZ": "Kirguizistán",
      "KGZ+": "República Kirguisa",
      "KHM": "Camboya",
      "KHM+": "Reino de Camboya",
      "KIR": "Kiribati",
      "KIR+": "República Independiente y Soberano de Kiribati",
      "KNA": "San Cristóbal y Nieves",
      "KNA+": "Federación de San Cristóbal y Nevis",
      "KOR": "Corea del Sur",
      "KOR+": "República de Corea",
      "KWT": "Kuwait",
      "KWT+": "Estado de Kuwait",
      "LAO": "Laos",
      "LAO+": "República Democrática Popular Lao",
      "LBN": "Líbano",
      "LBN+": "República Libanesa",
      "LBR": "Liberia",
      "LBR+": "República de Liberia",
      "LBY": "Libia",
      "LBY+": "Estado de Libia",
      "LCA": "Santa Lucía",
      "LCA+": "Santa Lucía",
      "LIE": "Liechtenstein",
      "LIE+": "Principado de Liechtenstein",
      "LKA": "Sri Lanka",
      "LKA+": "República Democrática Socialista de Sri Lanka",
      "LSO": "Lesotho",
      "LSO+": "Reino de Lesotho",
      "LTU": "Lituania",
      "LTU+": "República de Lituania",
      "LUX": "Luxemburgo",
      "LUX+": "Gran Ducado de Luxemburgo",
      "LVA": "Letonia",
      "LVA+": "República de Letonia",
      "MAC": "Macao",
      "MAC+":
          "Macao, Región Administrativa Especial de la República Popular China",
      "MAF": "Saint Martin",
      "MAF+": "Saint Martin",
      "MAR": "Marruecos",
      "MAR+": "Reino de Marruecos",
      "MCO": "Mónaco",
      "MCO+": "Principado de Mónaco",
      "MDA": "Moldavia",
      "MDA+": "República de Moldova",
      "MDG": "Madagascar",
      "MDG+": "República de Madagascar",
      "MDV": "Maldivas",
      "MDV+": "República de las Maldivas",
      "MEX": "México",
      "MEX+": "Estados Unidos Mexicanos",
      "MHL": "Islas Marshall",
      "MHL+": "República de las Islas Marshall",
      "MKD": "Macedonia del Norte",
      "MKD+": "República de Macedonia del Norte",
      "MLI": "Mali",
      "MLI+": "República de Malí",
      "MLT": "Malta",
      "MLT+": "República de Malta",
      "MMR": "Myanmar",
      "MMR+": "República de la Unión de Myanmar",
      "MNE": "Montenegro",
      "MNE+": "Montenegro",
      "MNG": "Mongolia",
      "MNG+": "Mongolia",
      "MNP": "Islas Marianas del Norte",
      "MNP+": "Mancomunidad de las Islas Marianas del Norte",
      "MOZ": "Mozambique",
      "MOZ+": "República de Mozambique",
      "MRT": "Mauritania",
      "MRT+": "República Islámica de Mauritania",
      "MSR": "Montserrat",
      "MSR+": "Montserrat",
      "MTQ": "Martinica",
      "MTQ+": "Martinica",
      "MUS": "Mauricio",
      "MUS+": "República de Mauricio",
      "MWI": "Malawi",
      "MWI+": "República de Malawi",
      "MYS": "Malasia",
      "MYS+": "Malasia",
      "MYT": "Mayotte",
      "MYT+": "Departamento de Mayotte",
      "NAM": "Namibia",
      "NAM+": "República de Namibia",
      "NCL": "Nueva Caledonia",
      "NCL+": "Nueva Caledonia",
      "NER": "Níger",
      "NER+": "República de Níger",
      "NFK": "Isla de Norfolk",
      "NFK+": "Territorio de la Isla Norfolk",
      "NGA": "Nigeria",
      "NGA+": "República Federal de Nigeria",
      "NIC": "Nicaragua",
      "NIC+": "República de Nicaragua",
      "NIU": "Niue",
      "NIU+": "Niue",
      "NLD": "Países Bajos",
      "NLD+": "Países Bajos",
      "NOR": "Noruega",
      "NOR+": "Reino de Noruega",
      "NPL": "Nepal",
      "NPL+": "República Democrática Federal de Nepal",
      "NRU": "Nauru",
      "NRU+": "República de Nauru",
      "NZL": "Nueva Zelanda",
      "NZL+": "Nueva Zelanda",
      "OMN": "Omán",
      "OMN+": "Sultanato de Omán",
      "PAK": "Pakistán",
      "PAK+": "República Islámica de Pakistán",
      "PAN": "Panamá",
      "PAN+": "República de Panamá",
      "PCN": "Islas Pitcairn",
      "PCN+": "Grupo de Islas Pitcairn",
      "PER": "Perú",
      "PER+": "República de Perú",
      "PHL": "Filipinas",
      "PHL+": "República de las Filipinas",
      "PLW": "Palau",
      "PLW+": "República de Palau",
      "PNG": "Papúa Nueva Guinea",
      "PNG+": "Estado Independiente de Papúa Nueva Guinea",
      "POL": "Polonia",
      "POL+": "República de Polonia",
      "PRI": "Puerto Rico",
      "PRI+": "Asociado de Puerto Rico",
      "PRK": "Corea del Norte",
      "PRK+": "República Popular Democrática de Corea",
      "PRT": "Portugal",
      "PRT+": "República Portuguesa",
      "PRY": "Paraguay",
      "PRY+": "República de Paraguay",
      "PSE": "Palestina",
      "PSE+": "Estado de Palestina",
      "PYF": "Polinesia Francesa",
      "PYF+": "Polinesia francés",
      "QAT": "Catar",
      "QAT+": "Estado de Qatar",
      "REU": "Reunión",
      "REU+": "Isla de la Reunión",
      "ROU": "Rumania",
      "ROU+": "Rumania",
      "RUS": "Rusia",
      "RUS+": "Federación de Rusia",
      "RWA": "Ruanda",
      "RWA+": "República de Rwanda",
      "SAU": "Arabia Saudí",
      "SAU+": "Reino de Arabia Saudita",
      "SDN": "Sudán",
      "SDN+": "República de Sudán",
      "SEN": "Senegal",
      "SEN+": "República de Senegal",
      "SGP": "Singapur",
      "SGP+": "República de Singapur",
      "SGS": "Islas Georgias del Sur y Sandwich del Sur",
      "SGS+": "Georgia del Sur y las Islas Sandwich del Sur",
      "SHN": "Santa Elena, Ascensión y Tristán de Acuña",
      "SHN+": "Santa Elena, Ascensión y Tristán de Acuña",
      "SJM": "Islas Svalbard y Jan Mayen",
      "SJM+": "Svalbard og Jan Mayen",
      "SLB": "Islas Salomón",
      "SLB+": "islas Salomón",
      "SLE": "Sierra Leone",
      "SLE+": "República de Sierra Leona",
      "SLV": "El Salvador",
      "SLV+": "República de El Salvador",
      "SMR": "San Marino",
      "SMR+": "Serenísima República de San Marino",
      "SOM": "Somalia",
      "SOM+": "República Federal de Somalia",
      "SPM": "San Pedro y Miquelón",
      "SPM+": "San Pedro y Miquelón",
      "SRB": "Serbia",
      "SRB+": "República de Serbia",
      "SSD": "Sudán del Sur",
      "SSD+": "República de Sudán del Sur",
      "STP": "Santo Tomé y Príncipe",
      "STP+": "República Democrática de Santo Tomé y Príncipe",
      "SUR": "Surinam",
      "SUR+": "República de Suriname",
      "SVK": "República Eslovaca",
      "SVK+": "República Eslovaca",
      "SVN": "Eslovenia",
      "SVN+": "República de Eslovenia",
      "SWE": "Suecia",
      "SWE+": "Reino de Suecia",
      "SWZ": "Suazilandia",
      "SWZ+": "Reino de eSwatini",
      "SXM": "Sint Maarten",
      "SXM+": "Sint Maarten",
      "SYC": "Seychelles",
      "SYC+": "República de las Seychelles",
      "SYR": "Siria",
      "SYR+": "República Árabe Siria",
      "TCA": "Islas Turks y Caicos",
      "TCA+": "Islas Turcas y Caicos",
      "TCD": "Chad",
      "TCD+": "República de Chad",
      "TGO": "Togo",
      "TGO+": "República de Togo",
      "THA": "Tailandia",
      "THA+": "Reino de Tailandia",
      "TJK": "Tayikistán",
      "TJK+": "República de Tayikistán",
      "TKL": "Islas Tokelau",
      "TKL+": "Tokelau",
      "TKM": "Turkmenistán",
      "TKM+": "Turkmenistán",
      "TLS": "Timor Oriental",
      "TLS+": "República Democrática de Timor-Leste",
      "TON": "Tonga",
      "TON+": "Reino de Tonga",
      "TTO": "Trinidad y Tobago",
      "TTO+": "República de Trinidad y Tobago",
      "TUN": "Túnez",
      "TUN+": "República de Túnez",
      "TUR": "Turquía",
      "TUR+": "República de Turquía",
      "TUV": "Tuvalu",
      "TUV+": "Tuvalu",
      "TWN": "Taiwán",
      "TWN+": "República de China en Taiwán",
      "TZA": "Tanzania",
      "TZA+": "República Unida de Tanzania",
      "UGA": "Uganda",
      "UGA+": "República de Uganda",
      "UKR": "Ucrania",
      "UKR+": "Ucrania",
      "UMI": "Islas Ultramarinas Menores de Estados Unidos",
      "UMI+": "Estados Unidos Islas menores alejadas de",
      "UNK": "Kosovo",
      "UNK+": "República de Kosovo",
      "URY": "Uruguay",
      "URY+": "República Oriental del Uruguay",
      "USA": "Estados Unidos",
      "USA+": "Estados Unidos de América",
      "UZB": "Uzbekistán",
      "UZB+": "República de Uzbekistán",
      "VAT": "Ciudad del Vaticano",
      "VAT+": "Ciudad del Vaticano",
      "VCT": "San Vicente y Granadinas",
      "VCT+": "San Vicente y las Granadinas",
      "VEN": "Venezuela",
      "VEN+": "República Bolivariana de Venezuela",
      "VGB": "Islas Vírgenes del Reino Unido",
      "VGB+": "Islas Vírgenes",
      "VIR": "Islas Vírgenes de los Estados Unidos",
      "VIR+": "Islas Vírgenes de los Estados Unidos",
      "VNM": "Vietnam",
      "VNM+": "República Socialista de Vietnam",
      "VUT": "Vanuatu",
      "VUT+": "República de Vanuatu",
      "WLF": "Wallis y Futuna",
      "WLF+": "Territorio de las Islas Wallis y Futuna",
      "WSM": "Samoa",
      "WSM+": "Estado Independiente de Samoa",
      "YEM": "Yemen",
      "YEM+": "República de Yemen",
      "ZAF": "Sudáfrica",
      "ZAF+": "República de Sudáfrica",
      "ZMB": "Zambia",
      "ZMB+": "República de Zambia",
      "ZWE": "Zimbabue",
      "ZWE+": "República de Zimbabue",
    });
  }
}
