import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the English language
/// locale.
class EnCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `en` locale.
  EnCountriesL10N() {
    map.addAll({
      "ABW": "Aruba",
      "ABW+": "Aruba",
      "AFG": "Afghanistan",
      "AFG+": "Islamic Republic of Afghanistan",
      "AGO": "Angola",
      "AGO+": "Republic of Angola",
      "AIA": "Anguilla",
      "AIA+": "Anguilla",
      "ALA": "Åland Islands",
      "ALA+": "Åland Islands",
      "ALB": "Albania",
      "ALB+": "Republic of Albania",
      "AND": "Andorra",
      "AND+": "Principality of Andorra",
      "ARE": "United Arab Emirates",
      "ARE+": "United Arab Emirates",
      "ARG": "Argentina",
      "ARG+": "Argentine Republic",
      "ARM": "Armenia",
      "ARM+": "Republic of Armenia",
      "ASM": "American Samoa",
      "ASM+": "American Samoa",
      "ATA": "Antarctica",
      "ATA+": "Antarctica",
      "ATF": "French Southern and Antarctic Lands",
      "ATF+": "Territory of the French Southern and Antarctic Lands",
      "ATG": "Antigua and Barbuda",
      "ATG+": "Antigua and Barbuda",
      "AUS": "Australia",
      "AUS+": "Commonwealth of Australia",
      "AUT": "Austria",
      "AUT+": "Republic of Austria",
      "AZE": "Azerbaijan",
      "AZE+": "Republic of Azerbaijan",
      "BDI": "Burundi",
      "BDI+": "Republic of Burundi",
      "BEL": "Belgium",
      "BEL+": "Kingdom of Belgium",
      "BEN": "Benin",
      "BEN+": "Republic of Benin",
      "BES": "Caribbean Netherlands",
      "BES+": "Bonaire, Sint Eust,atius and Saba",
      "BFA": "Burkina Faso",
      "BFA+": "Burkina Faso",
      "BGD": "Bangladesh",
      "BGD+": "People's Republic of Bangladesh",
      "BGR": "Bulgaria",
      "BGR+": "Republic of Bulgaria",
      "BHR": "Bahrain",
      "BHR+": "Kingdom of Bahrain",
      "BHS": "Bahamas",
      "BHS+": "Commonwealth of the Bahamas",
      "BIH": "Bosnia and Herzegovina",
      "BIH+": "Bosnia and Herzegovina",
      "BLM": "Saint Barthélemy",
      "BLM+": "Collectivity of Saint Barthélemy",
      "BLR": "Belarus",
      "BLR+": "Republic of Belarus",
      "BLZ": "Belize",
      "BLZ+": "Belize",
      "BMU": "Bermuda",
      "BMU+": "Bermuda",
      "BOL": "Bolivia",
      "BOL+": "Plurinational State of Bolivia",
      "BRA": "Brazil",
      "BRA+": "Federative Republic of Brazil",
      "BRB": "Barbados",
      "BRB+": "Barbados",
      "BRN": "Brunei",
      "BRN+": "Nation of Brunei, Abode of Peace",
      "BTN": "Bhutan",
      "BTN+": "Kingdom of Bhutan",
      "BVT": "Bouvet Island",
      "BVT+": "Bouvet Island",
      "BWA": "Botswana",
      "BWA+": "Republic of Botswana",
      "CAF": "Central African Republic",
      "CAF+": "Central African Republic",
      "CAN": "Canada",
      "CAN+": "Canada",
      "CCK": "Cocos (Keeling) Islands",
      "CCK+": "Territory of the Cocos (Keeling) Islands",
      "CHE": "Switzerland",
      "CHE+": "Swiss Confederation",
      "CHL": "Chile",
      "CHL+": "Republic of Chile",
      "CHN": "China",
      "CHN+": "People's Republic of China",
      "CIV": "Ivory Coast",
      "CIV+": "Republic of Côte d'Ivoire",
      "CMR": "Cameroon",
      "CMR+": "Republic of Cameroon",
      "COD": "DR Congo",
      "COD+": "Democratic Republic of the Congo",
      "COG": "Republic of the Congo",
      "COG+": "Republic of the Congo",
      "COK": "Cook Islands",
      "COK+": "Cook Islands",
      "COL": "Colombia",
      "COL+": "Republic of Colombia",
      "COM": "Comoros",
      "COM+": "Union of the Comoros",
      "CPV": "Cape Verde",
      "CPV+": "Republic of Cabo Verde",
      "CRI": "Costa Rica",
      "CRI+": "Republic of Costa Rica",
      "CUB": "Cuba",
      "CUB+": "Republic of Cuba",
      "CUW": "Curaçao",
      "CUW+": "Country of Curaçao",
      "CXR": "Christmas Island",
      "CXR+": "Territory of Christmas Island",
      "CYM": "Cayman Islands",
      "CYM+": "Cayman Islands",
      "CYP": "Cyprus",
      "CYP+": "Republic of Cyprus",
      "CZE": "Czechia",
      "CZE+": "Czech Republic",
      "DEU": "Germany",
      "DEU+": "Federal Republic of Germany",
      "DJI": "Djibouti",
      "DJI+": "Republic of Djibouti",
      "DMA": "Dominica",
      "DMA+": "Commonwealth of Dominica",
      "DNK": "Denmark",
      "DNK+": "Kingdom of Denmark",
      "DOM": "Dominican Republic",
      "DOM+": "Dominican Republic",
      "DZA": "Algeria",
      "DZA+": "People's Democratic Republic of Algeria",
      "ECU": "Ecuador",
      "ECU+": "Republic of Ecuador",
      "EGY": "Egypt",
      "EGY+": "Arab Republic of Egypt",
      "ERI": "Eritrea",
      "ERI+": "State of Eritrea",
      "ESH": "Western Sahara",
      "ESH+": "Sahrawi Arab Democratic Republic",
      "ESP": "Spain",
      "ESP+": "Kingdom of Spain",
      "EST": "Estonia",
      "EST+": "Republic of Estonia",
      "ETH": "Ethiopia",
      "ETH+": "Federal Democratic Republic of Ethiopia",
      "FIN": "Finland",
      "FIN+": "Republic of Finland",
      "FJI": "Fiji",
      "FJI+": "Republic of Fiji",
      "FLK": "Falkland Islands",
      "FLK+": "Falkland Islands",
      "FRA": "France",
      "FRA+": "French Republic",
      "FRO": "Faroe Islands",
      "FRO+": "Faroe Islands",
      "FSM": "Micronesia",
      "FSM+": "Federated States of Micronesia",
      "GAB": "Gabon",
      "GAB+": "Gabonese Republic",
      "GBR": "United Kingdom",
      "GBR+": "United Kingdom of Great Britain and Northern Ireland",
      "GEO": "Georgia",
      "GEO+": "Georgia",
      "GGY": "Guernsey",
      "GGY+": "Bailiwick of Guernsey",
      "GHA": "Ghana",
      "GHA+": "Republic of Ghana",
      "GIB": "Gibraltar",
      "GIB+": "Gibraltar",
      "GIN": "Guinea",
      "GIN+": "Republic of Guinea",
      "GLP": "Guadeloupe",
      "GLP+": "Guadeloupe",
      "GMB": "Gambia",
      "GMB+": "Republic of the Gambia",
      "GNB": "Guinea-Bissau",
      "GNB+": "Republic of Guinea-Bissau",
      "GNQ": "Equatorial Guinea",
      "GNQ+": "Republic of Equatorial Guinea",
      "GRC": "Greece",
      "GRC+": "Hellenic Republic",
      "GRD": "Grenada",
      "GRD+": "Grenada",
      "GRL": "Greenland",
      "GRL+": "Greenland",
      "GTM": "Guatemala",
      "GTM+": "Republic of Guatemala",
      "GUF": "French Guiana",
      "GUF+": "Guiana",
      "GUM": "Guam",
      "GUM+": "Guam",
      "GUY": "Guyana",
      "GUY+": "Co-operative Republic of Guyana",
      "HKG": "Hong Kong",
      "HKG+":
          """Hong Kong Special Administrative Region of the People's Republic of China""",
      "HMD": "Heard Island and McDonald Islands",
      "HMD+": "Heard Island and McDonald Islands",
      "HND": "Honduras",
      "HND+": "Republic of Honduras",
      "HRV": "Croatia",
      "HRV+": "Republic of Croatia",
      "HTI": "Haiti",
      "HTI+": "Republic of Haiti",
      "HUN": "Hungary",
      "HUN+": "Hungary",
      "IDN": "Indonesia",
      "IDN+": "Republic of Indonesia",
      "IMN": "Isle of Man",
      "IMN+": "Isle of Man",
      "IND": "India",
      "IND+": "Republic of India",
      "IOT": "British Indian Ocean Territory",
      "IOT+": "British Indian Ocean Territory",
      "IRL": "Ireland",
      "IRL+": "Republic of Ireland",
      "IRN": "Iran",
      "IRN+": "Islamic Republic of Iran",
      "IRQ": "Iraq",
      "IRQ+": "Republic of Iraq",
      "ISL": "Iceland",
      "ISL+": "Iceland",
      "ISR": "Israel",
      "ISR+": "State of Israel",
      "ITA": "Italy",
      "ITA+": "Italian Republic",
      "JAM": "Jamaica",
      "JAM+": "Jamaica",
      "JEY": "Jersey",
      "JEY+": "Bailiwick of Jersey",
      "JOR": "Jordan",
      "JOR+": "Hashemite Kingdom of Jordan",
      "JPN": "Japan",
      "JPN+": "Japan",
      "KAZ": "Kazakhstan",
      "KAZ+": "Republic of Kazakhstan",
      "KEN": "Kenya",
      "KEN+": "Republic of Kenya",
      "KGZ": "Kyrgyzstan",
      "KGZ+": "Kyrgyz Republic",
      "KHM": "Cambodia",
      "KHM+": "Kingdom of Cambodia",
      "KIR": "Kiribati",
      "KIR+": "Independent and Sovereign Republic of Kiribati",
      "KNA": "Saint Kitts and Nevis",
      "KNA+": "Federation of Saint Christopher and Nevis",
      "KOR": "South Korea",
      "KOR+": "Republic of Korea",
      "KWT": "Kuwait",
      "KWT+": "State of Kuwait",
      "LAO": "Laos",
      "LAO+": "Lao People's Democratic Republic",
      "LBN": "Lebanon",
      "LBN+": "Lebanese Republic",
      "LBR": "Liberia",
      "LBR+": "Republic of Liberia",
      "LBY": "Libya",
      "LBY+": "State of Libya",
      "LCA": "Saint Lucia",
      "LCA+": "Saint Lucia",
      "LIE": "Liechtenstein",
      "LIE+": "Principality of Liechtenstein",
      "LKA": "Sri Lanka",
      "LKA+": "Democratic Socialist Republic of Sri Lanka",
      "LSO": "Lesotho",
      "LSO+": "Kingdom of Lesotho",
      "LTU": "Lithuania",
      "LTU+": "Republic of Lithuania",
      "LUX": "Luxembourg",
      "LUX+": "Grand Duchy of Luxembourg",
      "LVA": "Latvia",
      "LVA+": "Republic of Latvia",
      "MAC": "Macau",
      "MAC+":
          """Macao Special Administrative Region of the People's Republic of China""",
      "MAF": "Saint Martin",
      "MAF+": "Saint Martin",
      "MAR": "Morocco",
      "MAR+": "Kingdom of Morocco",
      "MCO": "Monaco",
      "MCO+": "Principality of Monaco",
      "MDA": "Moldova",
      "MDA+": "Republic of Moldova",
      "MDG": "Madagascar",
      "MDG+": "Republic of Madagascar",
      "MDV": "Maldives",
      "MDV+": "Republic of the Maldives",
      "MEX": "Mexico",
      "MEX+": "United Mexican States",
      "MHL": "Marshall Islands",
      "MHL+": "Republic of the Marshall Islands",
      "MKD": "North Macedonia",
      "MKD+": "Republic of North Macedonia",
      "MLI": "Mali",
      "MLI+": "Republic of Mali",
      "MLT": "Malta",
      "MLT+": "Republic of Malta",
      "MMR": "Myanmar",
      "MMR+": "Republic of the Union of Myanmar",
      "MNE": "Montenegro",
      "MNE+": "Montenegro",
      "MNG": "Mongolia",
      "MNG+": "Mongolia",
      "MNP": "Northern Mariana Islands",
      "MNP+": "Commonwealth of the Northern Mariana Islands",
      "MOZ": "Mozambique",
      "MOZ+": "Republic of Mozambique",
      "MRT": "Mauritania",
      "MRT+": "Islamic Republic of Mauritania",
      "MSR": "Montserrat",
      "MSR+": "Montserrat",
      "MTQ": "Martinique",
      "MTQ+": "Martinique",
      "MUS": "Mauritius",
      "MUS+": "Republic of Mauritius",
      "MWI": "Malawi",
      "MWI+": "Republic of Malawi",
      "MYS": "Malaysia",
      "MYS+": "Malaysia",
      "MYT": "Mayotte",
      "MYT+": "Department of Mayotte",
      "NAM": "Namibia",
      "NAM+": "Republic of Namibia",
      "NCL": "New Caledonia",
      "NCL+": "New Caledonia",
      "NER": "Niger",
      "NER+": "Republic of Niger",
      "NFK": "Norfolk Island",
      "NFK+": "Territory of Norfolk Island",
      "NGA": "Nigeria",
      "NGA+": "Federal Republic of Nigeria",
      "NIC": "Nicaragua",
      "NIC+": "Republic of Nicaragua",
      "NIU": "Niue",
      "NIU+": "Niue",
      "NLD": "Netherlands",
      "NLD+": "Kingdom of the Netherlands",
      "NOR": "Norway",
      "NOR+": "Kingdom of Norway",
      "NPL": "Nepal",
      "NPL+": "Federal Democratic Republic of Nepal",
      "NRU": "Nauru",
      "NRU+": "Republic of Nauru",
      "NZL": "New Zealand",
      "NZL+": "New Zealand",
      "OMN": "Oman",
      "OMN+": "Sultanate of Oman",
      "PAK": "Pakistan",
      "PAK+": "Islamic Republic of Pakistan",
      "PAN": "Panama",
      "PAN+": "Republic of Panama",
      "PCN": "Pitcairn Islands",
      "PCN+": "Pitcairn Group of Islands",
      "PER": "Peru",
      "PER+": "Republic of Peru",
      "PHL": "Philippines",
      "PHL+": "Republic of the Philippines",
      "PLW": "Palau",
      "PLW+": "Republic of Palau",
      "PNG": "Papua New Guinea",
      "PNG+": "Independent State of Papua New Guinea",
      "POL": "Poland",
      "POL+": "Republic of Poland",
      "PRI": "Puerto Rico",
      "PRI+": "Commonwealth of Puerto Rico",
      "PRK": "North Korea",
      "PRK+": "Democratic People's Republic of Korea",
      "PRT": "Portugal",
      "PRT+": "Portuguese Republic",
      "PRY": "Paraguay",
      "PRY+": "Republic of Paraguay",
      "PSE": "Palestine",
      "PSE+": "State of Palestine",
      "PYF": "French Polynesia",
      "PYF+": "French Polynesia",
      "QAT": "Qatar",
      "QAT+": "State of Qatar",
      "REU": "Réunion",
      "REU+": "Réunion Island",
      "ROU": "Romania",
      "ROU+": "Romania",
      "RUS": "Russia",
      "RUS+": "Russian Federation",
      "RWA": "Rwanda",
      "RWA+": "Republic of Rwanda",
      "SAU": "Saudi Arabia",
      "SAU+": "Kingdom of Saudi Arabia",
      "SDN": "Sudan",
      "SDN+": "Republic of the Sudan",
      "SEN": "Senegal",
      "SEN+": "Republic of Senegal",
      "SGP": "Singapore",
      "SGP+": "Republic of Singapore",
      "SGS": "South Georgia",
      "SGS+": "South Georgia and the South Sandwich Islands",
      "SHN": "Saint Helena, Ascension and Tristan da Cunha",
      "SHN+": "Saint Helena, Ascension and Tristan da Cunha",
      "SJM": "Svalbard and Jan Mayen",
      "SJM+": "Svalbard og Jan Mayen",
      "SLB": "Solomon Islands",
      "SLB+": "Solomon Islands",
      "SLE": "Sierra Leone",
      "SLE+": "Republic of Sierra Leone",
      "SLV": "El Salvador",
      "SLV+": "Republic of El Salvador",
      "SMR": "San Marino",
      "SMR+": "Republic of San Marino",
      "SOM": "Somalia",
      "SOM+": "Federal Republic of Somalia",
      "SPM": "Saint Pierre and Miquelon",
      "SPM+": "Saint Pierre and Miquelon",
      "SRB": "Serbia",
      "SRB+": "Republic of Serbia",
      "SSD": "South Sudan",
      "SSD+": "Republic of South Sudan",
      "STP": "São Tomé and Príncipe",
      "STP+": "Democratic Republic of São Tomé and Príncipe",
      "SUR": "Suriname",
      "SUR+": "Republic of Suriname",
      "SVK": "Slovakia",
      "SVK+": "Slovak Republic",
      "SVN": "Slovenia",
      "SVN+": "Republic of Slovenia",
      "SWE": "Sweden",
      "SWE+": "Kingdom of Sweden",
      "SWZ": "Eswatini",
      "SWZ+": "Kingdom of Eswatini",
      "SXM": "Sint Maarten",
      "SXM+": "Sint Maarten",
      "SYC": "Seychelles",
      "SYC+": "Republic of Seychelles",
      "SYR": "Syria",
      "SYR+": "Syrian Arab Republic",
      "TCA": "Turks and Caicos Islands",
      "TCA+": "Turks and Caicos Islands",
      "TCD": "Chad",
      "TCD+": "Republic of Chad",
      "TGO": "Togo",
      "TGO+": "Togolese Republic",
      "THA": "Thailand",
      "THA+": "Kingdom of Thailand",
      "TJK": "Tajikistan",
      "TJK+": "Republic of Tajikistan",
      "TKL": "Tokelau",
      "TKL+": "Tokelau",
      "TKM": "Turkmenistan",
      "TKM+": "Turkmenistan",
      "TLS": "Timor-Leste",
      "TLS+": "Democratic Republic of Timor-Leste",
      "TON": "Tonga",
      "TON+": "Kingdom of Tonga",
      "TTO": "Trinidad and Tobago",
      "TTO+": "Republic of Trinidad and Tobago",
      "TUN": "Tunisia",
      "TUN+": "Tunisian Republic",
      "TUR": "Turkey",
      "TUR+": "Republic of Turkey",
      "TUV": "Tuvalu",
      "TUV+": "Tuvalu",
      "TWN": "Taiwan",
      "TWN+": "Republic of China (Taiwan)",
      "TZA": "Tanzania",
      "TZA+": "United Republic of Tanzania",
      "UGA": "Uganda",
      "UGA+": "Republic of Uganda",
      "UKR": "Ukraine",
      "UKR+": "Ukraine",
      "UMI": "United States Minor Outlying Islands",
      "UMI+": "United States Minor Outlying Islands",
      "UNK": "Kosovo",
      "UNK+": "Republic of Kosovo",
      "URY": "Uruguay",
      "URY+": "Oriental Republic of Uruguay",
      "USA": "United States",
      "USA+": "United States of America",
      "UZB": "Uzbekistan",
      "UZB+": "Republic of Uzbekistan",
      "VAT": "Vatican City",
      "VAT+": "Vatican City State",
      "VCT": "Saint Vincent and the Grenadines",
      "VCT+": "Saint Vincent and the Grenadines",
      "VEN": "Venezuela",
      "VEN+": "Bolivarian Republic of Venezuela",
      "VGB": "British Virgin Islands",
      "VGB+": "Virgin Islands",
      "VIR": "United States Virgin Islands",
      "VIR+": "Virgin Islands of the United States",
      "VNM": "Vietnam",
      "VNM+": "Socialist Republic of Vietnam",
      "VUT": "Vanuatu",
      "VUT+": "Republic of Vanuatu",
      "WLF": "Wallis and Futuna",
      "WLF+": "Territory of the Wallis and Futuna Islands",
      "WSM": "Samoa",
      "WSM+": "Independent State of Samoa",
      "YEM": "Yemen",
      "YEM+": "Republic of Yemen",
      "ZAF": "South Africa",
      "ZAF+": "Republic of South Africa",
      "ZMB": "Zambia",
      "ZMB+": "Republic of Zambia",
      "ZWE": "Zimbabwe",
      "ZWE+": "Republic of Zimbabwe",
    });
  }
}
