// This library translations are based on the data from the
// https://github.com/symfony/intl project
// (from The Symfony - Intl Component, Fabien Potencier) and from the
// https://github.com/umpirsky/country-list project (from Saša Stamenković).
// Both projects are licensed under the MIT License.

/// Provides country translations for different locales.
library l10n_countries;

import "src/data/aa_countries_l10n.data.dart";
import "src/data/ab_countries_l10n.data.dart";
import "src/data/af_countries_l10n.data.dart";
import "src/data/ak_countries_l10n.data.dart";
import "src/data/am_countries_l10n.data.dart";
import "src/data/an_countries_l10n.data.dart";
import "src/data/ar_countries_l10n.data.dart";
import "src/data/as_countries_l10n.data.dart";
import "src/data/av_countries_l10n.data.dart";
import "src/data/ay_countries_l10n.data.dart";
import "src/data/az_countries_l10n.data.dart";
import "src/data/az_cyrl_countries_l10n.data.dart";
import "src/data/ba_countries_l10n.data.dart";
import "src/data/be_countries_l10n.data.dart";
import "src/data/bg_countries_l10n.data.dart";
import "src/data/bh_countries_l10n.data.dart";
import "src/data/bi_countries_l10n.data.dart";
import "src/data/bm_countries_l10n.data.dart";
import "src/data/bm_latn_countries_l10n.data.dart";
import "src/data/bn_countries_l10n.data.dart";
import "src/data/bn_in_countries_l10n.data.dart";
import "src/data/bo_countries_l10n.data.dart";
import "src/data/br_countries_l10n.data.dart";
import "src/data/bs_countries_l10n.data.dart";
import "src/data/bs_cyrl_countries_l10n.data.dart";
import "src/data/ca_countries_l10n.data.dart";
import "src/data/ce_countries_l10n.data.dart";
import "src/data/ch_countries_l10n.data.dart";
import "src/data/co_countries_l10n.data.dart";
import "src/data/cs_countries_l10n.data.dart";
import "src/data/cu_countries_l10n.data.dart";
import "src/data/cv_countries_l10n.data.dart";
import "src/data/cy_countries_l10n.data.dart";
import "src/data/da_countries_l10n.data.dart";
import "src/data/de_countries_l10n.data.dart";
import "src/data/dv_countries_l10n.data.dart";
import "src/data/dz_countries_l10n.data.dart";
import "src/data/ee_countries_l10n.data.dart";
import "src/data/el_countries_l10n.data.dart";
import "src/data/en_countries_l10n.data.dart";
import "src/data/eo_countries_l10n.data.dart";
import "src/data/es_countries_l10n.data.dart";
import "src/data/et_countries_l10n.data.dart";
import "src/data/eu_countries_l10n.data.dart";
import "src/data/fa_countries_l10n.data.dart";
import "src/data/ff_countries_l10n.data.dart";
import "src/data/fi_countries_l10n.data.dart";
import "src/data/fj_countries_l10n.data.dart";
import "src/data/fo_countries_l10n.data.dart";
import "src/data/fr_countries_l10n.data.dart";
import "src/data/fy_countries_l10n.data.dart";
import "src/data/ga_countries_l10n.data.dart";
import "src/data/gd_countries_l10n.data.dart";
import "src/data/gl_countries_l10n.data.dart";
import "src/data/gn_countries_l10n.data.dart";
import "src/data/gu_countries_l10n.data.dart";
import "src/data/gv_countries_l10n.data.dart";
import "src/data/ha_countries_l10n.data.dart";
import "src/data/ha_latn_countries_l10n.data.dart";
import "src/data/he_countries_l10n.data.dart";
import "src/data/hi_countries_l10n.data.dart";
import "src/data/hr_countries_l10n.data.dart";
import "src/data/ht_countries_l10n.data.dart";
import "src/data/hu_countries_l10n.data.dart";
import "src/data/hy_countries_l10n.data.dart";
import "src/data/ia_countries_l10n.data.dart";
import "src/data/id_countries_l10n.data.dart";
import "src/data/ie_countries_l10n.data.dart";
import "src/data/ig_countries_l10n.data.dart";
import "src/data/ii_countries_l10n.data.dart";
import "src/data/ik_countries_l10n.data.dart";
import "src/data/io_countries_l10n.data.dart";
import "src/data/is_countries_l10n.data.dart";
import "src/data/it_countries_l10n.data.dart";
import "src/data/iu_countries_l10n.data.dart";
import "src/data/ja_countries_l10n.data.dart";
import "src/data/jv_countries_l10n.data.dart";
import "src/data/ka_countries_l10n.data.dart";
import "src/data/kg_countries_l10n.data.dart";
import "src/data/ki_countries_l10n.data.dart";
import "src/data/kk_countries_l10n.data.dart";
import "src/data/kk_cyrl_countries_l10n.data.dart";
import "src/data/kl_countries_l10n.data.dart";
import "src/data/km_countries_l10n.data.dart";
import "src/data/kn_countries_l10n.data.dart";
import "src/data/ko_countries_l10n.data.dart";
import "src/data/ks_arab_countries_l10n.data.dart";
import "src/data/ks_countries_l10n.data.dart";
import "src/data/ku_countries_l10n.data.dart";
import "src/data/kv_countries_l10n.data.dart";
import "src/data/kw_countries_l10n.data.dart";
import "src/data/ky_countries_l10n.data.dart";
import "src/data/ky_cyrl_countries_l10n.data.dart";
import "src/data/la_countries_l10n.data.dart";
import "src/data/lb_countries_l10n.data.dart";
import "src/data/lg_countries_l10n.data.dart";
import "src/data/li_countries_l10n.data.dart";
import "src/data/ln_countries_l10n.data.dart";
import "src/data/lo_countries_l10n.data.dart";
import "src/data/lt_countries_l10n.data.dart";
import "src/data/lu_countries_l10n.data.dart";
import "src/data/lv_countries_l10n.data.dart";
import "src/data/mg_countries_l10n.data.dart";
import "src/data/mi_countries_l10n.data.dart";
import "src/data/mk_countries_l10n.data.dart";
import "src/data/ml_countries_l10n.data.dart";
import "src/data/mn_countries_l10n.data.dart";
import "src/data/mn_cyrl_countries_l10n.data.dart";
import "src/data/mr_countries_l10n.data.dart";
import "src/data/ms_countries_l10n.data.dart";
import "src/data/ms_latn_countries_l10n.data.dart";
import "src/data/mt_countries_l10n.data.dart";
import "src/data/my_countries_l10n.data.dart";
import "src/data/na_countries_l10n.data.dart";
import "src/data/nb_countries_l10n.data.dart";
import "src/data/nd_countries_l10n.data.dart";
import "src/data/ne_countries_l10n.data.dart";
import "src/data/nl_countries_l10n.data.dart";
import "src/data/nn_countries_l10n.data.dart";
import "src/data/no_countries_l10n.data.dart";
import "src/data/nv_countries_l10n.data.dart";
import "src/data/ny_countries_l10n.data.dart";
import "src/data/oc_countries_l10n.data.dart";
import "src/data/om_countries_l10n.data.dart";
import "src/data/or_countries_l10n.data.dart";
import "src/data/os_countries_l10n.data.dart";
import "src/data/pa_arab_countries_l10n.data.dart";
import "src/data/pa_countries_l10n.data.dart";
import "src/data/pi_countries_l10n.data.dart";
import "src/data/pl_countries_l10n.data.dart";
import "src/data/ps_countries_l10n.data.dart";
import "src/data/ps_pk_countries_l10n.data.dart";
import "src/data/pt_countries_l10n.data.dart";
import "src/data/qu_countries_l10n.data.dart";
import "src/data/rm_countries_l10n.data.dart";
import "src/data/rn_countries_l10n.data.dart";
import "src/data/ro_countries_l10n.data.dart";
import "src/data/ro_md_countries_l10n.data.dart";
import "src/data/ru_countries_l10n.data.dart";
import "src/data/rw_countries_l10n.data.dart";
import "src/data/sa_countries_l10n.data.dart";
import "src/data/sc_countries_l10n.data.dart";
import "src/data/sd_countries_l10n.data.dart";
import "src/data/se_countries_l10n.data.dart";
import "src/data/se_fi_countries_l10n.data.dart";
import "src/data/sg_countries_l10n.data.dart";
import "src/data/si_countries_l10n.data.dart";
import "src/data/sk_countries_l10n.data.dart";
import "src/data/sl_countries_l10n.data.dart";
import "src/data/sm_countries_l10n.data.dart";
import "src/data/sn_countries_l10n.data.dart";
import "src/data/so_countries_l10n.data.dart";
import "src/data/sq_countries_l10n.data.dart";
import "src/data/sr_countries_l10n.data.dart";
import "src/data/ss_countries_l10n.data.dart";
import "src/data/st_countries_l10n.data.dart";
import "src/data/su_countries_l10n.data.dart";
import "src/data/sv_countries_l10n.data.dart";
import "src/data/sw_cd_countries_l10n.data.dart";
import "src/data/sw_countries_l10n.data.dart";
import "src/data/sw_ke_countries_l10n.data.dart";
import "src/data/ta_countries_l10n.data.dart";
import "src/data/te_countries_l10n.data.dart";
import "src/data/tg_countries_l10n.data.dart";
import "src/data/th_countries_l10n.data.dart";
import "src/data/ti_countries_l10n.data.dart";
import "src/data/tk_countries_l10n.data.dart";
import "src/data/tl_countries_l10n.data.dart";
import "src/data/tn_countries_l10n.data.dart";
import "src/data/to_countries_l10n.data.dart";
import "src/data/tr_countries_l10n.data.dart";
import "src/data/ts_countries_l10n.data.dart";
import "src/data/tt_countries_l10n.data.dart";
import "src/data/tw_countries_l10n.data.dart";
import "src/data/ty_countries_l10n.data.dart";
import "src/data/ug_arab_countries_l10n.data.dart";
import "src/data/ug_countries_l10n.data.dart";
import "src/data/uk_countries_l10n.data.dart";
import "src/data/ur_countries_l10n.data.dart";
import "src/data/uz_countries_l10n.data.dart";
import "src/data/uz_cyrl_countries_l10n.data.dart";
import "src/data/ve_countries_l10n.data.dart";
import "src/data/vi_countries_l10n.data.dart";
import "src/data/vo_countries_l10n.data.dart";
import "src/data/wa_countries_l10n.data.dart";
import "src/data/wo_countries_l10n.data.dart";
import "src/data/xh_countries_l10n.data.dart";
import "src/data/yi_countries_l10n.data.dart";
import "src/data/yo_bj_countries_l10n.data.dart";
import "src/data/yo_countries_l10n.data.dart";
import "src/data/za_countries_l10n.data.dart";
import "src/data/zh_countries_l10n.data.dart";
import "src/data/zu_countries_l10n.data.dart";
import "src/iso_locale_mapper.dart";

export "src/data/aa_countries_l10n.data.dart";
export "src/data/ab_countries_l10n.data.dart";
export "src/data/af_countries_l10n.data.dart";
export "src/data/ak_countries_l10n.data.dart";
export "src/data/am_countries_l10n.data.dart";
export "src/data/an_countries_l10n.data.dart";
export "src/data/ar_countries_l10n.data.dart";
export "src/data/as_countries_l10n.data.dart";
export "src/data/av_countries_l10n.data.dart";
export "src/data/ay_countries_l10n.data.dart";
export "src/data/az_countries_l10n.data.dart";
export "src/data/az_cyrl_countries_l10n.data.dart";
export "src/data/ba_countries_l10n.data.dart";
export "src/data/be_countries_l10n.data.dart";
export "src/data/bg_countries_l10n.data.dart";
export "src/data/bh_countries_l10n.data.dart";
export "src/data/bi_countries_l10n.data.dart";
export "src/data/bm_countries_l10n.data.dart";
export "src/data/bm_latn_countries_l10n.data.dart";
export "src/data/bn_countries_l10n.data.dart";
export "src/data/bn_in_countries_l10n.data.dart";
export "src/data/bo_countries_l10n.data.dart";
export "src/data/br_countries_l10n.data.dart";
export "src/data/bs_countries_l10n.data.dart";
export "src/data/bs_cyrl_countries_l10n.data.dart";
export "src/data/ca_countries_l10n.data.dart";
export "src/data/ce_countries_l10n.data.dart";
export "src/data/ch_countries_l10n.data.dart";
export "src/data/co_countries_l10n.data.dart";
export "src/data/cs_countries_l10n.data.dart";
export "src/data/cu_countries_l10n.data.dart";
export "src/data/cv_countries_l10n.data.dart";
export "src/data/cy_countries_l10n.data.dart";
export "src/data/da_countries_l10n.data.dart";
export "src/data/de_countries_l10n.data.dart";
export "src/data/dv_countries_l10n.data.dart";
export "src/data/dz_countries_l10n.data.dart";
export "src/data/ee_countries_l10n.data.dart";
export "src/data/el_countries_l10n.data.dart";
export "src/data/en_countries_l10n.data.dart";
export "src/data/eo_countries_l10n.data.dart";
export "src/data/es_countries_l10n.data.dart";
export "src/data/et_countries_l10n.data.dart";
export "src/data/eu_countries_l10n.data.dart";
export "src/data/fa_countries_l10n.data.dart";
export "src/data/ff_countries_l10n.data.dart";
export "src/data/fi_countries_l10n.data.dart";
export "src/data/fj_countries_l10n.data.dart";
export "src/data/fo_countries_l10n.data.dart";
export "src/data/fr_countries_l10n.data.dart";
export "src/data/fy_countries_l10n.data.dart";
export "src/data/ga_countries_l10n.data.dart";
export "src/data/gd_countries_l10n.data.dart";
export "src/data/gl_countries_l10n.data.dart";
export "src/data/gn_countries_l10n.data.dart";
export "src/data/gu_countries_l10n.data.dart";
export "src/data/gv_countries_l10n.data.dart";
export "src/data/ha_countries_l10n.data.dart";
export "src/data/ha_latn_countries_l10n.data.dart";
export "src/data/he_countries_l10n.data.dart";
export "src/data/hi_countries_l10n.data.dart";
export "src/data/hr_countries_l10n.data.dart";
export "src/data/ht_countries_l10n.data.dart";
export "src/data/hu_countries_l10n.data.dart";
export "src/data/hy_countries_l10n.data.dart";
export "src/data/ia_countries_l10n.data.dart";
export "src/data/id_countries_l10n.data.dart";
export "src/data/ie_countries_l10n.data.dart";
export "src/data/ig_countries_l10n.data.dart";
export "src/data/ii_countries_l10n.data.dart";
export "src/data/ik_countries_l10n.data.dart";
export "src/data/io_countries_l10n.data.dart";
export "src/data/is_countries_l10n.data.dart";
export "src/data/it_countries_l10n.data.dart";
export "src/data/iu_countries_l10n.data.dart";
export "src/data/ja_countries_l10n.data.dart";
export "src/data/jv_countries_l10n.data.dart";
export "src/data/ka_countries_l10n.data.dart";
export "src/data/kg_countries_l10n.data.dart";
export "src/data/ki_countries_l10n.data.dart";
export "src/data/kk_countries_l10n.data.dart";
export "src/data/kk_cyrl_countries_l10n.data.dart";
export "src/data/kl_countries_l10n.data.dart";
export "src/data/km_countries_l10n.data.dart";
export "src/data/kn_countries_l10n.data.dart";
export "src/data/ko_countries_l10n.data.dart";
export "src/data/ks_arab_countries_l10n.data.dart";
export "src/data/ks_countries_l10n.data.dart";
export "src/data/ku_countries_l10n.data.dart";
export "src/data/kv_countries_l10n.data.dart";
export "src/data/kw_countries_l10n.data.dart";
export "src/data/ky_countries_l10n.data.dart";
export "src/data/ky_cyrl_countries_l10n.data.dart";
export "src/data/la_countries_l10n.data.dart";
export "src/data/lb_countries_l10n.data.dart";
export "src/data/lg_countries_l10n.data.dart";
export "src/data/li_countries_l10n.data.dart";
export "src/data/ln_countries_l10n.data.dart";
export "src/data/lo_countries_l10n.data.dart";
export "src/data/lt_countries_l10n.data.dart";
export "src/data/lu_countries_l10n.data.dart";
export "src/data/lv_countries_l10n.data.dart";
export "src/data/mg_countries_l10n.data.dart";
export "src/data/mi_countries_l10n.data.dart";
export "src/data/mk_countries_l10n.data.dart";
export "src/data/ml_countries_l10n.data.dart";
export "src/data/mn_countries_l10n.data.dart";
export "src/data/mn_cyrl_countries_l10n.data.dart";
export "src/data/mr_countries_l10n.data.dart";
export "src/data/ms_countries_l10n.data.dart";
export "src/data/ms_latn_countries_l10n.data.dart";
export "src/data/mt_countries_l10n.data.dart";
export "src/data/my_countries_l10n.data.dart";
export "src/data/na_countries_l10n.data.dart";
export "src/data/nb_countries_l10n.data.dart";
export "src/data/nd_countries_l10n.data.dart";
export "src/data/ne_countries_l10n.data.dart";
export "src/data/nl_countries_l10n.data.dart";
export "src/data/nn_countries_l10n.data.dart";
export "src/data/no_countries_l10n.data.dart";
export "src/data/nv_countries_l10n.data.dart";
export "src/data/ny_countries_l10n.data.dart";
export "src/data/oc_countries_l10n.data.dart";
export "src/data/om_countries_l10n.data.dart";
export "src/data/or_countries_l10n.data.dart";
export "src/data/os_countries_l10n.data.dart";
export "src/data/pa_arab_countries_l10n.data.dart";
export "src/data/pa_countries_l10n.data.dart";
export "src/data/pi_countries_l10n.data.dart";
export "src/data/pl_countries_l10n.data.dart";
export "src/data/ps_countries_l10n.data.dart";
export "src/data/ps_pk_countries_l10n.data.dart";
export "src/data/pt_countries_l10n.data.dart";
export "src/data/qu_countries_l10n.data.dart";
export "src/data/rm_countries_l10n.data.dart";
export "src/data/rn_countries_l10n.data.dart";
export "src/data/ro_countries_l10n.data.dart";
export "src/data/ro_md_countries_l10n.data.dart";
export "src/data/ru_countries_l10n.data.dart";
export "src/data/rw_countries_l10n.data.dart";
export "src/data/sa_countries_l10n.data.dart";
export "src/data/sc_countries_l10n.data.dart";
export "src/data/sd_countries_l10n.data.dart";
export "src/data/se_countries_l10n.data.dart";
export "src/data/se_fi_countries_l10n.data.dart";
export "src/data/sg_countries_l10n.data.dart";
export "src/data/si_countries_l10n.data.dart";
export "src/data/sk_countries_l10n.data.dart";
export "src/data/sl_countries_l10n.data.dart";
export "src/data/sm_countries_l10n.data.dart";
export "src/data/sn_countries_l10n.data.dart";
export "src/data/so_countries_l10n.data.dart";
export "src/data/sq_countries_l10n.data.dart";
export "src/data/sr_countries_l10n.data.dart";
export "src/data/ss_countries_l10n.data.dart";
export "src/data/st_countries_l10n.data.dart";
export "src/data/su_countries_l10n.data.dart";
export "src/data/sv_countries_l10n.data.dart";
export "src/data/sw_cd_countries_l10n.data.dart";
export "src/data/sw_countries_l10n.data.dart";
export "src/data/sw_ke_countries_l10n.data.dart";
export "src/data/ta_countries_l10n.data.dart";
export "src/data/te_countries_l10n.data.dart";
export "src/data/tg_countries_l10n.data.dart";
export "src/data/th_countries_l10n.data.dart";
export "src/data/ti_countries_l10n.data.dart";
export "src/data/tk_countries_l10n.data.dart";
export "src/data/tl_countries_l10n.data.dart";
export "src/data/tn_countries_l10n.data.dart";
export "src/data/to_countries_l10n.data.dart";
export "src/data/tr_countries_l10n.data.dart";
export "src/data/ts_countries_l10n.data.dart";
export "src/data/tt_countries_l10n.data.dart";
export "src/data/tw_countries_l10n.data.dart";
export "src/data/ty_countries_l10n.data.dart";
export "src/data/ug_arab_countries_l10n.data.dart";
export "src/data/ug_countries_l10n.data.dart";
export "src/data/uk_countries_l10n.data.dart";
export "src/data/ur_countries_l10n.data.dart";
export "src/data/uz_countries_l10n.data.dart";
export "src/data/uz_cyrl_countries_l10n.data.dart";
export "src/data/ve_countries_l10n.data.dart";
export "src/data/vi_countries_l10n.data.dart";
export "src/data/vo_countries_l10n.data.dart";
export "src/data/wa_countries_l10n.data.dart";
export "src/data/wo_countries_l10n.data.dart";
export "src/data/xh_countries_l10n.data.dart";
export "src/data/yi_countries_l10n.data.dart";
export "src/data/yo_bj_countries_l10n.data.dart";
export "src/data/yo_countries_l10n.data.dart";
export "src/data/za_countries_l10n.data.dart";
export "src/data/zh_countries_l10n.data.dart";
export "src/data/zu_countries_l10n.data.dart";
export "src/iso_locale_mapper.dart";

/// Provides country names translations for different locales.
// ignore: prefer-match-file-name, it's main library file.
class CountriesLocaleMapper extends IsoLocaleMapper<IsoLocaleMapper<String>> {
  /// Provides names translations for 193 locales, with the option to
  /// add more translations via the [other] parameter.
  // ignore: avoid-non-empty-constructor-bodies,on purpose.
  CountriesLocaleMapper({Map<String, IsoLocaleMapper<String>>? other}) {
    map.addAll({
      "aa": AaCountriesL10N(),
      "ab": AbCountriesL10N(),
      "af": AfCountriesL10N(),
      "ak": AkCountriesL10N(),
      "am": AmCountriesL10N(),
      "an": AnCountriesL10N(),
      "ar": ArCountriesL10N(),
      "as": AsCountriesL10N(),
      "av": AvCountriesL10N(),
      "ay": AyCountriesL10N(),
      "az": AzCountriesL10N(),
      "az_Cyrl": AzCyrlCountriesL10N(),
      "ba": BaCountriesL10N(),
      "be": BeCountriesL10N(),
      "bg": BgCountriesL10N(),
      "bh": BhCountriesL10N(),
      "bi": BiCountriesL10N(),
      "bm": BmCountriesL10N(),
      "bm_Latn": BmLatnCountriesL10N(),
      "bn": BnCountriesL10N(),
      "bn_IN": BnInCountriesL10N(),
      "bo": BoCountriesL10N(),
      "br": BrCountriesL10N(),
      "bs": BsCountriesL10N(),
      "bs_Cyrl": BsCyrlCountriesL10N(),
      "ca": CaCountriesL10N(),
      "ce": CeCountriesL10N(),
      "ch": ChCountriesL10N(),
      "co": CoCountriesL10N(),
      "cs": CsCountriesL10N(),
      "cu": CuCountriesL10N(),
      "cv": CvCountriesL10N(),
      "cy": CyCountriesL10N(),
      "da": DaCountriesL10N(),
      "de": DeCountriesL10N(),
      "dv": DvCountriesL10N(),
      "dz": DzCountriesL10N(),
      "ee": EeCountriesL10N(),
      "el": ElCountriesL10N(),
      "en": EnCountriesL10N(),
      "eo": EoCountriesL10N(),
      "es": EsCountriesL10N(),
      "et": EtCountriesL10N(),
      "eu": EuCountriesL10N(),
      "fa": FaCountriesL10N(),
      "ff": FfCountriesL10N(),
      "fi": FiCountriesL10N(),
      "fj": FjCountriesL10N(),
      "fo": FoCountriesL10N(),
      "fr": FrCountriesL10N(),
      "fy": FyCountriesL10N(),
      "ga": GaCountriesL10N(),
      "gd": GdCountriesL10N(),
      "gl": GlCountriesL10N(),
      "gn": GnCountriesL10N(),
      "gu": GuCountriesL10N(),
      "gv": GvCountriesL10N(),
      "ha": HaCountriesL10N(),
      "ha_Latn": HaLatnCountriesL10N(),
      "he": HeCountriesL10N(),
      "hi": HiCountriesL10N(),
      "hr": HrCountriesL10N(),
      "ht": HtCountriesL10N(),
      "hu": HuCountriesL10N(),
      "hy": HyCountriesL10N(),
      "ia": IaCountriesL10N(),
      "id": IdCountriesL10N(),
      "ie": IeCountriesL10N(),
      "ig": IgCountriesL10N(),
      "ii": IiCountriesL10N(),
      "ik": IkCountriesL10N(),
      "io": IoCountriesL10N(),
      "is": IsCountriesL10N(),
      "it": ItCountriesL10N(),
      "iu": IuCountriesL10N(),
      "ja": JaCountriesL10N(),
      "jv": JvCountriesL10N(),
      "ka": KaCountriesL10N(),
      "kg": KgCountriesL10N(),
      "ki": KiCountriesL10N(),
      "kk": KkCountriesL10N(),
      "kk_Cyrl": KkCyrlCountriesL10N(),
      "kl": KlCountriesL10N(),
      "km": KmCountriesL10N(),
      "kn": KnCountriesL10N(),
      "ko": KoCountriesL10N(),
      "ks": KsCountriesL10N(),
      "ks_Arab": KsArabCountriesL10N(),
      "ku": KuCountriesL10N(),
      "kv": KvCountriesL10N(),
      "kw": KwCountriesL10N(),
      "ky": KyCountriesL10N(),
      "ky_Cyrl": KyCyrlCountriesL10N(),
      "la": LaCountriesL10N(),
      "lb": LbCountriesL10N(),
      "lg": LgCountriesL10N(),
      "li": LiCountriesL10N(),
      "ln": LnCountriesL10N(),
      "lo": LoCountriesL10N(),
      "lt": LtCountriesL10N(),
      "lu": LuCountriesL10N(),
      "lv": LvCountriesL10N(),
      "mg": MgCountriesL10N(),
      "mi": MiCountriesL10N(),
      "mk": MkCountriesL10N(),
      "ml": MlCountriesL10N(),
      "mn": MnCountriesL10N(),
      "mn_Cyrl": MnCyrlCountriesL10N(),
      "mr": MrCountriesL10N(),
      "ms": MsCountriesL10N(),
      "ms_Latn": MsLatnCountriesL10N(),
      "mt": MtCountriesL10N(),
      "my": MyCountriesL10N(),
      "na": NaCountriesL10N(),
      "nb": NbCountriesL10N(),
      "nd": NdCountriesL10N(),
      "ne": NeCountriesL10N(),
      "nl": NlCountriesL10N(),
      "nn": NnCountriesL10N(),
      "no": NoCountriesL10N(),
      "nv": NvCountriesL10N(),
      "ny": NyCountriesL10N(),
      "oc": OcCountriesL10N(),
      "om": OmCountriesL10N(),
      "or": OrCountriesL10N(),
      "os": OsCountriesL10N(),
      "pa": PaCountriesL10N(),
      "pa_Arab": PaArabCountriesL10N(),
      "pi": PiCountriesL10N(),
      "pl": PlCountriesL10N(),
      "ps": PsCountriesL10N(),
      "ps_PK": PsPkCountriesL10N(),
      "pt": PtCountriesL10N(),
      "qu": QuCountriesL10N(),
      "rm": RmCountriesL10N(),
      "rn": RnCountriesL10N(),
      "ro": RoCountriesL10N(),
      "ro_MD": RoMdCountriesL10N(),
      "ru": RuCountriesL10N(),
      "rw": RwCountriesL10N(),
      "sa": SaCountriesL10N(),
      "sc": ScCountriesL10N(),
      "sd": SdCountriesL10N(),
      "se": SeCountriesL10N(),
      "se_FI": SeFiCountriesL10N(),
      "sg": SgCountriesL10N(),
      "si": SiCountriesL10N(),
      "sk": SkCountriesL10N(),
      "sl": SlCountriesL10N(),
      "sm": SmCountriesL10N(),
      "sn": SnCountriesL10N(),
      "so": SoCountriesL10N(),
      "sq": SqCountriesL10N(),
      "sr": SrCountriesL10N(),
      "ss": SsCountriesL10N(),
      "st": StCountriesL10N(),
      "su": SuCountriesL10N(),
      "sv": SvCountriesL10N(),
      "sw": SwCountriesL10N(),
      "sw_CD": SwCdCountriesL10N(),
      "sw_KE": SwKeCountriesL10N(),
      "ta": TaCountriesL10N(),
      "te": TeCountriesL10N(),
      "tg": TgCountriesL10N(),
      "th": ThCountriesL10N(),
      "ti": TiCountriesL10N(),
      "tk": TkCountriesL10N(),
      "tl": TlCountriesL10N(),
      "tn": TnCountriesL10N(),
      "to": ToCountriesL10N(),
      "tr": TrCountriesL10N(),
      "ts": TsCountriesL10N(),
      "tt": TtCountriesL10N(),
      "tw": TwCountriesL10N(),
      "ty": TyCountriesL10N(),
      "ug": UgCountriesL10N(),
      "ug_Arab": UgArabCountriesL10N(),
      "uk": UkCountriesL10N(),
      "ur": UrCountriesL10N(),
      "uz": UzCountriesL10N(),
      "uz_Cyrl": UzCyrlCountriesL10N(),
      "ve": VeCountriesL10N(),
      "vi": ViCountriesL10N(),
      "vo": VoCountriesL10N(),
      "wa": WaCountriesL10N(),
      "wo": WoCountriesL10N(),
      "xh": XhCountriesL10N(),
      "yi": YiCountriesL10N(),
      "yo": YoCountriesL10N(),
      "yo_BJ": YoBjCountriesL10N(),
      "za": ZaCountriesL10N(),
      "zh": ZhCountriesL10N(),
      "zu": ZuCountriesL10N(),
      ...?other,
    });
  }

  /// The symbol used to identify the alternative/full name of the ISO object.
  static const symbol = "+";

  /// Localizes a set of ISO codes into names (to specified locale if needed).
  ///
  /// Parameters:
  /// - [isoCodes]: Set of ISO codes to be localized.
  /// - [altSymbol]: Optional symbol for alternative (full) name translations.
  /// - [fallbackLocale]: Optional secondary locale for translations.
  /// - [mainLocale]: Optional primary locale for translations.
  /// - [useLanguageFallback]: Whether to try language-only codes if specified
  /// locale not found (i.e. 'en_US' -> 'en').
  /// - [formatter]: Optional callback to modify each translation.
  ///
  /// Returns a [Map] containing the localized names for the provided ISO
  /// codes.
  ///
  /// Example:
  /// ```dart
  /// final map = mapper.localize({'FRA', 'RUS'}, mainLocale: 'en');
  /// ```
  LocaleMap localize(
    Set<String> isoCodes, {
    String? altSymbol,
    Object? fallbackLocale,
    Object? mainLocale,
    bool useLanguageFallback = true,
    String Function(LocaleKey isoLocale, String l10n)? formatter,
  }) {
    if (isoCodes.isEmpty) return const {};
    final locale = mainLocale?.toString();
    final altLocale = fallbackLocale?.toString();

    final localeData = extract(
      locale == null
          ? null
          : {
              ..._localesSet(locale, useLanguageFallback: useLanguageFallback),
              if (altLocale != null)
                ..._localesSet(
                  altLocale,
                  useLanguageFallback: useLanguageFallback,
                ),
            },
    );

    return switch (localeData.length) {
      0 => const {},
      1 => _fromSingle(
        isoCodes,
        localeData.entries.first,
        altSymbol ?? symbol,
        formatter,
      ),
      _ => _fromMultiple(isoCodes, localeData, altSymbol ?? symbol, formatter),
    };
  }

  static Set<String> _localesSet(
    String locale, {
    required bool useLanguageFallback,
  }) =>
      // ignore: avoid-substring, locale should has no emoji.
      {locale, if (useLanguageFallback) locale.substring(0, 2)};

  static MapEntry<LocaleKey, String> _mapSingle(
    String Function(LocaleKey isoLocale, String l10n)? formatter,
    String locale, {
    required String code,
    required String l10n,
  }) {
    final isoLocale = (isoCode: code, locale: locale);

    return MapEntry(isoLocale, formatter?.call(isoLocale, l10n) ?? l10n);
  }

  LocaleMap _fromSingle(
    Set<String> codes,
    MapEntry<String, IsoLocaleMapper<String>> localeEntry,
    String altSymbol,
    String Function(LocaleKey isoLocale, String l10n)? formatter,
  ) {
    final locale = localeEntry.key;
    final results = localeEntry.value
        .extract(codes, altSymbol: altSymbol)
        .map(
          (code, l10n) => _mapSingle(formatter, locale, code: code, l10n: l10n),
        );
    localeEntry.value.map.clear();
    map.clear();

    return LocaleMap.unmodifiable(results);
  }

  LocaleMap _fromMultiple(
    Set<String> codes,
    Map<String, IsoLocaleMapper<String>> localesData,
    String altSymbol,
    String Function(LocaleKey isoLocale, String l10n)? formatter,
  ) {
    final results = <LocaleKey, String>{};

    for (final localeEntry in localesData.entries) {
      final translations = localeEntry.value.extract(
        codes,
        altSymbol: altSymbol,
      );

      for (final code in codes) {
        final key = (isoCode: code, locale: localeEntry.key);
        if (results[key] == null) {
          final l10n = translations[code];
          if (l10n != null) {
            final mainLocale = (isoCode: code, locale: localeEntry.key);
            results[key] = formatter?.call(mainLocale, l10n) ?? l10n;
          }
        }

        final secondary = altKey(code, altSymbol);
        if (secondary == null) continue;

        final alternative = (isoCode: secondary, locale: localeEntry.key);
        if (results[alternative] != null) continue;

        final altL10n = translations[secondary];
        if (altL10n != null) {
          final altLocale = (isoCode: code, locale: localeEntry.key);
          results[alternative] = formatter?.call(altLocale, altL10n) ?? altL10n;
        }
      }

      localeEntry.value.map.clear();
    }
    map.clear();

    return LocaleMap.unmodifiable(results);
  }
}
