# Contributing

We're always happy to receive improvements and fixes, so please submit them whenever you can! A few key points are listed below.

> Many feature additions are more suitable for plugins, instead of being added to the core. This is aimed to reduce the future maintenance burden/cost on the maintainers.  
If we deny your PR for this reason, please do consider publishing a plugin, and we'll be happy to add it to the [Plugins List](https://docs.fleaflet.dev/plugins/list)! See [Making A Plugin](https://docs.fleaflet.dev/plugins/making-a-plugin) for more information.

* **If your PR will add a major or breaking change, please discuss it with us first, via the Issue Tracker.**  
We don't want to waste your time if we think it's more appropriate for a plugin, and it helps to make a clear plan before starting work.
Additionally, if your PR makes breaking changes, or depends on another breaking commit, we may have some additional guidance.

* **Create a draft PR as soon as work starts, and take it out of draft status when ready for review.**  
Keep everyone in the loop, so no-one tries working on the same thing as you.

* **Don't change the package version, GitHub workflows, lints, or any other meta files without clarification.**  
We rely on a standardized process and procedure to ensure top-quality releases.

* **Use a clear (preferably [Conventional](https://www.conventionalcommits.org/)) PR title.**  
This makes it easier for us to group commits for release and write correct CHANGELOGs.
