// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => '是';

  @override
  String get add => '加入产品';

  @override
  String get account_delete_message => '您確定要刪除您的帳戶嗎？\n如果有具體原因，請在下方分享';

  @override
  String get reason => '原因';

  @override
  String get okay => '確定';

  @override
  String get validate => '驗證';

  @override
  String get create => '创建';

  @override
  String get applyButtonText => '套用';

  @override
  String get next_label => '下一個';

  @override
  String get continue_label => '继续';

  @override
  String get exit_label => 'Exit';

  @override
  String get previous_label => '前一頁';

  @override
  String get go_back_to_top => '回到頂端';

  @override
  String get save => '儲存';

  @override
  String get save_confirmation => '您確定要存檔嗎？';

  @override
  String get skip => '略過';

  @override
  String get cancel => '取消';

  @override
  String get ignore => '忽略';

  @override
  String get close => '關閉';

  @override
  String get no => '否';

  @override
  String get stop => '停止';

  @override
  String get finish => '完成';

  @override
  String get calculate => '計算';

  @override
  String get reset_food_prefs => '重新設定食物偏好選項？';

  @override
  String get error => '出错';

  @override
  String get error_occurred => '发生错误';

  @override
  String get featureInProgress => '我們仍在開發此功能，敬請期待';

  @override
  String get label_web => '在瀏覽器上查看';

  @override
  String get learnMore => '瞭解更多';

  @override
  String get unknown => '未知';

  @override
  String get match_very_good => '优秀的配对';

  @override
  String get match_good => '不错的配对';

  @override
  String get match_poor => '较差的配对';

  @override
  String get match_may_not => '可能不匹配';

  @override
  String get match_does_not => '不匹配';

  @override
  String get match_unknown => '未知匹配';

  @override
  String get match_short_very_good => '优秀的配对';

  @override
  String get match_short_good => '不错的配对';

  @override
  String get match_short_poor => '较差的配对';

  @override
  String get match_short_may_not => '可能不匹配';

  @override
  String get match_short_does_not => '不匹配';

  @override
  String get match_short_unknown => '未知匹配';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => '尋找';

  @override
  String get welcomeToOpenFoodFacts => '歡迎來到 Open Food Facts';

  @override
  String get whatIsOff => 'Open Food Facts 是一个由当地社区推动的全球性非营利组织。';

  @override
  String get productDataUtility => '查看與您的偏好相關的食物資料。';

  @override
  String get healthCardUtility => '選擇對您有益的食物。';

  @override
  String get ecoCardUtility => '選擇對地球有益的食物。';

  @override
  String get server_error_open_new_issue => '服务器无响应！您可以使用以下链接反馈问题。';

  @override
  String get sign_in_text => '登录您的 Open Food Facts 账号以保存您的贡献';

  @override
  String get incorrect_credentials => '使用者名稱或密碼錯誤。';

  @override
  String get password_lost_incorrect_credentials => '此电子邮件或用户名不存在。请检查您的登录信息。';

  @override
  String get password_lost_server_unavailable => '我们的服务器目前速度缓慢，对此我们深表歉意。请稍后重试。';

  @override
  String get login => '用戶名';

  @override
  String get login_result_type_server_unreachable => '网络无法访问';

  @override
  String get login_result_type_server_issue => '服务器出现问题。请稍后再试。';

  @override
  String get login_page_username_or_email => '請輸入使用者名稱或電子郵件';

  @override
  String get login_page_password_error_empty => '請輸入密碼';

  @override
  String get create_account => '創建帳號';

  @override
  String get sign_in => '登录';

  @override
  String get sign_in_mandatory => '對於該功能，我們需要您先登入。';

  @override
  String get help_improve_country => '帮助改善您所在国家/地区的 Open Food Facts';

  @override
  String get sign_out => '登出';

  @override
  String get sign_out_confirmation => '確定要登出嗎?';

  @override
  String get password => '密码';

  @override
  String get forgot_password => '忘记密码';

  @override
  String get forgot_password_question => '忘記密碼？';

  @override
  String get view_profile => '檢視個人檔案';

  @override
  String get reset_password => '重置密码';

  @override
  String get reset_password_explanation_text =>
      '如果忘記密碼，請輸入您的使用者名稱或電子郵件地址以接收重置密碼的步驟說明。另外，記得檢查垃圾郵件的文件夾。';

  @override
  String get username_or_email => '使用者名稱或電子郵件地址';

  @override
  String get reset_password_done =>
      '一封含有重設密碼連結的電子郵件已寄給您的帳戶中所設定的電子郵件地址。另外，請檢查垃圾郵件。';

  @override
  String get send_reset_password_mail => '修改密碼';

  @override
  String get enter_some_text => '請輸入內容';

  @override
  String get sign_up_page_title => '注册';

  @override
  String get sign_up_page_action_button => '注册';

  @override
  String get sign_up_page_action_doing_it => '註冊中…';

  @override
  String get sign_up_page_action_ok => '恭喜！您已經成功創建帳號。';

  @override
  String get sign_up_page_display_name_hint => '名称';

  @override
  String get sign_up_page_display_name_error_empty => '請輸入您想要使用的顯示名稱';

  @override
  String get sign_up_page_email_hint => '電子郵件';

  @override
  String get sign_up_page_email_error_empty => '電子郵件（必填）';

  @override
  String get sign_up_page_email_error_invalid => '電子信箱無效';

  @override
  String get sign_up_page_username_hint => '使用者名稱：公開可見';

  @override
  String get sign_up_page_username_error_empty => '請填入使用者名稱';

  @override
  String get sign_up_page_username_error_invalid => '請輸入一個有效的使用者名稱';

  @override
  String get sign_up_page_username_description => '使用者名稱不能包含空格、大寫字母或特殊字符';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return '使用者名稱的長度不能超過 $value 個字元';
  }

  @override
  String get sign_up_page_password_hint => '密码';

  @override
  String get sign_up_page_password_error_empty => '請輸入密碼';

  @override
  String get sign_up_page_password_error_invalid => '請輸入有效密碼（至少 6 個字元）';

  @override
  String get sign_up_page_confirm_password_hint => '再次輸入密碼';

  @override
  String get sign_up_page_confirm_password_error_empty => '請再次輸入密碼';

  @override
  String get sign_up_page_confirm_password_error_invalid => '密碼錯誤';

  @override
  String get sign_up_page_agree_text => '我同意 Open Food Facts ';

  @override
  String get sign_up_page_terms_text => '使用及貢獻條款';

  @override
  String get donate_url =>
      'https://world-zh.openfoodfacts.org/donate-to-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      '創建帳號時，必須同意使用條款，但是您仍然可以通過應用程式進行匿名捐款';

  @override
  String get sign_up_page_producer_checkbox => '我是食品生產商';

  @override
  String get sign_up_page_producer_hint => '生產商/品牌';

  @override
  String get sign_up_page_producer_error_empty => '請輸入生產商或品牌名稱';

  @override
  String get sign_up_page_subscribe_checkbox =>
      '我想订阅 Open Food Facts 的最新动态（您可以随时取消订阅）';

  @override
  String get sign_up_page_user_name_already_used => '這個使用者名稱已存在，請改用其他名稱。';

  @override
  String get sign_up_page_email_already_exists => '已經存在，請直接登入、或改用其他電子郵件。';

  @override
  String get sign_up_page_provide_valid_email => '請提供有效的電子郵件地址。';

  @override
  String get sign_up_page_server_busy => '非常抱歉，创建您的帐户时遇到了一些技术问题。请稍后重试。';

  @override
  String get settingsTitle => '設定';

  @override
  String get darkmode => '主題';

  @override
  String get darkmode_dark => '深色';

  @override
  String get darkmode_light => '淺色';

  @override
  String get darkmode_system_default => '系統預設值';

  @override
  String get thanks_for_contributing => '感谢您的贡献！';

  @override
  String get contributors_label => '他们正在开发应用程序';

  @override
  String get contributors_dialog_title => '合作者';

  @override
  String contributors_dialog_entry_description(Object name) {
    return '贡献者：$name';
  }

  @override
  String get contributors_description => '此应用程序所有贡献者的列表';

  @override
  String get support => '支持';

  @override
  String get support_join_slack => '在我们的 Slack 频道寻求帮助';

  @override
  String get support_via_forum => '在論壇上尋求幫助';

  @override
  String get support_via_email => '給我們傳送電子郵件';

  @override
  String get support_via_email_include_logs_dialog_title => '要將紀錄送出嗎？';

  @override
  String get support_via_email_include_logs_dialog_body =>
      '您是否希望將應用程式紀錄附在電子郵件中？';

  @override
  String get termsOfUse => '使用条款';

  @override
  String get legalNotices => '法律声明';

  @override
  String get privacy_policy => '隐私政策';

  @override
  String get about_this_app => '關於本程式';

  @override
  String get contribute => '貢獻';

  @override
  String get contribute_sw_development => '軟體開發';

  @override
  String get contribute_develop_text =>
      '所有 Open Food Facts 产品的代码均可在 GitHub 上获取。欢迎您复用代码（代码为开源），并帮助我们改进，造福全球所有人。';

  @override
  String get contribute_develop_text_2 =>
      '您可以加入 Open Food Facts Slack 聊天室，这是提问的首选方式。';

  @override
  String get contribute_develop_dev_mode_title => '開發模式？';

  @override
  String get contribute_develop_dev_mode_subtitle => '起用開發模式';

  @override
  String get contribute_donate_title => '贊助/捐款';

  @override
  String get contribute_donate_header => '捐助 Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      '请注意，使用内部 alpha 版本，可能会完全丢失数据，并且应用程序可能随时无法使用！';

  @override
  String get contribute_improve_ProductsToBeCompleted => '待完成的产品';

  @override
  String get contribute_improve_header => '改善';

  @override
  String get contribute_improve_text =>
      '数据库是该项目的核心。它简单易用，快速提供帮助。您可以下载手机应用程序，开始添加或改进产品。\n\n另一方面，Open Food Facts 网站提供了多种贡献方式：';

  @override
  String get contribute_translate_header => '翻譯';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => '開始翻譯';

  @override
  String get contribute_translate_text =>
      'Open Food Facts 是一个全球项目，涵盖来自 160 多个国家的产品。Open Food Facts 已被翻译成数十种语言，内容也不断更新。';

  @override
  String get contribute_translate_text_2 => '翻譯是專案的關鍵任務之一';

  @override
  String get contribute_join_skill_pool => '为 Open Food Facts 贡献你的技能。加入技能库！';

  @override
  String get contribute_share_header => '与朋友分享 Open Food Facts';

  @override
  String get contribute_share_content =>
      '我想介绍一下我一直在用的一款应用——Open Food Facts，它能让你以个性化的方式了解食物对健康和环境的影响。它的工作原理是扫描包装上的条形码。它完全免费，无需注册，你甚至可以帮助增加了解产品的数量。以下是手机应用下载链接：https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribute prices by requesting a GDPR export of your loyalty cards data';

  @override
  String get tap_to_answer => '點擊此處回答問題';

  @override
  String get tap_to_answer_hint => '點擊此處並回答有關此產品的問題';

  @override
  String get robotoff_questions_loading_hint => '正在加载有关该产品的问题，请稍候';

  @override
  String get saving_answer => '儲存您的回覆';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text => '登录您的 Open Food Facts 帐户，获取您的贡献值';

  @override
  String get question_yes_button_accessibility_value => '回答是';

  @override
  String get question_no_button_accessibility_value => '回答不是';

  @override
  String get question_skip_button_accessibility_value => '跳過此問題';

  @override
  String get tap_to_edit_search => '点击打开搜索框';

  @override
  String get myPreferences => '我的偏好設定';

  @override
  String get account_create_message =>
      '创建您的帐户并加入 Open Food Facts 社区，帮助在世界各地建立食品知识！';

  @override
  String get join_us => '加入我們';

  @override
  String get myPreferences_profile_title => '您的個人檔案';

  @override
  String get myPreferences_profile_subtitle => '管理您的 Open Food Facts 贡献者帐户。';

  @override
  String get myPreferences_settings_title => '應用程式設定';

  @override
  String get myPreferences_settings_subtitle => '黑暗模式，语言…';

  @override
  String get myPreferences_food_title => '食品偏好選項';

  @override
  String get myPreferences_food_subtitle => '選擇對您最至關重要的食物資訊';

  @override
  String get myPreferences_food_comment =>
      'Choose what information about food matters most to you, in order to rank food according to your preferences, see the information you care about first, and get a compatibility summary. Those food preferences stay on your device, and are not associated with your Open Food Facts contributor account if you have one.';

  @override
  String get confirmResetPreferences => '重新設定食物偏好選項？';

  @override
  String get myPersonalizedRanking => '我的個人化排名';

  @override
  String get ranking_tab_all => '全部';

  @override
  String get ranking_subtitle_match_yes => '非常适合';

  @override
  String get ranking_subtitle_match_no => '非常不适合';

  @override
  String get ranking_subtitle_match_maybe => '未知匹配';

  @override
  String get refresh_with_new_preferences => '使用您的新偏好刷新列表';

  @override
  String get reloaded_with_new_preferences => '重新加载新的偏好设置';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => '掃描';

  @override
  String get history_navbar_label => '歷史紀錄';

  @override
  String get list_navbar_label => '列表';

  @override
  String get category => '按類別篩選';

  @override
  String get category_all => '全部';

  @override
  String get category_search => '（類別搜尋）';

  @override
  String get filter => '筛选';

  @override
  String get scan => '来自扫描屏幕的产品';

  @override
  String get scan_history => '扫描历史记录';

  @override
  String get search => '搜尋';

  @override
  String get search_product_help => 'Search a product,\na brand or a barcode';

  @override
  String get search_filter => 'Search filter';

  @override
  String get search_history => 'Search history';

  @override
  String get search_store => '搜索商店';

  @override
  String get search_store_help => 'Hint: add the city or the country';

  @override
  String get tap_for_more => '点击获取更多信息';

  @override
  String get product => '產品';

  @override
  String get unknownBrand => '未知品牌';

  @override
  String get unknownProductName => '未知產品名稱';

  @override
  String get label_refresh => '重新整理';

  @override
  String get label_reload => '重新加载';

  @override
  String get image => '圖片';

  @override
  String get front_photo => '正面照片';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType （此图片可能已过时）';
  }

  @override
  String get outdated_image_short_label => '可能已经过时';

  @override
  String get ingredients => '成分';

  @override
  String get ingredients_editing_instructions =>
      '保持原始顺序。如需指定，请注明百分比。用逗号或连字符分隔，并使用括号表示成分。';

  @override
  String get ingredients_editing_error => '儲存成分失敗。';

  @override
  String get ingredients_editing_image_error => '未能獲取新的成分圖像。';

  @override
  String get ingredients_editing_title => '編輯成分';

  @override
  String get ingredients_photo => '成分照片';

  @override
  String get packaging_editing_instructions =>
      '列出用逗号或换行符分隔的所有包装零件，以及它们的数量（例如1或6）类型（例如瓶、盒、罐）、材料（例如塑料、金属、铝）以及它们的尺寸（例如33cl）和回收说明。示例：1个要回收的玻璃瓶，1个要丢弃的塑料软木塞';

  @override
  String get packaging_editing_error => '无法保存包装信息。';

  @override
  String get packaging_editing_image_error => '无法获得新的包装图片。';

  @override
  String get packaging_editing_title => '编辑包装信息';

  @override
  String get nutrition => '營養成分';

  @override
  String get nutrition_facts_photo => '營養標示相片';

  @override
  String get nutrition_facts_editing_title => '编辑营养成分表';

  @override
  String get packaging_information => '包裝資訊';

  @override
  String get packaging_information_photo => '包裝資訊照片';

  @override
  String get missing_product => '您發現了一個新產品！';

  @override
  String get add_product_take_photos => '拍摄包装照片，将此产品添加到 Open Food Facts';

  @override
  String get add_product_take_photos_descriptive => '请您先拍几张照片，你可以在以后完成操作';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => '新的產品';

  @override
  String get new_product_found_title => '发现新产品！';

  @override
  String get new_product_found_text => '我们的协作数据库包含超过** 300 万种产品**，但此条形码不存在：';

  @override
  String get new_product_found_button => '加入此產品';

  @override
  String get new_product_leave_title => '离开此页面吗？';

  @override
  String get new_product_leave_message => '看起来你没有输入任何内容。你真的想要离开这个页面吗？';

  @override
  String get new_product_dialog_description => '请拍摄包装照片以将此产品添加到我们的公共数据库中';

  @override
  String get new_product_dialog_illustration_description =>
      'An illustration with unknown Nutri-Score and Green Score';

  @override
  String get front_packaging_photo_button_label => '正面包装照片';

  @override
  String get confirm_front_packaging_photo_button_label => '确认上传正面包装照片';

  @override
  String get confirm_button_label => '确认';

  @override
  String get send_image_button_label => '发送图片';

  @override
  String get crop_page_action_saving => '正在保存图像…';

  @override
  String get crop_page_action_cropping => '剪裁图像…';

  @override
  String get crop_page_action_local => '保存本地版本…';

  @override
  String get crop_page_action_local_failed_title => '啊噢…你的照片有点问题！';

  @override
  String get crop_page_action_local_failed_message =>
      '在把图片上传到服务器前，我们没有办法在本地进行处理。请稍后再试，如果仍有问题请联系我们。';

  @override
  String get crop_page_action_retake => '重拍';

  @override
  String get crop_page_too_small_image_title => '图片尺寸过小';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return '图片上传的最小尺寸（以像素为单位）为 ${expectedMinWidth}x$expectedMinHeight。当前图片的尺寸为 ${actualWidth}x$actualHeight。';
  }

  @override
  String get crop_page_action_server => '准备调用服务器…';

  @override
  String get front_packaging_photo_title => '正面包装照片';

  @override
  String get ingredients_photo_title => '配料表照片';

  @override
  String get nutritional_facts_photo_title => '营养成分表照片';

  @override
  String get recycling_photo_title => '“循环利用标记”的照片';

  @override
  String get take_photo_title => '選一張圖片';

  @override
  String get take_more_photo_title => '拍摄更多照片';

  @override
  String get front_photo_uploaded => '已上載正面包裝的相片';

  @override
  String get ingredients_photo_button_label => '成分照片';

  @override
  String get ingredients_photo_uploaded => '已上載成分的相片';

  @override
  String get nutrition_cache_loading_error => '无法从缓存中加载营养成分';

  @override
  String get nutritional_facts_photo_button_label => '營養標示相片';

  @override
  String get nutritional_facts_input_button_label => '填写营养成分表';

  @override
  String get nutritional_facts_added => '已添加营养成分表';

  @override
  String get categories_added => '分类已添加';

  @override
  String get new_product_title_nutriscore => '计算营养评分（Nutri-Score）';

  @override
  String get new_product_subtitle_nutriscore => '帮助我们填写至少一个类别和营养价值';

  @override
  String get new_product_title_environmental_score => '计算 Green Score';

  @override
  String get new_product_subtitle_environmental_score => '填写至少一个类别即可获得';

  @override
  String get new_product_additional_environmental_score =>
      '通过原产地、包装等因素使 Green Score 计算更加精确';

  @override
  String get new_product_title_nova => '计算食品加工水平（NOVA）';

  @override
  String get new_product_subtitle_nova => '通过填写食品类别和配料获得它';

  @override
  String get new_product_desc_nova_unknown => '食品加工程度未知';

  @override
  String get new_product_title_pictures => '添加产品';

  @override
  String get new_product_title_pictures_details =>
      '请拍摄以下照片，Open Food Facts 引擎可以解决剩下的问题！';

  @override
  String get new_product_title_misc => '还有一些基本数据…';

  @override
  String new_product_done_msg(String username) {
    return '感谢您的贡献“$username”！';
  }

  @override
  String get new_product_done_msg_no_user => '感谢您的贡献！';

  @override
  String get new_product_done_button_label => '发现已完成录入的产品';

  @override
  String get hey_incomplete_product_message =>
      '立即点击回答 3 个问题来计算Nutri-Score、绿色分数和超加工分组 (NOVA)！';

  @override
  String get hey_incomplete_product_message_beauty => '立即点击回答 2 个问题来帮助分析这款化妆品！';

  @override
  String get hey_incomplete_product_message_pet_food =>
      '立即点击回答 3 个问题来帮助分析这种宠物食品！';

  @override
  String get hey_incomplete_product_message_product => '立即点击以帮助完成该产品信息的收集！';

  @override
  String get nutritional_facts_photo_uploaded => '已上传营养成分表照片';

  @override
  String get recycling_photo_button_label => '“循环利用标记”的照片';

  @override
  String get recycling_photo_uploaded => '已上传“循环利用标记”的照片';

  @override
  String get take_more_photo_button_label => '拍摄更多照片';

  @override
  String get other_photo_uploaded => '已上傳其它相片';

  @override
  String get retake_photo_button_label => '重拍';

  @override
  String get selecting_photo => '選取相片';

  @override
  String get uploading_image => '正在向服务器上传照片';

  @override
  String get uploading_image_type_front => '将正面图片上传至 Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Uploading ingredients image to Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Uploading nutrition image to Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Uploading packaging image to Open Food Facts';

  @override
  String get uploading_image_type_other => '上传其他图片至 Open Food Facts';

  @override
  String get uploading_image_type_generic => '将图片上传至 Open Food Facts';

  @override
  String get score_add_missing_ingredients => '添加缺少的成分';

  @override
  String get score_add_missing_packaging_image => '添加缺失的包装照片';

  @override
  String get score_add_missing_nutrition_facts => '補充營養成分';

  @override
  String get score_add_missing_product_traces => '添加缺失的产品轨迹';

  @override
  String get score_add_missing_product_category => '选择一个类别';

  @override
  String get score_add_missing_precise_product_category => '選擇更精確的類別';

  @override
  String get score_add_missing_product_countries => '添加缺失的产品产地国';

  @override
  String get score_add_missing_product_emb => '添加缺失的产品代码（翻译注：可能是条形码';

  @override
  String get score_add_missing_product_labels => '添加缺失的产品标签';

  @override
  String get score_add_missing_product_origins => '添加缺失的产品来源';

  @override
  String get score_add_missing_product_stores => '添加缺失的产品来源商店';

  @override
  String get score_add_missing_product_brands => '添加缺失的产品品牌';

  @override
  String get score_update_nutrition_facts => '更新營養成分';

  @override
  String get nutrition_page_title => '營養成分';

  @override
  String get nutrition_page_nutritional_info_title => '营养信息';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Values specified on the product:';

  @override
  String get nutrition_page_nutritional_info_value_positive => '是';

  @override
  String get nutrition_page_nutritional_info_value_negative => '否';

  @override
  String get nutrition_page_nutritional_info_open_photo => '打开照片';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Good practices: Nutritional information';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Sometimes nutrition facts are **not specified on the packaging** or on a document given with the product. In this case, and only in this case, you can set the value to **NO**.';

  @override
  String get nutrition_page_serving_type_label => '营养价值：';

  @override
  String get nutrition_page_per_100g => '每 100 克';

  @override
  String get nutrition_page_per_100g_100ml => '每100克/100毫升';

  @override
  String get nutrition_page_per_serving => '每份';

  @override
  String get nutrition_page_add_nutrient => '新增營養';

  @override
  String get nutrition_page_serving_size => '份量';

  @override
  String get nutrition_page_serving_size_hint => '输入份量（例如：100g）';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Good practices: Serving size';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      '这个值有助于**对每份食物中的每种营养素进行比例计算**。';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Allowed units** are: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**、**60g** 或 **60 G**（建议使用第一个，它们都代表克）';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 毫升** 或 **1 升**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      '无效单位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      '无效单位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **candies** and 2 **biscuits**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      '缺少单位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => '無效數值';

  @override
  String get nutrition_page_update_running => '正在更新服务器上的产品…';

  @override
  String get nutrition_page_update_done => '產品更新了！';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      '使用产品数量作为份量';

  @override
  String get nutrition_page_photo_error => '无法加载照片';

  @override
  String get more_photos => '更多奇妙照片';

  @override
  String get view_more_photo_button => '查看该产品的所有现有照片';

  @override
  String get no_product_found => '未發現產品';

  @override
  String get no_location_found => '未找到位置';

  @override
  String get not_found => '無法查明：';

  @override
  String get refreshing_product => '食品重新整理中';

  @override
  String get product_refreshed => '產品更新';

  @override
  String product_image_accessibility_label(String date) {
    return '图片拍摄于 $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return '图片拍摄于 $date。此图片可能已过时';
  }

  @override
  String get product_image_outdated => '此图片可能已过期';

  @override
  String get product_image_outdated_explanations_title => '此图片可能已过期';

  @override
  String get product_image_outdated_explanations_content =>
      '这张照片拍摄于一年多以前。\n请检查它是否仍为最新版本。\n\n这只是一个警告。如果内容和现在仍然相同，您可以忽略此消息。';

  @override
  String product_image_action_replace_photo(String type) {
    return '替换照片 ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return '添加照片 ($type)';
  }

  @override
  String get product_image_action_take_new_picture => '拍摄';

  @override
  String get product_image_action_take_picture => '選一張圖片';

  @override
  String get product_image_action_from_gallery => '从手机图库中选择';

  @override
  String get product_image_action_choose_existing_photo => '从产品照片中选择';

  @override
  String get product_image_details_label => '有关照片的信息';

  @override
  String get product_image_details_from_producer => '来自制造商';

  @override
  String get product_image_details_contributor => '貢獻者';

  @override
  String get product_image_details_contributor_producer =>
      'Contributor (producer)';

  @override
  String get product_image_details_date => '日期';

  @override
  String get product_image_details_date_unknown => '未知';

  @override
  String get homepage_main_card_logo_description => '欢迎使用 Open Food Facts';

  @override
  String get homepage_main_card_subheading => '扫描条形码或\n搜索产品';

  @override
  String get homepage_main_card_search_field_hint => '搜索产品';

  @override
  String get homepage_main_card_search_field_tooltip => '开始搜索';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return '最新消息： $news_title';
  }

  @override
  String get tagline_app_review => '你喜欢这个应用程序吗？';

  @override
  String get tagline_app_review_button_positive => '我太爱它了！😍';

  @override
  String get tagline_app_review_button_negative => '不太喜欢';

  @override
  String get tagline_app_review_button_later => '稍后再询问我';

  @override
  String get tagline_feed_news_button => '了解更多';

  @override
  String get app_review_negative_modal_title => '您不喜欢我们的应用程序吗？';

  @override
  String get app_review_negative_modal_text => '您能花点时间告诉我们原因吗？';

  @override
  String get app_review_negative_modal_positive_button => '绝对是这样没错！';

  @override
  String get app_review_negative_modal_negative_button => '否';

  @override
  String get could_not_refresh => '無法重新整理產品';

  @override
  String get product_internet_error_modal_title => '发生错误！';

  @override
  String product_internet_error_modal_message(String error) {
    return '由于网络错误，我们无法获取此产品的相关信息。请检查您的网络连接，然后重试。\n\n内部错误：\n$error';
  }

  @override
  String get product_tags_title => '产品属性';

  @override
  String get no_product_tags_found_message => '未找到产品属性。产品属性可以更详细、更灵活地描述产品。';

  @override
  String get product_tags_empty => '沒有屬性';

  @override
  String get product_tags_explanation => '透過為產品添加屬性（鍵/值），您可以幫助豐富產品。';

  @override
  String get add_tag => '添加属性';

  @override
  String get add_tags => '添加属性';

  @override
  String get add_edit_tags => '添加或编辑属性';

  @override
  String get edit_tag => '编辑属性';

  @override
  String get remove_tag => '删除属性';

  @override
  String get tag_key => '属性';

  @override
  String get tag_keys => '特性';

  @override
  String get tag_key_uneditable => '属性（不可编辑）';

  @override
  String get tag_key_input_hint => 'Input a property';

  @override
  String get tag_value => '值';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Input a value';

  @override
  String get tag_key_item => 'Property:';

  @override
  String get tag_value_item => 'Value:';

  @override
  String get tag_key_explanations =>
      'A key must be lowercase and without any spaces.';

  @override
  String tag_key_already_exists(String property) {
    return 'A tag with a property $property already exists!';
  }

  @override
  String get product_internet_error => '因為網路錯誤，無法取得關於此產品的資訊。';

  @override
  String get cached_results_from => '顯示結果自：';

  @override
  String get product_search_same_category => '尋找替代方案';

  @override
  String get product_search_same_category_short => '比較';

  @override
  String get product_search_same_category_error =>
      'This feature can only be used for products with a category.\n\nPlease edit the product to add a category.';

  @override
  String get product_improvement_add_category => '新增一個類別以計算 Nutri-Score。';

  @override
  String get product_improvement_add_nutrition_facts =>
      '新增營養成分和類別以計算Nutri-Score。';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      '新增營養成分和類別以計算Nutri-Score。';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      '无法计算此产品的Nutri-Score，这可能是由于例如：非标准类别。如果这被认为是错误，请与我们联系。';

  @override
  String get product_improvement_obsolete_nutrition_image => '此營養成分表已過時：請更新。';

  @override
  String get product_improvement_origins_to_be_completed =>
      'The Green Score takes into account the origins of the ingredients. Please take a photo of the ingredient list and/or any geographic claim or edit the product, so they can be taken into account.';

  @override
  String get country_chooser_label => '請選擇國家';

  @override
  String get currency_chooser_label => 'Please choose a currency';

  @override
  String get country_change_message => 'You have just changed countries.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Do you want to change the currency from $previousCurrency to $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Please choose a country:';

  @override
  String get country_chooser_label_from_settings => 'Your country';

  @override
  String get country_selection_explanation => '有些环境特征是因地而异的。';

  @override
  String get product_removed_comparison => '已从对比中删除该产品';

  @override
  String get native_app_settings => '本机应用程序设置';

  @override
  String get native_app_description =>
      'Open systems settings for Open Food Facts';

  @override
  String get product_removed_history => '產品已從歷史記錄中刪除';

  @override
  String get product_removed_list => '把产品从列表移除';

  @override
  String get product_could_not_remove => '無法移除產品';

  @override
  String get no_prodcut_in_list => '此清單裡沒有任何產品';

  @override
  String get no_product_in_section => '此部門仍未有產品';

  @override
  String get recently_seen_products => 'All viewed products';

  @override
  String get clear => '清除';

  @override
  String get clear_long => '清空列表';

  @override
  String get really_clear => '您確定要刪除此清單嗎？';

  @override
  String pct_match(Object percent) {
    return '$percent% 匹配度';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 天前',
      one: '一天前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 小时前',
      one: '一小时前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 分钟前',
      one: '1 分钟前',
      zero: '不到一分钟前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 个月前',
      one: '一个月前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 周前',
      one: '一周前',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '比较 $count 种产品',
      one: '比较一种产品',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count selected products',
      one: 'One selected product',
      zero: 'No selected product',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => '比较选定的产品';

  @override
  String get delete_products_mode => '删除选定的产品';

  @override
  String get select_all_products_mode => '选择所有产品';

  @override
  String get select_none_products_mode => '全部不选';

  @override
  String get compare_products_appbar_title => 'Compare products';

  @override
  String get compare_products_appbar_subtitle => '请至少选择两个产品';

  @override
  String get retry_button_label => '重試';

  @override
  String get connect_with_us => '聯繫我們';

  @override
  String get tiktok => '在 TikTok 上关注我们';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => '在 Instagram 上关注我们';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => '在 X（原 Twitter）上关注我们';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => '在 Mastodon 上关注我们';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => '在 BlueSky 上关注我们';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => '部落格';

  @override
  String get faq => '常見問題';

  @override
  String get discover => '探索';

  @override
  String get how_to_contribute => '如何貢獻';

  @override
  String get hint_knowledge_panel_message =>
      '您可以點擊卡片的任何部分以獲取有關您所看到內容的更多詳細信息。現在就試試！';

  @override
  String get permissions_page_title => '相机访问权限';

  @override
  String get permissions_page_body1 => '要使用手机相机扫描条形码，请授权访问。';

  @override
  String get permissions_page_body2 => '如果您改变主意，可以随时在设置里启用或禁用此功能。';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return '操作系统：Android（SDK Int： $sdkInt / 版本： $release）\n型号： $model\n产品： $product\n设备： $device\n品牌：$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return '操作系统： iOS （$version)\n型： $model\n本地化模型： $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\n应用版本：$appVersion\n应用内部版本号：$appBuildNumber\n应用包名称：$appPackageName';
  }

  @override
  String get authorize_button_label => '授权';

  @override
  String get refuse_button_label => '拒絕';

  @override
  String get ask_me_later_button_label => '稍后';

  @override
  String get are_you_sure => '确定吗？';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return '继续了解 $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => '欢迎 ！';

  @override
  String get onboarding_home_welcome_text2 => '该应用程序可帮助您选择对您和地球都有益的食物！';

  @override
  String get onboarding_continue_button => '继续';

  @override
  String get onboarding_welcome_loading_dialog_title => '正在加载您的第一个产品';

  @override
  String get onboarding_welcome_warning => '抱歉，這是我們的範例產品，您無法編輯 :)';

  @override
  String get product_list_your_ranking => '你的排名';

  @override
  String get product_list_empty_icon_desc => '無歷史資料';

  @override
  String get product_list_empty_title => '开始扫描';

  @override
  String get product_list_empty_message => '扫描的产品会出现在这里，您可以查看详细信息。';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '产品',
      one: '产品',
      zero: '产品',
    );
    return '重新加载在你历史记录中的$_temp0';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '产品',
      one: '产品',
      zero: '产品',
    );
    return '$_temp0重新加载完成';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => '正在下載資料';

  @override
  String get loading_dialog_default_error_message => '無法下載資料';

  @override
  String get account_delete => '刪除帳號';

  @override
  String get account_delete_title => '刪除我的帳戶';

  @override
  String get user_profile => '账户';

  @override
  String get user_profile_title_guest => '歡迎！';

  @override
  String get user_profile_subtitle_guest => '登录或注册加入 Open Food Facts 社区';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts 登录： $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return '欢迎 $id！';
  }

  @override
  String get email_subject_account_deletion => '刪除帳號';

  @override
  String email_body_account_deletion(String userId) {
    return '您好，请删除我的 Open Food Facts 帐户： $userId';
  }

  @override
  String get settings_app_app => '应用程序';

  @override
  String get settings_app_data => '功能和崩溃监控';

  @override
  String get settings_app_camera => '相机';

  @override
  String get settings_app_products => '产品';

  @override
  String get settings_app_miscellaneous => '其他';

  @override
  String get camera_play_sound_title => '在扫描时播放声音';

  @override
  String get camera_play_sound_subtitle => '每次成功扫描都会发出蜂鸣声';

  @override
  String get camera_window_accessibility_label => '使用相机扫描条形码';

  @override
  String get app_haptic_feedback_title => '振动 触觉';

  @override
  String get app_haptic_feedback_subtitle => '执行某些操作后的振动（条形码已解码，产品已移除…）。';

  @override
  String get crash_reporting_toggle_title => '向我们报告错误和崩溃';

  @override
  String get crash_reporting_toggle_subtitle =>
      '启用后，崩溃报告会自动提交给 Open Food Facts 的错误跟踪系统，以便修复错误并改进应用程序。';

  @override
  String get send_anonymous_data_toggle_title => '向我们报告功能使用情况';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      '启用后，有关功能使用情况的严格匿名信息将发送至 Open Food Facts 服务器，以便我们了解功能的使用情况，从而改进功能。';

  @override
  String get product_edit_photo_title => '编辑照片';

  @override
  String get permission_photo_error => '错误';

  @override
  String get permission_photo_denied_title => '允许使用照相机扫描条码';

  @override
  String permission_photo_denied_message(String appName) {
    return '为了提高使用体验，请允许$appName访问您的照相机。以便于直接扫描条码。';
  }

  @override
  String get permission_photo_denied_button => '允许';

  @override
  String get permission_photo_denied_dialog_settings_title => '没有权限';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      '因为之前拒绝了访问照相机，所以只能在设置里手动允许使用照相机。';

  @override
  String get permission_photo_denied_dialog_settings_button_open => '打开权限设置';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => '取消';

  @override
  String get permission_photo_none_found => '没有检测到摄像头';

  @override
  String get permission_photo_denied => '未授權相機訪問權限';

  @override
  String get show_product_pictures => '显示产品图片';

  @override
  String get edit_product_label => '编辑产品';

  @override
  String get edit_product_pending_operations_banner_title => '正在上传您的编辑…';

  @override
  String get edit_product_pending_operations_banner_message =>
      '您的编辑正在后台发送（如果出现错误则稍后发送）。\n您可以继续编辑其他产品字段。';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Your edits are being **sent in the background** (or later in case of error).';

  @override
  String get edit_product_label_short => '編輯';

  @override
  String edit_product_form_item_help(String value) {
    return '如何输入\"$value\"？';
  }

  @override
  String get edit_product_form_item_error_empty => '请输入非空值！';

  @override
  String get edit_product_form_item_error_existing => '数值已经存在！';

  @override
  String get edit_product_form_item_add_action_brand => '添加新品牌';

  @override
  String get edit_product_form_item_add_action_label => '添加新标签';

  @override
  String get edit_product_form_item_add_action_store => '添加新商店';

  @override
  String get edit_product_form_item_add_action_origin => '添加新产地';

  @override
  String get edit_product_form_item_add_action_emb_code => '添加新的追溯代码';

  @override
  String get edit_product_form_item_add_action_country => '添加新国家';

  @override
  String get edit_product_form_item_add_action_category => '添加新类别';

  @override
  String get edit_product_form_item_add_action_trace => '添加一个新的轨迹';

  @override
  String get edit_product_form_item_add_suggestion => '添加建议';

  @override
  String get edit_product_form_item_deny_suggestion => '拒絕建議';

  @override
  String get edit_product_form_item_details_title => '基本資料';

  @override
  String get edit_product_form_item_details_subtitle => '產品名稱、品牌、數量';

  @override
  String get edit_product_form_item_other_details_title => '额外细节';

  @override
  String get edit_product_form_item_other_details_subtitle => '产品网站…';

  @override
  String get edit_product_form_item_photos_title => '相片';

  @override
  String get edit_product_form_item_photos_subtitle => '添加或更新照片';

  @override
  String get edit_product_form_item_labels_title => '標籤和認證';

  @override
  String get edit_product_form_item_labels_subtitle => '环保、质量标签…';

  @override
  String get edit_product_form_item_labels_hint => '输入标签（例如：NutriScore）';

  @override
  String get edit_product_form_item_labels_type => '標籤';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Good practices: Labels';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Any characteristic of the product **which is factual** and different from the other fields.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      '营养评分（Nutri-Score），NOVA 分组…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      '比利时制造，布列塔尼生产…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001、ISO 22000 产品质量标准…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      '富含纤维，铁的来源…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => '商店';

  @override
  String get edit_product_form_item_stores_hint => '输入商店信息';

  @override
  String get edit_product_form_item_stores_type => '商店';

  @override
  String get edit_product_form_item_stores_explanation_title => '关于商店信息的良好实践';

  @override
  String get edit_product_form_item_stores_explanation_info1 => '输入您购买产品的商店。';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 => '沃尔玛';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 => '家乐福';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 => '利德尔';

  @override
  String get edit_product_form_item_origins_title => '產地';

  @override
  String get edit_product_form_item_origins_hint => '输入原产地（例如：德国）';

  @override
  String get edit_product_form_item_origins_type => '國家';

  @override
  String get edit_product_form_item_origins_explanation_title => '关于原产地信息的良好实践';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '添加**您可以在包装上找到的任何原产地指示**。\n您不需要添加成分表中直接指示的原产地。';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      '阿根廷牛肉';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'The soy does not come from the European Union';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint => '输入国家（例如：德国）';

  @override
  String get edit_product_form_item_countries_type => '國家';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Good practices: Countries';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Countries where the product is widely available** (not including stores specialising in foreign products).';

  @override
  String get edit_product_form_item_emb_codes_title => '產銷履歷代碼';

  @override
  String get edit_product_form_item_emb_codes_hint => '输入溯源码';

  @override
  String get edit_product_form_item_emb_codes_type => '產銷履歷代碼';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Good practices: Traceability codes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In this section, you can input codes related to **packaging marks**, **identification marks** or **health marks**.';

  @override
  String get edit_product_form_item_emb_help_info2_title => '可追溯性代码示例';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '欧盟用于识别食品生产商或包装商的 EC 代码：';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: country code of **France**\n**72.264.002**: geographic data\n**CE**: European Community';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '法国使用的 EMB 代码：';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => '含少量';

  @override
  String get edit_product_form_item_traces_hint => '追蹤';

  @override
  String get edit_product_form_item_traces_type => '输入追踪信息（例如：大豆）';

  @override
  String get edit_product_form_item_categories_title => '類別';

  @override
  String get edit_product_form_item_categories_hint => '分類';

  @override
  String get edit_product_form_item_categories_type => '输入类别（例如：橙汁）';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      '关于分类信息的良好实践';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicate **only the most specific category**.\nParent categories will be automatically added.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      '缺少类别？';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      '如果某个类别**在自动完成中不可用**，请随意添加。\n这将帮助我们改进您所在国家/地区的 Open Food Facts。';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardines in olive oil';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Orange juice from concentrate';

  @override
  String get edit_product_form_item_exit_title => '数据未保存，退出吗？';

  @override
  String get edit_product_form_item_exit_confirmation => '是否再离开页面前保存?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button => '保存更改';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button => '放弃更改';

  @override
  String get edit_product_form_item_ingredients_title => '成分';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      '通过捏合手势来放大和缩小';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      '放大和缩小照片';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '使用捏合缩放手势，您可以放大或缩小照片：';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => '加入产品';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip => '请先输入文字';

  @override
  String get edit_product_form_item_remove_item_tooltip => '移除';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => '保存';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip => '取消';

  @override
  String get edit_product_form_item_packaging_title => '回收说明照片';

  @override
  String get edit_product_form_item_nutrition_facts_title => '营养成分';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle => '營養、酒精含量⋯⋯';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Good practices: Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nutritional values';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'First, select if the **values are provided**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      '营养成分';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Then, input the nutritional values **as indicated on the packaging**. If there is no value, you can click on the \"Eye\" icon.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Missing field?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'If an entry is missing, you can **click on the \"Plus\" icon** to add it (eg: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => '編輯';

  @override
  String get edit_product_ingredients_photo_title => '成分照片';

  @override
  String get edit_product_ingredients_list_title => '成分列表';

  @override
  String get edit_product_packaging_photo_title => 'Packaging photo';

  @override
  String get edit_product_packaging_list_title => 'Packaging list';

  @override
  String get no_data_available => '沒有可用的資料';

  @override
  String get product_field_website_title => '网站';

  @override
  String get origins_editing_title => 'Edit Origins';

  @override
  String get completed_basic_details_btn_text => '完善基本信息';

  @override
  String get not_implemented_snackbar_text => '尚未生效';

  @override
  String get category_picker_page_appbar_text => '類別';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extract ingredients from the photo';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short => '提取成分';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extracting ingredients\nfrom the photo';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'To use the \"Extract ingredients\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => '刷新照片';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extract packaging\nfrom the photo';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extract packaging';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extracting packaging from the photo';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'To use the \"Extract packaging\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_packaging_refresh_photo_btn_text => '刷新照片';

  @override
  String get edit_ocr_extract_failed => '无法检测图像中的文本。';

  @override
  String get edit_ocr_extract_disabled_title => 'No picture!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'In order to use the text extraction feature, you must first take a photo.';

  @override
  String get user_list_dialog_new_title => '新产品列表';

  @override
  String get user_list_dialog_rename_title => '重命名列表';

  @override
  String get user_list_subtitle_product => '列表';

  @override
  String get user_list_title => '您的清單';

  @override
  String get user_list_add_product => '将产品添加到您的列表';

  @override
  String get user_list_button_new => 'Create a new list';

  @override
  String get user_list_empty_label => '暂无可用列表，请从创建一个新列表开始';

  @override
  String get user_list_button_add_product => '添加到列表';

  @override
  String get added_to_list_msg => '已添加到列表';

  @override
  String get user_list_popup_clear => '清除历史记录';

  @override
  String get user_list_popup_rename => '重命名';

  @override
  String get user_list_name_hint => '我的列表';

  @override
  String get user_list_name_error_empty => '名称是必填项';

  @override
  String get user_list_name_error_already => '名称已被使用';

  @override
  String get user_list_name_error_same => '名称重复';

  @override
  String get user_list_name_input_hint => 'Name of the list';

  @override
  String get try_again => '重试';

  @override
  String get there_was_an_error => '有错误产生';

  @override
  String category_picker_no_category_found_message(String items) {
    return '没有 $items 对应的类别';
  }

  @override
  String get camera_toggle_camera => '在后置和前置相机之间切换';

  @override
  String get camera_toggle_flash => '打开或关闭摄像头的闪光灯';

  @override
  String get camera_enable_flash => '打开闪光灯';

  @override
  String get camera_disable_flash => '禁用闪光灯';

  @override
  String get camera_flash_error_dialog_title => '发生错误';

  @override
  String get camera_flash_error_dialog_message =>
      '更改闪光灯状态时发生错误。请确保你的智能手机尚未启用手电筒。';

  @override
  String get category_picker_no_category_found_button => '返回';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Click to open in your browser or in the application (if installed)';

  @override
  String get dev_preferences_screen_title => '开发模式';

  @override
  String get dev_preferences_screen_subtitle => '存取實驗性功能和開發工具';

  @override
  String get dev_preferences_reset_onboarding_title => '重置引导流程';

  @override
  String get dev_preferences_reset_onboarding_subtitle => '你必须重新启动应用才能再次看到它。';

  @override
  String get dev_preferences_environment_switch_title =>
      '在 openfoodfacts.org (PROD) 和测试环境之间切换';

  @override
  String get dev_preferences_test_environment_title => '测试环境参数';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return '当前测试环境的基本 URL： $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title => '测试环境主机';

  @override
  String get dev_preferences_ml_kit_title => '使用机器学习套件';

  @override
  String get dev_preferences_ml_kit_subtitle => '您需要重新启动此应用';

  @override
  String get dev_preferences_product_additional_features_title => '产品页面上的附加按钮';

  @override
  String get dev_preferences_edit_ingredients_title => '通过信息面板按钮编辑成分';

  @override
  String get dev_preferences_export_history_title => '导出历史记录';

  @override
  String get dev_preferences_export_history_progress_error => '异常';

  @override
  String get dev_preferences_export_history_progress_found => '找到产品';

  @override
  String get dev_preferences_export_history_progress_not_found => '未找到产品';

  @override
  String get dev_preferences_export_history_dialog_title => '导出历史记录';

  @override
  String get dev_preferences_button_positive => '好';

  @override
  String get dev_preferences_button_negative => '取消';

  @override
  String get dev_preferences_migration_title => '从 V1 迁移数据';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return '状态：$status';
  }

  @override
  String get dev_preferences_migration_status_already_done => '成功或全新安装';

  @override
  String get dev_preferences_migration_status_success => '成功';

  @override
  String get dev_preferences_migration_status_error => '错误';

  @override
  String get dev_preferences_migration_status_in_progress => '进行中';

  @override
  String get dev_preferences_migration_status_required => '需要（点击开始）';

  @override
  String get dev_preferences_migration_status_not_started => '未知';

  @override
  String get dev_preferences_import_history_subtitle => '将清除历史记录并在其中放置 3 个产品';

  @override
  String get dev_preferences_news_custom_url_title => 'Custom URL for news';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL of the JSON file:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Not set';

  @override
  String get dev_preferences_news_provider_status_title => '狀態';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Last refresh: $date';
  }

  @override
  String get product_type_label_food => '食物';

  @override
  String get product_type_label_beauty => 'Personal care';

  @override
  String get product_type_label_pet_food => '寵物食品';

  @override
  String get product_type_label_product => 'Other';

  @override
  String get product_type_selection_title => 'Product type';

  @override
  String get product_type_selection_subtitle =>
      'Select the type of this product';

  @override
  String get product_type_selection_empty =>
      'You need to select a product type first!';

  @override
  String product_type_selection_already(String productType) {
    return 'You cannot change the product type ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Shortcut to Prices app on product page';

  @override
  String get prices_app_button => 'Go to Prices app';

  @override
  String get prices_website_button => '在公開價格網站上打開';

  @override
  String get prices_bulk_proof_upload_select =>
      'Add price tags directly from gallery';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Once you\'ve selected images, you won\'t be able to edit them!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch => '允許社群驗證人工智慧提取的價格。';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Multiple Price Tags';

  @override
  String get prices_bulk_proof_upload_title => 'Bulk Proof Upload';

  @override
  String get prices_bulk_proof_upload_step_selecting => '選擇文件';

  @override
  String get prices_bulk_proof_upload_step_starting => '開始上傳';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return '本地複製檔 #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return '準備上傳 #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return '圖片 #$index/$count失敗';
  }

  @override
  String get prices_generic_title => '价格';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add $count prices',
      one: 'Add a price',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Send $count prices',
      one: 'Send the price',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Add an item';

  @override
  String get prices_add_a_price => '添加价格';

  @override
  String get prices_add_a_receipt => 'Add a receipt';

  @override
  String get prices_add_price_tags => 'Add price tags';

  @override
  String prices_barcode_already(String barcode) {
    return 'This barcode ($barcode) is already in the list!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product not found';

  @override
  String get prices_barcode_search_none_yet => 'No product yet';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Looking for $barcode';
  }

  @override
  String get prices_barcode_enter => 'Enter the Barcode';

  @override
  String get prices_category_enter => '商品無條碼';

  @override
  String get prices_per_kilogram => '每公斤價格';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' /公斤';

  @override
  String get prices_per_unit_short => ' / 單元';

  @override
  String get prices_category_mandatory => 'Mandatory';

  @override
  String get prices_category_optional => '選修的';

  @override
  String get prices_category_error_mandatory => '此類別為必填項';

  @override
  String get prices_barcode_reader_action => 'Barcode reader';

  @override
  String get prices_view_prices => 'View the prices';

  @override
  String get prices_list_title => '價目表';

  @override
  String get prices_list_count => '\n價格的數量';

  @override
  String get prices_list_add_new_price => '加\n新價格';

  @override
  String get prices_list_empty_title => '尚無價格！';

  @override
  String get prices_list_empty_subtitle => '第一個新增：\n透過掃描**收據**或**價格標籤**！';

  @override
  String get prices_entry_shop_not_found => '未知商店';

  @override
  String prices_entry_menu_title(String user) {
    return '價格條目來自“$user”';
  }

  @override
  String get prices_entry_menu_open_product_prices => '查看該產品的所有價格';

  @override
  String get prices_entry_menu_open_proof => '查看證明';

  @override
  String get prices_entry_menu_my_prices => '查看我的其他價格';

  @override
  String get prices_entry_menu_author_prices => '查看作者的其他價格';

  @override
  String get prices_entry_menu_shop_prices => '查看商店其他價格';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: '1 price',
    );
    return '$_temp0 for $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count prices',
      one: 'Only one price',
      zero: 'No price yet',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize prices (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Price: $price / Store: \"$location\" / Published on $date by \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Open proofs of \"$user\"';
  }

  @override
  String get prices_open_proof => 'Open price proof';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count proofs',
      one: 'Only one proof',
      zero: 'No proof yet',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize proofs (total: $total)';
  }

  @override
  String get prices_users_empty_title => '尚無貢獻者！';

  @override
  String get prices_users_empty_explanation => '率先添加價格！';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize contributors (total: $total)';
  }

  @override
  String get prices_locations_empty_title => '暫無店！';

  @override
  String get prices_locations_empty_explanation => '率先添加價格！';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize locations (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count proofs',
      one: 'One proof',
      zero: 'No proof',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: 'One product',
      zero: 'No product',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count users',
      one: 'One user',
      zero: 'No user',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: 'One price',
      zero: 'No price',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => '之前新增的價格';

  @override
  String get prices_amount_subtitle => 'Amount';

  @override
  String get prices_amount_is_discounted => 'Is discounted?';

  @override
  String get prices_amount_price_normal => '价格';

  @override
  String get prices_amount_price_discounted => '打折后价格';

  @override
  String get prices_amount_price_not_discounted => 'Original price';

  @override
  String get prices_amount_no_product => 'One product is missing!';

  @override
  String get prices_amount_price_incorrect => '错误值';

  @override
  String get prices_amount_price_mandatory => 'Mandatory value';

  @override
  String get prices_currency_subtitle => '货币';

  @override
  String get prices_date_subtitle => '日期';

  @override
  String get prices_location_subtitle => '商店';

  @override
  String get prices_location_find => '查找商店';

  @override
  String get prices_location_mandatory => 'You need to select a shop!';

  @override
  String get prices_location_search_broader =>
      'Couldn\'t find what you were looking for? Let\'s try a broader search!';

  @override
  String get prices_proof_subtitle => '证明';

  @override
  String get prices_proof_empty_title => '尚無證據！';

  @override
  String get prices_proof_empty_explanation => '首先添加**收據**或**價格標籤**的照片！';

  @override
  String get prices_proof_find => 'Select a proof';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => '收据';

  @override
  String get prices_proof_price_tag => '价格标签';

  @override
  String get prices_proof_mandatory => 'You need to select a proof!';

  @override
  String get prices_add_validation_error => 'Validation error';

  @override
  String get prices_privacy_warning_title => 'Privacy warning';

  @override
  String get prices_unknown_product => '未知产品';

  @override
  String get prices_privacy_warning_main_message =>
      'Prices **will be public**, along with the store they refer to.\n\nThat might allow people who know about your Open Food Facts pseudonym to:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 => '推断您居住的地区';

  @override
  String get prices_privacy_warning_message_bullet_2 => '了解您所购买的商品';

  @override
  String get prices_privacy_warning_sub_message =>
      '如果您对此感到不安，请更改您的展示名，或创建一个新的 Open Food Facts 帐户并使用它登录该应用程序。';

  @override
  String get i_refuse => '我拒绝';

  @override
  String get i_accept => '我接受';

  @override
  String get prices_currency_change_proposal_title => '更改货币？';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return '您当前的货币是 **$currency**。您想将其更改为 **$newCurrency** 吗？';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return '是的，使用 $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return '不，保持 $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => '已完成';

  @override
  String get dev_mode_section_server => '服务器配置';

  @override
  String get dev_mode_section_news => '新闻提供商配置';

  @override
  String get dev_mode_section_product_page => '产品页面';

  @override
  String get dev_mode_section_ui => '用户界面';

  @override
  String get dev_mode_section_experimental_features => '实验性功能';

  @override
  String get dev_mode_hide_environmental_score_title => '排除 Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title => '使用拼写检查器进行 OCR 屏幕检查';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '（成分和包装）';

  @override
  String get dev_mode_reset_app_language_title => '重置應用語言';

  @override
  String get dev_mode_add_demo_cards_language_title => '添加卡片';

  @override
  String get dev_mode_openprices_switch_env_title =>
      '在 prices.openfoodfacts.org (PROD) 和測試環境之間切換';

  @override
  String get search_history_item_edit_tooltip => '沿用與編輯此搜尋的項目';

  @override
  String get search_history_item_remove_tooltip => '移除';

  @override
  String product_search_no_more_results(int totalSize) {
    return '已成功加载 $totalSize 产品.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '再加载 $count 产品\n已经加载 $totalSize 产品中的 $downloaded 产品.';
  }

  @override
  String product_search_loading_message(Object search) {
    return '您对 $search 的搜索正在进行中。\n\n请等待几秒钟…';
  }

  @override
  String get user_search_contributor_title => '我添加的产品';

  @override
  String get user_search_informer_title => '我编辑过的产品';

  @override
  String get user_search_photographer_title => '我拍摄过的产品';

  @override
  String get user_search_to_be_completed_title => '需要完善信息的产品';

  @override
  String get user_search_prices_title => '我的价格';

  @override
  String get user_search_proofs_title => '我的样张';

  @override
  String get user_search_proof_title => '我的凭证';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return '貢獻者價格： $user';
  }

  @override
  String get all_search_prices_latest_title => '最新报价';

  @override
  String get all_search_prices_top_user_title => '价格贡献数排行榜';

  @override
  String get all_search_prices_top_location_title => '价格信息最丰富的商店';

  @override
  String get prices_contribution_assistant => '价格贡献助理';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => '添加多个凭证';

  @override
  String get all_search_prices_top_location_single_title => '商店中的价格';

  @override
  String get all_search_prices_top_product_title => '报价信息最丰富的产品';

  @override
  String get all_search_to_be_completed_title => '所有待完善产品';

  @override
  String get categorize_products_country_title => '帮助对您所在国家/地区的产品进行分类';

  @override
  String get edit_product_action_retake_picture => '重拍';

  @override
  String get edit_product_action_take_picture => '拍摄';

  @override
  String get edit_product_action_confirm => '确认';

  @override
  String get signup_page_terms_of_use_line1 => '我同意 Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => '使用及貢獻條款';

  @override
  String get analytics_consent_image_semantic_label => '分析图标';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return '错误: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return '错误: $error';
  }

  @override
  String get summary_card_button_add_basic_details => '完善基本信息';

  @override
  String get edit_photo_button_label => '編輯';

  @override
  String get edit_photo_unselect_button_label => '取消选择照片';

  @override
  String get edit_photo_select_existing_button_label => '选择现有图像';

  @override
  String get edit_photo_select_existing_all_label => '现有图像';

  @override
  String get edit_photo_select_existing_all_subtitle => '单击选择图像';

  @override
  String get edit_photo_select_existing_download_label => '正在获取现有图像…';

  @override
  String get edit_photo_select_existing_downloaded_none => '没有以前上传的与此产品相关的图像。';

  @override
  String get edit_photo_language_not_this_one => '暂无该语言的图像';

  @override
  String get edit_photo_language_none => '暂无图像';

  @override
  String get category_picker_screen_title => '類別';

  @override
  String get basic_details => '基本信息';

  @override
  String get product_name => '产品名称';

  @override
  String get product_names => '产品名称';

  @override
  String get add_basic_details_product_name_add_translation => '添加新翻译';

  @override
  String get add_basic_details_product_name_warning_translations =>
      '验证之前，请确保仅**如果包装上有该语言**才添加翻译';

  @override
  String get add_basic_details_product_name_open_photo => '查看正面照片';

  @override
  String get add_basic_details_product_name_take_photo => '拍摄正面照片';

  @override
  String get add_basic_details_product_name_hint => '输入产品名称（例如：Nutella）';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      '更改預設語言？';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return '您是否希望將產品的預設語言設定為“$language”？';
  }

  @override
  String get explanation_section_good_examples => '正面示例';

  @override
  String get explanation_section_bad_examples => '负面示例';

  @override
  String get add_basic_details_product_name_help_title => '产品名称信息的良好实践';

  @override
  String get add_basic_details_product_name_help_info1 =>
      '产品名称是**包装上印刷的主名称**。它可以是注册商标。';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**注意：**如果包装上没有该语言，请不要添加翻译。**';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => '雀巢';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => '番茄酱';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      '不要在名称中包含品牌';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      '亨氏番茄酱';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '不要使用 ®、™、© 或类似符号';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      '雀巢**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count other translations',
      one: '$count other translation',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => '品牌';

  @override
  String get brand_names => 'Brand names';

  @override
  String get add_basic_details_brand_name_error => '请输入品牌名称';

  @override
  String get add_basic_details_brand_names_hint => 'Input brands (eg: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Good practices: Brands';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Input **all the brands of the product**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Main brand';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'The **main brand**, generally clearly displayed on the front pack, should be **entered first**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Other brands';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'When sold **by a big company**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** is sold by **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'When sold with its brand **translated in multiple languages**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** is sometimes written **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => '数量和重量';

  @override
  String get add_basic_details_quantity_hint =>
      'Input the weight and if needed the quantity (eg : 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Good practices: Quantity';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copy the value indicated on the product and **don\'t forget the units**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** or **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (for 6 eggs)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(for a product with 3 boxes, each of 150g)';

  @override
  String get barcode => '條碼';

  @override
  String barcode_barcode(String barcode) {
    return '条码: $barcode';
  }

  @override
  String get barcode_invalid_error => '條碼無效';

  @override
  String get basic_details_add_success => '基本信息添加成功';

  @override
  String get basic_details_add_error => '无法添加基本信息，请稍后再试';

  @override
  String get clear_search => 'Clear your search';

  @override
  String get confirm_clear => '您即将清除整个历史记录：您确定要继续吗？';

  @override
  String get alert_clear_selected_user_list => '你即将清除历史记录中选定的项目';

  @override
  String get confirm_clear_selected_user_list => '您确定要继续吗？';

  @override
  String get alert_select_items_to_clear => '请选择一个或多个要清理的项目';

  @override
  String confirm_clear_user_list(String name) {
    return '您即将清除此列表 ($name)：您确定要继续吗？';
  }

  @override
  String get confirm_delete_user_list_title => 'Delete the list?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'You\'re about to delete the list \"$name\".\nAre you sure you want to continue?';
  }

  @override
  String get confirm_delete_user_list_button => 'Yes, I confirm';

  @override
  String importance_label(String name, String id) {
    return '$name 重要性: $id';
  }

  @override
  String get user_list_all_title => '列表';

  @override
  String get user_list_all_empty => '创建您的第一个列表';

  @override
  String get product_list_select => '请选择一个列表';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 产品',
      one: '一款产品',
      zero: '空列表',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => '创建列表';

  @override
  String get open_food_preferences_tooltip => '编辑您的食物偏好';

  @override
  String get add_photo_button_label => '添加照片';

  @override
  String get add_packaging_photo_button_label => '对任何包装/回收信息拍照';

  @override
  String get add_origin_photo_button_label =>
      'Take photos of any origin information';

  @override
  String get add_emb_photo_button_label =>
      'Take photos of any traceability code information';

  @override
  String get add_label_photo_button_label =>
      'Take photos of any labels & certifications information';

  @override
  String get choose_image_source_title => '选择图片来源';

  @override
  String get choose_image_source_body => '请选择图片来源';

  @override
  String get gallery_source_label => '相册';

  @override
  String get gallery_source_access_denied_dialog_title => 'Access denied';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Unfortunately, the application can\'t access your gallery, as you have previously denied the permission.\n\nPlease go to the app settings in your phone Settings -> Photos';

  @override
  String get gallery_source_access_denied_dialog_button => 'Open the Settings';

  @override
  String get share => '推荐给好友';

  @override
  String share_product_text(String url) {
    return 'Have a look at this product on Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Have a look at this product on Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Have a look at this product on Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Have a look at this product on Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Have a look at my list of products on Open Food Facts: $url';
  }

  @override
  String get capture => '拍摄';

  @override
  String get capture_new_picture => '選一張圖片';

  @override
  String get choose_from_gallery => '从相册选择';

  @override
  String get image_upload_queued => '图片将尽快上传。';

  @override
  String get add_price_queued =>
      'The price will be sent to the server as soon as possible.';

  @override
  String get background_task_title_full_refresh => '开始刷新本地存储的所有产品';

  @override
  String get background_task_title_top_n => '开始下载最受欢迎的产品';

  @override
  String get expand_nutrition_facts => '展开营养成分表';

  @override
  String get expand_nutrition_facts_body => '扩大营养成分表';

  @override
  String get expand_ingredients => '展开成分';

  @override
  String get expand_ingredients_body => '保持成分面板扩展';

  @override
  String get no_internet_connection => '无互联网连接';

  @override
  String get world_results_label => '整个世界';

  @override
  String get world_results_action => '将您的搜索扩大到全世界';

  @override
  String get copy_to_clipboard => '复制';

  @override
  String get paste_from_clipboard => 'Paste from clipboard';

  @override
  String get no_data_available_in_clipboard =>
      'No data available in your clipboard';

  @override
  String get clipboard_barcode_copy => '将条形码复制到剪贴板';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return '条码 $barcode 已复制到剪贴板！';
  }

  @override
  String get open_product_website => 'Open this product on the website';

  @override
  String get language_picker_label => 'Your language';

  @override
  String get country_picker_label => 'Your country';

  @override
  String get currency_picker_label => 'Your currency';

  @override
  String get help_with_openfoodfacts => '帮助 OpenFoodFacts';

  @override
  String get product_task_background_schedule => '产品将尽快在后台更新。';

  @override
  String get no_email_client_available_dialog_title => '没有电子邮件应用！';

  @override
  String get no_email_client_available_dialog_content =>
      'Please send us manually an email to mobile@openfoodfacts.org';

  @override
  String get all_images => '所有图像';

  @override
  String get selected_images => '选定图片';

  @override
  String get product_card_remove_product_tooltip => '移除产品';

  @override
  String scan_announce_new_barcode(String barcode) {
    return '扫描到一个新条形码：$barcode';
  }

  @override
  String get scan_header_clear_button_tooltip => '从扫描结果轮播中删除所有产品';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      '请扫描至少两个产品以进行比较';

  @override
  String get scan_header_compare_button_valid_state_tooltip => '点击以比较您扫描过的产品';

  @override
  String get scan_product_loading => 'You have scanned\nthe barcode:';

  @override
  String get scan_product_loading_initial =>
      'We\'re looking for this product!\nPlease wait a few seconds…';

  @override
  String get scan_product_loading_long_request =>
      '我们仍在寻找这款产品！\n您觉得加载时间太长吗？我们也觉得…';

  @override
  String get scan_product_loading_unresponsive => '我们仍在寻找该产品。\n您想重新开始搜索吗？';

  @override
  String get scan_product_loading_restart_button => '重新开始搜索';

  @override
  String get portion_calculator_description => '计算特定数量的营养成分';

  @override
  String get portion_calculator_hint => '数量';

  @override
  String get portion_calculator_accessibility => '输入数量来计算营养成分';

  @override
  String portion_calculator_error(int min, int max) {
    return '请输入介于 $min 和 $max g 之间的数量';
  }

  @override
  String get portion_calculator_computation_error => '缺少数据。无法进行计算。';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams 克（或毫升）的营养成分';
  }

  @override
  String get offline_data => '离线数据';

  @override
  String get ocr_image_upload_instruction => '上传图片以自动提取其包含的信息。';

  @override
  String get upload_image => '上传图片';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => '，';

  @override
  String get image_download_error => '图片下载失败';

  @override
  String get image_edit_url_error => '由于未设置图片 URL，无法编辑图片。';

  @override
  String get user_picture_source_remember => '记住我的选择';

  @override
  String get user_picture_source_ask => '每次询问';

  @override
  String get robotoff_continue => '继续';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: ' $count 个问题',
      one: '一个问题',
    );
    return '下$_temp0';
  }

  @override
  String get show_password => '显示密码';

  @override
  String get owner_field_info_title => '生产者提供的价值';

  @override
  String get owner_field_info_message => '我们通过该标志突出显示生产商提供的数据，这些数据可能无法编辑。';

  @override
  String get owner_field_info_close_button => '关闭此信息';

  @override
  String get owner_field_image => '此图片由制造商提供，可能无法编辑。';

  @override
  String get edit_packagings_title => '包装成分';

  @override
  String get edit_packagings_element_add => '添加包装成分';

  @override
  String get edit_packagings_completed => '此包装成分已完整';

  @override
  String edit_packagings_element_title(int index) {
    return '包装成分 #$index';
  }

  @override
  String get edit_packagings_element_field_units => '单位数';

  @override
  String get edit_packagings_element_hint_units => '输入产品中包含的相同形状和材料的包装单位数量。';

  @override
  String get edit_packagings_element_field_shape => '形狀';

  @override
  String get edit_packagings_element_hint_shape =>
      '输入回收说明中列出的形状名称（如果可用），或选择一个形状。';

  @override
  String get edit_packagings_element_example_shape => '瓶子';

  @override
  String get edit_packagings_element_field_material => '材料';

  @override
  String get edit_packagings_element_hint_material =>
      '如果可以确定，请输入具体材料（三角形内的材料代码通常可以在包装部件上找到），如果您不确定，请输入通用材料（例如塑料或金属）。';

  @override
  String get edit_packagings_element_example_material => '玻璃';

  @override
  String get edit_packagings_element_field_recycling => '回收说明';

  @override
  String get edit_packagings_element_hint_recycling => '只有在产品上列出的回收说明才可输入。';

  @override
  String get edit_packagings_element_example_recycling => '回收';

  @override
  String get edit_packagings_element_field_quantity => '每单位产品净数量';

  @override
  String get edit_packagings_element_hint_quantity =>
      '输入净重或净体积并注明单位（例如克 g 或毫升 ml）。';

  @override
  String get edit_packagings_element_field_weight => '一个空单位的重量（克）';

  @override
  String get edit_packagings_element_hint_weight =>
      '在称重之前，请清除所有剩余的食物并清洗和干燥包装部分。如果可能，使用精度为 0.1g 或 0.01g 的秤。';

  @override
  String get background_task_title => '待处理贡献';

  @override
  String get background_task_subtitle => '您的贡献会自动保存到我们的服务器，但并不总是实时的。';

  @override
  String get background_task_list_empty => '没有待处理的后台任务';

  @override
  String get background_task_error_server_time_out => '服务器超时';

  @override
  String get background_task_error_no_internet => '网络连接错误，请稍后再试。';

  @override
  String get background_task_operation_unknown => '未知操作类型';

  @override
  String get background_task_operation_details => '详细更改';

  @override
  String get background_task_operation_image => '照片上传';

  @override
  String get background_task_operation_refresh => '照片上传后刷新延迟';

  @override
  String get background_task_run_started => '已开始';

  @override
  String get background_task_run_not_started => '尚未开始';

  @override
  String get background_task_run_to_be_deleted => '待删除';

  @override
  String get background_task_question_stop => '您想尽快停止该任务吗？';

  @override
  String get feed_back => '意见反馈';

  @override
  String get undo => '撤销';

  @override
  String get copy_email_to_clip_board => '复制电子邮箱到剪贴板';

  @override
  String get please_send_us_an_email_to => '请手动向我们发送电子邮件至';

  @override
  String get email_copied_to_clip_board => '电子邮件地址已复制到剪贴板';

  @override
  String get select_accent_color => '选择强调色';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => '蓝色';

  @override
  String get color_cyan => '青色';

  @override
  String get color_green => '绿色';

  @override
  String get color_light_brown => '默认';

  @override
  String get color_magenta => '洋红色';

  @override
  String get color_orange => '橙色';

  @override
  String get color_pink => '粉色';

  @override
  String get color_red => '红色';

  @override
  String get color_rust => '赤色';

  @override
  String get color_teal => '鸭青色';

  @override
  String get text_contrast_mode => '文本对比度';

  @override
  String get contrast_high => '高';

  @override
  String get contrast_medium => '中等';

  @override
  String get contrast_low => '低';

  @override
  String get product_refresher_internet_not_found => '未找到该产品！';

  @override
  String get product_refresher_internet_not_connected => '您尚未连接到互联网！';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return '服务器宕机 ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return '服务器错误（$exception）';
  }

  @override
  String get product_loader_not_found_title => '未找到该产品！';

  @override
  String product_loader_not_found_message(String barcode) {
    return '我们的数据库中不存在以下条形码对应的产品：$barcode';
  }

  @override
  String get product_loader_network_error_title => '无网络连接';

  @override
  String get product_loader_network_error_message =>
      '请检查您的智能手机是否已连接无线网络或已启用移动数据';

  @override
  String get page_not_found_title => '页面未找到';

  @override
  String get page_not_found_button => '返回首页';

  @override
  String get download_data => '下载数据';

  @override
  String get download_top_products => '下载您所在国家/地区排名前 1000 的产品进行即时扫描';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 的产品',
    );
    return '下载您所在国家/地区排名前 $_temp0进行即时扫描';
  }

  @override
  String get download_in_progress => '正在下载数据\n这可能需要一段时间';

  @override
  String downloaded_products(int num) {
    return '$num 个产品被添加';
  }

  @override
  String get update_offline_data => '更新离线产品数据';

  @override
  String get update_local_database_sub => '使用 Open Food Facts 的最新数据更新本地产品数据库';

  @override
  String get clear_local_database => '清除离线产品数据';

  @override
  String get clear_local_database_sub => '清除应用中的所有本地产品数据以释放空间';

  @override
  String deleted_products(int num) {
    return '$num 个产品被删除';
  }

  @override
  String get loading => '載入中…';

  @override
  String get know_more => '了解更多';

  @override
  String get offline_data_desc => '点击了解更多有关离线数据的信息';

  @override
  String get offline_product_data_title => '离线产品数据';

  @override
  String available_for_download(int num) {
    return '$num 产品可供立即扫描';
  }

  @override
  String get country_selector_title => '选择您的国家：';

  @override
  String get currency_selector_title => '选择您的货币：';

  @override
  String get language_selector_title => '选择您的语言：';

  @override
  String get language_selector_section_selected => '所选语言';

  @override
  String get language_selector_section_frequently_used => '经常使用';

  @override
  String get action_delete_list => '删除';

  @override
  String get action_change_list => '更改当前列表';

  @override
  String get product_list_create => '创建';

  @override
  String get product_list_create_tooltip => 'Create a new list';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return '营养分数（Nutri-Score） $letter （新计算方式）';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score is not applicable (New calculation)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => '未知Green-Score';

  @override
  String get environmental_score_not_applicable_new => 'Green-Score不适用';

  @override
  String get nova_group_generic_new => '超加工食品 - NOVA 集团';

  @override
  String get nova_group_1 => 'NOVA 分组 — 第 1 级';

  @override
  String get nova_group_2 => 'NOVA 分组 — 第 2 级';

  @override
  String get nova_group_3 => 'NOVA 分组 — 第 3 级';

  @override
  String get nova_group_4 => 'NOVA 分组 — 第 4 级';

  @override
  String get nova_group_unknown => '未知 NOVA 分组信息';

  @override
  String get nutrition_facts => '营养水平';

  @override
  String get faq_title_partners => '非政府组织的合作伙伴和赞助人';

  @override
  String get faq_title_vision => 'Open Food Facts 的愿景、使命、价值观和计划';

  @override
  String get faq_title_install_beauty => '安装 Open Beauty Facts 来创建化妆品数据库';

  @override
  String get faq_title_install_pet => '安装 Open Pet Food Facts 来创建宠物食品数据库';

  @override
  String get faq_title_install_product =>
      'Install Open Products Facts to create a products database to extend the life of objects';

  @override
  String get faq_nutriscore_nutriscore =>
      'New calculation of the Nutri-Score: what\'s new?';

  @override
  String get contact_title_pro_page =>
      'Pro? Import your products in Open Food Facts';

  @override
  String get contact_title_pro_email => 'Producer Contact';

  @override
  String get contact_title_press_page => 'Press Page';

  @override
  String get contact_title_press_email => 'Press Contact';

  @override
  String get contact_title_newsletter => 'Subscribe to our newsletter';

  @override
  String get contact_title_calendar => 'Subscribe to our community calendar';

  @override
  String get hunger_games_loading_line1 => 'Please give us a few seconds…';

  @override
  String get hunger_games_loading_line2 => 'We\'re downloading the questions!';

  @override
  String get hunger_games_error_label =>
      'Argh! Something went wrong… and we couldn\'t load the questions.';

  @override
  String get hunger_games_error_retry_button => 'Let\'s retry!';

  @override
  String get reorder_attribute_action => 'Reorder the attributes';

  @override
  String get link_cant_be_opened => '此連結無法在您的裝置上開啟。請檢查您是否安裝了瀏覽器。';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Details for $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Details for $pageName with $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => '推荐给好友';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Where to find the new Nutri-Score calculation?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'The Nutri-Score is applied in 7 countries: France, Germany, Belgium, Spain, Luxembourg, the Netherlands and Switzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Manufacturers have at most **2 years** at the latest after the signature of the decree **to replace** the old calculation with the new one.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => '什麼是綠色分數？';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score 是一個標誌，旨在告知您**食品對環境的影響**。';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      '顏色代碼從代表**影響最小**產品的深綠色（**A+**）到代表**影響最大**產品的深紅色（**F**）不等。';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score 標誌';

  @override
  String get guide_greenscore_lca_title => '核心：生命週期評估（LCA）';

  @override
  String get guide_greenscore_lca_arg1_title => '食品類別的科學評估';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      '對於每個產品類別，使用來自 Agribalyse 環境資料庫（由 ADEME 和 INRAE 設計）的資料建立一個**基準**分數。';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**生命週期分析**是一種進行多階段、多標準環境評估的標準化評估方法。';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**其測量：**';

  @override
  String get guide_greenscore_lca_arg2_title => '6個生產步驟';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agriculture';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processing';

  @override
  String get guide_greenscore_lca_arg2_packaging => '包装';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transportation';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribution';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumption';

  @override
  String get guide_greenscore_lca_arg3_title => '14項環境影響指標';

  @override
  String get guide_greenscore_lca_arg3_text1 => '氣候變遷/碳足跡';

  @override
  String get guide_greenscore_lca_arg3_text2 => '臭氧層損耗';

  @override
  String get guide_greenscore_lca_arg3_text3 => '電離輻射';

  @override
  String get guide_greenscore_lca_arg3_text4 => '土地';

  @override
  String get guide_greenscore_lca_arg3_text5 => '水和能源的使用';

  @override
  String get guide_greenscore_lca_arg3_text6 => '空氣污染';

  @override
  String get guide_greenscore_lca_arg3_text7 => '海水和淡水（顆粒、酸化、富營養化）';

  @override
  String get guide_greenscore_lca_arg3_text8 => '資源枯竭。';

  @override
  String get guide_greenscore_bonuses_penalties_title => '獎金和罰款';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode of production';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => '成分來源';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Endangered species';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => '包装';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'An increased need for transparency to better measure and reduce environmental impacts';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title => '製造商如何提供協助';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      '製造商可以透過我們為生產商提供的免費平台直接向我們發送他們的資訊。';

  @override
  String get guide_greenscore_better_product_title => '哪種產品對地球比較好？';

  @override
  String get guide_greenscore_better_product_arg1_title => '很難說';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      '選擇永續食品是我們為氣候所能做的最強大的事情之一，因為**我們的全球食品系統造成了超過四分之一的溫室氣體排放**。\n（資料來源：Poore & Nemecek，Science，2018）。';

  @override
  String get guide_greenscore_better_product_arg2_title => '你有力量！';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      '好消息是，這為我們提供了一種強而有力的變革方法。\n**我們每個人每年大約吃1000餐**。這意味著我們有1000個機會**為地球選擇更美好的未來**！';

  @override
  String get guide_greenscore_better_product_arg3_title => '幫助承擔責任並做出決定';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      '選擇永續食品可能感覺很複雜。標籤令人困惑，資訊也常常缺少。 Green-Score 的創建旨在簡化這一過程，為您提供**清晰**、**基於科學**且**透明**的食品環境評級，就在您需要的時候：購物時。';

  @override
  String get guide_greenscore_better_product_arg4_title => '透明度';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      '與專有標籤不同，Green-Score 計算**完全開放**，並且**任何人都可以驗證**。';

  @override
  String get guide_nova_title =>
      'The overall purpose of ultra-processing is to create branded, convenient (durable, ready to consume), attractive (hyper-palatable) and highly profitable (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively. Ultra-processed food products are usually packaged attractively and marketed intensively. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_what_is_nova_title => '什麼是超加工？';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'The NOVA groups inform you about **the level of food processing**.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA 分類允許根據食品的**工業加工程度**將其分為**4 類**（最低限度加工或未加工食品、烹飪原料、加工食品、超加工食品）。';

  @override
  String get guide_nova_logos_caption => 'NOVA 標誌';

  @override
  String get guide_nova_groups_title => '4個NOVA組';

  @override
  String get guide_nova_groups_intro => 'NOVA 有 4 組，有問題的是第 4 組 - 超加工食品。';

  @override
  String get guide_nova_groups_arg1_title => '低度加工或未加工食品';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => '加工的烹飪用食品';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from Group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => '第三類： 加工食品';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to Group 1** foods. Processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. Most processed foods have two or three ingredients and are recognizable as modified versions of Group 1 foods. They can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title =>
      'The overall purpose of ultra-processing is to create branded, convenient (durable, ready to consume), attractive (hyper-palatable) and highly profitable (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively. Ultra-processed food products are usually packaged attractively and marketed intensively. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact Group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. However, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. Some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => '超加工的問題';

  @override
  String get guide_nova_explanations_arg1_title => '食品原料的極端加工';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title => '超越純淨食品安全的添加物';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title => '在家無法完成的處理';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title => '超加工的掠奪性和財務面';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-zh.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-zh.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-zh.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-zh.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-zh.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Preview';

  @override
  String get prices_feedback_form =>
      'Click here to send us your feedback about this new feature!';

  @override
  String get menu_button_list_actions => 'Select an action';

  @override
  String get error_loading_photo => 'Error loading photo';

  @override
  String get photo_viewer_action_use_picture_as => 'Use as…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Use this picture as…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Use this picture as… ($language)';
  }

  @override
  String get photo_viewer_details_button => '詳細資訊';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Details of this photo';

  @override
  String get photo_viewer_details_title => 'Details of the photo';

  @override
  String get photo_viewer_details_contributor_title => '貢獻者';

  @override
  String get photo_viewer_details_size_title => 'Size';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => '日期';

  @override
  String get photo_viewer_details_url_title => '網址';

  @override
  String get product_page_compatibility_score => '兼容的';

  @override
  String get user_lists_action_multi_select => '多选';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Your compatibility score: $score%';
  }

  @override
  String get product_image_front_accessibility_label => '封面圖片';

  @override
  String get product_image_ingredients_accessibility_label => '成分照片';

  @override
  String get product_image_nutrition_accessibility_label => '营养信息图片';

  @override
  String get product_image_packaging_accessibility_label => '包装图片';

  @override
  String get product_image_other_accessibility_label => '其他图片';

  @override
  String get product_image_outdated_message => '此图片可能已经过期了';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type （此图片可能已过期）';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type （此图可能被制作者锁定）';
  }

  @override
  String get product_image_error => '无法加载图像！';

  @override
  String product_image_error_accessibility_label(String type) {
    return '无法加载 $type （网络错误？）';
  }

  @override
  String get product_page_image_no_image_available => '没有图像！';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      '此产品暂无图片';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      '重新排序或隐藏操作';

  @override
  String get product_page_action_bar_setting_modal_title => '编辑操作';

  @override
  String get product_page_action_bar_item_move_up => '上移';

  @override
  String get product_page_action_bar_item_move_down => '下移';

  @override
  String get product_page_action_bar_item_enable => '启用操作';

  @override
  String get product_page_action_bar_item_disable => '禁用操作';

  @override
  String get product_page_pending_operations_banner_title => '正在上传您的编辑…';

  @override
  String get product_page_pending_operations_banner_message =>
      '此页面显示的数据**尚未反映您的修改**。\n请等待几秒钟…';

  @override
  String get product_add_a_language => '添加语言';

  @override
  String barcode_accessibility_label(String barcode) {
    return '条形码 $barcode';
  }

  @override
  String get carousel_close_tooltip => '从轮播中移除该产品';

  @override
  String get carousel_unsupported_header => '不支持的条形码！';

  @override
  String get carousel_unsupported_title => '哎呀！';

  @override
  String get carousel_unsupported_text => '扫描的条形码不受 Open Food Facts 支持！';

  @override
  String get carousel_error_header => '错误！';

  @override
  String get carousel_error_title => '真糟糕！';

  @override
  String get carousel_error_text_1 => '我们无法下载此条形码的信息：';

  @override
  String get carousel_error_text_2 => '请检查您的互联网连接或单击此按钮：';

  @override
  String get carousel_error_button => '重試';

  @override
  String get carousel_unknown_product_header => '未知产品';

  @override
  String get carousel_unknown_product_title => '恭喜！你找到了__稀有宝石！__';

  @override
  String get carousel_unknown_product_text =>
      '我们的协作数据库包含超过** 300 万种产品**，但此条形码不存在：';

  @override
  String get carousel_unknown_product_button => '加入此產品';

  @override
  String get carousel_loading_header => '正在加载信息...';

  @override
  String get carousel_loading_title => '您刚刚扫描了带有以下条形码的产品：';

  @override
  String get carousel_loading_text => '我们正在超过**300 万种产品**的数据库中搜索它！';

  @override
  String get product_type_subtitle_food => '蔬菜、水果、冷冻食品…';

  @override
  String get product_type_subtitle_beauty => '化妆品、肥皂、牙膏…';

  @override
  String get product_type_subtitle_pet_food => '狗粮、猫粮…';

  @override
  String get product_type_subtitle_product => '智能手机、家具…';

  @override
  String get photo_field_front => '产品照片';

  @override
  String get photo_field_ingredients => '成分照片';

  @override
  String get photo_field_nutrition => '营养成分的照片';

  @override
  String get photo_field_packaging => '包裝資訊照片';

  @override
  String get photo_already_exists => '这张照片已经存在';

  @override
  String get photo_missing => '这张照片不见了';

  @override
  String get date => '日期';

  @override
  String get photo_rotate_left => '向左旋轉';

  @override
  String get photo_rotate_right => '向右旋轉';

  @override
  String get photo_undo_action => '撤消上一个操作';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location的世界地图';
  }

  @override
  String get open_street_map_contributor_attribution => 'OpenStreetMap 贡献者';

  @override
  String get not_applicable_short => '不适用';

  @override
  String get knowledge_panel_warning_text => '警告';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      '为什么这个 Nutri-Score 与包装上的不同？';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      '可能有两种解释：\n成分表和/或营养成分表不是最新的。\n\n我们提供 Nutri-Score 的“更新版计算方法”。请检查包装上是否有“新计算”的标语。';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Check ingredients';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Check nutrition facts';

  @override
  String url_not_supported(String url) {
    return 'Unfortunately, we can\'t open the URL:\n$url';
  }

  @override
  String get product_list_export => 'Export';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'View barcode';

  @override
  String get product_footer_action_barcode_short => '條碼';

  @override
  String get product_footer_action_open_website => 'Open website';

  @override
  String get product_footer_action_report => 'Report';

  @override
  String get product_footer_action_contributor_guide => '帮助';

  @override
  String get product_footer_action_data_quality_tags => 'Data quality';

  @override
  String get product_page_tab_for_me => '為我';

  @override
  String get product_page_tab_website => '网站';

  @override
  String get product_page_tab_prices => '价格';

  @override
  String get prices_explanation_card_title => '為什麼是價格？';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** 是一個收集和分享全球產品價格的項目🌍。 Open Prices 由 Open Food Facts 開發和維護。';

  @override
  String get explanation_card_learn_more_button => '瞭解更多';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title => '民間分類法的屬性有哪些？';

  @override
  String get folksonomy_explanation_card_line1 => '屬性採用**鍵值對**格式。';

  @override
  String get folksonomy_explanation_card_line2 => '這些屬性由貢獻者建立和歸檔，可用於任何用途。';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => '暫無價格';

  @override
  String get prices_products_empty_explanation => '成為第一個做出貢獻的人！';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize products (total: $total)';
  }

  @override
  String get app_review_title => 'Are you enjoying this app?';

  @override
  String get app_review_low => 'Could do better';

  @override
  String get app_review_medium => 'Not bad';

  @override
  String get app_review_high => 'I love it!';

  @override
  String get app_review_feedback_modal_title => '帮助我们改进我们的应用程序';

  @override
  String get app_review_feedback_modal_content =>
      '如果您有几分钟时间，请填写此表，以便我们可以在以后的更新中改进：';

  @override
  String get app_review_feedback_modal_open_form => '填写表格';

  @override
  String get app_review_feedback_modal_later => '稍后再询问我';

  @override
  String get nutrition_facts_extract_new => '新功能：您可以自动从图片中提取营养成分！';

  @override
  String get nutrition_facts_extract_button_text => '马上解析';

  @override
  String get nutrition_facts_extract_in_progress => '正在提取…';

  @override
  String get nutrition_facts_extract_successful => '提取成功';

  @override
  String get nutrition_facts_extract_failed => '未能从图片中提取营养成分';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => '统计数据';

  @override
  String get prices_stats_title => '价格统计';

  @override
  String get prices_stats_prices_section => '价格';

  @override
  String get prices_stats_products_section => '产品';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => '合作者';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => '其他';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumption';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => '食物';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => '产品';

  @override
  String get prices_stats_pet_food => '寵物食品';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => '國家地區';

  @override
  String get prices_stats_price_tag => '价格标签';

  @override
  String get prices_stats_receipt => '收据';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => '网站';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Other';

  @override
  String get prices_stats_last_updated => '最后更新于';

  @override
  String get prices_stats_error => '加载统计数据时发生错误。';

  @override
  String get product_edit_robotoff_question_answered => 'Question answered!';

  @override
  String get product_edit_robotoff_proof => '证明';

  @override
  String get preferences_card_general => '一般';

  @override
  String get preferences_prices_title => '价格';

  @override
  String get preferences_prices_subtitle => '管理您的價格偏好';

  @override
  String get preferences_card_project => '開放食品事實項目';

  @override
  String get preferences_contribute_title => '貢獻';

  @override
  String get preferences_my_contributions_title => 'My contributions';

  @override
  String get preferences_my_stats_title => '我的統計數據';

  @override
  String get preferences_contribute_subtitle => '翻譯，改進我們的工具…';

  @override
  String get preferences_connect_title => '連接';

  @override
  String get preferences_connect_subtitle => '聯絡我們或在社交媒體上關注我們';

  @override
  String get preferences_support_title => '捐款';

  @override
  String get preferences_support_subtitle => '幫助我們向全球數百萬消費者提供信息';

  @override
  String get preferences_card_help => '幫助與支持';

  @override
  String get preferences_faq_title => '常見問題';

  @override
  String get preferences_faq_subtitle => '獲得問題的答案';

  @override
  String get logged_out => '已註銷';

  @override
  String get preferences_app_bar_message => '感謝您成為我們的會員之一！';

  @override
  String get preferences_app_bar_products_modified => 'Products modified';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => '查看所有統計數據';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '在 $provider 中搜尋“$keyword”';
  }

  @override
  String get preferences_app_bar_search_hint => '搜尋設定（例如 Nutri-Score）';

  @override
  String get preferences_accessibility_show_emoji => '輔助使用：顯示表情符號';

  @override
  String get preferences_accessibility_remove_colors => '輔助使用：刪除顏色';

  @override
  String get preferences_app_settings_products => '产品';

  @override
  String get preferences_card_about => '關於';

  @override
  String get preferences_legal_information_title => '法律資訊';

  @override
  String get preferences_legal_information_subtitle => '使用條款、隱私權政策等';

  @override
  String get preferences_terms_of_use => '使用条款';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts 是一個食品產品資料庫，**由每個人創建，為每個人服務**。\n您可以使用它來做出更好的食物選擇，而且由於它是**開放資料**，任何人都可以**將其重新用於任何目的**。';

  @override
  String get preferences_privacy_policy => '隐私政策';

  @override
  String get preferences_licenses => '許可證';

  @override
  String get preferences_about_app_title => '關於應用程式';

  @override
  String get preferences_about_app_subtitle => '技術資訊、開發人員資訊等';

  @override
  String get preferences_card_information => '資訊';

  @override
  String get preferences_version_number_title => '版本號';

  @override
  String get preferences_scanner_title => '掃描器';

  @override
  String get preferences_app_store => '應用程式商店';

  @override
  String get preferences_app_system_settings => '系統設定';

  @override
  String get preferences_source_code => '存取原始碼';

  @override
  String get preferences_source_code_subtitle => '並開始對數百萬人產生影響';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Complete products';

  @override
  String get preferences_tips => '尖端';

  @override
  String get tips_discover_nutriscore => '探索新的Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => '在Open Food Facts網站上';

  @override
  String get preferences_manage_account_title => '管理我的帳戶';

  @override
  String get preferences_manage_account_tooltip => '管理您的帳戶';

  @override
  String get preferences_change_password_title => '更改我的密碼';

  @override
  String get preferences_danger_zone => '危險區域';

  @override
  String get preferences_account_deletion_subtitle => '您的所有貢獻都將丟失';

  @override
  String get preferences_contributions_title => '貢獻';

  @override
  String get preferences_dev_mode_app_settings_title => '應用程式設定';

  @override
  String get preferences_dev_mode_offline_data_subtitle => '離線掃描產品的非常實驗性的方法';

  @override
  String get preferences_dev_mode_refresh_products_title => '從伺服器刷新所有產品';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      '除非絕對必要，否則請避免這樣做';

  @override
  String get preferences_dev_mode_demo_mode_title => '演示模式';

  @override
  String get preferences_dev_mode_add_cards_title => '將卡片加入掃描儀';

  @override
  String get preferences_dev_mode_add_cards_subtitle => '在掃描器中加入 3 個樣品產品';

  @override
  String get preferences_dev_mode_folksonomy_host_title => '大眾分類法主持人';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return '主持人： $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title => '可訪問性實驗';

  @override
  String get preferences_dev_mode_multi_products_selection_title => '多產品價格選擇';

  @override
  String get preferences_dev_mode_user_ordered_kp_title => '使用者訂購的知識面板';

  @override
  String get preferences_dev_mode_location_search_title => '臨時訪問位置搜索';

  @override
  String get preferences_dev_mode_comparison_title => '並排比較 2 或 3 種產品';

  @override
  String get preferences_dev_mode_product_list_import_title => '產品清單導入';

  @override
  String get preferences_faq_scores_methodologies_title => '分數和方法';

  @override
  String get preferences_faq_nutriscore_subtitle => '了解Nutri-Score的計算方法';

  @override
  String get preferences_faq_nutriscore_v2_subtitle => '了解方法論的主要變化';

  @override
  String get preferences_faq_discover_project_title => '探索項目';

  @override
  String get preferences_faq_discover_off_title => '發現Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - 常見問題';

  @override
  String get preferences_faq_off_ngo_title => 'Open Food Facts非政府組織';

  @override
  String get preferences_about_information_title => '資訊';

  @override
  String get preferences_connect_community_updates_title => '獲取社區更新';

  @override
  String get preferences_connect_newsletter_subtitle => '隨時了解應用程式和社區新聞';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscribe to our community calendar';

  @override
  String get preferences_connect_community_calendar_subtitle => '參加我們的虛擬活動';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts博客';

  @override
  String get preferences_connect_blog_subtitle => '取得最新資訊';

  @override
  String get preferences_connect_community_help_title => '獲取社區協助';

  @override
  String get preferences_connect_improve_app_title => '幫助我們改進應用程式';

  @override
  String get preferences_connect_debug_info_title => '向我們發送調試訊息';

  @override
  String get preferences_connect_debug_info_subtitle => '向我們發送包含詳細調試資訊的電子郵件';

  @override
  String get preferences_connect_feedback_title => '向我們發送有關應用程式的回饋';

  @override
  String get preferences_connect_feedback_subtitle => '幫助塑造應用程式的未來';

  @override
  String get preferences_connect_survey_title => '參與應用調查';

  @override
  String get preferences_connect_survey_subtitle => '幫助我們了解下一步該建立什麼';

  @override
  String get preferences_connect_professionals_title => '專業人士';

  @override
  String get preferences_connect_pro_subtitle =>
      '完全免費，確保 500 個應用程式和數百萬消費者的數據準確無誤。自助服務，與您的 PIM 或電子表格 (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle => '聯絡我們開始使用';

  @override
  String get preferences_connect_press_title => '傳媒';

  @override
  String get preferences_connect_press_page_subtitle => '取得報告所需的所有資料';

  @override
  String get preferences_connect_press_email_subtitle =>
      '如有新聞諮詢或想告知我們您的報告，請聯絡我們';

  @override
  String get preferences_contribute_active_volunteer_title => '成為一名積極的志願者';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      '發展、溝通、設計… 歡迎任何形式的志願服務或專業知識！';

  @override
  String get preferences_contribute_how_to_subtitle => '探索您可以做出貢獻的多種方式';

  @override
  String get preferences_contribute_mobile_dev_title => '行動應用程式開發';

  @override
  String get preferences_contribute_sw_dev_subtitle => '了解如何為軟體開發做出貢獻';

  @override
  String get preferences_contribute_alpha_subtitle => '每日不穩定版本，全新功能';

  @override
  String get preferences_contribute_local_community_title => '發展您的當地社區';

  @override
  String get preferences_contribute_translate_subtitle => '協助軟體、內容、成分分析翻譯';

  @override
  String get preferences_contribute_share_subtitle => '我們準備了一個小模板來幫助您:-)';

  @override
  String get preferences_contribute_country_subtitle => '提高貴國食品透明度的簡單步驟';

  @override
  String get preferences_contribute_data_quality_title => 'Data quality';

  @override
  String get preferences_contribute_data_quality_team_title => '加入數據品質團隊';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      '加入我們的努力，確保資料庫的完整和準確';

  @override
  String get preferences_contributions_products_added_title => '添加的產品';

  @override
  String get preferences_contributions_new_products_subtitle =>
      '我添加到 Open Food Facts 的新產品';

  @override
  String get preferences_contributions_to_be_completed_title => '我需要完成的產品';

  @override
  String get preferences_contributions_all_incomplete_title => '所有未完成產品';

  @override
  String get preferences_my_contributions_prices_title => '价格';

  @override
  String get preferences_my_contributions_my_prices_title => '我的价格';

  @override
  String get preferences_my_contributions_my_prices_subtitle => '我的價格，我的證據…';

  @override
  String get preferences_contributions_all_incomplete_subtitle => '您可以幫助完成的產品';

  @override
  String get preferences_contributions_categorize_subtitle =>
      '幫助計算您所在國家/地區的Nutri-Score和Green-Score';

  @override
  String get preferences_prices_user_prices_subtitle => '我貢獻的價格';

  @override
  String get preferences_prices_proofs_subtitle => '價格標籤和收據';

  @override
  String get preferences_prices_add_receipt_subtitle => '拍攝收據照片並掃描相關條碼';

  @override
  String get preferences_prices_add_price_tags_subtitle => '拍攝商店裡的價格照片';

  @override
  String get preferences_prices_newest_title => '最新價格';

  @override
  String get preferences_prices_newest_subtitle => 'Open Prices社群新增的最新價格';

  @override
  String get preferences_prices_top_contributors_title => '貢獻最多獎項的貢獻者';

  @override
  String get preferences_prices_metrics_title => '開盤價指標';

  @override
  String get preferences_prices_metrics_subtitle => '追蹤專案的進展';

  @override
  String get preferences_prices_ways_contribute_title => '貢獻方式';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      '在人工智慧的幫助下確認自己或他人添加的價格';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      '從相機膠卷中快速添加多張收據或貨架照片';

  @override
  String get preferences_prices_challenges_title => '每月挑戰';

  @override
  String get preferences_prices_challenges_subtitle => '參與每月主題任務收集價格';

  @override
  String get preferences_prices_loyalty_data_title => '恢復您的忠誠度數據';

  @override
  String get preferences_prices_gdpr_subtitle => '了解如何請求您的數據';

  @override
  String get preferences_page_customize_app_title => '自訂應用程式';

  @override
  String get preferences_page_contribute_project_title => '為專案做出貢獻';

  @override
  String get preferences_page_contribute_project_subtitle =>
      '幫助Open Food Facts的簡單方法';

  @override
  String get preferences_page_faq_subtitle => '評分方法、幫助以及有關項目的更多信息';

  @override
  String get product_edit_robotoff_positive_button => '接受建議';

  @override
  String get product_edit_robotoff_negative_button => '拒絕建議';

  @override
  String get product_edit_robotoff_show_proof => '出示證明';

  @override
  String get product_edit_robotoff_expand_proof => '擴大證明';

  @override
  String get product_page_tab_raw_data => '原始數據';

  @override
  String page_indicator_with_total(int current, int total) {
    return '頁 $current / $total';
  }

  @override
  String page_indicator(int current) {
    return '頁 $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count 項中的 $total 項';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count 項中的 $total 項';
  }

  @override
  String item_count(int count) {
    return '$count 件';
  }

  @override
  String item_count_string(String count) {
    return '$count 件';
  }

  @override
  String get prices_no_result => '未找到價格統計。';

  @override
  String get prices_error_loading_more_items => '加載更多項目時出錯';

  @override
  String get prices_proof_error => '身份驗證失敗，無法取得證明';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count 的 $total 證明';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count 的 $total 位貢獻者';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count 個位置中的 $total 個位置';
  }

  @override
  String prices_locations_count(int count) {
    return '$count 位置';
  }

  @override
  String get restart_to_apply_message => '請重新啟動應用程式以應用變更。';

  @override
  String get preferences_app_settings_graphical_interface_title => '圖形介面';

  @override
  String get preferences_app_settings_media_title => '媒體';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts實驗室';

  @override
  String get preferences_root_account_title => '账户';

  @override
  String get preferences_contribute_translate_header =>
      '將 Open Food Facts 引入您的語言';

  @override
  String get preferences_contribute_enroll_alpha => '註冊該應用程式的 alpha 版本';

  @override
  String get preferences_dev_mode_section_data => '貢獻和產品數據';

  @override
  String get preferences_dev_preferences_show_folksonomy_title => '不顯示大眾分類法';

  @override
  String get preferences_account_title => '账户';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '加入於 $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => '名称';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}

/// The translations for Chinese, as used in China (`zh_CN`).
class AppLocalizationsZhCn extends AppLocalizationsZh {
  AppLocalizationsZhCn() : super('zh_CN');

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => '是';

  @override
  String get add => '加入产品';

  @override
  String get account_delete_message => '您确定要删除您的账户吗？\n如果有特殊原因，请在下面分享';

  @override
  String get reason => '原因';

  @override
  String get okay => '好的';

  @override
  String get validate => '验证';

  @override
  String get create => '创建';

  @override
  String get applyButtonText => '应用';

  @override
  String get next_label => '下一個';

  @override
  String get continue_label => '继续';

  @override
  String get exit_label => '退出';

  @override
  String get previous_label => '上一步';

  @override
  String get go_back_to_top => '返回顶端';

  @override
  String get save => '保存';

  @override
  String get save_confirmation => '您确定要保存吗?';

  @override
  String get skip => '跳过';

  @override
  String get cancel => '取消';

  @override
  String get ignore => '忽略';

  @override
  String get close => '關閉';

  @override
  String get no => '否';

  @override
  String get stop => '停止';

  @override
  String get finish => '完成';

  @override
  String get calculate => '计算';

  @override
  String get reset_food_prefs => '重设食物偏好';

  @override
  String get error => '出错';

  @override
  String get error_occurred => '发生错误';

  @override
  String get featureInProgress => '我们正在开发此功能，敬请期待';

  @override
  String get label_web => '在网站查看';

  @override
  String get learnMore => '更多信息';

  @override
  String get unknown => '未知';

  @override
  String get match_very_good => '优秀的配对';

  @override
  String get match_good => '不错的配对';

  @override
  String get match_poor => '较差的配对';

  @override
  String get match_may_not => '可能不匹配';

  @override
  String get match_does_not => '不匹配';

  @override
  String get match_unknown => '未知匹配';

  @override
  String get match_short_very_good => '优秀的配对';

  @override
  String get match_short_good => '不错的配对';

  @override
  String get match_short_poor => '较差的配对';

  @override
  String get match_short_may_not => '可能不匹配';

  @override
  String get match_short_does_not => '不匹配';

  @override
  String get match_short_unknown => '未知匹配';

  @override
  String get licenses => '许可证';

  @override
  String get looking_for => '查找';

  @override
  String get welcomeToOpenFoodFacts => '欢迎使用 Open Food Facts！';

  @override
  String get whatIsOff => 'Open Food Facts 是一个由当地社区推动的全球性非营利组织。';

  @override
  String get productDataUtility => '查看和您的偏好有关的食品数据。';

  @override
  String get healthCardUtility => '选择对您有益的食品。';

  @override
  String get ecoCardUtility => '选择对地球有益的食品。';

  @override
  String get server_error_open_new_issue => '服务器无响应！您可以使用以下链接反馈问题。';

  @override
  String get sign_in_text => '登录您的 Open Food Facts 账号以保存您的贡献';

  @override
  String get incorrect_credentials => '用户名或密码错误。';

  @override
  String get password_lost_incorrect_credentials => '此电子邮件或用户名不存在。请检查您的登录信息。';

  @override
  String get password_lost_server_unavailable => '我们的服务器目前速度缓慢，对此我们深表歉意。请稍后重试。';

  @override
  String get login => '用户名';

  @override
  String get login_result_type_server_unreachable => '网络无法访问';

  @override
  String get login_result_type_server_issue => '服务器出现问题。请稍后再试。';

  @override
  String get login_page_username_or_email => '请输入用户名或邮箱';

  @override
  String get login_page_password_error_empty => '请输入密码';

  @override
  String get create_account => '创建账号';

  @override
  String get sign_in => '登录';

  @override
  String get sign_in_mandatory => '您需要登录才可以使用该功能';

  @override
  String get help_improve_country => '帮助改善您所在国家/地区的 Open Food Facts';

  @override
  String get sign_out => '登出';

  @override
  String get sign_out_confirmation => '您确定要登出吗?';

  @override
  String get password => '密码';

  @override
  String get forgot_password => '忘记密码';

  @override
  String get forgot_password_question => '忘记密码？';

  @override
  String get view_profile => '查看个人资料';

  @override
  String get reset_password => '重置密码';

  @override
  String get reset_password_explanation_text =>
      '如果忘记密码，请输入您的用户名或邮箱地址以接收重置密码验证邮件。请检查您的收件箱，另外，也请记得检查垃圾邮件文件夹。';

  @override
  String get username_or_email => '用户名或邮箱';

  @override
  String get reset_password_done =>
      '一封包含重置密码链接的电子邮件已发送到与您的账户关联的电子邮件地址，请检查您的收件箱或垃圾邮件文件夹。';

  @override
  String get send_reset_password_mail => '更改密码';

  @override
  String get enter_some_text => '请填写信息';

  @override
  String get sign_up_page_title => '注册';

  @override
  String get sign_up_page_action_button => '注册';

  @override
  String get sign_up_page_action_doing_it => '正在注册…';

  @override
  String get sign_up_page_action_ok => '恭喜! 您的账户已经被创建。';

  @override
  String get sign_up_page_display_name_hint => '名称';

  @override
  String get sign_up_page_display_name_error_empty => '请输入您想使用的显示名称';

  @override
  String get sign_up_page_email_hint => '电子邮件';

  @override
  String get sign_up_page_email_error_empty => '电子邮件是必需的';

  @override
  String get sign_up_page_email_error_invalid => '无效电子邮件';

  @override
  String get sign_up_page_username_hint => '用户名: 公开可见';

  @override
  String get sign_up_page_username_error_empty => '请输入用户名';

  @override
  String get sign_up_page_username_error_invalid => '请输入有效的用户名';

  @override
  String get sign_up_page_username_description => '用户名不能包含空格、大写字母或特殊字符。';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return '用户名不能超过 $value 个字符';
  }

  @override
  String get sign_up_page_password_hint => '密码';

  @override
  String get sign_up_page_password_error_empty => '请输入密码';

  @override
  String get sign_up_page_password_error_invalid => '请输入一个有效密码 (包含至少6个字符)';

  @override
  String get sign_up_page_confirm_password_hint => '确认密码';

  @override
  String get sign_up_page_confirm_password_error_empty => '请确认密码';

  @override
  String get sign_up_page_confirm_password_error_invalid => '密码不相符';

  @override
  String get sign_up_page_agree_text => '我同意 Open Food Facts ';

  @override
  String get sign_up_page_terms_text => '使用条款和贡献';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      '创建帐户时, 必须同意使用条款, 然而, 仍然可以通过应用程序进行匿名贡献';

  @override
  String get sign_up_page_producer_checkbox => '我是食品生产商';

  @override
  String get sign_up_page_producer_hint => '生产商/品牌';

  @override
  String get sign_up_page_producer_error_empty => '请输入生产商或品牌名称';

  @override
  String get sign_up_page_subscribe_checkbox =>
      '我想订阅 Open Food Facts 的最新动态（您可以随时取消订阅）';

  @override
  String get sign_up_page_user_name_already_used => '该用户名已存在，请选择一个不同的用户名。';

  @override
  String get sign_up_page_email_already_exists => '已存在。登录该账号或尝试其他电子邮件地址。';

  @override
  String get sign_up_page_provide_valid_email => '请提供一个有效的电子邮箱地址。';

  @override
  String get sign_up_page_server_busy => '非常抱歉，创建您的帐户时遇到了一些技术问题。请稍后重试。';

  @override
  String get settingsTitle => '设置';

  @override
  String get darkmode => '主题';

  @override
  String get darkmode_dark => '深色';

  @override
  String get darkmode_light => '浅色';

  @override
  String get darkmode_system_default => '系统默认';

  @override
  String get thanks_for_contributing => '感谢您的贡献！';

  @override
  String get contributors_label => '他们正在开发应用程序';

  @override
  String get contributors_dialog_title => '贡献者';

  @override
  String contributors_dialog_entry_description(Object name) {
    return '贡献者：$name';
  }

  @override
  String get contributors_description => '此应用程序所有贡献者的列表';

  @override
  String get support => '支持';

  @override
  String get support_join_slack => '在我们的 Slack 频道寻求帮助';

  @override
  String get support_via_forum => '在我们的社区上寻求帮助';

  @override
  String get support_via_email => '给我们发送电子邮件';

  @override
  String get support_via_email_include_logs_dialog_title => '发送应用日志?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      '您是否希望在电子邮件附件中包含应用程序日志?';

  @override
  String get termsOfUse => '使用条款';

  @override
  String get legalNotices => '法律声明';

  @override
  String get privacy_policy => '隐私政策';

  @override
  String get about_this_app => '关于这个应用程序';

  @override
  String get contribute => '贡献';

  @override
  String get contribute_sw_development => '软件开发';

  @override
  String get contribute_develop_text =>
      '所有 Open Food Facts 产品的代码均可在 GitHub 上获取。欢迎您复用代码（代码为开源），并帮助我们改进，造福全球所有人。';

  @override
  String get contribute_develop_text_2 =>
      '您可以加入 Open Food Facts Slack 聊天室，这是提问的首选方式。';

  @override
  String get contribute_develop_dev_mode_title => '开发模式？';

  @override
  String get contribute_develop_dev_mode_subtitle => '启用开发者模式';

  @override
  String get contribute_donate_title => '捐赠';

  @override
  String get contribute_donate_header => '捐助 Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      '请注意，使用内部 alpha 版本，可能会完全丢失数据，并且应用程序可能随时无法使用！';

  @override
  String get contribute_improve_ProductsToBeCompleted => '待完成的产品';

  @override
  String get contribute_improve_header => '改进';

  @override
  String get contribute_improve_text =>
      '数据库是该项目的核心。它简单易用，快速提供帮助。您可以下载手机应用程序，开始添加或改进产品。\n\n另一方面，Open Food Facts 网站提供了多种贡献方式：';

  @override
  String get contribute_translate_header => '翻译';

  @override
  String get contribute_data_quality => '数据质量';

  @override
  String get contribute_translate_link_text => '开始翻译';

  @override
  String get contribute_translate_text =>
      'Open Food Facts 是一个全球项目，涵盖来自 160 多个国家的产品。Open Food Facts 已被翻译成数十种语言，内容也不断更新。';

  @override
  String get contribute_translate_text_2 => '翻译是项目的关键任务之一';

  @override
  String get contribute_join_skill_pool => '为 Open Food Facts 贡献你的技能。加入技能库！';

  @override
  String get contribute_share_header => '与朋友分享 Open Food Facts';

  @override
  String get contribute_share_content =>
      '我想介绍一下我一直在用的一款应用——Open Food Facts，它能让你以个性化的方式了解食物对健康和环境的影响。它的工作原理是扫描包装上的条形码。它完全免费，无需注册，你甚至可以帮助增加了解产品的数量。以下是手机应用下载链接：https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr => '通过请求导出符合 GDPR 规定的会员卡数据，贡献价格信息。';

  @override
  String get tap_to_answer => '点击此处回答问题';

  @override
  String get tap_to_answer_hint => '点击此处回答有关该产品的问题';

  @override
  String get robotoff_questions_loading_hint => '正在加载有关该产品的问题，请稍候';

  @override
  String get saving_answer => '保存您的答案';

  @override
  String get contribute_to_get_rewards => '成为食品透明度的参与者';

  @override
  String get question_sign_in_text => '登录您的 Open Food Facts 帐户，获取您的贡献值';

  @override
  String get question_yes_button_accessibility_value => '回答“是”';

  @override
  String get question_no_button_accessibility_value => '回答“否”';

  @override
  String get question_skip_button_accessibility_value => '跳过该题';

  @override
  String get tap_to_edit_search => '点击打开搜索框';

  @override
  String get myPreferences => '我的偏好';

  @override
  String get account_create_message =>
      '创建您的帐户并加入 Open Food Facts 社区，帮助在世界各地建立食品知识！';

  @override
  String get join_us => '加入我们';

  @override
  String get myPreferences_profile_title => '您的个人信息';

  @override
  String get myPreferences_profile_subtitle => '管理您的 Open Food Facts 贡献者帐户。';

  @override
  String get myPreferences_settings_title => '应用设置';

  @override
  String get myPreferences_settings_subtitle => '黑暗模式，语言…';

  @override
  String get myPreferences_food_title => '食物偏好';

  @override
  String get myPreferences_food_subtitle => '选择对您最重要的食物信息.';

  @override
  String get myPreferences_food_comment =>
      '选择您最关心的食物信息，以便根据您的偏好对食物进行排名，优先查看您关注的信息，并获得兼容性摘要。这些食物偏好设置将保留在您的设备上，并且不会与您的 Open Food Facts 贡献者帐户关联（如果您有的话）。';

  @override
  String get confirmResetPreferences => '重置您的食物偏好?';

  @override
  String get myPersonalizedRanking => '我的个性化排名';

  @override
  String get ranking_tab_all => '全部';

  @override
  String get ranking_subtitle_match_yes => '非常适合';

  @override
  String get ranking_subtitle_match_no => '非常不适合';

  @override
  String get ranking_subtitle_match_maybe => '未知匹配';

  @override
  String get refresh_with_new_preferences => '使用您的新偏好刷新列表';

  @override
  String get reloaded_with_new_preferences => '重新加载新的偏好设置';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => '扫描';

  @override
  String get history_navbar_label => '历史记录';

  @override
  String get list_navbar_label => '列表';

  @override
  String get category => '按类别筛选';

  @override
  String get category_all => '全部';

  @override
  String get category_search => '(类别搜索)';

  @override
  String get filter => '筛选';

  @override
  String get scan => '来自扫描屏幕的产品';

  @override
  String get scan_history => '扫描历史记录';

  @override
  String get search => '搜索';

  @override
  String get search_product_help => '搜索产品\n一个品牌或条形码';

  @override
  String get search_filter => '搜索筛选器';

  @override
  String get search_history => '搜索历史';

  @override
  String get search_store => '搜索商店';

  @override
  String get search_store_help => '提示：添加城市或国家';

  @override
  String get tap_for_more => '点击获取更多信息';

  @override
  String get product => '产品';

  @override
  String get unknownBrand => '未知品牌';

  @override
  String get unknownProductName => '未知产品名称';

  @override
  String get label_refresh => '刷新';

  @override
  String get label_reload => '重新加载';

  @override
  String get image => '图片';

  @override
  String get front_photo => '正面照片';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType （此图片可能已过时）';
  }

  @override
  String get outdated_image_short_label => '可能已经过时';

  @override
  String get ingredients => '成分';

  @override
  String get ingredients_editing_instructions =>
      '保持原始顺序。如需指定，请注明百分比。用逗号或连字符分隔，并使用括号表示成分。';

  @override
  String get ingredients_editing_error => '未能保存配料表。';

  @override
  String get ingredients_editing_image_error => '未能获取配料表图像。';

  @override
  String get ingredients_editing_title => '编辑配料表';

  @override
  String get ingredients_photo => '原料的照片';

  @override
  String get packaging_editing_instructions =>
      '列出用逗号或换行符分隔的所有包装零件，以及它们的数量（例如1或6）类型（例如瓶、盒、罐）、材料（例如塑料、金属、铝）以及它们的尺寸（例如33cl）和回收说明。示例：1个要回收的玻璃瓶，1个要丢弃的塑料软木塞';

  @override
  String get packaging_editing_error => '无法保存包装信息。';

  @override
  String get packaging_editing_image_error => '无法获得新的包装图片。';

  @override
  String get packaging_editing_title => '编辑包装信息';

  @override
  String get nutrition => '营养';

  @override
  String get nutrition_facts_photo => '营养成分的照片';

  @override
  String get nutrition_facts_editing_title => '编辑营养成分表';

  @override
  String get packaging_information => '包装信息';

  @override
  String get packaging_information_photo => '包装信息照片';

  @override
  String get missing_product => '你发现了一件新产品！';

  @override
  String get add_product_take_photos => '拍摄包装照片，将此产品添加到 Open Food Facts';

  @override
  String get add_product_take_photos_descriptive => '请您先拍几张照片，你可以在以后完成操作';

  @override
  String get add_product_information_button_label => '添加产品信息';

  @override
  String get new_product => '新产品';

  @override
  String get new_product_found_title => '发现新产品！';

  @override
  String get new_product_found_text => '我们的协作数据库包含超过** 300 万种产品**，但此条形码不存在：';

  @override
  String get new_product_found_button => '添加该商品';

  @override
  String get new_product_leave_title => '离开此页面吗？';

  @override
  String get new_product_leave_message => '看起来你没有输入任何内容。你真的想要离开这个页面吗？';

  @override
  String get new_product_dialog_description => '请拍摄包装照片以将此产品添加到我们的公共数据库中';

  @override
  String get new_product_dialog_illustration_description =>
      '一张标有未知Nutri-Score和绿色评分的插图';

  @override
  String get front_packaging_photo_button_label => '正面包装照片';

  @override
  String get confirm_front_packaging_photo_button_label => '确认上传正面包装照片';

  @override
  String get confirm_button_label => '确认';

  @override
  String get send_image_button_label => '发送图片';

  @override
  String get crop_page_action_saving => '正在保存图像…';

  @override
  String get crop_page_action_cropping => '剪裁图像…';

  @override
  String get crop_page_action_local => '保存本地版本…';

  @override
  String get crop_page_action_local_failed_title => '啊噢…你的照片有点问题！';

  @override
  String get crop_page_action_local_failed_message =>
      '在把图片上传到服务器前，我们没有办法在本地进行处理。请稍后再试，如果仍有问题请联系我们。';

  @override
  String get crop_page_action_retake => '重拍';

  @override
  String get crop_page_too_small_image_title => '图片尺寸过小';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return '图片上传的最小尺寸（以像素为单位）为 ${expectedMinWidth}x$expectedMinHeight。当前图片的尺寸为 ${actualWidth}x$actualHeight。';
  }

  @override
  String get crop_page_action_server => '准备调用服务器…';

  @override
  String get front_packaging_photo_title => '正面包装照片';

  @override
  String get ingredients_photo_title => '配料表照片';

  @override
  String get nutritional_facts_photo_title => '营养成分表照片';

  @override
  String get recycling_photo_title => '“循环利用标记”的照片';

  @override
  String get take_photo_title => '请拍照';

  @override
  String get take_more_photo_title => '拍摄更多照片';

  @override
  String get front_photo_uploaded => '已上传正面照片';

  @override
  String get ingredients_photo_button_label => '原料的照片';

  @override
  String get ingredients_photo_uploaded => '已上传配料表照片';

  @override
  String get nutrition_cache_loading_error => '无法从缓存中加载营养成分';

  @override
  String get nutritional_facts_photo_button_label => '营养成分的照片';

  @override
  String get nutritional_facts_input_button_label => '填写营养成分表';

  @override
  String get nutritional_facts_added => '已添加营养成分表';

  @override
  String get categories_added => '分类已添加';

  @override
  String get new_product_title_nutriscore => '计算营养评分（Nutri-Score）';

  @override
  String get new_product_subtitle_nutriscore => '帮助我们填写至少一个类别和营养价值';

  @override
  String get new_product_title_environmental_score => '计算 Green Score';

  @override
  String get new_product_subtitle_environmental_score => '填写至少一个类别即可获得';

  @override
  String get new_product_additional_environmental_score =>
      '通过原产地、包装等因素使 Green Score 计算更加精确';

  @override
  String get new_product_title_nova => '计算食品加工水平（NOVA）';

  @override
  String get new_product_subtitle_nova => '通过填写食品类别和配料获得它';

  @override
  String get new_product_desc_nova_unknown => '食品加工水平未知';

  @override
  String get new_product_title_pictures => '添加产品';

  @override
  String get new_product_title_pictures_details =>
      '请拍摄以下照片，Open Food Facts 引擎可以解决剩下的问题！';

  @override
  String get new_product_title_misc => '还有一些基本数据…';

  @override
  String new_product_done_msg(String username) {
    return '感谢您的贡献“$username”！';
  }

  @override
  String get new_product_done_msg_no_user => '感谢您的贡献！';

  @override
  String get new_product_done_button_label => '发现已完成录入的产品';

  @override
  String get hey_incomplete_product_message =>
      '立即点击回答 3 个问题来计算Nutri-Score、绿色分数和超加工分组 (NOVA)！';

  @override
  String get hey_incomplete_product_message_beauty => '立即点击回答 2 个问题来帮助分析这款化妆品！';

  @override
  String get hey_incomplete_product_message_pet_food =>
      '立即点击回答 3 个问题来帮助分析这种宠物食品！';

  @override
  String get hey_incomplete_product_message_product => '立即点击以帮助完成该产品信息的收集！';

  @override
  String get nutritional_facts_photo_uploaded => '已上传营养成分表照片';

  @override
  String get recycling_photo_button_label => '“循环利用标记”的照片';

  @override
  String get recycling_photo_uploaded => '已上传“循环利用标记”的照片';

  @override
  String get take_more_photo_button_label => '拍摄更多照片';

  @override
  String get other_photo_uploaded => '已上传其他照片';

  @override
  String get retake_photo_button_label => '重拍';

  @override
  String get selecting_photo => '正在选择照片';

  @override
  String get uploading_image => '正在向服务器上传照片';

  @override
  String get uploading_image_type_front => '将正面图片上传至 Open Food Facts';

  @override
  String get uploading_image_type_ingredients => '将食材图片上传至 Open Food Facts';

  @override
  String get uploading_image_type_nutrition => '将营养成分图片上传至 Open Food Facts';

  @override
  String get uploading_image_type_packaging => '将包装图片上传至 Open Food Facts';

  @override
  String get uploading_image_type_other => '上传其他图片至 Open Food Facts';

  @override
  String get uploading_image_type_generic => '将图片上传至 Open Food Facts';

  @override
  String get score_add_missing_ingredients => '添加缺失的成分';

  @override
  String get score_add_missing_packaging_image => '添加缺失的包装照片';

  @override
  String get score_add_missing_nutrition_facts => '添加缺失的营养成分';

  @override
  String get score_add_missing_product_traces => '添加缺失的产品轨迹';

  @override
  String get score_add_missing_product_category => '选择一个类别';

  @override
  String get score_add_missing_precise_product_category => '选择更精确的类别';

  @override
  String get score_add_missing_product_countries => '添加缺失的产品产地国';

  @override
  String get score_add_missing_product_emb => '添加缺失的产品代码（翻译注：可能是条形码';

  @override
  String get score_add_missing_product_labels => '添加缺失的产品标签';

  @override
  String get score_add_missing_product_origins => '添加缺失的产品来源';

  @override
  String get score_add_missing_product_stores => '添加缺失的产品来源商店';

  @override
  String get score_add_missing_product_brands => '添加缺失的产品品牌';

  @override
  String get score_update_nutrition_facts => '更新营养成分表';

  @override
  String get nutrition_page_title => '营养成分表';

  @override
  String get nutrition_page_nutritional_info_title => '营养信息';

  @override
  String get nutrition_page_nutritional_info_label => '产品上标明的数值：';

  @override
  String get nutrition_page_nutritional_info_value_positive => '是';

  @override
  String get nutrition_page_nutritional_info_value_negative => '否';

  @override
  String get nutrition_page_nutritional_info_open_photo => '打开照片';

  @override
  String get nutrition_page_nutritional_info_explanation_title => '良好做法：营养信息';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      '有时，营养成分信息**并未标注在包装上**，也未出现在产品随附的文件中。在这种情况下，且仅在这种情况下，您可以将该值设置为**否**。';

  @override
  String get nutrition_page_serving_type_label => '营养价值：';

  @override
  String get nutrition_page_per_100g => '每 100 克';

  @override
  String get nutrition_page_per_100g_100ml => '每100克/100毫升';

  @override
  String get nutrition_page_per_serving => '每份';

  @override
  String get nutrition_page_add_nutrient => '添加营养';

  @override
  String get nutrition_page_serving_size => '份量';

  @override
  String get nutrition_page_serving_size_hint => '输入份量（例如：100g）';

  @override
  String get nutrition_page_serving_size_explanation_title => '良好做法：份量';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      '这个值有助于**对每份食物中的每种营养素进行比例计算**。';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**允许的单位**为：kg、g、mg、μg、oz、l、dl、cl、ml、fl.oz、fl oz、г、мг、кг、л、дл、кл、мл、毫克、公斤、毫升、公升、吨。';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**、**60g** 或 **60 G**（建议使用第一个，它们都代表克）';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 毫升** 或 **1 升**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      '无效单位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30克';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      '无效单位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 颗糖果和 2 块饼干';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      '缺少单位';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => '无效的数字';

  @override
  String get nutrition_page_update_running => '正在更新服务器上的产品…';

  @override
  String get nutrition_page_update_done => '产品已更新！';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      '使用产品数量作为份量';

  @override
  String get nutrition_page_photo_error => '无法加载照片';

  @override
  String get more_photos => '更有趣的照片';

  @override
  String get view_more_photo_button => '查看该产品的所有现有照片';

  @override
  String get no_product_found => '没有找到的产品';

  @override
  String get no_location_found => '未找到位置';

  @override
  String get not_found => '未找到:';

  @override
  String get refreshing_product => '产品更新中';

  @override
  String get product_refreshed => '产品已更新';

  @override
  String product_image_accessibility_label(String date) {
    return '图片拍摄于 $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return '图片拍摄于 $date。此图片可能已过时';
  }

  @override
  String get product_image_outdated => '此图片可能已过期';

  @override
  String get product_image_outdated_explanations_title => '此图片可能已过期';

  @override
  String get product_image_outdated_explanations_content =>
      '这张照片拍摄于一年多以前。\n请检查它是否仍为最新版本。\n\n这只是一个警告。如果内容和现在仍然相同，您可以忽略此消息。';

  @override
  String product_image_action_replace_photo(String type) {
    return '替换照片 ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return '添加照片 ($type)';
  }

  @override
  String get product_image_action_take_new_picture => '拍一张新照片';

  @override
  String get product_image_action_take_picture => '请拍照';

  @override
  String get product_image_action_from_gallery => '从手机图库中选择';

  @override
  String get product_image_action_choose_existing_photo => '从产品照片中选择';

  @override
  String get product_image_details_label => '有关照片的信息';

  @override
  String get product_image_details_from_producer => '来自制造商';

  @override
  String get product_image_details_contributor => '贡献者';

  @override
  String get product_image_details_contributor_producer => '贡献者（制片人）';

  @override
  String get product_image_details_date => '日期';

  @override
  String get product_image_details_date_unknown => '未知';

  @override
  String get homepage_main_card_logo_description => '欢迎使用 Open Food Facts';

  @override
  String get homepage_main_card_subheading => '扫描条形码或\n搜索产品';

  @override
  String get homepage_main_card_search_field_hint => '搜索产品';

  @override
  String get homepage_main_card_search_field_tooltip => '开始搜索';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return '最新消息： $news_title';
  }

  @override
  String get tagline_app_review => '你喜欢这个应用程序吗？';

  @override
  String get tagline_app_review_button_positive => '我太爱它了！😍';

  @override
  String get tagline_app_review_button_negative => '不太喜欢';

  @override
  String get tagline_app_review_button_later => '稍后再询问我';

  @override
  String get tagline_feed_news_button => '了解更多';

  @override
  String get app_review_negative_modal_title => '您不喜欢我们的应用程序吗？';

  @override
  String get app_review_negative_modal_text => '您能花点时间告诉我们原因吗？';

  @override
  String get app_review_negative_modal_positive_button => '绝对是这样没错！';

  @override
  String get app_review_negative_modal_negative_button => '否';

  @override
  String get could_not_refresh => '无法刷新产品';

  @override
  String get product_internet_error_modal_title => '发生错误！';

  @override
  String product_internet_error_modal_message(String error) {
    return '由于网络错误，我们无法获取此产品的相关信息。请检查您的网络连接，然后重试。\n\n内部错误：\n$error';
  }

  @override
  String get product_tags_title => '产品属性';

  @override
  String get no_product_tags_found_message => '未找到产品属性。产品属性可以更详细、更灵活地描述产品。';

  @override
  String get product_tags_empty => '没有属性';

  @override
  String get product_tags_explanation => '通过向产品添加属性（键/值），您可以帮助丰富产品。';

  @override
  String get add_tag => '添加属性';

  @override
  String get add_tags => '添加属性';

  @override
  String get add_edit_tags => '添加或编辑属性';

  @override
  String get edit_tag => '编辑属性';

  @override
  String get remove_tag => '删除属性';

  @override
  String get tag_key => '属性';

  @override
  String get tag_keys => '特性';

  @override
  String get tag_key_uneditable => '属性（不可编辑）';

  @override
  String get tag_key_input_hint => '输入属性';

  @override
  String get tag_value => '值';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => '输入一个值';

  @override
  String get tag_key_item => '财产：';

  @override
  String get tag_value_item => '价值：';

  @override
  String get tag_key_explanations => '密钥必须为小写字母，且不包含空格。';

  @override
  String tag_key_already_exists(String property) {
    return '已存在具有属性 $property 的标签！';
  }

  @override
  String get product_internet_error => '由于网络错误，无法获取有关此产品的信息。';

  @override
  String get cached_results_from => '显示结果来自：';

  @override
  String get product_search_same_category => '寻找替代方案';

  @override
  String get product_search_same_category_short => '比较';

  @override
  String get product_search_same_category_error =>
      '此功能仅适用于已设置分类的产品。\n\n请编辑产品以添加分类。';

  @override
  String get product_improvement_add_category => '添加类别以计算Nutri-Score。';

  @override
  String get product_improvement_add_nutrition_facts => '添加营养成分以计算Nutri-Score。';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      '添加营养成分和类别以计算 Nutri-Score。';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      '无法计算此产品的Nutri-Score，这可能是由于例如：非标准类别。如果这被认为是错误，请与我们联系。';

  @override
  String get product_improvement_obsolete_nutrition_image => '营养表图片已过时，请刷新。';

  @override
  String get product_improvement_origins_to_be_completed =>
      '绿色评分会考虑成分的来源。请拍摄成分列表和/或任何地理标志声明的照片，或编辑产品信息，以便我们将其纳入考量。';

  @override
  String get country_chooser_label => '请提供国家信息';

  @override
  String get currency_chooser_label => '请选择货币';

  @override
  String get country_change_message => '您刚刚更改了国家/地区。';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return '您想将货币从 $previousCurrency 更改为 $possibleCurrency吗？';
  }

  @override
  String get onboarding_country_chooser_label => '请选择国家/地区：';

  @override
  String get country_chooser_label_from_settings => '你的国家';

  @override
  String get country_selection_explanation => '有些环境特征是因地而异的。';

  @override
  String get product_removed_comparison => '已从对比中删除该产品';

  @override
  String get native_app_settings => '本机应用程序设置';

  @override
  String get native_app_description => '开放食品事实的开放系统设置';

  @override
  String get product_removed_history => '已从历史记录中删除该产品';

  @override
  String get product_removed_list => '把产品从列表移除';

  @override
  String get product_could_not_remove => '无法移除产品';

  @override
  String get no_prodcut_in_list => '这个列表中没有产品';

  @override
  String get no_product_in_section => '这个区域没有产品';

  @override
  String get recently_seen_products => '所有浏览过的产品';

  @override
  String get clear => '清除';

  @override
  String get clear_long => '清空列表';

  @override
  String get really_clear => '确定要删除此列表吗？';

  @override
  String pct_match(Object percent) {
    return '$percent% 匹配度';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 天前',
      one: '一天前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 小时前',
      one: '一小时前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 分钟前',
      one: '1 分钟前',
      zero: '不到一分钟前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 个月前',
      one: '一个月前',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 周前',
      one: '一周前',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '比较 $count 种产品',
      one: '比较一种产品',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 已选择商品',
      one: '已选择一件商品',
      zero: '未选择商品',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => '比较选定的产品';

  @override
  String get delete_products_mode => '删除选定的产品';

  @override
  String get select_all_products_mode => '选择所有产品';

  @override
  String get select_none_products_mode => '全部不选';

  @override
  String get compare_products_appbar_title => '比较产品';

  @override
  String get compare_products_appbar_subtitle => '请至少选择两个产品';

  @override
  String get retry_button_label => '重试';

  @override
  String get connect_with_us => '联系我们';

  @override
  String get tiktok => '在 TikTok 上关注我们';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => '在 Instagram 上关注我们';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => '在 X（原 Twitter）上关注我们';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => '在 Mastodon 上关注我们';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => '在 BlueSky 上关注我们';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => '博客';

  @override
  String get faq => '常见问题';

  @override
  String get discover => '发现';

  @override
  String get how_to_contribute => '如何贡献数据';

  @override
  String get hint_knowledge_panel_message => '点击卡片任意部分获取更多信息。立即尝试！';

  @override
  String get permissions_page_title => '相机访问权限';

  @override
  String get permissions_page_body1 => '要使用手机相机扫描条形码，请授权访问。';

  @override
  String get permissions_page_body2 => '如果您改变主意，可以随时在设置里启用或禁用此功能。';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return '操作系统：Android（SDK Int： $sdkInt / 版本： $release）\n型号： $model\n产品： $product\n设备： $device\n品牌：$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return '操作系统： iOS （$version)\n型： $model\n本地化模型： $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\n应用版本：$appVersion\n应用内部版本号：$appBuildNumber\n应用包名称：$appPackageName';
  }

  @override
  String get authorize_button_label => '授权';

  @override
  String get refuse_button_label => '拒绝';

  @override
  String get ask_me_later_button_label => '稍后';

  @override
  String get are_you_sure => '确定吗？';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return '继续了解 $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => '欢迎 ！';

  @override
  String get onboarding_home_welcome_text2 => '该应用程序可帮助您选择对您和地球都有益的食物！';

  @override
  String get onboarding_continue_button => '继续';

  @override
  String get onboarding_welcome_loading_dialog_title => '正在加载您的第一个产品';

  @override
  String get onboarding_welcome_warning => '抱歉，这是我们的示例产品，您无法编辑 :)';

  @override
  String get product_list_your_ranking => '您的排名';

  @override
  String get product_list_empty_icon_desc => '无历史记录';

  @override
  String get product_list_empty_title => '开始扫描';

  @override
  String get product_list_empty_message => '扫描的产品会出现在这里，您可以查看详细信息。';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '产品',
      one: '产品',
      zero: '产品',
    );
    return '重新加载在你历史记录中的$_temp0';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '产品',
      one: '产品',
      zero: '产品',
    );
    return '$_temp0重新加载完成';
  }

  @override
  String get loading_dialog_default_title => '正在下载数据';

  @override
  String get loading_dialog_default_error_message => '无法下载数据';

  @override
  String get account_delete => '删除账号';

  @override
  String get account_delete_title => '删除我的帐户';

  @override
  String get user_profile => '账户';

  @override
  String get user_profile_title_guest => '欢迎!';

  @override
  String get user_profile_subtitle_guest => '登录或注册加入 Open Food Facts 社区';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts 登录： $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return '欢迎 $id！';
  }

  @override
  String get email_subject_account_deletion => '删除账号';

  @override
  String email_body_account_deletion(String userId) {
    return '您好，请删除我的 Open Food Facts 帐户： $userId';
  }

  @override
  String get settings_app_app => '应用程序';

  @override
  String get settings_app_data => '功能和崩溃监控';

  @override
  String get settings_app_camera => '相机';

  @override
  String get settings_app_products => '产品';

  @override
  String get settings_app_miscellaneous => '其他';

  @override
  String get camera_play_sound_title => '在扫描时播放声音';

  @override
  String get camera_play_sound_subtitle => '每次成功扫描都会发出蜂鸣声';

  @override
  String get camera_window_accessibility_label => '使用相机扫描条形码';

  @override
  String get app_haptic_feedback_title => '振动 触觉';

  @override
  String get app_haptic_feedback_subtitle => '执行某些操作后的振动（条形码已解码，产品已移除…）。';

  @override
  String get crash_reporting_toggle_title => '向我们报告错误和崩溃';

  @override
  String get crash_reporting_toggle_subtitle =>
      '启用后，崩溃报告会自动提交给 Open Food Facts 的错误跟踪系统，以便修复错误并改进应用程序。';

  @override
  String get send_anonymous_data_toggle_title => '向我们报告功能使用情况';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      '启用后，有关功能使用情况的严格匿名信息将发送至 Open Food Facts 服务器，以便我们了解功能的使用情况，从而改进功能。';

  @override
  String get product_edit_photo_title => '编辑照片';

  @override
  String get permission_photo_error => '错误';

  @override
  String get permission_photo_denied_title => '允许使用照相机扫描条码';

  @override
  String permission_photo_denied_message(String appName) {
    return '为了提高使用体验，请允许$appName访问您的照相机。以便于直接扫描条码。';
  }

  @override
  String get permission_photo_denied_button => '允许';

  @override
  String get permission_photo_denied_dialog_settings_title => '没有权限';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      '因为之前拒绝了访问照相机，所以只能在设置里手动允许使用照相机。';

  @override
  String get permission_photo_denied_dialog_settings_button_open => '打开权限设置';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => '取消';

  @override
  String get permission_photo_none_found => '没有检测到摄像头';

  @override
  String get permission_photo_denied => '未授权访问照相机';

  @override
  String get show_product_pictures => '显示产品图片';

  @override
  String get edit_product_label => '编辑产品';

  @override
  String get edit_product_pending_operations_banner_title => '正在上传您的编辑…';

  @override
  String get edit_product_pending_operations_banner_message =>
      '您的编辑正在后台发送（如果出现错误则稍后发送）。\n您可以继续编辑其他产品字段。';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      '您的编辑内容正在**后台发送**（如果出现错误，则会稍后发送）。';

  @override
  String get edit_product_label_short => '编辑';

  @override
  String edit_product_form_item_help(String value) {
    return '如何输入“$value”？';
  }

  @override
  String get edit_product_form_item_error_empty => '请输入非空值！';

  @override
  String get edit_product_form_item_error_existing => '数值已经存在！';

  @override
  String get edit_product_form_item_add_action_brand => '添加新品牌';

  @override
  String get edit_product_form_item_add_action_label => '添加新标签';

  @override
  String get edit_product_form_item_add_action_store => '添加新商店';

  @override
  String get edit_product_form_item_add_action_origin => '添加新产地';

  @override
  String get edit_product_form_item_add_action_emb_code => '添加新的追溯代码';

  @override
  String get edit_product_form_item_add_action_country => '添加新国家';

  @override
  String get edit_product_form_item_add_action_category => '添加新类别';

  @override
  String get edit_product_form_item_add_action_trace => '添加一个新的轨迹';

  @override
  String get edit_product_form_item_add_suggestion => '添加建议';

  @override
  String get edit_product_form_item_deny_suggestion => '拒绝建议';

  @override
  String get edit_product_form_item_details_title => '基本信息';

  @override
  String get edit_product_form_item_details_subtitle => '产品名称、品牌、数量';

  @override
  String get edit_product_form_item_other_details_title => '额外细节';

  @override
  String get edit_product_form_item_other_details_subtitle => '产品网站…';

  @override
  String get edit_product_form_item_photos_title => '照片';

  @override
  String get edit_product_form_item_photos_subtitle => '添加或刷新照片';

  @override
  String get edit_product_form_item_labels_title => '标签和证书';

  @override
  String get edit_product_form_item_labels_subtitle => '环保、质量标签…';

  @override
  String get edit_product_form_item_labels_hint => '输入标签（例如：NutriScore）';

  @override
  String get edit_product_form_item_labels_type => '标签';

  @override
  String get edit_product_form_item_labels_explanation_title => '良好做法：标签';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      '产品的任何特性，**是真实的**，并且与其他领域不同。';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      '营养评分（Nutri-Score），NOVA 分组…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      '比利时制造，布列塔尼生产…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001、ISO 22000 产品质量标准…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      '富含纤维，铁的来源…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      '公平贸易，Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => '商店';

  @override
  String get edit_product_form_item_stores_hint => '输入商店信息';

  @override
  String get edit_product_form_item_stores_type => '商店';

  @override
  String get edit_product_form_item_stores_explanation_title => '关于商店信息的良好实践';

  @override
  String get edit_product_form_item_stores_explanation_info1 => '输入您购买产品的商店。';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 => '沃尔玛';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 => '家乐福';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 => '利德尔';

  @override
  String get edit_product_form_item_origins_title => '起源';

  @override
  String get edit_product_form_item_origins_hint => '输入原产地（例如：德国）';

  @override
  String get edit_product_form_item_origins_type => '國家';

  @override
  String get edit_product_form_item_origins_explanation_title => '关于原产地信息的良好实践';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '添加**您可以在包装上找到的任何原产地指示**。\n您不需要添加成分表中直接指示的原产地。';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      '阿根廷牛肉';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      '这种大豆并非来自欧盟。';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint => '输入国家（例如：德国）';

  @override
  String get edit_product_form_item_countries_type => '國家';

  @override
  String get edit_product_form_item_countries_explanations_title => '良好做法：国家';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**产品广泛销售的国家/地区**（不包括专门销售外国产品的商店）。';

  @override
  String get edit_product_form_item_emb_codes_title => '可追踪码';

  @override
  String get edit_product_form_item_emb_codes_hint => '输入溯源码';

  @override
  String get edit_product_form_item_emb_codes_type => '可追踪码';

  @override
  String get edit_product_form_item_emb_help_title => '良好实践：可追溯性代码';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      '在本部分，您可以输入与**包装标志**、**识别标志**或**卫生标志**相关的代码。';

  @override
  String get edit_product_form_item_emb_help_info2_title => '可追溯性代码示例';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '欧盟用于识别食品生产商或包装商的 EC 代码：';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      '法国\n72.264.002\n欧洲';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**：法国国家代码\n**72.264.002**：地理数据\n**CE**：欧盟';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '法国使用的 EMB 代码：';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => '跟踪';

  @override
  String get edit_product_form_item_traces_hint => '跟踪';

  @override
  String get edit_product_form_item_traces_type => '输入追踪信息（例如：大豆）';

  @override
  String get edit_product_form_item_categories_title => '类别';

  @override
  String get edit_product_form_item_categories_hint => '类别';

  @override
  String get edit_product_form_item_categories_type => '输入类别（例如：橙汁）';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      '关于分类信息的良好实践';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '请仅指定最具体的类别。\n系统将自动添加父类别。';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      '缺少类别？';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      '如果某个类别**在自动完成中不可用**，请随意添加。\n这将帮助我们改进您所在国家/地区的 Open Food Facts。';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      '橄榄油浸沙丁鱼';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      '浓缩橙汁';

  @override
  String get edit_product_form_item_exit_title => '数据未保存，退出吗？';

  @override
  String get edit_product_form_item_exit_confirmation => '是否再离开页面前保存?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button => '保存更改';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button => '放弃更改';

  @override
  String get edit_product_form_item_ingredients_title => '成分';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      '通过捏合手势来放大和缩小';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      '放大和缩小照片';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '使用捏合缩放手势，您可以放大或缩小照片：';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => '加入产品';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip => '请先输入文字';

  @override
  String get edit_product_form_item_remove_item_tooltip => '移除';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => '保存';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip => '取消';

  @override
  String get edit_product_form_item_packaging_title => '回收说明照片';

  @override
  String get edit_product_form_item_nutrition_facts_title => '营养成分';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle => '营养成分、酒精含量……';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      '良好做法：营养成分';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      '营养价值';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      '首先，选择**是否提供值**：';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      '营养成分';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      '然后，输入包装上所示的营养成分数值。如果没有数值，您可以点击“眼睛”图标。';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      '缺少字段？';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      '如果缺少某个条目，您可以**点击“加号”图标**添加它（例如：维生素 D、镁…）。';

  @override
  String get edit_product_form_save => '编辑';

  @override
  String get edit_product_ingredients_photo_title => '原料的照片';

  @override
  String get edit_product_ingredients_list_title => '成分列表';

  @override
  String get edit_product_packaging_photo_title => '包装照片';

  @override
  String get edit_product_packaging_list_title => '包装清单';

  @override
  String get no_data_available => '暂无数据';

  @override
  String get product_field_website_title => '网站';

  @override
  String get origins_editing_title => '编辑起源';

  @override
  String get completed_basic_details_btn_text => '完善基本信息';

  @override
  String get not_implemented_snackbar_text => '尚未生效';

  @override
  String get category_picker_page_appbar_text => '类别';

  @override
  String get edit_ingredients_extract_ingredients_btn_text => '从照片中提取成分';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short => '提取成分';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text => '从照片中提取成分\n';

  @override
  String get edit_ingredients_loading_photo_btn_text => '正在加载照片…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title => '为什么我会看到这条消息？';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '要使用“提取成分”功能，需要先上传照片。\n\n请稍等片刻或手动输入。';

  @override
  String get edit_ingredients_refresh_photo_btn_text => '刷新照片';

  @override
  String get edit_packaging_extract_btn_text => '从照片中提取包装\n';

  @override
  String get edit_packaging_extract_btn_text_short => '提取包装';

  @override
  String get edit_packaging_extracting_btn_text => '从照片中提取包装信息';

  @override
  String get edit_packaging_loading_photo_btn_text => '正在加载照片…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title => '为什么我会看到这条消息？';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '要使用“提取包装”功能，需要先上传照片。\n\n请稍等片刻或手动输入。';

  @override
  String get edit_packaging_refresh_photo_btn_text => '刷新照片';

  @override
  String get edit_ocr_extract_failed => '无法检测图像中的文本。';

  @override
  String get edit_ocr_extract_disabled_title => '没有图片！';

  @override
  String get edit_ocr_extract_disabled_message => '要使用文本提取功能，您必须先拍摄一张照片。';

  @override
  String get user_list_dialog_new_title => '新产品列表';

  @override
  String get user_list_dialog_rename_title => '重命名列表';

  @override
  String get user_list_subtitle_product => '列表';

  @override
  String get user_list_title => '您的清单';

  @override
  String get user_list_add_product => '将产品添加到您的列表';

  @override
  String get user_list_button_new => '创建新列表';

  @override
  String get user_list_empty_label => '暂无列表！\n请先创建一个。';

  @override
  String get user_list_button_add_product => '添加到列表';

  @override
  String get added_to_list_msg => '已添加到列表';

  @override
  String get user_list_popup_clear => '清除历史记录';

  @override
  String get user_list_popup_rename => '重命名';

  @override
  String get user_list_name_hint => '我的列表';

  @override
  String get user_list_name_error_empty => '名称是必填项';

  @override
  String get user_list_name_error_already => '名称已被使用';

  @override
  String get user_list_name_error_same => '名称重复';

  @override
  String get user_list_name_input_hint => '列表名称';

  @override
  String get try_again => '重试';

  @override
  String get there_was_an_error => '有错误产生';

  @override
  String category_picker_no_category_found_message(String items) {
    return '没有 $items 对应的类别';
  }

  @override
  String get camera_toggle_camera => '在后置和前置相机之间切换';

  @override
  String get camera_toggle_flash => '打开或关闭摄像头的闪光灯';

  @override
  String get camera_enable_flash => '打开闪光灯';

  @override
  String get camera_disable_flash => '禁用闪光灯';

  @override
  String get camera_flash_error_dialog_title => '发生错误';

  @override
  String get camera_flash_error_dialog_message =>
      '更改闪光灯状态时发生错误。请确保你的智能手机尚未启用手电筒。';

  @override
  String get category_picker_no_category_found_button => '返回';

  @override
  String get user_preferences_item_accessibility_hint =>
      '点击即可在浏览器或应用程序（如果已安装）中打开。';

  @override
  String get dev_preferences_screen_title => '开发模式';

  @override
  String get dev_preferences_screen_subtitle => '访问实验性功能和开发工具';

  @override
  String get dev_preferences_reset_onboarding_title => '重置引导流程';

  @override
  String get dev_preferences_reset_onboarding_subtitle => '你必须重新启动应用才能再次看到它。';

  @override
  String get dev_preferences_environment_switch_title =>
      '在 openfoodfacts.org (PROD) 和测试环境之间切换';

  @override
  String get dev_preferences_test_environment_title => '测试环境参数';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return '当前测试环境的基本 URL： $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title => '测试环境主机';

  @override
  String get dev_preferences_ml_kit_title => '使用机器学习套件';

  @override
  String get dev_preferences_ml_kit_subtitle => '您需要重新启动此应用';

  @override
  String get dev_preferences_product_additional_features_title => '产品页面上的附加按钮';

  @override
  String get dev_preferences_edit_ingredients_title => '通过信息面板按钮编辑成分';

  @override
  String get dev_preferences_export_history_title => '导出历史记录';

  @override
  String get dev_preferences_export_history_progress_error => '异常';

  @override
  String get dev_preferences_export_history_progress_found => '找到产品';

  @override
  String get dev_preferences_export_history_progress_not_found => '未找到产品';

  @override
  String get dev_preferences_export_history_dialog_title => '导出历史记录';

  @override
  String get dev_preferences_button_positive => '确定';

  @override
  String get dev_preferences_button_negative => '取消';

  @override
  String get dev_preferences_migration_title => '从 V1 迁移数据';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return '状态：$status';
  }

  @override
  String get dev_preferences_migration_status_already_done => '成功或全新安装';

  @override
  String get dev_preferences_migration_status_success => '成功';

  @override
  String get dev_preferences_migration_status_error => '错误';

  @override
  String get dev_preferences_migration_status_in_progress => '进行中';

  @override
  String get dev_preferences_migration_status_required => '需要（点击开始）';

  @override
  String get dev_preferences_migration_status_not_started => '未知';

  @override
  String get dev_preferences_import_history_subtitle => '将清除历史记录并在其中放置 3 个产品';

  @override
  String get dev_preferences_news_custom_url_title => '新闻自定义网址';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'JSON 文件的 URL：';

  @override
  String get dev_preferences_news_custom_url_empty_value => '未设置';

  @override
  String get dev_preferences_news_provider_status_title => '状态';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return '上次刷新时间： $date';
  }

  @override
  String get product_type_label_food => '食物';

  @override
  String get product_type_label_beauty => '个人护理';

  @override
  String get product_type_label_pet_food => '宠物食品';

  @override
  String get product_type_label_product => '其他';

  @override
  String get product_type_selection_title => '产品类型';

  @override
  String get product_type_selection_subtitle => '请选择该产品的类型';

  @override
  String get product_type_selection_empty => '您需要先选择产品类型！';

  @override
  String product_type_selection_already(String productType) {
    return '您无法更改产品类型（$productType）！';
  }

  @override
  String get prices_app_dev_mode_flag => '产品页面上的“价格”应用快捷方式';

  @override
  String get prices_app_button => '前往价格应用';

  @override
  String get prices_website_button => '在公开价格网站上打开';

  @override
  String get prices_bulk_proof_upload_select => '直接从图库添加价格标签';

  @override
  String get prices_bulk_proof_upload_warning => '一旦你选择了图片，就无法编辑它们了！';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch => '允许社区验证人工智能提取的价格。';

  @override
  String get prices_bulk_proof_upload_subtitle => '多个价格标签';

  @override
  String get prices_bulk_proof_upload_title => '批量上传证明';

  @override
  String get prices_bulk_proof_upload_step_selecting => '选择文件';

  @override
  String get prices_bulk_proof_upload_step_starting => '开始上传';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return '本地复制文件 #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return '准备上传 #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return '图像 #$index/$count失败';
  }

  @override
  String get prices_generic_title => '价格';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '添加价格 $count 价格',
      one: '添加价格',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '发送 $count 价格',
      one: '发送价格',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => '添加项目';

  @override
  String get prices_add_a_price => '添加价格';

  @override
  String get prices_add_a_receipt => '添加收据';

  @override
  String get prices_add_price_tags => '添加价格标签';

  @override
  String prices_barcode_already(String barcode) {
    return '此条形码（$barcode）已在列表中！';
  }

  @override
  String get prices_barcode_search_not_found => '未找到产品';

  @override
  String get prices_barcode_search_none_yet => '暂无产品';

  @override
  String prices_barcode_search_running(String barcode) {
    return '正在寻找 $barcode';
  }

  @override
  String get prices_barcode_enter => '输入条形码';

  @override
  String get prices_category_enter => '商品无条形码';

  @override
  String get prices_per_kilogram => '每公斤价格';

  @override
  String get prices_per_unit => '每单位价格';

  @override
  String get prices_per_kilogram_short => ' /公斤';

  @override
  String get prices_per_unit_short => ' / 单元';

  @override
  String get prices_category_mandatory => '强制性的';

  @override
  String get prices_category_optional => '选修的';

  @override
  String get prices_category_error_mandatory => '此类别为必填项';

  @override
  String get prices_barcode_reader_action => '条形码阅读器';

  @override
  String get prices_view_prices => '查看价格';

  @override
  String get prices_list_title => '价目表';

  @override
  String get prices_list_count => '\n价格的数量';

  @override
  String get prices_list_add_new_price => '添加\n新价格';

  @override
  String get prices_list_empty_title => '尚无价格！';

  @override
  String get prices_list_empty_subtitle => '第一个添加：\n通过扫描**收据**或**价格标签**！';

  @override
  String get prices_entry_shop_not_found => '未知商店';

  @override
  String prices_entry_menu_title(String user) {
    return '价格条目来自“$user”';
  }

  @override
  String get prices_entry_menu_open_product_prices => '查看该产品的所有价格';

  @override
  String get prices_entry_menu_open_proof => '查看证明';

  @override
  String get prices_entry_menu_my_prices => '查看我的其他价格';

  @override
  String get prices_entry_menu_author_prices => '查看作者的其他价格';

  @override
  String get prices_entry_menu_shop_prices => '查看商店其他价格';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 价格',
      one: '1 个价格',
    );
    return '$_temp0 用于 $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '所有价格 $count 价格',
      one: '只有一个价格',
      zero: '暂无价格',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return '最新 $pageSize 价格（总计： $total）';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return '价格： $price / 商店：$location/ 发布日期： $date ，发布者：$user';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '“$user”的公开证明';
  }

  @override
  String get prices_open_proof => '公开价格证明';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '所有证据 $count',
      one: '仅有一个证据',
      zero: '暂无证据',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return '最新 $pageSize 个证明（总计： $total）';
  }

  @override
  String get prices_users_empty_title => '尚无贡献者！';

  @override
  String get prices_users_empty_explanation => '率先添加价格！';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return '贡献人数前 $pageSize 位（总计： $total）';
  }

  @override
  String get prices_locations_empty_title => '暂无店铺！';

  @override
  String get prices_locations_empty_explanation => '率先添加价格！';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return '排名前 $pageSize 的位置（总计： $total）';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 证明',
      one: '一个证明',
      zero: '无证明',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 产品',
      one: '一个产品',
      zero: '无产品',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 用户',
      one: '一位用户',
      zero: '无用户',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 价格',
      one: '一口价',
      zero: '无价格',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => '之前添加的价格';

  @override
  String get prices_amount_subtitle => '数量';

  @override
  String get prices_amount_is_discounted => '有折扣吗？';

  @override
  String get prices_amount_price_normal => '价格';

  @override
  String get prices_amount_price_discounted => '打折后价格';

  @override
  String get prices_amount_price_not_discounted => '原价';

  @override
  String get prices_amount_no_product => '缺少一件商品！';

  @override
  String get prices_amount_price_incorrect => '错误值';

  @override
  String get prices_amount_price_mandatory => '强制性价值';

  @override
  String get prices_currency_subtitle => '货币';

  @override
  String get prices_date_subtitle => '日期';

  @override
  String get prices_location_subtitle => '商店';

  @override
  String get prices_location_find => '查找商店';

  @override
  String get prices_location_mandatory => '您需要选择一家店铺！';

  @override
  String get prices_location_search_broader => '没找到您要找的内容？我们来扩大搜索范围吧！';

  @override
  String get prices_proof_subtitle => '证明';

  @override
  String get prices_proof_empty_title => '尚无证据！';

  @override
  String get prices_proof_empty_explanation => '首先添加**收据**或**价格标签**的照片！';

  @override
  String get prices_proof_find => '证明';

  @override
  String get prices_proof_change => '变更证明';

  @override
  String get prices_proof_receipt => '收据';

  @override
  String get prices_proof_price_tag => '价格标签';

  @override
  String get prices_proof_mandatory => '您需要选择一个证明文件！';

  @override
  String get prices_add_validation_error => '验证错误';

  @override
  String get prices_privacy_warning_title => '隐私警告';

  @override
  String get prices_unknown_product => '未知产品';

  @override
  String get prices_privacy_warning_main_message =>
      '价格**将公开**，同时还会注明对应的商店。\n\n这可能会让那些知道您“Open Food Facts”笔名的人：\n';

  @override
  String get prices_privacy_warning_message_bullet_1 => '推断您居住的地区';

  @override
  String get prices_privacy_warning_message_bullet_2 => '了解您所购买的商品';

  @override
  String get prices_privacy_warning_sub_message =>
      '如果您对此感到不安，请更改您的展示名，或创建一个新的 Open Food Facts 帐户并使用它登录该应用程序。';

  @override
  String get i_refuse => '我拒绝';

  @override
  String get i_accept => '我接受';

  @override
  String get prices_currency_change_proposal_title => '更改货币？';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return '您当前的货币是 **$currency**。您想将其更改为 **$newCurrency** 吗？';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return '是的，使用 $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return '不，保持 $currency';
  }

  @override
  String get prices_menu_know_more => '了解更多关于Open Prices的信息';

  @override
  String get dev_preferences_import_history_result_success => '完成';

  @override
  String get dev_mode_section_server => '服务器配置';

  @override
  String get dev_mode_section_news => '新闻提供商配置';

  @override
  String get dev_mode_section_product_page => '产品页面';

  @override
  String get dev_mode_section_ui => '用户界面';

  @override
  String get dev_mode_section_experimental_features => '实验性功能';

  @override
  String get dev_mode_hide_environmental_score_title => '排除 Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title => '使用拼写检查器进行 OCR 屏幕检查';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '（成分和包装）';

  @override
  String get dev_mode_reset_app_language_title => '重置应用语言';

  @override
  String get dev_mode_add_demo_cards_language_title => '添加卡片';

  @override
  String get dev_mode_openprices_switch_env_title =>
      '在 prices.openfoodfacts.org (PROD) 和测试环境之间切换';

  @override
  String get search_history_item_edit_tooltip => '重复使用和编辑此搜索';

  @override
  String get search_history_item_remove_tooltip => '移除';

  @override
  String product_search_no_more_results(int totalSize) {
    return '已成功加载 $totalSize 产品.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '再加载 $count 产品\n已经加载 $totalSize 产品中的 $downloaded 产品.';
  }

  @override
  String product_search_loading_message(Object search) {
    return '您对 $search 的搜索正在进行中。\n\n请等待几秒钟…';
  }

  @override
  String get user_search_contributor_title => '我添加的产品';

  @override
  String get user_search_informer_title => '我编辑过的产品';

  @override
  String get user_search_photographer_title => '我拍摄过的产品';

  @override
  String get user_search_to_be_completed_title => '需要完善信息的产品';

  @override
  String get user_search_prices_title => '我的价格';

  @override
  String get user_search_proofs_title => '我的样张';

  @override
  String get user_search_proof_title => '我的凭证';

  @override
  String search_proof_title(String user) {
    return '来自“$user”的证明';
  }

  @override
  String user_any_search_prices_title(String user) {
    return '贡献者价格： $user';
  }

  @override
  String get all_search_prices_latest_title => '最新报价';

  @override
  String get all_search_prices_top_user_title => '价格贡献数排行榜';

  @override
  String get all_search_prices_top_location_title => '价格信息最丰富的商店';

  @override
  String get prices_contribution_assistant => '价格贡献助理';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => '添加多个凭证';

  @override
  String get all_search_prices_top_location_single_title => '商店中的价格';

  @override
  String get all_search_prices_top_product_title => '报价信息最丰富的产品';

  @override
  String get all_search_to_be_completed_title => '所有待完善产品';

  @override
  String get categorize_products_country_title => '帮助对您所在国家/地区的产品进行分类';

  @override
  String get edit_product_action_retake_picture => '重拍';

  @override
  String get edit_product_action_take_picture => '拍摄';

  @override
  String get edit_product_action_confirm => '确认';

  @override
  String get signup_page_terms_of_use_line1 => '我同意 Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => '使用条款和贡献';

  @override
  String get analytics_consent_image_semantic_label => '分析图标';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return '错误: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return '错误: $error';
  }

  @override
  String get summary_card_button_add_basic_details => '完善基本信息';

  @override
  String get edit_photo_button_label => '编辑';

  @override
  String get edit_photo_unselect_button_label => '取消选择照片';

  @override
  String get edit_photo_select_existing_button_label => '选择现有图像';

  @override
  String get edit_photo_select_existing_all_label => '现有图像';

  @override
  String get edit_photo_select_existing_all_subtitle => '单击选择图像';

  @override
  String get edit_photo_select_existing_download_label => '正在获取现有图像…';

  @override
  String get edit_photo_select_existing_downloaded_none => '没有以前上传的与此产品相关的图像。';

  @override
  String get edit_photo_language_not_this_one => '暂无该语言的图像';

  @override
  String get edit_photo_language_none => '暂无图像';

  @override
  String get category_picker_screen_title => '类别';

  @override
  String get basic_details => '基本信息';

  @override
  String get product_name => '产品名称';

  @override
  String get product_names => '产品名称';

  @override
  String get add_basic_details_product_name_add_translation => '添加新翻译';

  @override
  String get add_basic_details_product_name_warning_translations =>
      '验证之前，请确保仅**如果包装上有该语言**才添加翻译';

  @override
  String get add_basic_details_product_name_open_photo => '查看正面照片';

  @override
  String get add_basic_details_product_name_take_photo => '拍摄正面照片';

  @override
  String get add_basic_details_product_name_hint => '输入产品名称（例如：Nutella）';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      '更改默认语言？';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return '您是否希望将产品的默认语言设置为“$language”？';
  }

  @override
  String get explanation_section_good_examples => '正面示例';

  @override
  String get explanation_section_bad_examples => '负面示例';

  @override
  String get add_basic_details_product_name_help_title => '产品名称信息的良好实践';

  @override
  String get add_basic_details_product_name_help_info1 =>
      '产品名称是**包装上印刷的主名称**。它可以是注册商标。';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**注意：**如果包装上没有该语言，请不要添加翻译。**';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => '雀巢';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => '番茄酱';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      '不要在名称中包含品牌';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      '亨氏番茄酱';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '不要使用 ®、™、© 或类似符号';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      '雀巢**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 其他译法',
      one: '$count 其他译法',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => '品牌';

  @override
  String get brand_names => '品牌名称';

  @override
  String get add_basic_details_brand_name_error => '请输入品牌名称';

  @override
  String get add_basic_details_brand_names_hint => '输入品牌（例如：费列罗）';

  @override
  String get add_basic_details_product_brand_help_title => '良好实践：品牌';

  @override
  String get add_basic_details_product_brand_help_info1 => '输入**该产品的所有品牌**。';

  @override
  String get add_basic_details_product_brand_help_info2_title => '主品牌';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**主品牌**（通常清晰地显示在包装正面）应**首先输入**。';

  @override
  String get add_basic_details_product_brand_help_info3_title => '其他品牌';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      '当**由大公司**出售时：';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      'Actimel 由达能公司销售。';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      '当其品牌以**多种语言翻译**的形式出售时：';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** 有时写作 **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => '能多益';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 => '奥利奥，亿滋';

  @override
  String get quantity => '数量和重量';

  @override
  String get add_basic_details_quantity_hint => '输入重量，如果需要，请输入数量（例如：4x100克）';

  @override
  String get add_basic_details_product_quantity_help_title => '良好做法：数量';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      '复制产品上标明的数值，**不要忘记单位**。';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '230克或230克';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6**（6个鸡蛋）';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150克**\n（产品包含3盒，每盒150克）';

  @override
  String get barcode => '条形码';

  @override
  String barcode_barcode(String barcode) {
    return '条码: $barcode';
  }

  @override
  String get barcode_invalid_error => '无效的条形码';

  @override
  String get basic_details_add_success => '基本信息添加成功';

  @override
  String get basic_details_add_error => '无法添加基本信息，请稍后再试';

  @override
  String get clear_search => '清除搜索';

  @override
  String get confirm_clear => '您即将清除整个历史记录：您确定要继续吗？';

  @override
  String get alert_clear_selected_user_list => '你即将清除历史记录中选定的项目';

  @override
  String get confirm_clear_selected_user_list => '您确定要继续吗？';

  @override
  String get alert_select_items_to_clear => '请选择一个或多个要清理的项目';

  @override
  String confirm_clear_user_list(String name) {
    return '您即将清除此列表 ($name)：您确定要继续吗？';
  }

  @override
  String get confirm_delete_user_list_title => '删除列表？';

  @override
  String confirm_delete_user_list_message(String name) {
    return '您即将删除列表“$name”。\n您确定要继续吗？';
  }

  @override
  String get confirm_delete_user_list_button => '是的，我确认';

  @override
  String importance_label(String name, String id) {
    return '$name 重要性: $id';
  }

  @override
  String get user_list_all_title => '列表';

  @override
  String get user_list_all_empty => '创建您的第一个列表';

  @override
  String get product_list_select => '请选择一个列表';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 产品',
      one: '一款产品',
      zero: '空列表',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => '创建列表';

  @override
  String get open_food_preferences_tooltip => '编辑您的食物偏好';

  @override
  String get add_photo_button_label => '添加照片';

  @override
  String get add_packaging_photo_button_label => '对任何包装/回收信息拍照';

  @override
  String get add_origin_photo_button_label => '拍摄任何来源信息的照片';

  @override
  String get add_emb_photo_button_label => '拍摄所有可追溯性代码信息的照片';

  @override
  String get add_label_photo_button_label => '拍摄所有标签和认证信息的照片';

  @override
  String get choose_image_source_title => '选择图片来源';

  @override
  String get choose_image_source_body => '请选择图片来源';

  @override
  String get gallery_source_label => '相册';

  @override
  String get gallery_source_access_denied_dialog_title => '拒绝访问';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      '很抱歉，由于您之前已拒绝授权，该应用无法访问您的图库。\n\n请前往手机“设置”->“照片”中的应用设置。';

  @override
  String get gallery_source_access_denied_dialog_button => '打开设置';

  @override
  String get share => '推荐给好友';

  @override
  String share_product_text(String url) {
    return '请在 Open Food Facts 上查看此产品： $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return '请在 Open Beauty Facts 上查看这款产品： $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return '请在 Open PetFood Facts 上查看此产品： $url';
  }

  @override
  String share_product_text_product(String url) {
    return '请查看 Open Products Facts 上的这款产品： $url';
  }

  @override
  String share_product_list_text(String url) {
    return '请查看我在 Open Food Facts 上的产品列表： $url';
  }

  @override
  String get capture => '拍一张新照片';

  @override
  String get capture_new_picture => '请拍照';

  @override
  String get choose_from_gallery => '从相册选择';

  @override
  String get image_upload_queued => '图片将尽快上传。';

  @override
  String get add_price_queued => '价格将尽快发送至服务器。';

  @override
  String get background_task_title_full_refresh => '开始刷新本地存储的所有产品';

  @override
  String get background_task_title_top_n => '开始下载最受欢迎的产品';

  @override
  String get expand_nutrition_facts => '展开营养成分表';

  @override
  String get expand_nutrition_facts_body => '扩大营养成分表';

  @override
  String get expand_ingredients => '展开成分';

  @override
  String get expand_ingredients_body => '保持成分面板扩展';

  @override
  String get no_internet_connection => '无互联网连接';

  @override
  String get world_results_label => '整个世界';

  @override
  String get world_results_action => '将您的搜索扩大到全世界';

  @override
  String get copy_to_clipboard => '复制';

  @override
  String get paste_from_clipboard => '从剪贴板粘贴';

  @override
  String get no_data_available_in_clipboard => '剪贴板中没有可用数据';

  @override
  String get clipboard_barcode_copy => '将条形码复制到剪贴板';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return '条码 $barcode 已复制到剪贴板！';
  }

  @override
  String get open_product_website => '在网站上打开此产品';

  @override
  String get language_picker_label => '您的语言';

  @override
  String get country_picker_label => '你的国家';

  @override
  String get currency_picker_label => '您的货币';

  @override
  String get help_with_openfoodfacts => '帮助 OpenFoodFacts';

  @override
  String get product_task_background_schedule => '产品将尽快在后台更新。';

  @override
  String get no_email_client_available_dialog_title => '没有电子邮件应用！';

  @override
  String get no_email_client_available_dialog_content =>
      '请手动发送电子邮件至 mobile@openfoodfacts.org';

  @override
  String get all_images => '所有图像';

  @override
  String get selected_images => '选定图片';

  @override
  String get product_card_remove_product_tooltip => '移除产品';

  @override
  String scan_announce_new_barcode(String barcode) {
    return '扫描到一个新条形码：$barcode';
  }

  @override
  String get scan_header_clear_button_tooltip => '从扫描结果轮播中删除所有产品';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      '请扫描至少两个产品以进行比较';

  @override
  String get scan_header_compare_button_valid_state_tooltip => '点击即可比较您已扫描的产品。';

  @override
  String get scan_product_loading => '您已扫描条形码\n：';

  @override
  String get scan_product_loading_initial => '我们正在寻找这款产品！\n请稍等片刻…';

  @override
  String get scan_product_loading_long_request =>
      '我们仍在寻找这款产品！\n您觉得加载时间太长吗？我们也觉得…';

  @override
  String get scan_product_loading_unresponsive => '我们仍在寻找该产品。\n您想重新开始搜索吗？';

  @override
  String get scan_product_loading_restart_button => '重新开始搜索';

  @override
  String get portion_calculator_description => '计算特定数量的营养成分';

  @override
  String get portion_calculator_hint => '数量';

  @override
  String get portion_calculator_accessibility => '输入数量来计算营养成分';

  @override
  String portion_calculator_error(int min, int max) {
    return '请输入介于 $min 和 $max g 之间的数量';
  }

  @override
  String get portion_calculator_computation_error => '缺少数据。无法进行计算。';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams 克（或毫升）的营养成分';
  }

  @override
  String get offline_data => '离线数据';

  @override
  String get ocr_image_upload_instruction => '上传图片以自动提取其包含的信息。';

  @override
  String get upload_image => '上传图片';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => '，';

  @override
  String get image_download_error => '图片下载失败';

  @override
  String get image_edit_url_error => '由于未设置图片 URL，无法编辑图片。';

  @override
  String get user_picture_source_remember => '记住我的选择';

  @override
  String get user_picture_source_ask => '每次询问';

  @override
  String get robotoff_continue => '继续';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: ' $count 个问题',
      one: '一个问题',
    );
    return '下$_temp0';
  }

  @override
  String get show_password => '显示密码';

  @override
  String get owner_field_info_title => '生产者提供的价值';

  @override
  String get owner_field_info_message => '我们通过该标志突出显示生产商提供的数据，这些数据可能无法编辑。';

  @override
  String get owner_field_info_close_button => '关闭此信息';

  @override
  String get owner_field_image => '此图片由制造商提供，可能无法编辑。';

  @override
  String get edit_packagings_title => '包装成分';

  @override
  String get edit_packagings_element_add => '添加包装成分';

  @override
  String get edit_packagings_completed => '此包装成分已完整';

  @override
  String edit_packagings_element_title(int index) {
    return '包装成分 #$index';
  }

  @override
  String get edit_packagings_element_field_units => '单位数';

  @override
  String get edit_packagings_element_hint_units => '输入产品中包含的相同形状和材料的包装单位数量。';

  @override
  String get edit_packagings_element_field_shape => '形状';

  @override
  String get edit_packagings_element_hint_shape =>
      '输入回收说明中列出的形状名称（如果可用），或选择一个形状。';

  @override
  String get edit_packagings_element_example_shape => '瓶子';

  @override
  String get edit_packagings_element_field_material => '材料';

  @override
  String get edit_packagings_element_hint_material =>
      '如果可以确定，请输入具体材料（三角形内的材料代码通常可以在包装部件上找到），如果您不确定，请输入通用材料（例如塑料或金属）。';

  @override
  String get edit_packagings_element_example_material => '玻璃';

  @override
  String get edit_packagings_element_field_recycling => '回收说明';

  @override
  String get edit_packagings_element_hint_recycling => '只有在产品上列出的回收说明才可输入。';

  @override
  String get edit_packagings_element_example_recycling => '回收';

  @override
  String get edit_packagings_element_field_quantity => '每单位产品净数量';

  @override
  String get edit_packagings_element_hint_quantity =>
      '输入净重或净体积并注明单位（例如克 g 或毫升 ml）。';

  @override
  String get edit_packagings_element_field_weight => '一个空单位的重量（克）';

  @override
  String get edit_packagings_element_hint_weight =>
      '在称重之前，请清除所有剩余的食物并清洗和干燥包装部分。如果可能，使用精度为 0.1g 或 0.01g 的秤。';

  @override
  String get background_task_title => '待处理贡献';

  @override
  String get background_task_subtitle => '您的贡献会自动保存到我们的服务器，但并不总是实时的。';

  @override
  String get background_task_list_empty => '没有待处理的后台任务';

  @override
  String get background_task_error_server_time_out => '服务器超时';

  @override
  String get background_task_error_no_internet => '网络连接错误，请稍后再试。';

  @override
  String get background_task_operation_unknown => '未知操作类型';

  @override
  String get background_task_operation_details => '详细更改';

  @override
  String get background_task_operation_image => '照片上传';

  @override
  String get background_task_operation_refresh => '照片上传后刷新延迟';

  @override
  String get background_task_run_started => '已开始';

  @override
  String get background_task_run_not_started => '尚未开始';

  @override
  String get background_task_run_to_be_deleted => '待删除';

  @override
  String get background_task_question_stop => '您想尽快停止该任务吗？';

  @override
  String get feed_back => '意见反馈';

  @override
  String get undo => '撤销';

  @override
  String get copy_email_to_clip_board => '复制电子邮箱到剪贴板';

  @override
  String get please_send_us_an_email_to => '请手动向我们发送电子邮件至';

  @override
  String get email_copied_to_clip_board => '电子邮件地址已复制到剪贴板';

  @override
  String get select_accent_color => '选择强调色';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => '蓝色';

  @override
  String get color_cyan => '青色';

  @override
  String get color_green => '绿色';

  @override
  String get color_light_brown => '默认';

  @override
  String get color_magenta => '洋红色';

  @override
  String get color_orange => '橙色';

  @override
  String get color_pink => '粉色';

  @override
  String get color_red => '红色';

  @override
  String get color_rust => '赤色';

  @override
  String get color_teal => '鸭青色';

  @override
  String get text_contrast_mode => '文本对比度';

  @override
  String get contrast_high => '高';

  @override
  String get contrast_medium => '中等';

  @override
  String get contrast_low => '低';

  @override
  String get product_refresher_internet_not_found => '未找到该产品！';

  @override
  String get product_refresher_internet_not_connected => '您尚未连接到互联网！';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return '服务器宕机 ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return '服务器错误（$exception）';
  }

  @override
  String get product_loader_not_found_title => '未找到该产品！';

  @override
  String product_loader_not_found_message(String barcode) {
    return '我们的数据库中不存在以下条形码对应的产品：$barcode';
  }

  @override
  String get product_loader_network_error_title => '无网络连接';

  @override
  String get product_loader_network_error_message =>
      '请检查您的智能手机是否已连接无线网络或已启用移动数据';

  @override
  String get page_not_found_title => '页面未找到';

  @override
  String get page_not_found_button => '返回首页';

  @override
  String get download_data => '下载数据';

  @override
  String get download_top_products => '下载您所在国家/地区排名前 1000 的产品进行即时扫描';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 的产品',
    );
    return '下载您所在国家/地区排名前 $_temp0进行即时扫描';
  }

  @override
  String get download_in_progress => '正在下载数据\n这可能需要一段时间';

  @override
  String downloaded_products(int num) {
    return '$num 个产品被添加';
  }

  @override
  String get update_offline_data => '更新离线产品数据';

  @override
  String get update_local_database_sub => '使用 Open Food Facts 的最新数据更新本地产品数据库';

  @override
  String get clear_local_database => '清除离线产品数据';

  @override
  String get clear_local_database_sub => '清除应用中的所有本地产品数据以释放空间';

  @override
  String deleted_products(int num) {
    return '$num 个产品被删除';
  }

  @override
  String get loading => '正在加载…';

  @override
  String get know_more => '了解更多';

  @override
  String get offline_data_desc => '点击了解更多有关离线数据的信息';

  @override
  String get offline_product_data_title => '离线产品数据';

  @override
  String available_for_download(int num) {
    return '$num 产品可供立即扫描';
  }

  @override
  String get country_selector_title => '选择您的国家：';

  @override
  String get currency_selector_title => '选择您的货币：';

  @override
  String get language_selector_title => '选择您的语言：';

  @override
  String get language_selector_section_selected => '所选语言';

  @override
  String get language_selector_section_frequently_used => '经常使用';

  @override
  String get action_delete_list => '删除';

  @override
  String get action_change_list => '更改当前列表';

  @override
  String get product_list_create => '创建';

  @override
  String get product_list_create_tooltip => '创建新列表';

  @override
  String get nutriscore_generic => '营养分数';

  @override
  String get nutriscore_a => '营养评分 A';

  @override
  String get nutriscore_b => 'Nutri-ScoreB';

  @override
  String get nutriscore_c => 'Nutri-ScoreC';

  @override
  String get nutriscore_d => '营养评分 D';

  @override
  String get nutriscore_e => '营养评分 E';

  @override
  String nutriscore_new_formula(String letter) {
    return '营养分数（Nutri-Score） $letter （新计算方式）';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score（新计算方法）';

  @override
  String get nutriscore_unknown => '未知Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula => '未知Nutri-Score（新计算方法）';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score不适用';

  @override
  String get nutriscore_not_applicable_new_formula => 'Nutri-Score不适用（新计算方法）';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => '未知Green-Score';

  @override
  String get environmental_score_not_applicable_new => 'Green-Score不适用';

  @override
  String get nova_group_generic_new => '超加工食品 - NOVA 集团';

  @override
  String get nova_group_1 => 'NOVA 分组 — 第 1 级';

  @override
  String get nova_group_2 => 'NOVA 分组 — 第 2 级';

  @override
  String get nova_group_3 => 'NOVA 分组 — 第 3 级';

  @override
  String get nova_group_4 => 'NOVA 分组 — 第 4 级';

  @override
  String get nova_group_unknown => '未知 NOVA 分组信息';

  @override
  String get nutrition_facts => '营养水平';

  @override
  String get faq_title_partners => '非政府组织的合作伙伴和赞助人';

  @override
  String get faq_title_vision => 'Open Food Facts 的愿景、使命、价值观和计划';

  @override
  String get faq_title_install_beauty => '安装 Open Beauty Facts 来创建化妆品数据库';

  @override
  String get faq_title_install_pet => '安装 Open Pet Food Facts 来创建宠物食品数据库';

  @override
  String get faq_title_install_product =>
      '安装 Open Products Facts 以创建产品数据库，从而延长产品的使用寿命。';

  @override
  String get faq_nutriscore_nutriscore => 'Nutri-Score的新计算方法：有哪些新内容？';

  @override
  String get contact_title_pro_page => '专业版？将您的产品导入 Open Food Facts';

  @override
  String get contact_title_pro_email => '制片人联系方式';

  @override
  String get contact_title_press_page => '页面';

  @override
  String get contact_title_press_email => '媒体联系人';

  @override
  String get contact_title_newsletter => '订阅新闻资讯';

  @override
  String get contact_title_calendar => '订阅我们的社区日历';

  @override
  String get hunger_games_loading_line1 => '请稍等片刻…';

  @override
  String get hunger_games_loading_line2 => '我们正在下载试题！';

  @override
  String get hunger_games_error_label => '啊！出错了… ，我们无法加载问题。';

  @override
  String get hunger_games_error_retry_button => '我们再试一次！';

  @override
  String get reorder_attribute_action => '重新排列属性';

  @override
  String get link_cant_be_opened => '您的设备无法打开此链接。请检查您是否已安装浏览器。';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productName的详细信息';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName 与 $productName的详细信息';
  }

  @override
  String get guide_title => '指南';

  @override
  String get guide_share_label => '推荐给好友';

  @override
  String get guide_nutriscore_v2_title => 'Nutri-Score 正在不断发展！';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title => 'Nutri-Score 是什么？';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score 是一个标志，旨在告诉您**食品的营养质量**。';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      '颜色代码各不相同，深绿色（**A**）代表**最健康**的产品，深红色（**E**）代表**不太健康**的产品。';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption => 'Nutri-Score A 级标志';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Nutri-Score 为何不断发展？';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Nutri-Score 公式**正在不断发展**，以提供更好的建议：';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title => '更好地评估所有饮料';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      '在新算法中，**牛奶**、添加糖的**乳制品饮料**和**植物**饮料的得到了更好的区分。';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title => '更合理的饮料排名';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**糖含量**需要更好地考虑，并且更倾向于**低糖**饮料。\\n**甜味剂也会受到惩罚**：低糖汽水的评级将从 B 级降至 C 到 E 级之间。水仍然是推荐的饮料。';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      '含有较多盐和糖的产品将受到惩罚（译者注：生理盐水虽然含盐，但对人体应该一定程度上有益）';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      '**太甜**或**太咸**的产品的**评级将会进一步降低**。';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title => '油和鱼的营养情况也将被进一步细分';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      '某些**富含脂肪的鱼**和**富含有益脂肪的油**的评级将会提高。';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => '限制红肉';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      '**红肉的摄入量应该受到限制**。这就是为什么**家禽的排名相对较高**。';

  @override
  String get guide_nutriscore_v2_new_logo_title => '如何区分旧的 Nutri-Score 和新的计算？';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      '从现在开始，标志上可以显示“**新算法**”标记以表明这确实是新的算法。';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption => '新版 Nutri-Score 的标志';

  @override
  String get guide_nutriscore_v2_where_title => '哪里可以找到新的Nutri-Score计算方法？';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score 已在 7 个国家/地区应用：法国、德国、比利时、西班牙、卢森堡、荷兰和瑞士。';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      '制造商最迟有**2年**的时间，从法令签署之日起**将**旧的计算方法替换为新的计算方法。';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      '无需等待，您**将在 OpenFoodFacts 应用程序中找到**新的计算结果，包括制造商是否尚未更新分数的产品。';

  @override
  String get guide_nutriscore_v2_unchanged_title => '哪些要素没有改变';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score 是一个旨在**衡量营养质量**的评分系统。它作为 NOVA 分组关于**超加工食品的补充**（也包含在应用中）。';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      '对于制造商来说，Nutri-Score 的显示**仍然是可选的**。';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => '什么是绿色分数？';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score 是一个标志，旨在告知您**食品对环境的影响**。';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      '颜色代码从代表**影响最小**产品的深绿色（**A+**）到代表**影响最大**产品的深红色（**F**）不等。';

  @override
  String get guide_greenscore_logos_caption => 'Green-Score 徽标';

  @override
  String get guide_greenscore_lca_title => '核心：生命周期评估（LCA）';

  @override
  String get guide_greenscore_lca_arg1_title => '食品类别的科学评估';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      '对于每个产品类别，使用来自 Agribalyse 环境数据库（由 ADEME 和 INRAE 设计）的数据建立一个**基准**分数。';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**生命周期分析**是一种进行多阶段、多标准环境评估的标准化评估方法。';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**其测量：**';

  @override
  String get guide_greenscore_lca_arg2_title => '6个生产步骤';

  @override
  String get guide_greenscore_lca_arg2_agriculture => '农业';

  @override
  String get guide_greenscore_lca_arg2_processing => '加工';

  @override
  String get guide_greenscore_lca_arg2_packaging => '包装';

  @override
  String get guide_greenscore_lca_arg2_transportation => '运输';

  @override
  String get guide_greenscore_lca_arg2_distribution => '分派';

  @override
  String get guide_greenscore_lca_arg2_consumption => '消耗量';

  @override
  String get guide_greenscore_lca_arg3_title => '14项环境影响指标';

  @override
  String get guide_greenscore_lca_arg3_text1 => '气候变化/碳足迹';

  @override
  String get guide_greenscore_lca_arg3_text2 => '臭氧层损耗';

  @override
  String get guide_greenscore_lca_arg3_text3 => '电离辐射';

  @override
  String get guide_greenscore_lca_arg3_text4 => '土地';

  @override
  String get guide_greenscore_lca_arg3_text5 => '水和能源的使用';

  @override
  String get guide_greenscore_lca_arg3_text6 => '空气污染';

  @override
  String get guide_greenscore_lca_arg3_text7 => '海水和淡水（颗粒、酸化、富营养化）';

  @override
  String get guide_greenscore_lca_arg3_text8 => '资源枯竭。';

  @override
  String get guide_greenscore_bonuses_penalties_title => '奖金和罚款';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      '为了奖励某一类别中更优秀的产品，我们会根据若干标准应用**奖金和惩罚**：';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => '生产方式';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '带有**官方标签、保证环境效益的标签或认证**（有机、公平贸易、HVE、Label Rouge、Bleu Blanc Cœur、MSC/ASC）的产品将获得**奖励**。';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => '成分来源';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '根据原料产地，会给予**额外奖金**。该奖金会考虑**运输对产品的影响**以及各生产商所在国家的**环境政策**。';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title => '濒危物种';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '含有对生物多样性和生态系统造成重大负面影响的成分的产品，例如棕榈油，将会受到**处罚**，因为棕榈油的生产是造成大规模森林砍伐的原因。';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => '包装';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '计算**罚款**时，会考虑**包装的**循环性**（使用回收原材料和可回收性）和过度包装。';

  @override
  String get guide_greenscore_transparency_title => '更高的透明度的需求，以更好地衡量和减少环境影响';

  @override
  String get guide_greenscore_transparency_intro1 =>
      '要准确计算Green-Score，需要一些**包装上不一定标明的信息**（例如每种成分的来源和确切百分比），或者一些很少以可用形式提供的信息（例如包装所有组件的清单以及所用塑料的确切类型）。';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**当这些信息尚不可用时，将使用平均值**，但我们现在呼吁大家帮助我们收集这些信息，这些信息对于Green-Score以及许多其他用途都将非常有用。';

  @override
  String get guide_greenscore_transparency_arg1_title => '市民可以如何提供帮助？';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      '所有公民都可以帮助我们收集和整理产品上存在的信息或可以从产品中推断出的信息，例如包装信息：“包装任务”：一项针对所有食品包装的大规模合作清点计划（法语）。';

  @override
  String get guide_greenscore_transparency_arg2_title => '制造商如何提供帮助';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      '制造商可以通过我们为生产商提供的免费平台直接向我们发送他们的信息。';

  @override
  String get guide_greenscore_better_product_title => '哪种产品对地球更好？';

  @override
  String get guide_greenscore_better_product_arg1_title => '很难说';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      '选择可持续食品是我们为气候所能做的最有力的事情之一，因为**我们的全球食品系统造成了超过四分之一的温室气体排放**。\n（来源：Poore & Nemecek，Science，2018）。';

  @override
  String get guide_greenscore_better_product_arg2_title => '你有力量！';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      '好消息是，这为我们提供了一种强有力的变革方法。\n**我们每个人每年大约吃1000顿饭**。这意味着我们有1000个机会**为地球选择更美好的未来**！';

  @override
  String get guide_greenscore_better_product_arg3_title => '帮助承担责任并做出决定';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      '选择可持续食品可能感觉很复杂。标签令人困惑，信息也常常缺失。Green-Score 的创建旨在简化这一过程，为您提供**清晰**、**基于科学**且**透明**的食品环境评级，就在您需要的时候：购物时。';

  @override
  String get guide_greenscore_better_product_arg4_title => '透明度';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      '与专有标签不同，Green-Score 计算**完全开放**，并且**任何人都可以验证**。';

  @override
  String get guide_nova_title => '超加工食品';

  @override
  String get guide_nova_what_is_nova_title => '什么是超加工？';

  @override
  String get guide_nova_what_is_nova_paragraph1 => 'NOVA 小组会向您介绍**食品加工水平**。';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA 分类允许根据食品的**工业加工程度**将其分为**4 类**（最低限度加工或未加工食品、烹饪原料、加工食品、超加工食品）。';

  @override
  String get guide_nova_logos_caption => 'NOVA 标志';

  @override
  String get guide_nova_groups_title => '4个NOVA组';

  @override
  String get guide_nova_groups_intro => 'NOVA 有 4 个组，有问题的是第 4 组 - 超加工食品。';

  @override
  String get guide_nova_groups_arg1_title => '低度加工或未加工食品';

  @override
  String get guide_nova_groups_arg1_text =>
      '未加工（或天然）食品是指从自然界分离出来的**植物的可食用部分**（种子、果实、叶子、茎、根）**或**动物的**可食用部分**（肌肉、内脏、蛋、奶），以及真菌、藻类和水。';

  @override
  String get guide_nova_groups_arg2_title => '加工过的烹饪原料';

  @override
  String get guide_nova_groups_arg2_text =>
      '加工烹饪原料，如**油、黄油、糖和盐**，是从第 1 类食品或自然界通过压榨、精炼、研磨、碾磨和干燥等工艺获得的物质。';

  @override
  String get guide_nova_groups_arg3_title => '加工食品';

  @override
  String get guide_nova_groups_arg3_text =>
      '加工食品，例如瓶装蔬菜、罐装鱼、糖水水果、奶酪和新鲜面包，**主要是通过向第一类食品中添加盐、油、糖或其他第二类物质**制成的。加工过程包括各种保鲜或烹饪方法，面包和奶酪的加工过程还包括非酒精发酵。大多数加工食品含有两到三种成分，可以识别为第一类食品的改良版本。它们可以单独食用，但更常见的是与其他食物搭配食用。';

  @override
  String get guide_nova_groups_arg4_title => '超加工食品';

  @override
  String get guide_nova_groups_arg4_text =>
      '超加工食品，例如软饮料、甜味或咸味包装零食、重组肉制品和预制冷冻食品，**不仅仅是改良食品，而是主要或完全由食品衍生物质和添加剂制成的配方**，几乎不含或完全不含第一类完整食物。这些配方中的成分通常包括加工食品中常见的成分，例如糖、油、脂肪或盐。然而，超加工产品还含有其他一些通常不用于烹饪的能量和营养来源。其中一些直接提取自食物，例如酪蛋白、乳糖、乳清和麸质。';

  @override
  String get guide_nova_explanations_title => '超加工的问题';

  @override
  String get guide_nova_explanations_arg1_title => '食品原料的极端加工';

  @override
  String get guide_nova_explanations_arg1_text =>
      '许多成分**源自食品成分的进一步加工**，例如氢化油或酯交换油、水解蛋白质、大豆分离蛋白、麦芽糊精、转化糖和高果糖玉米糖浆。';

  @override
  String get guide_nova_explanations_arg2_title => '超越纯食品安全的添加剂';

  @override
  String get guide_nova_explanations_arg2_text =>
      '超加工食品中的添加剂包括一些加工食品中也常用的添加剂，例如防腐剂、抗氧化剂和稳定剂。而仅存在于超加工食品中的添加剂则用于**模仿或增强食品的感官特性，或掩盖最终产品令人不悦之处**。这些添加剂包括染料和其他色素、颜色稳定剂；香精、增味剂、非糖甜味剂；以及加工助剂，例如碳酸化剂、增稠剂、膨胀剂和消泡剂、抗结块剂和上光剂、乳化剂、螯合剂和保湿剂。';

  @override
  String get guide_nova_explanations_arg3_title => '在家无法完成的处理';

  @override
  String get guide_nova_explanations_arg3_text =>
      '为了将通常种类繁多的原料混合并制成最终产品（因此称为“超加工”），需要运用**多种加工工序**。这些工序包括一些**国内没有类似工艺**，例如氢化和水解、挤压和成型以及油炸前的预处理。';

  @override
  String get guide_nova_explanations_arg4_title => '超加工的掠夺性和财务方面';

  @override
  String get guide_nova_explanations_arg4_text =>
      '超加工的总体目标是打造品牌化、便捷（耐储存、即食）、诱人（口感极佳）且利润丰厚（原料成本低）的食品，旨在取代所有其他食品类别。超加工食品通常包装精美，并进行密集营销。';

  @override
  String get guide_nova_explanations_arg5_title => '对健康有害';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title => '各国建议限制它们';

  @override
  String get guide_nova_explanations_arg6_text =>
      '一些国家在其膳食指南或目标中使用了 NOVA 分组，例如：\n\n- **🇧🇷 巴西**的膳食指南**建议限制加工食品的摄入量**，并避免食用超加工食品。\n\n- **🇫🇷 法国**2018-2022 年公共卫生营养政策目标旨在**将第 4 组超加工食品的摄入量减少 20%**。';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => '欢迎来到开放食品真相！';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      '什么是Open Food Facts？';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts 是一个**协作式**、**免费**、**开放**的全球食品数据库。';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      '我们相信每个人都应该有权了解自己所吃的食物信息。通过收集成分、过敏原、营养成分等数据，**我们帮助消费者做出明智的选择**，并推动食品行业**走向更高的透明度**。';

  @override
  String get guide_open_food_facts_features_title => 'Open Food Facts的特点';

  @override
  String get guide_open_food_facts_features_arg1_title => '获取您不需要的成分的提醒';

  @override
  String get guide_open_food_facts_tips_title => '拍摄精彩照片的技巧';

  @override
  String get guide_open_food_facts_tips_arg1_title => '禁忌';

  @override
  String get guide_open_food_facts_tips_arg1_text1 => '避免阴影和眩光。';

  @override
  String get guide_open_food_facts_tips_arg1_text2 => '文字清晰，无模糊或失焦现象。';

  @override
  String get guide_open_food_facts_tips_arg1_text3 => '不要裁剪掉文本的任何部分。';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => '避免使用过于复杂的背景。';

  @override
  String get guide_open_food_facts_tips_arg2_title => '应该做的事';

  @override
  String get guide_open_food_facts_tips_arg2_text1 => '使用良好、均匀的照明。';

  @override
  String get guide_open_food_facts_tips_arg2_text2 => '确保文字清晰易读。';

  @override
  String get guide_open_food_facts_tips_arg2_text3 => '记下所有配料清单。';

  @override
  String get guide_open_food_facts_tips_arg2_text4 => '请将产品放置在平坦的表面上。';

  @override
  String get guide_open_food_facts_scores_title => '帮助我们打造“食品维基百科”';

  @override
  String get guide_open_food_facts_scores_arg1_title => '营养质量评分';

  @override
  String get guide_open_food_facts_scores_arg2_title => '避免食用超加工食品的评分';

  @override
  String get guide_open_food_facts_scores_arg3_title => '为地球打分';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-en.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title => '欢迎来到“公开宠物食品真相”！';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      '什么是“Open Pet Food Facts”？';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts 将我们的使命扩展到了毛茸茸的朋友们！这是一个**猫、狗和其他伴侣动物的宠物食品产品数据库**。';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      '我们收集有关**成分**、**营养分析**和喂养指南的信息，以帮助宠物主人选择最适合其宠物需求的食物。';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Open Pet Food Facts的特点';

  @override
  String get guide_open_pet_food_facts_features_arg1_title => '获取您不需要的成分的提醒';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      '您的宠物对某些成分过敏吗？您可以在应用程序中设置要避免的化妆品成分列表！';

  @override
  String get guide_open_pet_food_facts_tips_title => '拍摄精彩照片的技巧';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => '禁忌';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 => '避免阴影和眩光。';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 => '文字清晰，无模糊或失焦现象。';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 => '不要裁剪掉文本的任何部分。';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 => '避免使用过于复杂的背景。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => '应该做的事';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 => '使用良好、均匀的照明。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 => '确保文字清晰易读。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 => '记下所有配料清单。';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 => '请将产品放置在平坦的表面上。';

  @override
  String get guide_open_pet_food_facts_scores_title => '关于评分的说明';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      '目前，开发宠物食品评分系统**并非当务之急**。因为不同物种、年龄和健康状况的宠物营养需求差异很大，所以评分方法会非常复杂。我们尚未找到任何能够开发此类评分系统的独立科研团队。';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-en.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => '欢迎来到Open Beauty Facts！';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      '什么是“Open Beauty Facts”？';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts 是一个关于**化妆品**的协作数据库。';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      '我们的目标是解读成分表，帮助您**了解个人护理用品的成分**。从保湿霜到彩妆，我们收集成分、过敏原和包装方面的数据，以提升化妆品行业的透明度。';

  @override
  String get guide_open_beauty_facts_features_title => 'Open Beauty Facts的特点';

  @override
  String get guide_open_beauty_facts_features_arg1_title => '获取您不需要的成分的提醒';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      '您对某些成分过敏吗？想避免使用致粉刺成分吗？想避开有争议的成分吗？您可以在应用程序中设置一份要避免的化妆品成分列表！';

  @override
  String get guide_open_beauty_facts_tips_title => '拍摄精彩照片的技巧';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => '禁忌';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 => '避免阴影和眩光。';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 => '文字清晰，无模糊或失焦现象。';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 => '不要裁剪掉文本的任何部分。';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 => '避免使用过于复杂的背景。';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => '应该做的事';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 => '使用良好、均匀的照明。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 => '确保文字清晰易读。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 => '记下所有配料清单。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 => '如果瓶子是弧形的，请根据需要拍摄多张照片。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 => '你可能需要撕开标签才能看到成分表。';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 => '请将产品放置在平坦的表面上。';

  @override
  String get guide_open_beauty_facts_scores_title => '关于评分的说明';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      '与食品不同，化妆品领域**没有像Nutri-Score那样被普遍认可、政府支持的评分系统**。成分的效果因人而异，取决于肤质、过敏史和个人需求。';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-en.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => '欢迎来到Open Prices！';

  @override
  String get guide_open_prices_what_is_open_prices_title => '什么是Open Prices？';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices 是一个旨在收集和分享全球产品价格的项目。它是一个公开可用的数据集，可用于研究、分析等用途。Open Prices 由 Open Food Facts 开发和维护。';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      '目前，拥有条形码级产品价格大型数据库的公司寥寥无几。这些价格并非免费提供，而是以高价出售给有能力的私人参与者、研究人员和其他组织。';

  @override
  String get guide_open_prices_how_title => 'Open Prices是如何运作的？';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '我们正在众包一个开源的价格数据集。用户可以通过此网页应用或官方的 Open Food Facts 移动应用添加价格信息。零售商或第三方应用也可以通过我们的 API 贡献数据。';

  @override
  String get guide_open_prices_how_arg1_title => '收集过道中的价格标签照片';

  @override
  String get guide_open_prices_how_arg2_title => '收集收据照片。';

  @override
  String get guide_open_prices_why_title => 'Open Food Facts为什么要这样做？';

  @override
  String get guide_open_prices_why_paragraph1 =>
      '价格信息对于理解食品体系至关重要。它是了解食品成本和促进健康饮食的关键因素。公开价格数据能够帮助研究人员、记者和公众更轻松地了解食品价格在不同地区和时间上的变化。';

  @override
  String get guide_open_prices_why_arg1_title => '追踪价格随时间的变化';

  @override
  String get guide_open_prices_why_arg1_text =>
      '看看价格的**演变**：缩水式通胀、廉价式通胀，我们可以一起追踪它们！';

  @override
  String get guide_open_prices_why_arg2_title => '比较您附近的商品价格';

  @override
  String get guide_open_prices_why_arg2_text =>
      '随着我们掌握更多价格信息，您可以找到**您附近最便宜的商店**。';

  @override
  String get guide_open_prices_scrapping_title => '你有没有考虑过从零售商网站上抓取价格信息？';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      '出于法律和技术原因，**我们不认为从零售商网站抓取价格是向 Open Prices 贡献价格的有效方式**。我们希望确保收集到的价格准确且最新，而接收贡献者抓取的价格信息会让我们无法做到这一点。';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      '价格抓取是 Open Prices 未来版本中的一个考虑选项，但它将由 Open Prices 本身完成，以便我们能够根据 HTML 页面获得价格证明。';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      '您可以使用我们的 API 贡献价格信息。\n如果您想大规模贡献价格信息，请通过 prices@openfoodfacts.org 与我们联系。';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title => '欢迎来到开放产品资讯！';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      '什么是开放产品信息？';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts 是一个庞大的开放数据库，其中包含**任何带有条形码的产品，但不包括食品、化妆品或宠物食品**。';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      '从电子产品到玩具，从服装到清洁用品，只要有条形码，都可以添加进去。本项目旨在为日常物品构建“物联网”，使所有相关信息都能被普遍获取。';

  @override
  String get guide_open_products_facts_features_title => '开放产品事实的特点';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts 旨在通过提供循环解决方案，帮助消费者**延长物品的使用寿命**，从而维护、**修理**、**回收**物品或将其转赠给新的主人。';

  @override
  String get guide_open_products_facts_features_arg1_title => '某些产品的碳足迹';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '法国环境管理署 ADEME 发布的 **Impact CO2** 提供了许多类别的 **碳排放影响**，请务必对产品进行准确分类。';

  @override
  String get guide_open_products_facts_features_arg2_title => '许多产品的可修复性指数';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      '只要有法国可修复性指数，我们就会显示出来。此外，**您可以使用民间分类引擎开始收集相关变量**；这样，即使在没有该指数的国家/地区，我们也可以在将来自行重新计算该指数。';

  @override
  String get guide_open_products_facts_features_arg3_title => '寻找捐赠/转售产品的方法';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      '我们提供指向**第三方循环经济友好型服务**的链接，帮助您以二手商品的形式找到心仪的产品，从而更加环保地利用地球资源。\n请注意，我们并未因此获得报酬，且该系统目前仅作为法国两家网站的示例。您可以通过在维基上记录更多网站来帮助扩展该系统。';

  @override
  String get guide_open_products_facts_information_title => '哪些信息有用？';

  @override
  String get guide_open_products_facts_information_text =>
      '针对如此广泛的物品，**我们收集的数据具有灵活性**。为此，**我们创建了民间分类引擎**。';

  @override
  String get guide_open_products_facts_folksonomy_title => '民间分类引擎';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      '民间分类引擎是一款帮助您完善产品相关属性的工具。这不仅有助于提升搜索和发现率，还能在未来计算并展示更多有趣的内容。';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      '您可以添加任何键和值，例如：**compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      '系统会自动提供可能的属性建议，我们也非常欢迎您添加和记录您喜欢的产品类型的新属性。';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-en.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => '开放的食物偏好';

  @override
  String get guide_coming_soon_button_title => '即将推出';

  @override
  String get guide_learn_more_subtitle => '点击了解更多';

  @override
  String get preview_badge => '预览';

  @override
  String get prices_feedback_form => '点击这里向我们发送您对这项新功能的反馈！';

  @override
  String get menu_button_list_actions => '选择操作';

  @override
  String get error_loading_photo => '照片加载错误';

  @override
  String get photo_viewer_action_use_picture_as => '用作…';

  @override
  String get photo_viewer_use_picture_as_tooltip => '使用此图片作为…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return '使用此图片作为… ($language)';
  }

  @override
  String get photo_viewer_details_button => '细节';

  @override
  String get photo_viewer_details_button_accessibility_label => '这张照片的详细信息';

  @override
  String get photo_viewer_details_title => '照片详情';

  @override
  String get photo_viewer_details_contributor_title => '贡献者';

  @override
  String get photo_viewer_details_size_title => '尺寸';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height 像素';
  }

  @override
  String get photo_viewer_details_date_title => '日期';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => '兼容的';

  @override
  String get user_lists_action_multi_select => '多选';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return '您的匹配度得分： $score%';
  }

  @override
  String get product_image_front_accessibility_label => '正面图片';

  @override
  String get product_image_ingredients_accessibility_label => '成分列表：';

  @override
  String get product_image_nutrition_accessibility_label => '营养信息图片';

  @override
  String get product_image_packaging_accessibility_label => '包装图片';

  @override
  String get product_image_other_accessibility_label => '其他图片';

  @override
  String get product_image_outdated_message => '此图片可能已经过期了';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type （此图片可能已过期）';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type （此图可能被制作者锁定）';
  }

  @override
  String get product_image_error => '无法加载图像！';

  @override
  String product_image_error_accessibility_label(String type) {
    return '无法加载 $type （网络错误？）';
  }

  @override
  String get product_page_image_no_image_available => '没有图像！';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      '此产品暂无图片';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      '重新排序或隐藏操作';

  @override
  String get product_page_action_bar_setting_modal_title => '编辑操作';

  @override
  String get product_page_action_bar_item_move_up => '上移';

  @override
  String get product_page_action_bar_item_move_down => '下移';

  @override
  String get product_page_action_bar_item_enable => '启用操作';

  @override
  String get product_page_action_bar_item_disable => '禁用操作';

  @override
  String get product_page_pending_operations_banner_title => '正在上传您的编辑…';

  @override
  String get product_page_pending_operations_banner_message =>
      '此页面显示的数据**尚未反映您的修改**。\n请等待几秒钟…';

  @override
  String get product_add_a_language => '添加语言';

  @override
  String barcode_accessibility_label(String barcode) {
    return '条形码 $barcode';
  }

  @override
  String get carousel_close_tooltip => '从轮播中移除该产品';

  @override
  String get carousel_unsupported_header => '不支持的条形码！';

  @override
  String get carousel_unsupported_title => '哎呀！';

  @override
  String get carousel_unsupported_text => '扫描的条形码不受 Open Food Facts 支持！';

  @override
  String get carousel_error_header => '错误！';

  @override
  String get carousel_error_title => '真糟糕！';

  @override
  String get carousel_error_text_1 => '我们无法下载此条形码的信息：';

  @override
  String get carousel_error_text_2 => '请检查您的互联网连接或单击此按钮：';

  @override
  String get carousel_error_button => '重试';

  @override
  String get carousel_unknown_product_header => '未知产品';

  @override
  String get carousel_unknown_product_title => '恭喜！你找到了__稀有宝石！__';

  @override
  String get carousel_unknown_product_text =>
      '我们的协作数据库包含超过** 300 万种产品**，但此条形码不存在：';

  @override
  String get carousel_unknown_product_button => '添加该商品';

  @override
  String get carousel_loading_header => '正在加载信息...';

  @override
  String get carousel_loading_title => '您刚刚扫描了带有以下条形码的产品：';

  @override
  String get carousel_loading_text => '我们正在超过**300 万种产品**的数据库中搜索它！';

  @override
  String get product_type_subtitle_food => '蔬菜、水果、冷冻食品…';

  @override
  String get product_type_subtitle_beauty => '化妆品、肥皂、牙膏…';

  @override
  String get product_type_subtitle_pet_food => '狗粮、猫粮…';

  @override
  String get product_type_subtitle_product => '智能手机、家具…';

  @override
  String get photo_field_front => '产品照片';

  @override
  String get photo_field_ingredients => '原料的照片';

  @override
  String get photo_field_nutrition => '营养成分的照片';

  @override
  String get photo_field_packaging => '包装信息照片';

  @override
  String get photo_already_exists => '这张照片已经存在';

  @override
  String get photo_missing => '这张照片不见了';

  @override
  String get date => '日期';

  @override
  String get photo_rotate_left => '左边旋转';

  @override
  String get photo_rotate_right => '右边旋转';

  @override
  String get photo_undo_action => '撤消上一个操作';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location的世界地图';
  }

  @override
  String get open_street_map_contributor_attribution => 'OpenStreetMap 贡献者';

  @override
  String get not_applicable_short => '不适用';

  @override
  String get knowledge_panel_warning_text => '警告';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      '为什么这个 Nutri-Score 与包装上的不同？';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      '可能有两种解释：\n成分表和/或营养成分表不是最新的。\n\n我们提供 Nutri-Score 的“更新版计算方法”。请检查包装上是否有“新计算”的标语。';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      '检查成分';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      '查看营养成分';

  @override
  String url_not_supported(String url) {
    return '很抱歉，我们无法打开以下网址：\n$url';
  }

  @override
  String get product_list_export => '出口';

  @override
  String get product_list_import => '进口';

  @override
  String get product_footer_action_barcode => '查看条形码';

  @override
  String get product_footer_action_barcode_short => '条形码';

  @override
  String get product_footer_action_open_website => '打开网站';

  @override
  String get product_footer_action_report => '报告';

  @override
  String get product_footer_action_contributor_guide => '帮助';

  @override
  String get product_footer_action_data_quality_tags => '数据质量';

  @override
  String get product_page_tab_for_me => '为我';

  @override
  String get product_page_tab_website => '网站';

  @override
  String get product_page_tab_prices => '价格';

  @override
  String get prices_explanation_card_title => '为什么是价格？';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** 是一个收集和分享全球产品价格的项目🌍。Open Prices 由 Open Food Facts 开发和维护。';

  @override
  String get explanation_card_learn_more_button => '更多信息';

  @override
  String get product_page_tab_folksonomy => '民间经济学';

  @override
  String get folksonomy_explanation_card_title => '民间分类法的属性有哪些？';

  @override
  String get folksonomy_explanation_card_line1 => '属性采用**键值对**格式。';

  @override
  String get folksonomy_explanation_card_line2 => '这些属性由贡献者创建和归档，可用于任何用途。';

  @override
  String get folksonomy_action_external_link_title => '打开外部链接';

  @override
  String get folksonomy_action_external_link_warning => '外部链接可能不安全。您真的要访问吗？';

  @override
  String get prices_products_empty_title => '暂无价格';

  @override
  String get prices_products_empty_explanation => '成为第一个做出贡献的人！';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return '前 $pageSize 个产品（总计： $total个）';
  }

  @override
  String get app_review_title => '你喜欢这个应用吗？';

  @override
  String get app_review_low => '还可以做得更好';

  @override
  String get app_review_medium => '不错';

  @override
  String get app_review_high => '我喜欢它！';

  @override
  String get app_review_feedback_modal_title => '帮助我们改进我们的应用程序';

  @override
  String get app_review_feedback_modal_content =>
      '如果您有几分钟时间，请填写此表，以便我们可以在以后的更新中改进：';

  @override
  String get app_review_feedback_modal_open_form => '填写表格';

  @override
  String get app_review_feedback_modal_later => '稍后再询问我';

  @override
  String get nutrition_facts_extract_new => '新功能：您可以自动从图片中提取营养成分！';

  @override
  String get nutrition_facts_extract_button_text => '马上解析';

  @override
  String get nutrition_facts_extract_in_progress => '正在提取…';

  @override
  String get nutrition_facts_extract_successful => '提取成功';

  @override
  String get nutrition_facts_extract_failed => '未能从图片中提取营养成分';

  @override
  String get prices_discount => '折扣';

  @override
  String get prices_stats_statistics => '统计数据';

  @override
  String get prices_stats_title => '价格统计';

  @override
  String get prices_stats_prices_section => '价格';

  @override
  String get prices_stats_products_section => '产品';

  @override
  String get prices_stats_locations_section => '地点';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => '贡献者';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => '其他';

  @override
  String get prices_stats_total => '总计';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => '消耗量';

  @override
  String get prices_stats_with_price => '有价格';

  @override
  String get prices_stats_food => '食物';

  @override
  String get prices_stats_beauty => '美丽';

  @override
  String get prices_stats_products => '产品';

  @override
  String get prices_stats_pet_food => '宠物食品';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => '国家/地区';

  @override
  String get prices_stats_price_tag => '价格标签';

  @override
  String get prices_stats_receipt => '收据';

  @override
  String get prices_stats_gdpr_request => 'GDPR 要求';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => '网站';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => '其他';

  @override
  String get prices_stats_last_updated => '最后更新于';

  @override
  String get prices_stats_error => '加载统计数据时发生错误。';

  @override
  String get product_edit_robotoff_question_answered => '问题已解答！';

  @override
  String get product_edit_robotoff_proof => '证明';

  @override
  String get preferences_card_general => '一般';

  @override
  String get preferences_prices_title => '价格';

  @override
  String get preferences_prices_subtitle => '管理您的价格偏好';

  @override
  String get preferences_card_project => '开放食品事实项目';

  @override
  String get preferences_contribute_title => '贡献';

  @override
  String get preferences_my_contributions_title => '我的贡献';

  @override
  String get preferences_my_stats_title => '我的统计数据';

  @override
  String get preferences_contribute_subtitle => '翻译，改进我们的工具…';

  @override
  String get preferences_connect_title => '连接';

  @override
  String get preferences_connect_subtitle => '联系我们或在社交媒体上关注我们';

  @override
  String get preferences_support_title => '捐赠';

  @override
  String get preferences_support_subtitle => '帮助我们向全球数百万消费者提供信息';

  @override
  String get preferences_card_help => '帮助与支持';

  @override
  String get preferences_faq_title => '常见问题';

  @override
  String get preferences_faq_subtitle => '获取问题的答案';

  @override
  String get logged_out => '已注销';

  @override
  String get preferences_app_bar_message => '感谢您成为我们的会员之一！';

  @override
  String get preferences_app_bar_products_modified => '产品修改';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => '查看所有统计数据';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '在 $provider 中搜索“$keyword”';
  }

  @override
  String get preferences_app_bar_search_hint => '搜索设置（例如 Nutri-Score）';

  @override
  String get preferences_accessibility_show_emoji => '辅助功能：显示表情符号';

  @override
  String get preferences_accessibility_remove_colors => '辅助功能：删除颜色';

  @override
  String get preferences_app_settings_products => '产品';

  @override
  String get preferences_card_about => '关于';

  @override
  String get preferences_legal_information_title => '法律信息';

  @override
  String get preferences_legal_information_subtitle => '使用条款、隐私政策等';

  @override
  String get preferences_terms_of_use => '使用条款';

  @override
  String get preferences_legal_mentions => '法务信息';

  @override
  String get preferences_legal_header =>
      'Open Food Facts 是一个食品产品数据库，**由每个人创建，为每个人服务**。\n您可以使用它来做出更好的食物选择，而且由于它是**开放数据**，任何人都可以**将其重新用于任何目的**。';

  @override
  String get preferences_privacy_policy => '隐私政策';

  @override
  String get preferences_licenses => '许可证';

  @override
  String get preferences_about_app_title => '关于应用程序';

  @override
  String get preferences_about_app_subtitle => '技术信息、开发人员信息等';

  @override
  String get preferences_card_information => '信息';

  @override
  String get preferences_version_number_title => '版本号';

  @override
  String get preferences_scanner_title => '扫描器';

  @override
  String get preferences_app_store => '应用商店';

  @override
  String get preferences_app_system_settings => '系统设置';

  @override
  String get preferences_source_code => '访问源代码';

  @override
  String get preferences_source_code_subtitle => '并开始对数百万人产生影响';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => '补全产品信息';

  @override
  String get preferences_tips => '尖端';

  @override
  String get tips_discover_nutriscore => '探索新的Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle => '在Open Food Facts网站上';

  @override
  String get preferences_manage_account_title => '管理我的帐户';

  @override
  String get preferences_manage_account_tooltip => '管理您的帐户';

  @override
  String get preferences_change_password_title => '更改我的密码';

  @override
  String get preferences_danger_zone => '危险区域';

  @override
  String get preferences_account_deletion_subtitle => '您的所有贡献都将丢失';

  @override
  String get preferences_contributions_title => '贡献';

  @override
  String get preferences_dev_mode_app_settings_title => '应用设置';

  @override
  String get preferences_dev_mode_offline_data_subtitle => '离线扫描产品的非常实验性的方法';

  @override
  String get preferences_dev_mode_refresh_products_title => '从服务器刷新所有产品';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      '除非绝对必要，否则请避免这样做';

  @override
  String get preferences_dev_mode_demo_mode_title => '演示模式';

  @override
  String get preferences_dev_mode_add_cards_title => '将卡片添加到扫描仪';

  @override
  String get preferences_dev_mode_add_cards_subtitle => '向扫描仪添加 3 个样品产品';

  @override
  String get preferences_dev_mode_folksonomy_host_title => '大众分类法主持人';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return '主持人： $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title => '可访问性实验';

  @override
  String get preferences_dev_mode_multi_products_selection_title => '多产品价格选择';

  @override
  String get preferences_dev_mode_user_ordered_kp_title => '用户订购的知识面板';

  @override
  String get preferences_dev_mode_location_search_title => '临时访问位置搜索';

  @override
  String get preferences_dev_mode_comparison_title => '并排比较 2 或 3 种产品';

  @override
  String get preferences_dev_mode_product_list_import_title => '产品列表导入';

  @override
  String get preferences_faq_scores_methodologies_title => '分数和方法';

  @override
  String get preferences_faq_nutriscore_subtitle => '了解Nutri-Score的计算方法';

  @override
  String get preferences_faq_nutriscore_v2_subtitle => '了解方法论的主要变化';

  @override
  String get preferences_faq_discover_project_title => '探索項目';

  @override
  String get preferences_faq_discover_off_title => '发现Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title => '探索Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title => '探索Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => '探索Open Prices';

  @override
  String get preferences_faq_discover_opf_title => '了解开放产品信息';

  @override
  String get preferences_faq_faq_title => 'FAQ - 常见问题';

  @override
  String get preferences_faq_off_ngo_title => 'Open Food Facts非政府组织';

  @override
  String get preferences_about_information_title => '信息';

  @override
  String get preferences_connect_community_updates_title => '获取社区更新';

  @override
  String get preferences_connect_newsletter_subtitle => '随时了解应用和社区新闻';

  @override
  String get preferences_connect_community_calendar_title => '订阅我们的社区日历';

  @override
  String get preferences_connect_community_calendar_subtitle => '参加我们的虚拟活动';

  @override
  String get preferences_connect_blog_title => 'Open Food Facts博客';

  @override
  String get preferences_connect_blog_subtitle => '获取最新资讯';

  @override
  String get preferences_connect_community_help_title => '获取社区帮助';

  @override
  String get preferences_connect_improve_app_title => '帮助我们改进应用程序';

  @override
  String get preferences_connect_debug_info_title => '向我们发送调试信息';

  @override
  String get preferences_connect_debug_info_subtitle => '向我们发送包含详细调试信息的电子邮件';

  @override
  String get preferences_connect_feedback_title => '向我们发送有关应用程序的反馈';

  @override
  String get preferences_connect_feedback_subtitle => '帮助塑造应用程序的未来';

  @override
  String get preferences_connect_survey_title => '参与应用调查';

  @override
  String get preferences_connect_survey_subtitle => '帮助我们了解下一步应该构建什么';

  @override
  String get preferences_connect_professionals_title => '专业人士';

  @override
  String get preferences_connect_pro_subtitle =>
      '完全免费，确保 500 个应用和数百万消费者的数据准确无误。自助服务，兼容您的 PIM 或电子表格 (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle => '联系我们开始使用';

  @override
  String get preferences_connect_press_title => '媒体报道';

  @override
  String get preferences_connect_press_page_subtitle => '获取报告所需的所有材料';

  @override
  String get preferences_connect_press_email_subtitle =>
      '如有新闻咨询或想告知我们您的报告，请联系我们';

  @override
  String get preferences_contribute_active_volunteer_title => '成为一名积极的志愿者';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      '开发、沟通、设计… 欢迎任何形式的志愿服务或专业知识！';

  @override
  String get preferences_contribute_how_to_subtitle => '探索您可以做出贡献的多种方式';

  @override
  String get preferences_contribute_mobile_dev_title => '移动应用程序开发';

  @override
  String get preferences_contribute_sw_dev_subtitle => '了解如何为软件开发做出贡献';

  @override
  String get preferences_contribute_alpha_subtitle => '每日不稳定版本，全新功能';

  @override
  String get preferences_contribute_local_community_title => '发展您的当地社区';

  @override
  String get preferences_contribute_translate_subtitle => '协助软件、内容、成分分析翻译';

  @override
  String get preferences_contribute_share_subtitle => '我们准备了一个小模板来帮助您:-)';

  @override
  String get preferences_contribute_country_subtitle => '提高贵国食品透明度的简单步骤';

  @override
  String get preferences_contribute_data_quality_title => '数据质量';

  @override
  String get preferences_contribute_data_quality_team_title => '加入数据质量团队';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      '加入我们的努力，确保数据库的完整和准确';

  @override
  String get preferences_contributions_products_added_title => '添加的产品';

  @override
  String get preferences_contributions_new_products_subtitle =>
      '我添加到 Open Food Facts 的新产品';

  @override
  String get preferences_contributions_to_be_completed_title => '我需要完成的产品';

  @override
  String get preferences_contributions_all_incomplete_title => '所有未完成产品';

  @override
  String get preferences_my_contributions_prices_title => '价格';

  @override
  String get preferences_my_contributions_my_prices_title => '我的价格';

  @override
  String get preferences_my_contributions_my_prices_subtitle => '我的价格，我的证据…';

  @override
  String get preferences_contributions_all_incomplete_subtitle => '您可以帮助完成的产品';

  @override
  String get preferences_contributions_categorize_subtitle =>
      '帮助计算您所在国家/地区的Nutri-Score和Green-Score';

  @override
  String get preferences_prices_user_prices_subtitle => '我贡献的价格';

  @override
  String get preferences_prices_proofs_subtitle => '价格标签和收据';

  @override
  String get preferences_prices_add_receipt_subtitle => '拍摄收据照片并扫描相关条形码';

  @override
  String get preferences_prices_add_price_tags_subtitle => '拍摄商店里的价格照片';

  @override
  String get preferences_prices_newest_title => '最新价格';

  @override
  String get preferences_prices_newest_subtitle => 'Open Prices社区添加的最新价格';

  @override
  String get preferences_prices_top_contributors_title => '贡献最多奖项的贡献者';

  @override
  String get preferences_prices_metrics_title => '开盘价指标';

  @override
  String get preferences_prices_metrics_subtitle => '跟踪项目的进展';

  @override
  String get preferences_prices_ways_contribute_title => '贡献方式';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      '在人工智能的帮助下确认自己或他人添加的价格';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      '从相机胶卷中快速添加多张收据或货架照片';

  @override
  String get preferences_prices_challenges_title => '每月挑战';

  @override
  String get preferences_prices_challenges_subtitle => '参与每月主题任务收集价格';

  @override
  String get preferences_prices_loyalty_data_title => '恢复您的忠诚度数据';

  @override
  String get preferences_prices_gdpr_subtitle => '了解如何请求您的数据';

  @override
  String get preferences_page_customize_app_title => '自定义应用程序';

  @override
  String get preferences_page_contribute_project_title => '为项目做出贡献';

  @override
  String get preferences_page_contribute_project_subtitle =>
      '帮助Open Food Facts的简单方法';

  @override
  String get preferences_page_faq_subtitle => '评分方法、帮助以及有关项目的更多信息';

  @override
  String get product_edit_robotoff_positive_button => '接受建议';

  @override
  String get product_edit_robotoff_negative_button => '拒绝建议';

  @override
  String get product_edit_robotoff_show_proof => '出示证明';

  @override
  String get product_edit_robotoff_expand_proof => '扩大证明';

  @override
  String get product_page_tab_raw_data => '原始数据';

  @override
  String page_indicator_with_total(int current, int total) {
    return '页面 $current / $total';
  }

  @override
  String page_indicator(int current) {
    return '页面 $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count 项中的 $total 项';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count 项中的 $total 项';
  }

  @override
  String item_count(int count) {
    return '$count 件';
  }

  @override
  String item_count_string(String count) {
    return '$count 件';
  }

  @override
  String get prices_no_result => '未找到价格统计数据。';

  @override
  String get prices_error_loading_more_items => '加载更多项目时出错';

  @override
  String get prices_proof_error => '身份验证失败，无法获取证明';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count 的 $total 证明';
  }

  @override
  String proof_count(int count) {
    return '$count 证明';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count 的 $total 位贡献者';
  }

  @override
  String contributors_count(int count) {
    return '$count 贡献者';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count 个位置中的 $total 个位置';
  }

  @override
  String prices_locations_count(int count) {
    return '$count 位置';
  }

  @override
  String get restart_to_apply_message => '请重新启动应用程序以应用更改。';

  @override
  String get preferences_app_settings_graphical_interface_title => '图形界面';

  @override
  String get preferences_app_settings_media_title => '媒体';

  @override
  String get preferences_about_app_development_title => '开发';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts实验室';

  @override
  String get preferences_root_account_title => '账户';

  @override
  String get preferences_contribute_translate_header =>
      '将 Open Food Facts 引入您的语言';

  @override
  String get preferences_contribute_enroll_alpha => '注册该应用程序的 alpha 版本';

  @override
  String get preferences_dev_mode_section_data => '贡献和产品数据';

  @override
  String get preferences_dev_preferences_show_folksonomy_title => '不显示大众分类法';

  @override
  String get preferences_account_title => '账户';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '添加于 $created';
  }

  @override
  String get location_map_details_title => '位置详情';

  @override
  String get location_map_details_name => '名称';

  @override
  String get location_map_details_street => '街道';

  @override
  String get location_map_details_city => '城市';

  @override
  String get location_map_details_postcode => '邮政编码';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => '坐标';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
