// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Vietnamese (`vi`).
class AppLocalizationsVi extends AppLocalizations {
  AppLocalizationsVi([String locale = 'vi']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Có';

  @override
  String get add => 'Thêm vào';

  @override
  String get account_delete_message =>
      'Bạn có chắc rằng bạn muốn xóa tài khoản của bạn?\nNếu có lý do cụ thể hãy chia sẻ bên dưới';

  @override
  String get reason => 'Lý do';

  @override
  String get okay => 'Okay';

  @override
  String get validate => 'Xác thực';

  @override
  String get create => 'Tạo';

  @override
  String get applyButtonText => 'Áp dụng';

  @override
  String get next_label => 'Kế tiếp';

  @override
  String get continue_label => 'Tiếp tục';

  @override
  String get exit_label => 'Thoát';

  @override
  String get previous_label => 'Quay lại';

  @override
  String get go_back_to_top => 'Quay trở lại bên trên';

  @override
  String get save => 'Lưu';

  @override
  String get save_confirmation => 'Bạn chắc chắn muốn lưu?';

  @override
  String get skip => 'Bỏ qua';

  @override
  String get cancel => 'Huỷ';

  @override
  String get ignore => 'Bỏ qua';

  @override
  String get close => 'Đóng';

  @override
  String get no => 'Không';

  @override
  String get stop => 'Dừng';

  @override
  String get finish => 'Hoàn thành';

  @override
  String get calculate => 'Tính toán';

  @override
  String get reset_food_prefs => 'Đặt lại sở thích ăn uống';

  @override
  String get error => 'Đã xảy ra lỗi';

  @override
  String get error_occurred => 'Đã xảy ra lỗi';

  @override
  String get featureInProgress =>
      'Chúng tôi vẫn đang xây dựng tính năng này, nhớ theo dõi nhé';

  @override
  String get label_web => 'Xem trên web';

  @override
  String get learnMore => 'Tìm hiểu thêm';

  @override
  String get unknown => 'Không biết';

  @override
  String get match_very_good => 'Rất phù hợp';

  @override
  String get match_good => 'Phù hợp';

  @override
  String get match_poor => 'Kém phù hợp';

  @override
  String get match_may_not => 'Không phù hợp';

  @override
  String get match_does_not => 'Không phù hợp';

  @override
  String get match_unknown => 'Độ phù hợp không xác định';

  @override
  String get match_short_very_good => 'Rất phù hợp';

  @override
  String get match_short_good => 'Phù hợp';

  @override
  String get match_short_poor => 'Kém phù hợp';

  @override
  String get match_short_may_not => 'Không phù hợp';

  @override
  String get match_short_does_not => 'Không phù hợp';

  @override
  String get match_short_unknown => 'Độ phù hợp không xác định';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => 'Đang tìm';

  @override
  String get welcomeToOpenFoodFacts => 'Chào mừng đến với Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts is a global non-profit powered by local communities.';

  @override
  String get productDataUtility =>
      'Xem dữ liệu thực phẩm liên quan đến sở thích của bạn.';

  @override
  String get healthCardUtility => 'Chọn thực phẩm tốt cho bạn.';

  @override
  String get ecoCardUtility => 'Chọn thực phẩm tốt cho hành tinh này.';

  @override
  String get server_error_open_new_issue =>
      'No server response! You may open an issue with the following link.';

  @override
  String get sign_in_text =>
      'Sign in to your Open Food Facts account to save your contributions';

  @override
  String get incorrect_credentials => 'Tên đăng nhập hoặc mật khẩu không đúng.';

  @override
  String get password_lost_incorrect_credentials =>
      'This email or username doesn\'t exist. Please check your credentials.';

  @override
  String get password_lost_server_unavailable =>
      'We are currently experiencing slowdowns on our servers and we apologise for it. Please try again later.';

  @override
  String get login => 'Tên người dùng';

  @override
  String get login_result_type_server_unreachable => 'Network is unreachable';

  @override
  String get login_result_type_server_issue =>
      'Problem on the server. Please try later.';

  @override
  String get login_page_username_or_email =>
      'Vui lòng nhập tên người dùng hoặc e-mail';

  @override
  String get login_page_password_error_empty => 'Vui lòng nhập mật khẩu';

  @override
  String get create_account => 'Tạo tài khoản';

  @override
  String get sign_in => 'Đăng nhập';

  @override
  String get sign_in_mandatory =>
      'Để sử dụng tính năng này chúng tôi cần bạn đăng nhập.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Thoát';

  @override
  String get sign_out_confirmation => 'Bạn có chắc muốn thoát không?';

  @override
  String get password => 'Mật khẩu';

  @override
  String get forgot_password => 'Quên mật khẩu';

  @override
  String get forgot_password_question => 'Quên mật khẩu?';

  @override
  String get view_profile => 'Xem hồ sơ';

  @override
  String get reset_password => 'Đặt lại mật khẩu';

  @override
  String get reset_password_explanation_text =>
      'Trong trường hợp quên mật khẩu, vui lòng điền tên đăng nhập hoặc địa chỉ email để nhận hướng dẫn đặt lại mật khẩu. Xin hãy kiểm tra cả hòm thư Spam.';

  @override
  String get username_or_email => 'Tên đăng nhập hoặc email';

  @override
  String get reset_password_done =>
      'Một email chứa liên kết đặt lại mật khẩu đã được gửi tới địa chỉ email liên kết với tài khoản của bạn. Vui lòng kiểm tra đồng thời hòm thư spam';

  @override
  String get send_reset_password_mail => 'Thay đổi mật khẩu';

  @override
  String get enter_some_text => 'Vui lòng nhập một vài kí tự';

  @override
  String get sign_up_page_title => 'Đăng ký';

  @override
  String get sign_up_page_action_button => 'Đăng ký';

  @override
  String get sign_up_page_action_doing_it => 'Signing up…';

  @override
  String get sign_up_page_action_ok =>
      'Chúc mừng! Tài khoản của bạn vừa được tạo.';

  @override
  String get sign_up_page_display_name_hint => 'Tên';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Vui lòng nhập tên hiển thị bạn muốn sử dụng';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'Email là bắt buộc';

  @override
  String get sign_up_page_email_error_invalid => 'Email không hợp lệ';

  @override
  String get sign_up_page_username_hint => 'Tên người dùng: Hiển thị công khai';

  @override
  String get sign_up_page_username_error_empty => 'Vui lòng nhập tên đăng nhập';

  @override
  String get sign_up_page_username_error_invalid =>
      'Vui lòng nhập tên đăng nhập hợp lệ';

  @override
  String get sign_up_page_username_description =>
      'Tên người dùng không được chứa dấu cách, chữ hoa hoặc ký tự đặc biệt.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Tên người dùng không được quá $value kí tự';
  }

  @override
  String get sign_up_page_password_hint => 'Mật khẩu';

  @override
  String get sign_up_page_password_error_empty => 'Vui lòng nhập mật khẩu';

  @override
  String get sign_up_page_password_error_invalid =>
      'Vui lòng nhập mật khẩu hợp lệ (ít nhất 6 kí tự)';

  @override
  String get sign_up_page_confirm_password_hint => 'Xác nhận mật khẩu';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Vui lòng xác nhận mật khẩu';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Mật khẩu không khớp';

  @override
  String get sign_up_page_agree_text => 'I agree to the Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'điều khoản sử dụng và đóng góp';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Khi tạo tài khoản, việc đồng ý với Điều khoản sử dụng là bắt buộc, tuy nhiên người dùng ẩn danh vẫn có thể đóng áp thông qua ứng dụng';

  @override
  String get sign_up_page_producer_checkbox => 'Tôi là nhà sản xuất thực phẩm';

  @override
  String get sign_up_page_producer_hint => 'Nhà sản xuất/thương hiệu';

  @override
  String get sign_up_page_producer_error_empty =>
      'Vui lòng nhập tên nhà sản xuất hoặc thương hiệu';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'I\'d like to subscribe to the Open Food Facts newsletter (You can unsubscribe from it at any time)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Tên người dùng đã tồn tại, vui lòng chọn tên người dùng khác.';

  @override
  String get sign_up_page_email_already_exists =>
      'đã tồn tại, đăng nhập vào tài khoản hoặc thử với một email khác.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Vui lòng cung cấp một địa chỉ email hợp lệ.';

  @override
  String get sign_up_page_server_busy =>
      'We are deeply sorry, we have some technical difficulties to create your account. Please try again later.';

  @override
  String get settingsTitle => 'Cài đặt';

  @override
  String get darkmode => 'Giao diện';

  @override
  String get darkmode_dark => 'Tối';

  @override
  String get darkmode_light => 'Sáng';

  @override
  String get darkmode_system_default => 'Mặc định hệ thống';

  @override
  String get thanks_for_contributing => 'Thanks for contributing!';

  @override
  String get contributors_label => 'They are building the app';

  @override
  String get contributors_dialog_title => 'Người đóng góp';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Contributor: $name';
  }

  @override
  String get contributors_description =>
      'A list of all contributors of this app';

  @override
  String get support => 'Hỗ Trợ';

  @override
  String get support_join_slack =>
      'Yêu cầu hỗ trợ trên kênh Slack của chúng tôi';

  @override
  String get support_via_forum => 'Ask for help on our forum';

  @override
  String get support_via_email => 'Gửi email tới chúng tôi';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Gửi nhật ký ứng dụng?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Bạn có muốn đính kèm nhật ký ứng dụng vào email của mình không?';

  @override
  String get termsOfUse => 'Điều khoản sử dụng';

  @override
  String get legalNotices => 'Legal notices';

  @override
  String get privacy_policy => 'Privacy policy';

  @override
  String get about_this_app => 'Thông tin về ứng dụng';

  @override
  String get contribute => 'Góp phần';

  @override
  String get contribute_sw_development => 'Phát triển phần mềm';

  @override
  String get contribute_develop_text =>
      'The code for every Open Food Facts product is available on GitHub. You are welcome to reuse the code (it\'s open source) and help us improve it, for everyone, on all the planet.';

  @override
  String get contribute_develop_text_2 =>
      'You can join the Open Food Facts Slack chatroom which is the preferred way to ask questions.';

  @override
  String get contribute_develop_dev_mode_title => 'Chế độ DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Kích hoạt Chế độ DEV';

  @override
  String get contribute_donate_title => 'Ủng hộ';

  @override
  String get contribute_donate_header => 'Donate to Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Please acknowledge that with the internal alpha version, complete loss of data is possible, and the app may become unusable at any time !';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Các sản phẩm cần được hoàn thành';

  @override
  String get contribute_improve_header => 'Đang cải thiện';

  @override
  String get contribute_improve_text =>
      'The database is the core of the project. It\'s easy and very quick to help. You can download the mobile app for your phone, and start adding or improving products.\n\nOn the other hand, Open Food Facts website offers many ways to contribute: ';

  @override
  String get contribute_translate_header => 'Dịch';

  @override
  String get contribute_data_quality => 'Chất lượng số liệu';

  @override
  String get contribute_translate_link_text => 'Bắt đầu dịch';

  @override
  String get contribute_translate_text =>
      'Open Food Facts is a global project, containing products from more than 160 countries. Open Food Facts is translated into dozens of languages, with constantly evolving content.';

  @override
  String get contribute_translate_text_2 =>
      'Phiên dịch là một trong những nhiệm vụ trọng tâm của dự án';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'Share Open Food Facts with your friends';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribute prices by requesting a GDPR export of your loyalty cards data';

  @override
  String get tap_to_answer => 'Nhấn vào đây để trả lời câu hỏi';

  @override
  String get tap_to_answer_hint =>
      'Tap here to answer questions about this product';

  @override
  String get robotoff_questions_loading_hint =>
      'Please wait while questions about this product are loaded';

  @override
  String get saving_answer => 'Lưu câu trả lời của bạn';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Sign in to your Open Food Facts account to get credit for your contributions';

  @override
  String get question_yes_button_accessibility_value => 'Có';

  @override
  String get question_no_button_accessibility_value => 'Không';

  @override
  String get question_skip_button_accessibility_value => 'Bỏ qua câu hỏi này';

  @override
  String get tap_to_edit_search => 'Chạm để chỉnh sửa tìm kiếm';

  @override
  String get myPreferences => 'Tuỳ chọn của tôi';

  @override
  String get account_create_message =>
      'Create your account and join the Open Food Facts community to help build food knowledge all over the world!';

  @override
  String get join_us => 'Tham gia ngay';

  @override
  String get myPreferences_profile_title => 'Thông tin của bạn';

  @override
  String get myPreferences_profile_subtitle =>
      'Manage your Open Food Facts contributor account.';

  @override
  String get myPreferences_settings_title => 'Cài đặt ứng dụng';

  @override
  String get myPreferences_settings_subtitle => 'Dark mode, Languages…';

  @override
  String get myPreferences_food_title => 'Sở thích ăn uống';

  @override
  String get myPreferences_food_subtitle =>
      'Chọn loại thông tin về thực phẩm quan trọng nhất đối với bạn.';

  @override
  String get myPreferences_food_comment =>
      'Choose what information about food matters most to you, in order to rank food according to your preferences, see the information you care about first, and get a compatibility summary. Those food preferences stay on your device, and are not associated with your Open Food Facts contributor account if you have one.';

  @override
  String get confirmResetPreferences => 'Đặt lại sở thích ăn uống của bạn?';

  @override
  String get myPersonalizedRanking => 'Xếp hạng cá nhân của tôi';

  @override
  String get ranking_tab_all => 'Tất cả';

  @override
  String get ranking_subtitle_match_yes => 'Phù hợp nhất cho bạn';

  @override
  String get ranking_subtitle_match_no => 'Độ phù hợp thấp';

  @override
  String get ranking_subtitle_match_maybe => 'Độ phù hợp không xác định';

  @override
  String get refresh_with_new_preferences =>
      'Làm mới danh sách với các tùy chọn mới của bạn';

  @override
  String get reloaded_with_new_preferences => 'Đã tải lại với các tùy chọn mới';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Quét';

  @override
  String get history_navbar_label => 'Lịch sử';

  @override
  String get list_navbar_label => 'Danh sách';

  @override
  String get category => 'Lọc theo danh mục';

  @override
  String get category_all => 'Tất cả';

  @override
  String get category_search => '(tìm kiếm danh mục)';

  @override
  String get filter => 'Bộ lọc';

  @override
  String get scan => 'Products from the Scan screen';

  @override
  String get scan_history => 'Lịch sử quét';

  @override
  String get search => 'Tìm kiếm';

  @override
  String get search_product_help =>
      'Tìm kiếm sản phẩm,\nthương hiệu hoặc mã vạch';

  @override
  String get search_filter => 'Bộ lọc tìm kiếm';

  @override
  String get search_history => 'Lịch sử tìm kiếm';

  @override
  String get search_store => 'Search for a store';

  @override
  String get search_store_help => 'Gợi ý: thêm thành phố hoặc quốc gia';

  @override
  String get tap_for_more => 'Tap to see more info…';

  @override
  String get product => 'Sản phẩm';

  @override
  String get unknownBrand => 'Thương hiệu không xác định';

  @override
  String get unknownProductName => 'Tên sản phẩm không xác định';

  @override
  String get label_refresh => 'Làm mới';

  @override
  String get label_reload => 'Reload';

  @override
  String get image => 'Hình ảnh';

  @override
  String get front_photo => 'Ảnh mặt trước';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (this image may be outdated)';
  }

  @override
  String get outdated_image_short_label => 'may be outdated';

  @override
  String get ingredients => 'Thành phần';

  @override
  String get ingredients_editing_instructions =>
      'Keep the original order. Indicate the percentage when specified. Separate with a comma or hyphen and use parentheses for ingredients of an ingredient.';

  @override
  String get ingredients_editing_error => 'Không thể lưu các thành phần.';

  @override
  String get ingredients_editing_image_error =>
      'Không lấy được hình ảnh nguyên liệu mới.';

  @override
  String get ingredients_editing_title => 'Chỉnh sửa nguyên liệu';

  @override
  String get ingredients_photo => 'Ảnh chụp thành phần';

  @override
  String get packaging_editing_instructions =>
      'Liệt kê tất cả các phần đóng gói, phân tách bằng dấu phẩy hoặc gạch chéo, kèm theo số lượng (ví dụ 1 hoặc 6), loại (ví dụ chai, hộp, lon), chất liệu ( ví dụ nhựa, kim loại, nhôm), kích thước nếu có (ví dụ 33cl) và hướng dẫn tái chế.\nVí dụ 1 chai thủy tinh tái chế, 1 nút chai nhựa cần loại bỏ';

  @override
  String get packaging_editing_error => 'Lỗi lưu ảnh bao bì.';

  @override
  String get packaging_editing_image_error => 'Không thể lấy ảnh bao bì mới.';

  @override
  String get packaging_editing_title => 'Chỉnh sửa bao bì';

  @override
  String get nutrition => 'Dinh dưỡng';

  @override
  String get nutrition_facts_photo => 'Ảnh chụp thông tin dinh dưỡng';

  @override
  String get nutrition_facts_editing_title => 'Edit Nutrition Facts';

  @override
  String get packaging_information => 'Thông tin bao bì';

  @override
  String get packaging_information_photo => 'Ảnh chụp thông tin bao bì';

  @override
  String get missing_product => 'Bạn đã tìm thấy một sản phẩm mới!';

  @override
  String get add_product_take_photos =>
      'Take photos of the packaging to add this product to Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Đầu tiên xin vui lòng chụp một số hình ảnh. Bạn luôn có thể hoàn thiện thông tin sản phẩm sau đó.';

  @override
  String get add_product_information_button_label => 'Add product information';

  @override
  String get new_product => 'Sản phẩm mới';

  @override
  String get new_product_found_title => 'New product found!';

  @override
  String get new_product_found_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get new_product_found_button => 'Thêm sản phẩm này';

  @override
  String get new_product_leave_title => 'Leave this page?';

  @override
  String get new_product_leave_message =>
      'Có vẻ như bạn chưa không nhập bất cứ thứ gì. Bạn có thực sự muốn rời khỏi trang này?';

  @override
  String get new_product_dialog_description =>
      'Please take photos of the packaging to add this product to our common database';

  @override
  String get new_product_dialog_illustration_description =>
      'An illustration with unknown Nutri-Score and Green Score';

  @override
  String get front_packaging_photo_button_label => 'Ảnh mặt trước sản phẩm';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Xác nhận tải lên ảnh trước của Sản phẩm';

  @override
  String get confirm_button_label => 'Xác nhận';

  @override
  String get send_image_button_label => 'Gửi ảnh';

  @override
  String get crop_page_action_saving => 'Đang lưu ảnh…';

  @override
  String get crop_page_action_cropping => 'Đang cắt hình ảnh…';

  @override
  String get crop_page_action_local => 'Đang lưu phiên bản cục bộ…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oops… there\'s something with your photo!';

  @override
  String get crop_page_action_local_failed_message =>
      'We are unable to process the image locally, before sending it to our server. Please try again later or contact-us if the issue persists.';

  @override
  String get crop_page_action_retake => 'Retake a photo';

  @override
  String get crop_page_too_small_image_title => 'The image is too small!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'The minimum size in pixels for picture upload is ${expectedMinWidth}x$expectedMinHeight. The current picture is ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Chuẩn bị cuộc gọi đến máy chủ…';

  @override
  String get front_packaging_photo_title => 'Ảnh bao bì phía trước';

  @override
  String get ingredients_photo_title => 'Ảnh thành phần';

  @override
  String get nutritional_facts_photo_title => 'Ảnh chụp thông tin dinh dưỡng';

  @override
  String get recycling_photo_title => 'Ảnh quy định tái chế';

  @override
  String get take_photo_title => 'Chụp ảnh';

  @override
  String get take_more_photo_title => 'Chụp thêm ảnh';

  @override
  String get front_photo_uploaded => 'Đã tải ảnh mặt trước lên';

  @override
  String get ingredients_photo_button_label => 'Ảnh chụp thành phần';

  @override
  String get ingredients_photo_uploaded => 'Đã tải ảnh thành phần lên';

  @override
  String get nutrition_cache_loading_error =>
      'Không thể tải thông tin dinh dưỡng từ bộ nhớ sản phẩm';

  @override
  String get nutritional_facts_photo_button_label =>
      'Ảnh chụp thông tin dinh dưỡng';

  @override
  String get nutritional_facts_input_button_label =>
      'Thêm vào thông tin dinh dưỡng';

  @override
  String get nutritional_facts_added => 'Thông tin dinh dưỡng đã được thêm';

  @override
  String get categories_added => 'Đã thêm danh mục';

  @override
  String get new_product_title_nutriscore => 'Tính toán Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Tính điểm bằng cách điền danh mục thực phẩm và các giá trị dinh dưỡng';

  @override
  String get new_product_title_environmental_score => 'Compute the Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Get it by filling at least a category';

  @override
  String get new_product_additional_environmental_score =>
      'Make Green Score computation more precise with origins, packaging & more';

  @override
  String get new_product_title_nova =>
      'Compute the food processing level (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Get it by filling the food category and ingredients';

  @override
  String get new_product_desc_nova_unknown =>
      'Mức độ chế biến thực phẩm không xác định';

  @override
  String get new_product_title_pictures => 'Hãy chụp một vài bức ảnh!';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'Và một số dữ liệu cơ bản…';

  @override
  String new_product_done_msg(String username) {
    return 'Thanks for your contribution “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Thanks for your contribution!';

  @override
  String get new_product_done_button_label => 'Discover the completed product';

  @override
  String get hey_incomplete_product_message =>
      'Tap to answer 3 questions NOW to compute Nutri-Score, Green Score & Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Tap now to answer 2 questions to help analyze this cosmetic!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Tap now to answer 3 questions to help analyze this pet food product!';

  @override
  String get hey_incomplete_product_message_product =>
      'Tap now to help complete this product!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Ảnh thông tin dinh dưỡng đã được tải lên';

  @override
  String get recycling_photo_button_label => 'Ảnh thông tin tái chế';

  @override
  String get recycling_photo_uploaded =>
      'Ảnh thông tin tái chế đã được tải lên';

  @override
  String get take_more_photo_button_label => 'Chụp thêm ảnh';

  @override
  String get other_photo_uploaded => 'Ảnh hỗn hợp đã được tải lên';

  @override
  String get retake_photo_button_label => 'Chụp lại';

  @override
  String get selecting_photo => 'Chọn ảnh';

  @override
  String get uploading_image => 'Đang tải ảnh lên hệ thống';

  @override
  String get uploading_image_type_front =>
      'Uploading front image to Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Uploading ingredients image to Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Uploading nutrition image to Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Uploading packaging image to Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Uploading other image to Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Uploading image to Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Thêm các thành phần còn thiếu';

  @override
  String get score_add_missing_packaging_image =>
      'Thêm hình ảnh bao bì bị thiếu';

  @override
  String get score_add_missing_nutrition_facts =>
      'Thêm thông tin dinh dưỡng còn thiếu';

  @override
  String get score_add_missing_product_traces => 'Add missing product traces';

  @override
  String get score_add_missing_product_category =>
      'Thêm danh mục sản phẩm bị thiếu';

  @override
  String get score_add_missing_precise_product_category =>
      'Chọn một danh mục chính xác hơn';

  @override
  String get score_add_missing_product_countries =>
      'Thêm quốc gia sản phẩm bị thiếu';

  @override
  String get score_add_missing_product_emb =>
      'Thêm mã truy xuất nguồn gốc sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_labels => 'Thêm nhãn sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_origins =>
      'Thêm nguồn gốc sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_stores =>
      'Thêm cửa hàng bán sản phẩm còn thiếu';

  @override
  String get score_add_missing_product_brands => 'Add missing product brands';

  @override
  String get score_update_nutrition_facts => 'Cập nhật thông tin dinh dưỡng';

  @override
  String get nutrition_page_title => 'Giá trị dinh dưỡng';

  @override
  String get nutrition_page_nutritional_info_title => 'Nutritional information';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Values specified on the product:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Có';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Không';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Open photo';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Good practices: Nutritional information';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Sometimes nutrition facts are **not specified on the packaging** or on a document given with the product. In this case, and only in this case, you can set the value to **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'Nutritional values:';

  @override
  String get nutrition_page_per_100g => 'mỗi 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100g/ml';

  @override
  String get nutrition_page_per_serving => 'mỗi khẩu';

  @override
  String get nutrition_page_add_nutrient => 'Thêm chất dinh dưỡng';

  @override
  String get nutrition_page_serving_size => 'Kích thước phục vụ';

  @override
  String get nutrition_page_serving_size_hint =>
      'Input a serving size (eg: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Good practices: Serving size';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'This value helps to **make a proportional calculation of each nutrient per serving size**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Allowed units** are: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** or **60 G** (prefer the first one)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** or **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Invalid unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Invalid units';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **candies** and 2 **biscuits**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Missing unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Số không hợp lệ';

  @override
  String get nutrition_page_update_running =>
      'Updating the product on the server…';

  @override
  String get nutrition_page_update_done => 'Sản phẩm được cập nhật!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Use the product quantity as serving size';

  @override
  String get nutrition_page_photo_error => 'Unable to load the photo';

  @override
  String get more_photos => 'Nhiều hình ảnh thú vị hơn';

  @override
  String get view_more_photo_button =>
      'View all existing photos for this product';

  @override
  String get no_product_found => 'Không tìm thấy sản phẩm';

  @override
  String get no_location_found => 'No location found';

  @override
  String get not_found => 'không tìm thấy:';

  @override
  String get refreshing_product => 'Làm mới sản phẩm';

  @override
  String get product_refreshed => 'Sản phẩm đã được làm mới';

  @override
  String product_image_accessibility_label(String date) {
    return 'Image taken on $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Image taken on $date. This image may be outdated';
  }

  @override
  String get product_image_outdated => 'This image may be outdated';

  @override
  String get product_image_outdated_explanations_title =>
      'This image may be outdated';

  @override
  String get product_image_outdated_explanations_content =>
      'This image was taken more than a year ago.\n**Please check that\'s it\'s still up-to-date**.\n\nThis is **just a warning**. If the content is still the same, you can ignore this message.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Replace photo ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Add a photo ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Chụp mới';

  @override
  String get product_image_action_take_picture => 'Chụp ảnh';

  @override
  String get product_image_action_from_gallery =>
      'Select from your phone\'s gallery';

  @override
  String get product_image_action_choose_existing_photo =>
      'Select from the product photos';

  @override
  String get product_image_details_label => 'Information about the photo';

  @override
  String get product_image_details_from_producer => 'From the producer';

  @override
  String get product_image_details_contributor => 'Người đóng góp';

  @override
  String get product_image_details_contributor_producer =>
      'Contributor (producer)';

  @override
  String get product_image_details_date => 'Date';

  @override
  String get product_image_details_date_unknown => 'Không biết';

  @override
  String get homepage_main_card_logo_description =>
      'Welcome to Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scan** a barcode or\n**search** for a product';

  @override
  String get homepage_main_card_search_field_hint => 'Search for a product';

  @override
  String get homepage_main_card_search_field_tooltip => 'Start search';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Latest news: $news_title';
  }

  @override
  String get tagline_app_review => 'Do you like the app?';

  @override
  String get tagline_app_review_button_positive => 'I love it! 😍';

  @override
  String get tagline_app_review_button_negative => 'Not really…';

  @override
  String get tagline_app_review_button_later => 'Ask me later';

  @override
  String get tagline_feed_news_button => 'Know more';

  @override
  String get app_review_negative_modal_title => 'You don\'t like our app?';

  @override
  String get app_review_negative_modal_text =>
      'Could you take a few seconds to tell us why?';

  @override
  String get app_review_negative_modal_positive_button => 'Yes, absolutely!';

  @override
  String get app_review_negative_modal_negative_button => 'Không';

  @override
  String get could_not_refresh => 'Không thể làm mới sản phẩm';

  @override
  String get product_internet_error_modal_title => 'An error has occurred!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'We are unable to fetch information about this product due to a network error. Please check your internet connection and try again.\n\nInternal error:\n$error';
  }

  @override
  String get product_tags_title => 'Product properties';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Không có thuộc tính';

  @override
  String get product_tags_explanation =>
      'Bằng cách thêm thuộc tính (khóa/giá trị) vào sản phẩm, bạn giúp làm phong phú thêm sản phẩm đó.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Add properties';

  @override
  String get add_edit_tags => 'Add or edit properties';

  @override
  String get edit_tag => 'Edit property';

  @override
  String get remove_tag => 'Remove property';

  @override
  String get tag_key => 'Property';

  @override
  String get tag_keys => 'Của cải';

  @override
  String get tag_key_uneditable => 'Property (uneditable)';

  @override
  String get tag_key_input_hint => 'Input a property';

  @override
  String get tag_value => 'Giá trị';

  @override
  String get tag_values => 'Giá trị';

  @override
  String get tag_value_input_hint => 'Input a value';

  @override
  String get tag_key_item => 'Property:';

  @override
  String get tag_value_item => 'Value:';

  @override
  String get tag_key_explanations =>
      'A key must be lowercase and without any spaces.';

  @override
  String tag_key_already_exists(String property) {
    return 'A tag with a property $property already exists!';
  }

  @override
  String get product_internet_error =>
      'Không thể nạp thông tin về sản phẩm này do lỗi kết nối mạng.';

  @override
  String get cached_results_from => 'Hiển thị kết quả từ:';

  @override
  String get product_search_same_category => 'Tìm giải pháp thay thế';

  @override
  String get product_search_same_category_short => 'So sánh';

  @override
  String get product_search_same_category_error =>
      'This feature can only be used for products with a category.\n\nPlease edit the product to add a category.';

  @override
  String get product_improvement_add_category =>
      'Thêm danh mục để tính Điểm dinh dưỡng.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Thêm thông tin dinh dưỡng để tính điểm Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Add nutrition facts and a category to calculate the Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Không thể tính được Nutri-Score cho sản phẩm này, có thể do danh mục không đạt tiêu chuẩn. Nếu đây là lỗi, vui lòng liên hệ với chúng tôi.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Hình ảnh dinh dưỡng đã quá hạn: vui lòng cập nhật.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'The Green Score takes into account the origins of the ingredients. Please take a photo of the ingredient list and/or any geographic claim or edit the product, so they can be taken into account.';

  @override
  String get country_chooser_label => 'Vui lòng chọn quốc gia';

  @override
  String get currency_chooser_label => 'Please choose a currency';

  @override
  String get country_change_message => 'You have just changed countries.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Do you want to change the currency from $previousCurrency to $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Please choose a country:';

  @override
  String get country_chooser_label_from_settings => 'Your country';

  @override
  String get country_selection_explanation =>
      'Một số đặc điểm môi trường là đặc thù địa lý';

  @override
  String get product_removed_comparison =>
      'Sản phẩm bị gỡ bỏ khỏi phần so sánh';

  @override
  String get native_app_settings => 'Cài đặt ứng dụng gốc';

  @override
  String get native_app_description =>
      'Open systems settings for Open Food Facts';

  @override
  String get product_removed_history => 'Sản phẩm bị xóa khỏi lịch sử';

  @override
  String get product_removed_list => 'Product removed from list';

  @override
  String get product_could_not_remove => 'Không thể loại bỏ sản phẩm';

  @override
  String get no_prodcut_in_list => 'Không có sản phẩm nào trong danh sách này';

  @override
  String get no_product_in_section => 'Không có sản phẩm nào trong phần này';

  @override
  String get recently_seen_products => 'All viewed products';

  @override
  String get clear => 'Xóa';

  @override
  String get clear_long => 'Empty the list';

  @override
  String get really_clear => 'Bạn có thực sự muốn xoá danh sách này?';

  @override
  String pct_match(Object percent) {
    return '$percent% phù hợp';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ngày trước',
      one: 'một ngày trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count giờ trước',
      one: 'một giờ trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count phút trước',
      one: 'một phút trước',
      zero: 'gần một phút trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tháng trước',
      one: 'một tháng trước',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tuần trước',
      one: 'một tuần trước',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'So sánh $count sản phẩm',
      one: 'So sánh một sản phẩm',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count selected products',
      one: 'One selected product',
      zero: 'No selected product',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Compare selected products';

  @override
  String get delete_products_mode => 'Delete selected products';

  @override
  String get select_all_products_mode => 'Select all products';

  @override
  String get select_none_products_mode => 'Select none';

  @override
  String get compare_products_appbar_title => 'So sánh sản phẩm';

  @override
  String get compare_products_appbar_subtitle =>
      'Xin vui lòng chọn ít nhất hai sản phẩm';

  @override
  String get retry_button_label => 'Thử lại';

  @override
  String get connect_with_us => 'Kết nối với chúng tôi';

  @override
  String get tiktok => 'Follow us on TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Follow us on Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Follow us on X (formerly Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Follow us on Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Follow us on BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'FAQ';

  @override
  String get discover => 'Khám phá';

  @override
  String get how_to_contribute => 'Làm thế nào để đóng góp';

  @override
  String get hint_knowledge_panel_message =>
      'Bạn có thể nhấn vào bất kì vị trí nào trên thẻ để xem chi tiết hơn về những gì bạn đang xem. Thử ngay!';

  @override
  String get permissions_page_title => 'Truy cập máy ảnh';

  @override
  String get permissions_page_body1 =>
      'Để quét mã vạch với máy ảnh của bạn, vui lòng Cấp quyền truy cập.';

  @override
  String get permissions_page_body2 =>
      'Nếu bạn thay đổi ý định, lựa chọn này có thể được bật hoặc tắt bất kì lúc nào trong phần cài đặt.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Phát hành: $release)\nMẫu: $model\nSản phẩm: $product\nThiết bị: $device\nNhãn hiệu:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nMẫu: $model\nMẫu bản địa hóa: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nPhiên bản ứng dụng:$appVersion\nBản dựng ứng dụng số:$appBuildNumber\nTên gói ứng dụng:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Cho phép';

  @override
  String get refuse_button_label => 'Từ chối';

  @override
  String get ask_me_later_button_label => 'Để sau';

  @override
  String get are_you_sure => 'Bạn chắc chứ?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Nhiều hơn trên $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Welcome !';

  @override
  String get onboarding_home_welcome_text2 =>
      'The app that helps you choose food that is good for **you** and the **planet**!';

  @override
  String get onboarding_continue_button => 'Tiếp tục';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Đang tải lên sản phẩm mẫu đầu tiên của bạn';

  @override
  String get onboarding_welcome_warning =>
      'Xin lỗi, đây là sản phẩm mẫu của chúng tôi, bạn không thể chỉnh sửa nó :)';

  @override
  String get product_list_your_ranking => 'Xếp hạng của bạn';

  @override
  String get product_list_empty_icon_desc => 'Lịch sử không có sẵn';

  @override
  String get product_list_empty_title => 'Bắt đầu quét';

  @override
  String get product_list_empty_message =>
      'Các sản phẩm bạn quét sẽ xuất hiện ở đây và bạn có thể kiểm tra thông tin chi tiết về chúng';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'sản phẩm',
      one: 'sản phẩm',
      zero: 'sản phẩm',
    );
    return 'Làm mới $_temp0 trong lịch sử của bạn';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'sản phẩm',
      one: 'Sản phẩm',
      zero: 'Sản phẩm',
    );
    return '$_temp0 làm mới hoàn thành';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Đang tải xuống dữ liệu';

  @override
  String get loading_dialog_default_error_message => 'Không thể tải dữ liệu';

  @override
  String get account_delete => 'Xoá tài khoản';

  @override
  String get account_delete_title => 'Xóa tài khoản của tôi';

  @override
  String get user_profile => 'Tài khoản';

  @override
  String get user_profile_title_guest => 'Xin chào!';

  @override
  String get user_profile_subtitle_guest =>
      'Sign-in or sign-up to join the Open Food Facts community';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts login: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Chào mừng $id!';
  }

  @override
  String get email_subject_account_deletion => 'Xoá tài khoản';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hi there, please delete my Open Food Facts account: $userId';
  }

  @override
  String get settings_app_app => 'Ứng dụng';

  @override
  String get settings_app_data => 'Quyền riêng tư và giám sát';

  @override
  String get settings_app_camera => 'Máy ảnh';

  @override
  String get settings_app_products => 'Sản phẩm';

  @override
  String get settings_app_miscellaneous => 'Các tùy chọn khác';

  @override
  String get camera_play_sound_title => 'Phát âm thanh khi quét';

  @override
  String get camera_play_sound_subtitle =>
      'Có tiếng bíp mỗi lần quét thành công';

  @override
  String get camera_window_accessibility_label =>
      'Scan a barcode with your camera';

  @override
  String get app_haptic_feedback_title => 'Rung & Phản hồi';

  @override
  String get app_haptic_feedback_subtitle =>
      'Rung sau khi thực hiện một số hành động (giải mã mã vạch, xóa bỏ sản phẩm…).';

  @override
  String get crash_reporting_toggle_title => 'Báo cáo lỗi';

  @override
  String get crash_reporting_toggle_subtitle =>
      'When enabled, crash reports are automatically submitted to Open Food Facts\' error tracking system, so that bugs can be fixed and thus improve the app.';

  @override
  String get send_anonymous_data_toggle_title => 'Gửi dữ liệu ẩn danh';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Chỉnh sửa ảnh';

  @override
  String get permission_photo_error => 'Lỗi';

  @override
  String get permission_photo_denied_title =>
      'Cho phép sử dụng máy ảnh để quét mã vạch';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Để có trải nghiệm nâng cao, vui lòng cho phép $appName truy cập vào máy ảnh của bạn. Bạn sẽ có thể quét trực tiếp mã vạch.';
  }

  @override
  String get permission_photo_denied_button => 'Cho phép';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Quyền truy cập bị từ chối';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Vì trước đây bạn đã từ chối quyền đối với máy ảnh, bạn phải cho phép nó theo cách thủ công từ Cài đặt.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Mở cài đặt';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Huỷ';

  @override
  String get permission_photo_none_found => 'No camera detected';

  @override
  String get permission_photo_denied => 'Không có quyền truy cập máy ảnh';

  @override
  String get show_product_pictures => 'Show product pictures';

  @override
  String get edit_product_label => 'Chỉnh sửa sản phẩm';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Uploading your edits…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Your edits are being **sent in the background** (or later in case of error).\nYou can continue editing other product fields.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Your edits are being **sent in the background** (or later in case of error).';

  @override
  String get edit_product_label_short => 'Chỉnh sửa';

  @override
  String edit_product_form_item_help(String value) {
    return 'How to enter \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Please enter a non-empty value!';

  @override
  String get edit_product_form_item_error_existing =>
      'This value is already there!';

  @override
  String get edit_product_form_item_add_action_brand => 'Add a new brand';

  @override
  String get edit_product_form_item_add_action_label => 'Add a new label';

  @override
  String get edit_product_form_item_add_action_store => 'Add a new store';

  @override
  String get edit_product_form_item_add_action_origin => 'Add a new origin';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Add a new traceability code';

  @override
  String get edit_product_form_item_add_action_country => 'Add a new country';

  @override
  String get edit_product_form_item_add_action_category => 'Add a new category';

  @override
  String get edit_product_form_item_add_action_trace => 'Add a new trace';

  @override
  String get edit_product_form_item_add_suggestion => 'Add suggestion';

  @override
  String get edit_product_form_item_deny_suggestion => 'Từ chối đề xuất';

  @override
  String get edit_product_form_item_details_title => 'Thông tin cơ bản';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Tên sản phẩm, thương hiệu, số lượng';

  @override
  String get edit_product_form_item_other_details_title => 'Additional details';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Website…';

  @override
  String get edit_product_form_item_photos_title => 'Ảnh';

  @override
  String get edit_product_form_item_photos_subtitle => 'Thêm hoặc làm mới ảnh';

  @override
  String get edit_product_form_item_labels_title => 'Nhãn & Giấy chứng nhận';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Environmental, Quality labels…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Input a label (eg: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'nhãn hiệu';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Good practices: Labels';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Any characteristic of the product **which is factual** and different from the other fields.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Made in Belgium, produced in Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rich in fiber, source of iron…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Cửa hàng';

  @override
  String get edit_product_form_item_stores_hint => 'Input a store';

  @override
  String get edit_product_form_item_stores_type => 'cửa hàng';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Good practices: Stores';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Input the store where you bought the product.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Nguồn gốc';

  @override
  String get edit_product_form_item_origins_hint =>
      'Input an origin (eg: Germany)';

  @override
  String get edit_product_form_item_origins_type => 'nước';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Good practices: Origins';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Add **any indications of origins you can find on the packaging**.\nYou need not worry about origins indicated directly in the ingredient list.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Beef from Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'The soy does not come from the European Union';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Input a country (eg: Germany)';

  @override
  String get edit_product_form_item_countries_type => 'nước';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Good practices: Countries';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Countries where the product is widely available** (not including stores specialising in foreign products).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Mã xác định nguồn gốc';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Input a code (eg: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'mã truy xuất nguồn gốc';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Good practices: Traceability codes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In this section, you can input codes related to **packaging marks**, **identification marks** or **health marks**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Examples of traceability codes';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC codes** used in the European Community to identify food producers or packagers:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: country code of **France**\n**72.264.002**: geographic data\n**CE**: European Community';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB codes** used in France:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Truy gốc';

  @override
  String get edit_product_form_item_traces_hint => 'dấu vết';

  @override
  String get edit_product_form_item_traces_type =>
      'Input a trace (eg: Soy beans)';

  @override
  String get edit_product_form_item_categories_title => 'Thể loại';

  @override
  String get edit_product_form_item_categories_hint => 'danh mục';

  @override
  String get edit_product_form_item_categories_type =>
      'Input a category (eg: Orange juice)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Good practices: Categories';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicate **only the most specific category**.\nParent categories will be automatically added.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Missing category?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'In case a category is **not available in autocomplete**, feel free to add it anyway.\nThis will help us improve Open Food Facts in your country.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardines in olive oil';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Orange juice from concentrate';

  @override
  String get edit_product_form_item_exit_title => 'Quit without saving?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Bạn có muốn lưu các thay đổi trước khi rời trang?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Lưu thay đổi';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Hủy bỏ thay đổi';

  @override
  String get edit_product_form_item_ingredients_title => 'Thành phần';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zoom in and out by pinching the screen';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zoom in and out the photo';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Using the **Pinch-to-zoom gesture**, you can zoom in or out the photo:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Thêm vào';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Vui lòng nhập một văn bản trước';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Gỡ bỏ';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => 'Save your edit';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancel your edit';

  @override
  String get edit_product_form_item_packaging_title => 'Ảnh hướng dẫn tái chế';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Giá trị dinh dưỡng';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Dinh dưỡng, độ cồn…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Good practices: Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nutritional values';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'First, select if the **values are provided**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Giá trị dinh dưỡng';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Then, input the nutritional values **as indicated on the packaging**. If there is no value, you can click on the \"Eye\" icon.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Missing field?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'If an entry is missing, you can **click on the \"Plus\" icon** to add it (eg: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'Chỉnh sửa';

  @override
  String get edit_product_ingredients_photo_title => 'Ảnh chụp thành phần';

  @override
  String get edit_product_ingredients_list_title => 'Danh sách các thành phần';

  @override
  String get edit_product_packaging_photo_title => 'Packaging photo';

  @override
  String get edit_product_packaging_list_title => 'Packaging list';

  @override
  String get no_data_available => 'No data available';

  @override
  String get product_field_website_title => 'Website';

  @override
  String get origins_editing_title => 'Edit Origins';

  @override
  String get completed_basic_details_btn_text => 'Hoàn thành thông tin cơ bản';

  @override
  String get not_implemented_snackbar_text => 'Chưa thực hiện';

  @override
  String get category_picker_page_appbar_text => 'Thể loại';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extract ingredients from the photo';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Trích xuất thành phần';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extracting ingredients\nfrom the photo';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'To use the \"Extract ingredients\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Làm mới ảnh';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extract packaging\nfrom the photo';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extract packaging';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extracting packaging from the photo';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'To use the \"Extract packaging\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Làm mới ảnh';

  @override
  String get edit_ocr_extract_failed =>
      'Không thể phát hiện văn bản trong hình ảnh.';

  @override
  String get edit_ocr_extract_disabled_title => 'No picture!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'In order to use the text extraction feature, you must first take a photo.';

  @override
  String get user_list_dialog_new_title => 'Danh sách sản phẩm mới';

  @override
  String get user_list_dialog_rename_title => 'Đổi tên danh sách';

  @override
  String get user_list_subtitle_product => 'Danh sách';

  @override
  String get user_list_title => 'Danh sách của bạn';

  @override
  String get user_list_add_product => 'Thêm sản phẩm vào danh sách của bạn';

  @override
  String get user_list_button_new => 'Tạo danh sách mới';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Thêm vào danh sách';

  @override
  String get added_to_list_msg => 'Added to list';

  @override
  String get user_list_popup_clear => 'Clear your history';

  @override
  String get user_list_popup_rename => 'Đổi tên';

  @override
  String get user_list_name_hint => 'My list';

  @override
  String get user_list_name_error_empty => 'Tên là thông tin bắt buộc';

  @override
  String get user_list_name_error_already => 'Tên đã được sử dụng';

  @override
  String get user_list_name_error_same => 'Tên bị trùng';

  @override
  String get user_list_name_input_hint => 'Name of the list';

  @override
  String get try_again => 'Thử lại';

  @override
  String get there_was_an_error => 'Có lỗi xảy ra';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Không tìm thấy danh mục nào cho $items';
  }

  @override
  String get camera_toggle_camera => 'Switch between back and front camera';

  @override
  String get camera_toggle_flash => 'Turn ON or OFF the flash of the camera';

  @override
  String get camera_enable_flash => 'Bật flash';

  @override
  String get camera_disable_flash => 'Tắt flash';

  @override
  String get camera_flash_error_dialog_title => 'An error occurred!';

  @override
  String get camera_flash_error_dialog_message =>
      'An error occurred while changing the state of your flash. Please ensure your smartphone has not the torch already enabled.';

  @override
  String get category_picker_no_category_found_button => 'Quay lại';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Click to open in your browser or in the application (if installed)';

  @override
  String get dev_preferences_screen_title => 'Chế độ DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Truy cập các tính năng thử nghiệm và công cụ phát triển';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Bắt đầu lại phần giới thiệu';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Sau đó, bạn phải khởi động lại Ứng dụng để xem lại.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Chuyển đổi giữa openfoodfacts.org (PROD) và test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Các thông số môi trường thử nghiệm';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL cơ sở cho thử nghiệm hiện tại env: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Máy chủ môi trường thử nghiệm';

  @override
  String get dev_preferences_ml_kit_title => 'Sử dụng ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'sau đó bạn phải khởi động lại ứng dụng này';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Nút bổ sung trên trang sản phẩm';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Chỉnh sửa thành phần thông qua nút bảng điều khiển';

  @override
  String get dev_preferences_export_history_title => 'Xuất lịch sử';

  @override
  String get dev_preferences_export_history_progress_error => 'ngoại lệ';

  @override
  String get dev_preferences_export_history_progress_found =>
      'tìm thấy sản phẩm';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'KHÔNG tìm thấy sản phẩm';

  @override
  String get dev_preferences_export_history_dialog_title => 'Xuất lịch sử';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Huỷ';

  @override
  String get dev_preferences_migration_title => 'Chuyển dữ liệu từ V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Trạng thái: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'thành công hoặc cài đặt mới';

  @override
  String get dev_preferences_migration_status_success => 'thành công';

  @override
  String get dev_preferences_migration_status_error => 'lỗi';

  @override
  String get dev_preferences_migration_status_in_progress => 'đang xử lý';

  @override
  String get dev_preferences_migration_status_required =>
      'bắt buộc (bấm để bắt đầu)';

  @override
  String get dev_preferences_migration_status_not_started => 'không xác định';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Sẽ xóa lịch sử và thêm 3 sản phẩm mới vào';

  @override
  String get dev_preferences_news_custom_url_title => 'Custom URL for news';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL of the JSON file:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Not set';

  @override
  String get dev_preferences_news_provider_status_title => 'Trạng thái';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Last refresh: $date';
  }

  @override
  String get product_type_label_food => 'Food';

  @override
  String get product_type_label_beauty => 'Personal care';

  @override
  String get product_type_label_pet_food => 'Pet food';

  @override
  String get product_type_label_product => 'Khác';

  @override
  String get product_type_selection_title => 'Product type';

  @override
  String get product_type_selection_subtitle =>
      'Select the type of this product';

  @override
  String get product_type_selection_empty =>
      'You need to select a product type first!';

  @override
  String product_type_selection_already(String productType) {
    return 'You cannot change the product type ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Shortcut to Prices app on product page';

  @override
  String get prices_app_button => 'Go to Prices app';

  @override
  String get prices_website_button => 'Mở trên trang web Giá mở';

  @override
  String get prices_bulk_proof_upload_select =>
      'Add price tags directly from gallery';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Once you\'ve selected images, you won\'t be able to edit them!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Cho phép cộng đồng xác thực giá được trích xuất bởi AI.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Multiple Price Tags';

  @override
  String get prices_bulk_proof_upload_title => 'Bulk Proof Upload';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Chọn tập tin';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Bắt đầu tải lên';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Sao chép tệp cục bộ #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Đang chuẩn bị tải lên #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Thất bại ở hình ảnh #$index/$count';
  }

  @override
  String get prices_generic_title => 'Prices';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add $count prices',
      one: 'Add a price',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Send $count prices',
      one: 'Send the price',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Add an item';

  @override
  String get prices_add_a_price => 'Add a price';

  @override
  String get prices_add_a_receipt => 'Add a receipt';

  @override
  String get prices_add_price_tags => 'Add price tags';

  @override
  String prices_barcode_already(String barcode) {
    return 'This barcode ($barcode) is already in the list!';
  }

  @override
  String get prices_barcode_search_not_found => 'Không tìm thấy sản phẩm';

  @override
  String get prices_barcode_search_none_yet => 'No product yet';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Looking for $barcode';
  }

  @override
  String get prices_barcode_enter => 'Enter the Barcode';

  @override
  String get prices_category_enter => 'Mặt hàng không có mã vạch';

  @override
  String get prices_per_kilogram => 'Giá mỗi kilôgam';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / đơn vị';

  @override
  String get prices_category_mandatory => 'Bắt buộc';

  @override
  String get prices_category_optional => 'Không bắt buộc';

  @override
  String get prices_category_error_mandatory => 'Thể loại này là bắt buộc';

  @override
  String get prices_barcode_reader_action => 'Barcode reader';

  @override
  String get prices_view_prices => 'View the prices';

  @override
  String get prices_list_title => 'Bảng giá';

  @override
  String get prices_list_count => 'Số lượng\ngiá';

  @override
  String get prices_list_add_new_price => 'Thêm giá mới\n';

  @override
  String get prices_list_empty_title => 'Chưa có giá!';

  @override
  String get prices_list_empty_subtitle =>
      'Hãy là người đầu tiên thêm một:\nBằng cách quét **biên lai** hoặc **nhãn giá**!';

  @override
  String get prices_entry_shop_not_found => 'Cửa hàng không xác định';

  @override
  String prices_entry_menu_title(String user) {
    return 'Giá nhập từ \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Xem tất cả giá cho sản phẩm này';

  @override
  String get prices_entry_menu_open_proof => 'Xem bằng chứng';

  @override
  String get prices_entry_menu_my_prices => 'Xem giá khác của tôi';

  @override
  String get prices_entry_menu_author_prices =>
      'Xem các mức giá khác của tác giả';

  @override
  String get prices_entry_menu_shop_prices => 'Xem giá khác từ cửa hàng';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: '1 price',
    );
    return '$_temp0 for $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count prices',
      one: 'Only one price',
      zero: 'No price yet',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize prices (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Price: $price / Store: \"$location\" / Published on $date by \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Open proofs of \"$user\"';
  }

  @override
  String get prices_open_proof => 'Open price proof';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count proofs',
      one: 'Only one proof',
      zero: 'No proof yet',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize proofs (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'Chưa có người đóng góp nào!';

  @override
  String get prices_users_empty_explanation =>
      'Hãy là người đầu tiên thêm giá!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize contributors (total: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Chưa có cửa hàng nào!';

  @override
  String get prices_locations_empty_explanation =>
      'Hãy là người đầu tiên thêm giá!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize locations (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count proofs',
      one: 'One proof',
      zero: 'No proof',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: 'One product',
      zero: 'No product',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count users',
      one: 'One user',
      zero: 'No user',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: 'One price',
      zero: 'No price',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Giá đã thêm trước đó';

  @override
  String get prices_amount_subtitle => 'Amount';

  @override
  String get prices_amount_is_discounted => 'Is discounted?';

  @override
  String get prices_amount_price_normal => 'Price';

  @override
  String get prices_amount_price_discounted => 'Discounted price';

  @override
  String get prices_amount_price_not_discounted => 'Original price';

  @override
  String get prices_amount_no_product => 'One product is missing!';

  @override
  String get prices_amount_price_incorrect => 'Incorrect value';

  @override
  String get prices_amount_price_mandatory => 'Mandatory value';

  @override
  String get prices_currency_subtitle => 'Currency';

  @override
  String get prices_date_subtitle => 'Date';

  @override
  String get prices_location_subtitle => 'Shop';

  @override
  String get prices_location_find => 'Find a shop';

  @override
  String get prices_location_mandatory => 'You need to select a shop!';

  @override
  String get prices_location_search_broader =>
      'Couldn\'t find what you were looking for? Let\'s try a broader search!';

  @override
  String get prices_proof_subtitle => 'Proof';

  @override
  String get prices_proof_empty_title => 'Chưa có bằng chứng!';

  @override
  String get prices_proof_empty_explanation =>
      'Bắt đầu bằng cách thêm ảnh **biên lai** hoặc **nhãn giá**!';

  @override
  String get prices_proof_find => 'Select a proof';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Receipt';

  @override
  String get prices_proof_price_tag => 'Price tag';

  @override
  String get prices_proof_mandatory => 'You need to select a proof!';

  @override
  String get prices_add_validation_error => 'Validation error';

  @override
  String get prices_privacy_warning_title => 'Privacy warning';

  @override
  String get prices_unknown_product => 'Unknown product';

  @override
  String get prices_privacy_warning_main_message =>
      'Prices **will be public**, along with the store they refer to.\n\nThat might allow people who know about your Open Food Facts pseudonym to:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Infer in which area you live';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Know what you are buying';

  @override
  String get prices_privacy_warning_sub_message =>
      'If you are uneasy with that, please change your pseudonym, or create a new Open Food Facts account and log into the app with it.';

  @override
  String get i_refuse => 'I refuse';

  @override
  String get i_accept => 'I accept';

  @override
  String get prices_currency_change_proposal_title => 'Change the currency?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Your current currency is **$currency**. Would you like to change it to **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Yes, use $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'No, keep $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Xong';

  @override
  String get dev_mode_section_server => 'Server configuration';

  @override
  String get dev_mode_section_news => 'News provider configuration';

  @override
  String get dev_mode_section_product_page => 'Product page';

  @override
  String get dev_mode_section_ui => 'User Interface';

  @override
  String get dev_mode_section_experimental_features => 'Experimental features';

  @override
  String get dev_mode_hide_environmental_score_title => 'Exclude Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Use a spellchecker for OCR screens';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredients and packaging)';

  @override
  String get dev_mode_reset_app_language_title => 'Đặt lại ngôn ngữ ứng dụng';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Thêm thẻ';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Chuyển đổi giữa prices.openfoodfacts.org (PROD) và môi trường thử nghiệm';

  @override
  String get search_history_item_edit_tooltip => 'Reuse and edit this search';

  @override
  String get search_history_item_remove_tooltip => 'Gỡ bỏ';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Bạn vừa tải xuống tất cả $totalSize sản phẩm.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Tải thêm $count sản phẩm\nĐã tải $downloaded trên tổng $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Your search of $search is in progress.\n\nPlease wait a few seconds…';
  }

  @override
  String get user_search_contributor_title => 'Sản phẩm tôi đã thêm';

  @override
  String get user_search_informer_title => 'Sản phẩm tôi đã chỉnh sửa';

  @override
  String get user_search_photographer_title => 'Sản phẩm tôi đã chụp';

  @override
  String get user_search_to_be_completed_title =>
      'Các sản phẩm sắp hoàn thiện của tôi';

  @override
  String get user_search_prices_title => 'My prices';

  @override
  String get user_search_proofs_title => 'My proofs';

  @override
  String get user_search_proof_title => 'My proof';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Giá đóng góp: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Latest Prices added';

  @override
  String get all_search_prices_top_user_title => 'Top price contributors';

  @override
  String get all_search_prices_top_location_title =>
      'Stores with the most prices';

  @override
  String get prices_contribution_assistant => 'Price Contribution Assistant';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Add Multiple Proofs';

  @override
  String get all_search_prices_top_location_single_title => 'Prices in a store';

  @override
  String get all_search_prices_top_product_title =>
      'Products with the most prices';

  @override
  String get all_search_to_be_completed_title =>
      'Tất cả các sản phẩm sắp hoàn thiện';

  @override
  String get categorize_products_country_title =>
      'Help categorize products in your country';

  @override
  String get edit_product_action_retake_picture => 'Chụp lại ảnh';

  @override
  String get edit_product_action_take_picture => 'Chụp ảnh';

  @override
  String get edit_product_action_confirm => 'Xác nhận';

  @override
  String get signup_page_terms_of_use_line1 =>
      'I agree to the Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'điều khoản sử dụng và đóng góp';

  @override
  String get analytics_consent_image_semantic_label => 'Biểu tượng phân tích';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Lỗi nghiêm trọng: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Lỗi nghiêm trọng: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Hoàn thành thông tin cơ bản';

  @override
  String get edit_photo_button_label => 'Chỉnh sửa';

  @override
  String get edit_photo_unselect_button_label => 'Bỏ chọn ảnh';

  @override
  String get edit_photo_select_existing_button_label =>
      'Chọn một hình ảnh có sẵn';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Select an image by clicking on it';

  @override
  String get edit_photo_select_existing_download_label =>
      'Retrieving existing images…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Không có hình ảnh nào được tải lên trước đây liên quan đến sản phẩm này.';

  @override
  String get edit_photo_language_not_this_one =>
      'No image in that language yet';

  @override
  String get edit_photo_language_none => 'No image yet';

  @override
  String get category_picker_screen_title => 'Thể loại';

  @override
  String get basic_details => 'Thông tin chi tiết cơ bản';

  @override
  String get product_name => 'Tên sản phẩm';

  @override
  String get product_names => 'Product Names';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Add a new translation';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Before validating, please ensure you only add a translation **if the language is present on the packaging**';

  @override
  String get add_basic_details_product_name_open_photo => 'View front photo';

  @override
  String get add_basic_details_product_name_take_photo => 'Take front photo';

  @override
  String get add_basic_details_product_name_hint =>
      'Input the name of the product (eg: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Thay đổi ngôn ngữ mặc định?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Bạn có muốn ngôn ngữ mặc định của sản phẩm được đặt thành \'$language\' không?';
  }

  @override
  String get explanation_section_good_examples => 'Good examples';

  @override
  String get explanation_section_bad_examples => 'Bad examples';

  @override
  String get add_basic_details_product_name_help_title =>
      'Good practices: Product name';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'The product name is the **main name printed on the packaging**. It can be a registered trademark.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Note:** Please don\'t add a translation **if the language is not present on the packaging**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomato Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Don\'t include the brand in the name';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomato Ketchup **by Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Don\'t use symbols ®, ™, © or similar';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count other translations',
      one: '$count other translation',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Tên thương hiệu';

  @override
  String get brand_names => 'Brand names';

  @override
  String get add_basic_details_brand_name_error =>
      'Vui lòng nhập tên thương hiệu';

  @override
  String get add_basic_details_brand_names_hint => 'Input brands (eg: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Good practices: Brands';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Input **all the brands of the product**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Main brand';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'The **main brand**, generally clearly displayed on the front pack, should be **entered first**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Other brands';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'When sold **by a big company**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** is sold by **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'When sold with its brand **translated in multiple languages**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** is sometimes written **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Số lượng và cân nặng';

  @override
  String get add_basic_details_quantity_hint =>
      'Input the weight and if needed the quantity (eg : 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Good practices: Quantity';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copy the value indicated on the product and **don\'t forget the units**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** or **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (for 6 eggs)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(for a product with 3 boxes, each of 150g)';

  @override
  String get barcode => 'Mã vạch';

  @override
  String barcode_barcode(String barcode) {
    return 'Mã vạch: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Mã vạch không hợp lệ';

  @override
  String get basic_details_add_success =>
      'Thông tin chi tiết cơ bản đã được thêm thành công';

  @override
  String get basic_details_add_error =>
      'Không thể thêm thông tin chi tiết cơ bản. Vui lòng thử lại lúc khác';

  @override
  String get clear_search => 'Clear your search';

  @override
  String get confirm_clear =>
      'Bạn sắp xóa toàn bộ lịch sử của mình: bạn có chắc muốn tiếp tục?';

  @override
  String get alert_clear_selected_user_list =>
      'You\'re about to clear selected items in your history';

  @override
  String get confirm_clear_selected_user_list =>
      'Are you sure you want to continue?';

  @override
  String get alert_select_items_to_clear =>
      'Please select one or more items to clear';

  @override
  String confirm_clear_user_list(String name) {
    return 'Bạn sắp xóa danh sách ($name): bạn có chắc muốn tiếp tục?';
  }

  @override
  String get confirm_delete_user_list_title => 'Delete the list?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'You\'re about to delete the list \"$name\".\nAre you sure you want to continue?';
  }

  @override
  String get confirm_delete_user_list_button => 'Yes, I confirm';

  @override
  String importance_label(String name, String id) {
    return '$name quan trọng: $id';
  }

  @override
  String get user_list_all_title => 'Danh sách';

  @override
  String get user_list_all_empty => 'Tạo danh sách sản phẩm đầu tiên';

  @override
  String get product_list_select => 'Select a list';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Sản phẩm',
      one: 'Một sản phẩm',
      zero: 'Danh sách trống',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Thêm danh sách';

  @override
  String get open_food_preferences_tooltip =>
      'Chỉnh sửa tiêu chí thực phẩm của bạn';

  @override
  String get add_photo_button_label => 'Thêm ảnh';

  @override
  String get add_packaging_photo_button_label =>
      'Chụp ảnh thông tin đóng gói/tái chế bất kì';

  @override
  String get add_origin_photo_button_label =>
      'Take photos of any origin information';

  @override
  String get add_emb_photo_button_label =>
      'Take photos of any traceability code information';

  @override
  String get add_label_photo_button_label =>
      'Take photos of any labels & certifications information';

  @override
  String get choose_image_source_title => 'Chọn nguồn ảnh';

  @override
  String get choose_image_source_body => 'Vui lòng chọn một nguồn ảnh';

  @override
  String get gallery_source_label => 'Thư viện';

  @override
  String get gallery_source_access_denied_dialog_title => 'Access denied';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Unfortunately, the application can\'t access your gallery, as you have previously denied the permission.\n\nPlease go to the app settings in your phone Settings -> Photos';

  @override
  String get gallery_source_access_denied_dialog_button => 'Open the Settings';

  @override
  String get share => 'Chia sẻ';

  @override
  String share_product_text(String url) {
    return 'Have a look at this product on Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Have a look at this product on Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Have a look at this product on Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Have a look at this product on Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Have a look at my list of products on Open Food Facts: $url';
  }

  @override
  String get capture => 'Chụp mới';

  @override
  String get capture_new_picture => 'Chụp ảnh';

  @override
  String get choose_from_gallery => 'Chọn từ thư viện ảnh';

  @override
  String get image_upload_queued =>
      'Ảnh sẽ được tải lên trong nền trong thời gian sớm nhất.';

  @override
  String get add_price_queued =>
      'The price will be sent to the server as soon as possible.';

  @override
  String get background_task_title_full_refresh =>
      'Starting the refresh of all the products locally stored';

  @override
  String get background_task_title_top_n =>
      'Starting the download of the most popular products';

  @override
  String get expand_nutrition_facts => 'Mở rộng bảng thông tin dinh dưỡng';

  @override
  String get expand_nutrition_facts_body =>
      'Giữ bảng thông tin dinh dưỡng mở rộng';

  @override
  String get expand_ingredients => 'Mở rộng thành phần';

  @override
  String get expand_ingredients_body => 'Giữ bảng thành phần mở rộng';

  @override
  String get no_internet_connection => 'Không có kết nối mạng';

  @override
  String get world_results_label => 'Toàn cầu';

  @override
  String get world_results_action => 'Mở rộng tìm kiếm toàn cầu';

  @override
  String get copy_to_clipboard => 'Copy';

  @override
  String get paste_from_clipboard => 'Paste from clipboard';

  @override
  String get no_data_available_in_clipboard =>
      'No data available in your clipboard';

  @override
  String get clipboard_barcode_copy => 'Sao chép mã vạch vào khay nhớ tạm';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Mã vạch $barcode đã được sao chép vào khay nhớ tạm!';
  }

  @override
  String get open_product_website => 'Open this product on the website';

  @override
  String get language_picker_label => 'Your language';

  @override
  String get country_picker_label => 'Your country';

  @override
  String get currency_picker_label => 'Your currency';

  @override
  String get help_with_openfoodfacts => 'Trợ giúp với OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Sản phẩm sẽ được cập nhật trong nền trong thời gian sớm nhất.';

  @override
  String get no_email_client_available_dialog_title =>
      'Không có ứng dụng email!';

  @override
  String get no_email_client_available_dialog_content =>
      'Please send us manually an email to mobile@openfoodfacts.org';

  @override
  String get all_images => 'Tất cả Hình ảnh';

  @override
  String get selected_images => 'Hình ảnh được chọn';

  @override
  String get product_card_remove_product_tooltip => 'Gỡ bỏ sản phẩm';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'New barcode scanned: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Xóa tất cả sản phẩm khỏi băng chuyền';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Vui lòng quét ít nhất hai sản phẩm để thực hiện so sánh';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Nhấp để so sánh các sản phẩm bạn đã quét';

  @override
  String get scan_product_loading => 'You have scanned\nthe barcode:';

  @override
  String get scan_product_loading_initial =>
      'We\'re looking for this product!\nPlease wait a few seconds…';

  @override
  String get scan_product_loading_long_request =>
      'We\'re still looking for this product!\nDo you find it takes a long time to load? So are we…';

  @override
  String get scan_product_loading_unresponsive =>
      'We\'re still looking for this product.\nWould you like to restart the search?';

  @override
  String get scan_product_loading_restart_button => 'Restart search';

  @override
  String get portion_calculator_description =>
      'Tính toán thông tin dĩnh dưỡng cho một khối lượng nhất định';

  @override
  String get portion_calculator_hint => 'Quantity in';

  @override
  String get portion_calculator_accessibility =>
      'Input a quantity to calculate nutrition facts';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Please enter a quantity between $min and $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Missing data. Calculation could not be performed.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Thông tin dinh dưỡng cho $grams g (hoặc ml)';
  }

  @override
  String get offline_data => 'Dữ liệu ngoại tuyến';

  @override
  String get ocr_image_upload_instruction =>
      'Tải lên một hình ảnh để tự động trích xuất thông tin chứa trong đó.';

  @override
  String get upload_image => 'Tải ảnh lên';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Tải hình ảnh thất bại';

  @override
  String get image_edit_url_error =>
      'Không thể chỉnh sửa hình ảnh vì URL hình ảnh chưa được đặt.';

  @override
  String get user_picture_source_remember => 'Nhớ lựa chọn của tôi';

  @override
  String get user_picture_source_ask => 'Ask each time';

  @override
  String get robotoff_continue => 'Tiếp tục';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count câu hỏi',
      one: 'câu hỏi',
    );
    return '$_temp0 kế tiếp';
  }

  @override
  String get show_password => 'Hiện mật khẩu';

  @override
  String get owner_field_info_title => 'Producer provided values';

  @override
  String get owner_field_info_message =>
      'With that logo we highlight data provided by the producer, and that may not be editable.';

  @override
  String get owner_field_info_close_button => 'Close this info';

  @override
  String get owner_field_image =>
      'This image is provided by the producer. It may not be editable.';

  @override
  String get edit_packagings_title => 'Thành phần bao bì';

  @override
  String get edit_packagings_element_add => 'Thêm thành phần bao bì';

  @override
  String get edit_packagings_completed => 'Bao bì đã hoàn thành';

  @override
  String edit_packagings_element_title(int index) {
    return 'Thành phần bao bì #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Number of units';

  @override
  String get edit_packagings_element_hint_units =>
      'Nhập số lượng đơn vị đóng gói có cùng hình dạng và chất liệu chứa trong sản phẩm.';

  @override
  String get edit_packagings_element_field_shape => 'Hình dạng';

  @override
  String get edit_packagings_element_hint_shape =>
      'Nhập tên hình dạng được liệt kê trong hướng dẫn tái chế nếu chúng có sẵn, hoặc chọn một hình dạng.';

  @override
  String get edit_packagings_element_example_shape => 'Chai';

  @override
  String get edit_packagings_element_field_material => 'Chất liệu';

  @override
  String get edit_packagings_element_hint_material =>
      'Nhập vật liệu cụ thể nếu có thể xác định được (mã vật liệu bên trong hình tam giác thường có trên các bộ phận đóng gói) hoặc một loại vật liệu chung (ví dụ: nhựa hoặc kim loại) nếu bạn không chắc chắn.';

  @override
  String get edit_packagings_element_example_material => 'Thủy tinh';

  @override
  String get edit_packagings_element_field_recycling => 'Hướng dẫn tái chế';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Chỉ nhập hướng dẫn tái chế nếu chúng được liệt kê trên sản phẩm.';

  @override
  String get edit_packagings_element_example_recycling => 'Tái chế';

  @override
  String get edit_packagings_element_field_quantity =>
      'Số lượng tịnh của sản phẩm trên một đơn vị';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Nhập khối lượng tịnh hoặc thể tích tịnh và cho biết đơn vị (ví dụ g hoặc ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Trọng lượng của một đơn vị rỗng (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Loại bỏ bất kỳ thực phẩm thừa sau đó rửa sạch và lau khô bộ phận đóng gói trước khi cân. Nếu có thể, hãy sử dụng cân có độ chính xác đến 0,1g hoặc 0,01g.';

  @override
  String get background_task_title => 'Đóng góp đang chờ xử lý';

  @override
  String get background_task_subtitle =>
      'Đóng góp của bạn được lưu tự động vào máy chủ của chúng tôi, nhưng không phải lúc nào cũng theo thời gian thực.';

  @override
  String get background_task_list_empty => 'Không có tác vụ nền đang chờ xử lý';

  @override
  String get background_task_error_server_time_out => 'Server timeout';

  @override
  String get background_task_error_no_internet =>
      'Lỗi kết nối Internet. Thử lại sau.';

  @override
  String get background_task_operation_unknown =>
      'loại hoạt động không xác định';

  @override
  String get background_task_operation_details => 'thay đổi chi tiết';

  @override
  String get background_task_operation_image => 'tải ảnh lên';

  @override
  String get background_task_operation_refresh =>
      'làm mới bị trì hoãn sau khi tải ảnh lên';

  @override
  String get background_task_run_started => 'đã bắt đầu';

  @override
  String get background_task_run_not_started => 'chưa bắt đầu';

  @override
  String get background_task_run_to_be_deleted => 'bị xóa';

  @override
  String get background_task_question_stop =>
      'Bạn có muốn dừng nhiệm vụ đó sớm không?';

  @override
  String get feed_back => 'Feedback';

  @override
  String get undo => 'Hoàn tác';

  @override
  String get copy_email_to_clip_board => 'Sao chép email vào khay nhớ tạm';

  @override
  String get please_send_us_an_email_to =>
      'Vui lòng gửi cho email cho chúng tôi đến địa chỉ';

  @override
  String get email_copied_to_clip_board => 'Email được sao chép vào clipboard!';

  @override
  String get select_accent_color => 'Chọn màu chủ đề';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Xanh dương';

  @override
  String get color_cyan => 'Lục lam';

  @override
  String get color_green => 'Xanh lá cây';

  @override
  String get color_light_brown => 'Mặc định';

  @override
  String get color_magenta => 'Đỏ tươi';

  @override
  String get color_orange => 'Cam';

  @override
  String get color_pink => 'Hồng';

  @override
  String get color_red => 'Đỏ';

  @override
  String get color_rust => 'Rỉ sắt';

  @override
  String get color_teal => 'Xanh mòng két';

  @override
  String get text_contrast_mode => 'Tương phản văn bản';

  @override
  String get contrast_high => 'Cao';

  @override
  String get contrast_medium => 'Trung bình';

  @override
  String get contrast_low => 'Thấp';

  @override
  String get product_refresher_internet_not_found => 'Không tìm thấy sản phẩm!';

  @override
  String get product_refresher_internet_not_connected =>
      'You are not connected to internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server down ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Server error ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Không tìm thấy sản phẩm!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Sản phẩm có vạch mã sau không tồn tại trong cơ sở dữ liệu của chúng tôi: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Không có kết nối mạng!';

  @override
  String get product_loader_network_error_message =>
      'Vui lòng kiểm tra kết nối Wifi hoặc di động trên thiết bị di động của bạn';

  @override
  String get page_not_found_title => 'Không tìm thấy trang!';

  @override
  String get page_not_found_button => 'Trở về trang chủ';

  @override
  String get download_data => 'Tải dữ liệu';

  @override
  String get download_top_products =>
      'Tải xuống 1000 sản phẩm hàng đầu ở quốc gia của bạn để quét ngay lập tức';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
    );
    return 'Download the top $_temp0 in your country for instant scanning';
  }

  @override
  String get download_in_progress =>
      'Đang tải xuống dữ liệu\nQuá trình này có thể mất một chút thời gian';

  @override
  String downloaded_products(int num) {
    return 'Đã thêm $num sản phẩm';
  }

  @override
  String get update_offline_data => 'Cập nhật dữ liệu sản phẩm ngoại tuyến';

  @override
  String get update_local_database_sub =>
      'Update the local product database with the latest data from Open Food Facts';

  @override
  String get clear_local_database => 'Xóa dữ liệu sản phẩm ngoại tuyến';

  @override
  String get clear_local_database_sub =>
      'Xóa tất cả dữ liệu sản phẩm tại phương khỏi ứng dụng của bạn để giải phóng dung lượng';

  @override
  String deleted_products(int num) {
    return 'Đã xóa $num sản phẩm';
  }

  @override
  String get loading => 'Loading…';

  @override
  String get know_more => 'Tìm hiểu thêm';

  @override
  String get offline_data_desc => 'Nhấp để biết thêm về dữ liệu ngoại tuyến';

  @override
  String get offline_product_data_title => 'Dữ liệu sản phẩm ngoại tuyến';

  @override
  String available_for_download(int num) {
    return '$num sản phẩm có sẵn để quét ngay lập tức';
  }

  @override
  String get country_selector_title => 'Select your country:';

  @override
  String get currency_selector_title => 'Select your currency:';

  @override
  String get language_selector_title => 'Select your language:';

  @override
  String get language_selector_section_selected => 'Selected languages';

  @override
  String get language_selector_section_frequently_used => 'Frequently used';

  @override
  String get action_delete_list => 'Xóa';

  @override
  String get action_change_list => 'Change the current list';

  @override
  String get product_list_create => 'Tạo';

  @override
  String get product_list_create_tooltip => 'Tạo danh sách mới';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (New calculation)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (New calculation)';

  @override
  String get nutriscore_unknown => 'Unknown Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Unknown Nutri-Score (New calculation)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score is not applicable (New calculation)';

  @override
  String get environmental_score_generic_new => 'Điểm sinh thái';

  @override
  String get environmental_score_a_new => 'Điểm xanh A';

  @override
  String get environmental_score_b_new => 'Điểm xanh B';

  @override
  String get environmental_score_c_new => 'Điểm xanh C';

  @override
  String get environmental_score_d_new => 'Điểm xanh lá cây D';

  @override
  String get environmental_score_e_new => 'Điểm xanh E';

  @override
  String get environmental_score_unknown_new => 'Điểm xanh không xác định';

  @override
  String get environmental_score_not_applicable_new =>
      'Điểm xanh không áp dụng';

  @override
  String get nova_group_generic_new =>
      'Thực phẩm siêu chế biến - Tập đoàn NOVA';

  @override
  String get nova_group_1 => 'NOVA Group 1';

  @override
  String get nova_group_2 => 'NOVA Group 2';

  @override
  String get nova_group_3 => 'NOVA Group 3';

  @override
  String get nova_group_4 => 'NOVA Group 4';

  @override
  String get nova_group_unknown => 'Unknown NOVA Group';

  @override
  String get nutrition_facts => 'Nutrient Levels';

  @override
  String get faq_title_partners => 'Partners & Patrons of the NGO';

  @override
  String get faq_title_vision =>
      'The Open Food Facts Vision, Mission, Values and Programs';

  @override
  String get faq_title_install_beauty =>
      'Install Open Beauty Facts to create a cosmetic database';

  @override
  String get faq_title_install_pet =>
      'Install Open Pet Food Facts to create a pet food database';

  @override
  String get faq_title_install_product =>
      'Install Open Products Facts to create a products database to extend the life of objects';

  @override
  String get faq_nutriscore_nutriscore =>
      'New calculation of the Nutri-Score: what\'s new?';

  @override
  String get contact_title_pro_page =>
      'Pro? Import your products in Open Food Facts';

  @override
  String get contact_title_pro_email => 'Producer Contact';

  @override
  String get contact_title_press_page => 'Press Page';

  @override
  String get contact_title_press_email => 'Press Contact';

  @override
  String get contact_title_newsletter => 'Đăng ký nhận Bản tin';

  @override
  String get contact_title_calendar => 'Subscribe to our community calendar';

  @override
  String get hunger_games_loading_line1 => 'Please give us a few seconds…';

  @override
  String get hunger_games_loading_line2 => 'We\'re downloading the questions!';

  @override
  String get hunger_games_error_label =>
      'Argh! Something went wrong… and we couldn\'t load the questions.';

  @override
  String get hunger_games_error_retry_button => 'Let\'s retry!';

  @override
  String get reorder_attribute_action => 'Reorder the attributes';

  @override
  String get link_cant_be_opened =>
      'This link can\'t be opened on your device. Please check that you have a browser installed.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Details for $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Details for $pageName with $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Chia sẻ';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Where to find the new Nutri-Score calculation?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'The Nutri-Score is applied in 7 countries: France, Germany, Belgium, Spain, Luxembourg, the Netherlands and Switzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Manufacturers have at most **2 years** at the latest after the signature of the decree **to replace** the old calculation with the new one.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Điểm sinh thái';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'Điểm xanh là gì?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score là một logo có mục đích cung cấp thông tin cho bạn về **tác động của thực phẩm đến môi trường**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Mã màu thay đổi từ màu xanh lá cây đậm (**A+**) cho các sản phẩm **ít tác động nhất** đến màu đỏ đậm (**F**) cho các sản phẩm **có tác động lớn nhất**.';

  @override
  String get guide_greenscore_logos_caption => 'Logo Green-Score';

  @override
  String get guide_greenscore_lca_title => 'Cốt lõi: Đánh giá vòng đời (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Đánh giá khoa học về các loại thực phẩm';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Đối với mỗi danh mục sản phẩm, điểm chuẩn **được thiết lập bằng cách sử dụng dữ liệu từ cơ sở dữ liệu môi trường Agribalyse (do ADEME và INRAE thiết kế).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Phân tích vòng đời** là phương pháp đánh giá chuẩn hóa để thực hiện đánh giá môi trường nhiều giai đoạn và nhiều tiêu chí.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Nó đo:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 bước sản xuất';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Nông nghiệp';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Đang xử lý';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Bao bì';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Vận chuyển';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Phân phối';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Tiêu thụ';

  @override
  String get guide_greenscore_lca_arg3_title => '14 chỉ số tác động môi trường';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Biến đổi khí hậu/dấu chân carbon';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Sự suy giảm tầng ôzôn';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Bức xạ ion hóa';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Đất';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Sử dụng nước và năng lượng';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Ô nhiễm không khí';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Nước biển và nước ngọt (các hạt, axit hóa, phú dưỡng)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Sự cạn kiệt tài nguyên.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Tiền thưởng và tiền phạt';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Phương thức sản xuất';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Nguồn gốc của các thành phần';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Những loài có nguy có bị tuyệt chủng';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Bao bì';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Nhu cầu về sự minh bạch ngày càng tăng để có thể đo lường tốt hơn và giảm tác động môi trường';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Các nhà sản xuất có thể giúp đỡ như thế nào';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Các nhà sản xuất có thể gửi thông tin trực tiếp cho chúng tôi thông qua nền tảng miễn phí dành cho nhà sản xuất.';

  @override
  String get guide_greenscore_better_product_title =>
      'Sản phẩm nào tốt hơn cho hành tinh?';

  @override
  String get guide_greenscore_better_product_arg1_title => 'Có thể khó để nói';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Lựa chọn thực phẩm bền vững là một trong những điều mạnh mẽ nhất mà chúng ta có thể làm cho khí hậu, vì **hệ thống thực phẩm toàn cầu của chúng ta chịu trách nhiệm cho hơn một phần tư lượng khí thải nhà kính**.\n(Nguồn: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Bạn có sức mạnh!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Tin tốt là điều này mang đến cho chúng ta một cách thức mạnh mẽ để tạo ra sự thay đổi.\n**Mỗi người chúng ta ăn khoảng 1.000 bữa ăn mỗi năm**. Đó là 1.000 cơ hội để **chọn một tương lai tốt đẹp hơn cho hành tinh**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Giúp có trách nhiệm và quyết định';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Việc lựa chọn thực phẩm bền vững có thể khá phức tạp. Nhãn mác dễ gây nhầm lẫn và thông tin thường bị thiếu. Điểm Xanh được tạo ra để đơn giản hóa việc này, cung cấp cho bạn xếp hạng môi trường **rõ ràng**, **dựa trên khoa học** và **minh bạch** cho các sản phẩm thực phẩm, ngay tại nơi bạn cần: khi bạn mua sắm.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Tính minh bạch';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Không giống như các nhãn hiệu độc quyền, phép tính Điểm Xanh **hoàn toàn mở** và có thể được **xác minh bởi bất kỳ ai**.';

  @override
  String get guide_nova_title => 'Thức ăn siêu chế biến';

  @override
  String get guide_nova_what_is_nova_title => 'Siêu xử lý là gì?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'The NOVA groups inform you about **the level of food processing**.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Phân loại NOVA cho phép phân loại thực phẩm thành **4 nhóm** dựa trên **mức độ chế biến công nghiệp** (thực phẩm chế biến tối thiểu hoặc chưa chế biến, nguyên liệu nấu ăn, thực phẩm chế biến, thực phẩm siêu chế biến).';

  @override
  String get guide_nova_logos_caption => 'Các logo NOVA';

  @override
  String get guide_nova_groups_title => '4 nhóm NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Có 4 nhóm NOVA, nhóm có vấn đề là Nhóm 4 - Thực phẩm siêu chế biến.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Thực phẩm chế biến tối thiểu hoặc chưa chế biến';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Các thành phần ẩm thực đã qua chế biến';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from Group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Thực phẩm đã qua chế biến';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to Group 1** foods. Processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. Most processed foods have two or three ingredients and are recognizable as modified versions of Group 1 foods. They can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Thức ăn siêu chế biến';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact Group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. However, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. Some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Các vấn đề với quá trình xử lý siêu việt';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Xử lý cực độ các thành phần thực phẩm';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Phụ gia vượt xa tiêu chuẩn an toàn thực phẩm thuần túy';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Xử lý bạn không thể làm ở nhà';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Các khía cạnh săn mồi và tài chính của quá trình siêu chế biến';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-vi.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-vi.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-vi.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-vi.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-vi.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Preview';

  @override
  String get prices_feedback_form =>
      'Click here to send us your feedback about this new feature!';

  @override
  String get menu_button_list_actions => 'Select an action';

  @override
  String get error_loading_photo => 'Error loading photo';

  @override
  String get photo_viewer_action_use_picture_as => 'Use as…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Use this picture as…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Use this picture as… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Details';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Details of this photo';

  @override
  String get photo_viewer_details_title => 'Details of the photo';

  @override
  String get photo_viewer_details_contributor_title => 'Người đóng góp';

  @override
  String get photo_viewer_details_size_title => 'Size';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Date';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatible';

  @override
  String get user_lists_action_multi_select => 'Multi-select';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Your compatibility score: $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'Hình ảnh của mặt trước';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Hình ảnh trong danh sách các thành phần';

  @override
  String get product_image_nutrition_accessibility_label => 'Nutrition picture';

  @override
  String get product_image_packaging_accessibility_label => 'Packaging picture';

  @override
  String get product_image_other_accessibility_label => 'Other picture';

  @override
  String get product_image_outdated_message => 'This picture may be outdated';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (this image may be outdated)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (this image may be locked by the producer)';
  }

  @override
  String get product_image_error => 'Unable to load the image!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Unable to load the $type (network error?)';
  }

  @override
  String get product_page_image_no_image_available => 'No\nimage!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'No picture available for this product';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reorder or hide actions';

  @override
  String get product_page_action_bar_setting_modal_title => 'Edit actions';

  @override
  String get product_page_action_bar_item_move_up => 'Move up';

  @override
  String get product_page_action_bar_item_move_down => 'Move down';

  @override
  String get product_page_action_bar_item_enable => 'Enable action';

  @override
  String get product_page_action_bar_item_disable => 'Disable action';

  @override
  String get product_page_pending_operations_banner_title =>
      'Uploading your edits…';

  @override
  String get product_page_pending_operations_banner_message =>
      'The data displayed on this page **does not yet reflect your modifications**.\nPlease wait a few seconds…';

  @override
  String get product_add_a_language => 'Add a language';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Barcode $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Remove this product from the carousel';

  @override
  String get carousel_unsupported_header => 'Unsupported barcode!';

  @override
  String get carousel_unsupported_title => 'Ooops!';

  @override
  String get carousel_unsupported_text =>
      'The barcode scanned is not supported by Open Food Facts!';

  @override
  String get carousel_error_header => 'Error!';

  @override
  String get carousel_error_title => 'It\'s a bummer!';

  @override
  String get carousel_error_text_1 =>
      'We couldn\'t download information on this barcode:';

  @override
  String get carousel_error_text_2 =>
      'Please check your Internet connection or click this button:';

  @override
  String get carousel_error_button => 'Thử lại';

  @override
  String get carousel_unknown_product_header => 'Unknown product';

  @override
  String get carousel_unknown_product_title =>
      'Congratulations!\nYou\'ve found __the rare gem!__';

  @override
  String get carousel_unknown_product_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get carousel_unknown_product_button => 'Thêm sản phẩm này';

  @override
  String get carousel_loading_header => 'Loading information...';

  @override
  String get carousel_loading_title =>
      'You\'ve just scanned a product with the following barcode:';

  @override
  String get carousel_loading_text =>
      'We are searching for it in our database of more than **3 million products!**';

  @override
  String get product_type_subtitle_food => 'Vegetables, fruits, frozen food…';

  @override
  String get product_type_subtitle_beauty => 'Makeup, soaps, toothpastes…';

  @override
  String get product_type_subtitle_pet_food => 'Food for dogs, cats…';

  @override
  String get product_type_subtitle_product => 'Smartphones, furniture…';

  @override
  String get photo_field_front => 'Product photo';

  @override
  String get photo_field_ingredients => 'Ảnh chụp thành phần';

  @override
  String get photo_field_nutrition => 'Nutrition photo';

  @override
  String get photo_field_packaging => 'Ảnh chụp thông tin bao bì';

  @override
  String get photo_already_exists => 'This photo already exists';

  @override
  String get photo_missing => 'This photo is missing';

  @override
  String get date => 'Date';

  @override
  String get photo_rotate_left => 'Xoay trái';

  @override
  String get photo_rotate_right => 'Xoay phải';

  @override
  String get photo_undo_action => 'Undo the previous action';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'A world map of $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap contributors';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Cảnh báo';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Why is this Nutri-Score different from the one on the package?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'There are two possible explanations:\nThe list of ingredients and/or nutrition facts are not up-to-date.\n\nWe provide the \"New calculation\" of the Nutri-Score (or V2). Please check that you have the banner \"New calculation\" on the package.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Check ingredients';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Check nutrition facts';

  @override
  String url_not_supported(String url) {
    return 'Unfortunately, we can\'t open the URL:\n$url';
  }

  @override
  String get product_list_export => 'Export';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'View barcode';

  @override
  String get product_footer_action_barcode_short => 'Mã vạch';

  @override
  String get product_footer_action_open_website => 'Open website';

  @override
  String get product_footer_action_report => 'Report';

  @override
  String get product_footer_action_contributor_guide => 'Help';

  @override
  String get product_footer_action_data_quality_tags => 'Data quality';

  @override
  String get product_page_tab_for_me => 'Đối với tôi';

  @override
  String get product_page_tab_website => 'Website';

  @override
  String get product_page_tab_prices => 'Prices';

  @override
  String get prices_explanation_card_title => 'Tại sao lại có giá?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** là một dự án thu thập và chia sẻ giá sản phẩm trên toàn thế giới 🌍. Open Prices được phát triển và duy trì bởi Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Tìm hiểu thêm';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Thuộc tính Folksonomy là gì?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Thuộc tính dựa trên **khóa-giá trị**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Những thuộc tính này được tạo ra và lưu trữ bởi những người đóng góp cho mọi mục đích sử dụng.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Không có giá nào có sẵn';

  @override
  String get prices_products_empty_explanation =>
      'Hãy là người đầu tiên đóng góp!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize products (total: $total)';
  }

  @override
  String get app_review_title => 'Are you enjoying this app?';

  @override
  String get app_review_low => 'Could do better';

  @override
  String get app_review_medium => 'Not bad';

  @override
  String get app_review_high => 'I love it!';

  @override
  String get app_review_feedback_modal_title =>
      'Help us improve our application';

  @override
  String get app_review_feedback_modal_content =>
      'If you have a few minutes, could you answer this form so that **we can improve in future updates**:';

  @override
  String get app_review_feedback_modal_open_form => 'Answer the form';

  @override
  String get app_review_feedback_modal_later => 'Ask me later';

  @override
  String get nutrition_facts_extract_new =>
      'NEW: You can automatically extract the nutrients from the picture!';

  @override
  String get nutrition_facts_extract_button_text => 'Extract now';

  @override
  String get nutrition_facts_extract_in_progress => 'Đang trích xuất…';

  @override
  String get nutrition_facts_extract_successful => 'Trích xuất thành công';

  @override
  String get nutrition_facts_extract_failed =>
      'Failed to extract nutrients from picture';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistics';

  @override
  String get prices_stats_title => 'Prices Statistics';

  @override
  String get prices_stats_prices_section => 'Prices';

  @override
  String get prices_stats_products_section => 'Sản phẩm';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Người đóng góp';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Các tùy chọn khác';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Tiêu thụ';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Food';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Sản phẩm';

  @override
  String get prices_stats_pet_food => 'Pet food';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Quốc gia';

  @override
  String get prices_stats_price_tag => 'Price tag';

  @override
  String get prices_stats_receipt => 'Receipt';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Website';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Khác';

  @override
  String get prices_stats_last_updated => 'Last updated on';

  @override
  String get prices_stats_error =>
      'An error occurred while loading statistics.';

  @override
  String get product_edit_robotoff_question_answered => 'Question answered!';

  @override
  String get product_edit_robotoff_proof => 'Proof';

  @override
  String get preferences_card_general => 'Chung';

  @override
  String get preferences_prices_title => 'Prices';

  @override
  String get preferences_prices_subtitle => 'Quản lý tùy chọn giá của bạn';

  @override
  String get preferences_card_project => 'Dự án Open Food Facts';

  @override
  String get preferences_contribute_title => 'Góp phần';

  @override
  String get preferences_my_contributions_title => 'Đóng góp của tôi';

  @override
  String get preferences_my_stats_title => 'Thống kê của tôi';

  @override
  String get preferences_contribute_subtitle =>
      'Dịch, cải thiện công cụ của chúng tôi…';

  @override
  String get preferences_connect_title => 'Kết nối';

  @override
  String get preferences_connect_subtitle =>
      'Liên hệ hoặc theo dõi chúng tôi trên mạng xã hội';

  @override
  String get preferences_support_title => 'Quyên góp';

  @override
  String get preferences_support_subtitle =>
      'Hãy giúp chúng tôi thông tin đến hàng triệu người tiêu dùng trên toàn thế giới';

  @override
  String get preferences_card_help => 'Trợ giúp & Hỗ trợ';

  @override
  String get preferences_faq_title => 'FAQ';

  @override
  String get preferences_faq_subtitle => 'Nhận câu trả lời cho câu hỏi của bạn';

  @override
  String get logged_out => 'Đã đăng xuất';

  @override
  String get preferences_app_bar_message =>
      'Cảm ơn bạn đã là thành viên của chúng tôi!';

  @override
  String get preferences_app_bar_products_modified =>
      'Các sản phẩm đã được sửa đổi';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Xem tất cả số liệu thống kê';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Tìm kiếm $provider cho \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Tìm kiếm cài đặt (ví dụ: Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Khả năng truy cập: Hiển thị biểu tượng cảm xúc';

  @override
  String get preferences_accessibility_remove_colors =>
      'Khả năng truy cập: Xóa màu';

  @override
  String get preferences_app_settings_products => 'Sản phẩm';

  @override
  String get preferences_card_about => 'Giới thiệu';

  @override
  String get preferences_legal_information_title => 'Thông tin pháp lý';

  @override
  String get preferences_legal_information_subtitle =>
      'Điều khoản sử dụng, chính sách bảo mật và nhiều hơn nữa';

  @override
  String get preferences_terms_of_use => 'Điều khoản sử dụng';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts là cơ sở dữ liệu về sản phẩm thực phẩm **do mọi người tạo ra, dành cho mọi người**.\nBạn có thể sử dụng cơ sở dữ liệu này để đưa ra những lựa chọn thực phẩm tốt hơn và vì đây là **dữ liệu mở** nên bất kỳ ai cũng có thể **tái sử dụng cho bất kỳ mục đích nào**.';

  @override
  String get preferences_privacy_policy => 'Privacy policy';

  @override
  String get preferences_licenses => 'Giấy phép';

  @override
  String get preferences_about_app_title => 'Giới thiệu về ứng dụng';

  @override
  String get preferences_about_app_subtitle =>
      'Thông tin kỹ thuật, thông tin dành cho nhà phát triển và nhiều thông tin khác';

  @override
  String get preferences_card_information => 'Thông tin';

  @override
  String get preferences_version_number_title => 'Số phiên bản';

  @override
  String get preferences_scanner_title => 'Máy quét';

  @override
  String get preferences_app_store => 'Cửa hàng ứng dụng';

  @override
  String get preferences_app_system_settings => 'Cài đặt hệ thống';

  @override
  String get preferences_source_code => 'Truy cập mã nguồn';

  @override
  String get preferences_source_code_subtitle =>
      'Và bắt đầu tạo ra tác động cho hàng triệu người';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Nói với toàn thế giới';

  @override
  String get preferences_tips => 'Mẹo';

  @override
  String get tips_discover_nutriscore => 'Khám phá Nutri-Score mới';

  @override
  String get preferences_on_off_website_subtitle =>
      'Trên trang web Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Quản lý tài khoản của tôi';

  @override
  String get preferences_manage_account_tooltip => 'Quản lý tài khoản của bạn';

  @override
  String get preferences_change_password_title => 'Thay đổi mật khẩu của tôi';

  @override
  String get preferences_danger_zone => 'Khu vực nguy hiểm';

  @override
  String get preferences_account_deletion_subtitle =>
      'Mọi đóng góp của bạn sẽ bị mất';

  @override
  String get preferences_contributions_title => 'Đóng góp';

  @override
  String get preferences_dev_mode_app_settings_title => 'Cài đặt ứng dụng';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Cách thử nghiệm để quét sản phẩm ngoại tuyến';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Làm mới tất cả sản phẩm từ máy chủ';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Xin vui lòng tránh làm điều đó trừ khi thực sự cần thiết';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Chế độ demo';

  @override
  String get preferences_dev_mode_add_cards_title => 'Thêm thẻ vào máy quét';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Thêm 3 sản phẩm mẫu vào máy quét';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Người dẫn chương trình Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Máy chủ: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Thí nghiệm về khả năng tiếp cận';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Lựa chọn nhiều sản phẩm cho giá cả';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Bảng kiến thức do người dùng đặt hàng';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Truy cập tạm thời vào tìm kiếm vị trí';

  @override
  String get preferences_dev_mode_comparison_title =>
      'So sánh cạnh nhau cho 2 hoặc 3 sản phẩm';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Nhập danh sách sản phẩm';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Điểm số và phương pháp luận';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Khám phá cách tính điểm Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Khám phá những thay đổi chính về phương pháp luận';

  @override
  String get preferences_faq_discover_project_title => 'Khám phá những dự án';

  @override
  String get preferences_faq_discover_off_title =>
      'Khám phá sự thật về thực phẩm mở';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Những câu hỏi thường gặp';

  @override
  String get preferences_faq_off_ngo_title =>
      'Tổ chức phi chính phủ Open Food Facts';

  @override
  String get preferences_about_information_title => 'Thông tin';

  @override
  String get preferences_connect_community_updates_title =>
      'Nhận thông tin cập nhật từ cộng đồng';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Cập nhật tin tức về ứng dụng và cộng đồng';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscribe to our community calendar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Tham gia bằng cách tham dự một trong các sự kiện trực tuyến của chúng tôi';

  @override
  String get preferences_connect_blog_title => 'Blog Sự thật về Thực phẩm Mở';

  @override
  String get preferences_connect_blog_subtitle =>
      'Nhận tin tức mới nhất khi chúng xảy ra';

  @override
  String get preferences_connect_community_help_title =>
      'Nhận sự giúp đỡ từ cộng đồng';

  @override
  String get preferences_connect_improve_app_title =>
      'Hãy giúp chúng tôi cải thiện ứng dụng';

  @override
  String get preferences_connect_debug_info_title =>
      'Gửi cho chúng tôi thông tin gỡ lỗi';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Gửi cho chúng tôi một email với thông tin gỡ lỗi chi tiết';

  @override
  String get preferences_connect_feedback_title =>
      'Gửi cho chúng tôi phản hồi về ứng dụng';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Giúp định hình tương lai của ứng dụng';

  @override
  String get preferences_connect_survey_title => 'Tham gia khảo sát ứng dụng';

  @override
  String get preferences_connect_survey_subtitle =>
      'Giúp chúng tôi hiểu những gì chúng tôi nên xây dựng tiếp theo';

  @override
  String get preferences_connect_professionals_title => 'Chuyên gia';

  @override
  String get preferences_connect_pro_subtitle =>
      'Hoàn toàn miễn phí, đảm bảo dữ liệu chính xác cho 500 ứng dụng và hàng triệu người dùng. Tự phục vụ, tương thích với PIM hoặc bảng tính (XLSX) của bạn';

  @override
  String get preferences_connect_pro_email_subtitle => 'Liên hệ để bắt đầu';

  @override
  String get preferences_connect_press_title => 'Báo chí';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Nhận tất cả tài liệu bạn cần cho báo cáo của mình';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Liên hệ để được báo chí hỏi thăm hoặc cho chúng tôi biết về báo cáo của bạn';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Trở thành một tình nguyện viên tích cực';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Phát triển, Truyền thông, Thiết kế… mọi hình thức tình nguyện hoặc chuyên môn đều được hoan nghênh!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Khám phá một số cách bạn có thể đóng góp';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Phát triển ứng dụng di động';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Tìm hiểu cách đóng góp vào quá trình phát triển phần mềm';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Bản dựng không ổn định hàng ngày, các tính năng hoàn toàn mới';

  @override
  String get preferences_contribute_local_community_title =>
      'Phát triển cộng đồng địa phương của bạn';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Hỗ trợ dịch thuật phần mềm, nội dung, phân tích thành phần';

  @override
  String get preferences_contribute_share_subtitle =>
      'Chúng tôi đã chuẩn bị một mẫu nhỏ để giúp bạn :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Các bước đơn giản để tăng cường tính minh bạch về thực phẩm ở quốc gia của bạn';

  @override
  String get preferences_contribute_data_quality_title => 'Data quality';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Tham gia nhóm chất lượng dữ liệu';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Hãy tham gia cùng chúng tôi để đảm bảo cơ sở dữ liệu được hoàn thiện và chính xác';

  @override
  String get preferences_contributions_products_added_title =>
      'Sản phẩm đã thêm';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Sản phẩm mới tôi đã thêm vào Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Sản phẩm tôi cần hoàn thành';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Tất cả các sản phẩm chưa hoàn thành';

  @override
  String get preferences_my_contributions_prices_title => 'Prices';

  @override
  String get preferences_my_contributions_my_prices_title => 'My prices';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Giá của tôi, bằng chứng của tôi…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Sản phẩm bạn có thể giúp hoàn thành';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Giúp tính toán Điểm Nutri-Score & Điểm Green-Score ở quốc gia của bạn';

  @override
  String get preferences_prices_user_prices_subtitle => 'Giá tôi đã đóng góp';

  @override
  String get preferences_prices_proofs_subtitle => 'Thẻ giá và biên lai';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Chụp ảnh biên lai của bạn và quét mã vạch liên quan';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Chụp ảnh giá cả trong cửa hàng';

  @override
  String get preferences_prices_newest_title => 'Giá mới nhất';

  @override
  String get preferences_prices_newest_subtitle =>
      'Giá mới nhất được cộng đồng Open Prices thêm vào';

  @override
  String get preferences_prices_top_contributors_title =>
      'Những người đóng góp nhiều giá nhất';

  @override
  String get preferences_prices_metrics_title => 'Số liệu giá mở';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Theo dõi sự phát triển của dự án';

  @override
  String get preferences_prices_ways_contribute_title => 'Các cách đóng góp';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Xác nhận giá do bạn hoặc người khác thêm vào, với sự trợ giúp của AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Nhanh chóng thêm nhiều biên lai hoặc ảnh kệ từ cuộn camera của bạn';

  @override
  String get preferences_prices_challenges_title => 'Thử thách hàng tháng';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Tham gia các nhiệm vụ theo chủ đề hàng tháng để thu thập giá';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Lấy lại dữ liệu lòng trung thành của bạn';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Tìm hiểu cách yêu cầu dữ liệu của bạn';

  @override
  String get preferences_page_customize_app_title => 'Tùy chỉnh ứng dụng';

  @override
  String get preferences_page_contribute_project_title => 'Đóng góp cho dự án';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Những cách đơn giản để giúp Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Phương pháp tính điểm, trợ giúp và nhiều thông tin khác về dự án';

  @override
  String get product_edit_robotoff_positive_button => 'Chấp nhận đề xuất';

  @override
  String get product_edit_robotoff_negative_button => 'Từ chối đề xuất';

  @override
  String get product_edit_robotoff_show_proof => 'Hiển thị bằng chứng';

  @override
  String get product_edit_robotoff_expand_proof => 'Mở rộng bằng chứng';

  @override
  String get product_page_tab_raw_data => 'Dữ liệu thô';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Trang $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Trang $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count trong số $total mục';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count trong số $total mục';
  }

  @override
  String item_count(int count) {
    return '$count mục';
  }

  @override
  String item_count_string(String count) {
    return '$count mục';
  }

  @override
  String get prices_no_result => 'Không tìm thấy số liệu thống kê giá.';

  @override
  String get prices_error_loading_more_items => 'Lỗi khi tải thêm mục';

  @override
  String get prices_proof_error =>
      'Xác thực không thành công, không thể lấy bằng chứng';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count trong số $total bản chứng minh';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count trong số $total người đóng góp';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count trong số $total địa điểm';
  }

  @override
  String prices_locations_count(int count) {
    return '$count địa điểm';
  }

  @override
  String get restart_to_apply_message =>
      'Vui lòng khởi động lại ứng dụng để áp dụng những thay đổi.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Giao diện đồ họa';

  @override
  String get preferences_app_settings_media_title => 'Phương tiện truyền thông';

  @override
  String get preferences_about_app_development_title => 'Phát triển';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Phòng thí nghiệm thông tin thực phẩm mở';

  @override
  String get preferences_root_account_title => 'Tài khoản';

  @override
  String get preferences_contribute_translate_header =>
      'Mang Thông tin Thực phẩm Mở sang ngôn ngữ của bạn';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Đăng ký phiên bản alpha của ứng dụng';

  @override
  String get preferences_dev_mode_section_data => 'Đóng góp & Dữ liệu sản phẩm';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Không hiển thị Folksonomy';

  @override
  String get preferences_account_title => 'Tài khoản';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Đã thêm vào $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Tên';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
