// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Evet';

  @override
  String get add => 'Ekle';

  @override
  String get account_delete_message =>
      'Hesabınızı silmek istediğinizden emin misiniz?\nBelirli bir nedeni varsa aşağıda paylaşın';

  @override
  String get reason => 'Sebep';

  @override
  String get okay => 'Tamam';

  @override
  String get validate => 'Geçerlilik';

  @override
  String get create => 'Oluştur';

  @override
  String get applyButtonText => 'Uygula';

  @override
  String get next_label => 'Sonraki';

  @override
  String get continue_label => 'Devam et';

  @override
  String get exit_label => 'Çık';

  @override
  String get previous_label => 'Önceki';

  @override
  String get go_back_to_top => 'Başa dön';

  @override
  String get save => 'Kaydet';

  @override
  String get save_confirmation => 'Kaydetmek istediğinizden emin misiniz?';

  @override
  String get skip => 'Atla';

  @override
  String get cancel => 'İptal';

  @override
  String get ignore => 'Yok say';

  @override
  String get close => 'Kapat';

  @override
  String get no => 'Hayır';

  @override
  String get stop => 'Durdur';

  @override
  String get finish => 'Bitir';

  @override
  String get calculate => 'Hesapla';

  @override
  String get reset_food_prefs => 'Yemek tercihlerini sıfırla';

  @override
  String get error => 'Bir şeyler ters gitti';

  @override
  String get error_occurred => 'Hata oluştu';

  @override
  String get featureInProgress =>
      'Bu özellik üzerinde halâ çalışıyoruz, takipte kal';

  @override
  String get label_web => 'Web\'de görüntüle';

  @override
  String get learnMore => 'Daha fazla bilgi edin';

  @override
  String get unknown => 'Bilinmeyen';

  @override
  String get match_very_good => 'Çok iyi eşleşme';

  @override
  String get match_good => 'İyi eşleşme';

  @override
  String get match_poor => 'Zayıf eşleşme';

  @override
  String get match_may_not => 'Eşleşmeyebilir';

  @override
  String get match_does_not => 'Eşleşmiyor';

  @override
  String get match_unknown => 'Bilinmeyen eşleşme';

  @override
  String get match_short_very_good => 'Çok iyi eşleşme';

  @override
  String get match_short_good => 'İyi eşleşme';

  @override
  String get match_short_poor => 'Zayıf eşleşme';

  @override
  String get match_short_may_not => 'Eşleşmeyebilir';

  @override
  String get match_short_does_not => 'Eşleşmiyor';

  @override
  String get match_short_unknown => 'Bilinmeyen eşleşme';

  @override
  String get licenses => 'Lisanslar';

  @override
  String get looking_for => 'Aranıyor';

  @override
  String get welcomeToOpenFoodFacts => 'Open Food Facts\'e Hoş Geldiniz';

  @override
  String get whatIsOff =>
      'Open Food Facts, yerel topluluklar tarafından desteklenen küresel, kar amacı gütmeyen bir kuruluştur.';

  @override
  String get productDataUtility =>
      'Tercihleriniz ile ilgili gıda verilerine bakın.';

  @override
  String get healthCardUtility => 'Sizin için iyi olan gıdaları seçin.';

  @override
  String get ecoCardUtility => 'Dünya için iyi olan gıdaları seçin.';

  @override
  String get server_error_open_new_issue =>
      'Sunucu yanıtı yok! Aşağıdaki bağlantıdan konu açabilirsiniz.';

  @override
  String get sign_in_text =>
      'Katkılarınızı kaydetmek için Open Food Facts hesabınızda oturum açın';

  @override
  String get incorrect_credentials => 'Hatalı kullanıcı adı veya parola.';

  @override
  String get password_lost_incorrect_credentials =>
      'Bu e-posta veya kullanıcı adı mevcut değil. Lütfen kimlik bilgilerinizi kontrol edin.';

  @override
  String get password_lost_server_unavailable =>
      'Şu anda sunucularımızda yavaşlamalar yaşıyoruz ve bunun için özür dileriz. Lütfen daha sonra tekrar deneyiniz.';

  @override
  String get login => 'Oturumu Başlat';

  @override
  String get login_result_type_server_unreachable => 'Ağa erişilemiyor';

  @override
  String get login_result_type_server_issue =>
      'Sunucuda sorun. Lütfen daha sonra tekrar deneyin.';

  @override
  String get login_page_username_or_email =>
      'Lütfen kullanıcı adı veya e-posta girin';

  @override
  String get login_page_password_error_empty => 'Lütfen bir şifre girin';

  @override
  String get create_account => 'Hesap oluştur';

  @override
  String get sign_in => 'Giriş Yap';

  @override
  String get sign_in_mandatory => 'Bu özellik için oturum açmanız gerekiyor.';

  @override
  String get help_improve_country =>
      'Ülkenizde Open Food Facts\'in iyileştirilmesine yardımcı olun';

  @override
  String get sign_out => 'Çıkış yap';

  @override
  String get sign_out_confirmation =>
      'Oturumu kapatmak istediğinizden emin misiniz?';

  @override
  String get password => 'Şifre';

  @override
  String get forgot_password => 'Parolanızı mı unuttunuz';

  @override
  String get forgot_password_question => 'Parolanızı mı unuttunuz?';

  @override
  String get view_profile => 'Profili görüntüle';

  @override
  String get reset_password => 'Parolayı sıfırla';

  @override
  String get reset_password_explanation_text =>
      'Parolanın unutulması durumunda parola sıfırlama talimatlarını almak için kullanıcı adınızı veya e-posta adresinizi girin. Ayrıca, Spam klasörünü kontrol etmeyi unutmayın.';

  @override
  String get username_or_email => 'Kullanıcı adı veya e-mail';

  @override
  String get reset_password_done =>
      'An e-mail with a link to reset your password has been sent to the e-mail address associated with your account. Also check your spam';

  @override
  String get send_reset_password_mail => 'Parolayı değiştir';

  @override
  String get enter_some_text => 'Lütfen bir metin girin';

  @override
  String get sign_up_page_title => 'Kaydol';

  @override
  String get sign_up_page_action_button => 'Kaydol';

  @override
  String get sign_up_page_action_doing_it => 'Kaydolunuyor…';

  @override
  String get sign_up_page_action_ok =>
      'Tebrikler! Hesabınız başarıyla oluşturuldu.';

  @override
  String get sign_up_page_display_name_hint => 'İsim';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Lütfen kaydetmek istediğiniz başlığı girin';

  @override
  String get sign_up_page_email_hint => 'E-posta';

  @override
  String get sign_up_page_email_error_empty => 'E-mail gereklidir';

  @override
  String get sign_up_page_email_error_invalid => 'Geçersiz e-posta';

  @override
  String get sign_up_page_username_hint => 'Kullanıcı adı: Herkese açık';

  @override
  String get sign_up_page_username_error_empty =>
      'Lütfen bir kullanıcı adı girin';

  @override
  String get sign_up_page_username_error_invalid =>
      'Lütfen Geçerli Bir Kullanıcı Adı Girin';

  @override
  String get sign_up_page_username_description =>
      'Kullanıcı adı boşluk, büyük harf veya özel karakter içeremez.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Kullanıcı adı $value karakterden fazla olamaz';
  }

  @override
  String get sign_up_page_password_hint => 'Şifre';

  @override
  String get sign_up_page_password_error_empty => 'Lütfen bir şifre girin';

  @override
  String get sign_up_page_password_error_invalid =>
      'Geçerli bir şifre girin. (en az 6 harf)';

  @override
  String get sign_up_page_confirm_password_hint => 'Şifreyi Doğrula';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Lütfen parolayı doğrulayın';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Parolalar eşleşmiyor';

  @override
  String get sign_up_page_agree_text => 'Open Food Facts\'i kabul ediyorum';

  @override
  String get sign_up_page_terms_text => 'kullanım ve katılım koşulları';

  @override
  String get donate_url => 'https://tr.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Bir hesap oluştururken Kullanım Koşullarını kabul etmek zorunludur, ancak uygulama aracılığıyla yine de anonim katkılar yapılabilir';

  @override
  String get sign_up_page_producer_checkbox => 'Ben bir yemek üreticisiyim';

  @override
  String get sign_up_page_producer_hint => 'Üretici/Marka';

  @override
  String get sign_up_page_producer_error_empty =>
      'Lütfen bir üretici veya marka adı girin';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Open Food Facts haber bültenine abone olmak istiyorum (İstediğiniz zaman aboneliğinizi iptal edebilirsiniz)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Kullanıcı adı zaten var, lütfen başka bir kullanıcı adı seçin.';

  @override
  String get sign_up_page_email_already_exists =>
      'zaten var, hesaba giriş yapın veya başka bir e-posta ile deneyin.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Lütfen geçerli bir e-posta adresi girin.';

  @override
  String get sign_up_page_server_busy =>
      'Çok üzgünüz, hesabınızı oluştururken bazı teknik sorunlar yaşıyoruz. Lütfen daha sonra tekrar deneyiniz.';

  @override
  String get settingsTitle => 'Ayarlar';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Karanlık';

  @override
  String get darkmode_light => 'Aydınlık';

  @override
  String get darkmode_system_default => 'Sistem varsayılanı';

  @override
  String get thanks_for_contributing =>
      'Katkıda bulunduğunuz için teşekkürler!';

  @override
  String get contributors_label => 'Onlar uygulamayı geliştiriyorlar';

  @override
  String get contributors_dialog_title => 'Katkıda bulunanlar';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Katılımcı: $name';
  }

  @override
  String get contributors_description =>
      'Bu uygulamaya tüm katkıda bulunanlarının listesi';

  @override
  String get support => 'Destek';

  @override
  String get support_join_slack => 'Slack kanalımızda yardım isteyin';

  @override
  String get support_via_forum => 'Forumumuzda yardım isteyin';

  @override
  String get support_via_email => 'Bize bir e-posta gönder';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Uygulama günlükleri gönderilsin mi?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'E-postanıza ek olarak uygulama günlüklerini eklemek ister misiniz?';

  @override
  String get termsOfUse => 'Kullanım Koşulları';

  @override
  String get legalNotices => 'Yasal uyarılar';

  @override
  String get privacy_policy => 'Gizlilik politikası';

  @override
  String get about_this_app => 'Bu uygulama hakkında';

  @override
  String get contribute => 'Destekleyebilirsiniz';

  @override
  String get contribute_sw_development => 'Yazılım geliştirme';

  @override
  String get contribute_develop_text =>
      'Her Open Food Facts ürününün kodu GitHub\'da mevcuttur. Kodu yeniden kullanmakta özgürsünüz (kod açık kaynaklı) ve dünyadaki herkes için iyileştirmemize yardımcı olabilirsiniz.';

  @override
  String get contribute_develop_text_2 =>
      'Soru sormanın genelde tercih edilen yolu olan Open Food Facts Slack sohbet odasına katılabilirsiniz.';

  @override
  String get contribute_develop_dev_mode_title => 'Geliştirici Modu?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'DEV Modunu Etkinleştirin';

  @override
  String get contribute_donate_title => 'Bağış Yapın';

  @override
  String get contribute_donate_header => 'OpenFoodFacts\'e bağış yapın';

  @override
  String get contribute_enroll_alpha_warning =>
      'Lütfen dahili alfa sürümünde verilerin tamamen kaybedilmesinin mümkün olduğunu ve uygulamanın her an kullanılamaz hale gelebileceğini kabul edin!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'Tamamlanacak ürünler';

  @override
  String get contribute_improve_header => 'Geliştirmek';

  @override
  String get contribute_improve_text =>
      'Veritabanı, projenin özüdür. Yardım etmek kolay ve çok hızlı. Telefonunuz için mobil uygulamayı indirebilir ve ürün eklemeye veya iyileştirmeye başlayabilirsiniz.\n\nÖte yandan, Open Food Facts web sitesi katkıda bulunmanız için birçok yol sunar: ';

  @override
  String get contribute_translate_header => 'Çeviri';

  @override
  String get contribute_data_quality => 'Veri Kalitesi';

  @override
  String get contribute_translate_link_text => 'Çeviri Yapmaya Başlayın';

  @override
  String get contribute_translate_text =>
      'Open Food Facts, 160\'tan fazla ülkeden ürünler içeren global bir projedir. Open Food Facts, sürekli gelişen içeriklerle düzinelerce dile çevrilir.';

  @override
  String get contribute_translate_text_2 =>
      'Çeviriler, projenin temel görevlerinden biridir';

  @override
  String get contribute_join_skill_pool =>
      'Open Food Facts\'e becerilerinizle katkıda bulunun. Beceri havuzuna katılın!';

  @override
  String get contribute_share_header =>
      'Open Food Facts\'ı arkadaşlarınızla paylaşın';

  @override
  String get contribute_share_content =>
      'Kullanmakta olduğum uygulama olan Open Food Facts hakkında bilgi vermek istedim. Ambalaj üzerindeki barkodları okutarak çalışır. Ücretsizdir, kayıt gerektirmez ve şifresi çözülen ürün sayısını artırmaya yardımcı olabilirsiniz. İşte telefonunuza indirmek için bağlantı: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Sadakat kartı verilerinizin GDPR kapsamında dışa aktarılmasını talep ederek fiyatlara katkıda bulunun';

  @override
  String get tap_to_answer => 'Soruları yanıtlamak için buraya dokunun';

  @override
  String get tap_to_answer_hint =>
      'Bu ürünle ilgili soruları yanıtlamak için buraya dokunun';

  @override
  String get robotoff_questions_loading_hint =>
      'Bu ürünle ilgili sorular yüklenirken lütfen bekleyin';

  @override
  String get saving_answer => 'Yanıtınız kaydediliyor';

  @override
  String get contribute_to_get_rewards => 'Gıda şeffaflığının katılımcısı ol';

  @override
  String get question_sign_in_text =>
      'Katkılarınız için kredi almak üzere OpenFoodFacts hesabınızda oturum açın';

  @override
  String get question_yes_button_accessibility_value => 'Evet ile cevapla';

  @override
  String get question_no_button_accessibility_value => 'Hayır ile cevapla';

  @override
  String get question_skip_button_accessibility_value => 'Bu soruyu atla';

  @override
  String get tap_to_edit_search => 'Aramayı düzenlemek için dokunun';

  @override
  String get myPreferences => 'Tercihlerim';

  @override
  String get account_create_message =>
      'Hesabınızı oluşturun ve tüm dünyada gıda bilgisi oluşturmaya yardımcı olmak için Open Food Facts topluluğuna katılın!';

  @override
  String get join_us => 'Bize katılın';

  @override
  String get myPreferences_profile_title => 'Profiliniz';

  @override
  String get myPreferences_profile_subtitle =>
      'Open Food Facts hesabını yönet.';

  @override
  String get myPreferences_settings_title => 'Uygulama Ayarları';

  @override
  String get myPreferences_settings_subtitle => 'Karanlık mod, Diller…';

  @override
  String get myPreferences_food_title => 'Yiyecek tercihleri';

  @override
  String get myPreferences_food_subtitle =>
      'Yiyeceklerle ilgili hangi bilgilerin sizin için en önemli olduğunu seçin.';

  @override
  String get myPreferences_food_comment =>
      'Yiyecekleri tercihlerinize göre sıralamak, önemsediğiniz bilgileri ilk önce görmek ve uyumluluk özeti almak için yiyeceklerle ilgili sizin için en önemli olan bilgileri seçin. Bu yemek tercihleri cihazınızda kalır ve varsa Open Food Facts hesabınızla ilişkilendirilmez.';

  @override
  String get confirmResetPreferences => 'Yiyecek tercihleriniz sıfırlansın mı?';

  @override
  String get myPersonalizedRanking => 'Bireysel Sıralamam';

  @override
  String get ranking_tab_all => 'Hepsi';

  @override
  String get ranking_subtitle_match_yes => 'Sizin için harika bir eşleşme';

  @override
  String get ranking_subtitle_match_no => 'Çok zayıf eşleşme';

  @override
  String get ranking_subtitle_match_maybe => 'Bilinmeyen eşleşme';

  @override
  String get refresh_with_new_preferences =>
      'Listeyi yeni tercihlerinizle yenileyin';

  @override
  String get reloaded_with_new_preferences =>
      'Yeni tercihlerle yeniden yüklendi';

  @override
  String get profile_navbar_label => 'Topluluk';

  @override
  String get scan_navbar_label => 'Tara';

  @override
  String get history_navbar_label => 'Geçmiş';

  @override
  String get list_navbar_label => 'Listeler';

  @override
  String get category => 'Kategoriye göre ayır';

  @override
  String get category_all => 'Hepsi';

  @override
  String get category_search => '(kategori arama)';

  @override
  String get filter => 'Filtrele';

  @override
  String get scan => 'Tarama ekranındaki ürünler';

  @override
  String get scan_history => 'Tarama Geçmişi';

  @override
  String get search => 'Ara';

  @override
  String get search_product_help => 'Search a product,\na brand or a barcode';

  @override
  String get search_filter => 'Arama filtresi';

  @override
  String get search_history => 'Arama geçmişi';

  @override
  String get search_store => 'Bir mağaza arayın';

  @override
  String get search_store_help => 'İpucu: Şehri veya ülkeyi ekleyin';

  @override
  String get tap_for_more => 'Daha fazla bilgi görmek için dokunun…';

  @override
  String get product => 'Ürün';

  @override
  String get unknownBrand => 'Bilinmeyen marka';

  @override
  String get unknownProductName => 'Bilinmeyen ürün adı';

  @override
  String get label_refresh => 'Yenile';

  @override
  String get label_reload => 'Yeniden yükle';

  @override
  String get image => 'Resim';

  @override
  String get front_photo => 'Ön fotoğraf';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (bu görsel güncelliğini yitirmiş olabilir)';
  }

  @override
  String get outdated_image_short_label => 'güncelliğini yitirmiş olabilir';

  @override
  String get ingredients => 'Malzemeler';

  @override
  String get ingredients_editing_instructions =>
      'Orijinal sıralamayı koruyun. Belirtildiğinde yüzdeyi belirtin. Virgül veya tire ile ayırın ve bir bileşenin içeriklerini parantez içinde belirtin.';

  @override
  String get ingredients_editing_error => 'Malzemeler kaydedilemedi.';

  @override
  String get ingredients_editing_image_error =>
      'Yeni malzeme görüntüsü alınamadı.';

  @override
  String get ingredients_editing_title => 'Malzemeleri Düzenle';

  @override
  String get ingredients_photo => 'İçindekiler fotoğarafı';

  @override
  String get packaging_editing_instructions =>
      'Tüm ambalaj parçalarını virgülle veya satır beslemesiyle ayırarak, miktarları (ör. 1 veya 6), türü (ör. şişe, kutu, kutu), malzemesi (ör. plastik, metal, alüminyum) ve varsa boyutları (ör. 33 cl) ve geri dönüşüm talimatları.\nÖrnek: Geri dönüştürülecek 1 cam şişe, çöpe atılacak 1 plastik mantar';

  @override
  String get packaging_editing_error => 'Ambalaj kaydedilemedi.';

  @override
  String get packaging_editing_image_error =>
      'Yeni bir paketleme görüntüsü alınamadı.';

  @override
  String get packaging_editing_title => 'Paketlemeyi Düzenle';

  @override
  String get nutrition => 'Beslenme';

  @override
  String get nutrition_facts_photo => 'Besin değerleri fotoğrafı';

  @override
  String get nutrition_facts_editing_title => 'Besin Değerlerini Düzenle';

  @override
  String get packaging_information => 'Paketleme bilgileri';

  @override
  String get packaging_information_photo => 'Paketleme bilgileri fotoğrafı';

  @override
  String get missing_product => 'Yeni bir ürün buldun!';

  @override
  String get add_product_take_photos =>
      'Bu ürünü Open Food Facts\'e eklemek için ambalajın fotoğraflarını çekin';

  @override
  String get add_product_take_photos_descriptive =>
      'Lütfen önce biraz fotoğraf çekin. Ürünü her zaman daha sonra tamamlayabilirsiniz.';

  @override
  String get add_product_information_button_label => 'Ürün bilgisi ekle';

  @override
  String get new_product => 'Yeni ürün';

  @override
  String get new_product_found_title => 'Yeni ürün bulundu!';

  @override
  String get new_product_found_text =>
      'Ortak veritabanımız **3 milyondan fazla** ürünü içeriyor, ancak bu barkod mevcut değil: ';

  @override
  String get new_product_found_button => 'Bu ürünü ekle';

  @override
  String get new_product_leave_title => 'Bu sayfadan ayrılınsın mı?';

  @override
  String get new_product_leave_message =>
      'Hiçbir şey girmemişsiniz gibi görünüyor. Bu sayfadan gerçekten ayrılmak istiyor musunuz?';

  @override
  String get new_product_dialog_description =>
      'Bu ürünü ortak veritabanımıza eklemek için lütfen ambalajın fotoğraflarını çekin';

  @override
  String get new_product_dialog_illustration_description =>
      'Bilinmeyen Nutri-Score ve Green Score\'a sahip bir çizim';

  @override
  String get front_packaging_photo_button_label => 'Ürünün önden bir fotoğrafı';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Ürünün ön fotoğrafının yüklenmesini onaylayın';

  @override
  String get confirm_button_label => 'Onayla';

  @override
  String get send_image_button_label => 'Resim gönder';

  @override
  String get crop_page_action_saving => 'Görüntüyü kaydetme…';

  @override
  String get crop_page_action_cropping => 'Resmin kırpılması…';

  @override
  String get crop_page_action_local => 'Yerel bir sürümü kaydetme…';

  @override
  String get crop_page_action_local_failed_title =>
      'Hata… Fotoğrafınızda bir şey var!';

  @override
  String get crop_page_action_local_failed_message =>
      'Görüntüyü sunucumuza göndermeden önce yerel olarak işleyemiyoruz. Lütfen daha sonra tekrar deneyin veya sorun devam ederse bizimle iletişime geçin.';

  @override
  String get crop_page_action_retake => 'Fotoğrafı yeniden çek';

  @override
  String get crop_page_too_small_image_title => 'Resim çok küçük!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Resim yükleme için minimum piksel boyutu ${expectedMinWidth}x$expectedMinHeight. Mevcut resim ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Çağrıyı sunucuya hazırlama…';

  @override
  String get front_packaging_photo_title => 'Ön ambalaj fotoğrafı';

  @override
  String get ingredients_photo_title => 'İçindekiler fotoğarafı';

  @override
  String get nutritional_facts_photo_title => 'Besin Değerleri Fotoğrafı';

  @override
  String get recycling_photo_title => 'Geri Dönüşüm Fotoğrafı';

  @override
  String get take_photo_title => 'Resim çek';

  @override
  String get take_more_photo_title => 'Daha fazla fotoğraf çekin';

  @override
  String get front_photo_uploaded => 'Önden fotoğraf yüklendi';

  @override
  String get ingredients_photo_button_label => 'İçindekiler fotoğarafı';

  @override
  String get ingredients_photo_uploaded => '\"İçindekiler\" fotoğrafı yüklendi';

  @override
  String get nutrition_cache_loading_error =>
      'Besin değerleri önbellekten yüklenemiyor';

  @override
  String get nutritional_facts_photo_button_label =>
      'Besin değerleri fotoğrafı';

  @override
  String get nutritional_facts_input_button_label => 'Besin değerleri gir';

  @override
  String get nutritional_facts_added => 'Besin değerleri eklendi';

  @override
  String get categories_added => 'Kategoriler eklendi';

  @override
  String get new_product_title_nutriscore => 'Nutri-Score\'u hesaplayın';

  @override
  String get new_product_subtitle_nutriscore =>
      'Gıda kategorisini ve besin değerlerini doldurarak alın';

  @override
  String get new_product_title_environmental_score => 'Green-Score\'u hesapla';

  @override
  String get new_product_subtitle_environmental_score =>
      'En azından bir kategoriyi doldurarak bunu elde edin';

  @override
  String get new_product_additional_environmental_score =>
      'Green-Score hesaplamasını köken, paketleme ve daha fazlasını girerek tutarlılaştırın';

  @override
  String get new_product_title_nova =>
      'Gıda işleme seviyesini (NOVA) hesaplayın';

  @override
  String get new_product_subtitle_nova =>
      'Gıda kategorisini ve malzemeleri doldurarak alın';

  @override
  String get new_product_desc_nova_unknown =>
      'Gıda işleme seviyesi bilinmemektedir';

  @override
  String get new_product_title_pictures => 'Birkaç fotoğraf çekelim!';

  @override
  String get new_product_title_pictures_details =>
      'Lütfen aşağıdaki fotoğrafları çekin. Open Food Facts motoru gerisini halledecektir!';

  @override
  String get new_product_title_misc => 'Ve bazı temel veriler…';

  @override
  String new_product_done_msg(String username) {
    return 'Katkılarınız için teşekkürler “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Katkılarınız için teşekkürler!';

  @override
  String get new_product_done_button_label => 'Tamamlanan ürünü keşfedin';

  @override
  String get hey_incomplete_product_message =>
      'Nutri-Score, Green Score ve Ultra-processing (NOVA)\'ı hesaplamak için ŞİMDİ 3 soruyu yanıtlamak için tıklayın!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Bu kozmetiği analiz etmemize yardımcı olacak 2 soruyu yanıtlamak için hemen tıklayın!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Bu evcil hayvan maması ürününü analiz etmemize yardımcı olacak 3 soruyu yanıtlamak için hemen tıklayın!';

  @override
  String get hey_incomplete_product_message_product =>
      'Bu ürünü tamamlamaya yardımcı olmak için hemen tıklayın!';

  @override
  String get nutritional_facts_photo_uploaded =>
      '\"Besin değerleri\" fotoğrafı yüklendi';

  @override
  String get recycling_photo_button_label => 'Geri dönüşüm bilgisi fotoğrafı';

  @override
  String get recycling_photo_uploaded => 'Geri dönüşüm fotoğrafı yüklendi';

  @override
  String get take_more_photo_button_label => 'Daha fazla fotoğraf çekin';

  @override
  String get other_photo_uploaded => 'Fotoğraf yüklendi';

  @override
  String get retake_photo_button_label => 'Yeniden çek';

  @override
  String get selecting_photo => 'Fotoğraf seçiliyor';

  @override
  String get uploading_image => 'Fotoğraf sunucuya yükleniyor';

  @override
  String get uploading_image_type_front =>
      'Ön yüz görseli Open Food Facts\'e yükleniyor';

  @override
  String get uploading_image_type_ingredients =>
      'İçindekiler görseli Open Food Facts\'e yükleniyor';

  @override
  String get uploading_image_type_nutrition =>
      'Besin değerleri görseli Open Food Facts\'e yükleniyor';

  @override
  String get uploading_image_type_packaging =>
      'Ambalaj görseli Open Food Facts\'e yükleniyor';

  @override
  String get uploading_image_type_other =>
      '\"Diğer\" görseli Open Food Facts\'e yükleniyor';

  @override
  String get uploading_image_type_generic =>
      'Görsel Open Food Facts\'e yükleniyor';

  @override
  String get score_add_missing_ingredients =>
      'Eksik içindekiler bilgileri ekle';

  @override
  String get score_add_missing_packaging_image =>
      'Eksik paketleme resmini ekleyin';

  @override
  String get score_add_missing_nutrition_facts =>
      'Eksik besin değerlerini ekle';

  @override
  String get score_add_missing_product_traces => 'Eksik ürün izlerini ekleyin';

  @override
  String get score_add_missing_product_category =>
      'Eksik ürün kategori bilgisini ekle';

  @override
  String get score_add_missing_precise_product_category =>
      'Daha kesin bir kategori seçin';

  @override
  String get score_add_missing_product_countries =>
      'Eksik ürün ülkelerini ekleyin';

  @override
  String get score_add_missing_product_emb =>
      'Eksik ürün izlenebilirlik kodlarını ekleyin';

  @override
  String get score_add_missing_product_labels =>
      'Eksik ürün etiketlerini ekleyin';

  @override
  String get score_add_missing_product_origins =>
      'Eksik ürün menşelerini ekleyin';

  @override
  String get score_add_missing_product_stores =>
      'Eksik ürün mağazalarını ekleyin';

  @override
  String get score_add_missing_product_brands =>
      'Eksik ürün markalarını ekleyin';

  @override
  String get score_update_nutrition_facts =>
      'Besin değerleri bilgilerini güncelle';

  @override
  String get nutrition_page_title => 'Besin Değerleri';

  @override
  String get nutrition_page_nutritional_info_title => 'Besin değeri bilgileri';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Ürün üzerinde belirtilen değerler:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Evet';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Hayır';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Fotoğrafı aç';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'İyi uygulamalar: Besin değeri bilgileri';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Bazen besin değerleri **ambalajda** veya ürünle birlikte verilen bir belgede belirtilmez. Bu durumda ve yalnızca bu durumda, değeri **HAYIR** olarak ayarlayabilirsiniz.';

  @override
  String get nutrition_page_serving_type_label => 'Besin değerleri:';

  @override
  String get nutrition_page_per_100g => '100g başına';

  @override
  String get nutrition_page_per_100g_100ml => '100g/ml başına';

  @override
  String get nutrition_page_per_serving => 'porsiyon başına';

  @override
  String get nutrition_page_add_nutrient => 'Besin ögesi ekle';

  @override
  String get nutrition_page_serving_size => 'Porsiyon ölçüsü';

  @override
  String get nutrition_page_serving_size_hint =>
      'Bir porsiyon boyutu girin (örneğin: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'İyi uygulamalar: Porsiyon boyutu';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Bu değer, **her bir besin öğesinin porsiyon başına orantılı olarak hesaplanmasına** yardımcı olur.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**İzin verilen birimler** şunlardır: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** veya **60 G** (ilkini tercih edin)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** veya **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Geçersiz birim';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Geçersiz birimler';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **şeker** ve 2 **bisküvi**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Eksik ünite';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Geçersiz numara';

  @override
  String get nutrition_page_update_running => 'Ürün sunucuda güncelleniyor…';

  @override
  String get nutrition_page_update_done => 'Ürün güncellendi!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Ürün miktarını porsiyon boyutu olarak kullanın';

  @override
  String get nutrition_page_photo_error => 'Fotoğraf yüklenemiyor';

  @override
  String get more_photos => 'Daha ilginç fotoğraflar';

  @override
  String get view_more_photo_button =>
      'Bu ürüne ait mevcut tüm fotoğrafları görüntüle';

  @override
  String get no_product_found => 'Ürün bulunamadı';

  @override
  String get no_location_found => 'Konum bulunamadı';

  @override
  String get not_found => 'bulunamadı:';

  @override
  String get refreshing_product => 'Ürün yenileme';

  @override
  String get product_refreshed => 'Ürün yenilendi';

  @override
  String product_image_accessibility_label(String date) {
    return 'Görüntü ${date}tarihinde çekildi';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Görüntü ${date}tarihinde çekildi. Bu görüntü güncelliğini yitirmiş olabilir.';
  }

  @override
  String get product_image_outdated =>
      'Bu görüntü güncelliğini yitirmiş olabilir';

  @override
  String get product_image_outdated_explanations_title =>
      'Bu görüntü güncelliğini yitirmiş olabilir';

  @override
  String get product_image_outdated_explanations_content =>
      'Bu görüntü bir yıldan uzun süre önce çekildi.\n**Lütfen güncel olduğundan emin olun**.\n\nBu **sadece bir uyarı**. İçerik hala aynıysa, bu mesajı görmezden gelebilirsiniz.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Fotoğrafı değiştir ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Bir fotoğraf ekle ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Yeni Yakala';

  @override
  String get product_image_action_take_picture => 'Resim çek';

  @override
  String get product_image_action_from_gallery =>
      'Telefonunuzun galerisinden seçin';

  @override
  String get product_image_action_choose_existing_photo =>
      'Ürün fotoğraflarından seçin';

  @override
  String get product_image_details_label => 'Fotoğraf hakkında bilgi';

  @override
  String get product_image_details_from_producer => 'Yapımcıdan';

  @override
  String get product_image_details_contributor => 'Katkı sağlayan';

  @override
  String get product_image_details_contributor_producer =>
      'Katkıda bulunan (yapımcı)';

  @override
  String get product_image_details_date => 'Tarih';

  @override
  String get product_image_details_date_unknown => 'Bilinmeyen';

  @override
  String get homepage_main_card_logo_description =>
      'Open Food Facts\'e Hoş Geldiniz';

  @override
  String get homepage_main_card_subheading =>
      'Bir barkodu **tarayın** veya bir ürün için\n**arama** yapın';

  @override
  String get homepage_main_card_search_field_hint => 'Bir ürün arayın';

  @override
  String get homepage_main_card_search_field_tooltip => 'Aramayı başlat';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Son haberler: $news_title';
  }

  @override
  String get tagline_app_review => 'Uygulamayı beğendiniz mi?';

  @override
  String get tagline_app_review_button_positive => 'Bayıldım! 😍';

  @override
  String get tagline_app_review_button_negative => 'Pek sayılmaz…';

  @override
  String get tagline_app_review_button_later => 'Daha sonra sor';

  @override
  String get tagline_feed_news_button => 'Daha fazla bilgi';

  @override
  String get app_review_negative_modal_title => 'Uygulamamızı beğenmediniz mi?';

  @override
  String get app_review_negative_modal_text =>
      'Bize nedenini söylemek için birkaç saniyenizi ayırabilir misiniz?';

  @override
  String get app_review_negative_modal_positive_button => 'Evet kesinlikle!';

  @override
  String get app_review_negative_modal_negative_button => 'Hayır';

  @override
  String get could_not_refresh => 'Ürün yenilenemedi';

  @override
  String get product_internet_error_modal_title => 'Bir hata oluştu!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Bir ağ hatası nedeniyle bu ürün hakkında bilgi alamıyoruz. Lütfen internet bağlantınızı kontrol edin ve tekrar deneyin.\n\nDahili hata:\n$error';
  }

  @override
  String get product_tags_title => 'Ürün özellikleri';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Hiçbir özellik yok';

  @override
  String get product_tags_explanation =>
      'Bir ürüne özellikler (anahtar/değer) ekleyerek onu zenginleştirmeye yardımcı olursunuz.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Özellikler ekle';

  @override
  String get add_edit_tags => 'Özellikleri ekleyin veya düzenleyin';

  @override
  String get edit_tag => 'Özelliği düzenle';

  @override
  String get remove_tag => 'Özelliği Kaldır';

  @override
  String get tag_key => 'Özellik';

  @override
  String get tag_keys => 'Özellikler';

  @override
  String get tag_key_uneditable => 'Özellik (düzenlenemez)';

  @override
  String get tag_key_input_hint => 'Bir özellik girin';

  @override
  String get tag_value => 'Değer';

  @override
  String get tag_values => 'Değerler';

  @override
  String get tag_value_input_hint => 'Bir değer girin';

  @override
  String get tag_key_item => 'Özellik:';

  @override
  String get tag_value_item => 'Değer:';

  @override
  String get tag_key_explanations =>
      'Şifre küçük harfli olmalı ve boşluk içermemelidir.';

  @override
  String tag_key_already_exists(String property) {
    return '$property özelliğine sahip bir etiket zaten mevcut!';
  }

  @override
  String get product_internet_error =>
      'Bir ağ hatasından dolayı ürün bilgileri çekilemedi.';

  @override
  String get cached_results_from => 'Sonuçların gösterildiği:';

  @override
  String get product_search_same_category => 'Alternatifleri bulun';

  @override
  String get product_search_same_category_short => 'Karşılaştır';

  @override
  String get product_search_same_category_error =>
      'Bu özellik yalnızca kategorisi olan ürünler için kullanılabilir.\n\nKategori eklemek için lütfen ürünü düzenleyin.';

  @override
  String get product_improvement_add_category =>
      'Nutri-Score\'u hesaplamak için bir kategori ekleyin.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Nutri-Score puanını hesaplamak için besin değerleri bilgisi ekleyin.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Nutri-Score puanını hesaplamak için besin değerleri ve bir kategori bilgisi ekleyin.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Bu ürün için Nutri-Score hesaplanamıyor, bunun nedeni örneğin standart olmayan bir kategori olabilir. Bu bir hata olarak kabul edilirse, lütfen bizimle iletişime geçin.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Beslenme resmi eskidir: lütfen yenileyin.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Green Score, içeriklerin kökenlerini hesaba katar. Lütfen içerik listesinin ve/veya herhangi bir köken belirtisinin fotoğrafını çekin veya ürünü düzenleyin, böylece dikkate alınabilirler.';

  @override
  String get country_chooser_label => 'Lütfen bir ülke seçin';

  @override
  String get currency_chooser_label => 'Lütfen bir para birimi seçin';

  @override
  String get country_change_message => 'Az önce ülke değiştirdiniz.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Para birimini $previousCurrency yerine $possibleCurrency olarak değiştirmek istiyor musunuz?';
  }

  @override
  String get onboarding_country_chooser_label => 'Lütfen bir ülke seçin:';

  @override
  String get country_chooser_label_from_settings => 'Ülkeniz';

  @override
  String get country_selection_explanation =>
      'Bazı çevresel özellikler konuma özgüdür';

  @override
  String get product_removed_comparison => 'Ürün karşılaştırmadan kaldırıldı';

  @override
  String get native_app_settings => 'Yerel Uygulama Ayarları';

  @override
  String get native_app_description =>
      'Open Food Facts için sistem ayarlarını açın';

  @override
  String get product_removed_history => 'Ürün geçmişten kaldırıldı';

  @override
  String get product_removed_list => 'Ürün listeden kaldırıldı';

  @override
  String get product_could_not_remove => 'Ürün kaldırılamadı';

  @override
  String get no_prodcut_in_list => 'Bu listede ürün yok';

  @override
  String get no_product_in_section => 'Bu bölümde ürün bulunmamaktadır';

  @override
  String get recently_seen_products => 'Görüntülenen tüm ürünler';

  @override
  String get clear => 'Temizle';

  @override
  String get clear_long => 'Listeyi boşalt';

  @override
  String get really_clear => 'Bu listeyi silmek istediğinize emin misiniz?';

  @override
  String pct_match(Object percent) {
    return '$percent% eşleşme';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count gün önce',
      one: 'bir gün önce',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count saatler önce',
      one: 'bir saat önce',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dakika önce',
      one: 'bir dakika önce',
      zero: 'bir dakikadan az önce',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ay önce',
      one: 'bir ay önce',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count hafta önce',
      one: 'bir hafta önce',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ürünler $count Karşılaştırın',
      one: 'Bir Ürünü Karşılaştırın',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count seçili ürünler',
      one: 'Bir seçili ürün',
      zero: 'Seçili ürün yok',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Seçili ürünleri karşılaştırın';

  @override
  String get delete_products_mode => 'Seçili ürünleri sil';

  @override
  String get select_all_products_mode => 'Tüm ürünleri seçin';

  @override
  String get select_none_products_mode => 'Hiçbirini seçme';

  @override
  String get compare_products_appbar_title => 'Ürünleri karşılaştırın';

  @override
  String get compare_products_appbar_subtitle =>
      'Lütfen en az iki ürünü seçiniz';

  @override
  String get retry_button_label => 'Tekrar dene';

  @override
  String get connect_with_us => 'Bizimle iletişime geçin';

  @override
  String get tiktok => 'Bizi TikTok\'ta takip et';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Bizi Instagram\'da takip edin';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Bizi X\'te takip edin (eski adıyla Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Bizi Mastodon\'da takip edin';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Bizi BlueSky\'da takip edin';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'SSS';

  @override
  String get discover => 'Keşfet';

  @override
  String get how_to_contribute => 'Nasıl Katkıda Bulunulur';

  @override
  String get hint_knowledge_panel_message =>
      'Gördüğünüz şey hakkında daha fazla ayrıntı almak için kartın herhangi bir yerine dokunabilirsiniz. Şimdi dene!';

  @override
  String get permissions_page_title => 'Kamera erişimi';

  @override
  String get permissions_page_body1 =>
      'Barkodları telefonunuzun kamerasıyla taramak için lütfen erişimi yetkilendirin.';

  @override
  String get permissions_page_body2 =>
      'Fikrinizi değiştirirseniz, bu seçenek istediğiniz zaman ayarlardan etkinleştirilebilir ve devre dışı bırakılabilir.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Sürüm: $release)\nModel: $model\nÜrün: $product\nCihaz: $device\nMarka:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'İşletim Sistemi: iOS ($version)\nModel: $model\nYerelleştirilmiş model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nUygulama sürümü:$appVersion\nUygulama yapı numarası:$appBuildNumber\nUygulama paketi adı:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Yetkilendirme';

  @override
  String get refuse_button_label => 'Reddet';

  @override
  String get ask_me_later_button_label => 'Daha sonra';

  @override
  String get are_you_sure => 'Emin misiniz?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return '$sourceName Daha ileri git';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Hoş geldiniz!';

  @override
  String get onboarding_home_welcome_text2 =>
      '**sizin** ve **gezegen** için iyi olan yiyecekleri seçmenize yardımcı olan uygulama!';

  @override
  String get onboarding_continue_button => 'Devam et';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'İlk örnek ürününüz yükleniyor';

  @override
  String get onboarding_welcome_warning =>
      'Üzgünüz, bu bizim örnek ürünümüz, düzenleyemezsiniz :)';

  @override
  String get product_list_your_ranking => 'Sıralamanız';

  @override
  String get product_list_empty_icon_desc => 'Geçmiş kullanılamıyor';

  @override
  String get product_list_empty_title => 'Taramayı başlat';

  @override
  String get product_list_empty_message =>
      'Taranan ürünler burada görünecektir. Onlar hakkında detaylı bilgileri kontrol edebilirsiniz';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'ürünler',
      one: 'ürün',
      zero: 'ürün',
    );
    return 'Tazeleme $_temp0 geçmişinizde';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Ürünler',
      one: 'Ürün',
      zero: 'Ürün',
    );
    return '$_temp0 yenileme tamamlandı';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Veri indiriliyor';

  @override
  String get loading_dialog_default_error_message => 'Veri indirilemedi';

  @override
  String get account_delete => 'Hesabımı sil';

  @override
  String get account_delete_title => 'Hesabımı sil';

  @override
  String get user_profile => 'Hesap';

  @override
  String get user_profile_title_guest => 'Hoşgeldiniz!';

  @override
  String get user_profile_subtitle_guest =>
      'Open Food Facts topluluğuna katılmak için oturum açın veya kaydolun';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts giriş: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return '$id hoş geldiniz!';
  }

  @override
  String get email_subject_account_deletion => 'Hesabımı sil';

  @override
  String email_body_account_deletion(String userId) {
    return 'Merhaba, lütfen Open Food Facts hesabımı silin: $userId';
  }

  @override
  String get settings_app_app => 'Uygulama';

  @override
  String get settings_app_data => 'Gizlilik ve izleme';

  @override
  String get settings_app_camera => 'Kamera';

  @override
  String get settings_app_products => 'Ürünler';

  @override
  String get settings_app_miscellaneous => 'Çeşitli';

  @override
  String get camera_play_sound_title => 'Taranınca ses çıkar';

  @override
  String get camera_play_sound_subtitle =>
      'Her başarılı taramada bip sesi çıkarır';

  @override
  String get camera_window_accessibility_label =>
      'Kameranızla bir barkodu tarayın';

  @override
  String get app_haptic_feedback_title => 'Titreşim ve Dokunma';

  @override
  String get app_haptic_feedback_subtitle =>
      'Bazı eylemler gerçekleştirildikten sonra titreşimler (barkod kodu çözüldü, ürün kaldırıldı…).';

  @override
  String get crash_reporting_toggle_title => 'Çökme raporlaması';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Etkinleştirildiğinde, kilitlenme raporları Open Food Facts\'in hata izleme sistemine otomatik olarak gönderilir, böylece hatalar düzeltilebilir ve böylece uygulama geliştirilebilir.';

  @override
  String get send_anonymous_data_toggle_title => 'Anonim veri gönder';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Etkinleştirildiğinde, uygulama kullanımına ilişkin bazı anonim bilgiler Open Food Facts sunucularına gönderilecek, böylece özelliklerin iyileştirilmesi amacıyla nasıl ve ne kadar kullanıldığını anlayabileceğiz.';

  @override
  String get product_edit_photo_title => 'Fotoğrafı Düzenle';

  @override
  String get permission_photo_error => 'Hata';

  @override
  String get permission_photo_denied_title =>
      'Barkodları taramak için kamera kullanımına izin verin';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Gelişmiş bir deneyim için lütfen $appName kameranıza erişmesine izin verin. Barkodları doğrudan tarayabileceksiniz.';
  }

  @override
  String get permission_photo_denied_button => 'İzin ver';

  @override
  String get permission_photo_denied_dialog_settings_title => 'İzin reddedildi';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Daha önce kamera iznini reddettiğinizden, ayarlardan el ile izin vermelisiniz.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Ayarları Aç';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'İptal';

  @override
  String get permission_photo_none_found => 'Kamera algılanmadı';

  @override
  String get permission_photo_denied => 'Kamera erişimi verilmedi';

  @override
  String get show_product_pictures => 'Ürün resimlerini göster';

  @override
  String get edit_product_label => 'Ürünü Düzenle';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Düzenlemeleriniz yükleniyor…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Düzenlemeleriniz **arka planda** (veya hata durumunda daha sonra) gönderiliyor.\nDiğer ürün alanlarını düzenlemeye devam edebilirsiniz.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Düzenlemeleriniz **arka planda** (veya hata durumunda daha sonra) gönderiliyor.';

  @override
  String get edit_product_label_short => 'Düzenle';

  @override
  String edit_product_form_item_help(String value) {
    return '\"$value\" nasıl girilir?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Lütfen boş olmayan bir değer girin!';

  @override
  String get edit_product_form_item_error_existing => 'Bu değer zaten var!';

  @override
  String get edit_product_form_item_add_action_brand => 'Yeni bir marka ekle';

  @override
  String get edit_product_form_item_add_action_label => 'Yeni bir etiket ekle';

  @override
  String get edit_product_form_item_add_action_store => 'Yeni bir mağaza ekle';

  @override
  String get edit_product_form_item_add_action_origin => 'Yeni bir köken ekle';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Yeni bir izlenebilirlik kodu ekleyin';

  @override
  String get edit_product_form_item_add_action_country => 'Yeni bir ülke ekle';

  @override
  String get edit_product_form_item_add_action_category =>
      'Yeni bir kategori ekle';

  @override
  String get edit_product_form_item_add_action_trace => 'Yeni bir iz ekle';

  @override
  String get edit_product_form_item_add_suggestion => 'Öneri ekle';

  @override
  String get edit_product_form_item_deny_suggestion => 'Öneriyi reddet';

  @override
  String get edit_product_form_item_details_title => 'Temel bilgiler';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Ürün adı, markası, miktarı';

  @override
  String get edit_product_form_item_other_details_title => 'Ek ayrıntılar';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Web sitesi…';

  @override
  String get edit_product_form_item_photos_title => 'Fotoğraflar';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Fotoğraf ekle veya yenile';

  @override
  String get edit_product_form_item_labels_title => 'Etiketler ve Sertifikalar';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Çevre, Kalite etiketleri…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Bir etiket girin (örneğin: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etiket';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'İyi uygulamalar: Etiketler';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Ürünün **gerçek** ve diğer alanlardan farklı olan herhangi bir özelliği.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Belçika\'da üretildi, Britanya\'da üretildi…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Lif açısından zengin, demir kaynağı…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Adil ticaret, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Mağazalar';

  @override
  String get edit_product_form_item_stores_hint => 'Bir mağaza girin';

  @override
  String get edit_product_form_item_stores_type => 'mağaza';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'İyi uygulamalar: Mağazalar';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Ürünü satın aldığınız mağazayı girin.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Kökenleri';

  @override
  String get edit_product_form_item_origins_hint =>
      'Bir köken girin (örneğin: Almanya)';

  @override
  String get edit_product_form_item_origins_type => 'ülke';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'İyi uygulamalar: Kökenler';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      '**Ambalaj üzerinde bulabildiğiniz menşei bilgilerini** ekleyin.\nİçerik listesinde doğrudan belirtilen menşeler konusunda endişelenmenize gerek yok.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Arjantin\'den sığır eti';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soya Avrupa Birliği\'nden gelmiyor';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Bir ülke girin (örneğin: Almanya)';

  @override
  String get edit_product_form_item_countries_type => 'ülke';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'İyi uygulamalar: Ülkeler';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Ürünün yaygın olarak bulunduğu ülkeler** (yabancı ürünlere odaklanan mağazalar hariç).';

  @override
  String get edit_product_form_item_emb_codes_title => 'İzlenebilirlik kodları';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Bir kod girin (örn.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'izlenebilirlik Kodu';

  @override
  String get edit_product_form_item_emb_help_title =>
      'İyi uygulamalar: İzlenebilirlik kodları';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Bu bölümde **ambalaj işaretleri**, **tanımlama işaretleri** veya **sağlık işaretleri** ile ilgili kodları girebilirsiniz.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'İzlenebilirlik kodlarına örnekler';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC kodları** Avrupa Topluluğu\'nda gıda üreticilerini veya paketleyicilerini tanımlamak için kullanılır:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: **Fransa**\'nın ülke kodu\n**72.264.002**: coğrafi veriler\n**CE**: Avrupa Topluluğu';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      'Fransa\'da kullanılan **EMB kodları**:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'İz';

  @override
  String get edit_product_form_item_traces_hint => 'iz';

  @override
  String get edit_product_form_item_traces_type =>
      'Bir iz girin (örneğin: Soya fasulyesi)';

  @override
  String get edit_product_form_item_categories_title => 'Kategoriler';

  @override
  String get edit_product_form_item_categories_hint => 'kategori';

  @override
  String get edit_product_form_item_categories_type =>
      'Bir kategori girin (örneğin: Portakal suyu)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'İyi uygulamalar: Kategoriler';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      '**Yalnızca en spesifik kategoriyi** belirtin.\nÜst kategoriler otomatik olarak eklenecektir.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Kategori eksik mi?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Bir kategori **otomatik tamamlamada mevcut değilse**, yine de eklemekten çekinmeyin.\nBu, ülkenizde Open Food Facts\'i geliştirmemize yardımcı olacaktır.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Zeytinyağında sardalya bulunuyor';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Konsantre portakal suyu';

  @override
  String get edit_product_form_item_exit_title =>
      'Kaydetmeden çıkmak mı istiyorsunuz?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Sayfadan ayrılmadan önce değişiklikleri kaydetmek istiyor musunuz?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Değişiklikleri kaydet';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Değişiklileri yoksay';

  @override
  String get edit_product_form_item_ingredients_title => 'Malzemeler';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Ekranı sıkıştırarak yakınlaştırın ve uzaklaştırın';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Fotoğrafı yakınlaştırın ve uzaklaştırın';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      '**Yakınlaştırma hareketini** kullanarak fotoğrafı yakınlaştırabilir veya uzaklaştırabilirsiniz:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Ekle';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Lütfen önce bir metin girin';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Kaldır';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Düzenlemenizi kaydedin';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Düzenlemenizi iptal edin';

  @override
  String get edit_product_form_item_packaging_title =>
      'Geri dönüşüm talimatları fotoğrafı';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Beslenme gerçekleri';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Besin değerleri, alkol içeriği…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'İyi uygulamalar: Besin değerleri';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Besin değerleri';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Öncelikle **değerlerin sağlanıp sağlanmadığını** seçin:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Beslenme gerçekleri';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Ardından, ambalaj üzerinde belirtilen besin değerlerini girin. Eğer değer yoksa, \"Göz\" simgesine tıklayabilirsiniz.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Eksik alan mı?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Eğer bir girdi eksikse, eklemek için **\"Artı\" simgesine** tıklayabilirsiniz (örn: D vitamini, magnezyum…).';

  @override
  String get edit_product_form_save => 'Düzenle';

  @override
  String get edit_product_ingredients_photo_title => 'İçindekiler fotoğarafı';

  @override
  String get edit_product_ingredients_list_title => 'Malzemelerin listesi';

  @override
  String get edit_product_packaging_photo_title => 'Ambalaj fotoğrafı';

  @override
  String get edit_product_packaging_list_title => 'Paketleme listesi';

  @override
  String get no_data_available => 'Hiç veri yok';

  @override
  String get product_field_website_title => 'Web sitesi';

  @override
  String get origins_editing_title => 'Kökenleri Düzenle';

  @override
  String get completed_basic_details_btn_text => 'Temel bilgileri tamamlayın';

  @override
  String get not_implemented_snackbar_text => 'Henüz uygulanmadı';

  @override
  String get category_picker_page_appbar_text => 'Kategoriler';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Fotoğraftan içerikleri çıkar';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'İçindekileri çıkartın';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Fotoğraftan içerikleri çıkarma';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Fotoğraf yükleniyor…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Bu mesajı neden görüyorum?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      '\"Malzemeleri çıkar\" özelliğini kullanabilmek için öncelikle fotoğrafın yüklenmesi gerekmektedir.\n\nLütfen birkaç saniye bekleyin veya manuel olarak girin.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Fotoğrafı yenileyin';

  @override
  String get edit_packaging_extract_btn_text => 'Fotoğraftan ambalajı\nçıkarın';

  @override
  String get edit_packaging_extract_btn_text_short => 'Ambalajı çıkar';

  @override
  String get edit_packaging_extracting_btn_text => 'Fotoğraftan ambalajı çıkar';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Fotoğraf yükleniyor…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Bu mesajı neden görüyorum?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      '\"Ambalajı çıkar\" özelliğini kullanabilmek için öncelikle fotoğrafın yüklenmesi gerekmektedir.\n\nLütfen birkaç saniye bekleyin veya manuel olarak girin.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Fotoğrafı yenileyin';

  @override
  String get edit_ocr_extract_failed => 'Resimdeki metin algılanamadı.';

  @override
  String get edit_ocr_extract_disabled_title => 'Fotoğraf yok!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Metin çıkarma özelliğini kullanabilmeniz için öncelikle bir fotoğraf çekmeniz gerekiyor.';

  @override
  String get user_list_dialog_new_title => 'Ürünlerin yeni listesi';

  @override
  String get user_list_dialog_rename_title => 'Listeyi yeniden adlandırın';

  @override
  String get user_list_subtitle_product => 'Listeler';

  @override
  String get user_list_title => 'Listeleriniz';

  @override
  String get user_list_add_product => 'Ürünü listelerinize ekleyin';

  @override
  String get user_list_button_new => 'Yeni bir liste oluştur';

  @override
  String get user_list_empty_label =>
      'Henüz bir liste mevcut değil,\nlütfen bir tane oluşturarak başlayın';

  @override
  String get user_list_button_add_product => 'Listeye ekle';

  @override
  String get added_to_list_msg => 'Listeye eklendi';

  @override
  String get user_list_popup_clear => 'Geçmişinizi temizleyin';

  @override
  String get user_list_popup_rename => 'Yeniden adlandırın';

  @override
  String get user_list_name_hint => 'Listem';

  @override
  String get user_list_name_error_empty => 'Ad zorunludur';

  @override
  String get user_list_name_error_already => 'Bu isim zaten kullanılmakta';

  @override
  String get user_list_name_error_same => 'Bu aynı isim';

  @override
  String get user_list_name_input_hint => 'Listenin adı';

  @override
  String get try_again => 'Tekrar Dene';

  @override
  String get there_was_an_error => 'Bir hata oluştu';

  @override
  String category_picker_no_category_found_message(String items) {
    return '$items için kategori bulunamadı';
  }

  @override
  String get camera_toggle_camera => 'Arka ve ön kamera arasında geçiş yapın';

  @override
  String get camera_toggle_flash => 'Kameranın flaşını AÇIN veya KAPATIN';

  @override
  String get camera_enable_flash => 'Flaşı etkinleştir';

  @override
  String get camera_disable_flash => 'Flaşı kapat';

  @override
  String get camera_flash_error_dialog_title => 'Bir hata oluştu!';

  @override
  String get camera_flash_error_dialog_message =>
      'Flaşınızın durumu değiştirilirken bir hata oluştu. Lütfen akıllı telefonunuzda el fenerinin etkinleştirilmiş olmadığından emin olun.';

  @override
  String get category_picker_no_category_found_button => 'Geri';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Tarayıcınızda veya uygulamada (yüklüyse) açmak için tıklayın';

  @override
  String get dev_preferences_screen_title => 'Geliştirici Modu';

  @override
  String get dev_preferences_screen_subtitle =>
      'Deneysel özelliklere ve geliştirme araçlarına erişin';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'İlk katılımı yeniden başlat';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Daha sonra tekrar görmek için Uygulamayı yeniden başlatmanız gerekir.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Openfoodfacts.org (PROD) ve test ortamı arasında geçiş yapın';

  @override
  String get dev_preferences_test_environment_title =>
      'Test ortamı parametreleri';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Mevcut test ortamı için temel URL: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Test ortamı ana bilgisayarı';

  @override
  String get dev_preferences_ml_kit_title => 'ML Kitini Kullan';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'o zaman bu uygulamayı yeniden başlatmanız gerekiyor';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Ürün sayfasındaki ek düğme';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Bir bilgi paneli düğmesi aracılığıyla içindeki malzemeleri düzenleyin';

  @override
  String get dev_preferences_export_history_title => 'Geçmişi dışa aktar';

  @override
  String get dev_preferences_export_history_progress_error => 'istisna';

  @override
  String get dev_preferences_export_history_progress_found => 'ürün bulundu';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'ürün bulunamadı';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Geçmişi dışa aktar';

  @override
  String get dev_preferences_button_positive => 'Tamam';

  @override
  String get dev_preferences_button_negative => 'İptal';

  @override
  String get dev_preferences_migration_title => 'V1\'den veri aktarma';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Durum: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'başarı veya yeni yükleme';

  @override
  String get dev_preferences_migration_status_success => 'başarı';

  @override
  String get dev_preferences_migration_status_error => 'hata';

  @override
  String get dev_preferences_migration_status_in_progress => 'devam ediyor';

  @override
  String get dev_preferences_migration_status_required =>
      'gerekli (başlamak için tıklayın)';

  @override
  String get dev_preferences_migration_status_not_started => 'bilinmiyor';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Geçmişi temizleyecek ve oraya 3 ürün koyacak';

  @override
  String get dev_preferences_news_custom_url_title => 'Haberler için özel URL';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'JSON dosyasının URL\'si:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Ayarlanmadı';

  @override
  String get dev_preferences_news_provider_status_title => 'Durum';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Son yenileme: $date';
  }

  @override
  String get product_type_label_food => 'Gıda';

  @override
  String get product_type_label_beauty => 'Kişisel bakım';

  @override
  String get product_type_label_pet_food => 'Evcil hayvan maması';

  @override
  String get product_type_label_product => 'Diğer';

  @override
  String get product_type_selection_title => 'Ürün tipi';

  @override
  String get product_type_selection_subtitle => 'Bu ürünün türünü seçin';

  @override
  String get product_type_selection_empty =>
      'Öncelikle bir ürün türü seçmeniz gerekiyor!';

  @override
  String product_type_selection_already(String productType) {
    return 'Ürün türünü değiştiremezsiniz ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Ürün sayfasındaki Fiyatlar uygulamasının kısayolu';

  @override
  String get prices_app_button => 'Fiyatlar uygulamasına gidin';

  @override
  String get prices_website_button => 'Açık Fiyatlar web sitesinde açık';

  @override
  String get prices_bulk_proof_upload_select =>
      'Fiyat etiketlerini doğrudan galeriden ekleyin';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Resimlerinizi seçtikten sonra onları düzenleyemezsiniz!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'Yapay zeka kanıtlarınız üzerinde çalışarak fiyatları çıkaracak.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Yapay zeka tarafından çıkarılan fiyatların topluluk tarafından doğrulanmasına izin verin.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Birden Fazla Fiyat Etiketi';

  @override
  String get prices_bulk_proof_upload_title => 'Toplu Kanıt Yüklemesi';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Dosyaları seçme';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Yükleme başlatılıyor';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return '#$index/${count}dosyası yerel olarak kopyalanıyor';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Yükleme hazırlanıyor #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return '#$index/${count}görüntüsünde başarısız oldu';
  }

  @override
  String get prices_generic_title => 'Fiyatlar';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fiyat ekleyin',
      one: 'Bir fiyat ekleyin',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fiyatlarını gönder',
      one: 'Fiyatı gönder',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Bir öge ekle';

  @override
  String get prices_add_a_price => 'Fiyat ekleyin';

  @override
  String get prices_add_a_receipt => 'Bir makbuz ekle';

  @override
  String get prices_add_price_tags => 'Fiyat etiketleri ekle';

  @override
  String prices_barcode_already(String barcode) {
    return 'Bu barkod ($barcode) zaten listede!';
  }

  @override
  String get prices_barcode_search_not_found => 'Ürün bulunamadı';

  @override
  String get prices_barcode_search_none_yet => 'Henüz ürün yok';

  @override
  String prices_barcode_search_running(String barcode) {
    return '$barcode aranıyor';
  }

  @override
  String get prices_barcode_enter => 'Barkodu girin';

  @override
  String get prices_category_enter => 'Barkodsuz ürün';

  @override
  String get prices_per_kilogram => 'Kilogram başına fiyat';

  @override
  String get prices_per_unit => 'Birim fiyat';

  @override
  String get prices_per_kilogram_short => ' / kilogram';

  @override
  String get prices_per_unit_short => ' / birim';

  @override
  String get prices_category_mandatory => 'Mecburi';

  @override
  String get prices_category_optional => 'İsteğe bağlı';

  @override
  String get prices_category_error_mandatory => 'Kategori zorunludur';

  @override
  String get prices_barcode_reader_action => 'Barkod okuyucu';

  @override
  String get prices_view_prices => 'Fiyatları görüntüle';

  @override
  String get prices_list_title => 'Fiyat listesi';

  @override
  String get prices_list_count => '\nfiyat sayısı';

  @override
  String get prices_list_add_new_price => '\nyeni bir fiyat ekle';

  @override
  String get prices_list_empty_title => 'Henüz fiyat yok!';

  @override
  String get prices_list_empty_subtitle =>
      'İlk siz ekleyin:\nBir **fiş** veya **fiyat etiketi** tarayarak!';

  @override
  String get prices_entry_shop_not_found => 'Bilinmeyen mağaza';

  @override
  String prices_entry_menu_title(String user) {
    return 'Fiyat girişi \"$user\" \'dan';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Bu ürünün tüm fiyatlarını görüntüle';

  @override
  String get prices_entry_menu_open_proof => 'Kanıtı görüntüle';

  @override
  String get prices_entry_menu_my_prices => 'Diğer fiyatlarımı görüntüle';

  @override
  String get prices_entry_menu_author_prices =>
      'Yazarın diğer fiyatlarını görüntüle';

  @override
  String get prices_entry_menu_shop_prices =>
      'Mağazadaki diğer fiyatları görün';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fiyatlar',
      one: '1 fiyat',
    );
    return '$_temp0 için $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tüm $count fiyatları',
      one: 'Sadece bir fiyat',
      zero: 'Henüz fiyat yok',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Son $pageSize fiyatları (toplam: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Fiyat: $price / Mağaza: \"$location\" / $date tarihinde \"$user\" tarafından yayınlandı';
  }

  @override
  String prices_open_user_proofs(String user) {
    return '\"$user\" ın açık kanıtları';
  }

  @override
  String get prices_open_proof => 'Açık fiyat kanıtı';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tüm $count kanıtlar',
      one: 'Sadece bir kanıt',
      zero: 'Henüz kanıt yok',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Son $pageSize kanıt (toplam: $total)';
  }

  @override
  String get prices_users_empty_title => 'Henüz katkıda bulunan yok!';

  @override
  String get prices_users_empty_explanation => 'İlk fiyatı siz ekleyin!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'En çok katkıda bulunan $pageSize kişi (toplam: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Henüz mağaza yok!';

  @override
  String get prices_locations_empty_explanation => 'İlk fiyatı siz ekleyin!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'En iyi $pageSize konum (toplam: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kanıt',
      one: 'Bir kanıt',
      zero: 'Kanıt yok',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ürün',
      one: 'Bir ürün',
      zero: 'Ürün yok',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kullanıcı',
      one: 'Bir kullanıcı',
      zero: 'Kullanıcı yok',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count fiyatlar',
      one: 'Tek fiyat',
      zero: 'Fiyat yok',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Fiyat daha önce eklendi';

  @override
  String get prices_amount_subtitle => 'Miktar';

  @override
  String get prices_amount_is_discounted => 'İndirimli mi?';

  @override
  String get prices_amount_price_normal => 'Fiyat';

  @override
  String get prices_amount_price_discounted => 'İndirimli fiyat';

  @override
  String get prices_amount_price_not_discounted => 'Orjinal fiyat';

  @override
  String get prices_amount_no_product => 'Bir ürün eksik!';

  @override
  String get prices_amount_price_incorrect => 'Yanlış değer';

  @override
  String get prices_amount_price_mandatory => 'Zorunlu değer';

  @override
  String get prices_currency_subtitle => 'Kur';

  @override
  String get prices_date_subtitle => 'Tarih';

  @override
  String get prices_location_subtitle => 'Mağaza';

  @override
  String get prices_location_find => 'Bir mağaza bul';

  @override
  String get prices_location_mandatory => 'Bir mağaza seçmeniz gerekiyor!';

  @override
  String get prices_location_search_broader =>
      'Aradığınızı bulamadınız mı? Daha kapsamlı bir arama yapalım!';

  @override
  String get prices_proof_subtitle => 'Kanıt';

  @override
  String get prices_proof_empty_title => 'Henüz bir kanıt yok!';

  @override
  String get prices_proof_empty_explanation =>
      'Öncelikle bir **fiş** veya **fiyat etiketi** fotoğrafı ekleyerek başlayın!';

  @override
  String get prices_proof_find => 'Bedeli sil';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Makbuz';

  @override
  String get prices_proof_price_tag => 'Fiyat etiketi';

  @override
  String get prices_proof_mandatory => 'Bir bedel seçmeniz gerekiyor!';

  @override
  String get prices_add_validation_error => 'Doğrulama hatası';

  @override
  String get prices_privacy_warning_title => 'Gizlilik uyarısı';

  @override
  String get prices_unknown_product => 'Bilinmeyen ürün';

  @override
  String get prices_privacy_warning_main_message =>
      'Fiyatlar **kamuya açık olacak** ve bahsedilen mağaza da belirtilecek.\n\nBu, Open Food Facts takma adınızı bilen kişilerin şunları yapmasına olanak tanıyabilir:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Hangi bölgede yaşadığınızı tahmin etmek';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Ne satın aldığınızı bilmek';

  @override
  String get prices_privacy_warning_sub_message =>
      'Eğer bu durumdan rahatsızsanız lütfen takma adınızı değiştirin veya yeni bir Open Food Facts hesabı oluşturup uygulamaya bu hesapla giriş yapın.';

  @override
  String get i_refuse => 'Reddediyorum';

  @override
  String get i_accept => 'Kabul ediyorum';

  @override
  String get prices_currency_change_proposal_title => 'Para birimini değiştir?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Mevcut para biriminiz **$currency**. Bunu **$newCurrency** olarak değiştirmek ister misiniz?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Evet, ${newCurrency}kullanın';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Hayır, $currency\'ı tut';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Yapıldı';

  @override
  String get dev_mode_section_server => 'Sunucu yapılandırması';

  @override
  String get dev_mode_section_news => 'Haber sağlayıcı yapılandırması';

  @override
  String get dev_mode_section_product_page => 'Ürün sayfası';

  @override
  String get dev_mode_section_ui => 'Kullanıcı Arayüzü';

  @override
  String get dev_mode_section_experimental_features => 'Deneysel özellikler';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Green-Score\'u hariç tut';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'OCR ekranları için bir yazım denetleyicisi kullanın';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(İçindekiler ve ambalaj)';

  @override
  String get dev_mode_reset_app_language_title => 'Uygulama dilini sıfırla';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Kart ekle';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'prices.openfoodfacts.org (PROD) ve test ortamı arasında geçiş yapın';

  @override
  String get search_history_item_edit_tooltip =>
      'Bu aramayı yeniden kullan ve düzenle';

  @override
  String get search_history_item_remove_tooltip => 'Kaldır';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Tüm $totalSize ürünleri indirdiniz.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return '$count ürün daha indir\n$totalSize üründen $downloaded tanesi indirildi.';
  }

  @override
  String product_search_loading_message(Object search) {
    return '$search aramanız devam ediyor.\n\nLütfen birkaç saniye bekleyin…';
  }

  @override
  String get user_search_contributor_title => 'Eklediğim Ürünler';

  @override
  String get user_search_informer_title => 'Düzenlediğim ürünler';

  @override
  String get user_search_photographer_title => 'Fotoğrafını çektiğim ürünler';

  @override
  String get user_search_to_be_completed_title => 'Tamamlanacak ürünlerim';

  @override
  String get user_search_prices_title => 'Fiyatlarım';

  @override
  String get user_search_proofs_title => 'Bedellerim';

  @override
  String get user_search_proof_title => 'Kanıtım';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Katkıda bulunanların fiyatları: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Son Fiyatlar eklendi';

  @override
  String get all_search_prices_top_user_title =>
      'En çok fiyat katkısı sağlayanlar';

  @override
  String get all_search_prices_top_location_title =>
      'En çok fiyatı olan mağazalar';

  @override
  String get prices_contribution_assistant => 'Fiyat Katkı Asistanı';

  @override
  String get prices_validation_assistant => 'Fiyat Doğrulama Asistanı';

  @override
  String get prices_challenges_page => 'Meydan Okumalar';

  @override
  String get prices_multiple_proof_addition_system => 'Birden Fazla Kanıt Ekle';

  @override
  String get all_search_prices_top_location_single_title =>
      'Mağazadaki fiyatlar';

  @override
  String get all_search_prices_top_product_title =>
      'En çok fiyatı olan ürünler';

  @override
  String get all_search_to_be_completed_title => 'Tamamlanacak tüm ürünler';

  @override
  String get categorize_products_country_title =>
      'Ülkenizdeki ürünleri kategorilere ayırmamıza yardımcı olun';

  @override
  String get edit_product_action_retake_picture => 'Yeniden çek';

  @override
  String get edit_product_action_take_picture => 'Fotoğraf çek';

  @override
  String get edit_product_action_confirm => 'Onayla';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Open Food Facts\'i kabul ediyorum ';

  @override
  String get signup_page_terms_of_use_line2 => 'kullanım ve katılım koşulları';

  @override
  String get analytics_consent_image_semantic_label => 'Analitik simgesi';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Önemli Hata: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Önemli Hata: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Temel bilgileri tamamlayın';

  @override
  String get edit_photo_button_label => 'Düzenle';

  @override
  String get edit_photo_unselect_button_label => 'Fotoğrafın seçimini kaldır';

  @override
  String get edit_photo_select_existing_button_label =>
      'Mevcut bir resmi seçin';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Üzerine tıklayarak bir resim seçin';

  @override
  String get edit_photo_select_existing_download_label =>
      'Mevcut görüntüler alınıyor…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Bu ürünle ilgili daha önce yüklenmiş görsel bulunmamaktadır.';

  @override
  String get edit_photo_language_not_this_one => 'Henüz o dilde resim yok';

  @override
  String get edit_photo_language_none => 'Henüz resim yok';

  @override
  String get category_picker_screen_title => 'Kategoriler';

  @override
  String get basic_details => 'Temel bilgiler';

  @override
  String get product_name => 'Ürün adı';

  @override
  String get product_names => 'Ürün Adları';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Yeni bir çeviri ekle';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Doğrulamadan önce lütfen yalnızca **ambalaj üzerinde dil mevcutsa** bir çeviri eklediğinizden emin olun';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Ön fotoğrafı görüntüle';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Önden fotoğraf çekin';

  @override
  String get add_basic_details_product_name_hint =>
      'Ürünün adını girin (örneğin: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Varsayılan dili değiştirmek ister misiniz?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Ürünün varsayılan dilinin \'$language\' olarak ayarlanmasını ister misiniz?';
  }

  @override
  String get explanation_section_good_examples => 'İyi örnekler';

  @override
  String get explanation_section_bad_examples => 'Kötü örnekler';

  @override
  String get add_basic_details_product_name_help_title =>
      'İyi uygulamalar: Ürün adı';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Ürün adı, **ambalaj üzerinde basılı olan ana isimdir**. Tescilli bir marka olabilir.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Not:** Ambalaj üzerinde dil mevcut değilse lütfen çeviri eklemeyin.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 => 'Ketçap';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Markayı isme dahil etmeyin';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketçap **Heinz\'den**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      '®, ™, © veya benzeri sembolleri kullanmayın';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count diğer çeviriler',
      one: '$count diğer çeviriler',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Marka adı';

  @override
  String get brand_names => 'Marka isimleri';

  @override
  String get add_basic_details_brand_name_error => 'Lütfen marka adını girin';

  @override
  String get add_basic_details_brand_names_hint =>
      'Marka girin (örneğin: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'İyi uygulamalar: Markalar';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      '**Ürünün tüm markalarını** girin.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Ana marka';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Genellikle ön pakette açıkça gösterilen **ana marka**, **önce girilmelidir**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Diğer markalar';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      '**Büyük bir şirket tarafından** satıldığında:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel**, **Danone** tarafından satılmaktadır';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Markası **birden fazla dile çevrilmiş** olarak satıldığında:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** bazen **Val Nature** olarak yazılır';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Miktar ve ağırlık';

  @override
  String get add_basic_details_quantity_hint =>
      'Ağırlığı ve gerekiyorsa miktarı girin (örneğin: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'İyi uygulamalar: Miktar';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Ürün üzerinde belirtilen değeri kopyalayın ve **birimleri unutmayın**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** veya **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (6 yumurta için)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(her biri 150g olan 3 kutulu bir ürün için)';

  @override
  String get barcode => 'Barkod';

  @override
  String barcode_barcode(String barcode) {
    return 'Barkod: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Geçersiz barkod';

  @override
  String get basic_details_add_success => 'Temel ayrıntılar başarıyla eklendi';

  @override
  String get basic_details_add_error =>
      'Temel detaylar eklenemiyor. Lütfen bir süre sonra tekrar deneyin';

  @override
  String get clear_search => 'Aramanızı temizleyin';

  @override
  String get confirm_clear =>
      'Tüm geçmişinizi temizlemek üzeresiniz: devam etmek istediğinizden emin misiniz?';

  @override
  String get alert_clear_selected_user_list =>
      'Geçmişinizdeki seçili öğeleri silmek üzeresiniz';

  @override
  String get confirm_clear_selected_user_list =>
      'Devam etmek istediğinize emin misiniz?';

  @override
  String get alert_select_items_to_clear =>
      'Lütfen temizlemek için bir veya daha fazla öğe seçin';

  @override
  String confirm_clear_user_list(String name) {
    return 'Bu listeyi temizlemek üzeresiniz ($name): devam etmek istediğinizden emin misiniz?';
  }

  @override
  String get confirm_delete_user_list_title => 'Liste silinsin mi?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Bu listeyi silmek üzeresiniz: $name. Devam etmek istediğinizden emin misiniz?';
  }

  @override
  String get confirm_delete_user_list_button => 'Evet, onaylıyorum';

  @override
  String importance_label(String name, String id) {
    return '$name önemi: $id';
  }

  @override
  String get user_list_all_title => 'Listeler';

  @override
  String get user_list_all_empty => 'İlk listenizi oluşturun';

  @override
  String get product_list_select => 'Bir liste seçin';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ürün',
      zero: 'Liste boş',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Liste ekle';

  @override
  String get open_food_preferences_tooltip => 'Yemek tercihlerinizi düzenleyin';

  @override
  String get add_photo_button_label => 'Fotoğraf ekle';

  @override
  String get add_packaging_photo_button_label =>
      'Herhangi bir ambalaj/geri dönüşüm bilgisinin fotoğrafını çekin';

  @override
  String get add_origin_photo_button_label =>
      'Herhangi bir menşe bilgisinin fotoğrafını çekin';

  @override
  String get add_emb_photo_button_label =>
      'İzlenebilirlik kodu bilgilerinin fotoğraflarını çekin';

  @override
  String get add_label_photo_button_label =>
      'Tüm etiket ve sertifika bilgilerinin fotoğrafını çekin';

  @override
  String get choose_image_source_title => 'Görüntü kaynağını seçin';

  @override
  String get choose_image_source_body => 'Lütfen bir resim kaynağı seçin';

  @override
  String get gallery_source_label => 'Galeri';

  @override
  String get gallery_source_access_denied_dialog_title => 'Erişim reddedildi';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Ne yazık ki, daha önce izin vermediğiniz için uygulama galerinize erişemiyor.\n\nLütfen telefonunuzun Ayarlar -> Fotoğraflar kısmından uygulama ayarlarına gidin';

  @override
  String get gallery_source_access_denied_dialog_button => 'Ayarları Aç';

  @override
  String get share => 'Paylaş';

  @override
  String share_product_text(String url) {
    return 'Open Food Facts\'teki bu ürüne bir göz atın: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Open Beauty Facts\'te bu ürüne bir göz atın: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Bu ürüne Open PetFood\'da bir göz atın. Bilgiler: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Bu ürüne Open Products Facts\'te bir göz atın. Bilgiler: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Open Food Facts\'teki ürün listeme bir göz atın: $url';
  }

  @override
  String get capture => 'Yeni Yakala';

  @override
  String get capture_new_picture => 'Resim çek';

  @override
  String get choose_from_gallery => 'Galeriden seç';

  @override
  String get image_upload_queued =>
      'Resim en kısa sürede arka planda yüklenecektir.';

  @override
  String get add_price_queued =>
      'Fiyat en kısa sürede sunucuya gönderilecektir.';

  @override
  String get background_task_title_full_refresh =>
      'Yerel olarak depolanan tüm ürünlerin yenilenmesinin başlatılması';

  @override
  String get background_task_title_top_n =>
      'En popüler ürünlerin indirilmesinin başlatılması';

  @override
  String get expand_nutrition_facts =>
      'Beslenme değerleri tablosunu genişletin';

  @override
  String get expand_nutrition_facts_body =>
      'Beslenme değerleri tablosunu genişletin';

  @override
  String get expand_ingredients => 'Malzemeleri genişlet';

  @override
  String get expand_ingredients_body =>
      'Malzemeler panelini genişletilmiş tutun';

  @override
  String get no_internet_connection => 'İnternet bağlantısı yok';

  @override
  String get world_results_label => 'Tüm dünya';

  @override
  String get world_results_action => 'Aramanızı dünyaya genişletin';

  @override
  String get copy_to_clipboard => 'Kopyala';

  @override
  String get paste_from_clipboard => 'Panodan yapıştır';

  @override
  String get no_data_available_in_clipboard => 'Panonuzda veri yok';

  @override
  String get clipboard_barcode_copy => 'Barkodu panoya kopyala';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Barkod $barcode panoya kopyalandı!';
  }

  @override
  String get open_product_website => 'Bu ürünü web sitesinde açın';

  @override
  String get language_picker_label => 'Diliniz';

  @override
  String get country_picker_label => 'Ülkeniz';

  @override
  String get currency_picker_label => 'Para biriminiz';

  @override
  String get help_with_openfoodfacts => 'OpenFoodFacts ile Yardım';

  @override
  String get product_task_background_schedule =>
      'Ürün en kısa sürede arka planda güncellenecektir.';

  @override
  String get no_email_client_available_dialog_title =>
      'E-posta uygulaması yok!';

  @override
  String get no_email_client_available_dialog_content =>
      'Lütfen bize mobile@openfoodfacts.org adresine manuel olarak bir e-posta gönderin';

  @override
  String get all_images => 'Tüm Resimler';

  @override
  String get selected_images => 'Seçilmiş Resimler';

  @override
  String get product_card_remove_product_tooltip => 'Ürünü kaldır';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Taranan yeni barkod: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Karuselden tüm ürünleri kaldır';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Lütfen karşılaştırmak için en az iki ürünü tarayın';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Taradığınız ürünleri karşılaştırmak için tıklayın';

  @override
  String get scan_product_loading => 'Barkodu\ntaradınız:';

  @override
  String get scan_product_loading_initial =>
      'Bu ürünü arıyoruz!\nLütfen birkaç saniye bekleyin…';

  @override
  String get scan_product_loading_long_request =>
      'Hala bu ürünü arıyoruz!\nYüklemenin uzun sürdüğünü düşünüyor musunuz? Biz de…';

  @override
  String get scan_product_loading_unresponsive =>
      'Hala bu ürünü arıyoruz.\nAramayı yeniden başlatmak ister misiniz?';

  @override
  String get scan_product_loading_restart_button => 'Aramayı yeniden başlat';

  @override
  String get portion_calculator_description =>
      'Belirli bir miktar için besin değerlerini hesaplayın';

  @override
  String get portion_calculator_hint => 'Miktar';

  @override
  String get portion_calculator_accessibility =>
      'Besin değerlerini hesaplamak için bir miktar girin';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Lütfen $min ile $max g arasında bir değer giriniz';
  }

  @override
  String get portion_calculator_computation_error =>
      'Veriler eksik. Hesaplama gerçekleştirilemedi.';

  @override
  String portion_calculator_result_title(int grams) {
    return '$grams g (veya ml) için besin değerleri';
  }

  @override
  String get offline_data => 'Çevrimdışı Veri';

  @override
  String get ocr_image_upload_instruction =>
      'İçerdiği bilgileri otomatik olarak çıkarmak için bir resim yükleyin.';

  @override
  String get upload_image => 'Fotoğraf Yükle';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Resim indirilemedi';

  @override
  String get image_edit_url_error =>
      'Resim URL\'si ayarlanmadığından resim düzenlenemedi.';

  @override
  String get user_picture_source_remember => 'Seçimimi hatırla';

  @override
  String get user_picture_source_ask => 'Her zaman sor';

  @override
  String get robotoff_continue => 'Devam et';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count questions',
      one: 'question',
    );
    return 'Sonraki $_temp0';
  }

  @override
  String get show_password => 'Şifreyi Göster';

  @override
  String get owner_field_info_title => 'Üretici tarafından sağlanan değerler';

  @override
  String get owner_field_info_message =>
      'Bu logo ile üreticinin sağladığı ve düzenlenemeyen veriler olduğunu belirtiyoruz.';

  @override
  String get owner_field_info_close_button => 'Bu bilgiyi kapat';

  @override
  String get owner_field_image =>
      'Bu görsel yapımcı tarafından sağlanmıştır. Düzenlenemez.';

  @override
  String get edit_packagings_title => 'Ambalaj bileşenleri';

  @override
  String get edit_packagings_element_add => 'Bir paketleme bileşeni ekleyin';

  @override
  String get edit_packagings_completed => 'Paketleme tamamlandı';

  @override
  String edit_packagings_element_title(int index) {
    return 'Paketleme bileşeni #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Birim sayısı';

  @override
  String get edit_packagings_element_hint_units =>
      'Üründe bulunan aynı şekil ve malzemeye sahip ambalaj birimlerinin sayısını girin.';

  @override
  String get edit_packagings_element_field_shape => 'Şekil';

  @override
  String get edit_packagings_element_hint_shape =>
      'Varsa, geri dönüşüm talimatlarında listelenen şeklin adını girin veya bir şekil seçin.';

  @override
  String get edit_packagings_element_example_shape => 'Şişe';

  @override
  String get edit_packagings_element_field_material => 'Malzeme';

  @override
  String get edit_packagings_element_hint_material =>
      'Belirlenebiliyorsa belirli bir malzemeyi (bir üçgen içindeki bir malzeme kodu genellikle ambalaj parçalarında bulunur) veya emin değilseniz genel bir malzemeyi (örneğin plastik veya metal) girin.';

  @override
  String get edit_packagings_element_example_material => 'Cam';

  @override
  String get edit_packagings_element_field_recycling => 'Geri dönüşüm talimatı';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Yalnızca ürün üzerinde listeleniyorsa geri dönüşüm talimatlarını girin.';

  @override
  String get edit_packagings_element_example_recycling => 'Geri dönüşüm';

  @override
  String get edit_packagings_element_field_quantity =>
      'Birim başına net ürün miktarı';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Net ağırlığı veya net hacmi girin ve birimi belirtin (örneğin g veya ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Bir boş birimin ağırlığı (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Kalan yiyecekleri çıkarın ve tartmadan önce ambalaj parçasını yıkayın ve kurulayın. Mümkünse 0,1g veya 0,01g hassasiyetli bir terazi kullanın.';

  @override
  String get background_task_title => 'Bekleyen katkılar';

  @override
  String get background_task_subtitle =>
      'Katkılarınız otomatik olarak sunucumuza kaydedilir, ancak her zaman gerçek zamanlı olarak kaydedilmez.';

  @override
  String get background_task_list_empty => 'Bekleyen Arka Plan Görevi Yok';

  @override
  String get background_task_error_server_time_out => 'Sunucu zaman aşımı';

  @override
  String get background_task_error_no_internet =>
      'İnternet bağlantısı hatası. Daha sonra tekrar deneyin.';

  @override
  String get background_task_operation_unknown => 'bilinmeyen işlem türü';

  @override
  String get background_task_operation_details => 'ayrıntılı değişiklikler';

  @override
  String get background_task_operation_image => 'fotoğraf yükleme';

  @override
  String get background_task_operation_refresh =>
      'fotoğraf yüklendikten sonra yenileme ertelendi';

  @override
  String get background_task_run_started => 'başladı';

  @override
  String get background_task_run_not_started => 'henüz başlamadı';

  @override
  String get background_task_run_to_be_deleted => 'silinecek';

  @override
  String get background_task_question_stop =>
      'Bu görevi en kısa sürede durdurmak istiyor musunuz?';

  @override
  String get feed_back => 'Geri bildirim';

  @override
  String get undo => 'Geri al';

  @override
  String get copy_email_to_clip_board => 'E-postayı panoya kopyala';

  @override
  String get please_send_us_an_email_to =>
      'Lütfen bize manuel olarak şu adrese bir e-posta gönderin';

  @override
  String get email_copied_to_clip_board => 'E-posta panoya kopyalandı!';

  @override
  String get select_accent_color => 'Vurgu Rengini Seçin';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Mavi';

  @override
  String get color_cyan => 'Cam göbeği';

  @override
  String get color_green => 'Yeşil';

  @override
  String get color_light_brown => 'Varsayılan';

  @override
  String get color_magenta => 'Eflatun';

  @override
  String get color_orange => 'Turuncu';

  @override
  String get color_pink => 'Pembe';

  @override
  String get color_red => 'Kırmızı';

  @override
  String get color_rust => 'Pas rengi';

  @override
  String get color_teal => 'Deniz Mavisi';

  @override
  String get text_contrast_mode => 'Metin Kontrastı';

  @override
  String get contrast_high => 'Yüksek';

  @override
  String get contrast_medium => 'Orta';

  @override
  String get contrast_low => 'Düşük';

  @override
  String get product_refresher_internet_not_found => 'Ürün bulunamadı!';

  @override
  String get product_refresher_internet_not_connected =>
      'İnternete bağlı değilsiniz!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Sunucu kapalı ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Sunucu hatası ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Ürün bulunamadı!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Aşağıdaki barkoda sahip bir ürün veritabanımızda yok: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'İnternet bağlantısı yok!';

  @override
  String get product_loader_network_error_message =>
      'Lütfen akıllı telefonunuzun bir Wi-Fi ağına bağlı olduğundan veya mobil verinin etkinleştirildiğinden emin olun';

  @override
  String get page_not_found_title => 'Sayfa bulunamadı!';

  @override
  String get page_not_found_button => 'Ana sayfaya geri dön';

  @override
  String get download_data => 'Verileri indir';

  @override
  String get download_top_products =>
      'Anında tarama ile ülkenizdeki en iyi 1000 ürünü indirin';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ürünü',
    );
    return 'Ülkenizde en çok kullanılan $_temp0 hızla taramak için indirin';
  }

  @override
  String get download_in_progress =>
      'Veri indiriliyor\nBu biraz zaman alabilir';

  @override
  String downloaded_products(int num) {
    return '$num ürün eklendi';
  }

  @override
  String get update_offline_data => 'Çevrimdışı ürün verilerini güncelleyin';

  @override
  String get update_local_database_sub =>
      'Yerel ürün veritabanını OpenFoodFacts\'in en son verileriyle güncelleyin';

  @override
  String get clear_local_database => 'Çevrimdışı ürün verilerini temizle';

  @override
  String get clear_local_database_sub =>
      'Yer açmak için uygulamanızdaki tüm yerel ürün verilerini temizleyin';

  @override
  String deleted_products(int num) {
    return '$num ürün silindi';
  }

  @override
  String get loading => 'Yükleniyor…';

  @override
  String get know_more => 'Daha Fazla Bilgi Edinin';

  @override
  String get offline_data_desc =>
      'Çevrimdışı veriler hakkında daha fazla bilgi edinmek için tıklayın';

  @override
  String get offline_product_data_title => 'Çevrimdışı ürün verileri';

  @override
  String available_for_download(int num) {
    return 'Anında tarama için $num ürün mevcut';
  }

  @override
  String get country_selector_title => 'Ülkenizi seçin:';

  @override
  String get currency_selector_title => 'Para biriminizi seçin:';

  @override
  String get language_selector_title => 'Dilinizi seçiniz:';

  @override
  String get language_selector_section_selected => 'Seçilen diller';

  @override
  String get language_selector_section_frequently_used => 'Sıklıkla kullanılan';

  @override
  String get action_delete_list => 'Sil';

  @override
  String get action_change_list => 'Mevcut listeyi değiştir';

  @override
  String get product_list_create => 'Oluştur';

  @override
  String get product_list_create_tooltip => 'Yeni bir liste oluştur';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Yeni hesaplama)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Yeni hesaplama)';

  @override
  String get nutriscore_unknown => 'Bilinmeyen Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Bilinmeyen Nutri-Score (Yeni hesaplama)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score geçerli değildir';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score geçerli değildir (Yeni hesaplama)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Yeşil Puan A';

  @override
  String get environmental_score_b_new => 'Yeşil Puan B';

  @override
  String get environmental_score_c_new => 'Yeşil Puan C';

  @override
  String get environmental_score_d_new => 'Yeşil Puan D';

  @override
  String get environmental_score_e_new => 'Yeşil Puan E';

  @override
  String get environmental_score_unknown_new => 'Bilinmeyen Yeşil Puan';

  @override
  String get environmental_score_not_applicable_new => 'Yeşil Puan uygulanamaz';

  @override
  String get nova_group_generic_new => 'Ultra işlenmiş gıdalar - NOVA grupları';

  @override
  String get nova_group_1 => 'NOVA Grup 1';

  @override
  String get nova_group_2 => 'NOVA Grup 2';

  @override
  String get nova_group_3 => 'NOVA Grup 3';

  @override
  String get nova_group_4 => 'NOVA Grup 4';

  @override
  String get nova_group_unknown => 'Bilinmeyen NOVA Grubu';

  @override
  String get nutrition_facts => 'Besin Düzeyleri';

  @override
  String get faq_title_partners => 'STK\'nın Ortakları ve Patronları';

  @override
  String get faq_title_vision =>
      'Open Food Facts Vizyon, Misyon, Değerler ve Programlar';

  @override
  String get faq_title_install_beauty =>
      'Bir kozmetik veritabanı oluşturmak için Open Beauty Facts\'i yükleyin';

  @override
  String get faq_title_install_pet =>
      'Bir evcil hayvan maması veri tabanı oluşturmak için Open Pet Food Facts\'i kurun';

  @override
  String get faq_title_install_product =>
      'Nesnelerin ömrünü uzatmak amacıyla bir ürün veritabanı oluşturmak için Open Products Facts\'i kurun';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nutri-Score\'un yeni hesaplaması: Neler yeni?';

  @override
  String get contact_title_pro_page =>
      'Profesyonel mi? Open Food Facts\'te ürünlerinizi içe aktarın';

  @override
  String get contact_title_pro_email => 'Üretici İletişim';

  @override
  String get contact_title_press_page => 'Basın Sayfası';

  @override
  String get contact_title_press_email => 'Basın İletişim';

  @override
  String get contact_title_newsletter => 'Haber bültenimize abone olun';

  @override
  String get contact_title_calendar => 'Topluluk takvimimize abone olun';

  @override
  String get hunger_games_loading_line1 =>
      'Lütfen bize birkaç saniye izin verin…';

  @override
  String get hunger_games_loading_line2 => 'Soruları indiriyoruz!';

  @override
  String get hunger_games_error_label =>
      'Ah! Bir şeyler ters gitti… ve soruları yükleyemedik.';

  @override
  String get hunger_games_error_retry_button => 'Tekrar deneyelim!';

  @override
  String get reorder_attribute_action => 'Öznitelikleri yeniden sırala';

  @override
  String get link_cant_be_opened =>
      'Bu bağlantı cihazınızda açılamıyor. Lütfen tarayıcınızın kurulu olup olmadığını kontrol edin.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return '$productName için ayrıntılar';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return '$pageName ile ${productName}için ayrıntılar';
  }

  @override
  String get guide_title => 'Rehber';

  @override
  String get guide_share_label => 'Paylaş';

  @override
  String get guide_nutriscore_v2_title => 'Nutri-Score gelişiyor: açıklamalar!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Nutri-Score nedir?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score, **gıdaların besin kalitesi** hakkında sizi bilgilendirmeyi amaçlayan bir logodur.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Renk kodu, **en sağlıklı** ürünler için koyu yeşilden (**A**) **daha az sağlıklı** ürünler için koyu kırmızıya (**E**) kadar değişmektedir.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption => 'Nutri-Score A logosu';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Nutri-Score neden gelişiyor?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Nutri-Score formülü daha iyi öneriler sunmak için **gelişiyor**:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Tüm içecekleri daha iyi değerlendir';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Yeni algoritmada **süt**, **şeker ilaveli sütlü içecekler** ve **bitkisel** içeceklerin karşılaştırmalı notaları daha iyi ayırt edildi.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'İçeceklerin daha iyi sıralanması';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**Şeker içeriği** daha iyi hesaba katılır ve **az şekerli** içecekler tercih edilir.\\n**Tatlandırıcılar da cezalandırılacak**: Diyet sodaların derecesi B\'den C ile E arasına düşürülecek. Su, önerilen içecek olmaya devam ediyor.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Tuz ve şeker cezalandırıldı';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      '**Çok tatlı** veya **çok tuzlu** olan ürünlerin **puanı daha da düşürülecektir**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Yağlar ve balıklar arasında hiyerarşi';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Bazı **yağlı balıkların** ve **iyi yağlardan zengin yağların** derecelendirmesi artacaktır.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Kırmızı eti sınırlayın';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      '**Kırmızı et tüketimi sınırlandırılmalıdır**. Bu nedenle **kümes hayvanları** nispeten daha iyi bir sıralamaya sahip olacaktır.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Eski Nutri-Score ile yeni hesaplama nasıl ayırt edilir?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Artık logoda, bunun gerçekten yeni bir hesaplama olduğunu belirtmek için \"**Yeni hesaplama**\" ifadesi yer alabilir.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Yeni Nutri-Score\'un logosu';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Yeni Nutri-Score hesaplamasını nerede bulabilirim?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score 7 ülkede uygulanıyor: Fransa, Almanya, Belçika, İspanya, Lüksemburg, Hollanda ve İsviçre.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Üreticilerin, kararnamenin imzalanmasından itibaren en geç **2 yıl** içinde eski hesaplamayı yenisiyle **değiştirmeleri** için süreleri bulunuyor.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Üreticiler puanı güncellememiş olsa bile, beklemeden **OpenFoodFacts uygulamasında** yeni hesaplamayı bulabilirsiniz.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Değişmeyen şey nedir?';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score, **besin kalitesini ölçmek** için tasarlanmış bir puandır. **NOVA grubunun** **ultra işlenmiş gıdalar** (uygulamada da mevcuttur) konusundaki çalışmalarını **tamamlayıcı** niteliktedir.';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Üreticiler için Nutri-Score\'un görüntülenmesi **isteğe bağlı** kalmaktadır.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'Yeşil Puan Nedir?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Yeşil Puan, gıdanın **çevresel etkisi** hakkında sizi bilgilendirmeyi amaçlayan bir logodur.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Renk kodu, **en az etkili** ürünler için koyu yeşilden (**A+**) **en etkili** ürünler için koyu kırmızıya (**F**) kadar değişmektedir.';

  @override
  String get guide_greenscore_logos_caption => 'Yeşil Puan logoları';

  @override
  String get guide_greenscore_lca_title =>
      'Çekirdek: Yaşam döngüsü değerlendirmesi (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Gıda kategorilerinin bilimsel değerlendirmesi';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Her ürün kategorisi için, Agribalyse çevre veritabanından (ADEME ve INRAE tarafından tasarlanmıştır) alınan veriler kullanılarak bir **kıyaslama** puanı belirlenir.';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Yaşam döngüsü analizi** çok aşamalı ve çok kriterli çevresel değerlendirme yapmak için kullanılan standartlaştırılmış bir değerlendirme yöntemidir.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Ölçer:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 üretim adımı';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Tarım';

  @override
  String get guide_greenscore_lca_arg2_processing => 'İşleme';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Ambalaj';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Taşıma';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Dağıtım';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Tüketim';

  @override
  String get guide_greenscore_lca_arg3_title => '14 çevresel etki göstergesi';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'İklim değişikliği/karbon ayak izi';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Ozon tabakasının incelmesi';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'İyonlaştırıcı radyasyon';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Kara';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Su ve enerji kullanımı';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Hava kirliliği';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Deniz ve tatlı su (partiküller, asitlenme, ötrofikasyon)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Kaynakların tükenmesi.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonuslar ve cezalar';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Üretim modu';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Malzemelerin kaynağı';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Nesli tükenmekte olan türler';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Ambalaj';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Çevresel etkileri daha iyi ölçmek ve azaltmak için artan şeffaflık ihtiyacı';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Üreticiler nasıl yardımcı olabilir?';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Üreticiler bilgilerini doğrudan üreticilere özel ücretsiz platformumuz üzerinden bize gönderebilirler.';

  @override
  String get guide_greenscore_better_product_title =>
      'Hangi ürün gezegenimiz için daha iyidir?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Söylemesi zor olabilir';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Sürdürülebilir gıda seçimi, iklim için yapabileceğimiz en etkili şeylerden biridir, çünkü **küresel gıda sistemimiz tüm sera gazı emisyonlarının dörtte birinden fazlasından sorumludur**.\n(Kaynak: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Güç sende!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'İyi haber şu ki, bu bize değişim yaratmanın güçlü bir yolunu sunuyor.\n**Her birimiz her yıl yaklaşık 1.000 öğün yemek yiyoruz**. Bu, **gezegenimiz için daha iyi bir gelecek** seçmek için 1.000 fırsat demek!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Sorumlu olmayı ve karar vermeyi kolaylaştırır';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Sürdürülebilir gıda seçmek karmaşık gelebilir. Etiketler kafa karıştırıcıdır ve bilgiler genellikle eksiktir. Green-Score, gıda ürünleri için **net**, **bilime dayalı** ve **şeffaf** bir çevre derecelendirmesini, tam da ihtiyacınız olan yerde, yani alışveriş yaparken sunmak için oluşturuldu.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Şeffaflık';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Tescilli etiketlerin aksine, Yeşil Puan hesaplaması **tamamen açıktır** ve **herkes tarafından doğrulanabilir**.';

  @override
  String get guide_nova_title => 'Aşırı işlenmiş gıdalar';

  @override
  String get guide_nova_what_is_nova_title => 'Ultra-işleme nedir?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'The NOVA groups inform you about **the level of food processing**.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'NOVA sınıflandırması, gıdaların **endüstriyel işleme derecesine** göre **4 gruba** ayrılmasına olanak tanır (asgari işlenmiş veya işlenmemiş gıdalar, mutfak malzemeleri, işlenmiş gıdalar, ultra işlenmiş gıdalar).';

  @override
  String get guide_nova_logos_caption => 'NOVA logoları';

  @override
  String get guide_nova_groups_title => '4 NOVA grubu';

  @override
  String get guide_nova_groups_intro =>
      '4 adet NOVA grubu var, sorunlu olanı ise Grup 4 - Ultra işlenmiş gıdalar.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimum işlenmiş veya işlenmemiş gıdalar';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'İşlenmiş yemek malzemeleri';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from Group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'İşlenmiş gıdalar';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to Group 1** foods. Processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. Most processed foods have two or three ingredients and are recognizable as modified versions of Group 1 foods. They can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Aşırı işlenmiş gıdalar';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact Group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. However, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. Some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Ultra işlemeyle ilgili sorunlar';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Gıda bileşenlerinin aşırı işlenmesi';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Saf gıda güvenliğinin ötesine geçen katkı maddeleri';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Evde yapamayacağınız işlemler';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Ultra işleme sürecinin yırtıcı ve finansal yönleri';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-tr.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-tr.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-tr.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-tr.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Şu anda barkod düzeyinde ürün fiyatlarına ilişkin büyük veri tabanlarına sahip çok az şirket bulunmaktadır. Bu fiyatlar serbestçe erişilebilir olmayıp, bunları karşılayabilen özel sektör aktörlerine, araştırmacılara ve diğer kuruluşlara yüksek bir fiyattan satılmaktadır.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'Ben bir perakendeciyim ve fiyatlara katkıda bulunmak istiyorum. Bunu nasıl yapabilirim?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-tr.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Ön izleme';

  @override
  String get prices_feedback_form =>
      'Bu yeni özellik hakkında bize geri bildiriminizi göndermek için buraya tıklayın!';

  @override
  String get menu_button_list_actions => 'Bir eylem seçin';

  @override
  String get error_loading_photo => 'Fotoğraf yüklenirken hata oluştu';

  @override
  String get photo_viewer_action_use_picture_as => '…olarak kullanın';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Bu resmi…olarak kullan';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Bu resmi… ($language) olarak kullanın';
  }

  @override
  String get photo_viewer_details_button => 'Ayrıntılar';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Bu fotoğrafın detayları';

  @override
  String get photo_viewer_details_title => 'Fotoğrafın detayları';

  @override
  String get photo_viewer_details_contributor_title => 'Katkı sağlayan';

  @override
  String get photo_viewer_details_size_title => 'Boyut';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height piksel';
  }

  @override
  String get photo_viewer_details_date_title => 'Tarih';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Uyumlu';

  @override
  String get user_lists_action_multi_select => 'Çoklu seçim';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Uyumluluk puanınız: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Ön resim';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Malzemelerin resmi';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Besin değerleri fotoğrafı';

  @override
  String get product_image_packaging_accessibility_label => 'Ambalaj fotoğrafı';

  @override
  String get product_image_other_accessibility_label => 'Diğer resim';

  @override
  String get product_image_outdated_message =>
      'Bu resim güncelliğini yitirmiş olabilir';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (bu görsel güncelliğini yitirmiş olabilir)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (bu görüntü yapımcı tarafından eklenip değişime kapatılmış olabilir)';
  }

  @override
  String get product_image_error => 'Resim yüklenemedi!';

  @override
  String product_image_error_accessibility_label(String type) {
    return '$type yüklenemedi (ağ hatası?)';
  }

  @override
  String get product_page_image_no_image_available => 'Görüntü\nyok!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Bu ürün için resim mevcut değil';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Eylemleri yeniden sırala veya gizle';

  @override
  String get product_page_action_bar_setting_modal_title => 'Eylemleri düzenle';

  @override
  String get product_page_action_bar_item_move_up => 'Yukarı git';

  @override
  String get product_page_action_bar_item_move_down => 'Aşağı in';

  @override
  String get product_page_action_bar_item_enable => 'Eylemi etkinleştir';

  @override
  String get product_page_action_bar_item_disable => 'Eylemi devre dışı bırak';

  @override
  String get product_page_pending_operations_banner_title =>
      'Düzenlemeleriniz yükleniyor…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Bu sayfada görüntülenen veriler **henüz değişikliklerinizi yansıtmıyor**.\nLütfen birkaç saniye bekleyin…';

  @override
  String get product_add_a_language => 'Dil ekleyin';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Barkod $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Bu ürünü döngüden kaldır';

  @override
  String get carousel_unsupported_header => 'Desteklenmeyen barkod!';

  @override
  String get carousel_unsupported_title => 'Hay aksi!';

  @override
  String get carousel_unsupported_text =>
      'Taranan barkod Open Food Facts tarafından desteklenmiyor!';

  @override
  String get carousel_error_header => 'Hata!';

  @override
  String get carousel_error_title => 'Çok yazık!';

  @override
  String get carousel_error_text_1 =>
      'Bu barkodla ilgili bilgileri indiremedik:';

  @override
  String get carousel_error_text_2 =>
      'Lütfen internet bağlantınızı kontrol edin veya şu butona tıklayın:';

  @override
  String get carousel_error_button => 'Tekrar dene';

  @override
  String get carousel_unknown_product_header => 'Bilinmeyen ürün';

  @override
  String get carousel_unknown_product_title =>
      'Tebrikler!\n__Nadir mücevheri buldunuz!__';

  @override
  String get carousel_unknown_product_text =>
      'Ortak veritabanımız **3 milyondan fazla** ürünü içeriyor, ancak bu barkod mevcut değil: ';

  @override
  String get carousel_unknown_product_button => 'Bu ürünü ekle';

  @override
  String get carousel_loading_header => 'Bilgiler yükleniyor...';

  @override
  String get carousel_loading_title =>
      'Aşağıdaki barkoda sahip bir ürünü taradınız:';

  @override
  String get carousel_loading_text =>
      '**3 milyondan fazla üründen oluşan veritabanımızda bunu arıyoruz!**';

  @override
  String get product_type_subtitle_food =>
      'Sebzeler, meyveler, dondurulmuş gıdalar…';

  @override
  String get product_type_subtitle_beauty =>
      'Makyaj malzemeleri, sabunlar, diş macunları…';

  @override
  String get product_type_subtitle_pet_food => 'Köpekler ve kediler için mama…';

  @override
  String get product_type_subtitle_product => 'Akıllı telefonlar, mobilyalar…';

  @override
  String get photo_field_front => 'Ürün fotoğrafı';

  @override
  String get photo_field_ingredients => 'İçindekiler fotoğarafı';

  @override
  String get photo_field_nutrition => 'Beslenme fotoğrafı';

  @override
  String get photo_field_packaging => 'Paketleme bilgileri fotoğrafı';

  @override
  String get photo_already_exists => 'Bu fotoğraf zaten mevcut';

  @override
  String get photo_missing => 'Bu fotoğraf eksik';

  @override
  String get date => 'Tarih';

  @override
  String get photo_rotate_left => 'Sola döndür';

  @override
  String get photo_rotate_right => 'Sağa döndür';

  @override
  String get photo_undo_action => 'Önceki eylemi geri al';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return '$location\'nın dünya haritası';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap\'e katkıda bulunanlar';

  @override
  String get not_applicable_short => 'Mevcut değil';

  @override
  String get knowledge_panel_warning_text => 'Uyarı';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Bu Nutri-Score neden paket üzerindekinden farklı?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'İki olası açıklama var:\nİçerik listesi ve/veya besin değerleri güncel değil.\n\nNutri-Score (veya V2) için \"Yeni hesaplama\" özelliğini sunuyoruz. Lütfen paket üzerinde \"Yeni hesaplama\" etiketinin bulunduğundan emin olun.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'İçerikleri kontrol edin';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Besin değerlerini kontrol edin';

  @override
  String url_not_supported(String url) {
    return 'Maalesef şu URL\'yi açamıyoruz:\n$url';
  }

  @override
  String get product_list_export => 'Dışa Aktar';

  @override
  String get product_list_import => 'İçe aktar';

  @override
  String get product_footer_action_barcode => 'Barkodu görüntüle';

  @override
  String get product_footer_action_barcode_short => 'Barkod';

  @override
  String get product_footer_action_open_website => 'Web sitesini aç';

  @override
  String get product_footer_action_report => 'Bildir';

  @override
  String get product_footer_action_contributor_guide => 'Yardım';

  @override
  String get product_footer_action_data_quality_tags => 'Veri kalitesi';

  @override
  String get product_page_tab_for_me => 'Benim için';

  @override
  String get product_page_tab_website => 'Web sitesi';

  @override
  String get product_page_tab_prices => 'Fiyatlar';

  @override
  String get prices_explanation_card_title => 'Neden fiyatlar?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices**, dünya genelindeki ürünlerin fiyatlarını toplayıp paylaşmayı amaçlayan bir projedir 🌍. Open Prices, Open Food Facts tarafından geliştirilip yönetilmektedir.';

  @override
  String get explanation_card_learn_more_button => 'Daha fazla bilgi edin';

  @override
  String get product_page_tab_folksonomy => 'Halkbilimi';

  @override
  String get folksonomy_explanation_card_title =>
      'Folksonominin nitelikleri nelerdir?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Nitelikler **anahtar-değer** tabanlıdır.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Bu özellikler, katkıda bulunanlar tarafından her türlü kullanım için oluşturulup dosyalanır.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Fiyat mevcut değil';

  @override
  String get prices_products_empty_explanation =>
      'İlk katkıda bulunan siz olun!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'En iyi $pageSize ürün (toplam: $total)';
  }

  @override
  String get app_review_title => 'Bu uygulamayı beğeniyor musunuz?';

  @override
  String get app_review_low => 'Daha iyisi yapılabilir';

  @override
  String get app_review_medium => 'Kötü değil';

  @override
  String get app_review_high => 'Bayıldım!';

  @override
  String get app_review_feedback_modal_title =>
      'Uygulamamızı geliştirmemize yardımcı olun';

  @override
  String get app_review_feedback_modal_content =>
      'Birkaç dakikanız varsa, **gelecekteki güncellemelerde iyileştirme yapabilmemiz** için bu formu yanıtlayabilir misiniz?';

  @override
  String get app_review_feedback_modal_open_form => 'Formu cevaplayın';

  @override
  String get app_review_feedback_modal_later => 'Daha sonra sor';

  @override
  String get nutrition_facts_extract_new =>
      'YENİ: Resimdeki besin değerlerini otomatik olarak aktarabilirsiniz!';

  @override
  String get nutrition_facts_extract_button_text => 'Şimdi aktar';

  @override
  String get nutrition_facts_extract_in_progress =>
      'Çıkarma işlemi devam ediyor…';

  @override
  String get nutrition_facts_extract_successful => 'Çıkarma başarılı';

  @override
  String get nutrition_facts_extract_failed =>
      'Resimden besin maddeleri aktarılamadı';

  @override
  String get prices_discount => 'İndirim';

  @override
  String get prices_stats_statistics => 'İstatistikler';

  @override
  String get prices_stats_title => 'Fiyat İstatistikleri';

  @override
  String get prices_stats_prices_section => 'Fiyatlar';

  @override
  String get prices_stats_products_section => 'Ürünler';

  @override
  String get prices_stats_locations_section => 'Konumlar';

  @override
  String get prices_stats_proofs_section => 'Kanıtlar';

  @override
  String get prices_stats_contributors_section => 'Katkıda bulunanlar';

  @override
  String get prices_stats_experiments_section => 'Deneyler';

  @override
  String get prices_stats_misc_section => 'Çeşitli';

  @override
  String get prices_stats_total => 'Toplam';

  @override
  String get prices_stats_with_barcode => 'Barkod ile';

  @override
  String get prices_stats_with_category => 'Bir kategori ile';

  @override
  String get prices_stats_with_discount => 'İndirimli';

  @override
  String get prices_stats_community => 'Topluluk';

  @override
  String get prices_stats_consumption => 'Tüketim';

  @override
  String get prices_stats_with_price => 'Bir fiyat ile';

  @override
  String get prices_stats_food => 'Gıda';

  @override
  String get prices_stats_beauty => 'Güzellik';

  @override
  String get prices_stats_products => 'Ürünler';

  @override
  String get prices_stats_pet_food => 'Evcil hayvan maması';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Çevrimiçi';

  @override
  String get prices_stats_countries => 'Ülkeler';

  @override
  String get prices_stats_price_tag => 'Fiyat etiketi';

  @override
  String get prices_stats_receipt => 'Makbuz';

  @override
  String get prices_stats_gdpr_request => 'GDPR talebi';

  @override
  String get prices_stats_shop_import => 'Mağaza aktarımı';

  @override
  String get prices_stats_challenges => 'Meydan Okumalar';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Fiyat etiketine bağlı fiyatlar';

  @override
  String get prices_stats_currencies => 'Para birimleri';

  @override
  String get prices_stats_years => 'Yıllar';

  @override
  String get prices_stats_by_source_title =>
      'Kaynak başına fiyatlar ve kanıtlar';

  @override
  String get prices_stats_website => 'Web sitesi';

  @override
  String get prices_stats_mobile_app => 'Mobil uygulama';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Diğer';

  @override
  String get prices_stats_last_updated => 'Son güncelleme tarihi';

  @override
  String get prices_stats_error => 'İstatistikler yüklenirken bir hata oluştu.';

  @override
  String get product_edit_robotoff_question_answered => 'Soru cevaplandı!';

  @override
  String get product_edit_robotoff_proof => 'Kanıt';

  @override
  String get preferences_card_general => 'Genel';

  @override
  String get preferences_prices_title => 'Fiyatlar';

  @override
  String get preferences_prices_subtitle => 'Fiyat tercihlerinizi yönetin';

  @override
  String get preferences_card_project => 'Açık Gıda Gerçekleri projesi';

  @override
  String get preferences_contribute_title => 'Destekleyebilirsiniz';

  @override
  String get preferences_my_contributions_title => 'Katkıda Bulunduklarım';

  @override
  String get preferences_my_stats_title => 'İstatistiklerim';

  @override
  String get preferences_contribute_subtitle =>
      'Çeviri yapın, araçlarımızı geliştirin…';

  @override
  String get preferences_connect_title => 'Bağlamak';

  @override
  String get preferences_connect_subtitle =>
      'Bize ulaşın veya sosyal medyada bizi takip edin';

  @override
  String get preferences_support_title => 'Bağışta bulunun';

  @override
  String get preferences_support_subtitle =>
      'Dünya çapında milyonlarca tüketiciyi bilgilendirmemize yardımcı olun';

  @override
  String get preferences_card_help => 'Yardım ve Destek';

  @override
  String get preferences_faq_title => 'SSS';

  @override
  String get preferences_faq_subtitle => 'Sorularınızın yanıtlarını alın';

  @override
  String get logged_out => 'Oturum kapatıldı';

  @override
  String get preferences_app_bar_message =>
      'Üyelerimizden biri olduğunuz için teşekkür ederiz!';

  @override
  String get preferences_app_bar_products_modified => 'Ürünler değiştirildi';

  @override
  String get preferences_app_bar_prices_added => 'Fiyatlar eklendi';

  @override
  String get preferences_app_bar_see_all_stats => 'Tüm istatistikleri görün';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return '$provider \'da \"$keyword\" için arama yapın';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Bir ayar arayın (örneğin Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Erişilebilirlik: Emojiyi göster';

  @override
  String get preferences_accessibility_remove_colors =>
      'Erişilebilirlik: Renkleri kaldır';

  @override
  String get preferences_app_settings_products => 'Ürünler';

  @override
  String get preferences_card_about => 'Hakkında';

  @override
  String get preferences_legal_information_title => 'Yasal bilgiler';

  @override
  String get preferences_legal_information_subtitle =>
      'Kullanım koşulları, gizlilik politikası ve daha fazlası';

  @override
  String get preferences_terms_of_use => 'Kullanım Koşulları';

  @override
  String get preferences_legal_mentions => 'Hukuki konular';

  @override
  String get preferences_legal_header =>
      'Open Food Facts, **herkes tarafından, herkes için** hazırlanmış bir gıda ürünleri veritabanıdır.\nDaha iyi gıda seçimleri yapmak için kullanabilirsiniz ve **açık veri** olduğu için herkes **herhangi bir amaç için yeniden kullanabilir**.';

  @override
  String get preferences_privacy_policy => 'Gizlilik politikası';

  @override
  String get preferences_licenses => 'Lisanslar';

  @override
  String get preferences_about_app_title => 'Uygulama hakkında';

  @override
  String get preferences_about_app_subtitle =>
      'Teknik bilgiler, geliştirici bilgileri ve daha fazlası';

  @override
  String get preferences_card_information => 'Bilgi';

  @override
  String get preferences_version_number_title => 'Sürüm numarası';

  @override
  String get preferences_scanner_title => 'Tarayıcı';

  @override
  String get preferences_app_store => 'Uygulama mağazası';

  @override
  String get preferences_app_system_settings => 'Sistem ayarları';

  @override
  String get preferences_source_code => 'Kaynak koduna erişin';

  @override
  String get preferences_source_code_subtitle =>
      'Ve milyonlarca kişi için etki yaratmaya başlayın';

  @override
  String get preferences_add_prices => 'Fiyatları ekle';

  @override
  String get preferences_complete_products => 'Dünyaya anlat';

  @override
  String get preferences_tips => 'İpuçları';

  @override
  String get tips_discover_nutriscore => 'Yeni Nutri-Score\'u keşfedin';

  @override
  String get preferences_on_off_website_subtitle =>
      'Açık Gıda Bilgileri web sitesinde';

  @override
  String get preferences_manage_account_title => 'Hesabımı yönet';

  @override
  String get preferences_manage_account_tooltip => 'Hesabınızı yönetin';

  @override
  String get preferences_change_password_title => 'Şifremi değiştir';

  @override
  String get preferences_danger_zone => 'Tehlikeli bölge';

  @override
  String get preferences_account_deletion_subtitle =>
      'Tüm katkılarınız kaybolacak';

  @override
  String get preferences_contributions_title => 'Katkıda Bulunulanlar';

  @override
  String get preferences_dev_mode_app_settings_title => 'Uygulama ayarları';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Ürünleri çevrimdışı taramak için oldukça deneysel bir yol';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Sunucudaki tüm ürünleri yenile';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Kesinlikle gerekli olmadıkça lütfen bunu yapmaktan kaçının';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demo modu';

  @override
  String get preferences_dev_mode_add_cards_title => 'Kartları tarayıcıya ekle';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Tarayıcıya 3 numune ürün ekler';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Folksonomi sunucusu';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Sunucu: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Erişilebilirlik deneyleri';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Fiyatlar için çoklu ürün seçimi';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Kullanıcı tarafından sipariş edilen bilgi panelleri';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Konum aramasına geçici erişim';

  @override
  String get preferences_dev_mode_comparison_title =>
      '2 veya 3 ürün için yan yana karşılaştırma';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Ürün listesi içe aktarımı';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Puanlar ve metodolojiler';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Nutri-Score\'un nasıl hesaplandığını keşfedin';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Metodolojideki temel değişiklikleri keşfedin';

  @override
  String get preferences_faq_discover_project_title => 'Projeyi keşfedin';

  @override
  String get preferences_faq_discover_off_title =>
      'Açık Gıda Gerçeklerini Keşfedin';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'SSS - Sıkça Sorulan Sorular';

  @override
  String get preferences_faq_off_ngo_title => 'Açık Gıda Gerçekleri STK\'sı';

  @override
  String get preferences_about_information_title => 'Bilgi';

  @override
  String get preferences_connect_community_updates_title =>
      'Topluluk güncellemelerini alın';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Uygulama ve topluluk haberleriyle güncel kalın';

  @override
  String get preferences_connect_community_calendar_title =>
      'Topluluk takvimimize abone olun';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Sanal etkinliklerimizden birine katılarak dahil olun';

  @override
  String get preferences_connect_blog_title => 'Açık Gıda Gerçekleri blogu';

  @override
  String get preferences_connect_blog_subtitle =>
      'En son haberleri, olaylar yaşandıkça alın';

  @override
  String get preferences_connect_community_help_title =>
      'Topluluktan yardım alın';

  @override
  String get preferences_connect_improve_app_title =>
      'Uygulamayı geliştirmemize yardımcı olun';

  @override
  String get preferences_connect_debug_info_title =>
      'Hata ayıklama bilgilerini bize gönderin';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Ayrıntılı hata ayıklama bilgileri içeren bir e-postayı bize gönderin';

  @override
  String get preferences_connect_feedback_title =>
      'Uygulama hakkında bize geri bildirim gönderin';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Uygulamanın geleceğini şekillendirmeye yardımcı olun';

  @override
  String get preferences_connect_survey_title => 'Uygulama anketine katılın';

  @override
  String get preferences_connect_survey_subtitle =>
      'Sırada ne inşa etmemiz gerektiğini anlamamıza yardımcı olun';

  @override
  String get preferences_connect_professionals_title => 'Profesyoneller';

  @override
  String get preferences_connect_pro_subtitle =>
      'Tamamen ücretsiz, 500 uygulama ve milyonlarca tüketici için doğru verileri garanti eder. Self servis, PIM\'iniz veya elektronik tablolarınızla (XLSX) uyumludur.';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Başlamak için iletişime geçin';

  @override
  String get preferences_connect_press_title => 'Basın';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Raporunuz için ihtiyacınız olan tüm materyali edinin';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Basın soruları için veya raporunuz hakkında bize bilgi vermek için bizimle iletişime geçin';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Aktif bir gönüllü olun';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Gelişim, İletişim, Tasarım… her türlü gönüllülük veya uzmanlık memnuniyetle karşılanır!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Katkıda bulunabileceğiniz birçok yoldan bazılarını keşfedin';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobil uygulama geliştirme';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Yazılım geliştirmeye nasıl katkıda bulunacağınızı öğrenin';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Günlük dengesiz yapılar, yepyeni özellikler';

  @override
  String get preferences_contribute_local_community_title =>
      'Yerel topluluğunuzu büyütün';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Yazılım, içerik, bileşen analizi çevirilerinde yardım';

  @override
  String get preferences_contribute_share_subtitle =>
      'Size yardımcı olması için küçük bir şablon hazırladık :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Ülkenizde gıda şeffaflığını artırmak için basit adımlar';

  @override
  String get preferences_contribute_data_quality_title => 'Veri kalitesi';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Veri kalitesi ekibine katılın';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Veritabanının eksiksiz ve doğru olmasını sağlamak için çabalarımıza katılın';

  @override
  String get preferences_contributions_products_added_title =>
      'Eklenen ürünler';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Açık Gıda Bilgilerine eklediğim yeni ürünler';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Tamamlamam gereken ürünler';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Tüm eksik ürünler';

  @override
  String get preferences_my_contributions_prices_title => 'Fiyatlar';

  @override
  String get preferences_my_contributions_my_prices_title => 'Fiyatlarım';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Fiyatlarım, delillerim…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Tamamlamanıza yardımcı olabileceğiniz ürünler';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ülkenizdeki Nutri-Score ve Green-Score\'un hesaplanmasına yardımcı olun';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Katkıda bulunduğum fiyatlar';

  @override
  String get preferences_prices_proofs_subtitle => 'Fiyat etiketleri ve fişler';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Fişlerinizin fotoğraflarını çekin ve ilgili barkodları tarayın';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Bir mağazadaki fiyatların fotoğraflarını çekin';

  @override
  String get preferences_prices_newest_title => 'En yeni fiyatlar';

  @override
  String get preferences_prices_newest_subtitle =>
      'Open Prices topluluğu tarafından eklenen en son fiyatlar';

  @override
  String get preferences_prices_top_contributors_title =>
      'En çok fiyat veren katılımcılar';

  @override
  String get preferences_prices_metrics_title => 'Açık Fiyat metrikleri';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Projenin gelişimini takip edin';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Katkıda bulunmanın yolları';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Yapay zekanın yardımıyla kendiniz veya başkaları tarafından eklenen fiyatları onaylayın';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Kamera rulosundan çok sayıda fiş veya raf fotoğrafını hızla ekleyin';

  @override
  String get preferences_prices_challenges_title => 'Aylık zorluklar';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Ödülleri toplamak için aylık tematik görevlere katılın';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Sadakat verilerinizi geri alın';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Verilerinizi nasıl talep edeceğinizi öğrenin';

  @override
  String get preferences_page_customize_app_title => 'Uygulamayı özelleştirin';

  @override
  String get preferences_page_contribute_project_title =>
      'Projeye katkıda bulunun';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Open Food Factsne yardımcı olmanın basit yolları';

  @override
  String get preferences_page_faq_subtitle =>
      'Puanlama metodolojileri, yardım ve proje hakkında daha fazlası';

  @override
  String get product_edit_robotoff_positive_button => 'Öneriyi kabul et';

  @override
  String get product_edit_robotoff_negative_button => 'Öneriyi reddet';

  @override
  String get product_edit_robotoff_show_proof => 'Kanıt göster';

  @override
  String get product_edit_robotoff_expand_proof => 'Kanıtı genişlet';

  @override
  String get product_page_tab_raw_data => 'Ham veriler';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Sayfa $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Sayfa $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count / $total öğe';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count / $total öğe';
  }

  @override
  String item_count(int count) {
    return '$count ürün';
  }

  @override
  String item_count_string(String count) {
    return '$count ürün';
  }

  @override
  String get prices_no_result => 'Fiyat istatistiği bulunamadı.';

  @override
  String get prices_error_loading_more_items =>
      'Daha fazla öğe yüklenirken hata oluştu';

  @override
  String get prices_proof_error =>
      'Kimlik doğrulama başarısız oldu, kanıtlar alınamadı';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count / $total kanıt';
  }

  @override
  String proof_count(int count) {
    return '$count bedel';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count / $total katılımcı';
  }

  @override
  String contributors_count(int count) {
    return '$count katkıda bulunan';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count / $total konum';
  }

  @override
  String prices_locations_count(int count) {
    return '$count konum';
  }

  @override
  String get restart_to_apply_message =>
      'Değişikliklerin geçerli olması için lütfen uygulamayı yeniden başlatın.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafiksel arayüz';

  @override
  String get preferences_app_settings_media_title => 'Medya';

  @override
  String get preferences_about_app_development_title => 'Yazılım Geliştirme';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Açık Gıda Bilgileri Laboratuvarları';

  @override
  String get preferences_root_account_title => 'Hesap';

  @override
  String get preferences_contribute_translate_header =>
      'Açık Gıda Gerçeklerini kendi dilinize getirin';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Uygulamanın alfa sürümüne kaydolun';

  @override
  String get preferences_dev_mode_section_data => 'Katkılar ve Ürün verileri';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Folksonomiyi göstermeyin';

  @override
  String get preferences_account_title => 'Hesap';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return '${created}tarihinde eklendi';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'İsim';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
