// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Romanian Moldavian Moldovan (`ro`).
class AppLocalizationsRo extends AppLocalizations {
  AppLocalizationsRo([String locale = 'ro']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Da';

  @override
  String get add => 'Adaugă';

  @override
  String get account_delete_message =>
      'Sigur doriți să vă ștergeți contul?\nDacă există un motiv specific, vă rugăm să distribuiți mai jos';

  @override
  String get reason => 'Motiv';

  @override
  String get okay => 'Bine';

  @override
  String get validate => 'Validați';

  @override
  String get create => 'Crează';

  @override
  String get applyButtonText => 'Aplică';

  @override
  String get next_label => 'Următoarea';

  @override
  String get continue_label => 'Continuați';

  @override
  String get exit_label => 'Ieșire';

  @override
  String get previous_label => 'Anterior';

  @override
  String get go_back_to_top => 'Înapoi sus';

  @override
  String get save => 'Salvează';

  @override
  String get save_confirmation => 'Sunteți sigur că doriți să salvați?';

  @override
  String get skip => 'Omitere';

  @override
  String get cancel => 'Anulare';

  @override
  String get ignore => 'Ignoră';

  @override
  String get close => 'Închidere';

  @override
  String get no => 'Nu';

  @override
  String get stop => 'Oprește';

  @override
  String get finish => 'Terminare';

  @override
  String get calculate => 'Calculează';

  @override
  String get reset_food_prefs => 'Resetați preferințele alimentare';

  @override
  String get error => 'Ceva nu a funcţionat corect';

  @override
  String get error_occurred => 'A intervenit o eroare';

  @override
  String get featureInProgress =>
      'Încă lucrăm la această funcție, rămâneți pe fază';

  @override
  String get label_web => 'Vizualizați-l pe web';

  @override
  String get learnMore => 'Afla mai mult';

  @override
  String get unknown => 'Necunoscut';

  @override
  String get match_very_good => 'Potrivire foarte bună';

  @override
  String get match_good => 'Potrivire bună';

  @override
  String get match_poor => 'Potrivire slabă';

  @override
  String get match_may_not => 'Nu se potrivește';

  @override
  String get match_does_not => 'Nu se potrivește';

  @override
  String get match_unknown => 'Potrivire necunoscută';

  @override
  String get match_short_very_good => 'Potrivire foarte bună';

  @override
  String get match_short_good => 'Potrivire bună';

  @override
  String get match_short_poor => 'Potrivire slabă';

  @override
  String get match_short_may_not => 'Nu se potrivește';

  @override
  String get match_short_does_not => 'Nu se potrivește';

  @override
  String get match_short_unknown => 'Potrivire necunoscută';

  @override
  String get licenses => 'Licențe';

  @override
  String get looking_for => 'Se caută pentru';

  @override
  String get welcomeToOpenFoodFacts => 'Bun venit la OpenFoodFacts';

  @override
  String get whatIsOff =>
      'Open Food Facts este o organizație non-profit globală susținută de comunitățile locale.';

  @override
  String get productDataUtility =>
      'Vedeți datele despre alimente relevante pentru preferințele dvs.';

  @override
  String get healthCardUtility => 'Alege alimente care sunt bune pentru tine.';

  @override
  String get ecoCardUtility => 'Alege alimente care sunt bune pentru planetă.';

  @override
  String get server_error_open_new_issue =>
      'Niciun răspuns al serverului! Puteți deschide o problemă cu următorul link.';

  @override
  String get sign_in_text =>
      'Conectați-vă la contul Open Food Facts pentru a vă salva contribuțiile';

  @override
  String get incorrect_credentials =>
      'Numele de utilizator sau parola incorectă.';

  @override
  String get password_lost_incorrect_credentials =>
      'Acest e-mail sau nume de utilizator nu există. Vă rugăm să vă verificați acreditările.';

  @override
  String get password_lost_server_unavailable =>
      'În prezent, întâmpinăm încetiniri pe serverele noastre și ne cerem scuze pentru asta. Vă rugăm să încercați din nou mai târziu.';

  @override
  String get login => 'Nume de utilizator';

  @override
  String get login_result_type_server_unreachable =>
      'Rețeaua nu este accesibilă';

  @override
  String get login_result_type_server_issue =>
      'Problemă la server. Te rugăm să încerci mai târziu.';

  @override
  String get login_page_username_or_email =>
      'Vă rugăm să introduceți numele de utilizator sau adresa de e-mail';

  @override
  String get login_page_password_error_empty =>
      'Vă rugăm să introduceți o parolă';

  @override
  String get create_account => 'Creați cont';

  @override
  String get sign_in => 'Conectare';

  @override
  String get sign_in_mandatory =>
      'Pentru această funcție este nevoie să vă conectați.';

  @override
  String get help_improve_country =>
      'Contribuiți la îmbunătățirea Open Food Facts în țara dumneavoastră';

  @override
  String get sign_out => 'Deconectare';

  @override
  String get sign_out_confirmation => 'Sigur doriți să vă deconectați?';

  @override
  String get password => 'Parolă';

  @override
  String get forgot_password => 'Ați uitat parola';

  @override
  String get forgot_password_question => 'Aţi uitat parola?';

  @override
  String get view_profile => 'Vizualizați profilul';

  @override
  String get reset_password => 'Resetare parolă';

  @override
  String get reset_password_explanation_text =>
      'În cazul în care ați uitat parola, introduceți numele de utilizator sau adresa de e-mail pentru a primi instrucțiuni pentru resetarea parolei. De asemenea, nu uitați să verificați folderul Spam.';

  @override
  String get username_or_email => 'Nume de utilizator sau email';

  @override
  String get reset_password_done =>
      'Un e-mail cu un link pentru resetarea parolei v-a fost trimis la adresa de e-mail asociată contului dumneavoastră. De asemenea, verificați spam-ul';

  @override
  String get send_reset_password_mail => 'Schimbați parola';

  @override
  String get enter_some_text => 'Vă rugăm introduceți text';

  @override
  String get sign_up_page_title => 'Înregistrare';

  @override
  String get sign_up_page_action_button => 'Înregistrare';

  @override
  String get sign_up_page_action_doing_it => 'Înregistrare…';

  @override
  String get sign_up_page_action_ok =>
      'Felicitări! Contul dvs. tocmai a fost creat.';

  @override
  String get sign_up_page_display_name_hint => 'Nume';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Vă rugăm să introduceți numele afișat pe care doriți să îl utilizați';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mailul este necesar';

  @override
  String get sign_up_page_email_error_invalid => 'E-mail invalid';

  @override
  String get sign_up_page_username_hint => 'Nume de utilizator: vizibil public';

  @override
  String get sign_up_page_username_error_empty =>
      'Vă rugăm să introduceți un nume de utilizator';

  @override
  String get sign_up_page_username_error_invalid =>
      'Vă rugăm să introduceți un nume de utilizator valid';

  @override
  String get sign_up_page_username_description =>
      'Numele de utilizator nu poate conține spații, majuscule sau caractere speciale.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Numele de utilizator nu poate depăși $value caractere';
  }

  @override
  String get sign_up_page_password_hint => 'Parolă';

  @override
  String get sign_up_page_password_error_empty =>
      'Vă rugăm să introduceți o parolă';

  @override
  String get sign_up_page_password_error_invalid =>
      'Vă rugăm să introduceți o parolă validă (cel puțin 6 caractere)';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirmați parola';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Vă rugăm să confirmați parola dvs';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Parolele nu se potrivesc';

  @override
  String get sign_up_page_agree_text => 'Sunt de acord cu Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'termeni de utilizare și contribuție';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'La crearea unui cont, acceptarea Termenilor de utilizare este obligatorie, cu toate acestea, contribuțiile anonime pot fi făcute în continuare prin intermediul aplicației';

  @override
  String get sign_up_page_producer_checkbox => 'Sunt un producător de alimente';

  @override
  String get sign_up_page_producer_hint => 'Producător/marcă';

  @override
  String get sign_up_page_producer_error_empty =>
      'Vă rugăm să introduceţi un producător sau un nume de marcă';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Aș dori să mă abonez la buletinul informativ Open Food Facts (vă puteți dezabona de la acesta oricând)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Numele de utilizator există deja, vă rugăm să alegeți un alt nume de utilizator.';

  @override
  String get sign_up_page_email_already_exists =>
      'există deja, conectați-vă la cont sau încercați cu un alt e-mail.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Vă rugăm să furnizați o adresă de e-mail validă.';

  @override
  String get sign_up_page_server_busy =>
      'Ne pare rău, avem unele dificultăți tehnice pentru a vă crea contul. Vă rugăm să încercați din nou mai târziu.';

  @override
  String get settingsTitle => 'Configurări';

  @override
  String get darkmode => 'Temă';

  @override
  String get darkmode_dark => 'Întunecat';

  @override
  String get darkmode_light => 'Luminos';

  @override
  String get darkmode_system_default => 'Setări implicite ale sistemului';

  @override
  String get thanks_for_contributing => 'Mulțumesc pentru contribuție!';

  @override
  String get contributors_label => 'Ei construiesc aplicația';

  @override
  String get contributors_dialog_title => 'Colaboratori';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Contributor: $name';
  }

  @override
  String get contributors_description =>
      'O listă cu toți contribuitorii acestei aplicații';

  @override
  String get support => 'Suport';

  @override
  String get support_join_slack => 'Solicitați ajutor pe canalul nostru Slack';

  @override
  String get support_via_forum => 'Cere ajutor pe forumul nostru';

  @override
  String get support_via_email => 'Trimiteți-ne un e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Trimiteți jurnalele aplicației?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Doriți să includeți jurnalele aplicației în atașamentul de la e-mailul dvs.?';

  @override
  String get termsOfUse => 'Condiții de utilizare';

  @override
  String get legalNotices => 'Mențiuni legale';

  @override
  String get privacy_policy => 'Politica de confidențialitate';

  @override
  String get about_this_app => 'Despre această aplicație';

  @override
  String get contribute => 'Contribuiți';

  @override
  String get contribute_sw_development => 'Dezvoltarea de software';

  @override
  String get contribute_develop_text =>
      'Codul pentru fiecare produs Open Food Facts este disponibil pe GitHub. Sunteți binevenit să-l reutilizați (este open source) și să ne ajutați să-l îmbunătățim, pentru toată lumea, pe toată planeta.';

  @override
  String get contribute_develop_text_2 =>
      'Vă puteți înscrie în sala de chat Open Food Facts Slack, care este modalitatea preferată de a pune întrebări.';

  @override
  String get contribute_develop_dev_mode_title => 'Modul DEV?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Activați modul DEV';

  @override
  String get contribute_donate_title => 'Donează';

  @override
  String get contribute_donate_header => 'Donează pentru Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Vă rugăm să rețineți că, în cazul versiunii alfa interne, este posibilă pierderea completă a datelor, iar aplicația poate deveni inutilizabilă în orice moment!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produse ce trebuie să fie finalizate';

  @override
  String get contribute_improve_header => 'Ameliorare';

  @override
  String get contribute_improve_text =>
      'Baza de date este nucleul proiectului. Este ușor și foarte rapid să ajutați. Puteți descărca aplicația mobilă pentru telefon și puteți începe să adăugați sau să îmbunătățiți produse.\n\nPe de altă parte, site-ul Open Food Facts oferă multe modalități de a contribui: ';

  @override
  String get contribute_translate_header => 'Tradu';

  @override
  String get contribute_data_quality => 'Calitatea datelor';

  @override
  String get contribute_translate_link_text => 'Începeți traducerea';

  @override
  String get contribute_translate_text =>
      'Open Food Facts este un proiect global, care conține produse din peste 160 de țări. Open Food Facts este tradus în zeci de limbi, cu conținut în continuă evoluție.';

  @override
  String get contribute_translate_text_2 =>
      'Traducerile sunt una dintre sarcinile cheie ale proiectului';

  @override
  String get contribute_join_skill_pool =>
      'Contribuiți cu abilitățile la Open Food Facts. Alăturați-vă grupului de abilități!';

  @override
  String get contribute_share_header =>
      'Distribuie Open Food Facts prietenilor tăi';

  @override
  String get contribute_share_content =>
      'Am vrut să vă anunț despre aplicația pe care am folosit-o, Open Food Facts, care vă permite să obțineți impactul asupra sănătății și asupra mediului al alimentelor dvs., într-un mod personalizat. Funcționează prin scanarea codurilor de bare de pe ambalaj. În sfârșit, este gratuit, nu necesită înregistrare și poți chiar contribui la creșterea numărului de produse descifrate. Iată linkul pentru a-l obține pentru telefonul tău: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribuiți cu prețurile solicitând un export GDPR al datelor cardurilor dvs. de fidelitate';

  @override
  String get tap_to_answer => 'Atingeți aici pentru a răspunde la întrebări';

  @override
  String get tap_to_answer_hint =>
      'Atingeți aici pentru a răspunde la întrebări despre acest produs';

  @override
  String get robotoff_questions_loading_hint =>
      'Vă rugăm să așteptați până când întrebările despre acest produs sunt încărcate';

  @override
  String get saving_answer => 'Se salvează răspunsul';

  @override
  String get contribute_to_get_rewards =>
      'Deveniți un actor al transparenței alimentare';

  @override
  String get question_sign_in_text =>
      'Conectați-vă la contul dvs. Open Food Facts pentru a obține credit pentru contribuțiile dvs';

  @override
  String get question_yes_button_accessibility_value => 'Raspunde cu da';

  @override
  String get question_no_button_accessibility_value => 'Raspunde cu nu';

  @override
  String get question_skip_button_accessibility_value =>
      'Sari peste această întrebare';

  @override
  String get tap_to_edit_search => 'Atingeți pentru a edita căutarea';

  @override
  String get myPreferences => 'Preferințe';

  @override
  String get account_create_message =>
      'Creați-vă contul și alăturați-vă comunității Open Food Facts pentru a ajuta la dezvoltarea cunoștințelor despre alimente în întreaga lume!';

  @override
  String get join_us => 'Alătură-te nouă';

  @override
  String get myPreferences_profile_title => 'Profilul tău';

  @override
  String get myPreferences_profile_subtitle =>
      'Gestionați contul dvs. de colaborator Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Setările aplicației';

  @override
  String get myPreferences_settings_subtitle => 'Mod întunecat, Limbi…';

  @override
  String get myPreferences_food_title => 'Preferințe alimentare';

  @override
  String get myPreferences_food_subtitle =>
      'Alegeți ce informații despre alimente contează cel mai mult pentru dvs.';

  @override
  String get myPreferences_food_comment =>
      'Alegeți ce informații despre alimente contează cel mai mult pentru dvs., pentru a clasifica alimentele în funcție de preferințele dvs., pentru a vedea mai întâi informațiile care vă interesează și pentru a obține un rezumat de compatibilitate. Aceste preferințe alimentare rămân pe dispozitivul dvs. și nu sunt asociate cu contul dvs. de colaborator Open Food Facts, dacă aveți unul.';

  @override
  String get confirmResetPreferences => 'Resetați preferințele alimentare?';

  @override
  String get myPersonalizedRanking => 'Clasamentul meu personalizat';

  @override
  String get ranking_tab_all => 'Toate';

  @override
  String get ranking_subtitle_match_yes => 'O bună potrivire pentru tine';

  @override
  String get ranking_subtitle_match_no => 'Potrivire foarte slabă';

  @override
  String get ranking_subtitle_match_maybe => 'Potrivire necunoscută';

  @override
  String get refresh_with_new_preferences =>
      'Reîmprospătați lista cu noile preferințe';

  @override
  String get reloaded_with_new_preferences => 'Reîncărcat cu noile preferințe';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Scanează';

  @override
  String get history_navbar_label => 'Istoric';

  @override
  String get list_navbar_label => 'Liste';

  @override
  String get category => 'Filtrare după categorie';

  @override
  String get category_all => 'Toate';

  @override
  String get category_search => '(căutare pe categorii)';

  @override
  String get filter => 'Filtrare';

  @override
  String get scan => 'Produse din ecranul de scanare';

  @override
  String get scan_history => 'Istoricul scanării';

  @override
  String get search => 'Caută';

  @override
  String get search_product_help =>
      'Căutați un produs,\no marcă sau un cod de bare';

  @override
  String get search_filter => 'Filtru de căutare';

  @override
  String get search_history => 'Istoricul căutărilor';

  @override
  String get search_store => 'Caută un magazin';

  @override
  String get search_store_help => 'Sugestie: adăugați orașul sau țara';

  @override
  String get tap_for_more => 'Atingeți pentru a vedea mai multe informații…';

  @override
  String get product => 'Produs';

  @override
  String get unknownBrand => 'Marcă necunoscută';

  @override
  String get unknownProductName => 'Produs cu nume necunoscut';

  @override
  String get label_refresh => 'Reîmprospătare';

  @override
  String get label_reload => 'Reîncărcare';

  @override
  String get image => 'Imagine';

  @override
  String get front_photo => 'Fotografie din față';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (această imagine poate fi învechită)';
  }

  @override
  String get outdated_image_short_label => 'poate fi învechit';

  @override
  String get ingredients => 'Ingrediente';

  @override
  String get ingredients_editing_instructions =>
      'Păstrați ordinea inițială. Indicați procentul atunci când este specificat. Separați prin virgulă sau cratimă și folosiți paranteze pentru ingredientele unui ingredient.';

  @override
  String get ingredients_editing_error =>
      'Salvarea ingredientelor nu a reușit.';

  @override
  String get ingredients_editing_image_error =>
      'Nu s-a putut obține o imagine nouă a ingredientelor.';

  @override
  String get ingredients_editing_title => 'Editați ingredientele';

  @override
  String get ingredients_photo => 'Foto ingrediente';

  @override
  String get packaging_editing_instructions =>
      'Enumerați toate părțile de ambalare separate prin virgulă sau (-), cu cantitatea lor (de exemplu 1 sau 6) tip (de exemplu sticla, cutie, cutie), material (de exemplu plastic, metal, aluminiu) și, dacă este disponibil, dimensiunea lor (de exemplu 33cl) și instrucțiuni de reciclare.';

  @override
  String get packaging_editing_error => 'Salvarea ambalajului nu a reușit.';

  @override
  String get packaging_editing_image_error =>
      'Obținerea unei imagini noi de ambalaj a eșuat.';

  @override
  String get packaging_editing_title => 'Editați ambalajul';

  @override
  String get nutrition => 'Informații nutriționale';

  @override
  String get nutrition_facts_photo => 'Foto cu informații nutriționale';

  @override
  String get nutrition_facts_editing_title =>
      'Editați informațiile nutriționale';

  @override
  String get packaging_information => 'Informații despre ambalaj';

  @override
  String get packaging_information_photo => 'Foto cu informații despre ambalaj';

  @override
  String get missing_product => 'Ai gasit un produs nou!';

  @override
  String get add_product_take_photos =>
      'Faceți fotografii ale ambalajului pentru a adăuga acest produs la Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Vă rugăm să faceți mai întâi câteva fotografii. Puteți completa întotdeauna produsul mai târziu.';

  @override
  String get add_product_information_button_label =>
      'Adăugați informații despre produs';

  @override
  String get new_product => 'Produs Nou';

  @override
  String get new_product_found_title => 'Produs nou găsit!';

  @override
  String get new_product_found_text =>
      'Baza noastră de date colaborativă conține peste **3 milioane de produse**, dar acest cod de bare nu există: ';

  @override
  String get new_product_found_button => 'Adaugă acest produs';

  @override
  String get new_product_leave_title => 'Părăsiți această pagină?';

  @override
  String get new_product_leave_message =>
      'Se pare că nu ai introdus nimic. Chiar vrei să părăsești această pagină?';

  @override
  String get new_product_dialog_description =>
      'Vă rugăm să faceți fotografii ale ambalajului pentru a adăuga acest produs în baza noastră de date comună.';

  @override
  String get new_product_dialog_illustration_description =>
      'O ilustrație cu Nutri-Score și Green Score necunoscute';

  @override
  String get front_packaging_photo_button_label =>
      'Fotografie din față a produsului';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirmați încărcarea fotografiei ambalajului frontal';

  @override
  String get confirm_button_label => 'Confirmați';

  @override
  String get send_image_button_label => 'Trimite imaginea';

  @override
  String get crop_page_action_saving => 'Se salvează imaginea…';

  @override
  String get crop_page_action_cropping => 'Decuparea imaginii…';

  @override
  String get crop_page_action_local => 'Salvarea unei versiuni locale…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oops… e ceva cu fotografia ta!';

  @override
  String get crop_page_action_local_failed_message =>
      'Nu putem procesa imaginea local, înainte de a o trimite pe serverul nostru. Vă rugăm să încercați din nou mai târziu sau să ne contactați dacă problema persistă.';

  @override
  String get crop_page_action_retake => 'Refaceți o fotografie';

  @override
  String get crop_page_too_small_image_title => 'Imaginea este prea mică!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Dimensiunea minimă în pixeli pentru încărcarea imaginii este ${expectedMinWidth}x$expectedMinHeight. Poza curentă este ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Pregătirea unui apel către server…';

  @override
  String get front_packaging_photo_title => 'Fotografie ambalaj frontal';

  @override
  String get ingredients_photo_title => 'Fotografie cu ingredientele';

  @override
  String get nutritional_facts_photo_title => 'Informații nutriționale Foto';

  @override
  String get recycling_photo_title => 'Imaginea cu metoda de reciclare';

  @override
  String get take_photo_title => 'Faceți o fotografie';

  @override
  String get take_more_photo_title => 'Faceți mai multe poze';

  @override
  String get front_photo_uploaded => 'Fotografia frontală a fost încărcată';

  @override
  String get ingredients_photo_button_label => 'Foto ingrediente';

  @override
  String get ingredients_photo_uploaded =>
      'Fotografia cu ingredientele încărcată';

  @override
  String get nutrition_cache_loading_error =>
      'Imposibil de încărcat nutrienții din cache';

  @override
  String get nutritional_facts_photo_button_label =>
      'Foto cu informații nutriționale';

  @override
  String get nutritional_facts_input_button_label =>
      'Completați informațiile nutriționale';

  @override
  String get nutritional_facts_added => 'Date nutriționale adăugate';

  @override
  String get categories_added => 'Categorii adăugate';

  @override
  String get new_product_title_nutriscore => 'Calculează Nutri-Score-ul';

  @override
  String get new_product_subtitle_nutriscore =>
      'Ajutați-ne completând cel puțin o categorie și valori nutriționale';

  @override
  String get new_product_title_environmental_score => 'Calculați scorul verde';

  @override
  String get new_product_subtitle_environmental_score =>
      'Obțineți-l completând cel puțin o categorie';

  @override
  String get new_product_additional_environmental_score =>
      'Faceți calculul Scorului Verde mai precis cu origini, ambalaje și multe altele';

  @override
  String get new_product_title_nova =>
      'Calculați nivelul de procesare a alimentelor (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Obțineți-l completând categoria de alimente și ingrediente';

  @override
  String get new_product_desc_nova_unknown =>
      'Nivel de procesare a alimentelor necunoscut';

  @override
  String get new_product_title_pictures => 'Produs nou';

  @override
  String get new_product_title_pictures_details =>
      'Vă rugăm să faceți următoarele fotografii și motorul Open Food Facts poate rezolva restul!';

  @override
  String get new_product_title_misc => 'Și câteva date de bază…';

  @override
  String new_product_done_msg(String username) {
    return 'Mulțumim pentru contribuția ta „$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Vă mulțumim pentru contribuție!';

  @override
  String get new_product_done_button_label => 'Descoperiți produsul finalizat';

  @override
  String get hey_incomplete_product_message =>
      'Apasă pentru a răspunde ACUM la 3 întrebări pentru a calcula Nutri-Score, Green Score și Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Apasă acum pentru a răspunde la 2 întrebări care te vor ajuta să analizezi acest produs cosmetic!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Apasă acum pentru a răspunde la 3 întrebări care te vor ajuta să analizezi acest produs alimentar pentru animale de companie!';

  @override
  String get hey_incomplete_product_message_product =>
      'Apasă acum pentru a ajuta la finalizarea acestui produs!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Fotografie cu informații nutriționale încărcate';

  @override
  String get recycling_photo_button_label =>
      'Fotografia cu informații despre reciclare';

  @override
  String get recycling_photo_uploaded =>
      'Fotografia despre reciclare încărcată';

  @override
  String get take_more_photo_button_label => 'Faceți mai multe poze';

  @override
  String get other_photo_uploaded => 'Diverse fotografii încărcate';

  @override
  String get retake_photo_button_label => 'Refaceți';

  @override
  String get selecting_photo => 'Selectare fotografie';

  @override
  String get uploading_image => 'Încărcarea fotografiei pe server';

  @override
  String get uploading_image_type_front =>
      'Se încarcă imaginea din față în Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Se încarcă imaginea ingredientelor în Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Se încarcă imaginea informațiilor nutriționale în Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Se încarcă imaginea ambalajului în Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Încărcarea unei alte imagini în Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Se încarcă imaginea în Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Adăugați ingredientele lipsă';

  @override
  String get score_add_missing_packaging_image =>
      'Adaugă imaginea lipsă a ambalajului';

  @override
  String get score_add_missing_nutrition_facts =>
      'Adăugați informațiile nutriționale care lipsesc';

  @override
  String get score_add_missing_product_traces =>
      'Adăugați urme de produs lipsă';

  @override
  String get score_add_missing_product_category => 'Selectați o categorie';

  @override
  String get score_add_missing_precise_product_category =>
      'Selectați o categorie mai precisă';

  @override
  String get score_add_missing_product_countries =>
      'Adăugați țările care lipsesc';

  @override
  String get score_add_missing_product_emb =>
      'Adăugați codurile de trasabilitate ale produselor care lipsesc';

  @override
  String get score_add_missing_product_labels =>
      'Adăugați etichetele produselor care lipsesc';

  @override
  String get score_add_missing_product_origins =>
      'Adăugați originile produselor care lipsesc';

  @override
  String get score_add_missing_product_stores =>
      'Adăugați magazine de produse lipsă';

  @override
  String get score_add_missing_product_brands =>
      'Adăugați mărcile de produse lipsă';

  @override
  String get score_update_nutrition_facts =>
      'Actualizați informațiile nutriționale';

  @override
  String get nutrition_page_title => 'Valori nutriționale';

  @override
  String get nutrition_page_nutritional_info_title => 'Informații nutriționale';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Valorile specificate pe produs:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Da';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nu';

  @override
  String get nutrition_page_nutritional_info_open_photo =>
      'Deschide fotografia';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Bune practici: Informații nutriționale';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Uneori, informațiile nutriționale **nu sunt specificate pe ambalaj** sau pe un document furnizat împreună cu produsul. În acest caz, și numai în acest caz, puteți seta valoarea la **NU**.';

  @override
  String get nutrition_page_serving_type_label => 'Valori nutriționale:';

  @override
  String get nutrition_page_per_100g => 'la 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100g/ml';

  @override
  String get nutrition_page_per_serving => 'per porție';

  @override
  String get nutrition_page_add_nutrient => 'Adăugați un nutrient';

  @override
  String get nutrition_page_serving_size => 'Cantitatea unei porții';

  @override
  String get nutrition_page_serving_size_hint =>
      'Introduceți o porție (de exemplu: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Bune practici: Dimensiunea porției';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Această valoare ajută la **calcularea proporțională a fiecărui nutrient per porție**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Unitățile permise** sunt: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 公升.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** sau **60 g** (de preferință primul)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** sau **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Unitate nevalidă';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 gr';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Unități nevalide';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **bomboane** și 2 **biscuiți**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Unitate lipsă';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Număr nevalid';

  @override
  String get nutrition_page_update_running =>
      'Se actualizează produsul pe server...';

  @override
  String get nutrition_page_update_done => 'Produs actualizat!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Folosește cantitatea de produs ca mărime a porției';

  @override
  String get nutrition_page_photo_error => 'Nu se poate încărca fotografia';

  @override
  String get more_photos => 'Mai multe fotografii interesante';

  @override
  String get view_more_photo_button =>
      'Vizualizați toate fotografiile existente pentru acest produs';

  @override
  String get no_product_found => 'Nu a fost găsit niciun produs';

  @override
  String get no_location_found => 'Nu a fost găsită nicio locație';

  @override
  String get not_found => 'nu a fost găsit:';

  @override
  String get refreshing_product => 'Reîmprospătare produs';

  @override
  String get product_refreshed => 'Produs reîmprospătat';

  @override
  String product_image_accessibility_label(String date) {
    return 'Imagine realizată pe $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Imagine realizată pe $date. Este posibil ca această imagine să fie învechită.';
  }

  @override
  String get product_image_outdated => 'Această imagine poate fi învechită';

  @override
  String get product_image_outdated_explanations_title =>
      'Această imagine poate fi învechită';

  @override
  String get product_image_outdated_explanations_content =>
      'Această imagine a fost făcută acum mai bine de un an.\n**Vă rugăm să verificați dacă este încă actualizată**.\n\nAcesta este **doar un avertisment**. Dacă conținutul este încă același, puteți ignora acest mesaj.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Înlocuiți fotografia ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Adaugă o fotografie ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Captură nouă';

  @override
  String get product_image_action_take_picture => 'Faceți o fotografie';

  @override
  String get product_image_action_from_gallery =>
      'Selectați din galeria telefonului dvs.';

  @override
  String get product_image_action_choose_existing_photo =>
      'Selectați din fotografiile produsului';

  @override
  String get product_image_details_label => 'Informații despre fotografie';

  @override
  String get product_image_details_from_producer => 'De la producător';

  @override
  String get product_image_details_contributor => 'Colaborator';

  @override
  String get product_image_details_contributor_producer =>
      'Contribuitor (producător)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Necunoscut';

  @override
  String get homepage_main_card_logo_description =>
      'Bun venit la Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scanați** un cod de bare sau\n**căutați** un produs';

  @override
  String get homepage_main_card_search_field_hint => 'Căutați un produs';

  @override
  String get homepage_main_card_search_field_tooltip => 'Începeți căutarea';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Ultimele știri: $news_title';
  }

  @override
  String get tagline_app_review => 'Îți place aplicația?';

  @override
  String get tagline_app_review_button_positive => 'O ador! 😍';

  @override
  String get tagline_app_review_button_negative => 'Nu chiar...';

  @override
  String get tagline_app_review_button_later => 'Întreabă-mă mai târziu';

  @override
  String get tagline_feed_news_button => 'Află mai multe';

  @override
  String get app_review_negative_modal_title =>
      'Nu îți place aplicația noastră?';

  @override
  String get app_review_negative_modal_text =>
      'Poți să aloci câteva secunde pentru a ne spune de ce?';

  @override
  String get app_review_negative_modal_positive_button => 'Da, cu siguranță!';

  @override
  String get app_review_negative_modal_negative_button => 'Nu';

  @override
  String get could_not_refresh => 'Produsul nu a putut fi reîmprospătat';

  @override
  String get product_internet_error_modal_title => 'A apărut o eroare!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Nu putem obține informații despre acest produs din cauza unei erori de rețea. Vă rugăm să verificați conexiunea la internet și să încercați din nou.\n\nEroare internă:\n$error';
  }

  @override
  String get product_tags_title => 'Proprietățile produsului';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Nicio proprietate';

  @override
  String get product_tags_explanation =>
      'Prin adăugarea de proprietăți (cheie/valoare) unui produs, contribuiți la îmbogățirea acestuia.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Adăugați proprietăți';

  @override
  String get add_edit_tags => 'Adăugați sau editați proprietăți';

  @override
  String get edit_tag => 'Editați proprietatea';

  @override
  String get remove_tag => 'Eliminați proprietatea';

  @override
  String get tag_key => 'Proprietate';

  @override
  String get tag_keys => 'Proprietăți';

  @override
  String get tag_key_uneditable => 'Proprietate (needitabilă)';

  @override
  String get tag_key_input_hint => 'Introduceți o proprietate';

  @override
  String get tag_value => 'Valoare';

  @override
  String get tag_values => 'Valori';

  @override
  String get tag_value_input_hint => 'Introduceți o valoare';

  @override
  String get tag_key_item => 'Proprietate:';

  @override
  String get tag_value_item => 'Valoare:';

  @override
  String get tag_key_explanations =>
      'O cheie trebuie să fie scrisă cu litere mici și fără spații.';

  @override
  String tag_key_already_exists(String property) {
    return 'Există deja o etichetă cu proprietatea $property !';
  }

  @override
  String get product_internet_error =>
      'Imposibil de preluat informații despre acest produs din cauza unei erori de rețea.';

  @override
  String get cached_results_from => 'Afișați rezultate de la:';

  @override
  String get product_search_same_category => 'Găsiți alternative';

  @override
  String get product_search_same_category_short => 'Compară';

  @override
  String get product_search_same_category_error =>
      'Această funcție poate fi utilizată doar pentru produsele cu o categorie.\n\nVă rugăm să editați produsul pentru a adăuga o categorie.';

  @override
  String get product_improvement_add_category =>
      'Adăugați o categorie pentru a calcula Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Adăugați informații nutriționale pentru a calcula Scorul Nutrițional.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Adăugați informații nutriționale și o categorie pentru a calcula Scorul Nutrițional.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Scorul Nutritiv pentru acest produs nu poate fi calculat, ceea ce se poate datora, de exemplu, unei categorii nestandard. Dacă aceasta este considerată o eroare, vă rugăm să ne contactați.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Imaginea nutrițională este depășită: vă rugăm să o reîmprospătați.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Scorul Verde ia în considerare originea ingredientelor. Vă rugăm să faceți o fotografie a listei de ingrediente și/sau a oricărei mențiuni geografice sau să editați produsul, astfel încât acestea să poată fi luate în considerare.';

  @override
  String get country_chooser_label => 'Vă rugăm să selectați o țară';

  @override
  String get currency_chooser_label => 'Vă rugăm să alegeți o monedă';

  @override
  String get country_change_message => 'Tocmai ai schimbat țara.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Doriți să schimbați moneda din $previousCurrency în $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Vă rugăm să alegeți o țară:';

  @override
  String get country_chooser_label_from_settings => 'Țara ta';

  @override
  String get country_selection_explanation =>
      'Unele caracteristici de mediu sunt specifice localizării';

  @override
  String get product_removed_comparison => 'Produs eliminat din comparație';

  @override
  String get native_app_settings => 'Setări aplicație nativă';

  @override
  String get native_app_description =>
      'Deschideți setările de sistem pentru Open Food Facts';

  @override
  String get product_removed_history => 'Produs eliminat din istoric';

  @override
  String get product_removed_list => 'Produs eliminat din listă';

  @override
  String get product_could_not_remove => 'Produsul nu a putut fi eliminat';

  @override
  String get no_prodcut_in_list => 'Nu există niciun produs în această listă';

  @override
  String get no_product_in_section =>
      'Nu există niciun produs în această secțiune';

  @override
  String get recently_seen_products => 'Toate produsele vizualizate';

  @override
  String get clear => 'Ștergeți';

  @override
  String get clear_long => 'Golește lista';

  @override
  String get really_clear => 'Sigur doriți să ștergeți această listă?';

  @override
  String pct_match(Object percent) {
    return '$percent% potrivire';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count zile în urmă',
      one: 'acum o zi',
      few: '$count zile în urmă',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ore în urmă',
      one: 'acum o ora',
      few: '$count ore în urmă',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minute în urmă',
      one: 'acum un minut',
      zero: 'in urma cu mai puțin de un minut',
      few: '$count minute în urmă',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count cu luni în urmă',
      one: 'acum o luna',
      few: '$count cu luni în urmă',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count săptămâni în urma',
      one: 'acum o saptamana',
      few: '$count săptămâni în urma',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Compara $count Produse',
      one: 'Compara un produs',
      few: 'Compara $count Produse',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produse selectate',
      one: 'Un produs selectat',
      zero: 'Niciun produs selectat',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Comparați produsele selectate';

  @override
  String get delete_products_mode => 'Ștergeți produsele selectate';

  @override
  String get select_all_products_mode => 'Selectați toate produsele';

  @override
  String get select_none_products_mode => 'Selectați niciunul';

  @override
  String get compare_products_appbar_title => 'Compară produsele';

  @override
  String get compare_products_appbar_subtitle =>
      'Vă rugăm să selectați cel puțin două produse';

  @override
  String get retry_button_label => 'Reîncercați';

  @override
  String get connect_with_us => 'Conectați-vă cu noi';

  @override
  String get tiktok => 'Urmărește-ne pe TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Urmăriți-ne pe Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Urmăriți-ne pe X (fostul Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Urmărește-ne pe Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Urmărește-ne pe BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Întrebări frecvente';

  @override
  String get discover => 'Descoperiți';

  @override
  String get how_to_contribute => 'Cum să contribuiți';

  @override
  String get hint_knowledge_panel_message =>
      'Puteți atinge orice parte a cardului pentru a obține mai multe detalii despre ceea ce vedeți. Încearcă acum!';

  @override
  String get permissions_page_title => 'Acces la cameră';

  @override
  String get permissions_page_body1 =>
      'Pentru a scana coduri de bare cu camera telefonului, vă rugăm să Autorizați accesul.';

  @override
  String get permissions_page_body2 =>
      'Dacă vă răzgândiți, această opțiune poate fi activată și dezactivată în orice moment din setări.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Lansare: $release)\nModel: $model\nProdus: $product\nDispozitiv: $device\nBrand:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModel: $model\nModel localizat: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersiunea aplicației:$appVersion\nNumărul versiunii aplicației:$appBuildNumber\nNumele pachetului aplicației:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Autorizează';

  @override
  String get refuse_button_label => 'Refuzați';

  @override
  String get ask_me_later_button_label => 'Mai târziu';

  @override
  String get are_you_sure => 'Sunteți sigur?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Mergi mai departe pe $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Bun venit!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Aplicația care te ajută să alegi alimente bune pentru **tine** și pentru **planetă**!';

  @override
  String get onboarding_continue_button => 'Continuați';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Se încarcă primul exemplu de produs';

  @override
  String get onboarding_welcome_warning =>
      'Îmi pare rău, este produsul nostru exemplu, nu îl poți edita :)';

  @override
  String get product_list_your_ranking => 'Clasamentul tău';

  @override
  String get product_list_empty_icon_desc => 'Istoricul nu este disponibil';

  @override
  String get product_list_empty_title => 'Începeți scanarea';

  @override
  String get product_list_empty_message =>
      'Produsele scanate vor apărea aici și puteți verifica informații detaliate despre ele';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produse',
      one: 'produs',
      zero: 'produs',
      few: 'produse',
    );
    return 'Reîmprospătare $_temp0 în istoric';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Produse',
      one: 'Produs',
      zero: 'Produs',
      few: 'Produse',
    );
    return '$_temp0 Reîmprospătare completă';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Descărcare date';

  @override
  String get loading_dialog_default_error_message =>
      'Datele nu au putut fi descărcate';

  @override
  String get account_delete => 'Ștergere cont';

  @override
  String get account_delete_title => 'Ștergeți contul meu';

  @override
  String get user_profile => 'Cont';

  @override
  String get user_profile_title_guest => 'Bine ați venit!';

  @override
  String get user_profile_subtitle_guest =>
      'Conectați-vă sau înscrieți-vă pentru a vă alătura comunității Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Conectare Open Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Bun venit $id!';
  }

  @override
  String get email_subject_account_deletion => 'Ștergere cont';

  @override
  String email_body_account_deletion(String userId) {
    return 'Bună ziua, vă rugăm să ștergeți contul meu Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplicație';

  @override
  String get settings_app_data => 'Confidențialitate și monitorizare';

  @override
  String get settings_app_camera => 'Cameră';

  @override
  String get settings_app_products => 'Produse';

  @override
  String get settings_app_miscellaneous => 'Diverse';

  @override
  String get camera_play_sound_title => 'Redați un sunet la scanare';

  @override
  String get camera_play_sound_subtitle =>
      'Va fi un semnal sonor la fiecare scanare reușită';

  @override
  String get camera_window_accessibility_label =>
      'Scanați un cod de bare cu camera dvs.';

  @override
  String get app_haptic_feedback_title => 'Vibrație și haptică';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrații după executarea unor acțiuni (cod de bare decodat, produs eliminat…).';

  @override
  String get crash_reporting_toggle_title => 'Rapoarte erori';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Când sunt activate, rapoartele de blocare sunt trimise automat la sistemul de urmărire a erorilor Open Food Facts, astfel încât erorile să poată fi remediate și astfel să îmbunătățească aplicația.';

  @override
  String get send_anonymous_data_toggle_title => 'Trimiteți date anonime';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Când este activată, unele informații anonime privind utilizarea aplicației vor fi trimise către serverele Open Food Facts, astfel încât să putem înțelege cum și cât de mult sunt utilizate funcțiile pentru a le îmbunătăți.';

  @override
  String get product_edit_photo_title => 'Editare fotografie';

  @override
  String get permission_photo_error => 'Eroare';

  @override
  String get permission_photo_denied_title =>
      'Permiteți utilizarea camerei pentru a scana coduri de bare';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Pentru o experiență îmbunătățită, permiteți utilizatorului $appName să vă acceseze camera. Veți putea scana direct codurile de bare.';
  }

  @override
  String get permission_photo_denied_button => 'Permite';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Acces refuzat';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Deoarece ați refuzat anterior permisiunea camerei, trebuie să o permiteți manual din Setări.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Open Settings';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Anulare';

  @override
  String get permission_photo_none_found => 'Nu a fost detectată nicio cameră';

  @override
  String get permission_photo_denied => 'Nu este permis accesul la cameră';

  @override
  String get show_product_pictures => 'Afișați imaginile produsului';

  @override
  String get edit_product_label => 'Modificare produs';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Încărcarea editărilor…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Modificările dvs. sunt **trimise în fundal** (sau mai târziu în caz de eroare).\nPuteți continua să editați alte câmpuri de produse.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Modificările tale sunt **trimise în fundal** (sau mai târziu în caz de eroare).';

  @override
  String get edit_product_label_short => 'Modificare';

  @override
  String edit_product_form_item_help(String value) {
    return 'Cum se introduce „$value”?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Vă rugăm să introduceți o valoare care nu este goală!';

  @override
  String get edit_product_form_item_error_existing =>
      'Această valoare există deja!';

  @override
  String get edit_product_form_item_add_action_brand => 'Adăugați o nouă marcă';

  @override
  String get edit_product_form_item_add_action_label =>
      'Adăugați o etichetă nouă';

  @override
  String get edit_product_form_item_add_action_store =>
      'Adăugați un magazin nou';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Adăugați o nouă origine';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Adăugați un nou cod de trasabilitate';

  @override
  String get edit_product_form_item_add_action_country =>
      'Adăugați o țară nouă';

  @override
  String get edit_product_form_item_add_action_category =>
      'Adăugați o categorie nouă';

  @override
  String get edit_product_form_item_add_action_trace => 'Adăugați o nouă urmă';

  @override
  String get edit_product_form_item_add_suggestion => 'Adăugați o sugestie';

  @override
  String get edit_product_form_item_deny_suggestion => 'Respinge sugestia';

  @override
  String get edit_product_form_item_details_title => 'Detalii de bază';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Denumirea produsului, marcă, cantitate';

  @override
  String get edit_product_form_item_other_details_title =>
      'Detalii suplimentare';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Site-ul web…';

  @override
  String get edit_product_form_item_photos_title => 'Imagini';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Adăugați sau reîmprospătați fotografii';

  @override
  String get edit_product_form_item_labels_title => 'Etichete și certificări';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Mediu, etichete de calitate…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Introduceți o etichetă (de exemplu: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'eticheta';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Bune practici: Etichete';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Orice caracteristică a produsului **care este factuală** și diferită de celelalte câmpuri.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Fabricat în Belgia, produs în Bretania…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Bogat în fibre, sursă de fier…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Comerț echitabil, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Magazine';

  @override
  String get edit_product_form_item_stores_hint => 'Introduceți un magazin';

  @override
  String get edit_product_form_item_stores_type => 'magazin';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Bune practici: Magazine';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Introdu magazinul de unde ai cumpărat produsul.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Origini';

  @override
  String get edit_product_form_item_origins_hint =>
      'Introduceți o origine (de exemplu: Germania)';

  @override
  String get edit_product_form_item_origins_type => 'tara';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Bune practici: Origini';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Adăugați **orice indicații privind originea pe care le puteți găsi pe ambalaj**.\nNu trebuie să vă faceți griji cu privire la originile indicate direct în lista ingredientelor.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Carne de vită din Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soia nu provine din Uniunea Europeană';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Introduceți o țară (de exemplu: Germania)';

  @override
  String get edit_product_form_item_countries_type => 'tara';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Bune practici: Țări';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Țări în care produsul este disponibil pe scară largă** (cu excepția magazinelor specializate în produse străine).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Codul EMB:';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Introduceți un cod (de exemplu: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'Codul EMB:';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Bune practici: Coduri de trasabilitate';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'În această secțiune, puteți introduce coduri legate de **mărcile de ambalare**, **mărcile de identificare** sau **mărcile sanitare**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Exemple de coduri de trasabilitate';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Coduri CE** utilizate în Comunitatea Europeană pentru a identifica producătorii sau ambalatorii de alimente:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: prefixul țării **Franța**\n**72.264.002**: date geografice\n**CE**: Comunitatea Europeană';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Coduri EMB** utilizate în Franța:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Urme';

  @override
  String get edit_product_form_item_traces_hint => 'urma';

  @override
  String get edit_product_form_item_traces_type =>
      'Introduceți o urmă (de exemplu: boabe de soia)';

  @override
  String get edit_product_form_item_categories_title => 'Categorii';

  @override
  String get edit_product_form_item_categories_hint => 'categorie';

  @override
  String get edit_product_form_item_categories_type =>
      'Introduceți o categorie (de exemplu: Suc de portocale)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Bune practici: Categorii';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicați **doar categoria cea mai specifică**.\nCategoriile părinte vor fi adăugate automat.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Categorie lipsă?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'În cazul în care o categorie **nu este disponibilă în completarea automată**, nu ezitați să o adăugați oricum.\nAcest lucru ne va ajuta să îmbunătățim Open Food Facts în țara dumneavoastră.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardine în ulei de măsline';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Suc de portocale din concentrat';

  @override
  String get edit_product_form_item_exit_title => 'Ieși fără a salva?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Doriți să salvați modificările înainte de a părăsi această pagină?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Salvează modificările';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Renunțați la modificări';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingrediente';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Măriți și micșorați prin atingerea ecranului';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Măriți și micșorați fotografia';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Folosind gestul **Ciupiți pentru zoom**, puteți mări sau micșora fotografia:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Adaugă';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Vă rugăm să introduceți mai întâi un text';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Elimină';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Salvați editarea';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Anulează editarea';

  @override
  String get edit_product_form_item_packaging_title =>
      'Fotografie cu instrucțiuni de reciclare';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Valori nutriționale';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutriție, conținut de alcool…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Bune practici: Informații nutriționale';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Valori nutriționale';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Mai întâi, selectați dacă **sunt furnizate valorile**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Valori nutriționale';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Apoi, introduceți valorile nutriționale **așa cum sunt indicate pe ambalaj**. Dacă nu există nicio valoare, puteți face clic pe pictograma „Ochi”.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Câmp lipsă?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Dacă lipsește o intrare, puteți **face clic pe pictograma „Plus”** pentru a o adăuga (de exemplu: vitamina D, magneziu…).';

  @override
  String get edit_product_form_save => 'Modificare';

  @override
  String get edit_product_ingredients_photo_title => 'Foto ingrediente';

  @override
  String get edit_product_ingredients_list_title => 'Lista ingredientelor';

  @override
  String get edit_product_packaging_photo_title => 'Fotografie de ambalare';

  @override
  String get edit_product_packaging_list_title => 'Lista de ambalaje';

  @override
  String get no_data_available => 'Nici o informație disponibilă';

  @override
  String get product_field_website_title => 'Site-ul web';

  @override
  String get origins_editing_title => 'Editați originile';

  @override
  String get completed_basic_details_btn_text => 'Detalii de bază complete';

  @override
  String get not_implemented_snackbar_text => 'Neimplementat încă';

  @override
  String get category_picker_page_appbar_text => 'Categorii';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extrageți ingredientele din fotografie';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extrageți ingredientele';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extragerea ingredientelor\ndin fotografie';

  @override
  String get edit_ingredients_loading_photo_btn_text =>
      'Se încarcă fotografia…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'De ce văd acest mesaj?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Pentru a utiliza funcția „Extrage ingrediente”, fotografia trebuie mai întâi încărcată.\n\nVă rugăm să așteptați câteva secunde sau să le introduceți manual.';

  @override
  String get edit_ingredients_refresh_photo_btn_text =>
      'Reîmprospătați fotografia';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extrageți ambalajul\ndin fotografie';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extrage ambalajul';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extragerea ambalajului din fotografie';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Se încarcă fotografia…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'De ce văd acest mesaj?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Pentru a utiliza funcția „Extrage ambalajul”, fotografia trebuie mai întâi încărcată.\n\nVă rugăm să așteptați câteva secunde sau să le introduceți manual.';

  @override
  String get edit_packaging_refresh_photo_btn_text =>
      'Reîmprospătați fotografia';

  @override
  String get edit_ocr_extract_failed =>
      'Nu s-a putut detecta textul din imagine.';

  @override
  String get edit_ocr_extract_disabled_title => 'Nicio poză!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Pentru a utiliza funcția de extragere a textului, trebuie mai întâi să faceți o fotografie.';

  @override
  String get user_list_dialog_new_title => 'Noua listă de produse';

  @override
  String get user_list_dialog_rename_title => 'Redenumiți lista';

  @override
  String get user_list_subtitle_product => 'Liste';

  @override
  String get user_list_title => 'Listele tale';

  @override
  String get user_list_add_product => 'Adăugați produsul în listele dvs';

  @override
  String get user_list_button_new => 'Creați o listă nouă';

  @override
  String get user_list_empty_label =>
      'Nu există încă o listă disponibilă, vă rugăm să începeți prin a crea una';

  @override
  String get user_list_button_add_product => 'Adaugă la listă';

  @override
  String get added_to_list_msg => 'Adăugat la listă';

  @override
  String get user_list_popup_clear => 'Ștergeți-vă istoricul';

  @override
  String get user_list_popup_rename => 'Redenumiți';

  @override
  String get user_list_name_hint => 'Lista mea';

  @override
  String get user_list_name_error_empty => 'Numele este obligatoriu';

  @override
  String get user_list_name_error_already => 'Acest nume este deja folosit';

  @override
  String get user_list_name_error_same => 'Este același nume';

  @override
  String get user_list_name_input_hint => 'Numele listei';

  @override
  String get try_again => 'Încearcă din nou';

  @override
  String get there_was_an_error => 'A apărut o eroare';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nu a fost găsită nicio categorie pentru $items';
  }

  @override
  String get camera_toggle_camera =>
      'Comutați între camera din spate și cea frontală';

  @override
  String get camera_toggle_flash => 'Porniți sau dezactivați blițul camerei';

  @override
  String get camera_enable_flash => 'Activați blițul';

  @override
  String get camera_disable_flash => 'Dezactivați blițul';

  @override
  String get camera_flash_error_dialog_title => 'A apărut o eroare!';

  @override
  String get camera_flash_error_dialog_message =>
      'A apărut o eroare la modificarea stării blițului. Asigurați-vă că smartphone-ul dvs. nu are lanterna deja activată.';

  @override
  String get category_picker_no_category_found_button => 'Înapoi';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Faceți clic pentru a deschide în browser sau în aplicație (dacă este instalată)';

  @override
  String get dev_preferences_screen_title => 'Modul dezvoltare';

  @override
  String get dev_preferences_screen_subtitle =>
      'Accesați funcții experimentale și instrumente de dezvoltare';

  @override
  String get dev_preferences_reset_onboarding_title => 'Reporniți integrarea';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Apoi trebuie să reporniți aplicația pentru a o vedea din nou.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Comutați între openfoodfacts.org (PROD) și testați mediul';

  @override
  String get dev_preferences_test_environment_title =>
      'Testarea parametrilor mediului';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Adresa URL de bază pentru mediul de testare curent: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Gazda mediului de testare';

  @override
  String get dev_preferences_ml_kit_title => 'Utilizați Kit-ul ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'apoi trebuie să reporniți această aplicație';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Buton suplimentar pe pagina produsului';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Editați ingredientele printr-un buton din panoul de cunoștințe';

  @override
  String get dev_preferences_export_history_title => 'Export istoric';

  @override
  String get dev_preferences_export_history_progress_error => 'excepție';

  @override
  String get dev_preferences_export_history_progress_found => 'Produs găsit';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'Produsul NU a fost găsit';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Istoricul exporturilor';

  @override
  String get dev_preferences_button_positive => 'Bine';

  @override
  String get dev_preferences_button_negative => 'Anulare';

  @override
  String get dev_preferences_migration_title => 'Migrarea datelor din V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Stare: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'succes sau instalare nouă';

  @override
  String get dev_preferences_migration_status_success => 'succes';

  @override
  String get dev_preferences_migration_status_error => 'eroare';

  @override
  String get dev_preferences_migration_status_in_progress => 'în curs';

  @override
  String get dev_preferences_migration_status_required =>
      'obligatoriu (click pentru a începe)';

  @override
  String get dev_preferences_migration_status_not_started => 'necunoscut';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Va șterge istoricul și va pune 3 produse acolo';

  @override
  String get dev_preferences_news_custom_url_title =>
      'URL personalizat pentru știri';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL-ul fișierului JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nesetat';

  @override
  String get dev_preferences_news_provider_status_title => 'Stare';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Ultima actualizare: $date';
  }

  @override
  String get product_type_label_food => 'Mâncare';

  @override
  String get product_type_label_beauty => 'Îngrijire personală';

  @override
  String get product_type_label_pet_food => 'Hrană pentru animale de companie';

  @override
  String get product_type_label_product => 'Altele';

  @override
  String get product_type_selection_title => 'Tipul de produs';

  @override
  String get product_type_selection_subtitle =>
      'Selectați tipul acestui produs';

  @override
  String get product_type_selection_empty =>
      'Mai întâi trebuie să selectați un tip de produs!';

  @override
  String product_type_selection_already(String productType) {
    return 'Nu puteți schimba tipul de produs ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Comandă rapidă către aplicația Prețuri pe pagina produsului';

  @override
  String get prices_app_button => 'Accesați aplicația Prețuri';

  @override
  String get prices_website_button => 'Deschideți pe site-ul Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Adăugați etichete de preț direct din galerie';

  @override
  String get prices_bulk_proof_upload_warning =>
      'După ce ați selectat imagini, nu le veți mai putea edita!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Permite comunității să valideze prețurile extrase de inteligența artificială.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Etichete de preț multiple';

  @override
  String get prices_bulk_proof_upload_title => 'Încărcare în bloc a dovezilor';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Selectarea fișierelor';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Începerea încărcării';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copierea locală a fișierului #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Se pregătește încărcarea #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Eșuat la imaginea #$index/$count';
  }

  @override
  String get prices_generic_title => 'Prețuri';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Adăugați $count prețuri',
      one: 'Adăugați un preț',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Trimiteți $count prețuri',
      one: 'Trimiteți prețul',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Adăugați un element';

  @override
  String get prices_add_a_price => 'Adăugați un preț';

  @override
  String get prices_add_a_receipt => 'Adăugați o chitanță';

  @override
  String get prices_add_price_tags => 'Adăugați etichete de preț';

  @override
  String prices_barcode_already(String barcode) {
    return 'Acest cod de bare ($barcode) este deja în listă!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produsul nu a fost găsit';

  @override
  String get prices_barcode_search_none_yet => 'Niciun produs încă';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Se caută $barcode';
  }

  @override
  String get prices_barcode_enter => 'Introduceți codul de bare';

  @override
  String get prices_category_enter => 'Articol fără coduri de bare';

  @override
  String get prices_per_kilogram => 'Preț pe kilogram';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unitate';

  @override
  String get prices_category_mandatory => 'Obligatoriu';

  @override
  String get prices_category_optional => 'Opțional';

  @override
  String get prices_category_error_mandatory => 'Categoria este obligatorie';

  @override
  String get prices_barcode_reader_action => 'Cititor de coduri de bare';

  @override
  String get prices_view_prices => 'Vezi prețurile';

  @override
  String get prices_list_title => 'Listă de prețuri';

  @override
  String get prices_list_count => 'Număr de\nprețuri';

  @override
  String get prices_list_add_new_price => 'Adăugați un preț nou\n';

  @override
  String get prices_list_empty_title => 'Încă nu există preț!';

  @override
  String get prices_list_empty_subtitle =>
      'Fii primul care adaugă unul:\nScanând o **chitanță** sau o **etichetă de preț**!';

  @override
  String get prices_entry_shop_not_found => 'Magazin necunoscut';

  @override
  String prices_entry_menu_title(String user) {
    return 'Introducere preț de la „$user”';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Vezi toate prețurile pentru acest produs';

  @override
  String get prices_entry_menu_open_proof => 'Vizualizați dovada';

  @override
  String get prices_entry_menu_my_prices => 'Vezi celelalte prețuri ale mele';

  @override
  String get prices_entry_menu_author_prices =>
      'Vedeți alte prețuri ale autorului';

  @override
  String get prices_entry_menu_shop_prices => 'Vezi alte prețuri din magazin';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prețuri',
      one: '1 preț',
    );
    return '$_temp0 pentru $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Toate $count prețurile',
      one: 'Un singur preț',
      zero: 'Încă nu există preț',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Cele mai recente prețuri $pageSize (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Preț: $price / Magazin: „$location” / Publicat pe $date de „$user”';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Demonstrații deschise ale lui „$user”';
  }

  @override
  String get prices_open_proof => 'Dovada prețului deschis';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Toate $count demonstrațiile',
      one: 'O singură demonstrație',
      zero: 'Nicio demonstrație încă',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Cele mai recente $pageSize dovezi (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'Niciun contribuitor încă!';

  @override
  String get prices_users_empty_explanation =>
      'Fii primul care adaugă un preț!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Cei mai importanți $pageSize contribuitori (total: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Încă nu există magazin!';

  @override
  String get prices_locations_empty_explanation =>
      'Fii primul care adaugă un preț!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Cele mai importante $pageSize locații (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count demonstrații',
      one: 'O demonstrație',
      zero: 'Nicio demonstrație',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produse',
      one: 'Un produs',
      zero: 'Niciun produs',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count utilizatori',
      one: 'Un utilizator',
      zero: 'Niciun utilizator',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prețuri',
      one: 'Un singur preț',
      zero: 'Fără preț',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Preț adăugat anterior';

  @override
  String get prices_amount_subtitle => 'Cantitate';

  @override
  String get prices_amount_is_discounted => 'Este redus?';

  @override
  String get prices_amount_price_normal => 'Preţ';

  @override
  String get prices_amount_price_discounted => 'Preț redus';

  @override
  String get prices_amount_price_not_discounted => 'Preț inițial';

  @override
  String get prices_amount_no_product => 'Lipsește un produs!';

  @override
  String get prices_amount_price_incorrect => 'Valoare incorectă';

  @override
  String get prices_amount_price_mandatory => 'Valoare obligatorie';

  @override
  String get prices_currency_subtitle => 'Valută';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Magazin';

  @override
  String get prices_location_find => 'Găsește un magazin';

  @override
  String get prices_location_mandatory => 'Trebuie să alegi un magazin!';

  @override
  String get prices_location_search_broader =>
      'Nu ați găsit ceea ce căutați? Haideți să încercăm o căutare mai amplă!';

  @override
  String get prices_proof_subtitle => 'Dovadă';

  @override
  String get prices_proof_empty_title => 'Încă nicio dovadă!';

  @override
  String get prices_proof_empty_explanation =>
      'Începeți prin a adăuga o fotografie a unei **bonuri** sau a unei **etichete de preț**!';

  @override
  String get prices_proof_find => 'Selectați o dovadă';

  @override
  String get prices_proof_change => 'Dovada schimbării';

  @override
  String get prices_proof_receipt => 'Chitanță';

  @override
  String get prices_proof_price_tag => 'Etichetă de preț';

  @override
  String get prices_proof_mandatory => 'Trebuie să alegi o dovadă!';

  @override
  String get prices_add_validation_error => 'Eroare de validare';

  @override
  String get prices_privacy_warning_title =>
      'Avertisment privind confidențialitatea';

  @override
  String get prices_unknown_product => 'Produs necunoscut';

  @override
  String get prices_privacy_warning_main_message =>
      'Prețurile **vor fi publice**, împreună cu magazinul la care se referă.\n\nAcest lucru ar putea permite persoanelor care știu despre pseudonimul dvs. Open Food Facts să:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Deduceți în ce zonă locuiți';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Știți ce cumpărați';

  @override
  String get prices_privacy_warning_sub_message =>
      'Dacă nu vă simțiți confortabil cu acest lucru, vă rugăm să vă schimbați pseudonimul sau să creați un nou cont Open Food Facts și să vă conectați la aplicație cu acesta.';

  @override
  String get i_refuse => 'Refuz';

  @override
  String get i_accept => 'Accept';

  @override
  String get prices_currency_change_proposal_title => 'Schimbați moneda?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Moneda dumneavoastră actuală este **$currency**. Doriți să o schimbați în **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Da, folosește $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nu, păstrați $currency';
  }

  @override
  String get prices_menu_know_more => 'Aflați mai multe despre Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Terminat';

  @override
  String get dev_mode_section_server => 'Configurarea serverului';

  @override
  String get dev_mode_section_news => 'Configurarea furnizorului de știri';

  @override
  String get dev_mode_section_product_page => 'Pagina produsului';

  @override
  String get dev_mode_section_ui => 'Interfață utilizator';

  @override
  String get dev_mode_section_experimental_features =>
      'Caracteristici experimentale';

  @override
  String get dev_mode_hide_environmental_score_title => 'Exclude Scorul Verde';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Folosește un verificator ortografic pentru ecranele OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingrediente și ambalaj)';

  @override
  String get dev_mode_reset_app_language_title => 'Resetați limba aplicației';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Adăugați carduri';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Comutare între prices.openfoodfacts.org (PROD) și mediul de testare';

  @override
  String get search_history_item_edit_tooltip =>
      'Reutilizați și editați această căutare';

  @override
  String get search_history_item_remove_tooltip => 'Elimină';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Ai descărcat toate cele $totalSize produse.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Descarcă încă $count produse\nDeja descărcate $downloaded din $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Căutarea $search este în desfășurare.\n\nVă rugăm să așteptați câteva secunde…';
  }

  @override
  String get user_search_contributor_title => 'Produsele pe care le-am adăugat';

  @override
  String get user_search_informer_title => 'Produsele pe care le-am editat';

  @override
  String get user_search_photographer_title =>
      'Produsele pe care le-am fotografiat';

  @override
  String get user_search_to_be_completed_title => 'Produsele mele de completat';

  @override
  String get user_search_prices_title => 'Prețurile mele';

  @override
  String get user_search_proofs_title => 'Dovezile mele';

  @override
  String get user_search_proof_title => 'Dovada mea';

  @override
  String search_proof_title(String user) {
    return 'Dovadă din „$user”';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Prețuri pentru contribuitori: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Ultimele prețuri adăugate';

  @override
  String get all_search_prices_top_user_title =>
      'Cei mai importanți contribuitori la preț';

  @override
  String get all_search_prices_top_location_title =>
      'Magazinele cu cele mai multe prețuri';

  @override
  String get prices_contribution_assistant =>
      'Asistent pentru contribuția la preț';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Adăugați mai multe dovezi';

  @override
  String get all_search_prices_top_location_single_title =>
      'Prețurile dintr-un magazin';

  @override
  String get all_search_prices_top_product_title =>
      'Produsele cu cele mai mari prețuri';

  @override
  String get all_search_to_be_completed_title => 'Toate produsele de completat';

  @override
  String get categorize_products_country_title =>
      'Ajută la clasificarea produselor din țara ta';

  @override
  String get edit_product_action_retake_picture => 'Refaceți fotografia';

  @override
  String get edit_product_action_take_picture => 'Faceți o fotografie';

  @override
  String get edit_product_action_confirm => 'Confirmați';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Sunt de acord cu Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'termeni de utilizare și contribuție';

  @override
  String get analytics_consent_image_semantic_label => 'Pictograma analitică';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Eroare fatală: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Eroare fatală: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Detalii de bază complete';

  @override
  String get edit_photo_button_label => 'Modificare';

  @override
  String get edit_photo_unselect_button_label => 'Deselectați fotografia';

  @override
  String get edit_photo_select_existing_button_label =>
      'Selectați o imagine existentă';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Selectați o imagine făcând clic pe ea';

  @override
  String get edit_photo_select_existing_download_label =>
      'Se preiau imaginile existente...';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Nu există imagini încărcate anterior legate de acest produs.';

  @override
  String get edit_photo_language_not_this_one =>
      'Nicio imagine încă în limba respectivă';

  @override
  String get edit_photo_language_none => 'Nicio imagine încă';

  @override
  String get category_picker_screen_title => 'Categorii';

  @override
  String get basic_details => 'Informații de bază';

  @override
  String get product_name => 'Numele produsului';

  @override
  String get product_names => 'Nume de produse';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Adăugați o traducere nouă';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Înainte de validare, vă rugăm să adăugați o traducere doar **dacă limba este prezentă pe ambalaj**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Vezi fotografia din față';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Faceți o fotografie frontală';

  @override
  String get add_basic_details_product_name_hint =>
      'Introduceți numele produsului (de exemplu: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Schimbați limba implicită?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Doriți ca limba implicită a produsului să fie setată la „$language”?';
  }

  @override
  String get explanation_section_good_examples => 'Exemple bune';

  @override
  String get explanation_section_bad_examples => 'Exemple proaste';

  @override
  String get add_basic_details_product_name_help_title =>
      'Bune practici: Numele produsului';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Numele produsului este **denumirea principală tipărită pe ambalaj**. Poate fi o marcă înregistrată.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      'Notă: Vă rugăm să nu adăugați o traducere dacă limba nu este prezentă pe ambalaj.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Ketchup de roșii';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Nu includeți marca în nume';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Ketchup de roșii **de la Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Nu folosiți simbolurile ®, ™, © sau similare';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count alte traduceri',
      one: '$count altă traducere',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Denumirea mărcii';

  @override
  String get brand_names => 'Nume de marcă';

  @override
  String get add_basic_details_brand_name_error =>
      'Vă rugăm să introduceți numele mărcii';

  @override
  String get add_basic_details_brand_names_hint =>
      'Mărci de ingrediente (de exemplu: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Bune practici: Mărci';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Introduceți **toate mărcile produsului**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Marcă principală';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Marca principală**, în general afișată clar pe ambalajul frontal, trebuie **introdusă prima**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Alte mărci';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Când este vândut **de o companie mare**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      'Actimel este vândut de Danone';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Când este vândut cu marca sa **tradusă în mai multe limbi**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Valea Naturii** este uneori scrisă **Val Natură**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Cantitatea și greutatea';

  @override
  String get add_basic_details_quantity_hint =>
      'Introduceți greutatea și, dacă este necesar, cantitatea (de exemplu: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Bune practici: Cantitate';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copiați valoarea indicată pe produs și **nu uitați unitățile**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** sau **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (pentru 6 ouă)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(pentru un produs cu 3 cutii, fiecare a câte 150g)';

  @override
  String get barcode => 'Cod de bare';

  @override
  String barcode_barcode(String barcode) {
    return 'Cod de bare: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Cod de bare nevalid';

  @override
  String get basic_details_add_success => 'Detalii de bază adăugate cu succes';

  @override
  String get basic_details_add_error =>
      'Nu se pot adăuga detalii de bază. Vă rugăm să încercați din nou după ceva timp';

  @override
  String get clear_search => 'Ștergeți căutarea';

  @override
  String get confirm_clear =>
      'Sunteți pe cale să vă ștergeți întregul istoric: sunteți sigur că doriți să continuați?';

  @override
  String get alert_clear_selected_user_list =>
      'Sunteți pe cale să ștergeți elementele selectate din istoric';

  @override
  String get confirm_clear_selected_user_list =>
      'Ești sigur că vrei să continui?';

  @override
  String get alert_select_items_to_clear =>
      'Vă rugăm să selectați unul sau mai multe elemente pentru ștergere';

  @override
  String confirm_clear_user_list(String name) {
    return 'Sunteți pe cale să ștergeți această listă ($name): sunteți sigur că doriți să continuați?';
  }

  @override
  String get confirm_delete_user_list_title => 'Ștergeți lista?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Sunteți pe cale să ștergeți lista „$name”.\nSigur doriți să continuați?';
  }

  @override
  String get confirm_delete_user_list_button => 'Da, confirm';

  @override
  String importance_label(String name, String id) {
    return '$name importanță: $id';
  }

  @override
  String get user_list_all_title => 'Liste';

  @override
  String get user_list_all_empty => 'Creați-vă prima listă';

  @override
  String get product_list_select => 'Selectați o listă';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produse',
      one: 'Un singur produs',
      zero: 'Lista goală',
      few: '$count produse',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Adăugați o listă';

  @override
  String get open_food_preferences_tooltip =>
      'Editați-vă preferințele alimentare';

  @override
  String get add_photo_button_label => 'Adăugați o fotografie';

  @override
  String get add_packaging_photo_button_label =>
      'Faceți fotografii cu orice informații despre ambalare/reciclare';

  @override
  String get add_origin_photo_button_label =>
      'Faceți fotografii cu orice informație despre origine';

  @override
  String get add_emb_photo_button_label =>
      'Faceți fotografii cu orice informație despre codul de trasabilitate';

  @override
  String get add_label_photo_button_label =>
      'Faceți fotografii ale oricăror etichete și informații despre certificări';

  @override
  String get choose_image_source_title => 'Alegeți sursa imaginii';

  @override
  String get choose_image_source_body =>
      'Vă rugăm să alegeți o sursă a imaginii';

  @override
  String get gallery_source_label => 'Galerie';

  @override
  String get gallery_source_access_denied_dialog_title => 'Acces interzis';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Din păcate, aplicația nu vă poate accesa galeria, deoarece ați refuzat anterior permisiunea.\n\nVă rugăm să accesați setările aplicației din Setări telefon -> Fotografii';

  @override
  String get gallery_source_access_denied_dialog_button => 'Deschide Setări';

  @override
  String get share => 'Distribuiți';

  @override
  String share_product_text(String url) {
    return 'Aruncă o privire la acest produs pe Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Aruncă o privire la acest produs pe Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Aruncați o privire la acest produs pe Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Aruncați o privire la acest produs pe Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Aruncă o privire la lista mea de produse pe Open Food Facts: $url';
  }

  @override
  String get capture => 'Captură nouă';

  @override
  String get capture_new_picture => 'Faceți o fotografie';

  @override
  String get choose_from_gallery => 'Alegeți din galerie';

  @override
  String get image_upload_queued =>
      'Imaginea va fi încărcată în fundal cât mai curând posibil.';

  @override
  String get add_price_queued =>
      'Prețul va fi trimis serverului cât mai curând posibil.';

  @override
  String get background_task_title_full_refresh =>
      'Începe reîmprospătarea tuturor produselor stocate local';

  @override
  String get background_task_title_top_n =>
      'Începe descărcarea celor mai populare produse';

  @override
  String get expand_nutrition_facts =>
      'Extinderea tabelului cu date nutriționale';

  @override
  String get expand_nutrition_facts_body =>
      'Păstrați tabelul cu informații nutriționale extins';

  @override
  String get expand_ingredients => 'Extinde ingredientele';

  @override
  String get expand_ingredients_body => 'Păstrați panoul de ingrediente extins';

  @override
  String get no_internet_connection => 'Fără conexiune la internet';

  @override
  String get world_results_label => 'Lumea întreagă';

  @override
  String get world_results_action => 'Extindeți-vă căutarea în lume';

  @override
  String get copy_to_clipboard => 'Copiază';

  @override
  String get paste_from_clipboard => 'Lipire din clipboard';

  @override
  String get no_data_available_in_clipboard =>
      'Nu există date disponibile în clipboard';

  @override
  String get clipboard_barcode_copy => 'Copiați codul de bare în clipboard';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Cod de bare $barcode copiat în clipboard!';
  }

  @override
  String get open_product_website => 'Deschideți acest produs pe site';

  @override
  String get language_picker_label => 'Limba ta';

  @override
  String get country_picker_label => 'Țara ta';

  @override
  String get currency_picker_label => 'Moneda dumneavoastră';

  @override
  String get help_with_openfoodfacts => 'Ajutor cu OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produsul va fi actualizat în fundal cât mai curând posibil.';

  @override
  String get no_email_client_available_dialog_title =>
      'Fără aplicații de e-mail!';

  @override
  String get no_email_client_available_dialog_content =>
      'Vă rugăm să ne trimiteți manual un e-mail la adresa mobile@openfoodfacts.org';

  @override
  String get all_images => 'Toate Imaginile';

  @override
  String get selected_images => 'Imagini selectate';

  @override
  String get product_card_remove_product_tooltip => 'Eliminați produsul';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Cod de bare nou scanat: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Scoateți toate produsele din carusel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Vă rugăm să scanați cel puțin două produse pentru a le compara';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Faceți clic pentru a compara produsele pe care le-ați scanat';

  @override
  String get scan_product_loading => 'Ați scanat\nde bare:';

  @override
  String get scan_product_loading_initial =>
      'Căutăm acest produs!\nVă rugăm să aşteptaţi câteva secunde…';

  @override
  String get scan_product_loading_long_request =>
      'Încă căutăm acest produs!\nConsiderați că durează mult timp să se încarce? La fel suntem…';

  @override
  String get scan_product_loading_unresponsive =>
      'Încă căutăm acest produs.\nDoriți să reporniți căutarea?';

  @override
  String get scan_product_loading_restart_button => 'Reporniți căutarea';

  @override
  String get portion_calculator_description =>
      'Calculează valorile nutriționale pentru o anumită cantitate';

  @override
  String get portion_calculator_hint => 'Cantitate în';

  @override
  String get portion_calculator_accessibility =>
      'Introduceți o cantitate pentru a calcula valorile nutriționale';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Vă rugăm să introduceți o cantitate între $min și $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Date lipsă. Calculul nu a putut fi efectuat.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Valori nutriționale pentru $grams g (sau ml)';
  }

  @override
  String get offline_data => 'Date offline';

  @override
  String get ocr_image_upload_instruction =>
      'Încărcați o imagine pentru a extrage automat informațiile pe care le conține.';

  @override
  String get upload_image => 'Încarcă o fotografie';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Nu s-a putut descărca imaginea';

  @override
  String get image_edit_url_error =>
      'Nu s-a putut edita imaginea deoarece adresa URL a imaginii nu a fost setată.';

  @override
  String get user_picture_source_remember => 'Memorează alegerea mea';

  @override
  String get user_picture_source_ask => 'Întreabă de fiecare dată';

  @override
  String get robotoff_continue => 'Continuați';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count întrebări',
      one: 'intrebare',
    );
    return 'Următorul $_temp0';
  }

  @override
  String get show_password => 'Afișează parola';

  @override
  String get owner_field_info_title => 'Valorile furnizate de producător';

  @override
  String get owner_field_info_message =>
      'Cu acel logo evidențiem datele furnizate de producător și care pot fi ineditate.';

  @override
  String get owner_field_info_close_button => 'Închideți aceste informații';

  @override
  String get owner_field_image =>
      'Această imagine este furnizată de producător. Este posibil să nu poată fi editată.';

  @override
  String get edit_packagings_title => 'Componente de ambalare';

  @override
  String get edit_packagings_element_add => 'Adăugați o componentă de ambalare';

  @override
  String get edit_packagings_completed => 'Ambalajul este complet';

  @override
  String edit_packagings_element_title(int index) {
    return 'Componenta ambalajului #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Număr de unități';

  @override
  String get edit_packagings_element_hint_units =>
      'Introduceți numărul de unități de ambalare de aceeași formă și material conținute în produs.';

  @override
  String get edit_packagings_element_field_shape => 'Formă';

  @override
  String get edit_packagings_element_hint_shape =>
      'Introduceți numele formei afișat în instrucțiunile de reciclare dacă sunt disponibile sau selectați o formă.';

  @override
  String get edit_packagings_element_example_shape => 'Sticla';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Introduceți materialul specific dacă poate fi determinat (un cod de material în interiorul unui triunghi poate fi găsit adesea pe piesele de ambalaj) sau un material generic (de exemplu plastic sau metal) dacă nu sunteți sigur.';

  @override
  String get edit_packagings_element_example_material => 'Sticlă';

  @override
  String get edit_packagings_element_field_recycling =>
      'Instrucțiuni de reciclare';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Introduceți instrucțiunile de reciclare numai dacă sunt enumerate pe produs.';

  @override
  String get edit_packagings_element_example_recycling => 'Reciclează';

  @override
  String get edit_packagings_element_field_quantity =>
      'Cantitatea netă de produs pe unitate';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Introduceți greutatea netă sau volumul net și indicați unitatea (de exemplu, g sau ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Greutatea unei unități goale (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Îndepărtați orice mâncare rămasă și spălați și uscați ambalajul înainte de cântărire. Dacă este posibil, utilizați o cântar cu precizie de 0,1 g sau 0,01 g.';

  @override
  String get background_task_title => 'Contribuții în așteptare';

  @override
  String get background_task_subtitle =>
      'Contribuțiile dvs. sunt salvate automat pe serverul nostru, dar nu întotdeauna în timp real.';

  @override
  String get background_task_list_empty =>
      'Nu există sarcini de fundal în așteptare';

  @override
  String get background_task_error_server_time_out => 'Expirare server';

  @override
  String get background_task_error_no_internet =>
      'Eroare de conexiune la internet. Încercați mai târziu.';

  @override
  String get background_task_operation_unknown => 'tip de operație necunoscut';

  @override
  String get background_task_operation_details => 'modificări detaliate';

  @override
  String get background_task_operation_image => 'încărcare fotografie';

  @override
  String get background_task_operation_refresh =>
      'reîmprospătarea a fost întârziată după încărcarea fotografiei';

  @override
  String get background_task_run_started => 'a început';

  @override
  String get background_task_run_not_started => 'încă nu a început';

  @override
  String get background_task_run_to_be_deleted => 'urmează să fie șterse';

  @override
  String get background_task_question_stop =>
      'Doriți să opriți această sarcină cât mai curând posibil?';

  @override
  String get feed_back => 'Părere';

  @override
  String get undo => 'Anulează';

  @override
  String get copy_email_to_clip_board => 'Copiați e-mailul în clipboard';

  @override
  String get please_send_us_an_email_to =>
      'Vă rugăm să ne trimiteți manual un e-mail la';

  @override
  String get email_copied_to_clip_board =>
      'E-mailul a fost copiat în clipboard!';

  @override
  String get select_accent_color => 'Selectaţi culoarea de accent';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Albastru';

  @override
  String get color_cyan => 'Turcoaz';

  @override
  String get color_green => 'Verde';

  @override
  String get color_light_brown => 'Implicit';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Portocaliu';

  @override
  String get color_pink => 'Roz';

  @override
  String get color_red => 'Roșu';

  @override
  String get color_rust => 'Ruginiu';

  @override
  String get color_teal => 'Turcoaz';

  @override
  String get text_contrast_mode => 'Contrastul textului';

  @override
  String get contrast_high => 'Ridicat';

  @override
  String get contrast_medium => 'Mediu';

  @override
  String get contrast_low => 'Scăzut';

  @override
  String get product_refresher_internet_not_found =>
      'Produsul nu a fost găsit!';

  @override
  String get product_refresher_internet_not_connected =>
      'Nu ești conectat la internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server inactiv ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Eroare de server ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produsul nu a fost găsit!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Un produs cu următorul cod de bare nu există în baza noastră de date: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Fără conexiune internet!';

  @override
  String get product_loader_network_error_message =>
      'Vă rugăm să verificați dacă smartphone-ul dvs. este într-o rețea WiFi sau are date mobile activate';

  @override
  String get page_not_found_title => 'Pagina nu a fost găsită!';

  @override
  String get page_not_found_button => 'Reveniți la pagina de pornire';

  @override
  String get download_data => 'Descărcați date';

  @override
  String get download_top_products =>
      'Descărcați primele 1000 de produse din țara dvs. pentru scanare instantanee';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produse',
      few: '$count produse',
    );
    return 'Descărcați partea de sus $_temp0 în țara dvs. pentru scanare instantanee';
  }

  @override
  String get download_in_progress =>
      'Descărcarea datelor\nAceasta poate dura ceva timp';

  @override
  String downloaded_products(int num) {
    return '$num produse adăugate';
  }

  @override
  String get update_offline_data => 'Actualizați datele despre produse offline';

  @override
  String get update_local_database_sub =>
      'Actualizați baza de date locală a produselor cu cele mai recente date de la Open Food Facts';

  @override
  String get clear_local_database => 'Ștergeți datele despre produse offline';

  @override
  String get clear_local_database_sub =>
      'Ștergeți toate datele despre produse locale din aplicație pentru a elibera spațiu';

  @override
  String deleted_products(int num) {
    return '$num produse șterse';
  }

  @override
  String get loading => 'Se încarcă…';

  @override
  String get know_more => 'Aflați mai multe';

  @override
  String get offline_data_desc =>
      'Faceți clic pentru a afla mai multe despre datele offline';

  @override
  String get offline_product_data_title => 'Date despre produse offline';

  @override
  String available_for_download(int num) {
    return '$num produse disponibile pentru scanare imediată';
  }

  @override
  String get country_selector_title => 'Selectează țara:';

  @override
  String get currency_selector_title => 'Selectați moneda dvs.:';

  @override
  String get language_selector_title => 'Selectați limba dvs.:';

  @override
  String get language_selector_section_selected => 'Limbi selectate';

  @override
  String get language_selector_section_frequently_used => 'Utilizat frecvent';

  @override
  String get action_delete_list => 'Ştergeţi';

  @override
  String get action_change_list => 'Schimbați lista curentă';

  @override
  String get product_list_create => 'Crează';

  @override
  String get product_list_create_tooltip => 'Creați o listă nouă';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Calcul nou)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Calcul nou)';

  @override
  String get nutriscore_unknown => 'Nutri-Score necunoscut';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score necunoscut (calcul nou)';

  @override
  String get nutriscore_not_applicable => 'Scorul nutrițional nu se aplică';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Scorul Nutri nu este aplicabil (calcul nou)';

  @override
  String get environmental_score_generic_new => 'Scor Ecologic';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'Scor verde necunoscut';

  @override
  String get environmental_score_not_applicable_new =>
      'Scorul verde nu este aplicabil';

  @override
  String get nova_group_generic_new => 'Alimente ultraprocesate - grupuri NOVA';

  @override
  String get nova_group_1 => 'Grupa 1 NOVA';

  @override
  String get nova_group_2 => 'Grupa 2 NOVA';

  @override
  String get nova_group_3 => 'Grupa 3 NOVA';

  @override
  String get nova_group_4 => 'Grupa 4 NOVA';

  @override
  String get nova_group_unknown => 'Grupul NOVA necunoscut';

  @override
  String get nutrition_facts => 'Nivelurile de nutrienți';

  @override
  String get faq_title_partners => 'Partenerii și Patronii ONG-ului';

  @override
  String get faq_title_vision =>
      'The Open Food Facts Viziune, misiune, valori și programe';

  @override
  String get faq_title_install_beauty =>
      'Instalați Open Beauty Facts pentru a crea o bază de date cu produse cosmetice';

  @override
  String get faq_title_install_pet =>
      'Instalați Open Pet Food Facts pentru a crea o bază de date cu alimente pentru animalele de companie';

  @override
  String get faq_title_install_product =>
      'Instalați Open Products Facts pentru a crea o bază de date de produse pentru a prelungi durata de viață a obiectelor';

  @override
  String get faq_nutriscore_nutriscore =>
      'Noul calcul al Nutri-Score: ce este nou?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importați-vă produsele în Open Food Facts';

  @override
  String get contact_title_pro_email => 'Contact producător';

  @override
  String get contact_title_press_page => 'Apăsați Pagina';

  @override
  String get contact_title_press_email => 'Apăsați Contact';

  @override
  String get contact_title_newsletter => 'Abonează-te la newsletter-ul nostru';

  @override
  String get contact_title_calendar =>
      'Abonează-te la calendarul comunității noastre';

  @override
  String get hunger_games_loading_line1 =>
      'Vă rugăm să ne acordați câteva secunde…';

  @override
  String get hunger_games_loading_line2 => 'Descărcăm întrebările!';

  @override
  String get hunger_games_error_label =>
      'Of! Ceva nu a mers bine...și nu am putut încărca întrebările.';

  @override
  String get hunger_games_error_retry_button => 'Să reîncercăm!';

  @override
  String get reorder_attribute_action => 'Reordonați atributele';

  @override
  String get link_cant_be_opened =>
      'Acest link nu poate fi deschis pe dispozitivul dvs. Vă rugăm să verificați dacă aveți un browser instalat.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detalii pentru $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detalii pentru $pageName cu $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Distribuiți';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Unde găsesc noul calcul Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score este aplicat în 7 țări: Franța, Germania, Belgia, Spania, Luxemburg, Olanda și Elveția.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Producătorii au la dispoziție cel mult **2 ani** de la semnarea decretului **pentru a înlocui** vechiul calcul cu cel nou.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Scor Ecologic';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Ce este Scorul Verde?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score este un logo care își propune să vă informeze despre **impactul alimentelor asupra mediului**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Codul de culori variază de la verde închis (**A+**) pentru produsele cu **cel mai mic impact** la roșu închis (**F**) pentru produsele cu **cel mai mare impact**.';

  @override
  String get guide_greenscore_logos_caption => 'Logourile Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Nucleul: Evaluarea ciclului de viață (ACV)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'O evaluare științifică a categoriilor de alimente';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Pentru fiecare categorie de produse, se stabilește un scor **de referință** folosind date din baza de date de mediu Agribalyse (concepută de ADEME și INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Analiza ciclului de viață** este o metodă standardizată de evaluare pentru efectuarea unei evaluări de mediu în mai multe etape și mai multe criterii.';

  @override
  String get guide_greenscore_lca_arg1_text3 => 'Măsoară:';

  @override
  String get guide_greenscore_lca_arg2_title => '6 etape de producție';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agricultură';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Prelucrare';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Ambalare';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribuție';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumul';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicatori de impact asupra mediului';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Schimbările climatice/amprenta de carbon';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Epuizarea stratului de ozon';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiații ionizante';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Teren';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Consumul de apă și energie';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Poluarea aerului';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Apă marină și dulce (particule, acidificare, eutrofizare)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Epuizarea resurselor.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonusuri și penalizări';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Pentru a recompensa produsele mai bune dintr-o anumită categorie, aplicăm **bonusuri și penalizări bazate pe mai multe criterii**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mod de producție';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'Un **bonus** se acordă produselor care au o **etichetă oficială, o etichetă sau o certificare care garantează beneficii pentru mediu** (organic, comerț echitabil, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Originea ingredientelor';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'Un **bonus** este acordat în funcție de originea ingredientelor. Acest bonus ia în considerare **impactul asupra transportului** și, de asemenea, **politica de mediu** a țării fiecărui producător.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Specii amenințate';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Se aplică o **penalizare** produselor care conțin ingrediente cu impacturi negative semnificative asupra biodiversității și ecosistemelor, cum ar fi uleiul de palmier, a cărui producție este responsabilă pentru defrișări masive.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Ambalare';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'O **penalizare** este calculată pentru a ține cont de **circularitatea ambalajelor** (utilizarea de materii prime reciclate și reciclabilitatea) și de ambalarea excesivă.';

  @override
  String get guide_greenscore_transparency_title =>
      'O necesitate sporită de transparență pentru o mai bună măsurare și reducere a impactului asupra mediului';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Pentru a calcula cu exactitate Green-Score, este necesar să existe **informații care nu sunt neapărat specificate pe ambalaj** (cum ar fi originea și procentul exact al fiecărui ingredient) sau care sunt rareori disponibile într-o formă utilizabilă (cum ar fi o listă a tuturor componentelor ambalajului cu tipurile precise de materiale plastice utilizate).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Valorile medii sunt folosite atunci când aceste informații nu sunt încă disponibile**, dar acum facem apel la toată lumea să ne ajute să colectăm aceste informații, care vor fi foarte utile pentru Green-Score, dar și pentru multe alte utilizări.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Cum pot cetățenii să ajute?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Toți cetățenii ne pot ajuta să adunăm și să structurăm informațiile prezente pe produse sau care pot fi deduse din acestea, cum ar fi informațiile despre **ambalaje**: „Misiunea Ambalajelor”: un inventar colaborativ la scară largă al ambalajelor pentru toate produsele alimentare (în franceză).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Cum pot ajuta producătorii';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Producătorii ne pot trimite informațiile lor direct prin intermediul platformei noastre gratuite pentru producători.';

  @override
  String get guide_greenscore_better_product_title =>
      'Ce produs este mai bun pentru planetă?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Poate fi greu de spus';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Alegerea alimentelor sustenabile este unul dintre cele mai importante lucruri pe care le putem face pentru climă, deoarece **sistemul nostru alimentar global este responsabil pentru peste un sfert din totalul emisiilor de gaze cu efect de seră**.\n(Sursa: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Tu ai puterea!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Vestea bună este că acest lucru ne oferă o modalitate puternică de a crea schimbare.\n**Fiecare dintre noi mănâncă în jur de 1.000 de mese în fiecare an**. Asta înseamnă 1.000 de oportunități de a **alege un viitor mai bun pentru planetă**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Ajută la a fi responsabil și la a lua decizii';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Alegerea alimentelor sustenabile poate părea complexă. Etichetele sunt confuze, iar informațiile lipsesc adesea. Scorul Verde a fost creat pentru a simplifica lucrurile, oferindu-vă un rating ecologic **clar**, **bazat pe informații științifice** și **transparent** pentru produsele alimentare, exact acolo unde aveți nevoie de el: atunci când faceți cumpărături.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparenţă';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Spre deosebire de etichetele proprietare, calculul Green-Score este **complet deschis** și poate fi **verificat de oricine**.';

  @override
  String get guide_nova_title => 'Alimente ultraprocesate';

  @override
  String get guide_nova_what_is_nova_title => 'Ce este ultra-procesarea?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Grupurile NOVA vă informează despre nivelul de procesare a alimentelor.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Clasificarea NOVA permite clasificarea alimentelor în **4 grupe** în funcție de **gradul lor de procesare industrială** (alimente minim procesate sau neprocesate, ingrediente culinare, alimente procesate, alimente ultra-procesate).';

  @override
  String get guide_nova_logos_caption => 'Logourile NOVA';

  @override
  String get guide_nova_groups_title => 'Cele 4 grupuri NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Există 4 grupuri NOVA, cea problematică fiind Grupa 4 - Alimente ultraprocesate.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Alimente minimal procesate sau neprocesate';

  @override
  String get guide_nova_groups_arg1_text =>
      'Alimentele neprocesate (sau naturale) sunt **părțile comestibile ale plantelor** (semințe, fructe, frunze, tulpini, rădăcini) **sau animalelor** (mușchi, organe, ouă, lapte), precum și ciupercile, algele și apa, după ce au fost separate din natură.';

  @override
  String get guide_nova_groups_arg2_title => 'Ingrediente culinare prelucrate';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Hrană procesată';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to Group 1** foods. processes include Various preservation Or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed Foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they Can be Eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Alimente ultraprocesate';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these Formulations usually Include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of Energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, And gluten.';

  @override
  String get guide_nova_explanations_title => 'Problemele cu ultra-procesarea';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Prelucrarea extremă a ingredientelor alimentare';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Multe sunt **derivate din procesarea ulterioară a constituenților alimentari**, cum ar fi uleiurile hidrogenate sau interesterificate, proteinele hidrolizate, izolatul proteic din soia, maltodextrina, zahărul invertit și siropul de porumb cu conținut ridicat de fructoză.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Aditivi care depășesc simpla siguranță alimentară';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Aditivii din alimentele ultraprocesate includ unii care sunt utilizați și în alimentele procesate, cum ar fi conservanții, antioxidanții și stabilizatorii. Clasele de aditivi care se găsesc doar în produsele ultraprocesate includ pe cei utilizați **pentru a imita sau a spori calitățile senzoriale ale alimentelor sau pentru a deghiza aspectele neplăcute ale produsului final**. Acești aditivi includ coloranți și alte culori, stabilizatori de culoare; arome, potențiatori de aromă, îndulcitori fără zahăr; și adjuvanți tehnologici, cum ar fi agenți de carbonatare, de întărire, de volumizare și anti-volumizare, agenți de antispumare, antiaglomeranți și de glazurare, emulgatori, sechestranți și umectanți.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Prelucrare pe care nu o poți face acasă';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**O multitudine de secvențe de procese sunt utilizate** pentru a combina ingredientele, de obicei numeroase, și pentru a crea produsul final (de unde și „ultra-procesat”). Procesele includ mai multe **fără echivalente interne**, cum ar fi hidrogenarea și hidroliza, extrudarea și turnarea, precum și pre-procesarea pentru prăjire.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Aspectele prădătoare și financiare ale ultra-procesării';

  @override
  String get guide_nova_explanations_arg4_text =>
      'Scopul general al ultra-procesării este de a crea produse alimentare de marcă, convenabile (durabile, gata de consum), atractive (hiper-palatabile) și extrem de profitabile (ingrediente cu costuri reduse), concepute pentru a înlocui toate celelalte grupe de alimente. Produsele alimentare ultra-procesate sunt de obicei ambalate atractiv și comercializate intensiv.';

  @override
  String get guide_nova_explanations_arg5_title => 'Un pericol pentru sănătate';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Din 2018, cu NutriNet-Santé, au fost evidențiate primele legături între **consumul de alimente ultra-procesate și riscurile crescute de cancer, boli cardiovasculare și diabet**. Astăzi, peste 90 de studii la nivel mondial confirmă aceste descoperiri.\nCele mai puternice asocieri se referă la **obezitate, mortalitate cardiovasculară și simptome depresive**. La copii, efectele sunt observate în principal asupra greutății și dezechilibrelor lipidice.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Țările recomandă limitarea acestora';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Unele țări utilizează grupurile NOVA pentru ghidurile sau obiectivele lor alimentare, de exemplu:\n\n- **🇧🇷 Ghidurile alimentare ale Braziliei** **recomandă limitarea consumului** de alimente procesate și evitarea alimentelor ultra-procesate.\n\n- **🇫🇷 Obiectivele politicii nutriționale de sănătate publică a Franței** pentru perioada 2018-2022 vizează **reducerea consumului de alimente ultra-procesate din grupa 4 cu 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title =>
      'Bine ați venit la Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Ce este Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts este o bază de date **colaborativă**, **gratuită** și **deschisă** cu produse alimentare din întreaga lume.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Credem că toată lumea ar trebui să aibă acces la informații despre ceea ce mănâncă. Prin colectarea de date despre ingrediente, alergeni, informații nutriționale și multe altele, **le oferim consumatorilor puterea de a face alegeri informate** și conducem industria alimentară **către o mai mare transparență**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Caracteristici ale Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Primește alerte pentru ingredientele nedorite';

  @override
  String get guide_open_food_facts_tips_title =>
      'Sfaturi pentru a face fotografii grozave';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Ce să nu faci';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Evitați umbrele și strălucirea.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Fără text neclar sau nefocalizat.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Nu decupați părți din text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Evitați fundalurile aglomerate.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Ce trebuie să faci';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Folosește o iluminare bună și uniformă.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Asigurați-vă că textul este clar și lizibil.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capturați întreaga listă de ingrediente.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Păstrați produsul pe o suprafață plană.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Ajutați-ne să construim „Wikipedia Alimentației”';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Un scor privind calitatea nutrițională';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Un scor pentru a evita alimentele ultra-procesate';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Un scor pentru planetă';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ro.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Bine ați venit la Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Care sunt informațiile despre hrana pentru animale de companie?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts își extinde misiunea către prietenii noștri blănoși! Este o **bază de date cu produse alimentare pentru pisici, câini și alți companioni**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Colectăm informații despre **ingrediente**, **analize nutriționale** și îndrumări de hrănire pentru a ajuta proprietarii de animale de companie să aleagă cea mai bună hrană pentru nevoile animalelor lor.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Caracteristicile hranei deschise pentru animale de companie';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Primește alerte pentru ingredientele nedorite';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Animalul tău de companie este alergic la vreun ingredient? Poți seta o listă de ingrediente cosmetice de evitat, direct în aplicație!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Sfaturi pentru a face fotografii grozave';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Ce să nu faci';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Evitați umbrele și strălucirea.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Fără text neclar sau nefocalizat.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Nu decupați părți din text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Evitați fundalurile aglomerate.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Ce trebuie să faci';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Folosește o iluminare bună și uniformă.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Asigurați-vă că textul este clar și lizibil.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capturați întreaga listă de ingrediente.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Păstrați produsul pe o suprafață plană.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'O notă despre punctaj';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Dezvoltarea unui sistem de notare pentru hrana animalelor de companie **nu este o prioritate în acest moment**. Metodologia ar fi complexă, deoarece nevoile nutriționale variază foarte mult în funcție de specie, vârstă și stare de sănătate. Nu am găsit încă nicio echipă științifică independentă, capabilă să dezvolte un astfel de scor.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ro.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Bine ați venit la Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Ce este Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts este o bază de date colaborativă de **produse cosmetice**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Scopul nostru este să descifrăm listele de ingrediente pentru a vă ajuta să **înțelegeți ce conțin produsele dumneavoastră de îngrijire personală**. De la creme hidratante la machiaj, colectăm date despre ingrediente, alergeni și ambalaje pentru a promova transparența în industria cosmetică.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Caracteristici ale Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Primește alerte pentru ingredientele nedorite';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Ești alergic la vreun ingredient? Vrei să eviți substanțele comedogene? Vrei să te ferești de componentele controversate? Poți seta o listă de ingrediente cosmetice de evitat, direct în aplicație!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Sfaturi pentru a face fotografii grozave';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Ce să nu faci';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Evitați umbrele și strălucirea.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Fără text neclar sau nefocalizat.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Nu decupați părți din text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Evitați fundalurile aglomerate.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Ce trebuie să faci';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Folosește o iluminare bună și uniformă.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Asigurați-vă că textul este clar și lizibil.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capturați întreaga listă de ingrediente.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Faceți câte fotografii este nevoie dacă sticla este curbată.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'S-ar putea să fie nevoie să dezlipiți eticheta pentru a vedea lista ingredientelor.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Păstrați produsul pe o suprafață plană.';

  @override
  String get guide_open_beauty_facts_scores_title => 'O notă despre punctaj';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Spre deosebire de produsele alimentare, lumea cosmeticelor **nu are un sistem de notare recunoscut universal și susținut de guvern, precum Nutri-Score**. Efectele ingredientelor pot fi extrem de personale și depind de tipul de piele, alergii și preocupări individuale.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ro.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Bine ați venit la Prețuri Deschise!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Ce sunt prețurile deschise?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices este un proiect care are ca scop **colectarea și partajarea prețurilor produselor din întreaga lume**. Este un set de date disponibil publicului, care poate fi utilizat pentru cercetare, analiză și multe altele. Open Prices este dezvoltat și întreținut de Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title =>
      'Cum funcționează Prețurile Deschise?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Utilizăm crowdsourcing pentru a obține un set de date open-source cu prețuri.** Prețurile pot fi adăugate de utilizatori prin intermediul acestei aplicații web sau prin intermediul aplicației mobile oficiale Open Food Facts. Comercianții cu amănuntul sau aplicațiile terțe pot contribui, de asemenea, utilizând API-ul nostru.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Colectați fotografii cu etichetele de preț de pe culoar';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Colectați fotografii ale chitanțelor';

  @override
  String get guide_open_prices_why_title =>
      'De ce face Open Food Facts acest lucru?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informațiile despre prețuri sunt de o importanță capitală pentru înțelegerea sistemelor alimentare. Este un factor cheie în înțelegerea costului alimentelor și în promovarea unor diete mai sănătoase. Datele despre prețurile de deschidere reprezintă o modalitate de a facilita cercetătorilor, jurnaliștilor și cetățenilor **o mai bună înțelegere a modului în care prețurile alimentelor variază geografic și în timp**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Urmăriți evoluția prețurilor în timp';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Vedeți **evoluția prețurilor**: inflație scăzută, inflație ieftină, le putem urmări împreună!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Compară prețurile în apropierea ta';

  @override
  String get guide_open_prices_why_arg2_text =>
      'Pe măsură ce aflăm mai multe prețuri, puteți identifica **cele mai ieftine magazine din zona dumneavoastră**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Te-ai gândit să extragi prețurile de pe site-urile comercianților cu amănuntul?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Din motive legale și tehnice, **nu considerăm extragerea prețurilor de pe site-urile comercianților cu amănuntul ca o modalitate validă de a contribui la Open Prices**. Vrem să ne asigurăm că prețurile pe care le colectăm sunt corecte și actualizate, iar primirea de prețuri extrase de la contribuitori nu ne permite să facem acest lucru.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Extragerea datelor de preț este o opțiune luată în considerare într-o versiune viitoare a Open Prices, dar va fi făcută chiar de Open Prices, astfel încât să putem avea o dovadă a prețului pe baza paginii HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Puteți contribui cu prețuri folosind API-ul nostru.\nDacă doriți să contribuiți cu prețuri la scară largă, vă rugăm să ne contactați la prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Bine ați venit la Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Care sunt informațiile despre produsele deschise?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts este o bază de date masivă și deschisă pentru **orice produs cu cod de bare, care nu este hrană alimentară, cosmetică sau hrană pentru animale de companie**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'De la **electronice** la **jucării** și de la **haine** la **produse de curățenie**, dacă are un cod de bare, acesta poate fi adăugat. Acest proiect își propune să creeze un „Internet al Lucrurilor” pentru obiectele de zi cu zi, făcând informațiile despre acestea universal accesibile.';

  @override
  String get guide_open_products_facts_features_title =>
      'Caracteristici ale produselor deschise';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts își propune să ofere consumatorilor posibilitatea de a **prelungi durata de viață a obiectelor** prin furnizarea de soluții circulare pentru întreținerea, **repararea**, **reciclarea** obiectelor sau pentru a le oferi un nou proprietar.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Amprenta de carbon pentru unele produse';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impactul CO2** realizat de Autoritatea Franceză pentru Mediu (ADEME) oferă **impactul carbonului** pentru mai multe categorii. Asigurați-vă că clasificați produsele cu precizie.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Indicele de reparabilitate pentru multe produse';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Ori de câte ori este disponibil un indice de reparabilitate francez, îl vom afișa. În plus, **puteți începe să colectați variabilele folosind Motorul de Folksonomie**; astfel încât să îl putem recalcula noi înșine în viitor, chiar și în țările în care nu este disponibil.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Găsește modalități de a dona/revinzi produsul tău';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Oferim linkuri către **servicii terțe prietenoase cu mediul circular** care vă ajută să obțineți tipul de produs pe care îl căutați, ca produs la mâna a doua, pentru a fi mai ecologic cu resursele planetare.\nRețineți că nu suntem plătiți pentru acest lucru și că sistemul funcționează doar ca exemplu pentru două site-uri web din Franța. Puteți ajuta la extinderea acestui sistem documentând mai multe site-uri pe wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Ce informații sunt utile?';

  @override
  String get guide_open_products_facts_information_text =>
      'Pentru o gamă atât de largă de articole, **datele pe care le colectăm sunt flexibile**. Pentru a face acest lucru, **am creat Motorul de Folksonomie**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Motorul de folcsonomie';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Motorul de Folksonomie este un instrument care vă ajută să completați produse cu proprietăți relevante. Acest lucru ajută la îmbunătățirea căutării și a descoperirii, dar și la calcularea și afișarea lucrurilor interesante în viitor.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Puteți adăuga orice chei și valori, cum ar fi: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Vei primi autosugestii de posibile proprietăți și ești binevenit să adaugi și să documentezi altele noi pentru tipurile tale de produse preferate.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ro.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Preferințe alimentare deschise';

  @override
  String get guide_coming_soon_button_title => 'În curând';

  @override
  String get guide_learn_more_subtitle => 'Atingeți pentru a afla mai multe';

  @override
  String get preview_badge => 'Previzualizare';

  @override
  String get prices_feedback_form =>
      'Apasă aici pentru a ne trimite feedback-ul tău despre această nouă funcție!';

  @override
  String get menu_button_list_actions => 'Selectați o acțiune';

  @override
  String get error_loading_photo => 'Eroare la încărcarea fotografiei';

  @override
  String get photo_viewer_action_use_picture_as => 'Folosește ca…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Folosește această imagine ca…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Folosește această imagine ca… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Detalii';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detalii ale acestei fotografii';

  @override
  String get photo_viewer_details_title => 'Detalii ale fotografiei';

  @override
  String get photo_viewer_details_contributor_title => 'Colaborator';

  @override
  String get photo_viewer_details_size_title => 'Dimensiune';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixeli';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'URL-ul';

  @override
  String get product_page_compatibility_score => 'Compatibil';

  @override
  String get user_lists_action_multi_select => 'Selectare multiplă';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Scorul tău de compatibilitate: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Imaginea din față';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Imaginea cu ingredientele';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Tablou nutrițional';

  @override
  String get product_image_packaging_accessibility_label =>
      'Imaginea ambalajului';

  @override
  String get product_image_other_accessibility_label => 'Altă imagine';

  @override
  String get product_image_outdated_message =>
      'Această imagine poate fi învechită';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (această imagine poate fi învechită)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (această imagine poate fi blocată de producător)';
  }

  @override
  String get product_image_error => 'Nu se poate încărca imaginea!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Nu se poate încărca $type (eroare de rețea?)';
  }

  @override
  String get product_page_image_no_image_available => 'Nicio imagine\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Nu este disponibilă nicio imagine pentru acest produs';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reordonarea sau ascunderea acțiunilor';

  @override
  String get product_page_action_bar_setting_modal_title => 'Editați acțiunile';

  @override
  String get product_page_action_bar_item_move_up => 'Mută în sus';

  @override
  String get product_page_action_bar_item_move_down => 'Mută în jos';

  @override
  String get product_page_action_bar_item_enable => 'Activează acțiunea';

  @override
  String get product_page_action_bar_item_disable => 'Dezactivare acțiune';

  @override
  String get product_page_pending_operations_banner_title =>
      'Încărcarea editărilor…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Datele afișate pe această pagină **nu reflectă încă modificările dvs.**.\nVă rugăm să așteptați câteva secunde…';

  @override
  String get product_add_a_language => 'Adăugați o limbă';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Cod de bare $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Eliminați acest produs din carusel';

  @override
  String get carousel_unsupported_header => 'Cod de bare neacceptat!';

  @override
  String get carousel_unsupported_title => 'Oops!';

  @override
  String get carousel_unsupported_text =>
      'Codul de bare scanat nu este acceptat de Open Food Facts!';

  @override
  String get carousel_error_header => 'Eroare!';

  @override
  String get carousel_error_title => 'E o pacoste!';

  @override
  String get carousel_error_text_1 =>
      'Nu am putut descărca informații despre acest cod de bare:';

  @override
  String get carousel_error_text_2 =>
      'Vă rugăm să verificați conexiunea la internet sau să faceți clic pe acest buton:';

  @override
  String get carousel_error_button => 'Reîncercați';

  @override
  String get carousel_unknown_product_header => 'Produs necunoscut';

  @override
  String get carousel_unknown_product_title =>
      'Felicitări!\nAi găsit __bijuteria rară!__';

  @override
  String get carousel_unknown_product_text =>
      'Baza noastră de date colaborativă conține peste **3 milioane de produse**, dar acest cod de bare nu există: ';

  @override
  String get carousel_unknown_product_button => 'Adaugă acest produs';

  @override
  String get carousel_loading_header => 'Se încarcă informațiile...';

  @override
  String get carousel_loading_title =>
      'Tocmai ați scanat un produs cu următorul cod de bare:';

  @override
  String get carousel_loading_text =>
      'Îl căutăm în baza noastră de date cu peste **3 milioane de produse!**';

  @override
  String get product_type_subtitle_food =>
      'Legume, fructe, alimente congelate…';

  @override
  String get product_type_subtitle_beauty =>
      'Machiaj, săpunuri, paste de dinți…';

  @override
  String get product_type_subtitle_pet_food => 'Hrană pentru câini, pisici…';

  @override
  String get product_type_subtitle_product => 'Smartphone-uri, mobilă…';

  @override
  String get photo_field_front => 'Fotografie de produs';

  @override
  String get photo_field_ingredients => 'Foto ingrediente';

  @override
  String get photo_field_nutrition => 'Fotografie nutrițională';

  @override
  String get photo_field_packaging => 'Foto cu informații despre ambalaj';

  @override
  String get photo_already_exists => 'Această fotografie există deja';

  @override
  String get photo_missing => 'Această fotografie lipsește';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Rotire la stânga';

  @override
  String get photo_rotate_right => 'Rotire la dreapta';

  @override
  String get photo_undo_action => 'Anulați acțiunea anterioară';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'O hartă a lumii a $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Contribuitori OpenStreetMap';

  @override
  String get not_applicable_short => 'N / A';

  @override
  String get knowledge_panel_warning_text => 'Atenţie';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'De ce este acest Nutri-Score diferit de cel de pe ambalaj?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Există două explicații posibile:\nLista ingredientelor și/sau informațiile nutriționale nu sunt actualizate.\n\nVă oferim „Noul calcul” al Nutri-Score (sau V2). Vă rugăm să verificați dacă aveți bannerul „Noul calcul” pe ambalaj.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Verificați ingredientele';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Verificați informațiile nutriționale';

  @override
  String url_not_supported(String url) {
    return 'Din păcate, nu putem deschide adresa URL:\n$url';
  }

  @override
  String get product_list_export => 'Export';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'Vizualizați codul de bare';

  @override
  String get product_footer_action_barcode_short => 'Cod de bare';

  @override
  String get product_footer_action_open_website => 'Deschideți site-ul web';

  @override
  String get product_footer_action_report => 'Raport';

  @override
  String get product_footer_action_contributor_guide => 'Ajutor';

  @override
  String get product_footer_action_data_quality_tags => 'Calitatea datelor';

  @override
  String get product_page_tab_for_me => 'Pentru mine';

  @override
  String get product_page_tab_website => 'Site-ul web';

  @override
  String get product_page_tab_prices => 'Prețuri';

  @override
  String get prices_explanation_card_title => 'De ce prețuri?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** este un proiect de colectare și partajare a prețurilor produselor din întreaga lume 🌍. Open Prices este dezvoltat și întreținut de Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Afla mai mult';

  @override
  String get product_page_tab_folksonomy => 'Folcsonomie';

  @override
  String get folksonomy_explanation_card_title =>
      'Care sunt atributele folcsonomiei?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atributele sunt bazate pe **cheie-valoare**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Aceste proprietăți sunt create și depuse de contribuitori pentru orice fel de utilizări.';

  @override
  String get folksonomy_action_external_link_title =>
      'Deschideți linkul extern';

  @override
  String get folksonomy_action_external_link_warning =>
      'Linkurile externe pot fi periculoase. Chiar doriți să le vizitați?';

  @override
  String get prices_products_empty_title => 'Niciun preț disponibil';

  @override
  String get prices_products_empty_explanation => 'Fii primul care contribuie!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Cele mai $pageSize produse de top (total: $total)';
  }

  @override
  String get app_review_title => 'Îți place această aplicație?';

  @override
  String get app_review_low => 'Aș putea face mai bine';

  @override
  String get app_review_medium => 'Nu-i rău';

  @override
  String get app_review_high => 'Îmi place!';

  @override
  String get app_review_feedback_modal_title =>
      'Ajutați-ne să îmbunătățim aplicația noastră';

  @override
  String get app_review_feedback_modal_content =>
      'Dacă aveți câteva minute, puteți răspunde la acest formular pentru a **pute îmbunătăți în actualizările viitoare**:';

  @override
  String get app_review_feedback_modal_open_form => 'Răspundeți la formular';

  @override
  String get app_review_feedback_modal_later => 'Întreabă-mă mai târziu';

  @override
  String get nutrition_facts_extract_new =>
      'NOU: Poți extrage automat nutrienții din imagine!';

  @override
  String get nutrition_facts_extract_button_text => 'Extrageți acum';

  @override
  String get nutrition_facts_extract_in_progress => 'Extracție în curs…';

  @override
  String get nutrition_facts_extract_successful => 'Extracția a reușit';

  @override
  String get nutrition_facts_extract_failed =>
      'Nu s-au reușit extragerea nutrienților din imagine';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Statistici';

  @override
  String get prices_stats_title => 'Statistici ale prețurilor';

  @override
  String get prices_stats_prices_section => 'Prețuri';

  @override
  String get prices_stats_products_section => 'Produse';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Colaboratori';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Diverse';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consumul';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Mâncare';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Produse';

  @override
  String get prices_stats_pet_food => 'Hrană pentru animale de companie';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Țări';

  @override
  String get prices_stats_price_tag => 'Etichetă de preț';

  @override
  String get prices_stats_receipt => 'Chitanță';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Site-ul web';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API-ul';

  @override
  String get prices_stats_other => 'Altele';

  @override
  String get prices_stats_last_updated => 'Ultima actualizare pe';

  @override
  String get prices_stats_error =>
      'A apărut o eroare la încărcarea statisticilor.';

  @override
  String get product_edit_robotoff_question_answered => 'Întrebare răspunsă!';

  @override
  String get product_edit_robotoff_proof => 'Dovadă';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Prețuri';

  @override
  String get preferences_prices_subtitle =>
      'Gestionați-vă preferințele de preț';

  @override
  String get preferences_card_project => 'Proiectul Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuiți';

  @override
  String get preferences_my_contributions_title => 'Contribuțiile mele';

  @override
  String get preferences_my_stats_title => 'Statisticile mele';

  @override
  String get preferences_contribute_subtitle =>
      'Traduceți, îmbunătățiți instrumentele noastre…';

  @override
  String get preferences_connect_title => 'Conectează-te';

  @override
  String get preferences_connect_subtitle =>
      'Contactați-ne sau urmăriți-ne pe rețelele de socializare';

  @override
  String get preferences_support_title => 'Faceți o donație';

  @override
  String get preferences_support_subtitle =>
      'Ajutați-ne să informăm milioane de consumatori din întreaga lume';

  @override
  String get preferences_card_help => 'Ajutor și asistență';

  @override
  String get preferences_faq_title => 'Întrebări frecvente';

  @override
  String get preferences_faq_subtitle =>
      'Obțineți răspunsuri la întrebările dvs.';

  @override
  String get logged_out => 'Deconectat/ă';

  @override
  String get preferences_app_bar_message =>
      'Îți mulțumim că ești unul dintre membrii noștri!';

  @override
  String get preferences_app_bar_products_modified => 'Produse modificate';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Vezi toate statisticile';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Caută $provider după „$keyword”';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Căutați o setare (de exemplu, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Accesibilitate: Afișați emoji-uri';

  @override
  String get preferences_accessibility_remove_colors =>
      'Accesibilitate: Eliminați culorile';

  @override
  String get preferences_app_settings_products => 'Produse';

  @override
  String get preferences_card_about => 'Despre';

  @override
  String get preferences_legal_information_title => 'Informații juridice';

  @override
  String get preferences_legal_information_subtitle =>
      'Termeni de utilizare, politică de confidențialitate și multe altele';

  @override
  String get preferences_terms_of_use => 'Condiții de utilizare';

  @override
  String get preferences_legal_mentions => 'Mențiuni legale';

  @override
  String get preferences_legal_header =>
      'Open Food Facts este o bază de date cu produse alimentare **creată de toată lumea, pentru toată lumea**.\nO puteți folosi pentru a face alegeri alimentare mai bune și, deoarece sunt **date deschise**, oricine o poate **reutiliza în orice scop**.';

  @override
  String get preferences_privacy_policy => 'Politica de confidențialitate';

  @override
  String get preferences_licenses => 'Licențe';

  @override
  String get preferences_about_app_title => 'Despre aplicație';

  @override
  String get preferences_about_app_subtitle =>
      'Informații tehnice, informații pentru dezvoltatori și multe altele';

  @override
  String get preferences_card_information => 'Informaţii';

  @override
  String get preferences_version_number_title => 'Numărul versiunii';

  @override
  String get preferences_scanner_title => 'Scaner';

  @override
  String get preferences_app_store => 'Magazin de aplicații';

  @override
  String get preferences_app_system_settings => 'Setări de sistem';

  @override
  String get preferences_source_code => 'Accesați codul sursă';

  @override
  String get preferences_source_code_subtitle =>
      'Și începe să ai un impact pentru milioane de oameni';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Produse complete';

  @override
  String get preferences_tips => 'Sfaturi';

  @override
  String get tips_discover_nutriscore => 'Descoperă noul Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Pe site-ul Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Gestionează contul meu';

  @override
  String get preferences_manage_account_tooltip => 'Gestionează-ți contul';

  @override
  String get preferences_change_password_title => 'Schimbă-mi parola';

  @override
  String get preferences_danger_zone => 'Zonă periculoasă';

  @override
  String get preferences_account_deletion_subtitle =>
      'Toate contribuțiile tale vor fi pierdute';

  @override
  String get preferences_contributions_title => 'Contribuții';

  @override
  String get preferences_dev_mode_app_settings_title => 'Setările aplicației';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Metodă foarte experimentală de scanare a produselor offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Reîmprospătați toate produsele de pe server';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Vă rugăm să evitați să faceți asta decât dacă este absolut necesar';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Mod demonstrativ';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Adăugați carduri la scaner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Adaugă 3 produse eșantion la scaner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Gazdă de folcsonomie';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Gazdă: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experimente de accesibilitate';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Selecție multi-produse pentru prețuri';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Panouri de cunoștințe ordonate de utilizatori';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Acces temporar la căutarea locației';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Comparație alăturată pentru 2 sau 3 produse';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importul listei de produse';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Scoruri și metodologii';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Descoperă cum se calculează Nutri-Score-ul';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Descoperiți principalele modificări ale metodologiei';

  @override
  String get preferences_faq_discover_project_title => 'Descoperiți proiectul';

  @override
  String get preferences_faq_discover_off_title =>
      'Descoperiți informații despre alimentele deschise';

  @override
  String get preferences_faq_discover_obf_title =>
      'Descoperă informații despre frumusețea deschisă';

  @override
  String get preferences_faq_discover_opff_title =>
      'Descoperiți informații despre hrana deschisă pentru animale de companie';

  @override
  String get preferences_faq_discover_op_title => 'Descoperiți Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Descoperiți informații despre produsele deschise';

  @override
  String get preferences_faq_faq_title =>
      'Întrebări frecvente - Întrebări frecvente';

  @override
  String get preferences_faq_off_ngo_title => 'ONG-ul Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informaţii';

  @override
  String get preferences_connect_community_updates_title =>
      'Primește actualizări din comunitate';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Rămâi la curent cu noutățile din aplicație și din comunitate';

  @override
  String get preferences_connect_community_calendar_title =>
      'Abonează-te la calendarul comunității noastre';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Implică-te participând la unul dintre evenimentele noastre virtuale';

  @override
  String get preferences_connect_blog_title => 'Blogul Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Primiți cele mai recente știri, pe măsură ce apar';

  @override
  String get preferences_connect_community_help_title =>
      'Obțineți ajutor din partea comunității';

  @override
  String get preferences_connect_improve_app_title =>
      'Ajutați-ne să îmbunătățim aplicația';

  @override
  String get preferences_connect_debug_info_title =>
      'Trimiteți-ne informații de depanare';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Trimiteți-ne un e-mail cu informații detaliate despre depanare';

  @override
  String get preferences_connect_feedback_title =>
      'Trimiteți-ne feedback despre aplicație';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Ajută la modelarea viitorului aplicației';

  @override
  String get preferences_connect_survey_title =>
      'Completează sondajul despre aplicație';

  @override
  String get preferences_connect_survey_subtitle =>
      'Ajută-ne să înțelegem ce ar trebui să construim în continuare';

  @override
  String get preferences_connect_professionals_title => 'Profesioniști';

  @override
  String get preferences_connect_pro_subtitle =>
      'Total gratuit, asigură date precise pentru 500 de aplicații și milioane de consumatori. Autoservire, compatibil cu PIM-ul sau foile de calcul (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Contactați-ne pentru a începe';

  @override
  String get preferences_connect_press_title => 'Presa';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Obțineți toate materialele de care aveți nevoie pentru raportul dvs.';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Contactați-ne pentru solicitări de presă sau pentru a ne informa despre raportul dumneavoastră.';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Devino voluntar activ';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Dezvoltare, Comunicare, Design… orice fel de voluntariat sau expertiză este binevenită!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Descoperă câteva dintre numeroasele modalități prin care poți contribui';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Dezvoltarea de aplicații mobile';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Învață cum să contribui la dezvoltarea de software';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Versiuni instabile zilnice, funcții complet noi';

  @override
  String get preferences_contribute_local_community_title =>
      'Dezvoltă-ți comunitatea locală';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Ajutor cu traduceri de software, conținut, analize de ingrediente';

  @override
  String get preferences_contribute_share_subtitle =>
      'Am pregătit un mic șablon care să te ajute :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Pași simpli pentru a crește transparența alimentară în țara dumneavoastră';

  @override
  String get preferences_contribute_data_quality_title => 'Calitatea datelor';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Alătură-te echipei de calitate a datelor';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Alăturați-vă efortului nostru pentru a ne asigura că baza de date este completă și exactă';

  @override
  String get preferences_contributions_products_added_title =>
      'Produse adăugate';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Produse noi pe care le-am adăugat la Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produse pe care trebuie să le finalizez';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Toate produsele incomplete';

  @override
  String get preferences_my_contributions_prices_title => 'Prețuri';

  @override
  String get preferences_my_contributions_my_prices_title => 'Prețurile mele';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Prețurile mele, dovezile mele…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produse pe care le puteți ajuta să le finalizați';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ajută la calcularea Nutri-Score și Green-Score în țara ta';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Prețuri pe care le-am contribuit';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Etichete de preț și chitanțe';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Faceți fotografii ale chitanțelor și scanați codurile de bare asociate';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Faceți fotografii cu prețurile dintr-un magazin';

  @override
  String get preferences_prices_newest_title => 'Cele mai noi prețuri';

  @override
  String get preferences_prices_newest_subtitle =>
      'Ultimele prețuri adăugate de comunitatea Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Contribuitorii cu cele mai multe prețuri';

  @override
  String get preferences_prices_metrics_title =>
      'Metrici ale prețului de deschidere';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Urmărește evoluția proiectului';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Modalități de a contribui';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Confirmați prețurile adăugate de dvs. sau de alții, cu ajutorul inteligenței artificiale';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Adăugați rapid mai multe chitanțe sau fotografii cu rafturi din albumul foto';

  @override
  String get preferences_prices_challenges_title => 'Provocări lunare';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Participă la misiuni tematice lunare pentru a colecta prețuri';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Recuperează-ți datele de fidelitate';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Află cum să-ți soliciti datele';

  @override
  String get preferences_page_customize_app_title => 'Personalizați aplicația';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribuie la proiect';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Modalități simple de a ajuta la Open Food Informations';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologii de scorare, ajutor și multe altele despre proiect';

  @override
  String get product_edit_robotoff_positive_button => 'Acceptă sugestia';

  @override
  String get product_edit_robotoff_negative_button => 'Respinge sugestia';

  @override
  String get product_edit_robotoff_show_proof => 'Arată dovezi';

  @override
  String get product_edit_robotoff_expand_proof => 'Extindeți dovada';

  @override
  String get product_page_tab_raw_data => 'Date brute';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Pagina $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Pagina $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count din $total articole';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count din $total articole';
  }

  @override
  String item_count(int count) {
    return '$count articole';
  }

  @override
  String item_count_string(String count) {
    return '$count articole';
  }

  @override
  String get prices_no_result => 'Nu s-au găsit statistici despre prețuri.';

  @override
  String get prices_error_loading_more_items =>
      'Eroare la încărcarea mai multor elemente';

  @override
  String get prices_proof_error =>
      'Autentificarea a eșuat, imposibil de preluat dovezile';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count din $total dovezi';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count din $total contribuitori';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count din $total locații';
  }

  @override
  String prices_locations_count(int count) {
    return '$count locații';
  }

  @override
  String get restart_to_apply_message =>
      'Vă rugăm să reporniți aplicația pentru a aplica modificările.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interfață grafică';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Dezvoltare';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Laboratoare Deschise de Informații Alimentare';

  @override
  String get preferences_root_account_title => 'Cont';

  @override
  String get preferences_contribute_translate_header =>
      'Adu informații despre alimentele deschise în limba ta';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Înscrie-te în versiunea alfa a aplicației';

  @override
  String get preferences_dev_mode_section_data =>
      'Contribuții și date despre produse';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Nu afișați folcsonomia';

  @override
  String get preferences_account_title => 'Cont';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Adăugat la $created';
  }

  @override
  String get location_map_details_title => 'Detalii locație';

  @override
  String get location_map_details_name => 'Nume';

  @override
  String get location_map_details_street => 'Stradă';

  @override
  String get location_map_details_city => 'Oraş';

  @override
  String get location_map_details_postcode => 'Cod poștal';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordonate';

  @override
  String get location_map_details_osm_id => 'ID-ul OSM';
}
