// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class AppLocalizationsPl extends AppLocalizations {
  AppLocalizationsPl([String locale = 'pl']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Tak';

  @override
  String get add => 'Dodaj';

  @override
  String get account_delete_message =>
      'Czy na pewno chcesz usunąć swoje konto?\nJeśli istnieje konkretny powód, podziel się nim poniżej';

  @override
  String get reason => 'Powód';

  @override
  String get okay => 'OK';

  @override
  String get validate => 'Zweryfikuj';

  @override
  String get create => 'Stwórz';

  @override
  String get applyButtonText => 'Zastosuj';

  @override
  String get next_label => 'Następne';

  @override
  String get continue_label => 'Kontynuuj';

  @override
  String get exit_label => 'Wyjście';

  @override
  String get previous_label => 'Poprzednie';

  @override
  String get go_back_to_top => 'Powrót do góry';

  @override
  String get save => 'Zapisz';

  @override
  String get save_confirmation => 'Na pewno chcesz zapisać?';

  @override
  String get skip => 'Pomiń';

  @override
  String get cancel => 'Anuluj';

  @override
  String get ignore => 'Ignoruj';

  @override
  String get close => 'Zamknij';

  @override
  String get no => 'Nie';

  @override
  String get stop => 'Zatrzymaj';

  @override
  String get finish => 'Zakończ';

  @override
  String get calculate => 'Oblicz';

  @override
  String get reset_food_prefs => 'Zresetuj preferencje żywieniowe';

  @override
  String get error => 'Coś poszło nie tak';

  @override
  String get error_occurred => 'Wystąpił błąd';

  @override
  String get featureInProgress => 'Nadal pracujemy nad tą funkcją';

  @override
  String get label_web => 'Zobacz w internecie';

  @override
  String get learnMore => 'Dowiedz się więcej';

  @override
  String get unknown => 'Nieznany';

  @override
  String get match_very_good => 'Bardzo dobre dopasowanie';

  @override
  String get match_good => 'Dobre dopasowanie';

  @override
  String get match_poor => 'Słabe dopasowanie';

  @override
  String get match_may_not => 'Może nie pasować';

  @override
  String get match_does_not => 'Brak zgodności';

  @override
  String get match_unknown => 'Nie znaleziono powiązania';

  @override
  String get match_short_very_good => 'Bardzo dobre dopasowanie';

  @override
  String get match_short_good => 'Dobre dopasowanie';

  @override
  String get match_short_poor => 'Słabe dopasowanie';

  @override
  String get match_short_may_not => 'Może nie pasować';

  @override
  String get match_short_does_not => 'Brak zgodności';

  @override
  String get match_short_unknown => 'Nie znaleziono powiązania';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => 'Szukam';

  @override
  String get welcomeToOpenFoodFacts => 'Witamy w Open Food Facts';

  @override
  String get whatIsOff =>
      'OpenFoodFacts to globalna organizacja non-profit tworzona przez lokalne społeczności.';

  @override
  String get productDataUtility =>
      'Zobacz dane dotyczące żywności odpowiadające Twoim preferencjom.';

  @override
  String get healthCardUtility =>
      '▶ Wybierz produkty, które są dla Ciebie dobre.';

  @override
  String get ecoCardUtility =>
      'Wybierz produkty, które są dobre dla naszej planety.';

  @override
  String get server_error_open_new_issue =>
      'Serwer nie odpowiada! Możesz rozwiązać problem, klikając w ten link.';

  @override
  String get sign_in_text =>
      'Zaloguj się na swoje konto Open Food Facts, aby zapisać swój wkład';

  @override
  String get incorrect_credentials =>
      'Nieprawidłowa nazwa użytkownika lub hasło.';

  @override
  String get password_lost_incorrect_credentials =>
      'Ten adres e-mail lub nazwa użytkownika nie istnieje. Sprawdź swoje dane logowania.';

  @override
  String get password_lost_server_unavailable =>
      'Obecnie występują opóźnienia na naszych serwerach i przepraszamy za to. Spróbuj ponownie później.';

  @override
  String get login => 'Logowanie';

  @override
  String get login_result_type_server_unreachable => 'Sieć niedostępna';

  @override
  String get login_result_type_server_issue =>
      'Problem z serwerem. Spróbuj później.';

  @override
  String get login_page_username_or_email =>
      'Podaj nazwę użytkownika lub adres e-mail';

  @override
  String get login_page_password_error_empty => 'Proszę wpisać hasło';

  @override
  String get create_account => 'Utwórz konto';

  @override
  String get sign_in => 'Zaloguj się';

  @override
  String get sign_in_mandatory =>
      'Aby korzystać z tej funkcji, musisz się zalogować.';

  @override
  String get help_improve_country =>
      'Pomóż ulepszyć Open Food Facts w twoim kraju';

  @override
  String get sign_out => 'Wyloguj się';

  @override
  String get sign_out_confirmation => 'Jesteś pewny, że chcesz się wylogować?';

  @override
  String get password => 'Hasło';

  @override
  String get forgot_password => 'Nie pamiętam hasła';

  @override
  String get forgot_password_question => 'Zapomniałeś hasła?';

  @override
  String get view_profile => 'Zobacz profil';

  @override
  String get reset_password => 'Zresetuj hasło';

  @override
  String get reset_password_explanation_text =>
      'W przypadku zapomnienia hasła wpisz swoją nazwę użytkownika lub adres e-mail, aby otrzymać instrukcje do resetowania hasła. Pamiętaj o sprawdzeniu folderu \"Spam\".';

  @override
  String get username_or_email => 'Nazwa użytkownika lub e-mail';

  @override
  String get reset_password_done =>
      'Wiadomość e-mail z linkiem do zresetowania hasła została wysłana na adres e-mail powiązany z Twoim kontem. Sprawdź też folder \"Spam\"';

  @override
  String get send_reset_password_mail => 'Zmień hasło';

  @override
  String get enter_some_text => 'Wprowadź tekst';

  @override
  String get sign_up_page_title => 'Zarejestruj się';

  @override
  String get sign_up_page_action_button => 'Zarejestruj się';

  @override
  String get sign_up_page_action_doing_it => 'Trwa rejestracja…';

  @override
  String get sign_up_page_action_ok =>
      'Gratulacje! Twoje konto zostało utworzone.';

  @override
  String get sign_up_page_display_name_hint => 'Nazwa';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Wprowadź nazwę, której chcesz użyć';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mail jest wymagany';

  @override
  String get sign_up_page_email_error_invalid => 'Nieprawidłowy e-mail';

  @override
  String get sign_up_page_username_hint =>
      'Nazwa użytkownika: publicznie widoczna';

  @override
  String get sign_up_page_username_error_empty =>
      'Wpisz nazwę użytkownika (pseudonim)';

  @override
  String get sign_up_page_username_error_invalid =>
      'Proszę wprowadzić poprawną nazwę użytkownika';

  @override
  String get sign_up_page_username_description =>
      'Nazwa użytkownika nie może zawierać spacji, dużych liter ani znaków specjalnych.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Nazwa użytkownika nie może przekraczać $value znaków';
  }

  @override
  String get sign_up_page_password_hint => 'Hasło';

  @override
  String get sign_up_page_password_error_empty => 'Proszę wpisać hasło';

  @override
  String get sign_up_page_password_error_invalid =>
      'Proszę wprowadź prawidłowe hasło (co najmniej 6 znaków)';

  @override
  String get sign_up_page_confirm_password_hint => 'Potwierdź hasło';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Proszę potwierdź hasło';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Hasła nie zgadzają się (nie są identyczne)';

  @override
  String get sign_up_page_agree_text =>
      'Zgadzam się z Otwartymi Faktami Żywnościowymi';

  @override
  String get sign_up_page_terms_text =>
      'warunkami użytkowania i wkładu w Open Food Facts';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Przy zakładaniu konta zgoda na Warunki Użytkowania jest obowiązkowa; anonimowe wpisy mogą być nadal dokonywane za pośrednictwem aplikacji mobilnej';

  @override
  String get sign_up_page_producer_checkbox => 'Jestem producentem żywności';

  @override
  String get sign_up_page_producer_hint => 'Producent / Marka';

  @override
  String get sign_up_page_producer_error_empty =>
      'Proszę podać nazwę producenta lub marki';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Chcę się zapisać do newslettera Open Food Facts (Możesz zrezygnować w dowolnym momencie)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Ta nazwa już istnieje. Wybierz inną.';

  @override
  String get sign_up_page_email_already_exists =>
      'już istnieje, zaloguj się na konto lub spróbuj za pomocą innego adresu e-mail.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Podaj prawidłowy adres email.';

  @override
  String get sign_up_page_server_busy =>
      'Bardzo nam przykro, ale wystąpiły problemy techniczne z utworzeniem Twojego konta. Spróbuj ponownie później.';

  @override
  String get settingsTitle => 'Ustawienia';

  @override
  String get darkmode => 'Motyw';

  @override
  String get darkmode_dark => 'Tryb ciemny';

  @override
  String get darkmode_light => 'Tryb jasny';

  @override
  String get darkmode_system_default => 'Jak na urządzeniu';

  @override
  String get thanks_for_contributing => 'Dziękujemy za wkład!';

  @override
  String get contributors_label => 'Budują aplikację';

  @override
  String get contributors_dialog_title => 'Współtwórcy';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Współtwórca: $name';
  }

  @override
  String get contributors_description =>
      'Lista wszystkich współtwórców tej aplikacji';

  @override
  String get support => 'Pomoc techniczna';

  @override
  String get support_join_slack => 'Zapytaj o pomoc na naszym kanale Slack';

  @override
  String get support_via_forum => 'Poproś o pomoc na naszym forum';

  @override
  String get support_via_email => 'Wyślij do nas maila';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Wysłać dzienniki aplikacji?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Czy chcesz dołączyć logi aplikacji do wiadomości e-mail?';

  @override
  String get termsOfUse => 'Zasady korzystania';

  @override
  String get legalNotices => 'Informacje prawne';

  @override
  String get privacy_policy => 'Polityka Prywatności';

  @override
  String get about_this_app => 'O tej aplikacji';

  @override
  String get contribute => 'Wnieś wkład';

  @override
  String get contribute_sw_development => 'Usługi dla deweloperów';

  @override
  String get contribute_develop_text =>
      'Kod dla każdego produktu Open Food Facts jest dostępny na GitHub. Możesz ponownie użyć kodu (jest on open source) i pomóc nam go ulepszyć dla wszystkich nas na całej planecie.';

  @override
  String get contribute_develop_text_2 =>
      'Możesz dołączyć do Open Food Facts Slack, który jest preferowanym sposobem na zadawanie pytań.';

  @override
  String get contribute_develop_dev_mode_title => 'Tryb deweloperski (DEV)?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Aktywuj tryb deweloperski';

  @override
  String get contribute_donate_title => 'Podaruj';

  @override
  String get contribute_donate_header =>
      'Przekaż darowiznę na rzecz Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Prosimy o pamiętanie, że w wersji wewnętrznej alfa jest możliwa całkowita utrata danych, a aplikacja może stać się niezdatna do użytku w dowolnym momencie !';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Produkty do uzupełnienia';

  @override
  String get contribute_improve_header => 'Ulepszenie';

  @override
  String get contribute_improve_text =>
      'Podstawą projektu jest baza danych. Pomoc jest łatwa i bardzo szybka. Możesz pobrać aplikację mobilną na swój telefon i zacząć dodawać lub ulepszać produkty.\n\nZ drugiej strony, witryna Open Food Facts oferuje wiele sposobów na wniesienie wkładu: ';

  @override
  String get contribute_translate_header => 'Przetłumacz';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Zacznij tłumaczyć';

  @override
  String get contribute_translate_text =>
      'Open Food Facts jest globalnym projektem, obejmującym produkty z ponad 160 krajów. Open Food Facts jest tłumaczony na dziesiątki języków i zawiera ciągle ewoluującą zawartość.';

  @override
  String get contribute_translate_text_2 =>
      'Tłumaczenia są jednym z kluczowych zadań projektu';

  @override
  String get contribute_join_skill_pool =>
      'Podziel się swoimi umiejętnościami z Open Food Facts. Dołącz do grona osób, które podzieliły się swoimi umiejętnościami!';

  @override
  String get contribute_share_header =>
      'Udostępnij Open Food Fakty swoim znajomym';

  @override
  String get contribute_share_content =>
      'Chciałem Wam opowiedzieć o aplikacji, z której korzystam – Open Food Facts – która pozwala w spersonalizowany sposób sprawdzić wpływ Waszej żywności na zdrowie i środowisko. Działa poprzez skanowanie kodów kreskowych z opakowań. Co więcej, jest darmowa, nie wymaga rejestracji, a dzięki niej możecie zwiększyć liczbę odszyfrowanych produktów. Oto link do pobrania aplikacji na telefon: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Wprowadź ceny, żądając eksportu danych z kart lojalnościowych zgodnie z RODO';

  @override
  String get tap_to_answer => 'Kliknij tu, żeby odpowiedzieć na pytania';

  @override
  String get tap_to_answer_hint =>
      'Dotknij tutaj, aby odpowiedzieć na pytania dotyczące tego produktu';

  @override
  String get robotoff_questions_loading_hint =>
      'Poczekaj na załadowanie pytań dotyczących tego produktu';

  @override
  String get saving_answer => 'Zapisujemy odpowiedź';

  @override
  String get contribute_to_get_rewards =>
      'Dołącz do naszego ruchu na rzecz globalnej przejrzystości żywności';

  @override
  String get question_sign_in_text =>
      'Zaloguj się na swoje konto Open Food Facts, aby otrzymać uznanie za swój wkład';

  @override
  String get question_yes_button_accessibility_value => 'Odpowiedz \"tak\"';

  @override
  String get question_no_button_accessibility_value => 'Odpowiedz \"nie\"';

  @override
  String get question_skip_button_accessibility_value => 'Pomiń pytanie';

  @override
  String get tap_to_edit_search => 'Dotknij, aby edytować wyszukiwanie';

  @override
  String get myPreferences => 'Moje ustawienia';

  @override
  String get account_create_message =>
      'Załóż konto i dołącz do społeczności Open Food Facts, aby pomóc poszerzać wiedzę o żywności na całym świecie!';

  @override
  String get join_us => 'Dołącz do nas';

  @override
  String get myPreferences_profile_title => 'Profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Zarządzaj swoim kontem współautora Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Ustawienia';

  @override
  String get myPreferences_settings_subtitle => 'Tryb ciemny, Języki…';

  @override
  String get myPreferences_food_title => 'Preferencje żywieniowe';

  @override
  String get myPreferences_food_subtitle =>
      'Wybierz, które preferencje żywieniowe są dla Ciebie najważniejsze.';

  @override
  String get myPreferences_food_comment =>
      'Wybierz, które informacje o jedzeniu są dla Ciebie najważniejsze, aby uporządkować je według Twoich preferencji, wyświetlić informacje, które Cię interesują, w pierwszej kolejności i uzyskać podsumowanie zgodności. Te preferencje żywieniowe pozostają na Twoim urządzeniu i nie są powiązane z Twoim kontem Open Food Facts, jeśli je posiadasz.';

  @override
  String get confirmResetPreferences => 'Zresetować preferencje żywieniowe?';

  @override
  String get myPersonalizedRanking => 'Mój spersonalizowany ranking';

  @override
  String get ranking_tab_all => 'Wszystkie';

  @override
  String get ranking_subtitle_match_yes => 'Świetne dopasowanie dla Ciebie';

  @override
  String get ranking_subtitle_match_no => 'Bardzo słabe dopasowanie';

  @override
  String get ranking_subtitle_match_maybe => 'Nie znaleziono powiązania';

  @override
  String get refresh_with_new_preferences =>
      'Odśwież listę według nowych preferencji';

  @override
  String get reloaded_with_new_preferences =>
      'Odświeżono z nowymi preferencjami';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Skanuj';

  @override
  String get history_navbar_label => 'Historia';

  @override
  String get list_navbar_label => 'Listy';

  @override
  String get category => 'Filtruj według kategorii';

  @override
  String get category_all => 'Wszystkie';

  @override
  String get category_search => '(wyszukiwanie kategorii)';

  @override
  String get filter => 'Filtr';

  @override
  String get scan => 'Produkty z ekranu skanowania';

  @override
  String get scan_history => 'Historia skanowania';

  @override
  String get search => 'Wyszukiwanie';

  @override
  String get search_product_help => 'Wyszukaj produkt,\nmarkę lub kod kreskowy';

  @override
  String get search_filter => 'Filtr wyszukiwania';

  @override
  String get search_history => 'Historia wyszukiwania';

  @override
  String get search_store => 'Wyszukaj sklep';

  @override
  String get search_store_help => 'Wskazówka: dodaj miasto lub kraj';

  @override
  String get tap_for_more => 'Kliknij, aby wyświetlić więcej informacji…';

  @override
  String get product => 'Produkt';

  @override
  String get unknownBrand => 'Nieznana marka';

  @override
  String get unknownProductName => 'Nieznana nazwa produktu';

  @override
  String get label_refresh => 'Odśwież';

  @override
  String get label_reload => 'Przeładuj';

  @override
  String get image => 'Zdjęcie';

  @override
  String get front_photo => 'Zdjęcie z przodu';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (obraz może być nieaktualny)';
  }

  @override
  String get outdated_image_short_label => 'może być nieaktualny';

  @override
  String get ingredients => 'Składniki';

  @override
  String get ingredients_editing_instructions =>
      'Zachowaj oryginalną kolejność. Podaj wartość procentową, jeśli jest określona. Oddziel przecinkiem lub łącznikiem i użyj nawiasów dla składników danego składnika.';

  @override
  String get ingredients_editing_error => 'Nie udało się zapisać składników.';

  @override
  String get ingredients_editing_image_error =>
      'Nie udało się uzyskać nowego obrazu składników.';

  @override
  String get ingredients_editing_title => 'Edytuj składniki';

  @override
  String get ingredients_photo => 'Zdjęcie listy składników';

  @override
  String get packaging_editing_instructions =>
      'Wymień wszystkie części opakowania oddzielone przecinkiem lub nowym wierszem, podając ich ilość (np. 1 lub 6) rodzaj (np. butelka, pudełko, puszka), materiał (np. plastik, metal, aluminium) i, jeśli to możliwe, ich rozmiar (np. 330 ml) oraz instrukcje recyklingu.\nPrzykład: 1 szklana butelka do recyklingu, 1 plastikowy korek do wyrzucenia';

  @override
  String get packaging_editing_error =>
      'Nie udało się zapisać informacji o opakowaniu.';

  @override
  String get packaging_editing_image_error =>
      'Nie udało się pobrać zdjęcia nowego opakowania.';

  @override
  String get packaging_editing_title => 'Edytuj opakowanie';

  @override
  String get nutrition => 'Odżywianie';

  @override
  String get nutrition_facts_photo => 'Zdjęcie tabeli wartości odżywczych';

  @override
  String get nutrition_facts_editing_title => 'Edytuj informacje żywieniowe';

  @override
  String get packaging_information => 'Informacje dot. opakowania';

  @override
  String get packaging_information_photo =>
      'Zdjęcie informacji dotyczących opakowania';

  @override
  String get missing_product => 'Znalazłeś(-aś) nowy produkt!';

  @override
  String get add_product_take_photos =>
      'Zrób zdjęcia opakowania, aby dodać ten produkt do sekcji „Otwórz informacje o żywności”';

  @override
  String get add_product_take_photos_descriptive =>
      'Proszę najpierw dodać kilka zdjęć. Zawsze można dokończyć produkt później.';

  @override
  String get add_product_information_button_label =>
      'Dodaj informacje o produkcie';

  @override
  String get new_product => 'Nowy Produkt';

  @override
  String get new_product_found_title => 'Znaleziono nowy produkt!';

  @override
  String get new_product_found_text =>
      'Nasza wspólna baza danych zawiera ponad **3 miliony produktów**, ale ten kod kreskowy nie istnieje: ';

  @override
  String get new_product_found_button => 'Dodaj ten produkt';

  @override
  String get new_product_leave_title => 'Opuścić tę stronę?';

  @override
  String get new_product_leave_message =>
      'Wygląda na to, że nic nie wpisałeś. Czy naprawdę chcesz opuścić tę stronę?';

  @override
  String get new_product_dialog_description =>
      'Proszę o wykonanie zdjęć opakowania w celu dodania tego produktu do naszej wspólnej bazy danych';

  @override
  String get new_product_dialog_illustration_description =>
      'Ilustracja z nieznanym wynikiem Nutri-Score i Green Score';

  @override
  String get front_packaging_photo_button_label => 'Zdjęcie produktu z przodu';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Potwierdź przesłanie zdjęcia produktu';

  @override
  String get confirm_button_label => 'Potwierdź';

  @override
  String get send_image_button_label => 'Wyślij obraz';

  @override
  String get crop_page_action_saving => 'Zapisywanie obrazu…';

  @override
  String get crop_page_action_cropping => 'Przycinanie obrazu…';

  @override
  String get crop_page_action_local => 'Zapisywanie lokalnej wersji…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ups… coś jest nie tak z twoim zdjęciem!';

  @override
  String get crop_page_action_local_failed_message =>
      'Nie możemy przetworzyć obrazu lokalnie, przed wysłaniem go na nasz serwer. Spróbuj ponownie później lub skontaktuj się z nami, jeśli problem będzie się powtarzał.';

  @override
  String get crop_page_action_retake => 'Ponów zdjęcie';

  @override
  String get crop_page_too_small_image_title => 'Obraz jest za mały!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Minimalny rozmiar obrazu w pikselach wynosi: ${expectedMinWidth}x$expectedMinHeight. Obecne wymiary obrazu wynoszą: ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server =>
      'Przygotowywanie połączenia z serwerem…';

  @override
  String get front_packaging_photo_title => 'Zdjęcie opakowania z przodu';

  @override
  String get ingredients_photo_title => 'Zdjęcie listy składników';

  @override
  String get nutritional_facts_photo_title =>
      'Zdjęcie tabeli wartości odżywczych';

  @override
  String get recycling_photo_title => 'Zdjęcie informacji o recyklingu';

  @override
  String get take_photo_title => 'Zrób zdjęcie';

  @override
  String get take_more_photo_title => 'Zrób więcej zdjęć';

  @override
  String get front_photo_uploaded => 'Przesłano zdjęcie przodu';

  @override
  String get ingredients_photo_button_label => 'Zdjęcie listy składników';

  @override
  String get ingredients_photo_uploaded => 'Przesłano zdjęcie składników';

  @override
  String get nutrition_cache_loading_error =>
      'Nie można załadować składników odżywczych z pamięci podręcznej';

  @override
  String get nutritional_facts_photo_button_label =>
      'Zdjęcie tabeli wartości odżywczych';

  @override
  String get nutritional_facts_input_button_label =>
      'Wprowadź wartości odżywcze';

  @override
  String get nutritional_facts_added => 'Wartości odżywcze zostały dodane';

  @override
  String get categories_added => 'Kategorie dodane';

  @override
  String get new_product_title_nutriscore => 'Obliczanie Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Otrzymaj go, wypełniając kategorię żywności oraz wartości odżywcze';

  @override
  String get new_product_title_environmental_score => 'Obliczanie GreenScore';

  @override
  String get new_product_subtitle_environmental_score =>
      'Aby go zdobyć, wypełnij przynajmniej jedną kategorię';

  @override
  String get new_product_additional_environmental_score =>
      'Zwiększ dokładność obliczeń Green Score, uwzględniając pochodzenie, pakowanie i inne elementy';

  @override
  String get new_product_title_nova =>
      'Oblicz stopień przetworzenia jedzenia (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Otrzymaj go, wypełniając kategorię żywności oraz składniki';

  @override
  String get new_product_desc_nova_unknown =>
      'Poziom przetwarzania żywności nieznany';

  @override
  String get new_product_title_pictures => 'Zróbmy kilka zdjęć!';

  @override
  String get new_product_title_pictures_details =>
      'Zrób następujące zdjęcia, a silnik Open Food Facts może odtworzyć resztę!';

  @override
  String get new_product_title_misc => 'I trochę podstawowych danych…';

  @override
  String new_product_done_msg(String username) {
    return 'Dziękujemy za Twój wkład \"$username\"!';
  }

  @override
  String get new_product_done_msg_no_user => 'Dzięki za twój wkład!';

  @override
  String get new_product_done_button_label => 'Odkryj gotowy produkt';

  @override
  String get hey_incomplete_product_message =>
      'Kliknij, aby TERAZ odpowiedzieć na 3 pytania i obliczyć Nutri-Score, Green Score i Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Kliknij teraz, aby odpowiedzieć na 2 pytania, które pomogą Ci przeanalizować ten kosmetyk!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Kliknij teraz, aby odpowiedzieć na 3 pytania, które pomogą Ci przeanalizować tę karmę dla zwierząt!';

  @override
  String get hey_incomplete_product_message_product =>
      'Kliknij teraz, aby pomóc w dokończeniu tego produktu!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Przesłano zdjęcie z listą wartości odżywczych';

  @override
  String get recycling_photo_button_label =>
      'Zdjęcie informacji dotyczących Recyklingu';

  @override
  String get recycling_photo_uploaded => 'Przesłano zdjęcie dot. Recyklingu';

  @override
  String get take_more_photo_button_label => 'Zrób więcej zdjęć';

  @override
  String get other_photo_uploaded => 'Inne zdjęcie przesłane';

  @override
  String get retake_photo_button_label => 'Odzyskaj';

  @override
  String get selecting_photo => 'Wybieranie zdjęcia';

  @override
  String get uploading_image => 'Przesyłanie zdjęcia na serwer';

  @override
  String get uploading_image_type_front =>
      'Przesyłanie obrazu frontowego do Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Przesyłanie obrazu składników do Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Przesyłanie obrazu wartości odżywczych do Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Przesyłanie obrazu opakowania do Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Przesyłanie innego obrazu do Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Przesyłanie obrazu do Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Dodaj brakujące składniki';

  @override
  String get score_add_missing_packaging_image =>
      'Dodaj brakujący obraz opakowania';

  @override
  String get score_add_missing_nutrition_facts =>
      'Dodaj brakujące informacje o wartościach odżywczych';

  @override
  String get score_add_missing_product_traces =>
      'Dodaj brakujące ślady produktów';

  @override
  String get score_add_missing_product_category =>
      'Dodaj brakującą kategorię produktu';

  @override
  String get score_add_missing_precise_product_category =>
      'Wybierz bardziej precyzyjną kategorię';

  @override
  String get score_add_missing_product_countries =>
      'Dodaj brakujące kraje pochodzenia produktów';

  @override
  String get score_add_missing_product_emb =>
      'Dodaj brakujące kody identyfikacji produktów';

  @override
  String get score_add_missing_product_labels =>
      'Dodaj brakujące etykiety produktu';

  @override
  String get score_add_missing_product_origins =>
      'Dodaj brakujące pochodzenie produktów';

  @override
  String get score_add_missing_product_stores =>
      'Dodaj brakujące sklepy z produktem';

  @override
  String get score_add_missing_product_brands =>
      'Dodaj brakujące marki produktów';

  @override
  String get score_update_nutrition_facts =>
      'Zaktualizuj informacje o produkcie';

  @override
  String get nutrition_page_title => 'Wartość odżywcza';

  @override
  String get nutrition_page_nutritional_info_title => 'Informacje żywieniowe';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Wartości podane na produkcie:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Tak';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nie';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Otwórz zdjęcie';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Dobre praktyki: Informacje żywieniowe';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Czasami informacje o wartościach odżywczych **nie są podane na opakowaniu** lub w dokumencie dołączonym do produktu. W takim przypadku, i tylko w tym przypadku, możesz ustawić wartość na **NIE**.';

  @override
  String get nutrition_page_serving_type_label => 'Wartości odżywcze:';

  @override
  String get nutrition_page_per_100g => 'w 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'na 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'na porcję';

  @override
  String get nutrition_page_add_nutrient => 'Dodaj składnik odżywczy';

  @override
  String get nutrition_page_serving_size => 'Wielkość porcji';

  @override
  String get nutrition_page_serving_size_hint =>
      'Wprowadź wielkość porcji (np. 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Dobre praktyki: Wielkość porcji';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Wartość ta pomaga **dokonać proporcjonalnego obliczenia każdego składnika odżywczego na porcję**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Dozwolone jednostki** to: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** lub **60 G** (preferuję pierwszą opcję)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** lub **1 l**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Nieprawidłowa jednostka';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Nieprawidłowe jednostki';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **cukierków** i 2 **ciasteczka**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Brakująca jednostka';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Nieprawidłowa liczba';

  @override
  String get nutrition_page_update_running => 'Aktualizacja statusu produktu…';

  @override
  String get nutrition_page_update_done => 'Produkt zaktualizowany!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Użyj ilości produktu jako wielkości porcji';

  @override
  String get nutrition_page_photo_error => 'Nie można załadować zdjęcia';

  @override
  String get more_photos => 'Więcej interesujących zdjęć';

  @override
  String get view_more_photo_button =>
      'Zobacz wszystkie istniejące zdjęcia tego produktu';

  @override
  String get no_product_found => 'Nie znaleziono produktu';

  @override
  String get no_location_found => 'Nie znaleziono lokalizacji';

  @override
  String get not_found => 'nie znaleziono:';

  @override
  String get refreshing_product => 'Odświeżanie produktu';

  @override
  String get product_refreshed => 'Odświeżono produkt';

  @override
  String product_image_accessibility_label(String date) {
    return 'Zdjęcie zrobione $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Zdjęcie zrobione $date. To zdjęcie może być nieaktualne';
  }

  @override
  String get product_image_outdated => 'To zdjęcie może być nieaktualne';

  @override
  String get product_image_outdated_explanations_title =>
      'To zdjęcie może być nieaktualne';

  @override
  String get product_image_outdated_explanations_content =>
      'To zdjęcie zostało zrobione ponad rok temu.\n**Proszę, sprawdź, czy jest ono dalej aktualne**\n\nTo jest **tylko ostrzeżenie**. Jeśli zawartość dalej jest taka sama, możesz zignorować tę wiadomość.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Zastąp zdjęcie ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Dodaj zdjęcie ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Zrób zdjęcie';

  @override
  String get product_image_action_take_picture => 'Zrób zdjęcie';

  @override
  String get product_image_action_from_gallery => 'Wybierz z galerii telefonu';

  @override
  String get product_image_action_choose_existing_photo =>
      'Wybierz ze zdjęć produktu';

  @override
  String get product_image_details_label => 'Informacje o zdjęciu';

  @override
  String get product_image_details_from_producer => 'Od producenta';

  @override
  String get product_image_details_contributor => 'Współtwórca';

  @override
  String get product_image_details_contributor_producer =>
      'Współtwórca (producent)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Nieznany';

  @override
  String get homepage_main_card_logo_description => 'Witamy w OpenFoodFacts';

  @override
  String get homepage_main_card_subheading =>
      '**Zeskanuj** kod kreskowy lub **szukaj** produktu';

  @override
  String get homepage_main_card_search_field_hint => 'Wyszukaj produkt';

  @override
  String get homepage_main_card_search_field_tooltip =>
      'Rozpocznij wyszukiwanie';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Najnowsze wiadomości: $news_title';
  }

  @override
  String get tagline_app_review => 'Podoba ci się aplikacja?';

  @override
  String get tagline_app_review_button_positive => 'Kocham! 😍';

  @override
  String get tagline_app_review_button_negative => 'Nie za bardzo…';

  @override
  String get tagline_app_review_button_later => 'Zapytaj mnie później';

  @override
  String get tagline_feed_news_button => 'Dowiedz się więcej';

  @override
  String get app_review_negative_modal_title =>
      'Nie podoba Ci się nasza aplikacja?';

  @override
  String get app_review_negative_modal_text =>
      'Czy mógłbyś poświęcić kilka sekund, żeby nam wyjaśnić dlaczego?';

  @override
  String get app_review_negative_modal_positive_button => 'Tak, oczywiście!';

  @override
  String get app_review_negative_modal_negative_button => 'Nie';

  @override
  String get could_not_refresh => 'Nie udało się odświeżyć produktu';

  @override
  String get product_internet_error_modal_title => 'Wystąpił błąd!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Nie możemy pobrać informacji o tym produkcie z powodu błędu sieci. Sprawdź połączenie internetowe i spróbuj ponownie.\n\nBłąd wewnętrzny:\n$error';
  }

  @override
  String get product_tags_title => 'Właściwości produktu';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Brak właściwości';

  @override
  String get product_tags_explanation =>
      'Dodając właściwości (klucz/wartość) do produktu, przyczyniasz się do jego wzbogacenia.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Dodaj właściwości';

  @override
  String get add_edit_tags => 'Dodaj lub edytuj właściwości';

  @override
  String get edit_tag => 'Edytuj właściwość';

  @override
  String get remove_tag => 'Usuń właściwość';

  @override
  String get tag_key => 'Właściwość';

  @override
  String get tag_keys => 'Właściwości';

  @override
  String get tag_key_uneditable => 'Właściwość (nieedytowalna)';

  @override
  String get tag_key_input_hint => 'Wprowadź właściwość';

  @override
  String get tag_value => 'Wartość';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Wprowadź wartość';

  @override
  String get tag_key_item => 'Właściwość:';

  @override
  String get tag_value_item => 'Wartość:';

  @override
  String get tag_key_explanations =>
      'Klucz musi się składać z małych liter i nie może zawierać spacji.';

  @override
  String tag_key_already_exists(String property) {
    return 'Tag z właściwością $property już istnieje!';
  }

  @override
  String get product_internet_error =>
      'Nie można pobrać informacji o tym produkcie z powodu błędu sieciowego.';

  @override
  String get cached_results_from => 'Pokaż wyniki z:';

  @override
  String get product_search_same_category => 'Znajdź alternatywy';

  @override
  String get product_search_same_category_short => 'Porównaj';

  @override
  String get product_search_same_category_error =>
      'Ta funkcja może być używana wyłącznie w przypadku produktów z kategorią.\n\nProszę edytować produkt, aby dodać kategorię.';

  @override
  String get product_improvement_add_category =>
      'Dodaj kategorię, aby obliczyć Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Dodaj informacje żywieniowe, aby obliczyć Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Dodaj informacje żywieniowe i kategorię, aby obliczyć Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nie można wyliczyć Nutri-Score dla tego produktu, co może być spowodowane m.in. niestandardową kategorią. Jeśli jest to błąd, prosimy o kontakt.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Obraz tabeli wartości odżywczych jest nieaktualny: odśwież go.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Zielony wynik uwzględnia pochodzenie składników. Prosimy o zrobienie zdjęcia listy składników i/lub wszelkich oznaczeń geograficznych lub dokonanie edycji produktu, aby mogły zostać uwzględnione.';

  @override
  String get country_chooser_label => 'Proszę wybrać kraj';

  @override
  String get currency_chooser_label => 'Proszę wybrać walutę';

  @override
  String get country_change_message => 'Właśnie zmieniłeś kraj.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Czy chcesz zmienić walutę z $previousCurrency na $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Proszę wybrać kraj:';

  @override
  String get country_chooser_label_from_settings => 'Twój kraj';

  @override
  String get country_selection_explanation =>
      'Niektóre elementy środowiskowe są zależne od lokalizacji';

  @override
  String get product_removed_comparison => 'Produkt usunięty z porównania';

  @override
  String get native_app_settings => 'Natywne ustawienia aplikacji';

  @override
  String get native_app_description =>
      'Otwórz ustawienia systemowe dla Open Food Facts';

  @override
  String get product_removed_history => 'Produkt usunięty z historii';

  @override
  String get product_removed_list => 'Produkt usunięty z listy';

  @override
  String get product_could_not_remove => 'Nie udało się usunąć produktu';

  @override
  String get no_prodcut_in_list => 'Na tej liście nie ma produktu';

  @override
  String get no_product_in_section => 'W tej sekcji nie ma produktu';

  @override
  String get recently_seen_products => 'Wszystkie przeglądane produkty';

  @override
  String get clear => 'Wyczyść';

  @override
  String get clear_long => 'Opróżnij listę';

  @override
  String get really_clear => 'Czy na pewno chcesz usunąć tę listę?';

  @override
  String pct_match(Object percent) {
    return '$percent% dopasowania';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dni temu',
      one: '1 dzień temu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count godzin temu',
      one: 'jedną godzinę temu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minut temu',
      one: 'minutę temu',
      zero: 'mniej niż minutę temu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count miesięcy temu',
      one: '1 miesiąc temu',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count tygodni temu',
      one: '1 tydzień temu',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Porównaj $count produktów',
      one: 'Porównaj jeden produkt',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Wybrano$count produkty',
      one: 'Wybrano jeden produkt',
      zero: 'Nie wybrano żadnego produktu',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Porównaj wybrane produkty';

  @override
  String get delete_products_mode => 'Usuń wybrane produkty';

  @override
  String get select_all_products_mode => 'Zaznacz wszystkie produkty';

  @override
  String get select_none_products_mode => 'Nie zaznaczaj niczego';

  @override
  String get compare_products_appbar_title => 'Porównaj produkty';

  @override
  String get compare_products_appbar_subtitle =>
      'Proszę wybrać co najmniej dwa produkty';

  @override
  String get retry_button_label => 'Ponów próbę';

  @override
  String get connect_with_us => 'Połącz się z nami';

  @override
  String get tiktok => 'Obserwuj nas na TikToku';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Obserwuj nas na Instagramie';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Obserwuj nas na X (dawniej Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Obserwuj nas na Mastodonie';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Obserwuj nas na BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Najczęściej zadawane pytania (FAQ)';

  @override
  String get discover => 'Odkryj';

  @override
  String get how_to_contribute => 'Jak mogę pomóc';

  @override
  String get hint_knowledge_panel_message =>
      'Możesz dotknąć dowolnej części karty, aby uzyskać więcej informacji na temat tego, co widzisz. Spróbuj teraz!';

  @override
  String get permissions_page_title => 'Dostęp do aparatu';

  @override
  String get permissions_page_body1 =>
      'Aby zeskanować kody kreskowe aparatem telefonu, proszę autoryzować dostęp.';

  @override
  String get permissions_page_body2 =>
      'Jeśli zmienisz zdanie, tę opcję możesz włączyć i wyłączyć w dowolnym momencie w ustawieniach.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'System operacyjny: Android (SDK Int: $sdkInt / Wprowadzona: $release)\nModel: $model\nProdukt: $product\nUrządzenie: $device\nMarka: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'System operacyjny: iOS ($version)\nModel: $model\nZlokalizowany model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nWersja aplikacji:$appVersion\nNumer kompilacji aplikacji:$appBuildNumber\nNazwa pakietu aplikacji:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Autoryzuj';

  @override
  String get refuse_button_label => 'Odrzuć';

  @override
  String get ask_me_later_button_label => 'Później';

  @override
  String get are_you_sure => 'Czy na pewno?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Dowiedz się więcej na $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Powitanie !';

  @override
  String get onboarding_home_welcome_text2 =>
      'Aplikacja, która pomoże Ci wybrać jedzenie dobre dla **Ciebie** i **planety**!';

  @override
  String get onboarding_continue_button => 'Kontynuuj';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Ładowanie pierwszego przykładowego produktu';

  @override
  String get onboarding_welcome_warning =>
      'Przepraszamy, to nasz przykładowy produkt, nie możesz go edytować :)';

  @override
  String get product_list_your_ranking => 'Twój ranking';

  @override
  String get product_list_empty_icon_desc => 'Historia niedostępna';

  @override
  String get product_list_empty_title => 'Rozpocznij skanowanie';

  @override
  String get product_list_empty_message =>
      'Zeskanowane produkty pojawią się tutaj i możesz sprawdzić szczegółowe informacje na ich temat';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produktów',
      one: 'produktu',
      zero: 'produktów',
    );
    return 'Trwa odświeżanie $_temp0 w twojej historii';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produktów',
      one: 'produktu',
      zero: 'produktów',
    );
    return 'Odświeżanie $_temp0 skończone';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Pobieranie danych';

  @override
  String get loading_dialog_default_error_message =>
      'Nie udało się pobrać danych';

  @override
  String get account_delete => 'Usuń konto';

  @override
  String get account_delete_title => 'Usuń moje konto';

  @override
  String get user_profile => 'Konto';

  @override
  String get user_profile_title_guest => 'Witaj!';

  @override
  String get user_profile_subtitle_guest =>
      'Zaloguj się lub zarejestruj, aby dołączyć do społeczności Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Otwórz logowanie do Food Facts: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Witaj $id!';
  }

  @override
  String get email_subject_account_deletion => 'Usuń konto';

  @override
  String email_body_account_deletion(String userId) {
    return 'Cześć, proszę usuń moje konto Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplikacja';

  @override
  String get settings_app_data => 'Prywatność i monitorowanie';

  @override
  String get settings_app_camera => 'Aparat';

  @override
  String get settings_app_products => 'Produkty';

  @override
  String get settings_app_miscellaneous => 'Inne';

  @override
  String get camera_play_sound_title => 'Odtwórz dźwięk po zeskanowaniu';

  @override
  String get camera_play_sound_subtitle =>
      'Po każdym udanym skanowaniu wyda sygnał dźwiękowy';

  @override
  String get camera_window_accessibility_label =>
      'Zeskanuj kod kreskowy swoim aparatem';

  @override
  String get app_haptic_feedback_title =>
      'Wibracje i Haptyczna Informacja Zwrotna';

  @override
  String get app_haptic_feedback_subtitle =>
      'Wibracje po wykonaniu czynności (zeskanowanie kodu kreskowego, produkt usunięty…).';

  @override
  String get crash_reporting_toggle_title => 'Raportowanie błędów';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Po włączeniu tej opcji raporty o awariach będą automatycznie przesyłane do systemu śledzenia błędów Open Food Facts, co umożliwi naprawienie błędów i udoskonalenie aplikacji.';

  @override
  String get send_anonymous_data_toggle_title => 'Wysyłaj anonimowe dane';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Edytuj zdjęcie';

  @override
  String get permission_photo_error => 'Błąd';

  @override
  String get permission_photo_denied_title =>
      'Zezwalaj na używanie aparatu do skanowania kodów kreskowych';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Dla lepszego doświadczenia, proszę zezwolić $appName na dostęp do kamery. Będziesz mógł bezpośrednio skanować kody kreskowe.';
  }

  @override
  String get permission_photo_denied_button => 'Zezwól';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Odmowa dostępu';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Ponieważ poprzednio odmówiono dostępu do aparatu, musisz zezwolić na to ręcznie w Ustawieniach.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Ustawienia';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Anuluj';

  @override
  String get permission_photo_none_found => 'Nie wykryto aparatu';

  @override
  String get permission_photo_denied => 'Nie przyznano dostępu do aparatu';

  @override
  String get show_product_pictures => 'Pokaż zdjęcia produktu';

  @override
  String get edit_product_label => 'Edytuj produkt';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Przesyłanie edycji…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Twoje zmiany są **wysyłane w tle** (lub później w przypadku wystąpienia błędu).\nMożesz kontynuować edycję innych pól produktu.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Twoje edycje są **wysyłane w tle** (lub później w przypadku wystąpienia błędu).';

  @override
  String get edit_product_label_short => 'Edytuj';

  @override
  String edit_product_form_item_help(String value) {
    return 'Jak wpisać „$value”?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Proszę wprowadzić wartość, która nie jest pusta!';

  @override
  String get edit_product_form_item_error_existing =>
      'Ta wartość już tam jest!';

  @override
  String get edit_product_form_item_add_action_brand => 'Dodaj nową markę';

  @override
  String get edit_product_form_item_add_action_label => 'Dodaj nową etykietę';

  @override
  String get edit_product_form_item_add_action_store => 'Dodaj nowy sklep';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Dodaj nowe pochodzenie';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Dodaj nowy kod śledzenia';

  @override
  String get edit_product_form_item_add_action_country => 'Dodaj nowy kraj';

  @override
  String get edit_product_form_item_add_action_category =>
      'Dodaj nową kategorię';

  @override
  String get edit_product_form_item_add_action_trace => 'Dodaj nowy ślad';

  @override
  String get edit_product_form_item_add_suggestion => 'Dodaj sugestię';

  @override
  String get edit_product_form_item_deny_suggestion => 'Odrzuć sugestię';

  @override
  String get edit_product_form_item_details_title => 'Informacje podstawowe';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nazwa produktu, marka, ilość';

  @override
  String get edit_product_form_item_other_details_title =>
      'Dodatkowe informacje';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Strona…';

  @override
  String get edit_product_form_item_photos_title => 'Zdjęcia';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Dodaj lub odśwież zdjęcia';

  @override
  String get edit_product_form_item_labels_title => 'Etykiety i certyfikaty';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Oznakowania jakości i wpływu na środowisko…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Wprowadź etykietę (np. NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etykieta';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Dobre praktyki: Etykiety';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Wszelkie cechy produktu **które są faktyczne** i różnią się od cech w pozostałych polach.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Wynik Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Wyprodukowano w Belgii, wyprodukowano w Bretanii…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Bogate w błonnik, źródło żelaza…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Sprawiedliwy handel, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Sklepy';

  @override
  String get edit_product_form_item_stores_hint => 'Wprowadź sklep';

  @override
  String get edit_product_form_item_stores_type => 'stan';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Dobre praktyki: Sklepy';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Wprowadź nazwę sklepu, w którym kupiłeś produkt.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Pochodzenie';

  @override
  String get edit_product_form_item_origins_hint =>
      'Wprowadź pochodzenie (np. Niemcy)';

  @override
  String get edit_product_form_item_origins_type => 'kraj';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Dobre praktyki: Początki';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Dodaj **wszelkie informacje o pochodzeniu, które znajdziesz na opakowaniu**.\nNie musisz martwić się o pochodzenie podane bezpośrednio na liście składników.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Wołowina z Argentyny';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Soja nie pochodzi z Unii Europejskiej';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Wprowadź kraj (np. Niemcy)';

  @override
  String get edit_product_form_item_countries_type => 'kraj';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Dobre praktyki: Kraje';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Kraje, w których produkt jest powszechnie dostępny** (nie wliczając sklepów specjalizujących się w produktach zagranicznych).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Kody identyfikujące';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Wprowadź kod (np.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'kod identyfikujący';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Dobre praktyki: Kody identyfikowalności';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'W tej sekcji możesz wprowadzić kody związane ze **znakami opakowań**, **znakami identyfikacyjnymi** lub **znakami zdrowotnymi**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Przykłady kodów śledzenia';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Kody WE** stosowane we Wspólnocie Europejskiej do identyfikacji producentów lub pakowaczy żywności:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: kod kraju **Francji**\n**72.264.002**: dane geograficzne\n**CE**: Wspólnota Europejska';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Kody EMB** używane we Francji:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Ślady';

  @override
  String get edit_product_form_item_traces_hint => 'ślad';

  @override
  String get edit_product_form_item_traces_type => 'Wprowadź ślad (np.: Soja)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorie';

  @override
  String get edit_product_form_item_categories_hint => 'kategoria';

  @override
  String get edit_product_form_item_categories_type =>
      'Wprowadź kategorię (np.: Sok pomarańczowy)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Dobre praktyki: Kategorie';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Wskaż **tylko najbardziej szczegółową kategorię**.\nKategorie nadrzędne zostaną dodane automatycznie.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Brakuje kategorii?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Jeśli kategoria **nie jest dostępna w autouzupełnianiu**, możesz ją mimo wszystko dodać.\nPomoże nam to ulepszyć Open Food Facts w Twoim kraju.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardynki w oliwie z oliwek';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Sok pomarańczowy z koncentratu';

  @override
  String get edit_product_form_item_exit_title =>
      'Zrezygnować bez oszczędzania?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Czy chcesz zapisać zmiany przed opuszczeniem tej strony?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Zapisz zmiany';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Odrzuć zmiany';

  @override
  String get edit_product_form_item_ingredients_title => 'Składniki';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Powiększaj i pomniejszaj, ściskając ekran';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Przybliżanie i oddalanie zdjęcia';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Za pomocą gestu **szczypania w celu powiększenia** możesz przybliżać i oddalać zdjęcie:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Dodaj';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Proszę najpierw wpisać tekst';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Usuń';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Zapisz swoją edycję';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip => 'Anuluj edycję';

  @override
  String get edit_product_form_item_packaging_title =>
      'Zdjęcie informacji dotyczących recyklingu';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Wartości odżywcze';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Wartości odżywcze, zaw. alkoholu…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Dobre praktyki: Informacje żywieniowe';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Wartości odżywcze';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Najpierw wybierz, czy **wartości są podane**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Wartości odżywcze';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Następnie wprowadź wartości odżywcze **zgodnie ze wskazaniem na opakowaniu**. Jeśli nie ma wartości, kliknij ikonę „Oko”.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Brak pola?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Jeśli brakuje wpisu, możesz **kliknąć ikonę „Plus”**, aby go dodać (np. witamina D, magnez…).';

  @override
  String get edit_product_form_save => 'Edytuj';

  @override
  String get edit_product_ingredients_photo_title => 'Zdjęcie listy składników';

  @override
  String get edit_product_ingredients_list_title => 'Lista składników';

  @override
  String get edit_product_packaging_photo_title => 'Zdjęcie opakowania';

  @override
  String get edit_product_packaging_list_title => 'Lista opakowań';

  @override
  String get no_data_available => 'Brak dostępnych informacji';

  @override
  String get product_field_website_title => 'Strona';

  @override
  String get origins_editing_title => 'Edytuj pochodzenie';

  @override
  String get completed_basic_details_btn_text =>
      'Uzupełnij podstawowe informacje';

  @override
  String get not_implemented_snackbar_text => 'Jeszcze niezaimplementowane';

  @override
  String get category_picker_page_appbar_text => 'Kategorie';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Wyodrębnij składniki ze zdjęcia';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Wyodrębnij składniki';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Wyodrębnianie składników\nze zdjęcia';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Ładowanie zdjęcia…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Dlaczego widzę ten komunikat?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Aby skorzystać z funkcji „Wyodrębnij składniki”, najpierw musisz przesłać zdjęcie.\n\nPoczekaj kilka sekund lub wprowadź je ręcznie.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Odśwież zdjęcie';

  @override
  String get edit_packaging_extract_btn_text =>
      'Wyodrębnij opakowanie\nze zdjęcia';

  @override
  String get edit_packaging_extract_btn_text_short => 'Wyciągnij opakowanie';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Wyodrębnianie opakowania ze zdjęcia';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Ładowanie zdjęcia…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Dlaczego widzę ten komunikat?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Aby skorzystać z funkcji „Wypakuj opakowanie”, najpierw należy przesłać zdjęcie.\n\nPoczekaj kilka sekund lub wprowadź dane ręcznie.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Odśwież zdjęcie';

  @override
  String get edit_ocr_extract_failed =>
      'Nie udało się wykryć tekstu na obrazie.';

  @override
  String get edit_ocr_extract_disabled_title => 'Brak zdjęcia!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Aby skorzystać z funkcji wyodrębniania tekstu, musisz najpierw zrobić zdjęcie.';

  @override
  String get user_list_dialog_new_title => 'Nowa lista produktów';

  @override
  String get user_list_dialog_rename_title => 'Zmień nazwę listy';

  @override
  String get user_list_subtitle_product => 'Listy';

  @override
  String get user_list_title => 'Twoje listy';

  @override
  String get user_list_add_product => 'Dodaj produkt do swoich list';

  @override
  String get user_list_button_new => 'Stwórz nową listę';

  @override
  String get user_list_empty_label =>
      'Brak dostępnej listy, proszę zacząć od utworzenia listy';

  @override
  String get user_list_button_add_product => 'Dodaj do listy';

  @override
  String get added_to_list_msg => 'Dodano do listy';

  @override
  String get user_list_popup_clear => 'Wyczyść historię';

  @override
  String get user_list_popup_rename => 'Zmień nazwę';

  @override
  String get user_list_name_hint => 'Moja lista';

  @override
  String get user_list_name_error_empty => 'Nazwa jest obowiązkowa';

  @override
  String get user_list_name_error_already => 'Ta nazwa jest już używana';

  @override
  String get user_list_name_error_same => 'Ta lista już się tak nazywa';

  @override
  String get user_list_name_input_hint => 'Nazwa listy';

  @override
  String get try_again => 'Spróbuj ponownie';

  @override
  String get there_was_an_error => 'Wystąpił błąd';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Nie znaleziono kategorii dla $items';
  }

  @override
  String get camera_toggle_camera => 'Przerzuć między tylną a przednią kamerą';

  @override
  String get camera_toggle_flash => 'Włącz lub wyłącz lampę w kamerze';

  @override
  String get camera_enable_flash => 'Włącz lampę błyskową';

  @override
  String get camera_disable_flash => 'Wyłącz lampę błyskową';

  @override
  String get camera_flash_error_dialog_title => 'Wystąpił błąd!';

  @override
  String get camera_flash_error_dialog_message =>
      'Wystąpił błąd podczas zmiany stanu lampy błyskowej. Upewnij się, że latarka na Twoim smartfonie nie jest już włączona.';

  @override
  String get category_picker_no_category_found_button => 'Wstecz';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Kliknij, aby otworzyć w przeglądarce lub w aplikacji (jeśli jest zainstalowana)';

  @override
  String get dev_preferences_screen_title => 'Tryb deweloperski (DEV)';

  @override
  String get dev_preferences_screen_subtitle =>
      'Uzyskaj dostęp do funkcji eksperymentalnych i narzędzi programistycznych';

  @override
  String get dev_preferences_reset_onboarding_title => 'Zrestartuj wskazówki';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Aby wskazówki pojawiły się ponownie, zrestartuj aplikację.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Przełącz pomiędzy openfoodfacts.org (PROD) a test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Parametry środowiska testowego';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Podstawowy adres URL dla bieżącego środowiska testowego: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Środowisko testowe';

  @override
  String get dev_preferences_ml_kit_title => 'Użyj zestawu ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'musisz ponownie uruchomić tę aplikację';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Dodatkowy przycisk na stronie produktu';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Edytuj składniki za pomocą przycisku panelu wiedzy';

  @override
  String get dev_preferences_export_history_title => 'Eksportuj historię';

  @override
  String get dev_preferences_export_history_progress_error => 'wyjątek';

  @override
  String get dev_preferences_export_history_progress_found =>
      'znaleziono produkt';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkt NIE został znaleziony';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Eksportuj historię';

  @override
  String get dev_preferences_button_positive => 'Dobrze';

  @override
  String get dev_preferences_button_negative => 'Anuluj';

  @override
  String get dev_preferences_migration_title => 'Migracja danych z V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'sukces lub nowa instalacja';

  @override
  String get dev_preferences_migration_status_success => 'zakończono pomyślnie';

  @override
  String get dev_preferences_migration_status_error => 'błąd';

  @override
  String get dev_preferences_migration_status_in_progress => 'w toku';

  @override
  String get dev_preferences_migration_status_required =>
      'wymagane (kliknij, aby rozpocząć)';

  @override
  String get dev_preferences_migration_status_not_started => 'nieznany';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Usuwa historię wyszukiwania i wstawia w to miejsce 3 produkty';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Niestandardowy adres URL dla wiadomości';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'Adres URL pliku JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nie ustawiono';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Ostatnie odświeżenie: $date';
  }

  @override
  String get product_type_label_food => 'Żywność';

  @override
  String get product_type_label_beauty => 'Opieka osobista';

  @override
  String get product_type_label_pet_food => 'Karma dla zwierząt';

  @override
  String get product_type_label_product => 'Inne';

  @override
  String get product_type_selection_title => 'Typ produktu';

  @override
  String get product_type_selection_subtitle => 'Wybierz typ tego produktu';

  @override
  String get product_type_selection_empty =>
      'Najpierw musisz wybrać typ produktu!';

  @override
  String product_type_selection_already(String productType) {
    return 'Nie można zmienić typu produktu ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Skrót do aplikacji Ceny na stronie produktu';

  @override
  String get prices_app_button => 'Przejdź do aplikacji Ceny';

  @override
  String get prices_website_button =>
      'Otwórz na stronie internetowej Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Dodawaj metki cenowe bezpośrednio z galerii';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Po wybraniu obrazów nie będzie można ich edytować!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Pozwól społeczności weryfikować ceny wyodrębnione przez sztuczną inteligencję.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Wiele metek cenowych';

  @override
  String get prices_bulk_proof_upload_title => 'Masowe przesyłanie dowodów';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Wybieranie plików';

  @override
  String get prices_bulk_proof_upload_step_starting =>
      'Rozpoczęcie przesyłania';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokalne kopiowanie pliku #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Przygotowywanie przesyłania #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Nie udało się na obrazku #$index/$count';
  }

  @override
  String get prices_generic_title => 'Ceny';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Dodaj $count ceny',
      one: 'Dodaj cenę',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Wyślij $count ceny',
      one: 'Wyślij cenę',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Dodaj element';

  @override
  String get prices_add_a_price => 'Dodaj cenę';

  @override
  String get prices_add_a_receipt => 'Dodaj paragon';

  @override
  String get prices_add_price_tags => 'Dodaj metki cenowe';

  @override
  String prices_barcode_already(String barcode) {
    return 'Ten kod kreskowy ($barcode) już znajduje się na liście!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produkt nie został znaleziony';

  @override
  String get prices_barcode_search_none_yet => 'Brak jeszcze produktu';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Szukam $barcode';
  }

  @override
  String get prices_barcode_enter => 'Wprowadź kod kreskowy';

  @override
  String get prices_category_enter => 'Pozycja bez kodu kreskowego';

  @override
  String get prices_per_kilogram => 'Cena za kilogram';

  @override
  String get prices_per_unit => 'Cena jednostkowa';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / jednostka';

  @override
  String get prices_category_mandatory => 'Obowiązkowe';

  @override
  String get prices_category_optional => 'Fakultatywny';

  @override
  String get prices_category_error_mandatory => 'Kategoria jest obowiązkowa';

  @override
  String get prices_barcode_reader_action => 'Czytnik kodów kreskowych';

  @override
  String get prices_view_prices => 'Zobacz ceny';

  @override
  String get prices_list_title => 'Cennik';

  @override
  String get prices_list_count => 'Liczba\ncen';

  @override
  String get prices_list_add_new_price => 'Dodaj\nnową cenę';

  @override
  String get prices_list_empty_title => 'Cena jeszcze nieznana!';

  @override
  String get prices_list_empty_subtitle =>
      'Bądź pierwszy, który doda:\nSkanując **paragon** lub **metkę z ceną**!';

  @override
  String get prices_entry_shop_not_found => 'Nieznany sklep';

  @override
  String prices_entry_menu_title(String user) {
    return 'Wpis ceny od \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Zobacz wszystkie ceny tego produktu';

  @override
  String get prices_entry_menu_open_proof => 'Zobacz dowód';

  @override
  String get prices_entry_menu_my_prices => 'Zobacz moje inne ceny';

  @override
  String get prices_entry_menu_author_prices =>
      'Zobacz inne ceny podane przez autora';

  @override
  String get prices_entry_menu_shop_prices => 'Zobacz inne ceny w sklepie';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ceny',
      one: '1 cena',
    );
    return '$_temp0 za $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Wszystkie $count ceny',
      one: 'Tylko jedna cena',
      zero: 'Jeszcze nie ma ceny',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Najnowsze ceny $pageSize (łącznie: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Cena: $price / Sklep: \"$location\" / Opublikowano $date przez \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Otwórz dowody „$user”';
  }

  @override
  String get prices_open_proof => 'Otwarty dowód ceny';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Wszystkie $count dowody',
      one: 'Tylko jeden dowód',
      zero: 'Jeszcze nie ma dowodu',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Najnowsze $pageSize dowodów (łącznie: $total)';
  }

  @override
  String get prices_users_empty_title => 'Na razie nie ma współautora!';

  @override
  String get prices_users_empty_explanation =>
      'Bądź pierwszy, który doda cenę!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Najlepsi $pageSize współautorzy (łącznie: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Sklepu jeszcze nie ma!';

  @override
  String get prices_locations_empty_explanation =>
      'Bądź pierwszy, który doda cenę!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Najlepsze $pageSize lokalizacji (łącznie: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dowody',
      one: 'Jeden dowód',
      zero: 'Brak dowodu',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkty',
      one: 'Jeden produkt',
      zero: 'Brak produktu',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count użytkowników',
      one: 'Jeden użytkownik',
      zero: 'Brak użytkownika',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ceny',
      one: 'Jedna cena',
      zero: 'Brak ceny',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Cena dodana wcześniej';

  @override
  String get prices_amount_subtitle => 'Kwota';

  @override
  String get prices_amount_is_discounted => 'Czy jest objęty zniżką?';

  @override
  String get prices_amount_price_normal => 'Cena';

  @override
  String get prices_amount_price_discounted => 'Cena promocyjna';

  @override
  String get prices_amount_price_not_discounted => 'Cena oryginalna';

  @override
  String get prices_amount_no_product => 'Brakuje jednego produktu!';

  @override
  String get prices_amount_price_incorrect => 'Nieprawidłowa wartość';

  @override
  String get prices_amount_price_mandatory => 'Wartość obowiązkowa';

  @override
  String get prices_currency_subtitle => 'Waluta';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Sklep';

  @override
  String get prices_location_find => 'Znajdź sklep';

  @override
  String get prices_location_mandatory => 'Musisz wybrać sklep!';

  @override
  String get prices_location_search_broader =>
      'Nie udało Ci się znaleźć tego, czego szukasz? Spróbujmy szerszego zakresu wyszukiwania!';

  @override
  String get prices_proof_subtitle => 'Dowód';

  @override
  String get prices_proof_empty_title => 'Brak dowodów!';

  @override
  String get prices_proof_empty_explanation =>
      'Zacznij od dodania zdjęcia **paragonu** lub **metki z ceną**!';

  @override
  String get prices_proof_find => 'Wybierz próbkę';

  @override
  String get prices_proof_change => 'Dowód zmiany';

  @override
  String get prices_proof_receipt => 'Rachunek';

  @override
  String get prices_proof_price_tag => 'Cenówka';

  @override
  String get prices_proof_mandatory => 'Musisz wybrać kopię!';

  @override
  String get prices_add_validation_error => 'Błąd walidacji';

  @override
  String get prices_privacy_warning_title => 'Ostrzeżenie o prywatności';

  @override
  String get prices_unknown_product => 'Nieznany produkt';

  @override
  String get prices_privacy_warning_main_message =>
      'Ceny **będą publiczne**, podobnie jak sklep, do którego się odnoszą.\n\nDzięki temu osoby znające Twój pseudonim w serwisie Open Food Facts mogą:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Wywnioskuj, w jakim obszarze mieszkasz';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Wiedz, co kupujesz';

  @override
  String get prices_privacy_warning_sub_message =>
      'Jeśli to Cię niepokoi, zmień pseudonim lub załóż nowe konto Open Food Facts i zaloguj się do aplikacji za jego pomocą.';

  @override
  String get i_refuse => 'Odmawiam';

  @override
  String get i_accept => 'Akceptuję';

  @override
  String get prices_currency_change_proposal_title => 'Zmienić walutę?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Twoja obecna waluta to **$currency**. Czy chcesz ją zmienić na **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Tak, użyj $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nie, zachowaj $currency';
  }

  @override
  String get prices_menu_know_more => 'Dowiedz się więcej o cenach otwartych';

  @override
  String get dev_preferences_import_history_result_success => 'Gotowe';

  @override
  String get dev_mode_section_server => 'Konfiguracja serwera';

  @override
  String get dev_mode_section_news => 'Konfiguracja dostawcy wiadomości';

  @override
  String get dev_mode_section_product_page => 'Strona produktu';

  @override
  String get dev_mode_section_ui => 'Interfejs użytkownika';

  @override
  String get dev_mode_section_experimental_features => 'Cechy eksperymentalne';

  @override
  String get dev_mode_hide_environmental_score_title => 'Wyklucz wynik zielony';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Użyj modułu sprawdzania pisowni do ekranów OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Składniki i opakowanie)';

  @override
  String get dev_mode_reset_app_language_title => 'Zresetuj język aplikacji';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Dodaj karty';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Przełączanie między prices.openfoodfacts.org (PROD) i środowiskiem testowym';

  @override
  String get search_history_item_edit_tooltip =>
      'Użyj ponownie i edytuj to wyszukiwanie';

  @override
  String get search_history_item_remove_tooltip => 'Usuń';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Pobrałeś wszystkie $totalSize produkty.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Pobierz $count produktów więcej\nPobrano $downloaded z $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Trwa wyszukiwanie $search .\n\nPoczekaj kilka sekund…';
  }

  @override
  String get user_search_contributor_title => 'Produkty, które dodałem';

  @override
  String get user_search_informer_title => 'Produkty, które edytowałem';

  @override
  String get user_search_photographer_title =>
      'Produkty, które sfotografowałem';

  @override
  String get user_search_to_be_completed_title =>
      'Moje produkty do uzupełnienia';

  @override
  String get user_search_prices_title => 'Moje ceny';

  @override
  String get user_search_proofs_title => 'Moje dowody';

  @override
  String get user_search_proof_title => 'Mój dowód';

  @override
  String search_proof_title(String user) {
    return 'Dowód z \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Ceny dla współpracowników: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Dodano najnowsze ceny';

  @override
  String get all_search_prices_top_user_title => 'Najwięksi uczestnicy cen';

  @override
  String get all_search_prices_top_location_title =>
      'Sklepy z najwyższymi cenami';

  @override
  String get prices_contribution_assistant => 'Asystent ds. wkładu cenowego';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Dodaj wiele dowodów';

  @override
  String get all_search_prices_top_location_single_title => 'Ceny w sklepie';

  @override
  String get all_search_prices_top_product_title =>
      'Produkty z najwyższymi cenami';

  @override
  String get all_search_to_be_completed_title =>
      'Wszystkie produkty do uzupełnienia';

  @override
  String get categorize_products_country_title =>
      'Pomóż kategoryzować produkty w swoim kraju';

  @override
  String get edit_product_action_retake_picture => 'Ponów zdjęcie';

  @override
  String get edit_product_action_take_picture => 'Zrób zdjęcie';

  @override
  String get edit_product_action_confirm => 'Potwierdź';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Zgadzam się z Otwartymi Faktami Żywnościowymi ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'warunkami użytkowania i wkładu w Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'Analityka';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Błąd krytyczny: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Błąd krytyczny: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Uzupełnij podstawowe informacje';

  @override
  String get edit_photo_button_label => 'Edytuj';

  @override
  String get edit_photo_unselect_button_label => 'Odznacz zdjęcie';

  @override
  String get edit_photo_select_existing_button_label =>
      'Wybierz istniejące zdjęcie';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Wybierz obraz klikając na niego';

  @override
  String get edit_photo_select_existing_download_label =>
      'Pobieranie istniejących zdjęć…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Nie przesłano jeszcze żadnych zdjęć powiązanych z tym produktem.';

  @override
  String get edit_photo_language_not_this_one =>
      'Nie ma jeszcze obrazu w tym języku';

  @override
  String get edit_photo_language_none => 'Jeszcze nie ma obrazu';

  @override
  String get category_picker_screen_title => 'Kategorie';

  @override
  String get basic_details => 'Podstawowe informacje';

  @override
  String get product_name => 'Nazwa Produktu';

  @override
  String get product_names => 'Nazwy produktów';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Dodaj nowe tłumaczenie';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Przed zatwierdzeniem upewnij się, że dodajesz tłumaczenie tylko wtedy, gdy język jest podany na opakowaniu.';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Zobacz zdjęcie z przodu';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Zrób zdjęcie z przodu';

  @override
  String get add_basic_details_product_name_hint =>
      'Wprowadź nazwę produktu (np. Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Zmienić domyślny język?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Czy chcesz, aby domyślny język produktu został ustawiony na \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Dobre przykłady';

  @override
  String get explanation_section_bad_examples => 'Złe przykłady';

  @override
  String get add_basic_details_product_name_help_title =>
      'Dobre praktyki: Nazwa produktu';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Nazwa produktu to **główna nazwa wydrukowana na opakowaniu**. Może być zastrzeżonym znakiem towarowym.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Uwaga:** Proszę nie dodawać tłumaczenia, **jeśli na opakowaniu nie ma informacji o danym języku**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Keczup pomidorowy';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Nie umieszczaj marki w nazwie';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Keczup pomidorowy **firmy Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Nie używaj symboli ®, ™, © ani podobnych';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count inne tłumaczenia',
      one: '$count inne tłumaczenie',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nazwa marki';

  @override
  String get brand_names => 'Nazwy marek';

  @override
  String get add_basic_details_brand_name_error =>
      'Wprowadź, proszę, nazwę marki';

  @override
  String get add_basic_details_brand_names_hint =>
      'Wprowadź marki (np. Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Dobre praktyki: Marki';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Wprowadź **wszystkie marki produktu**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Główna marka';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Główną markę**, zazwyczaj wyraźnie widoczną na przedniej stronie opakowania, należy **wpisać jako pierwszą**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Inne marki';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'W przypadku sprzedaży przez **dużą firmę**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** jest sprzedawany przez **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'W przypadku sprzedaży pod marką **przetłumaczoną na wiele języków**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Dolina Natury** jest czasami zapisywana jako **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Ilość i waga';

  @override
  String get add_basic_details_quantity_hint =>
      'Wprowadź wagę i, jeśli to konieczne, ilość (np. 4 x 100 g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Dobre praktyki: Ilość';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Skopiuj wartość podaną na produkcie i **nie zapomnij o jednostkach**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 g** lub **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (na 6 jajek)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(dla produktu w 3 pudełkach, każde po 150 g)';

  @override
  String get barcode => 'Kod kreskowy';

  @override
  String barcode_barcode(String barcode) {
    return 'Kod kreskowy: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Nieprawidłowy kod kreskowy';

  @override
  String get basic_details_add_success =>
      'Podstawowe informacje dodane pomyślnie';

  @override
  String get basic_details_add_error =>
      'Nie można dodać podstawowych informacji. Spróbuj ponownie za jakiś czas';

  @override
  String get clear_search => 'Wyczyść wyszukiwanie';

  @override
  String get confirm_clear =>
      'Zamierzasz wyczyścić całą swoją historię: czy na pewno chcesz kontynuować?';

  @override
  String get alert_clear_selected_user_list =>
      'Za moment wyczyścisz wybrane przedmioty w twojej historii';

  @override
  String get confirm_clear_selected_user_list => 'Na pewno chcesz kontynuować?';

  @override
  String get alert_select_items_to_clear =>
      'Proszę wybrać jeden lub więcej przedmiotów do wyczyszczenia';

  @override
  String confirm_clear_user_list(String name) {
    return 'Zamierzasz wyczyścić tę listę ($name): czy na pewno chcesz kontynuować?';
  }

  @override
  String get confirm_delete_user_list_title => 'Usunąć listę?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Zamierzasz usunąć listę \"$name\". \nCzy na pewno chcesz kontynuować?';
  }

  @override
  String get confirm_delete_user_list_button => 'Tak, potwierdzam';

  @override
  String importance_label(String name, String id) {
    return 'Kryterium - $name: $id';
  }

  @override
  String get user_list_all_title => 'Listy';

  @override
  String get user_list_all_empty => 'Utwórz pierwszą listę';

  @override
  String get product_list_select => 'Wybierz listę';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktów',
      one: 'Jeden produkt',
      zero: 'Lista pusta',
      many: '$count produktów',
      few: '$count produkty',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Dodaj listę';

  @override
  String get open_food_preferences_tooltip =>
      'Edytuj swoje preferencje żywieniowe';

  @override
  String get add_photo_button_label => 'Dodaj zdjęcie';

  @override
  String get add_packaging_photo_button_label =>
      'Zrób zdjęcia wszelkich informacji dotyczących pakowania i recyklingu';

  @override
  String get add_origin_photo_button_label =>
      'Zrób zdjęcia wszelkich informacji o pochodzeniu';

  @override
  String get add_emb_photo_button_label =>
      'Zrób zdjęcia wszelkich informacji o kodzie śledzenia';

  @override
  String get add_label_photo_button_label =>
      'Zrób zdjęcia wszelkich etykiet i informacji o certyfikatach';

  @override
  String get choose_image_source_title => 'Wybierz źródło obrazu';

  @override
  String get choose_image_source_body => 'Wybierz, proszę, źródło obrazu';

  @override
  String get gallery_source_label => 'Galeria';

  @override
  String get gallery_source_access_denied_dialog_title => 'Odmowa dostępu';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Niestety, aplikacja nie może uzyskać dostępu do Twojej galerii, ponieważ wcześniej odmówiłeś jej dostępu.\n\nPrzejdź do ustawień aplikacji w telefonie Ustawienia -> Zdjęcia';

  @override
  String get gallery_source_access_denied_dialog_button => 'Otwórz Ustawienia';

  @override
  String get share => 'Udostępnij';

  @override
  String share_product_text(String url) {
    return 'Przyjrzyj się temu produktowi na stronie Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Sprawdź ten produkt na Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Przyjrzyj się temu produktowi na stronie Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Sprawdź ten produkt w sekcji „Otwórz informacje o produktach”: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Sprawdź moją listę produktów na Open Food Facts: $url';
  }

  @override
  String get capture => 'Zrób zdjęcie';

  @override
  String get capture_new_picture => 'Zrób zdjęcie';

  @override
  String get choose_from_gallery => 'Wybierz z galerii';

  @override
  String get image_upload_queued =>
      'Obraz zostanie przesłany w tle tak szybko, jak to możliwe.';

  @override
  String get add_price_queued =>
      'Cena zostanie wysłana na serwer tak szybko, jak to możliwe.';

  @override
  String get background_task_title_full_refresh =>
      'Rozpoczynanie odświeżania wszystkich lokalnie przechowywanych produktów';

  @override
  String get background_task_title_top_n =>
      'Rozpoczynanie pobierania najbardziej popularnych produktów';

  @override
  String get expand_nutrition_facts => 'Rozwiń tabelę wartości odżywczych';

  @override
  String get expand_nutrition_facts_body =>
      'Zachowaj rozwiniętą tabelę wartości odżywczych';

  @override
  String get expand_ingredients => 'Rozwiń składniki';

  @override
  String get expand_ingredients_body => 'Zachowaj rozwinięty panel składników';

  @override
  String get no_internet_connection => 'Brak połączenia z internetem';

  @override
  String get world_results_label => 'Cały świat';

  @override
  String get world_results_action =>
      'Rozszerz swoje poszukiwania na cały świat';

  @override
  String get copy_to_clipboard => 'Kopiuj';

  @override
  String get paste_from_clipboard => 'Wklej ze schowka';

  @override
  String get no_data_available_in_clipboard => 'Brak danych w schowku';

  @override
  String get clipboard_barcode_copy => 'Skopiuj kod kreskowy do schowka';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Kod kreskowy $barcode skopiowany do schowka!';
  }

  @override
  String get open_product_website =>
      'Otwórz ten produkt na stronie internetowej';

  @override
  String get language_picker_label => 'Twój język';

  @override
  String get country_picker_label => 'Twój kraj';

  @override
  String get currency_picker_label => 'Twoja waluta';

  @override
  String get help_with_openfoodfacts => 'Pomoc z OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produkt zostanie zaktualizowany w tle tak szybko, jak to możliwe.';

  @override
  String get no_email_client_available_dialog_title => 'Brak aplikacji e-mail!';

  @override
  String get no_email_client_available_dialog_content =>
      'Prosimy o przesłanie nam ręcznie wiadomości e-mail na adres mobile@openfoodfacts.org';

  @override
  String get all_images => 'Wszystkie obrazy';

  @override
  String get selected_images => 'Wybrane obrazy';

  @override
  String get product_card_remove_product_tooltip => 'Usuń produkt';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nowy kod kreskowy: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Usuń wszystkie produkty z karuzeli';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Zeskanuj co najmniej dwa produkty, aby je porównać';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Kliknij, aby porównać zeskanowane produkty';

  @override
  String get scan_product_loading => 'Zeskanowano\nkod kreskowy:';

  @override
  String get scan_product_loading_initial =>
      'Szukamy tego produktu!\nProszę zaczekać kilka sekund…';

  @override
  String get scan_product_loading_long_request =>
      'Nadal szukamy tego produktu!\nCzy uważasz, że ładowanie zajmuje dużo czasu? My też…';

  @override
  String get scan_product_loading_unresponsive =>
      'Nadal szukamy tego produktu.\nCzy chcesz ponownie uruchomić wyszukiwanie?';

  @override
  String get scan_product_loading_restart_button =>
      'Uruchom ponownie wyszukiwanie';

  @override
  String get portion_calculator_description =>
      'Oblicz wartość odżywczą dla określonej ilości';

  @override
  String get portion_calculator_hint => 'Ilość w';

  @override
  String get portion_calculator_accessibility =>
      'Wprowadź ilość, aby obliczyć wartości odżywcze';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Wprowadź ilość pomiędzy $min a $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Brak danych. Nie można wykonać obliczeń.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Wartości odżywcze dla $grams g (lub ml)';
  }

  @override
  String get offline_data => 'Dane offline';

  @override
  String get ocr_image_upload_instruction =>
      'Prześlij obraz, aby automatycznie wyodrębnić podane informacje.';

  @override
  String get upload_image => 'Prześlij zdjęcie';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Nie udało się pobrać obrazu';

  @override
  String get image_edit_url_error =>
      'Nie udało się edytować zdjęcia, ponieważ nie podano adresu URL obrazu.';

  @override
  String get user_picture_source_remember => 'Zapamiętaj mój wybór';

  @override
  String get user_picture_source_ask => 'Pytaj za każdym razem';

  @override
  String get robotoff_continue => 'Kontynuuj';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pytania',
      one: 'pytanie',
    );
    return 'Następne $_temp0';
  }

  @override
  String get show_password => 'Pokaż hasło';

  @override
  String get owner_field_info_title => 'Wartości podane przez producenta';

  @override
  String get owner_field_info_message =>
      'Za pomocą tego logo wyróżniamy dane dostarczone przez producenta, których nie da się edytować.';

  @override
  String get owner_field_info_close_button => 'Zamknij te informacje';

  @override
  String get owner_field_image =>
      'Ten obraz został udostępniony przez producenta. Może nie być edytowalny.';

  @override
  String get edit_packagings_title => 'Elementy opakowania';

  @override
  String get edit_packagings_element_add => 'Dodaj element opakowania';

  @override
  String get edit_packagings_completed => 'Uzupełniono informacje o pakowaniu';

  @override
  String edit_packagings_element_title(int index) {
    return 'Element pakowania #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Liczba jednostek';

  @override
  String get edit_packagings_element_hint_units =>
      'Wprowadź liczbę opakowań tego samego kształtu i materiału zawartych w produkcie.';

  @override
  String get edit_packagings_element_field_shape => 'Kształt';

  @override
  String get edit_packagings_element_hint_shape =>
      'Podaj nazwę kształtu znajdującego się w instrukcjach dotyczących recyklingu, lub go wybierz.';

  @override
  String get edit_packagings_element_example_shape => 'Butelka';

  @override
  String get edit_packagings_element_field_material => 'Materiał';

  @override
  String get edit_packagings_element_hint_material =>
      'Podaj konkretny materiał, jeżeli można go wskazać (kod materiału znajdujący się w trójkącie często można znaleźć na opakowaniu), lub materiał ogólny (na przykład plastik lub metal), jeśli nie masz pewności.';

  @override
  String get edit_packagings_element_example_material => 'Szkło';

  @override
  String get edit_packagings_element_field_recycling =>
      'Informacje dotyczące recyklingu';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Wprowadź informacje dotyczące recyklingu tylko wtedy, gdy znajdują się na produkcie.';

  @override
  String get edit_packagings_element_example_recycling => 'Recykling';

  @override
  String get edit_packagings_element_field_quantity =>
      'Ilość produktu netto na jednostkę';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Podaj wagę lub objętość produktu netto i uzupełnij jednostkę (na przykład g. lub ml.).';

  @override
  String get edit_packagings_element_field_weight =>
      'Waga jednej pustej jednostki (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Przed ważeniem wyjmij z opakowania całą zawartość, umyj je oraz pozwól mu wyschnąć. Jeżeli to możliwe, użyj wagi z dokładnością do części dziesiętnej lub setnej grama.';

  @override
  String get background_task_title => 'Oczekujące wpisy';

  @override
  String get background_task_subtitle =>
      'Twój wkład zapisywany jest automatycznie, jednak wprowadzone zmiany nie będą widoczne natychmiast.';

  @override
  String get background_task_list_empty => 'Brak oczekujących zadań w tle';

  @override
  String get background_task_error_server_time_out => 'Przerwa serwera';

  @override
  String get background_task_error_no_internet =>
      'Błąd połączenia internetowego. Spróbuj ponownie później.';

  @override
  String get background_task_operation_unknown => 'Nieznany typ żądania';

  @override
  String get background_task_operation_details => 'szczegółowe zmiany';

  @override
  String get background_task_operation_image => 'przesłanie zdjęcia';

  @override
  String get background_task_operation_refresh =>
      'odświeżanie jest opóźnione po przesłaniu zdjęcia';

  @override
  String get background_task_run_started => 'zaczęto';

  @override
  String get background_task_run_not_started => 'nie zaczęto';

  @override
  String get background_task_run_to_be_deleted => '(do usunięcia)';

  @override
  String get background_task_question_stop =>
      'Czy chcesz jak najszybciej przerwać to działanie?';

  @override
  String get feed_back => 'Opinie';

  @override
  String get undo => 'Cofnij';

  @override
  String get copy_email_to_clip_board => 'Kopiuj adres e-mail do schowka';

  @override
  String get please_send_us_an_email_to =>
      'Wyślij nam ręcznie wiadomość e-mail na adres';

  @override
  String get email_copied_to_clip_board =>
      'E-mail został skopiowany do schowka!';

  @override
  String get select_accent_color => 'Wybierz kolor akcentu';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Niebieski';

  @override
  String get color_cyan => 'Cyjan';

  @override
  String get color_green => 'Zielony';

  @override
  String get color_light_brown => 'Domyślny';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Pomarańczowy';

  @override
  String get color_pink => 'Różowy';

  @override
  String get color_red => 'Czerwony';

  @override
  String get color_rust => 'Rdza';

  @override
  String get color_teal => 'Morska zieleń';

  @override
  String get text_contrast_mode => 'Kontrast tekstu';

  @override
  String get contrast_high => 'Wysoki';

  @override
  String get contrast_medium => 'Średni';

  @override
  String get contrast_low => 'Niski';

  @override
  String get product_refresher_internet_not_found => 'Nie znaleziono produktu!';

  @override
  String get product_refresher_internet_not_connected =>
      'Nie masz połączenia z internetem!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Serwer wyłączony ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Błąd serwera ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Nie znaleziono produktu!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Produkt o następującym kodzie kreskowym nie istnieje w naszej bazie danych: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Brak połączenia z internetem!';

  @override
  String get product_loader_network_error_message =>
      'Proszę sprawdzić, czy Twój smartfon jest podłączony do sieci Wi-Fi lub czy jest włączony transfer danych komórkowych';

  @override
  String get page_not_found_title => 'Nie znaleziono strony!';

  @override
  String get page_not_found_button => 'Wróć do strony głównej';

  @override
  String get download_data => 'Pobierz dane';

  @override
  String get download_top_products =>
      'Pobierz najlepsze 1000 produktów w Twoim kraju do natychmiastowego skanowania';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produkty',
      many: '$count produkty',
      few: '$count produkty',
    );
    return 'Pobierz topowe $_temp0 w twoim kraju dla natychmiastowego skanowania';
  }

  @override
  String get download_in_progress =>
      'Pobieranie danych\nTo może chwilę potrwać';

  @override
  String downloaded_products(int num) {
    return 'Dodano $num produktów';
  }

  @override
  String get update_offline_data => 'Zaktualizuj dane produktów offline';

  @override
  String get update_local_database_sub =>
      'Zaktualizuj bazę danych produktów lokalnych o najnowsze dane z Open Food Facts';

  @override
  String get clear_local_database => 'Wyczyść dane produktów offline';

  @override
  String get clear_local_database_sub =>
      'Wyczyść wszystkie lokalne dane produktów z aplikacji, aby zwolnić miejsce';

  @override
  String deleted_products(int num) {
    return 'Usunięto $num produktów';
  }

  @override
  String get loading => 'Ładowanie…';

  @override
  String get know_more => 'Dowiedz się więcej';

  @override
  String get offline_data_desc =>
      'Kliknij, aby dowiedzieć się więcej o danych offline';

  @override
  String get offline_product_data_title => 'Dane produktów offline';

  @override
  String available_for_download(int num) {
    return 'Dostępnych jest $num produktów do natychmiastowego skanowania';
  }

  @override
  String get country_selector_title => 'Wybierz swój kraj:';

  @override
  String get currency_selector_title => 'Wybierz swoją walutę:';

  @override
  String get language_selector_title => 'Wybierz swój język:';

  @override
  String get language_selector_section_selected => 'Wybrane języki';

  @override
  String get language_selector_section_frequently_used => 'Często używane';

  @override
  String get action_delete_list => 'Usuń';

  @override
  String get action_change_list => 'Zmień bieżącą listę';

  @override
  String get product_list_create => 'Stwórz';

  @override
  String get product_list_create_tooltip => 'Stwórz nową listę';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Wskaźnik odżywczy A';

  @override
  String get nutriscore_b => 'Wynik Nutri-Score B';

  @override
  String get nutriscore_c => 'Wskaźnik Nutri-Score C';

  @override
  String get nutriscore_d => 'Wskaźnik Nutri-Score D';

  @override
  String get nutriscore_e => 'Wynik Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Nowe obliczenie)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (nowe obliczenie)';

  @override
  String get nutriscore_unknown => 'Nieznany wynik Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nieznany wynik Nutri-Score (nowe obliczenie)';

  @override
  String get nutriscore_not_applicable =>
      'Wynik Nutri-Score nie ma zastosowania';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Wynik Nutri-Score nie ma zastosowania (nowe obliczenie)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Zielony-Wynik A';

  @override
  String get environmental_score_b_new => 'Zielony-Wynik B';

  @override
  String get environmental_score_c_new => 'Zielony-Wynik C';

  @override
  String get environmental_score_d_new => 'Zielony-Wynik D';

  @override
  String get environmental_score_e_new => 'Zielony wynik E';

  @override
  String get environmental_score_unknown_new => 'Nieznany wynik zielony';

  @override
  String get environmental_score_not_applicable_new =>
      'Wynik zielony nie ma zastosowania';

  @override
  String get nova_group_generic_new => 'Żywność ultraprzetworzona - grupy NOVA';

  @override
  String get nova_group_1 => 'Grupa NOVA 1';

  @override
  String get nova_group_2 => 'Grupa NOVA 2';

  @override
  String get nova_group_3 => 'Grupa NOVA 3';

  @override
  String get nova_group_4 => 'Grupa NOVA 4';

  @override
  String get nova_group_unknown => 'Nieznana Grupa NOVA';

  @override
  String get nutrition_facts => 'Poziomy składników odżywczych';

  @override
  String get faq_title_partners =>
      'Partnerzy i patroni organizacji pozarządowej';

  @override
  String get faq_title_vision =>
      'Wizja, misja, wartości i programy Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Zainstaluj Open Beauty Facts, aby utworzyć bazę danych kosmetyków';

  @override
  String get faq_title_install_pet =>
      'Zainstaluj Open Pet Food Facts, aby utworzyć bazę danych karmy dla zwierząt';

  @override
  String get faq_title_install_product =>
      'Zainstaluj Open Products Facts, aby utworzyć bazę danych produktów i wydłużyć żywotność obiektów';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nowe obliczanie wskaźnika Nutri-Score: co nowego?';

  @override
  String get contact_title_pro_page =>
      'Zawodowiec? Importuj swoje produkty do Open Food Facts';

  @override
  String get contact_title_pro_email => 'Kontakt z producentem';

  @override
  String get contact_title_press_page => 'Strona prasowa';

  @override
  String get contact_title_press_email => 'Kontakt dla prasy';

  @override
  String get contact_title_newsletter => 'Zapisz się do naszego newslettera';

  @override
  String get contact_title_calendar =>
      'Zapisz się do naszego kalendarza społecznościowego';

  @override
  String get hunger_games_loading_line1 => 'Proszę dać nam kilka sekund…';

  @override
  String get hunger_games_loading_line2 => 'Pobieramy pytania!';

  @override
  String get hunger_games_error_label =>
      'Argh! Coś poszło nie tak… i nie mogliśmy załadować pytań.';

  @override
  String get hunger_games_error_retry_button => 'Spróbujmy jeszcze raz!';

  @override
  String get reorder_attribute_action => 'Zmień kolejność atrybutów';

  @override
  String get link_cant_be_opened =>
      'Nie można otworzyć tego odnośnika na Twoim urządzeniu. Sprawdź, czy masz zainstalowaną przeglądarkę.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Szczegóły dla $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Szczegóły dla $pageName z $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Udostępnij';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Czym jest Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Gdzie znajdę nowe narzędzie do obliczania wskaźnika Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score stosowany jest w 7 krajach: Francji, Niemczech, Belgii, Hiszpanii, Luksemburgu, Holandii i Szwajcarii.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Producenci mają najpóźniej **2 lata** od daty podpisania dekretu na **zastąpienie** starego sposobu obliczania nowym.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Czym jest Zielony Wynik?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score to logo, którego celem jest informowanie o **wpływie żywności na środowisko**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Kod kolorystyczny waha się od ciemnozielonego (**A+**) dla produktów o **najmniejszym wpływie** do ciemnoczerwonego (**F**) dla produktów o **największym wpływie**.';

  @override
  String get guide_greenscore_logos_caption => 'Loga Green-Score';

  @override
  String get guide_greenscore_lca_title => 'Rdzeń: Ocena cyklu życia (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Naukowa ocena kategorii żywności';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Dla każdej kategorii produktów ustalany jest **punkt odniesienia** na podstawie danych z bazy danych środowiskowych Agribalyse (opracowanej przez ADEME i INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Analiza cyklu życia** to znormalizowana metoda oceny służąca do przeprowadzania wieloetapowej i wielokryterialnej oceny oddziaływania na środowisko.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Wymiary:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 etapów produkcji';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Rolnictwo';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Przetwórstwo';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Opakowanie';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Dystrybucja';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Konsumpcja';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 wskaźników wpływu na środowisko';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Zmiany klimatyczne/ślad węglowy';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Zubożenie warstwy ozonowej';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Promieniowanie jonizujące';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Grunt';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Zużycie wody i energii';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Zanieczyszczenie powietrza';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Woda morska i słodka (cząstki, zakwaszenie, eutrofizacja)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Wyczerpywanie się zasobów.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Premie i kary';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Aby nagrodzić lepsze produkty w danej kategorii, stosujemy **bonusy i kary na podstawie kilku kryteriów**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Sposób produkcji';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Premia** przyznawana jest produktom, które mają **oficjalną etykietę, etykietę lub certyfikat gwarantujący korzyści dla środowiska** (organiczny, sprawiedliwy handel, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Pochodzenie składników';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Premia** przyznawana jest w oparciu o pochodzenie składników. Premia ta uwzględnia **wpływ na transport**, a także **politykę środowiskową** każdego kraju producenta.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Zagrożone gatunki';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      '**Kara** jest przyznawana produktom zawierającym składniki mające znaczący **negatywny wpływ na bioróżnorodność i ekosystemy**, np. olej palmowy, którego produkcja jest przyczyną masowego wylesiania.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Opakowanie';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      '**Kara** jest obliczana z uwzględnieniem **obiegowego charakteru opakowań** (wykorzystanie surowców pochodzących z recyklingu i możliwość recyklingu) oraz nadmiernego pakowania.';

  @override
  String get guide_greenscore_transparency_title =>
      'Zwiększona potrzeba przejrzystości w celu lepszego pomiaru i zmniejszenia wpływu na środowisko';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'Aby dokładnie obliczyć wynik Green-Score, konieczne jest posiadanie **informacji, które niekoniecznie są określone na opakowaniu** (takich jak pochodzenie i dokładny procent każdego składnika) lub które rzadko są dostępne w użytecznej formie (takich jak lista wszystkich składników opakowania wraz z dokładnymi rodzajami użytych tworzyw sztucznych).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**W przypadku, gdy dane te nie są jeszcze dostępne, stosuje się wartości średnie**, jednak obecnie zwracamy się do wszystkich z prośbą o pomoc w zbieraniu tych informacji, które będą bardzo przydatne dla Green-Score, a także do wielu innych zastosowań.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Jak obywatele mogą pomóc?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Wszyscy obywatele mogą pomóc nam w gromadzeniu i porządkowaniu informacji zamieszczonych na produktach lub możliwych do wywnioskowania z nich, na przykład informacji na temat **opakowań**: „Mission Emballages”: zakrojony na szeroką skalę, wspólny inwentarz opakowań wszystkich produktów spożywczych (w języku francuskim).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Jak producenci mogą pomóc';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Producenci mogą przesyłać nam swoje dane bezpośrednio za pośrednictwem naszej bezpłatnej platformy dla producentów.';

  @override
  String get guide_greenscore_better_product_title =>
      'Który produkt jest lepszy dla planety?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Może być trudno to stwierdzić';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Wybór zrównoważonej żywności to jedno z najskuteczniejszych działań, jakie możemy podjąć dla klimatu, ponieważ **nasz globalny system żywnościowy odpowiada za ponad jedną czwartą emisji wszystkich gazów cieplarnianych**.\n(Źródło: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Masz moc!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Dobra wiadomość jest taka, że daje nam to potężny sposób na wprowadzenie zmian.\n**Każdy z nas spożywa około 1000 posiłków rocznie**. To 1000 okazji, by **wybrać lepszą przyszłość dla planety**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Pomaga być odpowiedzialnym i podejmować decyzje';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Wybór zrównoważonej żywności może wydawać się skomplikowany. Etykiety są mylące, a informacji często brakuje. Zielony Wynik został stworzony, aby to uprościć, zapewniając **jasną**, **opartą na badaniach naukowych** i **transparentną** ocenę ekologiczną produktów spożywczych, dokładnie tam, gdzie jej potrzebujesz: podczas zakupów.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Przezroczystość';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'W przeciwieństwie do zastrzeżonych etykiet, sposób obliczania Green-Score jest **całkowicie otwarty** i może zostać **zweryfikowany przez każdego**.';

  @override
  String get guide_nova_title => 'Żywność wysoko przetworzona';

  @override
  String get guide_nova_what_is_nova_title => 'Czym jest ultraprzetwarzanie?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Grupy NOVA informują o poziomie przetworzenia żywności.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Klasyfikacja NOVA pozwala na podział żywności na **4 grupy** na podstawie jej **stopnia przetworzenia przemysłowego** (żywność minimalnie przetworzona lub nieprzetworzona, składniki kulinarne, żywność przetworzona, żywność ultraprzetworzona).';

  @override
  String get guide_nova_logos_caption => 'Loga NOVA';

  @override
  String get guide_nova_groups_title => '4 grupy NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Istnieją 4 grupy NOVA, przy czym problematyczna jest Grupa 4 - Żywność ultraprzetworzona.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Żywność minimalnie przetworzona lub nieprzetworzona';

  @override
  String get guide_nova_groups_arg1_text =>
      'Nieprzetworzona (lub naturalna) żywność to **jadalne części roślin** (nasiona, owoce, liście, łodygi, korzenie) **lub zwierząt** (mięśnie, podroby, jaja, mleko), a także grzyby, glony i woda, po oddzieleniu ich od natury.';

  @override
  String get guide_nova_groups_arg2_title => 'Przetworzone składniki kulinarne';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Żywność przetworzona';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include Various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. Most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be Eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Żywność wysoko przetworzona';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact Group 1 Food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or Salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary Preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Problemy z ultraprzetwarzaniem';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Ekstremalne przetwarzanie składników żywności';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Wiele z nich **pozyskuje się w wyniku dalszego przetwarzania składników żywności**, np. oleje uwodornione lub interestryfikowane, hydrolizowane białka, izolat białka sojowego, maltodekstryna, cukier inwertowany i syrop kukurydziany o wysokiej zawartości fruktozy.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Dodatki, które wykraczają poza czyste bezpieczeństwo żywności';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Dodatki do żywności ultraprzetworzonej obejmują te, które są również stosowane w żywności przetworzonej, takie jak konserwanty, przeciwutleniacze i stabilizatory. Dodatki występujące wyłącznie w produktach ultraprzetworzonych obejmują te stosowane **w celu naśladowania lub wzmocnienia walorów sensorycznych żywności lub zamaskowania nieprzyjemnych cech produktu końcowego**. Dodatki te obejmują barwniki i inne barwniki, stabilizatory koloru; aromaty, wzmacniacze smaku, słodziki bezcukrowe; oraz substancje wspomagające przetwarzanie, takie jak środki nasycające, ujędrniające, zwiększające objętość i przeciwobrzękowe, środki przeciwpieniące, przeciwzbrylające i glazurujące, emulgatory, sekwestranty i humektanty.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Przetwarzanie, którego nie możesz wykonać w domu';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Wykorzystywane są liczne sekwencje procesów**, aby połączyć zazwyczaj liczne składniki i stworzyć produkt końcowy (stąd określenie „ultraprzetworzony”). Procesy te obejmują kilka **niemających krajowych odpowiedników**, takich jak uwodornienie i hydroliza, ekstruzja i formowanie oraz wstępna obróbka przed smażeniem.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Aspekty drapieżne i finansowe ultraprzetwarzania';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Głównym celem ultraprzetwarzania jest tworzenie markowych**, **wygodnych** (trwałych, gotowych do spożycia), **atrakcyjnych** (hipersmakowitych) i **wysoce dochodowych** (niskokosztowych) produktów spożywczych, mających na celu wyparcie wszystkich innych grup żywności. Produkty ultraprzetworzone są zazwyczaj atrakcyjnie pakowane i intensywnie promowane.';

  @override
  String get guide_nova_explanations_arg5_title => 'Zagrożenie dla zdrowia';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Od 2018 roku, dzięki NutriNet-Santé, po raz pierwszy zwrócono uwagę na powiązania między **spożywaniem żywności ultraprzetworzonej a zwiększonym ryzykiem zachorowania na raka, choroby układu krążenia i cukrzycę**. Obecnie ponad 90 badań na całym świecie potwierdza te ustalenia.\nNajsilniejsze powiązania dotyczą **otyłości, śmiertelności z przyczyn sercowo-naczyniowych i objawów depresji**. U dzieci wpływ ten obserwuje się przede wszystkim w zakresie masy ciała i zaburzeń lipidowych.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Kraje zalecają ich ograniczenie';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Niektóre kraje wykorzystują grupy NOVA do ustalania swoich wytycznych lub celów żywieniowych, na przykład:\n\n- **🇧🇷 Wytyczne żywieniowe Brazylii** **zalecają ograniczenie spożycia** żywności przetworzonej i unikanie żywności ultraprzetworzonej.\n\n- **🇫🇷 Cele polityki żywieniowej zdrowia publicznego Francji** na lata 2018–2022 zakładają **zmniejszenie spożycia żywności ultraprzetworzonej z grupy 4 o 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Witamy w Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Czym jest Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts to **wspólna**, **bezpłatna** i **otwarta** baza danych produktów spożywczych z całego świata.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Wierzymy, że każdy powinien mieć dostęp do informacji o tym, co je. Gromadząc dane o składnikach, alergenach, wartościach odżywczych i innych, **pozwalamy konsumentom dokonywać świadomych wyborów** i napędzamy przemysł spożywczy **w kierunku większej przejrzystości**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Cechy otwartych informacji o żywności';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Otrzymuj powiadomienia o niepożądanych składnikach';

  @override
  String get guide_open_food_facts_tips_title =>
      'Wskazówki dotyczące robienia świetnych zdjęć';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Czego nie robić';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Unikaj cieni i odblasków.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Brak rozmazanego lub nieostrego tekstu.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Nie wycinaj fragmentów tekstu.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Unikaj tła o zbyt dużej intensywności.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Co robić';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Stosuj dobre, równomierne oświetlenie.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Upewnij się, że tekst jest wyraźny i czytelny.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Zapisz całą listę składników.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Przechowywać produkt na płaskiej powierzchni.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Pomóż nam zbudować „Wikipedię jedzenia”';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Ocena jakości odżywczej';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Wynik pozwalający unikać żywności ultraprzetworzonej';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Wynik dla planety';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-pl.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title => 'Witamy w Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Czym jest Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts rozszerza naszą misję na naszych futrzanych przyjaciół! To **baza danych karm dla kotów, psów i innych zwierząt**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Gromadzimy informacje na temat **składników**, **analizy wartości odżywczych** i wytycznych żywieniowych, aby pomóc właścicielom zwierząt domowych wybrać najlepszą karmę odpowiadającą potrzebom ich zwierząt.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Cechy otwartych informacji o karmie dla zwierząt';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Otrzymuj powiadomienia o niepożądanych składnikach';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Czy Twój pupil ma alergię na któryś ze składników? Możesz ustawić listę składników kosmetycznych, których należy unikać, bezpośrednio w aplikacji!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Wskazówki dotyczące robienia świetnych zdjęć';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Czego nie robić';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Unikaj cieni i odblasków.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Brak rozmazanego lub nieostrego tekstu.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Nie wycinaj fragmentów tekstu.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Unikaj tła o zbyt dużej intensywności.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Co robić';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Stosuj dobre, równomierne oświetlenie.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Upewnij się, że tekst jest wyraźny i czytelny.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Zapisz całą listę składników.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Przechowywać produkt na płaskiej powierzchni.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Uwaga dotycząca punktacji';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Opracowanie systemu punktacji karmy dla zwierząt domowych **nie jest obecnie priorytetem**. Metodologia byłaby skomplikowana, ponieważ potrzeby żywieniowe różnią się znacznie w zależności od gatunku, wieku i stanu zdrowia. Nie znaleźliśmy jeszcze żadnego niezależnego zespołu naukowego, który byłby w stanie opracować taką punktację.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-pl.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Witamy w Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Czym jest Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts to wspólna baza danych **produktów kosmetycznych**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Naszym celem jest rozszyfrowanie list składników, aby pomóc Ci **zrozumieć, co znajduje się w Twoich produktach do pielęgnacji osobistej**. Od kremów nawilżających po makijaż, zbieramy dane o składnikach, alergenach i opakowaniach, aby promować transparentność w branży kosmetycznej.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Cechy Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Otrzymuj powiadomienia o niepożądanych składnikach';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Czy masz alergię na któryś ze składników? Chcesz unikać substancji komedogennych? Chcesz unikać kontrowersyjnych składników? Możesz ustawić listę składników kosmetycznych, których należy unikać, bezpośrednio w aplikacji!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Wskazówki dotyczące robienia świetnych zdjęć';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Czego nie robić';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Unikaj cieni i odblasków.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Brak rozmazanego lub nieostrego tekstu.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Nie wycinaj fragmentów tekstu.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Unikaj tła o zbyt dużej intensywności.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Co robić';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Stosuj dobre, równomierne oświetlenie.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Upewnij się, że tekst jest wyraźny i czytelny.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Zapisz całą listę składników.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Jeżeli butelka jest zakrzywiona, zrób tyle zdjęć, ile potrzeba.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Aby zobaczyć listę składników, może być konieczne odklejenie etykiety.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Przechowywać produkt na płaskiej powierzchni.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Uwaga dotycząca punktacji';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'W przeciwieństwie do produktów spożywczych, w świecie kosmetyków **nie obowiązuje powszechnie uznawany, wspierany przez rząd system punktacji, taki jak Nutri-Score**. Wpływ składników może być bardzo indywidualny i zależy od rodzaju skóry, alergii i indywidualnych uwarunkowań.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-pl.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Witamy w Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Czym są ceny otwarte?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices to projekt mający na celu **gromadzenie i udostępnianie cen produktów na całym świecie**. To publicznie dostępny zbiór danych, który można wykorzystać do badań, analiz i nie tylko. Open Prices jest rozwijany i utrzymywany przez Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'Jak działają Ceny Otwarte?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Opracowujemy zbiór danych cenowych w modelu open source oparty na crowdsourcingu**. Użytkownicy mogą dodawać ceny za pośrednictwem tej aplikacji internetowej lub oficjalnej aplikacji mobilnej Open Food Facts. Sprzedawcy detaliczni i aplikacje innych firm również mogą się do tego przyczynić, korzystając z naszego interfejsu API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Zbierz zdjęcia metek cenowych w alejkach';

  @override
  String get guide_open_prices_how_arg2_title => 'Zbierz zdjęcia paragonów';

  @override
  String get guide_open_prices_why_title => 'Dlaczego Open Food Facts to robi?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Informacje o cenach mają kluczowe znaczenie dla zrozumienia systemów żywnościowych. To kluczowy czynnik w zrozumieniu kosztów żywności i promowaniu zdrowszej diety. Udostępnianie danych o cenach ułatwia badaczom, dziennikarzom i obywatelom **lepsze zrozumienie, jak ceny żywności zmieniają się geograficznie i w czasie**.';

  @override
  String get guide_open_prices_why_arg1_title => 'Śledź ewolucję cen w czasie';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Zobacz **ewolucję cen**: shrinkflation, cheapflation, możemy je śledzić razem!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Porównaj ceny w Twojej okolicy';

  @override
  String get guide_open_prices_why_arg2_text =>
      'W miarę jak będziemy znać więcej cen, będziesz mógł zauważyć **najtańsze sklepy w Twojej okolicy**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Czy rozważałeś możliwość pobierania cen ze stron internetowych sprzedawców detalicznych?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Ze względów prawnych i technicznych **nie uważamy, aby pozyskiwanie cen ze stron internetowych sprzedawców detalicznych było właściwym sposobem na dodawanie danych do Open Prices**. Chcemy mieć pewność, że zbierane przez nas ceny są dokładne i aktualne, a otrzymywanie zeskanowanych cen od osób, które je udostępniają, nam na to nie pozwala.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Funkcja scrapowania cen jest rozważana w przyszłej wersji Open Prices, ale będzie ona wykonywana przez samą Open Prices, abyśmy mogli uzyskać dowód ceny na podstawie strony HTML.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Możesz przekazać ceny korzystając z naszego interfejsu API.\nJeśli chcesz przekazać ceny na dużą skalę, skontaktuj się z nami pod adresem prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title => 'Witamy w Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Czym jest Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts to ogromna, otwarta baza danych dotycząca **wszystkich produktów z kodem kreskowym, które nie są żywnością, kosmetykami ani karmą dla zwierząt**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'Od **elektroniki** po **zabawki**, od **ubrań** po **środki czystości** – jeśli coś ma kod kreskowy, można go dodać. Celem tego projektu jest stworzenie „internetu rzeczy” dla przedmiotów codziennego użytku, zapewniając powszechny dostęp do informacji o nich.';

  @override
  String get guide_open_products_facts_features_title =>
      'Cechy produktów otwartych Fakty';

  @override
  String get guide_open_products_facts_features_text =>
      'Celem Open Products Facts jest umożliwienie konsumentom **wydłużenia żywotności przedmiotów** poprzez udostępnienie im rozwiązań gospodarki o obiegu zamkniętym, które umożliwiają konserwację, **naprawę**, **recykling** przedmiotów lub znalezienie dla nich nowego właściciela.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Ślad węglowy dla niektórych produktów';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Wpływ CO2** według Francuskiego Urzędu Ochrony Środowiska ADEME dostarcza informacji na temat **wpływu dwutlenku węgla** w wielu kategoriach, należy upewnić się, że produkty są kategoryzowane precyzyjnie.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Wskaźnik możliwości naprawy wielu produktów';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Zawsze, gdy będzie dostępny francuski wskaźnik możliwości naprawy, wyświetlimy go. Co więcej, **możesz rozpocząć zbieranie zmiennych za pomocą silnika Folksonomy**, dzięki czemu będziemy mogli go samodzielnie przeliczyć w przyszłości, nawet w krajach, w których nie jest on dostępny.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Znajdź sposoby na przekazanie/odsprzedaż swojego produktu';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Udostępniamy linki do **usług firm trzecich, przyjaznych gospodarce o obiegu zamkniętym**, które pomogą Ci znaleźć produkt, którego szukasz, jako produkt używany, aby w sposób bardziej oszczędny korzystać z zasobów planety.\nPamiętaj, że nie otrzymujemy za to wynagrodzenia, a system działa jedynie jako przykład dla dwóch stron internetowych we Francji. Możesz pomóc w rozwoju tego systemu, dokumentując więcej stron na wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Jakie informacje są przydatne?';

  @override
  String get guide_open_products_facts_information_text =>
      'W przypadku tak szerokiego zakresu produktów **dane, które zbieramy, są elastyczne**. W tym celu **stworzyliśmy silnik Folksonomy**.';

  @override
  String get guide_open_products_facts_folksonomy_title => 'Silnik Folksonomii';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Silnik Folksonomii to narzędzie, które pomaga w tworzeniu produktów o odpowiednich właściwościach. Pomaga to usprawnić wyszukiwanie i odkrywanie, a także obliczać i wyświetlać interesujące elementy w przyszłości.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Możesz dodać dowolne klucze i wartości, takie jak: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Otrzymasz automatyczne sugestie możliwych właściwości, a także będziesz mieć możliwość dodawania i dokumentowania nowych właściwości dla ulubionych rodzajów produktów.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-pl.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Otwórz preferencje żywieniowe';

  @override
  String get guide_coming_soon_button_title => 'Już wkrótce';

  @override
  String get guide_learn_more_subtitle => 'Kliknij, aby dowiedzieć się więcej';

  @override
  String get preview_badge => 'Zapowiedź';

  @override
  String get prices_feedback_form =>
      'Kliknij tutaj, aby przesłać nam swoją opinię na temat tej nowej funkcji!';

  @override
  String get menu_button_list_actions => 'Wybierz akcję';

  @override
  String get error_loading_photo => 'Błąd ładowania zdjęcia';

  @override
  String get photo_viewer_action_use_picture_as => 'Użyj jako…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Użyj tego obrazka jako…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Użyj tego obrazka jako… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Bliższe dane';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Szczegóły tego zdjęcia';

  @override
  String get photo_viewer_details_title => 'Szczegóły zdjęcia';

  @override
  String get photo_viewer_details_contributor_title => 'Współtwórca';

  @override
  String get photo_viewer_details_size_title => 'Rozmiar';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pikseli';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'Adres URL';

  @override
  String get product_page_compatibility_score => 'Zgodny';

  @override
  String get user_lists_action_multi_select => 'Wybór wielokrotny';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Twój wynik zgodności: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Zdjęcie z przodu';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Zdjęcie wykazie składników';

  @override
  String get product_image_nutrition_accessibility_label => 'Obraz żywieniowy';

  @override
  String get product_image_packaging_accessibility_label =>
      'Zdjęcie opakowania';

  @override
  String get product_image_other_accessibility_label => 'Inne zdjęcie';

  @override
  String get product_image_outdated_message =>
      'To zdjęcie może być nieaktualne';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (ten obraz może być nieaktualny)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (ten obraz może być zablokowany przez producenta)';
  }

  @override
  String get product_image_error => 'Nie można załadować obrazu!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Nie można załadować $type (błąd sieci?)';
  }

  @override
  String get product_page_image_no_image_available => 'Brak obrazu\n!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Brak zdjęcia tego produktu';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Zmień kolejność lub ukryj akcje';

  @override
  String get product_page_action_bar_setting_modal_title => 'Edytuj działania';

  @override
  String get product_page_action_bar_item_move_up => 'Podnieść';

  @override
  String get product_page_action_bar_item_move_down => 'Opuszczać';

  @override
  String get product_page_action_bar_item_enable => 'Włącz akcję';

  @override
  String get product_page_action_bar_item_disable => 'Wyłącz akcję';

  @override
  String get product_page_pending_operations_banner_title =>
      'Przesyłanie edycji…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Dane wyświetlane na tej stronie **nie odzwierciedlają jeszcze Twoich modyfikacji**.\nPoczekaj kilka sekund…';

  @override
  String get product_add_a_language => 'Dodaj język';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Kod kreskowy $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Usuń ten produkt z karuzeli';

  @override
  String get carousel_unsupported_header => 'Nieobsługiwany kod kreskowy!';

  @override
  String get carousel_unsupported_title => 'Ups!';

  @override
  String get carousel_unsupported_text =>
      'Zeskanowany kod kreskowy nie jest obsługiwany przez Open Food Facts!';

  @override
  String get carousel_error_header => 'Błąd!';

  @override
  String get carousel_error_title => 'To okropne!';

  @override
  String get carousel_error_text_1 =>
      'Nie udało się pobrać informacji o tym kodzie kreskowym:';

  @override
  String get carousel_error_text_2 =>
      'Sprawdź swoje połączenie internetowe lub kliknij ten przycisk:';

  @override
  String get carousel_error_button => 'Ponów próbę';

  @override
  String get carousel_unknown_product_header => 'Nieznany produkt';

  @override
  String get carousel_unknown_product_title =>
      'Gratulacje!\nZnalazłeś __rzadki klejnot!__';

  @override
  String get carousel_unknown_product_text =>
      'Nasza wspólna baza danych zawiera ponad **3 miliony produktów**, ale ten kod kreskowy nie istnieje: ';

  @override
  String get carousel_unknown_product_button => 'Dodaj ten produkt';

  @override
  String get carousel_loading_header => 'Ładowanie informacji...';

  @override
  String get carousel_loading_title =>
      'Właśnie zeskanowałeś produkt z następującym kodem kreskowym:';

  @override
  String get carousel_loading_text =>
      'Szukamy go w naszej bazie danych zawierającej ponad **3 miliony produktów!**';

  @override
  String get product_type_subtitle_food => 'Warzywa, owoce, mrożonki…';

  @override
  String get product_type_subtitle_beauty => 'Makijaż, mydła, pasty do zębów…';

  @override
  String get product_type_subtitle_pet_food => 'Karma dla psów i kotów…';

  @override
  String get product_type_subtitle_product => 'Smartfony, meble…';

  @override
  String get photo_field_front => 'Zdjęcie produktu';

  @override
  String get photo_field_ingredients => 'Zdjęcie listy składników';

  @override
  String get photo_field_nutrition => 'Zdjęcie żywieniowe';

  @override
  String get photo_field_packaging =>
      'Zdjęcie informacji dotyczących opakowania';

  @override
  String get photo_already_exists => 'To zdjęcie już istnieje';

  @override
  String get photo_missing => 'Brakuje tego zdjęcia';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Obróć w lewo';

  @override
  String get photo_rotate_right => 'Obróć w prawo';

  @override
  String get photo_undo_action => 'Cofnij poprzednią akcję';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Mapa świata $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Współtwórcy OpenStreetMap';

  @override
  String get not_applicable_short => 'Nie dotyczy';

  @override
  String get knowledge_panel_warning_text => 'Ostrzeżenie';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Czym ten wskaźnik Nutri-Score różni się od tego podanego na opakowaniu?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Istnieją dwa możliwe wyjaśnienia:\nLista składników i/lub informacje żywieniowe są nieaktualne.\n\nOferujemy „Nowe obliczenie” wskaźnika Nutri-Score (lub V2). Sprawdź, czy na opakowaniu znajduje się baner „Nowe obliczenie”.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Sprawdź składniki';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Sprawdź informacje żywieniowe';

  @override
  String url_not_supported(String url) {
    return 'Niestety nie możemy otworzyć adresu URL:\n$url';
  }

  @override
  String get product_list_export => 'Eksport';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'Wyświetl kod kreskowy';

  @override
  String get product_footer_action_barcode_short => 'Kod kreskowy';

  @override
  String get product_footer_action_open_website => 'Otwórz stronę internetową';

  @override
  String get product_footer_action_report => 'Raport';

  @override
  String get product_footer_action_contributor_guide => 'Pomoc';

  @override
  String get product_footer_action_data_quality_tags => 'Jakość danych';

  @override
  String get product_page_tab_for_me => 'Dla mnie';

  @override
  String get product_page_tab_website => 'Strona';

  @override
  String get product_page_tab_prices => 'Ceny';

  @override
  String get prices_explanation_card_title => 'Dlaczego ceny?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** to projekt mający na celu zbieranie i udostępnianie cen produktów na całym świecie. 🌍. Open Prices jest rozwijany i utrzymywany przez Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Dowiedz się więcej';

  @override
  String get product_page_tab_folksonomy => 'Folksonomia';

  @override
  String get folksonomy_explanation_card_title =>
      'Czym są atrybuty folksonomii?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atrybuty są oparte na **parametrach klucz-wartość**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Właściwości te są tworzone i archiwizowane przez współpracowników w celu dowolnego wykorzystania.';

  @override
  String get folksonomy_action_external_link_title => 'Otwórz link zewnętrzny';

  @override
  String get folksonomy_action_external_link_warning =>
      'Linki zewnętrzne mogą być niebezpieczne. Czy na pewno chcesz je odwiedzić?';

  @override
  String get prices_products_empty_title => 'Brak dostępnej ceny';

  @override
  String get prices_products_empty_explanation =>
      'Bądź pierwszy, który doda swoją opinię!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Najpopularniejsze $pageSize produkty (łącznie: $total)';
  }

  @override
  String get app_review_title => 'Czy podoba Ci się ta aplikacja?';

  @override
  String get app_review_low => 'Mogło być lepiej';

  @override
  String get app_review_medium => 'Nieźle';

  @override
  String get app_review_high => 'Uwielbiam to!';

  @override
  String get app_review_feedback_modal_title =>
      'Pomóż nam ulepszyć naszą aplikację';

  @override
  String get app_review_feedback_modal_content =>
      'Jeśli masz chwilę, wypełnij ten formularz, abyśmy mogli **udoskonalić przyszłe aktualizacje**:';

  @override
  String get app_review_feedback_modal_open_form => 'Odpowiedz na formularz';

  @override
  String get app_review_feedback_modal_later => 'Zapytaj mnie później';

  @override
  String get nutrition_facts_extract_new =>
      'NOWOŚĆ: Możesz automatycznie wyodrębnić składniki odżywcze ze zdjęcia!';

  @override
  String get nutrition_facts_extract_button_text => 'Wyodrębnij teraz';

  @override
  String get nutrition_facts_extract_in_progress => 'Ekstrakcja w toku…';

  @override
  String get nutrition_facts_extract_successful => 'Ekstrakcja pomyślna';

  @override
  String get nutrition_facts_extract_failed =>
      'Nie udało się wyodrębnić składników odżywczych ze zdjęcia';

  @override
  String get prices_discount => 'Promocja';

  @override
  String get prices_stats_statistics => 'Statystyka';

  @override
  String get prices_stats_title => 'Statystyki cen';

  @override
  String get prices_stats_prices_section => 'Ceny';

  @override
  String get prices_stats_products_section => 'Produkty';

  @override
  String get prices_stats_locations_section => 'Lokalizacje';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Współtwórcy';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Inne';

  @override
  String get prices_stats_total => 'Razem';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Konsumpcja';

  @override
  String get prices_stats_with_price => 'Z ceną';

  @override
  String get prices_stats_food => 'Żywność';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Produkty';

  @override
  String get prices_stats_pet_food => 'Karma dla zwierząt';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Kraje';

  @override
  String get prices_stats_price_tag => 'Cenówka';

  @override
  String get prices_stats_receipt => 'Rachunek';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Strona';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Inne';

  @override
  String get prices_stats_last_updated => 'Ostatnia aktualizacja:';

  @override
  String get prices_stats_error => 'Wystąpił błąd podczas ładowania statystyk.';

  @override
  String get product_edit_robotoff_question_answered => 'Pytanie rozwiązane!';

  @override
  String get product_edit_robotoff_proof => 'Dowód';

  @override
  String get preferences_card_general => 'Ogólne';

  @override
  String get preferences_prices_title => 'Ceny';

  @override
  String get preferences_prices_subtitle =>
      'Zarządzaj swoimi preferencjami cenowymi';

  @override
  String get preferences_card_project => 'Projekt Open Food Facts';

  @override
  String get preferences_contribute_title => 'Wnieś wkład';

  @override
  String get preferences_my_contributions_title => 'Mój wkład';

  @override
  String get preferences_my_stats_title => 'Moje statystyki';

  @override
  String get preferences_contribute_subtitle =>
      'Przetłumacz, ulepsz nasze narzędzia…';

  @override
  String get preferences_connect_title => 'Łączyć';

  @override
  String get preferences_connect_subtitle =>
      'Skontaktuj się z nami lub obserwuj nas w mediach społecznościowych';

  @override
  String get preferences_support_title => 'Wesprzyj nas';

  @override
  String get preferences_support_subtitle =>
      'Pomóż nam informować miliony konsumentów na całym świecie';

  @override
  String get preferences_card_help => 'Pomoc i wsparcie';

  @override
  String get preferences_faq_title => 'Najczęściej zadawane pytania (FAQ)';

  @override
  String get preferences_faq_subtitle => 'Uzyskaj odpowiedzi na swoje pytania';

  @override
  String get logged_out => 'Wylogowano';

  @override
  String get preferences_app_bar_message =>
      'Dziękujemy, że jesteś naszym członkiem!';

  @override
  String get preferences_app_bar_products_modified => 'Produkty zmodyfikowane';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Zobacz wszystkie statystyki';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Wyszukaj $provider dla „$keyword”';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Wyszukaj ustawienie (np. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji => 'Dostępność: Pokaż emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Dostępność: Usuń kolory';

  @override
  String get preferences_app_settings_products => 'Produkty';

  @override
  String get preferences_card_about => 'Na temat';

  @override
  String get preferences_legal_information_title => 'Informacje prawne';

  @override
  String get preferences_legal_information_subtitle =>
      'Warunki korzystania, polityka prywatności i inne';

  @override
  String get preferences_terms_of_use => 'Zasady korzystania';

  @override
  String get preferences_legal_mentions => 'Wzmianki prawne';

  @override
  String get preferences_legal_header =>
      'Open Food Facts to baza danych produktów spożywczych **tworzona przez wszystkich, dla wszystkich**.\nMożesz jej używać, aby podejmować lepsze decyzje żywieniowe, a ponieważ jest to **otwarta baza danych**, każdy może ją **wykorzystać w dowolnym celu**.';

  @override
  String get preferences_privacy_policy => 'Polityka Prywatności';

  @override
  String get preferences_licenses => 'Licencje';

  @override
  String get preferences_about_app_title => 'O aplikacji';

  @override
  String get preferences_about_app_subtitle =>
      'Informacje techniczne, informacje dla deweloperów i inne';

  @override
  String get preferences_card_information => 'Informacje';

  @override
  String get preferences_version_number_title => 'Numer wersji';

  @override
  String get preferences_scanner_title => 'Skaner';

  @override
  String get preferences_app_store => 'Sklep z aplikacjami';

  @override
  String get preferences_app_system_settings => 'Ustawienia systemowe';

  @override
  String get preferences_source_code => 'Uzyskaj dostęp do kodu źródłowego';

  @override
  String get preferences_source_code_subtitle =>
      'I zacznij mieć wpływ na życie milionów ludzi';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Uzupełnij produkty';

  @override
  String get preferences_tips => 'Porady';

  @override
  String get tips_discover_nutriscore => 'Odkryj nowy Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Na stronie internetowej Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Zarządzaj moim kontem';

  @override
  String get preferences_manage_account_tooltip => 'Zarządzaj swoim kontem';

  @override
  String get preferences_change_password_title => 'Zmień moje hasło';

  @override
  String get preferences_danger_zone => 'Strefa niebezpieczna';

  @override
  String get preferences_account_deletion_subtitle =>
      'Wszystkie Twoje wpłaty zostaną utracone';

  @override
  String get preferences_contributions_title => 'Wkład';

  @override
  String get preferences_dev_mode_app_settings_title => 'Ustawienia aplikacji';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Bardzo eksperymentalny sposób skanowania produktów w trybie offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Odśwież wszystkie produkty z serwera';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Proszę tego unikać, chyba że jest to absolutnie konieczne';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Tryb demonstracyjny';

  @override
  String get preferences_dev_mode_add_cards_title => 'Dodaj karty do skanera';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Dodaje 3 próbki produktów do skanera';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Gospodarz folksonomii';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Gospodarz: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Eksperymenty z dostępnością';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Wybór wielu produktów w cenach';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Panele wiedzy zamawiane przez użytkowników';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Tymczasowy dostęp do wyszukiwania lokalizacji';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Porównanie obok siebie 2 lub 3 produktów';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Import listy produktów';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Wyniki i metodologie';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Dowiedz się, jak obliczany jest wskaźnik Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Odkryj główne zmiany w metodologii';

  @override
  String get preferences_faq_discover_project_title => 'Odkryj projekt';

  @override
  String get preferences_faq_discover_off_title =>
      'Odkryj fakty dotyczące żywności';

  @override
  String get preferences_faq_discover_obf_title =>
      'Odkryj fakty dotyczące otwartego piękna';

  @override
  String get preferences_faq_discover_opff_title =>
      'Odkryj fakty dotyczące karmy dla zwierząt';

  @override
  String get preferences_faq_discover_op_title => 'Odkryj otwarte ceny';

  @override
  String get preferences_faq_discover_opf_title =>
      'Odkryj fakty dotyczące produktów Open';

  @override
  String get preferences_faq_faq_title => 'FAQ – Najczęściej zadawane pytania';

  @override
  String get preferences_faq_off_ngo_title =>
      'Organizacja pozarządowa Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informacje';

  @override
  String get preferences_connect_community_updates_title =>
      'Otrzymuj aktualizacje społeczności';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Bądź na bieżąco z aktualnościami aplikacji i społeczności';

  @override
  String get preferences_connect_community_calendar_title =>
      'Zapisz się do naszego kalendarza społecznościowego';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Zaangażuj się, biorąc udział w jednym z naszych wydarzeń wirtualnych';

  @override
  String get preferences_connect_blog_title => 'Blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Otrzymuj najświeższe wiadomości na bieżąco';

  @override
  String get preferences_connect_community_help_title =>
      'Uzyskaj pomoc od społeczności';

  @override
  String get preferences_connect_improve_app_title =>
      'Pomóż nam ulepszyć aplikację';

  @override
  String get preferences_connect_debug_info_title =>
      'Wyślij nam informacje debugowania';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Wyślij nam e-mail ze szczegółowymi informacjami dotyczącymi debugowania';

  @override
  String get preferences_connect_feedback_title =>
      'Prześlij nam opinię o aplikacji';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Pomóż kształtować przyszłość aplikacji';

  @override
  String get preferences_connect_survey_title =>
      'Weź udział w ankiecie aplikacji';

  @override
  String get preferences_connect_survey_subtitle =>
      'Pomóż nam zrozumieć, co powinniśmy zbudować dalej';

  @override
  String get preferences_connect_professionals_title => 'Profesjonaliści';

  @override
  String get preferences_connect_pro_subtitle =>
      'Całkowicie za darmo, zapewnia dokładne dane dla 500 aplikacji i milionów konsumentów. Samoobsługa, kompatybilność z PIM lub arkuszami kalkulacyjnymi (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Skontaktuj się z nami, aby rozpocząć';

  @override
  String get preferences_connect_press_title => 'Prasa';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Zdobądź wszystkie materiały potrzebne do swojego raportu';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Skontaktuj się z nami, aby zadać pytanie prasie lub poinformować nas o swoim raporcie';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Zostań aktywnym wolontariuszem';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Rozwój, Komunikacja, Projektowanie… Mile widziany jest każdy rodzaj wolontariatu lub wiedzy specjalistycznej!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Odkryj niektóre z wielu sposobów, w jakie możesz się przyczynić';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Rozwój aplikacji mobilnych';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Dowiedz się, jak przyczynić się do rozwoju oprogramowania';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Codzienne niestabilne kompilacje, zupełnie nowe funkcje';

  @override
  String get preferences_contribute_local_community_title =>
      'Rozwijaj swoją lokalną społeczność';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Pomoc w tłumaczeniu oprogramowania, treści i analizy składników';

  @override
  String get preferences_contribute_share_subtitle =>
      'Przygotowaliśmy dla Ciebie mały szablon, który Ci w tym pomoże :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Proste kroki, aby zwiększyć przejrzystość żywności w Twoim kraju';

  @override
  String get preferences_contribute_data_quality_title => 'Jakość danych';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Dołącz do zespołu ds. jakości danych';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Przyłącz się do naszych wysiłków na rzecz zapewnienia, że baza danych jest kompletna i dokładna';

  @override
  String get preferences_contributions_products_added_title =>
      'Dodane produkty';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nowe produkty dodałem do Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkty, które muszę uzupełnić';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Wszystkie niekompletne produkty';

  @override
  String get preferences_my_contributions_prices_title => 'Ceny';

  @override
  String get preferences_my_contributions_my_prices_title => 'Moje ceny';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Moje ceny, moje dowody…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkty, które możesz pomóc uzupełnić';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Pomóż obliczyć Nutri-Score i Green-Score w swoim kraju';

  @override
  String get preferences_prices_user_prices_subtitle => 'Ceny, które podałem';

  @override
  String get preferences_prices_proofs_subtitle => 'Metki cenowe i paragony';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Zrób zdjęcia swoich paragonów i zeskanuj powiązane kody kreskowe';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Zrób zdjęcia cen w sklepie';

  @override
  String get preferences_prices_newest_title => 'Najnowsze ceny';

  @override
  String get preferences_prices_newest_subtitle =>
      'Najnowsze ceny dodane przez społeczność Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Współpracownicy z największą liczbą cen';

  @override
  String get preferences_prices_metrics_title => 'Wskaźniki ceny otwartej';

  @override
  String get preferences_prices_metrics_subtitle => 'Śledź ewolucję projektu';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Sposoby wniesienia wkładu';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Potwierdź ceny dodane przez siebie lub innych za pomocą sztucznej inteligencji';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Szybko dodawaj wiele paragonów lub zdjęć półek z rolki aparatu';

  @override
  String get preferences_prices_challenges_title => 'Miesięczne wyzwania';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Bierz udział w miesięcznych tematycznych zadaniach, aby zbierać nagrody';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Odzyskaj swoje dane dotyczące lojalności';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Dowiedz się, jak poprosić o swoje dane';

  @override
  String get preferences_page_customize_app_title => 'Dostosuj aplikację';

  @override
  String get preferences_page_contribute_project_title =>
      'Wnieś swój wkład w projekt';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Proste sposoby na pomoc w otwarciu Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodyki punktacji, pomoc i więcej informacji o projekcie';

  @override
  String get product_edit_robotoff_positive_button => 'Zaakceptuj sugestię';

  @override
  String get product_edit_robotoff_negative_button => 'Odrzuć sugestię';

  @override
  String get product_edit_robotoff_show_proof => 'Pokaż dowód';

  @override
  String get product_edit_robotoff_expand_proof => 'Rozszerz dowód';

  @override
  String get product_page_tab_raw_data => 'Surowe dane';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Strona $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Strona $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count z $total elementów';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count z $total elementów';
  }

  @override
  String item_count(int count) {
    return '$count elementów';
  }

  @override
  String item_count_string(String count) {
    return '$count elementów';
  }

  @override
  String get prices_no_result => 'Nie znaleziono statystyk cenowych.';

  @override
  String get prices_error_loading_more_items =>
      'Błąd podczas ładowania większej liczby elementów';

  @override
  String get prices_proof_error =>
      'Uwierzytelnianie nie powiodło się, nie można pobrać dowodów';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count z $total dowodów';
  }

  @override
  String proof_count(int count) {
    return '$count dowodów';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count z $total współautorów';
  }

  @override
  String contributors_count(int count) {
    return '$count współtwórców';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count z $total lokalizacji';
  }

  @override
  String prices_locations_count(int count) {
    return '$count lokalizacji';
  }

  @override
  String get restart_to_apply_message =>
      'Aby zastosować zmiany, uruchom ponownie aplikację.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interfejs graficzny';

  @override
  String get preferences_app_settings_media_title => 'Głoska bezdźwięczna';

  @override
  String get preferences_about_app_development_title => 'Development';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Otwarte Laboratoria Faktów Żywnościowych';

  @override
  String get preferences_root_account_title => 'Konto';

  @override
  String get preferences_contribute_translate_header =>
      'Przenieś Open Food Fakty do swojego języka';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Zarejestruj się w wersji alfa aplikacji';

  @override
  String get preferences_dev_mode_section_data => 'Wkłady i dane o produktach';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Nie pokazuj Folksonomii';

  @override
  String get preferences_account_title => 'Konto';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Dodano $created';
  }

  @override
  String get location_map_details_title => 'Szczegóły lokalizacji';

  @override
  String get location_map_details_name => 'Nazwa';

  @override
  String get location_map_details_street => 'Ulica';

  @override
  String get location_map_details_city => 'Miasto';

  @override
  String get location_map_details_postcode => 'Kod pocztowy';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Współrzędne';

  @override
  String get location_map_details_osm_id => 'Identyfikator OSM';
}
