// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class AppLocalizationsNl extends AppLocalizations {
  AppLocalizationsNl([String locale = 'nl']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ja';

  @override
  String get add => 'Toevoegen';

  @override
  String get account_delete_message =>
      'Weet je zeker dat je je account wilt verwijderen?\nAls er een specifieke reden is, deel deze dan hieronder';

  @override
  String get reason => 'Reden';

  @override
  String get okay => 'Oké';

  @override
  String get validate => 'Bevestigen';

  @override
  String get create => 'Aanmaken';

  @override
  String get applyButtonText => 'Toepassen';

  @override
  String get next_label => 'Volgende';

  @override
  String get continue_label => 'Doorgaan';

  @override
  String get exit_label => 'Afsluiten';

  @override
  String get previous_label => 'Vorige';

  @override
  String get go_back_to_top => 'Terug naar boven';

  @override
  String get save => 'Opslaan';

  @override
  String get save_confirmation => 'Weet u zeker dat u wilt opslaan?';

  @override
  String get skip => 'Overslaan';

  @override
  String get cancel => 'Annuleer';

  @override
  String get ignore => 'Negeren';

  @override
  String get close => 'Sluit';

  @override
  String get no => 'Nee';

  @override
  String get stop => 'Stop';

  @override
  String get finish => 'Voltooien';

  @override
  String get calculate => 'Berekenen';

  @override
  String get reset_food_prefs => 'Voedselvoorkeuren resetten';

  @override
  String get error => 'Er ging iets mis';

  @override
  String get error_occurred => 'Er is een fout opgetreden';

  @override
  String get featureInProgress => 'We werken nog aan deze functie, wacht af';

  @override
  String get label_web => 'Bekijk in een browser';

  @override
  String get learnMore => 'Meer informatie';

  @override
  String get unknown => 'Onbekend';

  @override
  String get match_very_good => 'Zeer goede overeenkomst';

  @override
  String get match_good => 'Goede overeenkomst';

  @override
  String get match_poor => 'Slechte overeenkomst';

  @override
  String get match_may_not => 'Komt mogelijk niet overeen';

  @override
  String get match_does_not => 'Komt niet overeen';

  @override
  String get match_unknown => 'Onbekende overeenkomst';

  @override
  String get match_short_very_good => 'Zeer goede overeenkomst';

  @override
  String get match_short_good => 'Goede overeenkomst';

  @override
  String get match_short_poor => 'Slechte overeenkomst';

  @override
  String get match_short_may_not => 'Komt mogelijk niet overeen';

  @override
  String get match_short_does_not => 'Komt niet overeen';

  @override
  String get match_short_unknown => 'Onbekende overeenkomst';

  @override
  String get licenses => 'Licenties';

  @override
  String get looking_for => 'Zoeken naar';

  @override
  String get welcomeToOpenFoodFacts => 'Welkom bij Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts is een wereldwijde non-profitorganisatie die wordt ondersteund door lokale gemeenschappen.';

  @override
  String get productDataUtility =>
      'Zie de voedselgegevens die relevant zijn voor uw voorkeuren.';

  @override
  String get healthCardUtility => 'Kies de producten die goed voor je zijn.';

  @override
  String get ecoCardUtility => 'Kies voedsel dat goed is voor de planeet.';

  @override
  String get server_error_open_new_issue =>
      'Geen serverreactie! U kunt een probleem rapporteren via de volgende link.';

  @override
  String get sign_in_text =>
      'Log in op je Open Food Facts account om je bijdragen op te slaan';

  @override
  String get incorrect_credentials => 'Onjuiste gebruikersnaam of wachtwoord.';

  @override
  String get password_lost_incorrect_credentials =>
      'Dit e-mailadres of deze gebruikersnaam bestaat niet. Controleer uw inloggegevens.';

  @override
  String get password_lost_server_unavailable =>
      'We ondervinden momenteel vertragingen op onze servers en bieden hiervoor onze excuses aan. Probeer het later opnieuw.';

  @override
  String get login => 'Inloggen';

  @override
  String get login_result_type_server_unreachable => 'Netwerk niet bereikbaar';

  @override
  String get login_result_type_server_issue =>
      'Probleem op de server. Probeer het later opnieuw.';

  @override
  String get login_page_username_or_email =>
      'Voer gebruikersnaam of e-mailadres in';

  @override
  String get login_page_password_error_empty =>
      'Voer een wachtwoord in alstublieft';

  @override
  String get create_account => 'Account aanmaken';

  @override
  String get sign_in => 'Inloggen';

  @override
  String get sign_in_mandatory => 'Voor deze functie moet u zich aanmelden.';

  @override
  String get help_improve_country =>
      'Help Open Food Facts in uw land te verbeteren';

  @override
  String get sign_out => 'Uitloggen';

  @override
  String get sign_out_confirmation => 'Ben je zeker dat je wilt uitloggen?';

  @override
  String get password => 'Wachtwoord';

  @override
  String get forgot_password => 'Wachtwoord vergeten?';

  @override
  String get forgot_password_question => 'Wachtwoord vergeten?';

  @override
  String get view_profile => 'Profiel bekijken';

  @override
  String get reset_password => 'Wachtwoord resetten';

  @override
  String get reset_password_explanation_text =>
      'Als u uw wachtwoord bent vergeten, voert u uw gebruikersnaam of e-mailadres in om instructies te ontvangen voor het opnieuw instellen van uw wachtwoord. Vergeet ook niet de map Spam te controleren.';

  @override
  String get username_or_email => 'Gebruikersnaam of e-mail';

  @override
  String get reset_password_done =>
      'Een e-mail met een link om je wachtwoord te resetten is verstuurd naar het e-mailadres dat gekoppeld is aan je account. Controleer ook je spammap.';

  @override
  String get send_reset_password_mail => 'Wachtwoord wijzigen';

  @override
  String get enter_some_text => 'Tekst invoeren';

  @override
  String get sign_up_page_title => 'Registreren';

  @override
  String get sign_up_page_action_button => 'Registreren';

  @override
  String get sign_up_page_action_doing_it => 'Registreren…';

  @override
  String get sign_up_page_action_ok =>
      'Gefeliciteerd! Uw account is zojuist aangemaakt.';

  @override
  String get sign_up_page_display_name_hint => 'Naam';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Voer de weergavenaam in die u wilt gebruiken';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mail is verplicht';

  @override
  String get sign_up_page_email_error_invalid => 'Ongeldig e-mailadres';

  @override
  String get sign_up_page_username_hint => 'Gebruikersnaam: Openbaar zichtbaar';

  @override
  String get sign_up_page_username_error_empty => 'Voer een gebruikersnaam in';

  @override
  String get sign_up_page_username_error_invalid =>
      'Vul a.u.b. een geldige gebruikersnaam in';

  @override
  String get sign_up_page_username_description =>
      'Gebruikersnaam mag geen spaties, hoofdletters of speciale tekens bevatten.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Gebruikersnaam mag niet langer zijn dan $value tekens';
  }

  @override
  String get sign_up_page_password_hint => 'Wachtwoord';

  @override
  String get sign_up_page_password_error_empty =>
      'Voer een wachtwoord in alstublieft';

  @override
  String get sign_up_page_password_error_invalid =>
      'Voer een geldig wachtwoord in (minimaal 6 tekens)';

  @override
  String get sign_up_page_confirm_password_hint => 'Bevestig wachtwoord';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Bevestig a.u.b. het nieuwe wachtwoord';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'De wachtwoorden komen niet overeen';

  @override
  String get sign_up_page_agree_text => 'Ik ga akkoord met de Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'gebruiksvoorwaarden en bijdrage';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Als u een account aanmaakt, is akkoord gaan met de gebruiksvoorwaarden verplicht, maar anonieme bijdragen kunnen nog steeds via de app worden gedaan';

  @override
  String get sign_up_page_producer_checkbox => 'Ik ben een voedselproducent';

  @override
  String get sign_up_page_producer_hint => 'Producent/merk';

  @override
  String get sign_up_page_producer_error_empty =>
      'Voer een producent of een merknaam in';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Ik wil me graag inschrijven voor de nieuwsbrief van Open Food Facts (u kunt zich op elk moment afmelden)';

  @override
  String get sign_up_page_user_name_already_used =>
      'De gebruikersnaam bestaat al, kies een andere gebruikersnaam.';

  @override
  String get sign_up_page_email_already_exists =>
      'bestaat al, log in op het account of probeer het met een ander e-mailadres.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Voer een geldig e-mailadres in alsjeblieft.';

  @override
  String get sign_up_page_server_busy =>
      'Het spijt ons heel erg, we hebben wat technische problemen bij het aanmaken van uw account. Probeer het later opnieuw.';

  @override
  String get settingsTitle => 'Instellingen';

  @override
  String get darkmode => 'Thema';

  @override
  String get darkmode_dark => 'Donker';

  @override
  String get darkmode_light => 'Licht';

  @override
  String get darkmode_system_default => 'Standaard systeeminstelling';

  @override
  String get thanks_for_contributing => 'Bedankt voor je bijdrage!';

  @override
  String get contributors_label => 'Ze bouwen de app';

  @override
  String get contributors_dialog_title => 'Medewerkers';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Bijdrager: $name';
  }

  @override
  String get contributors_description =>
      'Een lijst van alle bijdragers aan deze app';

  @override
  String get support => 'Ondersteuning';

  @override
  String get support_join_slack => 'Vraag om hulp in ons Slack-kanaal';

  @override
  String get support_via_forum => 'Vraag om hulp op ons forum';

  @override
  String get support_via_email => 'Stuur ons een e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'App-logboeken verzenden?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Wilt u toepassingslogboeken als bijlage bij uw e-mail voegen?';

  @override
  String get termsOfUse => 'Gebruiksvoorwaarden';

  @override
  String get legalNotices => 'Juridische mededelingen';

  @override
  String get privacy_policy => 'Privacybeleid';

  @override
  String get about_this_app => 'Over deze app';

  @override
  String get contribute => 'Bijdragen';

  @override
  String get contribute_sw_development => 'Softwareontwikkeling';

  @override
  String get contribute_develop_text =>
      'De code voor elk Open Food Facts-product is beschikbaar op GitHub. Je bent van harte welkom om de code te hergebruiken (hij is open source) en ons te helpen deze te verbeteren, voor iedereen, op de hele planeet.';

  @override
  String get contribute_develop_text_2 =>
      'U kunt deelnemen aan de Open Food Facts Slack-chatroom, wat de beste manier is om vragen te stellen.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV-modus?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Activeer de DEV-modus';

  @override
  String get contribute_donate_title => 'Doneer';

  @override
  String get contribute_donate_header => 'Doneer aan Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Houd er rekening mee dat met de interne alfaversie volledig gegevensverlies mogelijk is en dat de app op elk moment onbruikbaar kan worden!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Onvoltooide producten';

  @override
  String get contribute_improve_header => 'Verbeteren';

  @override
  String get contribute_improve_text =>
      'De database is het hart van het project. Je kan ons makkelijk en heel snel helpen: door de app voor je telefoon te downloaden en te beginnen met het toevoegen of verbeteren van producten.\n\nDe Open Food Facts-website biedt vele andere manieren om bij te dragen: ';

  @override
  String get contribute_translate_header => 'Vertalen';

  @override
  String get contribute_data_quality => 'Gegevenskwaliteit';

  @override
  String get contribute_translate_link_text => 'Begin met vertalen';

  @override
  String get contribute_translate_text =>
      'Open Food Facts is een wereldwijd project met producten uit meer dan 160 landen. Open Food Facts is in tientallen talen vertaald, met voortdurend wijzigende inhoud.';

  @override
  String get contribute_translate_text_2 =>
      'Vertalingen zijn een van de belangrijkste taken van het project';

  @override
  String get contribute_join_skill_pool =>
      'Draag uw vaardigheden bij aan Open Food Facts. Sluit je aan bij de vaardighedenpool!';

  @override
  String get contribute_share_header => 'Deel Open Food Facts met je vrienden';

  @override
  String get contribute_share_content =>
      'Ik wil je laten weten dat ik de app Open Food Facts gebruik, waarmee je op een gepersonaliseerde manier de gezondheids- en milieueffecten van je eten kunt zien. Het werkt door de barcodes op de verpakking te scannen. Het is gratis, vereist geen registratie en je kunt zelfs helpen het aantal ontcijferde producten te vergroten. Download de app voor jouw telefoon via deze link: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Draag de prijzen bij door een GDPR export van je spaarkaartgegevens aan te vragen';

  @override
  String get tap_to_answer => 'Tik hier om vragen te beantwoorden';

  @override
  String get tap_to_answer_hint =>
      'Tik hier om vragen over dit product te beantwoorden';

  @override
  String get robotoff_questions_loading_hint =>
      'Een ogenblik geduld terwijl vragen over dit product worden geladen';

  @override
  String get saving_answer => 'Uw antwoord opslaan';

  @override
  String get contribute_to_get_rewards =>
      'Word een deelnemer aan voedseltransparantie';

  @override
  String get question_sign_in_text =>
      'Log in op uw Open Food Facts-account om krediet te krijgen voor uw bijdragen';

  @override
  String get question_yes_button_accessibility_value => 'Antwoord met ja';

  @override
  String get question_no_button_accessibility_value => 'Antwoord met nee';

  @override
  String get question_skip_button_accessibility_value => 'Sla deze vraag over';

  @override
  String get tap_to_edit_search => 'Tik om de zoekopdracht te bewerken';

  @override
  String get myPreferences => 'Mijn voorkeuren';

  @override
  String get account_create_message =>
      'Maak uw account aan en sluit u aan bij de Open Food Facts-community om voedselkennis over de hele wereld op te bouwen!';

  @override
  String get join_us => 'Doe mee';

  @override
  String get myPreferences_profile_title => 'Uw profiel';

  @override
  String get myPreferences_profile_subtitle =>
      'Beheer uw Open Food Facts-bijdragersaccount.';

  @override
  String get myPreferences_settings_title => 'App-instellingen';

  @override
  String get myPreferences_settings_subtitle => 'Donkere modus, Talen…';

  @override
  String get myPreferences_food_title => 'Voedselvoorkeuren';

  @override
  String get myPreferences_food_subtitle =>
      'Kies welke informatie over voedsel voor u het belangrijkst is.';

  @override
  String get myPreferences_food_comment =>
      'Kies welke informatie over voedsel voor u het belangrijkst is, om voedsel te rangschikken volgens uw voorkeuren, bekijk eerst de informatie die u belangrijk vindt en ontvang een compatibiliteitsoverzicht. Die voedselvoorkeuren blijven op uw apparaat staan en zijn niet gekoppeld aan uw Open Food Facts-bijdragersaccount, als je er een hebt.';

  @override
  String get confirmResetPreferences => 'Voedselvoorkeuren resetten?';

  @override
  String get myPersonalizedRanking => 'Mijn persoonlijke ranglijst';

  @override
  String get ranking_tab_all => 'Alles';

  @override
  String get ranking_subtitle_match_yes => 'Een geweldige overeenkomst voor u';

  @override
  String get ranking_subtitle_match_no => 'Zeer slechte overeenkomst';

  @override
  String get ranking_subtitle_match_maybe => 'Onbekende overeenkomst';

  @override
  String get refresh_with_new_preferences =>
      'Ververs de lijst met je nieuwe voorkeuren';

  @override
  String get reloaded_with_new_preferences =>
      'Opnieuw geladen met uw nieuwe voorkeuren';

  @override
  String get profile_navbar_label => 'Gemeenschap';

  @override
  String get scan_navbar_label => 'Scan';

  @override
  String get history_navbar_label => 'Geschiedenis';

  @override
  String get list_navbar_label => 'Lijsten';

  @override
  String get category => 'Filter op categorie';

  @override
  String get category_all => 'Alles';

  @override
  String get category_search => '(categorie zoeken)';

  @override
  String get filter => 'Filter';

  @override
  String get scan => 'Producten uit het scanscherm';

  @override
  String get scan_history => 'Scangeschiedenis';

  @override
  String get search => 'Zoeken';

  @override
  String get search_product_help =>
      'Zoek een product,\neen merk of een streepjescode';

  @override
  String get search_filter => 'Zoekfilter';

  @override
  String get search_history => 'Zoekgeschiedenis';

  @override
  String get search_store => 'Zoeken naar een winkel';

  @override
  String get search_store_help => 'Tip: voeg de stad of het land toe';

  @override
  String get tap_for_more => 'Tik om meer info te zien…';

  @override
  String get product => 'Product';

  @override
  String get unknownBrand => 'Onbekend merk';

  @override
  String get unknownProductName => 'Onbekende productnaam';

  @override
  String get label_refresh => 'Vernieuw';

  @override
  String get label_reload => 'Herladen';

  @override
  String get image => 'Afbeelding';

  @override
  String get front_photo => 'Foto voorzijde';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (deze afbeelding is mogelijk verouderd)';
  }

  @override
  String get outdated_image_short_label => 'kan verouderd zijn';

  @override
  String get ingredients => 'Ingrediënten';

  @override
  String get ingredients_editing_instructions =>
      'Behoud de originele volgorde. Geef het percentage aan indien gespecificeerd. Scheid met een komma of koppelteken en gebruik haakjes voor ingrediënten van een ingrediënt.';

  @override
  String get ingredients_editing_error => 'Kan de ingrediënten niet opslaan.';

  @override
  String get ingredients_editing_image_error =>
      'Kan geen afbeelding voor nieuwe ingrediënten ophalen.';

  @override
  String get ingredients_editing_title => 'Ingrediënten bewerken';

  @override
  String get ingredients_photo => 'Ingrediënten foto';

  @override
  String get packaging_editing_instructions =>
      'Vermeld alle verpakkingsonderdelen gescheiden door een komma of regel, met hun hoeveelheid (bijv. 1 of 6) type (bijv. fles, doos, blik), materiaal (bijv. plastic, metaal, aluminium) en indien beschikbaar hun grootte (bijv. 33cl) en instructies voor recycling.\nVoorbeeld: 1 glazen fles om te recyclen, 1 plastic dop om weg te gooien';

  @override
  String get packaging_editing_error => 'Opslaan van de verpakking is mislukt.';

  @override
  String get packaging_editing_image_error =>
      'Het ophalen van een nieuwe verpakkingsafbeelding is mislukt.';

  @override
  String get packaging_editing_title => 'Verpakking bewerken';

  @override
  String get nutrition => 'Voedingswaarde';

  @override
  String get nutrition_facts_photo => 'Foto van voedingswaarden';

  @override
  String get nutrition_facts_editing_title => 'Voedingswaarden bewerken';

  @override
  String get packaging_information => 'Verpakkingsinformatie';

  @override
  String get packaging_information_photo => 'Foto van verpakkingsinformatie';

  @override
  String get missing_product => 'Je hebt een nieuw product gevonden!';

  @override
  String get add_product_take_photos =>
      'Maak foto\'s van de verpakking om dit product toe te voegen aan Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Gelieve eerst wat foto\'s te maken. Je kunt het product altijd op een later tijdstip voltooien.';

  @override
  String get add_product_information_button_label =>
      'Voeg productinformatie toe';

  @override
  String get new_product => 'Nieuw Product';

  @override
  String get new_product_found_title => 'Nieuw product gevonden!';

  @override
  String get new_product_found_text =>
      'Onze gezamenlijke database bevat meer dan **3 miljoen producten**, maar deze streepjescode bestaat niet: ';

  @override
  String get new_product_found_button => 'Voeg dit product toe';

  @override
  String get new_product_leave_title => 'Deze pagina verlaten?';

  @override
  String get new_product_leave_message =>
      'Het lijkt erop dat je niets hebt ingevoerd. Wil je deze pagina echt verlaten?';

  @override
  String get new_product_dialog_description =>
      'Neem foto\'s van de verpakking om dit product toe te voegen aan onze gemeenschappelijke database';

  @override
  String get new_product_dialog_illustration_description =>
      'Een illustratie met onbekende Nutri-Score en Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Foto van voorkant verpakking';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Bevestig het uploaden van de foto van de voorkant';

  @override
  String get confirm_button_label => 'Bevestig';

  @override
  String get send_image_button_label => 'Afbeelding verzenden';

  @override
  String get crop_page_action_saving => 'De afbeelding opslaan…';

  @override
  String get crop_page_action_cropping => 'De afbeelding bijsnijden…';

  @override
  String get crop_page_action_local => 'Een lokale versie opslaan…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oeps… er is iets met je foto!';

  @override
  String get crop_page_action_local_failed_message =>
      'We kunnen de afbeelding niet lokaal verwerken voordat deze naar onze server wordt verzonden. Probeer het later opnieuw of neem contact met ons op als het probleem aanhoudt.';

  @override
  String get crop_page_action_retake => 'Maak een nieuwe foto';

  @override
  String get crop_page_too_small_image_title => 'De afbeelding is te klein!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'De minimale grootte in pixels voor het uploaden van afbeeldingen is ${expectedMinWidth}x$expectedMinHeight. De huidige afbeelding is ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server =>
      'Een oproep naar de server voorbereiden…';

  @override
  String get front_packaging_photo_title => 'Foto van voorkant verpakking';

  @override
  String get ingredients_photo_title => 'Foto van de ingrediëntenlijst';

  @override
  String get nutritional_facts_photo_title => 'Foto van de voedingswaardetabel';

  @override
  String get recycling_photo_title => 'Foto recycleren';

  @override
  String get take_photo_title => 'Neem een foto';

  @override
  String get take_more_photo_title => 'Maak meer foto\'s';

  @override
  String get front_photo_uploaded => 'Foto voorkant geüpload';

  @override
  String get ingredients_photo_button_label => 'Ingrediënten foto';

  @override
  String get ingredients_photo_uploaded => 'Foto van ingrediënten geüpload';

  @override
  String get nutrition_cache_loading_error =>
      'Kan voedingsstoffen uit de cache niet laden';

  @override
  String get nutritional_facts_photo_button_label => 'Foto van voedingswaarden';

  @override
  String get nutritional_facts_input_button_label => 'Vul voedingswaarden in';

  @override
  String get nutritional_facts_added => 'Voedingswaarden toegevoegd';

  @override
  String get categories_added => 'Categorieën toegevoegd';

  @override
  String get new_product_title_nutriscore => 'Bereken de Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Help ons door minimaal een categorie en voedingswaarden in te vullen';

  @override
  String get new_product_title_environmental_score => 'Bereken de Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Ontvang het door ten minste één categorie in te vullen';

  @override
  String get new_product_additional_environmental_score =>
      'Maak Green-Score-berekening nauwkeuriger met oorsprong, verpakking en meer';

  @override
  String get new_product_title_nova =>
      'Bereken het voedselverwerkingsniveau (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Krijg het door het invullen van de voedselcategorie en ingrediënten';

  @override
  String get new_product_desc_nova_unknown =>
      'Voedselverwerkingsniveau onbekend';

  @override
  String get new_product_title_pictures => 'Nieuw product';

  @override
  String get new_product_title_pictures_details =>
      'Maak de volgende foto\'s en de Open Food Facts-engine kan de rest doen!';

  @override
  String get new_product_title_misc => 'En enkele basisgegevens…';

  @override
  String new_product_done_msg(String username) {
    return 'Bedankt voor uw bijdrage “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Bedankt voor uw bijdrage!';

  @override
  String get new_product_done_button_label => 'Ontdek het aangevulde product';

  @override
  String get hey_incomplete_product_message =>
      'Tik om NU 3 vragen te beantwoorden om Nutri-Score, Green Score en Ultra-processing (NOVA) te berekenen!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Tik nu om 2 vragen te beantwoorden en zo dit cosmeticaproduct te analyseren!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Tik nu om 3 vragen te beantwoorden en zo dit diervoederproduct te analyseren!';

  @override
  String get hey_incomplete_product_message_product =>
      'Tik nu om dit product te voltooien!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Foto van voedingswaarden geüpload';

  @override
  String get recycling_photo_button_label => 'Foto van recyclen';

  @override
  String get recycling_photo_uploaded => 'Foto recyclen geüpload';

  @override
  String get take_more_photo_button_label => 'Maak meer foto\'s';

  @override
  String get other_photo_uploaded => 'Diverse foto\'s geüpload';

  @override
  String get retake_photo_button_label => 'Opnieuw';

  @override
  String get selecting_photo => 'Foto selecteren';

  @override
  String get uploading_image => 'Foto uploaden naar de server';

  @override
  String get uploading_image_type_front =>
      'Afbeelding van de voorkant uploaden naar Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Afbeelding van ingrediënten uploaden naar Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Voedingswaardenafbeelding uploaden naar Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Verpakkingsafbeelding uploaden naar Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Andere afbeelding uploaden naar Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Afbeelding uploaden naar Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Ontbrekende ingrediënten toevoegen';

  @override
  String get score_add_missing_packaging_image =>
      'Ontbrekende verpakkingsafbeelding toevoegen';

  @override
  String get score_add_missing_nutrition_facts =>
      'Ontbrekende voedingswaarden toevoegen';

  @override
  String get score_add_missing_product_traces =>
      'Ontbrekende productsporen toevoegen';

  @override
  String get score_add_missing_product_category => 'Selecteer een categorie';

  @override
  String get score_add_missing_precise_product_category =>
      'Selecteer een nauwkeurigere categorie';

  @override
  String get score_add_missing_product_countries =>
      'Voeg ontbrekende productlanden toe';

  @override
  String get score_add_missing_product_emb =>
      'Voeg ontbrekende producttraceerbaarheidscodes toe';

  @override
  String get score_add_missing_product_labels =>
      'Voeg ontbrekende productlabels toe';

  @override
  String get score_add_missing_product_origins =>
      'Voeg ontbrekende productherkomsten toe';

  @override
  String get score_add_missing_product_stores =>
      'Voeg ontbrekende productwinkels toe';

  @override
  String get score_add_missing_product_brands =>
      'Ontbrekende productmerken toevoegen';

  @override
  String get score_update_nutrition_facts => 'Voedingswaarden bijwerken';

  @override
  String get nutrition_page_title => 'Voedingswaarden';

  @override
  String get nutrition_page_nutritional_info_title => 'Voedingsinformatie';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Waarden vermeld op het product:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ja';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Nee';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Foto openen';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Goede praktijken: Voedingsinformatie';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Soms worden voedingswaarden **niet op de verpakking** of op een document dat bij het product wordt geleverd, vermeld. In dit geval, en alleen in dit geval, kunt u deze waarde op **NEE** zetten.';

  @override
  String get nutrition_page_serving_type_label => 'Voedingswaarden:';

  @override
  String get nutrition_page_per_100g => 'per 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100g/ml';

  @override
  String get nutrition_page_per_serving => 'per portie';

  @override
  String get nutrition_page_add_nutrient => 'Voeg voedingsstof toe';

  @override
  String get nutrition_page_serving_size => 'Grootte van een portie';

  @override
  String get nutrition_page_serving_size_hint =>
      'Voer een portiegrootte in (bijv. 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Goede praktijken: Portiegrootte';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Deze waarde helpt bij het **maken van een proportionele berekening van elke voedingsstof per portiegrootte**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Toegestane eenheden** zijn: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60 g** of **60 G** (geef de voorkeur aan de eerste)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** of **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Ongeldige eenheid';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Ongeldige eenheden';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **snoepjes** en 2 **koekjes**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Ontbrekende eenheid';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Ongeldig nummer';

  @override
  String get nutrition_page_update_running =>
      'Het product bijwerken op de server…';

  @override
  String get nutrition_page_update_done => 'Product bijgewerkt!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Gebruik de producthoeveelheid als portiegrootte';

  @override
  String get nutrition_page_photo_error => 'Kan de foto niet laden';

  @override
  String get more_photos => 'Meer interessante foto\'s';

  @override
  String get view_more_photo_button =>
      'Bekijk alle bestaande foto\'s voor dit product';

  @override
  String get no_product_found => 'Geen product gevonden';

  @override
  String get no_location_found => 'Geen locatie gevonden';

  @override
  String get not_found => 'niet gevonden:';

  @override
  String get refreshing_product => 'Herladen product';

  @override
  String get product_refreshed => 'Product herladen';

  @override
  String product_image_accessibility_label(String date) {
    return 'Foto gemaakt op $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Afbeelding gemaakt op $date. Deze afbeelding is mogelijk verouderd';
  }

  @override
  String get product_image_outdated => 'Deze afbeelding is mogelijk verouderd';

  @override
  String get product_image_outdated_explanations_title =>
      'Deze afbeelding is mogelijk verouderd';

  @override
  String get product_image_outdated_explanations_content =>
      'Deze afbeelding is meer dan een jaar geleden gemaakt.\n**Controleer of deze nog up-to-date is**.\n\nDit is **gewoon een waarschuwing**. Als de inhoud nog steeds hetzelfde is, kunt u dit bericht negeren.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Foto vervangen ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Voeg een foto toe ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Maak een nieuwe foto';

  @override
  String get product_image_action_take_picture => 'Neem een foto';

  @override
  String get product_image_action_from_gallery =>
      'Selecteer uit de galerij van uw telefoon';

  @override
  String get product_image_action_choose_existing_photo =>
      'Selecteer uit de productfoto\'s';

  @override
  String get product_image_details_label => 'Informatie over de foto';

  @override
  String get product_image_details_from_producer => 'Van de producent';

  @override
  String get product_image_details_contributor => 'Bijdrager';

  @override
  String get product_image_details_contributor_producer =>
      'Bijdrager (producent)';

  @override
  String get product_image_details_date => 'Datum';

  @override
  String get product_image_details_date_unknown => 'Onbekend';

  @override
  String get homepage_main_card_logo_description =>
      'Welkom bij Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scan** een streepjescode of\n**zoek** naar een product';

  @override
  String get homepage_main_card_search_field_hint => 'Zoek naar een product';

  @override
  String get homepage_main_card_search_field_tooltip => 'Begin met zoeken';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Laatste nieuws: $news_title';
  }

  @override
  String get tagline_app_review => 'Vind je de app leuk?';

  @override
  String get tagline_app_review_button_positive => 'Ik vind het geweldig! 😍';

  @override
  String get tagline_app_review_button_negative => 'Niet echt…';

  @override
  String get tagline_app_review_button_later => 'Vraag het me later nog eens';

  @override
  String get tagline_feed_news_button => 'Meer weten';

  @override
  String get app_review_negative_modal_title => 'Vind je onze app niet leuk?';

  @override
  String get app_review_negative_modal_text =>
      'Kunt u een paar seconden de tijd nemen om ons te vertellen waarom?';

  @override
  String get app_review_negative_modal_positive_button => 'Ja, absoluut!';

  @override
  String get app_review_negative_modal_negative_button => 'Nee';

  @override
  String get could_not_refresh => 'Kan product niet herladen';

  @override
  String get product_internet_error_modal_title => 'Er is een fout opgetreden!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'We kunnen geen informatie over dit product ophalen vanwege een netwerkfout. Controleer uw internetverbinding en probeer het opnieuw.\n\nInterne fout:\n$error';
  }

  @override
  String get product_tags_title => 'Producteigenschappen';

  @override
  String get no_product_tags_found_message =>
      'Geen producteigenschappen gevonden. Eigenschappen kunnen worden gebruikt om producten op een flexibele manier gedetailleerder te beschrijven.';

  @override
  String get product_tags_empty => 'Geen eigenschappen';

  @override
  String get product_tags_explanation =>
      'Door eigenschappen (sleutel/waarde) aan een product toe te voegen, draagt u bij aan de verrijking ervan.';

  @override
  String get add_tag => 'Voeg een eigenschap toe';

  @override
  String get add_tags => 'Eigenschappen toevoegen';

  @override
  String get add_edit_tags => 'Eigenschappen toevoegen of bewerken';

  @override
  String get edit_tag => 'Eigenschap bewerken';

  @override
  String get remove_tag => 'Eigenschap verwijderen';

  @override
  String get tag_key => 'Eigenschap';

  @override
  String get tag_keys => 'Eigenschappen';

  @override
  String get tag_key_uneditable => 'Eigenschap (niet te bewerken)';

  @override
  String get tag_key_input_hint => 'Voer een eigenschap in';

  @override
  String get tag_value => 'Waarde';

  @override
  String get tag_values => 'Waarden';

  @override
  String get tag_value_input_hint => 'Voer een waarde in';

  @override
  String get tag_key_item => 'Eigenschap:';

  @override
  String get tag_value_item => 'Waarde:';

  @override
  String get tag_key_explanations =>
      'Een sleutel moet uit kleine letters bestaan en mag geen spaties bevatten.';

  @override
  String tag_key_already_exists(String property) {
    return 'Er bestaat al een tag met de eigenschap $property!';
  }

  @override
  String get product_internet_error =>
      'Onmogelijk om informatie over dit product op te halen vanwege een netwerkfout.';

  @override
  String get cached_results_from => 'Resultaten weergeven van:';

  @override
  String get product_search_same_category => 'Vind alternatieven';

  @override
  String get product_search_same_category_short => 'Vergelijk';

  @override
  String get product_search_same_category_error =>
      'Deze functie kan alleen worden gebruikt voor producten met een categorie.\n\nBewerk het product om een categorie toe te voegen.';

  @override
  String get product_improvement_add_category =>
      'Voeg een categorie toe om de Nutri-Score te berekenen.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Voeg voedingswaarden toe om de Nutri-Score te berekenen.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Voeg voedingswaarden en een categorie toe om de Nutri-Score te berekenen.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'De Nutri-Score voor dit product kan niet worden berekend, wat bijvoorbeeld te wijten kan zijn aan een niet-standaard categorie. Als dit als een fout wordt beschouwd, neem dan contact met ons op.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'De voedingsafbeelding is verouderd: ververs deze alstublieft.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'De Green Score houdt rekening met de herkomst van de ingrediënten. Maak een foto van de ingrediëntenlijst en/of een geografische claim of bewerk het product, zodat er rekening mee kan worden gehouden.';

  @override
  String get country_chooser_label => 'Kies een land a.u.b';

  @override
  String get currency_chooser_label => 'Kies een valuta';

  @override
  String get country_change_message => 'Je bent zojuist van land veranderd.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Wilt u de valuta wijzigen van $previousCurrency naar $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Kies een land:';

  @override
  String get country_chooser_label_from_settings => 'Uw land';

  @override
  String get country_selection_explanation =>
      'Sommige milieukenmerken zijn locatie-specifiek';

  @override
  String get product_removed_comparison =>
      'Product verwijderd uit vergelijking';

  @override
  String get native_app_settings => 'Instellingen voor native applicaties';

  @override
  String get native_app_description =>
      'Open systeeminstellingen voor Open Food Facts';

  @override
  String get product_removed_history => 'Product verwijderd uit geschiedenis';

  @override
  String get product_removed_list => 'Product verwijderd uit de lijst';

  @override
  String get product_could_not_remove => 'Kon product niet verwijderen';

  @override
  String get no_prodcut_in_list => 'Er is geen product in deze lijst';

  @override
  String get no_product_in_section => 'Er is geen product in deze sectie';

  @override
  String get recently_seen_products => 'Alle bekeken producten';

  @override
  String get clear => 'Wissen';

  @override
  String get clear_long => 'Maak de lijst leeg';

  @override
  String get really_clear => 'Wilt u deze lijst echt wissen?';

  @override
  String pct_match(Object percent) {
    return '$percent% overeenkomst';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dagen geleden',
      one: 'een dag geleden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count uren geleden',
      one: 'een uur geleden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count minuten geleden',
      one: 'een minuut geleden',
      zero: 'minder dan een minuut geleden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count maanden geleden',
      one: 'een maand geleden',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count weken geleden',
      one: 'een week geleden',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Vergelijk $count producten',
      one: 'Vergelijk één product',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count geselecteerde producten',
      one: 'Eén geselecteerd product',
      zero: 'Geen geselecteerd product',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Vergelijk geselecteerde producten';

  @override
  String get delete_products_mode => 'Geselecteerde producten verwijderen';

  @override
  String get select_all_products_mode => 'Selecteer alle producten';

  @override
  String get select_none_products_mode => 'Niets selecteren';

  @override
  String get compare_products_appbar_title => 'Vergelijk Producten';

  @override
  String get compare_products_appbar_subtitle =>
      'Selecteer minimaal twee producten';

  @override
  String get retry_button_label => 'Opnieuw proberen';

  @override
  String get connect_with_us => 'Contacteer ons';

  @override
  String get tiktok => 'Volg ons op TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Volg ons op Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Volg ons op X (voorheen Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Volg ons op Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Volg ons op BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Veelgestelde vragen (FAQ)';

  @override
  String get discover => 'Ontdek';

  @override
  String get how_to_contribute => 'Hoe kan u bijdragen?';

  @override
  String get hint_knowledge_panel_message =>
      'U kunt op elk deel van de kaart tikken om meer details te krijgen over wat u ziet. Probeer het nu!';

  @override
  String get permissions_page_title => 'Cameratoegang';

  @override
  String get permissions_page_body1 =>
      'Om barcodes te scannen met de camera van uw telefoon, moet u toestemming verlenen.';

  @override
  String get permissions_page_body2 =>
      'Als u van gedachten verandert, kan deze optie op elk moment in de instellingen worden in- en uitgeschakeld.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Besturingssysteem: Android (SDK Int: $sdkInt / Release: $release)\nModel: $model\nProduct: $product\nApparaat: $device\nMerk:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Besturingssysteem: iOS ($version)\nModel: $model\nGelokaliseerd model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nApp versie:$appVersion\nApp build nummer:$appBuildNumber\nApp package naam:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Goedkeuren';

  @override
  String get refuse_button_label => 'Weigeren';

  @override
  String get ask_me_later_button_label => 'Later';

  @override
  String get are_you_sure => 'Weet je het zeker?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Ga verder op $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Welkom !';

  @override
  String get onboarding_home_welcome_text2 =>
      'De app die je helpt bij het kiezen van voedsel dat goed is voor **jou** en de **planeet**!';

  @override
  String get onboarding_continue_button => 'Doorgaan';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Uw eerste voorbeeldproduct wordt geladen';

  @override
  String get onboarding_welcome_warning =>
      'Sorry, dit is ons voorbeeldproduct, u kunt het niet bewerken :)';

  @override
  String get product_list_your_ranking => 'Jouw ranking';

  @override
  String get product_list_empty_icon_desc => 'Geschiedenis niet beschikbaar';

  @override
  String get product_list_empty_title => 'Begin met scannen';

  @override
  String get product_list_empty_message =>
      'Gescande producten verschijnen hier en u kunt gedetailleerde informatie over hen bekijken';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'producten',
      one: 'product',
      zero: 'product',
    );
    return 'Verversen van $_temp0 in jouw geschiedens';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Producten',
      one: 'Product',
      zero: 'Product',
    );
    return '$_temp0 vernieuwing voltooid';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Gegevens worden gedownload...';

  @override
  String get loading_dialog_default_error_message =>
      'Kan gegevens niet downloaden';

  @override
  String get account_delete => 'Account verwijderen';

  @override
  String get account_delete_title => 'Verwijder mijn account';

  @override
  String get user_profile => 'Account';

  @override
  String get user_profile_title_guest => 'Welkom!';

  @override
  String get user_profile_subtitle_guest =>
      'Log in of meld je aan om lid te worden van de Open Food Facts gemeenschap';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts login: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Welkom $id!';
  }

  @override
  String get email_subject_account_deletion => 'Account verwijderen';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hallo, verwijder mijn Open Food Facts-account: $userId';
  }

  @override
  String get settings_app_app => 'Applicatie';

  @override
  String get settings_app_data => 'Functies en crashbewaking';

  @override
  String get settings_app_camera => 'Camera';

  @override
  String get settings_app_products => 'Producten';

  @override
  String get settings_app_miscellaneous => 'Diversen';

  @override
  String get camera_play_sound_title => 'Een geluid afspelen bij scannen';

  @override
  String get camera_play_sound_subtitle => 'Piept bij elke geslaagde scan';

  @override
  String get camera_window_accessibility_label =>
      'Scan een streepjescode met uw camera';

  @override
  String get app_haptic_feedback_title => 'Trillen & haptieken';

  @override
  String get app_haptic_feedback_subtitle =>
      'Trillen na het uitvoeren van sommige acties (barcode gedecodeerd, product verwijderd…).';

  @override
  String get crash_reporting_toggle_title => 'Meld ons fouten en crashes';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Indien ingeschakeld, worden crashrapporten automatisch verzonden naar het foutenopvolgsysteem van Open Food Facts, zodat bugs kunnen worden verholpen en zo de app kan worden verbeterd.';

  @override
  String get send_anonymous_data_toggle_title =>
      'Rapporteer ons over het gebruik van functies';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Wanneer ingeschakeld, wordt strikt anonieme informatie over het gebruik van functies naar de Open Food Facts-servers verzonden, zodat we kunnen begrijpen hoe functies worden gebruikt om ze te verbeteren. Anders wordt een 0-id verzonden.';

  @override
  String get product_edit_photo_title => 'Foto bewerken';

  @override
  String get permission_photo_error => 'Foutmelding';

  @override
  String get permission_photo_denied_title =>
      'Sta het gebruik van de camera toe om streepjescodes te scannen';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Geef $appName toegang tot uw camera voor een verbeterde ervaring. U kunt streepjescodes rechtstreeks scannen.';
  }

  @override
  String get permission_photo_denied_button => 'Toestaan';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Toestemming geweigerd';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Omdat je eerder de cameratoestemming hebt geweigerd, moet je deze handmatig toestaan via de Instellingen.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Open instellingen';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Annuleer';

  @override
  String get permission_photo_none_found => 'Geen camera gedetecteerd';

  @override
  String get permission_photo_denied => 'Geen cameratoegang verleend';

  @override
  String get show_product_pictures => 'Toon productafbeeldingen';

  @override
  String get edit_product_label => 'Bewerk product';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Bewerkingen uploaden…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Uw bewerkingen worden **op de achtergrond verzonden** (of later in geval van een fout).\nU kunt doorgaan met het bewerken van andere productvelden.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Uw bewerkingen worden **op de achtergrond** verzonden (of later in geval van een fout).';

  @override
  String get edit_product_label_short => 'Bewerken';

  @override
  String edit_product_form_item_help(String value) {
    return 'Hoe voer ik \"$value\" in?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Voer een niet-lege waarde in!';

  @override
  String get edit_product_form_item_error_existing => 'Deze waarde is er al!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Voeg een nieuw merk toe';

  @override
  String get edit_product_form_item_add_action_label =>
      'Voeg een nieuw label toe';

  @override
  String get edit_product_form_item_add_action_store =>
      'Voeg een nieuwe winkel toe';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Voeg een nieuwe oorsprong toe';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Voeg een nieuwe traceerbaarheidscode toe';

  @override
  String get edit_product_form_item_add_action_country =>
      'Voeg een nieuw land toe';

  @override
  String get edit_product_form_item_add_action_category =>
      'Voeg een nieuwe categorie toe';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Een nieuw spoor toevoegen';

  @override
  String get edit_product_form_item_add_suggestion => 'Suggestie toevoegen';

  @override
  String get edit_product_form_item_deny_suggestion => 'Suggestie weigeren';

  @override
  String get edit_product_form_item_details_title => 'Basisdetails';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Productnaam, merk, hoeveelheid';

  @override
  String get edit_product_form_item_other_details_title =>
      'Aanvullende details';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Website…';

  @override
  String get edit_product_form_item_photos_title => 'Foto\'s';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Foto\'s toevoegen of vernieuwen';

  @override
  String get edit_product_form_item_labels_title => 'Labels en certificeringen';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Milieu, Kwaliteitslabels…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Voer een label in (bijv.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'keurmerk';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Goede praktijken: Etiketten';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Elk kenmerk van het product **dat feitelijk is** en verschilt van de andere velden.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Gemaakt in België, geproduceerd in Bretagne…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rijk aan vezels, bron van ijzer…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Winkels';

  @override
  String get edit_product_form_item_stores_hint => 'Voer een winkel in';

  @override
  String get edit_product_form_item_stores_type => 'winkel';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Goede praktijken: Winkels';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Voer de winkel in waar u het product hebt gekocht.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Oorsprong';

  @override
  String get edit_product_form_item_origins_hint =>
      'Voer een herkomst in (bijv. Duitsland)';

  @override
  String get edit_product_form_item_origins_type => 'land';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Goede praktijken: Oorsprong';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Voeg **alle herkomstaanduidingen die u op de verpakking kunt vinden** toe.\nU hoeft zich geen zorgen te maken over de herkomst die rechtstreeks in de ingrediëntenlijst staat vermeld.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Rundvlees uit Argentinië';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'De soja komt niet uit de Europese Unie';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Voer een land in (bijv. Duitsland)';

  @override
  String get edit_product_form_item_countries_type => 'land';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Goede praktijken: Landen';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Landen waar het product algemeen verkrijgbaar is** (met uitzondering van winkels die gespecialiseerd zijn in buitenlandse producten).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Traceerbaarheidscodes';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Voer een code in (bijv.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'traceerbaarheidscode';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Goede praktijken: Traceerbaarheidscodes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In dit gedeelte kunt u codes invoeren die betrekking hebben op **verpakkingsmerken**, **identificatiemerken** of **gezondheidsmerken**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Voorbeelden van traceerbaarheidscodes';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EG-codes** die in de Europese Gemeenschap worden gebruikt om voedselproducenten of -verpakkers te identificeren:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: landcode van **Frankrijk**\n**72.264.002**: geografische gegevens\n**CE**: Europese Gemeenschap';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB-codes** gebruikt in Frankrijk:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Sporen';

  @override
  String get edit_product_form_item_traces_hint => 'spoor';

  @override
  String get edit_product_form_item_traces_type =>
      'Voer een spoor in (bijv. sojabonen)';

  @override
  String get edit_product_form_item_categories_title => 'Categorieën';

  @override
  String get edit_product_form_item_categories_hint => 'categorie';

  @override
  String get edit_product_form_item_categories_type =>
      'Voer een categorie in (bijv.: Sinaasappelsap)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Goede praktijken: Categorieën';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Geef **alleen de meest specifieke categorie** aan.\nBovenliggende categorieën worden automatisch toegevoegd.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Ontbrekende categorie?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Mocht een categorie **niet beschikbaar zijn in automatisch aanvullen**, dan kunt u deze gerust toch toevoegen.\nHiermee helpt u ons Open Food Facts in uw land te verbeteren.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardientjes in olijfolie';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Sinaasappelsap uit concentraat';

  @override
  String get edit_product_form_item_exit_title => 'Afsluiten zonder opslaan?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Wilt u de wijzigingen opslaan voor het verlaten van deze pagina?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Wijzigingen opslaan';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Wijzigingen negeren';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingrediënten';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zoom in en uit door het beeldscherm samen te knijpen';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zoom in en uit op de foto';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Met het **knijp-om-te-zoomen-gebaar** kun je in- of uitzoomen op de foto:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Toevoegen';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Voer eerst een tekst in alsjeblieft';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Verwijderen';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Bewaar uw bewerking';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Annuleer uw bewerking';

  @override
  String get edit_product_form_item_packaging_title =>
      'Recycling instructies foto';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Voedingswaarden';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Voeding, alcoholgehalte…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Goede praktijken: Voedingswaarden';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Voedingswaarden';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Selecteer eerst of de **waarden zijn opgegeven**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Voedingswaarden';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Voer vervolgens de voedingswaarden in **zoals aangegeven op de verpakking**. Als er geen waarde is, kunt u op het \"Oog\"-icoontje klikken.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Ontbrekend veld?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Als er een item ontbreekt, kunt u **op het \"Plus\"-icoontje** klikken om het toe te voegen (bijv.: vitamine D, magnesium…).';

  @override
  String get edit_product_form_save => 'Bewerken';

  @override
  String get edit_product_ingredients_photo_title => 'Ingrediënten foto';

  @override
  String get edit_product_ingredients_list_title => 'Lijst van ingrediënten';

  @override
  String get edit_product_packaging_photo_title => 'Verpakkingsfoto';

  @override
  String get edit_product_packaging_list_title => 'Verpakkingslijst';

  @override
  String get no_data_available => 'Geen gegevens beschikbaar';

  @override
  String get product_field_website_title => 'Website';

  @override
  String get origins_editing_title => 'Oorsprong bewerken';

  @override
  String get completed_basic_details_btn_text => 'Basisdetails aanvullen';

  @override
  String get not_implemented_snackbar_text => 'Nog niet geïmplementeerd';

  @override
  String get category_picker_page_appbar_text => 'Categorieën';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Detecteer de ingrediënten op de foto';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Ingrediënten extraheren';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Detecteer de ingrediënten\nop de foto';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Foto laden…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Waarom zie ik dit bericht?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Om de functie \'Ingrediënten extraheren\' te gebruiken, moet de foto eerst worden geüpload.\n\nWacht een paar seconden of voer de ingrediënten handmatig in.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Foto vernieuwen';

  @override
  String get edit_packaging_extract_btn_text =>
      'Detecteer de verpakking\nop de foto';

  @override
  String get edit_packaging_extract_btn_text_short =>
      'Verpakkingsinformatie extraheren';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Detecteer de verpakking op de foto';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Foto laden…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Waarom zie ik dit bericht?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Om de functie \"Verpakkingsgegevens extraheren\" te gebruiken, moet de foto eerst worden geüpload.\n\nWacht alstublieft een paar seconden of voer de verpakkingsgegevens handmatig in.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Foto vernieuwen';

  @override
  String get edit_ocr_extract_failed =>
      'Detecteren van tekst in afbeelding mislukt.';

  @override
  String get edit_ocr_extract_disabled_title => 'Geen afbeelding!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Om de tekstextractiefunctie te kunnen gebruiken, moet u eerst een foto maken.';

  @override
  String get user_list_dialog_new_title => 'Nieuwe lijst van producten';

  @override
  String get user_list_dialog_rename_title => 'Lijst hernoemen';

  @override
  String get user_list_subtitle_product => 'Lijsten';

  @override
  String get user_list_title => 'Jouw lijsten';

  @override
  String get user_list_add_product => 'Voeg het product toe aan je lijsten';

  @override
  String get user_list_button_new => 'Een nieuwe lijst maken';

  @override
  String get user_list_empty_label =>
      'Er is nog geen lijst beschikbaar!\nBegin met het maken van een lijst.';

  @override
  String get user_list_button_add_product => 'Toevoegen aan lijst';

  @override
  String get added_to_list_msg => 'Toegevoegd aan lijst';

  @override
  String get user_list_popup_clear => 'Wis je geschiedenis';

  @override
  String get user_list_popup_rename => 'Hernoem';

  @override
  String get user_list_name_hint => 'Mijn lijst';

  @override
  String get user_list_name_error_empty => 'Naam is verplicht!';

  @override
  String get user_list_name_error_already => 'Deze naam is al in gebruik!';

  @override
  String get user_list_name_error_same => 'Dat is dezelfde naam';

  @override
  String get user_list_name_input_hint => 'Naam van de lijst';

  @override
  String get try_again => 'Probeer opnieuw';

  @override
  String get there_was_an_error => 'Er is een fout opgetreden!';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Geen categorie gevonden voor $items';
  }

  @override
  String get camera_toggle_camera =>
      'Schakel tussen de camera aan de achterkant en de voorkant';

  @override
  String get camera_toggle_flash => 'Zet de flitser van de camera AAN of UIT';

  @override
  String get camera_enable_flash => 'Schakel flitser in';

  @override
  String get camera_disable_flash => 'Flitser uitschakelen';

  @override
  String get camera_flash_error_dialog_title => 'Er is een fout opgetreden!';

  @override
  String get camera_flash_error_dialog_message =>
      'Er is een fout opgetreden bij het wijzigen van de status van uw flitser. Zorg ervoor dat op uw smartphone de zaklamp nog niet is ingeschakeld.';

  @override
  String get category_picker_no_category_found_button => 'Terug';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Klik om te openen in uw browser of in de applicatie (indien geïnstalleerd)';

  @override
  String get dev_preferences_screen_title => 'DEV-modus';

  @override
  String get dev_preferences_screen_subtitle =>
      'Toegang tot experimentele functies en ontwikkeltools';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Onboarding opnieuw starten';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Vervolgens moet u de app opnieuw opstarten om deze weer te zien.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Schakel tussen openfoodfacts.org (PROD) en test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Testomgevingsparameters';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Basis-URL voor huidige testomgeving: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Testomgeving host';

  @override
  String get dev_preferences_ml_kit_title => 'Gebruik ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'dan moet je deze app opnieuw opstarten';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Extra knop op de productpagina';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Bewerk ingrediënten via een kennispaneelknop';

  @override
  String get dev_preferences_export_history_title => 'Geschiedenis exporteren';

  @override
  String get dev_preferences_export_history_progress_error => 'Uitzondering';

  @override
  String get dev_preferences_export_history_progress_found =>
      'product gevonden';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'product NIET gevonden';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Geschiedenis exporteren';

  @override
  String get dev_preferences_button_positive => 'Ok';

  @override
  String get dev_preferences_button_negative => 'Annuleer';

  @override
  String get dev_preferences_migration_title => 'Gegevensmigratie van V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Status: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'succes of nieuwe installatie';

  @override
  String get dev_preferences_migration_status_success => 'geslaagd';

  @override
  String get dev_preferences_migration_status_error => 'fout';

  @override
  String get dev_preferences_migration_status_in_progress => 'in behandeling';

  @override
  String get dev_preferences_migration_status_required =>
      'vereist (klik om te beginnen)';

  @override
  String get dev_preferences_migration_status_not_started => 'onbekend';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Zal de geschiedenis wissen en er 3 producten in plaatsen';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Aangepaste URL voor nieuws';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL van het JSON-bestand:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Niet ingesteld';

  @override
  String get dev_preferences_news_provider_status_title => 'Status';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Laatste vernieuwing: $date';
  }

  @override
  String get product_type_label_food => 'Voedsel';

  @override
  String get product_type_label_beauty => 'Persoonlijke verzorging';

  @override
  String get product_type_label_pet_food => 'Dierenvoeding';

  @override
  String get product_type_label_product => 'Andere';

  @override
  String get product_type_selection_title => 'Producttype';

  @override
  String get product_type_selection_subtitle =>
      'Selecteer het type van dit product';

  @override
  String get product_type_selection_empty =>
      'U moet eerst een producttype selecteren!';

  @override
  String product_type_selection_already(String productType) {
    return 'U kunt het producttype niet wijzigen ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Snelkoppeling naar de Prijzen-app op de productpagina';

  @override
  String get prices_app_button => 'Ga naar de Prijzen-app';

  @override
  String get prices_website_button => 'Open op de website van Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Voeg prijskaartjes rechtstreeks vanuit de galerij toe';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Nadat u afbeeldingen hebt geselecteerd, kunt u deze niet meer bewerken!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI zal uw bewijzen gebruiken om prijzen te berekenen.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Geef de community de mogelijkheid om prijzen te valideren die door AI zijn verkregen.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Meerdere prijskaartjes';

  @override
  String get prices_bulk_proof_upload_title => 'Bulkbewijs uploaden';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Bestanden selecteren';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Het uploaden starten';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokaal kopiëren van bestand #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Upload voorbereiden #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Mislukt bij afbeelding #$index/$count';
  }

  @override
  String get prices_generic_title => 'Prijzen';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Voeg $count prijzen toe',
      one: 'Voeg een prijs toe',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Verstuur $count prijzen',
      one: 'Verstuur 1 prijs',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Item toevoegen';

  @override
  String get prices_add_a_price => 'Voeg een prijs toe';

  @override
  String get prices_add_a_receipt => 'Een ontvangstbewijs toevoegen';

  @override
  String get prices_add_price_tags => 'Voeg prijskaartjes toe';

  @override
  String prices_barcode_already(String barcode) {
    return 'Deze streepjescode ($barcode) staat al in de lijst!';
  }

  @override
  String get prices_barcode_search_not_found => 'Product niet gevonden';

  @override
  String get prices_barcode_search_none_yet => 'Nog geen product';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Zoeken naar $barcode';
  }

  @override
  String get prices_barcode_enter => 'Voer de streepjescode in';

  @override
  String get prices_category_enter => 'Artikel zonder streepjescode';

  @override
  String get prices_per_kilogram => 'Prijs per kilogram';

  @override
  String get prices_per_unit => 'Prijs per eenheid';

  @override
  String get prices_per_kilogram_short => ' /kg';

  @override
  String get prices_per_unit_short => ' /eenheid';

  @override
  String get prices_category_mandatory => 'Verplicht';

  @override
  String get prices_category_optional => 'Optioneel';

  @override
  String get prices_category_error_mandatory => 'De categorie is verplicht';

  @override
  String get prices_barcode_reader_action => 'Streepjescodelezer';

  @override
  String get prices_view_prices => 'Bekijk de prijzen';

  @override
  String get prices_list_title => 'Prijslijst';

  @override
  String get prices_list_count => 'Aantal\nprijzen';

  @override
  String get prices_list_add_new_price => 'Voeg een\nnieuwe prijs toe';

  @override
  String get prices_list_empty_title => 'Nog geen prijs!';

  @override
  String get prices_list_empty_subtitle =>
      'Wees de eerste om er een toe te voegen:\nDoor een **bon** of een **prijskaartje** te scannen!';

  @override
  String get prices_entry_shop_not_found => 'Onbekende winkel';

  @override
  String prices_entry_menu_title(String user) {
    return 'Prijsinvoer van \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Bekijk alle prijzen voor dit product';

  @override
  String get prices_entry_menu_open_proof => 'Bekijk het bewijs';

  @override
  String get prices_entry_menu_my_prices => 'Bekijk mijn andere prijzen';

  @override
  String get prices_entry_menu_author_prices =>
      'Bekijk andere prijzen van de auteur';

  @override
  String get prices_entry_menu_shop_prices =>
      'Bekijk andere prijzen van de winkel';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prijzen',
      one: '1 prijs',
    );
    return '$_temp0 voor $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count prijzen',
      one: 'Slechts één prijs',
      zero: 'Nog geen prijs',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Laatste $pageSize prijzen (totaal: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Prijs: $price / Winkel: \"$location\" / Gepubliceerd op $date door \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Bewijzen openen van \"$user\"';
  }

  @override
  String get prices_open_proof => 'Prijsbewijs openen';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Alle $count bewijzen',
      one: 'Slechts één bewijs',
      zero: 'Nog geen bewijs',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Laatste $pageSize bewijzen (totaal: $total)';
  }

  @override
  String get prices_users_empty_title => 'No contributor yet!';

  @override
  String get prices_users_empty_explanation =>
      'Wees de eerste om een prijs toe te voegen!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize bijdragers (totaal: $total)';
  }

  @override
  String get prices_locations_empty_title => 'No shop yet!';

  @override
  String get prices_locations_empty_explanation =>
      'Wees de eerste om een prijs toe te voegen!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize locaties (totaal: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count bewijzen',
      one: 'Eén bewijs',
      zero: 'Geen bewijs',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count producten',
      one: 'Eén product',
      zero: 'Geen product',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count gebruikers',
      one: 'Eén gebruiker',
      zero: 'Geen gebruiker',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prijzen',
      one: 'Eén prijs',
      zero: 'Geen prijs',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Prijs eerder toegevoegd';

  @override
  String get prices_amount_subtitle => 'Hoeveelheid';

  @override
  String get prices_amount_is_discounted => 'Wordt er korting gegeven?';

  @override
  String get prices_amount_price_normal => 'Prijs';

  @override
  String get prices_amount_price_discounted => 'Gereduceerde prijs';

  @override
  String get prices_amount_price_not_discounted => 'Oorspronkelijke prijs';

  @override
  String get prices_amount_no_product => 'Er ontbreekt één product!';

  @override
  String get prices_amount_price_incorrect => 'Onjuiste waarde';

  @override
  String get prices_amount_price_mandatory => 'Verplichte waarde';

  @override
  String get prices_currency_subtitle => 'Valuta';

  @override
  String get prices_date_subtitle => 'Datum';

  @override
  String get prices_location_subtitle => 'Winkel';

  @override
  String get prices_location_find => 'Zoek een winkel';

  @override
  String get prices_location_mandatory => 'Je moet een winkel selecteren!';

  @override
  String get prices_location_search_broader =>
      'Niet gevonden wat u zocht? Probeer een bredere zoekopdracht!';

  @override
  String get prices_proof_subtitle => 'Bewijs';

  @override
  String get prices_proof_empty_title => 'Nog geen bewijs!';

  @override
  String get prices_proof_empty_explanation =>
      'Begin met het toevoegen van een foto van een **bon** of een **prijskaartje**!';

  @override
  String get prices_proof_find => 'Selecteer een bewijs';

  @override
  String get prices_proof_change => 'Wijzig bewijs';

  @override
  String get prices_proof_receipt => 'Bon';

  @override
  String get prices_proof_price_tag => 'Prijskaartje';

  @override
  String get prices_proof_mandatory => 'Je moet een bewijs selecteren!';

  @override
  String get prices_add_validation_error => 'Validatiefout';

  @override
  String get prices_privacy_warning_title => 'Privacywaarschuwing';

  @override
  String get prices_unknown_product => 'Onbekend product';

  @override
  String get prices_privacy_warning_main_message =>
      'Prijzen **zullen openbaar zijn**, samen met de winkel waarnaar ze verwijzen.\n\nHierdoor kunnen mensen die op de hoogte zijn van uw Open Food Facts-pseudoniem:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Bepaal in welk gebied u woont';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Weet wat je koopt';

  @override
  String get prices_privacy_warning_sub_message =>
      'Als u zich hier niet prettig bij voelt, kunt u uw pseudoniem wijzigen of een nieuw Open Food Facts-account aanmaken en daarmee inloggen op de app.';

  @override
  String get i_refuse => 'Ik weiger';

  @override
  String get i_accept => 'Ik ga akkoord';

  @override
  String get prices_currency_change_proposal_title => 'De valuta wijzigen?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Uw huidige valuta is **$currency**. Wilt u dit wijzigen naar **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ja, gebruik $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Nee, behoud $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Voltooid';

  @override
  String get dev_mode_section_server => 'Serverconfiguratie';

  @override
  String get dev_mode_section_news => 'Configuratie van nieuwsprovider';

  @override
  String get dev_mode_section_product_page => 'Productpagina';

  @override
  String get dev_mode_section_ui => 'Gebruikersinterface';

  @override
  String get dev_mode_section_experimental_features => 'Experimentele functies';

  @override
  String get dev_mode_hide_environmental_score_title => 'Greenscore uitsluiten';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Gebruik een spellingcontrole voor OCR-schermen';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingrediënten en verpakking)';

  @override
  String get dev_mode_reset_app_language_title => 'App-taal resetten';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Kaarten toevoegen';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Schakel tussen prices.openfoodfacts.org (PROD) en testomgeving';

  @override
  String get search_history_item_edit_tooltip =>
      'Hergebruik en bewerk deze zoekopdracht';

  @override
  String get search_history_item_remove_tooltip => 'Verwijderen';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Je hebt alle $totalSize producten gedownload.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Download $count meer producten\nReeds gedownload $downloaded van de $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Uw zoekopdracht naar $search is bezig.\n\nWacht een paar seconden…';
  }

  @override
  String get user_search_contributor_title => 'Producten die ik heb toegevoegd';

  @override
  String get user_search_informer_title => 'Producten die ik heb bewerkt';

  @override
  String get user_search_photographer_title =>
      'Producten die ik heb gefotografeerd';

  @override
  String get user_search_to_be_completed_title => 'Mijn te voltooien producten';

  @override
  String get user_search_prices_title => 'Mijn prijzen';

  @override
  String get user_search_proofs_title => 'Mijn bewijzen';

  @override
  String get user_search_proof_title => 'Mijn bewijs';

  @override
  String search_proof_title(String user) {
    return 'Bewijs van \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Prijzen van bijdrager: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Laatste toegevoegde prijzen';

  @override
  String get all_search_prices_top_user_title => 'Beste prijsbijdragers';

  @override
  String get all_search_prices_top_location_title =>
      'Winkels met de meeste prijzen';

  @override
  String get prices_contribution_assistant => 'Prijsbijdrageassistent';

  @override
  String get prices_validation_assistant => 'Prijsvalidatie-assistent';

  @override
  String get prices_challenges_page => 'Uitdagingen';

  @override
  String get prices_multiple_proof_addition_system =>
      'Meerdere bewijzen toevoegen';

  @override
  String get all_search_prices_top_location_single_title =>
      'Prijzen in een winkel';

  @override
  String get all_search_prices_top_product_title =>
      'Producten met de meeste prijzen';

  @override
  String get all_search_to_be_completed_title => 'Alle te voltooien producten';

  @override
  String get categorize_products_country_title =>
      'Help producten in uw land te categoriseren';

  @override
  String get edit_product_action_retake_picture => 'Foto opnieuw maken';

  @override
  String get edit_product_action_take_picture => 'Maak een foto';

  @override
  String get edit_product_action_confirm => 'Bevestig';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Ik ga akkoord met de Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'gebruiksvoorwaarden en bijdrage';

  @override
  String get analytics_consent_image_semantic_label => 'Analytics-pictogram';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Fatale fout: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Fatale fout: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Basisdetails aanvullen';

  @override
  String get edit_photo_button_label => 'Bewerken';

  @override
  String get edit_photo_unselect_button_label => 'Foto deselecteren';

  @override
  String get edit_photo_select_existing_button_label =>
      'Selecteer een bestaande afbeelding';

  @override
  String get edit_photo_select_existing_all_label => 'Bestaande afbeeldingen';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Selecteer een afbeelding door erop te klikken';

  @override
  String get edit_photo_select_existing_download_label =>
      'Bestaande afbeeldingen ophalen…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Er zijn geen eerder geüploade afbeeldingen met betrekking tot dit product.';

  @override
  String get edit_photo_language_not_this_one =>
      'Nog geen afbeelding in die taal';

  @override
  String get edit_photo_language_none => 'Nog geen afbeeldingen';

  @override
  String get category_picker_screen_title => 'Categorieën';

  @override
  String get basic_details => 'Basisgegevens';

  @override
  String get product_name => 'Productnaam';

  @override
  String get product_names => 'Productnamen';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Voeg nieuwe vertaling toe';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Voordat u gaat valideren, zorg ervoor dat u alleen een vertaling toevoegt **als de taal aanwezig is op de verpakking**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Bekijk foto voorzijde';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Neem foto voor voorkant';

  @override
  String get add_basic_details_product_name_hint =>
      'Voer de naam van het product in (bijv. Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'De standaardtaal wijzigen?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Wilt u dat de standaardtaal van het product wordt ingesteld op \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Goede voorbeelden';

  @override
  String get explanation_section_bad_examples => 'Slechte voorbeelden';

  @override
  String get add_basic_details_product_name_help_title =>
      'Goede praktijken: Productnaam';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'De productnaam is de **hoofdnaam die op de verpakking staat**. Het kan een geregistreerd handelsmerk zijn.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Let op:** Voeg alstublieft geen vertaling toe **als de taal niet aanwezig is op de verpakking**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomatenketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Vermeld het merk niet in de naam';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomatenketchup **van Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Gebruik geen symbolen ®, ™, © of iets dergelijks';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count andere vertalingen',
      one: '$count andere vertaling',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Merknaam';

  @override
  String get brand_names => 'Merknaam';

  @override
  String get add_basic_details_brand_name_error => 'Vul a.u.b. de merknaam in';

  @override
  String get add_basic_details_brand_names_hint =>
      'Merken invoeren (bijv.: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Goede praktijken: Merken';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Voer **alle merken van het product** in.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Hoofdmerk';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Het **hoofdmerk**, dat doorgaans duidelijk op de voorkant van de verpakking staat, moet u als eerste invoeren.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Andere merken';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Wanneer verkocht **door een groot bedrijf**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** wordt verkocht door **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Wanneer verkocht met het merk **vertaald in meerdere talen**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** wordt soms als **Val Nature** geschreven';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Hoeveelheid en gewicht';

  @override
  String get add_basic_details_quantity_hint =>
      'Voer het gewicht in en indien nodig de hoeveelheid (bijv.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Goede praktijken: Hoeveelheden';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Neem de waarde over die op het product staat en **vergeet de eenheden niet**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** of **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (voor 6 eieren)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(voor een product met 3 dozen van elk 150g)';

  @override
  String get barcode => 'Streepjescode';

  @override
  String barcode_barcode(String barcode) {
    return 'Streepjescode: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Ongeldige barcode';

  @override
  String get basic_details_add_success => 'Basisgegevens succesvol toegevoegd';

  @override
  String get basic_details_add_error =>
      'Kan basisgegevens niet toevoegen. Probeer het later opnieuw';

  @override
  String get clear_search => 'Wis je zoekopdracht';

  @override
  String get confirm_clear =>
      'Je staat op het punt je hele geschiedenis te wissen: weet je zeker dat je wilt doorgaan?';

  @override
  String get alert_clear_selected_user_list =>
      'U staat op het punt geselecteerde items in uw geschiedenis te wissen';

  @override
  String get confirm_clear_selected_user_list =>
      'Weet je zeker dat je door wilt gaan?';

  @override
  String get alert_select_items_to_clear =>
      'Selecteer een of meer items om te wissen';

  @override
  String confirm_clear_user_list(String name) {
    return 'Je staat op het punt deze lijst ($name) te wissen: weet je zeker dat je wilt doorgaan?';
  }

  @override
  String get confirm_delete_user_list_title => 'De lijst verwijderen?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'U staat op het punt de lijst \"$name\" te verwijderen.\nWeet u zeker dat u wilt doorgaan?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ja, ik bevestig';

  @override
  String importance_label(String name, String id) {
    return '$name belangrijkheid: $id';
  }

  @override
  String get user_list_all_title => 'Lijsten';

  @override
  String get user_list_all_empty => 'Maak je eerste lijst aan';

  @override
  String get product_list_select => 'Selecteer een lijst';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count producten',
      one: 'Eén product',
      zero: 'Lege lijst',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Lijst toevoegen';

  @override
  String get open_food_preferences_tooltip => 'Bewerk je voedselvoorkeuren';

  @override
  String get add_photo_button_label => 'Foto toevoegen';

  @override
  String get add_packaging_photo_button_label =>
      'Maak foto\'s van alle informatie over verpakking/recycling';

  @override
  String get add_origin_photo_button_label =>
      'Maak foto\'s van eventuele herkomstinformatie';

  @override
  String get add_emb_photo_button_label =>
      'Maak foto\'s van eventuele traceerbaarheidscode-informatie';

  @override
  String get add_label_photo_button_label =>
      'Maak foto\'s van alle labels en certificeringsinformatie';

  @override
  String get choose_image_source_title => 'Kies afbeeldingsbron';

  @override
  String get choose_image_source_body => 'Kies een afbeeldingsbron';

  @override
  String get gallery_source_label => 'Gallerij';

  @override
  String get gallery_source_access_denied_dialog_title => 'Toegang geweigerd';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Helaas kan de app geen toegang krijgen tot je galerij, omdat je de toestemming al eerder hebt geweigerd.\n\nGa naar de app instellingen in je telefoon instellingen -> Foto\'s';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Open de instellingen';

  @override
  String get share => 'Delen';

  @override
  String share_product_text(String url) {
    return 'Bekijk dit product op Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Bekijk dit product op Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Bekijk dit product op Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Bekijk dit product op Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Bekijk mijn lijst met producten op Open Food Facts: $url';
  }

  @override
  String get capture => 'Maak een nieuwe foto';

  @override
  String get capture_new_picture => 'Neem een foto';

  @override
  String get choose_from_gallery => 'Kies uit gallerij';

  @override
  String get image_upload_queued =>
      'De afbeelding zal zo snel mogelijk op de achtergrond worden geüpload.';

  @override
  String get add_price_queued =>
      'De prijs wordt zo snel mogelijk naar de server verzonden.';

  @override
  String get background_task_title_full_refresh =>
      'Het vernieuwen starten van alle producten die lokaal zijn opgeslagen';

  @override
  String get background_task_title_top_n =>
      'Het downloaden van de meest populaire producten starten';

  @override
  String get expand_nutrition_facts => 'Tabel met voedingswaarden uitvouwen';

  @override
  String get expand_nutrition_facts_body =>
      'Houd de tabel met voedingswaarden uitgeklapt';

  @override
  String get expand_ingredients => 'Ingrediënten uitklappen';

  @override
  String get expand_ingredients_body =>
      'Houd het ingrediëntenpaneel uitgevouwen';

  @override
  String get no_internet_connection => 'Geen internetverbinding';

  @override
  String get world_results_label => 'Wereldwijd';

  @override
  String get world_results_action => 'Zoek wereldwijd';

  @override
  String get copy_to_clipboard => 'Kopiëren';

  @override
  String get paste_from_clipboard => 'Plakken vanaf klembord';

  @override
  String get no_data_available_in_clipboard =>
      'Er zijn geen gegevens beschikbaar op uw klembord';

  @override
  String get clipboard_barcode_copy => 'Kopieer streepjescode naar klembord';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Streepjescode $barcode gekopieerd naar het klembord!';
  }

  @override
  String get open_product_website => 'Open dit product op de website';

  @override
  String get language_picker_label => 'Uw taal';

  @override
  String get country_picker_label => 'Uw land';

  @override
  String get currency_picker_label => 'Uw valuta';

  @override
  String get help_with_openfoodfacts => 'Help met OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Het product zal zo snel mogelijk op de achtergrond worden bijgewerkt.';

  @override
  String get no_email_client_available_dialog_title => 'Geen e-mail-apps!';

  @override
  String get no_email_client_available_dialog_content =>
      'Stuur ons handmatig een e-mail naar mobile@openfoodfacts.org';

  @override
  String get all_images => 'Alle afbeeldingen';

  @override
  String get selected_images => 'Geselecteerde afbeeldingen';

  @override
  String get product_card_remove_product_tooltip => 'Product verwijderen';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nieuwe barcode gescand: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Verwijder alle producten uit de carrousel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Scan minstens twee producten om ze te vergelijken';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Klik om de door u gescande producten te vergelijken';

  @override
  String get scan_product_loading => 'U heeft\nde barcode gescand:';

  @override
  String get scan_product_loading_initial =>
      'We zijn op zoek naar dit product!\nWacht een paar seconden…';

  @override
  String get scan_product_loading_long_request =>
      'We zijn nog steeds op zoek naar dit product!\nVindt u dat het laden lang duurt? Wij ook…';

  @override
  String get scan_product_loading_unresponsive =>
      'We zijn nog steeds op zoek naar dit product.\nWilt u het zoeken opnieuw starten?';

  @override
  String get scan_product_loading_restart_button => 'Zoek opnieuw';

  @override
  String get portion_calculator_description =>
      'Bereken voedingsfeiten voor een specifieke hoeveelheid';

  @override
  String get portion_calculator_hint => 'Hoeveelheid in';

  @override
  String get portion_calculator_accessibility =>
      'Voer een hoeveelheid in om de voedingswaarden te berekenen';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Vul een hoeveelheid in tussen $min en $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Ontbrekende gegevens. De berekening kon niet worden uitgevoerd.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Voedingswaarden voor $grams g (of ml)';
  }

  @override
  String get offline_data => 'Offline gegevens';

  @override
  String get ocr_image_upload_instruction =>
      'Upload een afbeelding om de verstrekte informatie automatisch te extraheren.';

  @override
  String get upload_image => 'Foto uploaden';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Kan afbeelding niet downloaden';

  @override
  String get image_edit_url_error =>
      'Kan afbeelding niet bewerken omdat de afbeeldings-URL niet is ingesteld.';

  @override
  String get user_picture_source_remember => 'Onthoud mijn keuze';

  @override
  String get user_picture_source_ask => 'Telkens opnieuw vragen';

  @override
  String get robotoff_continue => 'Doorgaan';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vragen',
      one: 'vraag',
    );
    return 'Volgende $_temp0';
  }

  @override
  String get show_password => 'Toon wachtwoord';

  @override
  String get owner_field_info_title => 'Door de producent verstrekte waarden';

  @override
  String get owner_field_info_message =>
      'Met dat logo benadrukken we de gegevens die de producent aanlevert en die mogelijk niet bewerkt kunnen worden.';

  @override
  String get owner_field_info_close_button => 'Sluit deze info';

  @override
  String get owner_field_image =>
      'Deze afbeelding is geleverd door de producent. Het is mogelijk niet bewerkbaar.';

  @override
  String get edit_packagings_title => 'Verpakkingsonderdelen';

  @override
  String get edit_packagings_element_add => 'Voeg een verpakkingsonderdeel toe';

  @override
  String get edit_packagings_completed => 'De verpakking is compleet';

  @override
  String edit_packagings_element_title(int index) {
    return 'Verpakkingscomponent #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Aantal eenheden';

  @override
  String get edit_packagings_element_hint_units =>
      'Voer het aantal verpakkingseenheden van dezelfde vorm en hetzelfde materiaal in het product in.';

  @override
  String get edit_packagings_element_field_shape => 'Vorm';

  @override
  String get edit_packagings_element_hint_shape =>
      'Voer de vormnaam in die wordt vermeld in de recyclinginstructies als deze beschikbaar zijn, of selecteer een vorm.';

  @override
  String get edit_packagings_element_example_shape => 'Fles';

  @override
  String get edit_packagings_element_field_material => 'Materiaal';

  @override
  String get edit_packagings_element_hint_material =>
      'Voer het specifieke materiaal in als dit kan worden bepaald (een materiaalcode in een driehoek is vaak te vinden op verpakkingsonderdelen), of een algemener materiaal (bijvoorbeeld plastic of metaal) als u het niet zeker weet.';

  @override
  String get edit_packagings_element_example_material => 'Glas';

  @override
  String get edit_packagings_element_field_recycling => 'Recycling instructie';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Voer alleen recyclinginstructies in als deze op het product staan vermeld.';

  @override
  String get edit_packagings_element_example_recycling => 'Hergebruik';

  @override
  String get edit_packagings_element_field_quantity =>
      'Netto hoeveelheid product per eenheid';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Vul het nettogewicht of het nettovolume in en geef de eenheid aan (bijvoorbeeld g of ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Gewicht van één lege eenheid (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Verwijder alle resterende levensmiddelen en droog de verpakking af voor het wegen. Gebruik indien mogelijk een schaal met 0,1g of 0,01g precisie.';

  @override
  String get background_task_title => 'In afwachting van bijdragen';

  @override
  String get background_task_subtitle =>
      'Uw bijdragen worden automatisch opgeslagen op onze server, maar niet altijd in realtime.';

  @override
  String get background_task_list_empty => 'Geen lopende achtergrondtaken';

  @override
  String get background_task_error_server_time_out => 'Server time-out';

  @override
  String get background_task_error_no_internet =>
      'Fout met internetverbinding. Probeer het later.';

  @override
  String get background_task_operation_unknown => 'onbekend bewerkingstype';

  @override
  String get background_task_operation_details => 'gedetailleerde wijzigingen';

  @override
  String get background_task_operation_image => 'foto uploaden';

  @override
  String get background_task_operation_refresh =>
      'verversen vertraagd na uploaden van foto';

  @override
  String get background_task_run_started => 'gestart';

  @override
  String get background_task_run_not_started => 'nog niet gestart';

  @override
  String get background_task_run_to_be_deleted => 'om te worden verwijderd';

  @override
  String get background_task_question_stop => 'Wil je die taak ASAP stoppen?';

  @override
  String get feed_back => 'Feedback';

  @override
  String get undo => 'Ongedaan maken';

  @override
  String get copy_email_to_clip_board => 'E-mailadres kopiëren naar klembord';

  @override
  String get please_send_us_an_email_to =>
      'Stuur ons handmatig een e-mail naar';

  @override
  String get email_copied_to_clip_board => 'E-mail gekopieerd naar klembord!';

  @override
  String get select_accent_color => 'Selecteer een accentkleur';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blauw';

  @override
  String get color_cyan => 'Cyaan';

  @override
  String get color_green => 'Groen';

  @override
  String get color_light_brown => 'Standaard';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Oranje';

  @override
  String get color_pink => 'Roze';

  @override
  String get color_red => 'Rood';

  @override
  String get color_rust => 'Roest';

  @override
  String get color_teal => 'Groenblauw';

  @override
  String get text_contrast_mode => 'Tekstcontrast';

  @override
  String get contrast_high => 'Hoog';

  @override
  String get contrast_medium => 'Medium';

  @override
  String get contrast_low => 'Laag';

  @override
  String get product_refresher_internet_not_found => 'Product niet gevonden!';

  @override
  String get product_refresher_internet_not_connected =>
      'U bent niet verbonden met het internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server down ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Serverfout ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Product niet gevonden!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Er bestaat geen product met de volgende barcode in onze database: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Geen internetverbinding!';

  @override
  String get product_loader_network_error_message =>
      'Controleer of uw smartphone verbinding heeft met een wifi-netwerk of mobiele data heeft ingeschakeld';

  @override
  String get page_not_found_title => 'Pagina niet gevonden!';

  @override
  String get page_not_found_button => 'Ga terug naar de startpagina';

  @override
  String get download_data => 'Download gegevens';

  @override
  String get download_top_products =>
      'Download de top 1000 producten in uw land om direct te scannen';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count producten',
    );
    return 'Top $_temp0 downloaden in uw land voor direct scannen';
  }

  @override
  String get download_in_progress => 'Gegevens downloaden\nDit kan even duren';

  @override
  String downloaded_products(int num) {
    return '$num producten toegevoegd';
  }

  @override
  String get update_offline_data => 'Werk offline productgegevens bij';

  @override
  String get update_local_database_sub =>
      'Update de lokale productdatabase met de nieuwste gegevens van Open Food Facts';

  @override
  String get clear_local_database => 'Offline productgegevens wissen';

  @override
  String get clear_local_database_sub =>
      'Wis alle lokale productgegevens uit uw app om ruimte vrij te maken';

  @override
  String deleted_products(int num) {
    return '$num producten verwijderd';
  }

  @override
  String get loading => 'Bezig met laden…';

  @override
  String get know_more => 'Meer weten';

  @override
  String get offline_data_desc =>
      'Klik om meer te weten te komen over offline gegevens';

  @override
  String get offline_product_data_title => 'Offline productgegevens';

  @override
  String available_for_download(int num) {
    return '$num producten beschikbaar om onmiddellijk te scannen';
  }

  @override
  String get country_selector_title => 'Selecteer uw land:';

  @override
  String get currency_selector_title => 'Selecteer uw valuta:';

  @override
  String get language_selector_title => 'Selecteer uw taal:';

  @override
  String get language_selector_section_selected => 'Geselecteerde talen';

  @override
  String get language_selector_section_frequently_used => 'Vaak gebruikt';

  @override
  String get action_delete_list => 'Verwijder';

  @override
  String get action_change_list => 'De huidige lijst wijzigen';

  @override
  String get product_list_create => 'Aanmaken';

  @override
  String get product_list_create_tooltip => 'Een nieuwe lijst maken';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Nieuwe berekening)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Nieuwe berekening)';

  @override
  String get nutriscore_unknown => 'Onbekende Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Onbekende Nutri-Score (Nieuwe berekening)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is niet van toepassing';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score is niet van toepassing (Nieuwe berekening)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Green-Score A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'Onbekende Green-Score';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score is niet van toepassing';

  @override
  String get nova_group_generic_new =>
      'Ultra-bewerkte levensmiddelen - NOVA groepen';

  @override
  String get nova_group_1 => 'NOVA Groep 1';

  @override
  String get nova_group_2 => 'NOVA Groep 2';

  @override
  String get nova_group_3 => 'NOVA Groep 3';

  @override
  String get nova_group_4 => 'NOVA Groep 4';

  @override
  String get nova_group_unknown => 'Onbekende NOVA Groep';

  @override
  String get nutrition_facts => 'Voedingswaarden';

  @override
  String get faq_title_partners => 'Partners & begunstigers van de NGO';

  @override
  String get faq_title_vision =>
      'De Open Food Facts Visie, Missie, Waarden en Programma\'s';

  @override
  String get faq_title_install_beauty =>
      'Installeer Open Beauty Facts om een cosmetische database te maken';

  @override
  String get faq_title_install_pet =>
      'Installeer Open Pet Food Facts om een dierenvoedingsdatabase te maken';

  @override
  String get faq_title_install_product =>
      'Installeer Open Products Facts om een productendatabase te creëren om de levensduur van objecten te verlengen';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nieuwe berekening van de Nutri-Score: wat is er nieuw?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importeer uw producten in Open Food Facts';

  @override
  String get contact_title_pro_email => 'Producentcontact';

  @override
  String get contact_title_press_page => 'Perspagina';

  @override
  String get contact_title_press_email => 'Perscontact';

  @override
  String get contact_title_newsletter => 'Abonneer u op onze nieuwsbrief';

  @override
  String get contact_title_calendar => 'Abonneer je op onze communitykalender';

  @override
  String get hunger_games_loading_line1 => 'Geef ons een paar seconden…';

  @override
  String get hunger_games_loading_line2 =>
      'We zijn de vragen aan het downloaden!';

  @override
  String get hunger_games_error_label =>
      'Argh! Er ging iets mis… en we konden de vragen niet laden.';

  @override
  String get hunger_games_error_retry_button =>
      'Laten we het opnieuw proberen!';

  @override
  String get reorder_attribute_action => 'Herschik de attributen';

  @override
  String get link_cant_be_opened =>
      'Deze link kan niet worden geopend op uw apparaat. Controleer of u een browser heeft geïnstalleerd.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Details voor $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Details voor $pageName met $productName';
  }

  @override
  String get guide_title => 'Gids';

  @override
  String get guide_share_label => 'Delen';

  @override
  String get guide_nutriscore_v2_title =>
      'De Nutri-Score Evolueert: Toelichtingen!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Wat is de Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'De Nutri-Score is een logo dat tot doel heeft u te informeren over de **voedingskwaliteit van voedingsmiddelen**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'De kleurcode varieert van donkergroen (**A**) voor de **gezondste** producten tot donkerrood (**E**) voor de **minder gezonde** producten.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'Het Nutri-Score A-logo';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Waarom evolueert de Nutri-Score?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'De Nutri-Score-formule **evolueert** om betere aanbevelingen te doen:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Evalueert alle drankjes beter';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'De relatieve aantekeningen van **melk**, **zuiveldranken** met toegevoegde suikers en **groentedranken** werden beter gedifferentieerd in het nieuwe algoritme.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Betere rangschikking van drankjes';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'Er wordt meer rekening gehouden met het suikergehalte**, wat in voordeel is voor dranken met een laag suikergehalte.\\n** Zoetstoffen worden ook bestraft**: dieetdrankjes worden gedegradeerd van een B naar een C tot een E-score. Water is nog steeds de aanbevolen drank.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title => 'Zout en suiker bestraft';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Producten die **te zoet** of **te zout** zijn, krijgen een lagere beoordeling**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hiërarchie binnen oliën en vis';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'De beoordeling van bepaalde **vette vis** en **oliën rijk aan goede vetten** zal verbeteren.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Beperk rood vlees';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'De consumptie van **rood vlees moet beperkt worden**. Daarom zal **gevogelte relatief beter scoren**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Hoe onderscheid ik de oude Nutri-Score van de nieuwe berekening?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Vanaf nu kan het logo een vermelding \"**Nieuwe berekening**\" weergeven om te verduidelijken dat het daadwerkelijk om de nieuwe berekening gaat.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Het logo van de nieuwe Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Waar vind je de nieuwe Nutri-Score berekening?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'De Nutri-Score wordt toegepast in 7 landen: Frankrijk, Duitsland, België, Spanje, Luxemburg, Nederland en Zwitserland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Fabrikanten hebben maximaal **2 jaar** na ondertekening van het besluit de tijd om de oude berekening te vervangen door de nieuwe.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Zonder te moeten wachten **vind je in de OpenFoodFacts applicatie** al de nieuwe berekening, ook als de fabrikanten de score nog niet hebben aangepast.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Wat niet verandert';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'De Nutri-Score is een score die is ontworpen om **de voedingskwaliteit te meten**. Het is **complementair aan de NOVA-groep** op **ultrabewerkte voedingsmiddelen** (ook aanwezig in de applicatie).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Voor fabrikanten blijft de weergave van de Nutri-Score **optioneel**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Wat is de Green-Score?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'De Green-Score is een logo dat ernaar streeft je te informeren over de **milieu-impact van voedsel**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'De kleurcode varieert van donkergroen (**A+**) voor de **producten met de minste impact** tot donkerrood (**F**) voor de **producten met de meeste impact**.';

  @override
  String get guide_greenscore_logos_caption => 'De Green-Score-logo\'s';

  @override
  String get guide_greenscore_lca_title => 'De kern: Levenscyclusanalyse (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Een wetenschappelijke evaluatie van voedselcategorieën';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Voor elke productcategorie wordt een **benchmark**-score vastgesteld met behulp van gegevens uit de milieudatabase van Agribalyse (ontworpen door ADEME en INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Levenscyclusanalyse** is een gestandaardiseerde beoordelingsmethode voor het uitvoeren van een milieubeoordeling in meerdere fasen en op basis van meerdere criteria.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Het meet:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 productiestappen';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Landbouw';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Verwerking';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Verpakking';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distributie';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consumptie';

  @override
  String get guide_greenscore_lca_arg3_title => '14 milieu-impactindicatoren';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Klimaatverandering/CO-voetafdruk';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Aantasting van de ozonlaag';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ioniserende straling';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Land';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Water- en energieverbruik';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Luchtvervuiling';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Zee- en zoetwater (deeltjes, verzuring, eutrofiëring)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Uitputting van hulpbronnen.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonussen en malussen';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Productiewijze';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Herkomst van de ingrediënten';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Bedreigde soorten';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Verpakking';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Een grotere behoefte aan transparantie om de milieu-impact beter te meten en te verminderen';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Hoe kunnen burgers helpen?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Hoe fabrikanten kunnen helpen';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Fabrikanten kunnen hun informatie rechtstreeks aan ons doorgeven via ons gratis platform voor producenten.';

  @override
  String get guide_greenscore_better_product_title =>
      'Welk product is beter voor de planeet?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Het kan moeilijk zijn om dat te beoordelen';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Kiezen voor duurzaam voedsel is een van de krachtigste dingen die we voor het klimaat kunnen doen, aangezien **ons wereldwijde voedselsysteem verantwoordelijk is voor meer dan een kwart van alle uitstoot van broeikasgassen**.\n(Bron: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Jij hebt macht!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Het goede nieuws is dat dit ons een krachtige manier biedt om verandering te creëren.\n**Ieder van ons eet ongeveer 1000 maaltijden per jaar**. Dat zijn 1000 kansen om **een betere toekomst voor de planeet te kiezen**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Helpt om verantwoordelijk te zijn en beslissingen te nemen';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Het kiezen van duurzame voeding kan ingewikkeld lijken. Etiketten zijn verwarrend en er ontbreekt vaak informatie. De Green-Score is ontwikkeld om het eenvoudiger te maken en geeft je een **duidelijke**, **wetenschappelijk onderbouwde** en **transparante** milieubeoordeling voor voedingsproducten, precies waar je die nodig hebt: tijdens het winkelen.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparantie';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'In tegenstelling tot merkgebonden labels is de Green-Score-berekening **volledig open** en kan deze **door iedereen** worden geverifieerd.';

  @override
  String get guide_nova_title => 'Ultra-verwerkte voedingsmiddelen';

  @override
  String get guide_nova_what_is_nova_title => 'Wat is ultra-bewerking?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'De NOVA-groepen informeren u over **het niveau van voedselverwerking**.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'De NOVA-classificatie maakt het mogelijk om voedingsmiddelen in **4 groepen** in te delen op basis van hun **mate van industriële verwerking** (minimaal bewerkte of onbewerkte voedingsmiddelen, culinaire ingrediënten, bewerkte voedingsmiddelen, ultrabewerkte voedingsmiddelen).';

  @override
  String get guide_nova_logos_caption => 'De NOVA-logo\'s';

  @override
  String get guide_nova_groups_title => 'De 4 NOVA-groepen';

  @override
  String get guide_nova_groups_intro =>
      'Er zijn 4 NOVA-groepen, waarvan Groep 4 - Ultrabewerkte voedingsmiddelen de problematische is.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimaal bewerkte of onbewerkte voedingsmiddelen';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Bewerkte ingrediënten';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from Group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Bewerkte levensmiddelen';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to Group 1** foods. Processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. Most processed foods have two or three ingredients and are recognizable as modified versions of Group 1 foods. They can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra-verwerkte voedingsmiddelen';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact Group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. However, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. Some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'De problemen met ultra-bewerking';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Extreme bewerking van voedselingrediënten';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Additieven die verder gaan dan pure voedselveiligheid';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Bewerking die je niet thuis kan uitvoeren';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'De roofzuchtige en financiële aspecten van ultra-bewerking';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'Een gezondheidsrisico';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welkom bij Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Wat is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Kenmerken van Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Ontvang meldingen voor uw ongewenste ingrediënten';

  @override
  String get guide_open_food_facts_tips_title =>
      'Tips voor het maken van geweldige foto\'s';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Wat je niet moet doen';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Vermijd schaduwen en schittering.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Geen wazige of onscherpe tekst.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Knip geen delen van de tekst weg.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Vermijd drukke achtergronden.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Zorg voor goede, gelijkmatige verlichting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Zorg ervoor dat de tekst scherp en leesbaar is.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Leg de gehele ingrediëntenlijst vast.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Plaats het product op een vlakke ondergrond.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help ons de \"Wikipedia van Voedsel\" te bouwen';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Een score om ultrabewerkte voedingsmiddelen te vermijden';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'Een score voor de planeet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-nl.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welkom bij Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Wat is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Kenmerken van Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Ontvang meldingen voor uw ongewenste ingrediënten';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is uw huisdier allergisch voor bepaalde ingrediënten? U kunt direct in de app een lijst met te vermijden ingrediënten instellen!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips voor het maken van geweldige foto\'s';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title =>
      'Wat je niet moet doen';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Vermijd schaduwen en schittering.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Geen wazige of onscherpe tekst.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Knip geen delen van de tekst weg.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Vermijd drukke achtergronden.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Zorg voor goede, gelijkmatige verlichting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Zorg ervoor dat de tekst scherp en leesbaar is.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Leg de gehele ingrediëntenlijst vast.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Plaats het product op een vlakke ondergrond.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Een opmerking over het scoren';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-en.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welkom bij Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Wat is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Kenmerken van Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Ontvang meldingen voor uw ongewenste ingrediënten';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips voor het maken van geweldige foto\'s';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Wat je niet moet doen';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Vermijd schaduwen en schittering.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Geen wazige of onscherpe tekst.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Knip geen delen van de tekst weg.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Vermijd drukke achtergronden.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Zorg voor goede, gelijkmatige verlichting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Zorg ervoor dat de tekst scherp en leesbaar is.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Leg de gehele ingrediëntenlijst vast.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Plaats het product op een vlakke ondergrond.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Een opmerking over het scoren';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'In tegenstelling tot voedingsproducten kent de cosmeticawereld **geen universeel erkend, door de overheid ondersteund scoresysteem zoals de Nutri-Score**. De effecten van ingrediënten kunnen zeer persoonlijk zijn en hangen af van huidtype, allergieën en individuele behoeften.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-en.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welkom bij Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Wat is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Er zijn momenteel weinig bedrijven die grote databases met productprijzen op barcodeniveau bezitten. Deze prijzen zijn niet vrij beschikbaar, maar worden tegen een hoge prijs verkocht aan private actoren, onderzoekers en andere organisaties die ze zich kunnen veroorloven.';

  @override
  String get guide_open_prices_how_title => 'Hoe werkt Open Prices?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Verzamel foto\'s van bonnetjes';

  @override
  String get guide_open_prices_why_title => 'Waarom doet Open Food Facts dit?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title =>
      'Vergelijk prijzen bij u in de buurt';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'Ik ben een detailhandelaar en ik wil prijzen bijdragen. Hoe kan ik dat doen?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'Welke informatie is nuttig?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-en.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Binnenkort beschikbaar';

  @override
  String get guide_learn_more_subtitle => 'Tik om meer te weten te komen';

  @override
  String get preview_badge => 'Voorbeeld';

  @override
  String get prices_feedback_form =>
      'Klik hier om ons uw feedback over deze nieuwe functie te sturen!';

  @override
  String get menu_button_list_actions => 'Selecteer een actie';

  @override
  String get error_loading_photo => 'Fout bij het laden van de foto';

  @override
  String get photo_viewer_action_use_picture_as => 'Gebruiken als…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Deze afbeelding gebruiken als…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Gebruik deze afbeelding als… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Details';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Details van deze foto';

  @override
  String get photo_viewer_details_title => 'Details van de foto';

  @override
  String get photo_viewer_details_contributor_title => 'Bijdrager';

  @override
  String get photo_viewer_details_size_title => 'Grootte';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Datum';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatibel';

  @override
  String get user_lists_action_multi_select => 'Meerdere selecteren';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Jouw compatibiliteitsscore: $score%';
  }

  @override
  String get product_image_front_accessibility_label =>
      'Foto van het product (voorkant)';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Foto van de ingrediëntenlijst';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Foto van voedingswaarde';

  @override
  String get product_image_packaging_accessibility_label => 'Verpakkingsfoto';

  @override
  String get product_image_other_accessibility_label => 'Andere foto';

  @override
  String get product_image_outdated_message =>
      'Deze afbeelding is mogelijk verouderd';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (deze afbeelding kan verouderd zijn)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (deze afbeelding is mogelijk vergrendeld door de producent)';
  }

  @override
  String get product_image_error => 'De afbeelding kan niet worden geladen!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Kan $type niet laden (netwerkfout?)';
  }

  @override
  String get product_page_image_no_image_available => 'Geen\nafbeelding!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Er is geen afbeelding beschikbaar voor dit product';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Acties opnieuw ordenen of verbergen';

  @override
  String get product_page_action_bar_setting_modal_title => 'Acties bewerken';

  @override
  String get product_page_action_bar_item_move_up => 'Verplaats naar boven';

  @override
  String get product_page_action_bar_item_move_down => 'Verplaats naar beneden';

  @override
  String get product_page_action_bar_item_enable => 'Actie inschakelen';

  @override
  String get product_page_action_bar_item_disable => 'Actie uitschakelen';

  @override
  String get product_page_pending_operations_banner_title =>
      'Bewerkingen uploaden…';

  @override
  String get product_page_pending_operations_banner_message =>
      'De gegevens die op deze pagina worden weergegeven, weerspiegelen uw wijzigingen nog niet.\nWacht een paar seconden…';

  @override
  String get product_add_a_language => 'Een taal toevoegen';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Streepjescode $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Verwijder dit product uit de carrousel';

  @override
  String get carousel_unsupported_header => 'Niet-ondersteunde streepjescode!';

  @override
  String get carousel_unsupported_title => 'Oeps!';

  @override
  String get carousel_unsupported_text =>
      'De gescande streepjescode wordt niet ondersteund door Open Food Facts!';

  @override
  String get carousel_error_header => 'Fout!';

  @override
  String get carousel_error_title => 'Wat jammer!';

  @override
  String get carousel_error_text_1 =>
      'We konden geen informatie over deze streepjescode downloaden:';

  @override
  String get carousel_error_text_2 =>
      'Controleer uw internetverbinding of klik op deze knop:';

  @override
  String get carousel_error_button => 'Opnieuw proberen';

  @override
  String get carousel_unknown_product_header => 'Onbekend product';

  @override
  String get carousel_unknown_product_title =>
      'Gefeliciteerd!\nJe hebt __de zeldzame edelsteen gevonden!__';

  @override
  String get carousel_unknown_product_text =>
      'Onze gezamenlijke database bevat meer dan **3 miljoen producten**, maar deze streepjescode bestaat niet: ';

  @override
  String get carousel_unknown_product_button => 'Voeg dit product toe';

  @override
  String get carousel_loading_header => 'Informatie wordt geladen...';

  @override
  String get carousel_loading_title =>
      'U heeft zojuist een product gescand met de volgende streepjescode:';

  @override
  String get carousel_loading_text =>
      'We zijn er naar op zoek in onze database van meer dan **3 miljoen producten!**';

  @override
  String get product_type_subtitle_food =>
      'Groenten, fruit, diepvriesproducten…';

  @override
  String get product_type_subtitle_beauty => 'Make-up, zeep, tandpasta…';

  @override
  String get product_type_subtitle_pet_food => 'Voedsel voor honden, katten…';

  @override
  String get product_type_subtitle_product => 'Smartphones, meubels…';

  @override
  String get photo_field_front => 'Productfoto';

  @override
  String get photo_field_ingredients => 'Ingrediënten foto';

  @override
  String get photo_field_nutrition => 'Voedingswaarde foto';

  @override
  String get photo_field_packaging => 'Foto van verpakkingsinformatie';

  @override
  String get photo_already_exists => 'Deze foto bestaat al';

  @override
  String get photo_missing => 'Deze foto ontbreekt';

  @override
  String get date => 'Datum';

  @override
  String get photo_rotate_left => 'Draai naar links';

  @override
  String get photo_rotate_right => 'Draai naar rechts';

  @override
  String get photo_undo_action => 'Vorige actie ongedaan maken';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Een wereldkaart van $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap bijdragers';

  @override
  String get not_applicable_short => 'n.v.t.';

  @override
  String get knowledge_panel_warning_text => 'Waarschuwing';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Waarom verschilt deze Nutri-Score van de score op de verpakking?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Er zijn twee mogelijke verklaringen:\nDe lijst met ingrediënten en/of voedingswaarden is niet up-to-date.\n\nWij bieden de \"Nieuwe berekening\" van de Nutri-Score (of V2). Controleer of u de banner \"Nieuwe berekening\" op de verpakking ziet staan.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Controleer de ingrediënten';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Controleer voedingswaarden';

  @override
  String url_not_supported(String url) {
    return 'Helaas kunnen we de URL niet openen:\n$url';
  }

  @override
  String get product_list_export => 'Exporteren';

  @override
  String get product_list_import => 'Importeren';

  @override
  String get product_footer_action_barcode => 'Bekijk streepjescode';

  @override
  String get product_footer_action_barcode_short => 'Streepjescode';

  @override
  String get product_footer_action_open_website => 'Website openen';

  @override
  String get product_footer_action_report => 'Rapporteren';

  @override
  String get product_footer_action_contributor_guide => 'Help';

  @override
  String get product_footer_action_data_quality_tags => 'Gegevenskwaliteit';

  @override
  String get product_page_tab_for_me => 'Voor mij';

  @override
  String get product_page_tab_website => 'Website';

  @override
  String get product_page_tab_prices => 'Prijzen';

  @override
  String get prices_explanation_card_title => 'Waarom prijzen?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** is een project om productprijzen wereldwijd te verzamelen en te delen 🌍. Open Prices wordt ontwikkeld en onderhouden door Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Meer informatie';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Wat zijn Folksonomy-attributen?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Attributen zijn **sleutel-waarde** gebaseerd.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Deze eigenschappen worden door bijdragers gemaakt en opgeslagen voor allerlei doeleinden.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Geen prijs beschikbaar';

  @override
  String get prices_products_empty_explanation =>
      'Wees de eerste om bij te dragen!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize producten (totaal: $total)';
  }

  @override
  String get app_review_title => 'Geniet je van deze app?';

  @override
  String get app_review_low => 'Kan beter';

  @override
  String get app_review_medium => 'Niet slecht';

  @override
  String get app_review_high => 'Zeker weten!';

  @override
  String get app_review_feedback_modal_title =>
      'Help ons onze applicatie te verbeteren';

  @override
  String get app_review_feedback_modal_content =>
      'Als u een paar minuten de tijd heeft, kunt u dan dit formulier invullen zodat **we de app in toekomstige updates kunnen verbeteren**:';

  @override
  String get app_review_feedback_modal_open_form => 'Beantwoord de vragenlijst';

  @override
  String get app_review_feedback_modal_later => 'Vraag het me later nog eens';

  @override
  String get nutrition_facts_extract_new =>
      'NIEUW: U kunt automatisch de voedingsstoffen uit de foto extraheren!';

  @override
  String get nutrition_facts_extract_button_text => 'Nu extraheren';

  @override
  String get nutrition_facts_extract_in_progress => 'Extractie bezig…';

  @override
  String get nutrition_facts_extract_successful => 'Extractie succesvol';

  @override
  String get nutrition_facts_extract_failed =>
      'Het is niet gelukt om voedingsstoffen uit de foto te extraheren';

  @override
  String get prices_discount => 'Korting';

  @override
  String get prices_stats_statistics => 'Statistieken';

  @override
  String get prices_stats_title => 'Prijzen Statistieken';

  @override
  String get prices_stats_prices_section => 'Prijzen';

  @override
  String get prices_stats_products_section => 'Producten';

  @override
  String get prices_stats_locations_section => 'Locaties';

  @override
  String get prices_stats_proofs_section => 'Bewijzen';

  @override
  String get prices_stats_contributors_section => 'Medewerkers';

  @override
  String get prices_stats_experiments_section => 'Experimenten';

  @override
  String get prices_stats_misc_section => 'Diversen';

  @override
  String get prices_stats_total => 'Totaal';

  @override
  String get prices_stats_with_barcode => 'Met een streepjescode';

  @override
  String get prices_stats_with_category => 'Met een categorie';

  @override
  String get prices_stats_with_discount => 'Met een korting';

  @override
  String get prices_stats_community => 'Gemeenschap';

  @override
  String get prices_stats_consumption => 'Consumptie';

  @override
  String get prices_stats_with_price => 'Met een prijs';

  @override
  String get prices_stats_food => 'Voedsel';

  @override
  String get prices_stats_beauty => 'Schoonheidsindustrie';

  @override
  String get prices_stats_products => 'Producten';

  @override
  String get prices_stats_pet_food => 'Dierenvoeding';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Landen';

  @override
  String get prices_stats_price_tag => 'Prijskaartje';

  @override
  String get prices_stats_receipt => 'Bon';

  @override
  String get prices_stats_gdpr_request => 'AVG-verzoek';

  @override
  String get prices_stats_shop_import => 'Winkel import';

  @override
  String get prices_stats_challenges => 'Uitdagingen';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Prijzen gekoppeld aan een prijskaartje';

  @override
  String get prices_stats_currencies => 'Valuta\'s';

  @override
  String get prices_stats_years => 'Jaren';

  @override
  String get prices_stats_by_source_title => 'Prijzen en bewijzen per bron';

  @override
  String get prices_stats_website => 'Website';

  @override
  String get prices_stats_mobile_app => 'Mobiele app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Andere';

  @override
  String get prices_stats_last_updated => 'Laatst bijgewerkt op';

  @override
  String get prices_stats_error =>
      'Er is een fout opgetreden bij het laden van de statistieken.';

  @override
  String get product_edit_robotoff_question_answered => 'Vraag beantwoord!';

  @override
  String get product_edit_robotoff_proof => 'Bewijs';

  @override
  String get preferences_card_general => 'Algemeen';

  @override
  String get preferences_prices_title => 'Prijzen';

  @override
  String get preferences_prices_subtitle => 'Beheer uw prijsvoorkeuren';

  @override
  String get preferences_card_project => 'Het Open Food Facts-project';

  @override
  String get preferences_contribute_title => 'Bijdragen';

  @override
  String get preferences_my_contributions_title => 'Mijn bijdragen';

  @override
  String get preferences_my_stats_title => 'Mijn statistieken';

  @override
  String get preferences_contribute_subtitle => 'Vertaal, verbeter onze tools…';

  @override
  String get preferences_connect_title => 'Verbinden';

  @override
  String get preferences_connect_subtitle =>
      'Neem contact met ons op of volg ons op sociale media';

  @override
  String get preferences_support_title => 'Doneer';

  @override
  String get preferences_support_subtitle =>
      'Help ons miljoenen consumenten over de hele wereld te informeren';

  @override
  String get preferences_card_help => 'Hulp en ondersteuning';

  @override
  String get preferences_faq_title => 'Veelgestelde vragen (FAQ)';

  @override
  String get preferences_faq_subtitle => 'Krijg antwoorden op uw vragen';

  @override
  String get logged_out => 'Uitgelogd';

  @override
  String get preferences_app_bar_message =>
      'Bedankt dat u een van onze leden bent!';

  @override
  String get preferences_app_bar_products_modified => 'Producten aangepast';

  @override
  String get preferences_app_bar_prices_added => 'Prijzen toegevoegd';

  @override
  String get preferences_app_bar_see_all_stats => 'Bekijk alle statistieken';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Zoek $provider naar \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Zoek naar een instelling (bijv. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Toegankelijkheid: emoji weergeven';

  @override
  String get preferences_accessibility_remove_colors =>
      'Toegankelijkheid: kleuren verwijderen';

  @override
  String get preferences_app_settings_products => 'Producten';

  @override
  String get preferences_card_about => 'Over';

  @override
  String get preferences_legal_information_title => 'Juridische informatie';

  @override
  String get preferences_legal_information_subtitle =>
      'Gebruiksvoorwaarden, privacybeleid en meer';

  @override
  String get preferences_terms_of_use => 'Gebruiksvoorwaarden';

  @override
  String get preferences_legal_mentions => 'Wettelijke vermeldingen';

  @override
  String get preferences_legal_header =>
      'Open Food Facts is een database met voedselproducten **gemaakt door iedereen, voor iedereen**.\nU kunt het gebruiken om betere voedselkeuzes te maken, en omdat het **open data** is, kan iedereen het **hergebruiken voor welk doel dan ook**.';

  @override
  String get preferences_privacy_policy => 'Privacybeleid';

  @override
  String get preferences_licenses => 'Licenties';

  @override
  String get preferences_about_app_title => 'Over de app';

  @override
  String get preferences_about_app_subtitle =>
      'Technische informatie, ontwikkelaarsinformatie en meer';

  @override
  String get preferences_card_information => 'Informatie';

  @override
  String get preferences_version_number_title => 'Versienummer';

  @override
  String get preferences_scanner_title => 'Scanner';

  @override
  String get preferences_app_store => 'App store';

  @override
  String get preferences_app_system_settings => 'Systeeminstellingen';

  @override
  String get preferences_source_code => 'Toegang tot de broncode';

  @override
  String get preferences_source_code_subtitle =>
      'En begin met het maken van impact voor miljoenen mensen';

  @override
  String get preferences_add_prices => 'Prijzen toevoegen';

  @override
  String get preferences_complete_products => 'Voltooi producten';

  @override
  String get preferences_tips => 'Tips';

  @override
  String get tips_discover_nutriscore => 'Ontdek de nieuwe Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Op de website van Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Mijn account beheren';

  @override
  String get preferences_manage_account_tooltip => 'Beheer uw account';

  @override
  String get preferences_change_password_title => 'Mijn wachtwoord wijzigen';

  @override
  String get preferences_danger_zone => 'Gevarenzone';

  @override
  String get preferences_account_deletion_subtitle =>
      'Al uw bijdragen gaan verloren';

  @override
  String get preferences_contributions_title => 'Bijdragen';

  @override
  String get preferences_dev_mode_app_settings_title => 'App-instellingen';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Zeer experimentele manier om producten offline te scannen';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Vernieuw alle producten van de server';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Doe dit alleen als het absoluut noodzakelijk is.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demomodus';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Kaarten toevoegen aan scanner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Voegt 3 voorbeeldproducten toe aan de scanner';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'Folksonomy host';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Gastheer: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Toegankelijkheidsexperimenten';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Selectie van meerdere producten voor prijzen';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Door de gebruiker geordende kennispanelen';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Tijdelijke toegang tot locatie zoeken';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Zij-aan-zij vergelijking voor 2 of 3 producten';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Productlijst importeren';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Scores en methodologieën';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Ontdek hoe de Nutri-Score wordt berekend';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Ontdek de belangrijkste wijzigingen in de methodologie';

  @override
  String get preferences_faq_discover_project_title => 'Ontdek het project';

  @override
  String get preferences_faq_discover_off_title => 'Ontdek Open Food Facts';

  @override
  String get preferences_faq_discover_obf_title => 'Ontdek Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Ontdek Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Ontdek Open Prices';

  @override
  String get preferences_faq_discover_opf_title => 'Ontdek Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'FAQ - Veelgestelde vragen';

  @override
  String get preferences_faq_off_ngo_title => 'De NGO Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informatie';

  @override
  String get preferences_connect_community_updates_title =>
      'Ontvang community-updates';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Blijf op de hoogte van app- en communitynieuws';

  @override
  String get preferences_connect_community_calendar_title =>
      'Abonneer je op onze communitykalender';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Doe mee door een van onze virtuele evenementen bij te wonen';

  @override
  String get preferences_connect_blog_title => 'De Open Food Facts-blog';

  @override
  String get preferences_connect_blog_subtitle =>
      'Ontvang het laatste nieuws zodra het gebeurt';

  @override
  String get preferences_connect_community_help_title =>
      'Krijg hulp van de community';

  @override
  String get preferences_connect_improve_app_title =>
      'Help ons de app te verbeteren';

  @override
  String get preferences_connect_debug_info_title =>
      'Stuur ons debuginformatie';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Stuur ons een e-mail met gedetailleerde debuginformatie';

  @override
  String get preferences_connect_feedback_title =>
      'Stuur ons feedback over de app';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Help de toekomst van de app vorm te geven';

  @override
  String get preferences_connect_survey_title => 'Doe mee aan de app-enquête';

  @override
  String get preferences_connect_survey_subtitle =>
      'Help ons begrijpen wat we hierna moeten bouwen';

  @override
  String get preferences_connect_professionals_title => 'Professionals';

  @override
  String get preferences_connect_pro_subtitle =>
      'Volledig gratis, garandeert nauwkeurige gegevens voor 500 apps & miljoenen consumenten. Zelf-service, compatibel met uw PIM of spreadsheets (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Neem contact op om te beginnen';

  @override
  String get preferences_connect_press_title => 'Pers';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Ontvang al het materiaal dat u nodig hebt voor uw rapport';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Neem contact met ons op voor persvragen of om ons te informeren over uw rapport';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Word een actieve vrijwilliger';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Ontwikkeling, Communicatie, Ontwerp… alle vormen van vrijwilligerswerk of expertise zijn welkom!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Ontdek enkele van de vele manieren waarop u kunt bijdragen';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Mobiele app-ontwikkeling';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Leer hoe u kunt bijdragen aan softwareontwikkeling';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Dagelijkse onstabiele builds, gloednieuwe functies';

  @override
  String get preferences_contribute_local_community_title =>
      'Laat uw lokale gemeenschap groeien';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Hulp bij vertalingen van software, inhoud en ingrediëntenanalyse';

  @override
  String get preferences_contribute_share_subtitle =>
      'Om u te helpen, hebben we een klein sjabloon gemaakt :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Eenvoudige stappen om de voedseltransparantie in uw land te vergroten';

  @override
  String get preferences_contribute_data_quality_title => 'Gegevenskwaliteit';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Sluit je aan bij het datakwaliteitsteam';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Sluit u aan bij onze inspanningen om ervoor te zorgen dat de database compleet en nauwkeurig is';

  @override
  String get preferences_contributions_products_added_title =>
      'Toegevoegde producten';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nieuwe producten die ik heb toegevoegd aan Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Producten die ik moet voltooien';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Alle onvolledige producten';

  @override
  String get preferences_my_contributions_prices_title => 'Prijzen';

  @override
  String get preferences_my_contributions_my_prices_title => 'Mijn prijzen';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Mijn prijzen, mijn bewijzen…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Producten die u kunt helpen voltooien';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Help mee de Nutri-Score en Green-Score in uw land te berekenen';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Prijzen die ik heb bijgedragen';

  @override
  String get preferences_prices_proofs_subtitle => 'Prijskaartjes en bonnen';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Maak foto\'s van uw bonnetjes en scan de bijbehorende barcodes';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Maak foto\'s van prijzen in een winkel';

  @override
  String get preferences_prices_newest_title => 'Nieuwste prijzen';

  @override
  String get preferences_prices_newest_subtitle =>
      'Laatste prijzen toegevoegd door de Open Prices-community';

  @override
  String get preferences_prices_top_contributors_title =>
      'Bijdragers met de meeste prijzen';

  @override
  String get preferences_prices_metrics_title => 'Open Price-metrieken';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Volg de evolutie van het project';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Manieren om bij te dragen';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Bevestig de prijzen die door uzelf of anderen zijn toegevoegd met behulp van AI';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Voeg snel veel bonnen of foto\'s van rekken toe vanuit je filmrol';

  @override
  String get preferences_prices_challenges_title => 'Maandelijkse uitdagingen';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Neem deel aan maandelijkse thematische uitdagingen om prijzen te verzamelen';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Eis uw loyaliteitsgegevens terug';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Leer hoe u uw gegevens kunt opvragen';

  @override
  String get preferences_page_customize_app_title => 'Pas de app aan';

  @override
  String get preferences_page_contribute_project_title =>
      'Draag bij aan het project';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Eenvoudige manieren om Open Food Facts te helpen';

  @override
  String get preferences_page_faq_subtitle =>
      'Scoremethodologieën, hulp en meer over het project';

  @override
  String get product_edit_robotoff_positive_button => 'Suggestie accepteren';

  @override
  String get product_edit_robotoff_negative_button => 'Suggestie afwijzen';

  @override
  String get product_edit_robotoff_show_proof => 'Toon bewijs';

  @override
  String get product_edit_robotoff_expand_proof => 'Bewijs uitklappen';

  @override
  String get product_page_tab_raw_data => 'Ruwe gegevens';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Pagina $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Pagina $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count van $total items';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count van $total items';
  }

  @override
  String item_count(int count) {
    return '$count items';
  }

  @override
  String item_count_string(String count) {
    return '$count items';
  }

  @override
  String get prices_no_result => 'Geen prijsstatistieken gevonden.';

  @override
  String get prices_error_loading_more_items =>
      'Fout bij het laden van meer items';

  @override
  String get prices_proof_error =>
      'Authenticatie mislukt, kan geen bewijzen ophalen';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count van $total bewijzen';
  }

  @override
  String proof_count(int count) {
    return '$count bewijzen';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count van $total bijdragers';
  }

  @override
  String contributors_count(int count) {
    return '$count bijdragers';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count van $total locaties';
  }

  @override
  String prices_locations_count(int count) {
    return '$count locaties';
  }

  @override
  String get restart_to_apply_message =>
      'Start de app opnieuw op om de wijzigingen toe te passen.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafische interface';

  @override
  String get preferences_app_settings_media_title => 'Media';

  @override
  String get preferences_about_app_development_title => 'Ontwikkeling';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Open Food Facts Labs';

  @override
  String get preferences_root_account_title => 'Account';

  @override
  String get preferences_contribute_translate_header =>
      'Vertaal Open Food Facts in uw taal';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Schrijf je in voor de alfaversie van de app';

  @override
  String get preferences_dev_mode_section_data =>
      'Bijdragen en productgegevens';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Folksonomy niet weergeven';

  @override
  String get preferences_account_title => 'Account';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Toegevoegd op $created';
  }

  @override
  String get location_map_details_title => 'Locatiedetails';

  @override
  String get location_map_details_name => 'Naam';

  @override
  String get location_map_details_street => 'Straat';

  @override
  String get location_map_details_city => 'Stad';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coördinaten';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
