// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hebrew (`he`).
class AppLocalizationsHe extends AppLocalizations {
  AppLocalizationsHe([String locale = 'he']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'כן';

  @override
  String get add => 'הוספה';

  @override
  String get account_delete_message =>
      'למחוק את חשבונך?\nאם יש לכך סיבה כלשהי, נשמע לקבל הסבר כאן למטה';

  @override
  String get reason => 'סיבה';

  @override
  String get okay => 'בסדר';

  @override
  String get validate => 'אימות';

  @override
  String get create => 'יצירה';

  @override
  String get applyButtonText => 'החלה';

  @override
  String get next_label => 'הבא';

  @override
  String get continue_label => 'להמשיך';

  @override
  String get exit_label => 'יציאה';

  @override
  String get previous_label => 'הקודם';

  @override
  String get go_back_to_top => 'חזרה למעלה';

  @override
  String get save => 'שמירה';

  @override
  String get save_confirmation => 'לשמור?';

  @override
  String get skip => 'דילוג';

  @override
  String get cancel => 'ביטול';

  @override
  String get ignore => 'התעלמות';

  @override
  String get close => 'סגירה';

  @override
  String get no => 'לא';

  @override
  String get stop => 'עצירה';

  @override
  String get finish => 'סיום';

  @override
  String get calculate => 'חישוב';

  @override
  String get reset_food_prefs => 'איפוס העדפות מזון';

  @override
  String get error => 'משהו השתבש';

  @override
  String get error_occurred => 'אירעה שגיאה';

  @override
  String get featureInProgress =>
      'אנו עדיין עובדים על היכולת הזאת, מוטב לבדוק אותה שוב';

  @override
  String get label_web => 'הצגה בדפדפן';

  @override
  String get learnMore => 'מידע נוסף';

  @override
  String get unknown => 'לא ידוע';

  @override
  String get match_very_good => 'התאמה טובה מאוד';

  @override
  String get match_good => 'התאמה טובה';

  @override
  String get match_poor => 'התאמה גרועה';

  @override
  String get match_may_not => 'אולי אין התאמה';

  @override
  String get match_does_not => 'אינו תואם';

  @override
  String get match_unknown => 'התאמה לא ידועה';

  @override
  String get match_short_very_good => 'התאמה טובה מאוד';

  @override
  String get match_short_good => 'התאמה טובה';

  @override
  String get match_short_poor => 'התאמה גרועה';

  @override
  String get match_short_may_not => 'אולי אין התאמה';

  @override
  String get match_short_does_not => 'אינו תואם';

  @override
  String get match_short_unknown => 'התאמה לא ידועה';

  @override
  String get licenses => 'רישיונות';

  @override
  String get looking_for => 'בחיפוש אחר';

  @override
  String get welcomeToOpenFoodFacts => 'ברוך בואך ל־Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts הוא ארגון כלל עולמי ללא מטרות רווח שמופעל על ידי קהילות מקומיות.';

  @override
  String get productDataUtility => 'הצגת נתוני המזון שתואמים להעדפות שלך.';

  @override
  String get healthCardUtility => 'בחירת מאכלים שעושים לך טוב.';

  @override
  String get ecoCardUtility => 'בחירת מאכלים שעושים טוב לכדור הארץ.';

  @override
  String get server_error_open_new_issue =>
      'אין תגובה מהשרת! אפשר לדווח על תקלה דרך הקישור הבא.';

  @override
  String get sign_in_text =>
      'ניתן להיכנס לחשבונך ב־Open Food Facts כדי לשמור את התרומות שלך';

  @override
  String get incorrect_credentials => 'שם משתמש או סיסמה שגויים.';

  @override
  String get password_lost_incorrect_credentials =>
      'כתובת הדוא״ל או שם המשתמש הזה אינם קיימים. נא לבדוק את פרטי הגישה שלך.';

  @override
  String get password_lost_server_unavailable =>
      'אנו חווים כעת האטות בשרתים שלנו ואנו מצרים על כך. נא לנסות שוב מאוחר יותר.';

  @override
  String get login => 'שם משתמש';

  @override
  String get login_result_type_server_unreachable => 'אין גישה לרשת';

  @override
  String get login_result_type_server_issue => 'תקלה בשרת. נא לנסות שוב בהמשך.';

  @override
  String get login_page_username_or_email => 'נא למלא שם משתמש או כתובת דוא״ל';

  @override
  String get login_page_password_error_empty => 'נא למלא סיסמה';

  @override
  String get create_account => 'יצירת חשבון';

  @override
  String get sign_in => 'כניסה';

  @override
  String get sign_in_mandatory => 'ליכולת הזאת עלינו לבקש ממך להיכנס.';

  @override
  String get help_improve_country => 'לסייע בשיפור Open Food Facts במדינה שלך';

  @override
  String get sign_out => 'יציאה';

  @override
  String get sign_out_confirmation => 'לצאת?';

  @override
  String get password => 'סיסמה';

  @override
  String get forgot_password => 'שכחתי סיסמה';

  @override
  String get forgot_password_question => 'שכחת סיסמה?';

  @override
  String get view_profile => 'הצגת פרופיל';

  @override
  String get reset_password => 'איפוס הסיסמה';

  @override
  String get reset_password_explanation_text =>
      'אם שכחת סיסמה, נא למלא את שם המשתמש או את כתובת הדוא״ל שלך כדי לקבל הנחיות לאיפוס הסיסמה. כמו כן, מוטב לזכור לבדוק בתיקיית הספאם.';

  @override
  String get username_or_email => 'שם משתמש או כתובת דוא״ל';

  @override
  String get reset_password_done =>
      'הודעה עם קישור לאיפוס הסיסמה שלך נשלחה לכתובת הדוא״ל שמשויכת לחשבון שלך. כמו כן, מומלץ לבדוק את תיקיית הספאם';

  @override
  String get send_reset_password_mail => 'החלפת סיסמה';

  @override
  String get enter_some_text => 'נא למלא טקסט כלשהו';

  @override
  String get sign_up_page_title => 'הרשמה';

  @override
  String get sign_up_page_action_button => 'הרשמה';

  @override
  String get sign_up_page_action_doing_it => 'מתבצעת הרשמה…';

  @override
  String get sign_up_page_action_ok => 'מזל טוב! החשבון שלך נוצר.';

  @override
  String get sign_up_page_display_name_hint => 'שם';

  @override
  String get sign_up_page_display_name_error_empty =>
      'נא למלא את שם התצוגה המיועד';

  @override
  String get sign_up_page_email_hint => 'דוא״ל';

  @override
  String get sign_up_page_email_error_empty => 'צריך דוא״ל';

  @override
  String get sign_up_page_email_error_invalid => 'דוא״ל שגוי';

  @override
  String get sign_up_page_username_hint => 'שם משתמש: גלוי לציבור';

  @override
  String get sign_up_page_username_error_empty => 'נא למלא שם משתמש';

  @override
  String get sign_up_page_username_error_invalid => 'נא למלא שם משתמש תקף';

  @override
  String get sign_up_page_username_description =>
      'שם המשתמש לא יכול להכיל רווחים, רישיות או תווים מיוחדים.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'אורך שם המשתמש לא יכול לעלות על $value תווים';
  }

  @override
  String get sign_up_page_password_hint => 'סיסמה';

  @override
  String get sign_up_page_password_error_empty => 'נא למלא סיסמה';

  @override
  String get sign_up_page_password_error_invalid =>
      'נא למלא סיסמה תקפה (6 תווים לפחות)';

  @override
  String get sign_up_page_confirm_password_hint => 'אימות סיסמה';

  @override
  String get sign_up_page_confirm_password_error_empty => 'נא לאשר את הסיסמה';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'הסיסמאות שונות זו מזו';

  @override
  String get sign_up_page_agree_text => 'אני מסכים ל־Open Food Facts';

  @override
  String get sign_up_page_terms_text =>
      'תנאי השימוש והתרומה של Open Food Facts';

  @override
  String get donate_url => 'https://world-he.openfoodfacts.org/donate';

  @override
  String get sign_up_page_agree_error_invalid =>
      'בעת יצירת חשבון, חובה להסכים לתנאי השימוש, עם זאת, עדיין ניתן לתרום בעילום שם דרך היישומון';

  @override
  String get sign_up_page_producer_checkbox => 'עיסוקי הוא ייצור מזון';

  @override
  String get sign_up_page_producer_hint => 'יצרן/מותג';

  @override
  String get sign_up_page_producer_error_empty => 'נא למלא יצרן או שם מותג';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'אשמח להירשם לקבוצת הדיוור של Open Food Facts (ניתן לצאת ממנה בכל רגע נתון)';

  @override
  String get sign_up_page_user_name_already_used =>
      'שם המשתמש כבר קיים, נא לבחור בשם משתמש אחר.';

  @override
  String get sign_up_page_email_already_exists =>
      'כבר קיים, יש להיכנס לחשבון או לנסות עם כתובת דוא״ל אחרת.';

  @override
  String get sign_up_page_provide_valid_email => 'נא לספק כתובת דוא״ל תקפה.';

  @override
  String get sign_up_page_server_busy =>
      'אנו מתנצלים מעומק הלב, נתקלנו בקשיים טכניים ביצירת החשבון שלך. נא לנסות שוב מאוחר יותר.';

  @override
  String get settingsTitle => 'הגדרות';

  @override
  String get darkmode => 'ערכת עיצוב';

  @override
  String get darkmode_dark => 'כהה';

  @override
  String get darkmode_light => 'בהיר';

  @override
  String get darkmode_system_default => 'ברירת המחדל של המערכת';

  @override
  String get thanks_for_contributing => 'תודה על תרומתך!';

  @override
  String get contributors_label => 'הם בונים את היישומון';

  @override
  String get contributors_dialog_title => 'תורמים';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'תרומה: $name';
  }

  @override
  String get contributors_description => 'רשימת התורמים ליישומון הזה';

  @override
  String get support => 'תמיכה';

  @override
  String get support_join_slack => 'ניתן לבקש עזרה בערוץ ה־Slack שלנו';

  @override
  String get support_via_forum => 'בקשת עזרה בפורום שלנו';

  @override
  String get support_via_email => 'לשלוח לנו דוא״ל';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'לשלוח את יומני היישום?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'לצרף את יומני היישום להודעת הדוא״ל שלך?';

  @override
  String get termsOfUse => 'תנאי שימוש';

  @override
  String get legalNotices => 'הודעות משפטיות';

  @override
  String get privacy_policy => 'מדיניות פרטיות';

  @override
  String get about_this_app => 'על היישומון הזה';

  @override
  String get contribute => 'לתרום';

  @override
  String get contribute_sw_development => 'פיתוח תוכנה';

  @override
  String get contribute_develop_text =>
      'הקוד של כל אחד ממוצרי Open Food Facts זמין ב־GitHub. אנו מזמינים אותך לגזור מהקוד הזה (הוא בקוד פתוח) ולסייע לשפר אותו, עבור כולם, בכל רחבי העולם.';

  @override
  String get contribute_develop_text_2 =>
      'ניתן להצטרף לחדר השיח של Open Food Facts ב־Slack שהיא הדרך המומלצת לשאול שאלות.';

  @override
  String get contribute_develop_dev_mode_title => 'מצב למפתחים?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'הפעלת המצב למפתחים';

  @override
  String get contribute_donate_title => 'תרומה';

  @override
  String get contribute_donate_header => 'תרומה ל־Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'נא להכיר בזה שעם גרסת האלפא הפנימית הנתונים שלך יכולים להימחק לחלוטין ושהיישומון עשוי להיות בלתי שמיש לעתים!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'מוצרים שדורשים השלמה';

  @override
  String get contribute_improve_header => 'שיפור';

  @override
  String get contribute_improve_text =>
      'מסד הנתונים הוא ליבת המיזם. פשוט וקל מאוד לסייע בשיפורו. ניתן להוריד את היישומון לטלפון שלך ולהתחיל להוסיף ולשפר מוצרים.\n\nמצד שני, האתר של Open Food Facts מציע מגוון דרכים לתרום: ';

  @override
  String get contribute_translate_header => 'תרגום';

  @override
  String get contribute_data_quality => 'איכות נתונים';

  @override
  String get contribute_translate_link_text => 'להתחיל לתרגם';

  @override
  String get contribute_translate_text =>
      '‏Open Food Facts הוא מיזם גלובלי שמכיל מוצרים מלמעלה מ־160 מדינות. Open Food Facts מתורגם לעשרות שפות עם תוכן שהולך ומצטבר.';

  @override
  String get contribute_translate_text_2 =>
      'תרגומים הם אחת ממשימות המפתח של המיזם';

  @override
  String get contribute_join_skill_pool =>
      'מזמינים אותך לתרום את הכישורים שלך ל־Open Food Facts. מאגר הכשרונות מחכה רק לך!';

  @override
  String get contribute_share_header => 'שיתוף Open Food Facts עם חברים';

  @override
  String get contribute_share_content =>
      'רציתי לספר לך על יישומון שמותקן אצלי. Open Food Facts, שמאפשר לקבל את ההשפעות הבריאותיות והסביבתיות של המזון שלך, בדרך מותאמת אישית. הוא עובד עם סריקת ברקודים על האריזה. בסופו של דבר זה בחינם ולא נדרשת הרשמה ואפשר גם לסייע להגדיר את מספר המוצרים המפוענחים. הנה הקישור להורדה והתקנה בטלפון: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'תרומת מחירים על ידי בקשת ייצוא תואם GDPR של נתוני כרטיסי המועדון שלך';

  @override
  String get tap_to_answer => 'יש לגעת כאן כדי לענות על שאלות';

  @override
  String get tap_to_answer_hint => 'נא לגעת כאן כדי לענות על שאלות בנוגע למוצר';

  @override
  String get robotoff_questions_loading_hint =>
      'נא להמתין לטעינת השאלות על המוצר';

  @override
  String get saving_answer => 'התשובה שלך נשמרת';

  @override
  String get contribute_to_get_rewards => 'לקחת חלק פעיל בשקיפות המזון';

  @override
  String get question_sign_in_text =>
      'כדאי להיכנס לחשבונך ב־Open Food Facts כדי לקבל הוקרה על התרומות שלך';

  @override
  String get question_yes_button_accessibility_value => 'לענות בכן';

  @override
  String get question_no_button_accessibility_value => 'לענות בלא';

  @override
  String get question_skip_button_accessibility_value => 'לדלג על השאלה הזאת';

  @override
  String get tap_to_edit_search => 'יש לגעת לעריכת החיפוש';

  @override
  String get myPreferences => 'ההעדפות שלי';

  @override
  String get account_create_message =>
      'מזמינים אותך ליצור חשבון ולהצטרף לקהילת Open Food Facts כדי לסייע בבניית מידע על מזון בכל רחבי העולם!';

  @override
  String get join_us => 'הצטרפות אלינו';

  @override
  String get myPreferences_profile_title => 'הפרופיל שלך';

  @override
  String get myPreferences_profile_subtitle =>
      'ניהול חשבון התרומה שלך ב־Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'הגדרות היישומון';

  @override
  String get myPreferences_settings_subtitle => 'מצב כהה, שפות…';

  @override
  String get myPreferences_food_title => 'העדפות מזון';

  @override
  String get myPreferences_food_subtitle =>
      'נא לבחור איזה מידע על מזון הכי חשוב לך.';

  @override
  String get myPreferences_food_comment =>
      'נא לבחור איזה מידע על מזון מעניין אותך, כדי לדרג מזון לפי העדפותיך, לראות את המידע שמעניין אותך תחילה ולקבל תקציר תאימות. העדפות המזון האלו נשארות במכשיר שלך ואינן משויכות לחשבון התרומה שלך ל־Open Food Facts, אם יש לך חשבון כזה.';

  @override
  String get confirmResetPreferences => 'לאפס את העדפות המזון שלך?';

  @override
  String get myPersonalizedRanking => 'הדירוג המותאם שלי';

  @override
  String get ranking_tab_all => 'הכול';

  @override
  String get ranking_subtitle_match_yes => 'מתאים לך היטב';

  @override
  String get ranking_subtitle_match_no => 'לא כל כך קשור אליך';

  @override
  String get ranking_subtitle_match_maybe => 'התאמה לא ידועה';

  @override
  String get refresh_with_new_preferences =>
      'לרענן את הרשימה עם ההעדפות החדשות שלך';

  @override
  String get reloaded_with_new_preferences => 'נטען מחדש עם ההעדפות החדשות שלך';

  @override
  String get profile_navbar_label => 'קהילה';

  @override
  String get scan_navbar_label => 'סריקה';

  @override
  String get history_navbar_label => 'היסטוריה';

  @override
  String get list_navbar_label => 'רשימות';

  @override
  String get category => 'סינון לפי קטגוריה';

  @override
  String get category_all => 'הכול';

  @override
  String get category_search => '(חיפוש לפי קטגוריות)';

  @override
  String get filter => 'סינון';

  @override
  String get scan => 'מוצרים ממסך הסריקה';

  @override
  String get scan_history => 'היסטוריית סריקה';

  @override
  String get search => 'חיפוש';

  @override
  String get search_product_help => 'חיפוש מוצר,\nמותג או ברקוד';

  @override
  String get search_filter => 'מסנן חיפוש';

  @override
  String get search_history => 'היסטוריית חיפוש';

  @override
  String get search_store => 'חיפוש חנות';

  @override
  String get search_store_help => 'רמז: כדאי להוסיף את העיר או המדינה';

  @override
  String get tap_for_more => 'מידע נוסף יופיע בנגיעה…';

  @override
  String get product => 'מוצר';

  @override
  String get unknownBrand => 'מותג לא ידוע';

  @override
  String get unknownProductName => 'שם המוצר אינו ידוע';

  @override
  String get label_refresh => 'רענון';

  @override
  String get label_reload => 'ריענון';

  @override
  String get image => 'תמונה';

  @override
  String get front_photo => 'תמונת חזית';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (לא בטוח שהתמונה עדכנית)';
  }

  @override
  String get outdated_image_short_label => 'עשוי להיות מיושן';

  @override
  String get ingredients => 'רכיבים';

  @override
  String get ingredients_editing_instructions =>
      'לשמור על הסדר המקורי. יש לציין את האחוזים כשהם מופיעים. להפריד בפסיקים או מינוסים, להשתמש בסוגריים ברכיבים של רכיב.';

  @override
  String get ingredients_editing_error => 'שמירת הרכיבים נכשלה.';

  @override
  String get ingredients_editing_image_error =>
      'קבלת תמונת הרכיבים החדשה נכשלה.';

  @override
  String get ingredients_editing_title => 'עריכת רכיבים';

  @override
  String get ingredients_photo => 'תמונת רכיבים';

  @override
  String get packaging_editing_instructions =>
      'הצגת כל חלקי האריזה מופרדים בפסיקים או ירידת שורה, בצירוף הכמות (למשל: 1 או 6), סוג (למשל: בקבוק, קופסה, פחית), חומר (למשל: פלסטיק, מתכת, אלומיניום) והגודל אם יש (למשל: 330 מ״ל) והנחיות מיחזור. למשל: בקבוק זכוכית 1 למיחזור, פקק פלסטיק אחד להשלכה';

  @override
  String get packaging_editing_error => 'שמירת האריזה נכשלה.';

  @override
  String get packaging_editing_image_error => 'משיכת תמונת האריזה החדשה נכשלה.';

  @override
  String get packaging_editing_title => 'עריכת אריזה';

  @override
  String get nutrition => 'תזונה';

  @override
  String get nutrition_facts_photo => 'תמונת פירוט תזונתי';

  @override
  String get nutrition_facts_editing_title => 'עריכת עובדות תזונתיות';

  @override
  String get packaging_information => 'פרטי אריזה';

  @override
  String get packaging_information_photo => 'תמונת פרטי אריזה';

  @override
  String get missing_product => 'מצאת מוצר חדש!';

  @override
  String get add_product_take_photos =>
      'יש לצלם את האריזה כדי להוסיף את המוצר הזה ל־Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'נא לצלם תחילה מספר תמונות. תמיד ניתן להשלים את המוצר בהמשך.';

  @override
  String get add_product_information_button_label => 'הוספת פרטי מוצר';

  @override
  String get new_product => 'מוצר חדש';

  @override
  String get new_product_found_title => 'נמצא מוצר חדש!';

  @override
  String get new_product_found_text =>
      'מסד הנתונים השיתופי שלנו מכיל למעלה מ־**3 מיליון מוצרים**, אבל הברקוד הזה לא קיים: ';

  @override
  String get new_product_found_button => 'הוספת המוצר הזה';

  @override
  String get new_product_leave_title => 'לעזוב את העמוד הזה?';

  @override
  String get new_product_leave_message =>
      'נראה כאילו לא מילאת כלום. לעזוב את העמוד הזה?';

  @override
  String get new_product_dialog_description =>
      'נא לצלם את האריזה כדי להוסיף \nאת המוצר הזה למסד הנתונים השיתופי שלנו';

  @override
  String get new_product_dialog_illustration_description =>
      'איור עם ציוני Nutri-Score ו־Green-Score לא ידועים';

  @override
  String get front_packaging_photo_button_label => 'תמונת החזית של המוצר';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'לאשר את העלאת תמונת החזית של המוצר';

  @override
  String get confirm_button_label => 'אישור';

  @override
  String get send_image_button_label => 'שליחת תמונה';

  @override
  String get crop_page_action_saving => 'התמונה נשמרת…';

  @override
  String get crop_page_action_cropping => 'התמונה נחתכת…';

  @override
  String get crop_page_action_local => 'גרסה מקומית נשמרת…';

  @override
  String get crop_page_action_local_failed_title =>
      'אבוי… יש איזה עניין עם התמונה שלך!';

  @override
  String get crop_page_action_local_failed_message =>
      'לא הצלחנו לעבד את התמונה מקומית, בטרם שליחתה לשרתינו. נא לנסות שוב מאוחר יותר או ליצור אתנו קשר אם התקלה נמשכת.';

  @override
  String get crop_page_action_retake => 'צילום תמונה מחדש';

  @override
  String get crop_page_too_small_image_title => 'התמונה קטנה מדי!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'הגודל המזערי בפיקסלים להעלאת תמונה הוא ‎$expectedMinWidth×$expectedMinHeight. גודל התמונה הנוכחית הוא ‎$actualWidth×$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'בהכנות לקריאה לשרת…';

  @override
  String get front_packaging_photo_title => 'תמונת חזית האריזה';

  @override
  String get ingredients_photo_title => 'תמונת רכיבים';

  @override
  String get nutritional_facts_photo_title => 'תמונת פירוט תזונתי';

  @override
  String get recycling_photo_title => 'תמונת מיחזור';

  @override
  String get take_photo_title => 'צילום תמונה';

  @override
  String get take_more_photo_title => 'צילום תמונות נוספות';

  @override
  String get front_photo_uploaded => 'תמונת החזית נשלחה';

  @override
  String get ingredients_photo_button_label => 'תמונת רכיבים';

  @override
  String get ingredients_photo_uploaded => 'תמונת הרכיבים נשלחה';

  @override
  String get nutrition_cache_loading_error =>
      'לא ניתן לטעון חומרי הזנה מהמטמון';

  @override
  String get nutritional_facts_photo_button_label => 'תמונת פירוט תזונתי';

  @override
  String get nutritional_facts_input_button_label => 'מילוי העובדות התזונתיות';

  @override
  String get nutritional_facts_added => 'נוספות עובדות תזונתיות';

  @override
  String get categories_added => 'נוספו קטגוריות';

  @override
  String get new_product_title_nutriscore => 'חישוב ה־Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'אפשר לגלות אותו על ידי מילוי קטגוריית המזון והערכים התזונתיים';

  @override
  String get new_product_title_environmental_score => 'חישוב ה־Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'אפשר לגלות את זה על ידי מילוי הקטגוריה לכל הפחות';

  @override
  String get new_product_additional_environmental_score =>
      'אפשר לשפר את דיוק חישוב ה־Green-Score על ידי הוספה של מקורות, אריזות ועוד';

  @override
  String get new_product_title_nova => 'חישוב רמת עיבוד המזון (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'אפשר לגלות אותו על ידי מילוי קטגוריית המזון והרכיבים';

  @override
  String get new_product_desc_nova_unknown => 'רמת עיבוד המזון אינה ידועה';

  @override
  String get new_product_title_pictures => 'בואו נצלם קצת!';

  @override
  String get new_product_title_pictures_details =>
      'נא לצלם את התמונות הבאות והמנוע של Open Food Facts ידאג לשאר!';

  @override
  String get new_product_title_misc => 'וכמה נתונים בסיסיים…';

  @override
  String new_product_done_msg(String username) {
    return 'תודה „$username” על תרומתך!';
  }

  @override
  String get new_product_done_msg_no_user => 'תודה על תרומתך!';

  @override
  String get new_product_done_button_label => 'הנה המוצר השלם';

  @override
  String get hey_incomplete_product_message =>
      'נא לגעת כאן כדי לענות על 3 שאלות כעת ולחשב את ה־Nutri-Score,‏ Green-Score ואולטרא עיבוד (NOVA) כעת!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'נא לגעת כדי לענות על 2 שאלות כדי לסייע בניתוח מוצר הטיפוח הזה!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'נא לגעת כדי לענות על 3 שאלות כדי לסייע בניתוח מוצר המזון לחיות מחמד הזה!';

  @override
  String get hey_incomplete_product_message_product =>
      'נא לגעת כדי לסייע בהשלמת המוצר הזה!';

  @override
  String get nutritional_facts_photo_uploaded => 'תמונת הפירוט התזונתי נשלחה';

  @override
  String get recycling_photo_button_label => 'תמונת פרטי המיחזור';

  @override
  String get recycling_photo_uploaded => 'תמונת המיחזור נשלחה';

  @override
  String get take_more_photo_button_label => 'צילום תמונות נוספות';

  @override
  String get other_photo_uploaded => 'תמונה אחרת נשלחה';

  @override
  String get retake_photo_button_label => 'לצלם מחדש';

  @override
  String get selecting_photo => 'בחירת תמונה';

  @override
  String get uploading_image => 'התמונה נשלחת לשרת';

  @override
  String get uploading_image_type_front =>
      'תמונת החזית נשלחת ל־Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'תמונת הרכיבים נשלחת ל־Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'תמונת הערכים התזונתיים נשלחת ל־Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'תמונת האריזה נשלחת ל־Open Food Facts';

  @override
  String get uploading_image_type_other => 'תמונה אחרת נשלחת ל־Open Food Facts';

  @override
  String get uploading_image_type_generic => 'תמונה נשלחת ל־Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'הוספת רכיבים חסרים';

  @override
  String get score_add_missing_packaging_image => 'הוספת תמונת אריזה חסרה';

  @override
  String get score_add_missing_nutrition_facts => 'הוספת עובדות תזונתיות חסרות';

  @override
  String get score_add_missing_product_traces => 'הוספת עקבות חסרים למוצר';

  @override
  String get score_add_missing_product_category => 'הוספת קטגוריית מוצר חסרה';

  @override
  String get score_add_missing_precise_product_category =>
      'נא לבחור קטגוריה מדויקת יותר';

  @override
  String get score_add_missing_product_countries => 'הוספת מדינות מוצר חסרות';

  @override
  String get score_add_missing_product_emb => 'הוספת קודים למעקב חסרים של מוצר';

  @override
  String get score_add_missing_product_labels => 'הוספת תוויות מוצר חסרות';

  @override
  String get score_add_missing_product_origins => 'הוספת מקורות מוצר חסרים';

  @override
  String get score_add_missing_product_stores => 'הוספת חנויות מוצר חסרות';

  @override
  String get score_add_missing_product_brands => 'הוספת מותגי מוצרים חסרים';

  @override
  String get score_update_nutrition_facts => 'עדכון העובדות התזונתיות';

  @override
  String get nutrition_page_title => 'מפרט תזונתי';

  @override
  String get nutrition_page_nutritional_info_title => 'פירוט תזונתי';

  @override
  String get nutrition_page_nutritional_info_label =>
      'ערכים שמצוינים על המוצר:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'כן';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'לא';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'פתיחת תמונה';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Good practices: Nutritional information';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Sometimes nutrition facts are **not specified on the packaging** or on a document given with the product. In this case, and only in this case, you can set the value to **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'ערכים תזונתיים:';

  @override
  String get nutrition_page_per_100g => 'ל־100 ג׳';

  @override
  String get nutrition_page_per_100g_100ml => 'ל־100 ג׳/מ״ל';

  @override
  String get nutrition_page_per_serving => 'לכל הגשה';

  @override
  String get nutrition_page_add_nutrient => 'הוספת רכיב תזונתי';

  @override
  String get nutrition_page_serving_size => 'גודל ההגשה';

  @override
  String get nutrition_page_serving_size_hint =>
      'נא למלא גודל מנה (למשל: 100 גרם)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Good practices: Serving size';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'This value helps to **make a proportional calculation of each nutrient per serving size**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Allowed units** are: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** or **60 G** (prefer the first one)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** or **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'יחידה שגויה';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'יחידות שגויות';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **סוכריות** ו־2 **ביסקוויטים**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'חסרה יחידה';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'מספר שגוי';

  @override
  String get nutrition_page_update_running => 'המוצר מתעדכן בשרת…';

  @override
  String get nutrition_page_update_done => 'המוצר עודכן!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'להשתמש בכמות המוצר כגודל מנה';

  @override
  String get nutrition_page_photo_error => 'לא ניתן לטעון את התמונה';

  @override
  String get more_photos => 'תמונות מעניינות נוספות';

  @override
  String get view_more_photo_button => 'הצגת כל התמונות הקיימות עבור מוצר זה';

  @override
  String get no_product_found => 'לא נמצאו מוצרים';

  @override
  String get no_location_found => 'לא נמצא מקום';

  @override
  String get not_found => 'לא נמצאו:';

  @override
  String get refreshing_product => 'המוצר מתרענן';

  @override
  String get product_refreshed => 'המוצר התרענן';

  @override
  String product_image_accessibility_label(String date) {
    return 'התמונה צולמה ב־$date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'התמונה צולמה ב־$date. היא כנראה לא עדכנית';
  }

  @override
  String get product_image_outdated => 'יכול להיות שהתמונה הזאת לא עדכנית';

  @override
  String get product_image_outdated_explanations_title =>
      'יכול להיות שהתמונה הזאת לא עדכנית';

  @override
  String get product_image_outdated_explanations_content =>
      'התמונה הזאת צולמה לפני יותר משנה.\n**נא לבדוק שהיא עדיין עדכנית**.\n\nזוהי **רק אזהרה**. אם התוכן עדיין זהה, אפשר להתעלם מההודעה הזאת.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'החלפת התמונה ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'הוספת תמונה ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'לצלם חדשה';

  @override
  String get product_image_action_take_picture => 'צילום תמונה';

  @override
  String get product_image_action_from_gallery =>
      'נא לבחור מהגלריה של הטלפון שלך';

  @override
  String get product_image_action_choose_existing_photo =>
      'בחירת מתמונות המוצר';

  @override
  String get product_image_details_label => 'מידע על התמונה';

  @override
  String get product_image_details_from_producer => 'מהיצרן';

  @override
  String get product_image_details_contributor => 'תרומה';

  @override
  String get product_image_details_contributor_producer => 'מתנדב (יצרן)';

  @override
  String get product_image_details_date => 'תאריך';

  @override
  String get product_image_details_date_unknown => 'לא ידוע';

  @override
  String get homepage_main_card_logo_description =>
      'ברוך בואך ל־Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      'ניתן **לסרוק** ברקוד או\n**לחפש** מוצר';

  @override
  String get homepage_main_card_search_field_hint => 'חיפוש מוצר';

  @override
  String get homepage_main_card_search_field_tooltip => 'התחלת חיפוש';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'חדשות עדכניות: $news_title';
  }

  @override
  String get tagline_app_review => 'איך היישומון שלנו?';

  @override
  String get tagline_app_review_button_positive => 'הוא מעולה! 😍';

  @override
  String get tagline_app_review_button_negative => 'ככה ככה…';

  @override
  String get tagline_app_review_button_later => 'אחר כך';

  @override
  String get tagline_feed_news_button => 'מידע נוסף';

  @override
  String get app_review_negative_modal_title => 'לא אהבת את היישומון שלנו?';

  @override
  String get app_review_negative_modal_text =>
      'נוכל לבקש ממך להקדיש מספר שניות ולספר לנו למה?';

  @override
  String get app_review_negative_modal_positive_button => 'כן, כמובן!';

  @override
  String get app_review_negative_modal_negative_button => 'לא';

  @override
  String get could_not_refresh => 'לא ניתן לרענן את המוצר';

  @override
  String get product_internet_error_modal_title => 'אירעה שגיאה!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'לא הצלחנו למשוך מידע על המוצר הזה עקב תקלת רשת. נא לבדוק שהחיבור לאינטרנט תקין ולנסות שוב.\n\nשגיאה פנימית:\n$error';
  }

  @override
  String get product_tags_title => 'מאפייני מוצר';

  @override
  String get no_product_tags_found_message =>
      'לא נמצאו מאפייני מוצר. אפשר להשתמש במאפיינים כדי לתאר את המוצרים בפירוט נוסף, בצורה גמישה. לחיצה להוספה.';

  @override
  String get product_tags_empty => 'אין נכסים';

  @override
  String get product_tags_explanation =>
      'על ידי הוספת מאפיינים (מפתח/ערך) למוצר, אתם עוזרים להעשיר אותו.';

  @override
  String get add_tag => 'הוספת מאפיין';

  @override
  String get add_tags => 'הוספת מאפיינים';

  @override
  String get add_edit_tags => 'הוספת או עריכת מאפיינים';

  @override
  String get edit_tag => 'עריכת מאפיין';

  @override
  String get remove_tag => 'הסרת מאפיין';

  @override
  String get tag_key => 'מאפיין';

  @override
  String get tag_keys => 'נכסים';

  @override
  String get tag_key_uneditable => 'מאפיין (נעול)';

  @override
  String get tag_key_input_hint => 'נא למלא מאפיין';

  @override
  String get tag_value => 'ערך';

  @override
  String get tag_values => 'ערכים';

  @override
  String get tag_value_input_hint => 'נא למלא ערך';

  @override
  String get tag_key_item => 'מאפיין:';

  @override
  String get tag_value_item => 'ערך:';

  @override
  String get tag_key_explanations =>
      'מפתח חייב להיות באותיות קטנות וללא רווחים כלל.';

  @override
  String tag_key_already_exists(String property) {
    return 'כבר קיימת תגית עם המאפיין $property!';
  }

  @override
  String get product_internet_error =>
      'לא ניתן למשוך מידע על המוצר הזה עקב שגיאת רשת.';

  @override
  String get cached_results_from => 'להציג תוצאות מ־:';

  @override
  String get product_search_same_category => 'מצא חלופות';

  @override
  String get product_search_same_category_short => 'השוואה';

  @override
  String get product_search_same_category_error =>
      'אפשר להשתמש ביכולת הזאת רק למוצרים עם קטגוריה.';

  @override
  String get product_improvement_add_category =>
      'יש להוסיף קטגוריה כדי לחשב את ה־Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'יש להוסיף מפרט תזונתי כדי לחשב את ה־Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'יש להוסיף עובדות תזונתיות וקטגוריה כדי לחשב את ה־Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'לא ניתן לחשב את ה־Nutri-Score למוצר הזה, שעלול להיות עקב קטגוריה חריגה למשל. אם זאת נחשבת שגיאה, נא ליצור אתנו קשר.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'התמונה התזונתית מיושנת: נא לרענן אותה.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'ציון Green-Score מתחשב במקורות הרכיבים. נא לצלם את רשימת הרכיבים ו/או טענה גאוגרפית כלשהי או לערוך את המוצר, כדי שאפשר יהיה לקחת אותם בחשבון.';

  @override
  String get country_chooser_label => 'נא לבחור מדינה';

  @override
  String get currency_chooser_label => 'נא לבחור מטבע';

  @override
  String get country_change_message => 'הרגע החלפת בין מדינות.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'להחליף מהמטבע $previousCurrency למטבע $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'נא לבחור מדינה:';

  @override
  String get country_chooser_label_from_settings => 'המדינה שלך';

  @override
  String get country_selection_explanation =>
      'חלק מהמאפיינים הסביבתיים הם נקודתיים למיקום';

  @override
  String get product_removed_comparison => 'המוצר הוסר מההשוואה';

  @override
  String get native_app_settings => 'הגדרות יישומון טבעי';

  @override
  String get native_app_description =>
      'פתיחת הגדרות המערכת עבור Open Food Facts';

  @override
  String get product_removed_history => 'המוצר הוסר מההיסטוריה';

  @override
  String get product_removed_list => 'המוצר הוסר מהרשימה';

  @override
  String get product_could_not_remove => 'לא ניתן להסיר מוצר';

  @override
  String get no_prodcut_in_list => 'אין מוצרים ברשימה הזאת';

  @override
  String get no_product_in_section => 'אין מוצרים בסעיף זה';

  @override
  String get recently_seen_products => 'כל המוצרים שנצפו';

  @override
  String get clear => 'פינוי';

  @override
  String get clear_long => 'פינוי הרשימה';

  @override
  String get really_clear => 'למחוק את הרשימה הזאת?';

  @override
  String pct_match(Object percent) {
    return '‎$percent%‎ התאמה';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ימים',
      one: 'יום',
      many: '$count ימים',
      two: 'יומיים',
    );
    return 'לפני $_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count שעות',
      one: 'שעה',
      many: '$count שעות',
      two: 'שעתיים',
    );
    return 'לפני $_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count דקות',
      one: 'דקה',
      zero: 'פחות מדקה',
      many: '$count דקות',
      two: '$count דקות',
    );
    return 'לפני $_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count חודשים',
      one: 'חודש',
      many: '$count חודשים',
      two: 'חודשיים',
    );
    return 'לפני $_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count שבועות',
      one: 'שבוע',
      many: '$count weeks ago',
      two: 'שבועיים',
    );
    return 'לפני $_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'השוואה בין $count מוצרים',
      one: 'השוואת מוצר אחד',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count מוצרים נבחרו',
      one: 'נבחר מוצר',
      zero: 'לא נבחרו מוצרים',
      many: '$count מוצרים נבחרו',
      two: '$count מוצרים נבחרו',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'השוואת המוצרים הנבחרים';

  @override
  String get delete_products_mode => 'מחיקת המוצרים הנבחרים';

  @override
  String get select_all_products_mode => 'בחירת כל המוצרים';

  @override
  String get select_none_products_mode => 'ביטול בחירה';

  @override
  String get compare_products_appbar_title => 'השוואת מוצרים';

  @override
  String get compare_products_appbar_subtitle => 'נא לבחור שני מוצרים לפחות';

  @override
  String get retry_button_label => 'ניסיון חוזר';

  @override
  String get connect_with_us => 'להתחבר אלינו';

  @override
  String get tiktok => 'לעקוב אחרינו בטיקטוק';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'למעקב אחרינו באינסטגרם';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'למעקב אחרינו ב־X (לשעבר טוויטר)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'לעקוב אחרינו במסטודון';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'לעקוב אחרינו ב־BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'בלוג';

  @override
  String get faq => 'שו״ת';

  @override
  String get discover => 'לגלות';

  @override
  String get how_to_contribute => 'כיצד לתרום';

  @override
  String get hint_knowledge_panel_message =>
      'ניתן לחלק בכל אחד מחלקי הכרטיס לקבלת פרטים נוספים על מה שמופיע. כדאי לנסות!';

  @override
  String get permissions_page_title => 'גישה למצלמה';

  @override
  String get permissions_page_body1 =>
      'כדי לסרוק ברקודים עם מצלמת הטלפון שלך, נא לאשר את הגישה.';

  @override
  String get permissions_page_body2 =>
      'אפשר להפעיל או להשבית את האפשרות הזאת דרך ההגדרות במקרה של חרטה.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'מערכת הפעלה: Android (SDK Int: $sdkInt / מהדורה: $release)\nדגם: $model\nמוצר: $product\nמכשיר: $device\nמותג: $brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'מערכת הפעלה: iOS ($version)\nדגם: $model\nדגם מתורגם: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nגרסת יישומון:$appVersion\nמספר בניית יישומון:$appBuildNumber\nשם חבילת יישומון:$appPackageName';
  }

  @override
  String get authorize_button_label => 'אישור';

  @override
  String get refuse_button_label => 'סירוב';

  @override
  String get ask_me_later_button_label => 'אחר כך';

  @override
  String get are_you_sure => 'להמשיך?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'להמשיך ב־$sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'ברוך בואך!';

  @override
  String get onboarding_home_welcome_text2 =>
      'היישומון שמסייע לך לבחור מזון שטוב **לך** ול**כדור הארץ**!';

  @override
  String get onboarding_continue_button => 'להמשיך';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'מוצר ההדגמה הראשוני שלך נטען';

  @override
  String get onboarding_welcome_warning =>
      'סליחה, זה מוצר לדוגמה שלנו, אינך יכול לערוך אותו :)';

  @override
  String get product_list_your_ranking => 'הדירוג שלך';

  @override
  String get product_list_empty_icon_desc => 'ההיסטוריה לא זמינה';

  @override
  String get product_list_empty_title => 'התחלה בסריקה';

  @override
  String get product_list_empty_message =>
      'המוצרים הנסרקים מופיעים כאן וניתן לצפות בפירוט עליהם';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'מוצרים מתרעננים',
      one: 'מוצר מתרענן',
      zero: 'מוצרים מתרענים',
      many: 'מוצרים מתרעננים',
      two: 'מוצרים מתרעננים',
    );
    return '$_temp0 בהיסטוריה שלך';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'מוצרים',
      one: 'מוצר',
      zero: 'מוצר',
      many: 'מוצרים',
      two: 'מוצרים',
    );
    return 'רענון ה$_temp0 הושלם';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'הנתונים מתקבלים';

  @override
  String get loading_dialog_default_error_message => 'לא ניתן להוריד נתונים';

  @override
  String get account_delete => 'מחיקת חשבון';

  @override
  String get account_delete_title => 'למחוק את החשבון שלי';

  @override
  String get user_profile => 'חשבון';

  @override
  String get user_profile_title_guest => 'ברוך בואך!';

  @override
  String get user_profile_subtitle_guest =>
      'יש להיכנס או להירשם כדי להצטרף ל־Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'כניסה ל־Open Food Facts‏: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'ברוך בואך $id!';
  }

  @override
  String get email_subject_account_deletion => 'מחיקת חשבון';

  @override
  String email_body_account_deletion(String userId) {
    return 'היי, נא למחוק את החשבון שלי ב־Open Food Facts‏: $userId';
  }

  @override
  String get settings_app_app => 'יישום';

  @override
  String get settings_app_data => 'פרטיות וניטור';

  @override
  String get settings_app_camera => 'מצלמה';

  @override
  String get settings_app_products => 'מוצרים';

  @override
  String get settings_app_miscellaneous => 'שונות';

  @override
  String get camera_play_sound_title => 'השמעת צליל בסריקה';

  @override
  String get camera_play_sound_subtitle => 'יצפצף עם כל סריקה מוצלחת';

  @override
  String get camera_window_accessibility_label => 'סריקת ברקוד עם המצלמה שלך';

  @override
  String get app_haptic_feedback_title => 'רטט ומשוב פיזי';

  @override
  String get app_haptic_feedback_subtitle =>
      'רטט לאחר ביצוע של פעולות מסוימות (פענוח ברקוד, הסרת מוצר…).';

  @override
  String get crash_reporting_toggle_title => 'דיווח על קריסות';

  @override
  String get crash_reporting_toggle_subtitle =>
      'כשהאפשרות פעילה, דוחות קריסה מוגשות אוטומטית למערכת מעקב השגיאות של Open Food Facts, כדי שניתן יהיה לתקן תקלות ובכך לשפר את היישומון.';

  @override
  String get send_anonymous_data_toggle_title => 'שליחת נתונים אלמוניים';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'כאשר האפשרות פעילה, יישלח מידע אלמוני כלשהו בנוגע ליישומון אל השרתים של Open Food Facts כדי שנוכל להבין איך וכמה תכונות נמצאות בשימוש כדי לשפר אותן.';

  @override
  String get product_edit_photo_title => 'עריכת תמונה';

  @override
  String get permission_photo_error => 'שגיאה';

  @override
  String get permission_photo_denied_title => 'לאפשר למצלמה לסרוק ברקודים';

  @override
  String permission_photo_denied_message(String appName) {
    return 'לשיפור החוויה, נא לאפשר ל־$appName לגשת למצלמה שלך. תהיה לך אפשרות לסרוק ברקודים ישירות.';
  }

  @override
  String get permission_photo_denied_button => 'לאפשר';

  @override
  String get permission_photo_denied_dialog_settings_title => 'ההרשאה נדחתה';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'כיוון שדחית את הרשאת המצלמה, יהיה עליך לאפשר אותה ידנית דרך ההגדרות.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'פתיחת הגדרות';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'ביטול';

  @override
  String get permission_photo_none_found => 'לא זוהתה מצלמה';

  @override
  String get permission_photo_denied => 'הגישה למצלמה לא אושרה';

  @override
  String get show_product_pictures => 'הצגת תמונות המוצר';

  @override
  String get edit_product_label => 'עריכת מוצר';

  @override
  String get edit_product_pending_operations_banner_title =>
      'העריכות שלך נשלחות…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'העריכות שלך **נשלחות ברקע** (או בהמשך אם לא מתאפשר).\nאפשר להמשיך לערוך שדות מוצר אחרים.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'העריכות שלך **נשלחות ברקע** (או בהמשך אם יש שגיאה).';

  @override
  String get edit_product_label_short => 'עריכה';

  @override
  String edit_product_form_item_help(String value) {
    return 'איך למלא „$value”?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'נא למלא ערך ולא להשאיר ריק!';

  @override
  String get edit_product_form_item_error_existing =>
      'הערך הזה כבר נמצא במקום!';

  @override
  String get edit_product_form_item_add_action_brand => 'הוספת מותג חדש';

  @override
  String get edit_product_form_item_add_action_label => 'הוספת תווית חדשה';

  @override
  String get edit_product_form_item_add_action_store => 'הוספת חנות חדשה';

  @override
  String get edit_product_form_item_add_action_origin => 'הוספת מקור חדש';

  @override
  String get edit_product_form_item_add_action_emb_code => 'הוספת קוד מעקב חדש';

  @override
  String get edit_product_form_item_add_action_country => 'הוספת ארץ חדשה';

  @override
  String get edit_product_form_item_add_action_category => 'הוספת קטגוריה חדשה';

  @override
  String get edit_product_form_item_add_action_trace => 'הוספת עקבות חדשים';

  @override
  String get edit_product_form_item_add_suggestion => 'הוספת הצעה';

  @override
  String get edit_product_form_item_deny_suggestion => 'דחיית ההצעה';

  @override
  String get edit_product_form_item_details_title => 'פרטים בסיסיים';

  @override
  String get edit_product_form_item_details_subtitle => 'שם, מותג, כמות המוצר';

  @override
  String get edit_product_form_item_other_details_title => 'פרטים נוספים';

  @override
  String get edit_product_form_item_other_details_subtitle => 'אתר…';

  @override
  String get edit_product_form_item_photos_title => 'תמונות';

  @override
  String get edit_product_form_item_photos_subtitle => 'הוספה או רענון תמונות';

  @override
  String get edit_product_form_item_labels_title => 'תוויות ואישורים';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'תוויות איכות סביבה, איכות מוצר…';

  @override
  String get edit_product_form_item_labels_hint =>
      'נא למלא תווית (למשל: חי בריא)';

  @override
  String get edit_product_form_item_labels_type => 'תווית';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Good practices: Labels';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Any characteristic of the product **which is factual** and different from the other fields.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Made in Belgium, produced in Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001,‏ ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'עשיר בסיבים, מקור לברזל…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'חי בריא, Vegan Friendly…';

  @override
  String get edit_product_form_item_stores_title => 'חנויות';

  @override
  String get edit_product_form_item_stores_hint => 'נא למלא חנות';

  @override
  String get edit_product_form_item_stores_type => 'חנות';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Good practices: Stores';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'נא למלא את החנות בה רכשת את המוצר.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'שופרסל';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'טיב טעם';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'שפע יששכר';

  @override
  String get edit_product_form_item_origins_title => 'מקורות';

  @override
  String get edit_product_form_item_origins_hint =>
      'נא למלא מקור (למשל: ישראל)';

  @override
  String get edit_product_form_item_origins_type => 'מדינה';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Good practices: Origins';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'יש להוסיף **כל סימון שיכול להעיד על מקורות שניתן למצוא על האריזה**. אין חשש ממקורות של רכיבים שמצוינים ישירות ברשימת הרכיבים.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'בשר בקר מארגנטינה';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'מקורה של הסויה הוא לא מהאיחוד האירופי';

  @override
  String get edit_product_form_item_countries_title => 'מדינה';

  @override
  String get edit_product_form_item_countries_hint =>
      'נא למלא מדינה (למשל: ישראל)';

  @override
  String get edit_product_form_item_countries_type => 'מדינה';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Good practices: Countries';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**מדיניות שבהן המוצר זמין לקהל הרחב** (לא כולל חנויות שמתמחות במוצרים זרים).';

  @override
  String get edit_product_form_item_emb_codes_title => 'קודים למעקב';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'נא למלא קוד (למשל: ‎EMB 53062,‏ FR 62.448.034 CE,‏ 84 R 20,‏ 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'קוד מעקב';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Good practices: Traceability codes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In this section, you can input codes related to **packaging marks**, **identification marks** or **health marks**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Examples of traceability codes';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC codes** used in the European Community to identify food producers or packagers:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: country code of **France**\n**72.264.002**: geographic data\n**CE**: European Community';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB codes** used in France:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'עקבות';

  @override
  String get edit_product_form_item_traces_hint => 'עקבות';

  @override
  String get edit_product_form_item_traces_type =>
      'נא למלא עקבות (למשל: פולי סויה)';

  @override
  String get edit_product_form_item_categories_title => 'קטגוריות';

  @override
  String get edit_product_form_item_categories_hint => 'קטגוריה';

  @override
  String get edit_product_form_item_categories_type =>
      'נא למלא קטגוריה (למשל: זיתים)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Good practices: Categories';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicate **only the most specific category**.\nParent categories will be automatically added.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'חסרה קטגוריה?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'In case a category is **not available in autocomplete**, feel free to add it anyway.\nThis will help us improve Open Food Facts in your country.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'סרדינים בשמן זית';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'מיץ תפוזים מתרכיז';

  @override
  String get edit_product_form_item_exit_title => 'לצאת בלי לשמור?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'לשמור את השינויים שלך בטרם יציאה מהעמוד הזה?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'שמירת שינויים';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'התעלמות מהשינויים';

  @override
  String get edit_product_form_item_ingredients_title => 'רכיבים';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'אפשר להתקרב ולהתרחק על ידי צביטת המסך';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'התקרבות והתרחקות אל התמונה וממנה';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'בעזרת **מחוות צביטה**, אפשר להתקרב או להתרחק אל התמונה או ממנה:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'הוספה';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'נא למלא טקסט תחילה';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'הסרה';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'שמירת העריכה שלך';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'ביטול העריכה שלך';

  @override
  String get edit_product_form_item_packaging_title => 'תמונת הנחיות מיחזור';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'מפרט תזונתי';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'תזונה, הרכב אלכוהול…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Good practices: Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'ערכים תזונתיים';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'קודם כל, יש לציין האם **הערכים צוינו**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'מפרט תזונתי';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Then, input the nutritional values **as indicated on the packaging**. If there is no value, you can click on the \"Eye\" icon.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'חסר שדה?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'If an entry is missing, you can **click on the \"Plus\" icon** to add it (eg: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'עריכה';

  @override
  String get edit_product_ingredients_photo_title => 'תמונת רכיבים';

  @override
  String get edit_product_ingredients_list_title => 'רשימת מרכיבים';

  @override
  String get edit_product_packaging_photo_title => 'תמונת אריזה';

  @override
  String get edit_product_packaging_list_title => 'רשימת אריזה';

  @override
  String get no_data_available => 'אין נתונים זמינים';

  @override
  String get product_field_website_title => 'אתר';

  @override
  String get origins_editing_title => 'עריכת מקורות';

  @override
  String get completed_basic_details_btn_text => 'השלמת הפרטים הבסיסיים';

  @override
  String get not_implemented_snackbar_text => 'לא מיושם עדיין';

  @override
  String get category_picker_page_appbar_text => 'קטגוריות';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'חילוץ רכיבים מהתמונה';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'חילוץ רכיבים';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'רכיבים מחולצים מהתמונה';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'התמונה נטענת…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'למה ההודעה הזאת מופיעה?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'כדי להשתמש ביכולת „חילוץ רכיבים”, קודם יש להעלות את התמונה. \n\nנא להמתין מספר שניות או למלא אותם ידנית.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'רענון תמונה';

  @override
  String get edit_packaging_extract_btn_text => 'חילוץ נתוני האריזה\nמהתמונה';

  @override
  String get edit_packaging_extract_btn_text_short => 'חילוץ אריזה';

  @override
  String get edit_packaging_extracting_btn_text =>
      'נתוני האריזה מחולצים מהתמונה';

  @override
  String get edit_packaging_loading_photo_btn_text => 'התמונה נטענת…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'למה ההודעה הזאת מופיעה?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'כדי להשתמש ביכולת „חילוץ אריזה”, קודם יש להעלות את התמונה. \n\nנא להמתין מספר שניות או למלא אותם ידנית.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'רענון תמונה';

  @override
  String get edit_ocr_extract_failed => 'זיהוי טקסט בתמונה נכשל.';

  @override
  String get edit_ocr_extract_disabled_title => 'אין תמונה!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'כדי להשתמש ביכולת חילוץ הטקסט, יש לצלם תחילה.';

  @override
  String get user_list_dialog_new_title => 'רשימת מוצרים חדשה';

  @override
  String get user_list_dialog_rename_title => 'שינוי שם רשימה';

  @override
  String get user_list_subtitle_product => 'רשימות';

  @override
  String get user_list_title => 'הרשימות שלך';

  @override
  String get user_list_add_product => 'הוספת המוצר לרשימות שלך';

  @override
  String get user_list_button_new => 'יצירת רשימה חדשה';

  @override
  String get user_list_empty_label =>
      'אין עדיין רשימות זמינות, עדיף ליצור אחת בתור התחלה';

  @override
  String get user_list_button_add_product => 'הוספה לרשימה';

  @override
  String get added_to_list_msg => 'נוסף לרשימה';

  @override
  String get user_list_popup_clear => 'מחיקת ההיסטוריה שלך';

  @override
  String get user_list_popup_rename => 'שינוי שם';

  @override
  String get user_list_name_hint => 'הרשימה שלי';

  @override
  String get user_list_name_error_empty => 'השם הוא חובה';

  @override
  String get user_list_name_error_already => 'השם הזה כבר בשימוש';

  @override
  String get user_list_name_error_same => 'זה אותו השם';

  @override
  String get user_list_name_input_hint => 'שם הרשימה';

  @override
  String get try_again => 'לנסות שוב';

  @override
  String get there_was_an_error => 'אירעה שגיאה';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'לא נמצאה קטגוריה עבור $items';
  }

  @override
  String get camera_toggle_camera => 'החלפה בין המצלמה האחורית לקדמית';

  @override
  String get camera_toggle_flash => 'כיבוי או הפעלה של מבזק המצלמה';

  @override
  String get camera_enable_flash => 'הפעלת מבזק';

  @override
  String get camera_disable_flash => 'השבתת מבזק';

  @override
  String get camera_flash_error_dialog_title => 'אירעה שגיאה!';

  @override
  String get camera_flash_error_dialog_message =>
      'אירעה שגיאה בשינוי מצב המבזק שלך. נא לוודא שהפנס במכשיר שלך לא פועל כבר.';

  @override
  String get category_picker_no_category_found_button => 'חזרה';

  @override
  String get user_preferences_item_accessibility_hint =>
      'לחיצה תפתח בדפדפן שלך או ביישומון (אם מותקן)';

  @override
  String get dev_preferences_screen_title => 'מצב פיתוח';

  @override
  String get dev_preferences_screen_subtitle =>
      'גישה לתכונות ניסיוניות וכלי פיתוח';

  @override
  String get dev_preferences_reset_onboarding_title => 'הפעלת תהליך קליטה מחדש';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'לאחר מכן יהיה עליך להפעיל את היישומון מחדש כדי לראות זאת שוב.';

  @override
  String get dev_preferences_environment_switch_title =>
      'החלפה בין openfoodfacts.org (הסביבה המבצעית) לבין סביבת הבדיקות';

  @override
  String get dev_preferences_test_environment_title => 'בדיקת משתני הסביבה';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'כתובת בסיס לסביבת הבדיקות הנוכחית: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'בדיקת מארח הסביבה';

  @override
  String get dev_preferences_ml_kit_title => 'להשתמש ב־ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'אז יהיה עליך להפעיל את היישומון הזה מחדש';

  @override
  String get dev_preferences_product_additional_features_title =>
      'כפתור נוסף בעמוד המוצר';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'עריכת הרכיבים דרך כפתור לוח ידע';

  @override
  String get dev_preferences_export_history_title => 'ייצוא היסטוריה';

  @override
  String get dev_preferences_export_history_progress_error => 'חריגה';

  @override
  String get dev_preferences_export_history_progress_found => 'המוצר נמצא';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'המוצר לא נמצא';

  @override
  String get dev_preferences_export_history_dialog_title => 'ייצוא היסטוריה';

  @override
  String get dev_preferences_button_positive => 'אישור';

  @override
  String get dev_preferences_button_negative => 'ביטול';

  @override
  String get dev_preferences_migration_title => 'המרת נתונים מגרסה 1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'מצב: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'הצלחה או התקנה מאפס';

  @override
  String get dev_preferences_migration_status_success => 'הצלחה';

  @override
  String get dev_preferences_migration_status_error => 'שגיאה';

  @override
  String get dev_preferences_migration_status_in_progress => 'בתהליך';

  @override
  String get dev_preferences_migration_status_required =>
      'נחוץ (ללחוץ כדי להפעיל)';

  @override
  String get dev_preferences_migration_status_not_started => 'לא ידוע';

  @override
  String get dev_preferences_import_history_subtitle =>
      'יפנה את ההיסטוריה ויציב שם 3 מוצרים';

  @override
  String get dev_preferences_news_custom_url_title => 'כתובת מותאמת לחדשות';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'כתובת קובץ JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'לא הוגדרה';

  @override
  String get dev_preferences_news_provider_status_title => 'מצב';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'רענון אחרון: $date';
  }

  @override
  String get product_type_label_food => 'מזון';

  @override
  String get product_type_label_beauty => 'טיפוח עצמי';

  @override
  String get product_type_label_pet_food => 'מזון לחיות מחמד';

  @override
  String get product_type_label_product => 'אחר';

  @override
  String get product_type_selection_title => 'סוג המוצר';

  @override
  String get product_type_selection_subtitle => 'נא לבחור את סוג המוצר הזה';

  @override
  String get product_type_selection_empty => 'קודם צריך לבחור סוג מוצר!';

  @override
  String product_type_selection_already(String productType) {
    return 'לא ניתן לשנות את סוג המוצר ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'קיצור דרך ליישומון מחירים בעמוד המוצר';

  @override
  String get prices_app_button => 'מעבר ליישומון המחירים';

  @override
  String get prices_website_button => 'פתיחת אתר האינטרנט של Open Prices';

  @override
  String get prices_bulk_proof_upload_select => 'הוספת תגי מחיר ישירות מהגלריה';

  @override
  String get prices_bulk_proof_upload_warning =>
      'לאחר בחירת תמונות, לא ניתן יהיה לערוך אותן!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'בינה מלאכותית תרוץ על ההוכחות שלך כדי לחלץ מחירים.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'לאפשר לקהילה לאמת מחירים שחולצו על ידי בינה מלאכותית.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'כמה תגי מחיר';

  @override
  String get prices_bulk_proof_upload_title => 'העלאת הוכחות במרוכז';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'בחירת קבצים';

  @override
  String get prices_bulk_proof_upload_step_starting => 'ההעלאה מתחילה';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'העתקת קובץ מקומית #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'הכנה להעלאה מס׳ $index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'כשל בתמונה מס׳ $index/$count';
  }

  @override
  String get prices_generic_title => 'מחירים';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'הוספת $count מחירים',
      one: 'הוספת מחיר',
      many: 'הוספת $count מחירים',
      two: 'הוספת $count מחירים',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'שליחת $count מחירים',
      one: 'שליחת מחיר $count',
      many: 'שליחת $count מחירים',
      two: 'שליחת $count מחירים',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'הוספת פריט';

  @override
  String get prices_add_a_price => 'הוספת מחיר';

  @override
  String get prices_add_a_receipt => 'הוספת קבלה';

  @override
  String get prices_add_price_tags => 'הוספת תגי מחיר';

  @override
  String prices_barcode_already(String barcode) {
    return 'הברקוד הזה ($barcode) כבר נמצא ברשימה!';
  }

  @override
  String get prices_barcode_search_not_found => 'המוצר לא נמצא';

  @override
  String get prices_barcode_search_none_yet => 'אין מוצרים עדיין';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'מתבצע איתור אחר $barcode';
  }

  @override
  String get prices_barcode_enter => 'נא למלא את הברקוד';

  @override
  String get prices_category_enter => 'פריט ללא ברקוד';

  @override
  String get prices_per_kilogram => 'מחיר לקילוגרם';

  @override
  String get prices_per_unit => 'מחיר ליחידה';

  @override
  String get prices_per_kilogram_short => ' / ק\"ג';

  @override
  String get prices_per_unit_short => ' יחידה';

  @override
  String get prices_category_mandatory => 'חובה';

  @override
  String get prices_category_optional => 'אופציונלי';

  @override
  String get prices_category_error_mandatory => 'הקטגוריה היא חובה';

  @override
  String get prices_barcode_reader_action => 'קורא ברקודים';

  @override
  String get prices_view_prices => 'הצגת המחירים';

  @override
  String get prices_list_title => 'מחירון';

  @override
  String get prices_list_count => 'מספר\nמחירים';

  @override
  String get prices_list_add_new_price => 'הוספת\nמחיר חדש';

  @override
  String get prices_list_empty_title => 'אין מחיר עדיין!';

  @override
  String get prices_list_empty_subtitle =>
      'היה הראשון להוסיף אחד:\nעל ידי סריקת **קבלה** או **תג מחיר**!';

  @override
  String get prices_entry_shop_not_found => 'חנות לא ידועה';

  @override
  String prices_entry_menu_title(String user) {
    return 'הזנת מחיר מאת „$user”';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'הצג את כל המחירים עבור מוצר זה';

  @override
  String get prices_entry_menu_open_proof => 'הצגת הוכחה';

  @override
  String get prices_entry_menu_my_prices => 'הצגת המחירים האחרים שלי';

  @override
  String get prices_entry_menu_author_prices => 'הצגת מחירים אחרים של המחבר';

  @override
  String get prices_entry_menu_shop_prices => 'הצגת מחירים אחרים מהחנות';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count מחירים',
      one: 'מחיר $count',
      many: '$count מחירים',
      two: '$count מחירים',
    );
    return '$_temp0 ל$product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'כל $count המחירים',
      one: 'מחיר $count בלבד',
      zero: 'אין מחיר עדיין',
      many: 'כל $count המחירים',
      two: 'כל $count המחירים',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return '$pageSize המחירים העדכניים ביותר (סך הכול: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'מחיר: $price / חנות: „$location” / פורסם ב־$date על ידי „$user”';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'הוכחות פתוחות של „$user”';
  }

  @override
  String get prices_open_proof => 'הוכחת מחיר פתוח';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'כל $count ההוכחות',
      one: 'הוכחה אחת בלבד',
      zero: 'אין הוכחות עדיין',
      many: 'כל $count ההוכחות',
      two: 'כל $count ההוכחות',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return '$pageSize ההוכחות העדכניות ביותר ($total בסך הכול)';
  }

  @override
  String get prices_users_empty_title => 'עדיין אין תורם!';

  @override
  String get prices_users_empty_explanation => 'היה הראשון להוסיף מחיר!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return '$pageSize המתנדבים המובילים (בסך הכול: $total)';
  }

  @override
  String get prices_locations_empty_title => 'עדיין אין חנות!';

  @override
  String get prices_locations_empty_explanation => 'היה הראשון להוסיף מחיר!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return '$pageSize המקומות המובילים (בסך הכול: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count הוכחות',
      one: 'הוכחה',
      zero: 'אין הוכחות',
      many: '$count הוכחות',
      two: '$count הוכחות',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count מוצרים',
      one: 'מוצר',
      zero: 'אין מוצרים',
      many: '$count מוצרים',
      two: '$count מוצרים',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count משתמשים',
      one: 'משתמש',
      zero: 'אין משתמשים',
      many: '$count משתמשים',
      two: '$count משתמשים',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count מחירים',
      one: 'מחיר',
      zero: 'אין מחירים',
      many: '$count מחירים',
      two: '$count מחירים',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'מחיר נוסף בעבר';

  @override
  String get prices_amount_subtitle => 'סכום';

  @override
  String get prices_amount_is_discounted => 'בהנחה?';

  @override
  String get prices_amount_price_normal => 'מחיר';

  @override
  String get prices_amount_price_discounted => 'מחיר מוזל';

  @override
  String get prices_amount_price_not_discounted => 'מחיר מקורי';

  @override
  String get prices_amount_no_product => 'מוצר אחד חסר!';

  @override
  String get prices_amount_price_incorrect => 'ערך שגוי';

  @override
  String get prices_amount_price_mandatory => 'ערך חובה';

  @override
  String get prices_currency_subtitle => 'מטבע';

  @override
  String get prices_date_subtitle => 'תאריך';

  @override
  String get prices_location_subtitle => 'חנות';

  @override
  String get prices_location_find => 'איתור חנות';

  @override
  String get prices_location_mandatory => 'חובה לבחור חנות!';

  @override
  String get prices_location_search_broader =>
      'לא מצאת את מבוקשך? אולי כדאי להרחיב את החיפוש!';

  @override
  String get prices_proof_subtitle => 'הוכחה';

  @override
  String get prices_proof_empty_title => 'אין עדיין הוכחה!';

  @override
  String get prices_proof_empty_explanation =>
      'התחילו בהוספת תמונה של **קבלה** או **תג מחיר**!';

  @override
  String get prices_proof_find => 'בחירת הוכחה';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'קבלה';

  @override
  String get prices_proof_price_tag => 'תווית מחיר';

  @override
  String get prices_proof_mandatory => 'חובה לבחור הוכחה!';

  @override
  String get prices_add_validation_error => 'שגיאת אימות';

  @override
  String get prices_privacy_warning_title => 'אזהרת פרטיות';

  @override
  String get prices_unknown_product => 'מוצר לא ידוע';

  @override
  String get prices_privacy_warning_main_message =>
      'המחירים **יהיו גלויים לציבור**, לצד החנות אליהם מתייחסים.\n\nזה עלול לאפשר לאנשים שמכירים את הכינוי שלך ב־Open Food Facts:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'הסקה בנוגע לאזור מגוריך';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'לדעת מה רכשת';

  @override
  String get prices_privacy_warning_sub_message =>
      'אם לא נוח לך עם זה, נא לשנות את הכינוי שלך או ליצור חשבון Open Food Facts חדש ולהיכנס איתו ליישום.';

  @override
  String get i_refuse => 'לא מקובל';

  @override
  String get i_accept => 'מקובל';

  @override
  String get prices_currency_change_proposal_title => 'להחליף את המטבע?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'המטבע הנוכחי שלך הוא **$currency**. לשנות אותו למטבע **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'כן, להשתמש במטבע $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'לא, להשאיר את $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'בוצע';

  @override
  String get dev_mode_section_server => 'הגדרות שרת';

  @override
  String get dev_mode_section_news => 'הגדרות ספק חדשות';

  @override
  String get dev_mode_section_product_page => 'עמוד מוצר';

  @override
  String get dev_mode_section_ui => 'מנשק משתמש';

  @override
  String get dev_mode_section_experimental_features => 'יכולות ניסיוניות';

  @override
  String get dev_mode_hide_environmental_score_title => 'להחריג Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'להשתמש בבודק איות למסכי סריקה אופטית';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(רכיבים ואריזה)';

  @override
  String get dev_mode_reset_app_language_title => 'איפוס שפת האפליקציה';

  @override
  String get dev_mode_add_demo_cards_language_title => 'הוסף כרטיסים';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'מעבר בין prices.openfoodfacts.org (PROD) לסביבת בדיקה';

  @override
  String get search_history_item_edit_tooltip => 'שימוש בחיפוש ועריכתו';

  @override
  String get search_history_item_remove_tooltip => 'הסרה';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'הורדת את כל $totalSize המוצרים.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'הורדת $count מוצרים נוספים\nכבר הורדת $downloaded מתוך $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'החיפוש שלך אחר $search מתבצע.\n\nנא להמתין מספר שניות…';
  }

  @override
  String get user_search_contributor_title => 'מוצרים שהוספתי';

  @override
  String get user_search_informer_title => 'מוצרים שערכתי';

  @override
  String get user_search_photographer_title => 'מוצרים שצילמתי';

  @override
  String get user_search_to_be_completed_title => 'מוצרים שלי להשלמה';

  @override
  String get user_search_prices_title => 'המחירים שלי';

  @override
  String get user_search_proofs_title => 'ההוכחות שלי';

  @override
  String get user_search_proof_title => 'ההוכחה שלי';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'מחירי תורמים: $user';
  }

  @override
  String get all_search_prices_latest_title => 'המחירים האחרים שנוספו';

  @override
  String get all_search_prices_top_user_title => 'תורמי המחירים המובילים';

  @override
  String get all_search_prices_top_location_title =>
      'חנויות עם הכי הרבה מחירים';

  @override
  String get prices_contribution_assistant => 'מסייע תרומת מחירים';

  @override
  String get prices_validation_assistant => 'מסייע אימות מחירים';

  @override
  String get prices_challenges_page => 'אתגרים';

  @override
  String get prices_multiple_proof_addition_system => 'Add Multiple Proofs';

  @override
  String get all_search_prices_top_location_single_title => 'מחירים בחנות';

  @override
  String get all_search_prices_top_product_title => 'מוצרים עם הכי הרבה מחירים';

  @override
  String get all_search_to_be_completed_title => 'כל המוצרים להשלמה';

  @override
  String get categorize_products_country_title =>
      'סיוע במיון מוצרים במדינה שלך בקטגוריות';

  @override
  String get edit_product_action_retake_picture => 'צילום תמונה מחדש';

  @override
  String get edit_product_action_take_picture => 'צילום תמונה';

  @override
  String get edit_product_action_confirm => 'אישור';

  @override
  String get signup_page_terms_of_use_line1 =>
      'נתתי ל־Open Food Facts את הסכמתי ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'תנאי השימוש והתרומה של Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'סמל ניתוח נתונים';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'שגיאה מכרעת: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'שגיאה מכרעת: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'השלמת הפרטים הבסיסיים';

  @override
  String get edit_photo_button_label => 'עריכה';

  @override
  String get edit_photo_unselect_button_label => 'ביטול בחירת תמונה';

  @override
  String get edit_photo_select_existing_button_label => 'בחירת תמונה קיימת';

  @override
  String get edit_photo_select_existing_all_label => 'תמונות קיימות למוצר הזה';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'אפשר לבחור תמונה על ידי לחיצה עליה';

  @override
  String get edit_photo_select_existing_download_label =>
      'התמונות הקיימות מתקבלות…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'אין תמונות שהועלו בעבר וקשורות למוצר הזה.';

  @override
  String get edit_photo_language_not_this_one => 'אין תמונות בשפה הזאת עדיין';

  @override
  String get edit_photo_language_none => 'אין תמונות עדיין';

  @override
  String get category_picker_screen_title => 'קטגוריות';

  @override
  String get basic_details => 'פרטים בסיסיים';

  @override
  String get product_name => 'שם המוצר';

  @override
  String get product_names => 'שמות מוצרים';

  @override
  String get add_basic_details_product_name_add_translation =>
      'הוספת תרגום חדש';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'לפני האימות, נא לוודא שהוספת תרגום **רק אם השפה מופיעה על האריזה**';

  @override
  String get add_basic_details_product_name_open_photo => 'הצגת תמונת החזית';

  @override
  String get add_basic_details_product_name_take_photo => 'צילום תמונת חזית';

  @override
  String get add_basic_details_product_name_hint =>
      'נא למלא את שם המוצר (למשל: במבה)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'לשנות את שפת ברירת המחדל?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'להגדיר את שפת ברירת המחדל של המוצר ל„$language”?';
  }

  @override
  String get explanation_section_good_examples => 'דוגמאות טובות';

  @override
  String get explanation_section_bad_examples => 'דוגמאות גרועות';

  @override
  String get add_basic_details_product_name_help_title =>
      'Good practices: Product name';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'שם המוצר הוא **השם העיקרי שמודפס על האריזה**. הוא יכול להיות סמל מסחר רשום.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**לתשומת ליבך:** נא לא להוסיף תרגום **אם השפה לא מופיעה על האריזה**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'אסם';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'חטיף בוטנים';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'לא לכלול את המותג בשם';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'חטיף בוטנים **של אסם**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'לא להשתמש בסימנים ®, ™, © וכדומה';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'אסם**™**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count תרגומים נוספים',
      many: '$count תרגומים נוספים',
      two: '$count תרגומים נוספים',
      one: 'תרגום נוסף',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'שם המותג';

  @override
  String get brand_names => 'שמות מותג';

  @override
  String get add_basic_details_brand_name_error => 'נא למלא את שם המותג';

  @override
  String get add_basic_details_brand_names_hint =>
      'נא למלא מותגים (למשל: תנובה)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Good practices: Brands';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'יש למלא **את כל המותגים של המוצר**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'מותג ראשי';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'The **main brand**, generally clearly displayed on the front pack, should be **entered first**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'מותגים אחרים';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'כאשר נמכר על ידי **חברה גדולה**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**גמדים** נמכרת על ידי **שטראוס**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'כאשר נמכר עם המותג שלו **בתרגום לכמה שפות**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** is sometimes written **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'כמות ומשקל';

  @override
  String get add_basic_details_quantity_hint =>
      'נא למלא את המשקל ואת הכמות במידת הצורך (למשל: 4×100 גרם)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Good practices: Quantity';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copy the value indicated on the product and **don\'t forget the units**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** or **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (for 6 eggs)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(for a product with 3 boxes, each of 150g)';

  @override
  String get barcode => 'ברקוד';

  @override
  String barcode_barcode(String barcode) {
    return 'ברקוד: $barcode';
  }

  @override
  String get barcode_invalid_error => 'ברקוד שגוי';

  @override
  String get basic_details_add_success => 'פרטים בסיסיים נוספו בהצלחה';

  @override
  String get basic_details_add_error =>
      'לא ניתן להוסיף פרטים בסיסיים. נא לנסות שוב אחר כך';

  @override
  String get clear_search => 'פינוי החיפוש שלך';

  @override
  String get confirm_clear => 'פעולה זו תרוקן את כל ההיסטוריה שלך, להמשיך?';

  @override
  String get alert_clear_selected_user_list =>
      'פעולה זאת תמחק את הפריטים הנבחרים מההיסטוריה שלך';

  @override
  String get confirm_clear_selected_user_list => 'להמשיך?';

  @override
  String get alert_select_items_to_clear => 'נא לבחור פריט אחד או יותר';

  @override
  String confirm_clear_user_list(String name) {
    return 'פעולה זו תרוקן את הרשימה הזאת ($name), להמשיך?';
  }

  @override
  String get confirm_delete_user_list_title => 'למחוק את הרשימה?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'פעולה זו תמחק את הרשימה „$name”.\nלהמשיך?';
  }

  @override
  String get confirm_delete_user_list_button => 'כן, מקובל עליי';

  @override
  String importance_label(String name, String id) {
    return 'חשיבות $name: $id';
  }

  @override
  String get user_list_all_title => 'רשימות';

  @override
  String get user_list_all_empty => 'כאן ניתן ליצור את הרשימה הראשונה שלך';

  @override
  String get product_list_select => 'נא לבחור רשימה';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count מוצרים',
      one: 'מוצר $count',
      zero: 'רשימה ריקה',
      many: '$count מוצרים',
      two: '$count מוצרים',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'הוספת רשימה';

  @override
  String get open_food_preferences_tooltip => 'עריכת העדפות המזון שלך';

  @override
  String get add_photo_button_label => 'הוספת תמונה';

  @override
  String get add_packaging_photo_button_label =>
      'נא לצלם תמונות של פרטי אריזה/מיחזור כלשהם';

  @override
  String get add_origin_photo_button_label => 'נא לצלם תמונות של פרטי מקור';

  @override
  String get add_emb_photo_button_label => 'נא לצלם תמונות של פרטי קוד מעקב';

  @override
  String get add_label_photo_button_label =>
      'נא לצלם תמונות של פרטי תוויות והסמכות';

  @override
  String get choose_image_source_title => 'בחירת מקור תמונה';

  @override
  String get choose_image_source_body => 'נא לבחור מקור תמונה';

  @override
  String get gallery_source_label => 'גלריה';

  @override
  String get gallery_source_access_denied_dialog_title => 'הגישה נדחתה';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'למרבה הצער, היישום לא מצליח לגשת לגלריה שלך, כיוון שדחית את ההרשאה בעבר.\n\nנא לגשת להגדרות היישום תחת הגדרות -> תמונות בטלפון שלך';

  @override
  String get gallery_source_access_denied_dialog_button => 'פתיחת ההגדרות';

  @override
  String get share => 'שיתוף';

  @override
  String share_product_text(String url) {
    return '  מזמינים אותך להסתכל על המוצר הזה ב־Open Food Facts‏: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'מזמינים אותך להסתכל על המוצר הזה ב־Open Beauty Facts‏: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'מזמינים אותך להסתכל על המוצר הזה ב־Open PetFood Facts‏: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'מזמינים אותך להסתכל על המוצר הזה ב־Open Products Facts‏: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'הנה רשימת המוצרים שלי ב־Open Food Facts‏: $url';
  }

  @override
  String get capture => 'לצלם חדשה';

  @override
  String get capture_new_picture => 'צילום תמונה';

  @override
  String get choose_from_gallery => 'בחירה מהגלריה';

  @override
  String get image_upload_queued => 'התמונה תישלח ברקע בהקדם האפשרי.';

  @override
  String get add_price_queued => 'המחיר יישלח לשרת במהירות האפשרית.';

  @override
  String get background_task_title_full_refresh =>
      'מתחיל רענון של כל המוצרים שמאוחסנים מקומית';

  @override
  String get background_task_title_top_n =>
      'מתחילה הורדת המוצרים הנפוצים ביותר';

  @override
  String get expand_nutrition_facts => 'הרחבת טבלת העובדות התזונתיות';

  @override
  String get expand_nutrition_facts_body =>
      'לשמור על טבלת העובדות התזונתיות מורחבת';

  @override
  String get expand_ingredients => 'הרחבת רכיבים';

  @override
  String get expand_ingredients_body => 'לשמור על לוח הרכיבים מורחב';

  @override
  String get no_internet_connection => 'אין חיבור לאינטרנט';

  @override
  String get world_results_label => 'כל העולם';

  @override
  String get world_results_action => 'הרחבת החיפוש שלך לכל העולם';

  @override
  String get copy_to_clipboard => 'העתקה';

  @override
  String get paste_from_clipboard => 'הדבקה מלוח הגזירים';

  @override
  String get no_data_available_in_clipboard =>
      'אין נתונים זמינים בלוח הגזירים שלך';

  @override
  String get clipboard_barcode_copy => 'העתקת ברקוד ללוח הגזירים';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'הברקוד $barcode הועתק ללוח הגזירים!';
  }

  @override
  String get open_product_website => 'פתיחת המוצר הזה באתר';

  @override
  String get language_picker_label => 'השפה שלך';

  @override
  String get country_picker_label => 'המדינה שלך';

  @override
  String get currency_picker_label => 'המטבע שלך';

  @override
  String get help_with_openfoodfacts => 'עזרה עם OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'המוצר יעודכן ברקע בהקדם האפשרי.';

  @override
  String get no_email_client_available_dialog_title => 'אין יישומוני דוא״ל!';

  @override
  String get no_email_client_available_dialog_content =>
      'נא לשלוח אלינו הודעה ידנית אל mobile@openfoodfacts.org';

  @override
  String get all_images => 'כל התמונות';

  @override
  String get selected_images => 'תמונות נבחרות';

  @override
  String get product_card_remove_product_tooltip => 'הסרת מוצר';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'נסרק ברקוד חדש: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip => 'להסיר את כל המוצרים מהקרוסלה';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'נא לסרוק לפחות שני מוצרים כדי להשוות ביניהם';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'לחיצה תשווה בין המוצרים שסרקת';

  @override
  String get scan_product_loading => 'סרקת את\nהברקוד:';

  @override
  String get scan_product_loading_initial =>
      'אנו ממתינים למוצר הזה!\nנא להמתין מספר שניות…';

  @override
  String get scan_product_loading_long_request =>
      'אנחנו עדיין מחפשים את המוצר הזה!\nלהערכתך, לוקח לו יותר מדי זמן להיטען? גם אנחנו חושבים כך…';

  @override
  String get scan_product_loading_unresponsive =>
      'אנחנו עדיין מחפשים את המוצר הזה.\nלהפעיל את החיפוש מחדש?';

  @override
  String get scan_product_loading_restart_button => 'לחפש מחדש';

  @override
  String get portion_calculator_description =>
      'חישוב עובדות תזונתיות לכמות מסוימת';

  @override
  String get portion_calculator_hint => 'כמות בתוך';

  @override
  String get portion_calculator_accessibility =>
      'יש למלא כמות כדי לחשב את העובדות התזונתיות';

  @override
  String portion_calculator_error(int min, int max) {
    return 'נא למלא כמות בין $min ל־$max גרם';
  }

  @override
  String get portion_calculator_computation_error =>
      'חסרים נתונים. לא ניתן לבצע חישובים.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'עובדות תזונתיות ל־$grams ג׳ (או מ״ל)';
  }

  @override
  String get offline_data => 'נתונים בלתי מקוונים';

  @override
  String get ocr_image_upload_instruction =>
      'ניתן להעלות תמונה כדי לחלץ את המידע שהיא מכילה אוטומטית.';

  @override
  String get upload_image => 'העלאת תמונה';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'הורדת התמונה נכשלה';

  @override
  String get image_edit_url_error =>
      'עריכת התמונה נכשלה מכיוון שכתובת התמונה לא הוגדרה.';

  @override
  String get user_picture_source_remember => 'לזכור את הבחירה שלי';

  @override
  String get user_picture_source_ask => 'לשאול בכל פעם';

  @override
  String get robotoff_continue => 'להמשיך';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count השאלות הבאות',
      one: 'שאלה $count הבאה',
      many: '$count השאלות הבאות',
      two: '$count השאלות הבאות',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'הצגת סיסמה';

  @override
  String get owner_field_info_title => 'ערכים שסופקו על ידי היצרן';

  @override
  String get owner_field_info_message =>
      'עם הלוגו הזה אנחנו מדגישים נתונים שסופקו על ידי הספק וכנראה שלא ניתן יהיה לערוך אותם.';

  @override
  String get owner_field_info_close_button => 'לסגור את הפרטים האלה';

  @override
  String get owner_field_image =>
      'התמונה הזאת סופקה על ידי היצרן. יכול להיות שלא ניתן לערוך אותה.';

  @override
  String get edit_packagings_title => 'רכיבי אריזה';

  @override
  String get edit_packagings_element_add => 'הוספת רכיב אריזה';

  @override
  String get edit_packagings_completed => 'האריזה שלמה';

  @override
  String edit_packagings_element_title(int index) {
    return 'רכיב אריזה מס׳ $index';
  }

  @override
  String get edit_packagings_element_field_units => 'מספר יחידות';

  @override
  String get edit_packagings_element_hint_units =>
      'נא למלא את מספר יחידות האריזה מאותה הצורה והחומר שנמצא בתוך המוצר.';

  @override
  String get edit_packagings_element_field_shape => 'צורה';

  @override
  String get edit_packagings_element_hint_shape =>
      'נא למלא את שם הצורה שמופיעה על הנחיות המיחזור אם יש כאלה, או לבחור צורה.';

  @override
  String get edit_packagings_element_example_shape => 'בקבוק';

  @override
  String get edit_packagings_element_field_material => 'חומר גלם';

  @override
  String get edit_packagings_element_hint_material =>
      'נא לציין מה החומר המסוים שבו נעשה שימוש אם אפשר לאתר אותו (אפשר למצוא את קוד החומר בתוך משולש שנמצא על חלקי האריזה), או חומר כללי (למשל: פלסטיק או מתכת) במקרה של ספק.';

  @override
  String get edit_packagings_element_example_material => 'זכוכית';

  @override
  String get edit_packagings_element_field_recycling => 'הנחיות מיחזור';

  @override
  String get edit_packagings_element_hint_recycling =>
      'נא למלא פרטי מיחזור רק אם הם מופיעים על המוצר.';

  @override
  String get edit_packagings_element_example_recycling => 'מיחזור';

  @override
  String get edit_packagings_element_field_quantity =>
      'כמות נטו של המוצר ליחידה';

  @override
  String get edit_packagings_element_hint_quantity =>
      'נא למלא את המשקל הנקי או את הנפח הנקי ולציין את היחידה (למשל גרם או מיליליטר).';

  @override
  String get edit_packagings_element_field_weight =>
      'משקל של יחידה ריקה אחת (גרם)';

  @override
  String get edit_packagings_element_hint_weight =>
      'יש להסיר שאריות מזון ולשטוף ולייבש את החלק של האריזה בטרם השקילה. אם אפשר, כדאי להשתמש במשקל עם רמת דיוק של 0.1 גרם או 0.01 גרם.';

  @override
  String get background_task_title => 'תרומות ממתינות';

  @override
  String get background_task_subtitle =>
      'התרומות שלך נשמרות אוטומטית בשרת שלנו, אך לא תמיד בזמן אמת.';

  @override
  String get background_task_list_empty => 'אין משימות רקע ממתינות';

  @override
  String get background_task_error_server_time_out => 'פג זמן ההמתנה לשרת';

  @override
  String get background_task_error_no_internet =>
      'שגיאת חיבור לאינטרנט. נא לנסות מאוחר יותר.';

  @override
  String get background_task_operation_unknown => 'סוג פעולה לא ידוע';

  @override
  String get background_task_operation_details => 'שינויים מפורטים';

  @override
  String get background_task_operation_image => 'העלאת תמונה';

  @override
  String get background_task_operation_refresh =>
      'הרענון מתעכב לסיום העלאת התמונה';

  @override
  String get background_task_run_started => 'החל';

  @override
  String get background_task_run_not_started => 'טרם החל';

  @override
  String get background_task_run_to_be_deleted => 'למחיקה';

  @override
  String get background_task_question_stop =>
      'לעצור את המשימה הזאת בהקדם האפשרי?';

  @override
  String get feed_back => 'משוב';

  @override
  String get undo => 'ביטול';

  @override
  String get copy_email_to_clip_board => 'העתקת כתובת דוא״ל ללוח';

  @override
  String get please_send_us_an_email_to => 'נא לשלוח לנו הודעה ידנית בדוא״ל אל';

  @override
  String get email_copied_to_clip_board => 'כתובת הדוא״ל הועתקה ללוח הגזירים!';

  @override
  String get select_accent_color => 'בחירת צבע נושא';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'כחול';

  @override
  String get color_cyan => 'כחול־ירקרק';

  @override
  String get color_green => 'ירוק';

  @override
  String get color_light_brown => 'ברירת מחדל';

  @override
  String get color_magenta => 'ארגמן';

  @override
  String get color_orange => 'כתום';

  @override
  String get color_pink => 'ורוד';

  @override
  String get color_red => 'אדום';

  @override
  String get color_rust => 'חלודה';

  @override
  String get color_teal => 'תכלת';

  @override
  String get text_contrast_mode => 'ניגודיות טקסט';

  @override
  String get contrast_high => 'גבוהה';

  @override
  String get contrast_medium => 'בינונית';

  @override
  String get contrast_low => 'נמוכה';

  @override
  String get product_refresher_internet_not_found => 'המוצר לא נמצא!';

  @override
  String get product_refresher_internet_not_connected =>
      'אין לך חיבור לאינטרנט!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'השרת מושבת ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'שגיאת שרת ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'המוצר לא נמצא!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'אין מוצר עם הברקוד הבא במסד הנתונים שלנו: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'אין חיבור לאינטרנט!';

  @override
  String get product_loader_network_error_message =>
      'נא לבדוק שהטלפון החכם שלך מחובר לרשת אלחוטית או שחיבור הנתונים שלו פעיל';

  @override
  String get page_not_found_title => 'העמוד לא נמצא!';

  @override
  String get page_not_found_button => 'חזרה לעמוד הבית';

  @override
  String get download_data => 'הורדת נתונים';

  @override
  String get download_top_products =>
      'אפשר להוריד את 1000 המוצרים המובילים במדינה שלך להאצת הסריקה';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count המוצרים',
      many: '$count המוצרים',
      two: '$count המוצרים',
    );
    return 'הורדת $_temp0 במדינה שלך לסריקה מהירה';
  }

  @override
  String get download_in_progress => 'הנתונים מתקבלים\nעשוי לקחת זמן מה';

  @override
  String downloaded_products(int num) {
    return 'נוספו $num מוצרים';
  }

  @override
  String get update_offline_data => 'עדכון נתוני מוצרים באופן בלתי מקוון';

  @override
  String get update_local_database_sub =>
      'עדכון מסד הנתונים המקומי של המוצרים בנתונים העדכניים ביותר מ־Open Food Facts';

  @override
  String get clear_local_database => 'פינוי נתוני מוצרים באופן בלתי מקוון';

  @override
  String get clear_local_database_sub =>
      'פינוי כל נתוני המוצרים המקומיים מהיישומון שלך כדי לפנות מקום';

  @override
  String deleted_products(int num) {
    return '$num מוצרים נמחקו';
  }

  @override
  String get loading => 'בטעינה…';

  @override
  String get know_more => 'מידע נוסף';

  @override
  String get offline_data_desc =>
      'לחיצה כאן תחשוף מידע נוסף על נתונים בלתי מקוונים';

  @override
  String get offline_product_data_title => 'נתוני מוצרים בלתי מקוונים';

  @override
  String available_for_download(int num) {
    return '$num מוצרים זמינים לסריקה מיידית';
  }

  @override
  String get country_selector_title => 'נא לבחור את המדינה שלך:';

  @override
  String get currency_selector_title => 'בחירת המטבע שלך:';

  @override
  String get language_selector_title => 'נא לבחור את השפה שלך:';

  @override
  String get language_selector_section_selected => 'השפות הנבחרות';

  @override
  String get language_selector_section_frequently_used => 'בשימוש תדיר';

  @override
  String get action_delete_list => 'מחיקה';

  @override
  String get action_change_list => 'החלפת הרשימה הנוכחית';

  @override
  String get product_list_create => 'יצירה';

  @override
  String get product_list_create_tooltip => 'יצירת רשימה חדשה';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (נוסחה חדשה)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (נוסחה חדשה)';

  @override
  String get nutriscore_unknown => 'Nutri-Score לא ידוע';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-Score לא ידוע (נוסחה חדשה)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score לא ניתן ליישום';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score לא תקף (נוסחה חדשה)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'ציון ירוק A';

  @override
  String get environmental_score_b_new => 'ציון ירוק B';

  @override
  String get environmental_score_c_new => 'גרין-סקור ג\'';

  @override
  String get environmental_score_d_new => 'גרין-סקור ד\'';

  @override
  String get environmental_score_e_new => 'גרין-סקור E';

  @override
  String get environmental_score_unknown_new => 'ציון ירוק לא ידוע';

  @override
  String get environmental_score_not_applicable_new => 'ציון ירוק אינו רלוונטי';

  @override
  String get nova_group_generic_new => 'מזון מעובד במיוחד - קבוצות NOVA';

  @override
  String get nova_group_1 => 'קבוצת NOVA‏ 1';

  @override
  String get nova_group_2 => 'קבוצת NOVA‏ 2';

  @override
  String get nova_group_3 => 'קבוצת NOVA‏ 3';

  @override
  String get nova_group_4 => 'קבוצת NOVA‏ 4';

  @override
  String get nova_group_unknown => 'קבוצת NOVA לא ידועה';

  @override
  String get nutrition_facts => 'רמות חומרים מזינים';

  @override
  String get faq_title_partners => 'שותפים ומממנים של העמותה';

  @override
  String get faq_title_vision =>
      'החזון, היעדים, הערכים והתוכניות של Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'אפשר להתקין את Open Beauty Facts כדי ליצור מסד נתונים קוסמטי';

  @override
  String get faq_title_install_pet =>
      'אפשר להתקין את Open Pet Food Facts כדי ליצור מסד נתוני מזון לחיות מחמד';

  @override
  String get faq_title_install_product =>
      'אפשר להתקין את Open Products Facts כדי ליצור מסד נתונים של מוצרים להארכת חיי הפריטים';

  @override
  String get faq_nutriscore_nutriscore => 'נוסחה חדשה ל־Nutri-Score: מה השתנה?';

  @override
  String get contact_title_pro_page =>
      'יצרנים? אפשר לייבא את המוצרים שלכם ל־Open Food Facts';

  @override
  String get contact_title_pro_email => 'איש קשר ליצרנים';

  @override
  String get contact_title_press_page => 'עמוד לעיתונאים';

  @override
  String get contact_title_press_email => 'יצירת קשר לעיתונאים';

  @override
  String get contact_title_newsletter => 'הרשמה לרשימת התפוצה שלנו';

  @override
  String get contact_title_calendar => 'Subscribe to our community calendar';

  @override
  String get hunger_games_loading_line1 => 'נא להמתין מספר שניות…';

  @override
  String get hunger_games_loading_line2 => 'אנו מורידים את השאלות!';

  @override
  String get hunger_games_error_label =>
      'געוואלד! משהו השתבש… לא הצלחנו לטעון את השאלות.';

  @override
  String get hunger_games_error_retry_button => 'מומלץ לנסות שוב!';

  @override
  String get reorder_attribute_action => 'סידור המאפיינים מחדש';

  @override
  String get link_cant_be_opened =>
      'אי אפשר לפתוח את הקישור הזה במכשיר שלך. נא לבדוק שיש לך דפדפן מותקן.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'פרטים על $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'פרטים על $pageName עם $productName';
  }

  @override
  String get guide_title => 'מדריך';

  @override
  String get guide_share_label => 'שיתוף';

  @override
  String get guide_nutriscore_v2_title => 'Nutri-Score מתפתח: הסברים!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'מה זה Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'ה־Nutri-Score הוא לוגו שמטרתו ליידע אותך על **האיכות התזונתית של מוצרי המזון**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'קוד הצבע משתנה מירוק כהה (**A**) למוצרים **הבריאים** ביותר ועד אדום כהה (**E**) לאלו **שפחות בריאים**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption => 'הלוגו Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'למה Nutri-Score מתפתח?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'נוסחת Nutri-Score **מתפתחת** כדי לספק המלצות טובות יותר:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'הערכה טובה יותר של משקאות';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'הערות ההשוואה של **חלב**, **משקאות חלב** בתוספת סוכר ומשקאות **צמחיים** יהיו ברורים יותר באלגוריתם החדש.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'דירוג טוב יותר של משקאות';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**תכולת הסוכר** תילקח בחשבון בצורה יותר משמעותית ותינתן העדפה למשקאות **פחות ממותקים**.\\n**ענישה לממתיקים מלאכותיים**: משקאות דיאטטים מוגזים שונמכו מדירוג B לאיפשהו בין C ל־E. מים הם עדיין המשקה המומלץ.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title => 'מלח וסוכר נענשים';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'מוצרים **מתוקים מדי** או **מלוחים מדי** יזכו **לדירוג נחות עוד יותר**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'היררכיה בתוך שמנים ודגים';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'דירוג סוגים מסוימים של **דגים שמנים** ו**שמנים עשירים בשומנים טובים** ישתפר.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'הגבלת בשר אדום';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'צריכת **בשר אדום אמורה להיות מוגבלת**. לכן **עוף יזכה לדירוג טוב יותר בהשוואה**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'כיצד להבדיל בין Nutri-Score הישן לבין הנוסחה החדשה?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'מעתה, הלוגו יציג אזכור „**נוסחה חדשה**” (New calculation) כדי להבהיר שאכן זו הנוסחה החדשה.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'הלוגו של Nutri-Score החדש';

  @override
  String get guide_nutriscore_v2_where_title =>
      'היכן ניתן למצוא את נוסחת Nutri-Score החדשה?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'The Nutri-Score is applied in 7 countries: France, Germany, Belgium, Spain, Luxembourg, the Netherlands and Switzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Manufacturers have at most **2 years** at the latest after the signature of the decree **to replace** the old calculation with the new one.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'מבלי להמתין, כבר אפשר למצוא את הנוסחה החדשה ב**יישומון של Open Food Facts**ֿ גם אם היצרנים טרם עדכנו את הניקוד.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'מה לא משתנה';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score הוא ציון שנועד **למדוד איכות תזונתית**. הוא **משלים לקבוצת NOVA** על **מזון אולטרה מעובד** (קיים גם ביישום).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'ליצרנים, התצוגה של Nutri-Score **נותרת בגדר רשות**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title => 'מהו הציון הירוק?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'ה-Green-Score הוא לוגו שמטרתו ליידע אתכם על **ההשפעה הסביבתית של מזון**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'קוד הצבעים משתנה מירוק כהה (**A+**) עבור המוצרים **בעלי ההשפעה הפחותה** ועד אדום כהה (**F**) עבור המוצרים **בעלי ההשפעה המשמעותית ביותר**.';

  @override
  String get guide_greenscore_logos_caption => 'הלוגואים של גרין-סקור';

  @override
  String get guide_greenscore_lca_title => 'הליבה: הערכת מחזור חיים (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title => 'הערכה מדעית של קטגוריות מזון';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'עבור כל קטגוריית מוצרים, נקבע ציון **בנצ\'מרק** באמצעות נתונים ממסד הנתונים הסביבתי Agribalyse (שעוצב על ידי ADEME ו-INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**ניתוח מחזור חיים** היא שיטת הערכה סטנדרטית לביצוע הערכה סביבתית רב-שלבית ורב-קריטריונים.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**זה מודד:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 שלבי ייצור';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'חקלאות';

  @override
  String get guide_greenscore_lca_arg2_processing => 'עיבוד';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'אריזה';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'שינוע';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'הפצה';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'צריכה';

  @override
  String get guide_greenscore_lca_arg3_title => '14 מדדי השפעה סביבתית';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'שינויי אקלים/טביעת רגל פחמנית';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'דלדול שכבת האוזון';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'קרינה מייננת';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'אֶרֶץ';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'צריכת מים ואנרגיה';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'זיהום אוויר';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'מים ימיים ומתוקים (חלקיקים, החמצה, איטרופיקציה)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'דלדול משאבים.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'בונוסים ועונשים';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'מצב הייצור';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => 'מקור הרכיבים';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'זנים בסכנת הכחדה';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'אריזה';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'צורך גובר בשקיפות למדידה טובה יותר והפחתת ההשפעה הסביבתית';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'כיצד יצרנים יכולים לעזור';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'יצרנים יכולים לשלוח לנו את המידע שלהם ישירות דרך הפלטפורמה החינמית שלנו ליצרנים.';

  @override
  String get guide_greenscore_better_product_title =>
      'איזה מוצר עדיף לכדור הארץ?';

  @override
  String get guide_greenscore_better_product_arg1_title => 'קשה לדעת';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'בחירת מזון בר-קיימא היא אחד הדברים החזקים ביותר שאנחנו יכולים לעשות למען האקלים, שכן **מערכת המזון העולמית שלנו אחראית ליותר מרבע מכלל פליטות גזי החממה**.\n(מקור: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'יש לך את הכוח!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'החדשות הטובות הן שזה נותן לנו דרך עוצמתית ליצור שינוי.\n**כל אחד מאיתנו אוכל כ-1,000 ארוחות בכל שנה**. אלו 1,000 הזדמנויות **לבחור עתיד טוב יותר לכדור הארץ**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'עוזר לקחת אחריות ולקבל החלטות';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'בחירת מזון בר-קיימא יכולה להרגיש מורכבת. תוויות מבלבלות ולעיתים קרובות חסר בהן מידע. הציון הירוק נוצר כדי לפשט את התהליך, ומעניק לכם דירוג סביבתי **ברור**, **מבוסס מדע** ו**שקוף** למוצרי מזון, בדיוק במקום בו אתם צריכים אותו: בזמן הקניות.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'שְׁקִיפוּת';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'בניגוד לתוויות קנייניות, חישוב ה-Green-Score הוא **פתוח לחלוטין** וניתן לאמת אותו על ידי כל אחד**.';

  @override
  String get guide_nova_title => 'מזון אולטרה מעובד';

  @override
  String get guide_nova_what_is_nova_title => 'מה זה אולטרה-פרוססינג?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'קבוצות NOVA מיידעות אותך על רמת עיבוד המזון.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'סיווג NOVA מאפשר לסווג מזונות ל- **4 קבוצות** בהתבסס על **מידת העיבוד התעשייתי** שלהם (מזונות מעובדים מינימלית או לא מעובדים, מרכיבים קולינריים, מזונות מעובדים, מזונות מעובדים במיוחד).';

  @override
  String get guide_nova_logos_caption => 'הלוגואים של NOVA';

  @override
  String get guide_nova_groups_title => '4 קבוצות NOVA';

  @override
  String get guide_nova_groups_intro =>
      'ישנן 4 קבוצות NOVA, כאשר הבעייתית שבהן היא קבוצה 4 - מזונות מעובדים במיוחד.';

  @override
  String get guide_nova_groups_arg1_title =>
      'מזונות מעובדים מינימלית או לא מעובדים';

  @override
  String get guide_nova_groups_arg1_text =>
      'unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'רכיבים קולינריים מעובדים';

  @override
  String get guide_nova_groups_arg2_text =>
      'processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'מזון מעובד';

  @override
  String get guide_nova_groups_arg3_text =>
      'processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes include various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'מזון אולטרה מעובד';

  @override
  String get guide_nova_groups_arg4_text =>
      'ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'הבעיות עם עיבוד אולטרה';

  @override
  String get guide_nova_explanations_arg1_title =>
      'עיבוד קיצוני של מרכיבי מזון';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'תוספים מעבר לבטיחות מזון טהורה';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title => 'עיבוד שלא ניתן לעשות בבית';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'ההיבטים הטורפניים והפיננסיים של עיבוד אולטרה-';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'ברוך בואך ל־Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'מה זה Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'היכולות של Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'קבלת התראות על מרכיבים שאינם רצויים לך';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'מה לא לעשות';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'להימנע מצלליות וסנוורים.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'בלי טקסט מטושטש או לא ממוקד.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 => 'לא לחתוך חלקים מהטקסט.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'להימנע מרקעים עמוסים.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'מה כן לעשות';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'להשתמש בתאורה טובה ואחידה.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 => 'לוודא שהטקסט חד וקריא.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'לצלם את כל רשימת הרכיבים.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-he.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'קבלת התראות על מרכיבים שאינם רצויים לך';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'מה לא לעשות';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'להימנע מצלליות וסנוורים.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'בלי טקסט מטושטש או לא ממוקד.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'לא לחתוך חלקים מהטקסט.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'להימנע מרקעים עמוסים.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'מה כן לעשות';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'להשתמש בתאורה טובה ואחידה.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'לוודא שהטקסט חד וקריא.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'לצלם את כל רשימת הרכיבים.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-he.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'קבלת התראות על מרכיבים שאינם רצויים לך';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'מה לא לעשות';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'להימנע מצלליות וסנוורים.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'בלי טקסט מטושטש או לא ממוקד.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'לא לחתוך חלקים מהטקסט.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 => 'להימנע מרקעים עמוסים.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'מה כן לעשות';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'להשתמש בתאורה טובה ואחידה.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'לוודא שהטקסט חד וקריא.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'לצלם את כל רשימת הרכיבים.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-he.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'כרגע יש מעט חברות שמחזיקות מסדי נתונים גדולים של מחירים מוצרים ברמת ברקודים. המחירים האלה אינם גלויים לציבור באופן חופשי אך נמכרים במחיר גבוה לשחקנים פרטיים, חוקרים ושלל ארגונים שיכולים להרשות לעצמם לקנות אותם.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'אני קמעונאי ואני רוצה לתרום מחירים. איך אפשר לעשות את זה?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-he.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'תצוגה מקדימה';

  @override
  String get prices_feedback_form =>
      'נא ללחוץ כאן כדי לשלוח לנו משוב על היכולת החדשה הזאת!';

  @override
  String get menu_button_list_actions => 'נא לבחור פעולה';

  @override
  String get error_loading_photo => 'שגיאה בטעינת תמונה';

  @override
  String get photo_viewer_action_use_picture_as => 'להשתמש בתור…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'להשתמש בתמונה הזאת בתור…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'להשתמש בתמונה הזאת בתור… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'פרטים';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'פרטי התמונה הזאת';

  @override
  String get photo_viewer_details_title => 'פרטי התמונה';

  @override
  String get photo_viewer_details_contributor_title => 'תרומה';

  @override
  String get photo_viewer_details_size_title => 'גודל';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width × $height פיקסלים';
  }

  @override
  String get photo_viewer_details_date_title => 'תאריך';

  @override
  String get photo_viewer_details_url_title => 'כתובת';

  @override
  String get product_page_compatibility_score => 'תואם';

  @override
  String get user_lists_action_multi_select => 'בחירה מרוכזת';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'ציון התאימות שלך: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'תמונה קדמית';

  @override
  String get product_image_ingredients_accessibility_label => 'תמונת הרכיבים';

  @override
  String get product_image_nutrition_accessibility_label => 'תמונת מפרט תזונתי';

  @override
  String get product_image_packaging_accessibility_label => 'תמונת אריזה';

  @override
  String get product_image_other_accessibility_label => 'תמונה אחרת';

  @override
  String get product_image_outdated_message => 'לא בטוח שהתמונה עדכנית';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (לא בטוח שהתמונה עדכנית)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (יכול להיות שהתמונה ננעלה על ידי היצרן)';
  }

  @override
  String get product_image_error => 'לא ניתן לטעון את התמונה!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'לא ניתן לטעון את ה$type (תקלת רשת?)';
  }

  @override
  String get product_page_image_no_image_available => 'אין תמונה!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'אין תמונה זמינה למוצר הזה';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'סידור מחדש או הסתרת הפעולות';

  @override
  String get product_page_action_bar_setting_modal_title => 'עריכת פעולות';

  @override
  String get product_page_action_bar_item_move_up => 'העלאה למעלה';

  @override
  String get product_page_action_bar_item_move_down => 'הורדה למטה';

  @override
  String get product_page_action_bar_item_enable => 'הפעלת פעולה';

  @override
  String get product_page_action_bar_item_disable => 'השבתת פעולה';

  @override
  String get product_page_pending_operations_banner_title =>
      'העריכות שלך נשלחות…';

  @override
  String get product_page_pending_operations_banner_message =>
      'הנתונים שמוצגים בעמוד הזה **אינם משקפים את השינויים שערכת.\nנא להמתין מספר שניות…';

  @override
  String get product_add_a_language => 'הוספת שפה';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'ברקוד $barcode';
  }

  @override
  String get carousel_close_tooltip => 'הסרת המוצר הזה מהקרוסלה';

  @override
  String get carousel_unsupported_header => 'ברקוד לא נתמך!';

  @override
  String get carousel_unsupported_title => 'אוווופס!';

  @override
  String get carousel_unsupported_text =>
      'הברקוד שנסרק אינו נתמך על ידי Open Food Facts!';

  @override
  String get carousel_error_header => 'שגיאה!';

  @override
  String get carousel_error_title => 'איזו באסה!';

  @override
  String get carousel_error_text_1 => 'לא הצלחנו להוריד מידע על הברקוד הזה:';

  @override
  String get carousel_error_text_2 =>
      'נא לבדוק את החיבור שלך לאינטרנט או ללחוץ על הכפתור הזה:';

  @override
  String get carousel_error_button => 'ניסיון חוזר';

  @override
  String get carousel_unknown_product_header => 'מוצר לא ידוע';

  @override
  String get carousel_unknown_product_title =>
      'מזל טוב!\nמצאת את __הפנינה הנדירה!__';

  @override
  String get carousel_unknown_product_text =>
      'מסד הנתונים השיתופי שלנו מכיל למעלה מ־**3 מיליון מוצרים**, אבל הברקוד הזה לא קיים: ';

  @override
  String get carousel_unknown_product_button => 'הוספת המוצר הזה';

  @override
  String get carousel_loading_header => 'הפרטים נטענים…';

  @override
  String get carousel_loading_title => 'הרגע סרקת מוצר עם הברקוד הבא:';

  @override
  String get carousel_loading_text =>
      'אנו מחפשים אותו במסד הנתונים שלנו שמכיל למעלה מ־**3 מיליון מוצרים!**';

  @override
  String get product_type_subtitle_food => 'ירקות, פירות, מזון קפוא…';

  @override
  String get product_type_subtitle_beauty => 'איפור, סבונים, משחות שיניים…';

  @override
  String get product_type_subtitle_pet_food => 'מזון כלבים, חתולים…';

  @override
  String get product_type_subtitle_product => 'טלפונים חכמים, ריהוט…';

  @override
  String get photo_field_front => 'תמונת המוצר';

  @override
  String get photo_field_ingredients => 'תמונת רכיבים';

  @override
  String get photo_field_nutrition => 'תמונת מפרט תזונתי';

  @override
  String get photo_field_packaging => 'תמונת פרטי אריזה';

  @override
  String get photo_already_exists => 'התמונה הזאת כבר קיימת';

  @override
  String get photo_missing => 'התמונה הזאת חסרה';

  @override
  String get date => 'תאריך';

  @override
  String get photo_rotate_left => 'הטייה לשמאל';

  @override
  String get photo_rotate_right => 'הטייה לימין';

  @override
  String get photo_undo_action => 'ביטול הפעולה הקודמת';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'מפת העולם של $location';
  }

  @override
  String get open_street_map_contributor_attribution => 'מתנדבי OpenStreetMap';

  @override
  String get not_applicable_short => 'לא זמין';

  @override
  String get knowledge_panel_warning_text => 'אזהרה';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'למה ה־Nutri-Score הזה שונה מזה שעל האריזה?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'יש שני הסברים אפשריים:\nרשימת הרכיבים ו/או העובדות התזונתיות לא עדכניים.\n\nאנו מספקים את ה„חישוב החדש” של Nutri-Score (או V2/גרסה 2). נא לבדוק שמופיע הכיתוב „חישוב חדש/New calculation” על האריזה.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'בדיקת הרכיבים';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'בדיקת העובדות התזונתיות';

  @override
  String url_not_supported(String url) {
    return 'לצערנו, אי אפשר לפתוח את הכתובת: $url';
  }

  @override
  String get product_list_export => 'ייצוא';

  @override
  String get product_list_import => 'ייבוא';

  @override
  String get product_footer_action_barcode => 'הצגת ברקוד';

  @override
  String get product_footer_action_barcode_short => 'ברקוד';

  @override
  String get product_footer_action_open_website => 'פתיחת האתר';

  @override
  String get product_footer_action_report => 'דיווח';

  @override
  String get product_footer_action_contributor_guide => 'עזרה';

  @override
  String get product_footer_action_data_quality_tags => 'איכות נתונים';

  @override
  String get product_page_tab_for_me => 'בשבילי';

  @override
  String get product_page_tab_website => 'אתר';

  @override
  String get product_page_tab_prices => 'מחירים';

  @override
  String get prices_explanation_card_title => 'למה מחירים?';

  @override
  String get prices_explanation_card_line1 =>
      '**Prices פתוחים** הוא פרויקט לאיסוף ושיתוף מחירים של מוצרים ברחבי העולם 🌍. Prices פתוחים פותח ומתוחזק על ידי Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'מידע נוסף';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title => 'מהם מאפייני פולקסונומיה?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'מאפיינים מבוססים על **ערך מפתח**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'מאפיינים אלה נוצרים ומוגשים על ידי תורמים לכל סוג של שימוש.';

  @override
  String get folksonomy_action_external_link_title => 'פתיחת קישור חיצוני';

  @override
  String get folksonomy_action_external_link_warning =>
      'קישורים חיצוניים עלולים להיות מפוקפקים. בכל זאת לבקר בו?';

  @override
  String get prices_products_empty_title => 'אין מחיר זמין';

  @override
  String get prices_products_empty_explanation => 'היה הראשון לתרום!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return '$pageSize המוצרים המובילים (סך הכול: $total)';
  }

  @override
  String get app_review_title => 'היישומון הזה נושא חן בעיניך?';

  @override
  String get app_review_low => 'יכול להשתפר';

  @override
  String get app_review_medium => 'סבבה יחסית';

  @override
  String get app_review_high => 'מעולה!!!!';

  @override
  String get app_review_feedback_modal_title => 'נשמח לעזרתך בשיפור היישומון';

  @override
  String get app_review_feedback_modal_content =>
      'אם יש לך כמה דקות, אפשר לבקש ממך לענות על הטופס הזה כדי ש**נוכל לשפר את העדכונים העתידיים**:';

  @override
  String get app_review_feedback_modal_open_form => 'מענה לטופס';

  @override
  String get app_review_feedback_modal_later => 'אחר כך';

  @override
  String get nutrition_facts_extract_new =>
      'חדש: ניתן לחלץ את חומרי ההזנה מהתמונה אוטומטית!';

  @override
  String get nutrition_facts_extract_button_text => 'לחלץ עכשיו';

  @override
  String get nutrition_facts_extract_in_progress => 'חילוץ מתבצע…';

  @override
  String get nutrition_facts_extract_successful => 'החילוץ הצליח';

  @override
  String get nutrition_facts_extract_failed => 'חילוץ חומרי ההזנה מהתמונה נכשל';

  @override
  String get prices_discount => 'הנחה';

  @override
  String get prices_stats_statistics => 'סטטיסטיקה';

  @override
  String get prices_stats_title => 'סטטיסטיקת מחירים';

  @override
  String get prices_stats_prices_section => 'מחירים';

  @override
  String get prices_stats_products_section => 'מוצרים';

  @override
  String get prices_stats_locations_section => 'מקומות';

  @override
  String get prices_stats_proofs_section => 'הוכחות';

  @override
  String get prices_stats_contributors_section => 'תורמים';

  @override
  String get prices_stats_experiments_section => 'ניסויים';

  @override
  String get prices_stats_misc_section => 'שונות';

  @override
  String get prices_stats_total => 'סך הכול';

  @override
  String get prices_stats_with_barcode => 'עם ברקוד';

  @override
  String get prices_stats_with_category => 'עם קטגוריה';

  @override
  String get prices_stats_with_discount => 'עם הנחה';

  @override
  String get prices_stats_community => 'קהילה';

  @override
  String get prices_stats_consumption => 'צריכה';

  @override
  String get prices_stats_with_price => 'עם מחיר';

  @override
  String get prices_stats_food => 'מזון';

  @override
  String get prices_stats_beauty => 'טיפול';

  @override
  String get prices_stats_products => 'מוצרים';

  @override
  String get prices_stats_pet_food => 'מזון לחיות מחמד';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'מקוון';

  @override
  String get prices_stats_countries => 'מדינות';

  @override
  String get prices_stats_price_tag => 'תווית מחיר';

  @override
  String get prices_stats_receipt => 'קבלה';

  @override
  String get prices_stats_gdpr_request => 'בקשת GDPR (חוק הגנת הפרטיות)';

  @override
  String get prices_stats_shop_import => 'ייבוא חנות';

  @override
  String get prices_stats_challenges => 'אתגרים';

  @override
  String get prices_stats_linked_to_price_tag => 'מחירים המקושרים לתג מחיר';

  @override
  String get prices_stats_currencies => 'מטבעות';

  @override
  String get prices_stats_years => 'שנים';

  @override
  String get prices_stats_by_source_title => 'מחירים והוכחות לפי מקור';

  @override
  String get prices_stats_website => 'אתר';

  @override
  String get prices_stats_mobile_app => 'יישומון לניידים';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'אחר';

  @override
  String get prices_stats_last_updated => 'מועד עדכון אחרון';

  @override
  String get prices_stats_error => 'אירעה שגיאה בטעינת הסטטיסטיקה.';

  @override
  String get product_edit_robotoff_question_answered => 'Question answered!';

  @override
  String get product_edit_robotoff_proof => 'הוכחה';

  @override
  String get preferences_card_general => 'כללי';

  @override
  String get preferences_prices_title => 'מחירים';

  @override
  String get preferences_prices_subtitle => 'ניהול העדפות המחירים שלך';

  @override
  String get preferences_card_project => 'פרויקט עובדות המזון הפתוחות';

  @override
  String get preferences_contribute_title => 'לתרום';

  @override
  String get preferences_my_contributions_title => 'התרומות שלי';

  @override
  String get preferences_my_stats_title => 'הסטטיסטיקה שלי';

  @override
  String get preferences_contribute_subtitle => 'תרגמו, שפרו את הכלים שלנו…';

  @override
  String get preferences_connect_title => 'לְחַבֵּר';

  @override
  String get preferences_connect_subtitle =>
      'צרו קשר, או עקבו אחרינו ברשתות החברתיות';

  @override
  String get preferences_support_title => 'הגשת תרומה';

  @override
  String get preferences_support_subtitle =>
      'עזרו לנו ליידע מיליוני צרכנים ברחבי העולם';

  @override
  String get preferences_card_help => 'עזרה ותמיכה';

  @override
  String get preferences_faq_title => 'שו״ת';

  @override
  String get preferences_faq_subtitle => 'קבל תשובות לשאלות שלך';

  @override
  String get logged_out => 'התנתקתי';

  @override
  String get preferences_app_bar_message => 'תודה שאתה אחד החברים שלנו!';

  @override
  String get preferences_app_bar_products_modified => 'מוצרים שהשתנו';

  @override
  String get preferences_app_bar_prices_added => 'נוספו מחירים';

  @override
  String get preferences_app_bar_see_all_stats => 'ראה את כל הסטטיסטיקות';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'חפש $provider עבור \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint => 'חפש הגדרה (למשל, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji => 'נגישות: הצג אמוג\'י';

  @override
  String get preferences_accessibility_remove_colors => 'נגישות: הסרת צבעים';

  @override
  String get preferences_app_settings_products => 'מוצרים';

  @override
  String get preferences_card_about => 'על אודות';

  @override
  String get preferences_legal_information_title => 'מידע משפטי';

  @override
  String get preferences_legal_information_subtitle =>
      'תנאי שימוש, מדיניות פרטיות ועוד';

  @override
  String get preferences_terms_of_use => 'תנאי שימוש';

  @override
  String get preferences_legal_mentions => 'אזכורים משפטיים';

  @override
  String get preferences_legal_header =>
      'Open Food Facts הוא מאגר מידע של מוצרי מזון **שנוצר על ידי כולם, עבור כולם**.\nניתן להשתמש בו כדי לבצע בחירות מזון טובות יותר, ומכיוון שמדובר ב**נתונים פתוחים**, כל אחד ואחת יכולים **לעשות בהם שימוש חוזר לכל מטרה**.';

  @override
  String get preferences_privacy_policy => 'מדיניות פרטיות';

  @override
  String get preferences_licenses => 'רישיונות';

  @override
  String get preferences_about_app_title => 'אודות האפליקציה';

  @override
  String get preferences_about_app_subtitle => 'מידע טכני, מידע למפתחים ועוד';

  @override
  String get preferences_card_information => 'פרטים';

  @override
  String get preferences_version_number_title => 'מספר גרסה';

  @override
  String get preferences_scanner_title => 'סוֹרֵק';

  @override
  String get preferences_app_store => 'חנות האפליקציות';

  @override
  String get preferences_app_system_settings => 'הגדרות מערכת';

  @override
  String get preferences_source_code => 'גישה לקוד המקור';

  @override
  String get preferences_source_code_subtitle => 'ולהתחיל להשפיע על מיליונים';

  @override
  String get preferences_add_prices => 'הוספת מחירים';

  @override
  String get preferences_complete_products => 'הפצת הבשורה';

  @override
  String get preferences_tips => 'טיפים';

  @override
  String get tips_discover_nutriscore => 'גלו את ה-Nutri-Score החדש';

  @override
  String get preferences_on_off_website_subtitle =>
      'באתר האינטרנט של Open Food Facts';

  @override
  String get preferences_manage_account_title => 'ניהול החשבון שלי';

  @override
  String get preferences_manage_account_tooltip => 'ניהול החשבון שלך';

  @override
  String get preferences_change_password_title => 'שנה את הסיסמה שלי';

  @override
  String get preferences_danger_zone => 'אזור סכנה';

  @override
  String get preferences_account_deletion_subtitle => 'כל התרומות שלך יאבדו';

  @override
  String get preferences_contributions_title => 'תרומות';

  @override
  String get preferences_dev_mode_app_settings_title => 'הגדרות אפליקציה';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'דרך ניסיונית מאוד לסרוק מוצרים במצב לא מקוון';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'רענן את כל המוצרים מהשרת';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'אנא הימנעו מלעשות זאת אלא אם כן הדבר הכרחי לחלוטין';

  @override
  String get preferences_dev_mode_demo_mode_title => 'מצב הדגמה';

  @override
  String get preferences_dev_mode_add_cards_title => 'הוספת כרטיסים לסורק';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'מוסיף 3 מוצרים לדוגמה לסורק';

  @override
  String get preferences_dev_mode_folksonomy_host_title => 'מנחה פולקסונומי';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'מארח: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'ניסויי נגישות';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'מבחר מוצרים מרובים במחירים';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'לוחות ידע שהוזמנו על ידי המשתמש';

  @override
  String get preferences_dev_mode_location_search_title =>
      'גישה זמנית לחיפוש מיקום';

  @override
  String get preferences_dev_mode_comparison_title =>
      'השוואה זו לצד זו עבור 2 או 3 מוצרים';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'ייבוא רשימת מוצרים';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'ציונים ומתודולוגיות';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'גלה כיצד מחושב ה-Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'גלו את השינויים העיקריים במתודולוגיה';

  @override
  String get preferences_faq_discover_project_title => 'לגלות עוד על המיזם';

  @override
  String get preferences_faq_discover_off_title => 'גלה עובדות על אוכל פתוח';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'שאלות נפוצות - שאלות נפוצות';

  @override
  String get preferences_faq_off_ngo_title => 'עמותת \"עובדות על אוכל פתוח\"';

  @override
  String get preferences_about_information_title => 'פרטים';

  @override
  String get preferences_connect_community_updates_title => 'קבל עדכוני קהילה';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'הישארו מעודכנים עם חדשות האפליקציה והקהילה';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscribe to our community calendar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'הצטרפו אלינו באחד מהאירועים הווירטואליים שלנו';

  @override
  String get preferences_connect_blog_title => 'הבלוג של עובדות המזון הפתוחות';

  @override
  String get preferences_connect_blog_subtitle =>
      'קבלו את החדשות האחרונות, ברגע שהן קורות';

  @override
  String get preferences_connect_community_help_title => 'קבל עזרה מהקהילה';

  @override
  String get preferences_connect_improve_app_title =>
      'עזרו לנו לשפר את האפליקציה';

  @override
  String get preferences_connect_debug_info_title =>
      'שלח לנו מידע על ניפוי שגיאות';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'שלחו לנו אימייל עם מידע מפורט על ניפוי שגיאות';

  @override
  String get preferences_connect_feedback_title => 'שלחו לנו משוב על האפליקציה';

  @override
  String get preferences_connect_feedback_subtitle =>
      'עזרו לעצב את עתיד האפליקציה';

  @override
  String get preferences_connect_survey_title => 'השתתף בסקר האפליקציה';

  @override
  String get preferences_connect_survey_subtitle =>
      'עזרו לנו להבין מה עלינו לבנות בהמשך';

  @override
  String get preferences_connect_professionals_title => 'אנשי מקצוע';

  @override
  String get preferences_connect_pro_subtitle =>
      'לגמרי בחינם, מבטיח נתונים מדויקים עבור 500 אפליקציות ומיליוני צרכנים. שירות עצמי, תואם ל-PIM או לגיליונות אלקטרוניים (XLSX) שלך.';

  @override
  String get preferences_connect_pro_email_subtitle => 'צרו קשר כדי להתחיל';

  @override
  String get preferences_connect_press_title => 'מידע לעתונאים';

  @override
  String get preferences_connect_press_page_subtitle =>
      'קבלו את כל החומר הדרוש לכם לדוח שלכם';

  @override
  String get preferences_connect_press_email_subtitle =>
      'צרו קשר לקבלת שאלות מהתקשורת או כדי לעדכן אותנו בדיווח שלכם';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'הפוך למתנדב פעיל';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'פיתוח, תקשורת, עיצוב… כל סוג של התנדבות או מומחיות יתקבלו בברכה!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'גלו כמה מהדרכים הרבות בהן תוכלו לתרום';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'פיתוח אפליקציות מובייל';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'למד כיצד לתרום לפיתוח תוכנה';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'בניות לא יציבות יומיות, תכונות חדשות לגמרי';

  @override
  String get preferences_contribute_local_community_title =>
      'הרחיב את הקהילה המקומית שלך';

  @override
  String get preferences_contribute_translate_subtitle =>
      'עזרה בתרגומי תוכנה, תוכן וניתוח מרכיבים';

  @override
  String get preferences_contribute_share_subtitle =>
      'הכנו תבנית קטנה שתעזור לכם :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'צעדים פשוטים להגדלת שקיפות המזון במדינתך';

  @override
  String get preferences_contribute_data_quality_title => 'איכות נתונים';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'הצטרפו לצוות איכות הנתונים';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'הצטרפו למאמצינו להבטיח שמאגר הנתונים יהיה שלם ומדויק';

  @override
  String get preferences_contributions_products_added_title => 'מוצרים שנוספו';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'מוצרים חדשים שהוספתי ל-Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'מוצרים שאני צריך להשלים';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'כל המוצרים הלא גמורים';

  @override
  String get preferences_my_contributions_prices_title => 'מחירים';

  @override
  String get preferences_my_contributions_my_prices_title => 'המחירים שלי';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'המחירים שלי, ההוכחות שלי…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'מוצרים שתוכלו לעזור להם להשלים';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'עזרו לחשב את ה-Nutri-Score וה-Green-Score במדינתכם';

  @override
  String get preferences_prices_user_prices_subtitle => 'מחירים שתרמתי';

  @override
  String get preferences_prices_proofs_subtitle => 'תגי מחיר וקבלות';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'צלם תמונות של הקבלות שלך וסרוק את הברקודים הנלווים';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'צלם תמונות של מחירים בחנות';

  @override
  String get preferences_prices_newest_title => 'המחירים החדשים ביותר';

  @override
  String get preferences_prices_newest_subtitle =>
      'המחירים האחרונים שנוספו על ידי קהילת Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'התורמים עם המחירים הגבוהים ביותר';

  @override
  String get preferences_prices_metrics_title => 'מדדי מחיר פתיחה';

  @override
  String get preferences_prices_metrics_subtitle => 'עקבו אחר התפתחות הפרויקט';

  @override
  String get preferences_prices_ways_contribute_title => 'דרכים לתרום';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'אשר מחירים שנוספו בעצמך או על יד אחרים, בעזרת בינה מלאכותית';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'הוסף במהירות קבלות רבות או תמונות של מדפים מגליל הצילום שלך';

  @override
  String get preferences_prices_challenges_title => 'אתגרים חודשיים';

  @override
  String get preferences_prices_challenges_subtitle =>
      'השתתפו במשימות נושאיות חודשיות כדי לאסוף מחירים';

  @override
  String get preferences_prices_loyalty_data_title =>
      'החזירו את נתוני הנאמנות שלכם';

  @override
  String get preferences_prices_gdpr_subtitle => 'למד כיצד לבקש את הנתונים שלך';

  @override
  String get preferences_page_customize_app_title => 'התאם אישית את האפליקציה';

  @override
  String get preferences_page_contribute_project_title => 'תרמו לפרויקט';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'דרכים פשוטות לעזור Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'מתודולוגיות ניקוד, עזרה ועוד על הפרויקט';

  @override
  String get product_edit_robotoff_positive_button => 'קבלת ההצעה';

  @override
  String get product_edit_robotoff_negative_button => 'דחיית ההצעה';

  @override
  String get product_edit_robotoff_show_proof => 'הצגת הוכחה';

  @override
  String get product_edit_robotoff_expand_proof => 'הרחבת ההוכחה';

  @override
  String get product_page_tab_raw_data => 'נתונים גולמיים';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'עמוד $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'עמוד $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count מתוך $total פריטים';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count מתוך $total פריטים';
  }

  @override
  String item_count(int count) {
    return 'פריטים $count';
  }

  @override
  String item_count_string(String count) {
    return 'פריטים $count';
  }

  @override
  String get prices_no_result => 'לא נמצאו סטטיסטיקות מחירים.';

  @override
  String get prices_error_loading_more_items => 'שגיאה בטעינת פריטים נוספים';

  @override
  String get prices_proof_error => 'האימות נכשל, לא ניתן לאחזר הוכחות';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count מתוך $total הוכחות';
  }

  @override
  String proof_count(int count) {
    return '$count הוכחות';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count מתוך $total תורמים';
  }

  @override
  String contributors_count(int count) {
    return '$count תורמים';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count מתוך $total מקומות';
  }

  @override
  String prices_locations_count(int count) {
    return '$count מקומות';
  }

  @override
  String get restart_to_apply_message =>
      'אנא הפעל מחדש את האפליקציה כדי להחיל את השינויים.';

  @override
  String get preferences_app_settings_graphical_interface_title => 'ממשק גרפי';

  @override
  String get preferences_app_settings_media_title => 'כְּלֵי תִקְשׁוֹרֶת';

  @override
  String get preferences_about_app_development_title => 'פיתוח';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'מעבדות עובדות מזון פתוחות';

  @override
  String get preferences_root_account_title => 'חשבון';

  @override
  String get preferences_contribute_translate_header =>
      'הביאו עובדות פתוחות על מזון לשפה שלכם';

  @override
  String get preferences_contribute_enroll_alpha =>
      'הירשמו לגרסת אלפא של האפליקציה';

  @override
  String get preferences_dev_mode_section_data => 'תרומות ונתוני מוצר';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'אל תציג פולקסונומיה';

  @override
  String get preferences_account_title => 'חשבון';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'נוסף ב־$created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'שם';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'מדינה';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
