// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class AppLocalizationsEl extends AppLocalizations {
  AppLocalizationsEl([String locale = 'el']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ναι';

  @override
  String get add => 'Προσθήκη';

  @override
  String get account_delete_message =>
      'Σίγουρα θέλετε να διαγράψετε τον λογαριασμό σας;\nΕάν υπάρχει συγκεκριμένος λόγος, παρακαλούμε κοινοποιήστε παρακάτω';

  @override
  String get reason => 'Αιτία';

  @override
  String get okay => 'Εντάξει';

  @override
  String get validate => 'Επικύρωση';

  @override
  String get create => 'Δημιουργία';

  @override
  String get applyButtonText => 'Εφαρμογή';

  @override
  String get next_label => 'Επόμενο';

  @override
  String get continue_label => 'Συνέχεια';

  @override
  String get exit_label => 'Έξοδος';

  @override
  String get previous_label => 'Προηγούμενο';

  @override
  String get go_back_to_top => 'Επιστροφή στην κορυφή';

  @override
  String get save => 'Αποθήκευση';

  @override
  String get save_confirmation => 'Σίγουρα θέλετε να αποθηκεύσετε;';

  @override
  String get skip => 'Παράλειψη';

  @override
  String get cancel => 'Ακύρωση';

  @override
  String get ignore => 'Αγνόηση';

  @override
  String get close => 'Κλείσιμο';

  @override
  String get no => 'Όχι';

  @override
  String get stop => 'Διακοπή';

  @override
  String get finish => 'Τέλος';

  @override
  String get calculate => 'Υπολογισμός';

  @override
  String get reset_food_prefs => 'Επαναφορά προτιμήσεων φαγητού';

  @override
  String get error => 'Κάτι πήγε στραβά';

  @override
  String get error_occurred => 'Παρουσιάστηκε ένα σφάλμα';

  @override
  String get featureInProgress =>
      'Εξακολουθούμε να εργαζόμαστε σε αυτήν τη λειτουργία, μείνετε συντονισμένοι';

  @override
  String get label_web => 'Προβολή στον Ιστό';

  @override
  String get learnMore => 'Μάθετε περισσότερα';

  @override
  String get unknown => 'Άγνωστο';

  @override
  String get match_very_good => 'Πολύ καλή αντιστοιχία';

  @override
  String get match_good => 'Καλή αντιστοιχία';

  @override
  String get match_poor => 'Κακή αντιστοιχία';

  @override
  String get match_may_not => 'Μπορεί να μην ταιριάζει';

  @override
  String get match_does_not => 'Δεν ταιριάζει';

  @override
  String get match_unknown => 'Άγνωστη αντιστοιχία';

  @override
  String get match_short_very_good => 'Πολύ καλή αντιστοιχία';

  @override
  String get match_short_good => 'Καλή αντιστοιχία';

  @override
  String get match_short_poor => 'Κακή αντιστοιχία';

  @override
  String get match_short_may_not => 'Μπορεί να μην ταιριάζει';

  @override
  String get match_short_does_not => 'Δεν ταιριάζει';

  @override
  String get match_short_unknown => 'Άγνωστη αντιστοιχία';

  @override
  String get licenses => 'Licences';

  @override
  String get looking_for => 'Ψάχνουμε για';

  @override
  String get welcomeToOpenFoodFacts => 'Καλώς ήρθατε στο Open Food Facts';

  @override
  String get whatIsOff =>
      'Το Open Food Facts είναι ένας παγκόσμιος μη κερδοσκοπικός οργανισμός που υποστηρίζεται από τις τοπικές κοινότητες.';

  @override
  String get productDataUtility =>
      'Δείτε τα δεδομένα τροφίμων που σχετίζονται με τις προτιμήσεις σας.';

  @override
  String get healthCardUtility => 'Επιλέξτε τροφές που είναι καλές για εσάς.';

  @override
  String get ecoCardUtility =>
      'Επιλέξτε τροφές που είναι καλές για τον πλανήτη.';

  @override
  String get server_error_open_new_issue =>
      'Καμία απάντηση από διακομιστή! Μπορείτε να ανοίξετε ένα ζήτημα με τον παρακάτω σύνδεσμο.';

  @override
  String get sign_in_text =>
      'Συνδεθείτε στον λογαριασμό σας Open Food Facts για να αποθηκεύσετε τις συνεισφορές σας';

  @override
  String get incorrect_credentials => 'Λάθος όνομα χρήστη ή κωδικός πρόσβασης.';

  @override
  String get password_lost_incorrect_credentials =>
      'Αυτό το email ή όνομα χρήστη δεν υπάρχει. Ελέγξτε τα διαπιστευτήριά σας.';

  @override
  String get password_lost_server_unavailable =>
      'Αυτήν τη στιγμή αντιμετωπίζουμε καθυστερήσεις στους διακομιστές μας και ζητάμε συγγνώμη για αυτό. Δοκιμάστε ξανά αργότερα.';

  @override
  String get login => 'Σύνδεση';

  @override
  String get login_result_type_server_unreachable =>
      'Το δίκτυο είναι μη προσβάσιμο';

  @override
  String get login_result_type_server_issue =>
      'Πρόβλημα στον διακομιστή. Δοκιμάστε αργότερα.';

  @override
  String get login_page_username_or_email =>
      'Παρακαλώ εισάγετε όνομα χρήστη ή e-mail';

  @override
  String get login_page_password_error_empty => 'Πληκτρολογήστε τον κωδικό σας';

  @override
  String get create_account => 'Δημιουργήστε λογαριασμό';

  @override
  String get sign_in => 'Σύνδεση';

  @override
  String get sign_in_mandatory =>
      'Για αυτήν τη δυνατότητα, πρέπει να συνδεθείτε.';

  @override
  String get help_improve_country =>
      'Βοηθήστε στη βελτίωση των Open Food Facts στη χώρα σας';

  @override
  String get sign_out => 'Αποσύνδεση';

  @override
  String get sign_out_confirmation => 'Σίγουρα θέλετε να αποσυνδεθείτε;';

  @override
  String get password => 'Κωδικός πρόσβασης';

  @override
  String get forgot_password => 'Ξέχασα τον κωδικό';

  @override
  String get forgot_password_question => 'Ξεχάσατε τον κωδικό πρόσβασης;';

  @override
  String get view_profile => 'Προβολή προφίλ';

  @override
  String get reset_password => 'Επαναφορά κωδικού πρόσβασης';

  @override
  String get reset_password_explanation_text =>
      'Σε περίπτωση που ξεχάσατε τον κωδικό πρόσβασης, εισαγάγετε το όνομα χρήστη ή τη διεύθυνση e-mail σας για να λάβετε οδηγίες για την επαναφορά του κωδικού πρόσβασης. Επίσης, θυμηθείτε να ελέγξετε τον φάκελο Ανεπιθύμητα.';

  @override
  String get username_or_email => 'Όνομα χρήστη ή e-mail';

  @override
  String get reset_password_done =>
      'Ένα e-mail που περιέχει ένα σύνδεσμο για την αλλαγή του κωδικού σας έχει σταλεί στη διεύθυνση e-mail που είναι συνδεδεμένη με τον λογαριασμό σας. Ελέγξτε και τον φάκελο των ανεπιθύμητων';

  @override
  String get send_reset_password_mail => 'Αλλαγή κωδικού';

  @override
  String get enter_some_text => 'Παρακαλούμε εισάγετε κάποιο κείμενο';

  @override
  String get sign_up_page_title => 'Εγγραφή';

  @override
  String get sign_up_page_action_button => 'Εγγραφή';

  @override
  String get sign_up_page_action_doing_it => 'Γίνεται εγγραφή...';

  @override
  String get sign_up_page_action_ok =>
      'Συγχαρητήρια! Ο λογαριασμός σας μόλις δημιουργήθηκε.';

  @override
  String get sign_up_page_display_name_hint => 'Όνομα';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Παρακαλώ εισάγετε το όνομα εμφάνισης που θέλετε να χρησιμοποιήσετε';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'Απαιτείται e-mail';

  @override
  String get sign_up_page_email_error_invalid => 'Μη έγκυρο e-mail';

  @override
  String get sign_up_page_username_hint => 'Όνομα χρήστη: Ορατό προς όλους';

  @override
  String get sign_up_page_username_error_empty =>
      'Παρακαλώ εισάγετε ένα όνομα χρήστη';

  @override
  String get sign_up_page_username_error_invalid =>
      'Παρακαλώ εισάγετε ένα έγκυρο όνομα χρήστη';

  @override
  String get sign_up_page_username_description =>
      'Το όνομα χρήστη δεν μπορεί να περιέχει κενά, κεφαλαία ή ειδικούς χαρακτήρες.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Το όνομα χρήστη δεν μπορεί να είναι μεγαλύτερο από $value χαρακτήρες';
  }

  @override
  String get sign_up_page_password_hint => 'Κωδικός πρόσβασης';

  @override
  String get sign_up_page_password_error_empty =>
      'Πληκτρολογήστε τον κωδικό σας';

  @override
  String get sign_up_page_password_error_invalid =>
      'Παρακαλούμε εισάγετε έναν έγκυρο κωδικό πρόσβασης (τουλάχιστον 6 χαρακτήρες)';

  @override
  String get sign_up_page_confirm_password_hint =>
      'Επιβεβαίωση Κωδικού Πρόσβασης';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Επιβεβαιώστε τον κωδικό πρόσβασης';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Οι κωδικοί πρόσβασης δεν ταιριάζουν';

  @override
  String get sign_up_page_agree_text => 'Συμφωνώ με το Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'τους όρους χρήσης και συνεισφοράς';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Δημιουργώντας έναν λογαριασμό, η αποδοχή των Όρων Χρήσης είναι υποχρεωτική. Παρόλα αυτά, οι ανώνυμες συνεισφορές μπορούν ακόμα να γίνουν μέσω της εφαρμογής';

  @override
  String get sign_up_page_producer_checkbox => 'Είμαι παραγωγός τροφίμων';

  @override
  String get sign_up_page_producer_hint => 'Παραγωγός/επωνυμία';

  @override
  String get sign_up_page_producer_error_empty =>
      'Εισαγάγετε έναν παραγωγό ή μια επωνυμία';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Θα ήθελα να εγγραφώ στο ενημερωτικό δελτίο Open Food Facts (Μπορείτε να διαγραφείτε από αυτό ανά πάσα στιγμή)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Το όνομα χρήστη υπάρχει ήδη, επιλέξτε άλλο όνομα χρήστη.';

  @override
  String get sign_up_page_email_already_exists =>
      'υπάρχει ήδη, συνδεθείτε στον λογαριασμό ή δοκιμάστε με άλλο email.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Παρακαλώ δώστε μια έγκυρη διεύθυνση email.';

  @override
  String get sign_up_page_server_busy =>
      'Λυπούμαστε πολύ, έχουμε κάποιες τεχνικές δυσκολίες για τη δημιουργία του λογαριασμού σας. Δοκιμάστε ξανά αργότερα.';

  @override
  String get settingsTitle => 'Ρυθμίσεις';

  @override
  String get darkmode => 'Θέμα';

  @override
  String get darkmode_dark => 'Σκούρο';

  @override
  String get darkmode_light => 'Ανοιχτόχρωμο';

  @override
  String get darkmode_system_default => 'Προεπιλογή συστήματος';

  @override
  String get thanks_for_contributing => 'Ευχαριστούμε για τη συνεισφορά!';

  @override
  String get contributors_label => 'Ποιοι χτίζουν την εφαρμογή';

  @override
  String get contributors_dialog_title => 'Χρηστες';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Συντελεστής: $name';
  }

  @override
  String get contributors_description =>
      'Μια λίστα με όλους τους συντελεστές αυτής της εφαρμογής';

  @override
  String get support => 'Υποστήριξη';

  @override
  String get support_join_slack => 'Ζητήστε βοήθεια στο κανάλι μας στο Slack';

  @override
  String get support_via_forum => 'Ζητήστε βοήθεια στο φόρουμ μας';

  @override
  String get support_via_email => 'Στείλτε μας e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Αποστολή αρχείων καταγραφής εφαρμογής;';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Θέλετε να συμπεριλάβετε τα αρχεία καταγραφής της εφαρμογής σαν συνημμένο στο email;';

  @override
  String get termsOfUse => 'Όροι χρήσης';

  @override
  String get legalNotices => 'Νομικές ειδοποιήσεις';

  @override
  String get privacy_policy => 'Πολιτική απορρήτου';

  @override
  String get about_this_app => 'Σχετικά με αυτή την εφαρμογή';

  @override
  String get contribute => 'Συμβάλλετε';

  @override
  String get contribute_sw_development => 'Ανάπτυξη λογισμικού';

  @override
  String get contribute_develop_text =>
      'Ο κώδικας για κάθε προϊόν του Open Food Facts είναι διαθέσιμος στο GitHub. Μπορείτε να χρησιμοποιήσετε ξανά τον κώδικα (είναι ανοιχτού κώδικα) και να μας βοηθήσετε να τον βελτιώσουμε, για όλους, σε όλο τον πλανήτη.';

  @override
  String get contribute_develop_text_2 =>
      'Μπορείτε να εγγραφείτε στο Open Food Facts Slack chatroom που είναι ο προτιμώμενος τρόπος για να κάνετε ερωτήσεις.';

  @override
  String get contribute_develop_dev_mode_title => 'Λειτουργία DEV;';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Ενεργοποίηση Λειτουργίας DEV';

  @override
  String get contribute_donate_title => 'Κάντε Δωρεά';

  @override
  String get contribute_donate_header => 'Δωρεά στο Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Παρακαλούμε κατανοήστε ότι με την εσωτερική έκδοση alpha, η πλήρης απώλεια δεδομένων είναι πιθανή και η εφαρμογή μπορεί να γίνει άχρηστη ανά πάσα στιγμή!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Προϊόντα προς συμπλήρωση';

  @override
  String get contribute_improve_header => 'Τρόποι βελτίωσης';

  @override
  String get contribute_improve_text =>
      'Η βάση δεδομένων είναι ο πυρήνας του έργου. Είναι εύκολο και πολύ γρήγορο να βοηθήσετε. Μπορείτε να κάνετε λήψη της εφαρμογής για κινητά και να αρχίσετε να προσθέτετε ή να βελτιώνετε προϊόντα.\n\nΕκτός αυτού, ο ιστότοπος Open Food Facts προσφέρει πολλούς τρόπους συνεισφοράς: ';

  @override
  String get contribute_translate_header => 'Μετάφραση';

  @override
  String get contribute_data_quality => 'Data Quality';

  @override
  String get contribute_translate_link_text => 'Ξεκινήστε τη μετάφραση';

  @override
  String get contribute_translate_text =>
      'Το Open Food Facts είναι ένα παγκόσμιο έργο, που περιλαμβάνει προϊόντα από περισσότερες από 160 χώρες. Το Open Food Facts μεταφράζεται σε δεκάδες γλώσσες, με συνεχώς εξελισσόμενο περιεχόμενο.';

  @override
  String get contribute_translate_text_2 =>
      'Οι μεταφράσεις είναι ένα από τα βασικά καθήκοντα του έργου';

  @override
  String get contribute_join_skill_pool =>
      'Συνεισφέρετε τις δεξιότητές σας στα Open Food Facts. Εγγραφείτε στο skill pool!';

  @override
  String get contribute_share_header =>
      'Μοιραστείτε τα Open Food Facts με τους φίλους σας';

  @override
  String get contribute_share_content =>
      'Ήθελα να σας ενημερώσω για την εφαρμογή που χρησιμοποιώ, το Open Food Facts, η οποία σας επιτρέπει να μαθαίνετε τις επιπτώσεις των τροφίμων σας στην υγεία και το περιβάλλον, με εξατομικευμένο τρόπο. Λειτουργεί σαρώνοντας τους γραμμωτούς κώδικες στη συσκευασία. Τέλος, είναι δωρεάν, δεν απαιτεί εγγραφή και μπορείτε ακόμη και να αυξήσετε τον αριθμό των προϊόντων που αποκρυπτογραφούνται. Ο σύνδεσμος για να το αποκτήσετε για το τηλέφωνό σας: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Συνεισφέρετε τιμές ζητώντας εξαγωγή των δεδομένων των καρτών αφοσίωσης μέσω GDPR';

  @override
  String get tap_to_answer => 'Πατήστε εδώ για να απαντήσετε σε ερωτήσεις';

  @override
  String get tap_to_answer_hint =>
      'Πατήστε εδώ για να απαντήσετε σε ερωτήσεις σχετικά με αυτό το προϊόν';

  @override
  String get robotoff_questions_loading_hint =>
      'Περιμένετε μέχρι να φορτωθούν ερωτήσεις σχετικά με αυτό το προϊόν';

  @override
  String get saving_answer => 'Αποθήκευση της απάντησής σας';

  @override
  String get contribute_to_get_rewards =>
      'Become an actor of food transparency';

  @override
  String get question_sign_in_text =>
      'Συνδεθείτε στον λογαριασμό σας στο Open Food Facts για να λάβετε εύσημα για τις συνεισφορές σας';

  @override
  String get question_yes_button_accessibility_value => 'Απαντήστε με ναι';

  @override
  String get question_no_button_accessibility_value => 'Απαντήστε με όχι';

  @override
  String get question_skip_button_accessibility_value =>
      'Παράλειψη αυτής της ερώτησης';

  @override
  String get tap_to_edit_search => 'Πατήστε για επεξεργασία αναζήτησης';

  @override
  String get myPreferences => 'Οι προτιμήσεις μου';

  @override
  String get account_create_message =>
      'Δημιουργήστε τον λογαριασμό σας και εγγραφείτε στην κοινότητα Open Food Facts για να βοηθήσετε στην οικοδόμηση γνώσεων για τα τρόφιμα σε όλο τον κόσμο!';

  @override
  String get join_us => 'Γίνετε μέλος';

  @override
  String get myPreferences_profile_title => 'Το Προφίλ Σας';

  @override
  String get myPreferences_profile_subtitle =>
      'Διαχειριστείτε τον λογαριασμό συνεργάτη Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Ρυθμίσεις Εφαρμογής';

  @override
  String get myPreferences_settings_subtitle => 'Σκοτεινή λειτουργία, Γλώσσες…';

  @override
  String get myPreferences_food_title => 'Διατροφικές Προτιμήσεις';

  @override
  String get myPreferences_food_subtitle =>
      'Επιλέξτε ποιες πληροφορίες σχετικά με τα τρόφιμα έχουν μεγαλύτερη σημασία για εσάς.';

  @override
  String get myPreferences_food_comment =>
      'Επιλέξτε ποιες πληροφορίες σχετικά με τα τρόφιμα έχουν μεγαλύτερη σημασία για εσάς, προκειμένου να ταξινομηθούν τα τρόφιμα σύμφωνα με τις προτιμήσεις σας, να εμφανιστούν πρώτα οι πληροφορίες που σας ενδιαφέρουν και να λάβετε περίληψη συμβατότητας. Αυτές οι προτιμήσεις τροφίμων παραμένουν στη συσκευή σας και δεν συσχετίζονται με τον λογαριασμό συνεργάτη σας στο Open Food Facts, εάν έχετε.';

  @override
  String get confirmResetPreferences =>
      'Επαναφορά των διατροφικών σας προτιμήσεων;';

  @override
  String get myPersonalizedRanking => 'Η εξατομικευμένη μου κατάταξη';

  @override
  String get ranking_tab_all => 'Όλα';

  @override
  String get ranking_subtitle_match_yes => 'Ένα καλό ταίριασμα για εσάς';

  @override
  String get ranking_subtitle_match_no => 'Πολύ κακή αντιστοιχία';

  @override
  String get ranking_subtitle_match_maybe => 'Άγνωστη αντιστοιχία';

  @override
  String get refresh_with_new_preferences =>
      'Ανανεώστε τη λίστα με τις νέες σας προτιμήσεις';

  @override
  String get reloaded_with_new_preferences =>
      'Επαναφορτώθηκε με τις νέες σας προτιμήσεις';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Σάρωση';

  @override
  String get history_navbar_label => 'Ιστορικό';

  @override
  String get list_navbar_label => 'Λίστες';

  @override
  String get category => 'Φιλτράρισμα κατά κατηγορία';

  @override
  String get category_all => 'Όλα';

  @override
  String get category_search => '(αναζήτηση κατηγορίας)';

  @override
  String get filter => 'Φίλτρο';

  @override
  String get scan => 'Προϊόντα από την οθόνη Σάρωση';

  @override
  String get scan_history => 'Ιστορικό σάρωσης';

  @override
  String get search => 'Αναζήτηση';

  @override
  String get search_product_help =>
      'Αναζήτηση προϊόντος,\nμάρκας ή γραμμωτού κώδικα';

  @override
  String get search_filter => 'Φίλτρο αναζήτησης';

  @override
  String get search_history => 'Ιστορικό αναζήτησης';

  @override
  String get search_store => 'Αναζήτηση για κατάστημα';

  @override
  String get search_store_help => 'Υπόδειξη: προσθέστε την πόλη ή τη χώρα';

  @override
  String get tap_for_more => 'Πατήστε για να δείτε περισσότερες πληροφορίες…';

  @override
  String get product => 'Προϊόν';

  @override
  String get unknownBrand => 'Άγνωστη μάρκα';

  @override
  String get unknownProductName => 'Άγνωστο όνομα προϊόντος';

  @override
  String get label_refresh => 'Ανανέωση';

  @override
  String get label_reload => 'Ανανέωση';

  @override
  String get image => 'Εικόνα';

  @override
  String get front_photo => 'Μπροστινή φωτογραφία';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (αυτή η εικόνα μπορεί να είναι ξεπερασμένη)';
  }

  @override
  String get outdated_image_short_label => 'ίσως είναι ξεπερασμένη';

  @override
  String get ingredients => 'Συστατικά';

  @override
  String get ingredients_editing_instructions =>
      'Διατηρήστε την αρχική σειρά. Αναφέρετε το ποσοστό όταν καθορίζεται. Διαχωρίστε με κόμμα ή παύλα και χρησιμοποιήστε παρενθέσεις για τα συστατικά ενός συστατικού.';

  @override
  String get ingredients_editing_error =>
      'Απέτυχε η αποθήκευση του συστατικού.';

  @override
  String get ingredients_editing_image_error =>
      'Αποτυχία λήψης νέας εικόνας συστατικών.';

  @override
  String get ingredients_editing_title => 'Επεξεργασία Συστατικών';

  @override
  String get ingredients_photo => 'Φωτογραφία συστατικών';

  @override
  String get packaging_editing_instructions =>
      'Παραθέστε όλα τα μέρη συσκευασίας, διαχωρισμένα με κόμμα ή γραμμή, με τη ποσότητά τους (π.χ. 1 ή 6), τον τύπο τους (π.χ. μπουκάλι, κιβώτιο, δοχείο), υλικό (π.χ. πλαστικό, μέταλλο, αλουμίνιο) και εφόσον είναι διαθέσιμο το μέγεθός τους (π.χ. 33cl) και οδηγίες ανακύκλωσης.\nΠαράδειγμα: 1 γυάλινο μπουκάλι για ανακύκλωση, 1 πλαστικός φελλός για απορρίμματα';

  @override
  String get packaging_editing_error => 'Αποτυχία αποθήκευσης συσκευασίας.';

  @override
  String get packaging_editing_image_error =>
      'Αποτυχία λήψης νέας εικόνας συσκευασίας.';

  @override
  String get packaging_editing_title => 'Επεξεργασία Συσκευασίας';

  @override
  String get nutrition => 'Διατροφική Αξία';

  @override
  String get nutrition_facts_photo => 'Φωτογραφία διατροφικών στοιχείων';

  @override
  String get nutrition_facts_editing_title =>
      'Επεξεργασία Διατροφικών Στοιχείων';

  @override
  String get packaging_information => 'Πληροφορίες συσκευασίας';

  @override
  String get packaging_information_photo =>
      'Φωτογραφία πληροφοριών συσκευασίας';

  @override
  String get missing_product => 'Βρήκατε ένα νέο προϊόν!';

  @override
  String get add_product_take_photos =>
      'Τραβήξτε φωτογραφίες της συσκευασίας για να προσθέσετε αυτό το προϊόν στο Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Παρακαλώ τραβήξτε πρώτα κάποιες φωτογραφίες. Μπορείτε πάντα να ολοκληρώσετε το προϊόν αργότερα.';

  @override
  String get add_product_information_button_label =>
      'Προσθέστε πληροφορίες προϊόντος';

  @override
  String get new_product => 'Νέο Προϊόν';

  @override
  String get new_product_found_title => 'Βρέθηκε νέο προϊόν!';

  @override
  String get new_product_found_text =>
      'Η συνεργατική βάση δεδομένων μας περιέχει περισσότερα από **3 εκατομμύρια προϊόντα**, αλλά αυτός ο γραμμωτός κώδικας δεν υπάρχει: ';

  @override
  String get new_product_found_button => 'Προσθέστε αυτό το προϊόν';

  @override
  String get new_product_leave_title => 'Έξοδος από τη σελίδα;';

  @override
  String get new_product_leave_message =>
      'Φαίνεται ότι δεν εισαγάγατε τίποτα. Θέλετε πραγματικά να φύγετε από αυτήν τη σελίδα;';

  @override
  String get new_product_dialog_description =>
      'Παρακαλώ τραβήξτε φωτογραφίες της συσκευασίας για να προσθέσετε αυτό το προϊόν στην κοινή μας βάση δεδομένων';

  @override
  String get new_product_dialog_illustration_description =>
      'Μια απεικόνιση με άγνωστο Nutri-Score και Green Score';

  @override
  String get front_packaging_photo_button_label =>
      'Μπροστινή φωτογραφία προϊόντος';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Επιβεβαίωση μεταφόρτωσης μπροστινής φωτογραφίας προϊόντος';

  @override
  String get confirm_button_label => 'Επιβεβαίωση';

  @override
  String get send_image_button_label => 'Αποστολή εικόνας';

  @override
  String get crop_page_action_saving => 'Αποθήκευση της εικόνας…';

  @override
  String get crop_page_action_cropping => 'Περικοπή της εικόνας…';

  @override
  String get crop_page_action_local => 'Αποθήκευση τοπικής έκδοσης…';

  @override
  String get crop_page_action_local_failed_title =>
      'Ωχ… συμβαίνει κάτι με τη φωτογραφία σας!';

  @override
  String get crop_page_action_local_failed_message =>
      'Δεν μπορούμε να επεξεργαστούμε την εικόνα τοπικά, πριν την στείλουμε στον διακομιστή μας. Δοκιμάστε ξανά αργότερα ή επικοινωνήστε μαζί μας εάν το πρόβλημα παραμένει.';

  @override
  String get crop_page_action_retake => 'Επανάληψη φωτογραφίας';

  @override
  String get crop_page_too_small_image_title => 'Η εικόνα είναι πολύ μικρή!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Το ελάχιστο μέγεθος σε pixel για μεταφόρτωση εικόνας είναι ${expectedMinWidth}x$expectedMinHeight. Η τρέχουσα εικόνα είναι ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server =>
      'Προετοιμασία κλήσης προς τον διακομιστή…';

  @override
  String get front_packaging_photo_title => 'Φωτογραφία Μπροστινής Συσκευασίας';

  @override
  String get ingredients_photo_title => 'Φωτογραφία Συστατικών';

  @override
  String get nutritional_facts_photo_title =>
      'Φωτογραφία Διατροφικών Στοιχείων';

  @override
  String get recycling_photo_title => 'Φωτογραφία Ανακύκλωσης';

  @override
  String get take_photo_title => 'Τραβήξτε μια φωτογραφία';

  @override
  String get take_more_photo_title => 'Τραβήξτε περισσότερες φωτογραφίες';

  @override
  String get front_photo_uploaded => 'Η μπροστινή φωτογραφία μεταφορτώθηκε';

  @override
  String get ingredients_photo_button_label => 'Φωτογραφία συστατικών';

  @override
  String get ingredients_photo_uploaded =>
      'Η φωτογραφία των συστατικών μεταφορτώθηκε';

  @override
  String get nutrition_cache_loading_error =>
      'Δεν είναι δυνατή η φόρτωση θρεπτικών συστατικών από την προσωρινή μνήμη';

  @override
  String get nutritional_facts_photo_button_label =>
      'Φωτογραφία διατροφικών στοιχείων';

  @override
  String get nutritional_facts_input_button_label =>
      'Συμπλήρωση διατροφικών στοιχείων';

  @override
  String get nutritional_facts_added => 'Προστέθηκαν διατροφικά στοιχεία';

  @override
  String get categories_added => 'Προστέθηκαν κατηγορίες';

  @override
  String get new_product_title_nutriscore => 'Υπολογίστε το Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Βοηθήστε μας συμπληρώνοντας τουλάχιστον μια κατηγορία και διατροφικές τιμές';

  @override
  String get new_product_title_environmental_score =>
      'Υπολογίστε το Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Αποκτήστε το συμπληρώνοντας τουλάχιστον μια κατηγορία';

  @override
  String get new_product_additional_environmental_score =>
      'Κάντε τον υπολογισμό του Green Score πιο ακριβές με την προέλευση, τη συσκευασία και άλλα';

  @override
  String get new_product_title_nova =>
      'Υπολογίστε το επίπεδο επεξεργασίας τροφίμων (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Αποκτήστε το συμπληρώνοντας την κατηγορία τροφίμων και τα συστατικά';

  @override
  String get new_product_desc_nova_unknown =>
      'Άγνωστο επίπεδο επεξεργασίας τροφίμων';

  @override
  String get new_product_title_pictures => 'Νέο προϊόν';

  @override
  String get new_product_title_pictures_details =>
      'Παρακαλώ τραβήξτε τις παρακάτω φωτογραφίες και η μηχανή Open Food Facts θα κάνει τα υπόλοιπα!';

  @override
  String get new_product_title_misc => 'Και μερικά βασικά δεδομένα…';

  @override
  String new_product_done_msg(String username) {
    return 'Ευχαριστούμε για τη συνεισφορά σας \"$username\"!';
  }

  @override
  String get new_product_done_msg_no_user =>
      'Ευχαριστούμε για τη συνεισφορά σας!';

  @override
  String get new_product_done_button_label =>
      'Ανακαλύψτε το ολοκληρωμένο προϊόν';

  @override
  String get hey_incomplete_product_message =>
      'Πατήστε για να απαντήσετε σε 3 ερωτήσεις ΤΩΡΑ και να υπολογίσετε τα Nutri-Score, Green Score & την Υπερεπεξεργασία (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Πατήστε τώρα για να απαντήσετε σε 2 ερωτήσεις που θα βοηθήσουν στην ανάλυση αυτού του καλλυντικού!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Πατήστε τώρα για να απαντήσετε σε 3 ερωτήσεις που θα βοηθήσουν στην ανάλυση αυτού του προϊόντος τροφής για κατοικίδια!';

  @override
  String get hey_incomplete_product_message_product =>
      'Πατήστε τώρα για να ολοκληρώσετε αυτό το προϊόν!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Η φωτογραφία διατροφικών στοιχείων μεταφορτώθηκε';

  @override
  String get recycling_photo_button_label =>
      'Φωτογραφία πληροφοριών ανακύκλωσης';

  @override
  String get recycling_photo_uploaded =>
      'Η φωτογραφία ανακύκλωσης μεταφορτώθηκε';

  @override
  String get take_more_photo_button_label =>
      'Τραβήξτε περισσότερες φωτογραφίες';

  @override
  String get other_photo_uploaded =>
      'Η φωτογραφίας στην κατηγορία διάφορα μεταφορτώθηκε';

  @override
  String get retake_photo_button_label => 'Νέα λήψη';

  @override
  String get selecting_photo => 'Επιλογή φωτογραφίας';

  @override
  String get uploading_image => 'Μεταφόρτωση φωτογραφίας στον διακομιστή';

  @override
  String get uploading_image_type_front =>
      'Μεταφόρτωση μπροστινής εικόνας στο Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Μεταφόρτωση εικόνας συστατικών στο Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Μεταφόρτωση εικόνας διατροφής στο Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Μεταφόρτωση εικόνας συσκευασίας στο Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Μεταφόρτωση άλλης εικόνας στο Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Μεταφόρτωση εικόνας στο Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Προσθήκη συστατικών που λείπουν';

  @override
  String get score_add_missing_packaging_image =>
      'Προσθήκη εικόνας συσκευασίας που λείπει';

  @override
  String get score_add_missing_nutrition_facts =>
      'Προσθήκη διατροφικών στοιχείων που λείπουν';

  @override
  String get score_add_missing_product_traces =>
      'Προσθήκη ιχνών προϊόντων που λείπουν';

  @override
  String get score_add_missing_product_category => 'Προσθήκη κατηγορίας';

  @override
  String get score_add_missing_precise_product_category =>
      'Επιλέξτε μια πιο ακριβή κατηγορία';

  @override
  String get score_add_missing_product_countries =>
      'Προσθήκη χωρών προϊόντος που λείπουν';

  @override
  String get score_add_missing_product_emb =>
      'Προσθήκη κωδικών ιχνηλασιμότητας προϊόντος που λείπουν';

  @override
  String get score_add_missing_product_labels =>
      'Προσθήκη ετικετών προϊόντος που λείπουν';

  @override
  String get score_add_missing_product_origins =>
      'Προσθήκη προέλευσης προϊόντος που λείπουν';

  @override
  String get score_add_missing_product_stores =>
      'Προσθήκη καταστημάτων προϊόντος που λείπουν';

  @override
  String get score_add_missing_product_brands =>
      'Προσθήκη επωνυμιών προϊόντος που λείπουν';

  @override
  String get score_update_nutrition_facts => 'Ενημέρωση διατροφικών στοιχείων';

  @override
  String get nutrition_page_title => 'Διατροφικά Στοιχεία';

  @override
  String get nutrition_page_nutritional_info_title => 'Διατροφικές πληροφορίες';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Τιμές που καθορίζονται στο προϊόν:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ναι';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Όχι';

  @override
  String get nutrition_page_nutritional_info_open_photo =>
      'Άνοιγμα φωτογραφίας';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Καλές πρακτικές: Διατροφικές πληροφορίες';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Μερικές φορές τα στοιχεία διατροφής **δεν προσδιορίζονται στη συσκευασία** ή σε ένα έγγραφο που παρέχεται με το προϊόν. Σε αυτήν την περίπτωση, και μόνο σε αυτήν την περίπτωση, μπορείτε να ορίσετε την τιμή σε **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'Διατροφικές αξίες:';

  @override
  String get nutrition_page_per_100g => 'ανά 100g';

  @override
  String get nutrition_page_per_100g_100ml => 'ανά 100g/ml';

  @override
  String get nutrition_page_per_serving => 'ανά μερίδα';

  @override
  String get nutrition_page_add_nutrient => 'Προσθέστε ένα θρεπτικό συστατικό';

  @override
  String get nutrition_page_serving_size => 'Μέγεθος μερίδας';

  @override
  String get nutrition_page_serving_size_hint =>
      'Εισαγάγετε ένα μέγεθος μερίδας (πχ. 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Καλές πρακτικές: Μέγεθος μερίδας';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Αυτή η τιμή βοηθά να **κάνουμε έναν ανάλογο υπολογισμό κάθε θρεπτικού συστατικού ανά μέγεθος μερίδας**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Επιτρεπόμενες μονάδες** είναι: kg, g, mg, μg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公公.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** ή **60 G** (προτιμήστε το πρώτο)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** ή **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Μη έγκυρη μονάδα';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Μη έγκυρες μονάδες';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **καραμέλες** και 2 **μπισκότα**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Απουσία μονάδας';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Μη έγκυρος αριθμός';

  @override
  String get nutrition_page_update_running =>
      'Ενημέρωση του προϊόντος στον διακομιστή…';

  @override
  String get nutrition_page_update_done => 'Το προϊόν ενημερώθηκε!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Χρησιμοποιήστε την ποσότητα του προϊόντος ως μέγεθος σερβιρίσματος';

  @override
  String get nutrition_page_photo_error => 'Αδυναμία φόρτωσης φωτογραφίας';

  @override
  String get more_photos => 'Περισσότερες ενδιαφέρουσες φωτογραφίες';

  @override
  String get view_more_photo_button =>
      'Δείτε όλες τις υπάρχουσες φωτογραφίες για αυτό το προϊόν';

  @override
  String get no_product_found => 'Δεν βρέθηκε προϊόν';

  @override
  String get no_location_found => 'Δεν βρέθηκε τοποθεσία';

  @override
  String get not_found => 'δεν βρέθηκε:';

  @override
  String get refreshing_product => 'Ανανέωση προϊόντος';

  @override
  String get product_refreshed => 'Το προϊόν ανανεώθηκε';

  @override
  String product_image_accessibility_label(String date) {
    return 'Η εικόνα λήφθηκε στις $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Η εικόνα λήφθηκε στις $date. Αυτή η εικόνα μπορεί να είναι ξεπερασμένη';
  }

  @override
  String get product_image_outdated =>
      'Αυτή η εικόνα μπορεί να είναι ξεπερασμένη';

  @override
  String get product_image_outdated_explanations_title =>
      'Αυτή η εικόνα μπορεί να είναι ξεπερασμένη';

  @override
  String get product_image_outdated_explanations_content =>
      'Αυτή η εικόνα τραβήχτηκε τουλάχιστον ένα χρόνο πριν.\n**Βεβαιωθείτε ότι είναι ακόμα η πιο πρόσφατη**.\n\nΑυτό είναι **απλώς μια προειδοποίηση**. Εάν το περιεχόμενο εξακολουθεί να είναι το ίδιο, μπορείτε να αγνοήσετε αυτό το μήνυμα.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Αντικατάσταση φωτογραφίας ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Προσθήκη φωτογραφίας ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Λήψη νέας φωτογραφίας';

  @override
  String get product_image_action_take_picture => 'Τραβήξτε μια φωτογραφία';

  @override
  String get product_image_action_from_gallery =>
      'Επιλέξτε από τη συλλογή του τηλεφώνου σας';

  @override
  String get product_image_action_choose_existing_photo =>
      'Επιλέξτε από τις φωτογραφίες του προϊόντος';

  @override
  String get product_image_details_label =>
      'Πληροφορίες σχετικά με τη φωτογραφία';

  @override
  String get product_image_details_from_producer => 'Από τον παραγωγό';

  @override
  String get product_image_details_contributor => 'Συνεισφέρων';

  @override
  String get product_image_details_contributor_producer =>
      'Συνεισφέρων (παραγωγός)';

  @override
  String get product_image_details_date => 'Ημερομηνία';

  @override
  String get product_image_details_date_unknown => 'Άγνωστο';

  @override
  String get homepage_main_card_logo_description =>
      'Καλώς ήρθατε στο Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Σάρωση** γραμμικού κώδικα ή\n**αναζήτηση** για ένα προϊόν';

  @override
  String get homepage_main_card_search_field_hint => 'Αναζητήσετε ένα προϊόν';

  @override
  String get homepage_main_card_search_field_tooltip => 'Έναρξη αναζήτησης';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Τελευταία νέα: $news_title';
  }

  @override
  String get tagline_app_review => 'Σας αρέσει η εφαρμογή;';

  @override
  String get tagline_app_review_button_positive => 'Τη λατρεύω! 😍';

  @override
  String get tagline_app_review_button_negative => 'Μπα…';

  @override
  String get tagline_app_review_button_later => 'Ρωτήστε με αργότερα';

  @override
  String get tagline_feed_news_button => 'Μάθετε περισσότερα';

  @override
  String get app_review_negative_modal_title =>
      'Δεν σας αρέσει η εφαρμογή μας;';

  @override
  String get app_review_negative_modal_text =>
      'Θα μπορούσατε να αφιερώσετε λίγο χρόνο να μας πείτε γιατί;';

  @override
  String get app_review_negative_modal_positive_button => 'Ναι, φυσικά!';

  @override
  String get app_review_negative_modal_negative_button => 'Όχι';

  @override
  String get could_not_refresh => 'Αδυναμία ανανέωσης προϊόντος';

  @override
  String get product_internet_error_modal_title => 'Παρουσιάστηκε σφάλμα!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Δεν μπορούμε να ανακτήσουμε πληροφορίες για αυτό το προϊόν λόγω σφάλματος δικτύου. Ελέγξτε τη σύνδεσή σας στο διαδίκτυο και δοκιμάστε ξανά.\n\nΕσωτερικό σφάλμα:\n$error';
  }

  @override
  String get product_tags_title => 'Ιδιότητες προϊόντος';

  @override
  String get no_product_tags_found_message =>
      'Δεν βρέθηκαν ιδιότητες προϊόντος. Οι ιδιότητες μπορούν να χρησιμοποιηθούν για την περιγραφή των προϊόντων με περισσότερες λεπτομέρειες, με ευέλικτο τρόπο.';

  @override
  String get product_tags_empty => 'Δεν υπάρχουν ακίνητα';

  @override
  String get product_tags_explanation =>
      'Προσθέτοντας ιδιότητες (κλειδί/τιμή) σε ένα προϊόν, βοηθάτε στον εμπλουτισμό του.';

  @override
  String get add_tag => 'Προσθήκη ιδιότητας';

  @override
  String get add_tags => 'Προσθήκη ιδιοτήτων';

  @override
  String get add_edit_tags => 'Προσθήκη ή επεξεργασία ιδιοτήτων';

  @override
  String get edit_tag => 'Επεξεργασία ιδιότητας';

  @override
  String get remove_tag => 'Αφαίρεση ιδιότητας';

  @override
  String get tag_key => 'Ιδιότητα';

  @override
  String get tag_keys => 'Σκηνικά θέατρου';

  @override
  String get tag_key_uneditable => 'Ιδιότητα (μη επεξεργάσιμο)';

  @override
  String get tag_key_input_hint => 'Εισαγάγετε μια ιδιότητα';

  @override
  String get tag_value => 'Τιμή';

  @override
  String get tag_values => 'Αξίες';

  @override
  String get tag_value_input_hint => 'Εισαγάγετε μια τιμή';

  @override
  String get tag_key_item => 'Ιδιότητα:';

  @override
  String get tag_value_item => 'Τιμή:';

  @override
  String get tag_key_explanations =>
      'Ένα κλειδί πρέπει να είναι πεζό και χωρίς κενά.';

  @override
  String tag_key_already_exists(String property) {
    return 'Υπάρχει ήδη μια ετικέτα με ιδιότητα $property!';
  }

  @override
  String get product_internet_error =>
      'Η ανάκτηση πληροφοριών για αυτό το προϊόν ήταν αδύνατη λόγω σφάλματος δικτύου.';

  @override
  String get cached_results_from => 'Εμφάνιση αποτελεσμάτων από:';

  @override
  String get product_search_same_category => 'Βρείτε εναλλακτικές λύσεις';

  @override
  String get product_search_same_category_short => 'Σύγκριση';

  @override
  String get product_search_same_category_error =>
      'Αυτή η δυνατότητα μπορεί να χρησιμοποιηθεί μόνο για προϊόντα με κατηγορία.\n\nΠαρακαλούμε επεξεργαστείτε το προϊόν για να προσθέσετε μια κατηγορία.';

  @override
  String get product_improvement_add_category =>
      'Προσθέστε μια κατηγορία για να υπολογίσετε το Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Προσθέστε διατροφικά στοιχεία για να υπολογίσετε το Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Προσθέστε διατροφικά στοιχεία και κατηγορία για να υπολογίσετε το Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Το Nutri-Score για αυτό το προϊόν δεν μπορεί να υπολογιστεί, κάτι το οποίο μπορεί να οφείλεται π.χ. μια μη τυπική κατηγορία. Αν αυτό το θεωρείται σφάλμα, παρακαλούμε επικοινωνήστε μαζί μας.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Η εικόνα των διατροφικών στοιχείων είναι παρωχημένη: παρακαλώ ανανεώστε τη.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Το Green Score λαμβάνει υπόψη την προέλευση των συστατικών. Παρακαλούμε, βγάλτε μια φωτογραφία του καταλόγου συστατικών ή/και κάθε γεωγραφικό ισχυρισμό ή επεξεργαστείτε το προϊόν, ώστε να μπορούν να ληφθούν υπόψη.';

  @override
  String get country_chooser_label => 'Παρακαλούμε επιλέξτε μια χώρα';

  @override
  String get currency_chooser_label => 'Παρακαλούμε επιλέξτε ένα νόμισμα';

  @override
  String get country_change_message => 'Μόλις αλλάξατε χώρα.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Θέλετε να αλλάξετε το νόμισμα από $previousCurrency σε $possibleCurrency;';
  }

  @override
  String get onboarding_country_chooser_label => 'Παρακαλώ επιλέξτε μια χώρα:';

  @override
  String get country_chooser_label_from_settings => 'Η χώρα σας';

  @override
  String get country_selection_explanation =>
      'Ορισμένα περιβαλλοντικά χαρακτηριστικά εξαρτώνται από την τοποθεσία σας';

  @override
  String get product_removed_comparison =>
      'Το προϊόν αφαιρέθηκε από τη σύγκριση';

  @override
  String get native_app_settings => 'Ρυθμίσεις Εγγενούς Εφαρμογής';

  @override
  String get native_app_description =>
      'Ανοίξτε τις ρυθμίσεις συστήματος για Open Food Facts';

  @override
  String get product_removed_history => 'Το προϊόν αφαιρέθηκε από το ιστορικό';

  @override
  String get product_removed_list => 'Το προϊόν αφαιρέθηκε από τη λίστα';

  @override
  String get product_could_not_remove =>
      'Δεν ήταν δυνατή η αφαίρεση του προϊόντος';

  @override
  String get no_prodcut_in_list => 'Δεν υπάρχει προϊόν σε αυτή τη λίστα';

  @override
  String get no_product_in_section => 'Δεν υπάρχει προϊόν σε αυτήν την ενότητα';

  @override
  String get recently_seen_products => 'Όλα τα προβεβλημένα προϊόντα';

  @override
  String get clear => 'Εκκαθάριση';

  @override
  String get clear_long => 'Άδειασμα λίστας';

  @override
  String get really_clear => 'Θέλετε πραγματικά να διαγράψετε αυτή τη λίστα;';

  @override
  String pct_match(Object percent) {
    return '$percent% αντιστοιχία';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count μέρες πριν',
      one: 'μια μέρα πριν',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ώρες πριν',
      one: 'μία ώρα πριν',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count λεπτά πριν',
      one: 'ένα λεπτό πριν',
      zero: 'λιγότερο από ένα λεπτό πριν',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count μήνες πριν',
      one: 'ένα μήνα πριν',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count εβδομάδες πριν',
      one: 'μία εβδομάδα πριν',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Συγκρίνετε $count Προϊόντα',
      one: 'Συγκρίνετε ένα Προϊόν',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count επιλεγμένα προϊόντα',
      one: 'Ένα επιλεγμένο προϊόν',
      zero: 'Κανένα επιλεγμένο προϊόν',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Σύγκριση επιλεγμένων προϊόντων';

  @override
  String get delete_products_mode => 'Διαγραφή επιλεγμένων προϊόντων';

  @override
  String get select_all_products_mode => 'Επιλέξτε όλα τα προϊόντα';

  @override
  String get select_none_products_mode => 'Επιλογή κανενός';

  @override
  String get compare_products_appbar_title => 'Σύγκριση προϊόντων';

  @override
  String get compare_products_appbar_subtitle =>
      'Παρακαλώ επιλέξτε τουλάχιστον δύο προϊόντα';

  @override
  String get retry_button_label => 'Προσπαθήστε ξανά';

  @override
  String get connect_with_us => 'Συνδεθείτε μαζί μας';

  @override
  String get tiktok => 'Ακολουθήστε μας στο TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Ακολουθήστε μας στο Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Ακολουθήστε μας στο X (πρώην Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Ακολουθήστε μας στο Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Ακολουθήστε μας στο BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Ιστολόγιο';

  @override
  String get faq => 'Συχνές ερωτήσεις';

  @override
  String get discover => 'Ανακαλύψτε';

  @override
  String get how_to_contribute => 'Πώς να Συνεισφέρετε';

  @override
  String get hint_knowledge_panel_message =>
      'Μπορείτε να πατήσετε σε οποιοδήποτε μέρος της κάρτας για περισσότερες λεπτομέρειες σχετικά με το τι βλέπετε. Δοκιμάστε το τώρα!';

  @override
  String get permissions_page_title => 'Πρόσβαση στην Κάμερα';

  @override
  String get permissions_page_body1 =>
      'Για να σαρώσετε γραμμικούς κώδικες με την κάμερα του τηλεφώνου σας, παρακαλούμε Εξουσιοδοτήστε την πρόσβαση.';

  @override
  String get permissions_page_body2 =>
      'Αν αλλάξετε γνώμη, αυτή η επιλογή μπορεί να ενεργοποιηθεί και να απενεργοποιηθεί ανά πάσα στιγμή από τις ρυθμίσεις.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Έκδοση: $release)\nΜοντέλο: $model\nΠροϊόν: $product\nΣυσκευή: $device\nΜάρκα:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nΜοντέλο: $model\nΤοπικό μοντέλο: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nΈκδοση εφαρμογής:$appVersion\nΑριθμός έκδοσης εφαρμογής:$appBuildNumber\nΌνομα πακέτου εφαρμογής:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Εξουσιοδότηση';

  @override
  String get refuse_button_label => 'Απόρριψη';

  @override
  String get ask_me_later_button_label => 'Αργότερα';

  @override
  String get are_you_sure => 'Σίγουρα;';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Εμβαθύνετε στο $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Καλώς ορίσατε!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Η εφαρμογή που σας βοηθά να επιλέξετε φαγητό που είναι καλό για **εσάς** και τον **πλανήτη**!';

  @override
  String get onboarding_continue_button => 'Συνέχεια';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Φόρτωση του πρώτου παραδείγματος προϊόντος σας';

  @override
  String get onboarding_welcome_warning =>
      'Λυπούμαστε, είναι το παράδειγμα προϊόντος μας, δεν μπορείτε να το επεξεργαστείτε :)';

  @override
  String get product_list_your_ranking => 'Η κατάταξή σας';

  @override
  String get product_list_empty_icon_desc => 'Μη διαθέσιμο ιστορικό';

  @override
  String get product_list_empty_title => 'Ξεκινήστε τη σάρωση';

  @override
  String get product_list_empty_message =>
      'Τα σαρωμένα προϊόντα θα εμφανιστούν εδώ και μπορείτε να ελέγξετε αναλυτικές πληροφορίες γι \'αυτά';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'προϊόντων',
      one: 'προϊόντος',
      zero: 'προϊόντος',
    );
    return 'Ανανέωση $_temp0 στο ιστορικό σας';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'προϊόντων',
      one: 'προϊόντος',
      zero: 'προϊόντος',
    );
    return 'Η ανανέωση $_temp0 ολοκληρώθηκε';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Λήψη δεδομένων';

  @override
  String get loading_dialog_default_error_message =>
      'Δεν ήταν δυνατή η λήψη δεδομένων';

  @override
  String get account_delete => 'Διαγραφή λογαριασμού';

  @override
  String get account_delete_title => 'Διαγραφή του λογαριασμού μου';

  @override
  String get user_profile => 'Λογαριασμός';

  @override
  String get user_profile_title_guest => 'Καλώς ήρθατε!';

  @override
  String get user_profile_subtitle_guest =>
      'Συνδεθείτε ή εγγραφείτε για να γίνετε μέλος στην κοινότητα Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts σύνδεση: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Καλώς ήρθατε $id!';
  }

  @override
  String get email_subject_account_deletion => 'Διαγραφή λογαριασμού';

  @override
  String email_body_account_deletion(String userId) {
    return 'Γεια σας, διαγράψτε τον λογαριασμό μου Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Εφαρμογή';

  @override
  String get settings_app_data => 'Χαρακτηριστικά & Παρακολούθηση σφαλμάτων';

  @override
  String get settings_app_camera => 'Κάμερα';

  @override
  String get settings_app_products => 'Προϊόντα';

  @override
  String get settings_app_miscellaneous => 'Διάφορα';

  @override
  String get camera_play_sound_title => 'Αναπαραγωγή ήχου κατά τη σάρωση';

  @override
  String get camera_play_sound_subtitle =>
      'Ένας ήχος θα αναπαράγεται σε κάθε επιτυχημένη σάρωση';

  @override
  String get camera_window_accessibility_label =>
      'Σαρώστε έναν γραμμωτό κώδικα με την κάμερά σας';

  @override
  String get app_haptic_feedback_title => 'Δόνηση & Απτικά';

  @override
  String get app_haptic_feedback_subtitle =>
      'Δονήσεις μετά την εκτέλεση ορισμένων ενεργειών (αποκωδικοποιήθηκε ο γραμμωτός κώδικας, το προϊόν αφαιρέθηκε…).';

  @override
  String get crash_reporting_toggle_title => 'Αναφορά σφαλμάτων';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Όταν είναι ενεργό, οι αναφορές σφαλμάτων υποβάλλονται αυτόματα στο σύστημα εντοπισμού σφαλμάτων του Open Food Facts, έτσι ώστε τα σφάλματα να μπορούν να διορθωθούν και συνεπώς να βελτιωθεί η εφαρμογή.';

  @override
  String get send_anonymous_data_toggle_title => 'Αποστολή ανώνυμων δεδομένων';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Όταν ενεργοποιηθεί, οι αυστηρά ανώνυμες πληροφορίες σχετικά με τη χρήση λειτουργιών θα αποστέλλονται στους διακομιστές Open Food Facts, ώστε να κατανοήσουμε πώς χρησιμοποιούνται οι λειτουργίες για τη βελτίωσή τους. Διαφορετικά, θα σταλεί ένα αναγνωριστικό 0.';

  @override
  String get product_edit_photo_title => 'Επεξεργασία Φωτογραφίας';

  @override
  String get permission_photo_error => 'Σφάλμα';

  @override
  String get permission_photo_denied_title =>
      'Επιτρέψτε τη χρήση της κάμερας για τη σάρωση γραμμωτών κωδικών';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Για βελτιωμένη εμπειρία, παρακαλώ επιτρέψτε στο $appName να έχει πρόσβαση στην κάμερα σας. Θα μπορείτε να σαρώσετε απευθείας γραμμωτούς κωδικούς.';
  }

  @override
  String get permission_photo_denied_button => 'Να επιτρέπεται';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Άρνηση πρόσβασης';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Καθώς έχετε αρνηθεί στο παρελθόν την άδεια της κάμερας, πρέπει να την επιτρέψετε χειροκίνητα από τις Ρυθμίσεις.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Ανοίξτε τις ρυθμίσεις';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Ακύρωση';

  @override
  String get permission_photo_none_found => 'Δεν εντοπίστηκε κάμερα';

  @override
  String get permission_photo_denied =>
      'Δεν έχει χορηγηθεί πρόσβαση στην κάμερα';

  @override
  String get show_product_pictures => 'Εμφάνιση εικόνων προϊόντων';

  @override
  String get edit_product_label => 'Επεξεργασία προϊόντος';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Μεταφόρτωση των αλλαγών σας…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Οι αλλαγές σας **αποστέλλονται στο παρασκήνιο** (ή αργότερα σε περίπτωση σφάλματος).\nΜπορείτε να συνεχίσετε την επεξεργασία άλλων πεδίων προϊόντος.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Οι τροποποιήσεις σας **αποστέλλονται στο παρασκήνιο** (ή αργότερα σε περίπτωση σφάλματος).';

  @override
  String get edit_product_label_short => 'Επεξεργασία';

  @override
  String edit_product_form_item_help(String value) {
    return 'Πώς να εισάγετε \"$value\";';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Παρακαλώ εισάγετε μια μη κενή τιμή!';

  @override
  String get edit_product_form_item_error_existing =>
      'Αυτή η τιμή είναι ήδη εκεί!';

  @override
  String get edit_product_form_item_add_action_brand => 'Προσθήκη νέας μάρκας';

  @override
  String get edit_product_form_item_add_action_label =>
      'Προσθήκη νέας ετικέτας';

  @override
  String get edit_product_form_item_add_action_store =>
      'Προσθήκη νέου καταστήματος';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Προσθήκη νέας προέλευσης';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Προσθήκη νέου κώδικα ιχνηλασιμότητας';

  @override
  String get edit_product_form_item_add_action_country => 'Προσθήκη νέας χώρας';

  @override
  String get edit_product_form_item_add_action_category =>
      'Προσθήκη νέας κατηγορίας';

  @override
  String get edit_product_form_item_add_action_trace => 'Προσθήκη νέου ίχνους';

  @override
  String get edit_product_form_item_add_suggestion => 'Προσθήκη πρότασης';

  @override
  String get edit_product_form_item_deny_suggestion => 'Απόρριψη πρότασης';

  @override
  String get edit_product_form_item_details_title => 'Βασικές λεπτομέρειες';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Ονομασία προϊόντος, μάρκα, ποσότητα';

  @override
  String get edit_product_form_item_other_details_title =>
      'Πρόσθετες λεπτομέρειες';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Ιστότοπος…';

  @override
  String get edit_product_form_item_photos_title => 'Φωτογραφίες';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Προσθήκη ή ανανέωση φωτογραφιών';

  @override
  String get edit_product_form_item_labels_title => 'Ετικέτες & Πιστοποιήσεις';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Ετικέτες Περιβαλλοντικές, Ποιότητας…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Εισαγάγετε μια ετικέτα (πχ: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'ετικέτα';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Καλές πρακτικές: Ετικέτες';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Οποιοδήποτε χαρακτηριστικό του προϊόντος **το οποίο είναι πραγματικό** και διαφορετικό από τα άλλα πεδία.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Κατασκευάζεται στο Βέλγιο, παράγεται στη Βρετάνη…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Πλούσιο σε φυτικές ίνες, πηγή σιδήρου…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Δίκαιο εμπόριο, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Καταστήματα';

  @override
  String get edit_product_form_item_stores_hint => 'Εισαγάγετε ένα κατάστημα';

  @override
  String get edit_product_form_item_stores_type => 'κατάστημα';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Καλές πρακτικές: Καταστήματα';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Εισαγάγετε το κατάστημα από το οποίο αγοράσατε το προϊόν.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Προελεύσεις';

  @override
  String get edit_product_form_item_origins_hint =>
      'Εισαγάγετε μια προέλευση (πχ: βόειο κρέας από την Αργεντινή)';

  @override
  String get edit_product_form_item_origins_type => 'χώρα';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Καλές πρακτικές: Προέλευση';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Προσθέστε **τυχόν ενδείξεις προέλευσης που μπορείτε να βρείτε στη συσκευασία**.\nΔεν χρειάζεται να ανησυχείτε για την προέλευση που αναφέρεται απευθείας στη λίστα συστατικών.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Βοδινό κρέας από την Αργεντινή';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Η σόγια δεν προέρχεται από την Ευρωπαϊκή Ένωση';

  @override
  String get edit_product_form_item_countries_title => 'Χώρα';

  @override
  String get edit_product_form_item_countries_hint =>
      'Εισαγάγετε μια χώρα (πχ: Γερμανία)';

  @override
  String get edit_product_form_item_countries_type => 'χώρα';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Καλές πρακτικές: Χώρες';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Χώρες όπου το προϊόν είναι ευρέως διαθέσιμο** (εκτός από καταστήματα που ειδικεύονται σε ξένα προϊόντα).';

  @override
  String get edit_product_form_item_emb_codes_title =>
      'Κωδικοί ιχνηλασιμότητας';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Εισαγάγετε έναν κωδικό (πχ: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'κωδικός ιχνηλασιμότητας';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Ορθές πρακτικές: Κωδικοί ιχνηλασιμότητας';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'Σε αυτήν την ενότητα, μπορείτε να εισαγάγετε κωδικούς που σχετίζονται με **σήματα συσκευασίας**, **σήματα αναγνώρισης** ή **σήματα υγείας**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Παραδείγματα κωδικών ιχνηλασιμότητας';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Κωδικοί EC** που χρησιμοποιούνται στην Ευρωπαϊκή Κοινότητα για την αναγνώριση των παραγωγών ή των συσκευαστών τροφίμων:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: κωδικός χώρας **Γαλλία**\n**72.264.002**: γεωγραφικά στοιχεία\n**CE**: Ευρωπαϊκή Κοινότητα';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Κωδικοί EMB** που χρησιμοποιούνται στη Γαλλία:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Ίχνη';

  @override
  String get edit_product_form_item_traces_hint => 'ίχνος';

  @override
  String get edit_product_form_item_traces_type =>
      'Εισαγάγετε ένα ίχνος (πχ: φασόλια σόγιας)';

  @override
  String get edit_product_form_item_categories_title => 'Κατηγορίες';

  @override
  String get edit_product_form_item_categories_hint => 'κατηγορία';

  @override
  String get edit_product_form_item_categories_type =>
      'Εισαγάγετε μια κατηγορία (πχ: χυμός πορτοκαλιού)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Καλές πρακτικές: Κατηγορίες';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Υποδείξτε **μόνο την πιο συγκεκριμένη κατηγορία**.\nΟι γονικές κατηγορίες θα προστεθούν αυτόματα.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Λείπει κατηγορία;';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'Σε περίπτωση που μια κατηγορία **δεν είναι διαθέσιμη στην αυτόματη συμπλήρωση**, μη διστάσετε να την προσθέσετε ούτως ή άλλως.\nΑυτό θα μας βοηθήσει να βελτιώσουμε τα Open Food Facts στη χώρα σας.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Σαρδέλες σε ελαιόλαδο';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Χυμός πορτοκαλιού από συμπύκνωμα';

  @override
  String get edit_product_form_item_exit_title => 'Έξοδος χωρίς αποθήκευση;';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Θέλετε να αποθηκεύσετε τις αλλαγές σας πριν από την έξοδο από αυτή τη σελίδα;';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Αποθήκευση αλλαγών';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Απόρριψη αλλαγών';

  @override
  String get edit_product_form_item_ingredients_title => 'Συστατικά';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Μεγέθυνση και σμίκρυνση τσιμπώντας την οθόνη';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Μεγέθυνση και σμίκρυνση της φωτογραφίας';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Χρησιμοποιώντας τη χειρονομία **Pinch-to-zoom**, μπορείτε να κάνετε μεγέθυνση ή σμίκρυνση της φωτογραφίας:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Προσθήκη';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Παρακαλώ εισάγετε ένα κείμενο πρώτα';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Αφαίρεση';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Αποθηκεύστε την επεξεργασία σας';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Ακυρώστε την επεξεργασία σας';

  @override
  String get edit_product_form_item_packaging_title =>
      'Φωτογραφία οδηγιών ανακύκλωσης';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Διατροφικά στοιχεία';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Διατροφή, περιεκτικότητα σε αλκοόλ…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Καλές πρακτικές: Διατροφικά στοιχεία';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Διατροφικές τιμές';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Αρχικά, επιλέξτε εάν παρέχονται οι **τιμές**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Διατροφικά στοιχεία';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Στη συνέχεια, εισάγετε τις θρεπτικές αξίες **όπως αναγράφονται στη συσκευασία**. Εάν δεν υπάρχει τιμή, μπορείτε να κάνετε κλικ στο εικονίδιο \"Μάτι\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Λείπει πεδίο;';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Εάν λείπει μια καταχώριση, μπορείτε **κάντε κλικ στο εικονίδιο \"Συν\"** για να την προσθέσετε (πχ: βιταμίνη D, μαγνήσιο…).';

  @override
  String get edit_product_form_save => 'Επεξεργασία';

  @override
  String get edit_product_ingredients_photo_title => 'Φωτογραφία συστατικών';

  @override
  String get edit_product_ingredients_list_title => 'List of ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Φωτογραφία συσκευασίας';

  @override
  String get edit_product_packaging_list_title => 'Λίστα συσκευασίας';

  @override
  String get no_data_available => 'Δεν υπάρχουν διαθέσιμα δεδομένα';

  @override
  String get product_field_website_title => 'Ιστοσελίδα';

  @override
  String get origins_editing_title => 'Επεξεργασία Προέλευσης';

  @override
  String get completed_basic_details_btn_text =>
      'Συμπληρώστε βασικές λεπτομέρειες';

  @override
  String get not_implemented_snackbar_text => 'Δεν έχει υλοποιηθεί ακόμη';

  @override
  String get category_picker_page_appbar_text => 'Κατηγορίες';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Εξαγωγή συστατικών από τη φωτογραφία';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Εξαγωγή συστατικών';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Εξαγωγή συστατικών\nαπό τη φωτογραφία';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Φόρτωση φωτογραφίας…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Γιατί βλέπω αυτό το μήνυμα;';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Για να χρησιμοποιήσετε τη λειτουργία \"Εξαγωγή συστατικών\", πρέπει πρώτα να ανεβάσετε τη φωτογραφία.\n\nΠεριμένετε μερικά δευτερόλεπτα ή εισάγετέ τα χειροκίνητα.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Ανανέωση φωτογραφίας';

  @override
  String get edit_packaging_extract_btn_text =>
      'Εξαγωγή συσκευασίας\nαπό τη φωτογραφία';

  @override
  String get edit_packaging_extract_btn_text_short => 'Εξαγωγή συσκευασίας';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Γίνεται εξαγωγή συσκευασίας από τη φωτογραφία';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Φόρτωση φωτογραφίας…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Γιατί βλέπω αυτό το μήνυμα;';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Για να χρησιμοποιήσετε τη λειτουργία \"Εξαγωγή συσκευασίας\", πρέπει πρώτα να μεταφορτωθεί η φωτογραφία.\n\nΠεριμένετε μερικά δευτερόλεπτα ή εισάγετέ τα χειροκίνητα.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Ανανέωση φωτογραφίας';

  @override
  String get edit_ocr_extract_failed =>
      'Αποτυχία εντοπισμού κειμένου στην εικόνα.';

  @override
  String get edit_ocr_extract_disabled_title => 'Καμία εικόνα!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Για να χρησιμοποιήσετε τη δυνατότητα εξαγωγής κειμένου, πρέπει πρώτα να τραβήξετε μια φωτογραφία.';

  @override
  String get user_list_dialog_new_title => 'Νέα λίστα προϊόντων';

  @override
  String get user_list_dialog_rename_title => 'Μετονομασία λίστας';

  @override
  String get user_list_subtitle_product => 'Λίστες';

  @override
  String get user_list_title => 'Οι λίστες σας';

  @override
  String get user_list_add_product => 'Προσθέστε το προϊόν στις λίστες σας';

  @override
  String get user_list_button_new => 'Δημιουργία νέας λίστας';

  @override
  String get user_list_empty_label =>
      'Δεν υπάρχει ακόμη διαθέσιμη λίστα!\nΞεκινήστε δημιουργώντας μία.';

  @override
  String get user_list_button_add_product => 'Προσθήκη στη λίστα';

  @override
  String get added_to_list_msg => 'Προστέθηκε στη λίστα';

  @override
  String get user_list_popup_clear => 'Διαγράψτε το ιστορικό σας';

  @override
  String get user_list_popup_rename => 'Μετονομασία';

  @override
  String get user_list_name_hint => 'Η λίστα μου';

  @override
  String get user_list_name_error_empty => 'Το όνομα είναι υποχρεωτικό';

  @override
  String get user_list_name_error_already =>
      'Αυτό το όνομα χρησιμοποιείται ήδη';

  @override
  String get user_list_name_error_same => 'Αυτό είναι το ίδιο όνομα';

  @override
  String get user_list_name_input_hint => 'Όνομα της λίστας';

  @override
  String get try_again => 'Προσπαθήστε Ξανά';

  @override
  String get there_was_an_error => 'Παρουσιάστηκε σφάλμα';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Δε βρέθηκε κατηγορία για το $items';
  }

  @override
  String get camera_toggle_camera =>
      'Εναλλαγή μεταξύ πίσω και μπροστινής κάμερας';

  @override
  String get camera_toggle_flash =>
      'Ενεργοποιήστε ή απενεργοποιήστε το φλας της κάμερας';

  @override
  String get camera_enable_flash => 'Ενεργοποίηση φλας';

  @override
  String get camera_disable_flash => 'Απενεργοποίηση φλας';

  @override
  String get camera_flash_error_dialog_title => 'Προέκυψε σφάλμα!';

  @override
  String get camera_flash_error_dialog_message =>
      'Παρουσιάστηκε σφάλμα κατά την αλλαγή της κατάστασης του φλας. Βεβαιωθείτε ότι το smartphone σας δεν έχει ήδη ενεργοποιημένο τον φακό.';

  @override
  String get category_picker_no_category_found_button => 'Πίσω';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Κάντε κλικ για να ανοίξετε στο πρόγραμμα περιήγησής σας ή στην εφαρμογή (αν είναι εγκατεστημένη)';

  @override
  String get dev_preferences_screen_title => 'Λειτουργία DEV';

  @override
  String get dev_preferences_screen_subtitle =>
      'Πρόσβαση σε πειραματικές λειτουργίες και εργαλεία ανάπτυξης';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Επανεκκινήστε την εμπειρία εισόδου';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Στη συνέχεια, πρέπει να επανεκκινήσετε την εφαρμογή για να το δείτε ξανά.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Εναλλαγή μεταξύ περιβάλλοντος openfoodfacts.org (PROD) και δοκιμών';

  @override
  String get dev_preferences_test_environment_title =>
      'Παράμετροι περιβάλλοντος δοκιμής';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Βασική διεύθυνση URL για τρέχον δοκιμαστικό env: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Οικοδεσπότης περιβάλλοντος δοκιμής';

  @override
  String get dev_preferences_ml_kit_title => 'Χρήση ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'τότε πρέπει να επανεκκινήσετε αυτήν την εφαρμογή';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Επιπλέον κουμπί στη σελίδα του προϊόντος';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Επεξεργασία συστατικών μέσω ενός κουμπιού από τον πίνακα γνώσεων';

  @override
  String get dev_preferences_export_history_title => 'Εξαγωγή Ιστορικού';

  @override
  String get dev_preferences_export_history_progress_error => 'εξαίρεση';

  @override
  String get dev_preferences_export_history_progress_found =>
      'το προϊόν βρέθηκε';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'το προϊόν ΔΕΝ βρέθηκε';

  @override
  String get dev_preferences_export_history_dialog_title => 'Εξαγωγή ιστορικού';

  @override
  String get dev_preferences_button_positive => 'ΟΚ';

  @override
  String get dev_preferences_button_negative => 'Ακύρωση';

  @override
  String get dev_preferences_migration_title => 'Μεταφορά δεδομένων από V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Κατάσταση: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'επιτυχία ή καθαρή εγκατάσταση';

  @override
  String get dev_preferences_migration_status_success => 'επιτυχία';

  @override
  String get dev_preferences_migration_status_error => 'σφάλμα';

  @override
  String get dev_preferences_migration_status_in_progress => 'σε εξέλιξη';

  @override
  String get dev_preferences_migration_status_required =>
      'απαιτείται (κάντε κλικ για έναρξη)';

  @override
  String get dev_preferences_migration_status_not_started => 'άγνωστο';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Το ιστορικό θα σβηστεί και θα τοποθετηθούν 3 προϊόντα εκεί';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Προσαρμοσμένη διεύθυνση URL για ειδήσεις';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL του αρχείου JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Δεν ορίστηκε';

  @override
  String get dev_preferences_news_provider_status_title => 'Κατάσταση';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Τελευταία ανανέωση: $date';
  }

  @override
  String get product_type_label_food => 'Τροφή';

  @override
  String get product_type_label_beauty => 'Προσωπική φροντίδα';

  @override
  String get product_type_label_pet_food => 'Τροφή κατοικιδίων';

  @override
  String get product_type_label_product => 'Άλλο';

  @override
  String get product_type_selection_title => 'Τύπος προϊόντος';

  @override
  String get product_type_selection_subtitle =>
      'Επιλέξτε τον τύπο αυτού του προϊόντος';

  @override
  String get product_type_selection_empty =>
      'Πρέπει πρώτα να επιλέξετε έναν τύπο προϊόντος!';

  @override
  String product_type_selection_already(String productType) {
    return 'Δεν μπορείτε να αλλάξετε τον τύπο προϊόντος ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Συντόμευση στην εφαρμογή Τιμές στη σελίδα προϊόντος';

  @override
  String get prices_app_button => 'Μεταβείτε στην εφαρμογή Τιμές';

  @override
  String get prices_website_button => 'Ανοιχτό στον ιστότοπο Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Προσθήκη ετικετών τιμών απευθείας από τη συλλογή';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Μόλις επιλέξετε εικόνες, δεν θα μπορείτε να τις επεξεργαστείτε!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Επιτρέψτε στην κοινότητα να επικυρώσει τις τιμές που εξάγονται από την Τεχνητή Νοημοσύνη.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Πολλαπλές Ετικέτες Τιμής';

  @override
  String get prices_bulk_proof_upload_title => 'Μεταφόρτωση Μαζικής Απόδειξης';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Επιλογή αρχείων';

  @override
  String get prices_bulk_proof_upload_step_starting =>
      'Έναρξη της μεταφόρτωσης';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Τοπική αντιγραφή αρχείου #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Προετοιμασία μεταφόρτωσης #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Αποτυχία στην εικόνα #$index/$count';
  }

  @override
  String get prices_generic_title => 'Τιμές';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Προσθήκη $count τιμών',
      one: 'Προσθήκη τιμής',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Στείλτε $count τιμές',
      one: 'Στείλτε την τιμή',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Προσθήκη αντικειμένου';

  @override
  String get prices_add_a_price => 'Προσθήκη μίας τιμής';

  @override
  String get prices_add_a_receipt => 'Προσθήκη απόδειξης';

  @override
  String get prices_add_price_tags => 'Προσθήκη ετικετών τιμής';

  @override
  String prices_barcode_already(String barcode) {
    return 'Αυτός ο γραμμωτός κώδικας ($barcode) είναι ήδη στη λίστα!';
  }

  @override
  String get prices_barcode_search_not_found => 'Το προϊόν δεν βρέθηκε';

  @override
  String get prices_barcode_search_none_yet => 'Κανένα προϊόν ακόμα';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Αναζήτηση για $barcode';
  }

  @override
  String get prices_barcode_enter => 'Εισαγάγετε τον Γραμμωτό κώδικα';

  @override
  String get prices_category_enter => 'Προϊόν χωρίς γραμμωτό κώδικα (barcode)';

  @override
  String get prices_per_kilogram => 'Τιμή ανά κιλό';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / κιλό';

  @override
  String get prices_per_unit_short => ' / μονάδα';

  @override
  String get prices_category_mandatory => 'Υποχρεωτικό';

  @override
  String get prices_category_optional => 'Προαιρετικός';

  @override
  String get prices_category_error_mandatory => 'Η κατηγορία είναι υποχρεωτική';

  @override
  String get prices_barcode_reader_action => 'Αναγνώστης γραμμωτού κώδικα';

  @override
  String get prices_view_prices => 'Δείτε τις τιμές';

  @override
  String get prices_list_title => 'Τιμοκατάλογος';

  @override
  String get prices_list_count => 'Αριθμός\nτιμών';

  @override
  String get prices_list_add_new_price => 'Προσθήκη νέας τιμής\n';

  @override
  String get prices_list_empty_title => 'Δεν υπάρχει ακόμη τιμή!';

  @override
  String get prices_list_empty_subtitle =>
      'Γίνετε ο πρώτος που θα προσθέσει ένα:\nΣαρώνοντας μια **απόδειξη** ή μια **τιμή**!';

  @override
  String get prices_entry_shop_not_found => 'Άγνωστο κατάστημα';

  @override
  String prices_entry_menu_title(String user) {
    return 'Εισαγωγή τιμής από \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Δείτε όλες τις τιμές για αυτό το προϊόν';

  @override
  String get prices_entry_menu_open_proof => 'Δείτε την απόδειξη';

  @override
  String get prices_entry_menu_my_prices => 'Δείτε τις υπόλοιπες τιμές μου';

  @override
  String get prices_entry_menu_author_prices =>
      'Δείτε άλλες τιμές από τον συγγραφέα';

  @override
  String get prices_entry_menu_shop_prices =>
      'Δείτε άλλες τιμές από το κατάστημα';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count τιμές',
      one: '1 τιμή',
    );
    return '$_temp0 για $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Και οι $count τιμές',
      one: 'Μόνο μία τιμή',
      zero: 'Καμία τιμή ακόμα',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Τελευταίες $pageSize τιμές (σύνολο: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Τιμή: $price / Κατάστημα: \"$location\" / Δημοσιεύθηκε στις $date από \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Άνοιγμα αποδείξεων του \"$user\"';
  }

  @override
  String get prices_open_proof => 'Άνοιγμα απόδειξης τιμής';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Και οι $count αποδείξεις',
      one: 'Μόνο μία απόδειξη',
      zero: 'Καμία απόδειξη ακόμα',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Τελευταίες $pageSize proofs (σύνολο: $total)';
  }

  @override
  String get prices_users_empty_title => 'Δεν υπάρχει ακόμη συνεργάτης!';

  @override
  String get prices_users_empty_explanation =>
      'Γίνετε ο πρώτος που θα προσθέσει μια τιμή!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Κορυφαίοι $pageSize συνεισφέροντες (σύνολο: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Δεν υπάρχει ακόμα κατάστημα!';

  @override
  String get prices_locations_empty_explanation =>
      'Γίνετε ο πρώτος που θα προσθέσει μια τιμή!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Κορυφαίες $pageSize τοποθεσίες (σύνολο: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count αποδείξεις',
      one: 'Μία απόδειξη',
      zero: 'Καμία απόδειξη',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count προϊόντα',
      one: 'Ένα προϊόν',
      zero: 'Κανένα προϊόν',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count χρήστες',
      one: 'Ένας χρήστης',
      zero: 'Κανένας χρήστης',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count τιμές',
      one: 'Μία τιμή',
      zero: 'Καμία τιμή',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle =>
      'Τιμή που προστέθηκε προηγουμένως';

  @override
  String get prices_amount_subtitle => 'Ποσότητα';

  @override
  String get prices_amount_is_discounted => 'Σε έκπτωση;';

  @override
  String get prices_amount_price_normal => 'Τιμή';

  @override
  String get prices_amount_price_discounted => 'Τιμή με έκπτωση';

  @override
  String get prices_amount_price_not_discounted => 'Αρχική τιμή';

  @override
  String get prices_amount_no_product => 'Ένα προϊόν λείπει!';

  @override
  String get prices_amount_price_incorrect => 'Λάθος τιμή';

  @override
  String get prices_amount_price_mandatory => 'Υποχρεωτική τιμή';

  @override
  String get prices_currency_subtitle => 'Νόμισμα';

  @override
  String get prices_date_subtitle => 'Ημερομηνία';

  @override
  String get prices_location_subtitle => 'Κατάστημα';

  @override
  String get prices_location_find => 'Βρείτε ένα κατάστημα';

  @override
  String get prices_location_mandatory => 'Πρέπει να επιλέξετε ένα κατάστημα!';

  @override
  String get prices_location_search_broader =>
      'Δεν βρήκατε αυτό που ψάχνατε; Ας δοκιμάσουμε μια ευρύτερη αναζήτηση!';

  @override
  String get prices_proof_subtitle => 'Επαλήθευση';

  @override
  String get prices_proof_empty_title => 'Δεν υπάρχει ακόμη απόδειξη!';

  @override
  String get prices_proof_empty_explanation =>
      'Ξεκινήστε προσθέτοντας μια φωτογραφία μιας **απόδειξης** ή μιας **ετικέτας τιμής**!';

  @override
  String get prices_proof_find => 'Επιλέξτε μια απόδειξη';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Απόδειξη';

  @override
  String get prices_proof_price_tag => 'Ετικέτα τιμής';

  @override
  String get prices_proof_mandatory => 'Πρέπει να επιλέξετε μια απόδειξη!';

  @override
  String get prices_add_validation_error => 'Σφάλμα επικύρωσης';

  @override
  String get prices_privacy_warning_title => 'Ειδοποίηση απορρήτου';

  @override
  String get prices_unknown_product => 'Άγνωστο προϊόν';

  @override
  String get prices_privacy_warning_main_message =>
      'Οι τιμές **θα είναι δημόσιες**, μαζί με το κατάστημα στο οποίο αναφέρονται.\n\nΑυτό μπορεί να επιτρέψει σε άτομα που γνωρίζουν το ψευδώνυμό σας Open Food Facts να:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Συμπεράνει σε ποια περιοχή μένετε';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Μάθει τι αγοράζετε';

  @override
  String get prices_privacy_warning_sub_message =>
      'Εάν νιώθετε άβολα με αυτό, αλλάξτε το ψευδώνυμό σας ή δημιουργήστε έναν νέο λογαριασμό Open Food Facts και συνδεθείτε στην εφαρμογή με αυτόν.';

  @override
  String get i_refuse => 'Αρνούμαι';

  @override
  String get i_accept => 'Αποδέχομαι';

  @override
  String get prices_currency_change_proposal_title => 'Αλλαγή του νομίσματος;';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Το τρέχον νόμισμά σας είναι **$currency**. Θέλετε να το αλλάξετε σε **$newCurrency**;';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ναι, χρήση του $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Όχι, διατήρηση του $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Τέλος';

  @override
  String get dev_mode_section_server => 'Διαμόρφωση διακομιστή';

  @override
  String get dev_mode_section_news => 'Διαμόρφωση παρόχου ειδήσεων';

  @override
  String get dev_mode_section_product_page => 'Σελίδα προϊόντος';

  @override
  String get dev_mode_section_ui => 'Διεπαφή Χρήστη';

  @override
  String get dev_mode_section_experimental_features =>
      'Πειραματικές δυνατότητες';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Εξαίρεση του Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Χρήση ορθογραφικού ελέγχου για οθόνες OCR';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Συστατικά και συσκευασία)';

  @override
  String get dev_mode_reset_app_language_title => 'Επαναφορά γλώσσας εφαρμογής';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Προσθήκη καρτών';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Εναλλαγή μεταξύ prices.openfoodfacts.org (PROD) και περιβάλλοντος δοκιμής';

  @override
  String get search_history_item_edit_tooltip =>
      'Επαναχρησιμοποίηση και επεξεργασία αυτής της αναζήτησης';

  @override
  String get search_history_item_remove_tooltip => 'Αφαίρεση';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Έχετε κατεβάσει και τα $totalSize προϊόντα.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Λήψη $count ακόμη προϊόντων\nΈχει ήδη γίνει λήψη $downloaded από $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Η αναζήτησή σας για $search είναι σε εξέλιξη.\n\nΠεριμένετε λίγα δευτερόλεπτα…';
  }

  @override
  String get user_search_contributor_title => 'Προϊόντα που πρόσθεσα';

  @override
  String get user_search_informer_title => 'Προϊόντα που επεξεργάστηκα';

  @override
  String get user_search_photographer_title => 'Προϊόντα που φωτογράφισα';

  @override
  String get user_search_to_be_completed_title =>
      'Τα προς ολοκλήρωση προϊόντα μου';

  @override
  String get user_search_prices_title => 'Οι τιμές μου';

  @override
  String get user_search_proofs_title => 'Οι επαληθεύσεις μου';

  @override
  String get user_search_proof_title => 'Η απόδειξή μου';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Τιμές συνεργατών: $user';
  }

  @override
  String get all_search_prices_latest_title =>
      'Προστέθηκαν οι πιο Πρόσφατες Τιμές';

  @override
  String get all_search_prices_top_user_title =>
      'Κορυφαίοι συνεισφέροντες τιμών';

  @override
  String get all_search_prices_top_location_title =>
      'Καταστήματα με τις περισσότερες τιμές';

  @override
  String get prices_contribution_assistant => 'Βοηθός Συνεισφοράς Τιμής';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Προσθήκη Πολλαπλών Επαληθεύσεων';

  @override
  String get all_search_prices_top_location_single_title =>
      'Τιμές σε ένα κατάστημα';

  @override
  String get all_search_prices_top_product_title =>
      'Προϊόντα με τις περισσότερες τιμές';

  @override
  String get all_search_to_be_completed_title =>
      'Όλα τα προς ολοκλήρωση προϊόντα';

  @override
  String get categorize_products_country_title =>
      'Βοηθήστε στην κατηγοριοποίηση των προϊόντων στη χώρα σας';

  @override
  String get edit_product_action_retake_picture => 'Λήψη φωτογραφίας ξανά';

  @override
  String get edit_product_action_take_picture => 'Λήψη φωτογραφίας';

  @override
  String get edit_product_action_confirm => 'Επιβεβαίωση';

  @override
  String get signup_page_terms_of_use_line1 => 'Συμφωνώ με το Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      'τους όρους χρήσης και συνεισφοράς';

  @override
  String get analytics_consent_image_semantic_label => 'Εικονίδιο Analytics';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Μοιραίο σφάλμα: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Μοιραίο σφάλμα: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Συμπληρώστε βασικές λεπτομέρειες';

  @override
  String get edit_photo_button_label => 'Επεξεργασία';

  @override
  String get edit_photo_unselect_button_label => 'Αποεπιλογή φωτογραφίας';

  @override
  String get edit_photo_select_existing_button_label =>
      'Επιλέξτε μια υπάρχουσα εικόνα';

  @override
  String get edit_photo_select_existing_all_label => 'Υπάρχουσες εικόνες';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Επιλέξτε μια εικόνα κάνοντας κλικ πάνω της';

  @override
  String get edit_photo_select_existing_download_label =>
      'Ανάκτηση υπαρχουσών εικόνων…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Δεν υπάρχουν εικόνες που έχουν μεταφορτωθεί στο παρελθόν σχετικά με αυτό το προϊόν.';

  @override
  String get edit_photo_language_not_this_one =>
      'Δεν υπάρχει ακόμα εικόνα σε αυτή τη γλώσσα';

  @override
  String get edit_photo_language_none => 'Καμία εικόνα ακόμα';

  @override
  String get category_picker_screen_title => 'Κατηγορίες';

  @override
  String get basic_details => 'Βασικές Λεπτομέρειες';

  @override
  String get product_name => 'Όνομα Προϊόντος';

  @override
  String get product_names => 'Ονόματα Προϊόντων';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Προσθήκη νέας μετάφρασης';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Πριν από την επικύρωση, βεβαιωθείτε ότι προσθέτετε μία μετάφραση **μόνο αν υπάρχει η γλώσσα στη συσκευασία**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Προβολή μπροστινής φωτογραφίας';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Λήψη μπροστινής φωτογραφίας';

  @override
  String get add_basic_details_product_name_hint =>
      'Εισαγάγετε το όνομα του προϊόντος (πχ Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Αλλαγή της προεπιλεγμένης γλώσσας;';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Θέλετε η προεπιλεγμένη γλώσσα του προϊόντος να οριστεί σε \'$language\';';
  }

  @override
  String get explanation_section_good_examples => 'Καλά παραδείγματα';

  @override
  String get explanation_section_bad_examples => 'Κακά παραδείγματα';

  @override
  String get add_basic_details_product_name_help_title =>
      'Καλές πρακτικές: Όνομα προϊόντος';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Το όνομα του προϊόντος είναι το **κύριο όνομα που αναγράφεται στη συσκευασία**. Μπορεί να είναι σήμα κατατεθέν.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Σημείωση:** Μην προσθέτετε μετάφραση **εάν η γλώσσα δεν υπάρχει στη συσκευασία**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Κέτσαπ ντομάτας';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Μην συμπεριλάβετε την επωνυμία στο όνομα';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Κέτσαπ ντομάτας **από Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Μην χρησιμοποιείτε σύμβολα ®, ™, © ή παρόμοια';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count άλλες μεταφράσεις',
      one: '$count άλλη μετάφραση',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Μάρκα';

  @override
  String get brand_names => 'Επωνυμίες';

  @override
  String get add_basic_details_brand_name_error =>
      'Παρακαλώ εισάγετε το όνομα της μάρκας';

  @override
  String get add_basic_details_brand_names_hint =>
      'Εισάγετε επωνυμίες (πχ: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Καλές πρακτικές: Μάρκες';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Εισαγάγετε **όλες τις μάρκες του προϊόντος**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Κύρια μάρκα';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'Η **κύρια μάρκα**, που εμφανίζεται γενικά καθαρά στο μπροστινό πακέτο, θα πρέπει να εισαχθεί πρώτα**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Άλλες μάρκες';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Όταν πουλήθηκε **από μια μεγάλη εταιρεία**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      'Το **Actimel** πωλείται από την **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Όταν πωλείται με την επωνυμία του **μεταφρασμένο σε πολλές γλώσσες**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      'Η **Nature Valley** μερικές φορές γράφεται **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Ποσότητα και βάρος';

  @override
  String get add_basic_details_quantity_hint =>
      'Εισαγάγετε το βάρος και εάν χρειάζεται την ποσότητα (πχ: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Καλές πρακτικές: Ποσότητα';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Αντιγράψτε την τιμή που αναγράφεται στο προϊόν και **μην ξεχνάτε τις μονάδες**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** ή **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (για 6 αυγά)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(για ένα προϊόν με 3 κουτιά, το καθένα των 150g)';

  @override
  String get barcode => 'Γραμμικός κωδικός';

  @override
  String barcode_barcode(String barcode) {
    return 'Γραμμωτός κωδικός: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Μη έγκυρος γραμμικός κώδικας';

  @override
  String get basic_details_add_success =>
      'Οι βασικές λεπτομέρειες προστέθηκαν με επιτυχία';

  @override
  String get basic_details_add_error =>
      'Δεν είναι δυνατή η προσθήκη βασικών λεπτομερειών. Παρακαλώ προσπαθήστε ξανά μετά από κάποιο χρονικό διάστημα';

  @override
  String get clear_search => 'Καθαρίστε την αναζήτησή σας';

  @override
  String get confirm_clear =>
      'Πρόκειται να διαγράψετε ολόκληρο το ιστορικό σας: είστε βέβαιοι ότι θέλετε να συνεχίσετε;';

  @override
  String get alert_clear_selected_user_list =>
      'Πρόκειται να διαγράψετε επιλεγμένα στοιχεία από το ιστορικό σας';

  @override
  String get confirm_clear_selected_user_list =>
      'Είστε βέβαιοι ότι θέλετε να συνεχίσετε;';

  @override
  String get alert_select_items_to_clear =>
      'Επιλέξτε ένα ή περισσότερα στοιχεία για εκκαθάριση';

  @override
  String confirm_clear_user_list(String name) {
    return 'Πρόκειται να διαγράψετε αυτήν τη λίστα ($name): είστε βέβαιοι ότι θέλετε να συνεχίσετε;';
  }

  @override
  String get confirm_delete_user_list_title => 'Διαγραφή της λίστας;';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Πρόκειται να διαγράψετε τη λίστα \"$name\". Είστε βέβαιοι ότι θέλετε να συνεχίσετε;';
  }

  @override
  String get confirm_delete_user_list_button => 'Ναι, το επιβεβαιώνω';

  @override
  String importance_label(String name, String id) {
    return '$name σημασία: $id';
  }

  @override
  String get user_list_all_title => 'Λίστες';

  @override
  String get user_list_all_empty => 'Δημιουργήστε την πρώτη σας λίστα';

  @override
  String get product_list_select => 'Επιλέξτε μία λίστα';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count προϊόντα',
      one: 'Ένα προϊόν',
      zero: 'Κενή λίστα',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Προσθήκη λίστας';

  @override
  String get open_food_preferences_tooltip =>
      'Επεξεργαστείτε τις διατροφικές σας προτιμήσεις';

  @override
  String get add_photo_button_label => 'Προσθήκη φωτογραφίας';

  @override
  String get add_packaging_photo_button_label =>
      'Λήψη φωτογραφιών για πληροφορίες συσκευασίας/ανακύκλωσης';

  @override
  String get add_origin_photo_button_label =>
      'Τραβήξτε φωτογραφίες οποιασδήποτε πληροφορίας προέλευσης';

  @override
  String get add_emb_photo_button_label =>
      'Τραβήξτε φωτογραφίες οποιασδήποτε πληροφορίας κωδικού ιχνηλασιμότητας';

  @override
  String get add_label_photo_button_label =>
      'Τραβήξτε φωτογραφίες για πληροφορίες ετικετών & πιστοποιήσεων';

  @override
  String get choose_image_source_title => 'Επιλέξτε πηγή εικόνας';

  @override
  String get choose_image_source_body => 'Παρακαλώ επιλέξτε μια πηγή εικόνας';

  @override
  String get gallery_source_label => 'Συλλογή';

  @override
  String get gallery_source_access_denied_dialog_title =>
      'Δεν επιτρέπεται η πρόσβαση';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Δυστυχώς, η εφαρμογή δεν μπορεί να έχει πρόσβαση στη συλλογή σας, καθώς έχετε αρνηθεί στο παρελθόν την άδεια.\n\nΜεταβείτε στις ρυθμίσεις της εφαρμογής στις Ρυθμίσεις του τηλεφώνου σας -> Φωτογραφίες';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Ανοίξτε τις Ρυθμίσεις';

  @override
  String get share => 'Κοινοποίηση';

  @override
  String share_product_text(String url) {
    return 'Ρίξτε μια ματιά σε αυτό το προϊόν στο Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Ρίξτε μια ματιά σε αυτό το προϊόν στο Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Ρίξτε μια ματιά σε αυτό το προϊόν στο Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Ρίξτε μια ματιά σε αυτό το προϊόν στο Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Ρίξτε μια ματιά στη λίστα των προϊόντων μου στο Open Food Facts: $url';
  }

  @override
  String get capture => 'Λήψη νέας φωτογραφίας';

  @override
  String get capture_new_picture => 'Τραβήξτε μια φωτογραφία';

  @override
  String get choose_from_gallery => 'Επιλέξτε από τη συλλογή';

  @override
  String get image_upload_queued =>
      'Η εικόνα θα μεταφορτωθεί στο παρασκήνιο το συντομότερο δυνατό.';

  @override
  String get add_price_queued =>
      'Η τιμή θα σταλεί στον διακομιστή το συντομότερο δυνατό.';

  @override
  String get background_task_title_full_refresh =>
      'Έναρξη ανανέωσης όλων των προϊόντων που είναι αποθηκευμένα τοπικά';

  @override
  String get background_task_title_top_n =>
      'Έναρξη λήψης των πιο δημοφιλών προϊόντων';

  @override
  String get expand_nutrition_facts => 'Επέκταση πίνακα διατροφικών στοιχείων';

  @override
  String get expand_nutrition_facts_body =>
      'Διατήρηση πίνακα διατροφικών στοιχείων εκτεταμένο';

  @override
  String get expand_ingredients => 'Επέκταση συστατικών';

  @override
  String get expand_ingredients_body =>
      'Διατήρηση πίνακα συστατικών εκτεταμένο';

  @override
  String get no_internet_connection => 'Χωρίς σύνδεση στο διαδίκτυο';

  @override
  String get world_results_label => 'Όλος ο κόσμος';

  @override
  String get world_results_action => 'Επέκταση της αναζήτησής σας στον κόσμο';

  @override
  String get copy_to_clipboard => 'Αντιγραφή';

  @override
  String get paste_from_clipboard => 'Επικόλληση από το πρόχειρο';

  @override
  String get no_data_available_in_clipboard =>
      'Δεν υπάρχουν διαθέσιμα δεδομένα στο πρόχειρό σας';

  @override
  String get clipboard_barcode_copy =>
      'Αντιγράψτε τον γραμμωτό κώδικα στο πρόχειρο';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Ο γραμμωτός κώδικας $barcode αντιγράφηκε στο πρόχειρο!';
  }

  @override
  String get open_product_website => 'Ανοίξτε αυτό το προϊόν στον ιστότοπο';

  @override
  String get language_picker_label => 'Η γλώσσα σας';

  @override
  String get country_picker_label => 'Η χώρα σας';

  @override
  String get currency_picker_label => 'Το νόμισμά σας';

  @override
  String get help_with_openfoodfacts => 'Βοήθεια με το OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Το προϊόν θα ενημερωθεί στο παρασκήνιο το συντομότερο δυνατό.';

  @override
  String get no_email_client_available_dialog_title => 'Χωρίς εφαρμογές email!';

  @override
  String get no_email_client_available_dialog_content =>
      'Στείλτε μας χειροκίνητα ένα email στο mobile@openfoodfacts.org';

  @override
  String get all_images => 'Όλες Οι Εικόνες';

  @override
  String get selected_images => 'Επιλεγμένες εικόνες';

  @override
  String get product_card_remove_product_tooltip => 'Αφαίρεση προϊόντος';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Σαρώθηκε νέος γραμμωτός κώδικας: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Αφαιρέστε όλα τα προϊόντα από το καρουζέλ';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Παρακαλούμε σαρώστε τουλάχιστον δύο προϊόντα για να τα συγκρίνετε';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Συγκρίνετε τα προϊόντα που έχετε σαρώσει';

  @override
  String get scan_product_loading => 'Έχετε σαρώσει\nτον γραμμωτό κώδικα:';

  @override
  String get scan_product_loading_initial =>
      'Ψάχνουμε αυτό το προϊόν!\nΠεριμένετε μερικά δευτερόλεπτα…';

  @override
  String get scan_product_loading_long_request =>
      'Ακόμα ψάχνουμε το προϊόν!\nΘεωρείτε ότι χρειάζεται πολύς χρόνος για να φορτώσει; Το ίδιο και εμείς…';

  @override
  String get scan_product_loading_unresponsive =>
      'Εξακολουθούμε να ψάχνουμε για αυτό το προϊόν.\nΘέλετε να επανεκκινήσετε την αναζήτηση;';

  @override
  String get scan_product_loading_restart_button => 'Επανεκκίνηση αναζήτησης';

  @override
  String get portion_calculator_description =>
      'Υπολογίστε τα διατροφικά στοιχεία για μια συγκεκριμένη ποσότητα';

  @override
  String get portion_calculator_hint => 'Ποσότητα εντός';

  @override
  String get portion_calculator_accessibility =>
      'Εισαγάγετε μια ποσότητα για τον υπολογισμό των διατροφικών στοιχείων';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Εισαγάγετε μια ποσότητα μεταξύ $min και $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Λείπουν δεδομένα. Δεν ήταν δυνατός ο υπολογισμός.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Διατροφικά στοιχεία για $grams g (ή ml)';
  }

  @override
  String get offline_data => 'Δεδομένα Χωρίς Σύνδεση';

  @override
  String get ocr_image_upload_instruction =>
      'Ανεβάστε μια εικόνα για να εξαγάγετε αυτόματα τις πληροφορίες που περιέχει.';

  @override
  String get upload_image => 'Μεταφόρτωση Φωτογραφίας';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Αποτυχία λήψης εικόνας';

  @override
  String get image_edit_url_error =>
      'Η επεξεργασία της εικόνας απέτυχε επειδή δεν είχε οριστεί η διεύθυνση URL της εικόνας.';

  @override
  String get user_picture_source_remember => 'Απομνημόνευση επιλογής';

  @override
  String get user_picture_source_ask => 'Ερώτηση κάθε φορά';

  @override
  String get robotoff_continue => 'Συνέχεια';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Επόμενες $count ερωτήσεις',
      one: 'Επόμενη ερώτηση',
    );
    return '$_temp0';
  }

  @override
  String get show_password => 'Εμφάνιση Κωδικού Πρόσβασης';

  @override
  String get owner_field_info_title => 'Τιμές παρεχόμενες από παραγωγό';

  @override
  String get owner_field_info_message =>
      'Με αυτό το λογότυπο επισημαίνουμε δεδομένα που παρέχονται από τον παραγωγό και ενδέχεται να μην είναι επεξεργάσιμα.';

  @override
  String get owner_field_info_close_button => 'Κλείσιμο των πληροφοριών';

  @override
  String get owner_field_image =>
      'Αυτή η εικόνα παρέχεται από τον παραγωγό. Μπορεί να μην είναι επεξεργάσιμη.';

  @override
  String get edit_packagings_title => 'Μέρη συσκευασίας';

  @override
  String get edit_packagings_element_add => 'Προσθήκη μέρους συσκευασίας';

  @override
  String get edit_packagings_completed => 'Η συσκευασία είναι πλήρης';

  @override
  String edit_packagings_element_title(int index) {
    return 'Μέρος συσκευασίας #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Αριθμός μονάδων';

  @override
  String get edit_packagings_element_hint_units =>
      'Εισαγάγετε τον αριθμό των μονάδων συσκευασίας του ίδιου σχήματος και υλικού που περιέχονται στο προϊόν.';

  @override
  String get edit_packagings_element_field_shape => 'Σχήμα';

  @override
  String get edit_packagings_element_hint_shape =>
      'Εισάγετε το όνομα σχήματος που αναγράφεται στις οδηγίες ανακύκλωσης, εάν είναι διαθέσιμες, ή επιλέξτε ένα σχήμα.';

  @override
  String get edit_packagings_element_example_shape => 'Μπουκάλι';

  @override
  String get edit_packagings_element_field_material => 'Υλικό';

  @override
  String get edit_packagings_element_hint_material =>
      'Εισαγάγετε το συγκεκριμένο υλικό εάν μπορεί να προσδιοριστεί (ένας κωδικός υλικού μέσα σε ένα τρίγωνο μπορεί συχνά να βρεθεί στα μέρη της συσκευασίας) ή ένα γενικό υλικό (για παράδειγμα πλαστικό ή μέταλλο) εάν δεν είστε σίγουροι.';

  @override
  String get edit_packagings_element_example_material => 'Γυαλί';

  @override
  String get edit_packagings_element_field_recycling => 'Οδηγίες ανακύκλωσης';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Εισαγάγετε οδηγίες ανακύκλωσης μόνο εάν αναγράφονται στο προϊόν.';

  @override
  String get edit_packagings_element_example_recycling => 'Ανακύκλωση';

  @override
  String get edit_packagings_element_field_quantity =>
      'Καθαρή ποσότητα προϊόντος ανά μονάδα';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Εισαγάγετε το καθαρό βάρος ή τον καθαρό όγκο και υποδείξτε τη μονάδα (για παράδειγμα g ή ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Βάρος μιας άδειας μονάδας (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Αφαιρέστε τυχόν υπολείμματα τροφίμων, πλύνετε και στεγνώστε το μέρος της συσκευασίας πριν το ζύγισμα. Εάν είναι δυνατόν, χρησιμοποιήστε ζυγαριά με ακρίβεια 0,1 g ή 0,01 g.';

  @override
  String get background_task_title => 'Εκκρεμείς συνεισφορές';

  @override
  String get background_task_subtitle =>
      'Οι συνεισφορές σας αποθηκεύονται αυτόματα στον διακομιστή μας, αλλά όχι πάντα σε πραγματικό χρόνο.';

  @override
  String get background_task_list_empty => 'Καμία Εκκρεμής Εργασία Παρασκηνίου';

  @override
  String get background_task_error_server_time_out =>
      'Λήξη χρονικού ορίου διακομιστή';

  @override
  String get background_task_error_no_internet =>
      'Σφάλμα σύνδεσης στο διαδίκτυο. Δοκιμάστε αργότερα.';

  @override
  String get background_task_operation_unknown => 'άγνωστος τύπος λειτουργίας';

  @override
  String get background_task_operation_details => 'λεπτομερείς αλλαγές';

  @override
  String get background_task_operation_image => 'μεταφόρτωση φωτογραφίας';

  @override
  String get background_task_operation_refresh =>
      'η ανανέωση καθυστερεί μετά την μεταφόρτωση φωτογραφίας';

  @override
  String get background_task_run_started => 'ξεκίνησε';

  @override
  String get background_task_run_not_started => 'δεν έχει ξεκινήσει ακόμα';

  @override
  String get background_task_run_to_be_deleted => 'προς διαγραφή';

  @override
  String get background_task_question_stop =>
      'Θέλετε να σταματήσετε αυτήν την εργασία το συντομότερο δυνατόν;';

  @override
  String get feed_back => 'Σχόλια';

  @override
  String get undo => 'Αναίρεση';

  @override
  String get copy_email_to_clip_board => 'Αντιγραφή email στο πρόχειρο';

  @override
  String get please_send_us_an_email_to =>
      'Στείλτε μας χειροκίνητα ένα email στο';

  @override
  String get email_copied_to_clip_board => 'Το email αντιγράφηκε στο πρόχειρο!';

  @override
  String get select_accent_color => 'Επιλέξτε Χρώμα Έμφασης';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Μπλε';

  @override
  String get color_cyan => 'Κυανό';

  @override
  String get color_green => 'Πράσινο';

  @override
  String get color_light_brown => 'Προεπιλογή';

  @override
  String get color_magenta => 'Ματζέντα';

  @override
  String get color_orange => 'Πορτοκαλί';

  @override
  String get color_pink => 'Ροζ';

  @override
  String get color_red => 'Κόκκινο';

  @override
  String get color_rust => 'Σκουριά';

  @override
  String get color_teal => 'Τιρκουάζ';

  @override
  String get text_contrast_mode => 'Αντίθεση Κειμένου';

  @override
  String get contrast_high => 'Υψηλή';

  @override
  String get contrast_medium => 'Μεσαία';

  @override
  String get contrast_low => 'Χαμηλή';

  @override
  String get product_refresher_internet_not_found => 'Το προϊόν δεν βρέθηκε!';

  @override
  String get product_refresher_internet_not_connected =>
      'Δεν είστε συνδεδεμένοι στο διαδίκτυο!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Διακομιστής εκτός λειτουργίας ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Σφάλμα διακομιστή ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Το προϊόν δεν βρέθηκε!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Δεν υπάρχει προϊόν με τον ακόλουθο γραμμικό κώδικα στη βάση δεδομένων μας: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Δεν υπάρχει σύνδεση στο διαδίκτυο!';

  @override
  String get product_loader_network_error_message =>
      'Παρακαλώ ελέγξτε ότι το smartphone σας βρίσκεται σε δίκτυο WiFi ή διαθέτει ενεργοποιημένα δεδομένα κινητής τηλεφωνίας';

  @override
  String get page_not_found_title => 'Η σελίδα δεν βρέθηκε!';

  @override
  String get page_not_found_button => 'Πηγαίνετε πίσω στην αρχική σελίδα';

  @override
  String get download_data => 'Λήψη δεδομένων';

  @override
  String get download_top_products =>
      'Κατεβάστε τα κορυφαία 1000 προϊόντα στη χώρα σας για άμεση σάρωση';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count προϊόντα',
    );
    return 'Κατεβάστε τα κορυφαία $_temp0 στη χώρα σας για άμεση σάρωση';
  }

  @override
  String get download_in_progress =>
      'Λήψη δεδομένων\nΑυτό μπορεί να διαρκέσει λίγο';

  @override
  String downloaded_products(int num) {
    return 'Προστέθηκαν $num προϊόντα';
  }

  @override
  String get update_offline_data =>
      'Ενημέρωση των εκτός σύνδεσης δεδομένων προϊόντων';

  @override
  String get update_local_database_sub =>
      'Ενημερώστε την τοπική βάση δεδομένων προϊόντων με τα πιο πρόσφατα δεδομένα από το Open Food Facts';

  @override
  String get clear_local_database =>
      'Εκκαθάριση των χωρίς σύνδεση δεδομένων προϊόντων';

  @override
  String get clear_local_database_sub =>
      'Καθαρισμός όλων των τοπικών δεδομένων προϊόντων από την εφαρμογή σας για να ελευθερώσετε χώρο';

  @override
  String deleted_products(int num) {
    return 'διαγράφηκαν $num προϊόντα';
  }

  @override
  String get loading => 'Φόρτωση…';

  @override
  String get know_more => 'Know Περισσότερα';

  @override
  String get offline_data_desc =>
      'Κάντε κλικ για να μάθετε περισσότερα σχετικά με τα δεδομένα εκτός σύνδεσης';

  @override
  String get offline_product_data_title => 'Δεδομένα προϊόντος εκτός σύνδεσης';

  @override
  String available_for_download(int num) {
    return '$num προϊόντα διαθέσιμα για άμεση σάρωση';
  }

  @override
  String get country_selector_title => 'Επιλέξτε τη χώρα σας:';

  @override
  String get currency_selector_title => 'Επιλέξτε το νόμισμά σας:';

  @override
  String get language_selector_title => 'Επιλέξτε τη γλώσσα σας:';

  @override
  String get language_selector_section_selected => 'Επιλεγμένες γλώσσες';

  @override
  String get language_selector_section_frequently_used =>
      'Χρησιμοποιείται συχνά';

  @override
  String get action_delete_list => 'Διαγραφή';

  @override
  String get action_change_list => 'Αλλάξτε την τρέχουσα λίστα';

  @override
  String get product_list_create => 'Δημιουργία';

  @override
  String get product_list_create_tooltip => 'Δημιουργία νέας λίστας';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Νέος υπολογισμός)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Νέος υπολογισμός)';

  @override
  String get nutriscore_unknown => 'Άγνωστο Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Άγνωστο Nutri-Score (Νέος υπολογισμός)';

  @override
  String get nutriscore_not_applicable => 'Το Nutri-Score δεν είναι εφαρμόσιμο';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Το Nutri-Score δεν είναι εφαρμόσιμο (Νέος υπολογισμός)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Πράσινη βαθμολογία Α';

  @override
  String get environmental_score_b_new => 'Πράσινο-Βαθμολογία Β';

  @override
  String get environmental_score_c_new => 'Πράσινη βαθμολογία C';

  @override
  String get environmental_score_d_new => 'Πράσινο-Βαθμολογία D';

  @override
  String get environmental_score_e_new => 'Πράσινο-Σκορ E';

  @override
  String get environmental_score_unknown_new => 'Άγνωστο Πράσινο Σκορ';

  @override
  String get environmental_score_not_applicable_new =>
      'Το Green-Score δεν ισχύει';

  @override
  String get nova_group_generic_new =>
      'Υπερεπεξεργασμένα τρόφιμα - ομάδες NOVA';

  @override
  String get nova_group_1 => 'Ομάδα 1 NOVA';

  @override
  String get nova_group_2 => 'Ομάδα 2 NOVA';

  @override
  String get nova_group_3 => 'Ομάδα 3 NOVA';

  @override
  String get nova_group_4 => 'Ομάδα 4 NOVA';

  @override
  String get nova_group_unknown => 'Άγνωστη Ομάδα NOVA';

  @override
  String get nutrition_facts => 'Επίπεδα Θρεπτικών Ουσιών';

  @override
  String get faq_title_partners => 'Συνεργάτες & Προστάτες της ΜΚΟ';

  @override
  String get faq_title_vision =>
      'Όραμα, αποστολή, Αξίες και Προγράμματα Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Εγκαταστήστε το Open Beauty Facts για να δημιουργήσετε μια βάση δεδομένων καλλυντικών';

  @override
  String get faq_title_install_pet =>
      'Εγκαταστήστε το Open Pet Food Facts για να δημιουργήσετε μια βάση δεδομένων τροφών για κατοικίδια';

  @override
  String get faq_title_install_product =>
      'Εγκαταστήστε το Open Products Facts για να δημιουργήσετε μια βάση δεδομένων προϊόντων για να παρατείνετε τη διάρκεια ζωής των αντικειμένων';

  @override
  String get faq_nutriscore_nutriscore =>
      'Νέος υπολογισμός του Nutri-Score: τι νέο υπάρχει;';

  @override
  String get contact_title_pro_page =>
      'Επαγγελματίας; Εισαγάγετε τα προϊόντα σας στο Open Food Facts';

  @override
  String get contact_title_pro_email => 'Επικοινωνία Παραγωγού';

  @override
  String get contact_title_press_page => 'Σελίδα Τύπου';

  @override
  String get contact_title_press_email => 'Επικοινωνία Τύπου';

  @override
  String get contact_title_newsletter =>
      'Εγγραφείτε στο ενημερωτικό μας δελτίο';

  @override
  String get contact_title_calendar =>
      'Εγγραφείτε στο ημερολόγιο της κοινότητάς μας';

  @override
  String get hunger_games_loading_line1 => 'Δώστε μας λίγα δευτερόλεπτα…';

  @override
  String get hunger_games_loading_line2 => 'Κατεβάζουμε τις ερωτήσεις!';

  @override
  String get hunger_games_error_label =>
      'Πω! Κάτι πήγε στραβά… και δεν μπορέσαμε να φορτώσουμε τις ερωτήσεις.';

  @override
  String get hunger_games_error_retry_button => 'Ας προσπαθήσουμε ξανά!';

  @override
  String get reorder_attribute_action => 'Αναδιάταξη των χαρακτηριστικών';

  @override
  String get link_cant_be_opened =>
      'Αυτός ο σύνδεσμος δεν μπορεί να ανοίξει στη συσκευή σας. Ελέγξτε ότι έχετε εγκαταστήσει ένα πρόγραμμα περιήγησης.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Λεπτομέρειες για $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Λεπτομέρειες για $pageName με $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Κοινοποίηση';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Τι είναι το Nutri-Score;';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'The Nutri-Score A logo';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Πού θα βρείτε τον νέο υπολογισμό Nutri-Score;';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Το Nutri-Score εφαρμόζεται σε 7 χώρες: Γαλλία, Γερμανία, Βέλγιο, Ισπανία, Λουξεμβούργο, Ολλανδία και Ελβετία.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Οι κατασκευαστές έχουν το πολύ **2 έτη** το αργότερο μετά την υπογραφή του διατάγματος **για να αντικαταστήσουν** τον παλιό υπολογισμό με τον νέο.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Τι είναι η Πράσινη Βαθμολογία;';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Το Green-Score είναι ένα λογότυπο που στοχεύει να σας ενημερώσει σχετικά με τις **περιβαλλοντικές επιπτώσεις των τροφίμων**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Ο χρωματικός κώδικας ποικίλλει από σκούρο πράσινο (**A+**) για τα **λιγότερο εντυπωσιακά** προϊόντα έως σκούρο κόκκινο (**F**) για τα **περισσότερο εντυπωσιακά** προϊόντα.';

  @override
  String get guide_greenscore_logos_caption => 'Τα λογότυπα του Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Ο πυρήνας: Αξιολόγηση κύκλου ζωής (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Μια επιστημονική αξιολόγηση των κατηγοριών τροφίμων';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Για κάθε κατηγορία προϊόντος, καθορίζεται μια **βαθμολογία αναφοράς** χρησιμοποιώντας δεδομένα από την περιβαλλοντική βάση δεδομένων Agribalyse (σχεδιασμένη από την ADEME και την INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      'Η **ανάλυση κύκλου ζωής** είναι μια τυποποιημένη μέθοδος αξιολόγησης για τη διεξαγωγή πολυσταδιακής και πολυκριτηριακής περιβαλλοντικής αξιολόγησης.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Μετράει:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 βήματα παραγωγής';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Γεωργία';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Επεξεργασία';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Συσκευασία';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Μεταφορά';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Διανομή';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Κατανάλωση';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 δείκτες περιβαλλοντικών επιπτώσεων';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Κλιματική αλλαγή/αποτύπωμα άνθρακα';

  @override
  String get guide_greenscore_lca_arg3_text2 =>
      'Καταστροφή της στιβάδας του όζοντος';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ιονίζουσα ακτινοβολία';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Γη';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Χρήση νερού και ενέργειας';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Ρύπανση του αέρα';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Θαλάσσιο και γλυκό νερό (σωματίδια, οξίνιση, ευτροφισμός)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Εξάντληση πόρων.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Μπόνους και κυρώσεις';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Τρόπος παραγωγής';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Προέλευση των συστατικών';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Είδη υπό εξαφάνιση';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Συσκευασία';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Αυξημένη ανάγκη για διαφάνεια για την καλύτερη μέτρηση και τη μείωση των περιβαλλοντικών επιπτώσεων';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Πώς μπορούν να βοηθήσουν οι κατασκευαστές';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Οι κατασκευαστές μπορούν να μας στείλουν τις πληροφορίες τους απευθείας μέσω της δωρεάν πλατφόρμας μας για παραγωγούς.';

  @override
  String get guide_greenscore_better_product_title =>
      'Ποιο προϊόν είναι καλύτερο για τον πλανήτη;';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Μπορεί να είναι δύσκολο να το καταλάβεις';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Η επιλογή βιώσιμων τροφίμων είναι ένα από τα πιο ισχυρά πράγματα που μπορούμε να κάνουμε για το κλίμα, καθώς **το παγκόσμιο σύστημα τροφίμων μας ευθύνεται για πάνω από το ένα τέταρτο όλων των εκπομπών αερίων του θερμοκηπίου**.\n(Πηγή: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title =>
      'Εσύ έχεις τη δύναμη!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Τα καλά νέα είναι ότι αυτό μας δίνει έναν ισχυρό τρόπο να δημιουργήσουμε αλλαγή.\n**Ο καθένας μας τρώει περίπου 1.000 γεύματα κάθε χρόνο**. Αυτές είναι 1.000 ευκαιρίες να **επιλέξουμε ένα καλύτερο μέλλον για τον πλανήτη**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Βοηθά να είναι κανείς υπεύθυνος και να αποφασίζει';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Η επιλογή βιώσιμων τροφίμων μπορεί να φαίνεται περίπλοκη. Οι ετικέτες είναι περίπλοκες και οι πληροφορίες συχνά λείπουν. Το Green-Score δημιουργήθηκε για να την κάνει απλή, παρέχοντάς σας μια **σαφή**, **επιστημονικά βασισμένη** και **διαφανή** περιβαλλοντική αξιολόγηση για τα τρόφιμα, ακριβώς εκεί που τη χρειάζεστε: ενώ ψωνίζετε.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Διαφάνεια';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Σε αντίθεση με τις ιδιόκτητες ετικέτες, ο υπολογισμός του Green-Score είναι **εντελώς ανοιχτός** και μπορεί να **επαληθευτεί από οποιονδήποτε**.';

  @override
  String get guide_nova_title => 'Υπερεπεξεργασμένα τρόφιμα';

  @override
  String get guide_nova_what_is_nova_title => 'Τι είναι η υπερεπεξεργασία;';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Οι ομάδες NOVA σας ενημερώνουν για το επίπεδο επεξεργασίας τροφίμων.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Η ταξινόμηση NOVA επιτρέπει την κατηγοριοποίηση των τροφίμων σε **4 ομάδες** με βάση τον **βαθμό βιομηχανικής επεξεργασίας** (ελάχιστα επεξεργασμένα ή μη επεξεργασμένα τρόφιμα, μαγειρικά συστατικά, επεξεργασμένα τρόφιμα, υπερεπεξεργασμένα τρόφιμα).';

  @override
  String get guide_nova_logos_caption => 'Τα λογότυπα της NOVA';

  @override
  String get guide_nova_groups_title => 'Οι 4 ομάδες NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Υπάρχουν 4 ομάδες NOVA, με την προβληματική να είναι η Ομάδα 4 - Υπερεπεξεργασμένα τρόφιμα.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Ελάχιστα επεξεργασμένα ή μη επεξεργασμένα τρόφιμα';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Επεξεργασμένα μαγειρικά συστατικά';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through Processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Επεξεργασμένα τρόφιμα';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes Include various preservation or cooking Methods, and In the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and Are recognizable as modified versions of group 1 foods. they can be eaten on their own or, more Commonly, in Combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Υπερεπεξεργασμένα τρόφιμα';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. ingredients in These formulations Usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed products also contain Other sources of energy and nutrients not typically used in culinary preparations. some of these are directly extracted from Foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Τα προβλήματα με την υπερεπεξεργασία';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Ακραία επεξεργασία συστατικών τροφίμων';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Πρόσθετα που ξεπερνούν την απλή ασφάλεια των τροφίμων';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Επεξεργασία που δεν μπορείτε να κάνετε στο σπίτι';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Οι επιθετικές και οικονομικές πτυχές της υπερεπεξεργασίας';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-el.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-el.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-el.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-el.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'Υπάρχουν επί του παρόντος λίγες εταιρείες που διαθέτουν μεγάλες βάσεις δεδομένων τιμών προϊόντων σε επίπεδο γραμμωτού κώδικα. Αυτές οι τιμές δεν είναι ελεύθερα διαθέσιμες, αλλά πωλούνται σε υψηλές τιμές σε ιδιώτες φορείς, ερευνητές και άλλους οργανισμούς που μπορούν να τις αντέξουν οικονομικά.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-el.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Προεπισκόπηση';

  @override
  String get prices_feedback_form =>
      'Κάντε κλικ εδώ για να μας στείλετε τα σχόλιά σας σχετικά με αυτή τη νέα λειτουργία!';

  @override
  String get menu_button_list_actions => 'Επιλέξτε μια ενέργεια';

  @override
  String get error_loading_photo => 'Σφάλμα φόρτωσης φωτογραφίας';

  @override
  String get photo_viewer_action_use_picture_as => 'Χρήση ως…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Χρησιμοποιήστε αυτήν την εικόνα ως…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Χρήση αυτής της εικόνας ως… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Λεπτομέρειες';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Λεπτομέρειες αυτής της φωτογραφίας';

  @override
  String get photo_viewer_details_title => 'Λεπτομέρειες της φωτογραφίας';

  @override
  String get photo_viewer_details_contributor_title => 'Συνεισφέρων';

  @override
  String get photo_viewer_details_size_title => 'Μέγεθος';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Ημερομηνία';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Συμβατό';

  @override
  String get user_lists_action_multi_select => 'Πολλαπλή επιλογή';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Η βαθμολογία συμβατότητάς σας: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Μπροστινή εικόνα';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Φωτογραφία συστατικών';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Φωτογραφία διατροφής';

  @override
  String get product_image_packaging_accessibility_label =>
      'Εικόνα συσκευασίας';

  @override
  String get product_image_other_accessibility_label => 'Άλλη εικόνα';

  @override
  String get product_image_outdated_message =>
      'Αυτή η εικόνα μπορεί να είναι ξεπερασμένη';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (αυτή η εικόνα μπορεί να είναι ξεπερασμένη)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (αυτή η εικόνα μπορεί να είναι κλειδωμένη από τον παραγωγό)';
  }

  @override
  String get product_image_error => 'Αδυναμία φόρτωσης εικόνας!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Αδυναμία φόρτωσης $type (σφάλμα δικτύου;)';
  }

  @override
  String get product_page_image_no_image_available => 'Καμία\nεικόνα!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Δεν υπάρχει διαθέσιμη εικόνα για αυτό το προϊόν';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Αναδιάταξη ή απόκρυψη ενεργειών';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Επεξεργασία ενεργειών';

  @override
  String get product_page_action_bar_item_move_up => 'Μετακίνηση επάνω';

  @override
  String get product_page_action_bar_item_move_down => 'Μετακίνηση κάτω';

  @override
  String get product_page_action_bar_item_enable => 'Ενεργοποίηση ενέργειας';

  @override
  String get product_page_action_bar_item_disable => 'Απενεργοποίηση ενέργειας';

  @override
  String get product_page_pending_operations_banner_title =>
      'Μεταφόρτωση των αλλαγών σας…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Τα δεδομένα που εμφανίζονται σε αυτήν τη σελίδα **δεν αντικατοπτρίζουν ακόμη τις τροποποιήσεις σας**.\nΠεριμένετε μερικά δευτερόλεπτα…';

  @override
  String get product_add_a_language => 'Προσθήκη γλώσσας';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Γραμμωτός κωδικός $barcode';
  }

  @override
  String get carousel_close_tooltip =>
      'Αφαιρέστε αυτό το προϊόν από το καρουζέλ';

  @override
  String get carousel_unsupported_header =>
      'Μη υποστηριζόμενος γραμμωτός κώδικας!';

  @override
  String get carousel_unsupported_title => 'Ουπς!';

  @override
  String get carousel_unsupported_text =>
      'Ο γραμμωτός κώδικας που σαρώθηκε δεν υποστηρίζεται από το Open Food Facts!';

  @override
  String get carousel_error_header => 'Σφάλμα!';

  @override
  String get carousel_error_title => 'Κρίμα!';

  @override
  String get carousel_error_text_1 =>
      'Δεν ήταν δυνατή η λήψη πληροφοριών για αυτόν τον γραμμωτό κώδικα:';

  @override
  String get carousel_error_text_2 =>
      'Ελέγξτε τη σύνδεσή σας στο Διαδίκτυο ή κάντε κλικ σε αυτό το κουμπί:';

  @override
  String get carousel_error_button => 'Προσπαθήστε ξανά';

  @override
  String get carousel_unknown_product_header => 'Άγνωστο προϊόν';

  @override
  String get carousel_unknown_product_title =>
      'Συγχαρητήρια!\nΒρήκες __ένα σπάνιο στολίδι!__';

  @override
  String get carousel_unknown_product_text =>
      'Η συνεργατική βάση δεδομένων μας περιέχει περισσότερα από **3 εκατομμύρια προϊόντα**, αλλά αυτός ο γραμμωτός κώδικας δεν υπάρχει: ';

  @override
  String get carousel_unknown_product_button => 'Προσθέστε αυτό το προϊόν';

  @override
  String get carousel_loading_header => 'Φόρτωση πληροφοριών...';

  @override
  String get carousel_loading_title =>
      'Μόλις σαρώσατε ένα προϊόν με τον ακόλουθο γραμμωτό κώδικα:';

  @override
  String get carousel_loading_text =>
      'Το αναζητούμε στη βάση δεδομένων μας με περισσότερα από **3 εκατομμύρια προϊόντα!**';

  @override
  String get product_type_subtitle_food =>
      'Λαχανικά, φρούτα, κατεψυγμένα τρόφιμα…';

  @override
  String get product_type_subtitle_beauty =>
      'Μακιγιάζ, σαπούνια, οδοντόκρεμες…';

  @override
  String get product_type_subtitle_pet_food => 'Τροφή για σκύλους, γάτες…';

  @override
  String get product_type_subtitle_product => 'Smartphones, έπιπλα…';

  @override
  String get photo_field_front => 'Φωτογραφία προϊόντος';

  @override
  String get photo_field_ingredients => 'Φωτογραφία συστατικών';

  @override
  String get photo_field_nutrition => 'Φωτογραφία διατροφής';

  @override
  String get photo_field_packaging => 'Φωτογραφία πληροφοριών συσκευασίας';

  @override
  String get photo_already_exists => 'Αυτή η φωτογραφία υπάρχει ήδη';

  @override
  String get photo_missing => 'Αυτή η φωτογραφία λείπει';

  @override
  String get date => 'Ημερομηνία';

  @override
  String get photo_rotate_left => 'Περιστροφή αριστερά';

  @override
  String get photo_rotate_right => 'Περιστροφή δεξιά';

  @override
  String get photo_undo_action => 'Αναίρεση της προηγούμενης ενέργειας';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Ένας παγκόσμιος χάρτης του $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Συνεισφέροντες OpenStreetMap';

  @override
  String get not_applicable_short => 'Μ/Δ';

  @override
  String get knowledge_panel_warning_text => 'Προσοχή';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Γιατί αυτό το Nutri-Score είναι διαφορετικό από αυτό στη συσκευασία;';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Υπάρχουν δύο πιθανές εξηγήσεις:\nΟ κατάλογος των συστατικών ή/και τα στοιχεία διατροφής δεν είναι ενημερωμένα.\n\nΠαρέχουμε τον \"Νέο υπολογισμό\" του Nutri-Score (ή V2). Βεβαιωθείτε ότι έχετε το σημάδι «Νέος υπολογισμός» στη συσκευασία.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Έλεγχος συστατικών';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Έλεγχος διατροφικών στοιχείων';

  @override
  String url_not_supported(String url) {
    return 'Δυστυχώς, δεν μπορούμε να ανοίξουμε το URL:\n$url';
  }

  @override
  String get product_list_export => 'Εξαγωγή';

  @override
  String get product_list_import => 'Εισαγωγή';

  @override
  String get product_footer_action_barcode => 'Προβολή γραμμωτού κώδικα';

  @override
  String get product_footer_action_barcode_short => 'Γραμμικός κωδικός';

  @override
  String get product_footer_action_open_website => 'Άνοιγμα ιστοσελίδας';

  @override
  String get product_footer_action_report => 'Αναφορά';

  @override
  String get product_footer_action_contributor_guide => 'Βοήθεια';

  @override
  String get product_footer_action_data_quality_tags => 'Ποιότητα δεδομένων';

  @override
  String get product_page_tab_for_me => 'Για μένα';

  @override
  String get product_page_tab_website => 'Ιστοσελίδα';

  @override
  String get product_page_tab_prices => 'Τιμές';

  @override
  String get prices_explanation_card_title => 'Γιατί τιμές;';

  @override
  String get prices_explanation_card_line1 =>
      'Το **Open Prices** είναι ένα έργο για τη συλλογή και κοινοποίηση τιμών προϊόντων σε όλο τον κόσμο 🌍. Το Open Prices αναπτύσσεται και συντηρείται από το Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Μάθετε περισσότερα';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Ποια είναι τα χαρακτηριστικά της Λαϊκής Προσωπικότητας;';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Τα χαρακτηριστικά βασίζονται **σε κλειδί-τιμή**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Αυτές οι ιδιότητες δημιουργούνται και καταχωρούνται από τους συνεισφέροντες για κάθε είδους χρήση.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Δεν υπάρχει διαθέσιμη τιμή';

  @override
  String get prices_products_empty_explanation =>
      'Γίνετε ο πρώτος που θα συνεισφέρει!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Κορυφαία $pageSize προϊόντα (σύνολο: $total)';
  }

  @override
  String get app_review_title => 'Σας αρέσει η εφαρμογή;';

  @override
  String get app_review_low => 'Θα μπορούσε καλύτερα';

  @override
  String get app_review_medium => 'Όχι και άσχημα';

  @override
  String get app_review_high => 'Τη λατρεύω!';

  @override
  String get app_review_feedback_modal_title =>
      'Βοηθήστε μας να βελτιώσουμε την εφαρμογή μας';

  @override
  String get app_review_feedback_modal_content =>
      'Εάν έχετε λίγα λεπτά, θα μπορούσατε να απαντήσετε σε αυτήν τη φόρμα, ώστε **να βελτιωθούμε σε μελλοντικές ενημερώσεις**:';

  @override
  String get app_review_feedback_modal_open_form => 'Απαντήστε τη φόρμα';

  @override
  String get app_review_feedback_modal_later => 'Ρωτήστε με αργότερα';

  @override
  String get nutrition_facts_extract_new =>
      'ΝΕΟ: Μπορείτε να εξαγάγετε αυτόματα τα θρεπτικά συστατικά από την εικόνα!';

  @override
  String get nutrition_facts_extract_button_text => 'Εξαγωγή τώρα';

  @override
  String get nutrition_facts_extract_in_progress => 'Εξαγωγή σε εξέλιξη…';

  @override
  String get nutrition_facts_extract_successful => 'Η εξαγωγή ήταν επιτυχής';

  @override
  String get nutrition_facts_extract_failed =>
      'Αποτυχία εξαγωγής θρεπτικών συστατικών από την εικόνα';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Στατιστικά';

  @override
  String get prices_stats_title => 'Στατιστικά Τιμών';

  @override
  String get prices_stats_prices_section => 'Τιμές';

  @override
  String get prices_stats_products_section => 'Προϊόντα';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Χρηστες';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Διάφορα';

  @override
  String get prices_stats_total => 'Σύνολο';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Κατανάλωση';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Τροφή';

  @override
  String get prices_stats_beauty => 'Ομορφιά';

  @override
  String get prices_stats_products => 'Προϊόντα';

  @override
  String get prices_stats_pet_food => 'Τροφή κατοικιδίων';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Χώρες';

  @override
  String get prices_stats_price_tag => 'Ετικέτα τιμής';

  @override
  String get prices_stats_receipt => 'Απόδειξη';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Ιστοσελίδα';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Άλλο';

  @override
  String get prices_stats_last_updated => 'Τελευταία ενημέρωση στις';

  @override
  String get prices_stats_error =>
      'Παρουσιάστηκε σφάλμα κατά τη φόρτωση των στατιστικών.';

  @override
  String get product_edit_robotoff_question_answered => 'Η ερώτηση απαντήθηκε!';

  @override
  String get product_edit_robotoff_proof => 'Επαλήθευση';

  @override
  String get preferences_card_general => 'Γενικά';

  @override
  String get preferences_prices_title => 'Τιμές';

  @override
  String get preferences_prices_subtitle =>
      'Διαχειριστείτε τις προτιμήσεις τιμών σας';

  @override
  String get preferences_card_project => 'Το έργο Open Food Facts';

  @override
  String get preferences_contribute_title => 'Συμβάλλετε';

  @override
  String get preferences_my_contributions_title => 'Οι Συνεισφορές μου';

  @override
  String get preferences_my_stats_title => 'Τα στατιστικά μου';

  @override
  String get preferences_contribute_subtitle =>
      'Μεταφράστε, βελτιώστε τα εργαλεία μας…';

  @override
  String get preferences_connect_title => 'Συνδέω';

  @override
  String get preferences_connect_subtitle =>
      'Επικοινωνήστε μαζί μας ή ακολουθήστε μας στα μέσα κοινωνικής δικτύωσης';

  @override
  String get preferences_support_title => 'Κάντε μια δωρεά';

  @override
  String get preferences_support_subtitle =>
      'Βοηθήστε μας να ενημερώσουμε εκατομμύρια καταναλωτές σε όλο τον κόσμο';

  @override
  String get preferences_card_help => 'Βοήθεια και Υποστήριξη';

  @override
  String get preferences_faq_title => 'Συχνές ερωτήσεις';

  @override
  String get preferences_faq_subtitle => 'Λάβετε απαντήσεις στις ερωτήσεις σας';

  @override
  String get logged_out => 'Αποσυνδέθηκα';

  @override
  String get preferences_app_bar_message =>
      'Σας ευχαριστούμε που είστε ένα από τα μέλη μας!';

  @override
  String get preferences_app_bar_products_modified =>
      'Προϊόντα που επεξεργάστηκαν';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats =>
      'Δείτε όλα τα στατιστικά στοιχεία';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Αναζήτηση $provider για \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Αναζήτηση ρύθμισης (π.χ. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Προσβασιμότητα: Εμφάνιση emoji';

  @override
  String get preferences_accessibility_remove_colors =>
      'Προσβασιμότητα: Αφαίρεση χρωμάτων';

  @override
  String get preferences_app_settings_products => 'Προϊόντα';

  @override
  String get preferences_card_about => 'Σχετικά';

  @override
  String get preferences_legal_information_title => 'Νομικές πληροφορίες';

  @override
  String get preferences_legal_information_subtitle =>
      'Όροι χρήσης, πολιτική απορρήτου και άλλα';

  @override
  String get preferences_terms_of_use => 'Όροι χρήσης';

  @override
  String get preferences_legal_mentions => 'Νομικές αναφορές';

  @override
  String get preferences_legal_header =>
      'Το Open Food Facts είναι μια βάση δεδομένων τροφίμων **που δημιουργήθηκε από όλους, για όλους**.\nΜπορείτε να τη χρησιμοποιήσετε για να κάνετε καλύτερες επιλογές τροφίμων και, καθώς πρόκειται για **ανοιχτά δεδομένα**, ο καθένας μπορεί να την **επαναχρησιμοποιήσει για οποιονδήποτε σκοπό**.';

  @override
  String get preferences_privacy_policy => 'Πολιτική απορρήτου';

  @override
  String get preferences_licenses => 'Άδειες';

  @override
  String get preferences_about_app_title => 'Σχετικά με την εφαρμογή';

  @override
  String get preferences_about_app_subtitle =>
      'Τεχνικές πληροφορίες, πληροφορίες για προγραμματιστές και άλλα';

  @override
  String get preferences_card_information => 'Πληροφορίες';

  @override
  String get preferences_version_number_title => 'Αριθμός έκδοσης';

  @override
  String get preferences_scanner_title => 'Ερευνητής';

  @override
  String get preferences_app_store => 'Κατάστημα εφαρμογών';

  @override
  String get preferences_app_system_settings => 'Ρυθμίσεις συστήματος';

  @override
  String get preferences_source_code => 'Πρόσβαση στον πηγαίο κώδικα';

  @override
  String get preferences_source_code_subtitle =>
      'Και αρχίστε να έχετε αντίκτυπο σε εκατομμύρια ανθρώπους';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Ολοκληρωμένα προϊόντα';

  @override
  String get preferences_tips => 'Συμβουλές';

  @override
  String get tips_discover_nutriscore => 'Ανακαλύψτε το νέο Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Στον ιστότοπο Open Food Facts';

  @override
  String get preferences_manage_account_title =>
      'Διαχείριση του λογαριασμού μου';

  @override
  String get preferences_manage_account_tooltip =>
      'Διαχείριση του λογαριασμού σας';

  @override
  String get preferences_change_password_title => 'Αλλαγή κωδικού πρόσβασης';

  @override
  String get preferences_danger_zone => 'Ζώνη κινδύνου';

  @override
  String get preferences_account_deletion_subtitle =>
      'Όλες οι συνεισφορές σας θα χαθούν';

  @override
  String get preferences_contributions_title => 'Συνεισφορές';

  @override
  String get preferences_dev_mode_app_settings_title => 'Ρυθμίσεις εφαρμογής';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Πολύ πειραματικός τρόπος σάρωσης προϊόντων εκτός σύνδεσης';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Ανανέωση όλων των προϊόντων από τον διακομιστή';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Παρακαλώ αποφύγετε να το κάνετε αυτό εκτός αν είναι απολύτως απαραίτητο';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Λειτουργία επίδειξης';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Προσθήκη καρτών στον σαρωτή';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Προσθέτει 3 δείγματα προϊόντων στον σαρωτή';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Παρουσιαστής Folksonomy';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Κεντρικός υπολογιστής: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Πειράματα προσβασιμότητας';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Επιλογή πολλαπλών προϊόντων για τιμές';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Πίνακες γνώσεων με ταξινόμηση χρήστη';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Προσωρινή πρόσβαση στην αναζήτηση τοποθεσίας';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Σύγκριση μεταξύ 2 ή 3 προϊόντων';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Εισαγωγή λίστας προϊόντων';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Βαθμολογίες & μεθοδολογίες';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Ανακαλύψτε πώς υπολογίζεται το Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Ανακαλύψτε τις κύριες αλλαγές στη μεθοδολογία';

  @override
  String get preferences_faq_discover_project_title => 'Ανακαλύψτε το έργο';

  @override
  String get preferences_faq_discover_off_title =>
      'Ανακαλύψτε Ανοιχτά Γεγονότα για τα Τρόφιμα';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'Συχνές ερωτήσεις - Συχνές ερωτήσεις';

  @override
  String get preferences_faq_off_ngo_title => 'Η ΜΚΟ Open Food Facts';

  @override
  String get preferences_about_information_title => 'Πληροφορίες';

  @override
  String get preferences_connect_community_updates_title =>
      'Λάβετε ενημερώσεις κοινότητας';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Μείνετε ενημερωμένοι για τα νέα της εφαρμογής και της κοινότητας';

  @override
  String get preferences_connect_community_calendar_title =>
      'Εγγραφείτε στο ημερολόγιο της κοινότητάς μας';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Συμμετέχετε συμμετέχοντας σε μία από τις εικονικές μας εκδηλώσεις';

  @override
  String get preferences_connect_blog_title => 'Το ιστολόγιο Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Λάβετε τα τελευταία νέα, τη στιγμή που συμβαίνουν';

  @override
  String get preferences_connect_community_help_title =>
      'Λάβετε βοήθεια από την κοινότητα';

  @override
  String get preferences_connect_improve_app_title =>
      'Βοηθήστε μας να βελτιώσουμε την εφαρμογή';

  @override
  String get preferences_connect_debug_info_title =>
      'Στείλτε μας πληροφορίες εντοπισμού σφαλμάτων';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Στείλτε μας ένα email με λεπτομερείς πληροφορίες για τον εντοπισμό σφαλμάτων';

  @override
  String get preferences_connect_feedback_title =>
      'Στείλτε μας σχόλια σχετικά με την εφαρμογή';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Βοηθήστε στη διαμόρφωση του μέλλοντος της εφαρμογής';

  @override
  String get preferences_connect_survey_title =>
      'Συμμετέχετε στην έρευνα της εφαρμογής';

  @override
  String get preferences_connect_survey_subtitle =>
      'Βοηθήστε μας να καταλάβουμε τι πρέπει να κατασκευάσουμε στη συνέχεια';

  @override
  String get preferences_connect_professionals_title => 'Επαγγελματίες';

  @override
  String get preferences_connect_pro_subtitle =>
      'Εντελώς δωρεάν, εξασφαλίζει ακριβή δεδομένα για 500 εφαρμογές και εκατομμύρια καταναλωτές. Αυτοεξυπηρέτηση, συμβατό με το PIM ή τα υπολογιστικά φύλλα σας (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Επικοινωνήστε μαζί μας για να ξεκινήσετε';

  @override
  String get preferences_connect_press_title => 'Τύπος';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Αποκτήστε όλο το υλικό που χρειάζεστε για την αναφορά σας';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Επικοινωνήστε μαζί μας για ερωτήσεις τύπου ή για να μας ενημερώσετε για την έκθεσή σας';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Γίνε ενεργός εθελοντής';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Ανάπτυξη, Επικοινωνία, Σχεδιασμός… Κάθε είδους εθελοντισμός ή εμπειρογνωμοσύνη είναι ευπρόσδεκτη!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Ανακαλύψτε μερικούς από τους πολλούς τρόπους με τους οποίους μπορείτε να συνεισφέρετε';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Ανάπτυξη εφαρμογών για κινητά';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Μάθετε πώς να συμβάλλετε στην ανάπτυξη λογισμικού';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Καθημερινές ασταθείς κατασκευές, ολοκαίνουργια χαρακτηριστικά';

  @override
  String get preferences_contribute_local_community_title =>
      'Αναπτύξτε την τοπική σας κοινότητα';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Βοήθεια με μεταφράσεις λογισμικού, περιεχομένου, ανάλυσης συστατικών';

  @override
  String get preferences_contribute_share_subtitle =>
      'Έχουμε ετοιμάσει ένα μικρό πρότυπο για να σας βοηθήσουμε :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Απλά βήματα για την αύξηση της διαφάνειας των τροφίμων στη χώρα σας';

  @override
  String get preferences_contribute_data_quality_title => 'Ποιότητα δεδομένων';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Γίνετε μέλος της ομάδας ποιότητας δεδομένων';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Συμμετέχετε στην προσπάθειά μας να διασφαλίσουμε ότι η βάση δεδομένων είναι πλήρης και ακριβής';

  @override
  String get preferences_contributions_products_added_title =>
      'Προστέθηκαν προϊόντα';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Νέα προϊόντα που πρόσθεσα στο Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Προϊόντα που πρέπει να ολοκληρώσω';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Όλα τα ημιτελή προϊόντα';

  @override
  String get preferences_my_contributions_prices_title => 'Τιμές';

  @override
  String get preferences_my_contributions_my_prices_title => 'Οι τιμές μου';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Οι τιμές μου, οι αποδείξεις μου…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Προϊόντα που μπορείτε να βοηθήσετε στην ολοκλήρωση';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Βοηθήστε στον υπολογισμό του Nutri-Score και του Green-Score στη χώρα σας';

  @override
  String get preferences_prices_user_prices_subtitle => 'Τιμές που συνεισφέρω';

  @override
  String get preferences_prices_proofs_subtitle => 'Τιμές και αποδείξεις';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Τραβήξτε φωτογραφίες των αποδείξεών σας και σαρώστε τους σχετικούς γραμμωτούς κώδικες';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Βγάλτε φωτογραφίες των τιμών σε ένα κατάστημα';

  @override
  String get preferences_prices_newest_title => 'Νεότερες τιμές';

  @override
  String get preferences_prices_newest_subtitle =>
      'Οι πιο πρόσφατες τιμές που προστέθηκαν από την κοινότητα Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Συνεργάτες με τις περισσότερες τιμές';

  @override
  String get preferences_prices_metrics_title => 'Μετρήσεις τιμής ανοίγματος';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Παρακολουθήστε την εξέλιξη του έργου';

  @override
  String get preferences_prices_ways_contribute_title => 'Τρόποι συνεισφοράς';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Επιβεβαιώστε τιμές που προστέθηκαν από εσάς ή άλλους, με τη βοήθεια της Τεχνητής Νοημοσύνης';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Προσθέστε γρήγορα πολλές αποδείξεις ή φωτογραφίες από ράφια από το ρολό της κάμεράς σας';

  @override
  String get preferences_prices_challenges_title => 'Μηνιαίες προκλήσεις';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Συμμετέχετε σε μηνιαίες θεματικές αποστολές για τη συλλογή τιμών';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Ανακτήστε τα δεδομένα πιστότητας';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Μάθετε πώς να ζητήσετε τα δεδομένα σας';

  @override
  String get preferences_page_customize_app_title => 'Προσαρμόστε την εφαρμογή';

  @override
  String get preferences_page_contribute_project_title =>
      'Συνεισφέρετε στο έργο';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Απλοί τρόποι για να βοηθήσετε το Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Μεθοδολογίες βαθμολόγησης, βοήθεια και πολλά άλλα σχετικά με το έργο';

  @override
  String get product_edit_robotoff_positive_button => 'Αποδοχή πρότασης';

  @override
  String get product_edit_robotoff_negative_button => 'Απόρριψη πρότασης';

  @override
  String get product_edit_robotoff_show_proof => 'Εμφάνιση απόδειξης';

  @override
  String get product_edit_robotoff_expand_proof => 'Επέκταση απόδειξης';

  @override
  String get product_page_tab_raw_data => 'Ακατέργαστα δεδομένα';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Σελίδα $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Σελίδα $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count από $total στοιχεία';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count από $total στοιχεία';
  }

  @override
  String item_count(int count) {
    return '$count στοιχεία';
  }

  @override
  String item_count_string(String count) {
    return '$count στοιχεία';
  }

  @override
  String get prices_no_result => 'Δεν βρέθηκαν στατιστικά στοιχεία τιμών.';

  @override
  String get prices_error_loading_more_items =>
      'Σφάλμα κατά τη φόρτωση περισσότερων στοιχείων κατά τη φόρτωση περισσότερων στοιχείων';

  @override
  String get prices_proof_error =>
      'Η πιστοποίηση απέτυχε, δεν είναι δυνατή η ανάκτηση αποδείξεων';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count από $total αποδείξεις';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count από $total συνεισφέροντες';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count από $total τοποθεσίες';
  }

  @override
  String prices_locations_count(int count) {
    return '$count τοποθεσίες';
  }

  @override
  String get restart_to_apply_message =>
      'Επανεκκινήστε την εφαρμογή για να εφαρμοστούν οι αλλαγές.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Γραφική διεπαφή';

  @override
  String get preferences_app_settings_media_title => 'Μέσα ενημέρωσης';

  @override
  String get preferences_about_app_development_title => 'Ανάπτυξη';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Ανοιχτά Εργαστήρια Γεγονότων για τα Τρόφιμα';

  @override
  String get preferences_root_account_title => 'Λογαριασμός';

  @override
  String get preferences_contribute_translate_header =>
      'Φέρτε τα Ανοιχτά Γεγονότα για τα Τρόφιμα στη γλώσσα σας';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Εγγραφείτε στην έκδοση alpha της εφαρμογής';

  @override
  String get preferences_dev_mode_section_data =>
      'Συνεισφορές και δεδομένα προϊόντων';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Να μην εμφανίζεται η Λαϊκή Προσωπικότητα';

  @override
  String get preferences_account_title => 'Λογαριασμός';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Προστέθηκε στις $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Όνομα';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Χώρα';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
