// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class AppLocalizationsCs extends AppLocalizations {
  AppLocalizationsCs([String locale = 'cs']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Ano';

  @override
  String get add => 'Přidat';

  @override
  String get account_delete_message =>
      'Opravdu chcete smazat svůj účet?\nPokud existuje konkrétní důvod, podělte se prosím níže';

  @override
  String get reason => 'Důvod';

  @override
  String get okay => 'Potvrdit';

  @override
  String get validate => 'Ověřit';

  @override
  String get create => 'Vytvořit';

  @override
  String get applyButtonText => 'Použít';

  @override
  String get next_label => 'Další';

  @override
  String get continue_label => 'Pokračovat';

  @override
  String get exit_label => 'Ukončit';

  @override
  String get previous_label => 'Předchozí';

  @override
  String get go_back_to_top => 'Přejít zpět na začátek';

  @override
  String get save => 'Uložit';

  @override
  String get save_confirmation => 'Opravdu to chcete uložit?';

  @override
  String get skip => 'Přeskočit';

  @override
  String get cancel => 'Zrušit';

  @override
  String get ignore => 'Ignorovat';

  @override
  String get close => 'Zavřít';

  @override
  String get no => 'Ne';

  @override
  String get stop => 'Zastavit';

  @override
  String get finish => 'Dokončit';

  @override
  String get calculate => 'Vypočítat';

  @override
  String get reset_food_prefs => 'Obnovit předvolby jídla';

  @override
  String get error => 'Něco se nepovedlo';

  @override
  String get error_occurred => 'Vyskytla se chyba';

  @override
  String get featureInProgress =>
      'Na této funkci stále pracujeme, zůstaňte na příjmu';

  @override
  String get label_web => 'Zobrazit na webu';

  @override
  String get learnMore => 'Zjistit více';

  @override
  String get unknown => 'Neznámo';

  @override
  String get match_very_good => 'Velmi dobrá shoda';

  @override
  String get match_good => 'Dobrá shoda';

  @override
  String get match_poor => 'Špatná shoda';

  @override
  String get match_may_not => 'Nemusí se shodovat';

  @override
  String get match_does_not => 'Neshoduje se';

  @override
  String get match_unknown => 'Neznámá shoda';

  @override
  String get match_short_very_good => 'Velmi dobrá shoda';

  @override
  String get match_short_good => 'Dobrá shoda';

  @override
  String get match_short_poor => 'Špatná shoda';

  @override
  String get match_short_may_not => 'Nemusí se shodovat';

  @override
  String get match_short_does_not => 'Neshoduje se';

  @override
  String get match_short_unknown => 'Neznámá shoda';

  @override
  String get licenses => 'Licence';

  @override
  String get looking_for => 'Hledáte';

  @override
  String get welcomeToOpenFoodFacts => 'Vítejte v Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts je globální nezisková organizace tvořená místními komunitami.';

  @override
  String get productDataUtility =>
      'Podívejte se na údaje o jídle relevantní pro vaše preference.';

  @override
  String get healthCardUtility =>
      'Vyberte si potraviny, které jsou pro vás dobré.';

  @override
  String get ecoCardUtility =>
      'Vyberte si potraviny, které jsou dobré pro planetu.';

  @override
  String get server_error_open_new_issue =>
      'Žádná odpověď serveru! Problém můžete nahlásit pomocí následujícího odkazu.';

  @override
  String get sign_in_text =>
      'Pro uložení vašich příspěvků se přihlaste ke svému účtu Open Food Facts';

  @override
  String get incorrect_credentials => 'Nesprávné uživatelské jméno nebo heslo.';

  @override
  String get password_lost_incorrect_credentials =>
      'Tento e-mail nebo uživatelské jméno neexistuje. Zkontrolujte prosím své přihlašovací údaje.';

  @override
  String get password_lost_server_unavailable =>
      'Momentálně dochází ke zpomalení na našich serverech a omlouváme se za to. Prosím zkuste to znovu později.';

  @override
  String get login => 'Uživatelské jméno';

  @override
  String get login_result_type_server_unreachable => 'Síť je nedostupná';

  @override
  String get login_result_type_server_issue =>
      'Problém na serveru. Zkuste to prosím později.';

  @override
  String get login_page_username_or_email =>
      'Zadejte prosím uživatelské jméno nebo e-mail';

  @override
  String get login_page_password_error_empty => 'Zadejte heslo';

  @override
  String get create_account => 'Vytvořit účet';

  @override
  String get sign_in => 'Přihlásit se';

  @override
  String get sign_in_mandatory =>
      'Pro tuto funkci potřebujeme, abyste se přihlásili.';

  @override
  String get help_improve_country =>
      'Pomozte vylepšit Open Food Facts ve vaší zemi';

  @override
  String get sign_out => 'Odhlásit';

  @override
  String get sign_out_confirmation => 'Opravdu se chcete odhlásit?';

  @override
  String get password => 'Heslo';

  @override
  String get forgot_password => 'Zapomenuté heslo';

  @override
  String get forgot_password_question => 'Zapomněli jste heslo?';

  @override
  String get view_profile => 'Zobrazit profil';

  @override
  String get reset_password => 'Obnovit heslo';

  @override
  String get reset_password_explanation_text =>
      'V případě zapomenutého hesla zadejte své uživatelské jméno nebo e-mailovou adresu, abyste mohli obdržet pokyny pro obnovení hesla. Také nezapomeňte zkontrolovat složku nevyžádané pošty.';

  @override
  String get username_or_email => 'Uživatelské jméno nebo e-mail';

  @override
  String get reset_password_done =>
      'E-mail s odkazem na obnovení hesla byl odeslán na e-mailovou adresu spojenou s vaším účtem. Také zkontrolujte spam';

  @override
  String get send_reset_password_mail => 'Změnit heslo';

  @override
  String get enter_some_text => 'Zadejte prosím nějaký text';

  @override
  String get sign_up_page_title => 'Vytvořit účet';

  @override
  String get sign_up_page_action_button => 'Vytvořit účet';

  @override
  String get sign_up_page_action_doing_it => 'Registrace…';

  @override
  String get sign_up_page_action_ok => 'Gratulujeme! Váš účet byl vytvořen.';

  @override
  String get sign_up_page_display_name_hint => 'Jméno';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Zadejte zobrazované jméno, které chcete používat';

  @override
  String get sign_up_page_email_hint => 'E-mail';

  @override
  String get sign_up_page_email_error_empty => 'E-mail je povinný';

  @override
  String get sign_up_page_email_error_invalid => 'Neplatný e-mail';

  @override
  String get sign_up_page_username_hint =>
      'Uživatelské jméno: Veřejně viditelné';

  @override
  String get sign_up_page_username_error_empty =>
      'Prosím, zadejte své uživatelské jméno';

  @override
  String get sign_up_page_username_error_invalid =>
      'Zadejte prosím platné uživatelské jméno';

  @override
  String get sign_up_page_username_description =>
      'Uživatelské jméno nesmí obsahovat mezery, velká písmena ani speciální znaky.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Uživatelské jméno nesmí přesáhnout $value znaků';
  }

  @override
  String get sign_up_page_password_hint => 'Heslo';

  @override
  String get sign_up_page_password_error_empty => 'Zadejte heslo';

  @override
  String get sign_up_page_password_error_invalid =>
      'Zadejte prosím platné heslo (alespoň 6 znaků)';

  @override
  String get sign_up_page_confirm_password_hint => 'Potvrzení hesla';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Potvrďte prosím heslo';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Hesla se neshodují';

  @override
  String get sign_up_page_agree_text => 'Souhlasím s Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'podmínky použití a příspěvek';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Při vytváření účtu je souhlas s Podmínkami použití povinný, nicméně prostřednictvím aplikace lze stále přispívat anonymně';

  @override
  String get sign_up_page_producer_checkbox => 'Jsem výrobce potravin';

  @override
  String get sign_up_page_producer_hint => 'Výrobce/značka';

  @override
  String get sign_up_page_producer_error_empty =>
      'Zadejte výrobce nebo název značky';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Chci se přihlásit k odběru newsletteru Open Food Facts (můžete se kdykoli odhlásit)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Uživatelské jméno již existuje, zvolte prosím jiné uživatelské jméno.';

  @override
  String get sign_up_page_email_already_exists =>
      'již existuje, přihlaste se k účtu nebo zkuste jiný e-mail.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Zadejte platnou e-mailovou adresu.';

  @override
  String get sign_up_page_server_busy =>
      'Velmi se omlouváme, máme technické potíže s vytvořením vašeho účtu. Prosím zkuste to znovu později.';

  @override
  String get settingsTitle => 'Nastavení';

  @override
  String get darkmode => 'Motiv';

  @override
  String get darkmode_dark => 'Tmavý';

  @override
  String get darkmode_light => 'Světlý';

  @override
  String get darkmode_system_default => 'Výchozí nastavení';

  @override
  String get thanks_for_contributing => 'Děkujeme za příspěvek!';

  @override
  String get contributors_label => 'Vytvářejí aplikaci';

  @override
  String get contributors_dialog_title => 'Přispěvatelé';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Přispěvatel: $name';
  }

  @override
  String get contributors_description =>
      'Seznam všech přispěvatelů této aplikace';

  @override
  String get support => 'Podpora';

  @override
  String get support_join_slack => 'Požádejte o pomoc na našem kanálu Slack';

  @override
  String get support_via_forum => 'Požádejte o pomoc na našem fóru';

  @override
  String get support_via_email => 'Pošlete nám e-mail';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Odeslat protokoly aplikace?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Přejete si zahrnout protokoly aplikace do přílohy vašeho e-mailu?';

  @override
  String get termsOfUse => 'Podmínky použití';

  @override
  String get legalNotices => 'Právní upozornění';

  @override
  String get privacy_policy => 'Zásady ochrany osobních údajů';

  @override
  String get about_this_app => 'O této aplikaci';

  @override
  String get contribute => 'Přispět';

  @override
  String get contribute_sw_development => 'Vývoj softwaru';

  @override
  String get contribute_develop_text =>
      'Kód pro každý produkt Open Food Facts je k dispozici na GitHubu. Můžete znovu použít kód (je to open source) a pomoci nám jej vylepšit, pro každého na celé planetě.';

  @override
  String get contribute_develop_text_2 =>
      'Můžete se připojit k chatovací místnosti Open Food Facts Slack, což je preferovaný způsob, jak klást otázky.';

  @override
  String get contribute_develop_dev_mode_title => 'DEV režim?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Aktivovat DEV režim';

  @override
  String get contribute_donate_title => 'Podpořit';

  @override
  String get contribute_donate_header => 'Přispějte na Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Vezměte prosím na vědomí, že s interní alfa verzí je možná úplná ztráta dat a aplikace se může kdykoli stát nepoužitelnou!';

  @override
  String get contribute_improve_ProductsToBeCompleted => 'Nedokončené';

  @override
  String get contribute_improve_header => 'Zlepšování';

  @override
  String get contribute_improve_text =>
      'Databáze je jádrem projektu. Pomoci je snadné a velmi rychlé. Můžete si stáhnout mobilní aplikaci pro svůj telefon a začít přidávat nebo vylepšovat produkty.\n\nNa druhou stranu webová stránka Open Food Facts nabízí mnoho způsobů, jak přispět: ';

  @override
  String get contribute_translate_header => 'Přeložit';

  @override
  String get contribute_data_quality => 'Kvalita dat';

  @override
  String get contribute_translate_link_text => 'Zahájit překlad';

  @override
  String get contribute_translate_text =>
      'Open Food Facts je globální projekt, který obsahuje produkty z více než 160 zemí. Open Food Facts je přeložena do desítek jazyků s neustále se vyvíjejícím obsahem.';

  @override
  String get contribute_translate_text_2 =>
      'Překlady jsou jedním z klíčových úkolů projektu';

  @override
  String get contribute_join_skill_pool =>
      'Přispějte svými dovednostmi do Open Food Facts. Připojte se k fondu dovedností!';

  @override
  String get contribute_share_header =>
      'Sdílejte Open Food Facts se svými přáteli';

  @override
  String get contribute_share_content =>
      'Chtěl jsem vám dát vědět o aplikaci, kterou používám, Open Food Facts, která vám umožňuje personalizovaným způsobem získat informace o dopadech vašeho jídla na zdraví a životní prostředí. Funguje naskenováním čárových kódů na obalu. Konečně je to zdarma, nevyžaduje registraci a dokonce můžete pomoci zvýšit počet dešifrovaných produktů. Zde je odkaz, jak jej získat pro váš telefon: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Přispějte k cenám požadavkem na export dat z vašich věrnostních karet dle GDPR';

  @override
  String get tap_to_answer => 'Klepnutím sem odpovíte na otázky';

  @override
  String get tap_to_answer_hint =>
      'Klepnutím sem odpovězte na otázky týkající se tohoto produktu';

  @override
  String get robotoff_questions_loading_hint =>
      'Počkejte prosím, než budou otázky k tomuto produktu načteny';

  @override
  String get saving_answer => 'Ukládání odpovědi';

  @override
  String get contribute_to_get_rewards =>
      'Staňte se hybatelem férovosti potravin';

  @override
  String get question_sign_in_text =>
      'Přihlaste se ke svému účtu Open Food Facts a získejte kredit za vaše příspěvky';

  @override
  String get question_yes_button_accessibility_value => 'Odpovězte ano';

  @override
  String get question_no_button_accessibility_value => 'Odpovězte ne';

  @override
  String get question_skip_button_accessibility_value =>
      'Přeskočit tuto otázku';

  @override
  String get tap_to_edit_search => 'Klepnutím upravíte hledání';

  @override
  String get myPreferences => 'Moje předvolby';

  @override
  String get account_create_message =>
      'Vytvořte si účet a připojte se ke komunitě Open Food Facts a pomozte tak budovat znalosti o potravinách po celém světě!';

  @override
  String get join_us => 'Připojte se k nám';

  @override
  String get myPreferences_profile_title => 'Váš profil';

  @override
  String get myPreferences_profile_subtitle =>
      'Spravujte svůj účet přispěvatele Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Nastavení aplikace';

  @override
  String get myPreferences_settings_subtitle => 'Tmavý režim, Jazyky…';

  @override
  String get myPreferences_food_title => 'Předvolby jídla';

  @override
  String get myPreferences_food_subtitle =>
      'Vyberte si, které informace o jídle jsou pro vás nejdůležitější.';

  @override
  String get myPreferences_food_comment =>
      'Vyberte si, na kterých informacích o potravinách vám nejvíce záleží, abyste mohli seřadit potraviny podle svých preferencí, prohlédněte si informace, které vás zajímají, jako první a získejte přehled kompatibility. Tyto preference jídla zůstanou ve vašem zařízení a nejsou spojeny s vaším účtem přispěvatele Open Food Facts, pokud jej máte.';

  @override
  String get confirmResetPreferences => 'Obnovit předvolby jídla?';

  @override
  String get myPersonalizedRanking => 'Můj osobní žebříček';

  @override
  String get ranking_tab_all => 'Vše';

  @override
  String get ranking_subtitle_match_yes => 'Skvělá shoda pro vás';

  @override
  String get ranking_subtitle_match_no => 'Velmi špatná shoda';

  @override
  String get ranking_subtitle_match_maybe => 'Neznámá shoda';

  @override
  String get refresh_with_new_preferences =>
      'Aktualizujte seznam s novými nastaveními';

  @override
  String get reloaded_with_new_preferences =>
      'Znovu načteno s vašimi novými předvolbami';

  @override
  String get profile_navbar_label => 'Komunita';

  @override
  String get scan_navbar_label => 'Skenovat';

  @override
  String get history_navbar_label => 'Historie';

  @override
  String get list_navbar_label => 'Seznamy';

  @override
  String get category => 'Filtrovat podle kategorie';

  @override
  String get category_all => 'Vše';

  @override
  String get category_search => '(hledání kategorií)';

  @override
  String get filter => 'Filtr';

  @override
  String get scan => 'Produkty z obrazovky skenování';

  @override
  String get scan_history => 'Historie skenování';

  @override
  String get search => 'Vyhledat';

  @override
  String get search_product_help =>
      'Vyhledejte produkt,\nznačku nebo čárový kód';

  @override
  String get search_filter => 'Vyhledávací filtr';

  @override
  String get search_history => 'Historie vyhledávání';

  @override
  String get search_store => 'Vyhledat obchod';

  @override
  String get search_store_help => 'Nápověda: přidejte město nebo zemi';

  @override
  String get tap_for_more => 'Klepnutím zobrazíte více informací…';

  @override
  String get product => 'Produkt';

  @override
  String get unknownBrand => 'Neznámá značka';

  @override
  String get unknownProductName => 'Neznámý název produktu';

  @override
  String get label_refresh => 'Obnovit';

  @override
  String get label_reload => 'Znovu načíst';

  @override
  String get image => 'Obrázek';

  @override
  String get front_photo => 'Přední fotka';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (tento obrázek může být zastaralý)';
  }

  @override
  String get outdated_image_short_label => 'mohou být zastaralé';

  @override
  String get ingredients => 'Složení';

  @override
  String get ingredients_editing_instructions =>
      'Zachovejte původní řazení. Při specifikaci uveďte procento. Oddělte je čárkou nebo pomlčkou, použijte závorky pro složky přísady a označte alergeny mezi podtržítka.';

  @override
  String get ingredients_editing_error => 'Ingredience se nepodařilo uložit.';

  @override
  String get ingredients_editing_image_error =>
      'Nepodařilo se získat nový obrázek ingrediencí.';

  @override
  String get ingredients_editing_title => 'Upravit ingredience';

  @override
  String get ingredients_photo => 'Fotografie ingrediencí';

  @override
  String get packaging_editing_instructions =>
      'Uveďte všechny části balení oddělené čárkou nebo odřádkováním s uvedením jejich množství (např. 1 nebo 6), typu (např. láhev, krabice, plechovka), materiálu (např. plast, kov, hliník) a pokud je k dispozici jejich velikost (např. 33 cl) a pokyny k recyklaci.\nPříklad: 1 skleněná láhev k recyklaci, 1 plastový korek k vyhození';

  @override
  String get packaging_editing_error => 'Balení se nepodařilo uložit.';

  @override
  String get packaging_editing_image_error =>
      'Nepodařilo se získat nový obrázek obalu.';

  @override
  String get packaging_editing_title => 'Upravit obal';

  @override
  String get nutrition => 'Nutriční hodnoty';

  @override
  String get nutrition_facts_photo => 'Fotografie výživových faktů';

  @override
  String get nutrition_facts_editing_title => 'Upravit nutriční fakta';

  @override
  String get packaging_information => 'Informace o balení';

  @override
  String get packaging_information_photo => 'Informační foto balení';

  @override
  String get missing_product => 'Našli jste nový produkt!';

  @override
  String get add_product_take_photos =>
      'Vyfoťte obal a přidejte tento produkt do Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Nejprve prosím udělejte nějaké fotky. Produkt můžete vždy dokončit později.';

  @override
  String get add_product_information_button_label =>
      'Přidat informace o produktu';

  @override
  String get new_product => 'Nový produkt';

  @override
  String get new_product_found_title => 'Nalezen nový produkt!';

  @override
  String get new_product_found_text =>
      'Naše společně tvořená databáze obsahuje více než **3 miliony produktů**, ale tento čárový kód neexistuje: ';

  @override
  String get new_product_found_button => 'Přidat výrobek';

  @override
  String get new_product_leave_title => 'Opustit tuto stránku?';

  @override
  String get new_product_leave_message =>
      'Zdá se, že jste nic nezadali. Opravdu chcete opustit tuto stránku?';

  @override
  String get new_product_dialog_description =>
      'Pro přidání tohoto produktu do naší společné databáze prosím vyfoťte obal';

  @override
  String get new_product_dialog_illustration_description =>
      'Ilustrace s neznámým Nutri-Score a Green Score';

  @override
  String get front_packaging_photo_button_label => 'Přední fotka produktu';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Potvrdit nahrání přední fotky produktu';

  @override
  String get confirm_button_label => 'Potvrdit';

  @override
  String get send_image_button_label => 'Odeslat obrázek';

  @override
  String get crop_page_action_saving => 'Ukládání obrázku…';

  @override
  String get crop_page_action_cropping => 'Oříznutí obrázku…';

  @override
  String get crop_page_action_local => 'Ukládání místní verze…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oops, něco se stalo s tvojí fotkou!';

  @override
  String get crop_page_action_local_failed_message =>
      'Před odesláním na náš server nejsme schopni zpracovat obrázek lokálně. Zkuste to znovu později nebo nás kontaktujte, pokud problém přetrvává.';

  @override
  String get crop_page_action_retake => 'Znovu pořídit fotografii';

  @override
  String get crop_page_too_small_image_title => 'Obrázek je příliš malý!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Minimální velikost v pixelech pro nahrávání obrázků je ${expectedMinWidth}x$expectedMinHeight. Aktuální obrázek je ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Příprava volání serveru…';

  @override
  String get front_packaging_photo_title => 'Fotografie předního obalu';

  @override
  String get ingredients_photo_title => 'Fotografie ingrediencí';

  @override
  String get nutritional_facts_photo_title => 'Fotografie nutričních údajů';

  @override
  String get recycling_photo_title => 'Fotografie recyklace';

  @override
  String get take_photo_title => 'Vyfotit';

  @override
  String get take_more_photo_title => 'Vyfotit další obrázky';

  @override
  String get front_photo_uploaded => 'Přední fotka nahrána';

  @override
  String get ingredients_photo_button_label => 'Fotografie ingrediencí';

  @override
  String get ingredients_photo_uploaded => 'Fotografie ingrediencí nahrána';

  @override
  String get nutrition_cache_loading_error =>
      'Nelze načíst živiny z mezipaměti';

  @override
  String get nutritional_facts_photo_button_label =>
      'Fotografie výživových faktů';

  @override
  String get nutritional_facts_input_button_label => 'Zadejte fakta o výživě';

  @override
  String get nutritional_facts_added => 'Byly přidány údaje o výživě';

  @override
  String get categories_added => 'Kategorie přidány';

  @override
  String get new_product_title_nutriscore => 'Vypočítejte Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Získejte jej vyplněním kategorie potravin a výživových hodnot';

  @override
  String get new_product_title_environmental_score => 'Vypočítejte Green-Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Získejte jej vyplněním alespoň kategorie';

  @override
  String get new_product_additional_environmental_score =>
      'Zpřesněte výpočet Green-Score pomocí původu, balení a dalších údajů';

  @override
  String get new_product_title_nova =>
      'Vypočítejte úroveň zpracování potravin (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Získejte ji vyplněním kategorie potravin a složek';

  @override
  String get new_product_desc_nova_unknown =>
      'Neznámá úroveň průmyslového zpracování potraviny';

  @override
  String get new_product_title_pictures => 'Pojďme udělat pár fotek!';

  @override
  String get new_product_title_pictures_details =>
      'Udělejte prosím následující fotky a nástroj Open Food Facts dokáže vyřešit zbytek!';

  @override
  String get new_product_title_misc => 'A pár základních údajů…';

  @override
  String new_product_done_msg(String username) {
    return 'Děkujeme za váš příspěvek, $username!';
  }

  @override
  String get new_product_done_msg_no_user => 'Děkujeme za Váš příspěvek!';

  @override
  String get new_product_done_button_label => 'Objevte hotový produkt';

  @override
  String get hey_incomplete_product_message =>
      'Klepnutím odpovězte na 3 otázky k OKAMŽITÉMU výpočtu Nutri-Score, Green-Score & Ultra-zpracování (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Klepnutím nyní odpovězte na 2 otázky, které vám pomohou analyzovat tuto kosmetiku!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Klepnutím nyní odpovězte na 3 otázky, které vám pomohou analyzovat toto krmivo pro domácí zvířata!';

  @override
  String get hey_incomplete_product_message_product =>
      'Klepnutím nyní pomůžete dokončit tento produkt!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Fotografie nutričních údajů byla nahrána';

  @override
  String get recycling_photo_button_label =>
      'Informační fotografie o recyklaci';

  @override
  String get recycling_photo_uploaded => 'Nahrána fotografie recyklace';

  @override
  String get take_more_photo_button_label => 'Vyfotit další obrázky';

  @override
  String get other_photo_uploaded => 'Různé fotografie nahrány';

  @override
  String get retake_photo_button_label => 'Pořídit znovu';

  @override
  String get selecting_photo => 'Výběr fotografie';

  @override
  String get uploading_image => 'Nahrávání fotografie na server';

  @override
  String get uploading_image_type_front =>
      'Nahrávání předního obrázku do Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Nahrávání obrázku přísad do Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Nahrávání obrázku výživových údajů do Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Nahrávání obrázku balení do Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Nahrání jiného obrázku do Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Nahrávání obrázku do Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Přidejte chybějící přísady';

  @override
  String get score_add_missing_packaging_image =>
      'Přidat chybějící obrázek obalu';

  @override
  String get score_add_missing_nutrition_facts =>
      'Přidejte chybějící výživová fakta';

  @override
  String get score_add_missing_product_traces => 'Add missing product traces';

  @override
  String get score_add_missing_product_category =>
      'Přidejte chybějící kategorii produktu';

  @override
  String get score_add_missing_precise_product_category =>
      'Vyberte přesnější kategorii';

  @override
  String get score_add_missing_product_countries =>
      'Přidat chybějící země produktu';

  @override
  String get score_add_missing_product_emb =>
      'Přidat chybějící kódy sledovatelnosti produktu';

  @override
  String get score_add_missing_product_labels =>
      'Přidat chybějící štítky produktu';

  @override
  String get score_add_missing_product_origins =>
      'Přidat chybějící původ produktu';

  @override
  String get score_add_missing_product_stores =>
      'Přidat chybějící obchody produktů';

  @override
  String get score_add_missing_product_brands =>
      'Přidat chybějící značky produktů';

  @override
  String get score_update_nutrition_facts => 'Aktualizujte výživová fakta';

  @override
  String get nutrition_page_title => 'Nutriční hodnoty';

  @override
  String get nutrition_page_nutritional_info_title => 'Nutriční informace';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Hodnoty uvedené na produktu:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Ano';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Ne';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Otevřít fotografii';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Osvědčené postupy: Nutriční informace';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Výživová fakta jsou někdy **nespecifikována na balení** ani na dokumentu předloženém s tímto produktem. V tomto případě, a pouze v tomto případě, můžete nastavit hodnotu na **NE**.';

  @override
  String get nutrition_page_serving_type_label => 'Nutriční hodnoty:';

  @override
  String get nutrition_page_per_100g => 'na 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'na 100 g/ml';

  @override
  String get nutrition_page_per_serving => 'v jedné porci';

  @override
  String get nutrition_page_add_nutrient => 'Přidejte živinu';

  @override
  String get nutrition_page_serving_size => 'Velikost porce';

  @override
  String get nutrition_page_serving_size_hint =>
      'Zadejte velikost porce (např.: 100 g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Osvědčené postupy: Velikost porce';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Tato hodnota pomáhá **proporcionálně vypočítat každou živinu na velikost porce**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Povolené jednotky** jsou: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** nebo **60 G** (preferujte první)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** nebo **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Neplatná jednotka';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Neplatné jednotky';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9**bonbonů** a 2**sušenky**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Chybějící jednotka';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '***30**';

  @override
  String get nutrition_page_invalid_number => 'Neplatné číslo';

  @override
  String get nutrition_page_update_running =>
      'Aktualizace produktu na serveru…';

  @override
  String get nutrition_page_update_done => 'Produkt aktualizován!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Použít množství produktu jako velikost porce';

  @override
  String get nutrition_page_photo_error => 'Nelze načíst fotografii';

  @override
  String get more_photos => 'Další zajímavé fotky';

  @override
  String get view_more_photo_button =>
      'Zobrazit všechny existující fotografie tohoto produktu';

  @override
  String get no_product_found => 'Nebyl nalezen žádný produkt';

  @override
  String get no_location_found => 'Nenalezena žádná poloha';

  @override
  String get not_found => 'nenalezeno:';

  @override
  String get refreshing_product => 'Obnovování produktu';

  @override
  String get product_refreshed => 'Produkt obnoven';

  @override
  String product_image_accessibility_label(String date) {
    return 'Obrázek pořízený $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Obrázek pořízený $date. Tento obrázek může být zastaralý';
  }

  @override
  String get product_image_outdated => 'Tento obrázek může být zastaralý';

  @override
  String get product_image_outdated_explanations_title =>
      'Tento obrázek může být zastaralý';

  @override
  String get product_image_outdated_explanations_content =>
      'Tento snímek byl pořízen před více než rokem.\n**Zkontrolujte prosím, zda je stále aktuální**.\n\nToto je **jen upozornění**. Pokud je obsah stále stejný, můžete tuto zprávu ignorovat.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Nahradit fotku ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Přidat fotku ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Zachytit nový';

  @override
  String get product_image_action_take_picture => 'Vyfotit';

  @override
  String get product_image_action_from_gallery => 'Vyberte z galerie telefonu';

  @override
  String get product_image_action_choose_existing_photo =>
      'Vybrat z fotografií produktu';

  @override
  String get product_image_details_label => 'Informace o fotografii';

  @override
  String get product_image_details_from_producer => 'Od výrobce';

  @override
  String get product_image_details_contributor => 'Přispěvatel';

  @override
  String get product_image_details_contributor_producer =>
      'Přispěvatel (výrobce)';

  @override
  String get product_image_details_date => 'Datum';

  @override
  String get product_image_details_date_unknown => 'Neznámo';

  @override
  String get homepage_main_card_logo_description => 'Vítejte v Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Naskenujte** čárový kód nebo\n**vyhledejte** produkt';

  @override
  String get homepage_main_card_search_field_hint => 'Vyhledat produkt';

  @override
  String get homepage_main_card_search_field_tooltip => 'Začít hledání';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Nejnovější zprávy: $news_title';
  }

  @override
  String get tagline_app_review => 'Líbí se vám aplikace?';

  @override
  String get tagline_app_review_button_positive => 'Miluji to! 😍';

  @override
  String get tagline_app_review_button_negative => 'Ani ne...';

  @override
  String get tagline_app_review_button_later => 'Zeptejte se mě později';

  @override
  String get tagline_feed_news_button => 'Více informací';

  @override
  String get app_review_negative_modal_title => 'Nelíbí se vám naše aplikace?';

  @override
  String get app_review_negative_modal_text =>
      'Mohl byste nám dát pár sekund a říct nám proč?';

  @override
  String get app_review_negative_modal_positive_button => 'Ano, samozřejmě!';

  @override
  String get app_review_negative_modal_negative_button => 'Ne';

  @override
  String get could_not_refresh => 'Produkt se nepodařilo obnovit';

  @override
  String get product_internet_error_modal_title => 'Vyskytla se chyba!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Nemůžeme načíst informace o tomto produktu kvůli chybě sítě. Zkontrolujte prosím připojení k internetu a zkuste to znovu.\n\nVnitřní chyba:\n$error';
  }

  @override
  String get product_tags_title => 'Vlastnosti produktu';

  @override
  String get no_product_tags_found_message =>
      'Nebyly nalezeny žádné vlastnosti produktu. Vlastnosti lze použít k podrobnějšímu a flexibilnímu popisu produktů. Klepnutím přidáte.';

  @override
  String get product_tags_empty => 'Žádné nemovitosti';

  @override
  String get product_tags_explanation =>
      'Přidáním vlastností (klíč/hodnota) k produktu ho pomáháte obohatit.';

  @override
  String get add_tag => 'Přidat vlastnost';

  @override
  String get add_tags => 'Přidat vlastnosti';

  @override
  String get add_edit_tags => 'Přidat nebo upravit vlastnosti';

  @override
  String get edit_tag => 'Upravit vlastnost';

  @override
  String get remove_tag => 'Odstranit vlastnost';

  @override
  String get tag_key => 'Vlastnosti';

  @override
  String get tag_keys => 'Nemovitosti';

  @override
  String get tag_key_uneditable => 'Vlastnost (neupravitelná)';

  @override
  String get tag_key_input_hint => 'Zadejte vlastnost';

  @override
  String get tag_value => 'Hodnota';

  @override
  String get tag_values => 'Hodnoty';

  @override
  String get tag_value_input_hint => 'Zadejte hodnotu';

  @override
  String get tag_key_item => 'Vlastnost:';

  @override
  String get tag_value_item => 'Hodnota:';

  @override
  String get tag_key_explanations =>
      'Klíč musí být malými písmeny a bez mezer.';

  @override
  String tag_key_already_exists(String property) {
    return 'Značka s vlastností $property již existuje!';
  }

  @override
  String get product_internet_error =>
      'Nelze načíst informace o tomto produktu kvůli chybě sítě.';

  @override
  String get cached_results_from => 'Zobrazit výsledky z:';

  @override
  String get product_search_same_category => 'Najít alternativy';

  @override
  String get product_search_same_category_short => 'Porovnat';

  @override
  String get product_search_same_category_error =>
      'Tuto funkci lze použít pouze pro produkty s kategorií.\n\nPro přidání kategorie prosím upravte produkt.';

  @override
  String get product_improvement_add_category =>
      'Přidejte kategorii pro výpočet Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Přidejte výživové údaje pro výpočet Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Přidejte výživové údaje a kategorii pro výpočet Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-score pro tento produkt nelze vypočítat, což může být způsobeno např. nestandardní kategorií. Pokud je to považováno za chybu, kontaktujte nás.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Obrázek výživy je zastaralý: obnovte jej.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Green-Score bere v úvahu původ ingrediencí. Vyfoťte prosím seznam složek a/nebo jakékoli geografické tvrzení nebo úpravy produktu, aby mohly být zohledněny.';

  @override
  String get country_chooser_label => 'Vyberte prosím zemi';

  @override
  String get currency_chooser_label => 'Prosím zvolte měnu';

  @override
  String get country_change_message => 'Právě jste změnili zemi.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Chcete změnit měnu z $previousCurrency na $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Vyberte prosím zemi:';

  @override
  String get country_chooser_label_from_settings => 'Vaše země';

  @override
  String get country_selection_explanation =>
      'Některé prvky prostředí jsou specifické pro dané místo';

  @override
  String get product_removed_comparison => 'Produkt byl odstraněn ze srovnání';

  @override
  String get native_app_settings => 'Nastavení aplikace';

  @override
  String get native_app_description =>
      'Otevřít systémová nastavení pro Open Food Facts';

  @override
  String get product_removed_history => 'Produkt byl odstraněn z historie';

  @override
  String get product_removed_list => 'Produkt odstraněn ze seznamu';

  @override
  String get product_could_not_remove => 'Produkt se nepodařilo odebrat';

  @override
  String get no_prodcut_in_list => 'V tomto seznamu není žádný produkt';

  @override
  String get no_product_in_section => 'V této sekci není žádný produkt';

  @override
  String get recently_seen_products => 'Všechny prohlížené produkty';

  @override
  String get clear => 'Vymazat';

  @override
  String get clear_long => 'Vyprázdnit seznam';

  @override
  String get really_clear => 'Opravdu chcete tento seznam smazat?';

  @override
  String pct_match(Object percent) {
    return '$percent% shoda';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'před $count dny',
      one: 'před $count dny',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'před $count hodinami',
      many: 'před $count hodinami',
      one: 'před $count hodinami',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'před $count minutami',
      many: 'před $count minutami',
      one: 'před minutou',
      zero: 'před méně než minutou',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'před $count měsíci',
      one: 'před měsícem',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count týdny',
      one: 'týdnem',
    );
    return 'před $_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Porovnání $count produktů',
      one: 'Porovnání jednoho produktu',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count selected products',
      one: 'One selected product',
      zero: 'No selected product',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Porovnat vybrané produkty';

  @override
  String get delete_products_mode => 'Odstranit vybrané produkty';

  @override
  String get select_all_products_mode => 'Vybrat všechny produkty';

  @override
  String get select_none_products_mode => 'Zrušit výběr';

  @override
  String get compare_products_appbar_title => 'Porovnejte produkty';

  @override
  String get compare_products_appbar_subtitle =>
      'Vyberte prosím alespoň dva produkty';

  @override
  String get retry_button_label => 'Opakovat';

  @override
  String get connect_with_us => 'Spojte se s námi';

  @override
  String get tiktok => 'Sledujte nás na TikToku';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Sledujte nás na Instagramu';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Sledujte nás na X (dříve Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Sledujte nás na Mastodonu';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Sledujte nás na BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Blog';

  @override
  String get faq => 'Často kladené otázky';

  @override
  String get discover => 'Zjistit víc';

  @override
  String get how_to_contribute => 'Jak přispět';

  @override
  String get hint_knowledge_panel_message =>
      'Klepnutím na kteroukoli část karty získáte další podrobnosti o tom, co vidíte. Vyzkoušejte to teď!';

  @override
  String get permissions_page_title => 'Přístup k fotoaparátu';

  @override
  String get permissions_page_body1 =>
      'Chcete-li skenovat čárové kódy fotoaparátem telefonu, autorizujte přístup.';

  @override
  String get permissions_page_body2 =>
      'Pokud si to rozmyslíte, můžete tuto možnost kdykoli povolit nebo zakázat v nastavení.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'OS: Android (SDK Int: $sdkInt / Release: $release)\nModel: $model\nProdukt: $product\nZařízení: $device\nZnačka:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'OS: iOS ($version)\nModel: $model\nLokalizovaný model: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVerze aplikace:$appVersion\nČíslo sestavení aplikace:$appBuildNumber\nNázev balíčku aplikace:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Autorizovat';

  @override
  String get refuse_button_label => 'Odmítnout';

  @override
  String get ask_me_later_button_label => 'Později';

  @override
  String get are_you_sure => 'Jste si jisti?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Přejít dále na $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Vítejte!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Aplikace, která vám pomůže vybrat jídlo, které je dobré pro **vás** a **planetu**!';

  @override
  String get onboarding_continue_button => 'Pokračovat';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Načítám váš první příklad produktu';

  @override
  String get onboarding_welcome_warning =>
      'Omlouváme se, je to náš vzorový produkt, nemůžete ho upravovat :)';

  @override
  String get product_list_your_ranking => 'Vaše hodnocení';

  @override
  String get product_list_empty_icon_desc => 'Historie není k dispozici';

  @override
  String get product_list_empty_title => 'Začít skenovat';

  @override
  String get product_list_empty_message =>
      'Zde se zobrazí naskenované produkty a můžete si o nich zkontrolovat podrobné informace';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'produkty',
      one: 'produkt',
      zero: 'produkt',
      many: 'produktů',
      few: 'produkty',
    );
    return 'Obnovuji $_temp0 v historii';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Products',
      one: 'produktu',
      zero: 'produktů',
      many: 'produktů',
      few: 'produktů',
    );
    return 'Aktualizace $_temp0 dokončena';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Stahování dat';

  @override
  String get loading_dialog_default_error_message => 'Nelze stáhnout data';

  @override
  String get account_delete => 'Smazat účet';

  @override
  String get account_delete_title => 'Smazat můj účet';

  @override
  String get user_profile => 'Účet';

  @override
  String get user_profile_title_guest => 'Vítejte!';

  @override
  String get user_profile_subtitle_guest =>
      'Přihlaste se nebo se zaregistrujte a připojte se ke komunitě Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts přihlášení: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Vítejte $id!';
  }

  @override
  String get email_subject_account_deletion => 'Smazat účet';

  @override
  String email_body_account_deletion(String userId) {
    return 'Dobrý den, smažte prosím můj účet Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Aplikace';

  @override
  String get settings_app_data => 'Soukromí a monitorování';

  @override
  String get settings_app_camera => 'Fotoaparát';

  @override
  String get settings_app_products => 'Produkty';

  @override
  String get settings_app_miscellaneous => 'Ostatní';

  @override
  String get camera_play_sound_title => 'Přehrát zvuk při skenování';

  @override
  String get camera_play_sound_subtitle =>
      'Při každém úspěšném skenování pípne';

  @override
  String get camera_window_accessibility_label =>
      'Naskenujte čárový kód pomocí fotoaparátu';

  @override
  String get app_haptic_feedback_title => 'Vibrace a haptika';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibrace po provedení některých akcí (čárový kód dekódován, produkt odstraněn…).';

  @override
  String get crash_reporting_toggle_title => 'Hlášení o pádu';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Pokud je tato možnost povolena, zprávy o selhání se automaticky odesílají do systému sledování chyb Open Food Facts, aby bylo možné opravit chyby a vylepšit tak aplikaci.';

  @override
  String get send_anonymous_data_toggle_title => 'Odeslat anonymní data';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'Pokud je povoleno, některé anonymní informace o používání aplikace a jejích funkcích budou odeslány na server Open Food Facts, abychom mohli aplikaci dále vylepšovat.';

  @override
  String get product_edit_photo_title => 'Upravit obrázek';

  @override
  String get permission_photo_error => 'Chyba';

  @override
  String get permission_photo_denied_title =>
      'Povolit použití fotoaparátu ke skenování čárových kódů';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Pro lepší zážitek povolte $appName přístup ke kameře. Budete moci přímo skenovat čárové kódy.';
  }

  @override
  String get permission_photo_denied_button => 'Povolit';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Přístup odepřen';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Protože jste dříve odepřeli povolení fotoaparátu, musíte jej povolit ručně v Nastavení.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Otevřít nastavení';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Zrušit';

  @override
  String get permission_photo_none_found => 'Nenalezen žádný fotoaparát';

  @override
  String get permission_photo_denied => 'Není povolen přístup ke kameře';

  @override
  String get show_product_pictures => 'Zobrazit obrázky produktů';

  @override
  String get edit_product_label => 'Upravit produkt';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Nahrávání vašich úprav…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Tvé úpravy jsou **odeslány na pozadí** (nebo později v případě chyby).\nMůžeš pokračovat v úpravách ostatních produktových polí.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Tvé úpravy jsou **odeslány na pozadí** (nebo později v případě chyby).';

  @override
  String get edit_product_label_short => 'Upravit';

  @override
  String edit_product_form_item_help(String value) {
    return 'Jak zadat \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Zadejte prosím neprázdnou hodnotu!';

  @override
  String get edit_product_form_item_error_existing =>
      'Tato hodnota již existuje!';

  @override
  String get edit_product_form_item_add_action_brand => 'Přidat novou značku';

  @override
  String get edit_product_form_item_add_action_label => 'Přidat nový štítek';

  @override
  String get edit_product_form_item_add_action_store => 'Přidat nový obchod';

  @override
  String get edit_product_form_item_add_action_origin => 'Přidat nový původ';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Přidat nový kód sledovatelnosti';

  @override
  String get edit_product_form_item_add_action_country => 'Přidat novou zemi';

  @override
  String get edit_product_form_item_add_action_category =>
      'Přidá novou kategorii';

  @override
  String get edit_product_form_item_add_action_trace => 'Add a new trace';

  @override
  String get edit_product_form_item_add_suggestion => 'Přidat návrh';

  @override
  String get edit_product_form_item_deny_suggestion => 'Odmítnout návrh';

  @override
  String get edit_product_form_item_details_title => 'Základní detaily';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Název produktu, značka, množství';

  @override
  String get edit_product_form_item_other_details_title => 'Další detaily';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Webová stránka…';

  @override
  String get edit_product_form_item_photos_title => 'Fotky';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Přidat nebo obnovit fotky';

  @override
  String get edit_product_form_item_labels_title => 'Štítky a certifikace';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Environmentální, kvalitativní štítky…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Zadejte štítek (např.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'štítek';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Osvědčené postupy: Štítky';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Jakákoli charakteristika produktu, **která je faktická** a liší se od ostatních polí.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Vyrobeno v Belgii, vyrobeno v Bretani…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Bohatý na vlákninu, zdroj železa…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Prodejny';

  @override
  String get edit_product_form_item_stores_hint => 'Zadejte obchod';

  @override
  String get edit_product_form_item_stores_type => 'prodejna';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Osvědčené postupy: Obchody';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Zadejte obchod, kde jste produkt zakoupili.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Původ';

  @override
  String get edit_product_form_item_origins_hint =>
      'Zadejte původ (např.: Německo)';

  @override
  String get edit_product_form_item_origins_type => 'země';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Osvědčené postupy: Původ';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Přidejte **údaje o původu, které najdete na balení**.\nNemusíte se starat o původ uvedený přímo v seznamu ingrediencí.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Hovězí maso z Argentiny';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Sója nepochází z Evropské unie';

  @override
  String get edit_product_form_item_countries_title => 'Země';

  @override
  String get edit_product_form_item_countries_hint =>
      'Zadejte zemi (např.: Německo)';

  @override
  String get edit_product_form_item_countries_type => 'země';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Osvědčené postupy: Země';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Země, kde je produkt široce dostupný** (nezahrnuje obchody specializované na zahraniční produkty).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Kód EMB';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Zadejte kód (např.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'kód EMB';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Osvědčené postupy: Kódy sledovatelnosti';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'V této části můžete zadat kódy pro **značky balení**, **identifikační značky** nebo **značky zdravotní nezávadnosti**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Příklady kódů sledovatelnosti';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Kódy EC** používané v Evropském společenství k identifikaci výrobců potravin nebo balíren:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: Kód země **Francie**\n**72.264.002**: geografická data\n**CE**: Evropské společenství';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**Kódy EMB** používané ve Francii:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Stopy';

  @override
  String get edit_product_form_item_traces_hint => 'stopy';

  @override
  String get edit_product_form_item_traces_type =>
      'Input a trace (eg: Soy beans)';

  @override
  String get edit_product_form_item_categories_title => 'Kategorie';

  @override
  String get edit_product_form_item_categories_hint => 'kategorie';

  @override
  String get edit_product_form_item_categories_type =>
      'Zadejte kategorii (např.: Pomerančový džus)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Osvědčené postupy: Kategorie';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Uveďte **pouze nejkonkrétnější kategorii**.\nNadřazené kategorie budou přidány automaticky.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Chybí kategorie?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'V případě, že kategorie **není dostupná v automatickém doplňování**, klidně ji i tak přidejte.\nTo nám pomůže vylepšit Open Food Facts ve vaší zemi.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardinky v olivovém oleji';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Pomerančová šťáva z koncentrátu';

  @override
  String get edit_product_form_item_exit_title => 'Ukončit bez uložení?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Chcete uložit změny před opuštěním této stránky?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Uložit změny';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Zrušit změny';

  @override
  String get edit_product_form_item_ingredients_title => 'Složení';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Přiblížení a oddálení dotekem obrazovky';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Přiblížení a oddálení fotky';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Pomocí **gesta Pinch-to-zoom**, můžete fotku oddálit nebo oddálit:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Přidat';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Nejprve prosím zadejte text';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Odstranit';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Uložte své úpravy';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Zrušte svou úpravu';

  @override
  String get edit_product_form_item_packaging_title =>
      'Fotografie pokynů pro recyklaci';

  @override
  String get edit_product_form_item_nutrition_facts_title => 'Nutriční hodnoty';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Výživa, obsah alkoholu…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Osvědčené postupy: Fakta o výživě';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nutriční hodnoty';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Nejprve vyberte, zda jsou uvedeny **hodnoty**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Nutriční hodnoty';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Poté zadejte nutriční hodnoty **jak je uvedeno na obalu**. Pokud není žádná hodnota, můžete kliknout na ikonu \"Oko\".';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Chybí pole?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Pokud nějaká položka chybí, můžete ji **kliknutím na ikonu \"Plus \"** přidat (např.: vitamin D, hořčík...).';

  @override
  String get edit_product_form_save => 'Upravit';

  @override
  String get edit_product_ingredients_photo_title => 'Fotografie ingrediencí';

  @override
  String get edit_product_ingredients_list_title => 'Složení';

  @override
  String get edit_product_packaging_photo_title => 'Foto balení';

  @override
  String get edit_product_packaging_list_title => 'Seznam balení';

  @override
  String get no_data_available => 'Nejsou dostupná žádná data';

  @override
  String get product_field_website_title => 'Webová stránka';

  @override
  String get origins_editing_title => 'Upravit původ';

  @override
  String get completed_basic_details_btn_text => 'Vyplňte základní údaje';

  @override
  String get not_implemented_snackbar_text => 'Zatím neimplementováno';

  @override
  String get category_picker_page_appbar_text => 'Kategorie';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extrahujte přísady z fotografie';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Aut. rozpoznat složení';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extrahují se přísady\nz fotografie';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Načítání fotografie…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Proč se mi zobrazuje tato zpráva?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'Chcete-li použít funkci „Extrahovat ingredience“, musíte nejprve nahrát fotografii.\n\nPočkejte prosím několik sekund nebo je zadejte ručně.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Obnovit fotku';

  @override
  String get edit_packaging_extract_btn_text => 'Extrahujte obal\nz fotografie';

  @override
  String get edit_packaging_extract_btn_text_short => 'Rozpoznat balení';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extrahuje se obal z fotografie';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Načítání fotografie…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Proč se mi zobrazuje tato zpráva?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'Chcete-li použít funkci \"Extrahovat obal\", musíte nejprve nahrát fotografii.\n\nPočkejte prosím několik sekund nebo je zadejte ručně.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Obnovit fotku';

  @override
  String get edit_ocr_extract_failed =>
      'Nepodařilo se rozpoznat text v obrázku.';

  @override
  String get edit_ocr_extract_disabled_title => 'Žádný obrázek!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'Chcete-li použít funkci rozpoznání textu, musíte nejprve pořídit fotografii.';

  @override
  String get user_list_dialog_new_title => 'Nový seznam produktů';

  @override
  String get user_list_dialog_rename_title => 'Přejmenovat seznam';

  @override
  String get user_list_subtitle_product => 'Seznamy';

  @override
  String get user_list_title => 'Seznamy';

  @override
  String get user_list_add_product => 'Přidejte produkt do svých seznamů';

  @override
  String get user_list_button_new => 'Vytvořit nový seznam';

  @override
  String get user_list_empty_label =>
      'Zatím není k dispozici žádný seznam, začněte jeho vytvořením';

  @override
  String get user_list_button_add_product => 'Přidat na seznam';

  @override
  String get added_to_list_msg => 'Přidáno do seznamu';

  @override
  String get user_list_popup_clear => 'Vymažte historii';

  @override
  String get user_list_popup_rename => 'Přejmenovat';

  @override
  String get user_list_name_hint => 'Můj seznam';

  @override
  String get user_list_name_error_empty => 'Název je povinný';

  @override
  String get user_list_name_error_already => 'Tento název se již používá';

  @override
  String get user_list_name_error_same => 'To je stejné jméno';

  @override
  String get user_list_name_input_hint => 'Název seznamu';

  @override
  String get try_again => 'Zkuste to znovu';

  @override
  String get there_was_an_error => 'Došlo k chybě';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Pro $items nebyla nalezena žádná kategorie';
  }

  @override
  String get camera_toggle_camera => 'Přepínání mezi zadní a přední kamerou';

  @override
  String get camera_toggle_flash => 'Zapnout nebo vypnout blesk kamery';

  @override
  String get camera_enable_flash => 'Povolit blesk';

  @override
  String get camera_disable_flash => 'Zakázat blesk';

  @override
  String get camera_flash_error_dialog_title => 'Vyskytla se chyba!';

  @override
  String get camera_flash_error_dialog_message =>
      'Při změně stavu blesku došlo k chybě. Ujistěte se, že váš smartphone již nemá zapnutou svítilnu.';

  @override
  String get category_picker_no_category_found_button => 'Zpět';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Kliknutím otevřete ve svém prohlížeči nebo v aplikaci (pokud je nainstalována)';

  @override
  String get dev_preferences_screen_title => 'DEV režim';

  @override
  String get dev_preferences_screen_subtitle =>
      'Přístup k experimentálním funkcím a vývojářským nástrojům';

  @override
  String get dev_preferences_reset_onboarding_title => 'Restartovat zapojení';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Potom musíte aplikaci restartovat, abyste ji mohli znovu vidět.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Přepínání mezi openfoodfacts.org (PROD) a testovacím prostředím';

  @override
  String get dev_preferences_test_environment_title =>
      'Parametry testovacího prostředí';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Základní URL pro aktuální testovací prostředí: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Hostitel testovacího prostředí';

  @override
  String get dev_preferences_ml_kit_title => 'Použít ML kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'pak musíte tuto aplikaci restartovat';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Další tlačítko na stránce produktu';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Upravte přísady pomocí tlačítka na panelu znalostí';

  @override
  String get dev_preferences_export_history_title => 'Historie exportu';

  @override
  String get dev_preferences_export_history_progress_error => 'výjimka';

  @override
  String get dev_preferences_export_history_progress_found => 'produkt nalezen';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'produkt nenalezen';

  @override
  String get dev_preferences_export_history_dialog_title => 'Historie exportu';

  @override
  String get dev_preferences_button_positive => 'OK';

  @override
  String get dev_preferences_button_negative => 'Zrušit';

  @override
  String get dev_preferences_migration_title => 'Migrace dat z V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Stav: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'úspěšná nebo čerstvá instalace';

  @override
  String get dev_preferences_migration_status_success => 'úspěch';

  @override
  String get dev_preferences_migration_status_error => 'chyba';

  @override
  String get dev_preferences_migration_status_in_progress => 'probíhá';

  @override
  String get dev_preferences_migration_status_required =>
      'vyžadováno (kliknutím spustíte)';

  @override
  String get dev_preferences_migration_status_not_started => 'neznámý';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Vymaže historii a vloží tam 3 produkty';

  @override
  String get dev_preferences_news_custom_url_title => 'Vlastní URL pro zprávy';

  @override
  String get dev_preferences_news_custom_url_subtitle => 'URL souboru JSON:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Nenastaveno';

  @override
  String get dev_preferences_news_provider_status_title => 'Stav';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Poslední aktualizace: $date';
  }

  @override
  String get product_type_label_food => 'Jídlo';

  @override
  String get product_type_label_beauty => 'Osobní péče';

  @override
  String get product_type_label_pet_food => 'Zvířecí krmivo';

  @override
  String get product_type_label_product => 'Ostatní';

  @override
  String get product_type_selection_title => 'Typ produktu';

  @override
  String get product_type_selection_subtitle => 'Vyberte typ tohoto produktu';

  @override
  String get product_type_selection_empty =>
      'Nejprve musíte vybrat typ produktu!';

  @override
  String product_type_selection_already(String productType) {
    return 'Nelze změnit typ produktu ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Zástupce pro aplikaci Ceny na produktové stránce';

  @override
  String get prices_app_button => 'Přejít do aplikace Ceny';

  @override
  String get prices_website_button => 'Otevřít na webu Open Prices';

  @override
  String get prices_bulk_proof_upload_select =>
      'Add price tags directly from gallery';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Once you\'ve selected images, you won\'t be able to edit them!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Umožněte komunitě ověřovat ceny získané umělou inteligencí.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Multiple Price Tags';

  @override
  String get prices_bulk_proof_upload_title => 'Bulk Proof Upload';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Výběr souborů';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Zahájení nahrávání';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Lokální kopírování souboru #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Příprava nahrávání #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Selhalo u obrázku #$index/$count';
  }

  @override
  String get prices_generic_title => 'Ceny';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add $count prices',
      one: 'Add a price',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Send $count prices',
      one: 'Send the price',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Přidat položku';

  @override
  String get prices_add_a_price => 'Přidat cenu';

  @override
  String get prices_add_a_receipt => 'Přidat účtenku';

  @override
  String get prices_add_price_tags => 'Přidejte cenovky';

  @override
  String prices_barcode_already(String barcode) {
    return 'Tento čárový kód ($barcode) je již v seznamu!';
  }

  @override
  String get prices_barcode_search_not_found => 'Produkt nebyl nalezen';

  @override
  String get prices_barcode_search_none_yet => 'Zatím žádný produkt';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Hledání $barcode';
  }

  @override
  String get prices_barcode_enter => 'Zadejte čárový kód';

  @override
  String get prices_category_enter => 'Položka bez čárového kódu';

  @override
  String get prices_per_kilogram => 'Cena za kilogram';

  @override
  String get prices_per_unit => 'Cena za kus';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / jednotka';

  @override
  String get prices_category_mandatory => 'Povinné';

  @override
  String get prices_category_optional => 'Volitelný';

  @override
  String get prices_category_error_mandatory => 'Kategorie je povinná';

  @override
  String get prices_barcode_reader_action => 'Čtečka čárových kódů';

  @override
  String get prices_view_prices => 'Zobrazit ceny';

  @override
  String get prices_list_title => 'Ceník';

  @override
  String get prices_list_count => 'Počet cen\n';

  @override
  String get prices_list_add_new_price => 'Přidat novou cenu\n';

  @override
  String get prices_list_empty_title => 'Zatím žádná cena!';

  @override
  String get prices_list_empty_subtitle =>
      'Buďte první, kdo jeden přidá:\nNaskenováním **účtenky** nebo **cenovky**!';

  @override
  String get prices_entry_shop_not_found => 'Neznámý obchod';

  @override
  String prices_entry_menu_title(String user) {
    return 'Zadání ceny od „$user“';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Zobrazit všechny ceny tohoto produktu';

  @override
  String get prices_entry_menu_open_proof => 'Zobrazit důkaz';

  @override
  String get prices_entry_menu_my_prices => 'Zobrazit mé další ceny';

  @override
  String get prices_entry_menu_author_prices => 'Zobrazit další ceny od autora';

  @override
  String get prices_entry_menu_shop_prices => 'Zobrazit další ceny z obchodu';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: '1 price',
    );
    return '$_temp0 for $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Všech $count cen',
      few: 'Všechny $count ceny',
      one: 'Pouze 1 cena',
      zero: 'Zatím žádná cena',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Posledních $pageSize cen (celkem: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Cena: $price / Obchod: \"$location\" / Zveřejněno dne $date od \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Otevřené doklady \"$user\"';
  }

  @override
  String get prices_open_proof => 'Otevřený doklad o ceně';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count proofs',
      one: 'Only one proof',
      zero: 'No proof yet',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Nejnovější $pageSize doklady (celkem: $total)';
  }

  @override
  String get prices_users_empty_title => 'Zatím žádný přispěvatel!';

  @override
  String get prices_users_empty_explanation => 'Buďte první, kdo přidá cenu!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Nejlepší $pageSize přispěvatelé (celkem: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Zatím žádný obchod!';

  @override
  String get prices_locations_empty_explanation =>
      'Buďte první, kdo přidá cenu!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize locations (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count proofs',
      one: 'One proof',
      zero: 'No proof',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: 'One product',
      zero: 'No product',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count users',
      one: 'One user',
      zero: 'No user',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: 'One price',
      zero: 'No price',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Cena byla přidána dříve';

  @override
  String get prices_amount_subtitle => 'Množství';

  @override
  String get prices_amount_is_discounted => 'Je zlevněné?';

  @override
  String get prices_amount_price_normal => 'Cena';

  @override
  String get prices_amount_price_discounted => 'Snížená cena';

  @override
  String get prices_amount_price_not_discounted => 'Původní cena';

  @override
  String get prices_amount_no_product => 'Jeden produkt chybí!';

  @override
  String get prices_amount_price_incorrect => 'Nesprávná hodnota';

  @override
  String get prices_amount_price_mandatory => 'Povinná hodnota';

  @override
  String get prices_currency_subtitle => 'Měna';

  @override
  String get prices_date_subtitle => 'Datum';

  @override
  String get prices_location_subtitle => 'Obchod';

  @override
  String get prices_location_find => 'Najít obchod';

  @override
  String get prices_location_mandatory => 'Musíte vybrat obchod!';

  @override
  String get prices_location_search_broader =>
      'Nenašli jste to, co jste hledali? Pojďme zkusit širší vyhledávání!';

  @override
  String get prices_proof_subtitle => 'Doklad';

  @override
  String get prices_proof_empty_title => 'Zatím žádný důkaz!';

  @override
  String get prices_proof_empty_explanation =>
      'Začněte přidáním fotografie **účtenky** nebo **cenovky**!';

  @override
  String get prices_proof_find => 'Vybrat doklad';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Účtenka';

  @override
  String get prices_proof_price_tag => 'Cenovka';

  @override
  String get prices_proof_mandatory => 'Musíte vybrat doklad!';

  @override
  String get prices_add_validation_error => 'Chyba ověření';

  @override
  String get prices_privacy_warning_title => 'Upozornění na soukromí';

  @override
  String get prices_unknown_product => 'Neznámý produkt';

  @override
  String get prices_privacy_warning_main_message =>
      'Ceny **budou veřejné** spolu s obchodem, na který odkazují.\n\nTo by mohlo umožnit lidem, kteří vědí o vašem pseudonymu Open Food Facts:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Odhadnout, ve které oblasti žijete';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Vědět, co kupujete';

  @override
  String get prices_privacy_warning_sub_message =>
      'Pokud s tím nejste spokojeni, změňte si prosím svůj pseudonym nebo si vytvořte nový účet Open Food Facts a přihlaste se pomocí něj do aplikace.';

  @override
  String get i_refuse => 'Odmítám';

  @override
  String get i_accept => 'Přijímám';

  @override
  String get prices_currency_change_proposal_title => 'Změnit měnu?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Vaše současná měna je **$currency**. Chcete ji změnit na **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Ano, použít $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Ne, ponechat $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Hotovo';

  @override
  String get dev_mode_section_server => 'Konfigurace serveru';

  @override
  String get dev_mode_section_news => 'Konfigurace poskytovatele zpráv';

  @override
  String get dev_mode_section_product_page => 'Stránka produktu';

  @override
  String get dev_mode_section_ui => 'Uživatelské rozhraní';

  @override
  String get dev_mode_section_experimental_features => 'Experimentální funkce';

  @override
  String get dev_mode_hide_environmental_score_title => 'Vyloučit Green-Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Použít kontrolu pravopisu pro OCR obrazovky';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(Složení a balení)';

  @override
  String get dev_mode_reset_app_language_title => 'Obnovit jazyk aplikace';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Přidat karty';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Přepínání mezi prices.openfoodfacts.org (PROD) a testovacím prostředím';

  @override
  String get search_history_item_edit_tooltip =>
      'Znovu použijte a upravte toto vyhledávání';

  @override
  String get search_history_item_remove_tooltip => 'Odstranit';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Stáhli jste všech $totalSize produktů.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Stáhnout $count dalších produktů\nJiž staženo $downloaded ze $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Vaše vyhledávání „$search“ probíhá.\n\nPočkejte prosím několik sekund…';
  }

  @override
  String get user_search_contributor_title => 'Produkty, které jsem přidal';

  @override
  String get user_search_informer_title => 'Produkty, které jsem upravoval';

  @override
  String get user_search_photographer_title => 'Produkty, které jsem nafotil';

  @override
  String get user_search_to_be_completed_title => 'Moje produkty k dokončení';

  @override
  String get user_search_prices_title => 'Moje ceny';

  @override
  String get user_search_proofs_title => 'Moje důkazy';

  @override
  String get user_search_proof_title => 'Můj doklad';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Ceny přispěvatelů: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Přidány nejnovější ceny';

  @override
  String get all_search_prices_top_user_title => 'Nejlepší přispěvatelé cen';

  @override
  String get all_search_prices_top_location_title => 'Obchody s nejvíce cenami';

  @override
  String get prices_contribution_assistant => 'Asistent pro přidání ceny';

  @override
  String get prices_validation_assistant => 'Asistent pro ověření ceny';

  @override
  String get prices_challenges_page => 'Výzvy';

  @override
  String get prices_multiple_proof_addition_system => 'Add Multiple Proofs';

  @override
  String get all_search_prices_top_location_single_title => 'Ceny v obchodě';

  @override
  String get all_search_prices_top_product_title => 'Produkty s nejvíce cenami';

  @override
  String get all_search_to_be_completed_title => 'Všechny produkty k dokončení';

  @override
  String get categorize_products_country_title =>
      'Pomozte roztřídit produkty ve vaší zemi';

  @override
  String get edit_product_action_retake_picture => 'Znovu pořídit fotografii';

  @override
  String get edit_product_action_take_picture => 'Vyfotit';

  @override
  String get edit_product_action_confirm => 'Potvrdit';

  @override
  String get signup_page_terms_of_use_line1 => 'Souhlasím s Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'podmínky použití a příspěvek';

  @override
  String get analytics_consent_image_semantic_label => 'Ikona analytiky';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Závažná chyba: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Závažná chyba: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Vyplňte základní údaje';

  @override
  String get edit_photo_button_label => 'Upravit';

  @override
  String get edit_photo_unselect_button_label => 'Zrušit výběr fotky';

  @override
  String get edit_photo_select_existing_button_label =>
      'Vyberte existující obrázek';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existující obrázky pro tento produkt';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Vyberte obrázek kliknutím na něj';

  @override
  String get edit_photo_select_existing_download_label =>
      'Načítání existujících obrázků…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Neexistují žádné dříve nahrané obrázky související s tímto produktem.';

  @override
  String get edit_photo_language_not_this_one =>
      'V tomto jazyce zatím není žádný obrázek';

  @override
  String get edit_photo_language_none => 'Zatím žádný obrázek';

  @override
  String get category_picker_screen_title => 'Kategorie';

  @override
  String get basic_details => 'Základní detaily';

  @override
  String get product_name => 'Název produktu';

  @override
  String get product_names => 'Názvy produktů';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Přidat nový překlad';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Before validating, please ensure you only add a translation **if the language is present on the packaging**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Zobrazit přední fotku';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Vyfoťte přední stranu';

  @override
  String get add_basic_details_product_name_hint =>
      'Zadejte název produktu (např.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Změnit výchozí jazyk?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Chcete, aby byl výchozí jazyk produktu nastaven na \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Dobré příklady';

  @override
  String get explanation_section_bad_examples => 'Špatné příklady';

  @override
  String get add_basic_details_product_name_help_title =>
      'Osvědčené postupy: Název produktu';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Název produktu je **hlavní název vytištěný na obalu**. Může to být registrovaná ochranná známka.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Poznámka:** Nepřidávejte překlad, **pokud na obalu není uveden jazyk**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Rajčatový kečup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Neuvádějte značku v názvu';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Rajčatový kečup **od Heinze**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Nepoužívejte symboly ®, ™, © nebo podobné';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count other translations',
      one: '$count other translation',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Název značky';

  @override
  String get brand_names => 'Názvy značek';

  @override
  String get add_basic_details_brand_name_error => 'Zadejte název značky';

  @override
  String get add_basic_details_brand_names_hint =>
      'Zadejte značky (např.: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Dobrá praxe: Značky';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Zadejte **všechny značky výrobku**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Hlavní značka';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Hlavní značku**, obecně jasně uvedenou na předním balení, je třeba **zadat jako první**.';

  @override
  String get add_basic_details_product_brand_help_info3_title =>
      'Ostatní značky';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'When sold **by a big company**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** prodává **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'When sold with its brand **translated in multiple languages**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** se někdy píše **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Množství a hmotnost';

  @override
  String get add_basic_details_quantity_hint =>
      'Zadejte hmotnost a v případě potřeby množství (např.: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Dobrá praxe: Množství';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Zkopírujte hodnotu uvedenou na produktu a **nezapomeňte na jednotky**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** nebo **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (pro 6 vajec)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 g**\n(pro produkt se 3 krabičkami, každá po 150 g)';

  @override
  String get barcode => 'Čárový kód';

  @override
  String barcode_barcode(String barcode) {
    return 'Čárový kód: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Neplatný čárový kód';

  @override
  String get basic_details_add_success => 'Základní údaje byly úspěšně přidány';

  @override
  String get basic_details_add_error =>
      'Nelze přidat základní podrobnosti. Zkuste to znovu po nějaké době';

  @override
  String get clear_search => 'Vymažte vyhledávání';

  @override
  String get confirm_clear =>
      'Chystáte se vymazat celou historii: opravdu chcete pokračovat?';

  @override
  String get alert_clear_selected_user_list =>
      'Chystáte se vymazat vybrané položky ve své historii';

  @override
  String get confirm_clear_selected_user_list =>
      'Opravdu si přejete pokračovat?';

  @override
  String get alert_select_items_to_clear =>
      'Vyberte jednu nebo více položek, které chcete vymazat';

  @override
  String confirm_clear_user_list(String name) {
    return 'Chystáte se vymazat tento seznam ($name): opravdu chcete pokračovat?';
  }

  @override
  String get confirm_delete_user_list_title => 'Smazat seznam?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'Chystáte se smazat seznam \"$name\".\nOpravdu chcete pokračovat?';
  }

  @override
  String get confirm_delete_user_list_button => 'Ano, potvrzuji';

  @override
  String importance_label(String name, String id) {
    return '$name důležitosti: $id';
  }

  @override
  String get user_list_all_title => 'Seznamy';

  @override
  String get user_list_all_empty => 'Vytvořte svůj první seznam';

  @override
  String get product_list_select => 'Vyberte seznam';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count produktů',
      one: '1 produkt',
      zero: 'Prázdný seznam',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Přidat seznam';

  @override
  String get open_food_preferences_tooltip =>
      'Upravte své preference ohledně jídla';

  @override
  String get add_photo_button_label => 'Přidat fotografii';

  @override
  String get add_packaging_photo_button_label =>
      'Vyfoťte veškeré informace o balení/recyklaci';

  @override
  String get add_origin_photo_button_label =>
      'Vyfoťte veškeré informace o původu';

  @override
  String get add_emb_photo_button_label =>
      'Vyfoťte veškeré informace o kódu sledovatelnosti';

  @override
  String get add_label_photo_button_label =>
      'Vyfoťte veškeré informace o štítcích a certifikacích';

  @override
  String get choose_image_source_title => 'Vyberte zdroj obrázku';

  @override
  String get choose_image_source_body => 'Vyberte prosím zdroj obrázku';

  @override
  String get gallery_source_label => 'Galerie';

  @override
  String get gallery_source_access_denied_dialog_title => 'Přístup odepřen';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Aplikace bohužel nemá přístup k vaší galerii, protože jste již dříve odepřeli oprávnění.\n\nPřejděte do nastavení aplikace v nastavení telefonu -> Fotky';

  @override
  String get gallery_source_access_denied_dialog_button => 'Otevřít nastavení';

  @override
  String get share => 'Sdílet';

  @override
  String share_product_text(String url) {
    return 'Podívejte se na tento produkt na Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Podívejte se na tento produkt na Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Podívejte se na tento produkt na Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Podívejte se na tento produkt na Open Food Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Podívejte se na můj seznam produktů na Open Food Facts: $url';
  }

  @override
  String get capture => 'Zachytit nový';

  @override
  String get capture_new_picture => 'Vyfotit';

  @override
  String get choose_from_gallery => 'Vybrat z galerie';

  @override
  String get image_upload_queued =>
      'Obrázek bude nahrán na pozadí co nejdříve.';

  @override
  String get add_price_queued => 'Cena bude zaslána na server co nejdříve.';

  @override
  String get background_task_title_full_refresh =>
      'Spouštění aktualizace všech lokálně uložených produktů';

  @override
  String get background_task_title_top_n =>
      'Zahájení stahování nejoblíbenějších produktů';

  @override
  String get expand_nutrition_facts => 'Rozbalit tabulku nutričních údajů';

  @override
  String get expand_nutrition_facts_body =>
      'Nechte tabulku nutričních údajů rozšířenou';

  @override
  String get expand_ingredients => 'Rozbalit přísady';

  @override
  String get expand_ingredients_body => 'Nechte panel ingrediencí rozbalený';

  @override
  String get no_internet_connection => 'Žádné připojení k Internetu';

  @override
  String get world_results_label => 'Celý svět';

  @override
  String get world_results_action => 'Rozšířit hledání na celý svět';

  @override
  String get copy_to_clipboard => 'Kopírovat';

  @override
  String get paste_from_clipboard => 'Vložit ze schránky';

  @override
  String get no_data_available_in_clipboard =>
      'Ve vaší schránce nejsou k dispozici žádná data';

  @override
  String get clipboard_barcode_copy => 'Kopírovat čárový kód do schránky';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Čárový kód $barcode zkopírován do schránky!';
  }

  @override
  String get open_product_website => 'Otevřete tento produkt na webu';

  @override
  String get language_picker_label => 'Váš jazyk';

  @override
  String get country_picker_label => 'Vaše země';

  @override
  String get currency_picker_label => 'Vaše měna';

  @override
  String get help_with_openfoodfacts => 'Pomoc s OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Produkt bude aktualizován na pozadí co nejdříve.';

  @override
  String get no_email_client_available_dialog_title =>
      'Žádné e-mailové aplikace!';

  @override
  String get no_email_client_available_dialog_content =>
      'Pošlete nám prosím ručně e-mail na adresu mobile@openfoodfacts.org';

  @override
  String get all_images => 'Všechny obrázky';

  @override
  String get selected_images => 'Vybrané obrázky';

  @override
  String get product_card_remove_product_tooltip => 'Odstranit produkt';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nový naskenovaný čárový kód: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Odstranit všechny produkty z karuselu';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Naskenujte prosím alespoň dva produkty a porovnejte je';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Kliknutím porovnáte produkty, které jste naskenovali';

  @override
  String get scan_product_loading => 'Naskenovali jste\nčárový kód:';

  @override
  String get scan_product_loading_initial =>
      'Hledáme tento produkt!\nPočkejte prosím několik sekund…';

  @override
  String get scan_product_loading_long_request =>
      'Tento produkt stále hledáme!\nZdá se vám, že načítání trvá dlouho? Tak my…';

  @override
  String get scan_product_loading_unresponsive =>
      'Stále hledáme tento produkt.\nChcete restartovat vyhledávání?';

  @override
  String get scan_product_loading_restart_button => 'Restartovat hledání';

  @override
  String get portion_calculator_description =>
      'Vypočítejte nutriční údaje pro konkrétní množství';

  @override
  String get portion_calculator_hint => 'Množství v';

  @override
  String get portion_calculator_accessibility =>
      'Zadejte množství pro výpočet nutričních údajů';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Zadejte množství mezi $min a $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Chybějící data. Výpočet nebylo možné provést.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Výživové údaje na $grams g (nebo ml)';
  }

  @override
  String get offline_data => 'Offline data';

  @override
  String get ocr_image_upload_instruction =>
      'Nahrajte obrázek, abyste automaticky extrahovali informace, které obsahuje.';

  @override
  String get upload_image => 'Nahrát fotku';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Nepodařilo se stáhnout obrázek';

  @override
  String get image_edit_url_error =>
      'Úprava obrázku se nezdařila, protože nebyla nastavena URL obrázku.';

  @override
  String get user_picture_source_remember => 'Zapamatovat si moji volbu';

  @override
  String get user_picture_source_ask => 'Pokaždé se zeptat';

  @override
  String get robotoff_continue => 'Pokračovat';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count otázek',
      one: 'otázka',
    );
    return 'Další $_temp0';
  }

  @override
  String get show_password => 'Zobrazit heslo';

  @override
  String get owner_field_info_title => 'Hodnoty poskytnuté výrobcem';

  @override
  String get owner_field_info_message =>
      'Tímto logem upozorňujeme na údaje, které poskytuje výrobce a které nemusí být upravitelné.';

  @override
  String get owner_field_info_close_button => 'Zavřete tyto informace';

  @override
  String get owner_field_image =>
      'Tento obrázek je poskytován výrobcem. Nemusí být upravitelný.';

  @override
  String get edit_packagings_title => 'Součásti obalu';

  @override
  String get edit_packagings_element_add => 'Přidejte součást obalu';

  @override
  String get edit_packagings_completed => 'Balení je kompletní';

  @override
  String edit_packagings_element_title(int index) {
    return 'Složka balení #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Počet jednotek';

  @override
  String get edit_packagings_element_hint_units =>
      'Zadejte počet obalových jednotek stejného tvaru a materiálu obsažených v produktu.';

  @override
  String get edit_packagings_element_field_shape => 'Tvar';

  @override
  String get edit_packagings_element_hint_shape =>
      'Zadejte název tvaru uvedený v pokynech k recyklaci, pokud jsou k dispozici, nebo vyberte tvar.';

  @override
  String get edit_packagings_element_example_shape => 'Láhev';

  @override
  String get edit_packagings_element_field_material => 'Materiál';

  @override
  String get edit_packagings_element_hint_material =>
      'Zadejte konkrétní materiál, pokud jej lze určit (kód materiálu uvnitř trojúhelníku lze často nalézt na částech balení), nebo obecný materiál (například plast nebo kov), pokud si nejste jisti.';

  @override
  String get edit_packagings_element_example_material => 'Sklo';

  @override
  String get edit_packagings_element_field_recycling => 'Pokyny k recyklaci';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Pokyny k recyklaci zadávejte pouze v případě, že jsou uvedeny na produktu.';

  @override
  String get edit_packagings_element_example_recycling => 'Recyklace';

  @override
  String get edit_packagings_element_field_quantity =>
      'Čisté množství produktu na jednotku';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Zadejte čistou hmotnost nebo čistý objem a uveďte jednotku (například g nebo ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Hmotnost jedné prázdné jednotky (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Před vážením odstraňte veškeré zbývající potraviny a omyjte a osušte část obalu. Pokud je to možné, použijte váhu s přesností 0,1 g nebo 0,01 g.';

  @override
  String get background_task_title => 'Nevyřízené příspěvky';

  @override
  String get background_task_subtitle =>
      'Vaše příspěvky jsou automaticky uloženy na náš server, ale ne vždy v reálném čase.';

  @override
  String get background_task_list_empty => 'Žádné nevyřízené úkoly na pozadí';

  @override
  String get background_task_error_server_time_out => 'Časový limit serveru';

  @override
  String get background_task_error_no_internet =>
      'Chyba připojení k internetu. Zkuste to později.';

  @override
  String get background_task_operation_unknown => 'neznámý typ operace';

  @override
  String get background_task_operation_details => 'podrobné změny';

  @override
  String get background_task_operation_image => 'nahrání fotografie';

  @override
  String get background_task_operation_refresh =>
      'aktualizace zpožděna po nahrání fotografie';

  @override
  String get background_task_run_started => 'začalo';

  @override
  String get background_task_run_not_started => 'zatím nezačalo';

  @override
  String get background_task_run_to_be_deleted => 'k vymazání';

  @override
  String get background_task_question_stop =>
      'Chcete tento úkol co nejdříve zastavit?';

  @override
  String get feed_back => 'Zpětná vazba';

  @override
  String get undo => 'Zpět';

  @override
  String get copy_email_to_clip_board => 'Kopírovat e-mail do schránky';

  @override
  String get please_send_us_an_email_to => 'Pošlete nám prosím ručně e-mail na';

  @override
  String get email_copied_to_clip_board => 'E-mail zkopírován do schránky!';

  @override
  String get select_accent_color => 'Vyberte barvu zvýraznění';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Modrá';

  @override
  String get color_cyan => 'Azurová';

  @override
  String get color_green => 'Zelená';

  @override
  String get color_light_brown => 'Výchozí';

  @override
  String get color_magenta => 'Purpurová';

  @override
  String get color_orange => 'Oranžová';

  @override
  String get color_pink => 'Růžová';

  @override
  String get color_red => 'Červená';

  @override
  String get color_rust => 'Rezavá';

  @override
  String get color_teal => 'Tmavě modrozelená';

  @override
  String get text_contrast_mode => 'Kontrast textu';

  @override
  String get contrast_high => 'Vysoký';

  @override
  String get contrast_medium => 'Střední';

  @override
  String get contrast_low => 'Nízký';

  @override
  String get product_refresher_internet_not_found => 'Produkt nenalezen!';

  @override
  String get product_refresher_internet_not_connected =>
      'Nejste připojeni k internetu!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server nefunguje ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Chyba serveru ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Produkt nenalezen!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Produkt s následujícím čárovým kódem v naší databázi neexistuje: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'Žádné připojení k Internetu!';

  @override
  String get product_loader_network_error_message =>
      'Zkontrolujte, zda je váš smartphone připojen k síti WiFi nebo má povolená mobilní data';

  @override
  String get page_not_found_title => 'Stránka nenalezena!';

  @override
  String get page_not_found_button => 'Vraťte se na domovskou stránku';

  @override
  String get download_data => 'Stáhnout data';

  @override
  String get download_top_products =>
      'Stáhněte si 1000 nejlepších produktů ve vaší zemi pro okamžité skenování';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'nejlepších $count produktů',
      many: 'nejlepších $count produktů',
      few: 'nejlepší $count produkty',
      one: 'nejlepší $count produkt',
    );
    return 'Stáhnout $_temp0 ve tvé zemi pro okamžité skenování';
  }

  @override
  String get download_in_progress => 'Stahování dat\nMůže to chvíli trvat';

  @override
  String downloaded_products(int num) {
    return '$num produktů přidáno';
  }

  @override
  String get update_offline_data => 'Aktualizovat offline data produktů';

  @override
  String get update_local_database_sub =>
      'Aktualizujte místní databázi produktů nejnovějšími údaji z Open Food Facts';

  @override
  String get clear_local_database => 'Vymažte offline produktová data';

  @override
  String get clear_local_database_sub =>
      'Vymazat všechna data lokálních produktů z aplikace a uvolnit tak místo';

  @override
  String deleted_products(int num) {
    return '$num produktů smazáno';
  }

  @override
  String get loading => 'Načítá se…';

  @override
  String get know_more => 'Zjistit více';

  @override
  String get offline_data_desc =>
      'Klikněte pro více informací o offline datech';

  @override
  String get offline_product_data_title => 'Offline produktová data';

  @override
  String available_for_download(int num) {
    return '$num produktů dostupných k okamžitému skenování';
  }

  @override
  String get country_selector_title => 'Vyberte svou zemi:';

  @override
  String get currency_selector_title => 'Vyberte svou měnu:';

  @override
  String get language_selector_title => 'Vyberte svůj jazyk:';

  @override
  String get language_selector_section_selected => 'Vybrané jazyky';

  @override
  String get language_selector_section_frequently_used => 'Často používané';

  @override
  String get action_delete_list => 'Odstranit';

  @override
  String get action_change_list => 'Změnit aktuální seznam';

  @override
  String get product_list_create => 'Vytvořit';

  @override
  String get product_list_create_tooltip => 'Vytvořit nový seznam';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Nový výpočet)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Nový výpočet)';

  @override
  String get nutriscore_unknown => 'Neznámé Nutri-Score';

  @override
  String get nutriscore_unknown_new_formula =>
      'Neznámé Nutri-Score (Nový výpočet)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score nelze použít';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score nelze použít (Nový výpočet)';

  @override
  String get environmental_score_generic_new => 'Eco-score';

  @override
  String get environmental_score_a_new => 'Zelené skóre A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Zelené skóre E';

  @override
  String get environmental_score_unknown_new => 'Neznámé zelené skóre';

  @override
  String get environmental_score_not_applicable_new =>
      'Green-Score se nepoužije';

  @override
  String get nova_group_generic_new =>
      'Ultra zpracované potraviny - skupiny NOVA';

  @override
  String get nova_group_1 => 'Skupina NOVA 1';

  @override
  String get nova_group_2 => 'Skupina NOVA 2';

  @override
  String get nova_group_3 => 'Skupina NOVA 3';

  @override
  String get nova_group_4 => 'Skupina NOVA 4';

  @override
  String get nova_group_unknown => 'Neznámá skupina NOVA';

  @override
  String get nutrition_facts => 'Úrovně živin';

  @override
  String get faq_title_partners => 'Partneři a patroni nevládní organizace';

  @override
  String get faq_title_vision =>
      'Vize, mise, hodnoty a programy Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Nainstalujte Open Beauty Facts a vytvořte kosmetickou databázi';

  @override
  String get faq_title_install_pet =>
      'Nainstalujte si Open Pet Food Facts a vytvořte databázi krmiv pro domácí zvířata';

  @override
  String get faq_title_install_product =>
      'Nainstalujte Open Products Facts pro vytvoření databáze produktů pro prodloužení životnosti objektů';

  @override
  String get faq_nutriscore_nutriscore =>
      'Nový výpočet Nutri-Score: co je nového?';

  @override
  String get contact_title_pro_page =>
      'Pro? Importujte své produkty do Open Food Facts';

  @override
  String get contact_title_pro_email => 'Kontakt výrobce';

  @override
  String get contact_title_press_page => 'Pro média';

  @override
  String get contact_title_press_email => 'Kontakt pro novináře';

  @override
  String get contact_title_newsletter =>
      'Přihlaste se k odběru našeho zpravodaje';

  @override
  String get contact_title_calendar => 'Subscribe to our community calendar';

  @override
  String get hunger_games_loading_line1 => 'Dejte nám prosím pár sekund…';

  @override
  String get hunger_games_loading_line2 => 'Stahujeme otázky!';

  @override
  String get hunger_games_error_label =>
      'Argh! Něco se pokazilo… a otázky se nepodařilo načíst.';

  @override
  String get hunger_games_error_retry_button => 'Zkusme to znovu!';

  @override
  String get reorder_attribute_action => 'Změňte pořadí atributů';

  @override
  String get link_cant_be_opened =>
      'Tento odkaz nelze na vašem zařízení otevřít. Zkontrolujte, zda máte nainstalovaný prohlížeč.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Podrobnosti o $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Podrobnosti o $pageName s $productName';
  }

  @override
  String get guide_title => 'Průvodce';

  @override
  String get guide_share_label => 'Sdílet';

  @override
  String get guide_nutriscore_v2_title => 'Nutri-Score se vyvíjí: vysvětlení!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Co je Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'Nutri-Score je logo, jehož cílem je informovat vás o **nutriční kvalitě potravin**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'Barevný kód se liší od tmavě zelené (**A**) pro **nejzdravější** produkty až po tmavě červenou (**E**) pro **méně zdravé**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption => 'Logo Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Proč se Nutri-Score vyvíjí?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'Vzorec pro Nutri-Score **se vyvíjí** k poskytování lepších doporučení:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Lepší hodnocení všech nápojů';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'Srovnávací poznámky **mléka**, **mléčných nápojů** s přidaným cukrem a **zeleninových** nápojů byly v novém algoritmu lépe rozlišeny.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title => 'Lepší hodnocení nápojů';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      '**Obsah cukru** je lépe zohledněn a upřednostňuje **nízce slazené** nápoje.\\n**Sladidla budou rovněž penalizována**: dietní limonády budou sníženy z hodnocení B na hodnotu mezi C a E. Doporučeným nápojem zůstává voda.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title => 'Sůl a cukr penalizovány';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      '**Příliš sladké** nebo **příliš slané** produkty budou mít své **hodnocení dále sníženo**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchie v olejích a rybách';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'Hodnocení určitých **tučných ryb** a **olejů bohatých na dobré tuky** se zlepší.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Omezené červené maso';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Konzumace **červeného masa by měla být omezena**. To je důvod, proč **drůbež bude mít poměrně lepší hodnocení**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'Jak odlišit staré Nutri-Score a nový výpočet?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'Od této chvíle může logo zobrazovat zmínku „**Nový výpočet**“, aby bylo jasné, že se skutečně jedná o nový výpočet.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'Logo nového Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Kde najít nový výpočet Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score se používá v 7 zemích: Francii, Německu, Belgii, Španělsku, Lucembursku, Nizozemsku a Švýcarsku.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Výrobci mají nejpozději **2 roky** od podpisu vyhlášky na to, aby starý výpočet **nahradili** novým.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Bez čekání **už najdete v aplikaci OpenFoodFacts** nový výpočet, včetně případů, kdy výrobci neaktualizovali skóre.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'Co se nemění';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'Nutri-Score je skóre navržené k **měření nutriční kvality**. Je **doplňkem skupiny NOVA** pro **ultra zpracované potraviny** (taktéž přítomných v aplikaci).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'Pro výrobce zůstává zobrazení Nutri-Score **nepovinné**.';

  @override
  String get guide_greenscore_title => 'Eco-score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Co je to Zelené skóre?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Green-Score je logo, jehož cílem je informovat vás o **dopadu potravin na životní prostředí**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Barevný kód se pohybuje od tmavě zelené (**A+**) pro produkty s **nejméně dopadem** po tmavě červenou (**F**) pro produkty s **největším dopadem**.';

  @override
  String get guide_greenscore_logos_caption => 'Loga Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Jádro: Hodnocení životního cyklu (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Vědecké hodnocení kategorií potravin';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Pro každou kategorii produktů je stanoveno **referenční** skóre s využitím dat z environmentální databáze Agribalyse (kterou navrhly ADEME a INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Analýza životního cyklu** je standardizovaná metoda hodnocení pro provádění vícestupňového a vícekriteriálního environmentálního posouzení.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Měří:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 výrobních kroků';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Zemědělství';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Zpracování';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Obal';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Doprava';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribuce';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Spotřeba';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 ukazatelů dopadu na životní prostředí';

  @override
  String get guide_greenscore_lca_arg3_text1 => 'Změna klimatu/uhlíková stopa';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Úbytek ozonové vrstvy';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Ionizující záření';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Přistát';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Spotřeba vody a energie';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Znečištění ovzduší';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Mořská a sladká voda (částice, acidifikace, eutrofizace)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Vyčerpání zdrojů.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Bonusy a sankce';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'Abychom odměnili lepší produkty v dané kategorii, uplatňujeme **bonusy a sankce na základě několika kritérií**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title => 'Způsob výroby';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Bonus** se uděluje výrobkům, které mají **oficiální etiketu, označení nebo certifikace, která zaručuje přínos pro životní prostředí** (organický obchod, spravedlivý obchod, HVE, označení Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title => 'Původ přísad';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title => 'Ohrožené druhy';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Obal';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Zvýšená potřeba transparentnosti pro lepší měření a snižování dopadů na životní prostředí';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Jak mohou občané pomoci?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Všichni občané nám mohou pomoci shromáždit a strukturovat informace, které jsou na produktech uvedeny nebo z nich lze odvodit, například informace o **obalech**: „Mission Emballages“: rozsáhlý společný inventář obalů pro všechny potravinářské výrobky (ve francouzštině).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Jak mohou výrobci pomoci';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Výrobci nám mohou zasílat své informace přímo prostřednictvím naší bezplatné platformy pro výrobce.';

  @override
  String get guide_greenscore_better_product_title =>
      'Který produkt je lepší pro planetu?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Může být těžké říct';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Výběr udržitelných potravin je jednou z nejsilnějších věcí, které můžeme pro klima udělat, protože **náš globální potravinový systém je zodpovědný za více než čtvrtinu všech emisí skleníkových plynů**.\n(Zdroj: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Máš moc!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Dobrou zprávou je, že nám to dává účinný způsob, jak dosáhnout změny.\n**Každý z nás sní přibližně 1 000 jídel ročně**. To je 1 000 příležitostí **zvolit si lepší budoucnost pro planetu**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Pomáhá být zodpovědný a rozhodovat se';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Výběr udržitelných potravin se může zdát složitý. Štítky jsou matoucí a informace často chybí. Systém Green-Score byl vytvořen proto, aby to zjednodušil a poskytl vám **jasné**, **vědecky podložené** a **transparentní** environmentální hodnocení potravinářských výrobků přímo tam, kde ho potřebujete: při nakupování.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Průhlednost';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'Na rozdíl od proprietárních značek je výpočet Green-Score **zcela otevřený** a může být **ověřen kýmkoli**.';

  @override
  String get guide_nova_title => 'Ultra zpracované potraviny';

  @override
  String get guide_nova_what_is_nova_title => 'Co je ultraprocessing?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Skupiny NOVA vás informují o úrovni zpracování potravin.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Klasifikace NOVA umožňuje rozdělení potravin do **4 skupin** na základě jejich **stupně průmyslového zpracování** (minimálně zpracované nebo nezpracované potraviny, kulinářské ingredience, zpracované potraviny, ultrazpracované potraviny).';

  @override
  String get guide_nova_logos_caption => 'Loga NOVA';

  @override
  String get guide_nova_groups_title => '4 skupiny NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Existují 4 skupiny NOVA, problematická je skupina 4 – Ultrazpracované potraviny.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Minimálně zpracované nebo nezpracované potraviny';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title =>
      'Běžně zpracované kuchyňské přísady';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Běžně zpracované potraviny';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from Group 2 to group 1** Foods. processes include various preservation or cooking methods, and in the case of breads and Cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as modified versions Of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Ultra zpracované potraviny';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 Food. ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, Ultra-processed products also contain other sources of energy and nutrients not typically used in culinary preparations. Some of these are directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Problémy s ultraprocessingem';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Extrémní zpracování potravinářských surovin';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Přísady, které jdou nad rámec čisté bezpečnosti potravin';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Zpracování, které doma nezvládnete';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Predátorské a finanční aspekty ultraprocessingu';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-cs.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-cs.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-cs.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-cs.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'V současnosti je málo společností, které vlastní rozsáhlé databáze cen produktů na úrovni čárových kódů. Tyto ceny nejsou volně dostupné, ale prodávají se za vysokou cenu soukromým subjektům, výzkumníkům a dalším organizacím, které si je mohou dovolit.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'Jsem maloobchodník a chci přispět cenami. Jak to mohu udělat?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-cs.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Náhled';

  @override
  String get prices_feedback_form =>
      'Kliknutím sem nám pošlete svůj názor na tuto novou funkci!';

  @override
  String get menu_button_list_actions => 'Vyberte akci';

  @override
  String get error_loading_photo => 'Chyba při načítání fotografie';

  @override
  String get photo_viewer_action_use_picture_as => 'Použít jako…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Použijte tento obrázek jako…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Použít tento obrázek jako… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Podrobnosti';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Detaily této fotografie';

  @override
  String get photo_viewer_details_title => 'Detaily fotografie';

  @override
  String get photo_viewer_details_contributor_title => 'Přispěvatel';

  @override
  String get photo_viewer_details_size_title => 'Velikost';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixelů';
  }

  @override
  String get photo_viewer_details_date_title => 'Datum';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Kompatibilní';

  @override
  String get user_lists_action_multi_select => 'Hromadný výběr';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Vaše skóre kompatibility: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Přední obrázek';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Obrázek seznamu složek';

  @override
  String get product_image_nutrition_accessibility_label => 'Obrázek výživy';

  @override
  String get product_image_packaging_accessibility_label => 'Obrázek balení';

  @override
  String get product_image_other_accessibility_label => 'Jiný obrázek';

  @override
  String get product_image_outdated_message =>
      'Tento obrázek může být zastaralý';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (tento obrázek může být zastaralý)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (tento obrázek může být uzamčen výrobcem)';
  }

  @override
  String get product_image_error => 'Obrázek nelze načíst!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Nelze načíst $type (chyba sítě?)';
  }

  @override
  String get product_page_image_no_image_available => 'Žádný obrázek!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'K tomuto produktu není k dispozici žádný obrázek';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Změňte pořadí nebo skryjte akce';

  @override
  String get product_page_action_bar_setting_modal_title => 'Upravit akce';

  @override
  String get product_page_action_bar_item_move_up => 'Posunout nahoru';

  @override
  String get product_page_action_bar_item_move_down => 'Posunout dolů';

  @override
  String get product_page_action_bar_item_enable => 'Povolit akci';

  @override
  String get product_page_action_bar_item_disable => 'Zakázat akci';

  @override
  String get product_page_pending_operations_banner_title =>
      'Nahrávání vašich úprav…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Údaje zobrazené na této stránce **zatím neodrážejí vaše úpravy**.\nPočkejte prosím několik sekund…';

  @override
  String get product_add_a_language => 'Přidat jazyk';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Čárový kód $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Odstranit tento produkt z karuselu';

  @override
  String get carousel_unsupported_header => 'Nepodporovaný čárový kód!';

  @override
  String get carousel_unsupported_title => 'Jejda!';

  @override
  String get carousel_unsupported_text =>
      'Naskenovaný čárový kód není podporován Open Food Facts!';

  @override
  String get carousel_error_header => 'Chyba!';

  @override
  String get carousel_error_title => 'Je to průšvih!';

  @override
  String get carousel_error_text_1 =>
      'Nepodařilo se nám stáhnout informace o tomto čárovém kódu:';

  @override
  String get carousel_error_text_2 =>
      'Zkontrolujte prosím své internetové připojení nebo klikněte na toto tlačítko:';

  @override
  String get carousel_error_button => 'Opakovat';

  @override
  String get carousel_unknown_product_header => 'Neznámý produkt';

  @override
  String get carousel_unknown_product_title =>
      'Gratulujeme!\nNašli jste __vzácný drahokam!__';

  @override
  String get carousel_unknown_product_text =>
      'Naše společně tvořená databáze obsahuje více než **3 miliony produktů**, ale tento čárový kód neexistuje: ';

  @override
  String get carousel_unknown_product_button => 'Přidat výrobek';

  @override
  String get carousel_loading_header => 'Načítání informací...';

  @override
  String get carousel_loading_title =>
      'Právě jste naskenovali produkt s následujícím čárovým kódem:';

  @override
  String get carousel_loading_text =>
      'Hledáme ho v naší databázi více než **3 milionů produktů!**';

  @override
  String get product_type_subtitle_food =>
      'Zelenina, ovoce, mražené potraviny…';

  @override
  String get product_type_subtitle_beauty => 'Make-up, mýdla, zubní pasty…';

  @override
  String get product_type_subtitle_pet_food => 'Krmivo pro psy, kočky…';

  @override
  String get product_type_subtitle_product => 'Smartphony, nábytek…';

  @override
  String get photo_field_front => 'Fotografie produktu';

  @override
  String get photo_field_ingredients => 'Fotografie ingrediencí';

  @override
  String get photo_field_nutrition => 'Fotografie výživových údajů';

  @override
  String get photo_field_packaging => 'Informační foto balení';

  @override
  String get photo_already_exists => 'Tato fotografie již existuje';

  @override
  String get photo_missing => 'Tato fotografie chybí';

  @override
  String get date => 'Datum';

  @override
  String get photo_rotate_left => 'Otočit doleva';

  @override
  String get photo_rotate_right => 'Otočit doprava';

  @override
  String get photo_undo_action => 'Vrátit předchozí akci';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Mapa světa $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Přispěvatelé OpenStreetMap';

  @override
  String get not_applicable_short => 'Nedostupné';

  @override
  String get knowledge_panel_warning_text => 'Varování';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Proč se toto Nutri-Score liší od Nutri-Score na obalu?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Existují dvě možná vysvětlení:\nSeznam ingrediencí a/nebo výživových údajů není aktuální.\n\nPoskytujeme \"Nový výpočet\" Nutri-Score (nebo V2). Zkontrolujte, zda máte na obalu nápis \"Nový výpočet\".';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Zkontrolovat ingredience';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Zkontrolovat výživové údaje';

  @override
  String url_not_supported(String url) {
    return 'Bohužel nemůžeme otevřít adresu URL:\n$url';
  }

  @override
  String get product_list_export => 'Export';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'Zobrazit čárový kód';

  @override
  String get product_footer_action_barcode_short => 'Čárový kód';

  @override
  String get product_footer_action_open_website => 'Otevřít web';

  @override
  String get product_footer_action_report => 'Zpráva';

  @override
  String get product_footer_action_contributor_guide => 'Nápověda';

  @override
  String get product_footer_action_data_quality_tags => 'Kvalita dat';

  @override
  String get product_page_tab_for_me => 'Pro mě';

  @override
  String get product_page_tab_website => 'Webová stránka';

  @override
  String get product_page_tab_prices => 'Ceny';

  @override
  String get prices_explanation_card_title => 'Proč ceny?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** je projekt, jehož cílem je shromažďovat a sdílet ceny produktů z celého světa 🌍. Open Prices je vyvíjen a spravován společností Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Zjistit více';

  @override
  String get product_page_tab_folksonomy => 'Folksonomie';

  @override
  String get folksonomy_explanation_card_title =>
      'Jaké jsou atributy folksonomie?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Atributy jsou založeny na **klíč-hodnota**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Tyto vlastnosti jsou vytvářeny a archivovány přispěvateli pro jakékoli použití.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'Cena není k dispozici';

  @override
  String get prices_products_empty_explanation => 'Buďte první, kdo přispěje!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Nejlepších $pageSize produktů (celkem: $total)';
  }

  @override
  String get app_review_title => 'Líbí se vám tato aplikace?';

  @override
  String get app_review_low => 'Mohlo to být lepší';

  @override
  String get app_review_medium => 'Není to špatné';

  @override
  String get app_review_high => 'Moc se mi líbí!';

  @override
  String get app_review_feedback_modal_title =>
      'Pomozte nám vylepšit naši aplikaci';

  @override
  String get app_review_feedback_modal_content =>
      'Pokud máte pár minut, můžete odpovědět na tento formulář, abychom se **mohli zlepšit v budoucích aktualizacích**:';

  @override
  String get app_review_feedback_modal_open_form => 'Vyplnit formulář';

  @override
  String get app_review_feedback_modal_later => 'Zeptejte se mě později';

  @override
  String get nutrition_facts_extract_new =>
      'NOVINKA: Můžete automaticky extrahovat živiny z obrázku!';

  @override
  String get nutrition_facts_extract_button_text => 'Extrahujte nyní';

  @override
  String get nutrition_facts_extract_in_progress => 'Probíhá extrakce…';

  @override
  String get nutrition_facts_extract_successful => 'Extrakce úspěšná';

  @override
  String get nutrition_facts_extract_failed =>
      'Nepodařilo se extrahovat živiny z obrázku';

  @override
  String get prices_discount => 'Sleva';

  @override
  String get prices_stats_statistics => 'Statistiky';

  @override
  String get prices_stats_title => 'Statistiky cen';

  @override
  String get prices_stats_prices_section => 'Ceny';

  @override
  String get prices_stats_products_section => 'Produkty';

  @override
  String get prices_stats_locations_section => 'Polohy';

  @override
  String get prices_stats_proofs_section => 'Doklady';

  @override
  String get prices_stats_contributors_section => 'Přispěvatelé';

  @override
  String get prices_stats_experiments_section => 'Experimenty';

  @override
  String get prices_stats_misc_section => 'Ostatní';

  @override
  String get prices_stats_total => 'Celkem';

  @override
  String get prices_stats_with_barcode => 'S čárovým kódem';

  @override
  String get prices_stats_with_category => 'S kategorií';

  @override
  String get prices_stats_with_discount => 'Se slevou';

  @override
  String get prices_stats_community => 'Komunita';

  @override
  String get prices_stats_consumption => 'Spotřeba';

  @override
  String get prices_stats_with_price => 'S cenou';

  @override
  String get prices_stats_food => 'Jídlo';

  @override
  String get prices_stats_beauty => 'Krása';

  @override
  String get prices_stats_products => 'Produkty';

  @override
  String get prices_stats_pet_food => 'Zvířecí krmivo';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Země';

  @override
  String get prices_stats_price_tag => 'Cenovka';

  @override
  String get prices_stats_receipt => 'Účtenka';

  @override
  String get prices_stats_gdpr_request => 'GDPR požadavek';

  @override
  String get prices_stats_shop_import => 'Import obchodu';

  @override
  String get prices_stats_challenges => 'Výzvy';

  @override
  String get prices_stats_linked_to_price_tag =>
      'Ceny spojené s cenovým štítkem';

  @override
  String get prices_stats_currencies => 'Měny';

  @override
  String get prices_stats_years => 'Let';

  @override
  String get prices_stats_by_source_title => 'Ceny a doklady podle zdroje';

  @override
  String get prices_stats_website => 'Webová stránka';

  @override
  String get prices_stats_mobile_app => 'Mobilní aplikace';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Ostatní';

  @override
  String get prices_stats_last_updated => 'Naposled aktualizováno';

  @override
  String get prices_stats_error =>
      'An error occurred while loading statistics.';

  @override
  String get product_edit_robotoff_question_answered => 'Question answered!';

  @override
  String get product_edit_robotoff_proof => 'Doklad';

  @override
  String get preferences_card_general => 'Hlavní nastavení';

  @override
  String get preferences_prices_title => 'Ceny';

  @override
  String get preferences_prices_subtitle => 'Spravujte své cenové preference';

  @override
  String get preferences_card_project => 'Projekt Otevřená fakta o jídle';

  @override
  String get preferences_contribute_title => 'Přispět';

  @override
  String get preferences_my_contributions_title => 'Moje příspěvky';

  @override
  String get preferences_my_stats_title => 'Moje statistiky';

  @override
  String get preferences_contribute_subtitle =>
      'Překládejte, vylepšujte naše nástroje…';

  @override
  String get preferences_connect_title => 'Připojit';

  @override
  String get preferences_connect_subtitle =>
      'Kontaktujte nás nebo nás sledujte na sociálních sítích';

  @override
  String get preferences_support_title => 'Přispějte';

  @override
  String get preferences_support_subtitle =>
      'Pomozte nám informovat miliony spotřebitelů po celém světě';

  @override
  String get preferences_card_help => 'Nápověda a podpora';

  @override
  String get preferences_faq_title => 'Často kladené otázky';

  @override
  String get preferences_faq_subtitle => 'Získejte odpovědi na své otázky';

  @override
  String get logged_out => 'Odhlášen/a';

  @override
  String get preferences_app_bar_message =>
      'Děkujeme, že jste jedním z našich členů!';

  @override
  String get preferences_app_bar_products_modified => 'Produkty upraveny';

  @override
  String get preferences_app_bar_prices_added => 'Ceny přidány';

  @override
  String get preferences_app_bar_see_all_stats => 'Zobrazit všechny statistiky';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Hledat v $provider výraz „$keyword“';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Vyhledejte nastavení (např. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Přístupnost: Zobrazit emotikony';

  @override
  String get preferences_accessibility_remove_colors =>
      'Přístupnost: Odebrat barvy';

  @override
  String get preferences_app_settings_products => 'Produkty';

  @override
  String get preferences_card_about => 'O aplikaci';

  @override
  String get preferences_legal_information_title => 'Právní informace';

  @override
  String get preferences_legal_information_subtitle =>
      'Podmínky použití, zásady ochrany osobních údajů a další';

  @override
  String get preferences_terms_of_use => 'Podmínky použití';

  @override
  String get preferences_legal_mentions => 'Právní zmínky';

  @override
  String get preferences_legal_header =>
      'Open Food Facts je databáze potravinářských výrobků **vytvořená každým, pro každého**.\nMůžete ji použít k lepšímu výběru potravin a protože se jedná o **otevřená data**, kdokoli je může **znovu použít k jakémukoli účelu**.';

  @override
  String get preferences_privacy_policy => 'Zásady ochrany osobních údajů';

  @override
  String get preferences_licenses => 'Licence';

  @override
  String get preferences_about_app_title => 'O aplikaci';

  @override
  String get preferences_about_app_subtitle =>
      'Technické informace, informace pro vývojáře a další';

  @override
  String get preferences_card_information => 'Informace';

  @override
  String get preferences_version_number_title => 'Číslo verze';

  @override
  String get preferences_scanner_title => 'Skener';

  @override
  String get preferences_app_store => 'Obchod s aplikacemi';

  @override
  String get preferences_app_system_settings => 'Nastavení systému';

  @override
  String get preferences_source_code => 'Přístup ke zdrojovému kódu';

  @override
  String get preferences_source_code_subtitle =>
      'A začněte ovlivňovat miliony lidí';

  @override
  String get preferences_add_prices => 'Přidat ceny';

  @override
  String get preferences_complete_products => 'Dokončete produkty';

  @override
  String get preferences_tips => 'Tipy';

  @override
  String get tips_discover_nutriscore => 'Objevte nový Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Na webových stránkách Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Spravovat můj účet';

  @override
  String get preferences_manage_account_tooltip => 'Spravujte svůj účet';

  @override
  String get preferences_change_password_title => 'Změnit heslo';

  @override
  String get preferences_danger_zone => 'Nebezpečná zóna';

  @override
  String get preferences_account_deletion_subtitle =>
      'Všechny vaše příspěvky budou ztraceny';

  @override
  String get preferences_contributions_title => 'Příspěvky';

  @override
  String get preferences_dev_mode_app_settings_title => 'Nastavení aplikace';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Velmi experimentální způsob skenování produktů offline';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Obnovit všechny produkty ze serveru';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Prosím, vyhněte se tomu, pokud to není nezbytně nutné';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Demo režim';

  @override
  String get preferences_dev_mode_add_cards_title => 'Přidání karet do skeneru';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Přidá do skeneru 3 vzorky produktů';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Hostitel folksonomie';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Hostitel: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experimenty s přístupností';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Výběr více produktů za dané ceny';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Uživatelem seřazené znalostní panely';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Dočasný přístup k vyhledávání polohy';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Porovnání 2 nebo 3 produktů vedle sebe';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Import seznamu produktů';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Skóre a metodologie';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Zjistěte, jak se vypočítává Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Objevte hlavní změny v metodice';

  @override
  String get preferences_faq_discover_project_title =>
      'Zjistěte více o projektu';

  @override
  String get preferences_faq_discover_off_title =>
      'Objevte fakta o jídle na Open Food';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title =>
      'Často kladené otázky - Často kladené otázky';

  @override
  String get preferences_faq_off_ngo_title =>
      'Nevládní organizace Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informace';

  @override
  String get preferences_connect_community_updates_title =>
      'Získejte aktualizace komunity';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Zůstaňte v obraze díky aplikacím a novinkám z komunity';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscribe to our community calendar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Zapojte se účastí na jedné z našich virtuálních akcí';

  @override
  String get preferences_connect_blog_title => 'Blog Otevřená fakta o jídle';

  @override
  String get preferences_connect_blog_subtitle =>
      'Získejte nejnovější zprávy, jakmile se stanou';

  @override
  String get preferences_connect_community_help_title =>
      'Získejte pomoc od komunity';

  @override
  String get preferences_connect_improve_app_title =>
      'Pomozte nám vylepšit aplikaci';

  @override
  String get preferences_connect_debug_info_title =>
      'Zašlete nám informace o ladění';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Pošlete nám e-mail s podrobnými informacemi o ladění';

  @override
  String get preferences_connect_feedback_title =>
      'Pošlete nám zpětnou vazbu k aplikaci';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Pomozte utvářet budoucnost aplikace';

  @override
  String get preferences_connect_survey_title =>
      'Zúčastněte se průzkumu aplikace';

  @override
  String get preferences_connect_survey_subtitle =>
      'Pomozte nám pochopit, co bychom měli dále budovat';

  @override
  String get preferences_connect_professionals_title => 'Profesionálové';

  @override
  String get preferences_connect_pro_subtitle =>
      'Zcela zdarma, zajišťuje přesná data pro 500 aplikací a miliony spotřebitelů. Samoobsluha, kompatibilní s vaším PIM nebo tabulkami (XLSX).';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Kontaktujte nás a začněte';

  @override
  String get preferences_connect_press_title => 'Média';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Získejte veškerý materiál, který potřebujete pro svou zprávu';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Kontaktujte nás s dotazy pro tisk nebo s informacemi o vaší zprávě.';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Staňte se aktivním dobrovolníkem';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Vývoj, komunikace, design… jakýkoli druh dobrovolnictví nebo odbornosti je vítán!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Objevte některé z mnoha způsobů, jak můžete přispět';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Vývoj mobilních aplikací';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Naučte se, jak se podílet na vývoji softwaru';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Denně nestabilní sestavení, zbrusu nové funkce';

  @override
  String get preferences_contribute_local_community_title =>
      'Rozšiřte svou místní komunitu';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Pomoc se softwarem, obsahem, překlady analýz složek';

  @override
  String get preferences_contribute_share_subtitle =>
      'Připravili jsme pro vás malou šablonu, která vám s tím pomůže :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Jednoduché kroky k větší transparentnosti potravin ve vaší zemi';

  @override
  String get preferences_contribute_data_quality_title => 'Kvalita dat';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Přidejte se k týmu pro kvalitu dat';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Přidejte se k našemu úsilí o zajištění úplnosti a přesnosti databáze';

  @override
  String get preferences_contributions_products_added_title =>
      'Přidané produkty';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nové produkty, které jsem přidal/a do Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Produkty, které potřebuji dokončit';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Všechny neúplné produkty';

  @override
  String get preferences_my_contributions_prices_title => 'Ceny';

  @override
  String get preferences_my_contributions_my_prices_title => 'Moje ceny';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Moje ceny, moje důkazy…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Produkty, které můžete pomoci dokončit';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Pomozte s výpočtem Nutri-Score a Green-Score ve vaší zemi';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Ceny, které jsem přispěl/a';

  @override
  String get preferences_prices_proofs_subtitle => 'Cenovky a účtenky';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Vyfoťte si účtenky a naskenujte příslušné čárové kódy';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Vyfoťte si ceny v obchodě';

  @override
  String get preferences_prices_newest_title => 'Nejnovější ceny';

  @override
  String get preferences_prices_newest_subtitle =>
      'Nejnovější ceny přidané komunitou Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Přispěvatelé s nejvyššími cenami';

  @override
  String get preferences_prices_metrics_title => 'Metriky otevírací ceny';

  @override
  String get preferences_prices_metrics_subtitle => 'Sledujte vývoj projektu';

  @override
  String get preferences_prices_ways_contribute_title => 'Způsoby, jak přispět';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Potvrďte ceny, které jste přidali vy nebo jiní, s pomocí umělé inteligence';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Rychle přidejte mnoho účtenek nebo fotografií polic z alba fotoaparátu';

  @override
  String get preferences_prices_challenges_title => 'Měsíční výzvy';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Zúčastněte se měsíčních tematických úkolů a sbírejte ceny';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Získejte zpět svá věrnostní data';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Zjistěte, jak si vyžádat svá data';

  @override
  String get preferences_page_customize_app_title => 'Přizpůsobte si aplikaci';

  @override
  String get preferences_page_contribute_project_title =>
      'Přispějte k projektu';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Jednoduché způsoby, jak pomoci Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodiky hodnocení, pomoc a další informace o projektu';

  @override
  String get product_edit_robotoff_positive_button => 'Přijmout návrh';

  @override
  String get product_edit_robotoff_negative_button => 'Odmítnout návrh';

  @override
  String get product_edit_robotoff_show_proof => 'Ukažte důkaz';

  @override
  String get product_edit_robotoff_expand_proof => 'Rozbalit důkaz';

  @override
  String get product_page_tab_raw_data => 'Nezpracovaná data';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Strana $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Strana $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count z $total položek';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count z $total položek';
  }

  @override
  String item_count(int count) {
    return '$count položek';
  }

  @override
  String item_count_string(String count) {
    return '$count položek';
  }

  @override
  String get prices_no_result => 'Nebyly nalezeny žádné cenové statistiky.';

  @override
  String get prices_error_loading_more_items =>
      'Chyba při načítání dalších položek';

  @override
  String get prices_proof_error => 'Ověření selhalo, nelze načíst důkazy';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count z $total důkazů';
  }

  @override
  String proof_count(int count) {
    return '$count dokladů';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count z $total přispěvatelů';
  }

  @override
  String contributors_count(int count) {
    return '$count přispěvatelů';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count z $total lokalit';
  }

  @override
  String prices_locations_count(int count) {
    return '$count lokalit';
  }

  @override
  String get restart_to_apply_message =>
      'Pro použití změn restartujte aplikaci.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Grafické rozhraní';

  @override
  String get preferences_app_settings_media_title => 'Média';

  @override
  String get preferences_about_app_development_title => 'Vývoj';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Otevřené laboratoře faktů o potravinách';

  @override
  String get preferences_root_account_title => 'Účet';

  @override
  String get preferences_contribute_translate_header =>
      'Přineste fakta o otevřeném jídle do svého jazyka';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Zaregistrujte se do alfa verze aplikace';

  @override
  String get preferences_dev_mode_section_data => 'Příspěvky a produktová data';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Nezobrazovat folksonomii';

  @override
  String get preferences_account_title => 'Účet';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Přidáno dne $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Jméno';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Země';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
