// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class AppLocalizationsCa extends AppLocalizations {
  AppLocalizationsCa([String locale = 'ca']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Si';

  @override
  String get add => 'Afegeix';

  @override
  String get account_delete_message =>
      'Segur que voleu suprimir el vostre compte?\nSi hi ha una raó específica, compartiu-la a continuació';

  @override
  String get reason => 'Raó';

  @override
  String get okay => 'D\'acord';

  @override
  String get validate => 'Validar';

  @override
  String get create => 'Crea';

  @override
  String get applyButtonText => 'Aplicar';

  @override
  String get next_label => 'Següent';

  @override
  String get continue_label => 'Continuar';

  @override
  String get exit_label => 'Sortir';

  @override
  String get previous_label => 'Anterior';

  @override
  String get go_back_to_top => 'Torna a dalt';

  @override
  String get save => 'Desa';

  @override
  String get save_confirmation => 'De debò que ho voleu desar?';

  @override
  String get skip => 'Omet';

  @override
  String get cancel => 'Cancel·lar';

  @override
  String get ignore => 'Ignorar';

  @override
  String get close => 'Tanca';

  @override
  String get no => 'No';

  @override
  String get stop => 'Atura\'t';

  @override
  String get finish => 'Finalitzat';

  @override
  String get calculate => 'Calcular';

  @override
  String get reset_food_prefs => 'Restableix les preferències d\'aliments';

  @override
  String get error => 'Alguna cosa ha anat malament';

  @override
  String get error_occurred => 'S\'ha produït un error';

  @override
  String get featureInProgress =>
      'Seguim treballant en aquesta funció, estigueu atents';

  @override
  String get label_web => 'Veure a la web';

  @override
  String get learnMore => 'Saber-ne més';

  @override
  String get unknown => 'Desconegut';

  @override
  String get match_very_good => 'Molt bona coincidència';

  @override
  String get match_good => 'Bona coincidència';

  @override
  String get match_poor => 'Poca coincidència';

  @override
  String get match_may_not => 'Podria no coincidir';

  @override
  String get match_does_not => 'No coincideix';

  @override
  String get match_unknown => 'Coincidència desconeguda';

  @override
  String get match_short_very_good => 'Molt bona coincidència';

  @override
  String get match_short_good => 'Bona coincidència';

  @override
  String get match_short_poor => 'Poca coincidència';

  @override
  String get match_short_may_not => 'Podria no coincidir';

  @override
  String get match_short_does_not => 'No coincideix';

  @override
  String get match_short_unknown => 'Coincidència desconeguda';

  @override
  String get licenses => 'Llicències';

  @override
  String get looking_for => 'Tot cercant';

  @override
  String get welcomeToOpenFoodFacts => 'Benvingut a Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts is a global non-profit powered by local communities.';

  @override
  String get productDataUtility =>
      'Consulteu les dades dels aliments rellevants per a les vostres preferències.';

  @override
  String get healthCardUtility => 'Trieu aliments que us siguin bons.';

  @override
  String get ecoCardUtility => 'Trieu aliments que siguin bons per al planeta.';

  @override
  String get server_error_open_new_issue =>
      'No hi ha resposta del servidor! Podeu obrir una incidència amb el següent enllaç.';

  @override
  String get sign_in_text =>
      'Inicieu la sessió al vostre compte d\'Open Food Facts per desar les vostres contribucions';

  @override
  String get incorrect_credentials => 'Usuari o contrasenya incorrectes.';

  @override
  String get password_lost_incorrect_credentials =>
      'This email or username doesn\'t exist. Please check your credentials.';

  @override
  String get password_lost_server_unavailable =>
      'We are currently experiencing slowdowns on our servers and we apologise for it. Please try again later.';

  @override
  String get login => 'Nom d\'usuari';

  @override
  String get login_result_type_server_unreachable => 'Network is unreachable';

  @override
  String get login_result_type_server_issue =>
      'Problem on the server. Please try later.';

  @override
  String get login_page_username_or_email =>
      'Introduïu l\'usuari o l\'adreça electrònica';

  @override
  String get login_page_password_error_empty =>
      'Si us plau, introduïu una contrasenya';

  @override
  String get create_account => 'Crear un compte';

  @override
  String get sign_in => 'Inicia la sessió';

  @override
  String get sign_in_mandatory =>
      'Per a aquesta funció, necessitem que inicieu la sessió.';

  @override
  String get help_improve_country =>
      'Help improve Open Food Facts in your country';

  @override
  String get sign_out => 'Tanca la sessió';

  @override
  String get sign_out_confirmation => 'Segur que voleu tancar la sessió?';

  @override
  String get password => 'Contrasenya';

  @override
  String get forgot_password => 'Contrasenya oblidada';

  @override
  String get forgot_password_question => 'Has oblidat la contrasenya?';

  @override
  String get view_profile => 'Mostra el perfil';

  @override
  String get reset_password => 'Reinicialitza contrasenya';

  @override
  String get reset_password_explanation_text =>
      'En cas d\'oblidar la contrasenya, introduïu el vostre usuari o adreça electrònica per rebre les instruccions per restablir la contrasenya. A més, recordeu comprovar la carpeta de correu brossa.';

  @override
  String get username_or_email => 'Usuari o adreça electrònica';

  @override
  String get reset_password_done =>
      'S\'ha enviat un missatge de correu electrònic amb un enllaç per restablir la contrasenya a l\'adreça associada al vostre compte. Comproveu també dins el correu brossa';

  @override
  String get send_reset_password_mail => 'Canvia la contrasenya';

  @override
  String get enter_some_text => 'Si us plau, introduïu algun text';

  @override
  String get sign_up_page_title => 'Registreu-vos';

  @override
  String get sign_up_page_action_button => 'Registreu-vos';

  @override
  String get sign_up_page_action_doing_it => 'Registrant-se…';

  @override
  String get sign_up_page_action_ok =>
      'Felicitats! S\'acaba de crear el vostre compte.';

  @override
  String get sign_up_page_display_name_hint => 'Nom';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Introduïu el nom que voleu que es mostri';

  @override
  String get sign_up_page_email_hint => 'Adreça electrònica';

  @override
  String get sign_up_page_email_error_empty => 'Cal una adreça electrònica';

  @override
  String get sign_up_page_email_error_invalid => 'Adreça no vàlida';

  @override
  String get sign_up_page_username_hint => 'Usuari: visible públicament';

  @override
  String get sign_up_page_username_error_empty =>
      'Si us plau, introduïu un usuari';

  @override
  String get sign_up_page_username_error_invalid =>
      'Si us plau, introduïu un usuari vàlid';

  @override
  String get sign_up_page_username_description =>
      'El nom d\'usuari no pot contenir espais, majúscules ni caràcters especials.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'L\'usuari no pot excedir els $value caràcters';
  }

  @override
  String get sign_up_page_password_hint => 'Contrasenya';

  @override
  String get sign_up_page_password_error_empty =>
      'Si us plau, introduïu una contrasenya';

  @override
  String get sign_up_page_password_error_invalid =>
      'Si us plau, introduïu una contrasenya vàlida (com a mínim 6 caràcters)';

  @override
  String get sign_up_page_confirm_password_hint => 'Confirmeu la contrasenya';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Si us plau, confirmeu la contrasenya';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Les contrasenyes no coincideixen';

  @override
  String get sign_up_page_agree_text => 'I agree to the Open Food Facts';

  @override
  String get sign_up_page_terms_text => 'termes d\'ús i contribució';

  @override
  String get donate_url =>
      'https://es-ca.openfoodfacts.org/donate-to-open-food-facts';

  @override
  String get sign_up_page_agree_error_invalid =>
      'En crear un compte, acceptar les condicions d\'ús és obligatori, però encara es poden fer contribucions anònimes a través de l\'aplicació';

  @override
  String get sign_up_page_producer_checkbox => 'Sóc productor d\'aliments';

  @override
  String get sign_up_page_producer_hint => 'Productor/marca';

  @override
  String get sign_up_page_producer_error_empty =>
      'Introduïu un nom de productor o marca';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'I\'d like to subscribe to the Open Food Facts newsletter (You can unsubscribe from it at any time)';

  @override
  String get sign_up_page_user_name_already_used =>
      'El nom d\'usuari ja existeix, trieu-ne un altre.';

  @override
  String get sign_up_page_email_already_exists =>
      'ja existeix, inicieu sessió amb el compte o proveu amb un altre correu electrònic.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Introduïu una adreça electrònica vàlida.';

  @override
  String get sign_up_page_server_busy =>
      'We are deeply sorry, we have some technical difficulties to create your account. Please try again later.';

  @override
  String get settingsTitle => 'Preferències';

  @override
  String get darkmode => 'Tema';

  @override
  String get darkmode_dark => 'Fosc';

  @override
  String get darkmode_light => 'Clar';

  @override
  String get darkmode_system_default => 'Per defecte del sistema';

  @override
  String get thanks_for_contributing => 'Thanks for contributing!';

  @override
  String get contributors_label => 'Estan construint l\'aplicació';

  @override
  String get contributors_dialog_title => 'Contribuents';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Col·laborador/a: $name';
  }

  @override
  String get contributors_description =>
      'Una llista de tothom qui col·labora amb aquesta app';

  @override
  String get support => 'Suport';

  @override
  String get support_join_slack => 'Demana ajuda al nostre canal de Slack';

  @override
  String get support_via_forum => 'Demana ajuda al nostre fòrum';

  @override
  String get support_via_email => 'Envieu-nos un correu electrònic';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Vols enviar els registres de l\'aplicació?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Voleu incloure els registres de l\'aplicació al fitxer adjunt al vostre correu electrònic?';

  @override
  String get termsOfUse => 'Condicions d\'ús';

  @override
  String get legalNotices => 'Legal notices';

  @override
  String get privacy_policy => 'Privacy policy';

  @override
  String get about_this_app => 'Quant a aquesta aplicació';

  @override
  String get contribute => 'Contribuir';

  @override
  String get contribute_sw_development => 'Desenvolupament de programari';

  @override
  String get contribute_develop_text =>
      'The code for every Open Food Facts product is available on GitHub. You are welcome to reuse the code (it\'s open source) and help us improve it, for everyone, on all the planet.';

  @override
  String get contribute_develop_text_2 =>
      'You can join the Open Food Facts Slack chatroom which is the preferred way to ask questions.';

  @override
  String get contribute_develop_dev_mode_title => 'Mode Desenvolupador?';

  @override
  String get contribute_develop_dev_mode_subtitle => 'Activeu el mode DEV';

  @override
  String get contribute_donate_title => 'Feu un donatiu';

  @override
  String get contribute_donate_header => 'Donate to Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Please acknowledge that with the internal alpha version, complete loss of data is possible, and the app may become unusable at any time !';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Productes que s\'han de completar';

  @override
  String get contribute_improve_header => 'Millorant';

  @override
  String get contribute_improve_text =>
      'The database is the core of the project. It\'s easy and very quick to help. You can download the mobile app for your phone, and start adding or improving products.\n\nOn the other hand, Open Food Facts website offers many ways to contribute: ';

  @override
  String get contribute_translate_header => 'Tradueix';

  @override
  String get contribute_data_quality => 'Qualitat de les dades';

  @override
  String get contribute_translate_link_text => 'Comenceu a traduir';

  @override
  String get contribute_translate_text =>
      'Open Food Facts is a global project, containing products from more than 160 countries. Open Food Facts is translated into dozens of languages, with constantly evolving content.';

  @override
  String get contribute_translate_text_2 =>
      'Les traduccions són una de les tasques clau del projecte';

  @override
  String get contribute_join_skill_pool =>
      'Contribute your skills to Open Food Facts. Join the skill pool!';

  @override
  String get contribute_share_header =>
      'Share Open Food Facts with your friends';

  @override
  String get contribute_share_content =>
      'I wanted to let you know about the app I\'ve been using, Open Food Facts, which allows you to get the health and environmental impacts of your food, in a personalized way. It works by scanning the barcodes on the packaging. Finally it\'s free, does not require registration, and you can even help increase the number of products decyphered. Here\'s the link to get it for your phone: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Contribute prices by requesting a GDPR export of your loyalty cards data';

  @override
  String get tap_to_answer => 'Fes clic per respondre preguntes';

  @override
  String get tap_to_answer_hint =>
      'Fes clic aquí per respondre preguntes sobre aquest producte';

  @override
  String get robotoff_questions_loading_hint =>
      'Si us plau, espereu mentre es carreguen les preguntes sobre aquest producte';

  @override
  String get saving_answer => 'Desant la vostra resposta';

  @override
  String get contribute_to_get_rewards =>
      'Convertiu-vos en actor de la transparència alimentària';

  @override
  String get question_sign_in_text =>
      'Sign in to your Open Food Facts account to get credit for your contributions';

  @override
  String get question_yes_button_accessibility_value => 'Respondre amb sí';

  @override
  String get question_no_button_accessibility_value => 'Respondre amb no';

  @override
  String get question_skip_button_accessibility_value =>
      'Omet aquesta pregunta';

  @override
  String get tap_to_edit_search => 'Feu clic per editar la cerca';

  @override
  String get myPreferences => 'Les meves preferències';

  @override
  String get account_create_message =>
      'Create your account and join the Open Food Facts community to help build food knowledge all over the world!';

  @override
  String get join_us => 'Uneix-te\'ns';

  @override
  String get myPreferences_profile_title => 'El vostre perfil';

  @override
  String get myPreferences_profile_subtitle =>
      'Manage your Open Food Facts contributor account.';

  @override
  String get myPreferences_settings_title => 'Configuració de l\'App';

  @override
  String get myPreferences_settings_subtitle => 'Dark mode, Languages…';

  @override
  String get myPreferences_food_title => 'Preferències alimentàries';

  @override
  String get myPreferences_food_subtitle =>
      'Triau quina informació dels aliments us importa més.';

  @override
  String get myPreferences_food_comment =>
      'Choose what information about food matters most to you, in order to rank food according to your preferences, see the information you care about first, and get a compatibility summary. Those food preferences stay on your device, and are not associated with your Open Food Facts contributor account if you have one.';

  @override
  String get confirmResetPreferences =>
      'Voleu restablir les vostres preferències alimentàries?';

  @override
  String get myPersonalizedRanking => 'El meu rànquing personalitzat';

  @override
  String get ranking_tab_all => 'Tots';

  @override
  String get ranking_subtitle_match_yes => 'Una bona coincidència per a vós';

  @override
  String get ranking_subtitle_match_no => 'Coincidència molt pobra';

  @override
  String get ranking_subtitle_match_maybe => 'Coincidència desconeguda';

  @override
  String get refresh_with_new_preferences =>
      'Actualitzeu la llista amb les vostres noves preferències';

  @override
  String get reloaded_with_new_preferences =>
      'Recarregat amb les teves noves preferències';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Escàner';

  @override
  String get history_navbar_label => 'Historial';

  @override
  String get list_navbar_label => 'Llistes';

  @override
  String get category => 'Filtra per categoria';

  @override
  String get category_all => 'Tots';

  @override
  String get category_search => '(cerca per categoria)';

  @override
  String get filter => 'Filtre';

  @override
  String get scan => 'Products from the Scan screen';

  @override
  String get scan_history => 'Historial d\'escaneig';

  @override
  String get search => 'Cerca';

  @override
  String get search_product_help =>
      'Cerca un producte,\nuna marca o un codi de barres';

  @override
  String get search_filter => 'Filtre de cerca';

  @override
  String get search_history => 'Historial de cerca';

  @override
  String get search_store => 'Search for a store';

  @override
  String get search_store_help => 'Consell: afegiu la ciutat o el país';

  @override
  String get tap_for_more => 'Tap to see more info…';

  @override
  String get product => 'Producte';

  @override
  String get unknownBrand => 'Marca desconeguda';

  @override
  String get unknownProductName => 'Nom de producte desconegut';

  @override
  String get label_refresh => 'Refresca';

  @override
  String get label_reload => 'Reload';

  @override
  String get image => 'Imatge';

  @override
  String get front_photo => 'Foto frontal';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (this image may be outdated)';
  }

  @override
  String get outdated_image_short_label => 'may be outdated';

  @override
  String get ingredients => 'Ingredients';

  @override
  String get ingredients_editing_instructions =>
      'Keep the original order. Indicate the percentage when specified. Separate with a comma or hyphen and use parentheses for ingredients of an ingredient.';

  @override
  String get ingredients_editing_error =>
      'No s\'han pogut desar els ingredients.';

  @override
  String get ingredients_editing_image_error =>
      'No s\'ha pogut obtenir una nova imatge dels ingredients.';

  @override
  String get ingredients_editing_title => 'Edita els ingredients';

  @override
  String get ingredients_photo => 'Foto dels ingredients';

  @override
  String get packaging_editing_instructions =>
      'Introduïu totes les peces d\'embalatge separades per una coma o una línia, amb la seva quantitat (p. ex. 1 o 6) tipus (p. ex. ampolla, caixa, llauna), material (p. ex. plàstic, metall, alumini) i, si està disponible, la seva mida (p. ex. 33cl) i instruccions de reciclatge.\nExemple: 1 ampolla de vidre per reciclar, 1 suro de plàstic per llençar';

  @override
  String get packaging_editing_error => 'No s\'ha pogut desar l\'embalatge.';

  @override
  String get packaging_editing_image_error =>
      'No s\'ha pogut obtenir una nova imatge del paquet.';

  @override
  String get packaging_editing_title => 'Edita l\'embalatge';

  @override
  String get nutrition => 'Nutrició';

  @override
  String get nutrition_facts_photo => 'Fotos dels valors nutricionals';

  @override
  String get nutrition_facts_editing_title => 'Edit Nutrition Facts';

  @override
  String get packaging_information => 'Informació de l\'embolcall';

  @override
  String get packaging_information_photo =>
      'Foto de la informació de l\'embolcall';

  @override
  String get missing_product => 'Heu trobat un nou producte!';

  @override
  String get add_product_take_photos =>
      'Feu fotos de l\'embalatge per afegir aquest producte a Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Si us plau, feu algunes fotos primer. Sempre podeu completar el producte més endavant.';

  @override
  String get add_product_information_button_label =>
      'Afegiu informació del producte';

  @override
  String get new_product => 'Nou producte';

  @override
  String get new_product_found_title => 'New product found!';

  @override
  String get new_product_found_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get new_product_found_button => 'Afegir aquest producte';

  @override
  String get new_product_leave_title => 'Leave this page?';

  @override
  String get new_product_leave_message =>
      'Sembla que no has introduït res. De veritat vols sortir d\'aquesta pàgina?';

  @override
  String get new_product_dialog_description =>
      'Please take photos of the packaging to add this product to our common database';

  @override
  String get new_product_dialog_illustration_description =>
      'An illustration with unknown Nutri-Score and Green Score';

  @override
  String get front_packaging_photo_button_label => 'Foto frontal del producte';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Confirma la càrrega de la foto frontal del producte';

  @override
  String get confirm_button_label => 'Confirma';

  @override
  String get send_image_button_label => 'Enviar imatge';

  @override
  String get crop_page_action_saving => 'S\'està desant la imatge…';

  @override
  String get crop_page_action_cropping => 'Retallant la imatge…';

  @override
  String get crop_page_action_local => 'S\'està desant una versió local…';

  @override
  String get crop_page_action_local_failed_title =>
      'Oops… there\'s something with your photo!';

  @override
  String get crop_page_action_local_failed_message =>
      'We are unable to process the image locally, before sending it to our server. Please try again later or contact-us if the issue persists.';

  @override
  String get crop_page_action_retake => 'Retake a photo';

  @override
  String get crop_page_too_small_image_title => 'La imatge és massa petita!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'La mida mínima en píxels per pujar imatges és ${expectedMinWidth}x$expectedMinHeight. La imatge actual és de ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Preparant una trucada al servidor…';

  @override
  String get front_packaging_photo_title => 'Foto frontal de l\'embalatge';

  @override
  String get ingredients_photo_title => 'Foto dels ingredients';

  @override
  String get nutritional_facts_photo_title => 'Foto dels valors nutricionals';

  @override
  String get recycling_photo_title => 'Foto del reciclatge';

  @override
  String get take_photo_title => 'Fer una foto';

  @override
  String get take_more_photo_title => 'Feu més fotos';

  @override
  String get front_photo_uploaded => 'S\'ha penjat la foto frontal';

  @override
  String get ingredients_photo_button_label => 'Foto dels ingredients';

  @override
  String get ingredients_photo_uploaded =>
      'S\'ha penjat la foto dels ingredients';

  @override
  String get nutrition_cache_loading_error =>
      'No es poden carregar els nutrients de la memòria cau';

  @override
  String get nutritional_facts_photo_button_label =>
      'Fotos dels valors nutricionals';

  @override
  String get nutritional_facts_input_button_label =>
      'Introduïu valors nutricionals';

  @override
  String get nutritional_facts_added => 'Afegits els valors nutricionals';

  @override
  String get categories_added => 'Categories afegides';

  @override
  String get new_product_title_nutriscore => 'Calculeu el Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Aconsegueix-ho omplint la categoria de l\'aliment i els valors nutricionals';

  @override
  String get new_product_title_environmental_score => 'Compute the Green Score';

  @override
  String get new_product_subtitle_environmental_score =>
      'Get it by filling at least a category';

  @override
  String get new_product_additional_environmental_score =>
      'Make Green Score computation more precise with origins, packaging & more';

  @override
  String get new_product_title_nova =>
      'Calcula el nivell de processament d\'aliments (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Aconsegueix-ho omplint la categoria de l\'aliment i els ingredients';

  @override
  String get new_product_desc_nova_unknown =>
      'Nivell de processament d\'aliments desconegut';

  @override
  String get new_product_title_pictures => 'Fem unes fotos!';

  @override
  String get new_product_title_pictures_details =>
      'Please take the following photos and the Open Food Facts engine can work out the rest!';

  @override
  String get new_product_title_misc => 'I algunes dades bàsiques…';

  @override
  String new_product_done_msg(String username) {
    return 'Thanks for your contribution “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Thanks for your contribution!';

  @override
  String get new_product_done_button_label => 'Discover the completed product';

  @override
  String get hey_incomplete_product_message =>
      'Tap to answer 3 questions NOW to compute Nutri-Score, Green Score & Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Tap now to answer 2 questions to help analyze this cosmetic!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Tap now to answer 3 questions to help analyze this pet food product!';

  @override
  String get hey_incomplete_product_message_product =>
      'Tap now to help complete this product!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'S\'ha penjat una foto de dades nutricionals';

  @override
  String get recycling_photo_button_label =>
      'Foto informativa sobre el reciclatge';

  @override
  String get recycling_photo_uploaded => 'S\'ha penjat una foto de reciclatge';

  @override
  String get take_more_photo_button_label => 'Feu més fotos';

  @override
  String get other_photo_uploaded => 'S\'ha penjat una altra foto';

  @override
  String get retake_photo_button_label => 'Torna a fer';

  @override
  String get selecting_photo => 'Selecció de la foto';

  @override
  String get uploading_image => 'S\'està carregant la foto al servidor';

  @override
  String get uploading_image_type_front =>
      'Uploading front image to Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Uploading ingredients image to Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Uploading nutrition image to Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Uploading packaging image to Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Uploading other image to Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Uploading image to Open Food Facts';

  @override
  String get score_add_missing_ingredients =>
      'Afegiu els ingredients que falten';

  @override
  String get score_add_missing_packaging_image =>
      'Afegeix la imatge que falta de l\'envàs';

  @override
  String get score_add_missing_nutrition_facts =>
      'Afegiu les dades nutricionals que falten';

  @override
  String get score_add_missing_product_traces => 'Add missing product traces';

  @override
  String get score_add_missing_product_category =>
      'Afegiu la categoria de producte que falta';

  @override
  String get score_add_missing_precise_product_category =>
      'Seleccioneu una categoria més precisa';

  @override
  String get score_add_missing_product_countries =>
      'Afegiu els països del producte que falten';

  @override
  String get score_add_missing_product_emb =>
      'Afegiu els codis de traçabilitat dels productes que falten';

  @override
  String get score_add_missing_product_labels =>
      'Afegiu les etiquetes dels productes que falten';

  @override
  String get score_add_missing_product_origins =>
      'Afegiu els orígens dels productes que falten';

  @override
  String get score_add_missing_product_stores =>
      'Afegeix les botigues de productes que falten';

  @override
  String get score_add_missing_product_brands => 'Add missing product brands';

  @override
  String get score_update_nutrition_facts =>
      'Actualitzar les dades nutricionals';

  @override
  String get nutrition_page_title => 'Informació nutricional';

  @override
  String get nutrition_page_nutritional_info_title => 'Nutritional information';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Values specified on the product:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Si';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'No';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Open photo';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Good practices: Nutritional information';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Sometimes nutrition facts are **not specified on the packaging** or on a document given with the product. In this case, and only in this case, you can set the value to **NO**.';

  @override
  String get nutrition_page_serving_type_label => 'Nutritional values:';

  @override
  String get nutrition_page_per_100g => 'per 100 g';

  @override
  String get nutrition_page_per_100g_100ml => 'per 100g/ml';

  @override
  String get nutrition_page_per_serving => 'per porció';

  @override
  String get nutrition_page_add_nutrient => 'Afegir un nutrient';

  @override
  String get nutrition_page_serving_size => 'Mida de la porció';

  @override
  String get nutrition_page_serving_size_hint =>
      'Input a serving size (eg: 100g)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Good practices: Serving size';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'This value helps to **make a proportional calculation of each nutrient per serving size**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Allowed units** are: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, г, мг, кг, л, дл, кл, мл, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 g**, **60g** or **60 G** (prefer the first one)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 ml** or **1L**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Invalid unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 **gr**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Invalid units';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **candies** and 2 **biscuits**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Missing unit';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Número no vàlid';

  @override
  String get nutrition_page_update_running =>
      'Actualització del producte al servidor…';

  @override
  String get nutrition_page_update_done => 'Producte actualitzat!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Use the product quantity as serving size';

  @override
  String get nutrition_page_photo_error => 'Unable to load the photo';

  @override
  String get more_photos => 'Més fotos interessants';

  @override
  String get view_more_photo_button =>
      'View all existing photos for this product';

  @override
  String get no_product_found => 'Cap producte trobat';

  @override
  String get no_location_found => 'No location found';

  @override
  String get not_found => 'no trobat:';

  @override
  String get refreshing_product => 'Producte refrescant';

  @override
  String get product_refreshed => 'Producte actualitzat';

  @override
  String product_image_accessibility_label(String date) {
    return 'Image taken on $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Image taken on $date. This image may be outdated';
  }

  @override
  String get product_image_outdated => 'This image may be outdated';

  @override
  String get product_image_outdated_explanations_title =>
      'This image may be outdated';

  @override
  String get product_image_outdated_explanations_content =>
      'This image was taken more than a year ago.\n**Please check that\'s it\'s still up-to-date**.\n\nThis is **just a warning**. If the content is still the same, you can ignore this message.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Replace photo ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Add a photo ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Nova captura';

  @override
  String get product_image_action_take_picture => 'Fer una foto';

  @override
  String get product_image_action_from_gallery =>
      'Select from your phone\'s gallery';

  @override
  String get product_image_action_choose_existing_photo =>
      'Select from the product photos';

  @override
  String get product_image_details_label => 'Information about the photo';

  @override
  String get product_image_details_from_producer => 'From the producer';

  @override
  String get product_image_details_contributor => 'Voluntari/a';

  @override
  String get product_image_details_contributor_producer =>
      'Contributor (producer)';

  @override
  String get product_image_details_date => 'Data';

  @override
  String get product_image_details_date_unknown => 'Desconegut';

  @override
  String get homepage_main_card_logo_description =>
      'Welcome to Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Scan** a barcode or\n**search** for a product';

  @override
  String get homepage_main_card_search_field_hint => 'Search for a product';

  @override
  String get homepage_main_card_search_field_tooltip => 'Start search';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Latest news: $news_title';
  }

  @override
  String get tagline_app_review => 'Us agrada l\'aplicació?';

  @override
  String get tagline_app_review_button_positive => 'M\'encanta! 😍';

  @override
  String get tagline_app_review_button_negative => 'No gaire…';

  @override
  String get tagline_app_review_button_later => 'Pregunta-m\'ho després';

  @override
  String get tagline_feed_news_button => 'Know more';

  @override
  String get app_review_negative_modal_title =>
      'No us agrada, la nostra aplicació?';

  @override
  String get app_review_negative_modal_text =>
      'Podríeu emprar uns minuts per a dir-nos el per què?';

  @override
  String get app_review_negative_modal_positive_button => 'I tant!';

  @override
  String get app_review_negative_modal_negative_button => 'No';

  @override
  String get could_not_refresh => 'Impossible d\'actualitzar el producte';

  @override
  String get product_internet_error_modal_title => 'An error has occurred!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'We are unable to fetch information about this product due to a network error. Please check your internet connection and try again.\n\nInternal error:\n$error';
  }

  @override
  String get product_tags_title => 'Product properties';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Sense propietats';

  @override
  String get product_tags_explanation =>
      'En afegir propietats (clau/valor) a un producte, ajudeu a enriquir-lo.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Add properties';

  @override
  String get add_edit_tags => 'Add or edit properties';

  @override
  String get edit_tag => 'Edit property';

  @override
  String get remove_tag => 'Remove property';

  @override
  String get tag_key => 'Property';

  @override
  String get tag_keys => 'Propietats';

  @override
  String get tag_key_uneditable => 'Property (uneditable)';

  @override
  String get tag_key_input_hint => 'Input a property';

  @override
  String get tag_value => 'Valor';

  @override
  String get tag_values => 'Values';

  @override
  String get tag_value_input_hint => 'Input a value';

  @override
  String get tag_key_item => 'Property:';

  @override
  String get tag_value_item => 'Value:';

  @override
  String get tag_key_explanations =>
      'A key must be lowercase and without any spaces.';

  @override
  String tag_key_already_exists(String property) {
    return 'A tag with a property $property already exists!';
  }

  @override
  String get product_internet_error =>
      'No es pot obtenir informació sobre aquest producte a causa d\'un error de xarxa.';

  @override
  String get cached_results_from => 'Mostra resultats de:';

  @override
  String get product_search_same_category => 'Troba alternatives';

  @override
  String get product_search_same_category_short => 'Comparar';

  @override
  String get product_search_same_category_error =>
      'This feature can only be used for products with a category.\n\nPlease edit the product to add a category.';

  @override
  String get product_improvement_add_category =>
      'Afegiu una categoria per calcular el Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Afegiu dades nutricionals per calcular el Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Afegiu dades nutricionals i una categoria per calcular el Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'La Nutri-score d\'aquest producte no es pot calcular, la qual cosa pot ser degut, per exemple, a una categoria no estàndard. Si ho consideres un error, posa\'t en contacte amb nosaltres.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'La imatge nutricional és obsoleta: si us plau, actualitzeu-la.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'The Green Score takes into account the origins of the ingredients. Please take a photo of the ingredient list and/or any geographic claim or edit the product, so they can be taken into account.';

  @override
  String get country_chooser_label => 'Si us plau, trieu un país';

  @override
  String get currency_chooser_label => 'Trieu la vostra moneda';

  @override
  String get country_change_message => 'You have just changed countries.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Do you want to change the currency from $previousCurrency to $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Please choose a country:';

  @override
  String get country_chooser_label_from_settings => 'El vostre país';

  @override
  String get country_selection_explanation =>
      'Algunes característiques ambientals són específiques del lloc';

  @override
  String get product_removed_comparison => 'Producte eliminat de la comparació';

  @override
  String get native_app_settings => 'Configuració de l\'aplicació nativa';

  @override
  String get native_app_description =>
      'Obre la configuració del sistema per a Open Food Facts';

  @override
  String get product_removed_history => 'Producte eliminat de l\'historial';

  @override
  String get product_removed_list => 'Producte eliminat de la llista';

  @override
  String get product_could_not_remove => 'No s\'ha pogut eliminar el producte';

  @override
  String get no_prodcut_in_list => 'No hi ha cap producte en aquesta llista';

  @override
  String get no_product_in_section => 'No hi ha cap producte en aquesta secció';

  @override
  String get recently_seen_products => 'Tots els productes vistos';

  @override
  String get clear => 'Esborra';

  @override
  String get clear_long => 'Buida la llista';

  @override
  String get really_clear => 'Realment voleu suprimir aquesta llista?';

  @override
  String pct_match(Object percent) {
    return '$percent% de coincidència';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count dies',
      one: 'fa un dia',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Fa $count hores',
      one: 'Fa una hora',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count minuts',
      one: 'fa un minut',
      zero: 'fa menys d\'un minut',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count mesos',
      one: 'fa un mes',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'fa $count setmanes',
      one: 'fa una setmana',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Compara $count Productes',
      one: 'Compara un producte',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count selected products',
      one: 'One selected product',
      zero: 'No selected product',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Compare selected products';

  @override
  String get delete_products_mode => 'Delete selected products';

  @override
  String get select_all_products_mode => 'Select all products';

  @override
  String get select_none_products_mode => 'Select none';

  @override
  String get compare_products_appbar_title => 'Comparar productes';

  @override
  String get compare_products_appbar_subtitle =>
      'Seleccioneu com a mínim dos productes';

  @override
  String get retry_button_label => 'Torna a provar';

  @override
  String get connect_with_us => 'Connecta amb nosaltres';

  @override
  String get tiktok => 'Follow us on TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Segueix-nos a Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Segueix-nos a X (abans Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Follow us on Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Follow us on BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Bloc';

  @override
  String get faq => 'PMF';

  @override
  String get discover => 'Descobrir';

  @override
  String get how_to_contribute => 'Com contribuir';

  @override
  String get hint_knowledge_panel_message =>
      'Podeu fer clic a qualsevol part de la targeta per obtenir més detalls del que veieu. Proveu-ho ara!';

  @override
  String get permissions_page_title => 'Accés a la càmera';

  @override
  String get permissions_page_body1 =>
      'Per escanejar codis de barres amb la càmera del telèfon, si us plau, autoritzeu l\'accés.';

  @override
  String get permissions_page_body2 =>
      'Si canvieu d\'opinió, aquesta opció es pot activar o desactivar en qualsevol moment des de la configuració.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'Sistema operatiu: Android (SDK Int: $sdkInt / Versió: $release)\nModel: $model\nProducte: $product\nDispositiu: $device\nMarca:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'Sistema operatiu: iOS ($version)\nModel: $model\nModel localitzat: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nVersió de l\'aplicació:$appVersion\nNúmero de compilació de l\'aplicació:$appBuildNumber\nNom del paquet de l\'aplicació:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Autoritza';

  @override
  String get refuse_button_label => 'Denega';

  @override
  String get ask_me_later_button_label => 'Més tard';

  @override
  String get are_you_sure => 'N\'esteu segur?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Aneu més enllà del $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Welcome !';

  @override
  String get onboarding_home_welcome_text2 =>
      'The app that helps you choose food that is good for **you** and the **planet**!';

  @override
  String get onboarding_continue_button => 'Continuar';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'S\'està carregant el vostre primer exemple de producte';

  @override
  String get onboarding_welcome_warning =>
      'Ho sento, és el nostre producte d\'exemple, no el pots editar :)';

  @override
  String get product_list_your_ranking => 'La teva classificació';

  @override
  String get product_list_empty_icon_desc => 'Historial no disponible';

  @override
  String get product_list_empty_title => 'Comenceu a escanejar';

  @override
  String get product_list_empty_message =>
      'Els productes escanejats apareixeran aquí i podeu consultar informació detallada sobre ells';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'els productes',
      one: 'un producte',
      zero: 'cap producte',
    );
    return 'Refrescant $_temp0 en el teu historial';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'pels productes',
      one: 'pel producte',
      zero: 'pel producte',
    );
    return 'Refrescament acabat $_temp0';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Descàrregant les dades';

  @override
  String get loading_dialog_default_error_message =>
      'No s\'han pogut baixar les dades';

  @override
  String get account_delete => 'Elimina el compte';

  @override
  String get account_delete_title => 'Suprimeix el meu compte';

  @override
  String get user_profile => 'Compte';

  @override
  String get user_profile_title_guest => 'Benvingut! Benvinguda!';

  @override
  String get user_profile_subtitle_guest =>
      'Sign-in or sign-up to join the Open Food Facts community';

  @override
  String user_profile_title_id_email(String email) {
    return 'Open Food Facts login: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Benvingut/da $id!';
  }

  @override
  String get email_subject_account_deletion => 'Elimina el compte';

  @override
  String email_body_account_deletion(String userId) {
    return 'Hi there, please delete my Open Food Facts account: $userId';
  }

  @override
  String get settings_app_app => 'Aplicació';

  @override
  String get settings_app_data => 'Privacitat i seguiment';

  @override
  String get settings_app_camera => 'Càmera';

  @override
  String get settings_app_products => 'Productes';

  @override
  String get settings_app_miscellaneous => 'Miscel·lània';

  @override
  String get camera_play_sound_title => 'Reprodueix un so en escanejar';

  @override
  String get camera_play_sound_subtitle =>
      'Emetrà un so en cada escaneig exitós';

  @override
  String get camera_window_accessibility_label =>
      'Scan a barcode with your camera';

  @override
  String get app_haptic_feedback_title => 'Vibració i hàptica';

  @override
  String get app_haptic_feedback_subtitle =>
      'Vibracions després d\'executar algunes accions (codi de barres descodificat, producte eliminat…).';

  @override
  String get crash_reporting_toggle_title => 'Informes d\'errors';

  @override
  String get crash_reporting_toggle_subtitle =>
      'When enabled, crash reports are automatically submitted to Open Food Facts\' error tracking system, so that bugs can be fixed and thus improve the app.';

  @override
  String get send_anonymous_data_toggle_title => 'Enviament de dades anònimes';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Editar foto';

  @override
  String get permission_photo_error => 'Error';

  @override
  String get permission_photo_denied_title =>
      'Permeteu l\'ús de la càmera per escanejar codis de barres';

  @override
  String permission_photo_denied_message(String appName) {
    return 'Per obtenir una experiència millorada, permeteu que $appName accedeixi a la vostra càmera. Us permetrà escanejar codis de barres directament.';
  }

  @override
  String get permission_photo_denied_button => 'Permet';

  @override
  String get permission_photo_denied_dialog_settings_title => 'Permís denegat';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Com que prèviament heu denegat el permís de la càmera, heu de permetre\'l manualment des de la configuració.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Obre la configuració';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel =>
      'Cancel·lar';

  @override
  String get permission_photo_none_found => 'No es detecta cap càmera';

  @override
  String get permission_photo_denied => 'No s\'ha concedit accés a la càmera';

  @override
  String get show_product_pictures => 'Show product pictures';

  @override
  String get edit_product_label => 'Edita el producte';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Uploading your edits…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Your edits are being **sent in the background** (or later in case of error).\nYou can continue editing other product fields.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Your edits are being **sent in the background** (or later in case of error).';

  @override
  String get edit_product_label_short => 'Edita';

  @override
  String edit_product_form_item_help(String value) {
    return 'How to enter \"$value\"?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Please enter a non-empty value!';

  @override
  String get edit_product_form_item_error_existing =>
      'This value is already there!';

  @override
  String get edit_product_form_item_add_action_brand => 'Add a new brand';

  @override
  String get edit_product_form_item_add_action_label => 'Add a new label';

  @override
  String get edit_product_form_item_add_action_store => 'Add a new store';

  @override
  String get edit_product_form_item_add_action_origin => 'Add a new origin';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Add a new traceability code';

  @override
  String get edit_product_form_item_add_action_country => 'Add a new country';

  @override
  String get edit_product_form_item_add_action_category => 'Add a new category';

  @override
  String get edit_product_form_item_add_action_trace => 'Add a new trace';

  @override
  String get edit_product_form_item_add_suggestion => 'Add suggestion';

  @override
  String get edit_product_form_item_deny_suggestion => 'Rebutja el suggeriment';

  @override
  String get edit_product_form_item_details_title => 'Detalls bàsics';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Nom del producte, marca, quantitat';

  @override
  String get edit_product_form_item_other_details_title => 'Més detalls';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Lloc web…';

  @override
  String get edit_product_form_item_photos_title => 'Fotos';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Afegeix o actualitza fotos';

  @override
  String get edit_product_form_item_labels_title =>
      'Etiquetes i certificacions';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Mediambiental, Segells de qualitat…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Input a label (eg: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'etiqueta';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Good practices: Labels';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Any characteristic of the product **which is factual** and different from the other fields.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Nutri-Score, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Made in Belgium, produced in Brittany…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Rich in fiber, source of iron…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Fair trade, Max Havelaar…';

  @override
  String get edit_product_form_item_stores_title => 'Botigues';

  @override
  String get edit_product_form_item_stores_hint => 'Input a store';

  @override
  String get edit_product_form_item_stores_type => 'botiga';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Good practices: Stores';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Input the store where you bought the product.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Walmart';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Carrefour';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Lidl';

  @override
  String get edit_product_form_item_origins_title => 'Orígens';

  @override
  String get edit_product_form_item_origins_hint =>
      'Input an origin (eg: Germany)';

  @override
  String get edit_product_form_item_origins_type => 'país';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Good practices: Origins';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Add **any indications of origins you can find on the packaging**.\nYou need not worry about origins indicated directly in the ingredient list.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Beef from Argentina';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'The soy does not come from the European Union';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Input a country (eg: Germany)';

  @override
  String get edit_product_form_item_countries_type => 'país';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Good practices: Countries';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Countries where the product is widely available** (not including stores specialising in foreign products).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Codis de traçabilitat';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Input a code (eg: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'codi de traçabilitat';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Good practices: Traceability codes';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'In this section, you can input codes related to **packaging marks**, **identification marks** or **health marks**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Examples of traceability codes';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**EC codes** used in the European Community to identify food producers or packagers:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: country code of **France**\n**72.264.002**: geographic data\n**CE**: European Community';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB codes** used in France:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Rastres';

  @override
  String get edit_product_form_item_traces_hint => 'rastre';

  @override
  String get edit_product_form_item_traces_type =>
      'Input a trace (eg: Soy beans)';

  @override
  String get edit_product_form_item_categories_title => 'Categories';

  @override
  String get edit_product_form_item_categories_hint => 'categoria';

  @override
  String get edit_product_form_item_categories_type =>
      'Input a category (eg: Orange juice)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Good practices: Categories';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Indicate **only the most specific category**.\nParent categories will be automatically added.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Missing category?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'In case a category is **not available in autocomplete**, feel free to add it anyway.\nThis will help us improve Open Food Facts in your country.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Sardines in olive oil';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Orange juice from concentrate';

  @override
  String get edit_product_form_item_exit_title => 'Quit without saving?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Voleu desar els canvis abans de sortir de la pàgina?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Desa els canvis';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Descarta els canvis';

  @override
  String get edit_product_form_item_ingredients_title => 'Ingredients';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Zoom in and out by pinching the screen';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Zoom in and out the photo';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'Using the **Pinch-to-zoom gesture**, you can zoom in or out the photo:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Afegeix';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Si us plau, introduïu un text';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Suprimeix';

  @override
  String get edit_product_form_item_save_edit_item_tooltip => 'Save your edit';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Cancel your edit';

  @override
  String get edit_product_form_item_packaging_title =>
      'Foto d\'instruccions sobre el reciclatge';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Informació nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Nutrició, contingut alcohòlic…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Good practices: Nutrition facts';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Nutritional values';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'First, select if the **values are provided**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Informació nutricional';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'Then, input the nutritional values **as indicated on the packaging**. If there is no value, you can click on the \"Eye\" icon.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Missing field?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'If an entry is missing, you can **click on the \"Plus\" icon** to add it (eg: vitamin D, magnesium…).';

  @override
  String get edit_product_form_save => 'Edita';

  @override
  String get edit_product_ingredients_photo_title => 'Foto dels ingredients';

  @override
  String get edit_product_ingredients_list_title => 'Llistat d\'ingredients';

  @override
  String get edit_product_packaging_photo_title => 'Packaging photo';

  @override
  String get edit_product_packaging_list_title => 'Packaging list';

  @override
  String get no_data_available => 'No data available';

  @override
  String get product_field_website_title => 'Lloc web';

  @override
  String get origins_editing_title => 'Edit Origins';

  @override
  String get completed_basic_details_btn_text => 'Detalls bàsics complets';

  @override
  String get not_implemented_snackbar_text => 'Encara no s\'ha implementat';

  @override
  String get category_picker_page_appbar_text => 'Categories';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Extract ingredients from the photo';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Extreu els ingredients';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Extracting ingredients\nfrom the photo';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'To use the \"Extract ingredients\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Actualitza la foto';

  @override
  String get edit_packaging_extract_btn_text =>
      'Extract packaging\nfrom the photo';

  @override
  String get edit_packaging_extract_btn_text_short => 'Extract packaging';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Extracting packaging from the photo';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Loading photo…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Why do I see this message?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'To use the \"Extract packaging\" feature, the photo needs to be uploaded first.\n\nPlease wait a few seconds or enter them manually.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Actualitza la foto';

  @override
  String get edit_ocr_extract_failed =>
      'No ha pogut detectar text a la imatge.';

  @override
  String get edit_ocr_extract_disabled_title => 'No picture!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'In order to use the text extraction feature, you must first take a photo.';

  @override
  String get user_list_dialog_new_title => 'Nova llista de productes';

  @override
  String get user_list_dialog_rename_title => 'Canvia el nom a la llista';

  @override
  String get user_list_subtitle_product => 'Llistes';

  @override
  String get user_list_title => 'Les vostres llistes';

  @override
  String get user_list_add_product => 'Afegeix el producte a les teves llistes';

  @override
  String get user_list_button_new => 'Crea una llista nova';

  @override
  String get user_list_empty_label =>
      'Encara no hi ha cap llista disponible,\nsi us plau, comenceu creant-ne una';

  @override
  String get user_list_button_add_product => 'Afegeix a la llista';

  @override
  String get added_to_list_msg => 'S\'ha afegit a la llista';

  @override
  String get user_list_popup_clear => 'Neteja l\'historial';

  @override
  String get user_list_popup_rename => 'Canviar el nom';

  @override
  String get user_list_name_hint => 'La meva llista';

  @override
  String get user_list_name_error_empty => 'El nom és obligatori';

  @override
  String get user_list_name_error_already => 'Aquest nom ja s\'està utilitzat';

  @override
  String get user_list_name_error_same => 'Aquest és el mateix nom';

  @override
  String get user_list_name_input_hint => 'Name of the list';

  @override
  String get try_again => 'Torneu-ho a provar';

  @override
  String get there_was_an_error => 'S\'ha produït un error';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'No s\'ha trobat cap categoria per a $items';
  }

  @override
  String get camera_toggle_camera =>
      'Canvia entre la càmera posterior i la frontal';

  @override
  String get camera_toggle_flash => 'Enceneu o apagueu el flaix de la càmera';

  @override
  String get camera_enable_flash => 'Activa el flaix';

  @override
  String get camera_disable_flash => 'Desactiva el flaix';

  @override
  String get camera_flash_error_dialog_title => 'S\'ha produït un error!';

  @override
  String get camera_flash_error_dialog_message =>
      'S\'ha produït un error en canviar l\'estat del flaix. Assegureu-vos que el vostre telèfon no tingui la llanterna activada.';

  @override
  String get category_picker_no_category_found_button => 'Enrere';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Click to open in your browser or in the application (if installed)';

  @override
  String get dev_preferences_screen_title => 'Mode Desenvolupador';

  @override
  String get dev_preferences_screen_subtitle =>
      'Accediu a funcions experimentals i eines de desenvolupament';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Reinicieu la incorporació';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'Llavors heu de reiniciar l\'aplicació per tornar-ho a veure.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Canvia entre openfoodfacts.org (PROD) i prova env';

  @override
  String get dev_preferences_test_environment_title =>
      'Paràmetres de l\'entorn de prova';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'URL base per a l\'entorn de prova actual: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Amfitrió de l\'entorn de prova';

  @override
  String get dev_preferences_ml_kit_title => 'Utilitzeu el kit ML';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'aleshores heu de reiniciar aquesta aplicació';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Botó addicional a la pàgina del producte';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Editeu els ingredients mitjançant un botó del tauler de coneixement';

  @override
  String get dev_preferences_export_history_title => 'Exporta l\'historial';

  @override
  String get dev_preferences_export_history_progress_error => 'excepció';

  @override
  String get dev_preferences_export_history_progress_found => 'producte trobat';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'producte NO trobat';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Exportació de l\'historial';

  @override
  String get dev_preferences_button_positive => 'D\'acord';

  @override
  String get dev_preferences_button_negative => 'Cancel·lar';

  @override
  String get dev_preferences_migration_title =>
      'Migració de dades des de la V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Estat: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'èxit o instal·lació nova';

  @override
  String get dev_preferences_migration_status_success => 'èxit';

  @override
  String get dev_preferences_migration_status_error => 'error';

  @override
  String get dev_preferences_migration_status_in_progress => 'en curs';

  @override
  String get dev_preferences_migration_status_required =>
      'obligatori (feu clic per començar)';

  @override
  String get dev_preferences_migration_status_not_started => 'desconegut';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Esborrarà l\'historial i hi posarà 3 productes';

  @override
  String get dev_preferences_news_custom_url_title => 'Custom URL for news';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL of the JSON file:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Not set';

  @override
  String get dev_preferences_news_provider_status_title => 'Estat';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Last refresh: $date';
  }

  @override
  String get product_type_label_food => 'Menjar';

  @override
  String get product_type_label_beauty => 'Personal care';

  @override
  String get product_type_label_pet_food => 'Menjar per a mascotes';

  @override
  String get product_type_label_product => 'Altres';

  @override
  String get product_type_selection_title => 'Product type';

  @override
  String get product_type_selection_subtitle =>
      'Select the type of this product';

  @override
  String get product_type_selection_empty =>
      'You need to select a product type first!';

  @override
  String product_type_selection_already(String productType) {
    return 'You cannot change the product type ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Shortcut to Prices app on product page';

  @override
  String get prices_app_button => 'Go to Prices app';

  @override
  String get prices_website_button => 'Obre al lloc web de Preus Oberts';

  @override
  String get prices_bulk_proof_upload_select =>
      'Add price tags directly from gallery';

  @override
  String get prices_bulk_proof_upload_warning =>
      'Once you\'ve selected images, you won\'t be able to edit them!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Permetre que la comunitat validi els preus extrets per la IA.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Multiple Price Tags';

  @override
  String get prices_bulk_proof_upload_title => 'Bulk Proof Upload';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Seleccionant fitxers';

  @override
  String get prices_bulk_proof_upload_step_starting => 'Inici de la càrrega';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Copiant localment el fitxer #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Preparant la càrrega #$index/${count}S\'està preparant la càrrega #$index / $count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Error a la imatge #$index/$count';
  }

  @override
  String get prices_generic_title => 'Preus';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Add $count prices',
      one: 'Add a price',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Send $count prices',
      one: 'Send the price',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Add an item';

  @override
  String get prices_add_a_price => 'Afegir un preu';

  @override
  String get prices_add_a_receipt => 'Add a receipt';

  @override
  String get prices_add_price_tags => 'Add price tags';

  @override
  String prices_barcode_already(String barcode) {
    return 'This barcode ($barcode) is already in the list!';
  }

  @override
  String get prices_barcode_search_not_found => 'No s\'ha trobat el producte';

  @override
  String get prices_barcode_search_none_yet => 'No product yet';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Looking for $barcode';
  }

  @override
  String get prices_barcode_enter => 'Enter the Barcode';

  @override
  String get prices_category_enter => 'Article sense codi de barres';

  @override
  String get prices_per_kilogram => 'Preu per quilogram';

  @override
  String get prices_per_unit => 'Price per unit';

  @override
  String get prices_per_kilogram_short => ' / kg';

  @override
  String get prices_per_unit_short => ' / unitat';

  @override
  String get prices_category_mandatory => 'Obligatori';

  @override
  String get prices_category_optional => 'Opcional';

  @override
  String get prices_category_error_mandatory => 'La categoria és obligatòria';

  @override
  String get prices_barcode_reader_action => 'Barcode reader';

  @override
  String get prices_view_prices => 'View the prices';

  @override
  String get prices_list_title => 'Llista de preus';

  @override
  String get prices_list_count => 'Nombre de preus\n';

  @override
  String get prices_list_add_new_price => 'Afegeix un\npreu nou';

  @override
  String get prices_list_empty_title => 'Encara no hi ha preu!';

  @override
  String get prices_list_empty_subtitle =>
      'Sigues el primer a afegir-ne un:\nEscanejant un **rebut** o una **etiqueta de preu**!';

  @override
  String get prices_entry_shop_not_found => 'Botiga desconeguda';

  @override
  String prices_entry_menu_title(String user) {
    return 'Entrada de preu des de \"$user\"';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Veure tots els preus d\'aquest producte';

  @override
  String get prices_entry_menu_open_proof => 'Veure prova';

  @override
  String get prices_entry_menu_my_prices => 'Veure els meus altres preus';

  @override
  String get prices_entry_menu_author_prices =>
      'Veure altres preus de l\'autor';

  @override
  String get prices_entry_menu_shop_prices => 'Veure altres preus de la botiga';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: '1 price',
    );
    return '$_temp0 for $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count prices',
      one: 'Only one price',
      zero: 'No price yet',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize prices (total: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Price: $price / Store: \"$location\" / Published on $date by \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Open proofs of \"$user\"';
  }

  @override
  String get prices_open_proof => 'Open price proof';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'All $count proofs',
      one: 'Only one proof',
      zero: 'No proof yet',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Latest $pageSize proofs (total: $total)';
  }

  @override
  String get prices_users_empty_title => 'Encara no hi ha cap col·laborador!';

  @override
  String get prices_users_empty_explanation =>
      'Sigues el primer a afegir un preu!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize contributors (total: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Encara no hi ha botiga!';

  @override
  String get prices_locations_empty_explanation =>
      'Sigues el primer a afegir un preu!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize locations (total: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count proofs',
      one: 'One proof',
      zero: 'No proof',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count products',
      one: 'One product',
      zero: 'No product',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count users',
      one: 'One user',
      zero: 'No user',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count prices',
      one: 'One price',
      zero: 'No price',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Preu afegit anteriorment';

  @override
  String get prices_amount_subtitle => 'Amount';

  @override
  String get prices_amount_is_discounted => 'Is discounted?';

  @override
  String get prices_amount_price_normal => 'Preu';

  @override
  String get prices_amount_price_discounted => 'Preu rebaixat';

  @override
  String get prices_amount_price_not_discounted => 'Original price';

  @override
  String get prices_amount_no_product => 'One product is missing!';

  @override
  String get prices_amount_price_incorrect => 'Incorrect value';

  @override
  String get prices_amount_price_mandatory => 'Mandatory value';

  @override
  String get prices_currency_subtitle => 'Moneda';

  @override
  String get prices_date_subtitle => 'Data';

  @override
  String get prices_location_subtitle => 'Shop';

  @override
  String get prices_location_find => 'Find a shop';

  @override
  String get prices_location_mandatory => 'You need to select a shop!';

  @override
  String get prices_location_search_broader =>
      'Couldn\'t find what you were looking for? Let\'s try a broader search!';

  @override
  String get prices_proof_subtitle => 'Prova';

  @override
  String get prices_proof_empty_title => 'Encara no hi ha proves!';

  @override
  String get prices_proof_empty_explanation =>
      'Comença afegint una foto d\'un **rebut** o una **etiqueta de preu**!';

  @override
  String get prices_proof_find => 'Select a proof';

  @override
  String get prices_proof_change => 'Change proof';

  @override
  String get prices_proof_receipt => 'Receipt';

  @override
  String get prices_proof_price_tag => 'Price tag';

  @override
  String get prices_proof_mandatory => 'You need to select a proof!';

  @override
  String get prices_add_validation_error => 'Validation error';

  @override
  String get prices_privacy_warning_title => 'Privacy warning';

  @override
  String get prices_unknown_product => 'Unknown product';

  @override
  String get prices_privacy_warning_main_message =>
      'Prices **will be public**, along with the store they refer to.\n\nThat might allow people who know about your Open Food Facts pseudonym to:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Infer in which area you live';

  @override
  String get prices_privacy_warning_message_bullet_2 =>
      'Know what you are buying';

  @override
  String get prices_privacy_warning_sub_message =>
      'If you are uneasy with that, please change your pseudonym, or create a new Open Food Facts account and log into the app with it.';

  @override
  String get i_refuse => 'I refuse';

  @override
  String get i_accept => 'I accept';

  @override
  String get prices_currency_change_proposal_title => 'Change the currency?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Your current currency is **$currency**. Would you like to change it to **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Yes, use $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'No, keep $currency';
  }

  @override
  String get prices_menu_know_more => 'Know more about Open Prices';

  @override
  String get dev_preferences_import_history_result_success => 'Fet';

  @override
  String get dev_mode_section_server => 'Server configuration';

  @override
  String get dev_mode_section_news => 'News provider configuration';

  @override
  String get dev_mode_section_product_page => 'Product page';

  @override
  String get dev_mode_section_ui => 'User Interface';

  @override
  String get dev_mode_section_experimental_features => 'Experimental features';

  @override
  String get dev_mode_hide_environmental_score_title => 'Exclude Green Score';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Use a spellchecker for OCR screens';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle =>
      '(Ingredients and packaging)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Restableix l\'idioma de l\'aplicació';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Afegeix targetes';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Canvia entre prices.openfoodfacts.org (PROD) i l\'entorn de prova';

  @override
  String get search_history_item_edit_tooltip => 'Reuse and edit this search';

  @override
  String get search_history_item_remove_tooltip => 'Suprimeix';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Has baixat tots els $totalSize productes.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Descarrega $count productes més\nJa s\'han descarregat $downloaded de $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Your search of $search is in progress.\n\nPlease wait a few seconds…';
  }

  @override
  String get user_search_contributor_title => 'Productes I afegits';

  @override
  String get user_search_informer_title => 'Productes I editats';

  @override
  String get user_search_photographer_title => 'Productes I fotografiats';

  @override
  String get user_search_to_be_completed_title =>
      'Els meus productes pendents de completar';

  @override
  String get user_search_prices_title => 'My prices';

  @override
  String get user_search_proofs_title => 'My proofs';

  @override
  String get user_search_proof_title => 'My proof';

  @override
  String search_proof_title(String user) {
    return 'Proof from \"$user\"';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Preus de col·laboradors: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Latest Prices added';

  @override
  String get all_search_prices_top_user_title => 'Top price contributors';

  @override
  String get all_search_prices_top_location_title =>
      'Stores with the most prices';

  @override
  String get prices_contribution_assistant => 'Price Contribution Assistant';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system => 'Add Multiple Proofs';

  @override
  String get all_search_prices_top_location_single_title => 'Prices in a store';

  @override
  String get all_search_prices_top_product_title =>
      'Products with the most prices';

  @override
  String get all_search_to_be_completed_title =>
      'Tots els productes per completar';

  @override
  String get categorize_products_country_title =>
      'Help categorize products in your country';

  @override
  String get edit_product_action_retake_picture => 'Torna a fer la foto';

  @override
  String get edit_product_action_take_picture => 'Fes una foto';

  @override
  String get edit_product_action_confirm => 'Confirma';

  @override
  String get signup_page_terms_of_use_line1 =>
      'I agree to the Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 => 'termes d\'ús i contribució';

  @override
  String get analytics_consent_image_semantic_label => 'Icona d\'Analítiques';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Error fatal: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Error fatal: $error';
  }

  @override
  String get summary_card_button_add_basic_details => 'Detalls bàsics complets';

  @override
  String get edit_photo_button_label => 'Edita';

  @override
  String get edit_photo_unselect_button_label => 'Desselecciona la foto';

  @override
  String get edit_photo_select_existing_button_label =>
      'Seleccionar una imatge existent';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Select an image by clicking on it';

  @override
  String get edit_photo_select_existing_download_label =>
      'Recuperant imatges existents…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'No hi ha imatges carregades anteriorment relacionades amb aquest producte.';

  @override
  String get edit_photo_language_not_this_one =>
      'Encara no hi ha imatge en aquest idioma';

  @override
  String get edit_photo_language_none => 'Encara no hi ha imatge';

  @override
  String get category_picker_screen_title => 'Categories';

  @override
  String get basic_details => 'Detalls bàsics';

  @override
  String get product_name => 'Nom del producte';

  @override
  String get product_names => 'Product Names';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Add a new translation';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Before validating, please ensure you only add a translation **if the language is present on the packaging**';

  @override
  String get add_basic_details_product_name_open_photo => 'View front photo';

  @override
  String get add_basic_details_product_name_take_photo => 'Take front photo';

  @override
  String get add_basic_details_product_name_hint =>
      'Input the name of the product (eg: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Canviar l\'idioma predeterminat?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Voleu que l\'idioma per defecte del producte estigui definit com a \'$language\'?';
  }

  @override
  String get explanation_section_good_examples => 'Good examples';

  @override
  String get explanation_section_bad_examples => 'Bad examples';

  @override
  String get add_basic_details_product_name_help_title =>
      'Good practices: Product name';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'The product name is the **main name printed on the packaging**. It can be a registered trademark.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Note:** Please don\'t add a translation **if the language is not present on the packaging**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Nesquik';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Tomato Ketchup';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Don\'t include the brand in the name';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Tomato Ketchup **by Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Don\'t use symbols ®, ™, © or similar';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Nesquik**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count other translations',
      one: '$count other translation',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Nom de la marca';

  @override
  String get brand_names => 'Brand names';

  @override
  String get add_basic_details_brand_name_error =>
      'Si us plau, introduïu el nom de la marca';

  @override
  String get add_basic_details_brand_names_hint => 'Input brands (eg: Ferrero)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Good practices: Brands';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Input **all the brands of the product**.';

  @override
  String get add_basic_details_product_brand_help_info2_title => 'Main brand';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      'The **main brand**, generally clearly displayed on the front pack, should be **entered first**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Other brands';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'When sold **by a big company**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Actimel** is sold by **Danone**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'When sold with its brand **translated in multiple languages**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** is sometimes written **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Nutella';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Oreo, Mondelez';

  @override
  String get quantity => 'Quantitat i pes';

  @override
  String get add_basic_details_quantity_hint =>
      'Input the weight and if needed the quantity (eg : 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Good practices: Quantity';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Copy the value indicated on the product and **don\'t forget the units**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230g** or **230 g**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (for 6 eggs)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150g**\n(for a product with 3 boxes, each of 150g)';

  @override
  String get barcode => 'Codi de barres';

  @override
  String barcode_barcode(String barcode) {
    return 'Codi de barres: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Codi de barres invàlid';

  @override
  String get basic_details_add_success =>
      'Els detalls bàsics s\'han afegit correctament';

  @override
  String get basic_details_add_error =>
      'No es poden afegir detalls bàsics. Si us plau, torna-ho a provar d\'aquí a un temps';

  @override
  String get clear_search => 'Clear your search';

  @override
  String get confirm_clear =>
      'Esteu a punt d\'esborrar tot el vostre historial: esteu segurs que voleu continuar?';

  @override
  String get alert_clear_selected_user_list =>
      'Esteu a punt d\'esborrar els elements seleccionats del vostre historial';

  @override
  String get confirm_clear_selected_user_list =>
      'Estàs segur que vols continuar?';

  @override
  String get alert_select_items_to_clear =>
      'Seleccioneu un o més elements per esborrar';

  @override
  String confirm_clear_user_list(String name) {
    return 'Esteu a punt d\'esborrar aquesta llista ($name): estàs segur que vols continuar?';
  }

  @override
  String get confirm_delete_user_list_title => 'Delete the list?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'You\'re about to delete the list \"$name\".\nAre you sure you want to continue?';
  }

  @override
  String get confirm_delete_user_list_button => 'Yes, I confirm';

  @override
  String importance_label(String name, String id) {
    return '$name importància: $id';
  }

  @override
  String get user_list_all_title => 'Llistes';

  @override
  String get user_list_all_empty => 'Creeu la vostra primera llista';

  @override
  String get product_list_select => 'Tria una llista';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count productes',
      one: 'Un producte',
      zero: 'Llista buida',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Afegeix llista';

  @override
  String get open_food_preferences_tooltip =>
      'Editeu les vostres preferències alimentàries';

  @override
  String get add_photo_button_label => 'Afegeix foto';

  @override
  String get add_packaging_photo_button_label =>
      'Feu fotos de qualsevol informació d\'embalatge/reciclatge';

  @override
  String get add_origin_photo_button_label =>
      'Take photos of any origin information';

  @override
  String get add_emb_photo_button_label =>
      'Take photos of any traceability code information';

  @override
  String get add_label_photo_button_label =>
      'Take photos of any labels & certifications information';

  @override
  String get choose_image_source_title => 'Trieu la font de la imatge';

  @override
  String get choose_image_source_body => 'Si us plau, trieu una font d\'imatge';

  @override
  String get gallery_source_label => 'Galeria';

  @override
  String get gallery_source_access_denied_dialog_title => 'Accés denegat';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'Malauradament, l\'aplicació no pot accedir a la vostra galeria, ja que prèviament heu denegat el permís.\n\nAneu a la configuració de les aplicacions al vostre telèfon Configuració -> Fotos';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Obre la Configuració';

  @override
  String get share => 'Comparteix';

  @override
  String share_product_text(String url) {
    return 'Have a look at this product on Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Have a look at this product on Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Have a look at this product on Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Have a look at this product on Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Have a look at my list of products on Open Food Facts: $url';
  }

  @override
  String get capture => 'Nova captura';

  @override
  String get capture_new_picture => 'Fer una foto';

  @override
  String get choose_from_gallery => 'Triar de la galeria';

  @override
  String get image_upload_queued =>
      'La imatge es penjarà en segon pla tan aviat com sigui possible.';

  @override
  String get add_price_queued =>
      'The price will be sent to the server as soon as possible.';

  @override
  String get background_task_title_full_refresh =>
      'Començant l\'actualització de tots els productes emmagatzemats localment';

  @override
  String get background_task_title_top_n =>
      'Començant la descàrrega dels productes més populars';

  @override
  String get expand_nutrition_facts => 'Amplieu la taula de dades nutricionals';

  @override
  String get expand_nutrition_facts_body =>
      'Manteniu la taula de dades nutricionals ampliada';

  @override
  String get expand_ingredients => 'Ampliar els ingredients';

  @override
  String get expand_ingredients_body =>
      'Manteniu el panell d\'ingredients expandit';

  @override
  String get no_internet_connection => 'No hi ha connexió a Internet';

  @override
  String get world_results_label => 'Món sencer';

  @override
  String get world_results_action => 'Amplieu la vostra cerca al món';

  @override
  String get copy_to_clipboard => 'Copia';

  @override
  String get paste_from_clipboard => 'Paste from clipboard';

  @override
  String get no_data_available_in_clipboard =>
      'No data available in your clipboard';

  @override
  String get clipboard_barcode_copy =>
      'Copia el codi de barres al porta-retalls';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Codi de barres $barcode copiat al porta-retalls!';
  }

  @override
  String get open_product_website => 'Open this product on the website';

  @override
  String get language_picker_label => 'Your language';

  @override
  String get country_picker_label => 'El vostre país';

  @override
  String get currency_picker_label => 'Your currency';

  @override
  String get help_with_openfoodfacts => 'Ajuda a OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'El producte s\'actualitzarà en segon pla tan aviat com sigui possible.';

  @override
  String get no_email_client_available_dialog_title =>
      'No hi ha aplicacions de correu electrònic!';

  @override
  String get no_email_client_available_dialog_content =>
      'Please send us manually an email to mobile@openfoodfacts.org';

  @override
  String get all_images => 'Totes les imatges';

  @override
  String get selected_images => 'Imatges seleccionades';

  @override
  String get product_card_remove_product_tooltip => 'Eliminar el producte';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Nou codi de barres escanejat: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Traieu tots els productes del carrusel';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Si us plau, escaneja almenys dos productes per comparar-los';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Feu clic per comparar els productes que heu escanejat';

  @override
  String get scan_product_loading => 'You have scanned\nthe barcode:';

  @override
  String get scan_product_loading_initial =>
      'We\'re looking for this product!\nPlease wait a few seconds…';

  @override
  String get scan_product_loading_long_request =>
      'We\'re still looking for this product!\nDo you find it takes a long time to load? So are we…';

  @override
  String get scan_product_loading_unresponsive =>
      'We\'re still looking for this product.\nWould you like to restart the search?';

  @override
  String get scan_product_loading_restart_button => 'Restart search';

  @override
  String get portion_calculator_description =>
      'Calcula els valors nutricionals per a una quantitat específica';

  @override
  String get portion_calculator_hint => 'Quantity in';

  @override
  String get portion_calculator_accessibility =>
      'Input a quantity to calculate nutrition facts';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Please enter a quantity between $min and $max g';
  }

  @override
  String get portion_calculator_computation_error =>
      'Missing data. Calculation could not be performed.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Dades nutricionals per a $grams g (o ml)';
  }

  @override
  String get offline_data => 'Dades fora de línia';

  @override
  String get ocr_image_upload_instruction =>
      'Carregueu una imatge per extreure automàticament la informació que conté.';

  @override
  String get upload_image => 'Penjar una foto';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'No s\'ha pogut baixar la imatge';

  @override
  String get image_edit_url_error =>
      'No s\'ha pogut editar la imatge perquè l\'URL de la imatge no s\'ha definit.';

  @override
  String get user_picture_source_remember => 'Recorda la meva selecció';

  @override
  String get user_picture_source_ask => 'Ask each time';

  @override
  String get robotoff_continue => 'Continuar';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'es $count preguntes',
      one: 'a pregunta',
    );
    return 'Pròxim$_temp0';
  }

  @override
  String get show_password => 'Mostra la contrasenya';

  @override
  String get owner_field_info_title => 'Producer provided values';

  @override
  String get owner_field_info_message =>
      'With that logo we highlight data provided by the producer, and that may not be editable.';

  @override
  String get owner_field_info_close_button => 'Close this info';

  @override
  String get owner_field_image =>
      'This image is provided by the producer. It may not be editable.';

  @override
  String get edit_packagings_title => 'Components d\'embalatge';

  @override
  String get edit_packagings_element_add => 'Afegiu un component d\'embalatge';

  @override
  String get edit_packagings_completed => 'L\'embalatge està complet';

  @override
  String edit_packagings_element_title(int index) {
    return 'Component d\'embalatge #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Number of units';

  @override
  String get edit_packagings_element_hint_units =>
      'Introduïu el nombre d\'unitats d\'embalatge de la mateixa forma i material que conté el producte.';

  @override
  String get edit_packagings_element_field_shape => 'Forma';

  @override
  String get edit_packagings_element_hint_shape =>
      'Introduïu el nom de la forma que apareix a les instruccions de reciclatge si està disponible o seleccioneu una forma.';

  @override
  String get edit_packagings_element_example_shape => 'Ampolla';

  @override
  String get edit_packagings_element_field_material => 'Material';

  @override
  String get edit_packagings_element_hint_material =>
      'Introduïu el material específic si es pot determinar (hi sol haver un codi de material dins d\'un triangle a les peces d\'embalatge) o un material genèric (per exemple, plàstic o metall) si no n\'esteu segurs.';

  @override
  String get edit_packagings_element_example_material => 'Vidre';

  @override
  String get edit_packagings_element_field_recycling =>
      'Instrucció de reciclatge';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Introduïu les instruccions de reciclatge només si apareixen al producte.';

  @override
  String get edit_packagings_element_example_recycling => 'Reciclar';

  @override
  String get edit_packagings_element_field_quantity =>
      'Quantitat neta de producte per unitat';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Introduïu el pes net o el volum net i indiqueu la unitat (per exemple, g o ml).';

  @override
  String get edit_packagings_element_field_weight =>
      'Pes d\'una unitat buida (g)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Traieu els aliments restants i renteu i assequeu la part de l\'embalatge abans de pesar. Si és possible, utilitzeu una escala amb una precisió de 0,1 g o 0,01 g.';

  @override
  String get background_task_title => 'Contribucions pendents';

  @override
  String get background_task_subtitle =>
      'Les teves contribucions es guarden automàticament al nostre servidor, però no sempre en temps real.';

  @override
  String get background_task_list_empty => 'No hi ha tasques de fons pendents';

  @override
  String get background_task_error_server_time_out =>
      'Temps d\'espera del servidor';

  @override
  String get background_task_error_no_internet =>
      'Error de connexió a Internet. Prova-ho més tard.';

  @override
  String get background_task_operation_unknown =>
      'tipus d\'operació desconegut';

  @override
  String get background_task_operation_details => 'canvis detallats';

  @override
  String get background_task_operation_image => 'càrrega de fotos';

  @override
  String get background_task_operation_refresh =>
      'actualització retardada després de pujar la foto';

  @override
  String get background_task_run_started => 'iniciada';

  @override
  String get background_task_run_not_started => 'sense iniciar';

  @override
  String get background_task_run_to_be_deleted => 'per ser suprimit';

  @override
  String get background_task_question_stop =>
      'Vols aturar aquesta tasca el més aviat possible?';

  @override
  String get feed_back => 'Suggeriments';

  @override
  String get undo => 'Desfés';

  @override
  String get copy_email_to_clip_board =>
      'Copiar correu electrònic al porta-retalls';

  @override
  String get please_send_us_an_email_to =>
      'Envieu-nos manualment un correu electrònic a';

  @override
  String get email_copied_to_clip_board =>
      'S\'ha copiat el correu electrònic al porta-retalls!';

  @override
  String get select_accent_color => 'Seleccioneu Color d\'accent';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Blau';

  @override
  String get color_cyan => 'Cian';

  @override
  String get color_green => 'Verd';

  @override
  String get color_light_brown => 'Per defecte';

  @override
  String get color_magenta => 'Magenta';

  @override
  String get color_orange => 'Taronja';

  @override
  String get color_pink => 'Rosa';

  @override
  String get color_red => 'Vermell';

  @override
  String get color_rust => 'Rovell';

  @override
  String get color_teal => 'Turquesa fosc';

  @override
  String get text_contrast_mode => 'Contrast del text';

  @override
  String get contrast_high => 'Alt';

  @override
  String get contrast_medium => 'Mitjà';

  @override
  String get contrast_low => 'Baix';

  @override
  String get product_refresher_internet_not_found => 'Producte no trobat!';

  @override
  String get product_refresher_internet_not_connected =>
      'You are not connected to internet!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Server down ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Server error ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Producte no trobat!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Un producte amb el codi de barres següent no existeix a la nostra base de dades: $barcode';
  }

  @override
  String get product_loader_network_error_title =>
      'No hi ha conexió a internet!';

  @override
  String get product_loader_network_error_message =>
      'Si us plau, comproveu que el vostre telèfon estigui connectat a una xarxa WiFi o que tingui activades les dades mòbils';

  @override
  String get page_not_found_title => 'No s\'ha pogut trobar la pàgina!';

  @override
  String get page_not_found_button => 'Torna a la pàgina d\'inici';

  @override
  String get download_data => 'Descarregar dades';

  @override
  String get download_top_products =>
      'Baixeu els 1000 millors productes del vostre país per a l\'escaneig instantani';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '/s $count producte/s més popular/s',
    );
    return 'Descarrega el$_temp0 al teu país per a l\'escaneig instantani';
  }

  @override
  String get download_in_progress =>
      'Baixant dades\nAixò pot trigar una estona';

  @override
  String downloaded_products(int num) {
    return '$num productes afegits';
  }

  @override
  String get update_offline_data =>
      'Actualitza les dades del producte fora de línia';

  @override
  String get update_local_database_sub =>
      'Update the local product database with the latest data from Open Food Facts';

  @override
  String get clear_local_database =>
      'Esborra les dades del producte fora de línia';

  @override
  String get clear_local_database_sub =>
      'Esborra totes les dades de productes locals de la teva aplicació per alliberar espai';

  @override
  String deleted_products(int num) {
    return '$num productes suprimits';
  }

  @override
  String get loading => 'S\'està carregant…';

  @override
  String get know_more => 'Més informació';

  @override
  String get offline_data_desc =>
      'Feu clic per obtenir més informació sobre les dades fora de línia';

  @override
  String get offline_product_data_title => 'Dades de producte fora de línia';

  @override
  String available_for_download(int num) {
    return '$num productes disponibles per a l\'exploració immediata';
  }

  @override
  String get country_selector_title => 'Seleccioneu el vostre país:';

  @override
  String get currency_selector_title => 'Seleccioneu la vostra moneda:';

  @override
  String get language_selector_title => 'Select your language:';

  @override
  String get language_selector_section_selected => 'Selected languages';

  @override
  String get language_selector_section_frequently_used => 'Frequently used';

  @override
  String get action_delete_list => 'Elimina';

  @override
  String get action_change_list => 'Change the current list';

  @override
  String get product_list_create => 'Crea';

  @override
  String get product_list_create_tooltip => 'Crea una llista nova';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Nutri-Score A';

  @override
  String get nutriscore_b => 'Nutri-Score B';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (nou càlcul)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (nou càlcul)';

  @override
  String get nutriscore_unknown => 'Nutri-Score desconegut';

  @override
  String get nutriscore_unknown_new_formula =>
      'Nutri-score desconegut (nou càlcul)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score is not applicable';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score is not applicable (New calculation)';

  @override
  String get environmental_score_generic_new => 'Green-Score';

  @override
  String get environmental_score_a_new => 'Puntuació verda A';

  @override
  String get environmental_score_b_new => 'Green-Score B';

  @override
  String get environmental_score_c_new => 'Green-Score C';

  @override
  String get environmental_score_d_new => 'Green-Score D';

  @override
  String get environmental_score_e_new => 'Green-Score E';

  @override
  String get environmental_score_unknown_new => 'Puntuació verda desconeguda';

  @override
  String get environmental_score_not_applicable_new =>
      'La puntuació verda no és aplicable';

  @override
  String get nova_group_generic_new => 'Aliments ultraprocessats - Grups NOVA';

  @override
  String get nova_group_1 => 'NOVA Group 1';

  @override
  String get nova_group_2 => 'NOVA Group 2';

  @override
  String get nova_group_3 => 'NOVA Group 3';

  @override
  String get nova_group_4 => 'NOVA Group 4';

  @override
  String get nova_group_unknown => 'Unknown NOVA Group';

  @override
  String get nutrition_facts => 'Nutrient Levels';

  @override
  String get faq_title_partners => 'Partners & Patrons of the NGO';

  @override
  String get faq_title_vision =>
      'The Open Food Facts Vision, Mission, Values and Programs';

  @override
  String get faq_title_install_beauty =>
      'Install Open Beauty Facts to create a cosmetic database';

  @override
  String get faq_title_install_pet =>
      'Install Open Pet Food Facts to create a pet food database';

  @override
  String get faq_title_install_product =>
      'Install Open Products Facts to create a products database to extend the life of objects';

  @override
  String get faq_nutriscore_nutriscore =>
      'New calculation of the Nutri-Score: what\'s new?';

  @override
  String get contact_title_pro_page =>
      'Pro? Import your products in Open Food Facts';

  @override
  String get contact_title_pro_email => 'Producer Contact';

  @override
  String get contact_title_press_page => 'Press Page';

  @override
  String get contact_title_press_email => 'Press Contact';

  @override
  String get contact_title_newsletter => 'Subscriu-te al nostre butlletí';

  @override
  String get contact_title_calendar => 'Subscribe to our community calendar';

  @override
  String get hunger_games_loading_line1 => 'Please give us a few seconds…';

  @override
  String get hunger_games_loading_line2 => 'Estem descarregant les preguntes!';

  @override
  String get hunger_games_error_label =>
      'Ui! Alguna cosa no ha funcionat… i no hem pogut carregar les preguntes.';

  @override
  String get hunger_games_error_retry_button => 'Tornem-ho a provar!';

  @override
  String get reorder_attribute_action => 'Reorder the attributes';

  @override
  String get link_cant_be_opened =>
      'Aquest enllaç no es pot obrir al vostre dispositiu. Si us plau, comproveu que teniu un navegador instal·lat.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Detalls per a $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Detalls per a $pageName amb $productName';
  }

  @override
  String get guide_title => 'Guia';

  @override
  String get guide_share_label => 'Comparteix';

  @override
  String get guide_nutriscore_v2_title =>
      'El Nutri-Score està evolucionant: explicacions!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'What is the Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'El Nutri-Score és un logotip que pretén informar-vos sobre la **qualitat nutricional dels aliments**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'El codi de color varia des del verd fosc (**A**) per als productes **més saludables** fins al vermell fosc (**E**) per als **menys saludables**.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'El logotip de Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title =>
      'Per què està evolucionant Nutri-Score?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Where to find the new Nutri-Score calculation?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'The Nutri-Score is applied in 7 countries: France, Germany, Belgium, Spain, Luxembourg, the Netherlands and Switzerland.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Manufacturers have at most **2 years** at the latest after the signature of the decree **to replace** the old calculation with the new one.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Green-Score';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Què és la puntuació verda?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'El Green-Score és un logotip que pretén informar-vos sobre l\'**impacte ambiental dels aliments**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'El codi de color varia del verd fosc (**A+**) per als productes **menys impactants** al vermell fosc (**F**) per als productes **més impactants**.';

  @override
  String get guide_greenscore_logos_caption => 'Els logotips de Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'El nucli: Anàlisi del cicle de vida (ACV)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Una avaluació científica de les categories d\'aliments';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'Per a cada categoria de producte, s\'estableix una puntuació **de referència** utilitzant dades de la base de dades ambiental Agribalyse (dissenyada per ADEME i INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      'L\'anàlisi del cicle de vida és un mètode d\'avaluació estandarditzat per dur a terme una avaluació ambiental multietapa i multicriteri.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Mesura:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 passos de producció';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Agricultura';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Processament';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Empaquetament';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Transport';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Distribució';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Consum';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 indicadors d\'impacte ambiental';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Canvi climàtic/petjada de carboni';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Esgotament de la capa d\'ozó';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Radiació ionitzant';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Terra';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Ús d\'aigua i energia';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'contaminació de l\'aire';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Aigua marina i dolça (partícules, acidificació, eutrofització)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Esgotament de recursos.';

  @override
  String get guide_greenscore_bonuses_penalties_title =>
      'Bonificacions i penalitzacions';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'To reward better products within a category, we then apply **bonuses & penalties based on several criterion**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Mode de producció';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      'A **bonus** is awarded to products that have an **official label, a label or a certification that guarantees environmental benefits** (organic, fair trade, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Origen dels ingredients';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      'A **bonus** is awarded based on the origin of the ingredients. This bonus takes into account the **impact on transportation** and also the **environmental policy** of each producer\'s country.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Espècies en perill d\'extinció';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'A **penalty** is given to products that contain ingredients that have significant **negative impacts on biodiversity and ecosystems**, such as palm oil, the production of which is responsible for massive deforestation.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Empaquetament';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'A **penalty** is calculated to take into account the **circularity of packaging** (use of recycled raw material and recyclability) and overpacking.';

  @override
  String get guide_greenscore_transparency_title =>
      'Augment de la necessitat de transparència per mesurar i reduir millor els impactes ambientals';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'To accurately calculate the Green-Score, it is necessary to have **information which is not necessarily specified on the packaging** (such as the origin and the exact percentage of each ingredient) or which is rarely available in usable form (such as a list of all the components of the packaging with the precise types of plastics used).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Average values are used when this information is not yet available**, but we are now calling on everyone to help us collect this information which will be very useful for the Green-Score but also for many other uses.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'How citizens can help?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'All citizens can help us gather and structure the information that is present on products or that can be deduced from them, such as information on **packaging**: \"Mission Emballages\": a large-scale collaborative inventory of packaging for all food products (in French).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Com poden ajudar els fabricants';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Els fabricants ens poden enviar la seva informació directament a través de la nostra plataforma gratuïta per a productors.';

  @override
  String get guide_greenscore_better_product_title =>
      'Quin producte és millor per al planeta?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Pot ser difícil de dir';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Triar aliments sostenibles és una de les coses més poderoses que podem fer pel clima, ja que **el nostre sistema alimentari global és responsable de més d\'una quarta part de totes les emissions de gasos d\'efecte hivernacle**.\n(Font: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Tu tens el poder!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'La bona notícia és que això ens dóna una manera poderosa de crear canvis.\n**Cadascun de nosaltres menja uns 1.000 àpats cada any**. Això són 1.000 oportunitats per **triar un futur millor per al planeta**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Ajuda a ser responsable i a decidir';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Triar aliments sostenibles pot semblar complex. Les etiquetes són confuses i sovint falta informació. El Green-Score es va crear per simplificar-ho, donant-vos una qualificació ambiental **clara**, **basada en la ciència** i **transparent** per als productes alimentaris, just on la necessiteu: mentre compreu.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Transparència';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'A diferència de les etiquetes pròpies, el càlcul de Green-Score és **completament obert** i qualsevol persona pot **verificar-lo**.';

  @override
  String get guide_nova_title => 'Aliments ultraprocessats';

  @override
  String get guide_nova_what_is_nova_title => 'Què és l\'ultraprocessament?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Els grups NOVA us informen sobre el nivell de processament d\'aliments.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'La classificació NOVA permet la categorització dels aliments en **4 grups** segons el seu **grau de processament industrial** (aliments mínimament processats o no processats, ingredients culinaris, aliments processats, aliments ultraprocessats).';

  @override
  String get guide_nova_logos_caption => 'Els logotips de NOVA';

  @override
  String get guide_nova_groups_title => 'Els 4 grups NOVA';

  @override
  String get guide_nova_groups_intro =>
      'Hi ha 4 grups NOVA, i el problemàtic és el Grup 4: aliments ultraprocessats.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Aliments mínimament processats o sense processar';

  @override
  String get guide_nova_groups_arg1_text =>
      'Unprocessed (or natural) foods are the **edible parts of plants** (seeds, fruits, leaves, stems, roots) **or animals** (muscle, offal, eggs, milk), as well as fungi, algae, and water, after being separated from nature.';

  @override
  String get guide_nova_groups_arg2_title => 'Ingredients culinaris processats';

  @override
  String get guide_nova_groups_arg2_text =>
      'Processed culinary ingredients, such as **oils, butter, sugar, and salt**, are substances derived from group 1 foods or from nature through processes that include pressing, refining, grinding, milling, and drying.';

  @override
  String get guide_nova_groups_arg3_title => 'Aliments processats';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. processes Include various preservation or cooking Methods, and In the case of breads and cheese, non-alcoholic fermentation. most processed foods have two or three ingredients and are recognizable as Modified versions of group 1 foods. they can be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Aliments ultraprocessats';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 food. Ingredients in these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-processed Products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are directly Extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title =>
      'Els problemes amb l\'ultraprocessament';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Processament extrem d\'ingredients alimentaris';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Many are **derived from further processing of food constituents**, such as hydrogenated or interesterified oils, hydrolyzed proteins, soy protein isolate, maltodextrin, invert sugar, and high-fructose corn syrup.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Additius que van més enllà de la pura seguretat alimentària';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Additives in ultra-processed foods include some that are also used in processed foods, such as preservatives, antioxidants, and stabilizers. Classes of additives found only in ultra-processed products include those used **to imitate or enhance the sensory qualities of foods or to disguise unpalatable aspects of the final product**. These additives include dyes and other colors, color stabilizers; flavors, flavor enhancers, non-sugar sweeteners; and processing aids such as carbonating, firming, bulking and anti-bulking agents, de-foaming, anti-caking and glazing agents, emulsifiers, sequestrants, and humectants.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Processament que no pots fer a casa';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**A multitude of sequences of processes is used** to combine the usually many ingredients and to create the final product (hence \'ultra-processed\'). The processes include several **with no domestic equivalents**, such as hydrogenation and hydrolysation, extrusion and moulding, and pre-processing for frying.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Els aspectes depredadors i financers de l\'ultraprocessament';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**The overall purpose of ultra-processing is to create branded**, **convenient** (durable, ready to consume), **attractive** (hyper-palatable) and **highly profitable** (low-cost ingredients) food products designed to displace all other food groups. Ultra-processed food products are usually packaged attractively and marketed intensively.';

  @override
  String get guide_nova_explanations_arg5_title => 'A health hazard';

  @override
  String get guide_nova_explanations_arg5_text =>
      'Since 2018, with NutriNet-Santé, the first links between **the consumption of ultra-processed foods and increased risks of cancer, cardiovascular diseases, and diabetes have been highlighted**. Today, more than 90 studies worldwide confirm these findings.\nThe strongest associations relate to **obesity, cardiovascular mortality, and depressive symptoms**. On children, the effects are primarily observed on weight and lipid imbalances.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Countries recommend limiting them';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Some countries use the NOVA groups for their dietary guidelines or goals, for instance:\n\n- **🇧🇷 Brazil**\'s dietary guidelines **recommend to limit consumption** of processed food and avoid ultra-processed food.\n\n- **🇫🇷 France**\'s public health nutritional policy goals for 2018-2022 aims to **reduce consumption of group 4 ultra-processed foods by 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-ca.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Welcome to Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'What is Open Food Facts?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts is a **collaborative**, **free**, and **open** database of food products from around the world.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'We believe that everyone should have access to information about what they eat. By collecting data on ingredients, allergens, nutrition facts, and more, **we empower consumers to make informed choices** and drive the food industry **toward greater transparency**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Features of Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_food_facts_tips_title => 'Tips for taking great photos';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 => 'Avoid busy backgrounds.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Help us build the \"Wikipedia of Food\"';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'A score on the nutritional quality';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'A score to avoid ultra-processed foods';

  @override
  String get guide_open_food_facts_scores_arg3_title =>
      'A score for the planet';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-ca.openfoodfacts.org/descobrir';

  @override
  String get guide_open_pet_food_facts_title =>
      'Welcome to Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'What is Open Pet Food Facts?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts extends our mission to our furry friends! It\'s a **database of pet food products for cats, dogs, and other companions**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'We gather information on **ingredients**, **nutritional analysis**, and feeding guidelines to help pet owners choose the best food for their animals\' needs.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Features of Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Is your pet allergic to any ingredients? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_pet_food_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Developing a scoring system for pet food **is not a priority right now**. The methodology would be complex, as nutritional needs vary greatly by species, age, and health condition. We haven’t found any independant scientific team yet, able to develop such a score.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-ca.openpetfoodfacts.org/descobrir';

  @override
  String get guide_open_beauty_facts_title => 'Welcome to Open Beauty Facts!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'What is Open Beauty Facts?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts is a collaborative database of **cosmetic products**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Our goal is to decipher ingredient lists to help you **understand what\'s in your personal care items**. From moisturizers to makeup, we collect data on ingredients, allergens, and packaging to promote transparency in the cosmetics industry.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Features of Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Get alerts for your unwanted ingredients';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Are you allergic to any ingredients? Want to avoid comedogen substances? Want to steer away from controversial components ? You can set a list of cosmetic ingredients to avoid, right in the app!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Tips for taking great photos';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Don’ts';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Avoid shadows and glare.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'No blurry or out-of-focus text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Don\'t crop out parts of the text.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Avoid busy backgrounds.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Do’s';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Use good, even lighting.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Ensure text is sharp and readable.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Capture the entire ingredients list.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Take as many picture as need if the bottle is curved.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'You might need to peel the label to see the list of ingredients.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Keep the product on a flat surface.';

  @override
  String get guide_open_beauty_facts_scores_title => 'A note on scoring';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'Unlike food products, the world of cosmetics **does not have a universally recognized, government-backed scoring system like the Nutri-Score**. Ingredient effects can be highly personal and depend on skin type, allergies, and individual concerns.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-ca.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Welcome to Open Prices!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'What is Open Prices?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices is a project to **collect and share prices of products around the world**. It\'s a publicly available dataset that can be used for research, analysis, and more. Open Prices is developed and maintained by Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'How does Open Prices work?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**We are crowdsourcing an open-source dataset of prices**. Prices can be added by users via this web app, or via the official Open Food Facts mobile app. Retailers or third-party apps can contribute as well by using our API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Collect photos of price tags in aisles';

  @override
  String get guide_open_prices_how_arg2_title => 'Collect photos of receipts';

  @override
  String get guide_open_prices_why_title =>
      'Why is Open Food Facts doing this ?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Price information is of paramount importance to understand food systems. It\'s a key factor in understanding the cost of food and to promote healthier diets. Opening price data is a way to make it easier for researchers, journalists, and citizens to **have a better understanding of how food prices vary geographically and in time**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Track the evolution of prices over time';

  @override
  String get guide_open_prices_why_arg1_text =>
      'See the **evolution of prices**: shrinkflation, cheapflation, we can track them together!';

  @override
  String get guide_open_prices_why_arg2_title => 'Compare prices near you';

  @override
  String get guide_open_prices_why_arg2_text =>
      'As we get more prices, you can spot **the cheapest stores around you**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Did you consider scraping prices from retailers\' websites?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'For legal and technical reasons, **we don\'t consider scraping prices from retailers\' websites as a valid way to contribute to Open Prices**. We want to make sure that the prices we collect are accurate and up-to-date, and receiving scraped prices from contributors doesn\'t allow us to do that.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Price scraping is a considered option in a future version of Open Prices, but it would be done by Open Prices itself so that we can have a proof of the price based on the HTML page.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'You can contribute prices by using our API.\nIf you want to contribute prices at scale, please get in touch with us at prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Welcome to Open Products Facts!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'What is Open Products Facts?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts is a massive, open database for **any product with a barcode, which is not food, cosmetic or pet food**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'From **electronics** to **toys**, and **clothes** to **cleaning supplies**, if it has a barcode, it can be added. This project aims to create an \"Internet of Things\" for everyday objects, making information about them universally accessible.';

  @override
  String get guide_open_products_facts_features_title =>
      'Features of Open Products Facts';

  @override
  String get guide_open_products_facts_features_text =>
      'Open Products Facts aims to provide consumers to **extend the life of objects** by providing the circular solutions to maintain, **repair**, **recycle** their objects or give them a new owner.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Carbon footprints for some products';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Impact CO2** by French Environment Authority ADEME provides the **carbon impact** of many categories, make sure to categorize products precisely.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Reparability index for many products';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Whenever a French reparability index is available, we’ll display it. Moreover, **you can start collecting the variables using the Folksonomy Engine**; so that we can recompute it ourselves in the future, even in countries where it’s not available.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Find ways to donate/resell your product';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'We provide links to **third party circular friendly services** that help you get the kind of product you’re looking for, as a second hand product, to be more gentle on planetary resources.\nNote that we’re not paid to do that, and that the system only works as an example for two websites in France. You can help expand this system by documenting more sites on the wiki.';

  @override
  String get guide_open_products_facts_information_title =>
      'What information is useful?';

  @override
  String get guide_open_products_facts_information_text =>
      'For such a wide range of items, **the data we collect is flexible**. To do that, **we created the Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'The Folksonomy Engine';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'The Folksonomy Engine is a tool to help you complete products with relevant properties. This helps improve search and discoverability, but also compute and display interesting things in the future.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'You can add any keys and values like: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'You’ll get autosuggestion of possible properties, and you are very welcome to add and document new ones on your favorite kinds of products.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-ca.openproductsfacts.org/descobrir';

  @override
  String get guide_open_preferences_button_title => 'Open food preferences';

  @override
  String get guide_coming_soon_button_title => 'Coming soon';

  @override
  String get guide_learn_more_subtitle => 'Tap to learn more';

  @override
  String get preview_badge => 'Preview';

  @override
  String get prices_feedback_form =>
      'Click here to send us your feedback about this new feature!';

  @override
  String get menu_button_list_actions => 'Select an action';

  @override
  String get error_loading_photo => 'Error loading photo';

  @override
  String get photo_viewer_action_use_picture_as => 'Use as…';

  @override
  String get photo_viewer_use_picture_as_tooltip => 'Use this picture as…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Use this picture as… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Details';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Details of this photo';

  @override
  String get photo_viewer_details_title => 'Details of the photo';

  @override
  String get photo_viewer_details_contributor_title => 'Voluntari/a';

  @override
  String get photo_viewer_details_size_title => 'Size';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height pixels';
  }

  @override
  String get photo_viewer_details_date_title => 'Data';

  @override
  String get photo_viewer_details_url_title => 'URL';

  @override
  String get product_page_compatibility_score => 'Compatible';

  @override
  String get user_lists_action_multi_select => 'Multi-select';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Your compatibility score: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Imatge frontal';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Imatge dels ingredients';

  @override
  String get product_image_nutrition_accessibility_label => 'Nutrition picture';

  @override
  String get product_image_packaging_accessibility_label => 'Packaging picture';

  @override
  String get product_image_other_accessibility_label => 'Other picture';

  @override
  String get product_image_outdated_message => 'This picture may be outdated';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (this image may be outdated)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (this image may be locked by the producer)';
  }

  @override
  String get product_image_error => 'Unable to load the image!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Unable to load the $type (network error?)';
  }

  @override
  String get product_page_image_no_image_available => 'No\nimage!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'No picture available for this product';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Reorder or hide actions';

  @override
  String get product_page_action_bar_setting_modal_title => 'Edit actions';

  @override
  String get product_page_action_bar_item_move_up => 'Move up';

  @override
  String get product_page_action_bar_item_move_down => 'Move down';

  @override
  String get product_page_action_bar_item_enable => 'Enable action';

  @override
  String get product_page_action_bar_item_disable => 'Disable action';

  @override
  String get product_page_pending_operations_banner_title =>
      'Uploading your edits…';

  @override
  String get product_page_pending_operations_banner_message =>
      'The data displayed on this page **does not yet reflect your modifications**.\nPlease wait a few seconds…';

  @override
  String get product_add_a_language => 'Add a language';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Barcode $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Remove this product from the carousel';

  @override
  String get carousel_unsupported_header => 'Unsupported barcode!';

  @override
  String get carousel_unsupported_title => 'Ooops!';

  @override
  String get carousel_unsupported_text =>
      'The barcode scanned is not supported by Open Food Facts!';

  @override
  String get carousel_error_header => 'Error!';

  @override
  String get carousel_error_title => 'It\'s a bummer!';

  @override
  String get carousel_error_text_1 =>
      'We couldn\'t download information on this barcode:';

  @override
  String get carousel_error_text_2 =>
      'Please check your Internet connection or click this button:';

  @override
  String get carousel_error_button => 'Torna a provar';

  @override
  String get carousel_unknown_product_header => 'Unknown product';

  @override
  String get carousel_unknown_product_title =>
      'Congratulations!\nYou\'ve found __the rare gem!__';

  @override
  String get carousel_unknown_product_text =>
      'Our collaborative database contains more than **3 million products**, but this barcode doesn\'t exist: ';

  @override
  String get carousel_unknown_product_button => 'Afegir aquest producte';

  @override
  String get carousel_loading_header => 'Loading information...';

  @override
  String get carousel_loading_title =>
      'You\'ve just scanned a product with the following barcode:';

  @override
  String get carousel_loading_text =>
      'We are searching for it in our database of more than **3 million products!**';

  @override
  String get product_type_subtitle_food => 'Vegetables, fruits, frozen food…';

  @override
  String get product_type_subtitle_beauty => 'Makeup, soaps, toothpastes…';

  @override
  String get product_type_subtitle_pet_food => 'Food for dogs, cats…';

  @override
  String get product_type_subtitle_product => 'Smartphones, furniture…';

  @override
  String get photo_field_front => 'Product photo';

  @override
  String get photo_field_ingredients => 'Foto dels ingredients';

  @override
  String get photo_field_nutrition => 'Nutrition photo';

  @override
  String get photo_field_packaging => 'Foto de la informació de l\'embolcall';

  @override
  String get photo_already_exists => 'This photo already exists';

  @override
  String get photo_missing => 'This photo is missing';

  @override
  String get date => 'Data';

  @override
  String get photo_rotate_left => 'Gira a l\'\'esquerra';

  @override
  String get photo_rotate_right => 'Gira a la dreta';

  @override
  String get photo_undo_action => 'Undo the previous action';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'A world map of $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'OpenStreetMap contributors';

  @override
  String get not_applicable_short => 'N/A';

  @override
  String get knowledge_panel_warning_text => 'Avís';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Why is this Nutri-Score different from the one on the package?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'There are two possible explanations:\nThe list of ingredients and/or nutrition facts are not up-to-date.\n\nWe provide the \"New calculation\" of the Nutri-Score (or V2). Please check that you have the banner \"New calculation\" on the package.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Check ingredients';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Check nutrition facts';

  @override
  String url_not_supported(String url) {
    return 'Unfortunately, we can\'t open the URL:\n$url';
  }

  @override
  String get product_list_export => 'Export';

  @override
  String get product_list_import => 'Import';

  @override
  String get product_footer_action_barcode => 'View barcode';

  @override
  String get product_footer_action_barcode_short => 'Codi de barres';

  @override
  String get product_footer_action_open_website => 'Open website';

  @override
  String get product_footer_action_report => 'Report';

  @override
  String get product_footer_action_contributor_guide => 'Help';

  @override
  String get product_footer_action_data_quality_tags => 'Data quality';

  @override
  String get product_page_tab_for_me => 'Per a mi';

  @override
  String get product_page_tab_website => 'Lloc web';

  @override
  String get product_page_tab_prices => 'Preus';

  @override
  String get prices_explanation_card_title => 'Per què els preus?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** és un projecte per recopilar i compartir preus de productes d\'arreu del món 🌍. Open Prices està desenvolupat i mantingut per Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Saber-ne més';

  @override
  String get product_page_tab_folksonomy => 'Folksonomy';

  @override
  String get folksonomy_explanation_card_title =>
      'Quins són els atributs de la folksonomia?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Els atributs es basen en **valor-clau**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Aquestes propietats són creades i arxivades pels col·laboradors per a qualsevol tipus d\'ús.';

  @override
  String get folksonomy_action_external_link_title => 'Open external link';

  @override
  String get folksonomy_action_external_link_warning =>
      'External links may be unsafe. Do you really want to visit it?';

  @override
  String get prices_products_empty_title => 'No hi ha preu disponible';

  @override
  String get prices_products_empty_explanation =>
      'Sigues el primer a contribuir!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Top $pageSize products (total: $total)';
  }

  @override
  String get app_review_title => 'Are you enjoying this app?';

  @override
  String get app_review_low => 'Could do better';

  @override
  String get app_review_medium => 'Not bad';

  @override
  String get app_review_high => 'I love it!';

  @override
  String get app_review_feedback_modal_title =>
      'Help us improve our application';

  @override
  String get app_review_feedback_modal_content =>
      'If you have a few minutes, could you answer this form so that **we can improve in future updates**:';

  @override
  String get app_review_feedback_modal_open_form => 'Answer the form';

  @override
  String get app_review_feedback_modal_later => 'Pregunta-m\'ho després';

  @override
  String get nutrition_facts_extract_new =>
      'NEW: You can automatically extract the nutrients from the picture!';

  @override
  String get nutrition_facts_extract_button_text => 'Extract now';

  @override
  String get nutrition_facts_extract_in_progress => 'Extracció en curs…';

  @override
  String get nutrition_facts_extract_successful => 'Extracció correcta';

  @override
  String get nutrition_facts_extract_failed =>
      'Failed to extract nutrients from picture';

  @override
  String get prices_discount => 'Descompte';

  @override
  String get prices_stats_statistics => 'Statistics';

  @override
  String get prices_stats_title => 'Prices Statistics';

  @override
  String get prices_stats_prices_section => 'Preus';

  @override
  String get prices_stats_products_section => 'Productes';

  @override
  String get prices_stats_locations_section => 'Locations';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Contribuents';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Miscel·lània';

  @override
  String get prices_stats_total => 'Total';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Consum';

  @override
  String get prices_stats_with_price => 'With a price';

  @override
  String get prices_stats_food => 'Menjar';

  @override
  String get prices_stats_beauty => 'Bellesa';

  @override
  String get prices_stats_products => 'Productes';

  @override
  String get prices_stats_pet_food => 'Menjar per a mascotes';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Països';

  @override
  String get prices_stats_price_tag => 'Price tag';

  @override
  String get prices_stats_receipt => 'Receipt';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Lloc web';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Altres';

  @override
  String get prices_stats_last_updated => 'Last updated on';

  @override
  String get prices_stats_error =>
      'An error occurred while loading statistics.';

  @override
  String get product_edit_robotoff_question_answered => 'Question answered!';

  @override
  String get product_edit_robotoff_proof => 'Prova';

  @override
  String get preferences_card_general => 'General';

  @override
  String get preferences_prices_title => 'Preus';

  @override
  String get preferences_prices_subtitle =>
      'Gestiona les teves preferències de preus';

  @override
  String get preferences_card_project => 'El projecte Open Food Facts';

  @override
  String get preferences_contribute_title => 'Contribuir';

  @override
  String get preferences_my_contributions_title => 'Les meves aportacions';

  @override
  String get preferences_my_stats_title => 'Les meves estadístiques';

  @override
  String get preferences_contribute_subtitle =>
      'Tradueix, millora les nostres eines…';

  @override
  String get preferences_connect_title => 'Connecta';

  @override
  String get preferences_connect_subtitle =>
      'Contacta\'ns o segueix-nos a les xarxes socials';

  @override
  String get preferences_support_title => 'Fes una donació';

  @override
  String get preferences_support_subtitle =>
      'Ajudeu-nos a informar milions de consumidors arreu del món';

  @override
  String get preferences_card_help => 'Ajuda i assistència';

  @override
  String get preferences_faq_title => 'PMF';

  @override
  String get preferences_faq_subtitle =>
      'Obtén respostes a les teves preguntes';

  @override
  String get logged_out => 'Sessió tancada';

  @override
  String get preferences_app_bar_message =>
      'Gràcies per ser un dels nostres membres!';

  @override
  String get preferences_app_bar_products_modified => 'Productes modificats';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats =>
      'Veure totes les estadístiques';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Cerca $provider per \"$keyword\"';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Cerca una configuració (per exemple, Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Accessibilitat: Mostra emojis';

  @override
  String get preferences_accessibility_remove_colors =>
      'Accessibilitat: Elimina els colors';

  @override
  String get preferences_app_settings_products => 'Productes';

  @override
  String get preferences_card_about => 'Quant a';

  @override
  String get preferences_legal_information_title => 'Informació legal';

  @override
  String get preferences_legal_information_subtitle =>
      'Condicions d\'ús, política de privadesa i més';

  @override
  String get preferences_terms_of_use => 'Condicions d\'ús';

  @override
  String get preferences_legal_mentions => 'Legal mentions';

  @override
  String get preferences_legal_header =>
      'Open Food Facts és una base de dades de productes alimentaris **feta per tothom, per a tothom**.\nLa podeu utilitzar per prendre millors decisions alimentàries i, com que són **dades obertes**, tothom la pot **reutilitzar per a qualsevol propòsit**.';

  @override
  String get preferences_privacy_policy => 'Privacy policy';

  @override
  String get preferences_licenses => 'Llicències';

  @override
  String get preferences_about_app_title => 'Sobre l\'aplicació';

  @override
  String get preferences_about_app_subtitle =>
      'Informació tècnica, informació per a desenvolupadors i més';

  @override
  String get preferences_card_information => 'Informació';

  @override
  String get preferences_version_number_title => 'Número de versió';

  @override
  String get preferences_scanner_title => 'Escàner';

  @override
  String get preferences_app_store => 'Botiga d\'aplicacions';

  @override
  String get preferences_app_system_settings => 'Configuració del sistema';

  @override
  String get preferences_source_code => 'Accedir al codi font';

  @override
  String get preferences_source_code_subtitle =>
      'I comença a tenir un impacte per a milions de persones';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Expliqueu-ho al món';

  @override
  String get preferences_tips => 'Consells';

  @override
  String get tips_discover_nutriscore => 'Descobreix el nou Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'Al lloc web Open Food Facts';

  @override
  String get preferences_manage_account_title => 'Gestiona el meu compte';

  @override
  String get preferences_manage_account_tooltip => 'Gestiona el teu compte';

  @override
  String get preferences_change_password_title => 'Canvia la meva contrasenya';

  @override
  String get preferences_danger_zone => 'Zona de perill';

  @override
  String get preferences_account_deletion_subtitle =>
      'Totes les teves contribucions es perdran';

  @override
  String get preferences_contributions_title => 'Aportacions';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Configuració de l\'aplicació';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Una manera molt experimental d\'escanejar productes fora de línia';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Actualitza tots els productes del servidor';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Si us plau, eviteu fer això si no és absolutament necessari.';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Mode de demostració';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Afegir targetes a l\'escàner';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Afegeix 3 productes de mostra a l\'escàner';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Amfitrió de folksonomia';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Amfitrió: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Experiments d\'accessibilitat';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Selecció de diversos productes per preus';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Panells de coneixement ordenats per l\'usuari';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Accés temporal a la cerca d\'ubicacions';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Comparació paral·lela de 2 o 3 productes';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Importació de la llista de productes';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Puntuacions i metodologies';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Descobreix com es calcula el Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Descobreix els principals canvis en la metodologia';

  @override
  String get preferences_faq_discover_project_title => 'Descobreix el projecte';

  @override
  String get preferences_faq_discover_off_title =>
      'Descobreix els fets sobre menjar obert';

  @override
  String get preferences_faq_discover_obf_title => 'Discover Open Beauty Facts';

  @override
  String get preferences_faq_discover_opff_title =>
      'Discover Open Pet Food Facts';

  @override
  String get preferences_faq_discover_op_title => 'Discover Open Prices';

  @override
  String get preferences_faq_discover_opf_title =>
      'Discover Open Products Facts';

  @override
  String get preferences_faq_faq_title => 'Preguntes freqüents';

  @override
  String get preferences_faq_off_ngo_title => 'L\'ONG Open Food Facts';

  @override
  String get preferences_about_information_title => 'Informació';

  @override
  String get preferences_connect_community_updates_title =>
      'Rep actualitzacions de la comunitat';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Estigues al dia de les notícies de l\'aplicació i la comunitat';

  @override
  String get preferences_connect_community_calendar_title =>
      'Subscribe to our community calendar';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Participa assistint a un dels nostres esdeveniments virtuals';

  @override
  String get preferences_connect_blog_title => 'El blog Open Food Facts';

  @override
  String get preferences_connect_blog_subtitle =>
      'Rep les darreres notícies a mesura que es produeixen';

  @override
  String get preferences_connect_community_help_title =>
      'Obtén ajuda de la comunitat';

  @override
  String get preferences_connect_improve_app_title =>
      'Ajuda\'ns a millorar l\'aplicació';

  @override
  String get preferences_connect_debug_info_title =>
      'Envia\'ns informació de depuració';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Envieu-nos un correu electrònic amb informació detallada de depuració';

  @override
  String get preferences_connect_feedback_title =>
      'Envia\'ns comentaris sobre l\'aplicació';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Ajuda a donar forma al futur de l\'aplicació';

  @override
  String get preferences_connect_survey_title =>
      'Respon l\'enquesta de l\'aplicació';

  @override
  String get preferences_connect_survey_subtitle =>
      'Ajuda\'ns a entendre què hem de construir a continuació';

  @override
  String get preferences_connect_professionals_title => 'Professionals';

  @override
  String get preferences_connect_pro_subtitle =>
      'Totalment gratuït, garanteix dades precises per a 500 aplicacions i milions de consumidors. Autoservei, compatible amb el vostre PIM o fulls de càlcul (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Poseu-vos en contacte per començar';

  @override
  String get preferences_connect_press_title => 'Premsa';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Obtén tot el material que necessites per al teu informe';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Poseu-vos en contacte amb nosaltres per a consultes de premsa o per informar-nos sobre el vostre informe';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Fes-te voluntari/ària actiu/va';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Desenvolupament, Comunicació, Disseny… qualsevol tipus de voluntariat o experiència és benvinguda!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Descobreix algunes de les moltes maneres en què pots contribuir';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Desenvolupament d\'aplicacions mòbils';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Aprèn a contribuir al desenvolupament de programari';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Compilacions inestables diàries, funcions completament noves';

  @override
  String get preferences_contribute_local_community_title =>
      'Fes créixer la teva comunitat local';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Ajuda amb programari, continguts, traduccions d\'anàlisi d\'ingredients';

  @override
  String get preferences_contribute_share_subtitle =>
      'Hem preparat una petita plantilla per ajudar-vos :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Passos senzills per augmentar la transparència alimentària al vostre país';

  @override
  String get preferences_contribute_data_quality_title => 'Data quality';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Uneix-te a l\'equip de qualitat de dades';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Uneix-te al nostre esforç per garantir que la base de dades sigui completa i precisa';

  @override
  String get preferences_contributions_products_added_title =>
      'Productes afegits';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Nous productes que he afegit a Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Productes que he de completar';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Tots els productes incomplets';

  @override
  String get preferences_my_contributions_prices_title => 'Preus';

  @override
  String get preferences_my_contributions_my_prices_title => 'My prices';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Els meus preus, les meves proves…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Productes que pots ajudar a completar';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Ajuda a calcular el Nutri-Score i el Green-Score al teu país';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Preus que vaig aportar';

  @override
  String get preferences_prices_proofs_subtitle => 'Etiquetes de preu i rebuts';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Fes fotos dels teus rebuts i escaneja els codis de barres associats';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Fes fotos dels preus en una botiga';

  @override
  String get preferences_prices_newest_title => 'Preus més nous';

  @override
  String get preferences_prices_newest_subtitle =>
      'Últims preus afegits per la comunitat Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Contribuents amb més preus';

  @override
  String get preferences_prices_metrics_title =>
      'Mètriques de preu d\'obertura';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Segueix l\'evolució del projecte';

  @override
  String get preferences_prices_ways_contribute_title =>
      'Maneres de contribuir';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Confirma els preus afegits per tu mateix o per altres persones, amb l\'ajuda de la IA';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Afegeix ràpidament molts rebuts o fotos de prestatges del teu carret de càmera';

  @override
  String get preferences_prices_challenges_title => 'Reptes mensuals';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Participa en missions temàtiques mensuals per aconseguir preus.';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Reclama les teves dades de fidelització';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Aprèn com sol·licitar les teves dades';

  @override
  String get preferences_page_customize_app_title =>
      'Personalitza l\'aplicació';

  @override
  String get preferences_page_contribute_project_title =>
      'Contribueix al projecte';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Maneres senzilles d\'ajudar a Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Metodologies de puntuació, ajuda i més informació sobre el projecte';

  @override
  String get product_edit_robotoff_positive_button => 'Accepta el suggeriment';

  @override
  String get product_edit_robotoff_negative_button => 'Rebutja el suggeriment';

  @override
  String get product_edit_robotoff_show_proof => 'Mostrar proves';

  @override
  String get product_edit_robotoff_expand_proof => 'Ampliar la prova';

  @override
  String get product_page_tab_raw_data => 'Dades en brut';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Pàgina $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Pàgina $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count de $total elements';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count de $total elements';
  }

  @override
  String item_count(int count) {
    return '$count elements';
  }

  @override
  String item_count_string(String count) {
    return '$count elements';
  }

  @override
  String get prices_no_result => 'No s\'han trobat estadístiques de preus.';

  @override
  String get prices_error_loading_more_items =>
      'S\'ha produït un error en carregar més elements';

  @override
  String get prices_proof_error =>
      'L\'autenticació ha fallat, no s\'han pogut obtenir proves';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count de $total proves';
  }

  @override
  String proof_count(int count) {
    return '$count proofs';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count de $total col·laboradors';
  }

  @override
  String contributors_count(int count) {
    return '$count contributors';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count de $total ubicacions';
  }

  @override
  String prices_locations_count(int count) {
    return '$count ubicacions';
  }

  @override
  String get restart_to_apply_message =>
      'Reinicieu l\'aplicació per aplicar els canvis.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Interfície gràfica';

  @override
  String get preferences_app_settings_media_title => 'Mitjans de comunicació';

  @override
  String get preferences_about_app_development_title => 'Desenvolupament';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Laboratoris oberts d\'informació sobre aliments';

  @override
  String get preferences_root_account_title => 'Compte';

  @override
  String get preferences_contribute_translate_header =>
      'Porta Open Food Facts al teu idioma';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Inscriu-te a la versió alfa de l\'aplicació';

  @override
  String get preferences_dev_mode_section_data =>
      'Contribucions i dades de producte';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'No mostrar folksonomia';

  @override
  String get preferences_account_title => 'Compte';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Afegit a $created';
  }

  @override
  String get location_map_details_title => 'Location details';

  @override
  String get location_map_details_name => 'Nom';

  @override
  String get location_map_details_street => 'Street';

  @override
  String get location_map_details_city => 'City';

  @override
  String get location_map_details_postcode => 'Postcode';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Coordinates';

  @override
  String get location_map_details_osm_id => 'OSM ID';
}
