// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Bulgarian (`bg`).
class AppLocalizationsBg extends AppLocalizations {
  AppLocalizationsBg([String locale = 'bg']) : super(locale);

  @override
  String get app_name => 'Open Food Facts';

  @override
  String get sep => '';

  @override
  String get yes => 'Да';

  @override
  String get add => 'Добави';

  @override
  String get account_delete_message =>
      'Сигурен ли си, че искаш да изтриеш акаунта си?\nАко има конкретна причина, моля сподели по-долу';

  @override
  String get reason => 'Причина';

  @override
  String get okay => 'Добре';

  @override
  String get validate => 'Потвърди';

  @override
  String get create => 'Създай';

  @override
  String get applyButtonText => 'Приложи';

  @override
  String get next_label => 'Следваща';

  @override
  String get continue_label => 'Продължи';

  @override
  String get exit_label => 'Изход';

  @override
  String get previous_label => 'Предишна';

  @override
  String get go_back_to_top => 'Върни се горе';

  @override
  String get save => 'Запис';

  @override
  String get save_confirmation => 'Сигурен ли си, че искаш да запазиш?';

  @override
  String get skip => 'Пропусни';

  @override
  String get cancel => 'Отмени';

  @override
  String get ignore => 'Игнорирай';

  @override
  String get close => 'Затвори';

  @override
  String get no => 'Не';

  @override
  String get stop => 'Спри';

  @override
  String get finish => 'Край';

  @override
  String get calculate => 'Изчисли';

  @override
  String get reset_food_prefs => 'Нулиране на хранителните предпочитания';

  @override
  String get error => 'Нещо се обърка';

  @override
  String get error_occurred => 'Възникна грешка';

  @override
  String get featureInProgress => 'Все още работим по тази функция, следвай ни';

  @override
  String get label_web => 'Преглед в интернет';

  @override
  String get learnMore => 'Научи повече';

  @override
  String get unknown => 'Неизвестно';

  @override
  String get match_very_good => 'Много добро съвпадение';

  @override
  String get match_good => 'Добро съвпадение';

  @override
  String get match_poor => 'Лошо съвпадение';

  @override
  String get match_may_not => 'Може да не съвпада';

  @override
  String get match_does_not => 'Не съвпада';

  @override
  String get match_unknown => 'Неизвестно съвпадение';

  @override
  String get match_short_very_good => 'Много добро съвпадение';

  @override
  String get match_short_good => 'Добро съвпадение';

  @override
  String get match_short_poor => 'Лошо съвпадение';

  @override
  String get match_short_may_not => 'Може да не съвпада';

  @override
  String get match_short_does_not => 'Не съвпада';

  @override
  String get match_short_unknown => 'Неизвестно съвпадение';

  @override
  String get licenses => 'Лицензи';

  @override
  String get looking_for => 'Какво търсиш';

  @override
  String get welcomeToOpenFoodFacts => 'Добре дошъл в Open Food Facts';

  @override
  String get whatIsOff =>
      'Open Food Facts е глобална организация с нестопанска цел, захранвана от местни общности.';

  @override
  String get productDataUtility =>
      'Виж информация за храната, която отговаря на твоите предпочитания.';

  @override
  String get healthCardUtility => 'Избери храни, които са полезни за теб.';

  @override
  String get ecoCardUtility => 'Избери храни, които са полезни за планетата.';

  @override
  String get server_error_open_new_issue =>
      'Няма отговор от сървъра! Можете да отворите проблем със следния линк.';

  @override
  String get sign_in_text =>
      'Влез в акаунта си в Open Food Facts, за да запазиш приноса си';

  @override
  String get incorrect_credentials => 'Грешно потребителско име или парола.';

  @override
  String get password_lost_incorrect_credentials =>
      'Този имейл или потребителско име не съществува. Моля, проверете идентификационните си данни.';

  @override
  String get password_lost_server_unavailable =>
      'В момента наблюдаваме забавяне на сървърите ни и се извиняваме за това. Моля, опитайте отново по-късно.';

  @override
  String get login => 'Потребителско име';

  @override
  String get login_result_type_server_unreachable => 'Мрежата е недостъпна';

  @override
  String get login_result_type_server_issue =>
      'Проблем на сървъра. Моля, опитай по-късно.';

  @override
  String get login_page_username_or_email =>
      'Моля, въведи потребителско име или имейл';

  @override
  String get login_page_password_error_empty => 'Моля, въведи парола';

  @override
  String get create_account => 'Създаване на акаунт';

  @override
  String get sign_in => 'Вход';

  @override
  String get sign_in_mandatory =>
      'За тази функция трябва да влезеш в своя профил.';

  @override
  String get help_improve_country =>
      'Помогнете за подобряването на Open Food Facts във вашата страна';

  @override
  String get sign_out => 'Изход';

  @override
  String get sign_out_confirmation =>
      'Сигурен ли си, че искаш да излезеш от профила си?';

  @override
  String get password => 'Парола';

  @override
  String get forgot_password => 'Забравена парола';

  @override
  String get forgot_password_question => 'Забравена парола?';

  @override
  String get view_profile => 'Преглед на профила';

  @override
  String get reset_password => 'Нулиране на паролата';

  @override
  String get reset_password_explanation_text =>
      'В случай на забравена парола, въведи твоето потребителско име или емайл адрес, за да получиш инструкции за нулиране на паролата. Също така, не забравяй да провериш папка Спам.';

  @override
  String get username_or_email => 'Потребителско име или е-мейл адрес';

  @override
  String get reset_password_done =>
      'Имейл с линк за нулиране на паролата е изшратен на имейл адреса, свързан с твоя акаунт. Също така, провери и папка спам';

  @override
  String get send_reset_password_mail => 'Смяна на парола';

  @override
  String get enter_some_text => 'Моля, въведи текст';

  @override
  String get sign_up_page_title => 'Регистрация';

  @override
  String get sign_up_page_action_button => 'Регистрация';

  @override
  String get sign_up_page_action_doing_it => 'Регистриране…';

  @override
  String get sign_up_page_action_ok =>
      'Честито! Твоят акаунт току-що бе създаден.';

  @override
  String get sign_up_page_display_name_hint => 'Име';

  @override
  String get sign_up_page_display_name_error_empty =>
      'Моля, въведи екранно име, което искаш да използваш';

  @override
  String get sign_up_page_email_hint => 'Имейл';

  @override
  String get sign_up_page_email_error_empty => 'Изисква се имейл';

  @override
  String get sign_up_page_email_error_invalid => 'Невалиден имейл';

  @override
  String get sign_up_page_username_hint => 'Потребителско име: публично видимо';

  @override
  String get sign_up_page_username_error_empty =>
      'Моля, въведи потребителско име';

  @override
  String get sign_up_page_username_error_invalid =>
      'Въведи валидно потребителско име';

  @override
  String get sign_up_page_username_description =>
      'Потребителското име не може да съдържа интервали, главни или специални знаци.';

  @override
  String sign_up_page_username_length_invalid(int value) {
    return 'Потребителското име не може да надвишава $value знака';
  }

  @override
  String get sign_up_page_password_hint => 'Парола';

  @override
  String get sign_up_page_password_error_empty => 'Моля, въведи парола';

  @override
  String get sign_up_page_password_error_invalid =>
      'Моля, въведи валидна парола (поне 6 знака)';

  @override
  String get sign_up_page_confirm_password_hint => 'Потвърди паролата';

  @override
  String get sign_up_page_confirm_password_error_empty =>
      'Моля, потвърди паролата';

  @override
  String get sign_up_page_confirm_password_error_invalid =>
      'Паролите не съвпадат';

  @override
  String get sign_up_page_agree_text => 'Съгласен съм с Open Food Facts';

  @override
  String get sign_up_page_terms_text =>
      ' условията за ползване и принос на Open Food Facts';

  @override
  String get donate_url => 'https://donate.openfoodfacts.org/';

  @override
  String get sign_up_page_agree_error_invalid =>
      'Когато създаваш нов профил, приемането на условията за ползване е задължително, но въпреки това, анонимни приноси могат все пак да се правят чрез приложението';

  @override
  String get sign_up_page_producer_checkbox => 'Аз съм производител на храни';

  @override
  String get sign_up_page_producer_hint => 'Производител/марка';

  @override
  String get sign_up_page_producer_error_empty =>
      'Моля, въведи производител или марка';

  @override
  String get sign_up_page_subscribe_checkbox =>
      'Бих искал/а да се абонирам за бюлетина „Отворени факти за храната“ (Можете да се отпишете от него по всяко време)';

  @override
  String get sign_up_page_user_name_already_used =>
      'Потребителското име вече съществува, моля избери друго потребителско име.';

  @override
  String get sign_up_page_email_already_exists =>
      'вече съществува, влез в акаунта или опитай с друг имейл.';

  @override
  String get sign_up_page_provide_valid_email =>
      'Моля, посочи валиден имейл адрес.';

  @override
  String get sign_up_page_server_busy =>
      'Много съжаляваме, но имаме някои технически затруднения при създаването на твоя акаунт. Моля, опитай отново по-късно.';

  @override
  String get settingsTitle => 'Настройки';

  @override
  String get darkmode => 'Тема';

  @override
  String get darkmode_dark => 'Тъмен';

  @override
  String get darkmode_light => 'Светъл';

  @override
  String get darkmode_system_default => 'Стандартно за системата';

  @override
  String get thanks_for_contributing => 'Благодаря за приноса!';

  @override
  String get contributors_label => 'Те изграждат приложението';

  @override
  String get contributors_dialog_title => 'Сътрудници';

  @override
  String contributors_dialog_entry_description(Object name) {
    return 'Сътрудник: $name';
  }

  @override
  String get contributors_description =>
      'Списък на всички сътрудници на това приложение';

  @override
  String get support => 'Поддръжка';

  @override
  String get support_join_slack => 'Поискай помощ в нашият Slack канал';

  @override
  String get support_via_forum => 'Поискайте помощ в нашия форум';

  @override
  String get support_via_email => 'Изпрати ни имейл';

  @override
  String get support_via_email_include_logs_dialog_title =>
      'Изпращане на логовете на приложението?';

  @override
  String get support_via_email_include_logs_dialog_body =>
      'Искаш ли да включиш логовете на приложението като прикачен файл към твоя имейл?';

  @override
  String get termsOfUse => 'Условия за ползване';

  @override
  String get legalNotices => 'Правни бележки';

  @override
  String get privacy_policy => 'Политика за поверителност';

  @override
  String get about_this_app => 'Относно приложението';

  @override
  String get contribute => 'Допринеси';

  @override
  String get contribute_sw_development => 'Разработване на софтуер';

  @override
  String get contribute_develop_text =>
      'Кодът за всеки продукт на Open Food Facts е достъпен в GitHub. Заповядайте да използвате повторно кода (той е с отворен код) и да ни помогнете да го подобрим за всички, на цялата планета.';

  @override
  String get contribute_develop_text_2 =>
      'Можете да се присъедините към чата на Open Food Facts в Slack, което е предпочитаният начин да задавате въпроси.';

  @override
  String get contribute_develop_dev_mode_title => 'Режим на разработчик?';

  @override
  String get contribute_develop_dev_mode_subtitle =>
      'Включи режим на разработчик';

  @override
  String get contribute_donate_title => 'Дари';

  @override
  String get contribute_donate_header => 'Дарете на Open Food Facts';

  @override
  String get contribute_enroll_alpha_warning =>
      'Моля, имайте предвид, че с вътрешната алфа версия е възможна пълна загуба на данни и приложението може да стане неизползваемо по всяко време!';

  @override
  String get contribute_improve_ProductsToBeCompleted =>
      'Продукти за завършване';

  @override
  String get contribute_improve_header => 'Подобряване';

  @override
  String get contribute_improve_text =>
      'Базата данни е ядрото на проекта. Лесно и много бързо е да помогнете. Можете да изтеглите мобилното приложение за телефона си и да започнете да добавяте или подобрявате продукти.\n\nОт друга страна, уебсайтът Open Food Facts предлага много начини за принос: ';

  @override
  String get contribute_translate_header => 'Превеждане';

  @override
  String get contribute_data_quality => 'Качество на данните';

  @override
  String get contribute_translate_link_text => 'Започни превода';

  @override
  String get contribute_translate_text =>
      'Open Food Facts е глобален проект, съдържащ продукти от повече от 160 държави. Open Food Facts е преведен на десетки езици, като съдържанието му постоянно се развива.';

  @override
  String get contribute_translate_text_2 =>
      'Преводите са една от ключовите задачи на проекта';

  @override
  String get contribute_join_skill_pool =>
      'Допринесете с уменията си за Open Food Facts. Присъединете се към групата от умения!';

  @override
  String get contribute_share_header =>
      'Сподели Open Food Facts с приятелите си';

  @override
  String get contribute_share_content =>
      'Исках да ви разкажа за приложението, което използвам, Open Food Facts, което ви позволява да получавате информация за въздействието на вашата храна върху здравето и околната среда по персонализиран начин. То работи чрез сканиране на баркодовете на опаковката. И накрая, безплатно е, не изисква регистрация и дори можете да помогнете за увеличаване на броя на дешифрираните продукти. Ето линка, за да го изтеглите за телефона си: https://openfoodfacts.app';

  @override
  String get contribute_prices_gdpr =>
      'Допринесете за цените, като заявите експортиране на данните от вашите карти за лоялност съгласно GDPR';

  @override
  String get tap_to_answer => 'Натисни тук, за да отговориш на въпроси';

  @override
  String get tap_to_answer_hint =>
      'Докоснете тук, за да отговорите на въпроси относно този продукт';

  @override
  String get robotoff_questions_loading_hint =>
      'Моля, изчакайте, докато се заредят въпросите за този продукт';

  @override
  String get saving_answer => 'Запазване на твоят отговор';

  @override
  String get contribute_to_get_rewards =>
      'Стани участник в прозрачността на храните';

  @override
  String get question_sign_in_text =>
      'Влез в акаунта си в Open Food Facts, за да запишеш своите приноси';

  @override
  String get question_yes_button_accessibility_value => 'Отговорете с „да“';

  @override
  String get question_no_button_accessibility_value => 'Отговор с „не“';

  @override
  String get question_skip_button_accessibility_value =>
      'Пропуснете този въпрос';

  @override
  String get tap_to_edit_search => 'Докосни, за да редактираш търсенето';

  @override
  String get myPreferences => 'Моите настройки';

  @override
  String get account_create_message =>
      'Създайте си акаунт и се присъединете към общността Open Food Facts, за да помогнете за изграждането на знания за храните по целия свят!';

  @override
  String get join_us => 'Присъедини се';

  @override
  String get myPreferences_profile_title => 'Профил';

  @override
  String get myPreferences_profile_subtitle =>
      'Управлявайте акаунта си за сътрудници на Open Food Facts.';

  @override
  String get myPreferences_settings_title => 'Настройки';

  @override
  String get myPreferences_settings_subtitle => 'Тъмен режим, Езици…';

  @override
  String get myPreferences_food_title => 'Хранителни предпочитания';

  @override
  String get myPreferences_food_subtitle =>
      'Избери каква информация за храната е най-важна за теб.';

  @override
  String get myPreferences_food_comment =>
      'Избери коя информация за храната е най-важна за теб, за да класираш храната според твоите предпочитания. Виж информацията, която те интересува и получи обобщение за съвместимост. Тези предпочитания за храна остават на твоето устройство и не са свързани с твоят акаунт на сътрудник в Open Food Facts, ако имаш такъв.';

  @override
  String get confirmResetPreferences =>
      'Нулиране на твоите хранителни предпочитания?';

  @override
  String get myPersonalizedRanking => 'Моето класиране';

  @override
  String get ranking_tab_all => 'Всички';

  @override
  String get ranking_subtitle_match_yes => 'Добро съвпадение за теб';

  @override
  String get ranking_subtitle_match_no => 'Много лошо съвпадение';

  @override
  String get ranking_subtitle_match_maybe => 'Неизвестно съвпадение';

  @override
  String get refresh_with_new_preferences =>
      'Обнови списъка с новите си предпочитания';

  @override
  String get reloaded_with_new_preferences =>
      'Презаредено с новите ти предпочитания';

  @override
  String get profile_navbar_label => 'Community';

  @override
  String get scan_navbar_label => 'Сканирай';

  @override
  String get history_navbar_label => 'История';

  @override
  String get list_navbar_label => 'Списъци';

  @override
  String get category => 'Филтър по категория';

  @override
  String get category_all => 'Всички';

  @override
  String get category_search => '(търсене по категории)';

  @override
  String get filter => 'Филтър';

  @override
  String get scan => 'Продукти от екрана за Сканиране';

  @override
  String get scan_history => 'История на сканиранията';

  @override
  String get search => 'Търсене';

  @override
  String get search_product_help => 'Търсене на продукт,\nмарка или баркод';

  @override
  String get search_filter => 'Филтър за търсене';

  @override
  String get search_history => 'История на търсенията';

  @override
  String get search_store => 'Търсене на магазин';

  @override
  String get search_store_help => 'Подсказка: добавете града или държавата';

  @override
  String get tap_for_more => 'Докосни, за повече информация…';

  @override
  String get product => 'Продукт';

  @override
  String get unknownBrand => 'Неизвестна марка';

  @override
  String get unknownProductName => 'Неразпознат продукт';

  @override
  String get label_refresh => 'Опресни';

  @override
  String get label_reload => 'Презареждане';

  @override
  String get image => 'Снимка';

  @override
  String get front_photo => 'Снимка отпред';

  @override
  String outdated_image_accessibility_label(Object imageType) {
    return '$imageType (това изображение може да е остаряло)';
  }

  @override
  String get outdated_image_short_label => 'може да е остаряло';

  @override
  String get ingredients => 'Съставки';

  @override
  String get ingredients_editing_instructions =>
      'Запазете оригиналния ред. Посочете процента, когато е посочен. Разделете със запетая или тире и използвайте скоби за съставките на дадена съставка.';

  @override
  String get ingredients_editing_error => 'Неуспешно запазване на съставките.';

  @override
  String get ingredients_editing_image_error =>
      'Неуспешно получаване на новата снимка на съставките.';

  @override
  String get ingredients_editing_title => 'Редактиране на съставките';

  @override
  String get ingredients_photo => 'Снимка на съставките';

  @override
  String get packaging_editing_instructions =>
      'Изброй всички части на опаковката, разделени със запетая или ред, с тяхното количество (напр. 1 или 6), вид (напр. бутилка, кутия, кен), материал (напр. пластмаса, метал, алуминий) и ако е наличен, техния размер (напр. 33cl) и инструкции за рециклиране.\nПример: 1 стъклена бутилка за рециклиране, 1 пластмасова тапа за изхвърляне';

  @override
  String get packaging_editing_error => 'Неуспешно запазване на опаковката.';

  @override
  String get packaging_editing_image_error =>
      'Неуспешно получаване на новата снимка на опаковката.';

  @override
  String get packaging_editing_title => 'Редактиране на опаковката';

  @override
  String get nutrition => 'Хранителни стойности';

  @override
  String get nutrition_facts_photo => 'Снимка на хранителните стойности';

  @override
  String get nutrition_facts_editing_title =>
      'Редактиране на хранителните факти';

  @override
  String get packaging_information => 'Информация на опаковката';

  @override
  String get packaging_information_photo => 'Снимка с информация за опаковката';

  @override
  String get missing_product => 'Откри нов продукт!';

  @override
  String get add_product_take_photos =>
      'Направете снимки на опаковката, за да добавите този продукт към Open Food Facts';

  @override
  String get add_product_take_photos_descriptive =>
      'Моля, първо направи няколко снимки. Винаги можеш да завършиш продукта по-късно.';

  @override
  String get add_product_information_button_label =>
      'Добави информация за продукта';

  @override
  String get new_product => 'Нов продукт';

  @override
  String get new_product_found_title => 'Намерен е нов продукт!';

  @override
  String get new_product_found_text =>
      'Нашата съвместна база данни съдържа повече от **3 милиона продукта**, но този баркод не съществува: ';

  @override
  String get new_product_found_button => 'Добави продукта';

  @override
  String get new_product_leave_title => 'Напускане на страницата?';

  @override
  String get new_product_leave_message =>
      'Изглежда, че не си въвел нищо. Наистина ли искаш да напуснеш тази страница?';

  @override
  String get new_product_dialog_description =>
      'Моля, направете снимки на опаковката, за да добавите този продукт към нашата обща база данни.';

  @override
  String get new_product_dialog_illustration_description =>
      'Илюстрация с неизвестни Nutri-Score и Green Score';

  @override
  String get front_packaging_photo_button_label => 'Снимка на продукта отпред';

  @override
  String get confirm_front_packaging_photo_button_label =>
      'Потвърди качването на снимката на предната страна на продукта';

  @override
  String get confirm_button_label => 'Потвърди';

  @override
  String get send_image_button_label => 'Изпрати снимката';

  @override
  String get crop_page_action_saving => 'Запазване на снимката…';

  @override
  String get crop_page_action_cropping => 'Изрязване на снимката…';

  @override
  String get crop_page_action_local => 'Запазване на локална версия…';

  @override
  String get crop_page_action_local_failed_title =>
      'Опа… нещо не е наред със снимката ти!';

  @override
  String get crop_page_action_local_failed_message =>
      'Не можем да обработим изображението локално, преди да го изпратим на нашия сървър. Моля, опитайте отново по-късно или се свържете с нас, ако проблемът продължава.';

  @override
  String get crop_page_action_retake => 'Повторно снимане';

  @override
  String get crop_page_too_small_image_title => 'Снимката е прекалено малка!';

  @override
  String crop_page_too_small_image_message(
    int expectedMinWidth,
    int expectedMinHeight,
    int actualWidth,
    int actualHeight,
  ) {
    return 'Минималният размер в пиксели за качване на снимка е ${expectedMinWidth}x$expectedMinHeight. Текущата снимка е ${actualWidth}x$actualHeight.';
  }

  @override
  String get crop_page_action_server => 'Подготовка на повикване към сървъра…';

  @override
  String get front_packaging_photo_title =>
      'Снимка на предната част на опаковката';

  @override
  String get ingredients_photo_title => 'Снимка на съставките';

  @override
  String get nutritional_facts_photo_title =>
      'Снимка на хранителните стойности';

  @override
  String get recycling_photo_title => 'Снимка на указанията за рециклиране';

  @override
  String get take_photo_title => 'Направи снимка';

  @override
  String get take_more_photo_title => 'Направи още снимки';

  @override
  String get front_photo_uploaded => 'Снимката на предната страна е качена';

  @override
  String get ingredients_photo_button_label => 'Снимка на съставките';

  @override
  String get ingredients_photo_uploaded => 'Снимката на съставките е качена';

  @override
  String get nutrition_cache_loading_error =>
      'Не може да се заредят хранителни вещества от кеша';

  @override
  String get nutritional_facts_photo_button_label =>
      'Снимка на хранителните стойности';

  @override
  String get nutritional_facts_input_button_label =>
      'Въведи хранителните стойности';

  @override
  String get nutritional_facts_added => 'Хранителните стойности са добавени';

  @override
  String get categories_added => 'Добавени са категории';

  @override
  String get new_product_title_nutriscore => 'Изчисли Nutri-Score';

  @override
  String get new_product_subtitle_nutriscore =>
      'Помогни ни, като попълниш поне категория и хранителни стойности';

  @override
  String get new_product_title_environmental_score =>
      'Изчислете зеления резултат';

  @override
  String get new_product_subtitle_environmental_score =>
      'Вземете го, като попълните поне една категория';

  @override
  String get new_product_additional_environmental_score =>
      'Направете изчисляването на Green Score по-прецизно с произход, опаковка и други';

  @override
  String get new_product_title_nova =>
      'Изчисли нивото на обработка на храната (NOVA)';

  @override
  String get new_product_subtitle_nova =>
      'Вземете го, като попълните категорията храна и съставките';

  @override
  String get new_product_desc_nova_unknown =>
      'Нивото на обработка на храни не е известно';

  @override
  String get new_product_title_pictures => 'Да направим няколко снимки!';

  @override
  String get new_product_title_pictures_details =>
      'Моля, направи следните снимки и Open Food Facts ще направи останалото!';

  @override
  String get new_product_title_misc => 'И някои основни данни…';

  @override
  String new_product_done_msg(String username) {
    return 'Благодаря за приноса ти “$username”!';
  }

  @override
  String get new_product_done_msg_no_user => 'Благодарим за приноса!';

  @override
  String get new_product_done_button_label => 'Открийте готовия продукт';

  @override
  String get hey_incomplete_product_message =>
      'Докоснете, за да отговорите на 3 въпроса СЕГА, за да изчислите Nutri-Score, Green Score и Ultra-processing (NOVA)!';

  @override
  String get hey_incomplete_product_message_beauty =>
      'Докоснете сега, за да отговорите на 2 въпроса, които ще помогнат за анализа на тази козметика!';

  @override
  String get hey_incomplete_product_message_pet_food =>
      'Докоснете сега, за да отговорите на 3 въпроса, които ще помогнат за анализа на този хранителен продукт за домашни любимци!';

  @override
  String get hey_incomplete_product_message_product =>
      'Докоснете сега, за да помогнете за завършването на този продукт!';

  @override
  String get nutritional_facts_photo_uploaded =>
      'Снимката с хранителните стойности е качена';

  @override
  String get recycling_photo_button_label =>
      'Снимка с информацията за рециклиране';

  @override
  String get recycling_photo_uploaded => 'Снимката за рециклиране е качена';

  @override
  String get take_more_photo_button_label => 'Направи още снимки';

  @override
  String get other_photo_uploaded => 'Качена е различна снимка';

  @override
  String get retake_photo_button_label => 'Направи отново';

  @override
  String get selecting_photo => 'Избор на снимката';

  @override
  String get uploading_image => 'Качване на снимката на сървъра';

  @override
  String get uploading_image_type_front =>
      'Качване на изображение отпред в Open Food Facts';

  @override
  String get uploading_image_type_ingredients =>
      'Качване на изображение на съставките в Open Food Facts';

  @override
  String get uploading_image_type_nutrition =>
      'Качване на изображение за хранителната стойност в Open Food Facts';

  @override
  String get uploading_image_type_packaging =>
      'Качване на изображение от опаковката в Open Food Facts';

  @override
  String get uploading_image_type_other =>
      'Качване на друго изображение в Open Food Facts';

  @override
  String get uploading_image_type_generic =>
      'Качване на изображение в Open Food Facts';

  @override
  String get score_add_missing_ingredients => 'Добави липсващите съставки';

  @override
  String get score_add_missing_packaging_image =>
      'Добави липсващата снимка на опаковката';

  @override
  String get score_add_missing_nutrition_facts =>
      'Добави липсващи хранителни стойности';

  @override
  String get score_add_missing_product_traces =>
      'Добавете липсващи следи от продукти';

  @override
  String get score_add_missing_product_category =>
      'Добави липсваща продуктова категория';

  @override
  String get score_add_missing_precise_product_category =>
      'Изберете по-точна категория';

  @override
  String get score_add_missing_product_countries =>
      'Добави липсващите страни където се продава';

  @override
  String get score_add_missing_product_emb =>
      'Добави липсващите кодове за проследяване на продукта';

  @override
  String get score_add_missing_product_labels => 'Добави липсващите етикети';

  @override
  String get score_add_missing_product_origins =>
      'Добавете липсващ произход на продукта';

  @override
  String get score_add_missing_product_stores =>
      'Добавяне на липсващите магазини за продукта';

  @override
  String get score_add_missing_product_brands =>
      'Добавете липсващи продуктови марки';

  @override
  String get score_update_nutrition_facts =>
      'Актуализирай хранителните стойности';

  @override
  String get nutrition_page_title => 'Хранителни стойности';

  @override
  String get nutrition_page_nutritional_info_title => 'Хранителна информация';

  @override
  String get nutrition_page_nutritional_info_label =>
      'Стойности, посочени на продукта:';

  @override
  String get nutrition_page_nutritional_info_value_positive => 'Да';

  @override
  String get nutrition_page_nutritional_info_value_negative => 'Не';

  @override
  String get nutrition_page_nutritional_info_open_photo => 'Отвори снимката';

  @override
  String get nutrition_page_nutritional_info_explanation_title =>
      'Добри практики: Хранителна информация';

  @override
  String get nutrition_page_nutritional_info_explanation_info1 =>
      'Понякога хранителните факти **не са посочени на опаковката** или в документ, предоставен с продукта. В този случай, и само в този случай, можете да зададете стойността на **НЕ**.';

  @override
  String get nutrition_page_serving_type_label => 'Хранителни стойности:';

  @override
  String get nutrition_page_per_100g => 'на 100 г';

  @override
  String get nutrition_page_per_100g_100ml => 'на 100 г/мл';

  @override
  String get nutrition_page_per_serving => 'на порция';

  @override
  String get nutrition_page_add_nutrient => 'Добави хранително вещество';

  @override
  String get nutrition_page_serving_size => 'Размер на порция';

  @override
  String get nutrition_page_serving_size_hint =>
      'Въведете размер на порцията (например: 100 г)';

  @override
  String get nutrition_page_serving_size_explanation_title =>
      'Добри практики: Размер на порцията';

  @override
  String get nutrition_page_serving_size_explanation_info1 =>
      'Тази стойност помага за **извършване на пропорционално изчисление на всяко хранително вещество на порция**.';

  @override
  String get nutrition_page_serving_size_explanation_info2 =>
      '**Разрешени мерни единици** са: kg, g, mg, µg, oz, l, dl, cl, ml, fl.oz, fl oz, g, mg, kg, l, dl, кл, ml, 毫克, 公斤, 毫升, 公升, 吨.';

  @override
  String get nutrition_page_serving_size_explanation_good_example1 =>
      '**60 г**, **60 г** или **60 Г** (за предпочитане първото)';

  @override
  String get nutrition_page_serving_size_explanation_good_example2 =>
      '**1000 мл** или **1 л**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_explanation =>
      'Невалидна единица';

  @override
  String get nutrition_page_serving_size_explanation_bad_example1_example =>
      '30 гр.';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_explanation =>
      'Невалидни единици';

  @override
  String get nutrition_page_serving_size_explanation_bad_example2_example =>
      '9 **бонбона** и 2 **бисквити**';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_explanation =>
      'Липсваща единица';

  @override
  String get nutrition_page_serving_size_explanation_bad_example3_example =>
      '**30**';

  @override
  String get nutrition_page_invalid_number => 'Невалидно число';

  @override
  String get nutrition_page_update_running =>
      'Актуализиране на продукта на сървъра…';

  @override
  String get nutrition_page_update_done => 'Продуктът е актуализиран!';

  @override
  String get nutrition_page_take_serving_size_from_product_quantity =>
      'Използвайте количеството на продукта като размер на порцията';

  @override
  String get nutrition_page_photo_error => 'Не може да се зареди снимката';

  @override
  String get more_photos => 'Още интересни снимки';

  @override
  String get view_more_photo_button =>
      'Виж всички съществуващи снимки за този продукт';

  @override
  String get no_product_found => 'Няма намерен продукт';

  @override
  String get no_location_found => 'Не е намерено местоположение';

  @override
  String get not_found => 'не е намерено:';

  @override
  String get refreshing_product => 'Актуализация на продукта';

  @override
  String get product_refreshed => 'Продуктът е актуализиран';

  @override
  String product_image_accessibility_label(String date) {
    return 'Изображението е направено на $date';
  }

  @override
  String product_image_outdated_accessibility_label(String date) {
    return 'Изображението е направено на $date. Възможно е изображението да е остаряло.';
  }

  @override
  String get product_image_outdated => 'Това изображение може да е остаряло';

  @override
  String get product_image_outdated_explanations_title =>
      'Това изображение може да е остаряло';

  @override
  String get product_image_outdated_explanations_content =>
      'Това изображение е направено преди повече от година.\n**Моля, проверете дали е актуално**.\n\nТова е **просто предупреждение**. Ако съдържанието е все още същото, можете да игнорирате това съобщение.';

  @override
  String product_image_action_replace_photo(String type) {
    return 'Замяна на снимка ($type)';
  }

  @override
  String product_image_action_add_photo(String type) {
    return 'Добави снимка ($type)';
  }

  @override
  String get product_image_action_take_new_picture => 'Ново заснемане';

  @override
  String get product_image_action_take_picture => 'Направи снимка';

  @override
  String get product_image_action_from_gallery =>
      'Изберете от галерията на телефона си';

  @override
  String get product_image_action_choose_existing_photo =>
      'Изберете от снимките на продукта';

  @override
  String get product_image_details_label => 'Информация за снимката';

  @override
  String get product_image_details_from_producer => 'От производителя';

  @override
  String get product_image_details_contributor => 'Сътрудник';

  @override
  String get product_image_details_contributor_producer =>
      'Сътрудник (продуцент)';

  @override
  String get product_image_details_date => 'Дата';

  @override
  String get product_image_details_date_unknown => 'Неизвестно';

  @override
  String get homepage_main_card_logo_description =>
      'Добре дошъл в Open Food Facts';

  @override
  String get homepage_main_card_subheading =>
      '**Сканирай** баркод или\n**потърси** продукт';

  @override
  String get homepage_main_card_search_field_hint => 'Търсене на продукт';

  @override
  String get homepage_main_card_search_field_tooltip => 'Започни търсене';

  @override
  String scan_tagline_news_item_accessibility(String news_title) {
    return 'Последни новини: $news_title';
  }

  @override
  String get tagline_app_review => 'Харесваш ли приложението?';

  @override
  String get tagline_app_review_button_positive => 'Обичам го! 😍';

  @override
  String get tagline_app_review_button_negative => 'Не особено…';

  @override
  String get tagline_app_review_button_later => 'Попитай по-късно';

  @override
  String get tagline_feed_news_button => 'Научи повече';

  @override
  String get app_review_negative_modal_title => 'Не харесваш приложението?';

  @override
  String get app_review_negative_modal_text =>
      'Бихте ли отделили няколко секунди, за да ни кажете защо?';

  @override
  String get app_review_negative_modal_positive_button => 'Да, абсолютно!';

  @override
  String get app_review_negative_modal_negative_button => 'Не';

  @override
  String get could_not_refresh => 'Продуктът не можа да се обнови';

  @override
  String get product_internet_error_modal_title => 'Възникна грешка!';

  @override
  String product_internet_error_modal_message(String error) {
    return 'Не можем да извлечем информация за този продукт поради мрежова грешка. Моля, проверете интернет връзката си и опитайте отново.\n\nВътрешна грешка:\n$error';
  }

  @override
  String get product_tags_title => 'Свойства на продукта';

  @override
  String get no_product_tags_found_message =>
      'No product properties found. Properties can be used to describe products in more details, in a flexible way. Tap to add.';

  @override
  String get product_tags_empty => 'Няма имоти';

  @override
  String get product_tags_explanation =>
      'Чрез добавяне на свойства (ключ/стойност) към даден продукт, вие помагате за обогатяването му.';

  @override
  String get add_tag => 'Add property';

  @override
  String get add_tags => 'Добавяне на имоти';

  @override
  String get add_edit_tags => 'Добавяне или редактиране на свойства';

  @override
  String get edit_tag => 'Редактиране на собственост';

  @override
  String get remove_tag => 'Премахване на собственост';

  @override
  String get tag_key => 'Имот';

  @override
  String get tag_keys => 'Имоти';

  @override
  String get tag_key_uneditable => 'Имот (не може да се редактира)';

  @override
  String get tag_key_input_hint => 'Въведете свойство';

  @override
  String get tag_value => 'Стойност';

  @override
  String get tag_values => 'Ценности';

  @override
  String get tag_value_input_hint => 'Въведете стойност';

  @override
  String get tag_key_item => 'Имот:';

  @override
  String get tag_value_item => 'Стойност:';

  @override
  String get tag_key_explanations =>
      'Ключът трябва да бъде с малки букви и без интервали.';

  @override
  String tag_key_already_exists(String property) {
    return 'Вече съществува етикет със свойство $property !';
  }

  @override
  String get product_internet_error =>
      'Невъзможно е да се извлече информация за този продукт поради грешка в мрежата.';

  @override
  String get cached_results_from => 'Кеширани резултати от:';

  @override
  String get product_search_same_category => 'Намерете алтернативи';

  @override
  String get product_search_same_category_short => 'Сравни';

  @override
  String get product_search_same_category_error =>
      'Тази функция може да се използва само за продукти с категория.\n\nМоля, редактирайте продукта, за да добавите категория.';

  @override
  String get product_improvement_add_category =>
      'Добави категория, за да изчислиш Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts =>
      'Добави хранителни стойности, за да изчислиш Nutri-Score.';

  @override
  String get product_improvement_add_nutrition_facts_and_category =>
      'Добави хранителни стойности и категория, за да изчислиш Nutri-Score.';

  @override
  String get product_improvement_categories_but_no_nutriscore =>
      'Nutri-Score за този продукт не може да бъде изчислен, това може да се дължи например на нестандартна категория. Ако това се счита за грешка, моля, свържете се с нас.';

  @override
  String get product_improvement_obsolete_nutrition_image =>
      'Снимката на хранителните стойности е остаряла: моля, актуализирай я.';

  @override
  String get product_improvement_origins_to_be_completed =>
      'Зеленият рейтинг взема предвид произхода на съставките. Моля, направете снимка на списъка със съставките и/или всяко географско твърдение или редактирайте продукта, за да могат те да бъдат взети предвид.';

  @override
  String get country_chooser_label => 'Моля, избери страна';

  @override
  String get currency_chooser_label => 'Моля, избери валута';

  @override
  String get country_change_message => 'Току-що сте сменили държавата.';

  @override
  String currency_auto_change_message(
    String previousCurrency,
    String possibleCurrency,
  ) {
    return 'Искате ли да промените валутата от $previousCurrency на $possibleCurrency?';
  }

  @override
  String get onboarding_country_chooser_label => 'Моля, избери страна:';

  @override
  String get country_chooser_label_from_settings => 'Твоята страна';

  @override
  String get country_selection_explanation =>
      'Някои характеристики на околната среда са специфични за местоположението';

  @override
  String get product_removed_comparison =>
      'Продуктът е премахнат от сравнението';

  @override
  String get native_app_settings => 'Настройки на оригиналното приложение';

  @override
  String get native_app_description =>
      'Настройки на отворените системи за Open Food Facts';

  @override
  String get product_removed_history => 'Продуктът е премахнат от историята';

  @override
  String get product_removed_list => 'Продуктът е премахнат от списъка';

  @override
  String get product_could_not_remove => 'Продуктът не можа да бъде премахнат';

  @override
  String get no_prodcut_in_list => 'Няма продукт в този списък';

  @override
  String get no_product_in_section => 'Няма продукт в този раздел';

  @override
  String get recently_seen_products => 'Всички разгледани продукти';

  @override
  String get clear => 'Изчисти';

  @override
  String get clear_long => 'Изпразни списъка';

  @override
  String get really_clear => 'Наистина ли желаеш да изтриеш този списък?';

  @override
  String pct_match(Object percent) {
    return '$percent% съвпадение';
  }

  @override
  String plural_ago_days(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'преди $count дни',
      one: 'преди един ден',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_hours(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'преди $count часа',
      one: 'преди един час',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_minutes(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'преди $count минути',
      one: 'преди една минута',
      zero: 'преди по-малко от една минута',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_months(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'преди $count месеца',
      one: 'преди един месец',
    );
    return '$_temp0';
  }

  @override
  String plural_ago_weeks(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'преди $count седмици',
      one: 'преди една седмица',
    );
    return '$_temp0';
  }

  @override
  String plural_compare_x_products(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Сравни $count продукта',
      one: 'Сравни един продукт',
    );
    return '$_temp0';
  }

  @override
  String multiselect_title(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count избрани продукти',
      one: 'Един избран продукт',
      zero: 'Няма избран продукт',
    );
    return '$_temp0';
  }

  @override
  String get compare_products_mode => 'Сравнете избрани продукти';

  @override
  String get delete_products_mode => 'Изтриване на избраните продукти';

  @override
  String get select_all_products_mode => 'Изберете всички продукти';

  @override
  String get select_none_products_mode => 'Избери нищо';

  @override
  String get compare_products_appbar_title => 'Сравни продукти';

  @override
  String get compare_products_appbar_subtitle =>
      'Моля, избери поне два продукта';

  @override
  String get retry_button_label => 'Повторен опит';

  @override
  String get connect_with_us => 'Свържи се с нас';

  @override
  String get tiktok => 'Последвай ни в TikTok';

  @override
  String get tiktok_link => 'https://www.tiktok.com/@openfoodfacts';

  @override
  String get instagram => 'Последвай ни в Instagram';

  @override
  String get instagram_link => 'https://instagram.com/open.food.facts';

  @override
  String get twitter => 'Последвай ни в X (бивш Twitter)';

  @override
  String get twitter_link => 'https://www.twitter.com/openfoodfacts';

  @override
  String get mastodon => 'Последвай ни в Mastodon';

  @override
  String get mastodon_link => 'https://mastodon.social/@openfoodfacts';

  @override
  String get bsky => 'Последвай ни в BlueSky';

  @override
  String get bsky_link => 'https://bsky.app/profile/openfoodfacts.bsky.social';

  @override
  String get blog => 'Блог';

  @override
  String get faq => 'ЧЗВ';

  @override
  String get discover => 'Открийте';

  @override
  String get how_to_contribute => 'Как да допринесеш';

  @override
  String get hint_knowledge_panel_message =>
      'Можеш да докоснеш всяка част от картата, за да получиш повече подробности за това, което виждаш. Опитай сега!';

  @override
  String get permissions_page_title => 'Достъп до камерата';

  @override
  String get permissions_page_body1 =>
      'За да сканираш баркодове с камерата на телефона си, моля разреши достъпа.';

  @override
  String get permissions_page_body2 =>
      'Ако промениш решението си, тази опция може да бъде активирана и деактивирана по всяко време от настройките.';

  @override
  String contact_form_body_android(
    int? sdkInt,
    String? release,
    String? model,
    String? product,
    String? device,
    String? brand,
  ) {
    return 'ОС: Android (SDK Int: $sdkInt / Версия: $release)\nМодел: $model\nПродукт: $product\nУстройство: $device\nМарка:$brand';
  }

  @override
  String contact_form_body_ios(
    String? version,
    String? model,
    String? localizedModel,
  ) {
    return 'ОС: iOS ($version)\nМодел: $model\nЛокализиран модел: $localizedModel';
  }

  @override
  String contact_form_body(
    String osContent,
    String appVersion,
    String appBuildNumber,
    String appPackageName,
  ) {
    return '$osContent\nApp версия:$appVersion\nApp номер на build:$appBuildNumber\nApp име на пакета:$appPackageName';
  }

  @override
  String get authorize_button_label => 'Разреши';

  @override
  String get refuse_button_label => 'Отказ';

  @override
  String get ask_me_later_button_label => 'По-късно';

  @override
  String get are_you_sure => 'Сигурен ли си?';

  @override
  String knowledge_panel_text_source(String sourceName) {
    return 'Научи повече на $sourceName';
  }

  @override
  String get onboarding_home_welcome_text1 => 'Добре дошли!';

  @override
  String get onboarding_home_welcome_text2 =>
      'Приложението, което ви помага да изберете храна, която е полезна за **вас** и **планетата**!';

  @override
  String get onboarding_continue_button => 'Продължи';

  @override
  String get onboarding_welcome_loading_dialog_title =>
      'Зареждане на първия ти примерен продукт';

  @override
  String get onboarding_welcome_warning =>
      'За съжаление, това е нашият примерен продукт, не можете да го редактирате :)';

  @override
  String get product_list_your_ranking => 'Твоето класиране';

  @override
  String get product_list_empty_icon_desc => 'Историята не е налична';

  @override
  String get product_list_empty_title => 'Започни да сканираш';

  @override
  String get product_list_empty_message =>
      'Тук ще се появят сканираните продукти и можеш да провериш подробна информация за тях';

  @override
  String product_list_reloading_in_progress_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'продукти',
      one: 'продукт',
      zero: 'продукт',
    );
    return 'Обновяване на $_temp0 в твоята история';
  }

  @override
  String product_list_reloading_success_multiple(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Продукти',
      one: 'Продукт',
      zero: 'Продукт',
    );
    return '$_temp0 обновяването е завършено';
  }

  @override
  String get product_list_compare_side_by_side => 'Compare side by side';

  @override
  String get loading_dialog_default_title => 'Изтегляне на данни';

  @override
  String get loading_dialog_default_error_message =>
      'Данните не можаха да се изтеглят';

  @override
  String get account_delete => 'Изтриване на акаунт';

  @override
  String get account_delete_title => 'Изтриване на акаунта ми';

  @override
  String get user_profile => 'Профил';

  @override
  String get user_profile_title_guest => 'Добре дошъл!';

  @override
  String get user_profile_subtitle_guest =>
      'Влезте или се регистрирайте, за да се присъедините към общността Open Food Facts';

  @override
  String user_profile_title_id_email(String email) {
    return 'Вход за „Отворени факти за храната“: $email';
  }

  @override
  String user_profile_title_id_default(String id) {
    return 'Добре дошъл $id!';
  }

  @override
  String get email_subject_account_deletion => 'Изтриване на акаунт';

  @override
  String email_body_account_deletion(String userId) {
    return 'Здравейте, моля, изтрийте моя акаунт в Open Food Facts: $userId';
  }

  @override
  String get settings_app_app => 'Приложение';

  @override
  String get settings_app_data => 'Поверителност и наблюдение';

  @override
  String get settings_app_camera => 'Камера';

  @override
  String get settings_app_products => 'Продукти';

  @override
  String get settings_app_miscellaneous => 'Разни';

  @override
  String get camera_play_sound_title => 'Възпроизвеждане на звук при сканиране';

  @override
  String get camera_play_sound_subtitle =>
      'Звуков сигнал при всяко успешно сканиране';

  @override
  String get camera_window_accessibility_label =>
      'Сканирайте баркод с камерата си';

  @override
  String get app_haptic_feedback_title => 'Вибрация и усещане';

  @override
  String get app_haptic_feedback_subtitle =>
      'Вибрации след извършване на някои действия (декодиран баркод, премахнат продукт…).';

  @override
  String get crash_reporting_toggle_title => 'Докладване за срив';

  @override
  String get crash_reporting_toggle_subtitle =>
      'Когато е активирано, докладите за сривове се изпращат автоматично до системата за проследяване на грешки на Open Food Facts, така че те да бъдат коригирани и да се подобри приложението.';

  @override
  String get send_anonymous_data_toggle_title => 'Изпращане на анонимни данни';

  @override
  String get send_anonymous_data_toggle_subtitle =>
      'When enabled, some anonymous information regarding app usage will be sent to the Open Food Facts servers, so that we can understand how and how much features are used in order to improve them.';

  @override
  String get product_edit_photo_title => 'Редактиране на снимка';

  @override
  String get permission_photo_error => 'Грешка';

  @override
  String get permission_photo_denied_title =>
      'Разреши използването на камерата за да сканираш баркодове';

  @override
  String permission_photo_denied_message(String appName) {
    return 'За по-добро изживяване, моля разреши на $appName достъп до твоята камера. Ще можеш директно да сканираш баркодове.';
  }

  @override
  String get permission_photo_denied_button => 'Разреши';

  @override
  String get permission_photo_denied_dialog_settings_title =>
      'Достъпът е отказан';

  @override
  String get permission_photo_denied_dialog_settings_message =>
      'Тъй като по-рано си отказал разрешението на камерата, трябва да го разрешиш ръчно от настройките.';

  @override
  String get permission_photo_denied_dialog_settings_button_open =>
      'Отвори настройките';

  @override
  String get permission_photo_denied_dialog_settings_button_cancel => 'Отмени';

  @override
  String get permission_photo_none_found => 'Не е открита камера';

  @override
  String get permission_photo_denied => 'Не е предоставен достъп до камерата';

  @override
  String get show_product_pictures => 'Покажи снимки на продукти';

  @override
  String get edit_product_label => 'Редактирай продукта';

  @override
  String get edit_product_pending_operations_banner_title =>
      'Качване на вашите редакции…';

  @override
  String get edit_product_pending_operations_banner_message =>
      'Редакциите ви се **изпращат във фонов режим** (или по-късно, в случай на грешка).\nМожете да продължите да редактирате други полета на продукта.';

  @override
  String get edit_product_pending_operations_banner_short_message =>
      'Редакциите ви се **изпращат във фонов режим** (или по-късно, в случай на грешка).';

  @override
  String get edit_product_label_short => 'Редактирай';

  @override
  String edit_product_form_item_help(String value) {
    return 'Как да въведа „$value“?';
  }

  @override
  String get edit_product_form_item_error_empty =>
      'Моля, въведете стойност, която не е празна!';

  @override
  String get edit_product_form_item_error_existing =>
      'Тази стойност вече е налице!';

  @override
  String get edit_product_form_item_add_action_brand =>
      'Добавяне на нова марка';

  @override
  String get edit_product_form_item_add_action_label =>
      'Добавяне на нов етикет';

  @override
  String get edit_product_form_item_add_action_store =>
      'Добавяне на нов магазин';

  @override
  String get edit_product_form_item_add_action_origin =>
      'Добавяне на нов произход';

  @override
  String get edit_product_form_item_add_action_emb_code =>
      'Добавяне на нов код за проследяване';

  @override
  String get edit_product_form_item_add_action_country =>
      'Добавяне на нова държава';

  @override
  String get edit_product_form_item_add_action_category =>
      'Добавяне на нова категория';

  @override
  String get edit_product_form_item_add_action_trace =>
      'Добавяне на нова следа';

  @override
  String get edit_product_form_item_add_suggestion => 'Добавяне на предложение';

  @override
  String get edit_product_form_item_deny_suggestion =>
      'Отхвърляне на предложението';

  @override
  String get edit_product_form_item_details_title => 'Основни подробности';

  @override
  String get edit_product_form_item_details_subtitle =>
      'Име на продукта, марка, количество';

  @override
  String get edit_product_form_item_other_details_title =>
      'Допълнителни подробности';

  @override
  String get edit_product_form_item_other_details_subtitle => 'Уеб сайт…';

  @override
  String get edit_product_form_item_photos_title => 'Снимки';

  @override
  String get edit_product_form_item_photos_subtitle =>
      'Добави или опресни снимки';

  @override
  String get edit_product_form_item_labels_title => 'Етикети и сертификати';

  @override
  String get edit_product_form_item_labels_subtitle =>
      'Околна среда, Етикети за качество…';

  @override
  String get edit_product_form_item_labels_hint =>
      'Въведете етикет (напр.: NutriScore)';

  @override
  String get edit_product_form_item_labels_type => 'етикет';

  @override
  String get edit_product_form_item_labels_explanation_title =>
      'Добри практики: Етикети';

  @override
  String get edit_product_form_item_labels_explanation_info1 =>
      'Всяка характеристика на продукта, **която е фактическа** и се различава от останалите полета.';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_1 =>
      'Нутри-Скор, NOVA…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_2 =>
      'Произведено в Белгия, произведено в Бретан…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_3 =>
      'ISO 9001, ISO 22000…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_4 =>
      'Богат на фибри, източник на желязо…';

  @override
  String get edit_product_form_item_labels_explanation_good_examples_5 =>
      'Справедлива търговия, Макс Хавелар…';

  @override
  String get edit_product_form_item_stores_title => 'Магазини';

  @override
  String get edit_product_form_item_stores_hint => 'Въведете магазин';

  @override
  String get edit_product_form_item_stores_type => 'магазин';

  @override
  String get edit_product_form_item_stores_explanation_title =>
      'Добри практики: Магазини';

  @override
  String get edit_product_form_item_stores_explanation_info1 =>
      'Въведете магазина, от който сте закупили продукта.';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_1 =>
      'Уолмарт';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_2 =>
      'Карфур';

  @override
  String get edit_product_form_item_stores_explanation_good_examples_3 =>
      'Лидл';

  @override
  String get edit_product_form_item_origins_title => 'Произход';

  @override
  String get edit_product_form_item_origins_hint =>
      'Въведете произход (напр. Германия)';

  @override
  String get edit_product_form_item_origins_type => 'страна';

  @override
  String get edit_product_form_item_origins_explanation_title =>
      'Добри практики: Произход';

  @override
  String get edit_product_form_item_origins_explanation_info1 =>
      'Добавете **всякакви обозначения за произход, които можете да намерите на опаковката**.\nНе е нужно да се притеснявате за произхода, посочен директно в списъка на съставките.';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_1 =>
      'Говеждо месо от Аржентина';

  @override
  String get edit_product_form_item_origins_explanation_good_examples_2 =>
      'Соята не идва от Европейския съюз';

  @override
  String get edit_product_form_item_countries_title => 'Country';

  @override
  String get edit_product_form_item_countries_hint =>
      'Въведете държава (напр. Германия)';

  @override
  String get edit_product_form_item_countries_type => 'страна';

  @override
  String get edit_product_form_item_countries_explanations_title =>
      'Добри практики: Държави';

  @override
  String get edit_product_form_item_countries_explanations_info1 =>
      '**Държави, в които продуктът е широко достъпен** (без магазини, специализирани в чуждестранни продукти).';

  @override
  String get edit_product_form_item_emb_codes_title => 'Кодове за проследимост';

  @override
  String get edit_product_form_item_emb_codes_hint =>
      'Въведете код (напр.: EMB 53062, FR 62.448.034 CE, 84 R 20, 33 RECOLTANT 522…)';

  @override
  String get edit_product_form_item_emb_codes_type => 'код за проследимост';

  @override
  String get edit_product_form_item_emb_help_title =>
      'Добри практики: Кодове за проследяване';

  @override
  String get edit_product_form_item_emb_help_info1 =>
      'В този раздел можете да въведете кодове, свързани с **маркировки на опаковката**, **идентификационни маркировки** или **маркировки за здравословен начин на живот**.';

  @override
  String get edit_product_form_item_emb_help_info2_title =>
      'Примери за кодове за проследяване';

  @override
  String get edit_product_form_item_emb_help_info2_item1_text =>
      '**Кодове на ЕО**, използвани в Европейската общност за идентифициране на производители или опаковчици на храни:';

  @override
  String get edit_product_form_item_emb_help_info2_item1_example =>
      'FR\n72.264.002\nCE';

  @override
  String get edit_product_form_item_emb_help_info2_item1_explanation =>
      '**FR**: код на държавата **Франция**\n**72.264.002**: географски данни\n**CE**: Европейска общност';

  @override
  String get edit_product_form_item_emb_help_info2_item2_text =>
      '**EMB кодове**, използвани във Франция:';

  @override
  String get edit_product_form_item_emb_help_info2_item2_explanation =>
      'EMB 72264';

  @override
  String get edit_product_form_item_traces_title => 'Следи';

  @override
  String get edit_product_form_item_traces_hint => 'следа';

  @override
  String get edit_product_form_item_traces_type =>
      'Въведете следа (напр.: соеви зърна)';

  @override
  String get edit_product_form_item_categories_title => 'Категории';

  @override
  String get edit_product_form_item_categories_hint => 'категория';

  @override
  String get edit_product_form_item_categories_type =>
      'Въведете категория (напр.: Портокалов сок)';

  @override
  String get edit_product_form_item_categories_explanation_title =>
      'Добри практики: Категории';

  @override
  String get edit_product_form_item_categories_explanation_info1 =>
      'Посочете **само най-специфичната категория**.\nРодителските категории ще бъдат добавени автоматично.';

  @override
  String get edit_product_form_item_categories_explanation_info2_title =>
      'Липсва категория?';

  @override
  String get edit_product_form_item_categories_explanation_info2_content =>
      'В случай че дадена категория **не е налична в автоматичното довършване**, можете да я добавите въпреки това.\nТова ще ни помогне да подобрим Open Food Facts във вашата страна.';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_1 =>
      'Сардини в зехтин';

  @override
  String get edit_product_form_item_categories_explanation_good_examples_2 =>
      'Портокалов сок от концентрат';

  @override
  String get edit_product_form_item_exit_title => 'Да се изляза без запазване?';

  @override
  String get edit_product_form_item_exit_confirmation =>
      'Искаш ли да запазиш промените, преди да напуснеш тази страница?';

  @override
  String get edit_product_form_item_exit_confirmation_positive_button =>
      'Запази промените';

  @override
  String get edit_product_form_item_exit_confirmation_negative_button =>
      'Отхвърли промените';

  @override
  String get edit_product_form_item_ingredients_title => 'Съставки';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_tooltip =>
      'Увеличаване и намаляване на мащаба чрез щипване на екрана с пръсти';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_title =>
      'Увеличаване и намаляване на мащаба на снимката';

  @override
  String get edit_product_form_item_ingredients_pinch_to_zoom_message =>
      'С помощта на **жеста за мащабиране с щипване и прищипване** можете да увеличавате или намалявате мащаба на снимката:';

  @override
  String get edit_product_form_item_add_valid_item_tooltip => 'Добави';

  @override
  String get edit_product_form_item_add_invalid_item_tooltip =>
      'Моля, първо въведи текст';

  @override
  String get edit_product_form_item_remove_item_tooltip => 'Премахни';

  @override
  String get edit_product_form_item_save_edit_item_tooltip =>
      'Запазете редакцията си';

  @override
  String get edit_product_form_item_cancel_edit_item_tooltip =>
      'Отмяна на редакцията';

  @override
  String get edit_product_form_item_packaging_title =>
      'Снимка с инструкции за рециклиране';

  @override
  String get edit_product_form_item_nutrition_facts_title =>
      'Хранителни стойности';

  @override
  String get edit_product_form_item_nutrition_facts_subtitle =>
      'Хранителни стойности, съдържание на алкохол…';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_title =>
      'Добри практики: Хранителна информация';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_title =>
      'Хранителни стойности';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info1_content =>
      'Първо, изберете дали **стойностите са предоставени**:';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_title =>
      'Хранителни стойности';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info2_content =>
      'След това въведете хранителните стойности **както е посочено на опаковката**. Ако няма стойност, можете да кликнете върху иконата „Око“.';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_title =>
      'Липсва поле?';

  @override
  String get edit_product_form_item_nutrition_facts_explanation_info3_content =>
      'Ако липсва даден запис, можете да **щракнете върху иконата „Плюс“**, за да го добавите (напр.: витамин D, магнезий…).';

  @override
  String get edit_product_form_save => 'Редактирай';

  @override
  String get edit_product_ingredients_photo_title => 'Снимка на съставките';

  @override
  String get edit_product_ingredients_list_title => 'Списък на съставките';

  @override
  String get edit_product_packaging_photo_title => 'Снимка на опаковката';

  @override
  String get edit_product_packaging_list_title => 'Списък с опаковки';

  @override
  String get no_data_available => 'Няма налични данни';

  @override
  String get product_field_website_title => 'Уеб сайт';

  @override
  String get origins_editing_title => 'Редактиране на произхода';

  @override
  String get completed_basic_details_btn_text =>
      'Попълни основните подробности';

  @override
  String get not_implemented_snackbar_text => 'Все още не е внедрено';

  @override
  String get category_picker_page_appbar_text => 'Категории';

  @override
  String get edit_ingredients_extract_ingredients_btn_text =>
      'Извличане на съставки от снимката';

  @override
  String get edit_ingredients_extract_ingredients_btn_text_short =>
      'Извлечи съставките';

  @override
  String get edit_ingredients_extracting_ingredients_btn_text =>
      'Извличане на съставки\nот снимката';

  @override
  String get edit_ingredients_loading_photo_btn_text => 'Зареждане на снимка…';

  @override
  String get edit_ingredients_loading_photo_help_dialog_title =>
      'Защо виждам това съобщение?';

  @override
  String get edit_ingredients_loading_photo_help_dialog_body =>
      'За да използвате функцията „Извличане на съставки“, първо трябва да качите снимката.\n\nМоля, изчакайте няколко секунди или ги въведете ръчно.';

  @override
  String get edit_ingredients_refresh_photo_btn_text => 'Обнови снимката';

  @override
  String get edit_packaging_extract_btn_text =>
      'Извадете опаковката\nот снимката';

  @override
  String get edit_packaging_extract_btn_text_short => 'Извличане на опаковката';

  @override
  String get edit_packaging_extracting_btn_text =>
      'Извличане на опаковката от снимката';

  @override
  String get edit_packaging_loading_photo_btn_text => 'Зареждане на снимка…';

  @override
  String get edit_packaging_loading_photo_help_dialog_title =>
      'Защо виждам това съобщение?';

  @override
  String get edit_packaging_loading_photo_help_dialog_body =>
      'За да използвате функцията „Извличане на опаковката“, първо трябва да качите снимката.\n\nМоля, изчакайте няколко секунди или ги въведете ръчно.';

  @override
  String get edit_packaging_refresh_photo_btn_text => 'Обнови снимката';

  @override
  String get edit_ocr_extract_failed =>
      'Неуспешно откриване на текст в снимката.';

  @override
  String get edit_ocr_extract_disabled_title => 'Няма снимка!';

  @override
  String get edit_ocr_extract_disabled_message =>
      'За да използвате функцията за извличане на текст, първо трябва да направите снимка.';

  @override
  String get user_list_dialog_new_title => 'Нов списък с продукти';

  @override
  String get user_list_dialog_rename_title => 'Преименувай списъка';

  @override
  String get user_list_subtitle_product => 'Списъци';

  @override
  String get user_list_title => 'Твоите списъци';

  @override
  String get user_list_add_product => 'Добави продукта към твоите списъци';

  @override
  String get user_list_button_new => 'Създай нов списък';

  @override
  String get user_list_empty_label =>
      'No list available yet, please start by creating one';

  @override
  String get user_list_button_add_product => 'Добави към списък';

  @override
  String get added_to_list_msg => 'Добавено към списъка';

  @override
  String get user_list_popup_clear => 'Изчистване на историята';

  @override
  String get user_list_popup_rename => 'Преименувай';

  @override
  String get user_list_name_hint => 'Моят списък';

  @override
  String get user_list_name_error_empty => 'Името е задължително';

  @override
  String get user_list_name_error_already => 'Това име вече е заето';

  @override
  String get user_list_name_error_same => 'Това е същото име';

  @override
  String get user_list_name_input_hint => 'Име на списъка';

  @override
  String get try_again => 'Опитай отново';

  @override
  String get there_was_an_error => 'Възникна грешка';

  @override
  String category_picker_no_category_found_message(String items) {
    return 'Няма намерена категория за $items';
  }

  @override
  String get camera_toggle_camera => 'Превключване между задна и предна камера';

  @override
  String get camera_toggle_flash =>
      'Включване или изключване на светкавицата на камерата';

  @override
  String get camera_enable_flash => 'Включи светкавицата';

  @override
  String get camera_disable_flash => 'Изключи светкавицата';

  @override
  String get camera_flash_error_dialog_title => 'Възникна грешка!';

  @override
  String get camera_flash_error_dialog_message =>
      'Възникна грешка при промяна на състоянието на светкавицата. Моля, уверете се, че фенерчето не е активирано на вашия смартфон.';

  @override
  String get category_picker_no_category_found_button => 'Назад';

  @override
  String get user_preferences_item_accessibility_hint =>
      'Кликнете, за да отворите в браузъра си или в приложението (ако е инсталирано)';

  @override
  String get dev_preferences_screen_title => 'Режим на разработчик';

  @override
  String get dev_preferences_screen_subtitle =>
      'Достъп до експериментални функции и инструменти за разработка';

  @override
  String get dev_preferences_reset_onboarding_title =>
      'Рестартирайте включването';

  @override
  String get dev_preferences_reset_onboarding_subtitle =>
      'След това трябва да рестартираш приложението, за да го видиш отново.';

  @override
  String get dev_preferences_environment_switch_title =>
      'Превключва между openfoodfacts.org (PROD) и test env';

  @override
  String get dev_preferences_test_environment_title =>
      'Параметри на тестовата среда';

  @override
  String dev_preferences_test_environment_subtitle(String url) {
    return 'Базов URL за текущото test env: $url';
  }

  @override
  String get dev_preferences_test_environment_dialog_title =>
      'Хост на тестовата среда';

  @override
  String get dev_preferences_ml_kit_title => 'Използвай ML Kit';

  @override
  String get dev_preferences_ml_kit_subtitle =>
      'след това трябва да рестартираш приложението';

  @override
  String get dev_preferences_product_additional_features_title =>
      'Допълнителен бутон на продуктовата страница';

  @override
  String get dev_preferences_edit_ingredients_title =>
      'Редактиране на съставките чрез бутон панел за познание';

  @override
  String get dev_preferences_export_history_title => 'Експортирай историята';

  @override
  String get dev_preferences_export_history_progress_error => 'изключение';

  @override
  String get dev_preferences_export_history_progress_found => 'намерен продукт';

  @override
  String get dev_preferences_export_history_progress_not_found =>
      'продуктът НЕ е намерен';

  @override
  String get dev_preferences_export_history_dialog_title =>
      'Експортирай историята';

  @override
  String get dev_preferences_button_positive => 'Добре';

  @override
  String get dev_preferences_button_negative => 'Отмени';

  @override
  String get dev_preferences_migration_title => 'Миграция на данните от V1';

  @override
  String dev_preferences_migration_subtitle(String status) {
    return 'Статус: $status';
  }

  @override
  String get dev_preferences_migration_status_already_done =>
      'успешно или ново инсталиране';

  @override
  String get dev_preferences_migration_status_success => 'успешно';

  @override
  String get dev_preferences_migration_status_error => 'грешка';

  @override
  String get dev_preferences_migration_status_in_progress => 'в ход';

  @override
  String get dev_preferences_migration_status_required =>
      'задължително (щракни, за да започнеш)';

  @override
  String get dev_preferences_migration_status_not_started => 'неизвестно';

  @override
  String get dev_preferences_import_history_subtitle =>
      'Ще изчисти историята и ще сложи 3 продукта там';

  @override
  String get dev_preferences_news_custom_url_title =>
      'Персонализиран URL адрес за новини';

  @override
  String get dev_preferences_news_custom_url_subtitle =>
      'URL адрес на JSON файла:';

  @override
  String get dev_preferences_news_custom_url_empty_value => 'Не е зададено';

  @override
  String get dev_preferences_news_provider_status_title => 'Статус';

  @override
  String dev_preferences_news_provider_status_subtitle(String date) {
    return 'Последно обновяване: $date';
  }

  @override
  String get product_type_label_food => 'Храна';

  @override
  String get product_type_label_beauty => 'Лична грижа';

  @override
  String get product_type_label_pet_food => 'Храна за домашни любимци';

  @override
  String get product_type_label_product => 'Друго';

  @override
  String get product_type_selection_title => 'Тип продукт';

  @override
  String get product_type_selection_subtitle => 'Изберете вида на този продукт';

  @override
  String get product_type_selection_empty =>
      'Първо трябва да изберете вид продукт!';

  @override
  String product_type_selection_already(String productType) {
    return 'Не можете да промените типа на продукта ($productType)!';
  }

  @override
  String get prices_app_dev_mode_flag =>
      'Пряк път до приложението „Цени“ на страницата на продукта';

  @override
  String get prices_app_button => 'Отидете в приложението Цени';

  @override
  String get prices_website_button => 'Отворено на уебсайта „Отворени цени“';

  @override
  String get prices_bulk_proof_upload_select =>
      'Добавете ценови етикети директно от галерията';

  @override
  String get prices_bulk_proof_upload_warning =>
      'След като изберете изображения, няма да можете да ги редактирате!';

  @override
  String get prices_bulk_proof_upload_warning_ai =>
      'AI will run on your proofs to extract prices.';

  @override
  String get prices_bulk_proof_upload_community_switch =>
      'Позволете на общността да валидира цените, извлечени от изкуствен интелект.';

  @override
  String get prices_bulk_proof_upload_subtitle => 'Множество етикети с цени';

  @override
  String get prices_bulk_proof_upload_title =>
      'Качване на групово доказателство';

  @override
  String get prices_bulk_proof_upload_step_selecting => 'Избиране на файлове';

  @override
  String get prices_bulk_proof_upload_step_starting =>
      'Стартиране на качването';

  @override
  String prices_bulk_proof_upload_step_copying(int index, int count) {
    return 'Локално копира файл #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_preparing(int index, int count) {
    return 'Подготовка за качване #$index/$count';
  }

  @override
  String prices_bulk_proof_upload_step_error(int index, int count) {
    return 'Неуспешно при изображение #$index/$count';
  }

  @override
  String get prices_generic_title => 'Цени';

  @override
  String prices_add_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Добави $count цени',
      one: 'Добави цена',
    );
    return '$_temp0';
  }

  @override
  String prices_send_n_prices(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Изпрати $count цени',
      one: 'Изпрати цената',
    );
    return '$_temp0';
  }

  @override
  String get prices_add_an_item => 'Добавяне на елемент';

  @override
  String get prices_add_a_price => 'Добавяне на цена';

  @override
  String get prices_add_a_receipt => 'Добавяне на касова бележка';

  @override
  String get prices_add_price_tags => 'Добавете ценови етикети';

  @override
  String prices_barcode_already(String barcode) {
    return 'Този баркод ($barcode) вече е в списъка!';
  }

  @override
  String get prices_barcode_search_not_found => 'Продъктът не е открит';

  @override
  String get prices_barcode_search_none_yet => 'Все още няма продукт';

  @override
  String prices_barcode_search_running(String barcode) {
    return 'Търся $barcode';
  }

  @override
  String get prices_barcode_enter => 'Въведете баркода';

  @override
  String get prices_category_enter => 'Артикул без баркод';

  @override
  String get prices_per_kilogram => 'Цена за килограм';

  @override
  String get prices_per_unit => 'Единична цена';

  @override
  String get prices_per_kilogram_short => ' / кг';

  @override
  String get prices_per_unit_short => ' / единица';

  @override
  String get prices_category_mandatory => 'Задължително';

  @override
  String get prices_category_optional => 'По избор';

  @override
  String get prices_category_error_mandatory => 'Категорията е задължителна';

  @override
  String get prices_barcode_reader_action => 'Четец на баркодове';

  @override
  String get prices_view_prices => 'Вижте цените';

  @override
  String get prices_list_title => 'Ценова листа';

  @override
  String get prices_list_count => 'Брой цени от\n';

  @override
  String get prices_list_add_new_price => 'Добавете\nнова цена';

  @override
  String get prices_list_empty_title => 'Все още няма цена!';

  @override
  String get prices_list_empty_subtitle =>
      'Бъдете първият, който ще добави:\nКато сканирате **касова бележка** или **цена**!';

  @override
  String get prices_entry_shop_not_found => 'Неизвестен магазин';

  @override
  String prices_entry_menu_title(String user) {
    return 'Въвеждане на цена от „$user“';
  }

  @override
  String get prices_entry_menu_open_product_prices =>
      'Вижте всички цени за този продукт';

  @override
  String get prices_entry_menu_open_proof => 'Вижте доказателството';

  @override
  String get prices_entry_menu_my_prices => 'Вижте другите ми цени';

  @override
  String get prices_entry_menu_author_prices => 'Вижте други цени от автора';

  @override
  String get prices_entry_menu_shop_prices => 'Вижте другите цени от магазина';

  @override
  String prices_product_accessibility_summary(int count, String product) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count цени',
      one: '1 цена',
    );
    return '$_temp0 за $product';
  }

  @override
  String prices_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Всички $count цени',
      one: 'Само една цена',
      zero: 'Все още няма цена',
    );
    return '$_temp0';
  }

  @override
  String prices_list_length_many_pages(int pageSize, int total) {
    return 'Последни $pageSize цени (общо: $total)';
  }

  @override
  String prices_entry_accessibility_label(
    String price,
    String location,
    String date,
    String user,
  ) {
    return 'Цена: $price / Магазин: \"$location\" / Публикувано на $date от \"$user\"';
  }

  @override
  String prices_open_user_proofs(String user) {
    return 'Отворени доказателства за \"$user\"';
  }

  @override
  String get prices_open_proof => 'Доказателство за отворена цена';

  @override
  String prices_proofs_list_length_one_page(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Всички $count доказателства',
      one: 'Само едно доказателство',
      zero: 'Все още няма доказателство',
    );
    return '$_temp0';
  }

  @override
  String prices_proofs_list_length_many_pages(int pageSize, int total) {
    return 'Последни $pageSize доказателства (общо: $total)';
  }

  @override
  String get prices_users_empty_title => 'Все още няма сътрудник!';

  @override
  String get prices_users_empty_explanation =>
      'Бъдете първият, който ще добави цена!';

  @override
  String prices_users_list_length_many_pages(int pageSize, int total) {
    return 'Най-много $pageSize участници (общо: $total)';
  }

  @override
  String get prices_locations_empty_title => 'Все още няма магазин!';

  @override
  String get prices_locations_empty_explanation =>
      'Бъдете първият, който ще добави цена!';

  @override
  String prices_locations_list_length_many_pages(int pageSize, int total) {
    return 'Топ $pageSize местоположения (общо: $total)';
  }

  @override
  String prices_button_count_proof(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count доказателства',
      one: 'Едно доказателство',
      zero: 'Няма доказателство',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_product(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продукти',
      one: 'Един продукт',
      zero: 'Няма продукт',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_user(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count потребители',
      one: 'Един потребител',
      zero: 'Няма потребител',
    );
    return '$_temp0';
  }

  @override
  String prices_button_count_price(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count цени',
      one: 'Една цена',
      zero: 'Без цена',
    );
    return '$_temp0';
  }

  @override
  String get prices_amount_existing_subtitle => 'Цена, добавена преди това';

  @override
  String get prices_amount_subtitle => 'Сума';

  @override
  String get prices_amount_is_discounted => 'С отстъпка ли е?';

  @override
  String get prices_amount_price_normal => 'Цена';

  @override
  String get prices_amount_price_discounted => 'Намалена цена';

  @override
  String get prices_amount_price_not_discounted => 'Първоначална цена';

  @override
  String get prices_amount_no_product => 'Липсва един продукт!';

  @override
  String get prices_amount_price_incorrect => 'Неправилна стойност';

  @override
  String get prices_amount_price_mandatory => 'Задължителна стойност';

  @override
  String get prices_currency_subtitle => 'Валута';

  @override
  String get prices_date_subtitle => 'Дата';

  @override
  String get prices_location_subtitle => 'Магазин';

  @override
  String get prices_location_find => 'Намерете магазин';

  @override
  String get prices_location_mandatory => 'Трябва да изберете магазин!';

  @override
  String get prices_location_search_broader =>
      'Не можахте да намерите това, което търсите? Нека опитаме по-широко търсене!';

  @override
  String get prices_proof_subtitle => 'Доказателство';

  @override
  String get prices_proof_empty_title => 'Все още няма доказателства!';

  @override
  String get prices_proof_empty_explanation =>
      'Започнете, като добавите снимка на **касова бележка** или **цена**!';

  @override
  String get prices_proof_find => 'Изберете доказателство';

  @override
  String get prices_proof_change => 'Доказателство за промяна';

  @override
  String get prices_proof_receipt => 'Разписка';

  @override
  String get prices_proof_price_tag => 'Цена';

  @override
  String get prices_proof_mandatory => 'Трябва да изберете доказателство!';

  @override
  String get prices_add_validation_error => 'Грешка при валидиране';

  @override
  String get prices_privacy_warning_title => 'Предупреждение за поверителност';

  @override
  String get prices_unknown_product => 'Неизвестен продукт';

  @override
  String get prices_privacy_warning_main_message =>
      'Цените **ще бъдат публични**, заедно с магазина, за който се отнасят.\n\nТова може да позволи на хора, които знаят за вашия псевдоним Open Food Facts, да:\n';

  @override
  String get prices_privacy_warning_message_bullet_1 =>
      'Направете предположение в кой район живеете';

  @override
  String get prices_privacy_warning_message_bullet_2 => 'Знайте какво купувате';

  @override
  String get prices_privacy_warning_sub_message =>
      'Ако това ви притеснява, моля, променете псевдонима си или създайте нов акаунт в Open Food Facts и влезте в приложението с него.';

  @override
  String get i_refuse => 'Отказвам';

  @override
  String get i_accept => 'Приемам';

  @override
  String get prices_currency_change_proposal_title => 'Да се промени валутата?';

  @override
  String prices_currency_change_proposal_message(
    String currency,
    String newCurrency,
  ) {
    return 'Текущата ви валута е **$currency**. Искате ли да я промените на **$newCurrency**?';
  }

  @override
  String prices_currency_change_proposal_action_approve(String newCurrency) {
    return 'Да, използвайте $newCurrency';
  }

  @override
  String prices_currency_change_proposal_action_cancel(String currency) {
    return 'Не, запазете $currency';
  }

  @override
  String get prices_menu_know_more => 'Научете повече за отворените цени';

  @override
  String get dev_preferences_import_history_result_success => 'Готово';

  @override
  String get dev_mode_section_server => 'Конфигурация на сървъра';

  @override
  String get dev_mode_section_news => 'Конфигурация на доставчика на новини';

  @override
  String get dev_mode_section_product_page => 'Страница на продукта';

  @override
  String get dev_mode_section_ui => 'Потребителски интерфейс';

  @override
  String get dev_mode_section_experimental_features =>
      'Експериментални функции';

  @override
  String get dev_mode_hide_environmental_score_title =>
      'Изключи зеления резултат';

  @override
  String get dev_mode_spellchecker_for_ocr_title =>
      'Използвайте програма за проверка на правописа за OCR екрани';

  @override
  String get dev_mode_spellchecker_for_ocr_subtitle => '(Съставки и опаковка)';

  @override
  String get dev_mode_reset_app_language_title =>
      'Нулиране на езика на приложението';

  @override
  String get dev_mode_add_demo_cards_language_title => 'Добавяне на карти';

  @override
  String get dev_mode_openprices_switch_env_title =>
      'Превключване между prices.openfoodfacts.org (PROD) и тестова среда';

  @override
  String get search_history_item_edit_tooltip =>
      'Повторно използване и редактиране на това търсене';

  @override
  String get search_history_item_remove_tooltip => 'Премахни';

  @override
  String product_search_no_more_results(int totalSize) {
    return 'Изтегли всички $totalSize продукта.';
  }

  @override
  String product_search_button_download_more(
    int count,
    int downloaded,
    int totalSize,
  ) {
    return 'Изтегли още $count продукта\nВече изтеглени $downloaded от $totalSize.';
  }

  @override
  String product_search_loading_message(Object search) {
    return 'Твоето търсене на $search е в ход.\n\nМоля, изчакай няколко секунди…';
  }

  @override
  String get user_search_contributor_title => 'Добавени от мен продукти';

  @override
  String get user_search_informer_title => 'Редактирани от мен продукти';

  @override
  String get user_search_photographer_title => 'Снимани от мен продукти';

  @override
  String get user_search_to_be_completed_title =>
      'Моите продукти, които предстои да бъдат завършени';

  @override
  String get user_search_prices_title => 'Моите цени';

  @override
  String get user_search_proofs_title => 'Моите доказателства';

  @override
  String get user_search_proof_title => 'Моето доказателство';

  @override
  String search_proof_title(String user) {
    return 'Доказателство от „$user“';
  }

  @override
  String user_any_search_prices_title(String user) {
    return 'Цени на сътрудниците: $user';
  }

  @override
  String get all_search_prices_latest_title => 'Последни добавени цени';

  @override
  String get all_search_prices_top_user_title =>
      'Най-големи участници в цените';

  @override
  String get all_search_prices_top_location_title =>
      'Магазини с най-много цени';

  @override
  String get prices_contribution_assistant => 'Асистент за ценови вноски';

  @override
  String get prices_validation_assistant => 'Price Validation Assistant';

  @override
  String get prices_challenges_page => 'Challenges';

  @override
  String get prices_multiple_proof_addition_system =>
      'Добавяне на множество доказателства';

  @override
  String get all_search_prices_top_location_single_title => 'Цени в магазин';

  @override
  String get all_search_prices_top_product_title => 'Продукти с най-много цени';

  @override
  String get all_search_to_be_completed_title =>
      'Всички продукти, които трябва да бъдат завършени';

  @override
  String get categorize_products_country_title =>
      'Помогни с категоризирането на продукти в страната си';

  @override
  String get edit_product_action_retake_picture => 'Презаснемане';

  @override
  String get edit_product_action_take_picture => 'Направи снимка';

  @override
  String get edit_product_action_confirm => 'Потвърди';

  @override
  String get signup_page_terms_of_use_line1 =>
      'Съгласен съм с Open Food Facts ';

  @override
  String get signup_page_terms_of_use_line2 =>
      ' условията за ползване и принос на Open Food Facts';

  @override
  String get analytics_consent_image_semantic_label => 'Икона анализи';

  @override
  String knowledge_panel_page_loading_error(Object? error) {
    return 'Фатална грешка: $error';
  }

  @override
  String preferences_page_loading_error(Object? error) {
    return 'Фатална грешка: $error';
  }

  @override
  String get summary_card_button_add_basic_details =>
      'Попълни основните подробности';

  @override
  String get edit_photo_button_label => 'Редактирай';

  @override
  String get edit_photo_unselect_button_label => 'Отмяна на избор на снимка';

  @override
  String get edit_photo_select_existing_button_label =>
      'Избери съществуваща снимка';

  @override
  String get edit_photo_select_existing_all_label =>
      'Existing images for this product';

  @override
  String get edit_photo_select_existing_all_subtitle =>
      'Изберете изображение, като щракнете върху него';

  @override
  String get edit_photo_select_existing_download_label =>
      'Извличане на съществуващите снимки…';

  @override
  String get edit_photo_select_existing_downloaded_none =>
      'Няма качени снимки, свързани с този продукт.';

  @override
  String get edit_photo_language_not_this_one =>
      'Все още няма изображение на този език';

  @override
  String get edit_photo_language_none => 'Все още няма изображение';

  @override
  String get category_picker_screen_title => 'Категории';

  @override
  String get basic_details => 'Основни подробности';

  @override
  String get product_name => 'Име на продукта';

  @override
  String get product_names => 'Имена на продуктите';

  @override
  String get add_basic_details_product_name_add_translation =>
      'Добавяне на нов превод';

  @override
  String get add_basic_details_product_name_warning_translations =>
      'Преди валидиране, моля, уверете се, че добавяте превод само **ако езикът е наличен на опаковката**';

  @override
  String get add_basic_details_product_name_open_photo =>
      'Вижте снимката отпред';

  @override
  String get add_basic_details_product_name_take_photo =>
      'Направете снимка отпред';

  @override
  String get add_basic_details_product_name_hint =>
      'Въведете името на продукта (напр.: Nutella)';

  @override
  String get add_basic_details_product_name_change_main_language_title =>
      'Да се промени ли езикът по подразбиране?';

  @override
  String add_basic_details_product_name_change_main_language_text(
    String language,
  ) {
    return 'Искате ли езикът по подразбиране на продукта да бъде зададен на „$language“?';
  }

  @override
  String get explanation_section_good_examples => 'Добри примери';

  @override
  String get explanation_section_bad_examples => 'Лоши примери';

  @override
  String get add_basic_details_product_name_help_title =>
      'Добри практики: Име на продукта';

  @override
  String get add_basic_details_product_name_help_info1 =>
      'Името на продукта е **основното име, отпечатано върху опаковката**. То може да бъде регистрирана търговска марка.';

  @override
  String get add_basic_details_product_name_help_info2 =>
      '**Забележка:** Моля, не добавяйте превод, **ако езикът не е посочен на опаковката**.';

  @override
  String get add_basic_details_product_name_help_good_examples_1 => 'Несквик';

  @override
  String get add_basic_details_product_name_help_good_examples_2 =>
      'Доматен кетчуп';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_explanation =>
      'Не включвайте марката в името';

  @override
  String get add_basic_details_product_name_help_bad_examples_1_example =>
      'Доматен кетчуп **от Heinz**';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_explanation =>
      'Не използвайте символи ®, ™, © или подобни';

  @override
  String get add_basic_details_product_name_help_bad_examples_2_example =>
      'Несквик**®**';

  @override
  String add_basic_details_product_name_other_translations(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count други преводи',
      one: '$count друг превод',
    );
    return '$_temp0';
  }

  @override
  String get brand_name => 'Марка';

  @override
  String get brand_names => 'Имена на марките';

  @override
  String get add_basic_details_brand_name_error =>
      'Моля, въведи името на марката';

  @override
  String get add_basic_details_brand_names_hint =>
      'Въведи марките (напр: LB Bulgaricum)';

  @override
  String get add_basic_details_product_brand_help_title =>
      'Добри практики: Марки';

  @override
  String get add_basic_details_product_brand_help_info1 =>
      'Въведете **всички марки на продукта**.';

  @override
  String get add_basic_details_product_brand_help_info2_title =>
      'Основна марка';

  @override
  String get add_basic_details_product_brand_help_info2_content =>
      '**Основната марка**, обикновено ясно показана на предната опаковка, трябва да бъде **въведена първа**.';

  @override
  String get add_basic_details_product_brand_help_info3_title => 'Други марки';

  @override
  String get add_basic_details_product_brand_help_info3_item1_text =>
      'Когато се продава **от голяма компания**:';

  @override
  String get add_basic_details_product_brand_help_info3_item1_explanation =>
      '**Актимел** се продава от **Данон**';

  @override
  String get add_basic_details_product_brand_help_info3_item2_text =>
      'Когато се продава с марката си, **преведена на няколко езика**:';

  @override
  String get add_basic_details_product_brand_help_info3_item2_explanation =>
      '**Nature Valley** понякога се изписва **Val Nature**';

  @override
  String get add_basic_details_product_brand_help_good_examples_1 => 'Нутела';

  @override
  String get add_basic_details_product_brand_help_good_examples_2 =>
      'Орео, Монделийз';

  @override
  String get quantity => 'Количество и тегло';

  @override
  String get add_basic_details_quantity_hint =>
      'Въведете теглото и, ако е необходимо, количеството (например: 4x100g)';

  @override
  String get add_basic_details_product_quantity_help_title =>
      'Добри практики: Количество';

  @override
  String get add_basic_details_product_quantity_help_info1 =>
      'Копирайте стойността, посочена на продукта, и **не забравяйте мерните единици**.';

  @override
  String get add_basic_details_product_quantity_help_good_examples_1 =>
      '**230 г** или **230 г**';

  @override
  String get add_basic_details_product_quantity_help_good_examples_2 =>
      '**6** (за 6 яйца)';

  @override
  String get add_basic_details_product_quantity_help_good_examples_3 =>
      '**3 x 150 г**\n(за продукт с 3 кутии, всяка от 150 г)';

  @override
  String get barcode => 'Баркод';

  @override
  String barcode_barcode(String barcode) {
    return 'Баркод: $barcode';
  }

  @override
  String get barcode_invalid_error => 'Невалиден баркод';

  @override
  String get basic_details_add_success =>
      'Основните подробности са добавени успешно';

  @override
  String get basic_details_add_error =>
      'Не може да се добавят основните подробности. Моля, опитай отново по-късно';

  @override
  String get clear_search => 'Изчистване на търсенето';

  @override
  String get confirm_clear =>
      'На път си да изчистиш цялата си история: сигурен ли си, че искаш да продължиш?';

  @override
  String get alert_clear_selected_user_list =>
      'На път си да изчистиш избраните елементи от хронологията';

  @override
  String get confirm_clear_selected_user_list =>
      'Сигурен ли си, че искаш да продължиш?';

  @override
  String get alert_select_items_to_clear =>
      'Моля, изберете един или повече елементи за изчистване';

  @override
  String confirm_clear_user_list(String name) {
    return 'На път си да изчистиш този списък ($name): сигурен ли си, че искаш да продължиш?';
  }

  @override
  String get confirm_delete_user_list_title => 'Да се изтрие ли списъкът?';

  @override
  String confirm_delete_user_list_message(String name) {
    return 'На път сте да изтриете списъка „$name“.\nСигурни ли сте, че искате да продължите?';
  }

  @override
  String get confirm_delete_user_list_button => 'Да, потвърждавам';

  @override
  String importance_label(String name, String id) {
    return '$name важност: $id';
  }

  @override
  String get user_list_all_title => 'Списъци';

  @override
  String get user_list_all_empty => 'Създай първия си списък';

  @override
  String get product_list_select => 'Избери списък';

  @override
  String user_list_length(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продукти',
      one: 'Един продукт',
      zero: 'Празен списък',
    );
    return '$_temp0';
  }

  @override
  String get add_list_label => 'Добави списък';

  @override
  String get open_food_preferences_tooltip =>
      'Редактирай хранителните предпочитания';

  @override
  String get add_photo_button_label => 'Добави снимка';

  @override
  String get add_packaging_photo_button_label =>
      'Направи снимки на информацията за опаковката/рециклирането';

  @override
  String get add_origin_photo_button_label =>
      'Направи снимки с всякаква информация за произхода';

  @override
  String get add_emb_photo_button_label =>
      'Направете снимки на всяка информация за кода за проследяване';

  @override
  String get add_label_photo_button_label =>
      'Направи снимки на информация за етикети и сертификати';

  @override
  String get choose_image_source_title => 'Избери източник на снимката';

  @override
  String get choose_image_source_body => 'Моля, избери източник на снимката';

  @override
  String get gallery_source_label => 'Галерия';

  @override
  String get gallery_source_access_denied_dialog_title => 'Достъпът е отказан';

  @override
  String get gallery_source_access_denied_dialog_message_ios =>
      'За съжаление, приложението няма достъп до галерията ви, тъй като преди това сте отказали разрешението.\n\nМоля, отидете в настройките на приложението в телефона си -> Настройки -> Снимки';

  @override
  String get gallery_source_access_denied_dialog_button =>
      'Отворете Настройките';

  @override
  String get share => 'Сподели';

  @override
  String share_product_text(String url) {
    return 'Разгледайте този продукт в Open Food Facts: $url';
  }

  @override
  String share_product_text_beauty(String url) {
    return 'Разгледайте този продукт в Open Beauty Facts: $url';
  }

  @override
  String share_product_text_pet_food(String url) {
    return 'Разгледайте този продукт на Open PetFood Facts: $url';
  }

  @override
  String share_product_text_product(String url) {
    return 'Разгледайте този продукт на Open Products Facts: $url';
  }

  @override
  String share_product_list_text(String url) {
    return 'Разгледайте списъка ми с продукти в Open Food Facts: $url';
  }

  @override
  String get capture => 'Ново заснемане';

  @override
  String get capture_new_picture => 'Направи снимка';

  @override
  String get choose_from_gallery => 'Избери от галерията';

  @override
  String get image_upload_queued =>
      'Снимката ще бъде качена във фонов режим възможно най-скоро.';

  @override
  String get add_price_queued =>
      'Цената ще бъде изпратена на сървъра възможно най-скоро.';

  @override
  String get background_task_title_full_refresh =>
      'Стартиране на опресняването на всички продукти, съхранявани локално';

  @override
  String get background_task_title_top_n =>
      'Започва изтеглянето на най-популярните продукти';

  @override
  String get expand_nutrition_facts =>
      'Разгъни таблицата с хранителните стойности';

  @override
  String get expand_nutrition_facts_body =>
      'Дръж таблицата с хранителните стойности разгъната';

  @override
  String get expand_ingredients => 'Разгъни съставките';

  @override
  String get expand_ingredients_body => 'Дръж панела на съставките разгънат';

  @override
  String get no_internet_connection => 'Няма интернет връзка';

  @override
  String get world_results_label => 'Целият свят';

  @override
  String get world_results_action => 'Разшири търсенето си до света';

  @override
  String get copy_to_clipboard => 'Копиране';

  @override
  String get paste_from_clipboard => 'Вмъкни от клипборда';

  @override
  String get no_data_available_in_clipboard =>
      'Няма налични данни в клипборда ви';

  @override
  String get clipboard_barcode_copy => 'Копирай баркода в клипборда';

  @override
  String clipboard_barcode_copied(Object barcode) {
    return 'Баркода $barcode е копиран в системния буфер!';
  }

  @override
  String get open_product_website => 'Отворете този продукт на уебсайта';

  @override
  String get language_picker_label => 'Твоят език';

  @override
  String get country_picker_label => 'Твоята страна';

  @override
  String get currency_picker_label => 'Твоята валута';

  @override
  String get help_with_openfoodfacts => 'Помощ с OpenFoodFacts';

  @override
  String get product_task_background_schedule =>
      'Продуктът ще бъде актуализиран във фонов режим възможно най-скоро.';

  @override
  String get no_email_client_available_dialog_title =>
      'Няма приложения за електронна поща!';

  @override
  String get no_email_client_available_dialog_content =>
      'Моля, изпратете ни ръчно имейл до mobile@openfoodfacts.org';

  @override
  String get all_images => 'Всички снимки';

  @override
  String get selected_images => 'Избрани снимки';

  @override
  String get product_card_remove_product_tooltip => 'Премахни продукт';

  @override
  String scan_announce_new_barcode(String barcode) {
    return 'Нов сканиран баркод: $barcode';
  }

  @override
  String get scan_header_clear_button_tooltip =>
      'Премахнете всички продукти от карусела';

  @override
  String get scan_header_compare_button_invalid_state_tooltip =>
      'Моля, сканирай поне два продукта, за да ги сравниш';

  @override
  String get scan_header_compare_button_valid_state_tooltip =>
      'Кликни, за да сравниш продуктите, които си сканирал';

  @override
  String get scan_product_loading => 'Сканирали сте\nбаркода:';

  @override
  String get scan_product_loading_initial =>
      'Търсим този продукт!\nМоля, изчакайте няколко секунди…';

  @override
  String get scan_product_loading_long_request =>
      'Все още търсим този продукт!\nСмятате ли, че отнема много време за зареждане? И ние също…';

  @override
  String get scan_product_loading_unresponsive =>
      'Все още търсим този продукт.\nИскате ли да рестартирате търсенето?';

  @override
  String get scan_product_loading_restart_button => 'Рестартиране на търсенето';

  @override
  String get portion_calculator_description =>
      'Изчисли хранителните стойности за определено количество';

  @override
  String get portion_calculator_hint => 'Количество в';

  @override
  String get portion_calculator_accessibility =>
      'Въведете количество, за да изчислите хранителните стойности';

  @override
  String portion_calculator_error(int min, int max) {
    return 'Моля, въведете количество между $min и $max г';
  }

  @override
  String get portion_calculator_computation_error =>
      'Липсват данни. Изчислението не можа да бъде извършено.';

  @override
  String portion_calculator_result_title(int grams) {
    return 'Хранителни стойности за $grams г (или мл)';
  }

  @override
  String get offline_data => 'Данни извън линия';

  @override
  String get ocr_image_upload_instruction =>
      'Качи снимка, за да извлечеш автоматично информацията, която съдържа.';

  @override
  String get upload_image => 'Качете снимка';

  @override
  String get word_separator_char => ',';

  @override
  String get word_separator => ', ';

  @override
  String get image_download_error => 'Неуспешно изтегляне на снимката';

  @override
  String get image_edit_url_error =>
      'Редактирането на снимката не бе успешно, защото URL адресът на снимката не беше зададен.';

  @override
  String get user_picture_source_remember => 'Запомни моя избор';

  @override
  String get user_picture_source_ask => 'Питай всеки път';

  @override
  String get robotoff_continue => 'Продължи';

  @override
  String robotoff_next_n_questions(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count въпроси',
      one: 'въпрос',
    );
    return 'Следващ $_temp0';
  }

  @override
  String get show_password => 'Покажи паролата';

  @override
  String get owner_field_info_title =>
      'Стойности, предоставени от производителя';

  @override
  String get owner_field_info_message =>
      'С това лого ние подчертаваме данни, предоставени от производителя, и те може да не са редактируеми.';

  @override
  String get owner_field_info_close_button => 'Затвори тази информация';

  @override
  String get owner_field_image =>
      'Това изображение е предоставено от производителя. Възможно е да не може да се редактира.';

  @override
  String get edit_packagings_title => 'Части на опаковката';

  @override
  String get edit_packagings_element_add => 'Добави компонент от опаковката';

  @override
  String get edit_packagings_completed => 'Опаковката е пълна';

  @override
  String edit_packagings_element_title(int index) {
    return 'Опаковъчна част #$index';
  }

  @override
  String get edit_packagings_element_field_units => 'Брой единици';

  @override
  String get edit_packagings_element_hint_units =>
      'Въведи броя на опаковъчните единици с еднаква форма и материал, съдържащи се в продукта.';

  @override
  String get edit_packagings_element_field_shape => 'Форма';

  @override
  String get edit_packagings_element_hint_shape =>
      'Въведи името на формата, посочено в инструкциите за рециклиране, ако са налични, или избери форма.';

  @override
  String get edit_packagings_element_example_shape => 'Бутилка';

  @override
  String get edit_packagings_element_field_material => 'Материал';

  @override
  String get edit_packagings_element_hint_material =>
      'Въведи конкретния материал, ако може да бъде определен (код на материала вътре в триъгълник често може да се намери върху частите на опаковката) или общ материал (например пластмаса или метал), ако не си сигурен.';

  @override
  String get edit_packagings_element_example_material => 'Стъкло';

  @override
  String get edit_packagings_element_field_recycling =>
      'Инструкция за рециклиране';

  @override
  String get edit_packagings_element_hint_recycling =>
      'Въведи инструкциите за рециклиране само ако са посочени на продукта.';

  @override
  String get edit_packagings_element_example_recycling => 'Рециклирай';

  @override
  String get edit_packagings_element_field_quantity =>
      'Нетно количество продукт на единица';

  @override
  String get edit_packagings_element_hint_quantity =>
      'Въведи нетното тегло или нетния обем и посочи единицата (например г или мл).';

  @override
  String get edit_packagings_element_field_weight =>
      'Тегло на една празна единица (г)';

  @override
  String get edit_packagings_element_hint_weight =>
      'Отстрани останалата храна, измий и подсуши опаковката преди претеглянето. Ако е възможно, използвай везна с точност 0,1 г или 0,01 г.';

  @override
  String get background_task_title => 'Чакащ принос';

  @override
  String get background_task_subtitle =>
      'Вашите приноси се записват автоматично на нашия сървър, но не винаги в реално време.';

  @override
  String get background_task_list_empty => 'Няма чакащи фонови задачи';

  @override
  String get background_task_error_server_time_out =>
      'Време на изчакване на сървъра';

  @override
  String get background_task_error_no_internet =>
      'Грешка в интернет връзката. Пробвайте по-късно.';

  @override
  String get background_task_operation_unknown => 'неизвестен тип операция';

  @override
  String get background_task_operation_details => 'подробни промени';

  @override
  String get background_task_operation_image => 'качване на снимка';

  @override
  String get background_task_operation_refresh =>
      'опресняването се забави след качването на снимка';

  @override
  String get background_task_run_started => 'започнат';

  @override
  String get background_task_run_not_started => 'все още не е започнал';

  @override
  String get background_task_run_to_be_deleted => 'да бъде изтрито';

  @override
  String get background_task_question_stop =>
      'Искаш ли да спреш тази задача възможно най-скоро?';

  @override
  String get feed_back => 'Обратна връзка';

  @override
  String get undo => 'Отмяна';

  @override
  String get copy_email_to_clip_board => 'Копирай имейла в буфера';

  @override
  String get please_send_us_an_email_to => 'Моля, изпрати ни ръчно имейл до';

  @override
  String get email_copied_to_clip_board => 'Имейлът е копиран в клипборда!';

  @override
  String get select_accent_color => 'Изберете цвят за акцент';

  @override
  String get theme_amoled => 'AMOLED';

  @override
  String get color_blue => 'Синьо';

  @override
  String get color_cyan => 'Циан';

  @override
  String get color_green => 'Зелено';

  @override
  String get color_light_brown => 'По подразбиране';

  @override
  String get color_magenta => 'Магента';

  @override
  String get color_orange => 'Оранжево';

  @override
  String get color_pink => 'Розово';

  @override
  String get color_red => 'Червено';

  @override
  String get color_rust => 'Ръжда';

  @override
  String get color_teal => 'Тийл';

  @override
  String get text_contrast_mode => 'Контраст на текста';

  @override
  String get contrast_high => 'Високо';

  @override
  String get contrast_medium => 'Среден';

  @override
  String get contrast_low => 'Ниско';

  @override
  String get product_refresher_internet_not_found => 'Продъктът не е открит!';

  @override
  String get product_refresher_internet_not_connected =>
      'Нямате връзка с интернет!';

  @override
  String product_refresher_internet_no_ping(String? host) {
    return 'Сървърът не работи ($host)';
  }

  @override
  String product_refresher_internet_error(String? exception) {
    return 'Грешка на сървъра ($exception)';
  }

  @override
  String get product_loader_not_found_title => 'Продъктът не е открит!';

  @override
  String product_loader_not_found_message(String barcode) {
    return 'Продукт със следния баркод не съществува в нашата база данни: $barcode';
  }

  @override
  String get product_loader_network_error_title => 'Няма връзка с интернет!';

  @override
  String get product_loader_network_error_message =>
      'Моля, провери дали твоят смартфон има активирано WiFi или мобилни данни';

  @override
  String get page_not_found_title => 'Страницата не е намерена!';

  @override
  String get page_not_found_button => 'Върнете се на началната страница';

  @override
  String get download_data => 'Изтегляне на данните';

  @override
  String get download_top_products =>
      'Изтегли най-добрите 1000 продукта в твоята страна за незабавно сканиране';

  @override
  String download_top_n_products(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count продукти',
    );
    return 'Изтеглете най-добрите $_temp0 във вашата страна за незабавно сканиране';
  }

  @override
  String get download_in_progress =>
      'Изтегляне на данните\nТова може да отнеме известно време';

  @override
  String downloaded_products(int num) {
    return '$num добавени продукта';
  }

  @override
  String get update_offline_data => 'Актуализиране на офлайн данни за продукти';

  @override
  String get update_local_database_sub =>
      'Актуализирайте локалната база данни за продукти с най-новите данни от Open Food Facts';

  @override
  String get clear_local_database => 'Изчистване на офлайн данните за продукти';

  @override
  String get clear_local_database_sub =>
      'Изчистете всички данни за локални продукти от приложението си, за да освободите място';

  @override
  String deleted_products(int num) {
    return '$num продукта са изтрити';
  }

  @override
  String get loading => 'Зареждане…';

  @override
  String get know_more => 'Научи повече';

  @override
  String get offline_data_desc =>
      'Кликнете, за да научите повече за офлайн данните';

  @override
  String get offline_product_data_title => 'Офлайн данни за продукти';

  @override
  String available_for_download(int num) {
    return '$num налични продукта за незабавно сканиране';
  }

  @override
  String get country_selector_title => 'Изберете вашата държава:';

  @override
  String get currency_selector_title => 'Избери валута:';

  @override
  String get language_selector_title => 'Избери език:';

  @override
  String get language_selector_section_selected => 'Избрани езици';

  @override
  String get language_selector_section_frequently_used => 'Често използван';

  @override
  String get action_delete_list => 'Изтрий';

  @override
  String get action_change_list => 'Промяна на текущия списък';

  @override
  String get product_list_create => 'Създай';

  @override
  String get product_list_create_tooltip => 'Създай нов списък';

  @override
  String get nutriscore_generic => 'Nutri-Score';

  @override
  String get nutriscore_a => 'Нутри-оценка А';

  @override
  String get nutriscore_b => 'Нутри-скор Б';

  @override
  String get nutriscore_c => 'Nutri-Score C';

  @override
  String get nutriscore_d => 'Nutri-Score D';

  @override
  String get nutriscore_e => 'Nutri-Score E';

  @override
  String nutriscore_new_formula(String letter) {
    return 'Nutri-Score $letter (Ново изчисление)';
  }

  @override
  String get nutriscore_new_formula_title => 'Nutri-Score (Ново изчисление)';

  @override
  String get nutriscore_unknown => 'Неизвестен хранителен резултат';

  @override
  String get nutriscore_unknown_new_formula =>
      'Неизвестен Nutri-Score (ново изчисление)';

  @override
  String get nutriscore_not_applicable => 'Nutri-Score не е приложим';

  @override
  String get nutriscore_not_applicable_new_formula =>
      'Nutri-Score не е приложим (ново изчисление)';

  @override
  String get environmental_score_generic_new => 'Зелен-Резултат';

  @override
  String get environmental_score_a_new => 'Зелена оценка А';

  @override
  String get environmental_score_b_new => 'Зелена оценка B';

  @override
  String get environmental_score_c_new => 'Зелена оценка C';

  @override
  String get environmental_score_d_new => 'Зелена оценка D';

  @override
  String get environmental_score_e_new => 'Зелена оценка E';

  @override
  String get environmental_score_unknown_new => 'Неизвестен зелен резултат';

  @override
  String get environmental_score_not_applicable_new =>
      'Зеленият резултат не е приложим';

  @override
  String get nova_group_generic_new => 'Ултрапреработени храни - NOVA groups';

  @override
  String get nova_group_1 => 'НОВА Груп 1';

  @override
  String get nova_group_2 => 'НОВА Груп 2';

  @override
  String get nova_group_3 => 'НОВА Груп 3';

  @override
  String get nova_group_4 => 'НОВА Груп 4';

  @override
  String get nova_group_unknown => 'Неизвестна група NOVA';

  @override
  String get nutrition_facts => 'Нива на хранителни вещества';

  @override
  String get faq_title_partners => 'Партньори и меценати на НПО';

  @override
  String get faq_title_vision =>
      'Визията, мисията, ценностите и програмите на Open Food Facts';

  @override
  String get faq_title_install_beauty =>
      'Инсталирай Open Beauty Facts, за да създадеш козметична база данни';

  @override
  String get faq_title_install_pet =>
      'Инсталирай Open Pet Food Facts, за да създадеш база данни с храни за домашни любимци';

  @override
  String get faq_title_install_product =>
      'Инсталирайте Open Products Facts, за да създадете база данни за продукти и да удължите живота на обектите.';

  @override
  String get faq_nutriscore_nutriscore =>
      'Ново изчисление на Nutri-Score: какво е новото?';

  @override
  String get contact_title_pro_page =>
      'Професионалисти? Импортирайте продуктите си в Open Food Facts';

  @override
  String get contact_title_pro_email => 'Контакт с производителя';

  @override
  String get contact_title_press_page => 'Страница за пресата';

  @override
  String get contact_title_press_email => 'Контакт за пресата';

  @override
  String get contact_title_newsletter => 'Абонирай се за нашия бюлетин';

  @override
  String get contact_title_calendar =>
      'Абонирайте се за нашия общностен календар';

  @override
  String get hunger_games_loading_line1 => 'Моля, дайте ни няколко секунди…';

  @override
  String get hunger_games_loading_line2 => 'Изтегляме въпросите!';

  @override
  String get hunger_games_error_label =>
      'Аргх! Нещо се обърка… и не успяхме да заредим въпросите.';

  @override
  String get hunger_games_error_retry_button => 'Да опитаме отново!';

  @override
  String get reorder_attribute_action => 'Пренареждане на атрибутите';

  @override
  String get link_cant_be_opened =>
      'Тази връзка не може да бъде отворена на вашето устройство. Моля, проверете дали имате инсталиран браузър.';

  @override
  String knowledge_panel_page_title_no_title(String productName) {
    return 'Детайли за $productName';
  }

  @override
  String knowledge_panel_page_title(String pageName, String productName) {
    return 'Детайли за $pageName с $productName';
  }

  @override
  String get guide_title => 'Guide';

  @override
  String get guide_share_label => 'Сподели';

  @override
  String get guide_nutriscore_v2_title =>
      'The Nutri-Score is evolving: explanations!';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_title =>
      'Какво представлява Nutri-Score?';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph1 =>
      'The Nutri-Score is a logo which aims to inform you about the **nutritional quality of foods**.';

  @override
  String get guide_nutriscore_v2_what_is_nutriscore_paragraph2 =>
      'The color code varies from dark green (**A**) for the **healthiest** products to dark red (**E**) for the **less healthy** ones.';

  @override
  String get guide_nutriscore_v2_nutriscore_a_caption =>
      'Логото на Nutri-Score A';

  @override
  String get guide_nutriscore_v2_why_v2_title => 'Why is Nutri-Score evolving?';

  @override
  String get guide_nutriscore_v2_why_v2_intro =>
      'The Nutri-Score formula **is evolving** to provide better recommendations:';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_title =>
      'Better evaluate all drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg1_text =>
      'The comparative notes of **milk**, **dairy drinks** with added sugar and **vegetable** drinks were better differentiated in the new algorithm.';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_title =>
      'Better ranking of drinks';

  @override
  String get guide_nutriscore_v2_why_v2_arg2_text =>
      'The **sugar content** is better taken into account and favors **lowly sweetened** drinks.\\n**Sweeteners will also be penalized**: diet sodas will be downgraded from a B rating to between C and E. Water remains the recommended drink.';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_title =>
      'Salt and sugar penalized';

  @override
  String get guide_nutriscore_v2_why_v2_arg3_text =>
      'Products **too sweet** or **too salty** will see their **rating further downgraded**.';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_title =>
      'Hierarchy within oils and fishes';

  @override
  String get guide_nutriscore_v2_why_v2_arg4_text =>
      'The rating of certain **fatty fish** and **oils rich in good fats** will improve.';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_title => 'Limit red meat';

  @override
  String get guide_nutriscore_v2_why_v2_arg5_text =>
      'Consumption of **red meat should be limited**. This is why **poultry will be comparatively better ranked**.';

  @override
  String get guide_nutriscore_v2_new_logo_title =>
      'How to differentiate old Nutri-Score and new calculation?';

  @override
  String get guide_nutriscore_v2_new_logo_text =>
      'From now on, the logo can display a mention \"**New calculation**\" to clarify that this is indeed the new calculation.';

  @override
  String get guide_nutriscore_v2_new_logo_image_caption =>
      'The logo of the new Nutri-Score';

  @override
  String get guide_nutriscore_v2_where_title =>
      'Къде да намеря новото изчисление на Nutri-Score?';

  @override
  String get guide_nutriscore_v2_where_paragraph1 =>
      'Nutri-Score се прилага в 7 страни: Франция, Германия, Белгия, Испания, Люксембург, Нидерландия и Швейцария.';

  @override
  String get guide_nutriscore_v2_where_paragraph2 =>
      'Производителите имат най-много **2 години** след подписването на указа, за да заменят** старото изчисление с новото.';

  @override
  String get guide_nutriscore_v2_where_paragraph3 =>
      'Without waiting, you **will already find in the OpenFoodFacts application**, the new calculation, including if the manufacturers have not updated the score.';

  @override
  String get guide_nutriscore_v2_unchanged_title => 'What doesn\'t change';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph1 =>
      'The Nutri-Score is a score designed to **measure nutritional quality**. It is **complementary to the NOVA group** on **ultra-processed foods** (also present in the application).';

  @override
  String get guide_nutriscore_v2_unchanged_paragraph2 =>
      'For manufacturers, the display of the Nutri-Score **remains optional**.';

  @override
  String get guide_greenscore_title => 'Зелен-Резултат';

  @override
  String get guide_greenscore_what_is_greenscore_title =>
      'Какво е Зеленият резултат?';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph1 =>
      'Зеленият резултат е лого, което има за цел да ви информира за **въздействието на храната върху околната среда**.';

  @override
  String get guide_greenscore_what_is_greenscore_paragraph2 =>
      'Цветовият код варира от тъмнозелено (**A+**) за **най-малко въздействащите** продукти до тъмночервено (**F**) за **най-въздействащите** продукти.';

  @override
  String get guide_greenscore_logos_caption => 'Логотата на Green-Score';

  @override
  String get guide_greenscore_lca_title =>
      'Основното: Оценка на жизнения цикъл (LCA)';

  @override
  String get guide_greenscore_lca_arg1_title =>
      'Научна оценка на категориите храни';

  @override
  String get guide_greenscore_lca_arg1_text1 =>
      'За всяка продуктова категория се определя **бенчмарк** резултат, използвайки данни от екологичната база данни Agribalyse (разработена от ADEME и INRAE).';

  @override
  String get guide_greenscore_lca_arg1_text2 =>
      '**Анализът на жизнения цикъл** е стандартизиран метод за оценка, който се използва за извършване на многоетапна и многокритериална екологична оценка.';

  @override
  String get guide_greenscore_lca_arg1_text3 => '**Измерва:**';

  @override
  String get guide_greenscore_lca_arg2_title => '6 производствени стъпки';

  @override
  String get guide_greenscore_lca_arg2_agriculture => 'Земеделие';

  @override
  String get guide_greenscore_lca_arg2_processing => 'Преработка';

  @override
  String get guide_greenscore_lca_arg2_packaging => 'Опаковка';

  @override
  String get guide_greenscore_lca_arg2_transportation => 'Транспортиране';

  @override
  String get guide_greenscore_lca_arg2_distribution => 'Дистрибуция';

  @override
  String get guide_greenscore_lca_arg2_consumption => 'Потребление';

  @override
  String get guide_greenscore_lca_arg3_title =>
      '14 показателя за въздействие върху околната среда';

  @override
  String get guide_greenscore_lca_arg3_text1 =>
      'Изменение на климата/въглероден отпечатък';

  @override
  String get guide_greenscore_lca_arg3_text2 => 'Изчерпване на озоновия слой';

  @override
  String get guide_greenscore_lca_arg3_text3 => 'Йонизиращо лъчение';

  @override
  String get guide_greenscore_lca_arg3_text4 => 'Земя';

  @override
  String get guide_greenscore_lca_arg3_text5 => 'Потребление на вода и енергия';

  @override
  String get guide_greenscore_lca_arg3_text6 => 'Замърсяване на въздуха';

  @override
  String get guide_greenscore_lca_arg3_text7 =>
      'Морска и сладка вода (частици, подкиселяване, еутрофикация)';

  @override
  String get guide_greenscore_lca_arg3_text8 => 'Изчерпване на ресурсите.';

  @override
  String get guide_greenscore_bonuses_penalties_title => 'Бонуси и наказания';

  @override
  String get guide_greenscore_bonuses_penalties_intro =>
      'За да възнаградим по-добрите продукти в дадена категория, ние прилагаме **бонуси и санкции въз основа на няколко критерия**:';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_title =>
      'Начин на производство';

  @override
  String get guide_greenscore_bonuses_penalties_arg1_text =>
      '**Бонус** се присъжда на продукти, които имат **официален етикет, етикет или сертификат, гарантиращ ползи за околната среда** (органичен, справедлива търговия, HVE, Label Rouge, Bleu Blanc Cœur, MSC/ASC).';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_title =>
      'Произход на съставките';

  @override
  String get guide_greenscore_bonuses_penalties_arg2_text =>
      '**Бонус** се присъжда въз основа на произхода на съставките. Този бонус отчита **въздействието върху транспорта**, както и **екологичната политика** на всяка държава производител.';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_title =>
      'Застрашени видове';

  @override
  String get guide_greenscore_bonuses_penalties_arg3_text =>
      'Налага се **санкция** на продукти, съдържащи съставки, които имат значително **отрицателно въздействие върху биоразнообразието и екосистемите**, като например палмово масло, чието производство е причина за масовото обезлесяване.';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_title => 'Опаковка';

  @override
  String get guide_greenscore_bonuses_penalties_arg4_text =>
      'Изчислява се **глоба**, като се вземат предвид **кръговият характер на опаковките** (използване на рециклирани суровини и рециклируемост) и прекомерното опаковане.';

  @override
  String get guide_greenscore_transparency_title =>
      'Повишена нужда от прозрачност за по-добро измерване и намаляване на въздействието върху околната среда';

  @override
  String get guide_greenscore_transparency_intro1 =>
      'За да се изчисли точно Green-Score, е необходимо да има **информация, която не е задължително да е посочена на опаковката** (като произход и точния процент на всяка съставка) или която рядко е налична в използваема форма (като например списък на всички компоненти на опаковката с точните видове използвани пластмаси).';

  @override
  String get guide_greenscore_transparency_intro2 =>
      '**Средни стойности се използват, когато тази информация все още не е налична**, но сега призоваваме всички да ни помогнат да съберем тази информация, която ще бъде много полезна за Green-Score, но и за много други приложения.';

  @override
  String get guide_greenscore_transparency_arg1_title =>
      'Как могат да помогнат гражданите?';

  @override
  String get guide_greenscore_transparency_arg1_text =>
      'Всички граждани могат да ни помогнат да съберем и структурираме информацията, която се намира върху продуктите или която може да бъде извлечена от тях, като например информация за **опаковките**: „Мисия Emballages“: мащабен съвместен инвентар на опаковките за всички хранителни продукти (на френски език).';

  @override
  String get guide_greenscore_transparency_arg2_title =>
      'Как производителите могат да помогнат';

  @override
  String get guide_greenscore_transparency_arg2_text =>
      'Производителите могат да ни изпращат информацията си директно чрез нашата безплатна платформа за производители.';

  @override
  String get guide_greenscore_better_product_title =>
      'Кой продукт е по-добър за планетата?';

  @override
  String get guide_greenscore_better_product_arg1_title =>
      'Трудно е да се каже';

  @override
  String get guide_greenscore_better_product_arg1_text =>
      'Изборът на устойчива храна е едно от най-мощните неща, които можем да направим за климата, тъй като **нашата глобална хранителна система е отговорна за над една четвърт от всички емисии на парникови газове**.\n(Източник: Poore & Nemecek, Science, 2018).';

  @override
  String get guide_greenscore_better_product_arg2_title => 'Ти имаш силата!';

  @override
  String get guide_greenscore_better_product_arg2_text =>
      'Добрата новина е, че това ни дава мощен начин да създадем промяна.\n**Всеки от нас изяжда около 1000 пъти годишно**. Това са 1000 възможности да **изберем по-добро бъдеще за планетата**!';

  @override
  String get guide_greenscore_better_product_arg3_title =>
      'Помага да бъдете отговорни и да вземате решения';

  @override
  String get guide_greenscore_better_product_arg3_text =>
      'Изборът на устойчива храна може да изглежда сложен. Етикетите са объркващи и информацията често липсва. Green-Score е създаден, за да го опрости, като ви дава **ясна**, **научно обоснована** и **прозрачна** екологична оценка за хранителни продукти, точно там, където ви е необходима: докато пазарувате.';

  @override
  String get guide_greenscore_better_product_arg4_title => 'Прозрачност';

  @override
  String get guide_greenscore_better_product_arg4_text =>
      'За разлика от патентованите етикети, изчислението на Green-Score е **напълно отворено** и може да бъде **проверено от всеки**.';

  @override
  String get guide_nova_title => 'Свръхпреработени храни';

  @override
  String get guide_nova_what_is_nova_title => 'Какво е ултра-обработка?';

  @override
  String get guide_nova_what_is_nova_paragraph1 =>
      'Групите NOVA ви информират за нивото на обработка на храните.';

  @override
  String get guide_nova_what_is_nova_paragraph2 =>
      'Класификацията NOVA позволява категоризирането на храните в **4 групи** въз основа на тяхната **степен на промишлена обработка** (минимално преработени или непреработени храни, кулинарни съставки, преработени храни, ултрапреработени храни).';

  @override
  String get guide_nova_logos_caption => 'Логотата на NOVA';

  @override
  String get guide_nova_groups_title => '4-те NOVA групи';

  @override
  String get guide_nova_groups_intro =>
      'Има 4 групи NOVA, като проблемната е Група 4 - Ултрапреработени храни.';

  @override
  String get guide_nova_groups_arg1_title =>
      'Минимално преработени или непреработени храни';

  @override
  String get guide_nova_groups_arg1_text =>
      'Непреработените (или натурални) храни са **ядливите части на растения** (семена, плодове, листа, стъбла, корени) **или животни** (мускули, карантии, яйца, мляко), както и гъби, водорасли и вода, след като са отделени от природата.';

  @override
  String get guide_nova_groups_arg2_title => 'Преработени кулинарни съставки';

  @override
  String get guide_nova_groups_arg2_text =>
      'Преработените кулинарни съставки, като **масла, масло, захар и сол**, са вещества, получени от храни от Група 1 или от природата чрез процеси, които включват пресоване, рафиниране, смилане, фрезоване и сушене.';

  @override
  String get guide_nova_groups_arg3_title => 'Преработени храни';

  @override
  String get guide_nova_groups_arg3_text =>
      'Processed foods, such as bottled vegetables, canned fish, fruits in syrup, cheeses, and freshly made breads, are **primarily made by adding salt, oil, sugar, or other substances from group 2 to group 1** foods. Processes include Various preservation or cooking methods, and in the case of breads and cheese, non-alcoholic fermentation. most Processed foods have two or three ingredients and are recognizable as modified versions of group 1 foods. They can Be eaten on their own or, more commonly, in combination with other foods.';

  @override
  String get guide_nova_groups_arg4_title => 'Свръхпреработени храни';

  @override
  String get guide_nova_groups_arg4_text =>
      'Ultra-processed foods, such as soft drinks, sweet or savory packaged snacks, reconstituted meat products, and pre-prepared frozen dishes, **are not merely modified foods but formulations made mostly or entirely from substances derived from foods and additives**, with little to no intact group 1 Food. Ingredients In these formulations usually include those also found in processed foods, such as sugars, oils, fats, or salt. however, ultra-Processed products also contain other sources of energy and nutrients not typically used in culinary preparations. some of these are Directly extracted from foods, such as casein, lactose, whey, and gluten.';

  @override
  String get guide_nova_explanations_title => 'Проблемите с ултра-обработката';

  @override
  String get guide_nova_explanations_arg1_title =>
      'Екстремна обработка на хранителни съставки';

  @override
  String get guide_nova_explanations_arg1_text =>
      'Много от тях са **получени от по-нататъшна обработка на хранителни съставки**, като например хидрогенирани или интерестерифицирани масла, хидролизирани протеини, соев протеинов изолат, малтодекстрин, инвертна захар и царевичен сироп с високо съдържание на фруктоза.';

  @override
  String get guide_nova_explanations_arg2_title =>
      'Добавки, които надхвърлят чистата безопасност на храните';

  @override
  String get guide_nova_explanations_arg2_text =>
      'Добавките в ултрапреработените храни включват някои, които се използват и в преработените храни, като консерванти, антиоксиданти и стабилизатори. Класовете добавки, които се срещат само в ултрапреработените продукти, включват тези, използвани **за имитиране или подобряване на сензорните качества на храните или за прикриване на неприятни аспекти на крайния продукт**. Тези добавки включват оцветители и други цветове, стабилизатори на цветовете; ароматизатори, подобрители на вкуса, подсладители без захар; и помощни вещества за обработка, като карбонизиращи, втвърдяващи, обемни и антиобемни агенти, обезпенващи, антислепващи и глазиращи агенти, емулгатори, секвестранти и овлажнители.';

  @override
  String get guide_nova_explanations_arg3_title =>
      'Обработка, която не можете да направите у дома';

  @override
  String get guide_nova_explanations_arg3_text =>
      '**Използва се множество последователности от процеси**, за да се комбинират обикновено многото съставки и да се създаде крайният продукт (оттук и „ултраобработен“). Процесите включват няколко **без местни еквиваленти**, като хидрогениране и хидролизация, екструдиране и формоване, както и предварителна обработка за пържене.';

  @override
  String get guide_nova_explanations_arg4_title =>
      'Хищническите и финансовите аспекти на ултра-преработката';

  @override
  String get guide_nova_explanations_arg4_text =>
      '**Общата цел на ултрапреработката е да се създадат маркови**, **удобни** (трайни, готови за консумация), **атрактивни** (свръхвкусни) и **високорентабилни** (с евтини съставки) хранителни продукти, предназначени да изместят всички останали хранителни групи. Ултрапреработените хранителни продукти обикновено са атрактивно опаковани и се предлагат на пазара интензивно.';

  @override
  String get guide_nova_explanations_arg5_title => 'Опасност за здравето';

  @override
  String get guide_nova_explanations_arg5_text =>
      'От 2018 г. насам, с NutriNet-Santé, бяха подчертани първите връзки между **консумацията на ултрапреработени храни и повишения риск от рак, сърдечно-съдови заболявания и диабет**. Днес повече от 90 проучвания по целия свят потвърждават тези открития.\nНай-силните връзки са свързани със **затлъстяването, сърдечно-съдовата смъртност и депресивните симптоми**. При децата ефектите се наблюдават предимно върху теглото и липидния дисбаланс.';

  @override
  String get guide_nova_explanations_arg6_title =>
      'Държавите препоръчват ограничаването им';

  @override
  String get guide_nova_explanations_arg6_text =>
      'Някои държави използват групите NOVA за своите хранителни насоки или цели, например:\n\n- **🇧🇷 Бразилските хранителни насоки **препоръчват ограничаване на консумацията** на преработени храни и избягване на ултрапреработени храни.\n\n- **🇫🇷 Франция** - Целите на политиката за обществено здраве в областта на храненето за периода 2018-2022 г. са **намаляване на консумацията на ултрапреработени храни от група 4 с 20%**.';

  @override
  String get guide_nova_share_link => 'https://world-bg.openfoodfacts.org/nova';

  @override
  String get guide_open_food_facts_title => 'Добре дошли в Open Food Facts!';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_title =>
      'Какво представляват откритите факти за храната?';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph1 =>
      'Open Food Facts е **съвместна**, **безплатна** и **отворена** база данни за хранителни продукти от цял свят.';

  @override
  String get guide_open_food_facts_what_is_open_food_facts_paragraph2 =>
      'Вярваме, че всеки трябва да има достъп до информация за това, което яде. Чрез събиране на данни за съставки, алергени, хранителна стойност и други, **ние даваме възможност на потребителите да правят информиран избор** и насочваме хранителната индустрия **към по-голяма прозрачност**.';

  @override
  String get guide_open_food_facts_features_title =>
      'Характеристики на Open Food Facts';

  @override
  String get guide_open_food_facts_features_arg1_title =>
      'Получавайте известия за нежелани съставки';

  @override
  String get guide_open_food_facts_tips_title =>
      'Съвети за правене на страхотни снимки';

  @override
  String get guide_open_food_facts_tips_arg1_title => 'Не правете';

  @override
  String get guide_open_food_facts_tips_arg1_text1 =>
      'Избягвайте сенки и отблясъци.';

  @override
  String get guide_open_food_facts_tips_arg1_text2 =>
      'Без размазан или нефокусиран текст.';

  @override
  String get guide_open_food_facts_tips_arg1_text3 =>
      'Не изрязвайте части от текста.';

  @override
  String get guide_open_food_facts_tips_arg1_text4 =>
      'Избягвайте натоварени фонове.';

  @override
  String get guide_open_food_facts_tips_arg2_title => 'Какво да правите';

  @override
  String get guide_open_food_facts_tips_arg2_text1 =>
      'Използвайте добро, равномерно осветление.';

  @override
  String get guide_open_food_facts_tips_arg2_text2 =>
      'Уверете се, че текстът е ясен и четлив.';

  @override
  String get guide_open_food_facts_tips_arg2_text3 =>
      'Запишете целия списък със съставки.';

  @override
  String get guide_open_food_facts_tips_arg2_text4 =>
      'Дръжте продукта върху равна повърхност.';

  @override
  String get guide_open_food_facts_scores_title =>
      'Помогнете ни да изградим „Уикипедия за храната“';

  @override
  String get guide_open_food_facts_scores_arg1_title =>
      'Оценка за хранителното качество';

  @override
  String get guide_open_food_facts_scores_arg2_title =>
      'Резултат за избягване на ултрапреработени храни';

  @override
  String get guide_open_food_facts_scores_arg3_title => 'Резултат за планетата';

  @override
  String get guide_open_food_facts_share_link =>
      'https://world-bg.openfoodfacts.org/discover';

  @override
  String get guide_open_pet_food_facts_title =>
      'Добре дошли в Open Pet Food Facts!';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_title =>
      'Какво представляват фактите за храната за домашни любимци в Open Pet Food?';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph1 =>
      'Open Pet Food Facts разширява мисията ни към нашите пухкави приятели! Това е **база данни с храни за домашни любимци за котки, кучета и други домашни любимци**.';

  @override
  String get guide_open_pet_food_facts_what_is_open_pet_food_facts_paragraph2 =>
      'Събираме информация за **съставките**, **хранителния анализ** и насоките за хранене, за да помогнем на собствениците на домашни любимци да изберат най-добрата храна за нуждите на своите животни.';

  @override
  String get guide_open_pet_food_facts_features_title =>
      'Характеристики на Open Pet Food Facts';

  @override
  String get guide_open_pet_food_facts_features_arg1_title =>
      'Получавайте известия за нежелани съставки';

  @override
  String get guide_open_pet_food_facts_features_arg1_paragraph1 =>
      'Вашият домашен любимец алергичен ли е към някакви съставки? Можете да зададете списък с козметични съставки, които да избягвате, директно в приложението!';

  @override
  String get guide_open_pet_food_facts_tips_title =>
      'Съвети за правене на страхотни снимки';

  @override
  String get guide_open_pet_food_facts_tips_arg1_title => 'Не правете';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text1 =>
      'Избягвайте сенки и отблясъци.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text2 =>
      'Без размазан или нефокусиран текст.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text3 =>
      'Не изрязвайте части от текста.';

  @override
  String get guide_open_pet_food_facts_tips_arg1_text4 =>
      'Избягвайте натоварени фонове.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_title => 'Какво да правите';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text1 =>
      'Използвайте добро, равномерно осветление.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text2 =>
      'Уверете се, че текстът е ясен и четлив.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text3 =>
      'Запишете целия списък със съставки.';

  @override
  String get guide_open_pet_food_facts_tips_arg2_text4 =>
      'Дръжте продукта върху равна повърхност.';

  @override
  String get guide_open_pet_food_facts_scores_title =>
      'Бележка относно точкуването';

  @override
  String get guide_open_pet_food_facts_scores_paragraph1 =>
      'Разработването на система за оценяване на храната за домашни любимци **не е приоритет в момента**. Методологията би била сложна, тъй като хранителните нужди варират значително в зависимост от вида, възрастта и здравословното състояние. Все още не сме открили независим научен екип, който да е способен да разработи такава система за оценяване.';

  @override
  String get guide_open_pet_food_facts_share_link =>
      'https://world-bg.openpetfoodfacts.org/discover';

  @override
  String get guide_open_beauty_facts_title =>
      'Добре дошли в „Открити факти за красотата“!';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_title =>
      'Какво представляват откритите факти за красотата?';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph1 =>
      'Open Beauty Facts е съвместна база данни за **козметични продукти**.';

  @override
  String get guide_open_beauty_facts_what_is_open_beauty_facts_paragraph2 =>
      'Нашата цел е да разшифроваме списъците със съставки, за да ви помогнем да **разберете какво има във вашите продукти за лична хигиена**. От хидратиращи кремове до гримове, ние събираме данни за съставките, алергените и опаковките, за да насърчим прозрачността в козметичната индустрия.';

  @override
  String get guide_open_beauty_facts_features_title =>
      'Характеристики на Open Beauty Facts';

  @override
  String get guide_open_beauty_facts_features_arg1_title =>
      'Получавайте известия за нежелани съставки';

  @override
  String get guide_open_beauty_facts_features_arg1_paragraph1 =>
      'Алергични ли сте към някакви съставки? Искате да избягвате комедогенни вещества? Искате да се пазите от спорни компоненти? Можете да зададете списък с козметични съставки, които да избягвате, директно в приложението!';

  @override
  String get guide_open_beauty_facts_tips_title =>
      'Съвети за правене на страхотни снимки';

  @override
  String get guide_open_beauty_facts_tips_arg1_title => 'Не правете';

  @override
  String get guide_open_beauty_facts_tips_arg1_text1 =>
      'Избягвайте сенки и отблясъци.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text2 =>
      'Без размазан или нефокусиран текст.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text3 =>
      'Не изрязвайте части от текста.';

  @override
  String get guide_open_beauty_facts_tips_arg1_text4 =>
      'Избягвайте натоварени фонове.';

  @override
  String get guide_open_beauty_facts_tips_arg2_title => 'Какво да правите';

  @override
  String get guide_open_beauty_facts_tips_arg2_text1 =>
      'Използвайте добро, равномерно осветление.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text2 =>
      'Уверете се, че текстът е ясен и четлив.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text3 =>
      'Запишете целия списък със съставки.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text4 =>
      'Направете колкото е необходимо снимки, ако бутилката е извита.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text5 =>
      'Може да се наложи да отлепите етикета, за да видите списъка със съставките.';

  @override
  String get guide_open_beauty_facts_tips_arg2_text6 =>
      'Дръжте продукта върху равна повърхност.';

  @override
  String get guide_open_beauty_facts_scores_title =>
      'Бележка относно точкуването';

  @override
  String get guide_open_beauty_facts_scores_paragraph1 =>
      'За разлика от хранителните продукти, светът на козметиката **няма универсално призната, подкрепяна от правителството система за оценяване като Nutri-Score**. Ефектите на съставките могат да бъдат силно индивидуални и да зависят от типа кожа, алергиите и индивидуалните проблеми.';

  @override
  String get guide_open_beauty_facts_share_link =>
      'https://world-bg.openbeautyfacts.org/discover';

  @override
  String get guide_open_prices_title => 'Добре дошли в „Отворени цени“!';

  @override
  String get guide_open_prices_what_is_open_prices_title =>
      'Какво представляват отворените цени?';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph1 =>
      'Open Prices е проект за **събиране и споделяне на цени на продукти по целия свят**. Това е публично достъпен набор от данни, който може да се използва за изследвания, анализи и други. Open Prices е разработен и поддържан от Open Food Facts.';

  @override
  String get guide_open_prices_what_is_open_prices_paragraph2 =>
      'There are currently few companies that own large databases of product prices at the barcode level. These prices are not freely available, but sold at a high price to private actors, researchers and other organizations that can afford them.';

  @override
  String get guide_open_prices_how_title => 'Как работят отворените цени?';

  @override
  String get guide_open_prices_how_paragraph1 =>
      '**Ние използваме краудсорсинг за събиране на данни с отворен код за цени**. Цените могат да бъдат добавяни от потребителите чрез това уеб приложение или чрез официалното мобилно приложение Open Food Facts. Търговците на дребно или приложения на трети страни също могат да допринесат, като използват нашия API.';

  @override
  String get guide_open_prices_how_arg1_title =>
      'Събирайте снимки на етикети с цени по пътеките';

  @override
  String get guide_open_prices_how_arg2_title =>
      'Събирайте снимки на касови бележки';

  @override
  String get guide_open_prices_why_title => 'Защо Open Food Facts прави това?';

  @override
  String get guide_open_prices_why_paragraph1 =>
      'Информацията за цените е от първостепенно значение за разбирането на хранителните системи. Тя е ключов фактор за разбирането на цената на храната и за насърчаване на по-здравословно хранене. Данните за началните цени са начин да се улесни за изследователите, журналистите и гражданите **да разберат по-добре как цените на храните варират географски и във времето**.';

  @override
  String get guide_open_prices_why_arg1_title =>
      'Проследяване на развитието на цените във времето';

  @override
  String get guide_open_prices_why_arg1_text =>
      'Вижте **еволюцията на цените**: свиваща се инфлация, евтина инфлация, можем да ги проследим заедно!';

  @override
  String get guide_open_prices_why_arg2_title => 'Сравнете цените близо до вас';

  @override
  String get guide_open_prices_why_arg2_text =>
      'С нарастващата информация за цените, можете да откриете **най-евтините магазини около вас**.';

  @override
  String get guide_open_prices_scrapping_title =>
      'Обмисляли ли сте да вземете цени от уебсайтовете на търговците на дребно?';

  @override
  String get guide_open_prices_scrapping_paragraph1 =>
      'Поради правни и технически причини, **не считаме извличането на цени от уебсайтовете на търговците на дребно за валиден начин за допринасяне за Open Prices**. Искаме да се уверим, че цените, които събираме, са точни и актуални, а получаването на извлечени цени от други участници не ни позволява да правим това.';

  @override
  String get guide_open_prices_scrapping_paragraph2 =>
      'Извличането на данни от цените е обмисляна опция в бъдеща версия на Open Prices, но това ще се извършва от самия Open Prices, за да можем да имаме доказателство за цената въз основа на HTML страницата.';

  @override
  String get guide_open_prices_retailers_title =>
      'I\'m a retailer and I want to contribute prices. How can I do that?';

  @override
  String get guide_open_prices_retailers_paragraph1 =>
      'Можете да предоставите цени, като използвате нашия API.\nАко искате да предоставите цени в голям мащаб, моля, свържете се с нас на prices@openfoodfacts.org.';

  @override
  String get guide_open_prices_share_link =>
      'https://prices.openfoodfacts.org/about';

  @override
  String get guide_open_products_facts_title =>
      'Добре дошли във фактите за отворените продукти!';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_title =>
      'Какво представляват фактите за отворените продукти?';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph1 =>
      'Open Products Facts е огромна, отворена база данни за **всеки продукт с баркод, който не е храна, козметика или храна за домашни любимци**.';

  @override
  String get guide_open_products_facts_what_is_open_products_facts_paragraph2 =>
      'От **електроника** до **играчки** и от **дрехи** до **почистващи препарати**, ако има баркод, той може да бъде добавен. Този проект има за цел да създаде „интернет на нещата“ за предмети от ежедневието, като направи информацията за тях универсално достъпна.';

  @override
  String get guide_open_products_facts_features_title =>
      'Характеристики на отворените продукти Факти';

  @override
  String get guide_open_products_facts_features_text =>
      '„Open Products Facts“ има за цел да предостави на потребителите възможност за **удължаване на живота на предметите**, като им предоставя кръгови решения за поддръжка, **ремонт**, **рециклиране** на предметите или за даване на нов собственик.';

  @override
  String get guide_open_products_facts_features_arg1_title =>
      'Въглероден отпечатък за някои продукти';

  @override
  String get guide_open_products_facts_features_arg1_text =>
      '**Въздействие на CO2** от френската агенция по околна среда ADEME предоставя **въглеродното въздействие** на много категории, уверете се, че категоризирате продуктите точно.';

  @override
  String get guide_open_products_facts_features_arg2_title =>
      'Индекс на ремонтопригодност за много продукти';

  @override
  String get guide_open_products_facts_features_arg2_text =>
      'Винаги, когато е наличен френски индекс за ремонтопригодност, ще го покажем. Освен това, **можете да започнете да събирате променливите, използвайки Folksonomy Engine**; така че да можем сами да го преизчислим в бъдеще, дори в страни, където не е наличен.';

  @override
  String get guide_open_products_facts_features_arg3_title =>
      'Намерете начини да дарите/препродадете продукта си';

  @override
  String get guide_open_products_facts_features_arg3_text =>
      'Предоставяме връзки към **услуги на трети страни, съобразени с принципите на кръговата икономика**, които ви помагат да получите продукта, който търсите, като продукт втора употреба, за да бъдем по-щадящи за планетарните ресурси.\nОбърнете внимание, че не ни се плаща за това и че системата работи само като пример за два уебсайта във Франция. Можете да помогнете за разширяването на тази система, като документирате още сайтове в уикито.';

  @override
  String get guide_open_products_facts_information_title =>
      'Каква информация е полезна?';

  @override
  String get guide_open_products_facts_information_text =>
      'За толкова широк набор от артикули, **данните, които събираме, са гъвкави**. За да направим това, **създадохме Folksonomy Engine**.';

  @override
  String get guide_open_products_facts_folksonomy_title =>
      'Двигателят на фолксономията';

  @override
  String get guide_open_products_facts_folksonomy_paragraph1 =>
      'Folksonomy Engine е инструмент, който ви помага да допълвате продукти със съответните свойства. Това помага за подобряване на търсенето и откриваемостта, но също така и за изчисляване и показване на интересни неща в бъдеще.';

  @override
  String get guide_open_products_facts_folksonomy_paragraph2 =>
      'Можете да добавите всякакви ключове и стойности, като например: **compatibility_with_5G_mobile_network: yes**';

  @override
  String get guide_open_products_facts_folksonomy_paragraph3 =>
      'Ще получите автоматично предлагане на възможни свойства и сте добре дошли да добавяте и документирате нови за любимите си видове продукти.';

  @override
  String get guide_open_products_facts_share_link =>
      'https://world-bg.openproductsfacts.org/discover';

  @override
  String get guide_open_preferences_button_title =>
      'Отворете предпочитанията си за храна';

  @override
  String get guide_coming_soon_button_title => 'Очаквайте скоро';

  @override
  String get guide_learn_more_subtitle => 'Докоснете, за да научите повече';

  @override
  String get preview_badge => 'Преглед';

  @override
  String get prices_feedback_form =>
      'Кликнете тук, за да ни изпратите отзивите си за тази нова функция!';

  @override
  String get menu_button_list_actions => 'Изберете действие';

  @override
  String get error_loading_photo => 'Грешка при зареждане на снимката';

  @override
  String get photo_viewer_action_use_picture_as => 'Използвай като…';

  @override
  String get photo_viewer_use_picture_as_tooltip =>
      'Използвайте тази снимка като…';

  @override
  String photo_viewer_use_picture_as_title(String language) {
    return 'Използвайте тази снимка като… ($language)';
  }

  @override
  String get photo_viewer_details_button => 'Детайли';

  @override
  String get photo_viewer_details_button_accessibility_label =>
      'Подробности за тази снимка';

  @override
  String get photo_viewer_details_title => 'Детайли на снимката';

  @override
  String get photo_viewer_details_contributor_title => 'Сътрудник';

  @override
  String get photo_viewer_details_size_title => 'Размер';

  @override
  String photo_viewer_details_size_value(int width, int height) {
    return '$width x $height пиксела';
  }

  @override
  String get photo_viewer_details_date_title => 'Дата';

  @override
  String get photo_viewer_details_url_title => 'URL адрес';

  @override
  String get product_page_compatibility_score => 'Съвместим';

  @override
  String get user_lists_action_multi_select => 'Многократен избор';

  @override
  String product_page_compatibility_score_tooltip(String score) {
    return 'Вашият резултат за съвместимост: $score%';
  }

  @override
  String get product_image_front_accessibility_label => 'Предна снимка';

  @override
  String get product_image_ingredients_accessibility_label =>
      'Снимка на съставките';

  @override
  String get product_image_nutrition_accessibility_label =>
      'Хранителна картина';

  @override
  String get product_image_packaging_accessibility_label =>
      'Снимка на опаковката';

  @override
  String get product_image_other_accessibility_label => 'Друга снимка';

  @override
  String get product_image_outdated_message => 'Тази снимка може да е остаряла';

  @override
  String product_image_outdated_message_accessibility_label(String type) {
    return '$type (това изображение може да е остаряло)';
  }

  @override
  String product_image_locked_message_accessibility_label(String type) {
    return '$type (това изображение може да е заключено от продуцента)';
  }

  @override
  String get product_image_error => 'Не може да се зареди изображението!';

  @override
  String product_image_error_accessibility_label(String type) {
    return 'Не може да се зареди $type (мрежова грешка?)';
  }

  @override
  String get product_page_image_no_image_available => 'Няма\nизображение!';

  @override
  String get product_page_image_no_image_available_accessibility_label =>
      'Няма налична снимка за този продукт';

  @override
  String get product_page_action_bar_settings_accessibility_label =>
      'Пренареждане или скриване на действия';

  @override
  String get product_page_action_bar_setting_modal_title =>
      'Редактиране на действия';

  @override
  String get product_page_action_bar_item_move_up => 'Премести нагоре';

  @override
  String get product_page_action_bar_item_move_down => 'Премести надолу';

  @override
  String get product_page_action_bar_item_enable => 'Активиране на действие';

  @override
  String get product_page_action_bar_item_disable =>
      'Деактивиране на действието';

  @override
  String get product_page_pending_operations_banner_title =>
      'Качване на вашите редакции…';

  @override
  String get product_page_pending_operations_banner_message =>
      'Данните, показани на тази страница, **все още не отразяват вашите промени**.\nМоля, изчакайте няколко секунди…';

  @override
  String get product_add_a_language => 'Добавяне на език';

  @override
  String barcode_accessibility_label(String barcode) {
    return 'Баркод $barcode';
  }

  @override
  String get carousel_close_tooltip => 'Премахнете този продукт от карусела';

  @override
  String get carousel_unsupported_header => 'Неподдържан баркод!';

  @override
  String get carousel_unsupported_title => 'Опа!';

  @override
  String get carousel_unsupported_text =>
      'Сканираният баркод не се поддържа от Open Food Facts!';

  @override
  String get carousel_error_header => 'Грешка!';

  @override
  String get carousel_error_title => 'Това е голям жалко!';

  @override
  String get carousel_error_text_1 =>
      'Не успяхме да изтеглим информацията за този баркод:';

  @override
  String get carousel_error_text_2 =>
      'Моля, проверете интернет връзката си или кликнете върху този бутон:';

  @override
  String get carousel_error_button => 'Повторен опит';

  @override
  String get carousel_unknown_product_header => 'Неизвестен продукт';

  @override
  String get carousel_unknown_product_title =>
      'Поздравления!\nОткрихте __рядкото бижу!__';

  @override
  String get carousel_unknown_product_text =>
      'Нашата съвместна база данни съдържа повече от **3 милиона продукта**, но този баркод не съществува: ';

  @override
  String get carousel_unknown_product_button => 'Добави продукта';

  @override
  String get carousel_loading_header => 'Зареждане на информация...';

  @override
  String get carousel_loading_title =>
      'Току-що сканирахте продукт със следния баркод:';

  @override
  String get carousel_loading_text =>
      'Търсим го в нашата база данни с повече от **3 милиона продукта!**';

  @override
  String get product_type_subtitle_food =>
      'Зеленчуци, плодове, замразени храни…';

  @override
  String get product_type_subtitle_beauty => 'Грим, сапуни, пасти за зъби…';

  @override
  String get product_type_subtitle_pet_food => 'Храна за кучета, котки…';

  @override
  String get product_type_subtitle_product => 'Смартфони, мебели…';

  @override
  String get photo_field_front => 'Снимка на продукта';

  @override
  String get photo_field_ingredients => 'Снимка на съставките';

  @override
  String get photo_field_nutrition => 'Снимка за хранене';

  @override
  String get photo_field_packaging => 'Снимка с информация за опаковката';

  @override
  String get photo_already_exists => 'Тази снимка вече съществува';

  @override
  String get photo_missing => 'Тази снимка липсва';

  @override
  String get date => 'Дата';

  @override
  String get photo_rotate_left => 'Завърти наляво';

  @override
  String get photo_rotate_right => 'Завърти надясно';

  @override
  String get photo_undo_action => 'Отмяна на предишното действие';

  @override
  String knowledge_panel_world_map_accessibility_label(String location) {
    return 'Карта на света на $location';
  }

  @override
  String get open_street_map_contributor_attribution =>
      'Сътрудници на OpenStreetMap';

  @override
  String get not_applicable_short => 'Няма данни';

  @override
  String get knowledge_panel_warning_text => 'Предупреждение';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_title =>
      'Защо този Nutri-Score е различен от този на опаковката?';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_message =>
      'Има две възможни обяснения:\nСписъкът със съставки и/или хранителните факти не са актуални.\n\nПредоставяме „Ново изчисление“ на Nutri-Score (или V2). Моля, проверете дали имате банера „Ново изчисление“ на опаковката.';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button1 =>
      'Проверете съставките';

  @override
  String get knowledge_panel_nutriscore_banner_incorrect_score_button2 =>
      'Проверете хранителните факти';

  @override
  String url_not_supported(String url) {
    return 'За съжаление, не можем да отворим URL адреса:\n$url';
  }

  @override
  String get product_list_export => 'Експорт';

  @override
  String get product_list_import => 'Внос';

  @override
  String get product_footer_action_barcode => 'Преглед на баркод';

  @override
  String get product_footer_action_barcode_short => 'Баркод';

  @override
  String get product_footer_action_open_website => 'Отвори уебсайта';

  @override
  String get product_footer_action_report => 'Доклад';

  @override
  String get product_footer_action_contributor_guide => 'Помощ';

  @override
  String get product_footer_action_data_quality_tags => 'Качество на данните';

  @override
  String get product_page_tab_for_me => 'За мен';

  @override
  String get product_page_tab_website => 'Уеб сайт';

  @override
  String get product_page_tab_prices => 'Цени';

  @override
  String get prices_explanation_card_title => 'Защо цени?';

  @override
  String get prices_explanation_card_line1 =>
      '**Open Prices** е проект за събиране и споделяне на цени на продукти по целия свят 🌍. Open Prices е разработен и поддържан от Open Food Facts.';

  @override
  String get explanation_card_learn_more_button => 'Научи повече';

  @override
  String get product_page_tab_folksonomy => 'Фолксономия';

  @override
  String get folksonomy_explanation_card_title =>
      'Какви са атрибутите на фолксономията?';

  @override
  String get folksonomy_explanation_card_line1 =>
      'Атрибутите са базирани на **ключ-стойност**.';

  @override
  String get folksonomy_explanation_card_line2 =>
      'Тези свойства се създават и подават от сътрудници за всякакъв вид употреба.';

  @override
  String get folksonomy_action_external_link_title => 'Отвори външна връзка';

  @override
  String get folksonomy_action_external_link_warning =>
      'Външните връзки може да са опасни. Наистина ли искате да го посетите?';

  @override
  String get prices_products_empty_title => 'Няма налична цена';

  @override
  String get prices_products_empty_explanation =>
      'Бъдете първият, който ще допринесе!';

  @override
  String prices_products_list_length_many_pages(int pageSize, int total) {
    return 'Най-популярни $pageSize продукти (общо: $total)';
  }

  @override
  String get app_review_title => 'Харесва ли ви това приложение?';

  @override
  String get app_review_low => 'Можеше да се справи по-добре';

  @override
  String get app_review_medium => 'Не е лошо';

  @override
  String get app_review_high => 'Обичам го!';

  @override
  String get app_review_feedback_modal_title =>
      'Помогнете ни да подобрим приложението си';

  @override
  String get app_review_feedback_modal_content =>
      'Ако имате няколко минути, бихте ли могли да попълните този формуляр, за да **можем да се подобрим в бъдещи актуализации**:';

  @override
  String get app_review_feedback_modal_open_form => 'Отговорете на формуляра';

  @override
  String get app_review_feedback_modal_later => 'Попитай по-късно';

  @override
  String get nutrition_facts_extract_new =>
      'НОВО: Можете автоматично да извличате хранителните вещества от снимката!';

  @override
  String get nutrition_facts_extract_button_text => 'Извличане сега';

  @override
  String get nutrition_facts_extract_in_progress => 'Извличането е в ход…';

  @override
  String get nutrition_facts_extract_successful => 'Извличането е успешно';

  @override
  String get nutrition_facts_extract_failed =>
      'Неуспешно извличане на хранителни вещества от снимката';

  @override
  String get prices_discount => 'Discount';

  @override
  String get prices_stats_statistics => 'Статистика';

  @override
  String get prices_stats_title => 'Статистика за цените';

  @override
  String get prices_stats_prices_section => 'Цени';

  @override
  String get prices_stats_products_section => 'Продукти';

  @override
  String get prices_stats_locations_section => 'Места';

  @override
  String get prices_stats_proofs_section => 'Proofs';

  @override
  String get prices_stats_contributors_section => 'Сътрудници';

  @override
  String get prices_stats_experiments_section => 'Experiments';

  @override
  String get prices_stats_misc_section => 'Разни';

  @override
  String get prices_stats_total => 'Общо';

  @override
  String get prices_stats_with_barcode => 'With a barcode';

  @override
  String get prices_stats_with_category => 'With a category';

  @override
  String get prices_stats_with_discount => 'With a discount';

  @override
  String get prices_stats_community => 'Community';

  @override
  String get prices_stats_consumption => 'Потребление';

  @override
  String get prices_stats_with_price => 'С цена';

  @override
  String get prices_stats_food => 'Храна';

  @override
  String get prices_stats_beauty => 'Beauty';

  @override
  String get prices_stats_products => 'Продукти';

  @override
  String get prices_stats_pet_food => 'Храна за домашни любимци';

  @override
  String get prices_stats_osm => 'OpenStreetMap';

  @override
  String get prices_stats_online => 'Online';

  @override
  String get prices_stats_countries => 'Страни';

  @override
  String get prices_stats_price_tag => 'Цена';

  @override
  String get prices_stats_receipt => 'Разписка';

  @override
  String get prices_stats_gdpr_request => 'GDPR request';

  @override
  String get prices_stats_shop_import => 'Shop import';

  @override
  String get prices_stats_challenges => 'Challenges';

  @override
  String get prices_stats_linked_to_price_tag => 'Prices linked to a price tag';

  @override
  String get prices_stats_currencies => 'Currencies';

  @override
  String get prices_stats_years => 'Years';

  @override
  String get prices_stats_by_source_title => 'Prices and proofs per source';

  @override
  String get prices_stats_website => 'Уеб сайт';

  @override
  String get prices_stats_mobile_app => 'Mobile app';

  @override
  String get prices_stats_api => 'API';

  @override
  String get prices_stats_other => 'Друго';

  @override
  String get prices_stats_last_updated => 'Последна актуализация на';

  @override
  String get prices_stats_error =>
      'Възникна грешка при зареждането на статистиката.';

  @override
  String get product_edit_robotoff_question_answered => 'Отговор на въпроса!';

  @override
  String get product_edit_robotoff_proof => 'Доказателство';

  @override
  String get preferences_card_general => 'Общи';

  @override
  String get preferences_prices_title => 'Цени';

  @override
  String get preferences_prices_subtitle =>
      'Управлявайте предпочитанията си за цени';

  @override
  String get preferences_card_project => 'Проектът „Отворени факти за храната“';

  @override
  String get preferences_contribute_title => 'Допринеси';

  @override
  String get preferences_my_contributions_title => 'Моите приноси';

  @override
  String get preferences_my_stats_title => 'Моите статистики';

  @override
  String get preferences_contribute_subtitle =>
      'Превеждайте, подобрете инструментите си…';

  @override
  String get preferences_connect_title => 'Свържете се';

  @override
  String get preferences_connect_subtitle =>
      'Свържете се с нас или ни последвайте в социалните мрежи';

  @override
  String get preferences_support_title => 'Направи дарение';

  @override
  String get preferences_support_subtitle =>
      'Помогнете ни да информираме милиони потребители по целия свят';

  @override
  String get preferences_card_help => 'Помощ и поддръжка';

  @override
  String get preferences_faq_title => 'ЧЗВ';

  @override
  String get preferences_faq_subtitle => 'Получете отговори на вашите въпроси';

  @override
  String get logged_out => 'Излязох от профила си';

  @override
  String get preferences_app_bar_message =>
      'Благодарим ви, че сте един от нашите членове!';

  @override
  String get preferences_app_bar_products_modified => 'Променени продукти';

  @override
  String get preferences_app_bar_prices_added => 'Prices added';

  @override
  String get preferences_app_bar_see_all_stats => 'Вижте всички статистики';

  @override
  String external_search_tile_title(String provider, String keyword) {
    return 'Търсене в $provider за „$keyword“';
  }

  @override
  String get preferences_app_bar_search_hint =>
      'Търсене на настройка (напр. Nutri-Score)';

  @override
  String get preferences_accessibility_show_emoji =>
      'Достъпност: Показване на емоджи';

  @override
  String get preferences_accessibility_remove_colors =>
      'Достъпност: Премахване на цветове';

  @override
  String get preferences_app_settings_products => 'Продукти';

  @override
  String get preferences_card_about => 'Относно';

  @override
  String get preferences_legal_information_title => 'Правна информация';

  @override
  String get preferences_legal_information_subtitle =>
      'Условия за ползване, политика за поверителност и други';

  @override
  String get preferences_terms_of_use => 'Условия за ползване';

  @override
  String get preferences_legal_mentions => 'Правни споменавания';

  @override
  String get preferences_legal_header =>
      'Open Food Facts е база данни за хранителни продукти, **създадена от всички, за всички**.\nМожете да я използвате, за да правите по-добър избор на храна, и тъй като е **отворени данни**, всеки може да я **използва повторно за всякакви цели**.';

  @override
  String get preferences_privacy_policy => 'Политика за поверителност';

  @override
  String get preferences_licenses => 'Лицензи';

  @override
  String get preferences_about_app_title => 'Относно приложението';

  @override
  String get preferences_about_app_subtitle =>
      'Техническа информация, информация за разработчици и др.';

  @override
  String get preferences_card_information => 'Информация';

  @override
  String get preferences_version_number_title => 'Номер на версията';

  @override
  String get preferences_scanner_title => 'Скенер';

  @override
  String get preferences_app_store => 'Магазин за приложения';

  @override
  String get preferences_app_system_settings => 'Системни настройки';

  @override
  String get preferences_source_code => 'Достъп до изходния код';

  @override
  String get preferences_source_code_subtitle =>
      'И започнете да оказвате влияние върху милиони';

  @override
  String get preferences_add_prices => 'Add prices';

  @override
  String get preferences_complete_products => 'Попълни продуктите';

  @override
  String get preferences_tips => 'Съвети';

  @override
  String get tips_discover_nutriscore => 'Открийте новия Nutri-Score';

  @override
  String get preferences_on_off_website_subtitle =>
      'На уебсайта „Отворени факти за храната“';

  @override
  String get preferences_manage_account_title => 'Управление на моя акаунт';

  @override
  String get preferences_manage_account_tooltip => 'Управлявайте профила си';

  @override
  String get preferences_change_password_title => 'Промяна на паролата ми';

  @override
  String get preferences_danger_zone => 'Опасна зона';

  @override
  String get preferences_account_deletion_subtitle =>
      'Всички ваши приноси ще бъдат загубени';

  @override
  String get preferences_contributions_title => 'Приноси';

  @override
  String get preferences_dev_mode_app_settings_title =>
      'Настройки на приложението';

  @override
  String get preferences_dev_mode_offline_data_subtitle =>
      'Много експериментален начин за сканиране на продукти офлайн';

  @override
  String get preferences_dev_mode_refresh_products_title =>
      'Обновете всички продукти от сървъра';

  @override
  String get preferences_dev_mode_refresh_products_subtitle =>
      'Моля, избягвайте да правите това, освен ако не е абсолютно необходимо';

  @override
  String get preferences_dev_mode_demo_mode_title => 'Демо режим';

  @override
  String get preferences_dev_mode_add_cards_title =>
      'Добавяне на карти към скенера';

  @override
  String get preferences_dev_mode_add_cards_subtitle =>
      'Добавя 3 примерни продукта към скенера';

  @override
  String get preferences_dev_mode_folksonomy_host_title =>
      'Водещ на фолксономия';

  @override
  String preferences_dev_mode_folksonomy_host_subtitle(String host) {
    return 'Домакин: $host';
  }

  @override
  String get preferences_dev_mode_accessibility_experiments_title =>
      'Експерименти с достъпност';

  @override
  String get preferences_dev_mode_multi_products_selection_title =>
      'Избор на множество продукти за цени';

  @override
  String get preferences_dev_mode_user_ordered_kp_title =>
      'Панели със знания, подредени от потребителите';

  @override
  String get preferences_dev_mode_location_search_title =>
      'Временен достъп до търсене на местоположение';

  @override
  String get preferences_dev_mode_comparison_title =>
      'Паралелно сравнение на 2 или 3 продукта';

  @override
  String get preferences_dev_mode_product_list_import_title =>
      'Импортиране на списък с продукти';

  @override
  String get preferences_faq_scores_methodologies_title =>
      'Резултати и методологии';

  @override
  String get preferences_faq_nutriscore_subtitle =>
      'Открийте как се изчислява Nutri-Score';

  @override
  String get preferences_faq_nutriscore_v2_subtitle =>
      'Открийте основните промени в методологията';

  @override
  String get preferences_faq_discover_project_title => 'Открий проекта';

  @override
  String get preferences_faq_discover_off_title =>
      'Открийте фактите за отворената храна';

  @override
  String get preferences_faq_discover_obf_title =>
      'Открийте открити факти за красотата';

  @override
  String get preferences_faq_discover_opff_title =>
      'Открийте фактите за храната за домашни любимци на Open';

  @override
  String get preferences_faq_discover_op_title => 'Открийте отворени цени';

  @override
  String get preferences_faq_discover_opf_title =>
      'Открийте фактите за отворените продукти';

  @override
  String get preferences_faq_faq_title => 'ЧЗВ - Често задавани въпроси';

  @override
  String get preferences_faq_off_ngo_title => 'НПО „Отворени факти за храната“';

  @override
  String get preferences_about_information_title => 'Информация';

  @override
  String get preferences_connect_community_updates_title =>
      'Получавайте актуализации от общността';

  @override
  String get preferences_connect_newsletter_subtitle =>
      'Бъдете в течение с новините от приложението и общността';

  @override
  String get preferences_connect_community_calendar_title =>
      'Абонирайте се за нашия общностен календар';

  @override
  String get preferences_connect_community_calendar_subtitle =>
      'Включете се, като посетите едно от нашите виртуални събития';

  @override
  String get preferences_connect_blog_title =>
      'Блогът „Отворени факти за храната“';

  @override
  String get preferences_connect_blog_subtitle =>
      'Получавайте най-новите новини, веднага щом се случват';

  @override
  String get preferences_connect_community_help_title =>
      'Получете помощ от общността';

  @override
  String get preferences_connect_improve_app_title =>
      'Помогнете ни да подобрим приложението';

  @override
  String get preferences_connect_debug_info_title =>
      'Изпратете ни информация за отстраняване на грешки';

  @override
  String get preferences_connect_debug_info_subtitle =>
      'Изпратете ни имейл с подробна информация за отстраняване на грешки';

  @override
  String get preferences_connect_feedback_title =>
      'Изпратете ни обратна връзка за приложението';

  @override
  String get preferences_connect_feedback_subtitle =>
      'Помогнете за оформянето на бъдещето на приложението';

  @override
  String get preferences_connect_survey_title =>
      'Участвайте в анкетата за приложението';

  @override
  String get preferences_connect_survey_subtitle =>
      'Помогнете ни да разберем какво трябва да изградим след това';

  @override
  String get preferences_connect_professionals_title => 'Професионалисти';

  @override
  String get preferences_connect_pro_subtitle =>
      'Напълно безплатно, осигурява точни данни за 500 приложения и милиони потребители. Самообслужване, съвместимо с вашия PIM или електронни таблици (XLSX)';

  @override
  String get preferences_connect_pro_email_subtitle =>
      'Свържете се с нас, за да започнете';

  @override
  String get preferences_connect_press_title => 'Преса';

  @override
  String get preferences_connect_press_page_subtitle =>
      'Вземете всички необходими материали за вашия доклад';

  @override
  String get preferences_connect_press_email_subtitle =>
      'Свържете се с нас за запитвания от пресата или за да ни уведомите за вашия доклад';

  @override
  String get preferences_contribute_active_volunteer_title =>
      'Станете активен доброволец';

  @override
  String get preferences_contribute_skill_pool_subtitle =>
      'Разработка, Комуникация, Дизайн… всякакъв вид доброволчество или експертен опит са добре дошли!';

  @override
  String get preferences_contribute_how_to_subtitle =>
      'Открийте някои от многото начини, по които можете да допринесете';

  @override
  String get preferences_contribute_mobile_dev_title =>
      'Разработка на мобилни приложения';

  @override
  String get preferences_contribute_sw_dev_subtitle =>
      'Научете как да допринесете за разработването на софтуер';

  @override
  String get preferences_contribute_alpha_subtitle =>
      'Ежедневни нестабилни компилации, чисто нови функции';

  @override
  String get preferences_contribute_local_community_title =>
      'Развийте местната си общност';

  @override
  String get preferences_contribute_translate_subtitle =>
      'Помощ със софтуер, съдържание, преводи на анализи на съставки';

  @override
  String get preferences_contribute_share_subtitle =>
      'Подготвили сме малък шаблон, който да ви помогне :-)';

  @override
  String get preferences_contribute_country_subtitle =>
      'Прости стъпки за повишаване на прозрачността на храните във вашата страна';

  @override
  String get preferences_contribute_data_quality_title => 'Качество на данните';

  @override
  String get preferences_contribute_data_quality_team_title =>
      'Присъединете се към екипа за качество на данните';

  @override
  String get preferences_contribute_data_quality_team_subtitle =>
      'Присъединете се към нашите усилия, за да гарантираме, че базата данни е пълна и точна';

  @override
  String get preferences_contributions_products_added_title =>
      'Добавени продукти';

  @override
  String get preferences_contributions_new_products_subtitle =>
      'Нови продукти, които добавих към Open Food Facts';

  @override
  String get preferences_contributions_to_be_completed_title =>
      'Продукти, които трябва да завърша';

  @override
  String get preferences_contributions_all_incomplete_title =>
      'Всички непълни продукти';

  @override
  String get preferences_my_contributions_prices_title => 'Цени';

  @override
  String get preferences_my_contributions_my_prices_title => 'Моите цени';

  @override
  String get preferences_my_contributions_my_prices_subtitle =>
      'Моите цени, моите доказателства…';

  @override
  String get preferences_contributions_all_incomplete_subtitle =>
      'Продукти, които можете да помогнете за завършването им';

  @override
  String get preferences_contributions_categorize_subtitle =>
      'Помогнете за изчисляването на Nutri-Score и Green-Score във вашата страна';

  @override
  String get preferences_prices_user_prices_subtitle =>
      'Цени, които аз допринесох';

  @override
  String get preferences_prices_proofs_subtitle =>
      'Ценови етикети и касови бележки';

  @override
  String get preferences_prices_add_receipt_subtitle =>
      'Направете снимки на вашите касови бележки и сканирайте съответните баркодове';

  @override
  String get preferences_prices_add_price_tags_subtitle =>
      'Направете снимки на цените в магазина';

  @override
  String get preferences_prices_newest_title => 'Най-нови цени';

  @override
  String get preferences_prices_newest_subtitle =>
      'Последни цени, добавени от общността Open Prices';

  @override
  String get preferences_prices_top_contributors_title =>
      'Сътрудници с най-много цени';

  @override
  String get preferences_prices_metrics_title => 'Показатели за отворена цена';

  @override
  String get preferences_prices_metrics_subtitle =>
      'Следете развитието на проекта';

  @override
  String get preferences_prices_ways_contribute_title => 'Начини за принос';

  @override
  String get preferences_prices_validation_assistant_subtitle =>
      'Потвърдете цените, добавени от вас или други, с помощта на изкуствен интелект';

  @override
  String get preferences_prices_multiple_proof_subtitle =>
      'Бързо добавете много касови бележки или снимки на рафтове от вашата камера';

  @override
  String get preferences_prices_challenges_title => 'Месечни предизвикателства';

  @override
  String get preferences_prices_challenges_subtitle =>
      'Участвайте в месечни тематични куестове, за да събирате награди';

  @override
  String get preferences_prices_loyalty_data_title =>
      'Възстановете данните си за лоялност';

  @override
  String get preferences_prices_gdpr_subtitle =>
      'Научете как да заявите данните си';

  @override
  String get preferences_page_customize_app_title =>
      'Персонализирайте приложението';

  @override
  String get preferences_page_contribute_project_title =>
      'Допринесете за проекта';

  @override
  String get preferences_page_contribute_project_subtitle =>
      'Прости начини да помогнете Open Food Facts';

  @override
  String get preferences_page_faq_subtitle =>
      'Методологии за оценяване, помощ и още информация за проекта';

  @override
  String get product_edit_robotoff_positive_button =>
      'Приемане на предложението';

  @override
  String get product_edit_robotoff_negative_button =>
      'Отхвърляне на предложението';

  @override
  String get product_edit_robotoff_show_proof => 'Покажете доказателство';

  @override
  String get product_edit_robotoff_expand_proof =>
      'Разгъване на доказателството';

  @override
  String get product_page_tab_raw_data => 'Сурови данни';

  @override
  String page_indicator_with_total(int current, int total) {
    return 'Страница $current / $total';
  }

  @override
  String page_indicator(int current) {
    return 'Страница $current';
  }

  @override
  String item_count_with_total(int count, int total) {
    return '$count от $total артикула';
  }

  @override
  String item_count_with_total_string(String count, String total) {
    return '$count от $total артикула';
  }

  @override
  String item_count(int count) {
    return '$count артикула';
  }

  @override
  String item_count_string(String count) {
    return '$count артикула';
  }

  @override
  String get prices_no_result =>
      'Не са намерени статистически данни за цените.';

  @override
  String get prices_error_loading_more_items =>
      'Грешка при зареждането на още елементи';

  @override
  String get prices_proof_error =>
      'Удостоверяването не бе успешно, не можаха да се получат доказателства';

  @override
  String proofs_count_with_total(int count, int total) {
    return '$count от $total доказателства';
  }

  @override
  String proof_count(int count) {
    return '$count доказателства';
  }

  @override
  String contributors_count_with_total(int count, int total) {
    return '$count от $total сътрудници';
  }

  @override
  String contributors_count(int count) {
    return '$count сътрудници';
  }

  @override
  String prices_locations_count_with_total(int count, int total) {
    return '$count от $total местоположения';
  }

  @override
  String prices_locations_count(int count) {
    return '$count местоположения';
  }

  @override
  String get restart_to_apply_message =>
      'Моля, рестартирайте приложението, за да приложите промените.';

  @override
  String get preferences_app_settings_graphical_interface_title =>
      'Графичен интерфейс';

  @override
  String get preferences_app_settings_media_title => 'Медии';

  @override
  String get preferences_about_app_development_title => 'Развитие';

  @override
  String get preferences_page_open_food_facts_labs_title =>
      'Отворени лаборатории за факти за храните';

  @override
  String get preferences_root_account_title => 'Профил';

  @override
  String get preferences_contribute_translate_header =>
      'Внесете фактите за отворените храни на вашия език';

  @override
  String get preferences_contribute_enroll_alpha =>
      'Запишете се в алфа версията на приложението';

  @override
  String get preferences_dev_mode_section_data => 'Приноси и данни за продукта';

  @override
  String get preferences_dev_preferences_show_folksonomy_title =>
      'Не показвай фолксономията';

  @override
  String get preferences_account_title => 'Профил';

  @override
  String prices_adding_timestamp_tooltip(String created) {
    return 'Добавено на $created';
  }

  @override
  String get location_map_details_title => 'Подробности за местоположението';

  @override
  String get location_map_details_name => 'Име';

  @override
  String get location_map_details_street => 'Улица';

  @override
  String get location_map_details_city => 'Град';

  @override
  String get location_map_details_postcode => 'Пощенски код';

  @override
  String get location_map_details_country => 'Country';

  @override
  String get location_map_details_coordinates => 'Координати';

  @override
  String get location_map_details_osm_id => 'OSM Идентификационен номер';
}
