// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v25.5.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

import 'dart:async';
import 'dart:io' show Platform;
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;

import 'package:flutter/foundation.dart'
    show ReadBuffer, WriteBuffer, immutable, protected;
import 'package:flutter/services.dart';
import 'package:flutter/widgets.dart' show WidgetsFlutterBinding;

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({
  Object? result,
  PlatformException? error,
  bool empty = false,
}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}

/// An immutable object that serves as the base class for all ProxyApis and
/// can provide functional copies of itself.
///
/// All implementers are expected to be [immutable] as defined by the annotation
/// and override [pigeon_copy] returning an instance of itself.
@immutable
abstract class PigeonInternalProxyApiBaseClass {
  /// Construct a [PigeonInternalProxyApiBaseClass].
  PigeonInternalProxyApiBaseClass({
    this.pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) : pigeon_instanceManager =
           pigeon_instanceManager ?? PigeonInstanceManager.instance;

  /// Sends and receives binary data across the Flutter platform barrier.
  ///
  /// If it is null, the default BinaryMessenger will be used, which routes to
  /// the host platform.
  @protected
  final BinaryMessenger? pigeon_binaryMessenger;

  /// Maintains instances stored to communicate with native language objects.
  final PigeonInstanceManager pigeon_instanceManager;

  /// Instantiates and returns a functionally identical object to oneself.
  ///
  /// Outside of tests, this method should only ever be called by
  /// [PigeonInstanceManager].
  ///
  /// Subclasses should always override their parent's implementation of this
  /// method.
  @protected
  PigeonInternalProxyApiBaseClass pigeon_copy();
}

/// Maintains instances used to communicate with the native objects they
/// represent.
///
/// Added instances are stored as weak references and their copies are stored
/// as strong references to maintain access to their variables and callback
/// methods. Both are stored with the same identifier.
///
/// When a weak referenced instance becomes inaccessible,
/// [onWeakReferenceRemoved] is called with its associated identifier.
///
/// If an instance is retrieved and has the possibility to be used,
/// (e.g. calling [getInstanceWithWeakReference]) a copy of the strong reference
/// is added as a weak reference with the same identifier. This prevents a
/// scenario where the weak referenced instance was released and then later
/// returned by the host platform.
class PigeonInstanceManager {
  /// Constructs a [PigeonInstanceManager].
  PigeonInstanceManager({required void Function(int) onWeakReferenceRemoved}) {
    this.onWeakReferenceRemoved = (int identifier) {
      _weakInstances.remove(identifier);
      onWeakReferenceRemoved(identifier);
    };
    _finalizer = Finalizer<int>(this.onWeakReferenceRemoved);
  }

  // Identifiers are locked to a specific range to avoid collisions with objects
  // created simultaneously by the host platform.
  // Host uses identifiers >= 2^16 and Dart is expected to use values n where,
  // 0 <= n < 2^16.
  static const int _maxDartCreatedIdentifier = 65536;

  /// The default [PigeonInstanceManager] used by ProxyApis.
  ///
  /// On creation, this manager makes a call to clear the native
  /// InstanceManager. This is to prevent identifier conflicts after a host
  /// restart.
  static final PigeonInstanceManager instance = _initInstance();

  // Expando is used because it doesn't prevent its keys from becoming
  // inaccessible. This allows the manager to efficiently retrieve an identifier
  // of an instance without holding a strong reference to that instance.
  //
  // It also doesn't use `==` to search for identifiers, which would lead to an
  // infinite loop when comparing an object to its copy. (i.e. which was caused
  // by calling instanceManager.getIdentifier() inside of `==` while this was a
  // HashMap).
  final Expando<int> _identifiers = Expando<int>();
  final Map<int, WeakReference<PigeonInternalProxyApiBaseClass>>
  _weakInstances = <int, WeakReference<PigeonInternalProxyApiBaseClass>>{};
  final Map<int, PigeonInternalProxyApiBaseClass> _strongInstances =
      <int, PigeonInternalProxyApiBaseClass>{};
  late final Finalizer<int> _finalizer;
  int _nextIdentifier = 0;

  /// Called when a weak referenced instance is removed by [removeWeakReference]
  /// or becomes inaccessible.
  late final void Function(int) onWeakReferenceRemoved;

  static PigeonInstanceManager _initInstance() {
    if (Platform.environment['FLUTTER_TEST'] == 'true') {
      return PigeonInstanceManager(onWeakReferenceRemoved: (_) {});
    }
    WidgetsFlutterBinding.ensureInitialized();
    final _PigeonInternalInstanceManagerApi api =
        _PigeonInternalInstanceManagerApi();
    // Clears the native `PigeonInstanceManager` on the initial use of the Dart one.
    api.clear();
    final PigeonInstanceManager instanceManager = PigeonInstanceManager(
      onWeakReferenceRemoved: (int identifier) {
        api.removeStrongReference(identifier);
      },
    );
    _PigeonInternalInstanceManagerApi.setUpMessageHandlers(
      instanceManager: instanceManager,
    );
    URLRequest.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    HTTPURLResponse.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    URLResponse.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKUserScript.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKNavigationAction.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKNavigationResponse.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKFrameInfo.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    NSError.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKScriptMessage.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKSecurityOrigin.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    HTTPCookie.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    AuthenticationChallengeResponse.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKWebsiteDataStore.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    UIView.pigeon_setUpMessageHandlers(pigeon_instanceManager: instanceManager);
    UIScrollView.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKWebViewConfiguration.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKUserContentController.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKPreferences.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKScriptMessageHandler.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKNavigationDelegate.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    NSObject.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    UIViewWKWebView.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    NSViewWKWebView.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKWebView.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKUIDelegate.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    WKHTTPCookieStore.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    UIScrollViewDelegate.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    URLCredential.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    URLProtectionSpace.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    URLAuthenticationChallenge.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    URL.pigeon_setUpMessageHandlers(pigeon_instanceManager: instanceManager);
    WKWebpagePreferences.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    GetTrustResultResponse.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    SecTrust.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    SecCertificate.pigeon_setUpMessageHandlers(
      pigeon_instanceManager: instanceManager,
    );
    return instanceManager;
  }

  /// Adds a new instance that was instantiated by Dart.
  ///
  /// In other words, Dart wants to add a new instance that will represent
  /// an object that will be instantiated on the host platform.
  ///
  /// Throws assertion error if the instance has already been added.
  ///
  /// Returns the randomly generated id of the [instance] added.
  int addDartCreatedInstance(PigeonInternalProxyApiBaseClass instance) {
    assert(getIdentifier(instance) == null);

    final int identifier = _nextUniqueIdentifier();
    _identifiers[instance] = identifier;
    _weakInstances[identifier] = WeakReference<PigeonInternalProxyApiBaseClass>(
      instance,
    );
    _finalizer.attach(instance, identifier, detach: instance);

    final PigeonInternalProxyApiBaseClass copy = instance.pigeon_copy();
    _identifiers[copy] = identifier;
    _strongInstances[identifier] = copy;
    return identifier;
  }

  /// Removes the instance, if present, and call [onWeakReferenceRemoved] with
  /// its identifier.
  ///
  /// Returns the identifier associated with the removed instance. Otherwise,
  /// `null` if the instance was not found in this manager.
  ///
  /// This does not remove the strong referenced instance associated with
  /// [instance]. This can be done with [remove].
  int? removeWeakReference(PigeonInternalProxyApiBaseClass instance) {
    final int? identifier = getIdentifier(instance);
    if (identifier == null) {
      return null;
    }

    _identifiers[instance] = null;
    _finalizer.detach(instance);
    onWeakReferenceRemoved(identifier);

    return identifier;
  }

  /// Removes [identifier] and its associated strongly referenced instance, if
  /// present, from the manager.
  ///
  /// Returns the strong referenced instance associated with [identifier] before
  /// it was removed. Returns `null` if [identifier] was not associated with
  /// any strong reference.
  ///
  /// Throws an `AssertionError` if the weak referenced instance associated with
  /// [identifier] is not removed first. This can be done with
  /// [removeWeakReference].
  T? remove<T extends PigeonInternalProxyApiBaseClass>(int identifier) {
    final T? instance = _weakInstances[identifier]?.target as T?;
    assert(
      instance == null,
      'A strong instance with identifier $identifier is being removed despite the weak reference still existing: $instance',
    );
    return _strongInstances.remove(identifier) as T?;
  }

  /// Retrieves the instance associated with identifier.
  ///
  /// The value returned is chosen from the following order:
  ///
  /// 1. A weakly referenced instance associated with identifier.
  /// 2. If the only instance associated with identifier is a strongly
  /// referenced instance, a copy of the instance is added as a weak reference
  /// with the same identifier. Returning the newly created copy.
  /// 3. If no instance is associated with identifier, returns null.
  ///
  /// This method also expects the host `InstanceManager` to have a strong
  /// reference to the instance the identifier is associated with.
  T? getInstanceWithWeakReference<T extends PigeonInternalProxyApiBaseClass>(
    int identifier,
  ) {
    final PigeonInternalProxyApiBaseClass? weakInstance =
        _weakInstances[identifier]?.target;

    if (weakInstance == null) {
      final PigeonInternalProxyApiBaseClass? strongInstance =
          _strongInstances[identifier];
      if (strongInstance != null) {
        final PigeonInternalProxyApiBaseClass copy = strongInstance
            .pigeon_copy();
        _identifiers[copy] = identifier;
        _weakInstances[identifier] =
            WeakReference<PigeonInternalProxyApiBaseClass>(copy);
        _finalizer.attach(copy, identifier, detach: copy);
        return copy as T;
      }
      return strongInstance as T?;
    }

    return weakInstance as T;
  }

  /// Retrieves the identifier associated with instance.
  int? getIdentifier(PigeonInternalProxyApiBaseClass instance) {
    return _identifiers[instance];
  }

  /// Adds a new instance that was instantiated by the host platform.
  ///
  /// In other words, the host platform wants to add a new instance that
  /// represents an object on the host platform. Stored with [identifier].
  ///
  /// Throws assertion error if the instance or its identifier has already been
  /// added.
  void addHostCreatedInstance(
    PigeonInternalProxyApiBaseClass instance,
    int identifier,
  ) {
    assert(!containsIdentifier(identifier));
    assert(getIdentifier(instance) == null);
    assert(identifier >= 0);

    _identifiers[instance] = identifier;
    _strongInstances[identifier] = instance;
  }

  /// Whether this manager contains the given [identifier].
  bool containsIdentifier(int identifier) {
    return _weakInstances.containsKey(identifier) ||
        _strongInstances.containsKey(identifier);
  }

  int _nextUniqueIdentifier() {
    late int identifier;
    do {
      identifier = _nextIdentifier;
      _nextIdentifier = (_nextIdentifier + 1) % _maxDartCreatedIdentifier;
    } while (containsIdentifier(identifier));
    return identifier;
  }
}

/// Generated API for managing the Dart and native `PigeonInstanceManager`s.
class _PigeonInternalInstanceManagerApi {
  /// Constructor for [_PigeonInternalInstanceManagerApi].
  _PigeonInternalInstanceManagerApi({BinaryMessenger? binaryMessenger})
    : pigeonVar_binaryMessenger = binaryMessenger;

  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  static void setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? binaryMessenger,
    PigeonInstanceManager? instanceManager,
  }) {
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.PigeonInternalInstanceManager.removeStrongReference',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.PigeonInternalInstanceManager.removeStrongReference was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(
            arg_identifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.PigeonInternalInstanceManager.removeStrongReference was null, expected non-null int.',
          );
          try {
            (instanceManager ?? PigeonInstanceManager.instance).remove(
              arg_identifier!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  Future<void> removeStrongReference(int identifier) async {
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.PigeonInternalInstanceManager.removeStrongReference';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[identifier],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Clear the native `PigeonInstanceManager`.
  ///
  /// This is typically called after a hot restart.
  Future<void> clear() async {
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.PigeonInternalInstanceManager.clear';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(null);
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class _PigeonInternalProxyApiBaseCodec extends _PigeonCodec {
  const _PigeonInternalProxyApiBaseCodec(this.instanceManager);
  final PigeonInstanceManager instanceManager;
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is PigeonInternalProxyApiBaseClass) {
      buffer.putUint8(128);
      writeValue(buffer, instanceManager.getIdentifier(value));
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 128:
        return instanceManager.getInstanceWithWeakReference(
          readValue(buffer)! as int,
        );
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

/// The values that can be returned in a change dictionary.
///
/// See https://developer.apple.com/documentation/foundation/nskeyvalueobservingoptions.
enum KeyValueObservingOptions {
  /// Indicates that the change dictionary should provide the new attribute
  /// value, if applicable.
  newValue,

  /// Indicates that the change dictionary should contain the old attribute
  /// value, if applicable.
  oldValue,

  /// If specified, a notification should be sent to the observer immediately,
  /// before the observer registration method even returns.
  initialValue,

  /// Whether separate notifications should be sent to the observer before and
  /// after each change, instead of a single notification after the change.
  priorNotification,
}

/// The kinds of changes that can be observed.
///
/// See https://developer.apple.com/documentation/foundation/nskeyvaluechange.
enum KeyValueChange {
  /// Indicates that the value of the observed key path was set to a new value.
  setting,

  /// Indicates that an object has been inserted into the to-many relationship
  /// that is being observed.
  insertion,

  /// Indicates that an object has been removed from the to-many relationship
  /// that is being observed.
  removal,

  /// Indicates that an object has been replaced in the to-many relationship
  /// that is being observed.
  replacement,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// The keys that can appear in the change dictionary.
///
/// See https://developer.apple.com/documentation/foundation/nskeyvaluechangekey.
enum KeyValueChangeKey {
  /// If the value of the `KeyValueChangeKey.kind` entry is
  /// `KeyValueChange.insertion`, `KeyValueChange.removal`, or
  /// `KeyValueChange.replacement`, the value of this key is a Set object that
  /// contains the indexes of the inserted, removed, or replaced objects.
  indexes,

  /// An object that contains a value corresponding to one of the
  /// `KeyValueChange` enum, indicating what sort of change has occurred.
  kind,

  /// If the value of the `KeyValueChange.kind` entry is
  /// `KeyValueChange.setting, and `KeyValueObservingOptions.newValue` was
  /// specified when the observer was registered, the value of this key is the
  /// new value for the attribute.
  newValue,

  /// If the `KeyValueObservingOptions.priorNotification` option was specified
  /// when the observer was registered this notification is sent prior to a
  /// change.
  notificationIsPrior,

  /// If the value of the `KeyValueChange.kind` entry is
  /// `KeyValueChange.setting`, and `KeyValueObservingOptions.old` was specified
  /// when the observer was registered, the value of this key is the value
  /// before the attribute was changed.
  oldValue,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// Constants for the times at which to inject script content into a webpage.
///
/// See https://developer.apple.com/documentation/webkit/wkuserscriptinjectiontime.
enum UserScriptInjectionTime {
  /// A constant to inject the script after the creation of the webpage’s
  /// document element, but before loading any other content.
  atDocumentStart,

  /// A constant to inject the script after the document finishes loading, but
  /// before loading any other subresources.
  atDocumentEnd,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// The media types that require a user gesture to begin playing.
///
/// See https://developer.apple.com/documentation/webkit/wkaudiovisualmediatypes.
enum AudiovisualMediaType {
  /// No media types require a user gesture to begin playing.
  none,

  /// Media types that contain audio require a user gesture to begin playing.
  audio,

  /// Media types that contain video require a user gesture to begin playing.
  video,

  /// All media types require a user gesture to begin playing.
  all,
}

/// A `WKWebsiteDataRecord` object includes these constants in its dataTypes
/// property.
///
/// See https://developer.apple.com/documentation/webkit/wkwebsitedatarecord/data_store_record_types.
enum WebsiteDataType {
  /// Cookies.
  cookies,

  /// In-memory caches.
  memoryCache,

  /// On-disk caches.
  diskCache,

  /// HTML offline web app caches.
  offlineWebApplicationCache,

  /// HTML local storage.
  localStorage,

  /// HTML session storage.
  sessionStorage,

  /// WebSQL databases.
  webSQLDatabases,

  /// IndexedDB databases.
  indexedDBDatabases,
}

/// Constants that indicate whether to allow or cancel navigation to a webpage
/// from an action.
///
/// See https://developer.apple.com/documentation/webkit/wknavigationactionpolicy.
enum NavigationActionPolicy {
  /// Allow the navigation to continue.
  allow,

  /// Cancel the navigation.
  cancel,

  /// Allow the download to proceed.
  download,
}

/// Constants that indicate whether to allow or cancel navigation to a webpage
/// from a response.
///
/// See https://developer.apple.com/documentation/webkit/wknavigationresponsepolicy.
enum NavigationResponsePolicy {
  /// Allow the navigation to continue.
  allow,

  /// Cancel the navigation.
  cancel,

  /// Allow the download to proceed.
  download,
}

/// Constants that define the supported keys in a cookie attributes dictionary.
///
/// See https://developer.apple.com/documentation/foundation/httpcookiepropertykey.
enum HttpCookiePropertyKey {
  /// A String object containing the comment for the cookie.
  comment,

  /// An Uri object or String object containing the comment URL for the cookie.
  commentUrl,

  /// Aa String object stating whether the cookie should be discarded at the end
  /// of the session.
  discard,

  /// An String object containing the domain for the cookie.
  domain,

  /// An Date object or String object specifying the expiration date for the
  /// cookie.
  expires,

  /// An String object containing an integer value stating how long in seconds
  /// the cookie should be kept, at most.
  maximumAge,

  /// An String object containing the name of the cookie (required).
  name,

  /// A URL or String object containing the URL that set this cookie.
  originUrl,

  /// A String object containing the path for the cookie.
  path,

  /// An String object containing comma-separated integer values specifying the
  /// ports for the cookie.
  port,

  /// A string indicating the same-site policy for the cookie.
  sameSitePolicy,

  /// A String object indicating that the cookie should be transmitted only over
  /// secure channels.
  secure,

  /// A String object containing the value of the cookie.
  value,

  /// A String object that specifies the version of the cookie.
  version,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// The type of action that triggered the navigation.
///
/// See https://developer.apple.com/documentation/webkit/wknavigationtype.
enum NavigationType {
  /// A link activation.
  linkActivated,

  /// A request to submit a form.
  formSubmitted,

  /// A request for the frame’s next or previous item.
  backForward,

  /// A request to reload the webpage.
  reload,

  /// A request to resubmit a form.
  formResubmitted,

  /// A navigation request that originates for some other reason.
  other,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// Possible permission decisions for device resource access.
///
/// See https://developer.apple.com/documentation/webkit/wkpermissiondecision.
enum PermissionDecision {
  /// Deny permission for the requested resource.
  deny,

  /// Deny permission for the requested resource.
  grant,

  /// Prompt the user for permission for the requested resource.
  prompt,
}

/// List of the types of media devices that can capture audio, video, or both.
///
/// See https://developer.apple.com/documentation/webkit/wkmediacapturetype.
enum MediaCaptureType {
  /// A media device that can capture video.
  camera,

  /// A media device or devices that can capture audio and video.
  cameraAndMicrophone,

  /// A media device that can capture audio.
  microphone,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// Responses to an authentication challenge.
///
/// See https://developer.apple.com/documentation/foundation/urlsession/authchallengedisposition.
enum UrlSessionAuthChallengeDisposition {
  /// Use the specified credential, which may be nil.
  useCredential,

  /// Use the default handling for the challenge as though this delegate method
  /// were not implemented.
  performDefaultHandling,

  /// Cancel the entire request.
  cancelAuthenticationChallenge,

  /// Reject this challenge, and call the authentication delegate method again
  /// with the next authentication protection space.
  rejectProtectionSpace,

  /// The value is not recognized by the wrapper.
  unknown,
}

/// Specifies how long a credential will be kept.
///
/// See https://developer.apple.com/documentation/foundation/nsurlcredentialpersistence.
enum UrlCredentialPersistence {
  /// The credential should not be stored.
  none,

  /// The credential should be stored only for this session.
  forSession,

  /// The credential should be stored in the keychain.
  permanent,

  /// The credential should be stored permanently in the keychain, and in
  /// addition should be distributed to other devices based on the owning Apple
  /// ID.
  synchronizable,
}

/// Trust evaluation result codes.
///
/// See https://developer.apple.com/documentation/security/sectrustresulttype?language=objc.
enum DartSecTrustResultType {
  /// The user did not specify a trust setting.
  unspecified,

  /// The user granted permission to trust the certificate for the purposes
  /// designated in the specified policies.
  proceed,

  /// The user specified that the certificate should not be trusted.
  deny,

  /// Trust is denied, but recovery may be possible.
  recoverableTrustFailure,

  /// Trust is denied and no simple fix is available.
  fatalTrustFailure,

  /// A value that indicates a failure other than trust evaluation.
  otherError,

  /// An indication of an invalid setting or result.
  invalid,

  /// User confirmation is required before proceeding.
  confirm,

  /// The type is not recognized by this wrapper.
  unknown,
}

class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    } else if (value is KeyValueObservingOptions) {
      buffer.putUint8(129);
      writeValue(buffer, value.index);
    } else if (value is KeyValueChange) {
      buffer.putUint8(130);
      writeValue(buffer, value.index);
    } else if (value is KeyValueChangeKey) {
      buffer.putUint8(131);
      writeValue(buffer, value.index);
    } else if (value is UserScriptInjectionTime) {
      buffer.putUint8(132);
      writeValue(buffer, value.index);
    } else if (value is AudiovisualMediaType) {
      buffer.putUint8(133);
      writeValue(buffer, value.index);
    } else if (value is WebsiteDataType) {
      buffer.putUint8(134);
      writeValue(buffer, value.index);
    } else if (value is NavigationActionPolicy) {
      buffer.putUint8(135);
      writeValue(buffer, value.index);
    } else if (value is NavigationResponsePolicy) {
      buffer.putUint8(136);
      writeValue(buffer, value.index);
    } else if (value is HttpCookiePropertyKey) {
      buffer.putUint8(137);
      writeValue(buffer, value.index);
    } else if (value is NavigationType) {
      buffer.putUint8(138);
      writeValue(buffer, value.index);
    } else if (value is PermissionDecision) {
      buffer.putUint8(139);
      writeValue(buffer, value.index);
    } else if (value is MediaCaptureType) {
      buffer.putUint8(140);
      writeValue(buffer, value.index);
    } else if (value is UrlSessionAuthChallengeDisposition) {
      buffer.putUint8(141);
      writeValue(buffer, value.index);
    } else if (value is UrlCredentialPersistence) {
      buffer.putUint8(142);
      writeValue(buffer, value.index);
    } else if (value is DartSecTrustResultType) {
      buffer.putUint8(143);
      writeValue(buffer, value.index);
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : KeyValueObservingOptions.values[value];
      case 130:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : KeyValueChange.values[value];
      case 131:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : KeyValueChangeKey.values[value];
      case 132:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : UserScriptInjectionTime.values[value];
      case 133:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : AudiovisualMediaType.values[value];
      case 134:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : WebsiteDataType.values[value];
      case 135:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : NavigationActionPolicy.values[value];
      case 136:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : NavigationResponsePolicy.values[value];
      case 137:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : HttpCookiePropertyKey.values[value];
      case 138:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : NavigationType.values[value];
      case 139:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : PermissionDecision.values[value];
      case 140:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : MediaCaptureType.values[value];
      case 141:
        final int? value = readValue(buffer) as int?;
        return value == null
            ? null
            : UrlSessionAuthChallengeDisposition.values[value];
      case 142:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : UrlCredentialPersistence.values[value];
      case 143:
        final int? value = readValue(buffer) as int?;
        return value == null ? null : DartSecTrustResultType.values[value];
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

/// A URL load request that is independent of protocol or URL scheme.
///
/// See https://developer.apple.com/documentation/foundation/urlrequest.
class URLRequest extends NSObject {
  URLRequest({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    required String url,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, url],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [URLRequest] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  URLRequest.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecURLRequest =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    URLRequest Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      URLRequest.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// The URL being requested.
  Future<String?> getUrl() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.getUrl';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// The HTTP request method.
  Future<void> setHttpMethod(String? method) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.setHttpMethod';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, method],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The HTTP request method.
  Future<String?> getHttpMethod() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.getHttpMethod';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// The request body.
  Future<void> setHttpBody(Uint8List? body) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.setHttpBody';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, body],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The request body.
  Future<Uint8List?> getHttpBody() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.getHttpBody';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?);
    }
  }

  /// A dictionary containing all of the HTTP header fields for a request.
  Future<void> setAllHttpHeaderFields(Map<String, String>? fields) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.setAllHttpHeaderFields';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, fields],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// A dictionary containing all of the HTTP header fields for a request.
  Future<Map<String, String>?> getAllHttpHeaderFields() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLRequest;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLRequest.getAllHttpHeaderFields';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)
          ?.cast<String, String>();
    }
  }

  @override
  URLRequest pigeon_copy() {
    return URLRequest.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// The metadata associated with the response to an HTTP protocol URL load
/// request.
///
/// See https://developer.apple.com/documentation/foundation/httpurlresponse.
class HTTPURLResponse extends URLResponse {
  /// Constructs [HTTPURLResponse] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  HTTPURLResponse.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.statusCode,
    super.observeValue,
  }) : super.pigeon_detached();

  /// The response’s HTTP status code.
  final int statusCode;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    HTTPURLResponse Function(int statusCode)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.HTTPURLResponse.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.HTTPURLResponse.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.HTTPURLResponse.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_statusCode = (args[1] as int?);
          assert(
            arg_statusCode != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.HTTPURLResponse.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_statusCode!) ??
                      HTTPURLResponse.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        statusCode: arg_statusCode!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  HTTPURLResponse pigeon_copy() {
    return HTTPURLResponse.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      statusCode: statusCode,
      observeValue: observeValue,
    );
  }
}

/// The metadata associated with the response to a URL load request, independent
/// of protocol and URL scheme.
///
/// See https://developer.apple.com/documentation/foundation/urlresponse.
class URLResponse extends NSObject {
  /// Constructs [URLResponse] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  URLResponse.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    URLResponse Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLResponse.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLResponse.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLResponse.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      URLResponse.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  URLResponse pigeon_copy() {
    return URLResponse.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// A script that the web view injects into a webpage.
///
/// See https://developer.apple.com/documentation/webkit/wkuserscript.
class WKUserScript extends NSObject {
  /// Creates a user script object that contains the specified source code and
  /// attributes.
  WKUserScript({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.source,
    required this.injectionTime,
    required this.isForMainFrameOnly,
    super.observeValue,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKUserScript;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserScript.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[
        pigeonVar_instanceIdentifier,
        source,
        injectionTime,
        isForMainFrameOnly,
      ],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [WKUserScript] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKUserScript.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.source,
    required this.injectionTime,
    required this.isForMainFrameOnly,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecWKUserScript =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The script’s source code.
  final String source;

  /// The time at which to inject the script into the webpage.
  final UserScriptInjectionTime injectionTime;

  /// A Boolean value that indicates whether to inject the script into the main
  /// frame or all frames.
  final bool isForMainFrameOnly;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKUserScript Function(
      String source,
      UserScriptInjectionTime injectionTime,
      bool isForMainFrameOnly,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserScript.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUserScript.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUserScript.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_source = (args[1] as String?);
          assert(
            arg_source != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUserScript.pigeon_newInstance was null, expected non-null String.',
          );
          final UserScriptInjectionTime? arg_injectionTime =
              (args[2] as UserScriptInjectionTime?);
          assert(
            arg_injectionTime != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUserScript.pigeon_newInstance was null, expected non-null UserScriptInjectionTime.',
          );
          final bool? arg_isForMainFrameOnly = (args[3] as bool?);
          assert(
            arg_isForMainFrameOnly != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUserScript.pigeon_newInstance was null, expected non-null bool.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_source!,
                        arg_injectionTime!,
                        arg_isForMainFrameOnly!,
                      ) ??
                      WKUserScript.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        source: arg_source!,
                        injectionTime: arg_injectionTime!,
                        isForMainFrameOnly: arg_isForMainFrameOnly!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKUserScript pigeon_copy() {
    return WKUserScript.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      source: source,
      injectionTime: injectionTime,
      isForMainFrameOnly: isForMainFrameOnly,
      observeValue: observeValue,
    );
  }
}

/// An object that contains information about an action that causes navigation
/// to occur.
///
/// See https://developer.apple.com/documentation/webkit/wknavigationaction.
class WKNavigationAction extends NSObject {
  /// Constructs [WKNavigationAction] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKNavigationAction.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.request,
    this.targetFrame,
    required this.navigationType,
    super.observeValue,
  }) : super.pigeon_detached();

  /// The URL request object associated with the navigation action.
  final URLRequest request;

  /// The frame in which to display the new content.
  ///
  /// If the target of the navigation is a new window, this property is nil.
  final WKFrameInfo? targetFrame;

  /// The type of action that triggered the navigation.
  final NavigationType navigationType;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKNavigationAction Function(
      URLRequest request,
      WKFrameInfo? targetFrame,
      NavigationType navigationType,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationAction.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationAction.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationAction.pigeon_newInstance was null, expected non-null int.',
          );
          final URLRequest? arg_request = (args[1] as URLRequest?);
          assert(
            arg_request != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationAction.pigeon_newInstance was null, expected non-null URLRequest.',
          );
          final WKFrameInfo? arg_targetFrame = (args[2] as WKFrameInfo?);
          final NavigationType? arg_navigationType =
              (args[3] as NavigationType?);
          assert(
            arg_navigationType != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationAction.pigeon_newInstance was null, expected non-null NavigationType.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_request!,
                        arg_targetFrame,
                        arg_navigationType!,
                      ) ??
                      WKNavigationAction.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        request: arg_request!,
                        targetFrame: arg_targetFrame,
                        navigationType: arg_navigationType!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKNavigationAction pigeon_copy() {
    return WKNavigationAction.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      request: request,
      targetFrame: targetFrame,
      navigationType: navigationType,
      observeValue: observeValue,
    );
  }
}

/// An object that contains the response to a navigation request, and which you
/// use to make navigation-related policy decisions.
///
/// See https://developer.apple.com/documentation/webkit/wknavigationresponse.
class WKNavigationResponse extends NSObject {
  /// Constructs [WKNavigationResponse] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKNavigationResponse.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.response,
    required this.isForMainFrame,
    super.observeValue,
  }) : super.pigeon_detached();

  /// The frame’s response.
  final URLResponse response;

  /// A Boolean value that indicates whether the response targets the web view’s
  /// main frame.
  final bool isForMainFrame;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKNavigationResponse Function(URLResponse response, bool isForMainFrame)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationResponse.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationResponse.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationResponse.pigeon_newInstance was null, expected non-null int.',
          );
          final URLResponse? arg_response = (args[1] as URLResponse?);
          assert(
            arg_response != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationResponse.pigeon_newInstance was null, expected non-null URLResponse.',
          );
          final bool? arg_isForMainFrame = (args[2] as bool?);
          assert(
            arg_isForMainFrame != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationResponse.pigeon_newInstance was null, expected non-null bool.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_response!,
                        arg_isForMainFrame!,
                      ) ??
                      WKNavigationResponse.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        response: arg_response!,
                        isForMainFrame: arg_isForMainFrame!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKNavigationResponse pigeon_copy() {
    return WKNavigationResponse.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      response: response,
      isForMainFrame: isForMainFrame,
      observeValue: observeValue,
    );
  }
}

/// An object that contains information about a frame on a webpage.
///
/// See https://developer.apple.com/documentation/webkit/wkframeinfo.
class WKFrameInfo extends NSObject {
  /// Constructs [WKFrameInfo] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKFrameInfo.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.isMainFrame,
    this.request,
    super.observeValue,
  }) : super.pigeon_detached();

  /// A Boolean value indicating whether the frame is the web site's main frame
  /// or a subframe.
  final bool isMainFrame;

  /// The frame’s current request.
  final URLRequest? request;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKFrameInfo Function(bool isMainFrame, URLRequest? request)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKFrameInfo.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKFrameInfo.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKFrameInfo.pigeon_newInstance was null, expected non-null int.',
          );
          final bool? arg_isMainFrame = (args[1] as bool?);
          assert(
            arg_isMainFrame != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKFrameInfo.pigeon_newInstance was null, expected non-null bool.',
          );
          final URLRequest? arg_request = (args[2] as URLRequest?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_isMainFrame!, arg_request) ??
                      WKFrameInfo.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        isMainFrame: arg_isMainFrame!,
                        request: arg_request,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKFrameInfo pigeon_copy() {
    return WKFrameInfo.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      isMainFrame: isMainFrame,
      request: request,
      observeValue: observeValue,
    );
  }
}

/// Information about an error condition including a domain, a domain-specific
/// error code, and application-specific information.
///
/// See https://developer.apple.com/documentation/foundation/nserror.
class NSError extends NSObject {
  /// Constructs [NSError] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  NSError.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.code,
    required this.domain,
    required this.userInfo,
    super.observeValue,
  }) : super.pigeon_detached();

  /// The error code.
  final int code;

  /// A string containing the error domain.
  final String domain;

  /// The user info dictionary.
  final Map<String, Object?> userInfo;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    NSError Function(int code, String domain, Map<String, Object?> userInfo)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSError.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSError.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSError.pigeon_newInstance was null, expected non-null int.',
          );
          final int? arg_code = (args[1] as int?);
          assert(
            arg_code != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSError.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_domain = (args[2] as String?);
          assert(
            arg_domain != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSError.pigeon_newInstance was null, expected non-null String.',
          );
          final Map<String, Object?>? arg_userInfo =
              (args[3] as Map<Object?, Object?>?)?.cast<String, Object?>();
          assert(
            arg_userInfo != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSError.pigeon_newInstance was null, expected non-null Map<String, Object?>.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_code!,
                        arg_domain!,
                        arg_userInfo!,
                      ) ??
                      NSError.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        code: arg_code!,
                        domain: arg_domain!,
                        userInfo: arg_userInfo!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  NSError pigeon_copy() {
    return NSError.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      code: code,
      domain: domain,
      userInfo: userInfo,
      observeValue: observeValue,
    );
  }
}

/// An object that encapsulates a message sent by JavaScript code from a
/// webpage.
///
/// See https://developer.apple.com/documentation/webkit/wkscriptmessage.
class WKScriptMessage extends NSObject {
  /// Constructs [WKScriptMessage] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKScriptMessage.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.name,
    this.body,
    super.observeValue,
  }) : super.pigeon_detached();

  /// The name of the message handler to which the message is sent.
  final String name;

  /// The body of the message.
  final Object? body;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKScriptMessage Function(String name, Object? body)? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessage.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessage.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessage.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_name = (args[1] as String?);
          assert(
            arg_name != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessage.pigeon_newInstance was null, expected non-null String.',
          );
          final Object? arg_body = (args[2] as Object?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_name!, arg_body) ??
                      WKScriptMessage.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        name: arg_name!,
                        body: arg_body,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKScriptMessage pigeon_copy() {
    return WKScriptMessage.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      name: name,
      body: body,
      observeValue: observeValue,
    );
  }
}

/// An object that identifies the origin of a particular resource.
///
/// See https://developer.apple.com/documentation/webkit/wksecurityorigin.
class WKSecurityOrigin extends NSObject {
  /// Constructs [WKSecurityOrigin] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKSecurityOrigin.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.host,
    required this.port,
    required this.securityProtocol,
    super.observeValue,
  }) : super.pigeon_detached();

  /// The security origin’s host.
  final String host;

  /// The security origin's port.
  final int port;

  /// The security origin's protocol.
  final String securityProtocol;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKSecurityOrigin Function(String host, int port, String securityProtocol)?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKSecurityOrigin.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKSecurityOrigin.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKSecurityOrigin.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_host = (args[1] as String?);
          assert(
            arg_host != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKSecurityOrigin.pigeon_newInstance was null, expected non-null String.',
          );
          final int? arg_port = (args[2] as int?);
          assert(
            arg_port != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKSecurityOrigin.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_securityProtocol = (args[3] as String?);
          assert(
            arg_securityProtocol != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKSecurityOrigin.pigeon_newInstance was null, expected non-null String.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_host!,
                        arg_port!,
                        arg_securityProtocol!,
                      ) ??
                      WKSecurityOrigin.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        host: arg_host!,
                        port: arg_port!,
                        securityProtocol: arg_securityProtocol!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKSecurityOrigin pigeon_copy() {
    return WKSecurityOrigin.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      host: host,
      port: port,
      securityProtocol: securityProtocol,
      observeValue: observeValue,
    );
  }
}

/// A representation of an HTTP cookie.
///
/// See https://developer.apple.com/documentation/foundation/httpcookie.
class HTTPCookie extends NSObject {
  HTTPCookie({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    required Map<HttpCookiePropertyKey, Object> properties,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecHTTPCookie;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.HTTPCookie.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, properties],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [HTTPCookie] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  HTTPCookie.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecHTTPCookie =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    HTTPCookie Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.HTTPCookie.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.HTTPCookie.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.HTTPCookie.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      HTTPCookie.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// The cookie’s properties.
  Future<Map<HttpCookiePropertyKey, Object>?> getProperties() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecHTTPCookie;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.HTTPCookie.getProperties';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Map<Object?, Object?>?)
          ?.cast<HttpCookiePropertyKey, Object>();
    }
  }

  @override
  HTTPCookie pigeon_copy() {
    return HTTPCookie.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// Response object used to return multiple values to an auth challenge received
/// by a `WKNavigationDelegate` auth challenge.
///
/// The `webView(_:didReceive:completionHandler:)` method in
/// `WKNavigationDelegate` responds with a completion handler that takes two
/// values. The wrapper returns this class instead to handle this scenario.
class AuthenticationChallengeResponse extends PigeonInternalProxyApiBaseClass {
  /// Creates an [AuthenticationChallengeResponse].
  ///
  /// Due to https://github.com/flutter/flutter/issues/162437, this should only
  /// be used for testing.
  AuthenticationChallengeResponse({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.disposition,
    this.credential,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecAuthenticationChallengeResponse;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.AuthenticationChallengeResponse.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, disposition, credential],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [AuthenticationChallengeResponse] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  AuthenticationChallengeResponse.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.disposition,
    this.credential,
  });

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecAuthenticationChallengeResponse =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The option to use to handle the challenge.
  final UrlSessionAuthChallengeDisposition disposition;

  /// The credential to use for authentication when the disposition parameter
  /// contains the value URLSession.AuthChallengeDisposition.useCredential.
  final URLCredential? credential;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    AuthenticationChallengeResponse Function(
      UrlSessionAuthChallengeDisposition disposition,
      URLCredential? credential,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.AuthenticationChallengeResponse.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.AuthenticationChallengeResponse.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.AuthenticationChallengeResponse.pigeon_newInstance was null, expected non-null int.',
          );
          final UrlSessionAuthChallengeDisposition? arg_disposition =
              (args[1] as UrlSessionAuthChallengeDisposition?);
          assert(
            arg_disposition != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.AuthenticationChallengeResponse.pigeon_newInstance was null, expected non-null UrlSessionAuthChallengeDisposition.',
          );
          final URLCredential? arg_credential = (args[2] as URLCredential?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_disposition!, arg_credential) ??
                      AuthenticationChallengeResponse.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        disposition: arg_disposition!,
                        credential: arg_credential,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Creates an [AuthenticationChallengeResponse]
  ///
  /// This provides the native `AuthenticationChallengeResponse()` constructor
  /// as an async method to ensure the class is added to the InstanceManager.
  /// See https://github.com/flutter/flutter/issues/162437.
  static Future<AuthenticationChallengeResponse> createAsync(
    UrlSessionAuthChallengeDisposition disposition,
    URLCredential? credential, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.AuthenticationChallengeResponse.createAsync';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[disposition, credential],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as AuthenticationChallengeResponse?)!;
    }
  }

  @override
  AuthenticationChallengeResponse pigeon_copy() {
    return AuthenticationChallengeResponse.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      disposition: disposition,
      credential: credential,
    );
  }
}

/// An object that manages cookies, disk and memory caches, and other types of
/// data for a web view.
///
/// See https://developer.apple.com/documentation/webkit/wkwebsitedatastore.
class WKWebsiteDataStore extends NSObject {
  /// Constructs [WKWebsiteDataStore] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKWebsiteDataStore.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecWKWebsiteDataStore = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// The default data store, which stores data persistently to disk.
  static final WKWebsiteDataStore defaultDataStore =
      pigeonVar_defaultDataStore();

  /// The object that manages the HTTP cookies for your website.
  late final WKHTTPCookieStore httpCookieStore = pigeonVar_httpCookieStore();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKWebsiteDataStore Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebsiteDataStore.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebsiteDataStore.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebsiteDataStore.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      WKWebsiteDataStore.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  static WKWebsiteDataStore pigeonVar_defaultDataStore() {
    final WKWebsiteDataStore pigeonVar_instance =
        WKWebsiteDataStore.pigeon_detached();
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(PigeonInstanceManager.instance);
    final BinaryMessenger pigeonVar_binaryMessenger =
        ServicesBinding.instance.defaultBinaryMessenger;
    final int pigeonVar_instanceIdentifier = PigeonInstanceManager.instance
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebsiteDataStore.defaultDataStore';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  WKHTTPCookieStore pigeonVar_httpCookieStore() {
    final WKHTTPCookieStore pigeonVar_instance =
        WKHTTPCookieStore.pigeon_detached(
          pigeon_binaryMessenger: pigeon_binaryMessenger,
          pigeon_instanceManager: pigeon_instanceManager,
        );
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebsiteDataStore;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebsiteDataStore.httpCookieStore';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[this, pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  /// Removes the specified types of website data from one or more data records.
  Future<bool> removeDataOfTypes(
    List<WebsiteDataType> dataTypes,
    double modificationTimeInSecondsSinceEpoch,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebsiteDataStore;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebsiteDataStore.removeDataOfTypes';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, dataTypes, modificationTimeInSecondsSinceEpoch],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  @override
  WKWebsiteDataStore pigeon_copy() {
    return WKWebsiteDataStore.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An object that manages the content for a rectangular area on the screen.
///
/// See https://developer.apple.com/documentation/uikit/uiview.
class UIView extends NSObject {
  /// Constructs [UIView] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  UIView.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecUIView =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    UIView Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIView.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIView.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIView.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      UIView.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// The view’s background color.
  Future<void> setBackgroundColor(int? value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIView.setBackgroundColor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// A Boolean value that determines whether the view is opaque.
  Future<void> setOpaque(bool opaque) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIView.setOpaque';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, opaque],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  UIView pigeon_copy() {
    return UIView.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// A view that allows the scrolling and zooming of its contained views.
///
/// See https://developer.apple.com/documentation/uikit/uiscrollview.
class UIScrollView extends UIView {
  /// Constructs [UIScrollView] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  UIScrollView.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecUIScrollView =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    UIScrollView Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      UIScrollView.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// The point at which the origin of the content view is offset from the
  /// origin of the scroll view.
  Future<List<double>> getContentOffset() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.getContentOffset';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)!.cast<double>();
    }
  }

  /// Move the scrolled position of your view.
  ///
  /// Convenience method to synchronize change to the x and y scroll position.
  Future<void> scrollBy(double x, double y) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.scrollBy';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, x, y],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The point at which the origin of the content view is offset from the
  /// origin of the scroll view.
  Future<void> setContentOffset(double x, double y) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setContentOffset';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, x, y],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The delegate of the scroll view.
  Future<void> setDelegate(UIScrollViewDelegate? delegate) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setDelegate';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, delegate],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Whether the scroll view bounces past the edge of content and back again.
  Future<void> setBounces(bool value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setBounces';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Whether the scroll view bounces when it reaches the ends of its horizontal
  /// axis.
  Future<void> setBouncesHorizontally(bool value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setBouncesHorizontally';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Whether the scroll view bounces when it reaches the ends of its vertical
  /// axis.
  Future<void> setBouncesVertically(bool value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setBouncesVertically';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Whether bouncing always occurs when vertical scrolling reaches the end of
  /// the content.
  ///
  /// If the value of this property is true and `bouncesVertically` is true, the
  /// scroll view allows vertical dragging even if the content is smaller than
  /// the bounds of the scroll view.
  Future<void> setAlwaysBounceVertical(bool value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setAlwaysBounceVertical';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Whether bouncing always occurs when horizontal scrolling reaches the end
  /// of the content view.
  ///
  /// If the value of this property is true and `bouncesHorizontally` is true,
  /// the scroll view allows horizontal dragging even if the content is smaller
  /// than the bounds of the scroll view.
  Future<void> setAlwaysBounceHorizontal(bool value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setAlwaysBounceHorizontal';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Whether the vertical scroll indicator is visible.
  ///
  /// The default value is true.
  Future<void> setShowsVerticalScrollIndicator(bool value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setShowsVerticalScrollIndicator';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Whether the horizontal scroll indicator is visible.
  ///
  /// The default value is true.
  Future<void> setShowsHorizontalScrollIndicator(bool value) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollView.setShowsHorizontalScrollIndicator';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, value],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  UIScrollView pigeon_copy() {
    return UIScrollView.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// A collection of properties that you use to initialize a web view..
///
/// See https://developer.apple.com/documentation/webkit/wkwebviewconfiguration.
class WKWebViewConfiguration extends NSObject {
  WKWebViewConfiguration({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [WKWebViewConfiguration] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKWebViewConfiguration.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecWKWebViewConfiguration = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKWebViewConfiguration Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      WKWebViewConfiguration.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// The object that coordinates interactions between your app’s native code
  /// and the webpage’s scripts and other content.
  Future<void> setUserContentController(
    WKUserContentController controller,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.setUserContentController';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, controller],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The object that coordinates interactions between your app’s native code
  /// and the webpage’s scripts and other content.
  Future<WKUserContentController> getUserContentController() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.getUserContentController';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as WKUserContentController?)!;
    }
  }

  /// The object you use to get and set the site’s cookies and to track the
  /// cached data objects.
  Future<void> setWebsiteDataStore(WKWebsiteDataStore dataStore) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.setWebsiteDataStore';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, dataStore],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The object you use to get and set the site’s cookies and to track the
  /// cached data objects.
  Future<WKWebsiteDataStore> getWebsiteDataStore() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.getWebsiteDataStore';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as WKWebsiteDataStore?)!;
    }
  }

  /// The object that manages the preference-related settings for the web view.
  Future<void> setPreferences(WKPreferences preferences) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.setPreferences';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, preferences],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The object that manages the preference-related settings for the web view.
  Future<WKPreferences> getPreferences() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.getPreferences';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as WKPreferences?)!;
    }
  }

  /// A Boolean value that indicates whether HTML5 videos play inline or use the
  /// native full-screen controller.
  Future<void> setAllowsInlineMediaPlayback(bool allow) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.setAllowsInlineMediaPlayback';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, allow],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// A Boolean value that indicates whether the web view limits navigation to
  /// pages within the app’s domain.
  Future<void> setLimitsNavigationsToAppBoundDomains(bool limit) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.setLimitsNavigationsToAppBoundDomains';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, limit],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The media types that require a user gesture to begin playing.
  Future<void> setMediaTypesRequiringUserActionForPlayback(
    AudiovisualMediaType type,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.setMediaTypesRequiringUserActionForPlayback';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, type],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The default preferences to use when loading and rendering content.
  Future<WKWebpagePreferences> getDefaultWebpagePreferences() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebViewConfiguration;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebViewConfiguration.getDefaultWebpagePreferences';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as WKWebpagePreferences?)!;
    }
  }

  @override
  WKWebViewConfiguration pigeon_copy() {
    return WKWebViewConfiguration.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An object for managing interactions between JavaScript code and your web
/// view, and for filtering content in your web view.
///
/// See https://developer.apple.com/documentation/webkit/wkusercontentcontroller.
class WKUserContentController extends NSObject {
  /// Constructs [WKUserContentController] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKUserContentController.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecWKUserContentController = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKUserContentController Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      WKUserContentController.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Installs a message handler that you can call from your JavaScript code.
  Future<void> addScriptMessageHandler(
    WKScriptMessageHandler handler,
    String name,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKUserContentController;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.addScriptMessageHandler';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, handler, name],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Uninstalls the custom message handler with the specified name from your
  /// JavaScript code.
  Future<void> removeScriptMessageHandler(String name) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKUserContentController;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.removeScriptMessageHandler';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, name],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Uninstalls all custom message handlers associated with the user content
  /// controller.
  Future<void> removeAllScriptMessageHandlers() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKUserContentController;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.removeAllScriptMessageHandlers';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Injects the specified script into the webpage’s content.
  Future<void> addUserScript(WKUserScript userScript) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKUserContentController;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.addUserScript';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, userScript],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Removes all user scripts from the web view.
  Future<void> removeAllUserScripts() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKUserContentController;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUserContentController.removeAllUserScripts';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  WKUserContentController pigeon_copy() {
    return WKUserContentController.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An object that encapsulates the standard behaviors to apply to websites.
///
/// See https://developer.apple.com/documentation/webkit/wkpreferences.
class WKPreferences extends NSObject {
  /// Constructs [WKPreferences] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKPreferences.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecWKPreferences =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKPreferences Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKPreferences.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKPreferences.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKPreferences.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      WKPreferences.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// A Boolean value that indicates whether JavaScript is enabled.
  Future<void> setJavaScriptEnabled(bool enabled) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKPreferences;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKPreferences.setJavaScriptEnabled';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, enabled],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  WKPreferences pigeon_copy() {
    return WKPreferences.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An interface for receiving messages from JavaScript code running in a webpage.
///
/// See https://developer.apple.com/documentation/webkit/wkscriptmessagehandler.
class WKScriptMessageHandler extends NSObject {
  WKScriptMessageHandler({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    required this.didReceiveScriptMessage,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKScriptMessageHandler;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessageHandler.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [WKScriptMessageHandler] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKScriptMessageHandler.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    required this.didReceiveScriptMessage,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecWKScriptMessageHandler = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// Tells the handler that a webpage sent a script message.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKScriptMessageHandler instance = WKScriptMessageHandler(
  ///  didReceiveScriptMessage: (WKScriptMessageHandler pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    WKScriptMessageHandler pigeon_instance,
    WKUserContentController controller,
    WKScriptMessage message,
  )
  didReceiveScriptMessage;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(
      WKScriptMessageHandler pigeon_instance,
      WKUserContentController controller,
      WKScriptMessage message,
    )?
    didReceiveScriptMessage,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessageHandler.didReceiveScriptMessage',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessageHandler.didReceiveScriptMessage was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKScriptMessageHandler? arg_pigeon_instance =
              (args[0] as WKScriptMessageHandler?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessageHandler.didReceiveScriptMessage was null, expected non-null WKScriptMessageHandler.',
          );
          final WKUserContentController? arg_controller =
              (args[1] as WKUserContentController?);
          assert(
            arg_controller != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessageHandler.didReceiveScriptMessage was null, expected non-null WKUserContentController.',
          );
          final WKScriptMessage? arg_message = (args[2] as WKScriptMessage?);
          assert(
            arg_message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKScriptMessageHandler.didReceiveScriptMessage was null, expected non-null WKScriptMessage.',
          );
          try {
            (didReceiveScriptMessage ??
                    arg_pigeon_instance!.didReceiveScriptMessage)
                .call(arg_pigeon_instance!, arg_controller!, arg_message!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKScriptMessageHandler pigeon_copy() {
    return WKScriptMessageHandler.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
      didReceiveScriptMessage: didReceiveScriptMessage,
    );
  }
}

/// Methods for accepting or rejecting navigation changes, and for tracking the
/// progress of navigation requests.
///
/// See https://developer.apple.com/documentation/webkit/wknavigationdelegate.
class WKNavigationDelegate extends NSObject {
  WKNavigationDelegate({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    this.didFinishNavigation,
    this.didStartProvisionalNavigation,
    required this.decidePolicyForNavigationAction,
    required this.decidePolicyForNavigationResponse,
    this.didFailNavigation,
    this.didFailProvisionalNavigation,
    this.webViewWebContentProcessDidTerminate,
    required this.didReceiveAuthenticationChallenge,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKNavigationDelegate;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [WKNavigationDelegate] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKNavigationDelegate.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    this.didFinishNavigation,
    this.didStartProvisionalNavigation,
    required this.decidePolicyForNavigationAction,
    required this.decidePolicyForNavigationResponse,
    this.didFailNavigation,
    this.didFailProvisionalNavigation,
    this.webViewWebContentProcessDidTerminate,
    required this.didReceiveAuthenticationChallenge,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecWKNavigationDelegate = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// Tells the delegate that navigation is complete.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  didFinishNavigation: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    WKNavigationDelegate pigeon_instance,
    WKWebView webView,
    String? url,
  )?
  didFinishNavigation;

  /// Tells the delegate that navigation from the main frame has started.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  didStartProvisionalNavigation: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    WKNavigationDelegate pigeon_instance,
    WKWebView webView,
    String? url,
  )?
  didStartProvisionalNavigation;

  /// Asks the delegate for permission to navigate to new content based on the
  /// specified action information.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  decidePolicyForNavigationAction: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<NavigationActionPolicy> Function(
    WKNavigationDelegate pigeon_instance,
    WKWebView webView,
    WKNavigationAction navigationAction,
  )
  decidePolicyForNavigationAction;

  /// Asks the delegate for permission to navigate to new content after the
  /// response to the navigation request is known.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  decidePolicyForNavigationResponse: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<NavigationResponsePolicy> Function(
    WKNavigationDelegate pigeon_instance,
    WKWebView webView,
    WKNavigationResponse navigationResponse,
  )
  decidePolicyForNavigationResponse;

  /// Tells the delegate that an error occurred during navigation.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  didFailNavigation: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    WKNavigationDelegate pigeon_instance,
    WKWebView webView,
    NSError error,
  )?
  didFailNavigation;

  /// Tells the delegate that an error occurred during the early navigation
  /// process.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  didFailProvisionalNavigation: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    WKNavigationDelegate pigeon_instance,
    WKWebView webView,
    NSError error,
  )?
  didFailProvisionalNavigation;

  /// Tells the delegate that the web view’s content process was terminated.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  webViewWebContentProcessDidTerminate: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(WKNavigationDelegate pigeon_instance, WKWebView webView)?
  webViewWebContentProcessDidTerminate;

  /// Asks the delegate to respond to an authentication challenge.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKNavigationDelegate instance = WKNavigationDelegate(
  ///  didReceiveAuthenticationChallenge: (WKNavigationDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<AuthenticationChallengeResponse> Function(
    WKNavigationDelegate pigeon_instance,
    WKWebView webView,
    URLAuthenticationChallenge challenge,
  )
  didReceiveAuthenticationChallenge;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(
      WKNavigationDelegate pigeon_instance,
      WKWebView webView,
      String? url,
    )?
    didFinishNavigation,
    void Function(
      WKNavigationDelegate pigeon_instance,
      WKWebView webView,
      String? url,
    )?
    didStartProvisionalNavigation,
    Future<NavigationActionPolicy> Function(
      WKNavigationDelegate pigeon_instance,
      WKWebView webView,
      WKNavigationAction navigationAction,
    )?
    decidePolicyForNavigationAction,
    Future<NavigationResponsePolicy> Function(
      WKNavigationDelegate pigeon_instance,
      WKWebView webView,
      WKNavigationResponse navigationResponse,
    )?
    decidePolicyForNavigationResponse,
    void Function(
      WKNavigationDelegate pigeon_instance,
      WKWebView webView,
      NSError error,
    )?
    didFailNavigation,
    void Function(
      WKNavigationDelegate pigeon_instance,
      WKWebView webView,
      NSError error,
    )?
    didFailProvisionalNavigation,
    void Function(WKNavigationDelegate pigeon_instance, WKWebView webView)?
    webViewWebContentProcessDidTerminate,
    Future<AuthenticationChallengeResponse> Function(
      WKNavigationDelegate pigeon_instance,
      WKWebView webView,
      URLAuthenticationChallenge challenge,
    )?
    didReceiveAuthenticationChallenge,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFinishNavigation',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFinishNavigation was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFinishNavigation was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFinishNavigation was null, expected non-null WKWebView.',
          );
          final String? arg_url = (args[2] as String?);
          try {
            (didFinishNavigation ?? arg_pigeon_instance!.didFinishNavigation)
                ?.call(arg_pigeon_instance!, arg_webView!, arg_url);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didStartProvisionalNavigation',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didStartProvisionalNavigation was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didStartProvisionalNavigation was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didStartProvisionalNavigation was null, expected non-null WKWebView.',
          );
          final String? arg_url = (args[2] as String?);
          try {
            (didStartProvisionalNavigation ??
                    arg_pigeon_instance!.didStartProvisionalNavigation)
                ?.call(arg_pigeon_instance!, arg_webView!, arg_url);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationAction',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationAction was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationAction was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationAction was null, expected non-null WKWebView.',
          );
          final WKNavigationAction? arg_navigationAction =
              (args[2] as WKNavigationAction?);
          assert(
            arg_navigationAction != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationAction was null, expected non-null WKNavigationAction.',
          );
          try {
            final NavigationActionPolicy output =
                await (decidePolicyForNavigationAction ??
                        arg_pigeon_instance!.decidePolicyForNavigationAction)
                    .call(
                      arg_pigeon_instance!,
                      arg_webView!,
                      arg_navigationAction!,
                    );
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationResponse',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationResponse was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationResponse was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationResponse was null, expected non-null WKWebView.',
          );
          final WKNavigationResponse? arg_navigationResponse =
              (args[2] as WKNavigationResponse?);
          assert(
            arg_navigationResponse != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.decidePolicyForNavigationResponse was null, expected non-null WKNavigationResponse.',
          );
          try {
            final NavigationResponsePolicy output =
                await (decidePolicyForNavigationResponse ??
                        arg_pigeon_instance!.decidePolicyForNavigationResponse)
                    .call(
                      arg_pigeon_instance!,
                      arg_webView!,
                      arg_navigationResponse!,
                    );
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailNavigation',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailNavigation was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailNavigation was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailNavigation was null, expected non-null WKWebView.',
          );
          final NSError? arg_error = (args[2] as NSError?);
          assert(
            arg_error != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailNavigation was null, expected non-null NSError.',
          );
          try {
            (didFailNavigation ?? arg_pigeon_instance!.didFailNavigation)?.call(
              arg_pigeon_instance!,
              arg_webView!,
              arg_error!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailProvisionalNavigation',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailProvisionalNavigation was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailProvisionalNavigation was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailProvisionalNavigation was null, expected non-null WKWebView.',
          );
          final NSError? arg_error = (args[2] as NSError?);
          assert(
            arg_error != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didFailProvisionalNavigation was null, expected non-null NSError.',
          );
          try {
            (didFailProvisionalNavigation ??
                    arg_pigeon_instance!.didFailProvisionalNavigation)
                ?.call(arg_pigeon_instance!, arg_webView!, arg_error!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.webViewWebContentProcessDidTerminate',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.webViewWebContentProcessDidTerminate was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.webViewWebContentProcessDidTerminate was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.webViewWebContentProcessDidTerminate was null, expected non-null WKWebView.',
          );
          try {
            (webViewWebContentProcessDidTerminate ??
                    arg_pigeon_instance!.webViewWebContentProcessDidTerminate)
                ?.call(arg_pigeon_instance!, arg_webView!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didReceiveAuthenticationChallenge',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didReceiveAuthenticationChallenge was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKNavigationDelegate? arg_pigeon_instance =
              (args[0] as WKNavigationDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didReceiveAuthenticationChallenge was null, expected non-null WKNavigationDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didReceiveAuthenticationChallenge was null, expected non-null WKWebView.',
          );
          final URLAuthenticationChallenge? arg_challenge =
              (args[2] as URLAuthenticationChallenge?);
          assert(
            arg_challenge != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKNavigationDelegate.didReceiveAuthenticationChallenge was null, expected non-null URLAuthenticationChallenge.',
          );
          try {
            final AuthenticationChallengeResponse output =
                await (didReceiveAuthenticationChallenge ??
                        arg_pigeon_instance!.didReceiveAuthenticationChallenge)
                    .call(arg_pigeon_instance!, arg_webView!, arg_challenge!);
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKNavigationDelegate pigeon_copy() {
    return WKNavigationDelegate.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
      didFinishNavigation: didFinishNavigation,
      didStartProvisionalNavigation: didStartProvisionalNavigation,
      decidePolicyForNavigationAction: decidePolicyForNavigationAction,
      decidePolicyForNavigationResponse: decidePolicyForNavigationResponse,
      didFailNavigation: didFailNavigation,
      didFailProvisionalNavigation: didFailProvisionalNavigation,
      webViewWebContentProcessDidTerminate:
          webViewWebContentProcessDidTerminate,
      didReceiveAuthenticationChallenge: didReceiveAuthenticationChallenge,
    );
  }
}

/// The root class of most Objective-C class hierarchies, from which subclasses
/// inherit a basic interface to the runtime system and the ability to behave as
/// Objective-C objects.
///
/// See https://developer.apple.com/documentation/objectivec/nsobject.
class NSObject extends PigeonInternalProxyApiBaseClass {
  NSObject({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.observeValue,
  }) {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSObject;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [NSObject] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  NSObject.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    this.observeValue,
  });

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecNSObject =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// Informs the observing object when the value at the specified key path
  /// relative to the observed object has changed.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final NSObject instance = NSObject(
  ///  observeValue: (NSObject pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    NSObject pigeon_instance,
    String? keyPath,
    NSObject? object,
    Map<KeyValueChangeKey, Object?>? change,
  )?
  observeValue;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    NSObject Function()? pigeon_newInstance,
    void Function(
      NSObject pigeon_instance,
      String? keyPath,
      NSObject? object,
      Map<KeyValueChangeKey, Object?>? change,
    )?
    observeValue,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      NSObject.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.observeValue',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.observeValue was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final NSObject? arg_pigeon_instance = (args[0] as NSObject?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.observeValue was null, expected non-null NSObject.',
          );
          final String? arg_keyPath = (args[1] as String?);
          final NSObject? arg_object = (args[2] as NSObject?);
          final Map<KeyValueChangeKey, Object?>? arg_change =
              (args[3] as Map<Object?, Object?>?)
                  ?.cast<KeyValueChangeKey, Object?>();
          try {
            (observeValue ?? arg_pigeon_instance!.observeValue)?.call(
              arg_pigeon_instance!,
              arg_keyPath,
              arg_object,
              arg_change,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Registers the observer object to receive KVO notifications for the key
  /// path relative to the object receiving this message.
  Future<void> addObserver(
    NSObject observer,
    String keyPath,
    List<KeyValueObservingOptions> options,
  ) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSObject;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.addObserver';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, observer, keyPath, options],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Stops the observer object from receiving change notifications for the
  /// property specified by the key path relative to the object receiving this
  /// message.
  Future<void> removeObserver(NSObject observer, String keyPath) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSObject;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSObject.removeObserver';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, observer, keyPath],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  NSObject pigeon_copy() {
    return NSObject.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An object that displays interactive web content, such as for an in-app
/// browser.
///
/// See https://developer.apple.com/documentation/webkit/wkwebview.
class UIViewWKWebView extends UIView implements WKWebView {
  UIViewWKWebView({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    required WKWebViewConfiguration initialConfiguration,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, initialConfiguration],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [UIViewWKWebView] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  UIViewWKWebView.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecUIViewWKWebView =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The object that contains the configuration details for the web view.
  late final WKWebViewConfiguration configuration = pigeonVar_configuration();

  /// The scroll view associated with the web view.
  late final UIScrollView scrollView = pigeonVar_scrollView();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    UIViewWKWebView Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      UIViewWKWebView.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  WKWebViewConfiguration pigeonVar_configuration() {
    final WKWebViewConfiguration pigeonVar_instance =
        WKWebViewConfiguration.pigeon_detached(
          pigeon_binaryMessenger: pigeon_binaryMessenger,
          pigeon_instanceManager: pigeon_instanceManager,
        );
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.configuration';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[this, pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  UIScrollView pigeonVar_scrollView() {
    final UIScrollView pigeonVar_instance = UIScrollView.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
    );
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.scrollView';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[this, pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  /// The object you use to integrate custom user interface elements, such as
  /// contextual menus or panels, into web view interactions.
  Future<void> setUIDelegate(WKUIDelegate delegate) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.setUIDelegate';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, delegate],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The object you use to manage navigation behavior for the web view.
  Future<void> setNavigationDelegate(WKNavigationDelegate delegate) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.setNavigationDelegate';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, delegate],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The URL for the current webpage.
  Future<String?> getUrl() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.getUrl';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// An estimate of what fraction of the current navigation has been loaded.
  Future<double> getEstimatedProgress() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.getEstimatedProgress';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as double?)!;
    }
  }

  /// Loads the web content that the specified URL request object references and
  /// navigates to that content.
  Future<void> load(URLRequest request) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.load';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, request],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Loads the contents of the specified HTML string and navigates to it.
  Future<void> loadHtmlString(String string, String? baseUrl) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.loadHtmlString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, string, baseUrl],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Loads the web content from the specified file and navigates to it.
  Future<void> loadFileUrl(String url, String readAccessUrl) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.loadFileUrl';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, url, readAccessUrl],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Convenience method to load a Flutter asset.
  Future<void> loadFlutterAsset(String key) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.loadFlutterAsset';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, key],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// A Boolean value that indicates whether there is a valid back item in the
  /// back-forward list.
  Future<bool> canGoBack() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.canGoBack';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// A Boolean value that indicates whether there is a valid forward item in
  /// the back-forward list.
  Future<bool> canGoForward() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.canGoForward';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// Navigates to the back item in the back-forward list.
  Future<void> goBack() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.goBack';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Navigates to the forward item in the back-forward list.
  Future<void> goForward() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.goForward';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Reloads the current webpage.
  Future<void> reload() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.reload';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The page title.
  Future<String?> getTitle() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.getTitle';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// A Boolean value that indicates whether horizontal swipe gestures trigger
  /// backward and forward page navigation.
  Future<void> setAllowsBackForwardNavigationGestures(bool allow) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.setAllowsBackForwardNavigationGestures';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, allow],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The custom user agent string.
  Future<void> setCustomUserAgent(String? userAgent) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.setCustomUserAgent';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, userAgent],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Evaluates the specified JavaScript string.
  Future<Object?> evaluateJavaScript(String javaScriptString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.evaluateJavaScript';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, javaScriptString],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// A Boolean value that indicates whether you can inspect the view with
  /// Safari Web Inspector.
  Future<void> setInspectable(bool inspectable) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.setInspectable';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, inspectable],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The custom user agent string.
  Future<String?> getCustomUserAgent() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.getCustomUserAgent';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// Whether to allow previews for link destinations and detected data such as
  /// addresses and phone numbers.
  ///
  /// Defaults to true.
  Future<void> setAllowsLinkPreview(bool allow) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIViewWKWebView.setAllowsLinkPreview';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, allow],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  UIViewWKWebView pigeon_copy() {
    return UIViewWKWebView.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An object that displays interactive web content, such as for an in-app
/// browser.
///
/// See https://developer.apple.com/documentation/webkit/wkwebview.
class NSViewWKWebView extends NSObject implements WKWebView {
  NSViewWKWebView({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    required WKWebViewConfiguration initialConfiguration,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, initialConfiguration],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [NSViewWKWebView] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  NSViewWKWebView.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecNSViewWKWebView =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// The object that contains the configuration details for the web view.
  late final WKWebViewConfiguration configuration = pigeonVar_configuration();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    NSViewWKWebView Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      NSViewWKWebView.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  WKWebViewConfiguration pigeonVar_configuration() {
    final WKWebViewConfiguration pigeonVar_instance =
        WKWebViewConfiguration.pigeon_detached(
          pigeon_binaryMessenger: pigeon_binaryMessenger,
          pigeon_instanceManager: pigeon_instanceManager,
        );
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(pigeonVar_instance);
    () async {
      const String pigeonVar_channelName =
          'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.configuration';
      final BasicMessageChannel<Object?> pigeonVar_channel =
          BasicMessageChannel<Object?>(
            pigeonVar_channelName,
            pigeonChannelCodec,
            binaryMessenger: pigeonVar_binaryMessenger,
          );
      final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
        <Object?>[this, pigeonVar_instanceIdentifier],
      );
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
    return pigeonVar_instance;
  }

  /// The object you use to integrate custom user interface elements, such as
  /// contextual menus or panels, into web view interactions.
  Future<void> setUIDelegate(WKUIDelegate delegate) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.setUIDelegate';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, delegate],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The object you use to manage navigation behavior for the web view.
  Future<void> setNavigationDelegate(WKNavigationDelegate delegate) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.setNavigationDelegate';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, delegate],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The URL for the current webpage.
  Future<String?> getUrl() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.getUrl';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// An estimate of what fraction of the current navigation has been loaded.
  Future<double> getEstimatedProgress() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.getEstimatedProgress';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as double?)!;
    }
  }

  /// Loads the web content that the specified URL request object references and
  /// navigates to that content.
  Future<void> load(URLRequest request) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.load';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, request],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Loads the contents of the specified HTML string and navigates to it.
  Future<void> loadHtmlString(String string, String? baseUrl) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.loadHtmlString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, string, baseUrl],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Loads the web content from the specified file and navigates to it.
  Future<void> loadFileUrl(String url, String readAccessUrl) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.loadFileUrl';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, url, readAccessUrl],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Convenience method to load a Flutter asset.
  Future<void> loadFlutterAsset(String key) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.loadFlutterAsset';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, key],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// A Boolean value that indicates whether there is a valid back item in the
  /// back-forward list.
  Future<bool> canGoBack() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.canGoBack';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// A Boolean value that indicates whether there is a valid forward item in
  /// the back-forward list.
  Future<bool> canGoForward() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.canGoForward';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// Navigates to the back item in the back-forward list.
  Future<void> goBack() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.goBack';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Navigates to the forward item in the back-forward list.
  Future<void> goForward() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.goForward';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Reloads the current webpage.
  Future<void> reload() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.reload';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The page title.
  Future<String?> getTitle() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.getTitle';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// A Boolean value that indicates whether horizontal swipe gestures trigger
  /// backward and forward page navigation.
  Future<void> setAllowsBackForwardNavigationGestures(bool allow) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.setAllowsBackForwardNavigationGestures';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, allow],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The custom user agent string.
  Future<void> setCustomUserAgent(String? userAgent) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.setCustomUserAgent';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, userAgent],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// Evaluates the specified JavaScript string.
  Future<Object?> evaluateJavaScript(String javaScriptString) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.evaluateJavaScript';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, javaScriptString],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return pigeonVar_replyList[0];
    }
  }

  /// A Boolean value that indicates whether you can inspect the view with
  /// Safari Web Inspector.
  Future<void> setInspectable(bool inspectable) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.setInspectable';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, inspectable],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// The custom user agent string.
  Future<String?> getCustomUserAgent() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.getCustomUserAgent';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as String?);
    }
  }

  /// Whether to allow previews for link destinations and detected data such as
  /// addresses and phone numbers.
  ///
  /// Defaults to true.
  Future<void> setAllowsLinkPreview(bool allow) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecNSViewWKWebView;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.NSViewWKWebView.setAllowsLinkPreview';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, allow],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  NSViewWKWebView pigeon_copy() {
    return NSViewWKWebView.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An object that displays interactive web content, such as for an in-app
/// browser.
///
/// See https://developer.apple.com/documentation/webkit/wkwebview.
class WKWebView extends NSObject {
  /// Constructs [WKWebView] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKWebView.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKWebView Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebView.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebView.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebView.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      WKWebView.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKWebView pigeon_copy() {
    return WKWebView.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// The methods for presenting native user interface elements on behalf of a
/// webpage.
///
/// See https://developer.apple.com/documentation/webkit/wkuidelegate.
class WKUIDelegate extends NSObject {
  WKUIDelegate({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    this.onCreateWebView,
    required this.requestMediaCapturePermission,
    this.runJavaScriptAlertPanel,
    required this.runJavaScriptConfirmPanel,
    this.runJavaScriptTextInputPanel,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKUIDelegate;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [WKUIDelegate] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKUIDelegate.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    this.onCreateWebView,
    required this.requestMediaCapturePermission,
    this.runJavaScriptAlertPanel,
    required this.runJavaScriptConfirmPanel,
    this.runJavaScriptTextInputPanel,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecWKUIDelegate =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  /// Creates a new web view.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKUIDelegate instance = WKUIDelegate(
  ///  onCreateWebView: (WKUIDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    WKUIDelegate pigeon_instance,
    WKWebView webView,
    WKWebViewConfiguration configuration,
    WKNavigationAction navigationAction,
  )?
  onCreateWebView;

  /// Determines whether a web resource, which the security origin object
  /// describes, can access to the device’s microphone audio and camera video.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKUIDelegate instance = WKUIDelegate(
  ///  requestMediaCapturePermission: (WKUIDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<PermissionDecision> Function(
    WKUIDelegate pigeon_instance,
    WKWebView webView,
    WKSecurityOrigin origin,
    WKFrameInfo frame,
    MediaCaptureType type,
  )
  requestMediaCapturePermission;

  /// Displays a JavaScript alert panel.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKUIDelegate instance = WKUIDelegate(
  ///  runJavaScriptAlertPanel: (WKUIDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<void> Function(
    WKUIDelegate pigeon_instance,
    WKWebView webView,
    String message,
    WKFrameInfo frame,
  )?
  runJavaScriptAlertPanel;

  /// Displays a JavaScript confirm panel.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKUIDelegate instance = WKUIDelegate(
  ///  runJavaScriptConfirmPanel: (WKUIDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<bool> Function(
    WKUIDelegate pigeon_instance,
    WKWebView webView,
    String message,
    WKFrameInfo frame,
  )
  runJavaScriptConfirmPanel;

  /// Displays a JavaScript text input panel.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final WKUIDelegate instance = WKUIDelegate(
  ///  runJavaScriptTextInputPanel: (WKUIDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final Future<String?> Function(
    WKUIDelegate pigeon_instance,
    WKWebView webView,
    String prompt,
    String? defaultText,
    WKFrameInfo frame,
  )?
  runJavaScriptTextInputPanel;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    void Function(
      WKUIDelegate pigeon_instance,
      WKWebView webView,
      WKWebViewConfiguration configuration,
      WKNavigationAction navigationAction,
    )?
    onCreateWebView,
    Future<PermissionDecision> Function(
      WKUIDelegate pigeon_instance,
      WKWebView webView,
      WKSecurityOrigin origin,
      WKFrameInfo frame,
      MediaCaptureType type,
    )?
    requestMediaCapturePermission,
    Future<void> Function(
      WKUIDelegate pigeon_instance,
      WKWebView webView,
      String message,
      WKFrameInfo frame,
    )?
    runJavaScriptAlertPanel,
    Future<bool> Function(
      WKUIDelegate pigeon_instance,
      WKWebView webView,
      String message,
      WKFrameInfo frame,
    )?
    runJavaScriptConfirmPanel,
    Future<String?> Function(
      WKUIDelegate pigeon_instance,
      WKWebView webView,
      String prompt,
      String? defaultText,
      WKFrameInfo frame,
    )?
    runJavaScriptTextInputPanel,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.onCreateWebView',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.onCreateWebView was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKUIDelegate? arg_pigeon_instance = (args[0] as WKUIDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.onCreateWebView was null, expected non-null WKUIDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.onCreateWebView was null, expected non-null WKWebView.',
          );
          final WKWebViewConfiguration? arg_configuration =
              (args[2] as WKWebViewConfiguration?);
          assert(
            arg_configuration != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.onCreateWebView was null, expected non-null WKWebViewConfiguration.',
          );
          final WKNavigationAction? arg_navigationAction =
              (args[3] as WKNavigationAction?);
          assert(
            arg_navigationAction != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.onCreateWebView was null, expected non-null WKNavigationAction.',
          );
          try {
            (onCreateWebView ?? arg_pigeon_instance!.onCreateWebView)?.call(
              arg_pigeon_instance!,
              arg_webView!,
              arg_configuration!,
              arg_navigationAction!,
            );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.requestMediaCapturePermission',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.requestMediaCapturePermission was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKUIDelegate? arg_pigeon_instance = (args[0] as WKUIDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.requestMediaCapturePermission was null, expected non-null WKUIDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.requestMediaCapturePermission was null, expected non-null WKWebView.',
          );
          final WKSecurityOrigin? arg_origin = (args[2] as WKSecurityOrigin?);
          assert(
            arg_origin != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.requestMediaCapturePermission was null, expected non-null WKSecurityOrigin.',
          );
          final WKFrameInfo? arg_frame = (args[3] as WKFrameInfo?);
          assert(
            arg_frame != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.requestMediaCapturePermission was null, expected non-null WKFrameInfo.',
          );
          final MediaCaptureType? arg_type = (args[4] as MediaCaptureType?);
          assert(
            arg_type != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.requestMediaCapturePermission was null, expected non-null MediaCaptureType.',
          );
          try {
            final PermissionDecision output =
                await (requestMediaCapturePermission ??
                        arg_pigeon_instance!.requestMediaCapturePermission)
                    .call(
                      arg_pigeon_instance!,
                      arg_webView!,
                      arg_origin!,
                      arg_frame!,
                      arg_type!,
                    );
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptAlertPanel',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptAlertPanel was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKUIDelegate? arg_pigeon_instance = (args[0] as WKUIDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptAlertPanel was null, expected non-null WKUIDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptAlertPanel was null, expected non-null WKWebView.',
          );
          final String? arg_message = (args[2] as String?);
          assert(
            arg_message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptAlertPanel was null, expected non-null String.',
          );
          final WKFrameInfo? arg_frame = (args[3] as WKFrameInfo?);
          assert(
            arg_frame != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptAlertPanel was null, expected non-null WKFrameInfo.',
          );
          try {
            await (runJavaScriptAlertPanel ??
                    arg_pigeon_instance!.runJavaScriptAlertPanel)
                ?.call(
                  arg_pigeon_instance!,
                  arg_webView!,
                  arg_message!,
                  arg_frame!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptConfirmPanel',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptConfirmPanel was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKUIDelegate? arg_pigeon_instance = (args[0] as WKUIDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptConfirmPanel was null, expected non-null WKUIDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptConfirmPanel was null, expected non-null WKWebView.',
          );
          final String? arg_message = (args[2] as String?);
          assert(
            arg_message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptConfirmPanel was null, expected non-null String.',
          );
          final WKFrameInfo? arg_frame = (args[3] as WKFrameInfo?);
          assert(
            arg_frame != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptConfirmPanel was null, expected non-null WKFrameInfo.',
          );
          try {
            final bool output =
                await (runJavaScriptConfirmPanel ??
                        arg_pigeon_instance!.runJavaScriptConfirmPanel)
                    .call(
                      arg_pigeon_instance!,
                      arg_webView!,
                      arg_message!,
                      arg_frame!,
                    );
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptTextInputPanel',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptTextInputPanel was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final WKUIDelegate? arg_pigeon_instance = (args[0] as WKUIDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptTextInputPanel was null, expected non-null WKUIDelegate.',
          );
          final WKWebView? arg_webView = (args[1] as WKWebView?);
          assert(
            arg_webView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptTextInputPanel was null, expected non-null WKWebView.',
          );
          final String? arg_prompt = (args[2] as String?);
          assert(
            arg_prompt != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptTextInputPanel was null, expected non-null String.',
          );
          final String? arg_defaultText = (args[3] as String?);
          final WKFrameInfo? arg_frame = (args[4] as WKFrameInfo?);
          assert(
            arg_frame != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKUIDelegate.runJavaScriptTextInputPanel was null, expected non-null WKFrameInfo.',
          );
          try {
            final String? output =
                await (runJavaScriptTextInputPanel ??
                        arg_pigeon_instance!.runJavaScriptTextInputPanel)
                    ?.call(
                      arg_pigeon_instance!,
                      arg_webView!,
                      arg_prompt!,
                      arg_defaultText,
                      arg_frame!,
                    );
            return wrapResponse(result: output);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  WKUIDelegate pigeon_copy() {
    return WKUIDelegate.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
      onCreateWebView: onCreateWebView,
      requestMediaCapturePermission: requestMediaCapturePermission,
      runJavaScriptAlertPanel: runJavaScriptAlertPanel,
      runJavaScriptConfirmPanel: runJavaScriptConfirmPanel,
      runJavaScriptTextInputPanel: runJavaScriptTextInputPanel,
    );
  }
}

/// An object that manages the HTTP cookies associated with a particular web
/// view.
///
/// See https://developer.apple.com/documentation/webkit/wkhttpcookiestore.
class WKHTTPCookieStore extends NSObject {
  /// Constructs [WKHTTPCookieStore] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKHTTPCookieStore.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecWKHTTPCookieStore = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKHTTPCookieStore Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKHTTPCookieStore.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKHTTPCookieStore.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKHTTPCookieStore.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      WKHTTPCookieStore.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Sets a cookie policy that indicates whether the cookie store allows cookie
  /// storage.
  Future<void> setCookie(HTTPCookie cookie) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKHTTPCookieStore;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKHTTPCookieStore.setCookie';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, cookie],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  WKHTTPCookieStore pigeon_copy() {
    return WKHTTPCookieStore.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// The interface for the delegate of a scroll view.
///
/// See https://developer.apple.com/documentation/uikit/uiscrollviewdelegate.
class UIScrollViewDelegate extends NSObject {
  UIScrollViewDelegate({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    this.scrollViewDidScroll,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecUIScrollViewDelegate;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.pigeon_defaultConstructor';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [UIScrollViewDelegate] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  UIScrollViewDelegate.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    this.scrollViewDidScroll,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecUIScrollViewDelegate = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// Tells the delegate when the user scrolls the content view within the
  /// scroll view.
  ///
  /// Note that this is a convenient method that includes the `contentOffset` of
  /// the `scrollView`.
  ///
  /// For the associated Native object to be automatically garbage collected,
  /// it is required that the implementation of this `Function` doesn't have a
  /// strong reference to the encapsulating class instance. When this `Function`
  /// references a non-local variable, it is strongly recommended to access it
  /// with a `WeakReference`:
  ///
  /// ```dart
  /// final WeakReference weakMyVariable = WeakReference(myVariable);
  /// final UIScrollViewDelegate instance = UIScrollViewDelegate(
  ///  scrollViewDidScroll: (UIScrollViewDelegate pigeon_instance, ...) {
  ///    print(weakMyVariable?.target);
  ///  },
  /// );
  /// ```
  ///
  /// Alternatively, [PigeonInstanceManager.removeWeakReference] can be used to
  /// release the associated Native object manually.
  final void Function(
    UIScrollViewDelegate pigeon_instance,
    UIScrollView scrollView,
    double x,
    double y,
  )?
  scrollViewDidScroll;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    UIScrollViewDelegate Function()? pigeon_newInstance,
    void Function(
      UIScrollViewDelegate pigeon_instance,
      UIScrollView scrollView,
      double x,
      double y,
    )?
    scrollViewDidScroll,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      UIScrollViewDelegate.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }

    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.scrollViewDidScroll',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.scrollViewDidScroll was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final UIScrollViewDelegate? arg_pigeon_instance =
              (args[0] as UIScrollViewDelegate?);
          assert(
            arg_pigeon_instance != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.scrollViewDidScroll was null, expected non-null UIScrollViewDelegate.',
          );
          final UIScrollView? arg_scrollView = (args[1] as UIScrollView?);
          assert(
            arg_scrollView != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.scrollViewDidScroll was null, expected non-null UIScrollView.',
          );
          final double? arg_x = (args[2] as double?);
          assert(
            arg_x != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.scrollViewDidScroll was null, expected non-null double.',
          );
          final double? arg_y = (args[3] as double?);
          assert(
            arg_y != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.UIScrollViewDelegate.scrollViewDidScroll was null, expected non-null double.',
          );
          try {
            (scrollViewDidScroll ?? arg_pigeon_instance!.scrollViewDidScroll)
                ?.call(arg_pigeon_instance!, arg_scrollView!, arg_x!, arg_y!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  UIScrollViewDelegate pigeon_copy() {
    return UIScrollViewDelegate.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
      scrollViewDidScroll: scrollViewDidScroll,
    );
  }
}

/// An authentication credential consisting of information specific to the type
/// of credential and the type of persistent storage to use, if any.
///
/// See https://developer.apple.com/documentation/foundation/urlcredential.
class URLCredential extends NSObject {
  /// Creates a URL credential instance for internet password authentication
  /// with a given user name and password, using a given persistence setting.
  URLCredential.withUser({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
    required String user,
    required String password,
    required UrlCredentialPersistence persistence,
  }) : super.pigeon_detached() {
    final int pigeonVar_instanceIdentifier = pigeon_instanceManager
        .addDartCreatedInstance(this);
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLCredential;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLCredential.withUser';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[pigeonVar_instanceIdentifier, user, password, persistence],
    );
    () async {
      final List<Object?>? pigeonVar_replyList =
          await pigeonVar_sendFuture as List<Object?>?;
      if (pigeonVar_replyList == null) {
        throw _createConnectionError(pigeonVar_channelName);
      } else if (pigeonVar_replyList.length > 1) {
        throw PlatformException(
          code: pigeonVar_replyList[0]! as String,
          message: pigeonVar_replyList[1] as String?,
          details: pigeonVar_replyList[2],
        );
      } else {
        return;
      }
    }();
  }

  /// Constructs [URLCredential] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  URLCredential.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecURLCredential =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    URLCredential Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLCredential.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLCredential.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLCredential.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      URLCredential.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Creates a URL credential instance for internet password authentication
  /// with a given user name and password, using a given persistence setting.
  ///
  /// This provides the native `UrlCredential(user:password:persistence)`
  /// constructor as an async method to ensure the class is added to the
  /// InstanceManager. See https://github.com/flutter/flutter/issues/162437.
  static Future<URLCredential> withUserAsync(
    String user,
    String password,
    UrlCredentialPersistence persistence, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLCredential.withUserAsync';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[user, password, persistence],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as URLCredential?)!;
    }
  }

  /// Creates a URL credential instance for server trust authentication,
  /// initialized with a accepted trust.
  ///
  /// This provides the native `UrlCredential(forTrust:)` constructor as an
  /// async method to ensure the class is added to the InstanceManager. See
  /// https://github.com/flutter/flutter/issues/162437.
  static Future<URLCredential> serverTrustAsync(
    SecTrust trust, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLCredential.serverTrustAsync';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[trust],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as URLCredential?)!;
    }
  }

  @override
  URLCredential pigeon_copy() {
    return URLCredential.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// A server or an area on a server, commonly referred to as a realm, that
/// requires authentication.
///
/// See https://developer.apple.com/documentation/foundation/urlprotectionspace.
class URLProtectionSpace extends NSObject {
  /// Constructs [URLProtectionSpace] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  URLProtectionSpace.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.host,
    required this.port,
    this.realm,
    this.authenticationMethod,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecURLProtectionSpace = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  /// The receiver’s host.
  final String host;

  /// The receiver’s port.
  final int port;

  /// The receiver’s authentication realm.
  final String? realm;

  /// The authentication method used by the receiver.
  final String? authenticationMethod;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    URLProtectionSpace Function(
      String host,
      int port,
      String? realm,
      String? authenticationMethod,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLProtectionSpace.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLProtectionSpace.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLProtectionSpace.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_host = (args[1] as String?);
          assert(
            arg_host != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLProtectionSpace.pigeon_newInstance was null, expected non-null String.',
          );
          final int? arg_port = (args[2] as int?);
          assert(
            arg_port != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLProtectionSpace.pigeon_newInstance was null, expected non-null int.',
          );
          final String? arg_realm = (args[3] as String?);
          final String? arg_authenticationMethod = (args[4] as String?);
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(
                        arg_host!,
                        arg_port!,
                        arg_realm,
                        arg_authenticationMethod,
                      ) ??
                      URLProtectionSpace.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        host: arg_host!,
                        port: arg_port!,
                        realm: arg_realm,
                        authenticationMethod: arg_authenticationMethod,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// A representation of the server’s SSL transaction state.
  Future<SecTrust?> getServerTrust() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLProtectionSpace;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLProtectionSpace.getServerTrust';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as SecTrust?);
    }
  }

  @override
  URLProtectionSpace pigeon_copy() {
    return URLProtectionSpace.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      host: host,
      port: port,
      realm: realm,
      authenticationMethod: authenticationMethod,
      observeValue: observeValue,
    );
  }
}

/// A challenge from a server requiring authentication from the client.
///
/// See https://developer.apple.com/documentation/foundation/urlauthenticationchallenge.
class URLAuthenticationChallenge extends NSObject {
  /// Constructs [URLAuthenticationChallenge] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  URLAuthenticationChallenge.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecURLAuthenticationChallenge = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    URLAuthenticationChallenge Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLAuthenticationChallenge.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLAuthenticationChallenge.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URLAuthenticationChallenge.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      URLAuthenticationChallenge.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// The receiver’s protection space.
  Future<URLProtectionSpace> getProtectionSpace() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURLAuthenticationChallenge;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URLAuthenticationChallenge.getProtectionSpace';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as URLProtectionSpace?)!;
    }
  }

  @override
  URLAuthenticationChallenge pigeon_copy() {
    return URLAuthenticationChallenge.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// A value that identifies the location of a resource, such as an item on a
/// remote server or the path to a local file.
///
/// See https://developer.apple.com/documentation/foundation/url.
class URL extends NSObject {
  /// Constructs [URL] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  URL.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecURL =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    URL Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.URL.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URL.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.URL.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      URL.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// The absolute string for the URL.
  Future<String> getAbsoluteString() async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecURL;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.URL.getAbsoluteString';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as String?)!;
    }
  }

  @override
  URL pigeon_copy() {
    return URL.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An object that specifies the behaviors to use when loading and rendering
/// page content.
///
/// See https://developer.apple.com/documentation/webkit/wkwebpagepreferences.
class WKWebpagePreferences extends NSObject {
  /// Constructs [WKWebpagePreferences] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  WKWebpagePreferences.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec
  _pigeonVar_codecWKWebpagePreferences = _PigeonInternalProxyApiBaseCodec(
    pigeon_instanceManager,
  );

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    WKWebpagePreferences Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebpagePreferences.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebpagePreferences.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.WKWebpagePreferences.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      WKWebpagePreferences.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// A Boolean value that indicates whether JavaScript from web content is
  /// allowed to run.
  Future<void> setAllowsContentJavaScript(bool allow) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _pigeonVar_codecWKWebpagePreferences;
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.WKWebpagePreferences.setAllowsContentJavaScript';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[this, allow],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  @override
  WKWebpagePreferences pigeon_copy() {
    return WKWebpagePreferences.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// Data class used to respond to `SecTrust.getTrustResult`.
///
/// The native method needs to return two values, so this custom class is
/// created to support this.
class GetTrustResultResponse extends NSObject {
  /// Constructs [GetTrustResultResponse] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  GetTrustResultResponse.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    required this.result,
    required this.resultCode,
    super.observeValue,
  }) : super.pigeon_detached();

  /// The result code from the most recent trust evaluation.
  final DartSecTrustResultType result;

  /// A result code.
  ///
  /// See https://developer.apple.com/documentation/security/security-framework-result-codes?language=objc.
  final int resultCode;

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    GetTrustResultResponse Function(
      DartSecTrustResultType result,
      int resultCode,
    )?
    pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.GetTrustResultResponse.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.GetTrustResultResponse.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.GetTrustResultResponse.pigeon_newInstance was null, expected non-null int.',
          );
          final DartSecTrustResultType? arg_result =
              (args[1] as DartSecTrustResultType?);
          assert(
            arg_result != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.GetTrustResultResponse.pigeon_newInstance was null, expected non-null DartSecTrustResultType.',
          );
          final int? arg_resultCode = (args[2] as int?);
          assert(
            arg_resultCode != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.GetTrustResultResponse.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call(arg_result!, arg_resultCode!) ??
                      GetTrustResultResponse.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                        result: arg_result!,
                        resultCode: arg_resultCode!,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  @override
  GetTrustResultResponse pigeon_copy() {
    return GetTrustResultResponse.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      result: result,
      resultCode: resultCode,
      observeValue: observeValue,
    );
  }
}

/// An object used to evaluate trust.
///
/// See https://developer.apple.com/documentation/security/sectrust.
class SecTrust extends NSObject {
  /// Constructs [SecTrust] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  SecTrust.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecSecTrust =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    SecTrust Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      SecTrust.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Evaluates trust for the specified certificate and policies.
  static Future<bool> evaluateWithError(
    SecTrust trust, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.evaluateWithError';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[trust],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// Returns an opaque cookie containing exceptions to trust policies that will
  /// allow future evaluations of the current certificate to succeed.
  static Future<Uint8List?> copyExceptions(
    SecTrust trust, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.copyExceptions';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[trust],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?);
    }
  }

  /// Sets a list of exceptions that should be ignored when the certificate is
  /// evaluated.
  static Future<bool> setExceptions(
    SecTrust trust,
    Uint8List? exceptions, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.setExceptions';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[trust, exceptions],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as bool?)!;
    }
  }

  /// Returns the result code from the most recent trust evaluation.
  static Future<GetTrustResultResponse> getTrustResult(
    SecTrust trust, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.getTrustResult';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[trust],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as GetTrustResultResponse?)!;
    }
  }

  /// Certificates used to evaluate trust.
  static Future<List<SecCertificate>?> copyCertificateChain(
    SecTrust trust, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecTrust.copyCertificateChain';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[trust],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return (pigeonVar_replyList[0] as List<Object?>?)?.cast<SecCertificate>();
    }
  }

  @override
  SecTrust pigeon_copy() {
    return SecTrust.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}

/// An abstract Core Foundation-type object representing an X.509 certificate.
///
/// See https://developer.apple.com/documentation/security/seccertificate.
class SecCertificate extends NSObject {
  /// Constructs [SecCertificate] without creating the associated native object.
  ///
  /// This should only be used by subclasses created by this library or to
  /// create copies for an [PigeonInstanceManager].
  @protected
  SecCertificate.pigeon_detached({
    super.pigeon_binaryMessenger,
    super.pigeon_instanceManager,
    super.observeValue,
  }) : super.pigeon_detached();

  late final _PigeonInternalProxyApiBaseCodec _pigeonVar_codecSecCertificate =
      _PigeonInternalProxyApiBaseCodec(pigeon_instanceManager);

  static void pigeon_setUpMessageHandlers({
    bool pigeon_clearHandlers = false,
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
    SecCertificate Function()? pigeon_newInstance,
  }) {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? binaryMessenger = pigeon_binaryMessenger;
    {
      final BasicMessageChannel<Object?>
      pigeonVar_channel = BasicMessageChannel<Object?>(
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecCertificate.pigeon_newInstance',
        pigeonChannelCodec,
        binaryMessenger: binaryMessenger,
      );
      if (pigeon_clearHandlers) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(
            message != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.SecCertificate.pigeon_newInstance was null.',
          );
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_pigeon_instanceIdentifier = (args[0] as int?);
          assert(
            arg_pigeon_instanceIdentifier != null,
            'Argument for dev.flutter.pigeon.webview_flutter_wkwebview.SecCertificate.pigeon_newInstance was null, expected non-null int.',
          );
          try {
            (pigeon_instanceManager ?? PigeonInstanceManager.instance)
                .addHostCreatedInstance(
                  pigeon_newInstance?.call() ??
                      SecCertificate.pigeon_detached(
                        pigeon_binaryMessenger: pigeon_binaryMessenger,
                        pigeon_instanceManager: pigeon_instanceManager,
                      ),
                  arg_pigeon_instanceIdentifier!,
                );
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          } catch (e) {
            return wrapResponse(
              error: PlatformException(code: 'error', message: e.toString()),
            );
          }
        });
      }
    }
  }

  /// Returns a DER representation of a certificate given a certificate object.
  static Future<Uint8List> copyData(
    SecCertificate certificate, {
    BinaryMessenger? pigeon_binaryMessenger,
    PigeonInstanceManager? pigeon_instanceManager,
  }) async {
    final _PigeonInternalProxyApiBaseCodec pigeonChannelCodec =
        _PigeonInternalProxyApiBaseCodec(
          pigeon_instanceManager ?? PigeonInstanceManager.instance,
        );
    final BinaryMessenger? pigeonVar_binaryMessenger = pigeon_binaryMessenger;
    const String pigeonVar_channelName =
        'dev.flutter.pigeon.webview_flutter_wkwebview.SecCertificate.copyData';
    final BasicMessageChannel<Object?> pigeonVar_channel =
        BasicMessageChannel<Object?>(
          pigeonVar_channelName,
          pigeonChannelCodec,
          binaryMessenger: pigeonVar_binaryMessenger,
        );
    final Future<Object?> pigeonVar_sendFuture = pigeonVar_channel.send(
      <Object?>[certificate],
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_sendFuture as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as Uint8List?)!;
    }
  }

  @override
  SecCertificate pigeon_copy() {
    return SecCertificate.pigeon_detached(
      pigeon_binaryMessenger: pigeon_binaryMessenger,
      pigeon_instanceManager: pigeon_instanceManager,
      observeValue: observeValue,
    );
  }
}
