import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the Korean language
/// locale.
class KoCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `ko` locale.
  KoCountriesL10N() {
    map.addAll({
      "ABW": "아루바",
      "ABW+": "아루바",
      "AFG": "아프가니스탄",
      "AFG+": "아프가니스탄 이슬람 공화국",
      "AGO": "앙골라",
      "AGO+": "앙골라 공화국",
      "AIA": "앵귈라",
      "AIA+": "앵귈라",
      "ALA": "올란드 제도",
      "ALA+": "올란드 제도",
      "ALB": "알바니아",
      "ALB+": "알바니아 공화국",
      "AND": "안도라",
      "AND+": "안도라 공국",
      "ARE": "아랍에미리트",
      "ARE+": "아랍 토후국 연방",
      "ARG": "아르헨티나",
      "ARG+": "아르헨티나 공화국",
      "ARM": "아르메니아",
      "ARM+": "아르메니아 공화국",
      "ASM": "아메리칸사모아",
      "ASM+": "아메리칸사모아",
      "ATA": "남극",
      "ATA+": "남극",
      "ATF": "프랑스령 남부와 남극 지역",
      "ATF+": "프랑스령 남부와 남극 지역",
      "ATG": "앤티가 바부다",
      "ATG+": "앤티가 바부다",
      "AUS": "호주",
      "AUS+": "오스트레일리아 연방",
      "AUT": "오스트리아",
      "AUT+": "오스트리아 공화국",
      "AZE": "아제르바이잔",
      "AZE+": "아제르바이잔 공화국",
      "BDI": "부룬디",
      "BDI+": "부룬디",
      "BEL": "벨기에",
      "BEL+": "벨기에 왕국",
      "BEN": "베냉",
      "BEN+": "베냉 공화국",
      "BES": "카리브 네덜란드",
      "BES+": "보네르, 신트외스타티위스, 사바",
      "BFA": "부르키나파소",
      "BFA+": "부르키나파소",
      "BGD": "방글라데시",
      "BGD+": "방글라데시 인민 공화국",
      "BGR": "불가리아",
      "BGR+": "불가리아 공화국",
      "BHR": "바레인",
      "BHR+": "바레인 왕국",
      "BHS": "바하마",
      "BHS+": "바하마 연방",
      "BIH": "보스니아 헤르체고비나",
      "BIH+": "보스니아 헤르체고비나",
      "BLM": "생바르텔레미",
      "BLM+": "생바르텔레미",
      "BLR": "벨라루스",
      "BLR+": "벨라루스 공화국",
      "BLZ": "벨리즈",
      "BLZ+": "벨리즈",
      "BMU": "버뮤다",
      "BMU+": "버뮤다",
      "BOL": "볼리비아",
      "BOL+": "볼리비아 다민족국",
      "BRA": "브라질",
      "BRA+": "브라질 연방 공화국",
      "BRB": "바베이도스",
      "BRB+": "바베이도스",
      "BRN": "브루나이",
      "BRN+": "브루나이 다루살람국",
      "BTN": "부탄",
      "BTN+": "부탄 왕국",
      "BVT": "부베 섬",
      "BVT+": "부베 섬",
      "BWA": "보츠와나",
      "BWA+": "보츠와나 공화국",
      "CAF": "중앙아프리카 공화국",
      "CAF+": "중앙아프리카 공화국",
      "CAN": "캐나다",
      "CAN+": "캐나다",
      "CCK": "코코스 제도",
      "CCK+": "코코스 제도",
      "CHE": "스위스",
      "CHE+": "스위스 연방",
      "CHL": "칠레",
      "CHL+": "칠레 공화국",
      "CHN": "중국",
      "CHN+": "중화인민공화국",
      "CIV": "코트디부아르",
      "CIV+": "코트디부아르 공화국",
      "CMR": "카메룬",
      "CMR+": "카메룬 공화국",
      "COD": "콩고 민주 공화국",
      "COD+": "콩고 민주 공화국",
      "COG": "콩고",
      "COG+": "콩고",
      "COK": "쿡 제도",
      "COK+": "쿡 제도",
      "COL": "콜롬비아",
      "COL+": "콜롬비아 공화국",
      "COM": "코모로",
      "COM+": "코모로 연방",
      "CPV": "카보베르데",
      "CPV+": "카보베르데 공화국",
      "CRI": "코스타리카",
      "CRI+": "코스타리카 공화국",
      "CUB": "쿠바",
      "CUB+": "쿠바 공화국",
      "CUW": "퀴라소",
      "CUW+": "퀴라소",
      "CXR": "크리스마스 섬",
      "CXR+": "크리스마스 섬",
      "CYM": "케이맨 제도",
      "CYM+": "케이맨 제도",
      "CYP": "키프로스",
      "CYP+": "키프로스 공화국",
      "CZE": "체코",
      "CZE+": "체코",
      "DEU": "독일",
      "DEU+": "독일 연방 공화국",
      "DJI": "지부티",
      "DJI+": "지부티 공화국",
      "DMA": "도미니카",
      "DMA+": "도미니카 연방",
      "DNK": "덴마크",
      "DNK+": "덴마크 왕국",
      "DOM": "도미니카 공화국",
      "DOM+": "도미니카 공화국",
      "DZA": "알제리",
      "DZA+": "알제리 인민 민주 공화국",
      "ECU": "에콰도르",
      "ECU+": "에콰도르 공화국",
      "EGY": "이집트",
      "EGY+": "이집트 아랍 공화국",
      "ERI": "에리트레아",
      "ERI+": "에리트레아국",
      "ESH": "서사하라",
      "ESH+": "사하라 아랍 민주 공화국",
      "ESP": "스페인",
      "ESP+": "에스파냐 왕국",
      "EST": "에스토니아",
      "EST+": "에스토니아 공화국",
      "ETH": "에티오피아",
      "ETH+": "에티오피아 연방 민주 공화국",
      "FIN": "핀란드",
      "FIN+": "핀란드 공화국",
      "FJI": "피지",
      "FJI+": "피지 공화국",
      "FLK": "포클랜드 제도",
      "FLK+": "포클랜드 제도",
      "FRA": "프랑스",
      "FRA+": "프랑스 공화국",
      "FRO": "페로 제도",
      "FRO+": "페로 제도",
      "FSM": "미크로네시아",
      "FSM+": "미크로네시아 연방",
      "GAB": "가봉",
      "GAB+": "가봉 공화국",
      "GBR": "영국",
      "GBR+": "그레이트브리튼 북아일랜드 연합 왕국",
      "GEO": "조지아",
      "GEO+": "조지아",
      "GGY": "건지 섬",
      "GGY+": "건지 섬",
      "GHA": "가나",
      "GHA+": "가나 공화국",
      "GIB": "지브롤터",
      "GIB+": "지브롤터",
      "GIN": "기니",
      "GIN+": "기니 공화국",
      "GLP": "과들루프",
      "GLP+": "과들루프",
      "GMB": "감비아",
      "GMB+": "감비아 공화국",
      "GNB": "기니비사우",
      "GNB+": "기니비사우 공화국",
      "GNQ": "적도 기니",
      "GNQ+": "적도 기니 공화국",
      "GRC": "그리스",
      "GRC+": "그리스 공화국",
      "GRD": "그레나다",
      "GRD+": "그레나다",
      "GRL": "그린란드",
      "GRL+": "그린란드",
      "GTM": "과테말라",
      "GTM+": "과테말라 공화국",
      "GUF": "프랑스령 기아나",
      "GUF+": "프랑스령 기아나",
      "GUM": "괌",
      "GUM+": "괌",
      "GUY": "가이아나",
      "GUY+": "가이아나 협동 공화국",
      "HKG": "홍콩",
      "HKG+": "중화인민공화국 홍콩 특별행정구",
      "HMD": "허드 맥도널드 제도",
      "HMD+": "허드 맥도널드 제도",
      "HND": "온두라스",
      "HND+": "온두라스 공화국",
      "HRV": "크로아티아",
      "HRV+": "크로아티아 공화국",
      "HTI": "아이티",
      "HTI+": "아이티 공화국",
      "HUN": "헝가리",
      "HUN+": "헝가리",
      "IDN": "인도네시아",
      "IDN+": "인도네시아 공화국",
      "IMN": "맨섬",
      "IMN+": "맨섬",
      "IND": "인도",
      "IND+": "인도 공화국",
      "IOT": "영국령 인도양 지역",
      "IRL": "아일랜드",
      "IRL+": "아일랜드 공화국",
      "IRN": "이란",
      "IRN+": "이란 이슬람 공화국",
      "IRQ": "이라크",
      "IRQ+": "이라크 공화국",
      "ISL": "아이슬란드",
      "ISL+": "아이슬란드 공화국",
      "ISR": "이스라엘",
      "ISR+": "이스라엘국",
      "ITA": "이탈리아",
      "ITA+": "이탈리아 공화국",
      "JAM": "자메이카",
      "JAM+": "자메이카",
      "JEY": "저지 섬",
      "JEY+": "저지 섬",
      "JOR": "요르단",
      "JOR+": "요르단 하심 왕국",
      "JPN": "일본",
      "JPN+": "일본국",
      "KAZ": "카자흐스탄",
      "KAZ+": "카자흐스탄 공화국",
      "KEN": "케냐",
      "KEN+": "케냐 공화국",
      "KGZ": "키르기스스탄",
      "KGZ+": "키르기스 공화국",
      "KHM": "캄보디아",
      "KHM+": "캄보디아 왕국",
      "KIR": "키리바시",
      "KIR+": "키리바시 공화국",
      "KNA": "세인트키츠 네비스",
      "KNA+": "세인트키츠 네비스 연방",
      "KOR": "한국",
      "KOR+": "대한민국",
      "KWT": "쿠웨이트",
      "KWT+": "쿠웨이트국",
      "LAO": "라오스",
      "LAO+": "라오 인민 민주 공화국",
      "LBN": "레바논",
      "LBN+": "레바논 공화국",
      "LBR": "라이베리아",
      "LBR+": "라이베리아 공화국",
      "LBY": "리비아",
      "LBY+": "리비아",
      "LCA": "세인트루시아",
      "LCA+": "세인트루시아",
      "LIE": "리히텐슈타인",
      "LIE+": "리히텐슈타인 공국",
      "LKA": "스리랑카",
      "LKA+": "스리랑카 민주 사회주의 공화국",
      "LSO": "레소토",
      "LSO+": "레소토 왕국",
      "LTU": "리투아니아",
      "LTU+": "리투아니아 공화국",
      "LUX": "룩셈부르크",
      "LUX+": "룩셈부르크 대공국",
      "LVA": "라트비아",
      "LVA+": "라트비아 공화국",
      "MAC": "마카오",
      "MAC+": "중화인민공화국 마카오 특별행정구",
      "MAF": "생마르탱",
      "MAF+": "생마르탱",
      "MAR": "모로코",
      "MAR+": "모로코 왕국",
      "MCO": "모나코",
      "MCO+": "모나코 공국",
      "MDA": "몰도바",
      "MDA+": "몰도바 공화국",
      "MDG": "마다가스카르",
      "MDG+": "마다가스카르 공화국",
      "MDV": "몰디브",
      "MDV+": "몰디브 공화국",
      "MEX": "멕시코",
      "MEX+": "멕시코 합중국",
      "MHL": "마셜 제도",
      "MHL+": "마셜 제도 공화국",
      "MKD": "북마케도니아",
      "MKD+": "북마케도니아 공화국",
      "MLI": "말리",
      "MLI+": "말리 공화국",
      "MLT": "몰타",
      "MLT+": "몰타 공화국",
      "MMR": "미얀마",
      "MMR+": "미얀마 연방 공화국",
      "MNE": "몬테네그로",
      "MNE+": "몬테네그로",
      "MNG": "몽골",
      "MNG+": "몽골국",
      "MNP": "북마리아나 제도",
      "MNP+": "북마리아나 제도",
      "MOZ": "모잠비크",
      "MOZ+": "모잠비크 공화국",
      "MRT": "모리타니",
      "MRT+": "모리타니 이슬람 공화국",
      "MSR": "몬트세랫",
      "MSR+": "몬트세랫",
      "MTQ": "마르티니크",
      "MTQ+": "마르티니크",
      "MUS": "모리셔스",
      "MUS+": "모리셔스 공화국",
      "MWI": "말라위",
      "MWI+": "말라위 공화국",
      "MYS": "말레이시아",
      "MYS+": "말레이시아",
      "MYT": "마요트",
      "MYT+": "마요트",
      "NAM": "나미비아",
      "NAM+": "나미비아 공화국",
      "NCL": "누벨칼레도니",
      "NCL+": "누벨칼레도니",
      "NER": "니제르",
      "NER+": "니제르 공화국",
      "NFK": "노퍽 섬",
      "NFK+": "노퍽 섬",
      "NGA": "나이지리아",
      "NGA+": "나이지리아 연방 공화국",
      "NIC": "니카라과",
      "NIC+": "니카라과 공화국",
      "NIU": "니우에",
      "NIU+": "니우에",
      "NLD": "네덜란드",
      "NLD+": "네덜란드 왕국",
      "NOR": "노르웨이",
      "NOR+": "노르웨이 왕국",
      "NPL": "네팔",
      "NPL+": "네팔 연방 민주 공화국",
      "NRU": "나우루",
      "NRU+": "나우루 공화국",
      "NZL": "뉴질랜드",
      "NZL+": "뉴질랜드",
      "OMN": "오만",
      "OMN+": "오만 술탄국",
      "PAK": "파키스탄",
      "PAK+": "파키스탄 이슬람 공화국",
      "PAN": "파나마",
      "PAN+": "파나마 공화국",
      "PCN": "핏케언 제도",
      "PCN+": "핏케언 제도",
      "PER": "페루",
      "PER+": "페루 공화국",
      "PHL": "필리핀",
      "PHL+": "필리핀 공화국",
      "PLW": "팔라우",
      "PLW+": "팔라우 공화국",
      "PNG": "파푸아뉴기니",
      "PNG+": "파푸아뉴기니 독립국",
      "POL": "폴란드",
      "POL+": "폴란드 공화국",
      "PRI": "푸에르토리코",
      "PRI+": "푸에르토리코",
      "PRK": "조선",
      "PRK+": "조선민주주의인민공화국",
      "PRT": "포르투갈",
      "PRT+": "포르투갈 공화국",
      "PRY": "파라과이",
      "PRY+": "파라과이 공화국",
      "PSE": "팔레스타인",
      "PSE+": "팔레스타인국",
      "PYF": "프랑스령 폴리네시아",
      "PYF+": "프랑스령 폴리네시아",
      "QAT": "카타르",
      "QAT+": "카타르국",
      "REU": "레위니옹",
      "REU+": "레위니옹",
      "ROU": "루마니아",
      "ROU+": "루마니아",
      "RUS": "러시아",
      "RUS+": "러시아 연방",
      "RWA": "르완다",
      "RWA+": "르완다 공화국",
      "SAU": "사우디아라비아",
      "SAU+": "사우디아라비아 왕국",
      "SDN": "수단",
      "SDN+": "수단 공화국",
      "SEN": "세네갈",
      "SEN+": "세네갈 공화국",
      "SGP": "싱가포르",
      "SGP+": "싱가포르 공화국",
      "SGS": "사우스조지아 사우스샌드위치 제도",
      "SGS+": "사우스조지아 사우스샌드위치 제도",
      "SHN": "세인트헬레나",
      "SHN+": "세인트헬레나",
      "SJM": "스발바르 얀마옌 제도",
      "SJM+": "스발바르 얀마옌 제도",
      "SLB": "솔로몬 제도",
      "SLB+": "솔로몬 제도",
      "SLE": "시에라리온",
      "SLE+": "시에라리온 공화국",
      "SLV": "엘살바도르",
      "SLV+": "엘살바도르 공화국",
      "SMR": "산마리노",
      "SMR+": "산마리노 공화국",
      "SOM": "소말리아",
      "SOM+": " 소말리아 연방 공화국",
      "SPM": "생피에르 미클롱",
      "SPM+": "생피에르 미클롱",
      "SRB": "세르비아",
      "SRB+": "세르비아 공화국",
      "SSD": "남수단",
      "SSD+": "남수단 공화국",
      "STP": "상투메 프린시페",
      "STP+": "상투메 프린시페 민주 공화국",
      "SUR": "수리남",
      "SUR+": "수리남 공화국",
      "SVK": "슬로바키아",
      "SVK+": "슬로바키아 공화국",
      "SVN": "슬로베니아",
      "SVN+": "슬로베니아 공화국",
      "SWE": "스웨덴",
      "SWE+": "스웨덴 왕국",
      "SWZ": "에스와티니",
      "SWZ+": "에스와티니 왕국",
      "SXM": "신트마르턴",
      "SXM+": "신트마르턴",
      "SYC": "세이셸",
      "SYC+": "세이셸 공화국",
      "SYR": "시리아",
      "SYR+": "시리아 아랍 공화국",
      "TCA": "터크스 케이커스 제도",
      "TCA+": "터크스 케이커스 제도",
      "TCD": "차드",
      "TCD+": "차드 공화국",
      "TGO": "토고",
      "TGO+": "토고 공화국",
      "THA": "태국",
      "THA+": "타이 왕국",
      "TJK": "타지키스탄",
      "TJK+": "타지키스탄 공화국",
      "TKL": "토켈라우",
      "TKL+": "토켈라우",
      "TKM": "투르크메니스탄",
      "TKM+": "투르크메니스탄",
      "TLS": "동티모르",
      "TLS+": "동티모르 민주 공화국",
      "TON": "통가",
      "TON+": "통가 왕국",
      "TTO": "트리니다드 토바고",
      "TTO+": "트리니다드 토바고 공화국",
      "TUN": "튀니지",
      "TUN+": "튀니지 공화국",
      "TUR": "터키",
      "TUR+": "터키 공화국",
      "TUV": "투발루",
      "TUV+": "투발루",
      "TWN": "대만",
      "TWN+": "중화민국",
      "TZA": "탄자니아",
      "TZA+": "탄자니아 연합 공화국",
      "UGA": "우간다",
      "UGA+": "우간다 공화국",
      "UKR": "우크라이나",
      "UKR+": "우크라이나",
      "UMI": "미국령 군소 제도",
      "UMI+": "미국령 군소 제도",
      "UNK": "코소보",
      "UNK+": "코소보 공화국",
      "URY": "우루과이",
      "URY+": "우루과이 동방 공화국",
      "USA": "미국",
      "USA+": "아메리카 합중국",
      "UZB": "우즈베키스탄",
      "UZB+": "우즈베키스탄 공화국",
      "VAT": "바티칸",
      "VAT+": "바티칸 시국",
      "VCT": "세인트빈센트 그레나딘",
      "VCT+": "세인트빈센트 그레나딘",
      "VEN": "베네수엘라",
      "VEN+": "베네수엘라 볼리바르 공화국",
      "VGB": "영국령 버진아일랜드",
      "VGB+": "영국령 버진아일랜드",
      "VIR": "미국령 버진아일랜드",
      "VIR+": "미국령 버진아일랜드",
      "VNM": "베트남",
      "VNM+": "베트남 사회주의 공화국",
      "VUT": "바누아투",
      "VUT+": "바누아투 공화국",
      "WLF": "왈리스 푸투나",
      "WLF+": "왈리스 푸투나 제도",
      "WSM": "사모아",
      "WSM+": "사모아 독립국",
      "YEM": "예멘",
      "YEM+": "예멘 공화국",
      "ZAF": "남아프리카",
      "ZAF+": "남아프리카 공화국",
      "ZMB": "잠비아",
      "ZMB+": "잠비아 공화국",
      "ZWE": "짐바브웨",
      "ZWE+": "짐바브웨 공화국",
    });
  }
}
