import "../iso_locale_mapper.dart";

/// Contains 250 translation(s).
/// Provides translations for the Italian language
/// locale.
class ItCountriesL10N extends IsoLocaleMapper<String> {
  /// Provides country translations for the `it` locale.
  ItCountriesL10N() {
    map.addAll({
      "ABW": "Aruba",
      "ABW+": "Aruba",
      "AFG": "Afghanistan",
      "AFG+": "Repubblica islamica dell'Afghanistan",
      "AGO": "Angola",
      "AGO+": "Repubblica dell'Angola",
      "AIA": "Anguilla",
      "AIA+": "Anguilla",
      "ALA": "Isole Aland",
      "ALA+": "Isole Åland",
      "ALB": "Albania",
      "ALB+": "Repubblica d'Albania",
      "AND": "Andorra",
      "AND+": "Principato di Andorra",
      "ARE": "Emirati Arabi Uniti",
      "ARE+": "Emirati Arabi Uniti",
      "ARG": "Argentina",
      "ARG+": "Repubblica Argentina",
      "ARM": "Armenia",
      "ARM+": "Repubblica di Armenia",
      "ASM": "Samoa Americane",
      "ASM+": "Samoa americane",
      "ATA": "Antartide",
      "ATA+": "Antartide",
      "ATF": "Territori Francesi del Sud",
      "ATF+": "Territorio della australi e antartiche francesi Terre",
      "ATG": "Antigua e Barbuda",
      "ATG+": "Antigua e Barbuda",
      "AUS": "Australia",
      "AUS+": "Commonwealth dell'Australia",
      "AUT": "Austria",
      "AUT+": "Repubblica d'Austria",
      "AZE": "Azerbaijan",
      "AZE+": "Repubblica dell'Azerbaigian",
      "BDI": "Burundi",
      "BDI+": "Repubblica del Burundi",
      "BEL": "Belgio",
      "BEL+": "Regno del Belgio",
      "BEN": "Benin",
      "BEN+": "Repubblica del Benin",
      "BES": "Paesi Bassi caraibici",
      "BES+": "Bonaire, Sint Eustatius e Saba",
      "BFA": "Burkina Faso",
      "BFA+": "Burkina Faso",
      "BGD": "Bangladesh",
      "BGD+": "Repubblica popolare del Bangladesh",
      "BGR": "Bulgaria",
      "BGR+": "Repubblica di Bulgaria",
      "BHR": "Bahrein",
      "BHR+": "Regno del Bahrain",
      "BHS": "Bahamas",
      "BHS+": "Commonwealth delle Bahamas",
      "BIH": "Bosnia ed Erzegovina",
      "BIH+": "Bosnia-Erzegovina",
      "BLM": "Antille Francesi",
      "BLM+": "Collettività di Saint Barthélemy",
      "BLR": "Bielorussia",
      "BLR+": "Repubblica di Belarus",
      "BLZ": "Belize",
      "BLZ+": "Belize",
      "BMU": "Bermuda",
      "BMU+": "Bermuda",
      "BOL": "Bolivia",
      "BOL+": "Stato Plurinazionale della Bolivia",
      "BRA": "Brasile",
      "BRA+": "Repubblica federativa del Brasile",
      "BRB": "Barbados",
      "BRB+": "Barbados",
      "BRN": "Brunei",
      "BRN+": "Nazione di Brunei, Dimora della Pace",
      "BTN": "Bhutan",
      "BTN+": "Regno del Bhutan",
      "BVT": "Isola Bouvet",
      "BVT+": "Isola Bouvet",
      "BWA": "Botswana",
      "BWA+": "Repubblica del Botswana",
      "CAF": "Repubblica Centrafricana",
      "CAF+": "Repubblica Centrafricana",
      "CAN": "Canada",
      "CAN+": "Canada",
      "CCK": "Isole Cocos e Keeling",
      "CCK+": "Territorio della (Keeling) Isole Cocos",
      "CHE": "Svizzera",
      "CHE+": "Confederazione svizzera",
      "CHL": "Cile",
      "CHL+": "Repubblica del Cile",
      "CHN": "Cina",
      "CHN+": "Repubblica popolare cinese",
      "CIV": "Costa d'Avorio",
      "CIV+": "Repubblica della Costa d'Avorio",
      "CMR": "Camerun",
      "CMR+": "Repubblica del Camerun",
      "COD": "Congo (Rep. Dem.)",
      "COD+": "Repubblica Democratica del Congo",
      "COG": "Congo",
      "COG+": "Repubblica del Congo",
      "COK": "Isole Cook",
      "COK+": "Isole Cook",
      "COL": "Colombia",
      "COL+": "Repubblica di Colombia",
      "COM": "Comore",
      "COM+": "Unione delle Comore",
      "CPV": "Capo Verde",
      "CPV+": "Repubblica di Capo Verde",
      "CRI": "Costa Rica",
      "CRI+": "Repubblica di Costa Rica",
      "CUB": "Cuba",
      "CUB+": "Repubblica di Cuba",
      "CUW": "Curaçao",
      "CUW+": "Paese di Curaçao",
      "CXR": "Isola di Natale",
      "CXR+": "Territorio di Christmas Island",
      "CYM": "Isole Cayman",
      "CYM+": "Isole Cayman",
      "CYP": "Cipro",
      "CYP+": "Repubblica di Cipro",
      "CZE": "Cechia",
      "CZE+": "Repubblica Ceca",
      "DEU": "Germania",
      "DEU+": "Repubblica federale di Germania",
      "DJI": "Gibuti",
      "DJI+": "Repubblica di Gibuti",
      "DMA": "Dominica",
      "DMA+": "Commonwealth di Dominica",
      "DNK": "Danimarca",
      "DNK+": "Regno di Danimarca",
      "DOM": "Repubblica Dominicana",
      "DOM+": "Repubblica Dominicana",
      "DZA": "Algeria",
      "DZA+": "Repubblica popolare democratica di Algeria",
      "ECU": "Ecuador",
      "ECU+": "Repubblica dell'Ecuador",
      "EGY": "Egitto",
      "EGY+": "Repubblica araba d'Egitto",
      "ERI": "Eritrea",
      "ERI+": "Stato di Eritrea",
      "ESH": "Sahara Occidentale",
      "ESH+": "Repubblica Araba Saharawi Democratica",
      "ESP": "Spagna",
      "ESP+": "Regno di Spagna",
      "EST": "Estonia",
      "EST+": "Repubblica di Estonia",
      "ETH": "Etiopia",
      "ETH+": "Repubblica federale democratica di Etiopia",
      "FIN": "Finlandia",
      "FIN+": "Repubblica di Finlandia",
      "FJI": "Figi",
      "FJI+": "Repubblica di Figi",
      "FLK": "Isole Falkland o Isole Malvine",
      "FLK+": "Isole Falkland",
      "FRA": "Francia",
      "FRA+": "Repubblica francese",
      "FRO": "Isole Far Oer",
      "FRO+": "Isole Faroe",
      "FSM": "Micronesia",
      "FSM+": "Stati federati di Micronesia",
      "GAB": "Gabon",
      "GAB+": "Repubblica gabonese",
      "GBR": "Regno Unito",
      "GBR+": "Regno Unito di Gran Bretagna e Irlanda del Nord",
      "GEO": "Georgia",
      "GEO+": "Georgia",
      "GGY": "Guernsey",
      "GGY+": "Baliato di Guernsey",
      "GHA": "Ghana",
      "GHA+": "Repubblica del Ghana",
      "GIB": "Gibilterra",
      "GIB+": "Gibilterra",
      "GIN": "Guinea",
      "GIN+": "Repubblica di Guinea",
      "GLP": "Guadeloupa",
      "GLP+": "Guadeloupe",
      "GMB": "Gambia",
      "GMB+": "Repubblica del Gambia",
      "GNB": "Guinea-Bissau",
      "GNB+": "Repubblica di Guinea-Bissau",
      "GNQ": "Guinea Equatoriale",
      "GNQ+": "Repubblica della Guinea Equatoriale",
      "GRC": "Grecia",
      "GRC+": "Repubblica ellenica",
      "GRD": "Grenada",
      "GRD+": "Grenada",
      "GRL": "Groenlandia",
      "GRL+": "Groenlandia",
      "GTM": "Guatemala",
      "GTM+": "Repubblica del Guatemala",
      "GUF": "Guyana francese",
      "GUF+": "Guiana",
      "GUM": "Guam",
      "GUM+": "Guam",
      "GUY": "Guyana",
      "GUY+": "Co -operative Republic of Guyana",
      "HKG": "Hong Kong",
      "HKG+":
          """Hong Kong Regione amministrativa speciale della Repubblica Popolare Cinese""",
      "HMD": "Isole Heard e McDonald",
      "HMD+": "Isole Heard e McDonald",
      "HND": "Honduras",
      "HND+": "Repubblica di Honduras",
      "HRV": "Croazia",
      "HRV+": "Repubblica di Croazia",
      "HTI": "Haiti",
      "HTI+": "Repubblica di Haiti",
      "HUN": "Ungheria",
      "HUN+": "Ungheria",
      "IDN": "Indonesia",
      "IDN+": "Repubblica di Indonesia",
      "IMN": "Isola di Man",
      "IMN+": "Isola di Man",
      "IND": "India",
      "IND+": "Repubblica dell'India",
      "IOT": "Territorio britannico dell'oceano indiano",
      "IOT+": "Territorio britannico dell'Oceano Indiano",
      "IRL": "Irlanda",
      "IRL+": "Repubblica d'Irlanda",
      "IRN": "Iran",
      "IRN+": "Repubblica islamica dell'Iran",
      "IRQ": "Iraq",
      "IRQ+": "Repubblica dell'Iraq",
      "ISL": "Islanda",
      "ISL+": "Islanda",
      "ISR": "Israele",
      "ISR+": "Stato di Israele",
      "ITA": "Italia",
      "ITA+": "Repubblica italiana",
      "JAM": "Giamaica",
      "JAM+": "Giamaica",
      "JEY": "Isola di Jersey",
      "JEY+": "Baliato di Jersey",
      "JOR": "Giordania",
      "JOR+": "Regno hascemita di Giordania",
      "JPN": "Giappone",
      "JPN+": "Giappone",
      "KAZ": "Kazakistan",
      "KAZ+": "Repubblica del Kazakhstan",
      "KEN": "Kenya",
      "KEN+": "Repubblica del Kenya",
      "KGZ": "Kirghizistan",
      "KGZ+": "Kirghizistan",
      "KHM": "Cambogia",
      "KHM+": "Regno di Cambogia",
      "KIR": "Kiribati",
      "KIR+": "Repubblica indipendente e sovrano di Kiribati",
      "KNA": "Saint Kitts e Nevis",
      "KNA+": "Federazione di Saint Christopher e Nevis",
      "KOR": "Corea del Sud",
      "KOR+": "Repubblica di Corea",
      "KWT": "Kuwait",
      "KWT+": "Stato del Kuwait",
      "LAO": "Laos",
      "LAO+": "Repubblica democratica popolare del Laos",
      "LBN": "Libano",
      "LBN+": "Repubblica libanese",
      "LBR": "Liberia",
      "LBR+": "Repubblica di Liberia",
      "LBY": "Libia",
      "LBY+": "Stato della Libia",
      "LCA": "Santa Lucia",
      "LCA+": "Santa Lucia",
      "LIE": "Liechtenstein",
      "LIE+": "Principato del Liechtenstein",
      "LKA": "Sri Lanka",
      "LKA+": "Repubblica democratica socialista dello Sri Lanka",
      "LSO": "Lesotho",
      "LSO+": "Regno del Lesotho",
      "LTU": "Lituania",
      "LTU+": "Repubblica di Lituania",
      "LUX": "Lussemburgo",
      "LUX+": "Granducato di Lussemburgo",
      "LVA": "Lettonia",
      "LVA+": "Repubblica di Lettonia",
      "MAC": "Macao",
      "MAC+":
          """Macao Regione amministrativa speciale della Repubblica Popolare Cinese""",
      "MAF": "Saint Martin",
      "MAF+": "saint Martin",
      "MAR": "Marocco",
      "MAR+": "Regno del Marocco",
      "MCO": "Principato di Monaco",
      "MCO+": "Principato di Monaco",
      "MDA": "Moldavia",
      "MDA+": "Repubblica di Moldova",
      "MDG": "Madagascar",
      "MDG+": "Repubblica del Madagascar",
      "MDV": "Maldive",
      "MDV+": "Repubblica delle Maldive",
      "MEX": "Messico",
      "MEX+": "Stati Uniti del Messico",
      "MHL": "Isole Marshall",
      "MHL+": "Repubblica delle Isole Marshall",
      "MKD": "Macedonia del Nord",
      "MKD+": "Repubblica di Macedonia del Nord",
      "MLI": "Mali",
      "MLI+": "Repubblica del Mali",
      "MLT": "Malta",
      "MLT+": "Repubblica di Malta",
      "MMR": "Birmania",
      "MMR+": "Repubblica dell'Unione di Myanmar",
      "MNE": "Montenegro",
      "MNE+": "Montenegro",
      "MNG": "Mongolia",
      "MNG+": "Mongolia",
      "MNP": "Isole Marianne Settentrionali",
      "MNP+": "Commonwealth delle Isole Marianne Settentrionali",
      "MOZ": "Mozambico",
      "MOZ+": "Repubblica del Mozambico",
      "MRT": "Mauritania",
      "MRT+": "Repubblica islamica di Mauritania",
      "MSR": "Montserrat",
      "MSR+": "Montserrat",
      "MTQ": "Martinica",
      "MTQ+": "Martinique",
      "MUS": "Mauritius",
      "MUS+": "Repubblica di Mauritius",
      "MWI": "Malawi",
      "MWI+": "Repubblica del Malawi",
      "MYS": "Malesia",
      "MYS+": "Malaysia",
      "MYT": "Mayotte",
      "MYT+": "Dipartimento di Mayotte",
      "NAM": "Namibia",
      "NAM+": "Repubblica di Namibia",
      "NCL": "Nuova Caledonia",
      "NCL+": "Nuova Caledonia",
      "NER": "Niger",
      "NER+": "Repubblica del Niger",
      "NFK": "Isola Norfolk",
      "NFK+": "Territorio di Norfolk Island",
      "NGA": "Nigeria",
      "NGA+": "Repubblica federale di Nigeria",
      "NIC": "Nicaragua",
      "NIC+": "Repubblica del Nicaragua",
      "NIU": "Niue",
      "NIU+": "Niue",
      "NLD": "Paesi Bassi",
      "NLD+": "Paesi Bassi",
      "NOR": "Norvegia",
      "NOR+": "Regno di Norvegia",
      "NPL": "Nepal",
      "NPL+": "Repubblica federale democratica del Nepal",
      "NRU": "Nauru",
      "NRU+": "Repubblica di Nauru",
      "NZL": "Nuova Zelanda",
      "NZL+": "Nuova Zelanda",
      "OMN": "oman",
      "OMN+": "Sultanato dell'Oman",
      "PAK": "Pakistan",
      "PAK+": "Repubblica islamica del Pakistan",
      "PAN": "Panama",
      "PAN+": "Repubblica di Panama",
      "PCN": "Isole Pitcairn",
      "PCN+": "Pitcairn gruppo di isole",
      "PER": "Perù",
      "PER+": "Repubblica del Perù",
      "PHL": "Filippine",
      "PHL+": "Repubblica delle Filippine",
      "PLW": "Palau",
      "PLW+": "Repubblica di Palau",
      "PNG": "Papua Nuova Guinea",
      "PNG+": "Stato indipendente di Papua Nuova Guinea",
      "POL": "Polonia",
      "POL+": "Repubblica di Polonia",
      "PRI": "Porto Rico",
      "PRI+": "Commonwealth di Porto Rico",
      "PRK": "Corea del Nord",
      "PRK+": "Repubblica democratica popolare di Corea",
      "PRT": "Portogallo",
      "PRT+": "Repubblica portoghese",
      "PRY": "Paraguay",
      "PRY+": "Repubblica del Paraguay",
      "PSE": "Palestina",
      "PSE+": "Stato di Palestina",
      "PYF": "Polinesia Francese",
      "PYF+": "Polinesia Francese",
      "QAT": "Qatar",
      "QAT+": "Stato del Qatar",
      "REU": "Riunione",
      "REU+": "Réunion",
      "ROU": "Romania",
      "ROU+": "Romania",
      "RUS": "Russia",
      "RUS+": "Federazione russa",
      "RWA": "Ruanda",
      "RWA+": "Repubblica del Ruanda",
      "SAU": "Arabia Saudita",
      "SAU+": "Arabia Saudita",
      "SDN": "Sudan",
      "SDN+": "Repubblica del Sudan",
      "SEN": "Senegal",
      "SEN+": "Repubblica del Senegal",
      "SGP": "Singapore",
      "SGP+": "Repubblica di Singapore",
      "SGS": "Georgia del Sud e Isole Sandwich Meridionali",
      "SGS+": "Georgia del Sud e isole Sandwich del Sud",
      "SHN": "Sant'Elena, Ascensione e Tristan da Cunha",
      "SHN+": "Sant'Elena, Ascensione e Tristan da Cunha",
      "SJM": "Svalbard e Jan Mayen",
      "SJM+": "Svalbard og Jan Mayen",
      "SLB": "Isole Salomone",
      "SLB+": "Isole Salomone",
      "SLE": "Sierra Leone",
      "SLE+": "Repubblica della Sierra Leone",
      "SLV": "El Salvador",
      "SLV+": "Repubblica di El Salvador",
      "SMR": "San Marino",
      "SMR+": "Serenissima Repubblica di San Marino",
      "SOM": "Somalia",
      "SOM+": "Repubblica federale di Somalia",
      "SPM": "Saint-Pierre e Miquelon",
      "SPM+": "Saint Pierre e Miquelon",
      "SRB": "Serbia",
      "SRB+": "Repubblica di Serbia",
      "SSD": "Sudan del sud",
      "SSD+": "Repubblica del Sudan del Sud",
      "STP": "São Tomé e Príncipe",
      "STP+": "Repubblica democratica di São Tomé e Príncipe",
      "SUR": "Suriname",
      "SUR+": "Repubblica del Suriname",
      "SVK": "Slovacchia",
      "SVK+": "Repubblica slovacca",
      "SVN": "Slovenia",
      "SVN+": "Repubblica di Slovenia",
      "SWE": "Svezia",
      "SWE+": "Regno di Svezia",
      "SWZ": "Swaziland",
      "SWZ+": "Regno di eSwatini",
      "SXM": "Sint Maarten",
      "SXM+": "Sint Maarten",
      "SYC": "Seychelles",
      "SYC+": "Repubblica delle Seychelles",
      "SYR": "Siria",
      "SYR+": "Repubblica araba siriana",
      "TCA": "Isole Turks e Caicos",
      "TCA+": "Turks e Caicos",
      "TCD": "Ciad",
      "TCD+": "Repubblica del Ciad",
      "TGO": "Togo",
      "TGO+": "Repubblica del Togo",
      "THA": "Tailandia",
      "THA+": "Regno di Thailandia",
      "TJK": "Tagikistan",
      "TJK+": "Repubblica del Tajikistan",
      "TKL": "Isole Tokelau",
      "TKL+": "Tokelau",
      "TKM": "Turkmenistan",
      "TKM+": "Turkmenistan",
      "TLS": "Timor Est",
      "TLS+": "Repubblica Democratica di Timor Est",
      "TON": "Tonga",
      "TON+": "Regno di Tonga",
      "TTO": "Trinidad e Tobago",
      "TTO+": "Repubblica di Trinidad e Tobago",
      "TUN": "Tunisia",
      "TUN+": "Repubblica tunisina",
      "TUR": "Turchia",
      "TUR+": "Repubblica di Turchia",
      "TUV": "Tuvalu",
      "TUV+": "Tuvalu",
      "TWN": "Taiwan",
      "TWN+": "Repubblica cinese (Taiwan)",
      "TZA": "Tanzania",
      "TZA+": "Repubblica Unita di Tanzania",
      "UGA": "Uganda",
      "UGA+": "Repubblica di Uganda",
      "UKR": "Ucraina",
      "UKR+": "Ucraina",
      "UMI": "Isole minori esterne degli Stati Uniti d'America",
      "UMI+": "Stati Uniti Isole Minori",
      "UNK": "Kosovo",
      "UNK+": "Repubblica del Kosovo",
      "URY": "Uruguay",
      "URY+": "Repubblica Orientale dell'Uruguay",
      "USA": "Stati Uniti d'America",
      "USA+": "Stati Uniti d'America",
      "UZB": "Uzbekistan",
      "UZB+": "Repubblica di Uzbekistan",
      "VAT": "Città del Vaticano",
      "VAT+": "Città del Vaticano",
      "VCT": "Saint Vincent e Grenadine",
      "VCT+": "Saint Vincent e Grenadine",
      "VEN": "Venezuela",
      "VEN+": "Repubblica Bolivariana del Venezuela",
      "VGB": "Isole Vergini Britanniche",
      "VGB+": "Isole Vergini",
      "VIR": "Isole Vergini americane",
      "VIR+": "Isole Vergini degli Stati Uniti",
      "VNM": "Vietnam",
      "VNM+": "Repubblica socialista del Vietnam",
      "VUT": "Vanuatu",
      "VUT+": "Repubblica di Vanuatu",
      "WLF": "Wallis e Futuna",
      "WLF+": "Territorio delle Isole Wallis e Futuna",
      "WSM": "Samoa",
      "WSM+": "Stato indipendente di Samoa",
      "YEM": "Yemen",
      "YEM+": "Repubblica dello Yemen",
      "ZAF": "Sud Africa",
      "ZAF+": "Repubblica del Sud Africa",
      "ZMB": "Zambia",
      "ZMB+": "Repubblica di Zambia",
      "ZWE": "Zimbabwe",
      "ZWE+": "Repubblica dello Zimbabwe",
    });
  }
}
