extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")
@export var color := Globals.SwitchColor.BLUE

var fake := false
var invisible := false


func _ready() -> void:
	update_props()


func update_props() -> void:
	%Collision.disabled = fake


func _process(delta: float) -> void:
	%Sprite.play("on" if game.switch_color == color else "off")
	%Sprite.visible = not invisible


func _on_body_entered(body: Node2D) -> void:
	if game.switch_color != color:
		%PressSound.play()
	game.switch_color = color
