extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")
var only_play_once := false
var played := false


func _ready() -> void:
	%Sprite.visible = game.game_mode == game.GameMode.EDITING
	

func _process(delta: float) -> void:
	%Sprite.hide()


func _on_body_entered(body: Node2D) -> void:
	if only_play_once and played:
		# We can't queue free because that would stop the audio
		return
	played = true
	%SfxPlayer.play()
