extends Node

const default_server_base_url := "https://api.playmakergame.org"

var options := ConfigFile.new()
var full_screen := true
var show_timer := false
var master_volume := 1.00
var music_volume := 0.40
var sfx_volume := 0.50
var character := "green"
var joystick_mode := 1
var pause_visible := true
var levels_per_page := 10
var comments_per_page := 10
var server_base_url := default_server_base_url
var login_token = null

var got_first_level_extra_secret := false


func _ready() -> void:
	options.load("user://options.cfg")
	full_screen = options.get_value("options", "full_screen", full_screen)
	show_timer = options.get_value("options", "show_timer", show_timer)
	master_volume = options.get_value("options", "master_volume", master_volume)
	music_volume = options.get_value("options", "music_volume", music_volume)
	sfx_volume = options.get_value("options", "sfx_volume", sfx_volume)
	character = options.get_value("options", "character", character)
	joystick_mode = options.get_value("options", "joystick_mode", joystick_mode)
	pause_visible = options.get_value("options", "pause_visible", pause_visible)
	levels_per_page = options.get_value("options", "levels_per_page", levels_per_page)
	comments_per_page = options.get_value("options", "comments_per_page", comments_per_page)
	server_base_url = options.get_value("options", "server_base_url", server_base_url)
	login_token = options.get_value("options", "login_token", login_token)
	got_first_level_extra_secret = options.get_value("options", "got_first_level_extra_secret", got_first_level_extra_secret)
	
	# If we don't wait, it doesn't always exit fullscreen on start up
	await get_tree().process_frame
	update_options()


func save_options() -> void:
	options.set_value("options", "full_screen", full_screen)
	options.set_value("options", "show_timer", show_timer)
	options.set_value("options", "master_volume", master_volume)
	options.set_value("options", "music_volume", music_volume)
	options.set_value("options", "sfx_volume", sfx_volume)
	options.set_value("options", "character", character)
	options.set_value("options", "joystick_mode", joystick_mode)
	options.set_value("options", "pause_visible", pause_visible)
	options.set_value("options", "levels_per_page", max(levels_per_page, 1))
	options.set_value("options", "comments_per_page", max(comments_per_page, 1))
	options.set_value("options", "server_base_url", server_base_url)
	options.set_value("options", "login_token", login_token)
	options.set_value("options", "got_first_level_extra_secret", got_first_level_extra_secret)
	options.save("user://options.cfg")


func update_options() -> void:
	if full_screen:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_EXCLUSIVE_FULLSCREEN)
	else:
		DisplayServer.window_set_mode(DisplayServer.WINDOW_MODE_MAXIMIZED)
	
	AudioServer.set_bus_volume_linear(AudioServer.get_bus_index("Master"), master_volume)
	AudioServer.set_bus_volume_linear(AudioServer.get_bus_index("Music"), music_volume)
	AudioServer.set_bus_volume_linear(AudioServer.get_bus_index("SFX"), sfx_volume)
