extends Node

var show_old_version_warning := false
var next_is_info_menu_level := false
var return_to_uploaded_levels := false


enum SwitchColor {
	BLUE,
	RED,
	PURPLE
}


func _notification(what):
	if what == NOTIFICATION_WM_GO_BACK_REQUEST:
		var back_event = InputEventAction.new()
		back_event.action = "back"
		back_event.pressed = true
		Input.parse_input_event(back_event)
		for i in 2:
			await get_tree().process_frame
		back_event.pressed = false
		Input.parse_input_event(back_event)


func get_req_error(result: int, response_code: int, body: PackedByteArray, is_json: bool = true):
	if result == HTTPRequest.RESULT_CANT_CONNECT:
		return "Request failed while connecting"
	elif result == HTTPRequest.RESULT_CANT_RESOLVE:
		return "Request failed while resolving"
	elif result == HTTPRequest.RESULT_CONNECTION_ERROR:
		return "Request failed due to connection (read/write) error"
	elif result == HTTPRequest.RESULT_TLS_HANDSHAKE_ERROR:
		return "Request failed on TLS handshake"
	elif result == HTTPRequest.RESULT_TIMEOUT:
		return "Request failed due to a timeout"
	elif result != HTTPRequest.RESULT_SUCCESS:
		return "Request failed due to error code %d" % result
	elif response_code < 200 or response_code >= 300:
		var json = JSON.parse_string(body.get_string_from_utf8())
		if not json or not json.get("message"):
			return "Request failed due to response code %d" % response_code
		return json.get("message")
	
	if is_json:
		var json = JSON.parse_string(body.get_string_from_utf8())
		if not json:
			return "Unable to parse JSON"
	return null
