extends StaticBody2D

@onready var game = get_tree().get_first_node_in_group("game")
@export var color := Globals.SwitchColor.BLUE

func _ready() -> void:
	if game.game_mode == game.GameMode.PLAYING:
		update_status()


func _physics_process(delta: float) -> void:
	update_status()


func update_status() -> void:
	if game.switch_color == color:
		%Collision.disabled = false
		modulate = Color.WHITE
	else:
		%Collision.disabled = true
		modulate = Color.from_ok_hsl(0.0, 0.0, 1.0, 0.5)
