extends Control


@onready var game = get_tree().get_first_node_in_group("game")
var built_in_levels_scene: PackedScene = load("res://scenes/built_in_levels_menu.tscn")
var local_levels_scene: PackedScene = load("res://scenes/local_levels_menu.tscn")
var online_levels_scene: PackedScene = load("res://scenes/online_levels_menu.tscn")
var info_menu_scene: PackedScene = load("res://scenes/info_menu.tscn")


func _ready() -> void:
	get_tree().paused = true
	%RestartButton.grab_focus.call_deferred()
	%TimeSpent.text = "%.2fs" % (game.checkpoint_time + game.time_spent + game.added_time)
	if LevelManager.level_id == "precision_mountain":
		%Title.text = "AMAZING!"


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		if %MainMenu.visible:
			_on_leave_button_pressed()
		else:
			_on_restart_back_button_pressed()


func _on_restart_button_pressed() -> void:
	if game.checkpoint_pos:
		%MainMenu.hide()
		%RestartMenu.show()
		%RestartCheckpointButton.grab_focus.call_deferred()
	else:
		get_tree().paused = false
		game.restart()
		queue_free()



func _on_leave_button_pressed() -> void:
	game.save_level()
	get_tree().paused = false
	if LevelManager.level_source == LevelManager.LevelSource.BUILT_IN:
		if game.is_info_menu_level:
			get_tree().change_scene_to_packed(info_menu_scene)
		else:
			get_tree().change_scene_to_packed(built_in_levels_scene)
	elif LevelManager.level_source == LevelManager.LevelSource.LOCAL:
		get_tree().change_scene_to_packed(local_levels_scene)
	elif LevelManager.level_source == LevelManager.LevelSource.ONLINE:
		get_tree().change_scene_to_packed(online_levels_scene)


func _on_restart_checkpoint_button_pressed() -> void:
	get_tree().paused = false
	game.restart()
	queue_free()


func _on_restart_beginning_button_pressed() -> void:
	get_tree().paused = false
	game.remove_checkpoint()
	game.restart()
	queue_free()


func _on_restart_back_button_pressed() -> void:
	%MainMenu.show()
	%RestartMenu.hide()
	%RestartButton.grab_focus.call_deferred()
