extends Area2D


@onready var game = get_tree().get_first_node_in_group("game")

var fake := false
var invisible := false


func _ready() -> void:
	update_props()


func update_props() -> void:
	%Collision.disabled = fake


# In process so they can see it in the editor
func _process(delta: float) -> void:
	%Sprite.visible = not invisible


func _on_body_entered(body: Node2D) -> void:
	var amount := 2450.0
	if game.physics_mode == game.PhysicsMode.STRICT_V2:
		amount = 2600.0
		
	if int(round(rotation_degrees / 90)) % 4 == 0:
		body.velocity.y = -amount
	elif int(round(rotation_degrees / 90)) % 4 == 1:
		body.velocity.x = amount
	elif int(round(rotation_degrees / 90)) % 4 == 2:
		body.velocity.y = amount
	elif int(round(rotation_degrees / 90)) % 4 == 3:
		body.velocity.x = -amount
	%SoundPlayer.play()
	%Sprite.play("out")
	await get_tree().create_timer(1.0, false).timeout
	%Sprite.play("default")
