extends Control

var options_menu_scene: PackedScene = load("res://scenes/options_menu.tscn")


func _ready() -> void:
	%Username.grab_focus.call_deferred()


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_cancel_button_pressed()


func _on_cancel_button_pressed() -> void:
	get_tree().change_scene_to_packed(options_menu_scene)


func _on_sign_up_button_pressed() -> void:
	if %Password.text != %ConfirmPassword.text:
		%Status.text = "Passwords do not match"
		return
	
	%Username.editable = false
	%Password.editable = false
	%ConfirmPassword.editable = false
	%CancelButton.disabled = true
	%SignUpButton.disabled = true
	%Status.text = "Loading..."
	
	var json = JSON.stringify({
		"username": %Username.text,
		"password": %Password.text
	})
	
	var headers = ["Content-Type: application/json"]
	%SignUpReq.request("%s/register" % OptionsManager.server_base_url, headers, HTTPClient.METHOD_POST, json)


func _on_sign_up_req_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void:
	%Username.editable = true
	%Password.editable = true
	%ConfirmPassword.editable = true
	%CancelButton.disabled = false
	%SignUpButton.disabled = false
	var err = Globals.get_req_error(result, response_code, body)
	if err:
		%Status.text = err
		return
	
	var json = JSON.parse_string(body.get_string_from_utf8())
	OptionsManager.login_token = json.get("login_token")
	OptionsManager.save_options()
	get_tree().change_scene_to_packed(options_menu_scene)
