extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")


func _on_body_entered(body: Node2D) -> void:
	
	if "force_move_dir" in body:
		if body.force_move_dir != game.ForceMove.OFF:
			var rot_deg = fmod(round(rotation_degrees), 360.0)
			if (not %Sprite.flip_h and rot_deg == 0.0) or (%Sprite.flip_h and rot_deg == 180.0):
				body.force_move_dir = game.ForceMove.RIGHT
			elif (%Sprite.flip_h and rot_deg == 0.0) or (not %Sprite.flip_h and rot_deg == 180.0):
				body.force_move_dir = game.ForceMove.LEFT
