extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")
var damage := 1
var fake := false
var invisible := false


func _ready() -> void:
	update_props()
	if game.background == game.Background.RED_SKY\
	and LevelManager.level_id == "the_world_of_play_maker"\
	and game.game_mode == game.GameMode.PLAYING:
		if position.y > -58*256.0:
			queue_free()


func update_props() -> void:
	modulate = Color.from_hsv(0.0, clamp((damage - 1) * 0.75 / 4.0, 0.0, 0.75), 1.0)
	if damage == 0:
		modulate = Color.from_hsv(210.0 / 360.0, 0.5, 1.0)
	elif damage == -1:
		modulate = Color.from_hsv(0.0, 1.0, 0.6)
	%Collision.disabled = fake


# In process so they can see it in the editor
func _process(delta: float) -> void:
	%Sprite.visible = not invisible


func _physics_process(delta: float) -> void:
	for body in get_overlapping_bodies():
		if body.has_method("damage"):
			var dmg = damage
			if dmg == -1:
				dmg = 100_000_000
			body.damage(self, dmg)
