extends Control

var local_levels_scene: PackedScene = load("res://scenes/local_levels_menu.tscn")


func _ready() -> void:
	get_tree().paused = true
	%CancelButton.grab_focus.call_deferred()


func _on_cancel_button_pressed() -> void:
	get_tree().paused = false
	get_tree().change_scene_to_packed(local_levels_scene)


func _on_confirm_button_pressed() -> void:
	%Description.hide()
	%Status.text = "Loading..."
	%Status.show()
	%CancelButton.disabled = true
	%ConfirmButton.disabled = true
	
	var data_str := ConfigFile.new()
	data_str.set_value("level", "data", LevelManager.level_data)
	var json = JSON.stringify({
		"client_level_id": LevelManager.level_id,
		"title": LevelManager.level_data.get("title"),
		"data": data_str.encode_to_text()
	})
	
	var headers = ["Content-Type: application/json", "Authorization: Bearer %s" % OptionsManager.login_token]
	%PublishReq.request("%s/levels" % OptionsManager.server_base_url, headers, HTTPClient.METHOD_POST, json)



func _on_publish_req_request_completed(result: int, response_code: int, headers: PackedStringArray, body: PackedByteArray) -> void:
	var err = Globals.get_req_error(result, response_code, body)
	if err:
		%Status.text = err
		%CancelButton.disabled = false
		%ConfirmButton.text = "Retry"
		%ConfirmButton.disabled = false
		return
	
	%Status.text = "Level has been uploaded."
	%CancelButton.text = "Done"
	%CancelButton.disabled = false
	%ConfirmButton.hide()
