extends Control

var main_menu_scene: PackedScene = load("res://scenes/main_menu.tscn")
var sign_up_scene: PackedScene = load("res://scenes/sign_up_menu.tscn")
var login_scene: PackedScene = load("res://scenes/login_menu.tscn")
var account_scene: PackedScene = load("res://scenes/account_menu.tscn")
var info_scene: PackedScene = load("res://scenes/info_menu.tscn")
var change_scene := true


func _ready() -> void:
	%BackButton.grab_focus.call_deferred()
	%FullScreen.button_pressed = OptionsManager.full_screen
	%ShowTimer.button_pressed = OptionsManager.show_timer
	%MasterVolumeLabel.text = "Master Volume (%d%%)" % (OptionsManager.master_volume * 100.0)
	%MasterVolume.value = OptionsManager.master_volume * 100.0
	%MusicVolumeLabel.text = "Music Volume (%d%%)" % (OptionsManager.music_volume * 100.0)
	%MusicVolume.value = OptionsManager.music_volume * 100.0
	%SfxVolumeLabel.text = "Sound Effect Volume (%d%%)" % (OptionsManager.sfx_volume * 100.0)
	%SfxVolume.value = OptionsManager.sfx_volume * 100.0
	%ServerBaseUrl.text = OptionsManager.server_base_url
	%JoystickMode.select(OptionsManager.joystick_mode)
	%JoystickModeLabel.visible = DisplayServer.is_touchscreen_available()
	%JoystickMode.visible = DisplayServer.is_touchscreen_available()
	%PauseVisible.button_pressed = OptionsManager.pause_visible
	%PauseVisible.visible = DisplayServer.is_touchscreen_available()
	for i in %LevelsPerPage.item_count:
		if int(%LevelsPerPage.get_item_text(i)) == OptionsManager.levels_per_page:
			%LevelsPerPage.select(i)
	for i in %CommentsPerPage.item_count:
		if int(%CommentsPerPage.get_item_text(i)) == OptionsManager.comments_per_page:
			%CommentsPerPage.select(i)
	
	if OptionsManager.login_token:
		%SignedInAccountButtons.show()
		%SignedOutAccountButtons.hide()
		%ServerBaseUrlLabel.text = "Server Base URL (Log out to change)"
		%ServerBaseUrl.editable = false
		%ResetServerButton.disabled = true
	else:
		%SignedOutAccountButtons.show()
		%SignedInAccountButtons.hide()
	
	update_character_buttons()


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_back_button_pressed()


func _on_back_button_pressed() -> void:
	OptionsManager.full_screen = %FullScreen.button_pressed
	OptionsManager.show_timer = %ShowTimer.button_pressed
	OptionsManager.master_volume = %MasterVolume.value / 100.0
	OptionsManager.music_volume = %MusicVolume.value / 100.0
	OptionsManager.sfx_volume = %SfxVolume.value / 100.0
	OptionsManager.server_base_url = %ServerBaseUrl.text.strip_edges()
	OptionsManager.joystick_mode = %JoystickMode.selected
	OptionsManager.pause_visible = %PauseVisible.button_pressed
	OptionsManager.levels_per_page = max(int(%LevelsPerPage.get_item_text(%LevelsPerPage.selected)), 1)
	OptionsManager.comments_per_page = max(int(%CommentsPerPage.get_item_text(%CommentsPerPage.selected)), 1)
	OptionsManager.save_options()
	OptionsManager.update_options()
	
	if change_scene:
		get_tree().change_scene_to_packed(main_menu_scene)


func _on_master_volume_value_changed(value: float) -> void:
	%MasterVolumeLabel.text = "Master Volume (%d%%)" % (value)


func _on_music_volume_value_changed(value: float) -> void:
	%MusicVolumeLabel.text = "Music Volume (%d%%)" % (value)


func _on_sfx_volume_value_changed(value: float) -> void:
	%SfxVolumeLabel.text = "Sound Effect Volume (%d%%)" % (value)


func _notification(what):
	if what == NOTIFICATION_WM_CLOSE_REQUEST:
		change_scene = false
		_on_back_button_pressed()


func _on_sign_up_button_pressed() -> void:
	change_scene = false
	_on_back_button_pressed()
	get_tree().change_scene_to_packed(sign_up_scene)


func _on_login_button_pressed() -> void:
	change_scene = false
	_on_back_button_pressed()
	get_tree().change_scene_to_packed(login_scene)


func _on_account_button_pressed() -> void:
	change_scene = false
	_on_back_button_pressed()
	get_tree().change_scene_to_packed(account_scene)


func _on_reset_server_button_pressed() -> void:
	%ServerBaseUrl.text = OptionsManager.default_server_base_url


func update_character_buttons() -> void:
	%CharGreenButton.disabled = OptionsManager.character == "green"
	%CharPurpleButton.disabled = OptionsManager.character == "purple"
	%CharPinkButton.disabled = OptionsManager.character == "pink"
	%CharYellowButton.disabled = OptionsManager.character == "yellow"


func _on_char_green_button_pressed() -> void:
	OptionsManager.character = "green"
	update_character_buttons()


func _on_char_purple_button_pressed() -> void:
	OptionsManager.character = "purple"
	update_character_buttons()


func _on_char_pink_button_pressed() -> void:
	OptionsManager.character = "pink"
	update_character_buttons()


func _on_char_yellow_button_pressed() -> void:
	OptionsManager.character = "yellow"
	update_character_buttons()


func _on_info_button_pressed() -> void:
	change_scene = false
	_on_back_button_pressed()
	get_tree().change_scene_to_packed(info_scene)
