extends CharacterBody2D


@onready var game = get_tree().get_first_node_in_group("game")
const SPEED = 200.0
var dead := false
var first_physics_process := true
var ice_mult := 1.0


func _physics_process(delta: float) -> void:
	if dead:
		return
	
	if first_physics_process:
		first_physics_process = false
		velocity.x = SPEED * (1 if %Sprite.flip_h else -1)
	
	if not is_on_floor():
		velocity += get_gravity() * delta
	
	if velocity.y > game.get_max_y_velocity():
		#velocity.y = game.get_max_y_velocity()
		velocity.y *= pow(0.95, delta * 60)
		
	if is_on_wall() and %TurnTimer.is_stopped():
		%TurnTimer.start()
		%Sprite.flip_h = not %Sprite.flip_h
		velocity.x = SPEED * (1 if %Sprite.flip_h else -1)
	
	var accel = 4 * 60
	if ice_mult != 1.0:
		accel *= ice_mult
		ice_mult = 1.0
	
	velocity.x = move_toward(velocity.x, SPEED * (1 if %Sprite.flip_h else -1), accel * delta)
	
	move_and_slide()
	
	for body in %HurtArea.get_overlapping_bodies():
		var margin = 96.0
		if body.global_position.y + 128 - margin > %HurtCollision.global_position.y - (%HurtCollision.shape.size.y / 2):
			if body.has_method("damage"):
				body.damage(self)
		
		else:
			if body.has_method("bounce"):
				body.bounce(self)
			damage(body)


func damage(body = null, amount: int = 1) -> void:
	dead = true
	
	%Collision.set_deferred("disabled", true)
	%HurtCollision.set_deferred("disabled", true)
	%Sprite.stop()
	%Sprite.scale.y = 0.5
	%Sprite.position.y = 64.0
	%AnimationPlayer.play("die")
	%Sprite.reset_physics_interpolation()
	if body:
		%KillSound.play()

func _on_animation_player_animation_finished(anim_name: StringName) -> void:
	if anim_name == "die":
		queue_free()
