extends Control

static var shown_opening_animation = false

var built_in_levels_scene: PackedScene = load("res://scenes/built_in_levels_menu.tscn")
var local_levels_scene: PackedScene = load("res://scenes/local_levels_menu.tscn")
var options_scene: PackedScene = load("res://scenes/options_menu.tscn")


func _ready() -> void:
	if not shown_opening_animation:
		shown_opening_animation = true
		%AnimationPlayer.play("show")
	%PlayButton.grab_focus.call_deferred()
	%Title.text = "\n".join(ProjectSettings.get_setting("application/config/name").split(" "))
	%VersionLabel.text = "v%s" % ProjectSettings.get_setting("application/config/version")
	%OldVersionOverlay.visible = Globals.show_old_version_warning
	Globals.show_old_version_warning = false
	
	if %OldVersionOverlay.visible:
		%OldVerCloseButton.grab_focus.call_deferred()
	else:
		%PlayButton.grab_focus.call_deferred()


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_quit_button_pressed()


func _on_play_button_pressed() -> void:
	get_tree().change_scene_to_packed(built_in_levels_scene)


func _on_create_button_pressed() -> void:
	get_tree().change_scene_to_packed(local_levels_scene)


func _on_options_button_pressed() -> void:
	get_tree().change_scene_to_packed(options_scene)


func _on_quit_button_pressed() -> void:
	get_tree().quit()


func _on_old_ver_close_button_pressed() -> void:
	%OldVersionOverlay.hide()
	%PlayButton.grab_focus.call_deferred()
