extends Control

@onready var game = get_tree().get_first_node_in_group("game")


func _ready() -> void:
	get_tree().paused = true
	
	# Despite the removal code below using item indexes, having these above fixes a bug
	# where if you only have dirt and sky unlocked, and then select dirt
	# it would unselect any background when you reopened the menu
	# Make sure to remove everything BEFORE setting the values
	if not OptionsManager.got_first_level_extra_secret:
		%Background.remove_item(%Background.get_item_index(7)) # Blood Sky
	
	if not LevelManager.get_level_stats("cant_stop").get("completed", false):
		%ForceMoveLabel.hide()
		%ForceMove.hide()
	
	if not LevelManager.get_level_stats("sandy_plains").get("completed", false):
		%Background.remove_item(%Background.get_item_index(4)) # Desert
		%Background.remove_item(%Background.get_item_index(3)) # Sand
		%Music.remove_item(%Music.get_item_index(12)) # Desert Fox
	
	if not LevelManager.get_level_stats("rude_cave").get("completed", false) or LevelManager.get_level_stats("rude_cave").get("least_jumps", INF) > 0:
		%PhysicsMode.remove_item(%PhysicsMode.get_item_index(4)) # Slow Fall
		%PhysicsMode.remove_item(%PhysicsMode.get_item_index(5)) # Low Gravity
		%PhysicsMode.remove_item(%PhysicsMode.get_item_index(6)) # Flying
		%AirJumping.hide()
		%Background.remove_item(%Background.get_item_index(5)) # Stars
		%Background.remove_item(%Background.get_item_index(6)) # Nebula
		%Music.remove_item(%Music.get_item_index(13)) # Finally See The Light
	
	if not LevelManager.get_level_stats("precision_hill").get("completed", false):
		%PhysicsMode.remove_item(%PhysicsMode.get_item_index(3)) # Alt Strict
		%Background.remove_item(%Background.get_item_index(1)) # Night Sky 
	
	%LevelTitle.text = game.level_title
	%StartPosX.value = game.start_pos.x
	%StartPosY.value = -game.start_pos.y - 1
	%CameraOffsetX.value = game.camera_offset.x
	%CameraOffsetY.value = -game.camera_offset.y
	%MaxTime.value = game.max_time
	%ShowTimeLeft.button_pressed = game.show_time_left
	%Health.value = game.start_health
	%ShowHealth.button_pressed = game.show_health
	%MaxJumps.value = game.max_jumps
	%MinCoins.value = game.min_coins
	%ShowCoinCount.button_pressed = game.show_coin_count
	%PhysicsMode.select(%PhysicsMode.get_item_index(game.physics_mode))
	%AirJumping.button_pressed = game.air_jumping
	%SprintMode.select(%SprintMode.get_item_index(game.sprint_mode))
	%Background.select(%Background.get_item_index(game.background))
	%Music.select(%Music.get_item_index(max(game.music.keys().find(game.music_selected), 0)))
	%ProgressBar.select(%ProgressBar.get_item_index(game.progress_source))
	%ForceMove.select(%ForceMove.get_item_index(game.force_move))
	%DoneButton.grab_focus.call_deferred()
	%ScrollContainer.set_deferred("scroll_vertical", 0)


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_done_button_pressed()


func _on_done_button_pressed() -> void:
	get_tree().paused = false
	game.level_title = %LevelTitle.text
	game.start_pos = Vector2i(%StartPosX.value, -%StartPosY.value - 1)
	game.camera_offset = Vector2i(%CameraOffsetX.value, -%CameraOffsetY.value)
	game.max_time = %MaxTime.value
	game.show_time_left = %ShowTimeLeft.button_pressed
	game.start_health = %Health.value
	var health = %Health.value
	if health <= 0:
		health = 10_000_000
	game.health = health
	game.show_health = %ShowHealth.button_pressed
	game.max_jumps = %MaxJumps.value
	game.min_coins = %MinCoins.value
	game.show_coin_count = %ShowCoinCount.button_pressed
	game.physics_mode = %PhysicsMode.get_item_id(%PhysicsMode.selected)
	game.air_jumping = %AirJumping.button_pressed
	game.sprint_mode = %SprintMode.get_item_id(%SprintMode.selected)
	game.set_background(%Background.get_item_id(%Background.selected))
	game.music_selected = game.music.keys().get(%Music.get_item_id(%Music.selected))
	game.progress_source = %ProgressBar.get_item_id(%ProgressBar.selected)
	game.force_move = %ForceMove.get_item_id(%ForceMove.selected)
	if game.music_selected == "none":
		game.music_selected = null
	queue_free()
