extends PanelContainer

var comments_scene: PackedScene = load("res://scenes/comments_menu.tscn")

var bg_styles := {
	"red": load("res://misc/level_item_panels/red_level_item_panel.tres"),
	"orange": load("res://misc/level_item_panels/orange_level_item_panel.tres"),
	"yellow": load("res://misc/level_item_panels/yellow_level_item_panel.tres"),
	"green": load("res://misc/level_item_panels/green_level_item_panel.tres"),
	"purple": load("res://misc/level_item_panels/purple_level_item_panel.tres"),
	"rainbow": load("res://misc/level_item_panels/rainbow_level_item_panel.tres"),
	"nebula": load("res://misc/level_item_panels/nebula_level_item_panel.tres")
}

@export var title := "Untitled"
@export var author := "You"
@export var built_in_level_id := "" # Also for online
@export var show_edit := false
@export var show_author := false
@export var show_publish := false
@export var show_delete := false
@export var show_stats := true
@export var upload_time = null
var show_comments := false
var return_to_uploaded_levels := false
var supporter := false
var supporter_colors := false
var supporter_emphasis := false
var author_suffix = null
var rainbow_speed := 180.0
var rainbow_title := false
var rainbow_author := false
var rainbow_upload_date := false
var rainbow_best_time := false
var rainbow_play_button := false
var rainbow_play_text := false
var bg_style = null

var time := 0.0

func _ready() -> void:
	%Title.text = title
	%Author.visible = show_author
	%Author.text = "by %s" % author
	%EditButton.visible = show_edit
	%PublishButton.visible = show_publish
	%DeleteButton.visible = show_delete
	if show_stats:
		var level_stats := LevelManager.get_level_stats(built_in_level_id)
		if level_stats.completed:
			%CompleteCheck.show()
			%BestTime.text = "%.2fs" % level_stats.best_time
			%BestTime.show()
	
	if upload_time:
		var month_names = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
		var date = Time.get_date_dict_from_unix_time(upload_time)
		%UploadTime.text = "%s %d, %d" % [month_names[date.month - 1], date.day, date.year]
		%UploadTime.show()
	else:
		%UploadTime.hide()
	
	if supporter:
		%SupporterIcon1.show()
		%SupporterIcon2.show()
	
	if supporter_colors:
		%Title.add_theme_color_override("font_color", Color.from_hsv(270 / 360.0, 0.4, 0.9))
		%Author.add_theme_color_override("font_color", Color.from_hsv(60 / 360.0, 0.3, 0.9))
		%UploadTime.add_theme_color_override("font_color", Color.from_hsv(60 / 360.0, 0.3, 0.9))
		%BestTime.add_theme_color_override("font_color", Color.from_hsv(60 / 360.0, 0.2, 0.9))
	
	if supporter_emphasis:
		%Title.add_theme_color_override("font_shadow_color", Color.from_hsv(0.0, 0.0, 0.0))
		%Title.add_theme_color_override("font_outline_color", Color.from_hsv(0.0, 0.0, 0.0))
		%Author.add_theme_color_override("font_shadow_color", Color.from_hsv(0.0, 0.0, 0.0))
		%UploadTime.add_theme_color_override("font_shadow_color", Color.from_hsv(0.0, 0.0, 0.0))
		%BestTime.add_theme_color_override("font_shadow_color", Color.from_hsv(0.0, 0.0, 0.0))
	
	if author_suffix:
		%Author.text += " " + author_suffix

	if bg_styles.has(bg_style):
		add_theme_stylebox_override("panel", bg_styles.get(bg_style))
	
	if show_comments:
		%CommentsButton.show()


func _process(delta: float) -> void:
	time += delta
	if rainbow_title:
		%Title.add_theme_color_override("font_color", Color.from_hsv((time * rainbow_speed) / 360.0, 0.4, 0.9))
	if rainbow_author:
		%Author.add_theme_color_override("font_color", Color.from_hsv((time * rainbow_speed) / 360.0, 0.4, 0.9))
	if rainbow_upload_date:
		%UploadTime.add_theme_color_override("font_color", Color.from_hsv((time * rainbow_speed) / 360.0, 0.4, 0.9))
	if rainbow_best_time:
		%BestTime.add_theme_color_override("font_color", Color.from_hsv((time * rainbow_speed) / 360.0, 0.4, 0.9))
	if rainbow_play_button:
		%PlayButton.self_modulate = Color.from_hsv((time * rainbow_speed) / 360.0, 1.0, 1.0)
	if rainbow_play_text:
		%PlayButton.add_theme_color_override("font_color", Color.from_hsv((time * rainbow_speed) / 360.0, 0.4, 0.9))
	if bg_style == "rainbow":
		self_modulate = Color.from_hsv((time * rainbow_speed) / 360.0, 1.0, 1.0)


func _on_comments_button_pressed() -> void:
	LevelManager.level_id = built_in_level_id
	Globals.return_to_uploaded_levels = return_to_uploaded_levels
	get_tree().change_scene_to_packed(comments_scene)
