extends Control


var options_menu_scene: PackedScene = load("res://scenes/options_menu.tscn")
var game_scene: PackedScene = load("res://scenes/game.tscn")


func _ready() -> void:
	get_tree().paused = false
	%ColorOverlay.hide()
	%SourceButton.grab_focus.call_deferred()
	
	if not LevelManager.get_level_stats("switching").get("completed", false):
		%SecretLabel.text = "Tip: You can complete the \"Switching\" level to unlock switches and color blocks."
	elif not LevelManager.get_level_stats("the_world_of_play_maker").get("beat_secret_ending", false):
		%SecretLabel.text = "Tip: If you find the secret ending in the \"The World of Play Maker\" level, you unlock some decorations and a secret level."
	else:
		%SandyPlains.show()
		if not LevelManager.get_level_stats("sandy_plains").get("completed", false):
			%SecretLabel.text = "Tip: You can complete the secret \"Sandy Plains\" level to unlock the sand block and other sand related rewards, and another secret level."
		else:
			%CantStop.show()
			if not LevelManager.get_level_stats("cant_stop").get("completed", false):
				%SecretLabel.text = "Tip: You can complete the secret \"Can't Stop!\" level to unlock the \"Force Move\" level setting, and the direction sign."
			elif not LevelManager.get_level_stats("precision_hill").get("completed", false):
				%SecretLabel.text = "Tip: You can complete the \"Precision Hill\" level to unlock some new items, such as the ice block and night sky background."
			elif not LevelManager.get_level_stats("trial_of_the_saws").get("completed", false):
				%SecretLabel.text = "Tip: You can complete the \"Trial of the Saws\" level to unlock the gravestone."
			elif not LevelManager.get_level_stats("rude_cave").get("completed", false) or LevelManager.get_level_stats("rude_cave").get("least_jumps", INF) > 0:
				%SecretLabel.text = "Tip: You can complete the \"Rude Cave\" level without jumping to unlock multiple new physics modes, along with other additions and another secret level."
			else:
				%BlockyDescent.show()
				if not LevelManager.get_level_stats("blocky_descent").get("completed", false):
					%SecretLabel.text = "Tip: You can complete the secret \"Blocky Descent\" level to unlock screen effects, such as flipping and pixelation, and another secret level."
				else:
					%CheckpointRush.show()
					if not LevelManager.get_level_stats("checkpoint_rush").get("completed", false):
						%SecretLabel.text = "Tip: You can complete the secret \"Checkpoint Rush\" level to unlock the ability to create fake and invisible items, and the brick block."
					elif not LevelManager.get_level_stats("precision_mountain").get("completed", false):
						%SecretLabel.text = "Tip: You can complete the \"Precision Mountain\" level to be unlock a secret level."
					else:
						%UndergroundRace.show()
						if not LevelManager.get_level_stats("underground_race").get("completed", false):
							%SecretLabel.text = "Tip: You can complete the secret \"Underground Race\" level to be able to mark yourself as an expert, which makes your levels have an orange background in the online level list."

	%SandyPlains.get_node("%PlayButton").connect("pressed", _open_level.bind("sandy_plains"))
	%CantStop.get_node("%PlayButton").connect("pressed", _open_level.bind("cant_stop"))
	%BlockyDescent.get_node("%PlayButton").connect("pressed", _open_level.bind("blocky_descent"))
	%CheckpointRush.get_node("%PlayButton").connect("pressed", _open_level.bind("checkpoint_rush"))
	%UndergroundRace.get_node("%PlayButton").connect("pressed", _open_level.bind("underground_race"))


func _process(delta: float) -> void:
	if Input.is_action_just_pressed("back"):
		_on_back_button_pressed()


func _on_back_button_pressed() -> void:
	get_tree().change_scene_to_packed(options_menu_scene)


func _on_source_button_pressed() -> void:
	OS.shell_open(%SourceButton.text)


func _on_issues_button_pressed() -> void:
	OS.shell_open(%IssuesButton.text)


func _on_server_source_button_pressed() -> void:
	OS.shell_open(%ServerSourceButton.text)


func _on_donate_button_pressed() -> void:
	OS.shell_open(%DonateButton.text)


func _open_level(level_id: String) -> void:
	Globals.next_is_info_menu_level = true
	LevelManager.level_source = LevelManager.LevelSource.BUILT_IN
	LevelManager.level_id = level_id
	LevelManager.level_data = LevelManager.get_built_in_level_data(LevelManager.level_id)
	LevelManager.editing = false
	LevelManager.verifying = false
	DisplayServer.mouse_set_mode(DisplayServer.MOUSE_MODE_CAPTURED)
	%ColorOverlay.show()
	%AnimationPlayer.play("fade_exit")


func _on_animation_player_animation_finished(anim_name: StringName) -> void:
	if anim_name == "fade_exit":
		get_tree().change_scene_to_packed(game_scene)
