extends Area2D

@onready var game = get_tree().get_first_node_in_group("game")
var amount := 1


func _ready() -> void:
	update_props()


func update_props() -> void:
	%AmountLabel.visible = amount != 1
	%AmountLabel.text = str(amount)


func _on_body_entered(body: Node2D) -> void:
	%Collision.queue_free()
	%CollectAudio.play()
	%AnimationPlayer.play("collect")
	collect()


func collect() -> void:
	game.health += amount


func _on_animation_player_animation_finished(anim_name: StringName) -> void:
	if anim_name == "collect":
		queue_free()
